      *****************************************************************         
      **   CPD04391                                                  **         
      *****************************************************************         
      *****************************************************************         
      ** THIS COPYBOOK IS USED TO GET THE THERM PRICE AND AGL PASS   **         
      ** THROUGH CHARGE FOR THE NEW PRP AND BBP CUSTOMER AND         **         
      ** CALCULATES THE MONTHLY ESTIMATED CONSUMPTION CHARGE.        **         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **              --------------------------                     **         
      **    DATE    INITIALS   REASON                                **         
      **  --------  --------   ------                                **         
P00453**  10/05/10  SP95538  COPYBOOK ORIGINALLY WRITTEN             **         
P00453**  03/30/11  AA97148  PASS ZEROS TO WS-CONNECT-CHARGE FOR     **         
P00453**                     MARKET SWITCH ORDERS.                   **         
P00453**  03/31/11  SP95538  USE BTU FACTOR TO CONVERT CCF INTO      **         
P00453**                     THERMS                                  **         
P00453**  12/12/11  VP43661  USE THE COMMON DATE WHILE COMPUTING AGL **         
P00453**                     PASSTHRU CHARGES IN BATCH               **         
P00581**  02/06/12  VV94890  ADDED NEW DELINQUENCY VALUES FOR TURN ON**         
P00581**                     & METER SET ORDER TYPES - PRP ESTIMATE. **         
      *****************************************************************         
      *                                                                         
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
      **  FACTOR ID ACCOCIATED WITH THE GIVEN SPECIAL GROUP CODE.     **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE PASS-THRU-CHRG CURSOR FOR                         
                 SELECT  SF.FACTOR_ID,                                  
                         SF.FACTOR_TYPE,                                
                         SF.CHECK_ELEMENT,                              
                         SF.ADJUST_ELEMENT                              
                    FROM CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                 
                   WHERE SF.SPCL_GROUP_CD = 'AP'                        
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08551000
MFA-TR*       DECLARE PASS-THRU-CHRG CURSOR FOR                         08552000
MFA-TR*          SELECT  SF.FACTOR_ID,                                  08553000
MFA-TR*                  SF.FACTOR_TYPE,                                08554000
MFA-TR*                  SF.CHECK_ELEMENT,                              08555000
MFA-TR*                  SF.ADJUST_ELEMENT                              08555100
MFA-TR*             FROM CSS_SPCL_FCTR SF                               08556000
MFA-TR*            WHERE SF.SPCL_GROUP_CD = 'AP'                        08557000
MFA-TR*          FOR FETCH ONLY WITH UR                                 08558000
MFA-TR*            QUERYNO 7210                                                 
MFA-TR*    END-EXEC.                                                    08559000
      *                                                                         
      ****************************************************************  15140000
      * 6000-PRP-ESTIMATE.                                           *  15160000
      ****************************************************************  15170000
      *                                                                         
       6000-PRP-ESTIMATE.                                               
      *                                                                         
      *Get AGL pass through charge                                              
      *                                                                         
           MOVE '01'                        TO C8-COMPANY-NO.           
      *    Get default meter charge                                     15860000
           MOVE 'AGL-METER-CHARGE'          TO C8-DELINQ-CD.            
           PERFORM 7000-GET-DELINQ-VALUE        THRU 7000-EXIT.         
           MOVE C8-DELINQ-VALUE             TO WS-AGL-METER-CHARGE.     
      *                                                                 15864000
           MOVE 'PRP-ESTRATEINCR-GAS'       TO C8-DELINQ-CD.            
           PERFORM 7000-GET-DELINQ-VALUE        THRU 7000-EXIT.         
           COMPUTE  WS-GAS-RATE-INCR = (C8-DELINQ-VALUE * 0.01).        
      *    Get default dddc                                                     
           MOVE 'PRP-DEFAULT-DDDC'          TO C8-DELINQ-CD             
           PERFORM 7000-GET-DELINQ-VALUE        THRU 7000-EXIT          
           MOVE C8-DELINQ-VALUE             TO WS-DEFAULT-DDDC          
P00453*    Get BTU Factor                                                       
P00453     MOVE 'PRP-DEFAULT-BTU'           TO C8-DELINQ-CD             
P00453     PERFORM 7000-GET-DELINQ-VALUE        THRU 7000-EXIT          
P00453     MOVE C8-DELINQ-VALUE             TO WS-BTU-FACTOR.           
P00453*    Get connection charge                                                
P00453     IF WS-ORDER-TYPE = 'MKSW' OR SPACES OR LOW-VALUES            
P00453        MOVE ZEROS                    TO WS-CONNECT-CHARGE        
P00453     ELSE                                                         
P00581        IF WS-ORDER-TYPE = 'T-ON'                                 
P00581           MOVE 'DEREG-TURN-ON'         TO C8-DELINQ-CD           
P00581        ELSE                                                      
P00581           IF WS-ORDER-TYPE = 'SETM'                              
P00581              MOVE 'DEREG-METER-SET'    TO C8-DELINQ-CD           
P00581           ELSE                                                   
P00453              MOVE 'PRP-CONNECT-CHARGE' TO C8-DELINQ-CD           
P00581           END-IF                                                 
P00581        END-IF                                                    
P00453        PERFORM 7000-GET-DELINQ-VALUE THRU 7000-EXIT              
P00453        MOVE C8-DELINQ-VALUE          TO WS-CONNECT-CHARGE        
P00453     END-IF.                                                      
      *    Get Sculpted value                                                   
           EVALUATE WS-REV-MNTH                                         
                WHEN 01                                                 
                  MOVE 'PRP-SCULP-RATE-01'  TO C8-DELINQ-CD             
                WHEN 02                                                 
                  MOVE 'PRP-SCULP-RATE-02'  TO C8-DELINQ-CD             
                WHEN 03                                                 
                  MOVE 'PRP-SCULP-RATE-03'  TO C8-DELINQ-CD             
                WHEN 04                                                 
                  MOVE 'PRP-SCULP-RATE-04'  TO C8-DELINQ-CD             
                WHEN 05                                                 
                  MOVE 'PRP-SCULP-RATE-05'  TO C8-DELINQ-CD             
                WHEN 06                                                 
                  MOVE 'PRP-SCULP-RATE-06'  TO C8-DELINQ-CD             
                WHEN 07                                                 
                  MOVE 'PRP-SCULP-RATE-07'  TO C8-DELINQ-CD             
                WHEN 08                                                 
                  MOVE 'PRP-SCULP-RATE-08'  TO C8-DELINQ-CD             
                WHEN 09                                                 
                  MOVE 'PRP-SCULP-RATE-09'  TO C8-DELINQ-CD             
                WHEN 10                                                 
                  MOVE 'PRP-SCULP-RATE-10'  TO C8-DELINQ-CD             
                WHEN 11                                                 
                  MOVE 'PRP-SCULP-RATE-11'  TO C8-DELINQ-CD             
                WHEN 12                                                 
                  MOVE 'PRP-SCULP-RATE-12'  TO C8-DELINQ-CD             
                WHEN OTHER                                              
                  MOVE SPACES               TO C8-DELINQ-CD             
           END-EVALUATE                                                 
           PERFORM 7000-GET-DELINQ-VALUE        THRU 7000-EXIT          
           MOVE C8-DELINQ-VALUE             TO WS-SCULPT-RATE           
           IF WS-DDDC > 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-DEFAULT-DDDC          TO WS-DDDC                  
           END-IF                                                       
           PERFORM 7100-LOAD-REV-DIST-FROM-ZIP  THRU 7100-EXIT          
      *                                                                         
      *Compute pass thru charges                                        15930000
      *                                                                         
           INITIALIZE    WS-MNTH-PTC                                    
                         WS-MNTH-PTC-DDDC                               
                         WS-NEW-CHARGE                                  
                         WS-AGL-PASS-CHARGE                             
                         WS-ESTMT-AMOUNT.                               
                                                                        
           PERFORM 5000-COMPUTE-PTC             THRU 5000-EXIT.         
      *                                                                         
           IF WS-HOLD-ADJ-ELEMENT = 'A'                                 
               COMPUTE WS-MNTH-PTC-DDDC = WS-MNTH-PTC-DDDC +            
                                      WS-ANNUAL-DDAY-FACTOR             
           ELSE                                                         
              IF (SF-FACTOR-TYPE NOT EQUAL 'V' OR                       
                  SF-FACTOR-TYPE NOT EQUAL 'F')                         
                  AND WS-HOLD-ADJ-ELEMENT = 'H'                         
                  COMPUTE WS-MNTH-PTC-DDDC = WS-MNTH-PTC-DDDC -         
                                      WS-ANNUAL-DDAY-FACTOR             
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-CNSMPTN-NO-DAYS = 0                                    
              MOVE ZERO            TO WS-ESTMT-CONSUMPT                 
           ELSE                                                         
              IF WS-CNSMPTN-NO-DAYS >=25 AND WS-CNSMPTN-NO-DAYS <=35    
                 CONTINUE                                               
              ELSE                                                      
                 IF WS-CNSMPTN-NO-DAYS < 25 OR                          
                    WS-CNSMPTN-NO-DAYS > 35                             
                    MOVE WS-ESTMT-CONSUMPT TO WS-CNSMPTN-PRORATE        
                    COMPUTE WS-ESTMT-CONSUMPT ROUNDED =                 
                        (WS-CNSMPTN-PRORATE / WS-CNSMPTN-NO-DAYS) * 30  
      *             COMPUTE WS-ESTMT-CONSUMPT ROUNDED =                         
      *                     WS-CNSMPTN-PRORATE                                  
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
      *                                                                         
           IF WS-ESTMT-CONSUMPT > 0                                     
              MOVE 'P'                     TO WS-EST-METHOD-CD          
P00453        COMPUTE WS-UNITS ROUNDED =                                
P00453             WS-BTU-FACTOR * WS-ESTMT-CONSUMPT                    
P00453        MOVE WS-UNITS                TO WS-ESTMT-CONSUMPT         
           ELSE                                                         
      *       Get default therms                                                
              MOVE 'S'                     TO WS-EST-METHOD-CD          
              MOVE 'PRP-DEFAULT-THERMS'    TO C8-DELINQ-CD              
              PERFORM 7000-GET-DELINQ-VALUE     THRU 7000-EXIT          
              MOVE C8-DELINQ-VALUE         TO WS-DEFAULT-THERMS         
              COMPUTE WS-UNITS =                                        
                (WS-DEFAULT-THERMS * WS-DDDC)/WS-DEFAULT-DDDC           
              COMPUTE WS-UNITS ROUNDED =                                
                  (WS-UNITS * WS-SCULPT-RATE)/100                       
              MOVE WS-UNITS                TO WS-ESTMT-CONSUMPT         
           END-IF.                                                      
      *                                                                         
           COMPUTE WS-NEW-CHARGE ROUNDED =                              
                                 WS-ESTMT-CONSUMPT * WS-RATE-PRICE.     
           COMPUTE WS-BUFFER-AMT = WS-NEW-CHARGE * WS-GAS-RATE-INCR.    
           COMPUTE WS-AGL-PASS-CHARGE = WS-MNTH-PTC + WS-MNTH-PTC-DDDC. 
      *                                                                         
           COMPUTE WS-ESTMT-AMOUNT = WS-NEW-CHARGE       +              
                                     WS-BUFFER-AMT       +              
                                     WS-AGL-PASS-CHARGE  +              
                                     WS-CSC-AMT          +              
                                     WS-AGL-METER-CHARGE +              
                                     WS-CONNECT-CHARGE.                 
      *                                                                         
       6000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13870000
      ******************************************************************13880000
      * 5000-COMPUTE-PTC   (COMPUTES PASS THRU CHARGES)                *13890000
      ******************************************************************13900000
      *                                                                         
       5000-COMPUTE-PTC.                                                
      *                                                                         
           PERFORM 7200-OPEN-PASS-THRU-CHARGES THRU 7200-EXIT           
      *                                                                         
           MOVE SPACES TO WS-END-OF-PTC                                 
      *                                                                         
           PERFORM UNTIL WS-END-OF-PTC = 'Y'                            
              PERFORM 7210-FETCH-PASS-THRU-CHARGES  THRU 7210-EXIT      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 EVALUATE SF-CHECK-ELEMENT                              
                   WHEN 'Q'                                             
                   WHEN 'R'                                             
                     EVALUATE SF-FACTOR-ID                              
                       WHEN 'AGL EDUC'                                  
                         CONTINUE                                       
                       WHEN 'AGLSR CUS'                                 
                       WHEN 'AGLSR SOC'                                 
                         IF PROGRAM-NAME = 'CSR04391'                   
                            CONTINUE                                    
                         ELSE                                           
                            PERFORM 7375-CHK-SENIOR-FL THRU 7375-EXIT   
                            IF WS-SENIOR-FL = 'Y'                       
                               PERFORM 5100-ADD-PTC    THRU 5100-EXIT   
                            END-IF                                      
                         END-IF                                         
                       WHEN OTHER                                       
                         PERFORM 5100-ADD-PTC          THRU 5100-EXIT   
                     END-EVALUATE                                       
                   WHEN 'O'                                             
                     EVALUATE SF-FACTOR-ID                              
                       WHEN 'AGL EDUC'                                  
                          CONTINUE                                      
                       WHEN 'AGL DDAY'                                  
                          MOVE SF-ADJUST-ELEMENT                        
                                            TO WS-HOLD-ADJ-ELEMENT      
                          MOVE SF-FACTOR-ID TO SA-FACTOR-ID             
                          MOVE 'G'          TO SA-CODE-UTIL-TYPE        
                          MOVE WS-CORE-RATE-PLAN-NO                     
                                            TO SA-RATE-PLAN-NO          
                          IF WS-TRANS-IND = 'BBP'                       
                             PERFORM 7250-SUM-DDAY-FACTOR THRU 7250-EXIT
                          ELSE                                          
P00453                       IF BATCH-CALL                              
P00453                          MOVE WS-COMMON-DATE   TO SA-DATE-FROM   
P00453                                                   SA-DATE-TO     
P00453                       ELSE                                       
P00453                          PERFORM 7270-GET-CURRENT-DT             
P00453                                                    THRU 7270-EXIT
P00453                          MOVE WS-CURRENT-DATE  TO SA-DATE-FROM   
P00453                                                   SA-DATE-TO     
P00453                       END-IF                                     
                             PERFORM 7280-GET-DDAY-FACTOR THRU 7280-EXIT
                          END-IF                                        
                          COMPUTE WS-ANNUAL-DDAY-FACTOR =               
                           WS-ANNUAL-DDAY-FACTOR * WS-DDDC              
                       WHEN 'AGL LNG'                                   
                          PERFORM 7150-GLO-LOC-OFFICE-EXEMPT THRU       
                                     7150-EXIT                          
                          IF B1-LOCAL-OFFICE-DESC(1:5) = 'MACON' OR     
                                                         'ATLAN' OR     
                                                         'VALDO'        
                             PERFORM 5150-ADD-PTC-DDDC THRU 5150-EXIT   
                          END-IF                                        
                       WHEN OTHER                                       
                          PERFORM 5150-ADD-PTC-DDDC THRU 5150-EXIT      
                     END-EVALUATE                                       
                  WHEN OTHER                                            
                     PERFORM 5100-ADD-PTC THRU 5100-EXIT                
                 END-EVALUATE                                           
              END-IF                                                    
           END-PERFORM                                                  
           PERFORM 7220-CLOSE-PASS-THRU-CHARGES THRU 7220-EXIT.         
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************13880000
      * 5100-ADD-PTC                                               *    13890000
      ******************************************************************13900000
      *                                                                         
       5100-ADD-PTC.                                                    
      *                                                                         
           MOVE SF-FACTOR-ID                TO SA-FACTOR-ID             
           MOVE 'G'                         TO SA-CODE-UTIL-TYPE        
           MOVE WS-CORE-RATE-PLAN-NO        TO SA-RATE-PLAN-NO          
           PERFORM 7300-SELECT-FACTOR           THRU 7300-EXIT          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             IF SF-ADJUST-ELEMENT = 'A'                                 
                ADD SA-FACTOR               TO WS-MNTH-PTC              
             ELSE                                                       
                IF (SF-FACTOR-TYPE = 'V' OR SF-FACTOR-TYPE = 'F')       
                    AND SF-ADJUST-ELEMENT = 'H'                         
                      SUBTRACT SA-FACTOR FROM WS-MNTH-PTC               
                ELSE                                                    
                   IF SF-ADJUST-ELEMENT = 'H'                           
                      SUBTRACT SA-FACTOR FROM WS-MNTH-PTC               
                   END-IF                                               
                END-IF                                                  
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************13880000
      * 5150-ADD-PTC-DDDC                                              *13890000
      ******************************************************************13900000
      *                                                                         
       5150-ADD-PTC-DDDC.                                               
      *                                                                         
           MOVE SF-FACTOR-ID                TO SA-FACTOR-ID             
           MOVE 'G'                         TO SA-CODE-UTIL-TYPE        
           MOVE WS-CORE-RATE-PLAN-NO        TO SA-RATE-PLAN-NO          
           PERFORM 7300-SELECT-FACTOR           THRU 7300-EXIT          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF SF-ADJUST-ELEMENT = 'A'                                
                 COMPUTE WS-MNTH-PTC-DDDC =                             
                         WS-MNTH-PTC-DDDC +                             
                           (SA-FACTOR * WS-DDDC)                        
              ELSE                                                      
                 IF (SF-FACTOR-TYPE NOT EQUAL 'V' OR                    
                     SF-FACTOR-TYPE NOT EQUAL 'F')                      
                      AND SF-ADJUST-ELEMENT = 'H'                       
                     COMPUTE WS-MNTH-PTC-DDDC =                         
                             WS-MNTH-PTC-DDDC - (SA-FACTOR * WS-DDDC)   
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                 14970000
       5150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14970000
      ******************************************************************13790000
      * 5200-COMPUTE-TAX-EST                                           *13800000
      ******************************************************************13810000
      *                                                                 14970000
       5200-COMPUTE-TAX-EST.                                            
      *                                                                 14970000
           MOVE ZT-REV-DISTRICT-CD          TO TR-DETAIL-ID             
           PERFORM 7350-SELECT-TAX-RATE-EST     THRU 7350-EXIT.         
      *                                                                 14970000
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14970000
      ****************************************************************  15140000
      * 6100-BBP-ESTIMATE.                                           *  15160000
      ****************************************************************  15170000
      *                                                                         
       6100-BBP-ESTIMATE.                                               
      *                                                                         
      *Get AGL pass through charge                                              
      *                                                                         
           MOVE '01'                        TO C8-COMPANY-NO.           
      *    Get default meter charge                                     15860000
           MOVE 'AGL-METER-CHARGE'          TO C8-DELINQ-CD.            
           PERFORM 7000-GET-DELINQ-VALUE        THRU 7000-EXIT.         
           MOVE C8-DELINQ-VALUE             TO WS-AGL-METER-CHARGE.     
                                                                        
      *    Get default dddc                                                     
           MOVE 'EPP-DEFAULT-DDDC'          TO C8-DELINQ-CD             
           PERFORM 7000-GET-DELINQ-VALUE        THRU 7000-EXIT          
           MOVE C8-DELINQ-VALUE             TO WS-DEFAULT-DDDC          
           IF WS-DDDC > 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-DEFAULT-DDDC          TO WS-DDDC                  
           END-IF                                                       
           PERFORM 7100-LOAD-REV-DIST-FROM-ZIP  THRU 7100-EXIT          
      *                                                                         
      *Compute pass thru charges                                        15930000
      *                                                                         
           PERFORM 5000-COMPUTE-PTC             THRU 5000-EXIT.         
           COMPUTE WS-MNTH-PTC      = WS-MNTH-PTC * 12                  
           COMPUTE WS-MNTH-PTC-DDDC = WS-MNTH-PTC-DDDC * 12             
           IF WS-HOLD-ADJ-ELEMENT = 'A'                                 
               COMPUTE WS-MNTH-PTC-DDDC = WS-MNTH-PTC-DDDC +            
                                      WS-ANNUAL-DDAY-FACTOR             
           ELSE                                                         
              IF (SF-FACTOR-TYPE NOT EQUAL 'V' OR                       
                  SF-FACTOR-TYPE NOT EQUAL 'F')                         
                  AND WS-HOLD-ADJ-ELEMENT = 'H'                         
                  COMPUTE WS-MNTH-PTC-DDDC = WS-MNTH-PTC-DDDC -         
                                      WS-ANNUAL-DDAY-FACTOR             
              END-IF                                                    
           END-IF.                                                      
      *    Get default therms                                                   
           MOVE 'EPP-DEFAULT-THERMS'        TO C8-DELINQ-CD             
           PERFORM 7000-GET-DELINQ-VALUE        THRU 7000-EXIT          
           MOVE C8-DELINQ-VALUE             TO WS-DEFAULT-THERMS        
           COMPUTE WS-UNITS =                                           
                (WS-DEFAULT-THERMS * WS-DDDC)/WS-DEFAULT-DDDC           
           MOVE WS-UNITS                    TO WS-ESTMT-CONSUMPT        
           PERFORM 5200-COMPUTE-TAX-EST         THRU   5200-EXIT        
           COMPUTE WS-NEW-CHARGE = WS-ESTMT-CONSUMPT * WS-RATE-PRICE    
           COMPUTE WS-NEW-CHARGE = WS-NEW-CHARGE +                      
                                   WS-MNTH-PTC + WS-MNTH-PTC-DDDC +     
                                   (WS-AGL-METER-CHARGE * 12)           
                                                                        
           COMPUTE WS-NEW-CHARGE = WS-NEW-CHARGE +                      
                           (WS-NEW-CHARGE * TR-TAX-RATE)                
           COMPUTE WS-NEW-CHARGE = WS-NEW-CHARGE + (WS-CSC-AMT * 12)    
           DIVIDE WS-NEW-CHARGE BY 12 GIVING WS-INTEGER REMAINDER       
                                                  WS-REMAINDER          
           IF WS-REMAINDER GREATER THAN ZERO                            
               ADD +1 TO WS-INTEGER                                     
           END-IF                                                       
           MOVE WS-INTEGER                  TO WS-NEW-CHARGE            
      *                                                                         
           COMPUTE WS-AGL-PASS-CHARGE = WS-MNTH-PTC + WS-MNTH-PTC-DDDC  
                                   + (WS-AGL-METER-CHARGE * 12).        
           DIVIDE WS-AGL-PASS-CHARGE BY 12 GIVING WS-INTEGER REMAINDER  
                                                       WS-REMAINDER     
                                                                        
           IF WS-REMAINDER GREATER THAN ZERO                            
               ADD +1 TO WS-INTEGER                                     
           END-IF                                                       
           MOVE WS-INTEGER                  TO WS-AGL-PASS-CHARGE.      
      *                                                                 14970000
      *CHECK TO SEE IF ESTIMATE IS LESS THAN BPP LIMIT                  12370000
           MOVE 'EPP-ESTIMATE-LIMIT'           TO C8-DELINQ-CD.         
           PERFORM 7000-GET-DELINQ-VALUE       THRU 7000-EXIT.          
           MOVE C8-DELINQ-VALUE                TO WS-DEFAULT-BBP-LIMIT. 
           IF WS-DEFAULT-BBP-LIMIT > WS-NEW-CHARGE                      
               MOVE WS-DEFAULT-BBP-LIMIT       TO WS-NEW-CHARGE         
           END-IF.                                                      
      *                                                                 14970000
       6100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14970000
      ****************************************************************  35490000
      * 7000-GET-DELINQ-VALUE                                        *  35500000
      ****************************************************************  35510000
      *                                                                         
       7000-GET-DELINQ-VALUE.                                           
      *                                                                         
                                                                        
           EXEC SQL                                                     
               SELECT  C8.DELINQ_VALUE                                  
                 INTO :C8-DELINQ-VALUE                                  
                 FROM  CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                 
                 WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                    
                   AND C8.COMPANY_NO = :C8-COMPANY-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     35540000
MFA-TR*        SELECT  C8.DELINQ_VALUE                                  35550000
MFA-TR*          INTO :C8-DELINQ-VALUE                                  35560000
MFA-TR*          FROM  CSS_DELINQUENCY C8                               35570000
MFA-TR*          WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                    35580000
MFA-TR*            AND C8.COMPANY_NO = :C8-COMPANY-NO                   35590000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                    35600000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL  TO SUCCESSFUL-CALL          
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_DELINQUENCY'        TO TABLE-1                  
              MOVE 'DELINQ_CD '             TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE C8-DELINQ-CD             TO HOSTVAR-ELEMENT-1        
              MOVE C8-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 31130000
      *                                                               * 31140000
      * 7100-LOAD-REV-DIST-FROM-ZIP                                   * 31150000
      ***************************************************************** 31160000
      *                                                                         
       7100-LOAD-REV-DIST-FROM-ZIP.                                     
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) ZT.REV_DISTRICT_CD,
              ZT.LOCAL_OFFICE                                   
                 INTO :ZT-REV-DISTRICT-CD,                              
                      :ZT-LOCAL-OFFICE                                  
                 FROM CSS_ZIPCODE_LO_RT ZT WITH(READUNCOMMITTED)                
               WHERE ZT.ZIP_CODE = :WS-ZIP-CD                           
                 AND ZT.REV_DISTRICT_CD <>  '800'                       
                                                                 
                                                            
                                                    
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     31190000
MFA-TR*        SELECT ZT.REV_DISTRICT_CD,                               31200000
MFA-TR*               ZT.LOCAL_OFFICE                                   31210000
MFA-TR*          INTO :ZT-REV-DISTRICT-CD,                              31220000
MFA-TR*               :ZT-LOCAL-OFFICE                                  31230000
MFA-TR*          FROM CSS_ZIPCODE_LO_RT ZT                              31240000
MFA-TR*        WHERE ZT.ZIP_CODE = :WS-ZIP-CD                           31250000
MFA-TR*          AND ZT.REV_DISTRICT_CD <>  '800'                       31250000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*       FETCH FIRST ROW ONLY                                      31260000
MFA-TR*    END-EXEC                                                     31270000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE +200                  TO WS-ACTIVE-RETURN-CODE    
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '7100'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE 'CSS_ZIPCODE_LO_RT'   TO TABLE-1                  
                 MOVE 'ZIP_CODE'            TO TABLE-ELEMENT-1          
                 MOVE WS-ZIP-CD             TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '7100'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE 'CSS_ZIPCODE_LO_RT'   TO TABLE-1                  
                 MOVE 'ZIP_CODE'            TO TABLE-ELEMENT-1          
                 MOVE WS-ZIP-CD             TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************47020000
      *                                                                *47030000
      * 7150-GLO-LOC-OFFICE-EXEMPT                                     *47040000
      ******************************************************************47050000
      *                                                                         
       7150-GLO-LOC-OFFICE-EXEMPT.                                      
      *                                                                         
           MOVE ZT-LOCAL-OFFICE             TO B1-LOCAL-OFFICE.         
                                                                        
           EXEC SQL                                                     
              SELECT B1.LOCAL_OFFICE_DESC                               
                INTO :B1-LOCAL-OFFICE-DESC                              
                FROM CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                  
              WHERE  B1.COMPANY_NO      = :C8-COMPANY-NO                
                AND  B1.LOCAL_OFFICE    = :B1-LOCAL-OFFICE              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     47090000
MFA-TR*       SELECT B1.LOCAL_OFFICE_DESC                               47100000
MFA-TR*         INTO :B1-LOCAL-OFFICE-DESC                              47110000
MFA-TR*         FROM CSS_LOCAL_OFFICE B1                                47120000
MFA-TR*       WHERE  B1.COMPANY_NO      = :C8-COMPANY-NO                47130000
MFA-TR*         AND  B1.LOCAL_OFFICE    = :B1-LOCAL-OFFICE              47140000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7150                                                      
MFA-TR*    END-EXEC.                                                    47150000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7150'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_LOCAL_OFFICE'       TO TABLE-1                  
              MOVE 'LOCAL_OFFICE'           TO TABLE-ELEMENT-1          
              MOVE B1-LOCAL-OFFICE          TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************44640000
      * 7200-OPEN-PASS-THRU-CHARGES.                                   *44660000
      ******************************************************************44670000
      *                                                                         
        7200-OPEN-PASS-THRU-CHARGES.                                    
      *                                                                         
           EXEC SQL                                                     
              OPEN PASS-THRU-CHRG                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_SPCL_FCTR'          TO TABLE-1                  
              MOVE 'SPCL_GROUP_CD'          TO TABLE-ELEMENT-1          
              MOVE 'AP'                     TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 44880000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 44910000
      ******************************************************************44920000
      * 7210-FETCH-PASS-THRU-CHARGES                                   *44930000
      ******************************************************************44950000
      *                                                                 44910000
       7210-FETCH-PASS-THRU-CHARGES.                                    
      *                                                                 44910000
           EXEC SQL                                                     
              FETCH PASS-THRU-CHRG                                      
               INTO  :SF-FACTOR-ID,                                     
                     :SF-FACTOR-TYPE,                                   
                     :SF-CHECK-ELEMENT,                                 
                     :SF-ADJUST-ELEMENT                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'Y' TO WS-END-OF-PTC                              
                 MOVE +000                  TO S-RETURN-CODE            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7210'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'CSS_SPCL_FCTR'          TO TABLE-1                  
              MOVE 'SPCL_GROUP_CD'          TO TABLE-ELEMENT-1          
              MOVE 'AP'                     TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                 45210000
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 45240000
      ******************************************************************45250000
      * 7220-CLOSE-PASS-THRU-CHARGES                                   *45270000
      ******************************************************************45280000
      *                                                                 45240000
       7220-CLOSE-PASS-THRU-CHARGES.                                    
      *                                                                 45240000
           EXEC SQL                                                     
              CLOSE PASS-THRU-CHRG                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7220'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_SPCL_FCTR'          TO TABLE-1                  
              MOVE 'SPCL_GROUP_CD'          TO TABLE-ELEMENT-1          
              MOVE 'AP'                     TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************45910000
      * 7250-SUM-DDAY-FACTOR                                           *45930000
      ******************************************************************45940000
      *                                                                         
       7250-SUM-DDAY-FACTOR.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT SUM(SA.FACTOR)                                     
                INTO :WS-ANNUAL-DDAY-FACTOR :WS-NULL-IND-FCTR           
                FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)                
              WHERE  SA.CODE_UTIL_TYPE  = :SA-CODE-UTIL-TYPE            
              AND    SA.RATE_PLAN_NO    = :SA-RATE-PLAN-NO              
              AND    SA.FACTOR_ID       = :SA-FACTOR-ID                 
              AND SA.DATE_FROM         >=                               
                   SUBSTRING(CAST(CAST(SYSDATETIMEOFFSET() AS DATE)
            AS CHAR(10)), 1, 8) + '01'               
              AND    SA.DATE_TO        <=                               
                  (SUBSTRING(CAST(DATEADD( MONTH, 12, 
           CAST(SYSDATETIMEOFFSET() AS DATE) ) AS CHAR(10)), 1, 8) + 
           '01')  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     45960000
MFA-TR*       SELECT SUM(SA.FACTOR)                                     45970000
MFA-TR*         INTO :WS-ANNUAL-DDAY-FACTOR :WS-NULL-IND-FCTR           45980000
MFA-TR*         FROM CSS_SPCL_FCTR_APPL SA                              45990000
MFA-TR*       WHERE  SA.CODE_UTIL_TYPE  = :SA-CODE-UTIL-TYPE            46000000
MFA-TR*       AND    SA.RATE_PLAN_NO    = :SA-RATE-PLAN-NO              46010000
MFA-TR*       AND    SA.FACTOR_ID       = :SA-FACTOR-ID                 46020000
MFA-TR*       AND SA.DATE_FROM         >=                               46030000
MFA-TR*            SUBSTR(CHAR(CURRENT DATE),1,8) || '01'               46040000
MFA-TR*       AND    SA.DATE_TO        <=                               46050000
MFA-TR*           (SUBSTR(CHAR(CURRENT DATE + 12 MONTHS),1,8) || '01')  46060000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7250                                                      
MFA-TR*    END-EXEC.                                                    46070000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
               IF WS-NULL-IND-FCTR < 0                                  
                 MOVE ZEROS                 TO SA-FACTOR                
               END-IF                                                   
             END-IF                                                     
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7250'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                  
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-1          
              MOVE SA-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1        
              MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-2          
              MOVE SA-FACTOR-ID             TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00453******************************************************************45910000
P00453* 7270-GET-CURRENT-DT                                            *45930000
P00453******************************************************************45940000
P00453*                                                                         
P00453 7270-GET-CURRENT-DT.                                             
P00453*                                                                         
P00453     EXEC SQL                                                     
P00453       SELECT
              SUBSTRING(CAST(CAST(SYSDATETIMEOFFSET() AS DATE)
            AS CHAR(10)), 1, 8) + '01'
            INTO
              :WS-CURRENT-DATE 
P00453     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     45960000
MFA-TR*      SET :WS-CURRENT-DATE                                       45970000
MFA-TR*                        = SUBSTR(CHAR(CURRENT DATE),1,8) || '01' 45980000
MFA-TR*    END-EXEC.                                                    45990000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00453                                                                  
P00453     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P00453                                                                  
P00453     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00453        CONTINUE                                                  
P00453     ELSE                                                         
P00453        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P00453        MOVE '7260'                   TO ACTIVE-PARAGRAPH         
P00453        MOVE 'SET'                    TO ABEND-FUNCTION           
P00453        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
P00453        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
P00453     END-IF.                                                      
P00453*                                                                         
P00453 7270-EXIT.                                                       
P00453     EXIT.                                                        
P00453*                                                                         
      ******************************************************************45910000
      * 7280-GET-DDAY-FACTOR                                           *45930000
      ******************************************************************45940000
      *                                                                         
       7280-GET-DDAY-FACTOR.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) SA.FACTOR                                          
                INTO :WS-ANNUAL-DDAY-FACTOR :WS-NULL-IND-FCTR           
                FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)                
              WHERE  SA.CODE_UTIL_TYPE  = :SA-CODE-UTIL-TYPE            
              AND    SA.RATE_PLAN_NO    = :SA-RATE-PLAN-NO              
P00453        AND    SA.FACTOR_ID       = :SA-FACTOR-ID                 
P00453        AND    SA.DATE_FROM      <= IIF(TRY_CONVERT(DATE, 
                                                          :SA-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-FROM
              ) <> 0) OR (LEN(:SA-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :SA-DATE-FROM
              ), CONVERT(DATE, :SA-DATE-FROM) )                 
              AND    SA.DATE_TO        >= IIF(TRY_CONVERT(DATE, 
                                                            :SA-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-TO) <> 0) OR (LEN(
                                                            :SA-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:SA-DATE-TO), CONVERT(DATE, 
                                                            :SA-DATE-TO
              ) )                   
P00453        AND    SA.CODE_STATUS     = 'A'                           
P00453        ORDER BY SA.DATE_FROM ASC                                 
P00453                                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     45960000
MFA-TR*       SELECT SA.FACTOR                                          45970000
MFA-TR*         INTO :WS-ANNUAL-DDAY-FACTOR :WS-NULL-IND-FCTR           45980000
MFA-TR*         FROM CSS_SPCL_FCTR_APPL SA                              45990000
MFA-TR*       WHERE  SA.CODE_UTIL_TYPE  = :SA-CODE-UTIL-TYPE            46000000
MFA-TR*       AND    SA.RATE_PLAN_NO    = :SA-RATE-PLAN-NO              46010000
MFA-TR*       AND    SA.FACTOR_ID       = :SA-FACTOR-ID                 46020000
MFA-TR*       AND    SA.DATE_FROM      <= :SA-DATE-FROM                 46030000
MFA-TR*       AND    SA.DATE_TO        >= :SA-DATE-TO                   46050000
MFA-TR*       AND    SA.CODE_STATUS     = 'A'                           46050000
MFA-TR*       ORDER BY SA.DATE_FROM ASC                                 46050000
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                              46050000
MFA-TR*       QUERYNO 7280                                                      
MFA-TR*    END-EXEC.                                                    46070000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
               IF WS-NULL-IND-FCTR < 0                                  
                 MOVE ZEROS                 TO SA-FACTOR                
               END-IF                                                   
             END-IF                                                     
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7280'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                  
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-1          
              MOVE SA-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1        
              MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-2          
              MOVE SA-FACTOR-ID             TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7280-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************45552000
      * 7300-SELECT-FACTOR                                             *45570000
      ******************************************************************45580000
      *                                                                         
       7300-SELECT-FACTOR.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT SA.FACTOR                                          
                INTO :SA-FACTOR :WS-NULL-IND-FCTR                       
                FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)                
              WHERE  SA.CODE_UTIL_TYPE  = :SA-CODE-UTIL-TYPE            
              AND    SA.RATE_PLAN_NO    = :SA-RATE-PLAN-NO              
              AND    SA.FACTOR_ID       = :SA-FACTOR-ID                 
              AND    SA.CODE_STATUS     = 'A'                           
              AND    SA.DATE_FROM       < CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
              AND    SA.DATE_TO         > CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     45600000
MFA-TR*       SELECT SA.FACTOR                                          45610000
MFA-TR*         INTO :SA-FACTOR :WS-NULL-IND-FCTR                       45620000
MFA-TR*         FROM CSS_SPCL_FCTR_APPL SA                              45630000
MFA-TR*       WHERE  SA.CODE_UTIL_TYPE  = :SA-CODE-UTIL-TYPE            45640000
MFA-TR*       AND    SA.RATE_PLAN_NO    = :SA-RATE-PLAN-NO              45650000
MFA-TR*       AND    SA.FACTOR_ID       = :SA-FACTOR-ID                 45660000
MFA-TR*       AND    SA.CODE_STATUS     = 'A'                           45661000
MFA-TR*       AND    SA.DATE_FROM       < CURRENT DATE                  45670000
MFA-TR*       AND    SA.DATE_TO         > CURRENT DATE                  45680000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                    45690000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
               IF WS-NULL-IND-FCTR < 0                                  
                 MOVE ZEROS                 TO SA-FACTOR                
               END-IF                                                   
             END-IF                                                     
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                  
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-1          
              MOVE SA-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1        
              MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-2          
              MOVE SA-FACTOR-ID             TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************44280000
      * 7350-SELECT-TAX-RATE-EST                                       *44300000
      ******************************************************************44310000
      *                                                                         
       7350-SELECT-TAX-RATE-EST.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT TR.TAX_RATE                                        
                INTO :TR-TAX-RATE                                       
                FROM CSS_TAX_RATE TR                                    
              WHERE  TR.DETAIL_ID  = :TR-DETAIL-ID                      
              AND    TR.TAX_CNTRL_NO = 10                               
              AND    TR.OPER_MODE  = 'A'                                
              AND    TR.DATE_FROM <= CAST(SYSDATETIMEOFFSET() AS DATE)          
              AND    TR.DATE_TO   >= CAST(SYSDATETIMEOFFSET() AS DATE)          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     44330000
MFA-TR*       SELECT TR.TAX_RATE                                        44340000
MFA-TR*         INTO :TR-TAX-RATE                                       44350000
MFA-TR*         FROM CSS_TAX_RATE TR                                    44360000
MFA-TR*       WHERE  TR.DETAIL_ID  = :TR-DETAIL-ID                      44370000
MFA-TR*       AND    TR.TAX_CNTRL_NO = 10                               44380000
MFA-TR*       AND    TR.OPER_MODE  = 'A'                                44390000
MFA-TR*       AND    TR.DATE_FROM <= CURRENT DATE                       44400000
MFA-TR*       AND    TR.DATE_TO   >= CURRENT DATE                       44410000
MFA-TR*    END-EXEC.                                                    44420000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7350'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_TAX_RATE'           TO TABLE-1                  
              MOVE 'DETAIL_ID'              TO TABLE-ELEMENT-1          
              MOVE TR-DETAIL-ID             TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 44600000
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7375-CHK-SENIOR-FL.                                           *         
      *****************************************************************         
      *                                                                         
       7375-CHK-SENIOR-FL.                                              
      *                                                                         
           MOVE SPACES                      TO WS-SENIOR-FL.            
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-SENIOR-FL                                      
                FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                
                 AND ATTRIBUTE_DESC     = 'AGL DISCOUNT SR'             
                 AND ATTRIBUTE_VALUE_CD = 'YES'                         
                 AND STATUS_CD          = 'A'                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-SENIOR-FL                                              
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE                                         
MFA-TR*        WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                        
MFA-TR*          AND ATTRIBUTE_DESC     = 'AGL DISCOUNT SR'                     
MFA-TR*          AND ATTRIBUTE_VALUE_CD = 'YES'                                 
MFA-TR*          AND STATUS_CD          = 'A'                                   
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7350'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_ACCT_ATTRIBUTE'     TO TABLE-1                  
              MOVE 'AT-ACCOUNT-NO'          TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'ATTRIBUTE_DESC'         TO TABLE-ELEMENT-2          
              MOVE 'AGL DISCOUNT SR'        TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7375-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
