      ******************************************************************        
      **!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!**        
      ** CPD04353                                                     **        
      ** --------                                                     **        
      ** THIS COPY BOOK VALIDATES BBP BUSINESS RULES FOR ON ACCOUNT   **        
      **!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!**        
      ******************************************************************        
      **                    MODIFICATION  LOG                         **        
      ******************************************************************        
      **!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!**        
      **   DATE    INITIALS  REASON                                   **        
      ** ________  ________  ______                                   **        
P00220** 05/22/10  VP94820   INITIALLY CODED FOR BBP BPA'S.           **        
A02824** 09/30/10  GD97441   ADDED "BBP025" BBP BUSINESS RULE LOGIC.  **        
ACT004** 03/16/11  GD97441   APPL3118-ACT004:RETURN CHECK LOGIC CHANGE**        
A03710** 11/02/11  VV94890   ALLOW BBP SETUP ON PENDING ACCTS.        **        
P00836** 12/07/15  MS7M727   SET BBP-NOT-ELIGIBLE IS TRUE WHEN DNP    **        
P00836**                     IS ACTIVE AND WS-PARM-ELIGIBLE = 'W'     **        
A05460** 11/07/16  SM93554   SET BBP NOT TRUE FOR SCEG COMMERCIAL     **        
      **            ACT328   ACCOUNTS.                                **        
      **                                                              **        
      **!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!**        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      * 6000-VALIDATE-ACCT.                                            *        
      ******************************************************************        
      *                                                                         
       6000-VALIDATE-ACCT.                                              
      *                                                                         
           MOVE AT-ACCOUNT-NO            TO BH-ACCOUNT-NO               
                                            BI-ACCOUNT-NO               
                                            CZ-ACCOUNT-NO               
                                            DA-ACCOUNT-NO               
                                            NH-ACCOUNT-NO               
                                            UT-ACCOUNT-NO.              
      *                                                                         
           PERFORM 6100-GET-ACCT-DET     THRU 6100-EXIT.                
           MOVE AT-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT.      
           MOVE AT-COMPANY-NO            TO WS-COMPANY.                 
      *                                                                         
           MOVE 0                        TO WS-RETURN-CODE-1            
                                            S-RETURN-CODE-1.            
           SET BBP-ELIGIBLE              TO TRUE                        
      * BBP000 - Acct is already on BBP or not                                  
           MOVE 'BBP000'                 TO S-BUS-RULE-TYPE.            
           IF WS-CODE-BUDGET = 'A'                                      
              MOVE 'G'                   TO S-BUS-RULE-RESULT           
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
              GO TO 2000-EXIT                                           
           ELSE                                                         
              MOVE 'R'                   TO S-BUS-RULE-RESULT           
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
           END-IF.                                                      
      *                                                                         
      ******************************************************************        
      * CHECK BUSINESS RULES FOR SCE&G ACCOUNTS                        *        
      ******************************************************************        
      *                                                                         
           IF WS-SCEG                                                   
      * BBP001 - Existing Payment Arrangements                                  
              MOVE 'BBP001'              TO S-BUS-RULE-TYPE             
              IF WS-CODE-DPP-ACCT = 'A'                                 
                 SET BBP-NOT-ELIGIBLE    TO TRUE                        
                 MOVE 'R'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
A03710* BBP002 - Not an Active Account                                          
              IF AT-CODE-ACCT-STAT = 'A'                                
                 MOVE 'BBP002'           TO S-BUS-RULE-TYPE             
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 IF AT-CODE-ACCT-STAT = 'P'                             
                    MOVE 'BBP003'        TO S-BUS-RULE-TYPE             
                    MOVE 'G'             TO S-BUS-RULE-RESULT           
                 ELSE                                                   
                    SET BBP-NOT-ELIGIBLE TO TRUE                        
                    MOVE 'BBP002'        TO S-BUS-RULE-TYPE             
                    MOVE 'R'             TO S-BUS-RULE-RESULT           
                 END-IF                                                 
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP030 - Medical Certificate                                            
              MOVE 'BBP030'              TO S-BUS-RULE-TYPE             
              IF WS-CODE-MEDICAL = 'A'                                  
                 SET BBP-NOT-ELIGIBLE    TO TRUE                        
                 MOVE 'R'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP004 - Major Account                                                  
              MOVE 'BBP004'              TO S-BUS-RULE-TYPE             
              IF AT-CODE-MAJOR-ACCT = 'Y'                               
                 SET BBP-NOT-ELIGIBLE    TO TRUE                        
                 MOVE 'R'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP005 - Non-utility Account                                            
              MOVE 'BBP005'              TO S-BUS-RULE-TYPE             
              IF AT-CREDIT-GROUP = 'D'                                  
                 SET BBP-NOT-ELIGIBLE    TO TRUE                        
                 MOVE 'R'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP006 - Master/Sub Account                                             
              MOVE 'BBP006'              TO S-BUS-RULE-TYPE             
              IF AT-MST-SUB-ACCT-IND = 'M' OR 'S'                       
                 SET BBP-NOT-ELIGIBLE    TO TRUE                        
                 MOVE 'R'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP007 - Bankrupt Account                                               
              MOVE 'BBP007'              TO S-BUS-RULE-TYPE             
              IF AT-BANKRUPTCY-IND = 'B'                                
                 SET BBP-NOT-ELIGIBLE    TO TRUE                        
                 MOVE 'R'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP008 - Xfer From Account is not Final Billed                          
              MOVE 'BBP008'              TO S-BUS-RULE-TYPE             
              IF AT-ACCT-XFER-FROM-LST > 0                              
                 PERFORM 6150-GET-ACCT-STAT  THRU 6150-EXIT             
                 IF WS-XFER-TO-FB = 'N'                                 
                    SET BBP-NOT-ELIGIBLE TO TRUE                        
                    MOVE 'R'             TO S-BUS-RULE-RESULT           
                 ELSE                                                   
                    MOVE 'G'             TO S-BUS-RULE-RESULT           
                 END-IF                                                 
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP010 - Industrial Accounts                                            
              MOVE 'BBP010'              TO S-BUS-RULE-TYPE             
ACT328        IF AT-ACCOUNT-TYPE-CODE = 'I' OR 'C'                      
                 SET BBP-NOT-ELIGIBLE    TO TRUE                        
                 MOVE 'R'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP011 - Seasonal Account                                               
              PERFORM 6550-CHK-SEASONAL-USE  THRU 6550-EXIT             
              MOVE 'BBP011'              TO S-BUS-RULE-TYPE             
              IF WS-NOT-SEASONAL-ACCT = 'Y'                             
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'Y'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP012 - TOU Account                                                    
              MOVE 'BBP012'              TO S-BUS-RULE-TYPE             
              PERFORM 6200-CHK-FOR-TOU   THRU 6200-EXIT                 
              IF WS-TOU-EXISTS = 'Y'                                    
                 SET BBP-NOT-ELIGIBLE    TO TRUE                        
                 MOVE 'R'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP013 - Co-Gen Account                                                 
              MOVE 'BBP013'              TO S-BUS-RULE-TYPE             
              PERFORM 6250-CHK-FOR-COGEN THRU 6250-EXIT                 
              IF WS-COGEN-EXISTS = 'Y'                                  
                 SET BBP-NOT-ELIGIBLE    TO TRUE                        
                 MOVE 'R'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP009 - Commercial Accounts/Length Of Service                          
      * BBP014 - Residential Length Of Service                                  
              IF AT-ACCOUNT-TYPE-CODE = 'C' OR 'R'                      
                 EXEC SQL                                               
                      SELECT
              DATEADD( YEAR, -1, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :BI-DATE-BILLED      
                 END-EXEC                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*          EXEC SQL                                                       
MFA-TR*               SET :BI-DATE-BILLED  = CURRENT DATE - 1 YEAR              
MFA-TR*          END-EXEC                                                       

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                 PERFORM 6350-GET-BILLS-COUNT                           
                                         THRU 6350-EXIT                 
              END-IF                                                    
      *                                                                         
              IF AT-ACCOUNT-TYPE-CODE = 'C'                             
                 MOVE 'BBP009'           TO S-BUS-RULE-TYPE             
                 IF WS-NO-OF-BILLS < 12                                 
                    MOVE 'R'             TO S-BUS-RULE-RESULT           
                    SET BBP-NOT-ELIGIBLE TO TRUE                        
                 ELSE                                                   
                    MOVE 'Y'             TO S-BUS-RULE-RESULT           
                 END-IF                                                 
                 PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT              
              END-IF                                                    
      *                                                                         
              IF AT-ACCOUNT-TYPE-CODE = 'R'                             
                 MOVE 'BBP014'           TO S-BUS-RULE-TYPE             
                 IF WS-NO-OF-BILLS < 9                                  
                    MOVE 'Y'             TO S-BUS-RULE-RESULT           
                 ELSE                                                   
                    MOVE 'G'             TO S-BUS-RULE-RESULT           
                 END-IF                                                 
                 PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT              
              END-IF                                                    
ACT004* BBP015 - Unpaid returned check for utility balance                      
              PERFORM 6400-CHK-RET-CHECK THRU 6400-EXIT                 
              MOVE 'BBP015'              TO S-BUS-RULE-TYPE             
              IF WS-RET-CHK-EXISTS = 'Y'                                
                 MOVE 'Y'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP016 - Recent Arrears                                                 
              PERFORM 6500-SEL-CRED-PROFILE  THRU 6500-EXIT             
              MOVE 1                     TO WS-I                        
              PERFORM 12 TIMES                                          
                 IF CZ-ARREARS-HIST(WS-I:1) > 0                         
                    MOVE 'Y'             TO WS-ARREARS-EXISTS           
                    MOVE +11             TO WS-I                        
                 END-IF                                                 
                 ADD +1                  TO WS-I                        
              END-PERFORM                                               
              MOVE 'BBP016'              TO S-BUS-RULE-TYPE             
              IF WS-ARREARS-EXISTS = 'Y'                                
                 MOVE 'Y'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP019 - Recently Dropped From BBP                                      
              MOVE 'BBP019'              TO S-BUS-RULE-TYPE             
              IF WS-BBP-DROP-EXISTS = 'Y'                               
                 MOVE 'Y'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP020 - Rollover Enabled/Disabled                                      
              MOVE 'BBP020'              TO S-BUS-RULE-TYPE             
              IF WS-ROL-OVR-ENABLD = 'Y'                                
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'R'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP021 - Rollover Eligibile                                             
              IF WS-ROL-OVR-ENABLD = 'Y'                                
                 IF WS-ROL-OVR-ELIG = 'Y'                               
                    MOVE 'BBP021'        TO S-BUS-RULE-TYPE             
                    MOVE 'G'             TO S-BUS-RULE-RESULT           
                    PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT        
                 ELSE                                                   
      * BBP022 - Not eligible for Rollover because of BBP Drop                  
                    IF WS-BBP-DROP-EXISTS = 'Y'                         
                       MOVE 'BBP022'     TO S-BUS-RULE-TYPE             
                       MOVE 'R'          TO S-BUS-RULE-RESULT           
                       PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT        
                    END-IF                                              
      * BBP023 - Not eligible for Rollover because of DPP Drop                  
                    IF WS-DPP-DROP-EXISTS = 'Y'                         
                       MOVE 'BBP023'     TO S-BUS-RULE-TYPE             
                       MOVE 'R'          TO S-BUS-RULE-RESULT           
                       PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT        
                    END-IF                                              
      * BBP024 - Not eligible for Rollover because of Utility Arrears           
                    IF WS-UTL-ARRS-EXISTS = 'Y'                         
                       MOVE 'BBP024'     TO S-BUS-RULE-TYPE             
                       MOVE 'R'          TO S-BUS-RULE-RESULT           
                       PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT        
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
      * BBP026 - Account is scheduled to be billed within next 5 dayS           
              EXEC SQL                                                  
                  SELECT
              DATEADD( DAY, -5, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-5-DAY-AGO-DT        
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*       EXEC SQL                                                          
MFA-TR*           SET   :WS-5-DAY-AGO-DT = CURRENT DATE - 5 DAYS                
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              PERFORM 5900-NEXT-BILL-DATE         THRU                  
                      5900-NEXT-BILL-DATE-EXIT                          
              IF BN-DATE-EXTRACT <= WS-CURRENT-DATE AND                 
                 BN-DATE-EXTRACT >  WS-5-DAY-AGO-DT                     
                 MOVE 'Y'                TO S-BUS-RULE-RESULT           
                 MOVE 'BBP026'           TO S-BUS-RULE-TYPE             
                 PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT        
                                                                        
              END-IF                                                    
      * BBP028 - Active DNP exists                                              
              MOVE 'BBP028'              TO S-BUS-RULE-TYPE             
              IF WS-CODE-PENDING-DNP = 'A'                              
P00836           MOVE 'Y'                TO S-BUS-RULE-RESULT           
P00836           IF CALLING-PROGRAM  = WS-CALLED-FROM-WEB               
P00836              MOVE 'R'             TO S-BUS-RULE-RESULT           
P00836              SET BBP-NOT-ELIGIBLE TO TRUE                        
P00836           END-IF                                                 
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP029 - Not eligible for Rollover because of Pending DNP               
              IF WS-CODE-PENDING-DNP = 'A'                              
                 IF WS-ROL-OVR-ELIG = 'Y'                               
                    MOVE 'N'             TO WS-ROL-OVR-ELIG             
                    MOVE 'BBP029'        TO S-BUS-RULE-TYPE             
                    MOVE 'R'             TO S-BUS-RULE-RESULT           
                    PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT        
                 END-IF                                                 
              END-IF                                                    
      * BBP027 - Account is on Bank Draft                                       
              MOVE 'BBP027'              TO S-BUS-RULE-TYPE             
              IF WS-CODE-BANK-EFT = 'A'                                 
                 MOVE 'Y'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
           END-IF.                                                      
      *                                                                         
      ******************************************************************        
      * CHECK BUSINESS RULES FOR PSNC ACCOUNTS                         *        
      ******************************************************************        
      *                                                                         
           IF WS-PSNC                                                   
      * BBP001 - Existing Payment Arrangements                                  
              MOVE 'BBP001'              TO S-BUS-RULE-TYPE             
              IF WS-CODE-DPP-ACCT = 'A'                                 
                 SET BBP-NOT-ELIGIBLE    TO TRUE                        
                 MOVE 'R'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
A03710* BBP002 - Not an Active Account                                          
              IF AT-CODE-ACCT-STAT = 'A'                                
                 MOVE 'BBP002'           TO S-BUS-RULE-TYPE             
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 IF AT-CODE-ACCT-STAT = 'P'                             
                    MOVE 'BBP003'        TO S-BUS-RULE-TYPE             
                    MOVE 'G'             TO S-BUS-RULE-RESULT           
                 ELSE                                                   
                    SET BBP-NOT-ELIGIBLE TO TRUE                        
                    MOVE 'BBP002'        TO S-BUS-RULE-TYPE             
                    MOVE 'R'             TO S-BUS-RULE-RESULT           
                 END-IF                                                 
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP030 - Medical Certificate                                            
              MOVE 'BBP030'              TO S-BUS-RULE-TYPE             
              IF WS-CODE-MEDICAL = 'A'                                  
                 SET BBP-NOT-ELIGIBLE    TO TRUE                        
                 MOVE 'R'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP004 - Major Account                                                  
              MOVE 'BBP004'              TO S-BUS-RULE-TYPE             
              IF AT-CODE-MAJOR-ACCT = 'Y'                               
                 SET BBP-NOT-ELIGIBLE    TO TRUE                        
                 MOVE 'R'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP005 - Non-utility Account                                            
              MOVE 'BBP005'              TO S-BUS-RULE-TYPE             
              IF AT-CREDIT-GROUP = 'D'                                  
                 SET BBP-NOT-ELIGIBLE    TO TRUE                        
                 MOVE 'R'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP006 - Master/Sub Account                                             
              MOVE 'BBP006'              TO S-BUS-RULE-TYPE             
              IF AT-MST-SUB-ACCT-IND = 'M' OR 'S'                       
                 SET BBP-NOT-ELIGIBLE    TO TRUE                        
                 MOVE 'R'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP007 - Bankrupt Account                                               
              MOVE 'BBP007'              TO S-BUS-RULE-TYPE             
              IF AT-BANKRUPTCY-IND = 'B'                                
                 SET BBP-NOT-ELIGIBLE    TO TRUE                        
                 MOVE 'R'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP008 - Xfer From Account is not Final Billed                          
              MOVE 'BBP008'              TO S-BUS-RULE-TYPE             
              IF AT-ACCT-XFER-FROM-LST > 0                              
                 PERFORM 6150-GET-ACCT-STAT  THRU 6150-EXIT             
                 IF WS-XFER-TO-FB = 'N'                                 
                    SET BBP-NOT-ELIGIBLE TO TRUE                        
                    MOVE 'R'             TO S-BUS-RULE-RESULT           
                 ELSE                                                   
                    MOVE 'G'             TO S-BUS-RULE-RESULT           
                 END-IF                                                 
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP010 - Industrial Accounts                                            
              MOVE 'BBP010'              TO S-BUS-RULE-TYPE             
              IF AT-ACCOUNT-TYPE-CODE = 'I'                             
                 SET BBP-NOT-ELIGIBLE    TO TRUE                        
                 MOVE 'R'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP011 - Seasonal Account                                               
              PERFORM 6550-CHK-SEASONAL-USE  THRU 6550-EXIT             
              MOVE 'BBP011'              TO S-BUS-RULE-TYPE             
              IF WS-NOT-SEASONAL-ACCT = 'Y'                             
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'Y'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP009 - Commercial Accounts/Length Of Service                          
      * BBP014 - Residential Length Of Service                                  
              IF AT-ACCOUNT-TYPE-CODE = 'C' OR 'R'                      
                 EXEC SQL                                               
                      SELECT
              DATEADD( YEAR, -1, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :BI-DATE-BILLED       
                 END-EXEC                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*          EXEC SQL                                                       
MFA-TR*               SET :BI-DATE-BILLED = CURRENT DATE - 1 YEAR               
MFA-TR*          END-EXEC                                                       

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                 PERFORM 6350-GET-BILLS-COUNT                           
                                         THRU 6350-EXIT                 
              END-IF                                                    
      *                                                                         
              IF AT-ACCOUNT-TYPE-CODE = 'C'                             
                 MOVE 'BBP009'           TO S-BUS-RULE-TYPE             
                 IF WS-NO-OF-BILLS < 12                                 
                    MOVE 'R'             TO S-BUS-RULE-RESULT           
                    SET BBP-NOT-ELIGIBLE TO TRUE                        
                 ELSE                                                   
                    MOVE 'Y'             TO S-BUS-RULE-RESULT           
                 END-IF                                                 
                 PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT              
              END-IF                                                    
      *                                                                         
              IF AT-ACCOUNT-TYPE-CODE = 'R'                             
                 MOVE 'BBP014'           TO S-BUS-RULE-TYPE             
                 IF WS-NO-OF-BILLS < 9                                  
                    MOVE 'Y'             TO S-BUS-RULE-RESULT           
                 ELSE                                                   
                    MOVE 'G'             TO S-BUS-RULE-RESULT           
                 END-IF                                                 
                 PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT              
              END-IF                                                    
ACT004* BBP015 - Unpaid returned check for utility balance                      
              PERFORM 6400-CHK-RET-CHECK THRU 6400-EXIT                 
              MOVE 'BBP015'              TO S-BUS-RULE-TYPE             
              IF WS-RET-CHK-EXISTS = 'Y'                                
                 MOVE 'Y'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP016 - Recent Arrears                                                 
              PERFORM 6500-SEL-CRED-PROFILE  THRU 6500-EXIT             
              MOVE 1                     TO WS-I                        
              PERFORM 12 TIMES                                          
                 IF CZ-ARREARS-HIST(WS-I:1) > 0                         
                    ADD  +1              TO WS-NO-OF-ARREARS            
                 END-IF                                                 
                 ADD +1                  TO WS-I                        
              END-PERFORM                                               
              MOVE 'BBP016'              TO S-BUS-RULE-TYPE             
              IF WS-NO-OF-ARREARS > 2                                   
                 MOVE 'Y'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP017 - DNP-FB in last 12 Months at this Address                       
              PERFORM 6650-CHECK-DNP-FB  THRU 6650-EXIT                 
              MOVE 'BBP017'              TO S-BUS-RULE-TYPE             
              IF WS-DNBFB-EXISTS = 'Y'                                  
                    MOVE 'Y'             TO S-BUS-RULE-RESULT           
              ELSE                                                      
                    MOVE 'G'             TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP018 - Previous Payment Arrangements (DPP Only)                       
              EXEC SQL                                                  
                   SELECT
              DATEADD( MONTH, -3, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-DPP-CUTOFF-DT     
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*       EXEC SQL                                                          
MFA-TR*            SET  :WS-DPP-CUTOFF-DT = CURRENT DATE - 3 MONTHS             
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              PERFORM 6600-CHK-PYMT-ARR  THRU 6600-EXIT                 
              MOVE 'BBP018'              TO S-BUS-RULE-TYPE             
              IF WS-DPP-EXISTS = 'Y'                                    
                    MOVE 'Y'             TO S-BUS-RULE-RESULT           
              ELSE                                                      
                    MOVE 'G'             TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP019 - Recently Dropped From BBP                                      
              MOVE 'BBP019'              TO S-BUS-RULE-TYPE             
              IF WS-BBP-DROP-EXISTS = 'Y'                               
                 MOVE 'Y'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP020 - Rollover Enabled/Disabled                                      
              MOVE 'BBP020'              TO S-BUS-RULE-TYPE             
              IF WS-ROL-OVR-ENABLD = 'Y'                                
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'R'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP021 - Rollover Eligibile                                             
              IF WS-ROL-OVR-ENABLD = 'Y'                                
                 IF WS-ROL-OVR-ELIG = 'Y'                               
                    MOVE 'BBP021'        TO S-BUS-RULE-TYPE             
                    MOVE 'G'             TO S-BUS-RULE-RESULT           
                    PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT        
                 ELSE                                                   
      * BBP022 - Not eligible for Rollover because of BBP Drop                  
                    IF WS-BBP-DROP-EXISTS = 'Y'                         
                       MOVE 'BBP022'     TO S-BUS-RULE-TYPE             
                       MOVE 'R'          TO S-BUS-RULE-RESULT           
                       PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT        
                    END-IF                                              
      * BBP023 - Not eligible for Rollover because of DPP Drop                  
                    IF WS-DPP-DROP-EXISTS = 'Y'                         
                       MOVE 'BBP023'     TO S-BUS-RULE-TYPE             
                       MOVE 'R'          TO S-BUS-RULE-RESULT           
                       PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT        
                    END-IF                                              
      * BBP024 - Not eligible for Rollover because of Utility Arrears           
                    IF WS-UTL-ARRS-EXISTS = 'Y'                         
                       MOVE 'BBP024'     TO S-BUS-RULE-TYPE             
                       MOVE 'R'          TO S-BUS-RULE-RESULT           
                       PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT        
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
      * BBP026 - Account is scheduled to be billed within the nxt 5 dayS        
              EXEC SQL                                                  
                  SELECT
              DATEADD( DAY, -5, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-5-DAY-AGO-DT        
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*       EXEC SQL                                                          
MFA-TR*           SET   :WS-5-DAY-AGO-DT = CURRENT DATE - 5 DAYS                
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              PERFORM 5900-NEXT-BILL-DATE         THRU                  
                      5900-NEXT-BILL-DATE-EXIT                          
              IF BN-DATE-EXTRACT <= WS-CURRENT-DATE AND                 
                 BN-DATE-EXTRACT >  WS-5-DAY-AGO-DT                     
                 MOVE 'Y'                TO S-BUS-RULE-RESULT           
                 MOVE 'BBP026'           TO S-BUS-RULE-TYPE             
                 PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT        
                                                                        
              END-IF                                                    
      * BBP028 - Active DNP exists                                              
              MOVE 'BBP028'              TO S-BUS-RULE-TYPE             
              IF WS-CODE-PENDING-DNP = 'A'                              
                 MOVE 'Y'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
      * BBP029 - Not eligible for Rollover because of Pending DNP               
              IF WS-CODE-PENDING-DNP = 'A'                              
                 IF WS-ROL-OVR-ELIG = 'Y'                               
                    MOVE 'N'             TO WS-ROL-OVR-ELIG             
                    MOVE 'BBP029'        TO S-BUS-RULE-TYPE             
                    MOVE 'R'             TO S-BUS-RULE-RESULT           
                    PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT        
                 END-IF                                                 
              END-IF                                                    
      * BBP027 - Account is on Bank Draft                                       
              MOVE 'BBP027'              TO S-BUS-RULE-TYPE             
              IF WS-CODE-BANK-EFT = 'A'                                 
                 MOVE 'Y'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
           END-IF.                                                      
A02824** BBP025 - ACCOUNT IS HAVING ONE OR MORE IC'S ON SECURED RATE            
A02824     MOVE 'BBP025'                 TO S-BUS-RULE-TYPE.            
A02824     MOVE 'N'                      TO WS-SECURED-RATE-FLAG.       
A02824     PERFORM 6675-CHK-SECURE-RATE-IC-EXISTS  THRU  6675-EXIT.     
A02824     IF WS-SECURED-RATE-FLAG  =  'Y'                              
A02824        SET BBP-NOT-ELIGIBLE       TO TRUE                        
A02824        MOVE 'R'                   TO S-BUS-RULE-RESULT           
A02824     ELSE                                                         
A02824        MOVE 'G'                   TO S-BUS-RULE-RESULT           
A02824     END-IF.                                                      
A02824     PERFORM 8010-INSERT-GTT-R1  THRU  8010-EXIT.                 
A02824*                                                                         
       6000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6100-GET-ACCT-DET.                                             *        
      ******************************************************************        
      *                                                                         
       6100-GET-ACCT-DET.                                               
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                       AT.COMPANY_NO                                    
                      ,AT.PREMISE_NO                                    
                      ,AT.CODES_DATA_PRESENT                            
                      ,AT.CODE_ACCT_STAT                                
                      ,AT.ACCOUNT_TYPE_CODE                             
                      ,AT.CODE_MAJOR_ACCT                               
                      ,AT.CREDIT_GROUP                                  
                      ,AT.BANKRUPTCY_IND                                
                      ,AT.MST_SUB_ACCT_IND                              
                      ,AT.ACCT_XFER_FROM_LST                            
                  INTO                                                  
                       :AT-COMPANY-NO                                   
                      ,:AT-PREMISE-NO                                   
                      ,:AT-CODES-DATA-PRESENT                           
                      ,:AT-CODE-ACCT-STAT                               
                      ,:AT-ACCOUNT-TYPE-CODE                            
                      ,:AT-CODE-MAJOR-ACCT                              
                      ,:AT-CREDIT-GROUP                                 
                      ,:AT-BANKRUPTCY-IND                               
                      ,:AT-MST-SUB-ACCT-IND                             
                      ,:AT-ACCT-XFER-FROM-LST                           
                  FROM                                                  
                       CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                 WHERE                                                  
                       AT.ACCOUNT_NO = :AT-ACCOUNT-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                AT.COMPANY_NO                                            
MFA-TR*               ,AT.PREMISE_NO                                            
MFA-TR*               ,AT.CODES_DATA_PRESENT                                    
MFA-TR*               ,AT.CODE_ACCT_STAT                                        
MFA-TR*               ,AT.ACCOUNT_TYPE_CODE                                     
MFA-TR*               ,AT.CODE_MAJOR_ACCT                                       
MFA-TR*               ,AT.CREDIT_GROUP                                          
MFA-TR*               ,AT.BANKRUPTCY_IND                                        
MFA-TR*               ,AT.MST_SUB_ACCT_IND                                      
MFA-TR*               ,AT.ACCT_XFER_FROM_LST                                    
MFA-TR*           INTO                                                          
MFA-TR*                :AT-COMPANY-NO                                           
MFA-TR*               ,:AT-PREMISE-NO                                           
MFA-TR*               ,:AT-CODES-DATA-PRESENT                                   
MFA-TR*               ,:AT-CODE-ACCT-STAT                                       
MFA-TR*               ,:AT-ACCOUNT-TYPE-CODE                                    
MFA-TR*               ,:AT-CODE-MAJOR-ACCT                                      
MFA-TR*               ,:AT-CREDIT-GROUP                                         
MFA-TR*               ,:AT-BANKRUPTCY-IND                                       
MFA-TR*               ,:AT-MST-SUB-ACCT-IND                                     
MFA-TR*               ,:AT-ACCT-XFER-FROM-LST                                   
MFA-TR*           FROM                                                          
MFA-TR*                CSS_ACCOUNT AT                                           
MFA-TR*          WHERE                                                          
MFA-TR*                AT.ACCOUNT_NO = :AT-ACCOUNT-NO                           
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 6100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '6100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       6100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6150-GET-ACCT-STAT.                                            *        
      ******************************************************************        
      *                                                                         
       6150-GET-ACCT-STAT.                                              
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                    REPLACE(REPLACE(CONVERT(CHAR(26), COALESCE(
           ACCT_FINALED_DT,CIS.CHAR2TIMESTAMP(
              '2999-12-31-00.00.00.000000')), 121), ' ', '-'), ':', 
           '.')
                  INTO                                                  
                       :AT-ACCT-FINALED-DT                              
                  FROM                                                  
                       CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                 WHERE                                                  
                       AT.ACCOUNT_NO       = :AT-ACCT-XFER-FROM-LST     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*             IFNULL(ACCT_FINALED_DT,'2999-12-31-00.00.00.000000')        
MFA-TR*           INTO                                                          
MFA-TR*                :AT-ACCT-FINALED-DT                                      
MFA-TR*           FROM                                                          
MFA-TR*                CSS_ACCOUNT AT                                           
MFA-TR*          WHERE                                                          
MFA-TR*                AT.ACCOUNT_NO       = :AT-ACCT-XFER-FROM-LST             
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 6150                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF AT-ACCT-FINALED-DT = '2999-12-31-00.00.00.000000'      
                 MOVE 'N'                TO WS-XFER-TO-FB               
              ELSE                                                      
                 MOVE 'Y'                TO WS-XFER-TO-FB               
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZERO               TO S-RETURN-CODE-1             
                 MOVE 'Y'                TO WS-XFER-TO-FB               
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '6150'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCT-XFER-FROM-LST TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       6150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6200-CHK-FOR-TOU.                                              *        
      ******************************************************************        
      *                                                                         
       6200-CHK-FOR-TOU.                                                
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO                                                  
                       :WS-TOU-EXISTS                                   
                  FROM                                                  
                       CSS_RATE_TOU_DEF RJ WITH(READUNCOMMITTED)                
                      ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
                 WHERE                                                  
                       UT.ACCOUNT_NO     = :UT-ACCOUNT-NO               
                   AND RJ.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE            
                   AND RJ.RATE_PLAN_NO   = UT.RATE_PLAN_NO              
                   AND RJ.VERSION_NO_CNTRL =                            
                       (SELECT                                          
                               MAX(RT.VERSION_NO_CNTRL)                 
                          FROM                                          
                               CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)        
                         WHERE                                          
                               RT.CODE_UTIL_TYPE = RJ.CODE_UTIL_TYPE    
                           AND RT.RATE_PLAN_NO   = RJ.RATE_PLAN_NO      
                           AND RT.FROM_EFFECTIVE_DT <= 
           CAST(SYSDATETIMEOFFSET() AS DATE)     
                           AND RT.CODE_STATUS NOT IN ('T')              
                       )                                                
                                                                 
                                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO                                                          
MFA-TR*                :WS-TOU-EXISTS                                           
MFA-TR*           FROM                                                          
MFA-TR*                CSS_RATE_TOU_DEF RJ                                      
MFA-TR*               ,CSS_UTIL_ENVRNMT UT                                      
MFA-TR*          WHERE                                                          
MFA-TR*                UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                       
MFA-TR*            AND RJ.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                    
MFA-TR*            AND RJ.RATE_PLAN_NO   = UT.RATE_PLAN_NO                      
MFA-TR*            AND RJ.VERSION_NO_CNTRL =                                    
MFA-TR*                (SELECT                                                  
MFA-TR*                        MAX(RT.VERSION_NO_CNTRL)                         
MFA-TR*                   FROM                                                  
MFA-TR*                        CSS_RATE_CREATOR RT                              
MFA-TR*                  WHERE                                                  
MFA-TR*                        RT.CODE_UTIL_TYPE = RJ.CODE_UTIL_TYPE            
MFA-TR*                    AND RT.RATE_PLAN_NO   = RJ.RATE_PLAN_NO              
MFA-TR*                    AND RT.FROM_EFFECTIVE_DT <= CURRENT DATE             
MFA-TR*                    AND RT.CODE_STATUS NOT IN ('T')                      
MFA-TR*                )                                                        
MFA-TR*           WITH UR                                                       
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*        QUERYNO 6200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      NOT-FOUND                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZERO               TO S-RETURN-CODE-1             
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '6200'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       6200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6250-CHK-FOR-COGEN.                                            *        
      ******************************************************************        
      *                                                                         
       6250-CHK-FOR-COGEN.                                              
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO                                                  
                       :WS-COGEN-EXISTS                                 
                  FROM                                                  
                       CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)               
                      ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
                 WHERE                                                  
                       UT.ACCOUNT_NO      = :UT-ACCOUNT-NO              
                   AND J1.CODE_UTIL_TYPE  = UT.CODE_UTIL_TYPE           
                   AND J1.RATE_PLAN_NO    = UT.RATE_PLAN_NO             
                   AND (J1.BAL_FWD_CD     > ' ' OR                      
                        J1.CMPNT_ID_CD    = '60')                       
                   AND J1.VERSION_NO_CNTRL  =                           
                         (SELECT                                        
                                 MAX(RT.VERSION_NO_CNTRL)               
                            FROM                                        
                                 CSS_RATE_CREATOR RT
                           WITH(READUNCOMMITTED)                    
                           WHERE                                        
                                 RT.CODE_UTIL_TYPE = J1.CODE_UTIL_TYPE  
                             AND RT.RATE_PLAN_NO = J1.RATE_PLAN_NO      
                             AND RT.CODE_STATUS  = 'A'                  
                         )                                              
                                                                 
                                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO                                                          
MFA-TR*                :WS-COGEN-EXISTS                                         
MFA-TR*           FROM                                                          
MFA-TR*                CSS_RATE_COMP_DEF J1                                     
MFA-TR*               ,CSS_UTIL_ENVRNMT UT                                      
MFA-TR*          WHERE                                                          
MFA-TR*                UT.ACCOUNT_NO      = :UT-ACCOUNT-NO                      
MFA-TR*            AND J1.CODE_UTIL_TYPE  = UT.CODE_UTIL_TYPE                   
MFA-TR*            AND J1.RATE_PLAN_NO    = UT.RATE_PLAN_NO                     
MFA-TR*            AND (J1.BAL_FWD_CD     > ' ' OR                              
MFA-TR*                 J1.CMPNT_ID_CD    = '60')                               
MFA-TR*            AND J1.VERSION_NO_CNTRL  =                                   
MFA-TR*                  (SELECT                                                
MFA-TR*                          MAX(RT.VERSION_NO_CNTRL)                       
MFA-TR*                     FROM                                                
MFA-TR*                          CSS_RATE_CREATOR RT                            
MFA-TR*                    WHERE                                                
MFA-TR*                          RT.CODE_UTIL_TYPE = J1.CODE_UTIL_TYPE          
MFA-TR*                      AND RT.RATE_PLAN_NO = J1.RATE_PLAN_NO              
MFA-TR*                      AND RT.CODE_STATUS  = 'A'                          
MFA-TR*                  )                                                      
MFA-TR*           WITH UR                                                       
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*        QUERYNO 6250                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      NOT-FOUND                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZERO               TO S-RETURN-CODE-1             
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '6250'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       6250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 41260000
      ******************************************************************        
      * 6300-SELECT-JOB-PARM.                                          *        
      ******************************************************************        
      *                                                                         
       6300-SELECT-JOB-PARM.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT                                                   
                      G6.PARM_DATA                                      
                 INTO                                                   
                      :G6-PARM-DATA                                     
                 FROM                                                   
                      CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                     
                WHERE                                                   
                      G6.PROGRAM_NAME = :G6-PROGRAM-NAME                
                  AND G6.COMPANY_NO   = :G6-COMPANY-NO                  
                  AND G6.CMND_CODE    = :G6-CMND-CODE                   
                  AND G6.SEQ_NO       = :G6-SEQ-NO                      
                  AND G6.STATUS       = 'A'                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*               G6.PARM_DATA                                              
MFA-TR*          INTO                                                           
MFA-TR*               :G6-PARM-DATA                                             
MFA-TR*          FROM                                                           
MFA-TR*               CSS_JOB_PARM G6                                           
MFA-TR*         WHERE                                                           
MFA-TR*               G6.PROGRAM_NAME = :G6-PROGRAM-NAME                        
MFA-TR*           AND G6.COMPANY_NO   = :G6-COMPANY-NO                          
MFA-TR*           AND G6.CMND_CODE    = :G6-CMND-CODE                           
MFA-TR*           AND G6.SEQ_NO       = :G6-SEQ-NO                              
MFA-TR*           AND G6.STATUS       = 'A'                                     
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 6300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '6300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
              MOVE 'CMND_CODE'           TO TABLE-ELEMENT-1             
              MOVE 'SEQ_NO'              TO TABLE-ELEMENT-2             
              MOVE G6-CMND-CODE          TO HOSTVAR-ELEMENT-1           
              MOVE G6-SEQ-NO             TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       6300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 41260000
      ******************************************************************        
      * 6350-GET-BILLS-COUNT.                                          *        
      ******************************************************************        
      *                                                                         
       6350-GET-BILLS-COUNT.                                            
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                       COUNT(BI.DATE_BILLED)                            
                  INTO                                                  
                       :WS-NO-OF-BILLS                                  
                  FROM                                                  
                       CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                 
                 WHERE                                                  
                       BI.ACCOUNT_NO  = :BI-ACCOUNT-NO                  
                   AND BI.DATE_BILLED > IIF(TRY_CONVERT(DATE, 
                                                        :BI-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED
              ) <> 0) OR (LEN(:BI-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :BI-DATE-BILLED
              ), CONVERT(DATE, :BI-DATE-BILLED) )                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                COUNT(BI.DATE_BILLED)                                    
MFA-TR*           INTO                                                          
MFA-TR*                :WS-NO-OF-BILLS                                          
MFA-TR*           FROM                                                          
MFA-TR*                CSS_BILLING_HDR BI                                       
MFA-TR*          WHERE                                                          
MFA-TR*                BI.ACCOUNT_NO  = :BI-ACCOUNT-NO                          
MFA-TR*            AND BI.DATE_BILLED > :BI-DATE-BILLED                         
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 6350                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      NOT-FOUND                         
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '6350'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_BILLING_HDR'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE BI-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'DATE_BILLED'         TO TABLE-ELEMENT-2             
              MOVE BI-DATE-BILLED        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       6350-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 6400-CHK-RET-CHECK.                                            *        
      ******************************************************************        
      *                                                                         
       6400-CHK-RET-CHECK.                                              
      *                                                                         
           EXEC SQL                                                     
ACT004          SELECT TOP(1) 'Y'                                              
ACT004            INTO :WS-RET-CHK-EXISTS                               
ACT004            FROM CSS_AR_CNTL AC WITH(READUNCOMMITTED)                     
ACT004           WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO            
ACT004             AND AC.ITEM_ID           = 0                         
ACT004             AND AC.PYMT_PRIORITY_LVL = 20                        
ACT004                                       
ACT004                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-RET-CHK-EXISTS                                       
MFA-TR*           FROM CSS_AR_CNTL AC                                           
MFA-TR*          WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO                    
MFA-TR*            AND AC.ITEM_ID           = 0                                 
MFA-TR*            AND AC.PYMT_PRIORITY_LVL = 20                                
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 6400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
ACT004     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT004        MOVE ZERO                  TO S-RETURN-CODE-1             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '6400'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
ACT004        MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
ACT004        MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       6400-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 6500-SEL-CRED-PROFILE.                                         *        
      ******************************************************************        
      *                                                                         
       6500-SEL-CRED-PROFILE.                                           
      *                                                                         
            EXEC SQL                                                    
                 SELECT                                                 
                         CZ.ARREARS_HIST                                
                   INTO                                                 
                         :CZ-ARREARS-HIST                               
                   FROM                                                 
                        CSS_CREDIT_PROFILE CZ WITH(READUNCOMMITTED)             
                  WHERE                                                 
                        CZ.ACCOUNT_NO    = :CZ-ACCOUNT-NO               
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*          SELECT                                                         
MFA-TR*                  CZ.ARREARS_HIST                                        
MFA-TR*            INTO                                                         
MFA-TR*                  :CZ-ARREARS-HIST                                       
MFA-TR*            FROM                                                         
MFA-TR*                 CSS_CREDIT_PROFILE CZ                                   
MFA-TR*           WHERE                                                         
MFA-TR*                 CZ.ACCOUNT_NO    = :CZ-ACCOUNT-NO                       
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 6500                                                       
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      NOT-FOUND                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 0                  TO S-RETURN-CODE-1             
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '6500'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CREDIT_PROFILE'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE CZ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       6500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 6550-CHK-SEASONAL-USE.                                         *        
      ******************************************************************        
      *                                                                         
       6550-CHK-SEASONAL-USE.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO                                                  
                       :WS-NOT-SEASONAL-ACCT                            
                  FROM                                                  
                       CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
                 WHERE                                                  
                       UT.ACCOUNT_NO        = :UT-ACCOUNT-NO            
                   AND UT.CODE_UTIL_TYPE    IN ('E','G')                
                   AND UT.SEASONAL_USE_CODE <> ' '                      
                                                                 
                                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                'Y'                                                      
MFA-TR*           INTO                                                          
MFA-TR*                :WS-NOT-SEASONAL-ACCT                                    
MFA-TR*           FROM                                                          
MFA-TR*                CSS_UTIL_ENVRNMT UT                                      
MFA-TR*          WHERE                                                          
MFA-TR*                UT.ACCOUNT_NO        = :UT-ACCOUNT-NO                    
MFA-TR*            AND UT.CODE_UTIL_TYPE    IN ('E','G')                        
MFA-TR*            AND UT.SEASONAL_USE_CODE <> ' '                              
MFA-TR*           WITH UR                                                       
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*        QUERYNO 6550                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      NOT-FOUND                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZERO               TO S-RETURN-CODE-1             
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '6550'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       6550-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 6600-CHK-PYMT-ARR.                                             *        
      ******************************************************************        
      *                                                                         
       6600-CHK-PYMT-ARR.                                               
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO                                                  
                       :WS-DPP-EXISTS                                   
                  FROM                                                  
                       CSS_DFA_ACCT DA WITH(READUNCOMMITTED)                    
                 WHERE                                                  
                       DA.ACCOUNT_NO        = :DA-ACCOUNT-NO            
                   AND CODE_DFA_STATUS      IN ('C','R')                
                   AND CAST(LAST_UPDATE_TS AS DATE) > 
              IIF(TRY_CONVERT(DATE, :WS-DPP-CUTOFF-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-DPP-CUTOFF-DT
              ) <> 0) OR (LEN(:WS-DPP-CUTOFF-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-DPP-CUTOFF-DT
              ), CONVERT(DATE, :WS-DPP-CUTOFF-DT) )         
                                                                 
                                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                'Y'                                                      
MFA-TR*           INTO                                                          
MFA-TR*                :WS-DPP-EXISTS                                           
MFA-TR*           FROM                                                          
MFA-TR*                CSS_DFA_ACCT DA                                          
MFA-TR*          WHERE                                                          
MFA-TR*                DA.ACCOUNT_NO        = :DA-ACCOUNT-NO                    
MFA-TR*            AND CODE_DFA_STATUS      IN ('C','R')                        
MFA-TR*            AND DATE(LAST_UPDATE_TS) > :WS-DPP-CUTOFF-DT                 
MFA-TR*           WITH UR                                                       
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*        QUERYNO 6600                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      NOT-FOUND                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 0                  TO S-RETURN-CODE-1             
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '6600'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DFA_ACCT'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DA-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       6600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6650-CHECK-DNP-FB.                                             *        
      ******************************************************************        
      *                                                                         
       6650-CHECK-DNP-FB.                                               
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO                                                  
                       :WS-DNBFB-EXISTS                                 
                  FROM                                                  
                       CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
                 WHERE                                                  
                       AT.PREMISE_NO       = :AT-PREMISE-NO             
                   AND AT.ACCT_FINALED_DT  > DATEADD( YEAR, -1, 
           CIS.CURRENT$TIMESTAMP() ) 
                   AND AT.CODE_ACCT_STAT     IN ('B','S')               
                   AND AT.CODE_STATUS_REASON = 'C'                      
                                                                 
                                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                'Y'                                                      
MFA-TR*           INTO                                                          
MFA-TR*                :WS-DNBFB-EXISTS                                         
MFA-TR*           FROM                                                          
MFA-TR*                CSS_ACCOUNT AT                                           
MFA-TR*          WHERE                                                          
MFA-TR*                AT.PREMISE_NO       = :AT-PREMISE-NO                     
MFA-TR*            AND AT.ACCT_FINALED_DT  > CURRENT TIMESTAMP - 1 YEAR         
MFA-TR*            AND AT.CODE_ACCT_STAT     IN ('B','S')                       
MFA-TR*            AND AT.CODE_STATUS_REASON = 'C'                              
MFA-TR*           WITH UR                                                       
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*        QUERYNO 6650                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      NOT-FOUND                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 0                  TO S-RETURN-CODE-1             
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '6650'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       6650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A02824******************************************************************        
A02824* CHECK IF ANY IC IS ON SECURED RATE FOR A GIVEN ACCOUNT         *        
A02824******************************************************************        
A02824*                                                                         
A02824 6675-CHK-SECURE-RATE-IC-EXISTS.                                  
A02824*                                                                         
A02824     EXEC SQL                                                     
A02824       SELECT TOP(1) 'Y'                                               
A02824         INTO   :WS-SECURED-RATE-FLAG                             
A02824         FROM   CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)               
A02824               ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)               
A02824        WHERE  UT.ACCOUNT_NO       =  :UT-ACCOUNT-NO              
A02824          AND  UT.CODE_UTIL_TYPE  IN  ('E', 'G')                  
A02824          AND  RD.CODE_UTIL_TYPE   =  UT.CODE_UTIL_TYPE           
A02824          AND  RD.RATE_PLAN_NO     =  UT.RATE_PLAN_NO             
A02824          AND  RD.SECURED_RATE_FL  =  'Y'                         
A02824                                       
A02824                                                      
A02824     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT   'Y'                                                       
MFA-TR*        INTO   :WS-SECURED-RATE-FLAG                                     
MFA-TR*        FROM   CSS_UTIL_ENVRNMT   UT                                     
MFA-TR*              ,CSS_RATE_PLAN_DESC RD                                     
MFA-TR*       WHERE  UT.ACCOUNT_NO       =  :UT-ACCOUNT-NO                      
MFA-TR*         AND  UT.CODE_UTIL_TYPE  IN  ('E', 'G')                          
MFA-TR*         AND  RD.CODE_UTIL_TYPE   =  UT.CODE_UTIL_TYPE                   
MFA-TR*         AND  RD.RATE_PLAN_NO     =  UT.RATE_PLAN_NO                     
MFA-TR*         AND  RD.SECURED_RATE_FL  =  'Y'                                 
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*      QUERYNO 6675                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02824*                                                                         
A02824     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
A02824                                      S-RETURN-CODE-1.            
A02824*                                                                         
A02824     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A02824        MOVE 0                     TO S-RETURN-CODE-1             
A02824     ELSE                                                         
A02824        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A02824        MOVE '6675'                TO ACTIVE-PARAGRAPH            
A02824        MOVE 'SELECT'              TO ABEND-FUNCTION              
A02824        MOVE SPACES                TO ABEND-SQL-PREDICATES        
A02824                                      ABEND-TABLES                
A02824        MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
A02824        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
A02824        MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
A02824        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A02824     END-IF.                                                      
A02824*                                                                         
A02824 6675-EXIT.                                                       
A02824     EXIT.                                                        
A02824*                                                                 41260000
      ********************** END OF COPYBOOK ***************************        
