      ******************************************************************        
      **!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!**        
      ** CPD04344                                                     **        
      ** --------                                                     **        
      ** THIS COPY BOOK VALIDATES BBP BUSINESS RULES FOR ON ACCOUNT   **        
      **!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!**        
      ******************************************************************        
      **                    MODIFICATION  LOG                         **        
      ******************************************************************        
      **!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!**        
      **   DATE    INITIALS  REASON                                   **        
      ** ________  ________  ______                                   **        
P00220** 05/22/10  VP94820   INITIALLY CODED FOR BBP BPA'S.           **        
ACT002** 12/14/10  GD97441   APPL3118:ADDED RULES BBP034 & BBP035.    **        
ACT003** 12/20/10  GD97441   APPL3118:GROUPED BUSINESS RULES BASED ON **        
ACT003**                     COMMON/DEREG/GROUP2.                     **        
ACT004** 03/21/11  GD97441   APPL3118-ACT004:RETURN CHECK LOGIC CHANGE**        
P00453** 03/25/11  AA97148   P00453 - ADDED RULES BBP036.             **        
A03710** 11/02/11  VV94890   BBP037-ALLOW BBP SETUP ON PENDING ACCTS. **        
A03710**                     MODIFIED BBP009 & REMOVED BBP010 RULES.  **        
ACT078** 03/27/15  MC95456   APPL5136:ADDED BUS RULE BBP011           **        
P00836** 12/07/16  MS7M727   SET BBP-NOT-ELIGIBLE IS TRUE WHEN DNP    **        
P00836**                     IS ACTIVE AND CALLING-PROGRAM  = 'W'     **        
      **!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!**        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      * 6000-VALIDATE-ACCT.                                            *        
      ******************************************************************        
      *                                                                         
       6000-VALIDATE-ACCT-CPD4344.                                      
      *                                                                         
           SET BBP-ELIGIBLE              TO TRUE.                       
           MOVE 0                        TO WS-RETURN-CODE-1            
                                            S-RETURN-CODE-1.            
      *                                                                         
      ** COMMON BUSINESS RULES (DEREG/REG-GROUP 1/REG-GROUP 2)                  
           PERFORM 6010-CHK-COM-RULES-CPD4344     THRU                  
                   6010-CPD4344-EXIT.                                   
      *                                                                         
      ** BUSINESS RULES - DEREG ONLY                                            
           IF SEB-DREG                                                  
              PERFORM 6020-CHK-DREG-RULES-CPD4344 THRU                  
                      6020-CPD4344-EXIT                                 
           END-IF.                                                      
      *                                                                         
      ** BUSINESS RULES - GROUP 2 ONLY                                          
           IF REG-GRP-2                                                 
              PERFORM 6030-CHK-GRP2-RULES-CPD4344 THRU                  
                      6030-CPD4344-EXIT                                 
           END-IF.                                                      
      *                                                                         
       6000-CPD4344-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** BUSINESS RULES - DREG/REG-GROUP 1/REG-GROUP 2 CUSTOMERS      **        
      ******************************************************************        
      *                                                                         
       6010-CHK-COM-RULES-CPD4344.                                      
      *                                                                         
      ** BBP001 - Existing Payment Arrangements(DPP Account)                    
           MOVE 'BBP001'                 TO S-BUS-RULE-TYPE.            
           IF WS-CODE-DPP-ACCT = 'A'                                    
              MOVE 'R'                   TO S-BUS-RULE-RESULT           
              SET BBP-NOT-ELIGIBLE       TO TRUE                        
           ELSE                                                         
              MOVE 'G'                   TO S-BUS-RULE-RESULT           
           END-IF.                                                      
           PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT.                
      *                                                                         
A03710* BBP002 - Not an Active Account                                          
           IF AT-CODE-ACCT-STAT = 'A'                                   
              MOVE 'BBP002'              TO S-BUS-RULE-TYPE             
              MOVE 'G'                   TO S-BUS-RULE-RESULT           
           ELSE                                                         
              IF AT-CODE-ACCT-STAT = 'P'                                
                 MOVE 'BBP037'           TO S-BUS-RULE-TYPE             
                 MOVE 'G'                TO S-BUS-RULE-RESULT           
              ELSE                                                      
                 SET BBP-NOT-ELIGIBLE    TO TRUE                        
                 MOVE 'BBP002'           TO S-BUS-RULE-TYPE             
                 MOVE 'R'                TO S-BUS-RULE-RESULT           
              END-IF                                                    
           END-IF.                                                      
           PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT.                   
      *                                                                         
      ** BBP003 - Medical Certificate                                           
           MOVE 'BBP003'                 TO S-BUS-RULE-TYPE.            
           IF WS-CODE-MEDICAL = 'A'                                     
              MOVE 'R'                   TO S-BUS-RULE-RESULT           
              SET BBP-NOT-ELIGIBLE       TO TRUE                        
           ELSE                                                         
              MOVE 'G'                   TO S-BUS-RULE-RESULT           
           END-IF.                                                      
           PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT.                
      *                                                                         
      ** BBP006 - Master/Sub Account                                            
           MOVE 'BBP006'                 TO S-BUS-RULE-TYPE.            
           IF AT-MST-SUB-ACCT-IND = 'M' OR 'S'                          
              MOVE 'R'                   TO S-BUS-RULE-RESULT           
              SET BBP-NOT-ELIGIBLE       TO TRUE                        
           ELSE                                                         
              MOVE 'G'                   TO S-BUS-RULE-RESULT           
           END-IF.                                                      
           PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT.                
      *                                                                         
      ** BBP007 - Bankrupt Account                                              
           MOVE 'BBP007'                 TO S-BUS-RULE-TYPE.            
           IF AT-BANKRUPTCY-IND = 'B'                                   
              MOVE 'R'                   TO S-BUS-RULE-RESULT           
              SET BBP-NOT-ELIGIBLE       TO TRUE                        
           ELSE                                                         
              MOVE 'G'                   TO S-BUS-RULE-RESULT           
           END-IF.                                                      
           PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT.                
      *                                                                         
      ** BBP026 - Account is scheduled to be billed within next 5 dayS          
           EXEC SQL                                                     
                SELECT
              DATEADD( DAY, 5, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-CPD4344-CURR-DT-PLUS-5  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CPD4344-CURR-DT-PLUS-5 = CURRENT DATE + 5 DAYS          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           PERFORM 5900-NEXT-BILL-DATE THRU 5900-NEXT-BILL-DATE-EXIT.   
           IF (BN-DATE-EXTRACT >= WS-CURRENT-DATE)  AND                 
              (BN-DATE-EXTRACT <= WS-CPD4344-CURR-DT-PLUS-5)            
              MOVE 'BBP026'              TO S-BUS-RULE-TYPE             
              MOVE 'Y'                   TO S-BUS-RULE-RESULT           
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
           END-IF.                                                      
      *                                                                         
      ** BBP027 - Account is on Bank Draft                                      
           MOVE 'BBP027'                 TO S-BUS-RULE-TYPE.            
           IF WS-CODE-BANK-EFT = 'A'                                    
              MOVE 'Y'                   TO S-BUS-RULE-RESULT           
           ELSE                                                         
              MOVE 'G'                   TO S-BUS-RULE-RESULT           
           END-IF.                                                      
           PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT.                
      *                                                                         
      ** BBP028 - Forecasted/Active DNP exists                                  
           MOVE 'BBP028'                 TO S-BUS-RULE-TYPE.            
           IF WS-CODE-PENDING-DNP = 'A'                                 
              MOVE 'Y'                   TO S-BUS-RULE-RESULT           
P00836        IF CALLING-PROGRAM = WS-CALLED-FROM-WEB                   
P00836           MOVE 'R'                TO S-BUS-RULE-RESULT           
P00836           SET BBP-NOT-ELIGIBLE    TO TRUE                        
P00836        END-IF                                                    
           ELSE                                                         
              MOVE 'G'                   TO S-BUS-RULE-RESULT           
           END-IF.                                                      
           PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT.                
      *                                                                         
      ** BBP030 - Unpaid returned check for utility balance                     
           MOVE 'BBP030'                 TO S-BUS-RULE-TYPE.            
ACT004     PERFORM 6400-CHK-RET-CHECK-CPD4344 THRU 6400-CPD4344-EXIT.   
ACT004     IF WS-CPD4344-RET-CHK-IND = 'Y'                              
ACT004        MOVE 'R'                   TO S-BUS-RULE-RESULT           
ACT004        SET BBP-NOT-ELIGIBLE       TO TRUE                        
ACT004     ELSE                                                         
ACT004        MOVE 'G'                   TO S-BUS-RULE-RESULT           
ACT004     END-IF.                                                      
           PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT.                
      *                                                                         
ACT078** BBP011 - No Active Rate Information                                    
ACT078     PERFORM 6600-GET-ACCT-RATE-STATUS THRU 6600-EXIT             
ACT078     IF DF-STATUS-CD   = 'A' OR DF-STATUS-CD = 'P' OR             
ACT078        DF-STATUS-CD   = 'O' OR DF-STATUS-CD = 'R'                
ACT078        CONTINUE                                                  
ACT078     ELSE                                                         
ACT078        MOVE 'BBP011'              TO S-BUS-RULE-TYPE             
ACT078        MOVE 'R'                   TO S-BUS-RULE-RESULT           
ACT078        PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
ACT078     END-IF.                                                      
      *                                                                         
       6010-CPD4344-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** BUSINESS RULES - DREG CUSTOMERS                              **        
      ******************************************************************        
      *                                                                         
       6020-CHK-DREG-RULES-CPD4344.                                     
      *                                                                         
      ** BBP004 - Major Account                                                 
           MOVE 'BBP004'                 TO S-BUS-RULE-TYPE.            
           IF AT-CODE-MAJOR-ACCT = 'Y'                                  
              MOVE 'R'                   TO S-BUS-RULE-RESULT           
              SET BBP-NOT-ELIGIBLE       TO TRUE                        
           ELSE                                                         
              MOVE 'G'                   TO S-BUS-RULE-RESULT           
           END-IF.                                                      
           PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT.                
      *                                                                         
      ** BBP005 - Non-utility Account                                           
           MOVE 'BBP005'                 TO S-BUS-RULE-TYPE.            
           IF AT-CREDIT-GROUP = 'D'                                     
              MOVE 'R'                   TO S-BUS-RULE-RESULT           
              SET BBP-NOT-ELIGIBLE       TO TRUE                        
P00453        PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT              
           END-IF.                                                      
      *                                                                         
      ** BBP009 - Commercial/Industrial Accounts                                
           MOVE 'BBP009'                 TO S-BUS-RULE-TYPE.            
A03710     IF AT-ACCOUNT-TYPE-CODE = 'C' OR 'I'                         
P00453        MOVE 'R'                   TO S-BUS-RULE-RESULT           
A03710        SET BBP-NOT-ELIGIBLE       TO TRUE                        
           ELSE                                                         
              MOVE 'G'                   TO S-BUS-RULE-RESULT           
           END-IF.                                                      
           PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT.                
      *                                                                         
P00453** BBP036 - PRE-PAY PLAN Accounts                                         
P00453     IF WS-CODE-PRE-PAY-PLAN = 'A'                                
P00453        MOVE 'BBP036'              TO S-BUS-RULE-TYPE             
P00453        MOVE 'R'                   TO S-BUS-RULE-RESULT           
P00453        SET BBP-NOT-ELIGIBLE       TO TRUE                        
P00453        PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
P00453     END-IF.                                                      
      *                                                                         
       6020-CPD4344-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** BUSINESS RULES - REG GROUP 2 CUSTOMERS                       **        
      ******************************************************************        
      *                                                                         
       6030-CHK-GRP2-RULES-CPD4344.                                     
      *                                                                         
      ** BBP031 - Group 2 with Balance Credit Group                             
           IF AT-CREDIT-GROUP = 'B'                                     
              MOVE 'BBP031'              TO S-BUS-RULE-TYPE             
              MOVE 'Y'                   TO S-BUS-RULE-RESULT           
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
           END-IF.                                                      
      *                                                                         
      ** BBP034 - Group 2(Curr Dt between June-Aug:Delinquency Range)           
      ** BBP035 - Group 2(Curr Dt outside June-Aug:Cred Grp Cust Only)          
           IF WS-GRP2-CHK-CURR-MM >= WS-GRP2-DELINQ-FROM-MM  AND        
              WS-GRP2-CHK-CURR-MM <= WS-GRP2-DELINQ-TO-MM               
              MOVE 'BBP034'              TO S-BUS-RULE-TYPE             
              MOVE 'G'                   TO S-BUS-RULE-RESULT           
              PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT                 
           ELSE                                                         
              IF AT-CREDIT-GROUP = 'B'                                  
                 MOVE 'BBP035'           TO S-BUS-RULE-TYPE             
                 PERFORM 6500-GET-CRED-PROF-CPD4344  THRU               
                         6500-CPD4344-EXIT                              
ACT078           PERFORM 6550-COUNT-DISCONNECT-HIST  THRU 6550-EXIT     
                 IF CZ-ARREARS-HIST(1:12) = '000000000000'              
ACT078              AND WS-DNP-COUNT  <= 2                              
                    MOVE 'G'             TO S-BUS-RULE-RESULT           
                 ELSE                                                   
                    MOVE 'R'             TO S-BUS-RULE-RESULT           
                    SET BBP-NOT-ELIGIBLE TO TRUE                        
                 END-IF                                                 
                 PERFORM 8010-INSERT-GTT-R1 THRU 8010-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       6030-CPD4344-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * RETURN CHECK EXISTS CHECK                                      *        
      ******************************************************************        
      *                                                                         
       6400-CHK-RET-CHECK-CPD4344.                                      
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-CPD4344-RET-CHK-IND                          
                  FROM CSS_AR_CNTL AC WITH(READUNCOMMITTED)                     
                 WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO            
                   AND AC.ITEM_ID           = 0                         
                   AND AC.PYMT_PRIORITY_LVL = 20                        
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-CPD4344-RET-CHK-IND                                  
MFA-TR*           FROM CSS_AR_CNTL AC                                           
MFA-TR*          WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO                    
MFA-TR*            AND AC.ITEM_ID           = 0                                 
MFA-TR*            AND AC.PYMT_PRIORITY_LVL = 20                                
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 6400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE ZERO                  TO S-RETURN-CODE-1             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '6400'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       6400-CPD4344-EXIT.                                               
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** SELECT CREDIT PROFILE DATA                                   **        
      ******************************************************************        
      *                                                                         
       6500-GET-CRED-PROF-CPD4344.                                      
      *                                                                         
            EXEC SQL                                                    
              SELECT  CZ.ARREARS_HIST                                   
ACT078               ,CZ.DISCONNECT_HIST                                
ACT078               ,CZ.DISC_EXCEPTN_HIST                              
                INTO  :CZ-ARREARS-HIST                                  
ACT078               ,:CZ-DISCONNECT-HIST                               
ACT078               ,:CZ-DISC-EXCEPTN-HIST                             
                FROM  CSS_CREDIT_PROFILE  CZ WITH(READUNCOMMITTED)              
               WHERE  CZ.ACCOUNT_NO  =  :CZ-ACCOUNT-NO                  
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*       SELECT  CZ.ARREARS_HIST                                           
MFA-TR*              ,CZ.DISCONNECT_HIST                                        
MFA-TR*              ,CZ.DISC_EXCEPTN_HIST                                      
MFA-TR*         INTO  :CZ-ARREARS-HIST                                          
MFA-TR*              ,:CZ-DISCONNECT-HIST                                       
MFA-TR*              ,:CZ-DISC-EXCEPTN-HIST                                     
MFA-TR*         FROM  CSS_CREDIT_PROFILE  CZ                                    
MFA-TR*        WHERE  CZ.ACCOUNT_NO  =  :CZ-ACCOUNT-NO                          
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 6500                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE 0                     TO S-RETURN-CODE-1             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '6500'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CREDIT_PROFILE'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE CZ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       6500-CPD4344-EXIT.                                               
            EXIT.                                                       
      *                                                                         
ACT078******************************************************************        
ACT078** COUNTS DISCONNECTIONS IN LAST 12 MONTHS                      **        
ACT078******************************************************************        
      *                                                                         
ACT078 6550-COUNT-DISCONNECT-HIST.                                      
      *                                                                         
ACT078     MOVE CZ-DISCONNECT-HIST    TO WS-DISCONNECT-HIST.            
ACT078     MOVE CZ-DISC-EXCEPTN-HIST  TO WS-DISC-EXCEPTN-HIST.          
ACT078     MOVE 0                     TO WS-DNP-COUNT.                  
ACT078     MOVE 1                     TO WS-PREV-MNTH.                  
                                                                        
ACT078     PERFORM UNTIL WS-PREV-MNTH > 12 OR WS-DNP-COUNT > 2          
ACT078        IF WS-DISC-HIST-BYTES(WS-PREV-MNTH) = '2' OR              
ACT078           WS-DISC-HIST-BYTES(WS-PREV-MNTH) = '3' OR              
ACT078           WS-DISC-HIST-BYTES(WS-PREV-MNTH) = '4' OR              
ACT078           WS-DISC-HIST-BYTES(WS-PREV-MNTH) = 'I' OR              
ACT078           WS-DISC-HIST-BYTES(WS-PREV-MNTH) = 'R'                 
ACT078           ADD 1 TO WS-DNP-COUNT                                  
ACT078        END-IF                                                    
ACT078        IF WS-EXCEPTIONAL-HIST-BYTES(WS-PREV-MNTH) = '2' OR       
ACT078           WS-EXCEPTIONAL-HIST-BYTES(WS-PREV-MNTH) = '3' OR       
ACT078           WS-EXCEPTIONAL-HIST-BYTES(WS-PREV-MNTH) = '4' OR       
ACT078           WS-EXCEPTIONAL-HIST-BYTES(WS-PREV-MNTH) = 'I' OR       
ACT078           WS-EXCEPTIONAL-HIST-BYTES(WS-PREV-MNTH) = 'R'          
ACT078           ADD 1 TO WS-DNP-COUNT                                  
ACT078        END-IF                                                    
ACT078        ADD 1 TO WS-PREV-MNTH                                     
ACT078     END-PERFORM.                                                 
                                                                        
ACT078 6550-EXIT.                                                       
ACT078      EXIT.                                                       
      *                                                                         
ACT078******************************************************************        
ACT078** SELECT RATE AGREEMENT STATUS                                 **        
      ******************************************************************        
ACT078*                                                                         
ACT078 6600-GET-ACCT-RATE-STATUS.                                       
      *                                                                         
ACT078      EXEC SQL                                                    
ACT078        SELECT TOP(1) DF.STATUS_CD                                       
ACT078          INTO :DF-STATUS-CD                                      
ACT078          FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                 
ACT078         WHERE DF.ACCOUNT_NO  =  :DF-ACCOUNT-NO                   
ACT078         ORDER BY DF.RT_PKG_OPT_SEQ_NO DESC                       
ACT078                                              
ACT078                                                           
ACT078                                                      
ACT078      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*       SELECT DF.STATUS_CD                                               
MFA-TR*         INTO :DF-STATUS-CD                                              
MFA-TR*         FROM CSS_ACCT_RTPK_AGR DF                                       
MFA-TR*        WHERE DF.ACCOUNT_NO  =  :DF-ACCOUNT-NO                           
MFA-TR*        ORDER BY DF.RT_PKG_OPT_SEQ_NO DESC                               
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 6600                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
ACT078     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
ACT078     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT078        MOVE 0                     TO S-RETURN-CODE-1             
ACT078     ELSE                                                         
ACT078        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
ACT078        MOVE SQLCODE               TO ABEND-SQLCODE               
ACT078        MOVE SQLSTATE              TO ABEND-SQLSTATE              
ACT078        MOVE '6600'                TO ACTIVE-PARAGRAPH            
ACT078        MOVE 'SELECT'              TO ABEND-FUNCTION              
ACT078        MOVE 'CSS_ACCT_RTPK_AGR'   TO TABLE-1                     
ACT078        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
ACT078        MOVE DF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
ACT078        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
ACT078     END-IF.                                                      
      *                                                                         
ACT078 6600-EXIT.                                                       
ACT078      EXIT.                                                       
      *                                                                         
