      ******************************************************************31298000
      **                       COPYBOOK CPD04114                      **31300000
      ******************************************************************31320000
      ** PURPOSE: INCTV VALUE & PRORATED INCTV VALUE FOR INPUT ACCT.  **31300000
      **                                                              **        
      ** INPUTS: WS-ACCT-NO-4114                                      **        
      **         WS-RTPK-AGR-STAT-4114                                **        
      **         WS-INCTV-TYPE-4114                                   **        
      **         WS-INPUT-DATE-4114                                   **        
      **         WS-REV-MTH-4114                                      **        
      **                                                              **        
      ** OUTPUT: INCTV VALUE, PRORATED INCTV VALUE ETC                **        
      **                                                              **        
      ** REQUIRED MAIN PGM COPYBOOKS: CWS04114                        **        
      **                                                              **31300000
      ** REQUIRED MAIN PGM PARA: 6999-ERROR-ROUTINE-CPD4114           **31300000
      **                                                              **31300000
      ******************************************************************31360000
      **               COPYBOOK MODIFICATION  LOG                     **        
      **                                                              **        
      **    DATE     INITIALS                 REASON                  **        
      **  ________   ________   ___________________________________   **        
P00680**  05/01/12   GD97441    NEW COPYBOOK.                         **        
      **                        CUSTOMER RETENTION AND ACQUISITION.   **        
      ******************************************************************        
      *                                                                         
       6000-GET-PRO-INCTV-CPD4114.                                      
      *                                                                         
           MOVE '6000'                 TO ACTIVE-PARAGRAPH.             
      *                                                                         
           SET  NO-ERRORS-4114         TO TRUE.                         
      *                                                                         
      ***** VALIDATE ACCT/RTPK AGR STATUS                                       
           PERFORM 6100-VLDT-ACCT-RTPK-CPD4114      THRU                
                   6100-CPD4114-EXIT.                                   
      *                                                                         
      ***** VALIDATE ATTR INCTV                                                 
           IF NO-ERRORS-4114                                            
              PERFORM 6150-VLDT-INCTV-TYPE-CPD4114  THRU                
                      6150-CPD4114-EXIT                                 
           END-IF.                                                      
      *                                                                         
      ***** VALIDATE INPUT DATE AND REVENUE MONTH                               
           IF NO-ERRORS-4114                                            
              PERFORM 6200-VLDT-DATE-REVMTH-CPD4114 THRU                
                      6200-CPD4114-EXIT                                 
           END-IF.                                                      
      *                                                                         
      **** PRORATE RATE ATTR INCENTIVES                                         
           IF NO-ERRORS-4114                                            
              EVALUATE WS-INCTV-TYPE-4114                               
                  WHEN 'EXIT FEE'                                       
                       PERFORM 6250-PRORATE-EXIT-FEE-CPD4114 THRU       
                               6250-CPD4114-EXIT                        
                  WHEN OTHER                                            
                       CONTINUE                                         
              END-EVALUATE                                              
           END-IF.                                                      
      *                                                                         
      **** ERROR HANDLING - MAIN PROGRAM CODE                                   
           IF ERRORS-4114                                               
              PERFORM 6999-ERROR-ROUTINE-CPD4114    THRU                
                      6999-CPD4114-EXIT                                 
           END-IF.                                                      
      *                                                                         
       6000-CPD4114-EXIT.                                               
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** VALIDATE ACCT OPTION AND RATE PKG AGR STATUS                 **        
      ******************************************************************        
      *                                                                         
       6100-VLDT-ACCT-RTPK-CPD4114.                                     
      *                                                                         
           MOVE '6100'                  TO ACTIVE-PARAGRAPH.            
      *                                                                         
           MOVE 'N'                     TO WS-RTPK-STAT-ADJ-FL-4114.    
      *                                                                         
           MOVE WS-ACCT-NO-4114         TO AT-ACCOUNT-NO.               
      *                                                                         
      ***** RATE PKG AGR STATUS: P --> PENDING                                  
           EVALUATE WS-RTPK-AGR-STAT-4114                               
               WHEN 'P'                                                 
                    PERFORM 6510-GET-PEND-OPTION-CPD4114  THRU          
                            6510-CPD4114-EXIT                           
               WHEN OTHER                                               
                    PERFORM 6500-GET-ACCT-OPTION-CPD4114  THRU          
                            6500-CPD4114-EXIT                           
                    IF NO-ERRORS-4114                                   
                       MOVE HQ-DURATION-NO TO WS-DURATION-TOT-4114      
      ***** STATUS ADJUSTABLE CD: A --> ADJUSTABLE                              
                       IF DF-STAT-ADJUSTABLE-CD = 'A'  AND              
                          FF-DURATION-REMAIN-NO >  0                    
                          MOVE 'Y'        TO WS-RTPK-STAT-ADJ-FL-4114   
                       END-IF                                           
                    END-IF                                              
           END-EVALUATE.                                                
      *                                                                         
       6100-CPD4114-EXIT.                                               
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** VALIDATE INCENTIVE TYPE                                      **        
      ******************************************************************        
      *                                                                         
       6150-VLDT-INCTV-TYPE-CPD4114.                                    
      *                                                                         
           MOVE '6150'                TO ACTIVE-PARAGRAPH.              
      *                                                                         
           MOVE DF-OPTION-CD          TO HQ-OPTION-CD.                  
           MOVE WS-INCTV-TYPE-4114    TO HQ-RT-ATTR-INCTV-TYPE.         
                                                                        
           MOVE DF-OPT-AGRMT-EFF-DT   TO HQ-ATTR-INCTV-STRT-DT          
                                         HQ-ATTR-INCTV-END-DT           
                                         HQ-OPT-ATTR-VSTART-TS(1:10)    
                                         HQ-OPT-ATTR-VEND-TS(1:10).     
           MOVE '-00.00.00.000000'    TO HQ-OPT-ATTR-VSTART-TS(11:16)   
                                         HQ-OPT-ATTR-VEND-TS(11:16).    
      *                                                                         
           PERFORM 6550-GET-OPT-ATR-INCTV-CPD4114  THRU                 
                   6550-CPD4114-EXIT.                                   
      *                                                                         
       6150-CPD4114-EXIT.                                               
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** VALIDATE INPUT DATE AND REVENUE MONTH                        **        
      ******************************************************************        
      *                                                                         
       6200-VLDT-DATE-REVMTH-CPD4114.                                   
      *                                                                         
           MOVE '6200'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF NO-ERRORS-4114 AND WS-INPUT-DATE-4114 <= SPACES           
              PERFORM 6560-GET-COMMON-DT-CPD4114   THRU                 
                      6560-CPD4114-EXIT                                 
           END-IF.                                                      
      *                                                                         
           IF NO-ERRORS-4114 AND WS-REV-MTH-4114 <= 0                   
              MOVE WS-INPUT-DATE-4114     TO BN-DATE-EXTRACT            
              MOVE AT-BILL-CYCLE          TO BN-BILL-CYCLE              
              PERFORM 6570-GET-BW-REV-MTH-CPD4114  THRU                 
                      6570-CPD4114-EXIT                                 
              MOVE BN-REVENUE-MONTH       TO WS-REV-MTH-4114            
           END-IF.                                                      
           IF NO-ERRORS-4114 AND WS-REV-MTH-4114 <= 0                   
              PERFORM 6580-GET-MIN-REV-MTH-CPD4114 THRU                 
                      6580-CPD4114-EXIT                                 
              MOVE BN-REVENUE-MONTH       TO WS-REV-MTH-4114            
           END-IF.                                                      
           IF NO-ERRORS-4114 AND WS-REV-MTH-4114 <= 0                   
              PERFORM 6590-GET-COM-REV-MTH-CPD4114 THRU                 
                      6590-CPD4114-EXIT                                 
              MOVE G6-PARM-DATA(15:6)     TO WS-REV-MTH-4114            
           END-IF.                                                      
      *                                                                         
       6200-CPD4114-EXIT.                                               
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** PRORATION --> "EXIT FEE" RATE ATTRIBUTE INCENTIVE            **        
      ******************************************************************        
      *                                                                         
       6250-PRORATE-EXIT-FEE-CPD4114.                                   
      *                                                                         
           MOVE '6250'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE WS-INCTV-VALUE-4114       TO WS-TEMP-EXIT-FEE-4114      
                                             WS-EXIT-FEE-4114.          
      *                                                                         
      ***** EXIT FEE & SWITCH FEE ARE SAME FOR FOLLOWING SCENARIO               
           IF WS-RTPK-AGR-STAT-4114      = 'P'  OR                      
              WS-TEMP-EXIT-FEE-4114      =  0                           
              MOVE WS-TEMP-EXIT-FEE-4114  TO WS-RATE-CHNG-EXIT-FEE-4114 
              GO TO 6250-CPD4114-EXIT                                   
           END-IF.                                                      
      *                                                                         
      ***** GET INCTV PRORATE DATA                                              
           MOVE DD-TIER-ACCT-TYPE-CD      TO 2L-TIER-ACCT-TYPE-CD.      
           MOVE WS-INCTV-TYPE-4114        TO 2L-RT-ATTR-INCTV-TYPE.     
           MOVE WS-DURATION-TOT-4114      TO 2L-DURATION-TOTAL-NO.      
           MOVE DF-OPT-AGRMT-EFF-DT       TO 2L-ATTR-PRO-START-DT       
                                             2L-ATTR-PRO-END-DT.        
           MOVE WS-REV-MTH-4114(5:2)      TO 2R-ATTR-PRO-MTH.           
           MOVE FF-DURATION-REMAIN-NO     TO 2R-DURATION-REMAIN-NO.     
      *                                                                         
           INITIALIZE                        2L-ATTR-PRO-CALC-CD        
                                             2R-ATTR-PRO-FACTOR.        
      *                                                                         
           PERFORM 6600-GET-INCTV-PRORATE-CPD4114  THRU                 
                   6600-CPD4114-EXIT.                                   
      *                                                                         
           IF NO-ERRORS-4114                                            
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 PERFORM 6610-GET-INC-PRO-0-MTH-CPD4114  THRU           
                         6610-CPD4114-EXIT                              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
      ***** P --> %  A--> $                                                     
           IF NO-ERRORS-4114                                            
              EVALUATE 2L-ATTR-PRO-CALC-CD                              
                  WHEN 'A'                                              
                       MOVE 2R-ATTR-PRO-FACTOR                          
                         TO WS-RATE-CHNG-EXIT-FEE-4114                  
                  WHEN 'P'                                              
P680P2                 COMPUTE WS-EXIT-FEE-ROUND-4114 ROUNDED           
                         EQUAL(WS-TEMP-EXIT-FEE-4114 *                  
                               2R-ATTR-PRO-FACTOR) / 100                
                       END-COMPUTE                                      
P680P2                 MOVE WS-EXIT-FEE-ROUND-4114                      
P680P2                   TO WS-RATE-CHNG-EXIT-FEE-4114                  
                  WHEN OTHER                                            
                       CONTINUE                                         
              END-EVALUATE                                              
           END-IF.                                                      
      *                                                                         
       6250-CPD4114-EXIT.                                               
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      **  GET ACCT'S OPTION DATA                                      **        
      ******************************************************************        
      *                                                                         
       6500-GET-ACCT-OPTION-CPD4114.                                    
      *                                                                         
           EXEC SQL                                                     
             SELECT  AT.BILL_CYCLE                                      
                    ,DF.OPTION_CD                                       
                    ,DF.OPT_AGRMT_EFF_DT                                
                    ,DF.STAT_ADJUSTABLE_CD                              
                    ,DD.TIER_ACCT_TYPE_CD                               
                    ,FF.DURATION_REMAIN_NO                              
                    ,HQ.DURATION_NO                                     
               INTO  :AT-BILL-CYCLE                                     
                    ,:DF-OPTION-CD                                      
                    ,:DF-OPT-AGRMT-EFF-DT                               
                    ,:DF-STAT-ADJUSTABLE-CD                             
                    ,:DD-TIER-ACCT-TYPE-CD                              
                    ,:FF-DURATION-REMAIN-NO                             
                    ,:HQ-DURATION-NO                                    
               FROM  CSS_ACCOUNT         AT WITH(READUNCOMMITTED)               
                    ,CSS_ACCT_MKT_TIER   DD WITH(READUNCOMMITTED)               
                    ,CSS_UTIL_ENVRNMT    UT WITH(READUNCOMMITTED)               
                    ,CSS_ACCT_RTPK_AGR   DF WITH(READUNCOMMITTED)               
                    ,CSS_FIXED_FCTR      FF WITH(READUNCOMMITTED)               
                    ,CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)               
                    ,CSS_SPCL_FCTR       SF WITH(READUNCOMMITTED)               
              WHERE AT.ACCOUNT_NO         = :AT-ACCOUNT-NO              
                AND AT.ACCOUNT_NO         =  DD.ACCOUNT_NO              
                AND AT.ACCOUNT_NO         =  UT.ACCOUNT_NO              
                AND AT.ACCOUNT_NO         =  DF.ACCOUNT_NO              
                AND AT.ACCOUNT_NO         =  FF.ACCOUNT_NO              
                AND AT.COMPANY_NO         =  '01'                       
                AND UT.COMPANY_NO         =  AT.COMPANY_NO              
                AND UT.CODE_UTIL_TYPE     =  'G'                        
                AND DF.COMPANY_NO         =  UT.COMPANY_NO              
                AND DF.CODE_UTIL_TYPE     =  UT.CODE_UTIL_TYPE          
                AND DF.IC_NO              =  UT.IC_NO                   
                AND DF.RT_PKG_OPT_SEQ_NO  =  UT.RT_PKG_OPT_SEQ_NO       
                AND FF.CODE_UTIL_TYPE     =  UT.CODE_UTIL_TYPE          
                AND FF.IC_NO              =  UT.IC_NO                   
                AND FF.RT_PKG_OPT_SEQ_NO  =  UT.RT_PKG_OPT_SEQ_NO       
                AND FF.DURATION_REMAIN_NO >  0                          
                AND SF.FACTOR_ID          =  FF.FACTOR_ID               
                AND SF.OVR_RT_CALC_TYP_CD =  '02'                       
                AND HQ.FACTOR_ID          =  FF.FACTOR_ID               
                AND HQ.COMPANY_NO         =  DF.COMPANY_NO              
                AND HQ.OPTION_CD          =  DF.OPTION_CD               
                AND HQ.ATTR_INCTV_STRT_DT <= DF.OPT_AGRMT_EFF_DT        
                AND HQ.ATTR_INCTV_END_DT  >= DF.OPT_AGRMT_EFF_DT        
                AND HQ.RT_ATTR_INCTV_TYPE =  'FIXED PRICE'              
                AND HQ.PRIMRY_OPT_ATTR_FL =  'Y'                        
                AND HQ.PROC_STATUS_CD     =  'AC'                       
                AND HQ.OPT_ATTR_VSTART_TS = (                           
                    SELECT MAX(H1.OPT_ATTR_VSTART_TS)                   
                      FROM CRM_OPT_ATTR_INCTV H1 WITH(READUNCOMMITTED)          
                     WHERE H1.OPTION_CD       = HQ.OPTION_CD            
                       AND H1.RT_ATTR_INCTV_TYPE                        
                                                = HQ.RT_ATTR_INCTV_TYPE 
                       AND H1.ATTR_INCTV_STRT_DT                        
                                               <= DF.OPT_AGRMT_EFF_DT   
                       AND H1.ATTR_INCTV_END_DT                         
                                               >= DF.OPT_AGRMT_EFF_DT   
                       AND CAST(H1.OPT_ATTR_VSTART_TS AS DATE)                  
                                               <= DF.OPT_AGRMT_EFF_DT   
                       AND CAST(H1.OPT_ATTR_VEND_TS AS DATE)                    
                                               >= DF.OPT_AGRMT_EFF_DT   
                       AND H1.PROC_STATUS_CD  = 'AC')                   
                AND DD.EFF_START_DT       = (                           
                    SELECT MAX(DD1.EFF_START_DT)                        
                      FROM CSS_ACCT_MKT_TIER DD1 WITH(READUNCOMMITTED)          
                     WHERE DD1.ACCOUNT_NO = UT.ACCOUNT_NO)              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  AT.BILL_CYCLE                                              
MFA-TR*             ,DF.OPTION_CD                                               
MFA-TR*             ,DF.OPT_AGRMT_EFF_DT                                        
MFA-TR*             ,DF.STAT_ADJUSTABLE_CD                                      
MFA-TR*             ,DD.TIER_ACCT_TYPE_CD                                       
MFA-TR*             ,FF.DURATION_REMAIN_NO                                      
MFA-TR*             ,HQ.DURATION_NO                                             
MFA-TR*        INTO  :AT-BILL-CYCLE                                             
MFA-TR*             ,:DF-OPTION-CD                                              
MFA-TR*             ,:DF-OPT-AGRMT-EFF-DT                                       
MFA-TR*             ,:DF-STAT-ADJUSTABLE-CD                                     
MFA-TR*             ,:DD-TIER-ACCT-TYPE-CD                                      
MFA-TR*             ,:FF-DURATION-REMAIN-NO                                     
MFA-TR*             ,:HQ-DURATION-NO                                            
MFA-TR*        FROM  CSS_ACCOUNT         AT                                     
MFA-TR*             ,CSS_ACCT_MKT_TIER   DD                                     
MFA-TR*             ,CSS_UTIL_ENVRNMT    UT                                     
MFA-TR*             ,CSS_ACCT_RTPK_AGR   DF                                     
MFA-TR*             ,CSS_FIXED_FCTR      FF                                     
MFA-TR*             ,CRM_OPT_ATTR_INCTV  HQ                                     
MFA-TR*             ,CSS_SPCL_FCTR       SF                                     
MFA-TR*       WHERE AT.ACCOUNT_NO         = :AT-ACCOUNT-NO                      
MFA-TR*         AND AT.ACCOUNT_NO         =  DD.ACCOUNT_NO                      
MFA-TR*         AND AT.ACCOUNT_NO         =  UT.ACCOUNT_NO                      
MFA-TR*         AND AT.ACCOUNT_NO         =  DF.ACCOUNT_NO                      
MFA-TR*         AND AT.ACCOUNT_NO         =  FF.ACCOUNT_NO                      
MFA-TR*         AND AT.COMPANY_NO         =  '01'                               
MFA-TR*         AND UT.COMPANY_NO         =  AT.COMPANY_NO                      
MFA-TR*         AND UT.CODE_UTIL_TYPE     =  'G'                                
MFA-TR*         AND DF.COMPANY_NO         =  UT.COMPANY_NO                      
MFA-TR*         AND DF.CODE_UTIL_TYPE     =  UT.CODE_UTIL_TYPE                  
MFA-TR*         AND DF.IC_NO              =  UT.IC_NO                           
MFA-TR*         AND DF.RT_PKG_OPT_SEQ_NO  =  UT.RT_PKG_OPT_SEQ_NO               
MFA-TR*         AND FF.CODE_UTIL_TYPE     =  UT.CODE_UTIL_TYPE                  
MFA-TR*         AND FF.IC_NO              =  UT.IC_NO                           
MFA-TR*         AND FF.RT_PKG_OPT_SEQ_NO  =  UT.RT_PKG_OPT_SEQ_NO               
MFA-TR*         AND FF.DURATION_REMAIN_NO >  0                                  
MFA-TR*         AND SF.FACTOR_ID          =  FF.FACTOR_ID                       
MFA-TR*         AND SF.OVR_RT_CALC_TYP_CD =  '02'                               
MFA-TR*         AND HQ.FACTOR_ID          =  FF.FACTOR_ID                       
MFA-TR*         AND HQ.COMPANY_NO         =  DF.COMPANY_NO                      
MFA-TR*         AND HQ.OPTION_CD          =  DF.OPTION_CD                       
MFA-TR*         AND HQ.ATTR_INCTV_STRT_DT <= DF.OPT_AGRMT_EFF_DT                
MFA-TR*         AND HQ.ATTR_INCTV_END_DT  >= DF.OPT_AGRMT_EFF_DT                
MFA-TR*         AND HQ.RT_ATTR_INCTV_TYPE =  'FIXED PRICE'                      
MFA-TR*         AND HQ.PRIMRY_OPT_ATTR_FL =  'Y'                                
MFA-TR*         AND HQ.PROC_STATUS_CD     =  'AC'                               
MFA-TR*         AND HQ.OPT_ATTR_VSTART_TS = (                                   
MFA-TR*             SELECT MAX(H1.OPT_ATTR_VSTART_TS)                           
MFA-TR*               FROM CRM_OPT_ATTR_INCTV H1                                
MFA-TR*              WHERE H1.OPTION_CD       = HQ.OPTION_CD                    
MFA-TR*                AND H1.RT_ATTR_INCTV_TYPE                                
MFA-TR*                                         = HQ.RT_ATTR_INCTV_TYPE         
MFA-TR*                AND H1.ATTR_INCTV_STRT_DT                                
MFA-TR*                                        <= DF.OPT_AGRMT_EFF_DT           
MFA-TR*                AND H1.ATTR_INCTV_END_DT                                 
MFA-TR*                                        >= DF.OPT_AGRMT_EFF_DT           
MFA-TR*                AND DATE(H1.OPT_ATTR_VSTART_TS)                          
MFA-TR*                                        <= DF.OPT_AGRMT_EFF_DT           
MFA-TR*                AND DATE(H1.OPT_ATTR_VEND_TS)                            
MFA-TR*                                        >= DF.OPT_AGRMT_EFF_DT           
MFA-TR*                AND H1.PROC_STATUS_CD  = 'AC')                           
MFA-TR*         AND DD.EFF_START_DT       = (                                   
MFA-TR*             SELECT MAX(DD1.EFF_START_DT)                                
MFA-TR*               FROM CSS_ACCT_MKT_TIER DD1                                
MFA-TR*              WHERE DD1.ACCOUNT_NO = UT.ACCOUNT_NO)                      
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 6500                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  ERRORS-4114                TO TRUE                   
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCT_RTPK_AGR'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCT-NO-4114            TO HOSTVAR-ELEMENT-1      
           END-IF.                                                      
      *                                                                         
       6500-CPD4114-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET ACCT'S PENDING OPTION DATA                              **        
      ******************************************************************        
      *                                                                         
       6510-GET-PEND-OPTION-CPD4114.                                    
      *                                                                         
           EXEC SQL                                                     
             SELECT  AT.BILL_CYCLE                                      
                    ,DF.OPTION_CD                                       
                    ,DF.OPT_AGRMT_EFF_DT                                
               INTO  :AT-BILL-CYCLE                                     
                    ,:DF-OPTION-CD                                      
                    ,:DF-OPT-AGRMT-EFF-DT                               
               FROM  CSS_ACCOUNT         AT WITH(READUNCOMMITTED)               
                    ,CSS_ACCT_RTPK_AGR   DF WITH(READUNCOMMITTED)               
              WHERE AT.ACCOUNT_NO         = :AT-ACCOUNT-NO              
                AND AT.ACCOUNT_NO         =  DF.ACCOUNT_NO              
                AND AT.COMPANY_NO         =  '01'                       
                AND DF.COMPANY_NO         =  AT.COMPANY_NO              
                AND DF.CODE_UTIL_TYPE     =  'G'                        
                AND DF.STATUS_CD          =  'P'                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  AT.BILL_CYCLE                                              
MFA-TR*             ,DF.OPTION_CD                                               
MFA-TR*             ,DF.OPT_AGRMT_EFF_DT                                        
MFA-TR*        INTO  :AT-BILL-CYCLE                                             
MFA-TR*             ,:DF-OPTION-CD                                              
MFA-TR*             ,:DF-OPT-AGRMT-EFF-DT                                       
MFA-TR*        FROM  CSS_ACCOUNT         AT                                     
MFA-TR*             ,CSS_ACCT_RTPK_AGR   DF                                     
MFA-TR*       WHERE AT.ACCOUNT_NO         = :AT-ACCOUNT-NO                      
MFA-TR*         AND AT.ACCOUNT_NO         =  DF.ACCOUNT_NO                      
MFA-TR*         AND AT.COMPANY_NO         =  '01'                               
MFA-TR*         AND DF.COMPANY_NO         =  AT.COMPANY_NO                      
MFA-TR*         AND DF.CODE_UTIL_TYPE     =  'G'                                
MFA-TR*         AND DF.STATUS_CD          =  'P'                                
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 6510                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  ERRORS-4114                TO TRUE                   
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6510'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCT_RTPK_AGR'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCT-NO-4114            TO HOSTVAR-ELEMENT-1      
           END-IF.                                                      
      *                                                                         
       6510-CPD4114-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET INCTV DATA USING ACCT'S OPTION AND INPUT INCTV TYPE     **        
      ******************************************************************        
      *                                                                         
       6550-GET-OPT-ATR-INCTV-CPD4114.                                  
      *                                                                         
           EXEC SQL                                                     
             SELECT  COALESCE(HQ.ATTR_INCTV_VALUE,0)                      
               INTO :WS-INCTV-VALUE-4114                                
               FROM  CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)               
              WHERE HQ.COMPANY_NO          = '01'                       
                AND HQ.OPTION_CD           = :HQ-OPTION-CD              
                AND HQ.RT_ATTR_INCTV_TYPE  = :HQ-RT-ATTR-INCTV-TYPE     
                AND HQ.ATTR_INCTV_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )     
                AND HQ.ATTR_INCTV_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                  :HQ-ATTR-INCTV-END-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-END-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-END-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-END-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-END-DT) )      
                AND HQ.PROC_STATUS_CD      = 'AC'                       
                AND HQ.OPT_ATTR_VSTART_TS  = (                          
                    SELECT MAX(H1.OPT_ATTR_VSTART_TS)                   
                      FROM CRM_OPT_ATTR_INCTV H1 WITH(READUNCOMMITTED)          
                     WHERE H1.OPTION_CD      = HQ.OPTION_CD             
                       AND H1.RT_ATTR_INCTV_TYPE                        
                                             = HQ.RT_ATTR_INCTV_TYPE    
                       AND H1.ATTR_INCTV_STRT_DT                        
                                            <= IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )   
                       AND H1.ATTR_INCTV_END_DT                         
                                            >= IIF(TRY_CONVERT(DATE, 
                                                  :HQ-ATTR-INCTV-END-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-END-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-END-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-END-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-END-DT) )    
                       AND H1.OPT_ATTR_VSTART_TS                        
                                            <= CIS.CHAR2TIMESTAMP(
                                                 :HQ-OPT-ATTR-VSTART-TS
              )   
                       AND H1.OPT_ATTR_VEND_TS                          
                                            >= CIS.CHAR2TIMESTAMP(
                                                   :HQ-OPT-ATTR-VEND-TS
              )     
                       AND H1.PROC_STATUS_CD = 'AC')                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  IFNULL(HQ.ATTR_INCTV_VALUE,0)                              
MFA-TR*        INTO :WS-INCTV-VALUE-4114                                        
MFA-TR*        FROM  CRM_OPT_ATTR_INCTV  HQ                                     
MFA-TR*       WHERE HQ.COMPANY_NO          = '01'                               
MFA-TR*         AND HQ.OPTION_CD           = :HQ-OPTION-CD                      
MFA-TR*         AND HQ.RT_ATTR_INCTV_TYPE  = :HQ-RT-ATTR-INCTV-TYPE             
MFA-TR*         AND HQ.ATTR_INCTV_STRT_DT <= :HQ-ATTR-INCTV-STRT-DT             
MFA-TR*         AND HQ.ATTR_INCTV_END_DT  >= :HQ-ATTR-INCTV-END-DT              
MFA-TR*         AND HQ.PROC_STATUS_CD      = 'AC'                               
MFA-TR*         AND HQ.OPT_ATTR_VSTART_TS  = (                                  
MFA-TR*             SELECT MAX(H1.OPT_ATTR_VSTART_TS)                           
MFA-TR*               FROM CRM_OPT_ATTR_INCTV H1                                
MFA-TR*              WHERE H1.OPTION_CD      = HQ.OPTION_CD                     
MFA-TR*                AND H1.RT_ATTR_INCTV_TYPE                                
MFA-TR*                                      = HQ.RT_ATTR_INCTV_TYPE            
MFA-TR*                AND H1.ATTR_INCTV_STRT_DT                                
MFA-TR*                                     <= :HQ-ATTR-INCTV-STRT-DT           
MFA-TR*                AND H1.ATTR_INCTV_END_DT                                 
MFA-TR*                                     >= :HQ-ATTR-INCTV-END-DT            
MFA-TR*                AND H1.OPT_ATTR_VSTART_TS                                
MFA-TR*                                     <= :HQ-OPT-ATTR-VSTART-TS           
MFA-TR*                AND H1.OPT_ATTR_VEND_TS                                  
MFA-TR*                                     >= :HQ-OPT-ATTR-VEND-TS             
MFA-TR*                AND H1.PROC_STATUS_CD = 'AC')                            
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 6550                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  ERRORS-4114                TO TRUE                   
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6550'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CRM_OPT_ATTR_INCTV'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'OPTION_CD'                TO TABLE-ELEMENT-2        
              MOVE 'RT_ATTR_INCTV_TYPE'       TO TABLE-ELEMENT-3        
              MOVE 'ATTR_INCTV_STRT_DT'       TO TABLE-ELEMENT-4        
              MOVE WS-ACCT-NO-4114            TO HOSTVAR-ELEMENT-1      
              MOVE HQ-OPTION-CD               TO HOSTVAR-ELEMENT-2      
              MOVE HQ-RT-ATTR-INCTV-TYPE      TO HOSTVAR-ELEMENT-3      
              MOVE HQ-ATTR-INCTV-STRT-DT      TO HOSTVAR-ELEMENT-4      
           END-IF.                                                      
      *                                                                         
       6550-CPD4114-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET COMMON DATE                                             **        
      ******************************************************************        
      *                                                                         
       6560-GET-COMMON-DT-CPD4114.                                      
      *                                                                         
           EXEC SQL                                                     
             SELECT  CIS.SUBSTR3(G6.PARM_DATA,10,10)                         
               INTO  :WS-INPUT-DATE-4114                                
               FROM  CSS_JOB_PARM   G6 WITH(READUNCOMMITTED)                    
              WHERE  G6.PROGRAM_NAME  =  'COMMON'                       
                AND  G6.COMPANY_NO    =  '01'                           
                AND  G6.CMND_CODE     =  'DATE'                         
                AND  G6.SEQ_NO        =  10                             
                AND  G6.STATUS        =  'A'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  SUBSTR(G6.PARM_DATA,10,10)                                 
MFA-TR*        INTO  :WS-INPUT-DATE-4114                                        
MFA-TR*        FROM  CSS_JOB_PARM   G6                                          
MFA-TR*       WHERE  G6.PROGRAM_NAME  =  'COMMON'                               
MFA-TR*         AND  G6.COMPANY_NO    =  '01'                                   
MFA-TR*         AND  G6.CMND_CODE     =  'DATE'                                 
MFA-TR*         AND  G6.SEQ_NO        =  10                                     
MFA-TR*         AND  G6.STATUS        =  'A'                                    
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 6560                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  ERRORS-4114                TO TRUE                   
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6560'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_JOB_PARM'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCT-NO-4114            TO HOSTVAR-ELEMENT-1      
           END-IF.                                                      
      *                                                                         
       6560-CPD4114-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET REVENUE MONTH FOR INPUT CYCLE AND DATE                  **        
      ******************************************************************        
      *                                                                         
       6570-GET-BW-REV-MTH-CPD4114.                                     
      *                                                                         
           EXEC SQL                                                     
             SELECT  COALESCE(BN.REVENUE_MONTH,0)                         
               INTO  :BN-REVENUE-MONTH                                  
               FROM  CSS_BILL_WINDOW  BN WITH(READUNCOMMITTED)                  
              WHERE  BN.BILL_CYCLE    =  :BN-BILL-CYCLE                 
                AND  BN.DATE_EXTRACT  =  IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  IFNULL(BN.REVENUE_MONTH,0)                                 
MFA-TR*        INTO  :BN-REVENUE-MONTH                                          
MFA-TR*        FROM  CSS_BILL_WINDOW  BN                                        
MFA-TR*       WHERE  BN.BILL_CYCLE    =  :BN-BILL-CYCLE                         
MFA-TR*         AND  BN.DATE_EXTRACT  =  :BN-DATE-EXTRACT                       
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 6570                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  ERRORS-4114                TO TRUE                   
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6570'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_WINDOW'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_CYCLE'               TO TABLE-ELEMENT-2        
              MOVE 'DATE_EXTRACT'             TO TABLE-ELEMENT-3        
              MOVE WS-ACCT-NO-4114            TO HOSTVAR-ELEMENT-1      
              MOVE BN-BILL-CYCLE              TO HOSTVAR-ELEMENT-2      
              MOVE BN-DATE-EXTRACT            TO HOSTVAR-ELEMENT-3      
           END-IF.                                                      
      *                                                                         
       6570-CPD4114-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET MINIMUM REVENUE MONTH FOR INPUT DATE                    **        
      ******************************************************************        
      *                                                                         
       6580-GET-MIN-REV-MTH-CPD4114.                                    
      *                                                                         
           EXEC SQL                                                     
             SELECT  COALESCE(MIN(BN.REVENUE_MONTH),0)                    
               INTO  :BN-REVENUE-MONTH                                  
               FROM  CSS_BILL_WINDOW  BN WITH(READUNCOMMITTED)                  
              WHERE  BN.DATE_EXTRACT  =  IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  IFNULL(MIN(BN.REVENUE_MONTH),0)                            
MFA-TR*        INTO  :BN-REVENUE-MONTH                                          
MFA-TR*        FROM  CSS_BILL_WINDOW  BN                                        
MFA-TR*       WHERE  BN.DATE_EXTRACT  =  :BN-DATE-EXTRACT                       
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 6580                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  ERRORS-4114                TO TRUE                   
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6580'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_BILL_WINDOW'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'DATE_EXTRACT'             TO TABLE-ELEMENT-2        
              MOVE WS-ACCT-NO-4114            TO HOSTVAR-ELEMENT-1      
              MOVE BN-DATE-EXTRACT            TO HOSTVAR-ELEMENT-2      
           END-IF.                                                      
      *                                                                         
       6580-CPD4114-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET "COMMON-REVENUE MONTH" FROM JOB PARM                    **        
      ******************************************************************        
      *                                                                         
       6590-GET-COM-REV-MTH-CPD4114.                                    
      *                                                                         
           EXEC SQL                                                     
             SELECT  G6.PARM_DATA                                       
               INTO :G6-PARM-DATA                                       
               FROM  CSS_JOB_PARM  G6 WITH(READUNCOMMITTED)                     
              WHERE  G6.PROGRAM_NAME  =  'COMMON'                       
                AND  G6.CMND_CODE     =  'DATE'                         
                AND  G6.SEQ_NO        =  20                             
                AND  G6.STATUS        =  'A'                            
                AND  G6.COMPANY_NO    =  '01'                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  G6.PARM_DATA                                               
MFA-TR*        INTO :G6-PARM-DATA                                               
MFA-TR*        FROM  CSS_JOB_PARM  G6                                           
MFA-TR*       WHERE  G6.PROGRAM_NAME  =  'COMMON'                               
MFA-TR*         AND  G6.CMND_CODE     =  'DATE'                                 
MFA-TR*         AND  G6.SEQ_NO        =  20                                     
MFA-TR*         AND  G6.STATUS        =  'A'                                    
MFA-TR*         AND  G6.COMPANY_NO    =  '01'                                   
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 6590                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  ERRORS-4114                TO TRUE                   
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6590'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_JOB_PARM'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCT-NO-4114            TO HOSTVAR-ELEMENT-1      
           END-IF.                                                      
      *                                                                         
       6590-CPD4114-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET COLUMNS USED IN PRORATION                               **        
      ******************************************************************        
      *                                                                         
       6600-GET-INCTV-PRORATE-CPD4114.                                  
      *                                                                         
           EXEC SQL                                                     
             SELECT  [2L].ATTR_PRO_CALC_CD                                
                    ,[2R].ATTR_PRO_FACTOR                                 
               INTO  :2L-ATTR-PRO-CALC-CD                               
                    ,:2R-ATTR-PRO-FACTOR                                
               FROM  CRM_ATTR_PRORATE    [2L] WITH(READUNCOMMITTED)             
                    ,CRM_ATTR_PRO_FCTR   [2R] WITH(READUNCOMMITTED)             
              WHERE [2L].COMPANY_NO          =  '01'                      
                AND [2L].TIER_ACCT_TYPE_CD   = :2L-TIER-ACCT-TYPE-CD      
                AND [2L].RT_ATTR_INCTV_TYPE  = :2L-RT-ATTR-INCTV-TYPE     
                AND [2L].DURATION_TOTAL_NO   = :2L-DURATION-TOTAL-NO      
                AND [2L].ATTR_PRO_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                  :2L-ATTR-PRO-START-DT
              ) IS NULL OR (PATINDEX('%.%', :2L-ATTR-PRO-START-DT
              ) <> 0) OR (LEN(:2L-ATTR-PRO-START-DT
              ) <> 10), CIS.CHAR2DATE(:2L-ATTR-PRO-START-DT
              ), CONVERT(DATE, :2L-ATTR-PRO-START-DT) )      
                AND [2L].ATTR_PRO_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                    :2L-ATTR-PRO-END-DT
              ) IS NULL OR (PATINDEX('%.%', :2L-ATTR-PRO-END-DT
              ) <> 0) OR (LEN(:2L-ATTR-PRO-END-DT
              ) <> 10), CIS.CHAR2DATE(:2L-ATTR-PRO-END-DT
              ), CONVERT(DATE, :2L-ATTR-PRO-END-DT) )        
                AND [2R].COMPANY_NO          =  [2L].COMPANY_NO             
                AND [2R].TIER_ACCT_TYPE_CD   =  [2L].TIER_ACCT_TYPE_CD      
                AND [2R].RT_ATTR_INCTV_TYPE  =  [2L].RT_ATTR_INCTV_TYPE     
                AND [2R].DURATION_TOTAL_NO   =  [2L].DURATION_TOTAL_NO      
                AND [2R].ATTR_PRO_START_DT   =  [2L].ATTR_PRO_START_DT      
                AND [2R].ATTR_PRO_MTH        = :2R-ATTR-PRO-MTH           
                AND [2R].DURATION_REMAIN_NO  = :2R-DURATION-REMAIN-NO     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  2L.ATTR_PRO_CALC_CD                                        
MFA-TR*             ,2R.ATTR_PRO_FACTOR                                         
MFA-TR*        INTO  :2L-ATTR-PRO-CALC-CD                                       
MFA-TR*             ,:2R-ATTR-PRO-FACTOR                                        
MFA-TR*        FROM  CRM_ATTR_PRORATE    2L                                     
MFA-TR*             ,CRM_ATTR_PRO_FCTR   2R                                     
MFA-TR*       WHERE 2L.COMPANY_NO          =  '01'                              
MFA-TR*         AND 2L.TIER_ACCT_TYPE_CD   = :2L-TIER-ACCT-TYPE-CD              
MFA-TR*         AND 2L.RT_ATTR_INCTV_TYPE  = :2L-RT-ATTR-INCTV-TYPE             
MFA-TR*         AND 2L.DURATION_TOTAL_NO   = :2L-DURATION-TOTAL-NO              
MFA-TR*         AND 2L.ATTR_PRO_START_DT  <= :2L-ATTR-PRO-START-DT              
MFA-TR*         AND 2L.ATTR_PRO_END_DT    >= :2L-ATTR-PRO-END-DT                
MFA-TR*         AND 2R.COMPANY_NO          =  2L.COMPANY_NO                     
MFA-TR*         AND 2R.TIER_ACCT_TYPE_CD   =  2L.TIER_ACCT_TYPE_CD              
MFA-TR*         AND 2R.RT_ATTR_INCTV_TYPE  =  2L.RT_ATTR_INCTV_TYPE             
MFA-TR*         AND 2R.DURATION_TOTAL_NO   =  2L.DURATION_TOTAL_NO              
MFA-TR*         AND 2R.ATTR_PRO_START_DT   =  2L.ATTR_PRO_START_DT              
MFA-TR*         AND 2R.ATTR_PRO_MTH        = :2R-ATTR-PRO-MTH                   
MFA-TR*         AND 2R.DURATION_REMAIN_NO  = :2R-DURATION-REMAIN-NO             
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 6600                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  ERRORS-4114                TO TRUE                   
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6600'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CRM_ATTR_PRORATE'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'TIER_ACCT_TYPE_CD'        TO TABLE-ELEMENT-2        
              MOVE 'RT_ATTR_INCTV_TYPE'       TO TABLE-ELEMENT-3        
              MOVE 'DURATION_TOTAL_NO'        TO TABLE-ELEMENT-4        
              MOVE WS-ACCT-NO-4114            TO HOSTVAR-ELEMENT-1      
              MOVE 2L-TIER-ACCT-TYPE-CD       TO HOSTVAR-ELEMENT-2      
              MOVE 2L-RT-ATTR-INCTV-TYPE      TO HOSTVAR-ELEMENT-3      
              MOVE 2L-DURATION-TOTAL-NO       TO HOSTVAR-ELEMENT-4      
           END-IF.                                                      
      *                                                                         
       6600-CPD4114-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET COLUMNS USED IN PRORATION - PRORATE MONTH = 0           **        
      ******************************************************************        
      *                                                                         
       6610-GET-INC-PRO-0-MTH-CPD4114.                                  
      *                                                                         
           EXEC SQL                                                     
             SELECT  [2L].ATTR_PRO_CALC_CD                                
                    ,[2R].ATTR_PRO_FACTOR                                 
               INTO  :2L-ATTR-PRO-CALC-CD                               
                    ,:2R-ATTR-PRO-FACTOR                                
               FROM  CRM_ATTR_PRORATE    [2L] WITH(READUNCOMMITTED)             
                    ,CRM_ATTR_PRO_FCTR   [2R] WITH(READUNCOMMITTED)             
              WHERE [2L].COMPANY_NO          =  '01'                      
                AND [2L].TIER_ACCT_TYPE_CD   = :2L-TIER-ACCT-TYPE-CD      
                AND [2L].RT_ATTR_INCTV_TYPE  = :2L-RT-ATTR-INCTV-TYPE     
                AND [2L].DURATION_TOTAL_NO   = :2L-DURATION-TOTAL-NO      
                AND [2L].ATTR_PRO_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                  :2L-ATTR-PRO-START-DT
              ) IS NULL OR (PATINDEX('%.%', :2L-ATTR-PRO-START-DT
              ) <> 0) OR (LEN(:2L-ATTR-PRO-START-DT
              ) <> 10), CIS.CHAR2DATE(:2L-ATTR-PRO-START-DT
              ), CONVERT(DATE, :2L-ATTR-PRO-START-DT) )      
                AND [2L].ATTR_PRO_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                    :2L-ATTR-PRO-END-DT
              ) IS NULL OR (PATINDEX('%.%', :2L-ATTR-PRO-END-DT
              ) <> 0) OR (LEN(:2L-ATTR-PRO-END-DT
              ) <> 10), CIS.CHAR2DATE(:2L-ATTR-PRO-END-DT
              ), CONVERT(DATE, :2L-ATTR-PRO-END-DT) )        
                AND [2R].COMPANY_NO          =  [2L].COMPANY_NO             
                AND [2R].TIER_ACCT_TYPE_CD   =  [2L].TIER_ACCT_TYPE_CD      
                AND [2R].RT_ATTR_INCTV_TYPE  =  [2L].RT_ATTR_INCTV_TYPE     
                AND [2R].DURATION_TOTAL_NO   =  [2L].DURATION_TOTAL_NO      
                AND [2R].ATTR_PRO_START_DT   =  [2L].ATTR_PRO_START_DT      
                AND [2R].DURATION_REMAIN_NO  = :2R-DURATION-REMAIN-NO     
                AND [2R].ATTR_PRO_MTH        =  0                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  2L.ATTR_PRO_CALC_CD                                        
MFA-TR*             ,2R.ATTR_PRO_FACTOR                                         
MFA-TR*        INTO  :2L-ATTR-PRO-CALC-CD                                       
MFA-TR*             ,:2R-ATTR-PRO-FACTOR                                        
MFA-TR*        FROM  CRM_ATTR_PRORATE    2L                                     
MFA-TR*             ,CRM_ATTR_PRO_FCTR   2R                                     
MFA-TR*       WHERE 2L.COMPANY_NO          =  '01'                              
MFA-TR*         AND 2L.TIER_ACCT_TYPE_CD   = :2L-TIER-ACCT-TYPE-CD              
MFA-TR*         AND 2L.RT_ATTR_INCTV_TYPE  = :2L-RT-ATTR-INCTV-TYPE             
MFA-TR*         AND 2L.DURATION_TOTAL_NO   = :2L-DURATION-TOTAL-NO              
MFA-TR*         AND 2L.ATTR_PRO_START_DT  <= :2L-ATTR-PRO-START-DT              
MFA-TR*         AND 2L.ATTR_PRO_END_DT    >= :2L-ATTR-PRO-END-DT                
MFA-TR*         AND 2R.COMPANY_NO          =  2L.COMPANY_NO                     
MFA-TR*         AND 2R.TIER_ACCT_TYPE_CD   =  2L.TIER_ACCT_TYPE_CD              
MFA-TR*         AND 2R.RT_ATTR_INCTV_TYPE  =  2L.RT_ATTR_INCTV_TYPE             
MFA-TR*         AND 2R.DURATION_TOTAL_NO   =  2L.DURATION_TOTAL_NO              
MFA-TR*         AND 2R.ATTR_PRO_START_DT   =  2L.ATTR_PRO_START_DT              
MFA-TR*         AND 2R.DURATION_REMAIN_NO  = :2R-DURATION-REMAIN-NO             
MFA-TR*         AND 2R.ATTR_PRO_MTH        =  0                                 
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 6610                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              SET  ERRORS-4114                TO TRUE                   
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6610'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CRM_ATTR_PRORATE'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'TIER_ACCT_TYPE_CD'        TO TABLE-ELEMENT-2        
              MOVE 'RT_ATTR_INCTV_TYPE'       TO TABLE-ELEMENT-3        
              MOVE 'DURATION_TOTAL_NO'        TO TABLE-ELEMENT-4        
              MOVE WS-ACCT-NO-4114            TO HOSTVAR-ELEMENT-1      
              MOVE 2L-TIER-ACCT-TYPE-CD       TO HOSTVAR-ELEMENT-2      
              MOVE 2L-RT-ATTR-INCTV-TYPE      TO HOSTVAR-ELEMENT-3      
              MOVE 2L-DURATION-TOTAL-NO       TO HOSTVAR-ELEMENT-4      
           END-IF.                                                      
      *                                                                         
       6610-CPD4114-EXIT.                                               
           EXIT.                                                        
      *                                                                         
