      *----------------------------------------------------------------*        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *----------------------------------------------------------------*        
      *                CUSTOMER INFORMATION SYSTEMS                    *        
      *----------------------------------------------------------------*        
      ******************************************************************00070000
      **--------------- P R O G R A M  S U M M A R Y ----------------- *00080000
      ***************************************************************  *00090000
      *  CPD03414:                                                     *00100000
      *  This is a new copybook to handle Reconnect agreement/Cancel   *00101000
      *  DNP/Payment Arrangement completion process.                   *00101100
      *                                                                *00102000
      *  Below are the programs presently use this copybook            *00112000
      *  Batch components  - SCS03414:                                 *        
      *  ----------------------------                                  *        
      *  PCSAC180/SCSAC180                                             *00113000
      *  Online components - MCS03414:                                 *        
      *  -----------------------------                                 *        
      *  CSR03413   CSR02341   CSR02294   CSR02300   CSR03707          *        
      *  CSR04894   CSR04906                                           *        
      ******************************************************************00120000
      *                                                                *00121000
      * PREREQUISITES: Below working storage variables should be       *00130000
      *                populated prior to invoking this routine.       *00140000
      *                                                                *00150000
      *                -------------------                             *        
      *                !!! BE CAREFUL !!!!                             *        
      *                -------------------                             *        
      *                                                                *00150000
      * WS-CALL-TYPE      - Default call type is 'O'.                  *        
      *                     'O' - Online; 'B' - Batch                  *        
      * WS-CPD68-REQUIRED - Default value is 'N'.                      *        
      *                     'Y' - Yes; 'N' - No                        *        
      * WS-PYMT-AMOUNT    - 1. Payment amount has to be passed from main        
      *                        program when cpd68 is not called in cpyc.00510000
      *                     2. If cpd68 is called in this cpyc & commit*        
      *                        has already taken then Payment amount   *        
      *                        should be 0.                            *        
      * WS-PROGRAM-NAME   - Will be used while generating WQ           *00240000
      *                                                                *00490000
      * Input:                                                         *00150000
      * ------                                                         *        
      * WS-ACCOUNT-NO                                                  *00240000
      * WS-UPDATE-ACTION-FL                                            *        
      * WS-FACILITY-CODE                                               *        
      * WS-PYMT-AMOUNT                                                 *        
      * WS-CALL-TYPE                                                   *        
      * WS-CPD68-REQUIRED                                              *        
      * WS-PROGRAM-NAME                                                *00240000
      * ws-APPL-PROGRAM-ID                                             *        
      *                                                                *00490000
      * Output:                                                        *00150000
      * -------                                                        *        
      * WS-DNP-RET-CODE                                                *        
      * WS-CPD68-ACTN-FL                                               *        
      * WS-CNCL-DNP-ACTN-FL                                            *        
      * WS-SO-UPDT-ACTN-FL                                             *        
      * WS-CRED-ARNG-ACTN-FL                                           *        
      * S-ACTIVE-PARAGRAPH                                             *        
      *                                                                *00510000
      * ACTION-FLAGS:                                                  *00510000
      *    if Action flag returns 'Y' then the respective module being *00102000
      *    called for process else 'N'.                                *00112000
      ******************************************************************00120000
      *                     PROGRAM MODIFICATION LOG                   *00500000
      *                                                                *00510000
      *    DATE    INITIALS   COMMENTS                                 *00520000
      *  --------  --------   ---------------------------------------  *00530000
ACT285*  10/26/16  AA97148    PROCEDURE ORIGINALLY CODED.              *00540000
      *                       Ref: APPL00005460                        *        
P00948*  01/01/17  VENKAT.P   SEND DNP CANCEL NOTIFICATION E-MAIL FOR  *        
P00948*                       CUSTOMERS WITH E-MAIL ADDRESS.           *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *   COMMON INITIALIZATION ROUTINE                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE 'N'                      TO WS-CPD68-ACTN-FL            
                                            WS-CNCL-DNP-ACTN-FL         
                                            WS-SO-UPDT-ACTN-FL          
                                            WS-CRED-ARNG-ACTN-FL.       
           MOVE 0                        TO WS-DNP-RET-CODE             
                                            S-RETURN-CODE               
                                            WS-ADEP-BALANCE             
                                            WS-DNP-COLLECT-AMT.         
           MOVE '0100'                   TO ACTIVE-PARAGRAPH.           
           MOVE SPACES                   TO ABEND-FUNCTION.             
                                                                        
           PERFORM 7500-SELECT-TIMESTAMP THRU 7500-EXIT.                
           MOVE 'DATABASE'               TO C8-DELINQ-CD.               
           MOVE '01'                     TO C8-COMPANY-NO.              
           PERFORM 7000-GET-DELINQ-VALUE THRU 7000-EXIT.                
           MOVE C8-DELINQ-VALUE          TO WS-DATABASE-SW.             
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      *   DECIDE THE PROCESS                                          *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
                                                                        
       1000-PROCESS-ACCOUNT.                                            
                                                                        
           MOVE '1000'                   TO ACTIVE-PARAGRAPH            
                                                                        
           MOVE WS-ACCOUNT-NO            TO AT-ACCOUNT-NO               
                                            CZ-ACCOUNT-NO               
                                            XK-ACCOUNT-NO               
                                            DL-ACCOUNT-NO               
                                            DO-ACCOUNT-NO               
                                            DR-ACCOUNT-NO               
                                            AC-ACCOUNT-NO               
                                                                        
           PERFORM 7200-SELECT-AT-DETAILS   THRU 7200-EXIT              
           MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
                                                                        
      * Call Cpd68 to get recent DNP balance                                    
           IF WS-CPD68-REQUIRED = 'Y'                                   
              PERFORM 2000-CALL-CPD00068    THRU 2000-EXIT              
              MOVE 'Y'                      TO WS-CPD68-ACTN-FL         
              MOVE ZEROES                   TO WS-PYMT-AMOUNT           
           END-IF.                                                      
                                                                        
           COMPUTE WS-DNP-COLLECT-AMT = WS-AMT-DNP-BAL - WS-PYMT-AMOUNT 
           SET RECONNECT-FULLY-PAID TO TRUE                             
                                                                        
      * FM006 reconnect process                                                 
           PERFORM 7010-SELECT-RECONNECT   THRU 7010-EXIT               
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              COMPUTE WS-DNP-COLLECT-AMT = DL-AMT-TOT-RECONNECT -       
                      DL-RECNCT-COLLECT-AMT - WS-PYMT-AMOUNT            
              IF DL-AUTO-DEP-CERT-NO > ZEROES                           
                 MOVE DL-AUTO-DEP-CERT-NO TO DO-DEPOSIT-CERT-NO         
                                             DR-DEP-ITEM-ID             
                                             AC-ITEM-ID                 
                 MOVE 'B'                 TO DO-CODE-DEP-TYPE           
                 MOVE 80                  TO AC-PYMT-PRIORITY-LVL       
                 PERFORM 7960-GET-AUTO-DEP-ON-HAND THRU 7960-EXIT       
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    PERFORM 7970-GET-AUTO-DEP-REQ THRU 7970-EXIT        
                    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
                       IF DR-DEP-BILL-OPTION-CD = 'I'                   
                          PERFORM 7980-GET-AMT-ADEP-BAL THRU 7980-EXIT  
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 IF DL-AUTO-DEP-AM > ZEROES AND AT-COMPANY-NO = '26'    
                    MOVE DL-AUTO-DEP-AM   TO WS-ADEP-BALANCE            
                 END-IF                                                 
              END-IF                                                    
              SUBTRACT WS-ADEP-BALANCE FROM WS-DNP-COLLECT-AMT          
                                                                        
              IF WS-DNP-COLLECT-AMT > ZEROS                             
                 MOVE 'N'                 TO WS-RECONNECT-FULLY-PAID    
                 IF WS-CODE-PENDING-DNP = WS-A                          
                    IF WS-PROGRAM-NAME = 'CSR03413' OR 'CSR03707'       
                       IF WS-PROGRAM-NAME = 'CSR03413'                  
                          IF WS-FACILITY-CODE = 'O' OR 'U'              
                             MOVE 5105    TO WS-DNP-RET-CODE            
                          END-IF                                        
                       END-IF                                           
                       IF WS-PROGRAM-NAME = 'CSR03707'                  
                          MOVE 0          TO WS-DNP-RET-CODE            
                       END-IF                                           
                    ELSE                                                
                       MOVE 5105          TO WS-DNP-RET-CODE            
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
                                                                        
      * DNP01 or DNPFB with fully paid reconnect                                
           IF WS-CODE-PENDING-DNP = WS-A AND RECONNECT-FULLY-PAID       
              IF WS-DNP-COLLECT-AMT <= WS-NOTICE-DNP-LIMIT              
                 MOVE 'Y'                TO WS-CNCL-DNP-ACTN-FL         
              ELSE                                                      
                 MOVE 'U'                TO WS-UPDATE-ACTION-FL         
                 MOVE 'N'                TO WS-CNCL-DNP-ACTN-FL         
                 MOVE 'Y'                TO WS-SO-UPDT-ACTN-FL          
                 IF WS-PROGRAM-NAME = 'CSR03413' OR 'CSR03707'          
                    IF WS-PROGRAM-NAME = 'CSR03413'                     
                       IF WS-FACILITY-CODE = 'O' OR 'U'                 
                          MOVE 5105    TO WS-DNP-RET-CODE               
                       END-IF                                           
                    END-IF                                              
                    IF WS-PROGRAM-NAME = 'CSR03707'                     
                       MOVE 0          TO WS-DNP-RET-CODE               
                    END-IF                                              
                 ELSE                                                   
                    MOVE 5105          TO WS-DNP-RET-CODE               
                 END-IF                                                 
                 PERFORM 9510-CALL-CPDCB371     THRU 9510-EXIT          
              END-IF                                                    
           END-IF                                                       
                                                                        
      * cancel DNP order & make the reconnect to active/turndown status         
           IF WS-CNCL-DNP-ACTN-FL = 'Y'                                 
              EVALUATE WS-FACILITY-CODE                                 
                  WHEN 'W'                                              
                  WHEN 'B'                                              
                  WHEN 'M'                                              
                  WHEN 'D'                                              
                  WHEN 'E'                                              
                  WHEN 'O'                                              
                  WHEN 'X'                                              
                     PERFORM 1050-PROCESS-ACTIVE THRU 1050-EXIT         
                  WHEN OTHER                                            
                     PERFORM 1025-TURNDOWN-OR-ACTIVE THRU 1025-EXIT     
              END-EVALUATE                                              
           END-IF.                                                      
      *                                                                 13361000
      * Complete Payment Arrangements on Payment posting                13361000
           IF WS-CODE-CRED-ARNG = 'A' OR WS-CODE-STA-ACCT = 'A'         
              PERFORM 2950-PROCESS-CRED-ARNG      THRU 2950-EXIT        
              MOVE 'Y'                      TO WS-CRED-ARNG-ACTN-FL     
           END-IF.                                                      
P00948*                                                                 13361000
P00948* Send E-mail notification when DNP Cancelled                     13361000
P00948     IF AT-ACCOUNT-TYPE-CODE     = 'R' AND CSR-DATABASE AND       
P00948        WS-CNCL-DNP-EMAIL-REQ-FL = 'Y' AND                        
P00948        WS-CNCL-DNP-ACTN-FL      = 'Y' AND                        
P00948        WS-ORDER-TYPE-CD         = 'DNP01'                        
P00948        PERFORM 1075-SEND-NOTIFICATION THRU 1075-EXIT             
P00948     END-IF.                                                      
      *                                                                 13361000
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * SERVICE ORDER UPDATE TO 'TURNED DOWN CUSTOMER' OR 'ACTIVE'    *         
      * DEPENDING ON THE CRITERIA.                                    *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       1025-TURNDOWN-OR-ACTIVE.                                         
      *-----------------------*                                                 
           MOVE AT-ACCOUNT-NO            TO VO-ACCOUNT-NO-PRIOR         
           SET DNP-ERROR                 TO TRUE                        
                                                                        
           PERFORM 7300-SELECT-DNP-TYPE                                 
              THRU 7300-EXIT                                            
                                                                        
           PERFORM 1200-POPULATE-VALUES                                 
              THRU 1200-EXIT                                            
                                                                        
           PERFORM 2100-UPDATE-SERVICE-ORDER                            
              THRU 2100-EXIT                                            
           .                                                            
       1025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * RECONNECT ACTIVE PROCESS                                      *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       1050-PROCESS-ACTIVE.                                             
      *--------------------*                                                    
           SET RECONNECT-ERROR TO TRUE                                  
           PERFORM 2600-PROCESS-RECONNECT                               
              THRU 2600-EXIT                                            
                                                                        
           IF WS-RECONNECT-IND = 'Y'                                    
              MOVE 'B' TO WS-SO-ORDER-TYPE-FLAG                         
              MOVE 'DNPFB' TO WS-ORDER-TYPE-CD                          
           END-IF                                                       
                                                                        
           IF WS-RECONNECT-IND = 'N' AND WS-ORDER-TYPE-CD = 'DNPFB'     
              MOVE 5135  TO WS-DNP-RET-CODE                             
           END-IF                                                       
                                                                        
           SET DNP-ERROR TO TRUE                                        
           MOVE 'S' TO WS-SO-SELECT-UPDATE-C                            
           PERFORM 2700-UPDATE-DNP                                      
              THRU 2700-EXIT                                            
                                                                        
           IF WS-IND-07 = -1                                            
              MOVE WS-ORDER-REASON-TEMP TO WS-ORDER-REASON              
           END-IF                                                       
                                                                        
           IF RETURN-CODE-5000                                          
              MOVE 'Y'   TO WS-RETURN-FLAG                              
              MOVE 0357  TO WS-DNP-RET-CODE                             
              IF CSR-DATABASE                                           
                 SET DNP-COMPLETE-WQ    TO TRUE                         
                 PERFORM 2200-CREATE-WQ THRU 2200-EXIT                  
                 GO TO 1050-EXIT                                        
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF RETURN-CODE-100                                           
              MOVE 5105  TO WS-DNP-RET-CODE                             
              GO TO 1050-EXIT                                           
           END-IF                                                       
                                                                        
           PERFORM 2400-PROCESS-WORK-QUEUE                              
              THRU 2400-EXIT                                            
                                                                        
           IF WS-RETURN-FLAG = 'Y'                                      
              GO TO 1050-EXIT                                           
           END-IF                                                       
                                                                        
           MOVE 'U' TO WS-SO-SELECT-UPDATE-C                            
           PERFORM 2700-UPDATE-DNP                                      
              THRU 2700-EXIT                                            
                                                                        
           IF WS-ORDER-TYPE-CD = 'DNPFB'                                
              MOVE 'N'   TO WS-UPDATE-PROFILE                           
           ELSE                                                         
              MOVE 'Y'   TO WS-UPDATE-PROFILE                           
           END-IF                                                       
                                                                        
           PERFORM 9830-CALL-CSR02122                                   
              THRU 9830-EXIT                                            
                                                                        
           IF WS-RETURN-CODE < 0                                        
              CONTINUE                                                  
           ELSE                                                         
              IF WS-RETURN-CODE = 0 AND                                 
                 WS-ORDER-TYPE-CD NOT EQUAL 'DNPFB'                     
                   MOVE 0790 TO WS-DNP-RET-CODE                         
              END-IF                                                    
           END-IF                                                       
           .                                                            
       1050-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00948*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
P00948* SEND EMAIL NOTIFICATIONS                                      *         
P00948*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
P00948 1075-SEND-NOTIFICATION.                                          
P00948*----------------------*                                                  
P00948     MOVE '1075'                   TO ACTIVE-PARAGRAPH            
P00948*                                                                         
P00948     MOVE ZERO                     TO NE-CUSTOMER-NO.             
P00948     PERFORM 7985-SEL-EMAIL-ID        THRU 7985-EXIT.             
P00948     IF NE-CUSTOMER-NO > 0                                        
P00948*       set BATCH-EMAIL-ID - An Unique# from a sequence object            
P00948        PERFORM 7990-SET-EMAIL-ID     THRU 7990-EXIT              
P00948        MOVE AT-ACCOUNT-NO         TO AE-ACCOUNT-NO               
P00948        MOVE AT-CUSTOMER-NO        TO AE-CUSTOMER-NO              
P00948        MOVE AT-COMPANY-NO         TO AE-COMPANY-NO               
P00948        MOVE 'CIS58'               TO AE-EMAIL-EVENT-CD           
P00948        MOVE WS-CURRENT-DATE-USA   TO AE-EMAIL-EVENT-DT           
P00948        PERFORM 8850-INS-BATCH-EMAIL  THRU 8850-EXIT              
P00948*                                                                         
P00948        MOVE AE-BATCH-EMAIL-ID     TO JK-BATCH-EMAIL-ID           
P00948        MOVE '1-PAYMENT-AMT'       TO JK-FIELD-NAME-TX            
P00948        MOVE WS-PYMT-AMOUNT-HOLD   TO WS-COMP-2-CHAR-CONV-EDT1    
P00948        MOVE WS-COMP-2-CHAR-CONV-EDT1 TO JK-FIELD-VALUE-TX-TEXT   
P00948        MOVE LENGTH OF JK-FIELD-VALUE-TX-TEXT                     
P00948                                   TO JK-FIELD-VALUE-TX-LEN       
P00948        PERFORM 8860-INS-BATCH-EMAIL-DET THRU 8860-EXIT           
P00948        MOVE '2-PAYMENT-DT'        TO JK-FIELD-NAME-TX            
P00948        MOVE WS-CURRENT-DATE-USA   TO JK-FIELD-VALUE-TX-TEXT      
P00948        MOVE 10                    TO JK-FIELD-VALUE-TX-LEN       
P00948        PERFORM 8860-INS-BATCH-EMAIL-DET THRU 8860-EXIT           
P00948     END-IF.                                                      
P00948 1075-EXIT.                                                       
P00948     EXIT.                                                        
P00948                                                                  
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * POPULATE VALUES FOR TURN DOWN CUSTOMERS                       *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       1200-POPULATE-VALUES.                                            
      *---------------------*                                                   
                                                                        
           MOVE '1200'                   TO ACTIVE-PARAGRAPH            
                                                                        
           IF WS-ORDER-TYPE-CD = WS-DNPFB                               
              MOVE WS-B                  TO WS-SO-ORDER-TYPE-FLAG       
              SET WS-DNP-FINALBILL       TO TRUE                        
           ELSE                                                         
              MOVE WS-A                  TO WS-SO-ORDER-TYPE-FLAG       
              SET WS-DNP01               TO TRUE                        
           END-IF                                                       
                                                                        
           MOVE 'S336'                   TO WS-SO-PANEL-NO.             
           .                                                            
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15900000
      * 2000-CALL-CPD00068                                             *15910000
      ******************************************************************15920000
                                                                        
       2000-CALL-CPD00068.                                              
                                                                        
           MOVE WS-CURRENT-DATE     TO WS-CL-DATE-NOTICE-MAIL           
                                       WS-CL-DATE-NOTICE-DUE            
                                       WS-HOLD-DATE.                    
                                                                        
           MOVE 'Y'                 TO CALC-ARREARS-SW                  
                                       CALC-PAST-DUE-SW                 
                                       CALC-DNP-BAL-SW                  
                                       CALC-BALANCE-SW                  
                                       CALC-NOT-BAL-SW.                 
                                                                        
           MOVE PROGRAM-NAME        TO WS-CPD00068-CALLING-PGM.         
           MOVE SPACES              TO ABEND-FUNCTION.                  
                                                                        
           PERFORM 9500-CALL-CPD00068  THRU 9500-EXIT.                  
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * UPDATE SERVICE ORDER STATUS                                   *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       2100-UPDATE-SERVICE-ORDER.                                       
      *--------------------------*                                              
                                                                        
           MOVE '2100'                   TO ACTIVE-PARAGRAPH            
                                                                        
           PERFORM 2700-UPDATE-DNP                                      
              THRU 2700-EXIT                                            
                                                                        
           EVALUATE WS-SO-RETURN-CD                                     
             WHEN 0                                                     
                  SET SO-UPDATE-WORKED   TO TRUE                        
             WHEN 5000                                                  
                  IF SEB-DATABASE                                       
                     SET PAID-SENT       TO TRUE                        
                  ELSE                                                  
                     IF CSR-DATABASE                                    
                        SET DNP-COMPLETE-WQ    TO TRUE                  
                        PERFORM 2200-CREATE-WQ THRU 2200-EXIT           
                        GO TO 2100-EXIT                                 
                     END-IF                                             
                  END-IF                                                
             WHEN 100                                                   
                  IF WS-SO-ORDER-TYPE-FLAG = 'A'                        
                     MOVE 'B'            TO WS-SO-ORDER-TYPE-FLAG       
                     PERFORM 2300-FIND-DNPFB                            
                        THRU 2300-EXIT                                  
                     IF WS-DNPFB-RETURN-CD = SUCCESSFUL-CALL            
                        IF CSR-DATABASE                                 
                           SET DNPFB-WQ TO TRUE                         
                           PERFORM 2200-CREATE-WQ                       
                              THRU 2200-EXIT                            
                        END-IF                                          
                     END-IF                                             
                  END-IF                                                
             WHEN OTHER                                                 
                  SET SO-UPDATE-NOT-WORKED TO TRUE                      
           END-EVALUATE                                                 
                                                                        
           IF WS-INSERT-WORK-QUEUE = 'Y'                                
              IF WS-FACILITY-CODE = 'P' OR 'H' OR 'J' OR 'K' OR 'N'     
                                               OR 'I'                   
                 IF WS-DNP01 AND SO-UPDATE-WORKED                       
                    SET DNP-CANCEL-WQ TO TRUE                           
                 END-IF                                                 
                 PERFORM 2400-PROCESS-WORK-QUEUE                        
                    THRU 2400-EXIT                                      
              ELSE                                                      
                 IF (WS-DNP01 AND SO-UPDATE-WORKED)                     
                    AND CSR-DATABASE                                    
                   SET DNP-CANCEL-WQ TO TRUE                            
                   PERFORM 2500-DISPATCHER-WQ                           
                      THRU 2500-EXIT                                    
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF (WS-DNP01) AND (WS-FACILITY-CODE = 'U') AND               
                           (SO-UPDATE-WORKED OR PAID-SENT)              
              MOVE 0790                 TO WS-DNP-RET-CODE              
           END-IF                                                       
                                                                        
           IF SO-UPDATE-WORKED                                          
             MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT        
             MOVE SPACES                TO WS-CODE-PENDING-DNP          
             MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT        
                                                                        
             PERFORM 8400-UPDATE-ACCOUNT                                
                THRU 8400-EXIT                                          
             PERFORM 7600-SELECT-CREDIT-PROFILE                         
                THRU 7600-EXIT                                          
                                                                        
             MOVE WS-RESOLVED        TO WS-TEMP-HIST                    
             MOVE 1                  TO WS-TEMP-HIST-NUM                
                                                                        
             IF (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                AND WS-ORDER-TYPE-CD  NOT = 'DNPFB')                    
                                                                        
                EVALUATE WS-ORDER-REASON                                
                   WHEN 'N'                                             
                   WHEN 'O'                                             
                   WHEN 'J'                                             
                   WHEN 'K'                                             
                   WHEN 'U'                                             
                   WHEN 'V'                                             
                        MOVE WS-TEMP-HIST                               
                          TO CZ-DISCONNECT-HIST(WS-TEMP-HIST-NUM:1)     
                   WHEN OTHER                                           
                        MOVE WS-TEMP-HIST                               
                          TO CZ-DISC-EXCEPTN-HIST(WS-TEMP-HIST-NUM:1)   
                END-EVALUATE                                            
                                                                        
                PERFORM 8500-UPDATE-CREDIT-PROFILE                      
                   THRU 8500-EXIT                                       
             END-IF                                                     
                                                                        
             MOVE AT-PREMISE-NO         TO PR-PREMISE-NO                
             MOVE WS-PENDING-DNP-FLAG   TO PR-SERV-ORDER-PEND           
             PERFORM 8600-UPDATE-PREMISE                                
                THRU 8600-EXIT                                          
           END-IF                                                       
                                                                        
           IF WS-DNP-FINALBILL                                          
              SET RECONNECT-ERROR TO TRUE                               
              PERFORM 2800-GET-RECONNECT   THRU 2800-EXIT               
              IF WS-FACILITY-CODE = 'U'                                 
                 IF WS-RCNCT-RETURN-CD = 0                              
                    MOVE 5137              TO WS-DNP-RET-CODE           
                 ELSE                                                   
                    MOVE 5135              TO WS-DNP-RET-CODE           
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
           .                                                            
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * POPULATE VALUAES AND CREATE WQ                                *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       2200-CREATE-WQ.                                                  
      *---------------*                                                         
           MOVE '2200'                TO ACTIVE-PARAGRAPH               
                                                                        
           MOVE '1'                   TO WS-WQ-ROUTING-CATGRY-C         
           MOVE AT-LOCAL-OFFICE       TO WS-WQ-LOCAL-OFFICE-C           
           MOVE 'SYSTEM'              TO WS-WQ-USER-ID-ORIG-C           
           MOVE SPACES                TO WS-WQ-USER-ID-ASGN-C           
           MOVE WS-RESP-AREA-ID       TO WS-WQ-RESP-AREA-ID-C           
           MOVE AT-ACCOUNT-NO         TO WS-WQ-ACCOUNT-NO-D             
           MOVE WS-WQ-ACCOUNT-NO-D    TO WS-WQ-ACCOUNT-NO-I             
           MOVE AT-PREMISE-NO         TO WS-WQ-PREMISE-NO-D             
           MOVE WS-WQ-PREMISE-NO-D    TO WS-WQ-PREMISE-NO-I             
           MOVE AT-CUSTOMER-NO        TO WS-WQ-CUSTOMER-NO-D            
           MOVE WS-WQ-CUSTOMER-NO-D   TO WS-WQ-CUSTOMER-NO-I            
           MOVE WS-CURR-TIMESTAMP     TO WS-WQ-DATE-REQUIRED            
           MOVE WS-CURR-TIMESTAMP     TO WS-WQ-DATE-CREATED             
           MOVE 'H'                   TO WS-WQ-PRIORITY-C               
           MOVE ZEROES                TO WS-WQ-FREE-FORM-LEN            
           MOVE LOW-VALUES            TO WS-WQ-FREE-FORM-TEXT           
           MOVE WS-SERV-ORDER-CHAR    TO WS-WQ-SERV-ORDER-NO-C          
           MOVE WS-WQ-SERV-ORDER-NO-I TO WS-WQ-SERV-ORDER-NO-D          
                                                                        
           EVALUATE WS-WORK-QUEUE-SW                                    
               WHEN 'B'                                                 
                    MOVE 160                  TO WS-WQ-CATEGORY-ID-D    
                    MOVE +84                  TO WS-WQ-COMMENTS-LEN     
                    MOVE WS-WQ-DNP-COMPLETE   TO WS-WQ-COMMENTS-TEXT    
               WHEN 'C'                                                 
                    MOVE ZEROES               TO WS-WQ-SERV-ORDER-NO-D  
                    MOVE 31                   TO WS-WQ-CATEGORY-ID-D    
                    MOVE +41                  TO WS-WQ-COMMENTS-LEN     
                    MOVE WS-WQ-DNPFB-MSG      TO WS-WQ-COMMENTS-TEXT    
               WHEN 'D'                                                 
                    MOVE 31                   TO WS-WQ-CATEGORY-ID-D    
                    MOVE +148                 TO WS-WQ-COMMENTS-LEN     
                    MOVE WS-N-WQ-DNP-COMPLETE TO WS-WQ-COMMENTS-TEXT    
           END-EVALUATE                                                 
                                                                        
           PERFORM 9850-CALL-CSR04675                                   
              THRU 9850-EXIT                                            
           .                                                            
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * FIND FINALBILL                                                *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       2300-FIND-DNPFB.                                                 
      *---------------*                                                         
           MOVE '2300' TO ACTIVE-PARAGRAPH                              
                                                                        
           MOVE AT-ACCOUNT-NO                  TO VO-ACCOUNT-NO         
           MOVE WS-SO-REMARK-MSG               TO WS-SO-REMARK-TX-TEXT  
           MOVE LENGTH OF WS-SO-REMARK-TX-TEXT TO WS-SO-REMARK-TX-LEN   
                                                                        
           PERFORM 7310-SELECT-DNPFB                                    
              THRU 7310-EXIT                                            
           .                                                            
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * CREATE WQ                                                     *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       2400-PROCESS-WORK-QUEUE.                                         
      *------------------------*                                                
           MOVE '2400'                 TO ACTIVE-PARAGRAPH              
                                                                        
           IF WS-INSERT-WORK-QUEUE = 'Y'                                
              PERFORM 9870-CALL-CSR00423                                
                 THRU 9870-EXIT                                         
                                                                        
              IF WS-ORDER-TYPE-CD = 'DNPFB'                             
                 MOVE 'DNP ORDER FOR DNPFB' TO WS-COMMENTS              
              ELSE                                                      
                 IF WS-WORK-AREA = SPACES AND WS-CREW-ID = SPACES       
                    MOVE 'DNP ORDER CANCELLED' TO WS-COMMENTS           
                 ELSE                                                   
                    IF WS-CREW-ID = SPACES                              
                       STRING 'DNP ORDER CANCELLED,DNP WORK AREA WAS '  
                              DELIMITED BY SIZE WS-WORK-AREA            
                              DELIMITED BY SIZE                         
                         INTO WS-COMMENTS                               
                    ELSE                                                
                       STRING 'DNP ORDER CANCELLED,DNP CREW ID WAS '    
                              DELIMITED BY SIZE WS-CREW-ID              
                              DELIMITED BY SIZE                         
                         INTO WS-COMMENTS                               
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF WS-RETURN-FLAG = 'Y'                                   
                 STRING 'PAYMENT RECEIVED,DNP STATE IS COMPLETE, '      
                        DELIMITED BY SIZE                               
                        'POST ORDER AND REVIEW FOR POSSIBLE RECONNECT'  
                        DELIMITED BY SIZE                               
                   INTO WS-COMMENTS                                     
              END-IF                                                    
                                                                        
              PERFORM 2500-DISPATCHER-WQ                                
                 THRU 2500-EXIT                                         
           END-IF                                                       
           .                                                            
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * POPULATE VALUES AND INSERT WQ                                 *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       2500-DISPATCHER-WQ.                                              
      *-------------------*                                                     
           MOVE '2500'                 TO ACTIVE-PARAGRAPH              
                                                                        
           MOVE '1'                    TO WS-WQ-ROUTING-CATGRY-C        
           MOVE AT-LOCAL-OFFICE        TO WS-WQ-LOCAL-OFFICE-C          
           MOVE 'BATCH'                TO WS-WQ-USER-ID-ORIG-C          
           MOVE SPACES                 TO WS-WQ-USER-ID-ASGN-C          
           MOVE WS-RESP-AREA-ID        TO WS-WQ-RESP-AREA-ID-C          
           MOVE 31                     TO WS-WQ-CATEGORY-ID-D           
           MOVE AT-ACCOUNT-NO          TO WS-WQ-ACCOUNT-NO-D            
           MOVE WS-WQ-ACCOUNT-NO-D     TO WS-WQ-ACCOUNT-NO-I            
           MOVE AT-PREMISE-NO          TO WS-WQ-PREMISE-NO-D            
           MOVE WS-WQ-PREMISE-NO-D     TO WS-WQ-PREMISE-NO-I            
           MOVE AT-CUSTOMER-NO         TO WS-WQ-CUSTOMER-NO-D           
           MOVE WS-WQ-CUSTOMER-NO-D    TO WS-WQ-CUSTOMER-NO-I           
           MOVE WS-SERV-ORDER-CHAR     TO WS-WQ-SERV-ORDER-NO-C         
           MOVE WS-WQ-SERV-ORDER-NO-I  TO WS-WQ-SERV-ORDER-NO-D         
           MOVE +41                    TO WS-WQ-COMMENTS-LEN            
           MOVE WS-WQ-COMMENTS-MSG     TO WS-WQ-COMMENTS-TEXT           
           MOVE WS-CURR-TIMESTAMP      TO WS-WQ-DATE-REQUIRED           
           MOVE WS-CURR-TIMESTAMP      TO WS-WQ-DATE-CREATED            
           MOVE WS-H                   TO WS-WQ-PRIORITY-C              
           MOVE +20                    TO WS-WQ-FREE-FORM-LEN           
           MOVE 'DISCONNECT CANCELLED' TO WS-WQ-FREE-FORM-TEXT          
                                                                        
           PERFORM 9850-CALL-CSR04675                                   
              THRU 9850-EXIT                                            
           .                                                            
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * PROCESS RECONNECT                                             *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       2600-PROCESS-RECONNECT.                                          
      *-----------------------*                                                 
                                                                        
           PERFORM 9810-CALL-CSR00336                                   
              THRU 9810-EXIT                                            
                                                                        
           IF WS-RETURN-CODE = 100 OR WS-ORDER-STATE-CD = 'Z'           
              GO TO 2600-EXIT                                           
           ELSE                                                         
              IF WS-RETURN-CODE = 0 AND WS-ORDER-STATE-CD = 'H'         
                 MOVE 'Y'         TO WS-RECONNECT-IND                   
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF WS-ORDER-STATE-CD = 'B' OR 'D'                            
              MOVE 'B'            TO WS-SO-ORDER-TYPE-FLAG              
              MOVE 'DNPFB'        TO WS-ORDER-TYPE-CD                   
              GO TO 2600-EXIT                                           
           ELSE                                                         
              PERFORM 9820-CALL-CSR00337                                
                 THRU 9820-EXIT                                         
              IF WS-RETURN-CODE = 0                                     
                 MOVE 5137 TO WS-DNP-RET-CODE                           
                 GO TO 2600-EXIT                                        
              ELSE                                                      
                 IF WS-RETURN-CODE = 200                                
                    GO TO 2600-EXIT                                     
                 END-IF                                                 
              END-IF                                                    
              MOVE 'A' TO WS-SO-ORDER-TYPE-FLAG                         
           END-IF                                                       
           .                                                            
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * UPDATE DNP/DNPFB STATUS                                       *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       2700-UPDATE-DNP.                                                 
      *----------------*                                                        
                                                                        
           MOVE '2700'                         TO ACTIVE-PARAGRAPH      
                                                                        
           MOVE AT-ACCOUNT-NO                  TO WS-SO-ACCOUNT-NO-I    
           MOVE AT-PREMISE-NO                  TO WS-SO-PREMISE-NO-I    
           MOVE WS-SO-REMARK-MSG               TO WS-SO-REMARK-TX-TEXT  
           MOVE LENGTH OF WS-SO-REMARK-TX-TEXT TO WS-SO-REMARK-TX-LEN   
                                                                        
           MOVE '9999999999999'                TO WS-SERV-ORDER-CHAR    
           MOVE '999'                          TO WS-RESP-AREA-ID       
           MOVE WS-RESOLVED   TO WS-SO-DNP-CANCEL-REASON                
                                                                        
           PERFORM 9800-CALL-CSR00125                                   
              THRU 9800-EXIT                                            
                                                                        
      *    EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE            
      *      CSR00125                                                   
      *    END-EXEC                                                     
                                                                        
      *    EXEC SQL ALLOCATE C1 CURSOR FOR RESULT SET :LOC1             
      *    END-EXEC                                                     
                                                                        
           EXEC SQL                                                     
              FETCH C1 INTO                                             
                    :WS-SO-RETURN-CD :WS-IND-05                    
                   ,:WS-SERV-ORDER-CHAR :WS-IND-06                    
                   ,:WS-ORDER-REASON :WS-IND-07                    
                   ,:WS-RESP-AREA-ID :WS-IND-08                    
                   ,:WS-PENDING-DNP-FLAG :WS-IND-09                    
                   ,:WS-INSERT-WORK-QUEUE                               
                   ,:WS-AMOUNT-DISC-BAL :WS-IND-10                    
                   ,:WS-ORDER-TYPE-CD                                   
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-IND-05 = -1                                         
                 MOVE 0                     TO WS-SO-RETURN-CD          
              END-IF                                                    
                                                                        
              IF WS-IND-06 = -1                                         
                 MOVE SPACES                TO WS-SERV-ORDER-CHAR       
              END-IF                                                    
                                                                        
              IF WS-IND-07 = -1                                         
                 MOVE SPACES                TO WS-ORDER-REASON          
              END-IF                                                    
                                                                        
              IF WS-IND-08 = -1                                         
                 MOVE SPACES                TO WS-RESP-AREA-ID          
              END-IF                                                    
                                                                        
              IF WS-IND-09 = -1                                         
                 MOVE SPACES                TO WS-PENDING-DNP-FLAG      
              END-IF                                                    
                                                                        
              IF WS-IND-10 = -1                                         
                 MOVE 0                     TO WS-AMOUNT-DISC-BAL       
              END-IF                                                    
                                                                        
              MOVE SPACES                   TO WS-RETURN-CD-SW          
                                                                        
              EVALUATE WS-SO-RETURN-CD                                  
                WHEN 0                                                  
                     SET SO-UPDATE-WORKED   TO TRUE                     
                WHEN 5000                                               
                     SET RETURN-CODE-5000   TO TRUE                     
                WHEN 100                                                
                     SET RETURN-CODE-100    TO TRUE                     
                WHEN OTHER                                              
                     MOVE 'CSR00125 FAILED' TO ABEND-FUNCTION           
                     MOVE WS-SO-RETURN-CD   TO WS-ACTIVE-RETURN-CODE    
                     MOVE PROGRAM-NAME      TO ABEND-PROGRAM            
                     MOVE 'CSR00125'        TO TABLE-1                  
                     MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1          
                     MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1        
                     PERFORM 9100-TERMINATE                             
                        THRU 9100-EXIT                                  
              END-EVALUATE                                              
           ELSE                                                         
              MOVE '2700'                  TO ACTIVE-PARAGRAPH          
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE 'FETCH'                 TO ABEND-FUNCTION            
              MOVE 'CSR00125'              TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              MOVE 'SQLCODE '              TO TABLE-ELEMENT-2           
              MOVE WS-ACTIVE-RETURN-CODE   TO HOSTVAR-ELEMENT-2         
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
              CLOSE C1                                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '2700'                  TO ACTIVE-PARAGRAPH          
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE 'CLOSE'                 TO ABEND-FUNCTION            
              MOVE 'CSR00125'              TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              MOVE 'SQLCODE '              TO TABLE-ELEMENT-2           
              MOVE WS-ACTIVE-RETURN-CODE   TO HOSTVAR-ELEMENT-2         
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
P00948     IF WS-SO-SELECT-UPDATE-C = 'U'                               
P00948        IF SO-UPDATE-WORKED                                       
P00948           CONTINUE                                               
P00948        ELSE                                                      
P00948           MOVE SPACES               TO WS-CNCL-DNP-ACTN-FL       
P00948        END-IF                                                    
P00948     END-IF                                                       
           .                                                            
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * UPDATE RECONNECT STATUS                                       *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       2800-GET-RECONNECT.                                              
      *-------------------*                                                     
           MOVE '2800'                         TO ACTIVE-PARAGRAPH      
                                                                        
           MOVE AT-ACCOUNT-NO                  TO VO-ACCOUNT-NO         
           MOVE WS-SO-REMARK-MSG               TO WS-SO-REMARK-TX-TEXT  
           MOVE LENGTH OF WS-SO-REMARK-TX-TEXT TO WS-SO-REMARK-TX-LEN   
                                                                        
           PERFORM 9860-CALL-CSR04422                                   
              THRU 9860-EXIT                                            
                                                                        
      *    EXEC SQL ASSOCIATE LOCATORS(:LOC4) WITH PROCEDURE            
      *      CSR04422                                                   
      *    END-EXEC                                                     
                                                                        
      *    EXEC SQL ALLOCATE C4 CURSOR FOR RESULT SET :LOC4             
      *    END-EXEC                                                     
                                                                        
           EXEC SQL                                                     
           FETCH C4 INTO                                                
                 :WS-RCNCT-RETURN-CD :WS-IND-11                       
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-IND-11 = -1                                         
                 MOVE 0                       TO WS-RCNCT-RETURN-CD     
              END-IF                                                    
                                                                        
              EVALUATE WS-RCNCT-RETURN-CD                               
                 WHEN 0                                                 
                      SET SO-UPDATE-WORKED    TO TRUE                   
                 WHEN 100                                               
                      CONTINUE                                          
                 WHEN OTHER                                             
                      MOVE 'CSR04422 FAILED'  TO ABEND-FUNCTION         
                      MOVE WS-RCNCT-RETURN-CD TO WS-ACTIVE-RETURN-CODE  
                      MOVE PROGRAM-NAME       TO ABEND-PROGRAM          
                      MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1        
                      MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1      
                      MOVE 'SQLCODE '         TO TABLE-ELEMENT-2        
                      MOVE WS-RCNCT-RETURN-CD TO HOSTVAR-ELEMENT-2      
                      PERFORM 9100-TERMINATE                            
                         THRU 9100-EXIT                                 
              END-EVALUATE                                              
           ELSE                                                         
              MOVE '2800'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSR04422'                 TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'SQLCODE '                 TO TABLE-ELEMENT-2        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-2      
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
              CLOSE C4                                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '2800'                    TO ACTIVE-PARAGRAPH        
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSR04422'                TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'SQLCODE '                TO TABLE-ELEMENT-2         
              MOVE WS-ACTIVE-RETURN-CODE     TO HOSTVAR-ELEMENT-2       
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
           .                                                            
       2800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*          
      * COMPLETE CREDIT ARRANGEMENTS WHEN THE PAYMENT IS POSTED.     *          
      *--------------------------------------------------------------*          
       2950-PROCESS-CRED-ARNG.                                          
      *                                                                         
           MOVE AT-ACCOUNT-NO                  TO X1-ACCOUNT-NO         
                                                  WY-ACCOUNT-NO.        
           MOVE 'N'                            TO WS-ARNG-COMPLIANCE-CD.
           PERFORM 7675-SELECT-ACTIVE-ARNG     THRU 7675-EXIT.          
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 2960-CHECK-ARNG-COMPL-LIMIT THRU 2960-EXIT        
           END-IF.                                                      
           IF WS-ARNG-COMPLIANCE-CD = 'Y'                               
              PERFORM 8450-UPDATE-CRED-ARNG    THRU 8450-EXIT           
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 2975-POPULATE-ARNG-HIST-DTLS                   
                                               THRU 2975-EXIT           
                 PERFORM 8800-INSERT-ARNG-HIST THRU 8800-EXIT           
                 PERFORM 2980-WRITE-ARNG-TRANS-HIST                     
                                               THRU 2980-EXIT           
                 MOVE AT-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT 
                 IF WS-CODE-STA-ACCT = 'A'                              
                    MOVE SPACES                   TO WS-CODE-STA-ACCT   
                 ELSE                                                   
                    MOVE SPACES                   TO WS-CODE-CRED-ARNG  
                 END-IF                                                 
                 MOVE WS-CODES-DATA-PRESENT    TO AT-CODES-DATA-PRESENT 
                 PERFORM 8830-UPDATE-CDP       THRU 8830-EXIT           
      *** CRED_ARNG_ACTN table will have only STAA/STFA forecasted rows.        
      *** During billing process these rows will be inserted into               
      *** cred_coll table.                                                      
                 IF X1-ARNG-TYPE = 'STAA' OR 'STFA'                     
                    PERFORM 8840-DELETE-CRED-ARNG-ACTN                  
                                               THRU 8840-EXIT           
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *--------------------------------------------------------------*          
      * CHECK THE ARRANGEMENT COMPLIANCE LIMIT.                      *          
      *--------------------------------------------------------------*          
       2960-CHECK-ARNG-COMPL-LIMIT.                                     
      *                                                                         
           MOVE SPACES TO LR-REG-GROUP-CD.                              
           IF AT-CODE-ACCT-STAT = 'A'                                   
              IF SEB-DATABASE                                           
                 PERFORM 7045-SELECT-REG-PROFILE  THRU 7045-EXIT        
              END-IF                                                    
              PERFORM 7680-SELECT-COMPL-LIMIT     THRU 7680-EXIT        
              IF WS-CODE-STA-ACCT = 'A'                                 
                 IF SEB-DATABASE       AND AT-CREDIT-GROUP = 'B'        
                    COMPUTE WS-AMT-TO-COMPLY = WS-TOTAL-BALANCE-UTL     
                                               - WS-PYMT-AMOUNT         
                 ELSE                                                   
                    COMPUTE WS-AMT-TO-COMPLY = WS-AMT-PAST-DUE-UTL      
                                            - WS-PYMT-AMOUNT            
                 END-IF                                                 
              END-IF                                                    
      *                                                                         
              IF X1-ARNG-TYPE = 'STAA' OR 'STFA'                        
                 IF AT-DATE-BILL-DAY-00 = X1-ARNG-SETUP-DT              
                    PERFORM 7035-SELECT-BILL-DETAILS THRU 7035-EXIT     
                    IF BI-LAST-UPDATE-TS < WY-ARNG-HIST-TS              
                       COMPUTE WS-AMT-TO-COMPLY = WS-TOTAL-BALANCE-UTL  
                                                - WS-PYMT-AMOUNT        
                    ELSE                                                
                       COMPUTE WS-AMT-TO-COMPLY = WS-AMT-PAST-DUE-UTL   
                                                - WS-PYMT-AMOUNT        
                    END-IF                                              
                 ELSE                                                   
                   IF AT-DATE-BILL-DAY-00 < X1-ARNG-SETUP-DT            
                       COMPUTE WS-AMT-TO-COMPLY = WS-TOTAL-BALANCE-UTL  
                                                - WS-PYMT-AMOUNT        
                   ELSE                                                 
                       COMPUTE WS-AMT-TO-COMPLY = WS-AMT-PAST-DUE-UTL   
                                                - WS-PYMT-AMOUNT        
                   END-IF                                               
                 END-IF                                                 
              END-IF                                                    
      *                                                                         
              IF WS-CODE-CRED-ARNG = 'A' AND X1-ARNG-TYPE = 'CDD'       
                 COMPUTE WS-AMT-TO-COMPLY = WS-TOTAL-BALANCE            
                                          - WS-PYMT-AMOUNT              
              END-IF                                                    
      *                                                                 00162440
              IF X1-ARNG-TYPE = 'CDDA'                                  
                 COMPUTE WS-TOTAL-ARREARS  = WS-AMT-ARREARS-UTL +       
                                             WS-AMT-ARREARS-NONUTL -    
                                             WS-PYMT-AMOUNT             
                 IF AT-DATE-BILL-DAY-00 = X1-ARNG-SETUP-DT              
                    PERFORM 7035-SELECT-BILL-DETAILS THRU 7035-EXIT     
                    IF BI-LAST-UPDATE-TS < WY-ARNG-HIST-TS              
                       COMPUTE WS-AMT-TO-COMPLY = WS-TOTAL-BALANCE      
                                                - WS-PYMT-AMOUNT        
                    ELSE                                                
                       MOVE WS-TOTAL-ARREARS     TO WS-AMT-TO-COMPLY    
                    END-IF                                              
                 ELSE                                                   
                   IF AT-DATE-BILL-DAY-00 < X1-ARNG-SETUP-DT            
                       COMPUTE WS-AMT-TO-COMPLY = WS-TOTAL-BALANCE      
                                                - WS-PYMT-AMOUNT        
                   ELSE                                                 
                      MOVE WS-TOTAL-ARREARS     TO WS-AMT-TO-COMPLY     
                   END-IF                                               
                 END-IF                                                 
              END-IF                                                    
              IF WS-AMT-TO-COMPLY <= UY-ARNG-ATTR-VAL-NUM               
                 MOVE 'Y'                      TO WS-ARNG-COMPLIANCE-CD 
                 IF X1-ARNG-TYPE = 'STF' OR 'STFA'                      
                    MOVE WS-LEAST-AMT-DUE-CD   TO C8-DELINQ-CD          
                    MOVE AT-COMPANY-NO         TO C8-COMPANY-NO         
                    PERFORM 7000-GET-DELINQ-VALUE THRU 7000-EXIT        
                    MOVE C8-DELINQ-VALUE       TO WS-LEAST-AMT-DUE      
                    COMPUTE WS-AMT-TO-COMPLY = WS-AMT-TO-COMPLY         
                                             - WS-LEAST-AMT-DUE         
                 END-IF                                                 
                 IF WS-AMT-TO-COMPLY < 0                                
                    MOVE 0 TO WS-AMT-TO-COMPLY                          
                 END-IF                                                 
                 MOVE WS-AMT-TO-COMPLY TO X1-ARNG-REMAINING-AM          
                 IF WS-PROGRAM-NAME = 'CSR02341' OR 'CSR04894'          
                    IF WS-CODE-CRED-ARNG = 'A'                          
                       MOVE 5972    TO WS-DNP-RET-CODE                  
                    ELSE                                                
                       MOVE 5970    TO WS-DNP-RET-CODE                  
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 IF WS-PROGRAM-NAME = 'CSR02341' OR 'CSR04894'          
                    IF WS-CODE-CRED-ARNG = 'A'                          
                       MOVE 5973    TO WS-DNP-RET-CODE                  
                    ELSE                                                
                       MOVE 5971    TO WS-DNP-RET-CODE                  
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2960-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *--------------------------------------------------------------*          
      * POPULATE ARRANGEMENT HISTORY DETAILS                         *          
      *--------------------------------------------------------------*          
       2975-POPULATE-ARNG-HIST-DTLS.                                    
      *                                                                         
           MOVE AT-ACCOUNT-NO            TO WY-ACCOUNT-NO.              
           MOVE WS-TOTAL-BALANCE         TO WY-TOTAL-AR-BALANCE.        
           MOVE WS-TOTAL-BALANCE-UTL     TO WY-TOTAL-UTL-BAL.           
           MOVE WS-TOTAL-BALANCE-NONUTL  TO WY-TOTAL-NONUTL-BAL.        
           MOVE WS-AMT-ARREARS-UTL       TO WY-UTL-ARREARS-AMT.         
           MOVE WS-AMT-ARREARS-NONUTL    TO WY-NONUTL-ARREARS-AMT.      
           MOVE WX-ARNG-SCHD-DUE-DT      TO WY-ARNG-DUE-DT.             
           MOVE X1-ARNG-ID               TO WY-ARNG-ID.                 
           MOVE X1-CRED-ARNG-SEQ         TO WY-CRED-ARNG-SEQ.           
           MOVE WX-ARNG-SCHD-SEQ         TO WY-ARNG-SCHD-SEQ.           
           MOVE 'C'                      TO WY-ARNG-CHANGE-CD.          
           MOVE WS-ARRANGEMENT-COMMENTS  TO WY-CHANGE-COMMENTS-TEXT.    
           MOVE LENGTH OF WY-CHANGE-COMMENTS-TEXT                       
                                         TO WY-CHANGE-COMMENTS-LEN.     
           MOVE WS-CURR-TIMESTAMP        TO WY-LAST-UPDATE-TS           
                                            WY-ARNG-HIST-TS.            
           MOVE 'SYSTEM'                 TO WY-LAST-UPDATE-USERID.      
      *                                                                         
       2975-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *--------------------------------------------------------------*          
      * WRITE THE ARRANGEMENT TRANSACTION HISTORY DETAILS/HEADER     *          
      *--------------------------------------------------------------*          
       2980-WRITE-ARNG-TRANS-HIST.                                      
      *                                                                         
           MOVE 1                        TO MI-TRAN-APPL-NO.            
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE ZEROS                    TO MH-CUSTOMER-NO.             
           MOVE ZEROS                    TO MH-PREMISE-NO.              
           MOVE AT-ACCOUNT-NO            TO MH-ACCOUNT-NO.              
           MOVE WS-SYSTEM                TO MH-USER-ID.                 
           MOVE 'PYMTSTA'                TO MH-APPL-PROGRAM-ID.         
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO        
      *                                                                         
      *MNT TRANS HIST FOR ARRANGEMENT TYPE                                      
           MOVE 'ARNG TYPE'              TO MI-COLUMN-DESC.             
           MOVE SPACES                   TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                         TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE X1-ARNG-TYPE             TO MI-CHG-COLUMN-VALUE-TEXT.   
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                         TO MI-CHG-COLUMN-VALUE-LEN.    
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
      *                                                                         
      *MNT TRANS HIST FOR ARRANGEMENT ID                                        
           ADD 1                         TO MI-TRAN-APPL-NO.            
           MOVE 'ARNG ID'                TO MI-COLUMN-DESC.             
           MOVE SPACES                   TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                         TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE X1-ARNG-ID               TO MI-CHG-COLUMN-VALUE-TEXT.   
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                         TO MI-CHG-COLUMN-VALUE-LEN.    
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
      *                                                                         
      *MNT TRANS HIST FOR ARRANGEMENT STATUS                                    
           ADD 1                         TO MI-TRAN-APPL-NO             
           MOVE 'ARNG STATUS'            TO MI-COLUMN-DESC.             
           MOVE 'ACTIVE'                 TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                         TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE 'COMPLETE'               TO MI-CHG-COLUMN-VALUE-TEXT.   
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                         TO MI-CHG-COLUMN-VALUE-LEN.    
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
      *                                                                         
      *MNT TRANS HIST FOR REMAINING AMOUNT                                      
           ADD 1                         TO MI-TRAN-APPL-NO.            
           MOVE 'REMAINING AMT'          TO MI-COLUMN-DESC.             
           MOVE WX-ARNG-SCHD-PYMT-AMT    TO WS-COMP-2-CHAR-CONV         
           MOVE WS-COMP-2-CHAR-CONV      TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                         TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE WS-AMT-TO-COMPLY         TO WS-COMP-2-CHAR-CONV         
           MOVE WS-COMP-2-CHAR-CONV      TO MI-CHG-COLUMN-VALUE-TEXT.   
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                         TO MI-CHG-COLUMN-VALUE-LEN.    
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
      *                                                                         
      *MNT TRANS HIST FOR ARRANGEMENT COMPLIANCE CODE                           
           ADD  1                        TO MI-TRAN-APPL-NO.            
           MOVE 'COMPLNCE IND'           TO MI-COLUMN-DESC.             
           MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                         TO MI-PRV-COLUMN-VALUE-LEN.    
           IF WS-ARNG-COMPLIANCE-CD = 'Y'                               
              MOVE 'YES'                 TO MI-CHG-COLUMN-VALUE-TEXT    
           ELSE                                                         
              MOVE 'NO'                  TO MI-CHG-COLUMN-VALUE-TEXT    
           END-IF.                                                      
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                         TO MI-CHG-COLUMN-VALUE-LEN.    
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
      *                                                                         
       2980-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * SELECTS DELINQUENCY VALUE FOR GIVEN DELINQUENCY CODE          *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
                                                                        
       7000-GET-DELINQ-VALUE.                                           
      *----------------------*                                                  
                                                                        
           MOVE '7000'                   TO ACTIVE-PARAGRAPH            
                                                                        
           EXEC SQL                                                     
             SELECT DELINQ_VALUE                                        
               INTO :C8-DELINQ-VALUE                                    
               FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                       
              WHERE DELINQ_CD  = :C8-DELINQ-CD                          
                AND COMPANY_NO = :C8-COMPANY-NO                         
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DELINQ_VALUE                                                
MFA-TR*        INTO :C8-DELINQ-VALUE                                            
MFA-TR*        FROM CSS_DELINQUENCY                                             
MFA-TR*       WHERE DELINQ_CD  = :C8-DELINQ-CD                                  
MFA-TR*         AND COMPANY_NO = :C8-COMPANY-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DELINQUENCY'     TO TABLE-1                     
              MOVE C8-DELINQ-CD          TO HOSTVAR-ELEMENT-1           
              MOVE C8-COMPANY-NO         TO HOSTVAR-ELEMENT-2           
              MOVE 'DELINQ_CD'           TO TABLE-ELEMENT-1             
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-SELECT-RECONNECT                                          *22560000
      ******************************************************************        
                                                                        
       7010-SELECT-RECONNECT.                                           
                                                                        
           EXEC SQL                                                     
             SELECT AMT_TOT_RECONNECT                                   
                   ,RECNCT_COLLECT_AMT                                  
                   ,AUTO_DEP_AM                                         
                   ,AUTO_DEP_CERT_NO                                    
               INTO :DL-AMT-TOT-RECONNECT                               
                   ,:DL-RECNCT-COLLECT-AMT                              
                   ,:DL-AUTO-DEP-AM                                     
                   ,:DL-AUTO-DEP-CERT-NO                                
               FROM CSS_RECONNECT WITH(READUNCOMMITTED)                         
              WHERE ACCOUNT_NO  = :DL-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     22580000
MFA-TR*      SELECT AMT_TOT_RECONNECT                                   22590000
MFA-TR*            ,RECNCT_COLLECT_AMT                                  22600000
MFA-TR*            ,AUTO_DEP_AM                                                 
MFA-TR*            ,AUTO_DEP_CERT_NO                                            
MFA-TR*        INTO :DL-AMT-TOT-RECONNECT                               22610000
MFA-TR*            ,:DL-RECNCT-COLLECT-AMT                              22620000
MFA-TR*            ,:DL-AUTO-DEP-AM                                             
MFA-TR*            ,:DL-AUTO-DEP-CERT-NO                                        
MFA-TR*        FROM CSS_RECONNECT                                       22630000
MFA-TR*       WHERE ACCOUNT_NO  = :DL-ACCOUNT-NO                        22640000
MFA-TR*        WITH UR                                                  22652000
MFA-TR*     QUERYNO 7010                                                        
MFA-TR*    END-EXEC.                                                    22660000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7010'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_RECONNECT'       TO TABLE-1                     
              MOVE DL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * SELECTS BILLING TIMESTAMP                                     *         
      *---------------------------------------------------------------*         
       7035-SELECT-BILL-DETAILS.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS           
                INTO :BI-LAST-UPDATE-TS                                 
                FROM CSS_BILLING_HDR WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                       
                 AND DATE_BILLED IS NOT NULL                            
               ORDER BY BILL_NO DESC                                    
                                                                 
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LAST_UPDATE_TS                                             
MFA-TR*         INTO :BI-LAST-UPDATE-TS                                         
MFA-TR*         FROM CSS_BILLING_HDR                                            
MFA-TR*        WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                               
MFA-TR*          AND DATE_BILLED IS NOT NULL                                    
MFA-TR*        ORDER BY BILL_NO DESC                                            
MFA-TR*         WITH UR                                                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*      QUERYNO 7035                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES             TO BI-LAST-UPDATE-TS           
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE               
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7035'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BILLING_HDR'     TO TABLE-1                     
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7035-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *---------------------------------------------------------------*         
      * SELECTS REG GROUP CODE.                                       *         
      *---------------------------------------------------------------*         
       7045-SELECT-REG-PROFILE.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT REG_GROUP_CD                                       
                INTO :LR-REG-GROUP-CD                                   
                FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT REG_GROUP_CD                                               
MFA-TR*         INTO :LR-REG-GROUP-CD                                           
MFA-TR*         FROM CSS_REG_PROFILE                                            
MFA-TR*        WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7045                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE               
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7045'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_REG_PROFILE'     TO TABLE-1                     
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7045-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * GETS PREVIOUS BUSINESS DATE                                   *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       7100-GET-PREV-BUSINESS-DATE.                                     
      *----------------------------*                                            
                                                                        
           MOVE '7100'                    TO ACTIVE-PARAGRAPH           
                                                                        
           EXEC SQL                                                     
             SELECT DATEADD( DAY, -:WS-ADJ-DAY, IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )           
               INTO :WS-RELEASE-DATE                                    
               FROM CIS.SYSDUMMY1 WITH(READUNCOMMITTED)                         
              WHERE CIS.DAYS(DATEADD( DAY, -:WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )) -   
                    (CIS.DAYS(DATEADD( DAY, -:WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )
               )) / 7 * 7) BETWEEN 1 AND 5       
                AND NOT EXISTS                                          
                    (SELECT HOLIDAY_DT                                  
                       FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                   
                      WHERE HOLIDAY_DT =                                
                            DATEADD( DAY, -:WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) ))  
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DATE(:WS-CURRENT-DATE) - :WS-ADJ-DAY DAYS                   
MFA-TR*        INTO :WS-RELEASE-DATE                                            
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*       WHERE DAYS(DATE(:WS-CURRENT-DATE) - :WS-ADJ-DAY DAYS) -           
MFA-TR*             (INTEGER(DAYS(DATE(:WS-CURRENT-DATE)                        
MFA-TR*             - :WS-ADJ-DAY DAYS) / 7) * 7) BETWEEN 1 AND 5               
MFA-TR*         AND NOT EXISTS                                                  
MFA-TR*             (SELECT HOLIDAY_DT                                          
MFA-TR*                FROM CSS_HOLIDAY                                         
MFA-TR*               WHERE HOLIDAY_DT =                                        
MFA-TR*                     DATE(:WS-CURRENT-DATE) - :WS-ADJ-DAY DAYS)          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                                                        
           EVALUATE SQLCODE                                             
               WHEN SUCCESSFUL-CALL                                     
                    MOVE WS-RELEASE-DATE  TO WS-WORK-DAY (WD-INDX)      
                    ADD 1                 TO WS-ADJ-DAY                 
                    SET WD-INDX DOWN BY 1                               
               WHEN NOT-FOUND                                           
                    ADD 1                 TO WS-ADJ-DAY                 
               WHEN OTHER                                               
                    DISPLAY 'WORK-DATE ERROR'                           
                    SET WD-INDX           TO 1                          
                    SET WD-INDX DOWN BY 1                               
           END-EVALUATE                                                 
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * GET ACCOUNT DETAILS THAT WILL BE REQUIRED TO CANCEL THE SERVICE*        
      * ORDER  AND SEND A WORK QUEUE.                                  *        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       7200-SELECT-AT-DETAILS.                                          
      *------------------------*                                                
                                                                        
           MOVE '7200'                    TO ACTIVE-PARAGRAPH           
                                                                        
           EXEC SQL                                                     
             SELECT CUSTOMER_NO                                         
                   ,PREMISE_NO                                          
                   ,LOCAL_OFFICE                                        
                   ,CODES_DATA_PRESENT                                  
                   ,CODE_ACCT_STAT                                      
                   ,COMPANY_NO                                          
                   ,DATE_BILL_DAY_00                                    
                   ,CREDIT_GROUP                                        
P00948             ,ACCOUNT_TYPE_CODE                                   
               INTO :AT-CUSTOMER-NO                                     
                   ,:AT-PREMISE-NO                                      
                   ,:AT-LOCAL-OFFICE                                    
                   ,:AT-CODES-DATA-PRESENT                              
                   ,:AT-CODE-ACCT-STAT                                  
                   ,:AT-COMPANY-NO                                      
                   ,:AT-DATE-BILL-DAY-00                                
                   ,:AT-CREDIT-GROUP                                    
P00948             ,:AT-ACCOUNT-TYPE-CODE                               
               FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                           
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CUSTOMER_NO                                                 
MFA-TR*            ,PREMISE_NO                                                  
MFA-TR*            ,LOCAL_OFFICE                                                
MFA-TR*            ,CODES_DATA_PRESENT                                          
MFA-TR*            ,CODE_ACCT_STAT                                              
MFA-TR*            ,COMPANY_NO                                                  
MFA-TR*            ,DATE_BILL_DAY_00                                            
MFA-TR*            ,CREDIT_GROUP                                        21880000
MFA-TR*            ,ACCOUNT_TYPE_CODE                                   21880000
MFA-TR*        INTO :AT-CUSTOMER-NO                                             
MFA-TR*            ,:AT-PREMISE-NO                                              
MFA-TR*            ,:AT-LOCAL-OFFICE                                            
MFA-TR*            ,:AT-CODES-DATA-PRESENT                                      
MFA-TR*            ,:AT-CODE-ACCT-STAT                                          
MFA-TR*            ,:AT-COMPANY-NO                                              
MFA-TR*            ,:AT-DATE-BILL-DAY-00                                        
MFA-TR*            ,:AT-CREDIT-GROUP                                    21880000
MFA-TR*            ,:AT-ACCOUNT-TYPE-CODE                               21880000
MFA-TR*        FROM CSS_ACCOUNT                                                 
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CSS_ACCOUNT'          TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * SELECT DNP01 OR DNPFB DETAILS                                 *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       7300-SELECT-DNP-TYPE.                                            
      *---------------------*                                                   
                                                                        
           MOVE '7300'                    TO ACTIVE-PARAGRAPH           
                                                                        
           MOVE 0                         TO WS-IND-05 WS-IND-06        
                                             WS-IND-07 WS-IND-08        
           EXEC SQL                                                     
             SELECT SERV_ORDER_NO                                       
                   ,SERV_ORDER_STATUS                                   
                   ,ORDER_REASON                                        
                   ,ORDER_TYPE_CD                                       
               INTO :WS-SERV-ORDER-NO-TEMP :WS-IND-05                  
                   ,:WS-SERV-ORDER-STATUS :WS-IND-06                  
                   ,:WS-ORDER-REASON-TEMP :WS-IND-07                  
                   ,:WS-ORDER-TYPE-CD :WS-IND-08                  
               FROM CSS_SO_DATA WITH(READUNCOMMITTED)                           
              WHERE ACCOUNT_NO_PRIOR = :VO-ACCOUNT-NO-PRIOR             
                AND ORDER_STATE_CD   = 'A'                              
                AND ORDER_TYPE_CD LIKE 'DNP%'                           
                AND DATE_RECVED =                                       
                     (SELECT MAX(DATE_RECVED)                           
                        FROM CSS_SO_DATA WITH(READUNCOMMITTED)                  
                       WHERE ACCOUNT_NO_PRIOR = :VO-ACCOUNT-NO-PRIOR    
                         AND ORDER_TYPE_CD LIKE 'DNP%')                 
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT SERV_ORDER_NO                                               
MFA-TR*            ,SERV_ORDER_STATUS                                           
MFA-TR*            ,ORDER_REASON                                                
MFA-TR*            ,ORDER_TYPE_CD                                               
MFA-TR*        INTO :WS-SERV-ORDER-NO-TEMP  :WS-IND-05                          
MFA-TR*            ,:WS-SERV-ORDER-STATUS   :WS-IND-06                          
MFA-TR*            ,:WS-ORDER-REASON-TEMP   :WS-IND-07                          
MFA-TR*            ,:WS-ORDER-TYPE-CD       :WS-IND-08                          
MFA-TR*        FROM CSS_SO_DATA                                                 
MFA-TR*       WHERE ACCOUNT_NO_PRIOR = :VO-ACCOUNT-NO-PRIOR                     
MFA-TR*         AND ORDER_STATE_CD   = 'A'                                      
MFA-TR*         AND ORDER_TYPE_CD LIKE 'DNP%'                                   
MFA-TR*         AND DATE_RECVED =                                               
MFA-TR*              (SELECT MAX(DATE_RECVED)                                   
MFA-TR*                 FROM CSS_SO_DATA                                        
MFA-TR*                WHERE ACCOUNT_NO_PRIOR = :VO-ACCOUNT-NO-PRIOR            
MFA-TR*                  AND ORDER_TYPE_CD LIKE 'DNP%')                         
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              IF WS-IND-05 = -1                                         
                 MOVE 0                   TO WS-SERV-ORDER-NO-TEMP      
              END-IF                                                    
              IF WS-IND-06 = -1                                         
                 MOVE SPACES              TO WS-SERV-ORDER-STATUS       
              END-IF                                                    
              IF WS-IND-07 = -1                                         
                 MOVE SPACES              TO WS-ORDER-REASON-TEMP       
              END-IF                                                    
              IF WS-IND-08 = -1                                         
                 MOVE SPACES              TO WS-ORDER-TYPE-CD           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CSS_SO_DATA'          TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE VO-ACCOUNT-NO-PRIOR    TO HOSTVAR-ELEMENT-1          
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
           .                                                            
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * SELECT RECONNECT DETAILS FROM CSS_SO_DATA                     *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       7310-SELECT-DNPFB.                                               
      *------------------*                                                      
           MOVE '7310'                        TO ACTIVE-PARAGRAPH       
           MOVE ZEROS                         TO WS-SERV-ORDER-NO-D     
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) ROUND(SERV_ORDER_NO, 0)                             
               INTO :WS-SERV-ORDER-NO-D :WS-IND-12                      
               FROM CSS_SO_DATA                                         
              WHERE ACCOUNT_NO     = :VO-ACCOUNT-NO                     
                AND ORDER_TYPE_CD  = 'DNPFB'                            
                AND ORDER_STATE_CD = 'A'                                
                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT ROUND(SERV_ORDER_NO, 0)                                     
MFA-TR*        INTO :WS-SERV-ORDER-NO-D :WS-IND-12                              
MFA-TR*        FROM CSS_SO_DATA                                                 
MFA-TR*       WHERE ACCOUNT_NO     = :VO-ACCOUNT-NO                             
MFA-TR*         AND ORDER_TYPE_CD  = 'DNPFB'                                    
MFA-TR*         AND ORDER_STATE_CD = 'A'                                        
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL     TO SUCCESSFUL-CALL        
                                              OR NOT-FOUND              
              IF WS-IND-12 = -1                                         
                 MOVE 0                      TO WS-SERV-ORDER-NO-D      
              END-IF                                                    
              MOVE WS-SERV-ORDER-NO-D        TO WS-SERV-ORDER-CHAR      
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
           .                                                            
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * SELECT CURRENT TIMESTAMP                                      *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       7500-SELECT-TIMESTAMP.                                           
      *----------------------*                                                  
           MOVE '7500'                    TO ACTIVE-PARAGRAPH           
                                                                        
           EXEC SQL                                                     
             SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE),
              CIS.CHAR2$DATE(CAST(SYSDATETIMEOFFSET() AS DATE), 'USA'),
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MICROSECOND, 
              1, (CIS.CURRENT$TIMESTAMP()) ), 121), ' ', '-'), ':', 
           '.')
            INTO
              :WS-CURR-TIMESTAMP,
              :WS-CURRENT-DATE,
              :WS-CURRENT-DATE-USA,
              :MH-TRANS-HIST-SEQ-NO    
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-CURR-TIMESTAMP = CURRENT TIMESTAMP                         
MFA-TR*         ,:WS-CURRENT-DATE   = CURRENT DATE                              
MFA-TR*         ,:WS-CURRENT-DATE-USA  = CHAR(CURRENT DATE, USA)                
MFA-TR*         ,:MH-TRANS-HIST-SEQ-NO =                                        
MFA-TR*                          (CURRENT TIMESTAMP) + 1 MICROSECOND            
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'SET'                  TO ABEND-FUNCTION             
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
           .                                                            
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * GET CREDIT PROFILE DETAILS THAT WILL BE REQUIRED TO UPDATE     *        
      * HISTORY FIELDS                                                 *        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       7600-SELECT-CREDIT-PROFILE.                                      
      *---------------------------*                                             
           MOVE '7600'                    TO ACTIVE-PARAGRAPH           
                                                                        
           EXEC SQL                                                     
             SELECT DISCONNECT_HIST                                     
                   ,DISC_EXCEPTN_HIST                                   
               INTO :CZ-DISCONNECT-HIST                                 
                   ,:CZ-DISC-EXCEPTN-HIST                               
               FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                    
              WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                         
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DISCONNECT_HIST                                             
MFA-TR*            ,DISC_EXCEPTN_HIST                                           
MFA-TR*        INTO :CZ-DISCONNECT-HIST                                         
MFA-TR*            ,:CZ-DISC-EXCEPTN-HIST                                       
MFA-TR*        FROM CSS_CREDIT_PROFILE                                          
MFA-TR*       WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CSS_CREDIT_PROFILE'   TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE CZ-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
           .                                                            
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*          
      *   SELECT ACTIVE CREDIT ARRANGEMENT                                      
      *--------------------------------------------------------------*          
       7675-SELECT-ACTIVE-ARNG.                                         
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) X1.ACCOUNT_NO,
              X1.ARNG_ID,
              X1.ARNG_COMPLIANCE_CD,
              X1.CRED_ARNG_SEQ,
              X1.ARNG_CHANNEL_CD,
              X1.ARNG_TYPE,
              X1.ARNG_SETUP_DT,
              X1.ARNG_OPTION_ID,
              WX.ARNG_SCHD_SEQ,
              WX.ARNG_SCHD_DUE_DT,
              WX.ARNG_SCHD_PYMT_AMT,
              REPLACE(REPLACE(CONVERT(CHAR(26), WY.ARNG_HIST_TS, 121), 
           ' ', '-'), ':', '.') ARNG_HIST_TS                                   
                 INTO :X1-ACCOUNT-NO                                    
                     ,:X1-ARNG-ID                                       
                     ,:X1-ARNG-COMPLIANCE-CD                            
                     ,:X1-CRED-ARNG-SEQ                                 
                     ,:X1-ARNG-CHANNEL-CD                               
                     ,:X1-ARNG-TYPE                                     
                     ,:X1-ARNG-SETUP-DT                                 
                     ,:X1-ARNG-OPTION-ID                                
                     ,:WX-ARNG-SCHD-SEQ :WS-ARNG-SCHD-SEQ-NULL     
                     ,:WX-ARNG-SCHD-DUE-DT                              
                     ,:WX-ARNG-SCHD-PYMT-AMT                            
                     ,:WY-ARNG-HIST-TS                                  
                 FROM CSS_CRED_ARNGMENT  X1 WITH(READUNCOMMITTED)               
                     ,CSS_CRED_ARNG_SCHD WX WITH(READUNCOMMITTED)               
                     ,CSS_CRED_ARNG_HIST WY WITH(READUNCOMMITTED)               
                WHERE X1.ACCOUNT_NO        =  WX.ACCOUNT_NO             
                  AND WX.ACCOUNT_NO        =  WY.ACCOUNT_NO             
                  AND X1.ARNG_ID           =  WX.ARNG_ID                
                  AND WX.ARNG_ID           =  WY.ARNG_ID                
                  AND X1.CRED_ARNG_SEQ     =  WX.CRED_ARNG_SEQ          
                  AND WX.CRED_ARNG_SEQ     =  WY.CRED_ARNG_SEQ          
                  AND X1.ARNG_STATUS_CD    =  'A'                       
                  AND WY.ARNG_CHANGE_CD    =  'S'                       
                  AND X1.ACCOUNT_NO        = :AT-ACCOUNT-NO             
                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT X1.ACCOUNT_NO                                             
MFA-TR*              ,X1.ARNG_ID                                                
MFA-TR*              ,X1.ARNG_COMPLIANCE_CD                                     
MFA-TR*              ,X1.CRED_ARNG_SEQ                                          
MFA-TR*              ,X1.ARNG_CHANNEL_CD                                        
MFA-TR*              ,X1.ARNG_TYPE                                              
MFA-TR*              ,X1.ARNG_SETUP_DT                                          
MFA-TR*              ,X1.ARNG_OPTION_ID                                         
MFA-TR*              ,WX.ARNG_SCHD_SEQ                                          
MFA-TR*              ,WX.ARNG_SCHD_DUE_DT                                       
MFA-TR*              ,WX.ARNG_SCHD_PYMT_AMT                                     
MFA-TR*              ,WY.ARNG_HIST_TS                                           
MFA-TR*          INTO :X1-ACCOUNT-NO                                            
MFA-TR*              ,:X1-ARNG-ID                                               
MFA-TR*              ,:X1-ARNG-COMPLIANCE-CD                                    
MFA-TR*              ,:X1-CRED-ARNG-SEQ                                         
MFA-TR*              ,:X1-ARNG-CHANNEL-CD                                       
MFA-TR*              ,:X1-ARNG-TYPE                                             
MFA-TR*              ,:X1-ARNG-SETUP-DT                                         
MFA-TR*              ,:X1-ARNG-OPTION-ID                                        
MFA-TR*              ,:WX-ARNG-SCHD-SEQ      :WS-ARNG-SCHD-SEQ-NULL             
MFA-TR*              ,:WX-ARNG-SCHD-DUE-DT                                      
MFA-TR*              ,:WX-ARNG-SCHD-PYMT-AMT                                    
MFA-TR*              ,:WY-ARNG-HIST-TS                                          
MFA-TR*          FROM CSS_CRED_ARNGMENT  X1                                     
MFA-TR*              ,CSS_CRED_ARNG_SCHD WX                                     
MFA-TR*              ,CSS_CRED_ARNG_HIST WY                                     
MFA-TR*         WHERE X1.ACCOUNT_NO        =  WX.ACCOUNT_NO                     
MFA-TR*           AND WX.ACCOUNT_NO        =  WY.ACCOUNT_NO                     
MFA-TR*           AND X1.ARNG_ID           =  WX.ARNG_ID                        
MFA-TR*           AND WX.ARNG_ID           =  WY.ARNG_ID                        
MFA-TR*           AND X1.CRED_ARNG_SEQ     =  WX.CRED_ARNG_SEQ                  
MFA-TR*           AND WX.CRED_ARNG_SEQ     =  WY.CRED_ARNG_SEQ                  
MFA-TR*           AND X1.ARNG_STATUS_CD    =  'A'                               
MFA-TR*           AND WY.ARNG_CHANGE_CD    =  'S'                               
MFA-TR*           AND X1.ACCOUNT_NO        = :AT-ACCOUNT-NO                     
MFA-TR*           FETCH FIRST 1 ROWS ONLY WITH UR                               
MFA-TR*       QUERYNO 7675                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE              
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7675'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_CRED_ARNGMENT'    TO TABLE-1                    
              MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7675-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *--------------------------------------------------------------*          
      *   SELECT COMPLIANCE LIMIT FOR ARRANGEMENT                               
      *--------------------------------------------------------------*          
       7680-SELECT-COMPL-LIMIT.                                         
      *                                                                         
           EXEC SQL                                                     
             SELECT UY.ARNG_ATTR_VAL_NUM                                
                    INTO :UY-ARNG-ATTR-VAL-NUM                          
               FROM CSS_ARNG_ATTR UY WITH(READUNCOMMITTED)                      
              WHERE UY.ARNG_PLAN_ID  = (                                
                    SELECT UF.ARNG_PLAN_ID                              
                      FROM CSS_ARNG_PLAN UF WITH(READUNCOMMITTED)               
                     WHERE UF.ARNG_ID            = :X1-ARNG-ID          
                       AND UF.COMPANY_NO         = :AT-COMPANY-NO       
                       AND UF.REG_GROUP_CD       = :LR-REG-GROUP-CD     
                       AND UF.ARNG_PLAN_EFF_DT  <= 
              IIF(TRY_CONVERT(DATE, :X1-ARNG-SETUP-DT
              ) IS NULL OR (PATINDEX('%.%', :X1-ARNG-SETUP-DT
              ) <> 0) OR (LEN(:X1-ARNG-SETUP-DT) <> 10), CIS.CHAR2DATE(
                                                      :X1-ARNG-SETUP-DT
              ), CONVERT(DATE, :X1-ARNG-SETUP-DT) )    
                       AND UF.ARNG_PLAN_EXP_DT  >= 
              IIF(TRY_CONVERT(DATE, :X1-ARNG-SETUP-DT
              ) IS NULL OR (PATINDEX('%.%', :X1-ARNG-SETUP-DT
              ) <> 0) OR (LEN(:X1-ARNG-SETUP-DT) <> 10), CIS.CHAR2DATE(
                                                      :X1-ARNG-SETUP-DT
              ), CONVERT(DATE, :X1-ARNG-SETUP-DT) ) )  
                AND UY.ARNG_ATTR_CD       = 'COMPL'                     
                AND UY.ARNG_ATTR_EFF_DT  <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                
                AND UY.ARNG_ATTR_EXP_DT  >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                
              ORDER BY UY.ARNG_PLAN_ID ASC                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT UY.ARNG_ATTR_VAL_NUM                                        
MFA-TR*             INTO :UY-ARNG-ATTR-VAL-NUM                                  
MFA-TR*        FROM CSS_ARNG_ATTR UY                                            
MFA-TR*       WHERE UY.ARNG_PLAN_ID  = (                                        
MFA-TR*             SELECT UF.ARNG_PLAN_ID                                      
MFA-TR*               FROM CSS_ARNG_PLAN UF                                     
MFA-TR*              WHERE UF.ARNG_ID            = :X1-ARNG-ID                  
MFA-TR*                AND UF.COMPANY_NO         = :AT-COMPANY-NO               
MFA-TR*                AND UF.REG_GROUP_CD       = :LR-REG-GROUP-CD             
MFA-TR*                AND UF.ARNG_PLAN_EFF_DT  <= :X1-ARNG-SETUP-DT            
MFA-TR*                AND UF.ARNG_PLAN_EXP_DT  >= :X1-ARNG-SETUP-DT )          
MFA-TR*         AND UY.ARNG_ATTR_CD       = 'COMPL'                             
MFA-TR*         AND UY.ARNG_ATTR_EFF_DT  <= CURRENT DATE                        
MFA-TR*         AND UY.ARNG_ATTR_EXP_DT  >= CURRENT DATE                        
MFA-TR*       ORDER BY UY.ARNG_PLAN_ID ASC                                      
MFA-TR*       WITH UR                                                           
MFA-TR*     QUERYNO 7680                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE ZEROES TO UY-ARNG-ATTR-VAL-NUM                    
              END-IF                                                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE              
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7680'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_ARNG_ATTR'        TO TABLE-1                    
              MOVE X1-ARNG-ID             TO HOSTVAR-ELEMENT-1          
              MOVE X1-ARNG-SETUP-DT       TO HOSTVAR-ELEMENT-2          
              MOVE LR-REG-GROUP-CD        TO HOSTVAR-ELEMENT-3          
              MOVE 'ARNG_ID'              TO TABLE-ELEMENT-1            
              MOVE 'ARNG_SETUP_DT'        TO TABLE-ELEMENT-2            
              MOVE 'REG_GROUP_CD'         TO TABLE-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7680-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7960-GET-AUTO-DEP-ON-HAND                                      *        
      ******************************************************************        
                                                                        
       7960-GET-AUTO-DEP-ON-HAND.                                       
                                                                        
           MOVE '7960'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
               SELECT AUTO_DEP_LTR_IND                                  
               INTO  :DO-AUTO-DEP-LTR-IND                               
               FROM   CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                     
               WHERE  ACCOUNT_NO          = :DO-ACCOUNT-NO              
               AND    DEPOSIT_CERT_NO     = :DO-DEPOSIT-CERT-NO         
               AND    CODE_DEP_TYPE       = :DO-CODE-DEP-TYPE           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AUTO_DEP_LTR_IND                                          
MFA-TR*        INTO  :DO-AUTO-DEP-LTR-IND                                       
MFA-TR*        FROM   CSS_DEP_ON_HAND                                           
MFA-TR*        WHERE  ACCOUNT_NO          = :DO-ACCOUNT-NO                      
MFA-TR*        AND    DEPOSIT_CERT_NO     = :DO-DEPOSIT-CERT-NO                 
MFA-TR*        AND    CODE_DEP_TYPE       = :DO-CODE-DEP-TYPE                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_DEP_ON_HAND'   TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7960-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7970-GET-AUTO-DEP-REQ                                          *        
      ******************************************************************        
                                                                        
       7970-GET-AUTO-DEP-REQ.                                           
                                                                        
           MOVE '7970'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
               SELECT DEP_BILL_OPTION_CD                                
                     ,NO_SCHED_PYMTS                                    
               INTO  :DR-DEP-BILL-OPTION-CD                             
                    ,:DR-NO-SCHED-PYMTS                                 
               FROM   CSS_DEP_REQ WITH(READUNCOMMITTED)                         
               WHERE  ACCOUNT_NO  = :DR-ACCOUNT-NO                      
               AND    DEP_ITEM_ID = :DR-DEP-ITEM-ID                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DEP_BILL_OPTION_CD                                        
MFA-TR*              ,NO_SCHED_PYMTS                                            
MFA-TR*        INTO  :DR-DEP-BILL-OPTION-CD                                     
MFA-TR*             ,:DR-NO-SCHED-PYMTS                                         
MFA-TR*        FROM   CSS_DEP_REQ                                               
MFA-TR*        WHERE  ACCOUNT_NO  = :DR-ACCOUNT-NO                              
MFA-TR*        AND    DEP_ITEM_ID = :DR-DEP-ITEM-ID                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_DEP_ON_HAND'   TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7970-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7980-GET-AMT-ADEP-BAL                                          *        
      ******************************************************************        
                                                                        
       7980-GET-AMT-ADEP-BAL.                                           
                                                                        
           MOVE '7980'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMT_AR_DAY_00 +                               
                          AMT_AR_DAY_30 +                               
                          AMT_AR_DAY_60 +                               
                          AMT_AR_DAY_90)                                
               INTO  :WS-ADEP-BALANCE :WS-ADEP-BAL-NULL                 
               FROM   CSS_AR_CNTL AC WITH(READUNCOMMITTED)                      
               WHERE  ACCOUNT_NO        = :AC-ACCOUNT-NO                
               AND    PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL         
               AND    ITEM_ID           = :AC-ITEM-ID                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_AR_DAY_00 +                                       
MFA-TR*                   AMT_AR_DAY_30 +                                       
MFA-TR*                   AMT_AR_DAY_60 +                                       
MFA-TR*                   AMT_AR_DAY_90)                                        
MFA-TR*        INTO  :WS-ADEP-BALANCE :WS-ADEP-BAL-NULL                         
MFA-TR*        FROM   CSS_AR_CNTL AC                                            
MFA-TR*        WHERE  ACCOUNT_NO        = :AC-ACCOUNT-NO                        
MFA-TR*        AND    PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                 
MFA-TR*        AND    ITEM_ID           = :AC-ITEM-ID                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ADEP-BAL-NULL < ZERO                                
                 MOVE ZEROES            TO WS-ADEP-BALANCE              
                                           WS-ADEP-BAL-NULL             
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_AR_CNTL'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'PYMT_PRIORITY_LVL'  TO TABLE-ELEMENT-1              
              MOVE AC-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7980-EXIT.                                                       
           EXIT.                                                        
P00948*                                                                         
P00948*****************************************************************         
P00948* 7985-SEL-EMAIL-ID.                                            *         
P00948*****************************************************************         
P00948 7985-SEL-EMAIL-ID.                                               
P00948*                                                                         
P00948     MOVE '7985'                        TO ACTIVE-PARAGRAPH.      
P00948*                                                                         
P00948     EXEC SQL                                                     
P00948          SELECT CUSTOMER_NO                                      
P00948            INTO :NE-CUSTOMER-NO                                  
P00948            FROM CSS_CUST_EMAIL WITH(READUNCOMMITTED)                     
P00948           WHERE CUSTOMER_NO    = :AT-CUSTOMER-NO                 
P00948             AND EMAIL_TYPE_CD  = 'P1'                            
P00948             AND LTRIM(RTRIM(EMAIL_ADDRESS_TX)) > ''                      
P00948                                                           
P00948     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*         SELECT CUSTOMER_NO                                      07457000
MFA-TR*           INTO :NE-CUSTOMER-NO                                  07457000
MFA-TR*           FROM CSS_CUST_EMAIL                                   07457000
MFA-TR*          WHERE CUSTOMER_NO    = :AT-CUSTOMER-NO                 07457000
MFA-TR*            AND EMAIL_TYPE_CD  = 'P1'                            07457000
MFA-TR*            AND TRIM(EMAIL_ADDRESS_TX) > ''                      07457000
MFA-TR*           WITH UR                                               07457000
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00948*                                                                         
P00948     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00948                                                                  
P00948     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00948        CONTINUE                                                  
P00948     ELSE                                                         
P00948        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00948        MOVE 'SELECT'                   TO ABEND-FUNCTION         
P00948        MOVE 'CSS_CUST_EMAIL'           TO TABLE-1                
P00948        MOVE 'CUSTOMER-NO'              TO TABLE-ELEMENT-1        
P00948        MOVE AT-CUSTOMER-NO             TO HOSTVAR-ELEMENT-1      
P00948        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00948        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00948     END-IF.                                                      
P00948*                                                                         
P00948 7985-EXIT.                                                       
P00948     EXIT.                                                        
P00948*                                                                         
P00948*****************************************************************         
P00948* 7990-GET-EMAIL-ID.                                            *         
P00948*****************************************************************         
P00948 7990-SET-EMAIL-ID.                                               
P00948*                                                                         
P00948     MOVE '7990'                        TO ACTIVE-PARAGRAPH.      
P00948*                                                                         
P00948     EXEC SQL                                                     
P00948        SELECT
              NEXT VALUE FOR SEQ_AE_BATCH_EMAIL_ID
            INTO
              :AE-BATCH-EMAIL-ID
P00948     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ048
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*       SET :AE-BATCH-EMAIL-ID = NEXTVAL FOR SEQ_AE_BATCH_EMAIL_ID07458000
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00948*                                                                         
P00948     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00948                                                                  
P00948     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00948        CONTINUE                                                  
P00948     ELSE                                                         
P00948        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00948        MOVE 'NEXTVAL'                  TO ABEND-FUNCTION         
P00948        MOVE 'SEQ_AE_BATCH_EMAIL_ID'    TO TABLE-1                
P00948        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P00948        MOVE AE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P00948        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00948        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00948     END-IF.                                                      
P00948*                                                                         
P00948 7990-EXIT.                                                       
P00948     EXIT.                                                        
P00948*                                                                         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * UPDATE CODES DATA PRESENT VALUE                               *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       8400-UPDATE-ACCOUNT.                                             
      *------------------*                                                      
           MOVE '8400'                        TO ACTIVE-PARAGRAPH       
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_ACCOUNT                                         
                SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT         
                   ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()              
              WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_ACCOUNT                                                 
MFA-TR*         SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT                 
MFA-TR*            ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                      
MFA-TR*       WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'CODES_DATA_PRESENT'       TO TABLE-ELEMENT-2        
              MOVE AT-CODES-DATA-PRESENT      TO HOSTVAR-ELEMENT-2      
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
           .                                                            
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8450-UPDATE-CRED-ARNG                                          *        
      ******************************************************************        
       8450-UPDATE-CRED-ARNG.                                           
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_CRED_ARNGMENT                                  
                 SET ARNG_STATUS_CD     = 'C'                           
                    ,ARNG_COMPLIANCE_CD = :WS-ARNG-COMPLIANCE-CD        
                    ,LAST_UPDATE_USERID = 'SYSTEM'                      
                    ,ARNG_REMAINING_AM  = :X1-ARNG-REMAINING-AM         
               WHERE ACCOUNT_NO         = :X1-ACCOUNT-NO                
                 AND ARNG_ID            = :X1-ARNG-ID                   
                 AND CRED_ARNG_SEQ      = :X1-CRED-ARNG-SEQ             
                 AND ARNG_STATUS_CD     = 'A'                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL  OR NOT-FOUND                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8450'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CRED_ARNGMENT'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'ARNG_ID'                 TO TABLE-ELEMENT-2         
              MOVE 'CRED_ARNG_SEQ'           TO TABLE-ELEMENT-3         
              MOVE X1-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE X1-ARNG-ID                TO HOSTVAR-ELEMENT-2       
              MOVE X1-CRED-ARNG-SEQ          TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * UPDATE DISCONNECT HISTORY                                     *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       8500-UPDATE-CREDIT-PROFILE.                                      
      *---------------------------*                                             
           MOVE '8500'                        TO ACTIVE-PARAGRAPH       
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_CREDIT_PROFILE                                  
                SET DISCONNECT_HIST    = :CZ-DISCONNECT-HIST            
                   ,DISC_EXCEPTN_HIST  = :CZ-DISC-EXCEPTN-HIST          
                   ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()              
              WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_CREDIT_PROFILE                                          
MFA-TR*         SET DISCONNECT_HIST    = :CZ-DISCONNECT-HIST                    
MFA-TR*            ,DISC_EXCEPTN_HIST  = :CZ-DISC-EXCEPTN-HIST                  
MFA-TR*            ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                      
MFA-TR*       WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CREDIT_PROFILE'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CZ-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'DISCONNECT_HIST'          TO TABLE-ELEMENT-2        
              MOVE CZ-DISCONNECT-HIST         TO HOSTVAR-ELEMENT-2      
              MOVE 'DISC_EXCEPTN_HIST'        TO TABLE-ELEMENT-3        
              MOVE CZ-DISC-EXCEPTN-HIST       TO HOSTVAR-ELEMENT-3      
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
           .                                                            
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * UPDATE PREMISE TO INDICATE THERE IS A SERVICE ORDER PENDING   *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       8600-UPDATE-PREMISE.                                             
      *--------------------*                                                    
           MOVE '8600'                        TO ACTIVE-PARAGRAPH       
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_PREMISE                                         
                SET SERV_ORDER_PEND    = :PR-SERV-ORDER-PEND            
              WHERE PREMISE_NO         = :PR-PREMISE-NO                 
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_PREMISE'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE PR-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'SERV_ORDER_PEND'          TO TABLE-ELEMENT-2        
              MOVE PR-SERV-ORDER-PEND         TO HOSTVAR-ELEMENT-2      
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
           .                                                            
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8800-INSERT-ARNG-HIST                                          *        
      ******************************************************************        
       8800-INSERT-ARNG-HIST.                                           
      *                                                                         
           IF WY-ARNG-DUE-DT    = LOW-VALUES OR SPACES                  
              MOVE -1                     TO WS-ARNG-DUE-DT-NULL        
           ELSE                                                         
              MOVE ZERO                   TO WS-ARNG-DUE-DT-NULL        
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_CRED_ARNG_HIST                            
                  (ACCOUNT_NO                                           
                 ,ARNG_ID                                               
                 ,CRED_ARNG_SEQ                                         
                 ,ARNG_HIST_TS                                          
                 ,ARNG_CHANGE_CD                                        
                 ,TOTAL_AR_BALANCE                                      
                 ,TOTAL_UTL_BAL                                         
                 ,TOTAL_NONUTL_BAL                                      
                 ,UTL_ARREARS_AMT                                       
                 ,NONUTL_ARREARS_AMT                                    
                 ,ARNG_DUE_DT                                           
                 ,ARNG_SCHD_SEQ                                         
                 ,CHANGE_COMMENTS                                       
                 ,LAST_UPDATE_TS                                        
                 ,LAST_UPDATE_USERID)                                   
              VALUES                                                    
                  (:WY-ACCOUNT-NO                                       
                 ,:WY-ARNG-ID                                           
                 ,:WY-CRED-ARNG-SEQ                                     
                 ,CIS.CHAR2TIMESTAMP(:WY-ARNG-HIST-TS)                          
                 ,:WY-ARNG-CHANGE-CD                                    
                 ,:WY-TOTAL-AR-BALANCE                                  
                 ,:WY-TOTAL-UTL-BAL                                     
                 ,:WY-TOTAL-NONUTL-BAL                                  
                 ,:WY-UTL-ARREARS-AMT                                   
                 ,:WY-NONUTL-ARREARS-AMT                                
                 ,IIF(TRY_CONVERT(DATE, :WY-ARNG-DUE-DT 
                                        :WS-ARNG-DUE-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :WY-ARNG-DUE-DT 
                                                   :WS-ARNG-DUE-DT-NULL
              ) <> 0) OR (LEN(:WY-ARNG-DUE-DT :WS-ARNG-DUE-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:WY-ARNG-DUE-DT 
                                                   :WS-ARNG-DUE-DT-NULL
              ), CONVERT(DATE, :WY-ARNG-DUE-DT :WS-ARNG-DUE-DT-NULL) )         
                 ,:WY-ARNG-SCHD-SEQ                                     
                 ,:WY-CHANGE-COMMENTS                                   
                 ,CIS.CHAR2TIMESTAMP(:WY-LAST-UPDATE-TS)                        
                 ,:WY-LAST-UPDATE-USERID)                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CRED_ARNG_HIST                                    
MFA-TR*           (ACCOUNT_NO                                                   
MFA-TR*          ,ARNG_ID                                                       
MFA-TR*          ,CRED_ARNG_SEQ                                                 
MFA-TR*          ,ARNG_HIST_TS                                                  
MFA-TR*          ,ARNG_CHANGE_CD                                                
MFA-TR*          ,TOTAL_AR_BALANCE                                              
MFA-TR*          ,TOTAL_UTL_BAL                                                 
MFA-TR*          ,TOTAL_NONUTL_BAL                                              
MFA-TR*          ,UTL_ARREARS_AMT                                               
MFA-TR*          ,NONUTL_ARREARS_AMT                                            
MFA-TR*          ,ARNG_DUE_DT                                                   
MFA-TR*          ,ARNG_SCHD_SEQ                                                 
MFA-TR*          ,CHANGE_COMMENTS                                               
MFA-TR*          ,LAST_UPDATE_TS                                                
MFA-TR*          ,LAST_UPDATE_USERID)                                           
MFA-TR*       VALUES                                                            
MFA-TR*           (:WY-ACCOUNT-NO                                               
MFA-TR*          ,:WY-ARNG-ID                                                   
MFA-TR*          ,:WY-CRED-ARNG-SEQ                                             
MFA-TR*          ,:WY-ARNG-HIST-TS                                              
MFA-TR*          ,:WY-ARNG-CHANGE-CD                                            
MFA-TR*          ,:WY-TOTAL-AR-BALANCE                                          
MFA-TR*          ,:WY-TOTAL-UTL-BAL                                             
MFA-TR*          ,:WY-TOTAL-NONUTL-BAL                                          
MFA-TR*          ,:WY-UTL-ARREARS-AMT                                           
MFA-TR*          ,:WY-NONUTL-ARREARS-AMT                                        
MFA-TR*          ,:WY-ARNG-DUE-DT       :WS-ARNG-DUE-DT-NULL                    
MFA-TR*          ,:WY-ARNG-SCHD-SEQ                                             
MFA-TR*          ,:WY-CHANGE-COMMENTS                                           
MFA-TR*          ,:WY-LAST-UPDATE-TS                                            
MFA-TR*          ,:WY-LAST-UPDATE-USERID)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8800'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CRED_ARNG_HIST'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'ARNG_ID'                 TO TABLE-ELEMENT-2         
              MOVE 'CRED_ARNG_SEQ_NO'        TO TABLE-ELEMENT-3         
              MOVE WY-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WY-ARNG-ID                TO HOSTVAR-ELEMENT-2       
              MOVE WY-CRED-ARNG-SEQ          TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *---------------------------------------------------------------*         
      * UPDATES STA IN CODES DATA PRESENT                             *         
      *                                                               *         
      *---------------------------------------------------------------*         
       8830-UPDATE-CDP.                                                 
      *                                                                         
           EXEC SQL                                                     
             UPDATE CSS_ACCOUNT                                         
                SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT         
                   ,LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()              
              WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_ACCOUNT                                                 
MFA-TR*         SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT                 
MFA-TR*            ,LAST_UPDATE_TS     = CURRENT TIMESTAMP                      
MFA-TR*       WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8830'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AT-CODES-DATA-PRESENT     TO HOSTVAR-ELEMENT-2       
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODES_DATA_PRESENT'      TO TABLE-ELEMENT-2         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8830-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8840-DELETE-CRED-ARNG-ACTN                                    *         
      *****************************************************************         
       8840-DELETE-CRED-ARNG-ACTN.                                      
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM CSS_CRED_ARNG_ACTN                          
                WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                     
                  AND PROCESSED_FL = ''                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
              WHEN NOT-FOUND                                            
                   CONTINUE                                             
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '8840'                TO ACTIVE-PARAGRAPH       
                   MOVE 'DELETE'              TO ABEND-FUNCTION         
                   MOVE SQLCODE               TO ABEND-SQLCODE          
                   MOVE SPACES                TO ABEND-SQL-PREDICATES   
                                                  ABEND-TABLES          
                   MOVE 'CSS_CRED_ARNG_ACTN'  TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
      *                                                                         
       8840-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00948*****************************************************************         
P00948* 8850-INS-BATCH-EMAIL                                          *         
P00948*****************************************************************         
P00948*                                                                         
P00948 8850-INS-BATCH-EMAIL.                                            
P00948*                                                                         
P00948     MOVE '8850'                        TO ACTIVE-PARAGRAPH       
P00948                                                                  
P00948     EXEC SQL                                                     
P00948          INSERT INTO CSS_BATCH_EMAIL                             
P00948                 (ACCOUNT_NO                                      
P00948                 ,CUSTOMER_NO                                     
P00948                 ,EMAIL_EVENT_CD                                  
P00948                 ,EMAIL_EVENT_DT                                  
P00948                 ,BATCH_EMAIL_ID                                  
P00948                 ,COMPANY_NO)                                     
P00948          VALUES                                                  
P00948                 (:AE-ACCOUNT-NO                                  
P00948                 ,:AE-CUSTOMER-NO                                 
P00948                 ,:AE-EMAIL-EVENT-CD                              
P00948                 ,IIF(TRY_CONVERT(DATE, :AE-EMAIL-EVENT-DT
              ) IS NULL OR (PATINDEX('%.%', :AE-EMAIL-EVENT-DT
              ) <> 0) OR (LEN(:AE-EMAIL-EVENT-DT
              ) <> 10), CIS.CHAR2DATE(:AE-EMAIL-EVENT-DT
              ), CONVERT(DATE, :AE-EMAIL-EVENT-DT) )                           
P00948                 ,:AE-BATCH-EMAIL-ID                              
P00948                 ,:AE-COMPANY-NO)                                 
P00948     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_BATCH_EMAIL                                     
MFA-TR*                (ACCOUNT_NO                                              
MFA-TR*                ,CUSTOMER_NO                                             
MFA-TR*                ,EMAIL_EVENT_CD                                          
MFA-TR*                ,EMAIL_EVENT_DT                                          
MFA-TR*                ,BATCH_EMAIL_ID                                          
MFA-TR*                ,COMPANY_NO)                                             
MFA-TR*         VALUES                                                          
MFA-TR*                (:AE-ACCOUNT-NO                                          
MFA-TR*                ,:AE-CUSTOMER-NO                                         
MFA-TR*                ,:AE-EMAIL-EVENT-CD                                      
MFA-TR*                ,:AE-EMAIL-EVENT-DT                                      
MFA-TR*                ,:AE-BATCH-EMAIL-ID                                      
MFA-TR*                ,:AE-COMPANY-NO)                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00948*                                                                         
P00948     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00948*                                                                         
P00948     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00948        CONTINUE                                                  
P00948     ELSE                                                         
P00948        MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
P00948        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00948        MOVE 'INSERT'                   TO ABEND-FUNCTION         
P00948        MOVE 'CSS_BATCH_EMAIL'          TO TABLE-1                
P00948        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P00948        MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-2        
P00948        MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-3        
P00948        MOVE AE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P00948        MOVE AE-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2      
P00948        MOVE AE-COMPANY-NO              TO HOSTVAR-ELEMENT-3      
P00948        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00948        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00948     END-IF.                                                      
P00948*                                                                         
P00948 8850-EXIT.                                                       
P00948     EXIT.                                                        
P00948*                                                                         
P00948*****************************************************************         
P00948* 8860-INS-BATCH-EMAIL-DET                                      *         
P00948*****************************************************************         
P00948*                                                                         
P00948 8860-INS-BATCH-EMAIL-DET.                                        
P00948*                                                                         
P00948     MOVE '8860'                        TO ACTIVE-PARAGRAPH       
P00948                                                                  
P00948     EXEC SQL                                                     
P00948          INSERT INTO CSS_BTCH_EMAIL_DET                          
P00948                 (BATCH_EMAIL_ID                                  
P00948                 ,FIELD_NAME_TX                                   
P00948                 ,FIELD_VALUE_TX)                                 
P00948          VALUES                                                  
P00948                 (:JK-BATCH-EMAIL-ID                              
P00948                 ,:JK-FIELD-NAME-TX                               
P00948                 ,:JK-FIELD-VALUE-TX)                             
P00948     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00948*                                                                         
P00948     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00948*                                                                         
P00948     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00948        CONTINUE                                                  
P00948     ELSE                                                         
P00948        MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
P00948        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00948        MOVE 'INSERT'                   TO ABEND-FUNCTION         
P00948        MOVE 'CSS_BTCH_EMAIL_DET'       TO TABLE-1                
P00948        MOVE 'BATCH_EMAIL_ID'           TO TABLE-ELEMENT-1        
P00948        MOVE 'FIELD_NAME_TX'            TO TABLE-ELEMENT-2        
P00948        MOVE JK-BATCH-EMAIL-ID          TO HOSTVAR-ELEMENT-1      
P00948        MOVE JK-FIELD-NAME-TX           TO HOSTVAR-ELEMENT-2      
P00948        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00948        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00948     END-IF.                                                      
P00948*                                                                         
P00948 8860-EXIT.                                                       
P00948     EXIT.                                                        
P00948*                                                                         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * INSERT A ROW IN DNP CANCEL TABLE DURING ABEND                 *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       8900-SEND-DONE.                                                  
      *--------------*                                                          
                                                                        
           MOVE ACTIVE-PARAGRAPH TO S-ACTIVE-PARAGRAPH.                 
      *                                                                         
           IF WS-CODE-PENDING-DNP = WS-A                                
              MOVE WS-ACCOUNT-NO       TO XK-ACCOUNT-NO                 
              MOVE WS-UPDATE-ACTION-FL TO XK-SO-UPDT-ACTION-FL          
                                                                        
              EXEC SQL                                                  
                INSERT INTO CSS_SO_DNP_CANCEL                           
                      (ACCOUNT_NO                                       
                      ,SO_UPDT_ACTION_FL                                
                      )                                                 
                VALUES                                                  
                      (:XK-ACCOUNT-NO                                   
                      ,:XK-SO-UPDT-ACTION-FL                            
                      )                                                 
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE        TO WS-ACTIVE-RETURN-CODE              
                                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL -803                       
                 EXEC SQL                                               
                 UPDATE CSS_SO_DNP_CANCEL                               
                    SET SO_UPDT_ACTION_FL = :XK-SO-UPDT-ACTION-FL       
                  WHERE ACCOUNT_NO        = :XK-ACCOUNT-NO              
                 END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                               
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-FACILITY-CODE = 'O' OR 'U'                             
                                 OR 'W' OR 'B' OR 'M' OR 'D' OR 'E'     
              IF DNP-ERROR                                              
                 MOVE 244          TO WS-DNP-RET-CODE                   
              ELSE                                                      
                 MOVE 253          TO WS-DNP-RET-CODE                   
              END-IF                                                    
           ELSE                                                         
              MOVE 9999            TO WS-DNP-RET-CODE                   
           END-IF                                                       
                                                                        
           EXIT PROGRAM                                                 
           .                                                            
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * ROLLBACK ALL CHANGES                                          *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       9100-TERMINATE.                                                  
      *--------------*                                                          
           MOVE '9100'                        TO ACTIVE-PARAGRAPH       
                                                                        
           EXEC  SQL                                                    
               ROLLBACK                                                 
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE                                       
              THRU 8900-EXIT                                            
           .                                                            
       9100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************43310000
      * 9500-CALL-CPD00068                                             *43320000
      ******************************************************************43330000
                                                                        
       9500-CALL-CPD00068.                                              
                                                                        
           IF WS-CALL-TYPE = 'B'                                        
              CALL SCSCB068  USING  CWS00068-FIELDS                     
                                    WS-CODES-DATA-PRESENT               
                                    DCLCSS-ACCOUNT                      
                                    ABEND-FILE                          
                                    RS-RETURN-CODE                      
           ELSE                                                         
              CALL MCSCB068  USING  CWS00068-FIELDS                     
                                    WS-CODES-DATA-PRESENT               
                                    DCLCSS-ACCOUNT                      
                                    ABEND-FILE                          
                                    RS-RETURN-CODE                      
           END-IF                                                       
                                                                        
           MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE              
                                             SQLCODE.                   
                                                                        
           IF ABEND-FUNCTION  > SPACES                                  
              IF ABEND-FUNCTION EQUAL 'BADDATA'                         
                 MOVE -1                  TO S-RETURN-CODE              
                                             WS-ACTIVE-RETURN-CODE      
              END-IF                                                    
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       9500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 42427100
      * 9510-CALL-CPDCB371                                            * 42427200
      *---------------------------------------------------------------* 42427600
                                                                        
       9510-CALL-CPDCB371.                                              
                                                                        
           MOVE SPACES                        TO ABEND-FUNCTION.        
           MOVE ZERO                          TO RS-RETURN-CODE.        
                                                                        
           IF WS-CALL-TYPE = 'B'                                        
              CALL SCSCB371 USING   AT-ACCOUNT-NO                       
                                   ,AT-DATE-BILL-DAY-00                 
                                   ,AT-CREDIT-GROUP                     
                                   ,WS-DNP-COLLECT-AMT                  
                                   ,ABEND-FILE                          
                                   ,RS-RETURN-CODE                      
           ELSE                                                         
              CALL MCSCB371 USING   AT-ACCOUNT-NO                       
                                   ,AT-DATE-BILL-DAY-00                 
                                   ,AT-CREDIT-GROUP                     
                                   ,WS-DNP-COLLECT-AMT                  
                                   ,ABEND-FILE                          
                                   ,RS-RETURN-CODE                      
           END-IF.                                                      
                                                                        
           MOVE RS-RETURN-CODE                TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE          
                                                 SQLCODE.               
                                                                        
           IF ABEND-FUNCTION > SPACES OR WS-ACTIVE-RETURN-CODE NOT      
                                      EQUAL SUCCESSFUL-CALL             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       9510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * CALL CSR00125 TO UPDATE DNP                                   *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       9800-CALL-CSR00125.                                              
      *-------------------*                                                     
           MOVE '9800'                        TO ACTIVE-PARAGRAPH       
                                                                        
      *    EXEC SQL CALL CSR00125                                       
      *            (:WS-SO-ACCOUNT-NO-C                                 
      *            ,:WS-SO-PREMISE-NO-C                                 
      *            ,:WS-SO-USER-ID-C                                    
      *            ,:WS-SO-REMARK-TX-C                                  
      *            ,:WS-SO-UPDATE-REMARKS-C                             
      *            ,:WS-SO-SELECT-UPDATE-C                              
      *            ,:WS-SO-PANEL-NO                                     
      *            ,:WS-SO-ORDER-TYPE-FLAG                              
      *            ,:WS-SO-DNP-CANCEL-REASON                            
      *            )                                                    
      *    END-EXEC                                                     

MSQ001        EXEC SQL
MSQ001          CLOSE C1
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C1
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C1 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = +466                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE '9800'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'DB2SP CALL'               TO ABEND-FUNCTION         
              MOVE 'CSR00125'                 TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'SQLCODE'                  TO TABLE-ELEMENT-2        
              MOVE SQLCODE                    TO HOSTVAR-ELEMENT-2      
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
           .                                                            
       9800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * GET RECONNECT DETAILS                                         *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       9810-CALL-CSR00336.                                              
      *-------------------*                                                     
                                                                        
           MOVE WS-ACCOUNT-NO TO WS-ACCT-NO-C                           
                                                                        
      *    EXEC SQL CALL CSR00336                                       
      *                  (:WS-ACCT-NO-C                                 
      *                  ,'FM006'                                       
      *                  )                                              
      *    END-EXEC                                                     

MSQ001        EXEC SQL
MSQ001          CLOSE C8
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C8
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C8 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '9810'                     TO ACTIVE-PARAGRAPH       
              MOVE 'DB2 SP CALL'              TO ABEND-FUNCTION         
              MOVE 'CSR00336'                 TO TABLE-1                
              MOVE 'WS-ACTIVE-RETURN-CODE'    TO TABLE-ELEMENT-1        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *                 (:LOC8)                                         
      *            WITH PROCEDURE CSR00336                              
      *    END-EXEC                                                     
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE C8 CURSOR FOR RESULT SET                         
      *       :LOC8                                                     
      *    END-EXEC                                                     
                                                                        
           EXEC SQL                                                     
              FETCH C8 INTO                                             
                    :WS-RETURN-CODE                                     
                   ,:WS-SERV-ORDER-NO-D                                 
                   ,:WS-ORDER-STATE-CD                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '9810'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'RESULT_SET_CSR'           TO TABLE-1                
              MOVE 'WS-ACTIVE-RETURN-CODE'    TO TABLE-ELEMENT-1        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
           .                                                            
       9810-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * UPDATE RECONNECT DETAILS                                      *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       9820-CALL-CSR00337.                                              
      *-------------------*                                                     
                                                                        
           MOVE WS-SERV-ORDER-NO-D TO WS-SERV-ORDER-NO-I                
                                                                        
      *    EXEC SQL CALL CSR00337                                       
      *                 (:WS-SERV-ORDER-NO-C                            
      *                 )                                               
      *    END-EXEC                                                     

MSQ001        EXEC SQL
MSQ001          CLOSE C9
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C9
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C9 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '9820'                     TO ACTIVE-PARAGRAPH       
              MOVE 'DB2 SP CALL'              TO ABEND-FUNCTION         
              MOVE 'CSR00337'                 TO TABLE-1                
              MOVE 'WS-ACTIVE-RETURN-CODE'    TO TABLE-ELEMENT-1        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *                 (:LOC9)                                         
      *            WITH PROCEDURE CSR00337                              
      *    END-EXEC                                                     
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE C9 CURSOR FOR RESULT SET                         
      *       :LOC9                                                     
      *    END-EXEC                                                     
                                                                        
           EXEC SQL                                                     
              FETCH C9 INTO                                             
                    :WS-RETURN-CODE                                     
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
           IF WS-RETURN-CODE = SUCCESSFUL-CALL                          
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '9820'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'RESULT_SET_CSR'           TO TABLE-1                
              MOVE 'WS-ACTIVE-RETURN-CODE'    TO TABLE-ELEMENT-1        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
           .                                                            
       9820-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * UPDATES CSS_ACCOUNT AND CREDIT PROFILE                        *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       9830-CALL-CSR02122.                                              
      *-------------------*                                                     
      *    EXEC SQL CALL CSR02122                                       
      *                 (:WS-ACCT-NO-C                                  
      *                 ,:WS-WQ-PREMISE-NO-C                            
      *                 ,:WS-ORDER-REASON                               
      *                 ,:WS-SO-DNP-CANCEL-REASON                       
      *                 ,:WS-PENDING-DNP-FLAG                           
      *                 ,:WS-UPDATE-PROFILE                             
      *                 ,:WS-AMOUNT-DISC-BAL                            
      *                 ,:WS-SO-PANEL-NO                                
      *                 ,:WS-ORDER-TYPE-CD                              
      *                 ,:WS-SO-REMARK-TX-C                             
      *                 )                                               
      *    END-EXEC                                                     

MSQ001        EXEC SQL
MSQ001          CLOSE C10
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C10
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C10 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '9830'                     TO ACTIVE-PARAGRAPH       
              MOVE 'DB2 SP CALL'              TO ABEND-FUNCTION         
              MOVE 'CSR02122'                 TO TABLE-1                
              MOVE 'WS-ACTIVE-RETURN-CODE'    TO TABLE-ELEMENT-1        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *                 (:LOC10)                                        
      *            WITH PROCEDURE CSR02122                              
      *    END-EXEC                                                     
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE C10 CURSOR FOR RESULT SET                        
      *       :LOC10                                                    
      *    END-EXEC                                                     
                                                                        
           EXEC SQL                                                     
              FETCH C10 INTO                                            
                    :WS-RETURN-CODE                                     
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '9830'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'RESULT_SET_CSR'           TO TABLE-1                
              MOVE 'WS-ACTIVE-RETURN-CODE'    TO TABLE-ELEMENT-1        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
           .                                                            
       9830-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * INSERT A WORK QUEUE                                           *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       9850-CALL-CSR04675.                                              
      *-------------------*                                                     
           MOVE ZERO                        TO WS-WQ-ITEM-ID            
           MOVE WS-PROGRAM-NAME             TO WS-WQ-CREATED-BY         
                                                                        
      *    EXEC SQL                                                     
      *        CALL CSR04675                                            
      *             (:WS-WQ-ITEM-ID                                     
      *            ,:WS-WQ-ROUTING-CATGRY-C                             
      *            ,:WS-WQ-LOCAL-OFFICE-C                               
      *            ,:WS-WQ-USER-ID-ORIG-C                               
      *            ,:WS-WQ-USER-ID-ASGN-C                               
      *            ,:WS-WQ-RESP-AREA-ID-C                               
      *            ,:WS-WQ-CATEGORY-ID-D                                
      *            ,:WS-WQ-ACCOUNT-NO-D                                 
      *            ,:WS-WQ-PREMISE-NO-D                                 
      *            ,:WS-WQ-CUSTOMER-NO-D                                
      *            ,:WS-WQ-SERV-ORDER-NO-D                              
      *            ,:WS-WQ-COMMENTS-C                                   
      *            ,:WS-WQ-DATE-REQUIRED                                
      *            ,:WS-WQ-DATE-CREATED                                 
      *            ,:WS-WQ-PRIORITY-C                                   
      *            ,:WS-WQ-FREE-FORM-AREA-C                             
      *            ,:WS-WQ-CREATED-BY                                   
      *            )                                                    
      *    END-EXEC                                                     

MSQ001        EXEC SQL
MSQ001          CLOSE C3
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C3
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C3 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '9850'                     TO ACTIVE-PARAGRAPH       
              MOVE 'DB2 SP CALL'              TO ABEND-FUNCTION         
              MOVE 'CSR04675'                 TO TABLE-1                
              MOVE 'WS-ACTIVE-RETURN-CODE'    TO TABLE-ELEMENT-1        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *                 (:LOC3)                                         
      *            WITH PROCEDURE CSR04675                              
      *    END-EXEC                                                     
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE C3 CURSOR FOR RESULT SET                         
      *       :LOC3                                                     
      *    END-EXEC                                                     
                                                                        
           EXEC SQL                                                     
              FETCH C3 INTO                                             
                    :WS-SO-RETURN-CD                                    
                   ,:WS-WQ-ITEM-ID                                      
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '9850'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'RESULT_SET_CSR'           TO TABLE-1                
              MOVE 'WS-ACTIVE-RETURN-CODE'    TO TABLE-ELEMENT-1        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
           .                                                            
       9850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * UPDATES SO DATA                                               *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       9860-CALL-CSR04422.                                              
      *-------------------*                                                     
           MOVE '9860'                        TO ACTIVE-PARAGRAPH       
                                                                        
      *    EXEC SQL CALL CSR04422                                       
      *                ( :WS-SO-ACCOUNT-NO-C                            
      *                 ,:WS-SO-ORDER-TYPE-CD-C                         
      *                )                                                
      *    END-EXEC                                                     

MSQ001        EXEC SQL
MSQ001          CLOSE C4
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C4
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C4 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
           IF WS-ACTIVE-RETURN-CODE = +466                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE -1                         TO WS-ACTIVE-RETURN-CODE  
              MOVE '9860'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'DB2SP CALL'               TO ABEND-FUNCTION         
              MOVE 'CSR04422'                 TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'SQLCODE'                  TO TABLE-ELEMENT-2        
              MOVE SQLCODE                    TO HOSTVAR-ELEMENT-2      
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
           .                                                            
       9860-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
      * GETS CREW ID AND WORK AREA TX                                 *         
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
       9870-CALL-CSR00423.                                              
      *-------------------*                                                     
                                                                        
           MOVE WS-SERV-ORDER-CHAR TO WS-SERV-ORDER-NO-C                
           MOVE WS-SERV-ORDER-NO-I TO WS-SERV-ORDER-NO-D                
                                                                        
      *    EXEC SQL                                                     
      *        CALL CSR00423                                            
      *             (:WS-SERV-ORDER-NO-D                                
      *             )                                                   
      *    END-EXEC                                                     

MSQ001        EXEC SQL
MSQ001          CLOSE C2
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C2
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C2 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '9870'                     TO ACTIVE-PARAGRAPH       
              MOVE 'DB2 SP CALL'              TO ABEND-FUNCTION         
              MOVE 'CSR00423'                 TO TABLE-1                
              MOVE 'WS-ACTIVE-RETURN-CODE'    TO TABLE-ELEMENT-1        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF                                                       
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *                 (:LOC2)                                         
      *            WITH PROCEDURE CSR00423                              
      *    END-EXEC                                                     
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE C2 CURSOR FOR RESULT SET                         
      *       :LOC2                                                     
      *    END-EXEC                                                     
                                                                        
           EXEC SQL                                                     
              FETCH C2 INTO                                             
                    :WS-RETURN-CODE                                     
                   ,:WS-LOCAL-OFFICE :WS-IND-01                         
                   ,:WS-WORK-AREA :WS-IND-02                         
                   ,:WS-CREW-ID :WS-IND-04                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-IND-01 = -1                                         
                 MOVE SPACES TO WS-LOCAL-OFFICE                         
              END-IF                                                    
              IF WS-IND-02 = -1                                         
                 MOVE SPACES TO WS-WORK-AREA                            
              END-IF                                                    
              IF WS-IND-04 = -1                                         
                 MOVE SPACES TO WS-CREW-ID                              
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '9870'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'RESULT_SET_CSR'           TO TABLE-1                
              MOVE 'WS-ACTIVE-RETURN-CODE'    TO TABLE-ELEMENT-1        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9100-TERMINATE                                    
                 THRU 9100-EXIT                                         
           END-IF.                                                      
                                                                        
       9870-EXIT.                                                       
           EXIT.                                                        
