      *****************************************************************         
      *    6500-GET-NEXT-BUSINESS-DAY                                **         
      *                                                              **         
      *    FINDS THE NEXT BUSINESS DAY, SKIPPING OVER WEEKENDS       **         
      *    AND HOLIDAYS (FOUND IN CSS_HOLIDAY), AFTER THE CURRENT    **         
      *    VALUE IN WS-NEW-BUSINESS-DAY WHEN 6500 WAS CALLED.        **         
      *                                                              **         
      *    THE COPYBOOK CWS00315 IS NECESSARY FOR THIS TO WORK.      **         
      *    THIS CODE WAS COPIED FROM CPD00315 AND THE ERROR          **         
      *    ROUTINE WAS CHANGED TO COMPLY WITH ON-LINE ERROR LOGIC    **         
      *                                                              **         
      *****************************************************************         
       6500-GET-NEXT-BUSINESS-DAY.                                      
      *                                                                         
           EXEC SQL                                                     
T36611       SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) ) ),
              (CIS.DAYS(DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) ) )) -       
T36611                CIS.DAYS(DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) ) ))/7*7)+1
            INTO
              :WS-NEW-BUSINESS-DAY,
              :WS-DAY-OF-WEEK  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-NEW-BUSINESS-DAY =                                         
MFA-TR*               DATE(:WS-NEW-BUSINESS-DAY) + 1 DAYS,                      
MFA-TR*          :WS-DAY-OF-WEEK =                                              
MFA-TR*              (DAYS(DATE(:WS-NEW-BUSINESS-DAY) + 1 DAYS) -               
MFA-TR*               DAYS(DATE(:WS-NEW-BUSINESS-DAY) + 1 DAYS)/7*7)+1          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '6500'               TO ACTIVE-PARAGRAPH             
T36611        MOVE 'SET'                TO ABEND-FUNCTION               
C25923*       MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              16780000
C25923*       MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            16790000
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      ***  CHECK TO SEE IF IT IS A WEEKEND...                                   
           IF WS-DAY-OF-WEEK NOT EQUAL WS-SATURDAY AND                  
              WS-DAY-OF-WEEK NOT EQUAL WS-SUNDAY                        
                                                                        
              MOVE WS-NEW-BUSINESS-DAY       TO J8-HOLIDAY-DT           
              MOVE 'N'                       TO WS-HOLIDAY-EXISTS       
                                                                        
      ***  ...IF NOT A WEEKEND, THEN CHECK TO SEE IF IT IS A HOLIDAY            
              EXEC SQL                                                  
                  SELECT DISTINCT('Y')                                  
                  INTO   :WS-HOLIDAY-EXISTS                             
                  FROM   CSS_HOLIDAY WITH(READUNCOMMITTED)                      
                  WHERE  HOLIDAY_DT = IIF(TRY_CONVERT(DATE, 
                                                         :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                    
T36611                                                         
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*           SELECT DISTINCT('Y')                                          
MFA-TR*           INTO   :WS-HOLIDAY-EXISTS                                     
MFA-TR*           FROM   CSS_HOLIDAY                                            
MFA-TR*           WHERE  HOLIDAY_DT = :J8-HOLIDAY-DT                            
MFA-TR*           WITH   UR                                                     
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
T36611        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
T36611           IF WS-ACTIVE-RETURN-CODE NOT EQUAL NOT-FOUND           
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '6500'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_HOLIDAY'        TO TABLE-1                 
                   MOVE 'HOLIDAY_DT'         TO TABLE-ELEMENT-1         
                   MOVE J8-HOLIDAY-DT        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
                 END-IF                                                 
              END-IF                                                    
              IF HOLIDAY-EXISTS-NO                                      
                  MOVE 'Y'                   TO WS-NEXT-BUSINESS-DAY    
              ELSE                                                      
                  MOVE 'N'                   TO WS-NEXT-BUSINESS-DAY    
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       6500-NEXT-BUSINESS-DAY-EXIT.                                     
           EXIT.                                                        
