      ***************************************************************** 00010000
      ** CPD0309A  COPYBOOK TO DETERMINE THE NEXT BILL DATE          ** 00020000
      **                     RELEASE 1.0                             ** 00030000
      **=============================================================** 00040000
      **  >>>>> IMPORTANT NOTE >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>** 00040000
      ** IF CHANGES ARE REQUIRED FOR THIS COPYBOOK PLEAST VISIT      ** 00040000
      ** COPYBOOK CPD00309. CPD00309A IS CLONE OF CPD00309 WITH      ** 00040000
      ** CURRENT DATE CHECK IT 7915-SELECT-BILL-DATE-CSR.            ** 00040000
      **=============================================================** 00040000
      **  WS-REFERENCE:  COPYBOOKS: CWS00309 (WORKING STORAGE)       ** 00050000
      **                 TABLES:    TBBILWDW                         ** 00060000
      **                            TBACCT                           ** 00070000
      **                                                             ** 00080000
      **  PROCEDURE REFERENCE:                                       ** 00090000
      **                                                             ** 00100000
      **  PREREQUISITES: THE WORKING STORAGE VARIABLES FOR           ** 00110000
      **                 AT-CODE-BILL-FREQ AND AT-REV-MTH-LST-NRML   ** 00120000
      **                 MUST BE POPULATED PRIOR TO CALLING THIS     ** 00130000
      **                 ROUTINE.                                    ** 00140000
      **                                                             ** 00150000
      **  ADDITIONAL INFORMATION:                                    ** 00160000
      **    THIS COPYBOOK WILL DETERMINE THE NEXT BILLING DATE       ** 00170000
      **    RELATIVE TO A DATE PASSED IN VARIABLE WS-CURRENT-DATE.   ** 00180000
      **    WS-CURRENT-DATE SHOULD CONTAIN THE CURRENT DATE IN       ** 00190000
      **    DB2 FORMAT (CCYY-MM-DD).  IF MULTIPLE BILLING DATES ARE  ** 00200000
      **    REQUIRED (I.E. FOR DFA/DPP), THE FIRST CALL TO THIS      ** 00210000
      **    ROUTINE SHOULD PASS THE CURRENT SYSTEM DATE AND THE      ** 00220000
      **    SUBSEQUENT CALLS WILL PASS BN-DATE-EXTRACT RETURNED      ** 00230000
      **    FROM THE FIRST CALL.                                     ** 00240000
      **    THE NEXT BILL DATE WILL BE PASSED VIA BN-DATE-EXTRACT.   ** 00250000
      **                                                             ** 00260000
      ***************************************************************** 00270000
      ***************************************************************** 00280000
      *   MODIFICATION LOG -                                          * 00290000
      *                                                               * 00300000
      *   DATE     INITIALS        COMMENTS                           * 00310000
      *                                                               * 00320000
      * 02/05/97     JEP           FIRST RELEASE                      * 00330000
      * 04/18/97     PP            REMOVED POPULATION OF RS-RETURN-   * 00340000
      *                            CODE.                              * 00350000
T16560* 08/13/98     SHF           ADDED NULL INDICATOR TO CURSORS.   * 00351000
T17869* 09/21/98     KSB           DEFAULT BILL FREQ TO 'M01' IF SPACE* 00352000
T34621* 08/01/06     MADHAVI       FIX NEXT BILL DATE ORDER. CURSORS  * 00352100
      *                            REPLACED WITH SINGLTON SELECT FOR    00352200
      *                            PERFORMANCE REASONS.                 00352300
T34621* 03/05/07     VIJAY         DISPLAY CORRECT NEXT BILL DATE FOR * 00352100
T34621*                            THE ACCOUNT YET TO BILL FIRST TIME.* 00352100
C36675* 02/07/08     VIJAY   ADD DATE_EXTRACT PREDICATE TO FORCE TO     00352100
C36675*                      USE INDEX NXBNU04(MEA AND SUE REQUESTED)   00352100
A37276* 12/03/08     SS42021 ADDED CHECK REV MTH >= IN PLACE OF       *         
      *                      REV MTH = IN 7915-SELECT-BILL-DATE-CSR   *         
      *                      TO AVOID BLANK BILL DATES FOR NEW ACCTS W*         
      *                      BILL CYCLES THAT HAVE CLOSED FOR THE CURR*         
      *                      REVENUE MONTH.                           *         
P00453* 08/17/11     SP95538       FOR PRP ACCT AND FIRST BILL GET    * 00352100
P00453*                            THE REVENUE MONTH.                 * 00352200
      ***************************************************************** 00360000
       5900-NEXT-BILL-DATE.                                             
      *                                                                 00380000
           MOVE '5900' TO ACTIVE-PARAGRAPH.                             
      *                                                                 00400000
T17869     IF AT-CODE-BILL-FREQ <= SPACES                               
T17869        MOVE 'M01'   TO   WS-CODE-BILL-FREQ                       
T17869     ELSE                                                         
              MOVE AT-CODE-BILL-FREQ   TO WS-CODE-BILL-FREQ             
T17869     END-IF.                                                      
           MOVE AT-REV-MTH-LST-NRML TO WS-LST-REV-MTH-NRML.             
           MOVE AT-BILL-CYCLE       TO BN-BILL-CYCLE.                   
      *                                                                         
T16560     IF WS-CURRENT-DATE = SPACES                                  
T16560         MOVE -1 TO WS-CURRENT-DATE-NI                            
T16560     ELSE                                                         
T16560         MOVE 0 TO WS-CURRENT-DATE-NI                             
T16560     END-IF.                                                      
      *                                                                         
P00453     IF AT-CODES-DATA-PRESENT > SPACES AND                        
P00453                                      AT-LAST-NRML-BILL-NO  > 0   
P00453        MOVE AT-CODES-DATA-PRESENT TO WS-CWS309-CODES-DATA-PRESENT
P00453        MOVE AT-LAST-NRML-BILL-NO  TO WS-CWS309-LAST-NRML-BILL-NO 
           ELSE                                                         
P00453        PERFORM 7925-SELECT-ACCOUNT THRU 7925-ACCOUNT-EXIT        
P00453     END-IF.                                                      
P00453     IF WS-CWS309-CODES-DATA-PRESENT(15:1) = 'A' AND              
P00453                                  WS-CWS309-LAST-NRML-BILL-NO = 1 
P00453        PERFORM 7912-COMMON-REV-MONTH                             
P00453           THRU 7912-COMMON-REV-MONTH-EXIT                        
P00453        PERFORM 7915-SELECT-BILL-DATE-CSR                         
P00453           THRU 7915-BILL-DATE-CSR-EXIT                           
P00453     ELSE                                                         
              IF WS-FREQ-CODE-LIT EQUAL 'M'                             
T34621          IF WS-LST-REV-MTH-NRML > 0                              
T34621            PERFORM 7905-SELECT-BILL-DATE-CSR                     
T34621                THRU 7905-EXIT                                    
T34621          ELSE                                                    
T34621             PERFORM 7911-GET-REVENUE-MONTH                       
T34621                THRU 7911-GET-REVENUE-MONTH-EXIT                  
T34621             IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
T34621                 PERFORM 7912-COMMON-REV-MONTH                    
T34621                    THRU 7912-COMMON-REV-MONTH-EXIT               
T34621             END-IF                                               
T34621             PERFORM 7915-SELECT-BILL-DATE-CSR                    
T34621                THRU 7915-BILL-DATE-CSR-EXIT                      
T34621          END-IF                                                  
              ELSE                                                      
T34621           PERFORM 7920-SELECT-BILL-DATE-CSR                      
T34621              THRU 7920-BILL-DATE-CSR-EXIT                        
              END-IF                                                    
P00453     END-IF.                                                      
      *                                                                 00600000
       5900-NEXT-BILL-DATE-EXIT.                                        
           EXIT.                                                        
      *                                                                 00630000
      ***************************************************************** 01070000
      ** CSS_BILL_WINDOW FOR MONTHLY BILLED ACCOUNTS **                 01080000
      ***************************************************************** 01090000
T34621 7905-SELECT-BILL-DATE-CSR.                                       
                                                                        
           MOVE '7905' TO  ACTIVE-PARAGRAPH.                            
      *                                                                 01130000
           EXEC SQL                                                     
               SELECT TOP(1) DATE_EXTRACT,
              REVENUE_MONTH                                     
                 INTO :BN-DATE-EXTRACT :WS-NULL-DATE-EXTRACT,            
                      :BN-REVENUE-MONTH                                 
                 FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                     
                WHERE BILL_CYCLE    = :BN-BILL-CYCLE                    
                  AND REVENUE_MONTH > :WS-LST-REV-MTH-NRML              
C36675            AND DATE_EXTRACT  = DATE_EXTRACT                      
                ORDER BY DATE_EXTRACT, REVENUE_MONTH ASC                
                                                    
                                                                 
T34621      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     01130100
MFA-TR*        SELECT DATE_EXTRACT                                      01150300
MFA-TR*              ,REVENUE_MONTH                                     01150400
MFA-TR*          INTO :BN-DATE-EXTRACT:WS-NULL-DATE-EXTRACT,            01150410
MFA-TR*               :BN-REVENUE-MONTH                                 01150420
MFA-TR*          FROM CSS_BILL_WINDOW                                   01150430
MFA-TR*         WHERE BILL_CYCLE    = :BN-BILL-CYCLE                    01150500
MFA-TR*           AND REVENUE_MONTH > :WS-LST-REV-MTH-NRML              01150600
MFA-TR*           AND DATE_EXTRACT  = DATE_EXTRACT                      01150700
MFA-TR*         ORDER BY DATE_EXTRACT, REVENUE_MONTH ASC                01150700
MFA-TR*         FETCH FIRST ROW ONLY                                    01150800
MFA-TR*         WITH UR                                                         
MFA-TR*     END-EXEC.                                                   01150900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 01190000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           WS-DISP-RETURN-CODE.                         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-NULL-DATE-EXTRACT < ZERO                            
              OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE SPACES TO BN-DATE-EXTRACT                         
                 MOVE ZEROES TO BN-REVENUE-MONTH                        
              ELSE                                                      
                 MOVE PROGRAM-NAME TO ABEND-PROGRAM                     
                 MOVE '7905' TO ACTIVE-PARAGRAPH                        
                 MOVE 'SELECT' TO ABEND-FUNCTION                        
                 MOVE SPACES TO ABEND-SQL-PREDICATES                    
                                        ABEND-TABLES                    
                 MOVE 'CSS_BILL_WINDOW'  TO TABLE-1                     
                 MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1                  
                 MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                
                 PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
              END-IF                                                    
           END-IF.                                                      
      *                                                                 01420000
       7905-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01760000
T34621***************************************************************** 01070000
      ** FOR NOT YET BILLED ACCOUNT USE CURRENT DATE AND CYCLE TO GET   01080000
      ** REVENUE MONTH.                                                 01080000
      ***************************************************************** 01090000
       7911-GET-REVENUE-MONTH.                                          
                                                                        
           MOVE '7911' TO  ACTIVE-PARAGRAPH.                            
      *                                                                 01130000
           EXEC SQL                                                     
               SELECT REVENUE_MONTH                                     
                 INTO :WS-LST-REV-MTH-NRML                              
                 FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                     
             WHERE BILL_CYCLE   = :BN-BILL-CYCLE                        
C36675         AND (DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                      :WS-CURRENT-DATE 
                                                    :WS-CURRENT-DATE-NI
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE 
                                                    :WS-CURRENT-DATE-NI
              ) <> 0) OR (LEN(:WS-CURRENT-DATE :WS-CURRENT-DATE-NI
              ) <> 10), CIS.CHAR2DATE(:WS-CURRENT-DATE 
                                                    :WS-CURRENT-DATE-NI
              ), CONVERT(DATE, :WS-CURRENT-DATE :WS-CURRENT-DATE-NI) ) 
C36675           OR DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                      :WS-CURRENT-DATE 
                                                    :WS-CURRENT-DATE-NI
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE 
                                                    :WS-CURRENT-DATE-NI
              ) <> 0) OR (LEN(:WS-CURRENT-DATE :WS-CURRENT-DATE-NI
              ) <> 10), CIS.CHAR2DATE(:WS-CURRENT-DATE 
                                                    :WS-CURRENT-DATE-NI
              ), CONVERT(DATE, :WS-CURRENT-DATE :WS-CURRENT-DATE-NI) ))
                                                                 
T34621      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     01130100
MFA-TR*        SELECT REVENUE_MONTH                                     01150400
MFA-TR*          INTO :WS-LST-REV-MTH-NRML                              01150420
MFA-TR*          FROM CSS_BILL_WINDOW                                   01150430
MFA-TR*      WHERE BILL_CYCLE   = :BN-BILL-CYCLE                        01150500
MFA-TR*        AND (DATE_EXTRACT = :WS-CURRENT-DATE :WS-CURRENT-DATE-NI         
MFA-TR*          OR DATE_EXTRACT = :WS-CURRENT-DATE :WS-CURRENT-DATE-NI)        
MFA-TR*         WITH UR                                                 01150800
MFA-TR*     END-EXEC.                                                   01150900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 01190000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           WS-DISP-RETURN-CODE.                         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
                 MOVE PROGRAM-NAME TO ABEND-PROGRAM                     
                 MOVE '7911' TO ACTIVE-PARAGRAPH                        
                 MOVE 'SELECT' TO ABEND-FUNCTION                        
                 MOVE SPACES TO ABEND-SQL-PREDICATES                    
                                        ABEND-TABLES                    
                 MOVE 'CSS_BILL_WINDOW'  TO TABLE-1                     
                 MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1                  
                 MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                
                 PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                 01420000
       7911-GET-REVENUE-MONTH-EXIT.                                     
           EXIT.                                                        
      *                                                                 01760000
T34621***************************************************************** 01070000
      ** GET REVENUE FROM COMMON                                        01080000
      ***************************************************************** 01090000
T34621 7912-COMMON-REV-MONTH.                                           
                                                                        
           MOVE '7912' TO  ACTIVE-PARAGRAPH.                            
      *                                                                 01130000
           EXEC SQL                                                     
                SELECT PARM_DATA                                        
                 INTO :WS-JOB-PARM-DATA                                 
                 FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                        
                WHERE PROGRAM_NAME = 'COMMON'                           
                  AND COMPANY_NO   = '01'                               
                  AND CMND_CODE    = 'DATE'                             
                  AND SEQ_NO       = 20                                 
                  AND STATUS       = 'A'                                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     01130100
MFA-TR*         SELECT PARM_DATA                                                
MFA-TR*          INTO :WS-JOB-PARM-DATA                                 01150420
MFA-TR*          FROM CSS_JOB_PARM                                              
MFA-TR*         WHERE PROGRAM_NAME = 'COMMON'                                   
MFA-TR*           AND COMPANY_NO   = '01'                                       
MFA-TR*           AND CMND_CODE    = 'DATE'                                     
MFA-TR*           AND SEQ_NO       = 20                                         
MFA-TR*           AND STATUS       = 'A'                                        
MFA-TR*     WITH UR                                                             
MFA-TR*    END-EXEC.                                                    01130100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 01190000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           WS-DISP-RETURN-CODE.                         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-JOB-PARM-DATA (15:6) TO WS-REVENUE-MONTH-309      
              MOVE WS-REVENUE-MONTH-309 TO WS-LST-REV-MTH-NRML          
           ELSE                                                         
                 MOVE PROGRAM-NAME TO ABEND-PROGRAM                     
                 MOVE '7912' TO ACTIVE-PARAGRAPH                        
                 MOVE 'SELECT' TO ABEND-FUNCTION                        
                 MOVE SPACES TO ABEND-SQL-PREDICATES                    
                                        ABEND-TABLES                    
                 MOVE 'CSS_JOB_PARM'     TO TABLE-1                     
                 MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1                  
                 MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                
                 PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                 01420000
T34621 7912-COMMON-REV-MONTH-EXIT.                                      
           EXIT.                                                        
      *                                                                 01420000
T34621***************************************************************** 01070000
      ** SELECT BILL DATE FOR THE MONTH.                                01080000
      ***************************************************************** 01090000
       7915-SELECT-BILL-DATE-CSR.                                       
           MOVE '7915' TO  ACTIVE-PARAGRAPH.                            
      *                                                                 01130000
           EXEC SQL                                                     
               SELECT TOP(1) DATE_EXTRACT,
              REVENUE_MONTH                                     
                 INTO :BN-DATE-EXTRACT :WS-NULL-DATE-EXTRACT,            
                      :BN-REVENUE-MONTH                                 
              FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                        
             WHERE BILL_CYCLE    = :BN-BILL-CYCLE                       
A37276         AND REVENUE_MONTH >= :WS-LST-REV-MTH-NRML                
T34621         AND DATE_EXTRACT >= IIF(TRY_CONVERT(DATE, 
                                                      :WS-CURRENT-DATE 
                                                    :WS-CURRENT-DATE-NI
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE 
                                                    :WS-CURRENT-DATE-NI
              ) <> 0) OR (LEN(:WS-CURRENT-DATE :WS-CURRENT-DATE-NI
              ) <> 10), CIS.CHAR2DATE(:WS-CURRENT-DATE 
                                                    :WS-CURRENT-DATE-NI
              ), CONVERT(DATE, :WS-CURRENT-DATE :WS-CURRENT-DATE-NI) ) 
             ORDER BY DATE_EXTRACT, REVENUE_MONTH ASC                   
                                                    
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     01130100
MFA-TR*        SELECT DATE_EXTRACT                                      01150300
MFA-TR*              ,REVENUE_MONTH                                     01150400
MFA-TR*          INTO :BN-DATE-EXTRACT:WS-NULL-DATE-EXTRACT,            01150410
MFA-TR*               :BN-REVENUE-MONTH                                 01150420
MFA-TR*       FROM CSS_BILL_WINDOW                                      01150430
MFA-TR*      WHERE BILL_CYCLE    = :BN-BILL-CYCLE                       01150500
MFA-TR*        AND REVENUE_MONTH >= :WS-LST-REV-MTH-NRML                01150600
MFA-TR*        AND DATE_EXTRACT >= :WS-CURRENT-DATE :WS-CURRENT-DATE-NI 01150600
MFA-TR*      ORDER BY DATE_EXTRACT, REVENUE_MONTH ASC                   01150700
MFA-TR*      FETCH FIRST ROW ONLY                                       01150800
MFA-TR*      WITH UR                                                    01150800
MFA-TR*     END-EXEC.                                                   01150900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 01190000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           WS-DISP-RETURN-CODE.                         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-NULL-DATE-EXTRACT < ZERO                            
              OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE SPACES TO BN-DATE-EXTRACT                         
                 MOVE ZEROES TO BN-REVENUE-MONTH                        
              ELSE                                                      
                 MOVE PROGRAM-NAME TO ABEND-PROGRAM                     
                 MOVE '7915' TO ACTIVE-PARAGRAPH                        
                 MOVE 'SELECT' TO ABEND-FUNCTION                        
                 MOVE SPACES TO ABEND-SQL-PREDICATES                    
                                        ABEND-TABLES                    
                 MOVE 'CSS_BILL_WINDOW'  TO TABLE-1                     
                 MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1                  
                 MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                
                 PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
              END-IF                                                    
           END-IF.                                                      
      *                                                                 01420000
       7915-BILL-DATE-CSR-EXIT.                                         
T34621     EXIT.                                                        
T34621***************************************************************** 02210000
      ** CSS_BILL_WINDOW FOR B/Q/S/Y BILLED ACCOUNTS **                 02220000
      ***************************************************************** 02230000
       7920-SELECT-BILL-DATE-CSR.                                       
                                                                        
           MOVE '7920' TO  ACTIVE-PARAGRAPH.                            
      *                                                                 02270000
           EXEC SQL                                                     
             SELECT TOP(1) DATE_EXTRACT,
              REVENUE_MONTH                                       
                 INTO :BN-DATE-EXTRACT :WS-NULL-DATE-EXTRACT,            
                      :BN-REVENUE-MONTH                                 
               FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                       
              WHERE BILL_CYCLE    = :BN-BILL-CYCLE                      
                AND REVENUE_MONTH > :WS-LST-REV-MTH-NRML                
                AND CIS.SUBSTR3$(CIS.DIGITS(REVENUE_MONTH), 5, 2) = 
                                                         :WS-BILL-MONTH  
                ORDER BY DATE_EXTRACT, REVENUE_MONTH ASC                
                                                    
                                                                 
T34621     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     02270100
MFA-TR*      SELECT DATE_EXTRACT                                        02270200
MFA-TR*            ,REVENUE_MONTH                                       02270300
MFA-TR*          INTO :BN-DATE-EXTRACT:WS-NULL-DATE-EXTRACT,            02270400
MFA-TR*               :BN-REVENUE-MONTH                                 02270500
MFA-TR*        FROM CSS_BILL_WINDOW                                     02270600
MFA-TR*       WHERE BILL_CYCLE    = :BN-BILL-CYCLE                      02270700
MFA-TR*         AND REVENUE_MONTH > :WS-LST-REV-MTH-NRML                02270800
MFA-TR*         AND SUBSTR(DIGITS(REVENUE_MONTH),5,2) = :WS-BILL-MONTH  02270900
MFA-TR*         ORDER BY DATE_EXTRACT, REVENUE_MONTH ASC                02270910
MFA-TR*       FETCH FIRST ROW ONLY                                      02271100
MFA-TR*       WITH UR                                                   02271100
MFA-TR*    END-EXEC.                                                    02271110

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 02330000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           WS-DISP-RETURN-CODE.                         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-NULL-DATE-EXTRACT < ZERO                            
              OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE SPACES TO BN-DATE-EXTRACT                         
                 MOVE ZEROES TO BN-REVENUE-MONTH                        
              ELSE                                                      
                 MOVE PROGRAM-NAME TO ABEND-PROGRAM                     
                 MOVE '7920' TO ACTIVE-PARAGRAPH                        
                 MOVE 'SELECT' TO ABEND-FUNCTION                        
                 MOVE SPACES TO ABEND-SQL-PREDICATES                    
                                        ABEND-TABLES                    
                 MOVE 'CSS_BILL_WINDOW'  TO TABLE-1                     
                 MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1                  
                 MOVE AT-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                
                 PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
              END-IF                                                    
           END-IF.                                                      
      *                                                                 02560000
       7920-BILL-DATE-CSR-EXIT.                                         
           EXIT.                                                        
P00453*                                                                 02560000
P00453***************************************************************** 02210000
P00453** 7925-SELECT-ACCOUNT                                         ** 02220000
P00453***************************************************************** 02230000
P00453 7925-SELECT-ACCOUNT.                                             
P00453                                                                  
P00453     MOVE '7925' TO  ACTIVE-PARAGRAPH.                            
P00453*                                                                 02270000
P00453     EXEC SQL                                                     
P00453       SELECT AT.CODES_DATA_PRESENT                               
P00453             ,AT.LAST_NRML_BILL_NO                                
P00453         INTO :WS-CWS309-CODES-DATA-PRESENT                       
P00453             ,:WS-CWS309-LAST-NRML-BILL-NO                        
P00453         FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
P00453        WHERE AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                   
P00453                                                           
P00453     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02270100
MFA-TR*      SELECT AT.CODES_DATA_PRESENT                               02270200
MFA-TR*            ,AT.LAST_NRML_BILL_NO                                02270300
MFA-TR*        INTO :WS-CWS309-CODES-DATA-PRESENT                       02270400
MFA-TR*            ,:WS-CWS309-LAST-NRML-BILL-NO                        02270500
MFA-TR*        FROM CSS_ACCOUNT AT                                      02270600
MFA-TR*       WHERE AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                   02270700
MFA-TR*       WITH UR                                                   02271100
MFA-TR*    END-EXEC.                                                    02271110

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00453*                                                                 02330000
P00453     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE,           
P00453                                 WS-DISP-RETURN-CODE.             
P00453                                                                  
P00453     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00453        CONTINUE                                                  
P00453     ELSE                                                         
P00453        MOVE PROGRAM-NAME     TO ABEND-PROGRAM                    
P00453        MOVE '7925'           TO ACTIVE-PARAGRAPH                 
P00453        MOVE 'SELECT'         TO ABEND-FUNCTION                   
P00453        MOVE SPACES           TO ABEND-SQL-PREDICATES             
P00453                                 ABEND-TABLES                     
P00453        MOVE 'CSS_ACCOUNT'    TO TABLE-1                          
P00453        MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1                  
P00453        MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1                
P00453        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
P00453     END-IF.                                                      
P00453*                                                                 02560000
P00453 7925-ACCOUNT-EXIT.                                               
P00453     EXIT.                                                        
