      *****************************************************************         
      **  CPD00831  COPYBOOK TO SET UP BILL ANALYSIS NOTES.          **         
      **.............................................................**         
      **.............................................................**         
      **  NOTE:                                                      ** *       
      **      WHEN MODIFYING THIS MEMBER, MEMBER CWS000831           ** *       
      **      SHOULD BE EVALUATED FOR CORRESPONDING MODIFICATIONS.   **         
      **.............................................................**         
      **                                                             **         
      **  THIS COPYBOOK IS CALLED FROM BILL ANALYSIS STORED          **         
      **  PROCEDURE TO GET ALL NOTES.                                **         
      **                                                             **         
      *****************************************************************         
      *****************************************************************         
      *   MODIFICATION LOG                                            *         
      *                                                               *         
      *   DATE      INITIALS       COMMENTS                           *         
      *  ------     -------        -----------------------------------*         
P00724* 06/06/2013  MS93554        INTIALLY WRITTEN.                  *         
P00724* 06/06/2013  MS93554        CHANGED THE SQL FOR NON-NRML READ  *         
      *                            AND READ SOURCE CODE.              *         
A05460* 08/02/2016  SM93554        Removed HOME-ENERGY-CHCKUPDE vldt  *         
      *****************************************************************         
                                                                        
      *****************************************************************         
      * 6000-START-BILL-ANLYS-VLDT                                    *         
      *****************************************************************         
       6000-START-BILL-ANLYS-VLDT.                                      
                                                                        
           PERFORM 6005-INITIALIZE            THRU 6005-EXIT.           
           PERFORM 6010-START-VALIDATION      THRU 6010-EXIT.           
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6005-INITIALIZE.                                              *         
      *****************************************************************         
       6005-INITIALIZE.                                                 
                                                                        
           INITIALIZE WS-BILL-ANLYS-ERR-TABLE.                          
           SET WS-ERR-MSG-INDX  TO 1.                                   
                                                                        
       6005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6010-START-VALIDATION.                                        *         
      *****************************************************************         
       6010-START-VALIDATION.                                           
                                                                        
           IF FIRST-CALL                                                
              SET NOT-FIRST-CALL             TO TRUE                    
              PERFORM 6020-VLDT-PEND-FINAL-EXIST                        
                                              THRU 6020-EXIT            
           END-IF.                                                      
           PERFORM 6030-VLDT-METER-CHANGE     THRU 6030-EXIT.           
           PERFORM 6035-VLDT-NON-NRML-READ    THRU 6035-EXIT.           
           PERFORM 6040-VLDT-CNCL-REBIL       THRU 6040-EXIT.           
                                                                        
       6010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    Note2: Pending Final Exists                                 *        
      ******************************************************************        
       6020-VLDT-PEND-FINAL-EXIST.                                      
                                                                        
           MOVE WS-NO                        TO WS-PNDNG-FINAL-EXIST.   
           PERFORM 7002-CHK-PNDNG-FINAL-EXIST THRU 7002-EXIT.           
                                                                        
           IF WS-PNDNG-FINAL-EXIST EQUAL WS-YES                         
              MOVE WS-BUSRUL-PEND-FINAL-EXIST                           
                                             TO 1R-BUS-RULE-ID          
                           WS-4638-BUS-RULE-ID(WS-ERR-MSG-INDX)         
              MOVE WS-PASSED                 TO                         
                           WS-4638-BUS-RULE-RESULT-CD(WS-ERR-MSG-INDX)  
              PERFORM 6100-GET-RULE-XREF-ID   THRU 6100-EXIT            
           END-IF.                                                      
                                                                        
       6020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    Note4A:Meter Change in Bill Month                           *        
      *           Meter Change in Compare Month                        *        
      *           Front end will decide bill/compare month             *        
      *    Note4B:PRESSURE COMPENSATED METER                           *        
      *           Front end will decide bill/compare month             *        
      ******************************************************************        
       6030-VLDT-METER-CHANGE.                                          
                                                                        
           PERFORM 7004-CHK-MTR-CHNG-N-PCOMP-FCT THRU 7004-EXIT.        
                                                                        
           IF WS-4638-PCOMP-FCTR  GREATER THAN WS-ONE                   
              MOVE WS-BUSRUL-PCOMP-FCTR      TO 1R-BUS-RULE-ID          
                           WS-4638-BUS-RULE-ID(WS-ERR-MSG-INDX)         
              MOVE WS-PASSED                 TO                         
                           WS-4638-BUS-RULE-RESULT-CD(WS-ERR-MSG-INDX)  
              PERFORM 6100-GET-RULE-XREF-ID   THRU 6100-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-4638-METER-COUNT GREATER THAN WS-ONE                   
              MOVE WS-BUSRUL-METER-CHNG      TO 1R-BUS-RULE-ID          
                           WS-4638-BUS-RULE-ID(WS-ERR-MSG-INDX)         
              MOVE WS-PASSED                 TO                         
                           WS-4638-BUS-RULE-RESULT-CD(WS-ERR-MSG-INDX)  
              PERFORM 6100-GET-RULE-XREF-ID   THRU 6100-EXIT            
           END-IF.                                                      
                                                                        
       6030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    Note5: Non-Normal read for Bill Month                       *        
      *           Non-Normal read for Compare Month                    *        
      *           Non-Normal read for Month Prior to Bill Month        *        
      *           Non-Normal read for Month Prior to Compare Month     *        
      ******************************************************************        
       6035-VLDT-NON-NRML-READ.                                         
                                                                        
P00724     MOVE WS-NO                        TO WS-NON-NRML-READ-STAT.  
P00724     PERFORM 7003-CHK-NON-NRML-READ-STAT THRU 7003-EXIT.          
                                                                        
P00724     IF WS-NON-NRML-READ-STAT EQUAL WS-YES                        
              MOVE WS-BUSRUL-NON-NRML-READ   TO 1R-BUS-RULE-ID          
                           WS-4638-BUS-RULE-ID(WS-ERR-MSG-INDX)         
              MOVE WS-PASSED                 TO                         
                           WS-4638-BUS-RULE-RESULT-CD(WS-ERR-MSG-INDX)  
              PERFORM 6100-GET-RULE-XREF-ID   THRU 6100-EXIT            
           END-IF.                                                      
                                                                        
P00724     MOVE WS-NO                        TO WS-MTR-RD-SRC-CD-STAT.  
P00724     PERFORM 7006-CHK-MTR-RD-SRC-CD-STAT  THRU 7006-EXIT.         
           IF WS-MTR-RD-SRC-CD-STAT EQUAL WS-YES                        
              PERFORM 7005-GET-MTR-RD-SRC-DESC                          
                                              THRU 7005-EXIT            
              MOVE WS-BUSRUL-MTR-READ-SRC-CD TO 1R-BUS-RULE-ID          
                           WS-4638-BUS-RULE-ID(WS-ERR-MSG-INDX)         
              MOVE WS-PASSED                 TO                         
                           WS-4638-BUS-RULE-RESULT-CD(WS-ERR-MSG-INDX)  
              MOVE X7-MTR-READ-SOURCE-TX     TO                         
                        WS-4638-BUS-RULE-MESSAGE-PARMS(WS-ERR-MSG-INDX) 
              PERFORM 6100-GET-RULE-XREF-ID   THRU 6100-EXIT            
           END-IF.                                                      
                                                                        
       6035-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    Note8: Bill Month Cancel Rebilledt                          *        
      *        Compare Month Cancel Rebilledth Rate                    *        
      *        Cancel Rebill or Cust Chng for Mnth Prior to Bill mnth  *        
      *        Cancel Rebill or Cust Chng for Mnth Prior to Cmpare mnth*        
      ******************************************************************        
       6040-VLDT-CNCL-REBIL.                                            
                                                                        
           IF WS-4638-CD-BILL-ITM-TYPE EQUAL WS-CURRENT AND             
              WS-4638-CD-BILL-ITM-IND  EQUAL WS-K-CNCL OR WS-J-CNCL     
              IF WS-PGRMNAME           EQUAL WS-4638-PGM-NAME           
                 MOVE WS-BUSRUL-CNCL-REBIL   TO 1R-BUS-RULE-ID          
                           WS-4638-BUS-RULE-ID(WS-ERR-MSG-INDX)         
                 MOVE WS-PASSED              TO                         
                           WS-4638-BUS-RULE-RESULT-CD(WS-ERR-MSG-INDX)  
                 PERFORM 6100-GET-RULE-XREF-ID                          
                                              THRU 6100-EXIT            
              ELSE                                                      
                PERFORM 7008-CHK-REBILL-ROW   THRU 7008-EXIT            
                IF WS-4638-CANCEL-REBILLED EQUAL WS-YES                 
                   MOVE WS-BUSRUL-CNCL-REBIL TO 1R-BUS-RULE-ID          
                           WS-4638-BUS-RULE-ID(WS-ERR-MSG-INDX)         
                   MOVE WS-PASSED            TO                         
                           WS-4638-BUS-RULE-RESULT-CD(WS-ERR-MSG-INDX)  
                   PERFORM 6100-GET-RULE-XREF-ID                        
                                              THRU 6100-EXIT            
                END-IF                                                  
              END-IF                                                    
           END-IF.                                                      
                                                                        
       6040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6100-GET-RULE-XREF-I.                                          *        
      ******************************************************************        
       6100-GET-RULE-XREF-ID.                                           
                                                                        
           IF WS-TOT-GUIDANCE-CNT GREATER THAN WS-MAX-COUNT             
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-4638-BUS-RULE-ID(WS-ERR-MSG-INDX) > SPACES             
              PERFORM 7009-GET-RULE-XREF-ID   THRU 7009-EXIT            
              MOVE 1T-BUS-RULE-XREF-ID       TO                         
                     WS-4638-BUS-RULE-XREF-ID(WS-ERR-MSG-INDX)          
              SET WS-ERR-MSG-INDX UP BY 1                               
              SET WS-TOT-GUIDANCE-CNT        TO WS-ERR-MSG-INDX         
           END-IF.                                                      
                                                                        
       6100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7002-CHK-PNDNG-FINAL-EXIST.                                    *        
      ******************************************************************        
       7002-CHK-PNDNG-FINAL-EXIST.                                      
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-PNDNG-FINAL-EXIST                              
                FROM  CSS_OFF_CYCL_ACCT WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO            = :WS-4638-ACCOUNT-NO        
                 AND CODE_BILL_OFF_CYCL    = 'B'                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-PNDNG-FINAL-EXIST                                      
MFA-TR*         FROM  CSS_OFF_CYCL_ACCT                                         
MFA-TR*        WHERE ACCOUNT_NO            = :WS-4638-ACCOUNT-NO                
MFA-TR*          AND CODE_BILL_OFF_CYCL    = 'B'                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7002                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7002'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_OFF_CYCL_ACCT'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7002-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
P00724* 7003-CHK-NON-NRML-READ-STAT.                                   *        
      ******************************************************************        
P00724 7003-CHK-NON-NRML-READ-STAT.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-NON-NRML-READ-STAT                             
                FROM CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                  
               WHERE ACCOUNT_NO         = :WS-4638-ACCOUNT-NO           
                 AND CODE_UTIL_TYPE     = :WS-4638-CODE-UTIL-TYPE       
                 AND BILL_NO            = :WS-4638-BILL-NO              
                 AND IC_NO              = :WS-4638-IC-NO                
                 AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                           :WS-4638-BILL-ITEM-TIMESTAMP
              )  
P00724           AND CODE_METER_READ    <> 'J'                          
                 AND CODE_ITEM_STATUS IN ('A' , 'T')                    
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-NON-NRML-READ-STAT                                     
MFA-TR*         FROM CSS_CNSMPTN_HIST CX                                        
MFA-TR*        WHERE ACCOUNT_NO         = :WS-4638-ACCOUNT-NO                   
MFA-TR*          AND CODE_UTIL_TYPE     = :WS-4638-CODE-UTIL-TYPE               
MFA-TR*          AND BILL_NO            = :WS-4638-BILL-NO                      
MFA-TR*          AND IC_NO              = :WS-4638-IC-NO                        
MFA-TR*          AND BILL_ITEM_TIMESTMP = :WS-4638-BILL-ITEM-TIMESTAMP          
MFA-TR*          AND CODE_METER_READ    <> 'J'                                  
MFA-TR*          AND CODE_ITEM_STATUS IN ('A' , 'T')                            
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7003                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES                   TO ABEND-TABLES            
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
               MOVE '7003'                   TO ACTIVE-PARAGRAPH        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE 'SELECT'                 TO ABEND-FUNCTION          
               MOVE 'CSS_CNSMPTN_HIST'       TO TABLE-1                 
               MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
               MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2         
               MOVE 'BILL_NO'                TO TABLE-ELEMENT-3         
               MOVE 'BILL_ITEM_TIMESTAMP'    TO TABLE-ELEMENT-4         
               MOVE WS-4638-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1       
               MOVE WS-4638-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2       
               MOVE WS-4638-BILL-NO          TO HOSTVAR-ELEMENT-3       
               MOVE WS-4638-BILL-ITEM-TIMESTAMP                         
                                             TO HOSTVAR-ELEMENT-4       
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7003-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7004-CHK-MTR-CHNG-N-PCOMP-FCT.                                 *        
      ******************************************************************        
       7004-CHK-MTR-CHNG-N-PCOMP-FCT.                                   
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(DISTINCT(CX.METER_NO))                       
                    ,MAX(CX.PCOMP_FCT)                                  
                INTO :WS-4638-METER-COUNT                               
                    ,:WS-4638-PCOMP-FCTR :WS-NULL-INDICATOR             
                FROM CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                  
               WHERE ACCOUNT_NO         = :WS-4638-ACCOUNT-NO           
                 AND CODE_UTIL_TYPE     = :WS-4638-CODE-UTIL-TYPE       
                 AND BILL_NO            = :WS-4638-BILL-NO              
                 AND IC_NO              = :WS-4638-IC-NO                
                 AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                           :WS-4638-BILL-ITEM-TIMESTAMP
              )  
                 AND CODE_ITEM_STATUS IN ( 'A' , 'T')                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(DISTINCT(CX.METER_NO))                               
MFA-TR*             ,MAX(CX.PCOMP_FCT)                                          
MFA-TR*         INTO :WS-4638-METER-COUNT                                       
MFA-TR*             ,:WS-4638-PCOMP-FCTR :WS-NULL-INDICATOR                     
MFA-TR*         FROM CSS_CNSMPTN_HIST CX                                        
MFA-TR*        WHERE ACCOUNT_NO         = :WS-4638-ACCOUNT-NO                   
MFA-TR*          AND CODE_UTIL_TYPE     = :WS-4638-CODE-UTIL-TYPE               
MFA-TR*          AND BILL_NO            = :WS-4638-BILL-NO                      
MFA-TR*          AND IC_NO              = :WS-4638-IC-NO                        
MFA-TR*          AND BILL_ITEM_TIMESTMP = :WS-4638-BILL-ITEM-TIMESTAMP          
MFA-TR*          AND CODE_ITEM_STATUS IN ( 'A' , 'T')                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7004                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-NULL-INDICATOR < 0                                  
                 MOVE ZEROES                 TO WS-4638-PCOMP-FCTR      
              END-IF                                                    
           ELSE                                                         
               MOVE SPACES                   TO ABEND-TABLES            
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
               MOVE '7004'                   TO ACTIVE-PARAGRAPH        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE 'SELECT'                 TO ABEND-FUNCTION          
               MOVE 'CSS_CNSMPTN_HIST'       TO TABLE-1                 
               MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
               MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2         
               MOVE 'BILL_NO'                TO TABLE-ELEMENT-3         
               MOVE 'BILL_ITEM_TIMESTAMP'    TO TABLE-ELEMENT-4         
               MOVE WS-4638-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1       
               MOVE WS-4638-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2       
               MOVE WS-4638-BILL-NO          TO HOSTVAR-ELEMENT-3       
               MOVE WS-4638-BILL-ITEM-TIMESTAMP                         
                                             TO HOSTVAR-ELEMENT-4       
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7004-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7005-GET-MTR-RD-SRC-DESC.                                      *        
      ******************************************************************        
       7005-GET-MTR-RD-SRC-DESC.                                        
                                                                        
           EXEC SQL                                                     
              SELECT MTR_READ_SOURCE_TX                                 
                INTO :X7-MTR-READ-SOURCE-TX                             
                FROM CSS_MTR_RD_SOURCE X7 WITH(READUNCOMMITTED)                 
               WHERE MTR_READ_SOURCE_CD = :WS-4638-MTR-RD-SOURCE-CD     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MTR_READ_SOURCE_TX                                         
MFA-TR*         INTO :X7-MTR-READ-SOURCE-TX                                     
MFA-TR*         FROM CSS_MTR_RD_SOURCE X7                                       
MFA-TR*        WHERE MTR_READ_SOURCE_CD = :WS-4638-MTR-RD-SOURCE-CD             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7005                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-4638-MTR-RD-SOURCE-CD TO X7-MTR-READ-SOURCE-TX 
              END-IF                                                    
           ELSE                                                         
               MOVE SPACES                   TO ABEND-TABLES            
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
               MOVE '7005'                   TO ACTIVE-PARAGRAPH        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE 'SELECT'                 TO ABEND-FUNCTION          
               MOVE 'CSS_MTR_RD_SOURCE'      TO TABLE-1                 
               MOVE 'MTR_READ_SOURCE_CD'     TO TABLE-ELEMENT-1         
               MOVE WS-4638-MTR-RD-SOURCE-CD TO HOSTVAR-ELEMENT-1       
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00724***************************************************************** *       
P00724* 7006-CHK-MTR-RD-SRC-CD-STAT.                                  *         
P00724***************************************************************** *       
P00724 7006-CHK-MTR-RD-SRC-CD-STAT.                                     
P00724                                                                  
P00724     EXEC SQL                                                     
P00724        SELECT TOP(1) 'Y',
              CX.MTR_READ_SOURCE_CD                              
P00724          INTO :WS-MTR-RD-SRC-CD-STAT                             
P00724              ,:WS-4638-MTR-RD-SOURCE-CD                          
P00724          FROM CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                  
P00724         WHERE ACCOUNT_NO         = :WS-4638-ACCOUNT-NO           
P00724           AND CODE_UTIL_TYPE     = :WS-4638-CODE-UTIL-TYPE       
P00724           AND BILL_NO            = :WS-4638-BILL-NO              
P00724           AND IC_NO              = :WS-4638-IC-NO                
P00724           AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                           :WS-4638-BILL-ITEM-TIMESTAMP
              )  
P00724           AND MTR_READ_SOURCE_CD NOT IN ('B' , 'C', 'I' , '')    
P00724           AND CODE_ITEM_STATUS IN ('A' , 'T')                    
P00724                                              
P00724                                                           
P00724                                                      
P00724     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*             ,CX.MTR_READ_SOURCE_CD                                      
MFA-TR*         INTO :WS-MTR-RD-SRC-CD-STAT                                     
MFA-TR*             ,:WS-4638-MTR-RD-SOURCE-CD                                  
MFA-TR*         FROM CSS_CNSMPTN_HIST CX                                        
MFA-TR*        WHERE ACCOUNT_NO         = :WS-4638-ACCOUNT-NO                   
MFA-TR*          AND CODE_UTIL_TYPE     = :WS-4638-CODE-UTIL-TYPE               
MFA-TR*          AND BILL_NO            = :WS-4638-BILL-NO                      
MFA-TR*          AND IC_NO              = :WS-4638-IC-NO                        
MFA-TR*          AND BILL_ITEM_TIMESTMP = :WS-4638-BILL-ITEM-TIMESTAMP          
MFA-TR*          AND MTR_READ_SOURCE_CD NOT IN ('B' , 'C', 'I' , '')            
MFA-TR*          AND CODE_ITEM_STATUS IN ('A' , 'T')                            
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7006                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00724                                                                  
P00724     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00724     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00724        CONTINUE                                                  
P00724     ELSE                                                         
P00724         MOVE SPACES                   TO ABEND-TABLES            
P00724         MOVE SPACES                   TO ABEND-SQL-PREDICATES    
P00724         MOVE '7006'                   TO ACTIVE-PARAGRAPH        
P00724         MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
P00724         MOVE 'SELECT'                 TO ABEND-FUNCTION          
P00724         MOVE 'CSS_CNSMPTN_HIST'       TO TABLE-1                 
P00724         MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
P00724         MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2         
P00724         MOVE 'BILL_NO'                TO TABLE-ELEMENT-3         
P00724         MOVE 'BILL_ITEM_TIMESTAMP'    TO TABLE-ELEMENT-4         
P00724         MOVE WS-4638-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1       
P00724         MOVE WS-4638-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2       
P00724         MOVE WS-4638-BILL-NO          TO HOSTVAR-ELEMENT-3       
P00724         MOVE WS-4638-BILL-ITEM-TIMESTAMP                         
P00724                                       TO HOSTVAR-ELEMENT-4       
P00724         PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
P00724     END-IF.                                                      
P00724                                                                  
P00724 7006-EXIT.                                                       
P00724     EXIT.                                                        
P00724                                                                  
      ******************************************************************        
      * THE BELOW QRY TO CHECK WHETHER THE CANCELLED ROW GOT BILLED    *        
      * 7008-CHK-REBILL-ROW.                                           *        
      ******************************************************************        
       7008-CHK-REBILL-ROW.                                             
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-4638-CANCEL-REBILLED                           
                FROM CSS_BILLING_DET  BG WITH(READUNCOMMITTED)                  
                    ,CSS_BILLING_HDR  BI WITH(READUNCOMMITTED)                  
               WHERE BG.ACCOUNT_NO          = BI.ACCOUNT_NO             
                 AND BG.BILL_NO             = BI.BILL_NO                
                 AND BG.DATE_ORIG_BILL      = IIF(TRY_CONVERT(DATE, 
                                                   :WS-4638-BILLED-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-4638-BILLED-DATE
              ) <> 0) OR (LEN(:WS-4638-BILLED-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-4638-BILLED-DATE
              ), CONVERT(DATE, :WS-4638-BILLED-DATE) )      
                 AND BG.ACCOUNT_NO          = :WS-4638-ACCOUNT-NO       
                 AND BG.CODE_UTIL_TYPE      = :WS-4638-CODE-UTIL-TYPE   
                 AND BG.IC_NO               = :WS-4638-IC-NO            
                 AND BG.CODE_BILL_CALC     <> 'S'                       
                 AND BG.CODE_BILL_ITM_TYPE <> 'B'                       
                 AND BG.CODE_BILL_ITM_IND  NOT IN('K','J')              
               ORDER BY BG.BILL_NO DESC                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-4638-CANCEL-REBILLED                                   
MFA-TR*         FROM CSS_BILLING_DET  BG                                        
MFA-TR*             ,CSS_BILLING_HDR  BI                                        
MFA-TR*        WHERE BG.ACCOUNT_NO          = BI.ACCOUNT_NO                     
MFA-TR*          AND BG.BILL_NO             = BI.BILL_NO                        
MFA-TR*          AND BG.DATE_ORIG_BILL      = :WS-4638-BILLED-DATE              
MFA-TR*          AND BG.ACCOUNT_NO          = :WS-4638-ACCOUNT-NO               
MFA-TR*          AND BG.CODE_UTIL_TYPE      = :WS-4638-CODE-UTIL-TYPE           
MFA-TR*          AND BG.IC_NO               = :WS-4638-IC-NO                    
MFA-TR*          AND BG.CODE_BILL_CALC     <> 'S'                               
MFA-TR*          AND BG.CODE_BILL_ITM_TYPE <> 'B'                               
MFA-TR*          AND BG.CODE_BILL_ITM_IND  NOT IN('K','J')                      
MFA-TR*        ORDER BY BG.BILL_NO DESC                                         
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7008                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES                   TO ABEND-TABLES            
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
               MOVE '7008'                   TO ACTIVE-PARAGRAPH        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE 'SELECT'                 TO ABEND-FUNCTION          
               MOVE 'CSS_BILLING_HDR'        TO TABLE-1                 
               MOVE 'CSS_BILLING_DET'        TO TABLE-2                 
               MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
               MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2         
               MOVE 'BILL_NO'                TO TABLE-ELEMENT-3         
               MOVE 'BILL_ITEM_TIMESTAMP'    TO TABLE-ELEMENT-4         
               MOVE WS-4638-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1       
               MOVE WS-4638-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2       
               MOVE WS-4638-BILL-NO          TO HOSTVAR-ELEMENT-3       
               MOVE WS-4638-BILL-ITEM-TIMESTAMP                         
                                             TO HOSTVAR-ELEMENT-4       
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7008-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7009-GET-RULE-XREF-ID.                                         *        
      ******************************************************************        
       7009-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :1T-BUS-RULE-XREF-ID                               
                FROM CSS_BUS_RULE   [1R] WITH(READUNCOMMITTED)                  
                    ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
               WHERE [1R].BUS_RULE_ID = :1R-BUS-RULE-ID                   
                 AND [1R].BUS_RULE_ID =  [1T].BUS_RULE_ID                   
                                                  
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :1T-BUS-RULE-XREF-ID                                       
MFA-TR*         FROM CSS_BUS_RULE   1R                                          
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :1R-BUS-RULE-ID                           
MFA-TR*          AND 1R.BUS_RULE_ID =  1T.BUS_RULE_ID                           
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7009                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SPACES                   TO ABEND-TABLES            
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
               MOVE '7009'                   TO ACTIVE-PARAGRAPH        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE 'SELECT'                 TO ABEND-FUNCTION          
               MOVE 'CSS_BUS_RULE'           TO TABLE-1                 
               MOVE 'BUS_RULE_XREF_ID'       TO TABLE-ELEMENT-1         
               MOVE 1R-BUS-RULE-ID           TO HOSTVAR-ELEMENT-1       
               PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7009-EXIT.                                                       
           EXIT.                                                        
                                                                        
