      *****************************************************************         
      **  CPD00829 COPYBOOK USED FOR RPM APPLICATION VALIDATION.     **         
      **               SEB CRM BPA ENTRY.                            **         
      **.............................................................**         
      **.............................................................**         
      **NOTE: WHEN MODIFYING THIS MEMBER, MEMBER CWS00829 & CWS0829A **         
      **      SHOULD BE EVALUATED FOR CORRESPONDING MODIFICATIONS.   **         
      **.............................................................**         
      **                                                             **         
      **  PROCEDURE REFERENCE:                                       **         
      **                                                             **         
      **  PREREQUISITES: CWS00829 & CWS0829A                         **         
      **                                                             **         
      **  ADDITIONAL INFORMATION:                                    **         
      **    THIS COPYBOOK IS CALLED FROM CRM - BPA TABLE ENTRY       **         
      **    WIZARD AND HAS THE CORE LOGIC TO SUPPORT THE PROCESS     **         
      **    DRIVEN OPERATIONS.                                       **         
      **    CALLED PROGRAM - CSR04437 / CSR04446 (MCSCB829)          **         
      **                                                             **         
      **                                                             **         
      *****************************************************************         
      *  RULE #  ERROR MESSAGE                                        *         
      *  ------  -----------------------------------------------------*         
      *                                                               *         
      *  RPM005  MULTIPLE DEFAULT OFFERS EXISTS FOR MKT TIER RANKING  *         
      *  RPM006  OVERLAPPING DATES FOR THE SAME OFFER MARKET TIER     *         
PRJ680*  RPM007  MAX PRICE OFFER NOT ACTIVE FOR CURRENT DATE.         *         
PRJ680*  RPM008  MAX PRICE OFFER IS NOT IN APPROVED STATUS.           *         
      *  RPM009  RENEWAL OFFER NOT ACTIVE FOR CURRENT DATE.           *         
      *  RPM010  RENEWAL OFF DOESN'T HAV VARIABLE OPTN AS THE LAST OPT*         
      *  RPM011  MULTIPLE PRIMARY RATE ATTRIBUTES EXISTS FOR OPTION.  *         
      *  RPM012  A VALID PRICE IS NOT FOUND FOR THE FACTOR.           *         
PRJ680*  RPM013  OFFER END DATE CANNOT BE MODIFIED SINCE IT           *         
      *          IS ATTCHD WITH OTHER OFFERS AS MAX PRICE OFFER       *         
A04177*  RPM014  RENEWAL OFFER DOES NOT HAVE THE SAME CORE RATE AS    *         
      *          THE ORIGINAL OFFER.                                  *         
P00863*  RPM015  RATE CHANGE PUB OFFER NOT ACTIVE FOR CURRENT DATE.   *         
P00863*  RPM016  RATE CHANGE PUB OFFER NOT IN APPROVED STATUS.        *         
P00863*  RPM017  OFFER END DATE CANNOT BE MODIFIED SINCE IT IS        *         
P00863*          ATTACHED WITH OTHER OFFERS AS RATE CHANGE PUB OFFER  *         
      *  RPM018  UNAPPROVED VERSION EXISTS FOR OFFER.                 *         
      *  RPM019  UNAPPROVED VERSION EXISTS FOR OFFER MARKET TIER.     *         
      *  RPM020  UNAPPROVED VERSION EXISTS FOR OFFER ACCESS.          *         
      *  RPM021  UNAPPROVED VERSION EXISTS FOR OFFER RATE GROUP.      *         
      *  RPM022  UNAPPROVED VERSION EXISTS FOR OPTION.                *         
      *  RPM023  UNAPPROVED VERSION EXISTS FOR OPTION ATTRIBUTE INCTV.*         
      *  RPM024  UNAPPROVED VERSION EXISTS FOR OPTION ACCESS.         *         
      *  RPM025  UNAPPROVED VERSION EXISTS FOR PROMOTION.             *         
      *  RPM026  PROCESS STATUS IS NOT NEW, OFFER MARKET TIER CANNOT  *         
      *          BE DELETED.                                          *         
      *  RPM027  PROCESS STATUS IS NOT NEW, OFFER RATE GROUP CANNOT   *         
      *          BE DELETED.                                          *         
      *  RPM028  PROCESS STATUS IS NOT NEW, OPTION ATTRIBUTE CANNOT   *         
      *          BE DELETED.                                          *         
      *  RPM029  PROCESS STATUS IS NOT NEW, OPTION CANNOT BE DELETED. *         
      *  RPM030  PROCESS STATUS IS NOT NEW, OPTION ACCESS CANNOT      *         
      *          BE DELETED.                                          *         
      *  RPM031  PROCESS STATUS IS NOT NEW, OFFER ACCESS CANNOT       *         
      *          BE DELETED.                                          *         
      *  RPM032  PROCESS STATUS IS NOT NEW, PROMO CANNOT BE DELETE    *         
      *  RPM033  UNAPPROVED VERSION EXISTS FOR OFFER OPTION. *                  
      *  RPM034  PROCESS STATUS IS NOT NEW, OFFER OPTION CANNOT       *         
      *          BE DELETED.                                          *         
      *  RPM035  OPTION END DATE CANNOT BE MODIFIED SINCE IT IS ATTCHD*         
      *          WITH OTHER OFFERS.                                   *         
      *  RPM036  RENEWAL OFFER IS NOT IN APPROVED STATUS.             *         
      *  RPM037  OPTION CREATED AS PART OF DIFFERENT OFFER. PLEASE    *         
      *          APROVE THE OFFER THAT CREATED THIS OPTION.           *         
      *  RPM038  OPTION START DATE CANNOT BE MODIFIED SINCE IT IS     *         
      *          ATTACHED WITH OTHER OFFERS.                          *         
      *  RPM039  OPTION CANNOT BE DELETED SINCE IT IS ATTACHED WITH   *         
      *          WITH OTHER OFFERS.                                   *         
      *  RPM040  REJECTING OFFER WILL PROHIBIT OTHER OFFERS FROM      *         
      *          APPROVAL BECAUSE COMPONENTS IN OFFER ARE USED IN     *         
      *          OTHER OFFERS.                                        *         
      *  RPM041  REJECTING OFFER WILL PROHIBIT OTHER OFFERS FROM      *         
      *          APPROVAL BECAUSE OFFER USED AS RENEWAL OFFER FOR     *         
      *          OTHER OFFER(S).                                      *         
      *  RPM042  PROMOTION IS CURRENTLY SELECTED BY ANOTHER OFFER AND *         
      *          CANNOT BE MODIFIED.                                  *         
      *                                                                         
      *                                                                         
      *****************************************************************         
      *   MODIFICATION LOG                                            *         
      *                                                               *         
      *   DATE     INITIALS        COMMENTS                           *         
      *  ------    --------        -----------------------------------*         
P00473* 07/07/11   MS93554         INTIALLY WRITTEN.                  *         
PRJ680* 02/15/13   MS93554         New validation has added for       *         
      *                            max_price_offer_cd.                *         
A04177* 12/04/13   MS93554         Return warning message when renewal*         
      *            Act-35          offer (option) rate does not match *         
      *                            with original off (option) rate.   *         
P00863* 07/08/15   SS45239         New validation has added for       *         
      *                            rtchg_pub_offer_cd.                *         
      *****************************************************************         
                                                                        
      *****************************************************************         
      * 6000-START-VALIDATE-CRM.                                      *         
      *****************************************************************         
       6000-START-VALIDATE-CRM.                                         
                                                                        
           PERFORM 6020-PROCESS-INPUT            THRU 6020-EXIT.        
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6020-PROCESS-INPUT.                                           *         
      *****************************************************************         
       6020-PROCESS-INPUT.                                              
                                                                        
           PERFORM 2000-VALIDATE-CRM-WIZARD      THRU 2000-EXIT         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE 0              TO WS-ACTIVE-RETURN-CODE              
           END-IF.                                                      
                                                                        
       6020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *   RPM WIZARD'S                                                *         
      *   -------------------------                                   *         
      *   RPM001-CREATE NEW OFFER                                     *         
      *   RPM002-MODIFY OFFER                                         *         
      *   RPM003-CREATE AND REPLACE OFF                               *         
      *   RPM004-MODIFY OPTION                                        *         
      *****************************************************************         
       2000-VALIDATE-CRM-WIZARD.                                        
                                                                        
           MOVE WS-CRM-RESOURCE-ID            TO WS-RPM-WIZARDS.        
           MOVE WS-CRM-COMPANY-NO             TO WS-COMPANY-NO.         
      *    SYSTEM START DATE / TIME                                             
           MOVE WS-CRM-VRSN-TIMESTAMP         TO WS-VALIDATE-DATE       
                                                 WS-CHECK-TIMESTAMP.    
           MOVE WS-VALIDATE-DATE              TO WS-CHECK-DATE.         
                                                                        
           EVALUATE TRUE                                                
                                                                        
               WHEN CREATE-OFFER-WIZARD                                 
                    IF CRM-OFFER-CHANGE                                 
                       PERFORM 2010-VLDT-CREATE-OFF   THRU 2010-EXIT    
                    END-IF                                              
                    IF CRM-OPTION-CHANGE                                
                       PERFORM 2020-VLDT-CREATE-OPT   THRU 2020-EXIT    
                    END-IF                                              
                    IF CRM-PROMOTION-CHANGE                             
                       PERFORM 2030-VLDT-CREATE-PROMO THRU 2030-EXIT    
                    END-IF                                              
               WHEN MODIFY-OFFER-WIZARD                                 
                    IF CRM-OFFER-CHANGE                                 
                       PERFORM 2040-VLDT-MODIFY-OFF   THRU 2040-EXIT    
                    END-IF                                              
                    IF CRM-OPTION-CHANGE                                
                       PERFORM 2050-VLDT-MODIFY-OPT   THRU 2050-EXIT    
                    END-IF                                              
                    IF CRM-PROMOTION-CHANGE                             
                       PERFORM 2060-VLDT-MODIFY-PROMO THRU 2060-EXIT    
                    END-IF                                              
               WHEN CREATE-REPLACE-OFFER-WIZARD                         
                    IF CRM-OFFER-CHANGE                                 
                       PERFORM 2010-VLDT-CREATE-OFF   THRU 2010-EXIT    
                    END-IF                                              
                    IF CRM-OPTION-CHANGE                                
                       PERFORM 2020-VLDT-CREATE-OPT   THRU 2020-EXIT    
                    END-IF                                              
                    IF CRM-PROMOTION-CHANGE                             
                       PERFORM 2030-VLDT-CREATE-PROMO THRU 2030-EXIT    
                    END-IF                                              
               WHEN MODIFY-OPTION-WIZARD                                
                    IF CRM-OPTION-CHANGE                                
                       PERFORM 2050-VLDT-MODIFY-OPT   THRU 2050-EXIT    
                    END-IF                                              
               WHEN OTHER                                               
                    CONTINUE                                            
                                                                        
           END-EVALUATE.                                                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * RPM001 CREATE NEW OFFER WIZARD.                               *         
      *                                                               *         
      *****************************************************************         
       2010-VLDT-CREATE-OFF.                                            
                                                                        
           MOVE WS-CRM-RESOURCE-ID            TO WS-RPM-WIZARDS.        
           MOVE WS-CRM-OFF-PRC-STAT-CD-FG     TO WS-CHK-PRC-STAT-CD.    
           MOVE WS-CRM-OFFER-CD-FG            TO WS-CHK-OFFER-CD        
                                                 FG-OFFER-CD.           
           MOVE WS-CRM-RENEWAL-OFFER-CD-FG    TO WS-CHK-RNWL-OFF-CD     
                                                 FG-RENEWAL-OFFER-CD.   
           MOVE WS-CRM-OFFER-START-DT-FG      TO WS-CHK-OFF-START-DT.   
PRJ680     MOVE WS-CRM-OFFER-END-DT-FG        TO WS-CHK-OFF-END-DT.     
           MOVE WS-CRM-OFF-VRSN-NO-FG         TO WS-OFF-VRSN-NO.        
PRJ680     MOVE WS-CRM-MAX-PRICE-OFFER-CD-FG  TO WS-CHK-MAX-PRC-OFF-CD. 
P00863     MOVE WS-CRM-RTCHG-PUB-OFFER-CD-FG  TO WS-CHK-RTCHG-PUB-OFF-CD
                                                                        
      *    CHECK FOR ANY EXISTING ROW FOR THE NEW OFFER.                        
           IF CRM-OFFER-INSERT                                          
              PERFORM 6100-VALIDATION-FOR-OFF   THRU 6100-EXIT          
           END-IF.                                                      
                                                                        
      *    CHECK FOR RENEWAL OFFER CODE STATUS                                  
           IF WS-CHK-OFFER-CD NOT EQUAL WS-CHK-RNWL-OFF-CD              
              AND (CRM-OFFER-INSERT    OR CRM-OFFER-UPDATE )            
              AND (CREATE-OFFER-WIZARD OR                               
                  (CREATE-REPLACE-OFFER-WIZARD AND WS-OFF-VRSN-NO = 1)) 
              PERFORM 2100-VLDT-FOR-RPM009      THRU 2100-EXIT          
A04177        PERFORM 2102-VLDT-FOR-RPM014      THRU 2102-EXIT          
              IF RENEWAL-OFFER-VALID                                    
                 PERFORM 2110-VLDT-FOR-RPM010      THRU 2110-EXIT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
PRJ680*    CHECK FOR MAX PRICE OFFER CODE STATUS.                               
PRJ680     IF WS-CHK-OFFER-CD NOT EQUAL WS-CHK-MAX-PRC-OFF-CD           
PRJ680        AND (CRM-OFFER-INSERT    OR CRM-OFFER-UPDATE )            
PRJ680        AND (CREATE-OFFER-WIZARD OR                               
PRJ680            (CREATE-REPLACE-OFFER-WIZARD AND WS-OFF-VRSN-NO = 1)) 
PRJ680        PERFORM 2105-VLDT-FOR-RPM007     THRU 2105-EXIT           
PRJ680     END-IF                                                       
                                                                        
P00863*    CHECK FOR RATE CHANGE PUB OFFER CODE STATUS.                         
P00863     IF WS-CHK-OFFER-CD NOT EQUAL WS-CHK-RTCHG-PUB-OFF-CD         
P00863        AND (CRM-OFFER-INSERT    OR CRM-OFFER-UPDATE )            
P00863        AND (CREATE-OFFER-WIZARD OR                               
P00863            (CREATE-REPLACE-OFFER-WIZARD AND WS-OFF-VRSN-NO = 1)) 
P00863        PERFORM 2105A-VLDT-FOR-RPM015     THRU 2105A-EXIT         
P00863     END-IF                                                       
                                                                        
PRJ680*    CHECK THERE IS ANY CHANGE IN OFFER END DATE                          
PRJ680*    WHEN THE PROC STATUS IS APPROVED.                                    
PRJ680     IF CRM-OFFER-UPDATE                                          
PRJ680        PERFORM 2106-VLDT-FOR-RPM013      THRU 2106-EXIT          
P00863        PERFORM 2106A-VLDT-FOR-RPM017     THRU 2106A-EXIT         
PRJ680     END-IF.                                                      
                                                                        
      *    WHEN WE REJECT THE OFFER,IT WILL CHECK WHETHE OFFER USED             
      *    AS RENEWAL OFFER WITH OTHER OFFERS.                                  
           IF CALL-FRM-STATUS-UPDT AND WS-CHK-PRC-STAT-CD = WS-NEW      
                                   AND WS-OFF-VRSN-NO = 1               
             PERFORM 2111-VLDT-FOR-RJCT-OFF     THRU 2111-EXIT          
           END-IF.                                                      
                                                                        
      *    VALIDATION FOR CHILD ENTITY SCREEN- TIER/GROUP/ACCESS.               
           PERFORM 2115-PROCESS-OFFER-DET       THRU 2115-EXIT.         
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * VALIDATE FOR  OPTION / OPT ATTR INCTV / OPTION ACCESS         *         
      *                                                               *         
      *****************************************************************         
       2020-VLDT-CREATE-OPT.                                            
                                                                        
      *    VALIDATION FOR OPTION                                                
           PERFORM VARYING WS-CRM-OPT-INDX FROM 1 BY 1                  
                       UNTIL WS-CRM-OPT-INDX   > 20                     
            OR WS-CRM-OPTION-KEY-FI(WS-CRM-OPT-INDX) = SPACES           
            OR WS-CRM-OPTION-KEY-FI(WS-CRM-OPT-INDX) = LOW-VALUES       
                                                                        
             MOVE WS-CRM-OPTION-CD-FI(WS-CRM-OPT-INDX)                  
                                            TO WS-CHK-OPTION-CD         
             MOVE WS-CRM-OPT-PRC-STAT-CD-FI(WS-CRM-OPT-INDX)            
                                            TO WS-CHK-OPT-PRC-STAT-CD   
             MOVE WS-CRM-OPTION-START-DT-FI(WS-CRM-OPT-INDX)            
                                            TO WS-CHK-OPTION-START-DT   
             MOVE WS-CRM-OPTION-END-DT-FI(WS-CRM-OPT-INDX)              
                                            TO WS-CHK-OPTION-END-DT     
             MOVE WS-CRM-OPT-PRC-REQ-ID-FI(WS-CRM-OPT-INDX)             
                                            TO WS-CHK-OPT-PRC-REQ-ID    
             IF WS-CRM-OPTION-UPDT-IND-FI(WS-CRM-OPT-INDX)              
                                        NOT EQUAL WS-REFERENCE          
                PERFORM 6120-VLDT-FOR-OPTION   THRU 6120-EXIT           
             END-IF                                                     
                                                                        
      *    VALIDATION FOR OFFER OPTION INSERT / DELETE                          
             MOVE WS-CRM-OFFER-CD-E9(WS-CRM-OPT-INDX)                   
                                   TO WS-CHK-OFFER-CD                   
             MOVE WS-CRM-OPTION-CD-E9(WS-CRM-OPT-INDX)                  
                                   TO WS-CHK-OPTION-CD                  
             MOVE WS-CRM-OFF-OPT-PRC-STAT-CD-E9(WS-CRM-OPT-INDX)        
                                   TO WS-CHK-OFF-OPT-PRC-STAT-CD        
             IF WS-CRM-OFF-OPT-PRC-REQ-ID-E9(WS-CRM-OPT-INDX) IS NUMERIC
                MOVE WS-CRM-OFF-OPT-PRC-REQ-ID-E9(WS-CRM-OPT-INDX)      
                                            TO WS-CHK-OPT-PRC-REQ-ID    
             ELSE                                                       
                MOVE ZEROS                  TO WS-CHK-OPT-PRC-REQ-ID    
             END-IF                                                     
                                                                        
             PERFORM 6122-VLDT-FOR-OFF-OPT     THRU 6122-EXIT           
                                                                        
      *    VALIDATION FOR ATTR INCTV INSERT / DELETE                            
             PERFORM VARYING WS-CRM-ATTRB-INDX FROM 1 BY 1              
                                  UNTIL WS-CRM-ATTRB-INDX > 10          
              OR WS-CRM-OPT-ATTRB-IND(WS-CRM-OPT-INDX                   
                                     ,WS-CRM-ATTRB-INDX) = SPACES       
              OR WS-CRM-OPT-ATTRB-IND(WS-CRM-OPT-INDX                   
                                     ,WS-CRM-ATTRB-INDX) = LOW-VALUES   
                                                                        
               MOVE WS-CRM-OPTION-CD-HQ(WS-CRM-OPT-INDX                 
                                    , WS-CRM-ATTRB-INDX)                
                                   TO WS-CHK-OPTION-CD                  
               MOVE WS-CRM-FACTOR-ID-HQ (WS-CRM-OPT-INDX                
                                    , WS-CRM-ATTRB-INDX)                
                                   TO WS-CHK-FACTOR-ID                  
               MOVE WS-CRM-RT-ATTR-INCTV-TYPE-HQ(WS-CRM-OPT-INDX        
                                    , WS-CRM-ATTRB-INDX)                
                                   TO WS-CHK-RT-ATTR-INCTV-TYPE         
               MOVE WS-CRM-ATTR-INCTV-SEQ-NO-HQ(WS-CRM-OPT-INDX         
                                    , WS-CRM-ATTRB-INDX)                
                                   TO WS-CHK-ATTR-INCTV-SEQ-NO          
               MOVE WS-CRM-OPT-ATRB-PRC-STAT-CD-HQ(WS-CRM-OPT-INDX      
                                    , WS-CRM-ATTRB-INDX)                
                                   TO WS-CHK-OPT-ATRB-PRC-STAT-CD       
                                                                        
               PERFORM 6125-VLDT-FOR-ATTR-INCTV  THRU 6125-EXIT         
              IF CRM-OPT-ATTRB-INSERT(WS-CRM-OPT-INDX,WS-CRM-ATTRB-INDX)
                 OR                                                     
                 CRM-OPT-ATTRB-UPDATE(WS-CRM-OPT-INDX,WS-CRM-ATTRB-INDX)
                 PERFORM 2170-VLDT-FOR-RPM012      THRU 2170-EXIT       
              END-IF                                                    
                                                                        
             END-PERFORM                                                
                                                                        
      *    VALIDATION FOR OPTION ACCESS INSERT / DELETE                         
             PERFORM VARYING WS-CRM-OPTN-ACCS-INDX  FROM 1 BY 1         
                               UNTIL WS-CRM-OPTN-ACCS-INDX  > 05        
              OR WS-CRM-OPTN-ACCS-IND-CI(WS-CRM-OPT-INDX                
                                 ,WS-CRM-OPTN-ACCS-INDX) = SPACES       
              OR WS-CRM-OPTN-ACCS-IND-CI(WS-CRM-OPT-INDX                
                                 ,WS-CRM-OPTN-ACCS-INDX) = LOW-VALUES   
                                                                        
                MOVE WS-CRM-OPTN-OPTION-CD-CI(WS-CRM-OPT-INDX           
                                     , WS-CRM-OPTN-ACCS-INDX)           
                                    TO WS-CHK-OPTN-OPTION               
                MOVE WS-CRM-OPTN-CATEGORY-ID-CI(WS-CRM-OPT-INDX         
                                     , WS-CRM-OPTN-ACCS-INDX)           
                                    TO WS-CHK-OPTN-CATEGORY-ID          
                MOVE WS-CRM-OPT-ACS-PRC-STAT-CD-CI(WS-CRM-OPT-INDX      
                                     , WS-CRM-OPTN-ACCS-INDX)           
                                    TO WS-CHK-OPT-ACS-PRC-STAT-CD       
                IF WS-CRM-OPTN-ACCS-IND-CI(WS-CRM-OPT-INDX              
                      ,WS-CRM-OPTN-ACCS-INDX) NOT EQUAL WS-REFERENCE    
                                                                        
                   PERFORM 6130-VLDT-FOR-OPT-ACCESS  THRU 6130-EXIT     
                END-IF                                                  
             END-PERFORM                                                
                                                                        
           END-PERFORM.                                                 
                                                                        
       2020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * VALIDATE - PROMOTION VALIDATION                               *         
      *                                                               *         
      *****************************************************************         
       2030-VLDT-CREATE-PROMO.                                          
                                                                        
      *    VALIDATION FOR PROMOTION INSERT / DELETE                             
           PERFORM VARYING WS-CRM-PROMO-INDX FROM 1 BY 1                
                   UNTIL WS-CRM-PROMO-INDX > 2                          
           OR WS-CRM-PROMO-KEY-KM(WS-CRM-PROMO-INDX) = SPACES           
           OR WS-CRM-PROMO-KEY-KM(WS-CRM-PROMO-INDX) = LOW-VALUES       
                                                                        
              MOVE WS-CRM-PROMO-CD-KM(WS-CRM-PROMO-INDX)                
                                       TO WS-CHK-PROMO-CD               
              MOVE WS-CRM-PROMO-PRC-STAT-CD-KM(WS-CRM-PROMO-INDX)       
                                       TO WS-CHK-PROMO-PRC-STAT-CD      
              MOVE WS-CRM-OFFER-CD-KM(WS-CRM-PROMO-INDX)                
                                       TO WS-CHK-OFFER-CD               
              MOVE WS-CRM-PROMO-VRSN-NO-KM(WS-CRM-PROMO-INDX)           
                                       TO WS-CHK-PROMO-VRSN-NO          
                                                                        
              PERFORM 6135-VLDT-FOR-MKT-PROMO      THRU 6135-EXIT       
              PERFORM 6136-VLDT-FOR-MKT-PROMO      THRU 6136-EXIT       
                                                                        
           END-PERFORM.                                                 
                                                                        
                                                                        
       2030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * RPM002-MODIFY OFFER WIZARD                                    *         
      *                                                               *         
      *****************************************************************         
       2040-VLDT-MODIFY-OFF.                                            
                                                                        
           MOVE WS-CRM-RESOURCE-ID            TO WS-RPM-WIZARDS.        
           MOVE WS-CRM-OFF-PRC-STAT-CD-FG     TO WS-CHK-PRC-STAT-CD.    
           MOVE WS-CRM-OFFER-CD-FG            TO WS-CHK-OFFER-CD.       
           MOVE WS-CRM-RENEWAL-OFFER-CD-FG    TO WS-CHK-RNWL-OFF-CD     
                                                 FG-RENEWAL-OFFER-CD.   
           MOVE WS-CRM-OFFER-START-DT-FG      TO WS-CHK-OFF-START-DT.   
           MOVE WS-CRM-OFF-VRSN-NO-FG         TO WS-OFF-VRSN-NO.        
PRJ680     MOVE WS-CRM-OFFER-END-DT-FG        TO WS-CHK-OFF-END-DT.     
PRJ680     MOVE WS-CRM-MAX-PRICE-OFFER-CD-FG  TO WS-CHK-MAX-PRC-OFF-CD. 
P00863     MOVE WS-CRM-RTCHG-PUB-OFFER-CD-FG  TO WS-CHK-RTCHG-PUB-OFF-CD
                                                                        
      *    CHECK FOR RENEWAL OFFER CODE STATUS.                                 
           IF WS-CHK-OFFER-CD NOT = WS-CHK-RNWL-OFF-CD                  
              PERFORM 2100-VLDT-FOR-RPM009       THRU 2100-EXIT         
A04177        PERFORM 2102-VLDT-FOR-RPM014       THRU 2102-EXIT         
              IF RENEWAL-OFFER-VALID                                    
                 PERFORM 2110-VLDT-FOR-RPM010    THRU 2110-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
PRJ680*    CHECK FOR MAX PRICE OFFER CODE STATUS.                               
PRJ680     IF WS-CHK-OFFER-CD NOT = WS-CHK-MAX-PRC-OFF-CD               
PRJ680        PERFORM 2105-VLDT-FOR-RPM007      THRU 2105-EXIT          
PRJ680     END-IF.                                                      
                                                                        
P00863*    CHECK FOR RATE CHANGE PUB OFFER CODE STATUS.                         
P00863     IF WS-CHK-OFFER-CD NOT EQUAL WS-CHK-RTCHG-PUB-OFF-CD         
P00863        PERFORM 2105A-VLDT-FOR-RPM015     THRU 2105A-EXIT         
P00863     END-IF                                                       
                                                                        
PRJ680*    CHECK THERE IS ANY CHANGE IN OFFER END DATE                          
PRJ680*    WHEN THE PROC STATUS IS APPROVED.                                    
PRJ680     IF CRM-OFFER-UPDATE                                          
PRJ680        PERFORM 2106-VLDT-FOR-RPM013      THRU 2106-EXIT          
P00863        PERFORM 2106A-VLDT-FOR-RPM017     THRU 2106A-EXIT         
PRJ680     END-IF.                                                      
                                                                        
      *    WHEN WE REJECT THE OFFER , IT WILL CHECK WHETHE OFFER USED           
      *    AS RENEWAL OFFER WITH OTHER OFFERS.                                  
           IF CALL-FRM-STATUS-UPDT AND WS-CHK-PRC-STAT-CD = WS-NEW      
                                   AND WS-OFF-VRSN-NO = 1               
              PERFORM 2111-VLDT-FOR-RJCT-OFF     THRU 2111-EXIT         
           END-IF.                                                      
                                                                        
           PERFORM 2115-PROCESS-OFFER-DET        THRU 2115-EXIT.        
                                                                        
       2040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * RPM004 - MODIFY OPTION WIZARD                                 *         
      *                                                               *         
      *****************************************************************         
       2050-VLDT-MODIFY-OPT.                                            
                                                                        
      *    OPTION VALIDATION                                                    
           PERFORM VARYING WS-CRM-OPT-INDX FROM 1 BY 1                  
                          UNTIL WS-CRM-OPT-INDX   > 20                  
            OR WS-CRM-OPTION-KEY-FI(WS-CRM-OPT-INDX) = SPACES           
            OR WS-CRM-OPTION-KEY-FI(WS-CRM-OPT-INDX) = LOW-VALUES       
                                                                        
             MOVE WS-CRM-OPTION-CD-FI(WS-CRM-OPT-INDX)                  
                                            TO WS-CHK-OPTION-CD         
             MOVE WS-CRM-OPT-PRC-STAT-CD-FI(WS-CRM-OPT-INDX)            
                                            TO WS-CHK-OPT-PRC-STAT-CD   
             MOVE WS-CRM-OPTION-START-DT-FI(WS-CRM-OPT-INDX)            
                                            TO WS-CHK-OPTION-START-DT   
             MOVE WS-CRM-OPTION-END-DT-FI(WS-CRM-OPT-INDX)              
                                            TO WS-CHK-OPTION-END-DT     
             MOVE WS-CRM-OPT-PRC-REQ-ID-FI(WS-CRM-OPT-INDX)             
                                            TO WS-CHK-OPT-PRC-REQ-ID    
                                                                        
             PERFORM 6120-VLDT-FOR-OPTION      THRU 6120-EXIT           
                                                                        
      *    VALIDATION FOR OFFER OPTION                                          
             MOVE WS-CRM-OFFER-CD-E9(WS-CRM-OPT-INDX)                   
                                   TO WS-CHK-OFFER-CD                   
             MOVE WS-CRM-OPTION-CD-E9(WS-CRM-OPT-INDX)                  
                                   TO WS-CHK-OPTION-CD                  
             MOVE WS-CRM-OFF-OPT-PRC-STAT-CD-E9(WS-CRM-OPT-INDX)        
                                   TO WS-CHK-OFF-OPT-PRC-STAT-CD        
             IF WS-CRM-OFF-OPT-PRC-REQ-ID-E9(WS-CRM-OPT-INDX) IS NUMERIC
                MOVE WS-CRM-OFF-OPT-PRC-REQ-ID-E9(WS-CRM-OPT-INDX)      
                                            TO WS-CHK-OPT-PRC-REQ-ID    
             ELSE                                                       
                MOVE ZEROS                  TO WS-CHK-OPT-PRC-REQ-ID    
             END-IF                                                     
                                                                        
      *    VALIDATION FOR OFFER OPTION / ATTR INCTV / OPTION ACCESS             
             PERFORM 2116-PROCESS-OPTION-DET   THRU 2116-EXIT           
                                                                        
           END-PERFORM.                                                 
                                                                        
       2050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * RPM002-MODIFY OFFER WIZARD, PROMOTION CHANGE                  *         
      *                                                               *         
      *****************************************************************         
       2060-VLDT-MODIFY-PROMO.                                          
                                                                        
           PERFORM VARYING WS-CRM-PROMO-INDX FROM 1 BY 1                
                   UNTIL WS-CRM-PROMO-INDX > 2                          
           OR WS-CRM-PROMO-KEY-KM(WS-CRM-PROMO-INDX) = SPACES           
           OR WS-CRM-PROMO-KEY-KM(WS-CRM-PROMO-INDX) = LOW-VALUES       
                                                                        
              MOVE WS-CRM-PROMO-CD-KM(WS-CRM-PROMO-INDX)                
                                       TO WS-CHK-PROMO-CD               
              MOVE WS-CRM-PROMO-PRC-STAT-CD-KM(WS-CRM-PROMO-INDX)       
                                       TO WS-CHK-PROMO-PRC-STAT-CD      
              MOVE WS-CRM-OFFER-CD-KM(WS-CRM-PROMO-INDX)                
                                       TO WS-CHK-OFFER-CD               
              MOVE WS-CRM-PROMO-VRSN-NO-KM(WS-CRM-PROMO-INDX)           
                                       TO WS-CHK-PROMO-VRSN-NO          
                                                                        
              PERFORM 6136-VLDT-FOR-MKT-PROMO      THRU 6136-EXIT       
                                                                        
           END-PERFORM.                                                 
                                                                        
       2060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * WHEN - CREATE NEW OFFER / MODIFY OFFER / REPLACE OFFEER        *        
      *                                                                *        
      ******************************************************************        
       2100-VLDT-FOR-RPM009.                                            
                                                                        
           IF WS-CHK-RNWL-OFF-CD  > SPACES                              
              MOVE WS-APPROVED               TO WS-PROC-STATUS-CD       
              MOVE FG-RENEWAL-OFFER-CD       TO FG-OFFER-CD             
              MOVE WS-CHK-RNWL-OFF-CD        TO WS-REN-OFFER-CD         
              IF WS-CHK-PRC-STAT-CD NOT EQUAL WS-NEW                    
      *       RNWL OFF SHOULD BE ACTV(AC) WHEN THE STATS IS PA/EA/AC            
PRJ680           PERFORM 7014-CHK-OFF-CD-ACTV-STAT THRU 7014-EXIT       
PRJ680           MOVE WS-OFFER-CD-VALID      TO WS-RNWL-OFF-CD-VALID    
              ELSE                                                      
      *       RNWL OFF SHOULD BE ACTV FOR THE CHECK DATE.                       
PRJ680           PERFORM 7000-CHK-OFF-CD-ACTV-STAT THRU 7000-EXIT       
PRJ680           MOVE WS-OFFER-CD-VALID      TO WS-RNWL-OFF-CD-VALID    
              END-IF                                                    
                                                                        
              IF RNWL-OFF-CD-NOT-VALID                                  
                 MOVE WS-ERR-HEAD-REN-OFF-DESC TO                       
                                 WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX) 
                 IF WS-CHK-PRC-STAT-CD EQUAL WS-NEW                     
                   MOVE 'RPM009'       TO WS-RULE-NO(WS-ERR-MESS-INDX)  
                   MOVE WS-YELLOW-FLAG TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
                   IF WS-ERR-MSG-RETURN-CD <= 1                         
                      MOVE 1  TO WS-ERR-MSG-RETURN-CD                   
                   END-IF                                               
                   SET WS-ERR-MESS-INDX UP BY 1                         
                   SET RNWL-OFFER-NOT-VALID TO TRUE                     
                 ELSE                                                   
      *       CHECK FOR UNAPPROVED RENEWAL OFF WHILE APPROVE THE OFFER.         
PRJ680            PERFORM 7015-CHK-OFF-CD-ACTV-STAT THRU 7015-EXIT      
                                                                        
                  IF (FG-PROC-STATUS-CD  EQUAL WS-NEW            AND    
                     (WS-CHK-PRC-STAT-CD EQUAL WS-PEND-APPROVAL   OR    
                      WS-CHK-PRC-STAT-CD EQUAL WS-EARLY-APPROVAL  OR    
                      WS-CHK-PRC-STAT-CD EQUAL WS-APPROVED))            
                      OR                                                
                     (FG-PROC-STATUS-CD  EQUAL WS-PEND-APPROVAL  AND    
                     (WS-CHK-PRC-STAT-CD EQUAL WS-EARLY-APPROVAL  OR    
                      WS-CHK-PRC-STAT-CD EQUAL WS-APPROVED))            
                      OR                                                
                     (FG-PROC-STATUS-CD  EQUAL WS-EARLY-APPROVAL AND    
                      WS-CHK-PRC-STAT-CD EQUAL WS-APPROVED)             
                                                                        
                      MOVE WS-REN-OFFER-CD TO                           
                                  WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)
                      MOVE 'RPM036'    TO WS-RULE-NO(WS-ERR-MESS-INDX)  
                      MOVE WS-RED-FLAG TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
                      MOVE 2           TO WS-ERR-MSG-RETURN-CD          
                      SET WS-ERR-MESS-INDX UP BY 1                      
                  ELSE                                                  
      *       IF THE RENEWAL OFFER IS AC STATUS WITH FUTURE DATE WHEN           
      *       WE APPROVE THE OFFER.                                             
                   IF FG-PROC-STATUS-CD EQUAL WS-APPROVED               
                      MOVE 'RPM009'    TO WS-RULE-NO(WS-ERR-MESS-INDX)  
                      MOVE WS-RED-FLAG TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
                      MOVE 2  TO WS-ERR-MSG-RETURN-CD                   
                      SET WS-ERR-MESS-INDX UP BY 1                      
                      SET RNWL-OFFER-NOT-VALID TO TRUE                  
                   END-IF                                               
                  END-IF                                                
              END-IF                                                    
           END-IF
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04177******************************************************************        
A04177* WHEN - CREATE NEW OFFER / MODIFY OFFER / REPLACE OFFEER        *        
A04177*                                                                *        
A04177* WHEN THE RENEWAL OFFER (OPTION) DOES NOT HAVE THE SAME CORE    *        
A04177* RATE AS THE ORIGINAL OFFER (OPTION).                           *        
A04177******************************************************************        
A04177 2102-VLDT-FOR-RPM014.                                            
A04177                                                                  
A04177     IF WS-CHK-RNWL-OFF-CD  > SPACES                              
A04177        MOVE WS-APPROVED               TO WS-PROC-STATUS-CD       
A04177        MOVE FG-RENEWAL-OFFER-CD       TO E9-OFFER-CD             
A04177        SET  WS-CRM-OPT-INDX           TO 1                       
A04177        MOVE WS-CRM-RATE-PLAN-NO-FI(WS-CRM-OPT-INDX)              
A04177                                       TO WS-ORGNL-OFF-RATE-PLAN  
A04177        PERFORM 7012-GET-RATE-PLAN-NO     THRU 7012-EXIT          
A04177        MOVE FI-RATE-PLAN-NO           TO WS-RNWL-OFF-RATE-PLAN   
A04177                                                                  
A04177        IF WS-RNWL-OFF-RATE-PLAN NOT = WS-ORGNL-OFF-RATE-PLAN     
A04177           MOVE WS-ERR-HEAD-REN-OFF-DESC TO                       
A04177                           WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX) 
A04177           MOVE 'RPM014'       TO WS-RULE-NO(WS-ERR-MESS-INDX)    
A04177           MOVE WS-YELLOW-FLAG TO WS-RULE-FLAG(WS-ERR-MESS-INDX)  
A04177           IF WS-ERR-MSG-RETURN-CD <= 1                           
A04177              MOVE 1  TO WS-ERR-MSG-RETURN-CD                     
A04177           END-IF                                                 
A04177           SET WS-ERR-MESS-INDX UP BY 1                           
A04177        END-IF                                                    
A04177     END-IF.                                                      
A04177                                                                  
A04177 2102-EXIT.                                                       
A04177     EXIT.                                                        
                                                                        
PRJ680******************************************************************        
PRJ680* WHEN - CREATE NEW OFFER / MODIFY OFFER / REPLACE OFFEER        *        
PRJ680*                                                                *        
PRJ680******************************************************************        
PRJ680 2105-VLDT-FOR-RPM007.                                            
PRJ680                                                                  
PRJ680     IF WS-CHK-MAX-PRC-OFF-CD > SPACES                            
PRJ680        MOVE WS-APPROVED               TO WS-PROC-STATUS-CD       
PRJ680        MOVE WS-CHK-MAX-PRC-OFF-CD     TO FG-OFFER-CD             
PRJ680                                          WS-MAX-PRC-OFFER-CD     
PRJ680        MOVE 'N'                       TO WS-OFFER-CD-VALID       
PRJ680        IF WS-CHK-PRC-STAT-CD NOT EQUAL WS-NEW                    
PRJ680*       MAX PRC OFF SHOULD BE ACTV(AC) WHEN THE STATS IS PA/EA/AC         
PRJ680           PERFORM 7014-CHK-OFF-CD-ACTV-STAT THRU 7014-exit       
PRJ680           MOVE WS-OFFER-CD-VALID      TO WS-MAX-PRC-OFF-CD-VALID 
PRJ680        ELSE                                                      
PRJ680*       MAX PRC OFF SHOULD BE ACTV FOR THE CHECK DATE.                    
PRJ680           PERFORM 7000-CHK-OFF-CD-ACTV-STAT THRU 7000-EXIT       
PRJ680           MOVE WS-OFFER-CD-VALID      TO WS-MAX-PRC-OFF-CD-VALID 
PRJ680        END-IF                                                    
PRJ680                                                                  
PRJ680        IF MAX-PRC-OFF-CD-NOT-VALID                               
PRJ680           MOVE WS-ERR-HEAD-MAX-PRC-OFF-DESC TO                   
PRJ680                           WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX) 
PRJ680           IF WS-CHK-PRC-STAT-CD EQUAL WS-NEW                     
PRJ680             MOVE 'RPM007'       TO WS-RULE-NO(WS-ERR-MESS-INDX)  
PRJ680             MOVE WS-YELLOW-FLAG TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
PRJ680             IF WS-ERR-MSG-RETURN-CD <= 1                         
PRJ680                MOVE 1  TO WS-ERR-MSG-RETURN-CD                   
PRJ680             END-IF                                               
PRJ680             SET WS-ERR-MESS-INDX UP BY 1                         
PRJ680           ELSE                                                   
PRJ680*       CHECK FOR UNAPPROVED MAX PRC OFF WHILE APPROVE THE OFFER.         
PRJ680            PERFORM 7015-CHK-OFF-CD-ACTV-STAT THRU 7015-EXIT      
PRJ680                                                                  
PRJ680            IF (FG-PROC-STATUS-CD  EQUAL WS-NEW            AND    
PRJ680               (WS-CHK-PRC-STAT-CD EQUAL WS-PEND-APPROVAL   OR    
PRJ680                WS-CHK-PRC-STAT-CD EQUAL WS-EARLY-APPROVAL  OR    
PRJ680                WS-CHK-PRC-STAT-CD EQUAL WS-APPROVED))            
PRJ680                OR                                                
PRJ680               (FG-PROC-STATUS-CD  EQUAL WS-PEND-APPROVAL  AND    
PRJ680               (WS-CHK-PRC-STAT-CD EQUAL WS-EARLY-APPROVAL  OR    
PRJ680                WS-CHK-PRC-STAT-CD EQUAL WS-APPROVED))            
PRJ680                OR                                                
PRJ680               (FG-PROC-STATUS-CD  EQUAL WS-EARLY-APPROVAL AND    
PRJ680                WS-CHK-PRC-STAT-CD EQUAL WS-APPROVED)             
PRJ680                                                                  
PRJ680                MOVE WS-MAX-PRC-OFFER-CD TO                       
PRJ680                            WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)
PRJ680                MOVE 'RPM008'    TO WS-RULE-NO(WS-ERR-MESS-INDX)  
PRJ680                MOVE WS-RED-FLAG TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
PRJ680                MOVE 2           TO WS-ERR-MSG-RETURN-CD          
PRJ680                SET WS-ERR-MESS-INDX UP BY 1                      
PRJ680            ELSE                                                  
PRJ680*       IF THE MAX PRC OFFER IS AC STATUS WITH FUTURE DATE WHEN           
PRJ680*       WE APPROVE THE OFFER.                                             
PRJ680             IF FG-PROC-STATUS-CD EQUAL WS-APPROVED               
PRJ680                MOVE 'RPM007'    TO WS-RULE-NO(WS-ERR-MESS-INDX)  
PRJ680                MOVE WS-RED-FLAG TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
PRJ680                MOVE 2  TO WS-ERR-MSG-RETURN-CD                   
PRJ680                SET WS-ERR-MESS-INDX UP BY 1                      
PRJ680             END-IF                                               
PRJ680            END-IF                                                
PRJ680        END-IF                                                    
PRJ680     END-IF
           END-IF.                                                      
PRJ680                                                                  
PRJ680 2105-EXIT.                                                       
PRJ680     EXIT.                                                        
                                                                        
P00863******************************************************************        
P00863* WHEN - CREATE NEW OFFER / MODIFY OFFER / REPLACE OFFEER        *        
P00863*                                                                *        
P00863******************************************************************        
P00863 2105A-VLDT-FOR-RPM015.                                           
P00863                                                                  
P00863     IF WS-CHK-RTCHG-PUB-OFF-CD > SPACES                          
P00863        MOVE WS-APPROVED               TO WS-PROC-STATUS-CD       
P00863        MOVE WS-CHK-RTCHG-PUB-OFF-CD   TO FG-OFFER-CD             
P00863                                          WS-RTCHG-PUB-OFFER-CD   
P00863        MOVE 'N'                       TO WS-OFFER-CD-VALID       
P00863        IF WS-CHK-PRC-STAT-CD NOT EQUAL WS-NEW                    
P00863* RATE CHANGE PUB OFFER SHOULD BE ACTV(AC) WHEN STATUS IS PA/EA/AC        
P00863           PERFORM 7014-CHK-OFF-CD-ACTV-STAT THRU 7014-EXIT       
P00863           MOVE WS-OFFER-CD-VALID                                 
P00863                TO WS-RTCHG-PUB-OFF-CD-VALID                      
P00863        ELSE                                                      
P00863* RATE CHANGE PUB OFFER SHOULD BE ACTV FOR THE CHECK DATE.                
P00863           PERFORM 7000-CHK-OFF-CD-ACTV-STAT THRU 7000-EXIT       
P00863           MOVE WS-OFFER-CD-VALID                                 
P00863                TO WS-RTCHG-PUB-OFF-CD-VALID                      
P00863        END-IF                                                    
P00863                                                                  
P00863        IF RTCHG-PUB-OFF-CD-NOT-VALID                             
P00863           MOVE WS-ERR-HEAD-RTCHG-PUB-OFF-DESC                    
P00863                TO WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)         
P00863           IF WS-CHK-PRC-STAT-CD EQUAL WS-NEW                     
P00863              MOVE 'RPM015'      TO WS-RULE-NO(WS-ERR-MESS-INDX)  
P00863              MOVE WS-YELLOW-FLAG                                 
P00863                                 TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
P00863              IF WS-ERR-MSG-RETURN-CD <= 1                        
P00863                 MOVE 1          TO WS-ERR-MSG-RETURN-CD          
P00863              END-IF                                              
P00863              SET WS-ERR-MESS-INDX UP BY 1                        
P00863           ELSE                                                   
P00863* CHECK FOR UNAPPROVED RATE CHANGE PUB OFFER WHEN APPROVING OFFER         
P00863              PERFORM 7015-CHK-OFF-CD-ACTV-STAT THRU 7015-EXIT    
P00863                                                                  
P00863              IF (FG-PROC-STATUS-CD  EQUAL WS-NEW            AND  
P00863                 (WS-CHK-PRC-STAT-CD EQUAL WS-PEND-APPROVAL   OR  
P00863                  WS-CHK-PRC-STAT-CD EQUAL WS-EARLY-APPROVAL  OR  
P00863                  WS-CHK-PRC-STAT-CD EQUAL WS-APPROVED))          
P00863                  OR                                              
P00863                 (FG-PROC-STATUS-CD  EQUAL WS-PEND-APPROVAL  AND  
P00863                 (WS-CHK-PRC-STAT-CD EQUAL WS-EARLY-APPROVAL  OR  
P00863                  WS-CHK-PRC-STAT-CD EQUAL WS-APPROVED))          
P00863                  OR                                              
P00863                 (FG-PROC-STATUS-CD  EQUAL WS-EARLY-APPROVAL AND  
P00863                  WS-CHK-PRC-STAT-CD EQUAL WS-APPROVED)           
P00863                                                                  
P00863                 MOVE WS-RTCHG-PUB-OFFER-CD                       
P00863                      TO WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)   
P00863                 MOVE 'RPM016' TO WS-RULE-NO(WS-ERR-MESS-INDX)    
P00863                 MOVE WS-RED-FLAG                                 
P00863                      TO WS-RULE-FLAG(WS-ERR-MESS-INDX)           
P00863                 MOVE 2        TO WS-ERR-MSG-RETURN-CD            
P00863                 SET WS-ERR-MESS-INDX UP BY 1                     
P00863              ELSE                                                
P00863* IF RATE CHANGE PUB OFFER IS AC STATUS WITH FUTURE DATE WHEN             
P00863* WE APPROVE THE OFFER.                                                   
P00863                 IF FG-PROC-STATUS-CD EQUAL WS-APPROVED           
P00863                    MOVE 'RPM015' TO WS-RULE-NO(WS-ERR-MESS-INDX) 
P00863                    MOVE WS-RED-FLAG                              
P00863                         TO WS-RULE-FLAG(WS-ERR-MESS-INDX)        
P00863                    MOVE 2        TO WS-ERR-MSG-RETURN-CD         
P00863                    SET WS-ERR-MESS-INDX UP BY 1                  
P00863                 END-IF                                           
P00863              END-IF                                              
P00863           END-IF                                                 
P00863        END-IF                                                    
P00863     END-IF.                                                      
P00863                                                                  
P00863 2105A-EXIT.                                                      
P00863     EXIT.                                                        
                                                                        
PRJ680******************************************************************        
PRJ680* CHECK THERE IS ANY CHANGE IN OFFER END DATE                             
PRJ680* WHEN THE PROC STATUS IS APPROVED.                                       
PRJ680*                                                                *        
PRJ680******************************************************************        
PRJ680 2106-VLDT-FOR-RPM013.                                            
PRJ680                                                                  
PRJ680     IF WS-CHK-PRC-STAT-CD EQUAL WS-APPROVED                      
PRJ680        MOVE WS-CRM-OFFER-CD-FG       TO FG-OFFER-CD              
PRJ680                                         WS-OFFER-CODE            
PRJ680        PERFORM 7126-GET-OFF-END-DT  THRU 7126-EXIT               
PRJ680        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
PRJ680           IF WS-CHK-OFF-END-DT NOT EQUAL FG-OFFER-END-DT         
PRJ680              MOVE WS-CRM-PROC-REQ-ID TO WS-COMMON-PROC-REQ-ID    
PRJ680              MOVE 0                  TO WS-ROW-COUNT             
PRJ680              PERFORM 7127-CHK-OFF-OPT-ROW-EXIST THRU 7127-EXIT   
PRJ680              IF WS-ROW-COUNT > 0                                 
PRJ680                 MOVE WS-ERR-HEAD-OFF-DESC TO                     
PRJ680                      WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)      
PRJ680                 MOVE WS-RED-FLAG  TO                             
PRJ680                      WS-RULE-FLAG(WS-ERR-MESS-INDX)              
PRJ680                 MOVE 'RPM013'     TO                             
PRJ680                      WS-RULE-NO(WS-ERR-MESS-INDX)                
PRJ680                 MOVE 2            TO WS-ERR-MSG-RETURN-CD        
PRJ680                 SET WS-ERR-MESS-INDX UP BY 1                     
PRJ680              END-IF                                              
PRJ680           END-IF                                                 
PRJ680        END-IF                                                    
PRJ680     END-IF.                                                      
PRJ680                                                                  
PRJ680 2106-EXIT.                                                       
PRJ680     EXIT.                                                        
                                                                        
P00863******************************************************************        
P00863* CHECK IF OFFER END DATE HAS CHANGED WHEN PROC STATUS IS APPROVED        
P00863*                                                                *        
P00863******************************************************************        
P00863 2106A-VLDT-FOR-RPM017.                                           
P00863                                                                  
P00863     IF WS-CHK-PRC-STAT-CD EQUAL WS-APPROVED                      
P00863        MOVE WS-CRM-OFFER-CD-FG       TO FG-OFFER-CD              
P00863                                         WS-OFFER-CODE            
P00863        PERFORM 7126-GET-OFF-END-DT  THRU 7126-EXIT               
P00863        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
P00863           IF WS-CHK-OFF-END-DT NOT EQUAL FG-OFFER-END-DT         
P00863              MOVE WS-CRM-PROC-REQ-ID TO WS-COMMON-PROC-REQ-ID    
P00863              MOVE 0                  TO WS-ROW-COUNT             
P00863              PERFORM 7128-CHK-OFFER-ROW-EXIST THRU 7128-EXIT     
P00863              IF WS-ROW-COUNT > 0                                 
P00863                 MOVE WS-ERR-HEAD-OFF-DESC TO                     
P00863                      WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)      
P00863                 MOVE WS-RED-FLAG  TO                             
P00863                      WS-RULE-FLAG(WS-ERR-MESS-INDX)              
P00863                 MOVE 'RPM017'     TO                             
P00863                      WS-RULE-NO(WS-ERR-MESS-INDX)                
P00863                 MOVE 2            TO WS-ERR-MSG-RETURN-CD        
P00863                 SET WS-ERR-MESS-INDX UP BY 1                     
P00863              END-IF                                              
P00863           END-IF                                                 
P00863        END-IF                                                    
P00863     END-IF.                                                      
P00863                                                                  
P00863 2106A-EXIT.                                                      
P00863     EXIT.                                                        
                                                                        
      ****************************************************************          
      *  WHEN - CREATE NEW OFFER / REPLACE OFFEER / MODIFY OFFER     *          
      *                                                              *          
      ****************************************************************          
       2110-VLDT-FOR-RPM010.                                            
                                                                        
           IF WS-CHK-RNWL-OFF-CD > SPACES                               
              MOVE WS-APPROVED              TO WS-PROC-STATUS-CD        
              MOVE 'N'                      TO WS-OPTION-IS-VP          
              PERFORM 7002-VLDT-RENEWAL-OFF-CD THRU 7002-EXIT           
              MOVE WS-CHK-RNWL-OFF-CD       TO WS-REN-OFFER-CD          
                                                                        
              IF LAST-OPTION-IS-NOT-VP                                  
                 MOVE WS-REN-OFFER-CD  TO                               
                                  WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)
                 MOVE 'RPM010'         TO WS-RULE-NO(WS-ERR-MESS-INDX)  
                 IF WS-CHK-PRC-STAT-CD EQUAL WS-NEW                     
                   MOVE WS-YELLOW-FLAG TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
                   IF WS-ERR-MSG-RETURN-CD <= 1                         
                      MOVE 1  TO WS-ERR-MSG-RETURN-CD                   
                   END-IF                                               
                   SET WS-ERR-MESS-INDX UP BY 1                         
                 ELSE                                                   
                   MOVE WS-RED-FLAG    TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
                   MOVE 2              TO WS-ERR-MSG-RETURN-CD          
                   SET WS-ERR-MESS-INDX UP BY 1                         
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * WHEN WE REJECT THE OFFER , IT WILL CHECK WHETHE OFFER USED   *          
      * AS RENEWAL OFFER WITH OTHER OFFERS.                          *          
      *                                                              *          
      ****************************************************************          
       2111-VLDT-FOR-RJCT-OFF.                                          
                                                                        
           MOVE WS-CHK-OFFER-CD      TO FG-OFFER-CD                     
           PERFORM 7118-CHK-RJCT-OFF-AS-RNWL  THRU 7118-EXIT            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-OFF-ATTCHD-WTH-OTHR-OFF EQUAL WS-YES                
                 MOVE FG-OFFER-CD   TO                                  
                               WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)   
                 MOVE 'RPM041'       TO WS-RULE-NO(WS-ERR-MESS-INDX)    
                 MOVE WS-YELLOW-FLAG TO                                 
                                       WS-RULE-FLAG(WS-ERR-MESS-INDX)   
                 IF WS-ERR-MSG-RETURN-CD <= 1                           
                    MOVE 1           TO WS-ERR-MSG-RETURN-CD            
                 END-IF                                                 
                 SET WS-ERR-MESS-INDX UP BY 1                           
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2111-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * WHEN - CREATE NEW OFFER / REPLACE OFFEER / MODIFY OFFER    *            
      **************************************************************            
       2115-PROCESS-OFFER-DET.                                          
                                                                        
      **************************************************************            
      *    VALIDATION FOR OFFER ACCESS INSERT / DELETE             *            
      **************************************************************            
                                                                        
           PERFORM VARYING WS-CRM-OFFR-TIER-INDX FROM 1 BY 1            
                       UNTIL WS-CRM-OFFR-TIER-INDX > 15                 
            OR WS-CRM-OFFR-TIER-IND-DU(WS-CRM-OFFR-TIER-INDX) = SPACES  
            OR WS-CRM-OFFR-TIER-IND-DU(WS-CRM-OFFR-TIER-INDX)           
                                                 = LOW-VALUES           
                                                                        
             MOVE WS-CRM-OFFER-CD-DU (WS-CRM-OFFR-TIER-INDX)            
                                     TO WS-CHK-OFFER-CD                 
             MOVE WS-CRM-TIER-CUST-STAT-CD-DU(WS-CRM-OFFR-TIER-INDX)    
                                     TO WS-CHK-TIER-CUST-STAT-CD        
             MOVE WS-CRM-TIER-ACCT-TYPE-CD-DU(WS-CRM-OFFR-TIER-INDX)    
                                     TO WS-CHK-TIER-ACCT-TYPE-CD        
             MOVE WS-CRM-MKT-TIER-RANKING-DU(WS-CRM-OFFR-TIER-INDX)     
                                     TO WS-CHK-MKT-TIER-RANKING         
             MOVE WS-CRM-TIER-DEFLT-OFFR-CD-DU(WS-CRM-OFFR-TIER-INDX)   
                                     TO WS-CHK-TIER-DEFLT-OFFR-CD       
      *      GET MKT TIER START DATE FROM CRM_MKT_TIER.                         
             IF CRM-OFFR-TIER-INSERT(WS-CRM-OFFR-TIER-INDX)             
                MOVE WS-CRM-COMPANY-NO        TO IG-COMPANY-NO          
                MOVE WS-CHK-TIER-CUST-STAT-CD TO IG-TIER-CUST-STAT-CD   
                MOVE WS-CHK-TIER-ACCT-TYPE-CD TO IG-TIER-ACCT-TYPE-CD   
                MOVE WS-CHK-MKT-TIER-RANKING  TO IG-MKT-TIER-RANKING    
                                                 WS-MKT-TIER-RANKING    
                PERFORM 7001-GET-MKT-TIER-STAT-DT THRU 7001-EXIT        
                MOVE IG-MKT-TIER-START-DT     TO                        
                                                WS-CHK-MKT-TIER-START-DT
             ELSE                                                       
                MOVE WS-CRM-MKT-TIER-START-DT-DU(WS-CRM-OFFR-TIER-INDX) 
                                             TO WS-CHK-MKT-TIER-START-DT
             END-IF                                                     
                                                                        
             MOVE WS-CRM-OFFER-TIER-STRT-DT-DU(WS-CRM-OFFR-TIER-INDX)   
                                     TO WS-CHK-OFFER-TIER-STRT-DT       
             MOVE WS-CRM-OFF-TER-VRSN-NO-DU(WS-CRM-OFFR-TIER-INDX)      
                                     TO WS-CHK-OFF-TIER-VRSN-NO         
             MOVE WS-CRM-OFF-TER-PRC-STAT-CD-DU(WS-CRM-OFFR-TIER-INDX)  
                                     TO WS-CHK-OFF-TER-PRC-STAT-CD      
                                                                        
             MOVE WS-CHK-OFFER-CD              TO DU-OFFER-CD           
             MOVE WS-CHK-TIER-CUST-STAT-CD     TO DU-TIER-CUST-STAT-CD  
             MOVE WS-CHK-TIER-ACCT-TYPE-CD     TO DU-TIER-ACCT-TYPE-CD  
             MOVE WS-CHK-MKT-TIER-RANKING      TO DU-MKT-TIER-RANKING   
             MOVE WS-CHK-TIER-DEFLT-OFFR-CD    TO DU-TIER-DEFLT-OFFR-CD 
             MOVE WS-CHK-MKT-TIER-START-DT     TO DU-MKT-TIER-START-DT  
             MOVE WS-CHK-OFFER-TIER-STRT-DT    TO DU-OFFER-TIER-STRT-DT 
      *      VALIDATION FOR OFF MKT TIER INSERT / DELETE                        
             PERFORM 6105-VLDT-FOR-OFF-MKT-TIER   THRU 6105-EXIT        
      *      VALIDATION FOR OFF MKT TIER INSERT / UPDATE                        
             IF CRM-OFFR-TIER-INSERT(WS-CRM-OFFR-TIER-INDX) OR          
                CRM-OFFR-TIER-UPDATE(WS-CRM-OFFR-TIER-INDX)             
                PERFORM 2150-VLDT-FOR-RPM005      THRU 2150-EXIT        
             END-IF                                                     
                                                                        
             PERFORM 2155-VLDT-FOR-RPM006         THRU 2155-EXIT        
                                                                        
           END-PERFORM.                                                 
                                                                        
      **************************************************************            
      *    VALIDATION FOR OFFER ACCESS INSERT / DELETE             *            
      *                                                            *            
      **************************************************************            
           PERFORM VARYING WS-CRM-OFFR-ACCS-INDX FROM 1 BY 1            
                       UNTIL WS-CRM-OFFR-ACCS-INDX > 05                 
            OR WS-CRM-OFFR-ACCS-IND-CI(WS-CRM-OFFR-ACCS-INDX) = SPACES  
            OR WS-CRM-OFFR-ACCS-IND-CI(WS-CRM-OFFR-ACCS-INDX)           
                                                = LOW-VALUES            
                                                                        
             MOVE WS-CRM-OFFR-OFFER-CD-CI(WS-CRM-OFFR-ACCS-INDX)        
                                       TO WS-CHK-OFFR-OFFER-CD          
             MOVE WS-CRM-OFFR-CATEGORY-ID-CI(WS-CRM-OFFR-ACCS-INDX)     
                                       TO WS-CHK-OFFR-CATEGORY-ID       
             MOVE WS-CRM-OFF-ACS-PRC-STAT-CD-CI(WS-CRM-OFFR-ACCS-INDX)  
                                       TO WS-CHK-OFF-ACS-PRC-STAT-CD    
             IF WS-CRM-OFFR-ACCS-IND-CI(WS-CRM-OFFR-ACCS-INDX)          
                                        NOT EQUAL WS-REFERENCE          
                PERFORM 6110-VLDT-FOR-OFF-ACCESS THRU 6110-EXIT         
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
      **************************************************************            
      *    VALIDATION OFFER RATE GROUP  INSERT / DELETE            *            
      **************************************************************            
           PERFORM VARYING WS-CRM-RT-GRP-OFFR-INDX FROM 1 BY 1          
                       UNTIL WS-CRM-RT-GRP-OFFR-INDX > 5                
            OR WS-CRM-RT-GRP-OFFR-IND-G5(WS-CRM-RT-GRP-OFFR-INDX)       
                                                         = SPACES       
            OR WS-CRM-RT-GRP-OFFR-IND-G5(WS-CRM-RT-GRP-OFFR-INDX)       
                                                         = LOW-VALUES   
                                                                        
             MOVE WS-CRM-OFFER-CD-G5(WS-CRM-RT-GRP-OFFR-INDX)           
                                     TO WS-CHK-OFFER-CD                 
             MOVE WS-CRM-RATE-GROUP-TYPE-CD-G5(WS-CRM-RT-GRP-OFFR-INDX) 
                                     TO WS-CHK-RATE-GROUP-TYPE-CD       
             MOVE WS-CRM-RATE-GROUP-CD-G5(WS-CRM-RT-GRP-OFFR-INDX)      
                                     TO WS-CHK-RATE-GROUP-CD            
             MOVE WS-CRM-GRP-OFF-PRC-STAT-CD-G5(WS-CRM-RT-GRP-OFFR-INDX)
                                     TO WS-CHK-GRP-OFF-PRC-STAT-CD      
             IF WS-CRM-RT-GRP-OFFR-IND-G5(WS-CRM-RT-GRP-OFFR-INDX)      
                                    NOT EQUAL WS-REFERENCE              
                PERFORM 6115-VLDT-FOR-OFF-RATE-GRP  THRU 6115-EXIT      
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
       2115-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * RPM004   - MODIFY OPTION WIZARD                                         
      *          - OFFER OPTION / RATE GRP / ACCESS OPTION         *            
      *                                                            *            
      **************************************************************            
       2116-PROCESS-OPTION-DET.                                         
                                                                        
      * When we try to approve the option that created                          
      * Through other offer, it should return an error message.                 
           IF CALL-FRM-STATUS-UPDT                                      
              MOVE WS-CHK-OPTION-CD      TO E9-OPTION-CD                
              MOVE WS-CHK-OFFER-CD       TO E9-OFFER-CD                 
            IF WS-CHK-OFF-OPT-PRC-STAT-CD NOT EQUAL WS-NEW              
              PERFORM 7116-GET-MAX-PROC-REQ-ID THRU 7116-EXIT           
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                IF FI-PROC-REQ-ID NOT EQUAL WS-CHK-OPT-PRC-REQ-ID       
                 IF (FI-PROC-STATUS-CD       EQUAL WS-NEW            AND
                   (WS-CHK-OFF-OPT-PRC-STAT-CD EQUAL WS-PEND-APPROVAL OR
                   WS-CHK-OFF-OPT-PRC-STAT-CD EQUAL WS-EARLY-APPROVAL OR
                   WS-CHK-OFF-OPT-PRC-STAT-CD EQUAL WS-APPROVED))       
                     OR                                                 
                    (FI-PROC-STATUS-CD        EQUAL WS-PEND-APPROVAL AND
                  (WS-CHK-OFF-OPT-PRC-STAT-CD EQUAL WS-EARLY-APPROVAL OR
                   WS-CHK-OFF-OPT-PRC-STAT-CD EQUAL WS-APPROVED))       
                     OR                                                 
                  (FI-PROC-STATUS-CD         EQUAL WS-EARLY-APPROVAL AND
                   WS-CHK-OFF-OPT-PRC-STAT-CD EQUAL WS-APPROVED)        
                                                                        
                     MOVE FI-OPTION-CD TO                               
                                  WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)
                     MOVE 'RPM037'     TO WS-RULE-NO(WS-ERR-MESS-INDX)  
                     MOVE WS-RED-FLAG  TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
                                                                        
                     MOVE 2            TO WS-ERR-MSG-RETURN-CD          
                     SET WS-ERR-MESS-INDX UP BY 1                       
                 END-IF                                                 
                END-IF                                                  
              END-IF                                                    
            ELSE                                                        
      * When we try to reject the offer and if the option(created under         
      * same offer) are attached wih other offer, it should return              
      * warning message.                                                        
              PERFORM 7117-CHK-OFF-OPT-STATUS THRU 7117-EXIT            
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF WS-OPT-ATTCHD-WTH-OTHR-OFF EQUAL WS-YES             
                    MOVE FI-OPTION-CD   TO                              
                                  WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)
                    MOVE 'RPM040'       TO WS-RULE-NO(WS-ERR-MESS-INDX) 
                    MOVE WS-YELLOW-FLAG TO                              
                                          WS-RULE-FLAG(WS-ERR-MESS-INDX)
                    IF WS-ERR-MSG-RETURN-CD <= 1                        
                       MOVE 1           TO WS-ERR-MSG-RETURN-CD         
                    END-IF                                              
                    SET WS-ERR-MESS-INDX UP BY 1                        
                 END-IF                                                 
              END-IF                                                    
            END-IF                                                      
           END-IF.                                                      
                                                                        
      **************************************************************            
      * VALIDATION FOR OPTION ATTRIBUTE INCENTIVE INSERT / DELETE  *            
      **************************************************************            
           PERFORM VARYING WS-CRM-ATTRB-INDX FROM 1 BY 1                
                                UNTIL WS-CRM-ATTRB-INDX > 10            
              OR WS-CRM-OPT-ATTRB-IND(WS-CRM-OPT-INDX                   
                                     ,WS-CRM-ATTRB-INDX) = SPACES       
              OR WS-CRM-OPT-ATTRB-IND(WS-CRM-OPT-INDX                   
                                     ,WS-CRM-ATTRB-INDX) = LOW-VALUES   
                                                                        
             MOVE WS-CRM-OPTION-CD-HQ (WS-CRM-OPT-INDX                  
                                 , WS-CRM-ATTRB-INDX)                   
                                TO WS-CHK-OPTION-CD                     
             MOVE WS-CRM-FACTOR-ID-HQ (WS-CRM-OPT-INDX                  
                                 , WS-CRM-ATTRB-INDX)                   
                                TO WS-CHK-FACTOR-ID                     
             MOVE WS-CRM-RT-ATTR-INCTV-TYPE-HQ (WS-CRM-OPT-INDX         
                                 , WS-CRM-ATTRB-INDX)                   
                                TO WS-CHK-RT-ATTR-INCTV-TYPE            
             MOVE WS-CRM-ATTR-INCTV-SEQ-NO-HQ (WS-CRM-OPT-INDX          
                                 , WS-CRM-ATTRB-INDX)                   
                                TO WS-CHK-ATTR-INCTV-SEQ-NO             
             MOVE WS-CRM-PRIMRY-OPT-ATTR-FL-HQ (WS-CRM-OPT-INDX         
                                 , WS-CRM-ATTRB-INDX)                   
                                TO WS-CHK-PRIMRY-OPT-ATTR-FL            
             MOVE WS-CRM-OPT-ATRB-PRC-STAT-CD-HQ (WS-CRM-OPT-INDX       
                                 , WS-CRM-ATTRB-INDX)                   
                                TO WS-CHK-OPT-ATRB-PRC-STAT-CD          
                                                                        
             PERFORM 2165-VLDT-FOR-RPM011     THRU 2165-EXIT            
             IF CRM-OPT-ATTRB-INSERT(WS-CRM-OPT-INDX,WS-CRM-ATTRB-INDX) 
                OR                                                      
                CRM-OPT-ATTRB-UPDATE(WS-CRM-OPT-INDX,WS-CRM-ATTRB-INDX) 
                PERFORM 2170-VLDT-FOR-RPM012     THRU 2170-EXIT         
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
       2116-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * WHEN -CREATE NEW OFFER / REPLACE OFFEER / MODIFY OFFER.        *        
      *                                                                *        
      ******************************************************************        
       2150-VLDT-FOR-RPM005.                                            
                                                                        
           IF WS-CHK-TIER-DEFLT-OFFR-CD   EQUAL WS-YES AND              
              WS-CHK-TIER-CUST-STAT-CD  > SPACES AND                    
              WS-CHK-TIER-ACCT-TYPE-CD  > SPACES AND                    
              WS-CHK-MKT-TIER-RANKING   > ZERO                          
                                                                        
              MOVE WS-APPROVED               TO WS-PROC-STATUS-CD       
              MOVE WS-CHK-TIER-CUST-STAT-CD  TO IG-TIER-CUST-STAT-CD    
              MOVE WS-CHK-TIER-ACCT-TYPE-CD  TO IG-TIER-ACCT-TYPE-CD    
              MOVE WS-CHK-MKT-TIER-RANKING   TO IG-MKT-TIER-RANKING     
                                                WS-MKT-TIER-RANKING     
                                                                        
              PERFORM 7010-GET-MKT-TIER-DESC    THRU 7010-EXIT          
                                                                        
              PERFORM 7003-VLDT-DEFLT-OFF-CD    THRU 7003-EXIT          
              MOVE WS-ERR-HEAD-MKT-TIER-DESC TO                         
                              WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)    
              MOVE 'RPM005' TO WS-RULE-NO(WS-ERR-MESS-INDX)             
              IF ALREADY-DFLT-OFF-EXIST                                 
      *       PROCESS FOR TEMPLATE OFFER                                        
                 IF CREATE-REPLACE-OFFER-WIZARD                         
                    IF DU-OFFER-CD EQUAL WS-CRM-TEMPLATE-OFFER-CD AND   
                       WS-CRM-UNDFLT-TMPLT-OFFR-TIERS = WS-YES          
                       CONTINUE                                         
                    ELSE                                                
                       IF WS-CHK-OFF-TER-PRC-STAT-CD EQUAL WS-NEW       
                          MOVE WS-YELLOW-FLAG TO                        
                                          WS-RULE-FLAG(WS-ERR-MESS-INDX)
                          IF WS-ERR-MSG-RETURN-CD <= 1                  
                             MOVE 1           TO WS-ERR-MSG-RETURN-CD   
                          END-IF                                        
                          SET WS-ERR-MESS-INDX UP BY 1                  
                       ELSE                                             
                          MOVE WS-RED-FLAG TO                           
                                      WS-RULE-FLAG(WS-ERR-MESS-INDX)    
                          MOVE 2   TO WS-ERR-MSG-RETURN-CD              
                          SET WS-ERR-MESS-INDX UP BY 1                  
                       END-IF                                           
                    END-IF                                              
                 ELSE                                                   
      *          PROCESS FOR CREATE/ MODIFY OFFER WIZARD                        
                    IF WS-CHK-OFFER-CD NOT EQUAL DU-OFFER-CD            
                       IF WS-CHK-OFF-TER-PRC-STAT-CD EQUAL WS-NEW       
                          MOVE WS-YELLOW-FLAG TO                        
                                          WS-RULE-FLAG(WS-ERR-MESS-INDX)
                          IF WS-ERR-MSG-RETURN-CD <= 1                  
                             MOVE 1        TO WS-ERR-MSG-RETURN-CD      
                          END-IF                                        
                          SET WS-ERR-MESS-INDX UP BY 1                  
                       ELSE                                             
                          MOVE WS-RED-FLAG TO                           
                                          WS-RULE-FLAG(WS-ERR-MESS-INDX)
                           MOVE 2   TO WS-ERR-MSG-RETURN-CD             
                          SET WS-ERR-MESS-INDX UP BY 1                  
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
           END-IF
           END-IF.                                                      
                                                                        
       2150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * WHEN - CREATE NEW OFFER / REPLACE OFFEER / MODIFY OFFER        *        
      *                                                                *        
      ******************************************************************        
       2155-VLDT-FOR-RPM006.                                            
                                                                        
           IF WS-CHK-TIER-CUST-STAT-CD    > SPACES AND                  
              WS-CHK-TIER-ACCT-TYPE-CD    > SPACES AND                  
              WS-CHK-MKT-TIER-RANKING     > ZERO   AND                  
              WS-CHK-OFFER-CD             > SPACES                      
                                                                        
              MOVE WS-APPROVED                   TO WS-PROC-STATUS-CD   
              MOVE WS-CHK-OFFER-CD               TO DU-OFFER-CD         
              MOVE WS-CHK-TIER-CUST-STAT-CD      TO IG-TIER-CUST-STAT-CD
              MOVE WS-CHK-TIER-ACCT-TYPE-CD      TO IG-TIER-ACCT-TYPE-CD
              MOVE WS-CHK-MKT-TIER-RANKING       TO IG-MKT-TIER-RANKING 
                                                    WS-MKT-TIER-RANKING 
                                                                        
              PERFORM 7010-GET-MKT-TIER-DESC        THRU 7010-EXIT      
              PERFORM 7004-VLDT-OFF-MKT-TIER        THRU 7004-EXIT      
              IF  WS-ACTIVE-ROW-COUNT > 0 AND                           
                 (CRM-OFFR-TIER-INSERT(WS-CRM-OFFR-TIER-INDX) OR        
                  CRM-OFFR-TIER-UPDATE(WS-CRM-OFFR-TIER-INDX)  )        
                  MOVE WS-ERR-HEAD-MKT-TIER-DESC TO                     
                              WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)    
                  MOVE 'RPM006'      TO WS-RULE-NO(WS-ERR-MESS-INDX)    
                                                                        
                  IF WS-CHK-OFF-TER-PRC-STAT-CD EQUAL WS-NEW            
                     MOVE WS-YELLOW-FLAG                                
                                     TO WS-RULE-FLAG(WS-ERR-MESS-INDX)  
                     IF WS-ERR-MSG-RETURN-CD <= 1                       
                        MOVE 1       TO WS-ERR-MSG-RETURN-CD            
                     END-IF                                             
                     SET WS-ERR-MESS-INDX UP BY 1                       
                  ELSE                                                  
                    MOVE WS-RED-FLAG TO WS-RULE-FLAG(WS-ERR-MESS-INDX)  
                    MOVE 2           TO WS-ERR-MSG-RETURN-CD            
                    SET WS-ERR-MESS-INDX UP BY 1                        
                  END-IF                                                
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2155-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * WHEN - MODIFY OFFER / MODIFY OPTION WIZARD'S                   *        
      ******************************************************************        
       2165-VLDT-FOR-RPM011.                                            
                                                                        
           IF WS-CHK-OPTION-CD > SPACES AND                             
              WS-CHK-PRIMRY-OPT-ATTR-FL EQUAL 'Y'                       
              MOVE WS-APPROVED                  TO WS-PROC-STATUS-CD    
              MOVE WS-CHK-PRIMRY-OPT-ATTR-FL    TO HQ-PRIMRY-OPT-ATTR-FL
              MOVE WS-CHK-OPTION-CD             TO WS-OPTN1-CD          
                                                   HQ-OPTION-CD         
                                                                        
              PERFORM 7006-VLDT-OPTION-CD          THRU 7006-EXIT       
              IF WS-PRIM-ATTR-COUNT > ZERO                              
                 MOVE WS-OPTN1-CD      TO                               
                      WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)            
                 MOVE 'RPM011'         TO WS-RULE-NO(WS-ERR-MESS-INDX)  
                 IF WS-CHK-OPT-ATRB-PRC-STAT-CD EQUAL                   
                    WS-NEW OR WS-PEND-APPROVAL OR WS-EARLY-APPROVAL     
                   MOVE WS-YELLOW-FLAG TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
                   IF WS-ERR-MSG-RETURN-CD <= 1                         
                      MOVE 1  TO WS-ERR-MSG-RETURN-CD                   
                   END-IF                                               
                   SET WS-ERR-MESS-INDX UP BY 1                         
                 ELSE                                                   
                   MOVE WS-RED-FLAG    TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
                   MOVE 'RPM011'       TO WS-RULE-NO(WS-ERR-MESS-INDX)  
                   MOVE 2  TO WS-ERR-MSG-RETURN-CD                      
                   SET WS-ERR-MESS-INDX UP BY 1                         
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2165-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * WHEN - CREATE/MODIFY OFFER AND MODIFY OPTION WIZARD'S.      *           
      *                                                             *           
      ***************************************************************           
       2170-VLDT-FOR-RPM012.                                            
                                                                        
           IF WS-CHK-OPTION-CD          > SPACES AND                    
              WS-CHK-RT-ATTR-INCTV-TYPE EQUAL WS-FIXED-PRICE            
              MOVE WS-CHK-FACTOR-ID             TO HQ-FACTOR-ID         
                                                   SA-FACTOR-ID         
              MOVE WS-CHK-OPTION-CD             TO HQ-OPTION-CD         
              MOVE WS-CHK-RT-ATTR-INCTV-TYPE    TO HQ-RT-ATTR-INCTV-TYPE
              MOVE WS-APPROVED                  TO WS-PROC-STATUS-CD    
              MOVE 'N'                          TO WS-FCTR-ACTIVE       
              PERFORM 7007-VLDT-OPT-ATTR-INCTV     THRU 7007-EXIT       
                                                                        
              IF FACTOR-NOT-ACTIVE                                      
                 IF WS-CHK-OPT-ATRB-PRC-STAT-CD EQUAL                   
                    WS-NEW OR WS-PEND-APPROVAL  OR WS-EARLY-APPROVAL    
                                                OR WS-APPROVED          
                   MOVE WS-CHK-FACTOR-ID        TO WS-FACTOR-ID         
                   MOVE WS-CHK-OPTION-CD        TO WS-OPTN2-CD          
                                                                        
                   MOVE WS-ERR-HEAD-OPT-FACTOR  TO                      
                                  WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)
                   MOVE WS-YELLOW-FLAG TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
                   MOVE 'RPM012'       TO WS-RULE-NO(WS-ERR-MESS-INDX)  
                   IF WS-ERR-MSG-RETURN-CD <= 1                         
                      MOVE 1  TO WS-ERR-MSG-RETURN-CD                   
                   END-IF                                               
                   SET WS-ERR-MESS-INDX UP BY 1                         
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * VALIDATION FOR OFFER - CRM_RT_PKG_OFFER TABLE.               *          
      *                                                              *          
      ****************************************************************          
       6100-VALIDATION-FOR-OFF.                                         
                                                                        
           PERFORM 7100-CHK-OFF-ROW-EXIST         THRU 7100-EXIT.       
           IF WS-OFFER-ROW-EXIST  = WS-YES                              
              MOVE FG-OFFER-CD TO WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)
              MOVE WS-RED-FLAG TO WS-RULE-FLAG(WS-ERR-MESS-INDX)        
              MOVE 'RPM018'    TO WS-RULE-NO(WS-ERR-MESS-INDX)          
              MOVE 2           TO WS-ERR-MSG-RETURN-CD                  
              SET WS-ERR-MESS-INDX UP BY 1                              
           END-IF.                                                      
                                                                        
       6100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * VALIDATION FOR OFFER - CRM_OFF_MKT_TIER TABLE                 *         
      *                                                               *         
      *****************************************************************         
       6105-VLDT-FOR-OFF-MKT-TIER.                                      
                                                                        
           MOVE WS-NO                     TO WS-ROW-EXIST               
           MOVE WS-CHK-TIER-CUST-STAT-CD  TO IG-TIER-CUST-STAT-CD       
           MOVE WS-CHK-TIER-ACCT-TYPE-CD  TO IG-TIER-ACCT-TYPE-CD       
           MOVE WS-CHK-MKT-TIER-RANKING   TO IG-MKT-TIER-RANKING        
                                             WS-MKT-TIER-RANKING        
                                                                        
           PERFORM 7010-GET-MKT-TIER-DESC THRU 7010-EXIT                
                                                                        
           EVALUATE TRUE                                                
           WHEN CRM-OFFR-TIER-INSERT(WS-CRM-OFFR-TIER-INDX)             
                MOVE WS-APPROVED  TO WS-PROC-STATUS-CD                  
                PERFORM 7105-CHK-OFF-MKT-TIER-ROW   THRU 7105-EXIT      
                MOVE WS-ROW-EXIST TO WS-OFF-MKT-TIER-ROW-EXIST          
              IF WS-OFF-MKT-TIER-ROW-EXIST  EQUAL WS-YES                
                 PERFORM VARYING WS-DUMMY-OFF-TIER-INDX FROM 1 BY 1     
                 UNTIL WS-DUMMY-OFF-TIER-INDX = WS-CRM-OFFR-TIER-INDX   
                                             OR WS-DELETE-ROW-FOUND     
      *****************************************************************         
      *    IF THE INPUT STRING COMES WITH DELETE AND INSERT FOR THE   *         
      *    EXISTING ENTRY THEN SYSTEM SHOULD NOT THROW ERROR.                   
      *****************************************************************         
                   IF CRM-OFFR-TIER-DELETE(WS-DUMMY-OFF-TIER-INDX)      
                      AND WS-CRM-OFFER-CD-DU(WS-CRM-OFFR-TIER-INDX) =   
                          WS-CRM-OFFER-CD-DU(WS-DUMMY-OFF-TIER-INDX)    
                      AND WS-CRM-TIER-CUST-STAT-CD-DU                   
                                            (WS-CRM-OFFR-TIER-INDX) =   
                          WS-CRM-TIER-CUST-STAT-CD-DU                   
                                            (WS-DUMMY-OFF-TIER-INDX)    
                      AND WS-CRM-TIER-ACCT-TYPE-CD-DU                   
                                            (WS-CRM-OFFR-TIER-INDX) =   
                          WS-CRM-TIER-ACCT-TYPE-CD-DU                   
                                            (WS-DUMMY-OFF-TIER-INDX)    
                      AND WS-CRM-MKT-TIER-RANKING-DU                    
                                            (WS-CRM-OFFR-TIER-INDX) =   
                          WS-CRM-MKT-TIER-RANKING-DU                    
                                            (WS-DUMMY-OFF-TIER-INDX)    
                      MOVE WS-YES TO WS-DELETE-ROW-FOUND                
                   ELSE                                                 
                      MOVE WS-NO  TO WS-DELETE-ROW-FOUND                
                   END-IF                                               
                                                                        
                 END-PERFORM                                            
                 IF DELETE-ROW-NOT-FOUND                                
                    MOVE WS-ERR-HEAD-MKT-TIER-DESC TO                   
                         WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)         
                    MOVE WS-RED-FLAG TO WS-RULE-FLAG(WS-ERR-MESS-INDX)  
                    MOVE 'RPM019'    TO WS-RULE-NO(WS-ERR-MESS-INDX)    
                    MOVE 2           TO WS-ERR-MSG-RETURN-CD            
                    SET WS-ERR-MESS-INDX UP BY 1                        
                    MOVE WS-NO       TO WS-DELETE-ROW-FOUND             
                 END-IF                                                 
              END-IF                                                    
                                                                        
           WHEN CRM-OFFR-TIER-DELETE(WS-CRM-OFFR-TIER-INDX) AND         
                WS-CHK-OFF-TER-PRC-STAT-CD NOT EQUAL WS-NEW             
                   MOVE WS-ERR-HEAD-MKT-TIER-DESC TO                    
                        WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)          
                   MOVE WS-RED-FLAG TO WS-RULE-FLAG(WS-ERR-MESS-INDX)   
                   MOVE 'RPM026'    TO WS-RULE-NO(WS-ERR-MESS-INDX)     
                   MOVE 2           TO WS-ERR-MSG-RETURN-CD             
                   SET WS-ERR-MESS-INDX UP BY 1                         
           END-EVALUATE.                                                
                                                                        
       6105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * VALIDATION FOR OFFER - CRM_ACCESS_OFF_OPT TABLE.             *          
      *                                                              *          
      ****************************************************************          
       6110-VLDT-FOR-OFF-ACCESS.                                        
                                                                        
           MOVE WS-NO                    TO WS-ROW-EXIST                
           MOVE WS-CHK-OFFR-OFFER-CD     TO CI-OFFER-CD                 
                                            WS-OFFER-CD                 
           MOVE WS-CHK-OFFR-CATEGORY-ID  TO CI-CATEGORY-ID              
                                                                        
           EVALUATE TRUE                                                
              WHEN CRM-OFFR-ACCS-INSERT(WS-CRM-OFFR-ACCS-INDX)          
                   MOVE WS-APPROVED     TO WS-PROC-STATUS-CD            
                   PERFORM 7110-CHK-OFF-ACCESS-ROW    THRU 7110-EXIT    
                   MOVE WS-ROW-EXIST    TO WS-OFF-ACCESS-ROW-EXIST      
              IF WS-OFF-ACCESS-ROW-EXIST  EQUAL WS-YES                  
                 PERFORM VARYING WS-DUMMY-OFF-ACCS-INDX FROM 1 BY 1     
                 UNTIL WS-DUMMY-OFF-ACCS-INDX = WS-CRM-OFFR-ACCS-INDX   
                                             OR WS-DELETE-ROW-FOUND     
      *****************************************************************         
      *    IF THE INPUT STRING COMES WITH DELETE AND INSERT FOR THE   *         
      *    EXISTING ENTRY THEN SYSTEM SHOULD NOT THROW ERROR.                   
      *****************************************************************         
                   IF CRM-OFFR-ACCS-DELETE(WS-DUMMY-OFF-ACCS-INDX)      
                      AND WS-CRM-OFFR-OFFER-CD-CI                       
                                            (WS-CRM-OFFR-ACCS-INDX) =   
                          WS-CRM-OFFR-OFFER-CD-CI                       
                                            (WS-DUMMY-OFF-ACCS-INDX)    
                      AND WS-CRM-OFFR-CATEGORY-ID-CI                    
                                            (WS-CRM-OFFR-ACCS-INDX) =   
                          WS-CRM-OFFR-CATEGORY-ID-CI                    
                                            (WS-DUMMY-OFF-ACCS-INDX)    
                      MOVE WS-YES TO WS-DELETE-ROW-FOUND                
                   ELSE                                                 
                      MOVE WS-NO  TO WS-DELETE-ROW-FOUND                
                   END-IF                                               
                                                                        
                 END-PERFORM                                            
                   IF DELETE-ROW-NOT-FOUND                              
                      MOVE WS-OFFER-CD TO                               
                                  WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)
                      MOVE WS-RED-FLAG TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
                      MOVE 'RPM020'    TO WS-RULE-NO(WS-ERR-MESS-INDX)  
                      MOVE 2  TO WS-ERR-MSG-RETURN-CD                   
                      SET WS-ERR-MESS-INDX UP BY 1                      
                      MOVE WS-NO       TO WS-DELETE-ROW-FOUND           
                   END-IF                                               
              END-IF                                                    
                                                                        
              WHEN CRM-OFFR-ACCS-DELETE(WS-CRM-OFFR-ACCS-INDX) AND      
                   WS-CHK-OFF-ACS-PRC-STAT-CD NOT EQUAL WS-NEW          
                      MOVE WS-ERR-HEAD-OFFER-DESC TO                    
                                  WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)
                      MOVE WS-RED-FLAG TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
                      MOVE 'RPM031'    TO WS-RULE-NO(WS-ERR-MESS-INDX)  
                      MOVE 2  TO WS-ERR-MSG-RETURN-CD                   
                      SET WS-ERR-MESS-INDX UP BY 1                      
                                                                        
           END-EVALUATE.                                                
                                                                        
       6110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * VALIDATION FOR OFFER INSERT / DELETE - CRM_OFF_RATE_GRP      *          
      *                                                              *          
      ****************************************************************          
       6115-VLDT-FOR-OFF-RATE-GRP.                                      
                                                                        
           MOVE WS-NO                     TO WS-ROW-EXIST               
           MOVE WS-CHK-OFFER-CD           TO G5-OFFER-CD.               
           MOVE WS-CHK-RATE-GROUP-TYPE-CD TO G5-RATE-GROUP-TYPE-CD      
                                             F7-RATE-GROUP-TYPE-CD.     
           MOVE WS-CHK-RATE-GROUP-CD      TO G5-RATE-GROUP-CD           
                                             F7-RATE-GROUP-CD.          
           PERFORM 7090-GET-RATE-GRP-DESC THRU 7090-EXIT.               
                                                                        
           EVALUATE TRUE                                                
           WHEN CRM-RT-GRP-OFFR-INSERT(WS-CRM-RT-GRP-OFFR-INDX)         
                MOVE WS-APPROVED          TO WS-PROC-STATUS-CD          
                PERFORM 7115-CHK-OFF-RATE-GRP-ROW  THRU 7115-EXIT       
                MOVE WS-ROW-EXIST         TO WS-OFF-RATE-GRP-EXIST      
              IF WS-OFF-RATE-GRP-EXIST  EQUAL WS-YES                    
                 PERFORM VARYING WS-DUMMY-RT-GRP-INDX  FROM 1 BY 1      
                   UNTIL WS-DUMMY-RT-GRP-INDX =  WS-CRM-RT-GRP-OFFR-INDX
                                              OR WS-DELETE-ROW-FOUND    
      *****************************************************************         
      *    IF THE STRING COMES WITH DELETE AND INSERT FOR THE EXITING *         
      *    ENtry THEN SYSTEM SHOULD NOT THROW ERROR.                  *         
      *****************************************************************         
                   IF CRM-RT-GRP-OFFR-DELETE(WS-DUMMY-RT-GRP-INDX)      
                      AND WS-CRM-OFFER-CD-G5(WS-CRM-RT-GRP-OFFR-INDX) = 
                          WS-CRM-OFFER-CD-G5(WS-DUMMY-RT-GRP-INDX)      
                      AND WS-CRM-RATE-GROUP-TYPE-CD-G5                  
                                            (WS-CRM-RT-GRP-OFFR-INDX) = 
                          WS-CRM-RATE-GROUP-TYPE-CD-G5                  
                                            (WS-DUMMY-RT-GRP-INDX)      
                      AND WS-CRM-RATE-GROUP-CD-G5                       
                                            (WS-CRM-RT-GRP-OFFR-INDX) = 
                          WS-CRM-RATE-GROUP-CD-G5                       
                                            (WS-DUMMY-RT-GRP-INDX)      
                      MOVE WS-YES TO WS-DELETE-ROW-FOUND                
                   ELSE                                                 
                      MOVE WS-NO  TO WS-DELETE-ROW-FOUND                
                   END-IF                                               
                                                                        
                 END-PERFORM                                            
                 IF DELETE-ROW-NOT-FOUND                                
                    MOVE WS-RATE-GROUP-DESC        TO                   
                                  WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)
                    MOVE WS-RED-FLAG TO WS-RULE-FLAG(WS-ERR-MESS-INDX)  
                    MOVE 'RPM021'    TO WS-RULE-NO(WS-ERR-MESS-INDX)    
                    MOVE 2           TO WS-ERR-MSG-RETURN-CD            
                    SET WS-ERR-MESS-INDX UP BY 1                        
                    MOVE WS-NO       TO WS-DELETE-ROW-FOUND             
                 END-IF                                                 
              END-IF                                                    
                                                                        
           WHEN CRM-RT-GRP-OFFR-DELETE(WS-CRM-RT-GRP-OFFR-INDX) AND     
                WS-CHK-GRP-OFF-PRC-STAT-CD NOT EQUAL WS-NEW             
                   MOVE WS-ERR-HEAD-RATE-GRP-DESC TO                    
                                 WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX) 
                   MOVE WS-RED-FLAG TO WS-RULE-FLAG(WS-ERR-MESS-INDX)   
                   MOVE 'RPM027'    TO WS-RULE-NO(WS-ERR-MESS-INDX)     
                   MOVE 2  TO WS-ERR-MSG-RETURN-CD                      
                   SET WS-ERR-MESS-INDX UP BY 1                         
           END-EVALUATE.                                                
                                                                        
       6115-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * VALIDATION FOR OPTION INSERT / DELETE - CRM_RT_PKG_OPTION.   *          
      *                                                              *          
      ****************************************************************          
       6120-VLDT-FOR-OPTION.                                            
                                                                        
           MOVE WS-NO                       TO WS-ROW-EXIST.            
           MOVE WS-CHK-OPTION-CD            TO FI-OPTION-CD             
                                               WS-OPTION-CD.            
           EVALUATE TRUE                                                
             WHEN CRM-OPTION-INSERT(WS-CRM-OPT-INDX)                    
                  MOVE WS-APPROVED     TO WS-PROC-STATUS-CD             
                  PERFORM 7120-CHK-OPT-ROW-EXIST THRU 7120-EXIT         
                  MOVE WS-ROW-EXIST    TO WS-OPTION-ROW-EXIST           
                  IF WS-OPTION-ROW-EXIST EQUAL WS-YES                   
                     MOVE WS-OPTION-CD TO                               
                                  WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)
                     MOVE WS-RED-FLAG  TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
                     MOVE 'RPM022'     TO WS-RULE-NO(WS-ERR-MESS-INDX)  
                     MOVE 2            TO WS-ERR-MSG-RETURN-CD          
                     SET WS-ERR-MESS-INDX UP BY 1                       
                  END-IF                                                
      * CHECK THERE IS ANY CHANGE IN OPTN START DATE OR OPTN END DATE           
      * WHEN THE PROC STATUS IS NEW.                                            
                  IF WS-CHK-OPT-PRC-STAT-CD EQUAL WS-NEW                
                     PERFORM 7121-GET-OPT-END-DT  THRU 7121-EXIT        
                    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
                      IF WS-CHK-OPTION-END-DT NOT EQUAL FI-OPTION-END-DT
                         MOVE WS-CRM-PROC-REQ-ID TO                     
                                                  WS-COMMON-PROC-REQ-ID 
                         MOVE 0                  TO WS-ROW-COUNT        
                         PERFORM 7122-CHK-OFF-OPT-ROW-EXIST             
                                                  THRU 7122-EXIT        
                         IF WS-ROW-COUNT > 0                            
                            MOVE WS-ERR-HEAD-OPTION-DESC TO             
                                 WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX) 
                            MOVE WS-RED-FLAG  TO                        
                                 WS-RULE-FLAG(WS-ERR-MESS-INDX)         
                            MOVE 'RPM035'     TO                        
                                 WS-RULE-NO(WS-ERR-MESS-INDX)           
                            MOVE 2            TO WS-ERR-MSG-RETURN-CD   
                            SET WS-ERR-MESS-INDX UP BY 1                
                         END-IF                                         
                      END-IF                                            
                                                                        
                      IF WS-CHK-OPTION-START-DT NOT EQUAL               
                                                   FI-OPTION-START-DT   
                         MOVE WS-CRM-PROC-REQ-ID TO                     
                                                   WS-COMMON-PROC-REQ-ID
PRJ680                   MOVE 0                  TO WS-ROW-COUNT        
                         PERFORM 7122-CHK-OFF-OPT-ROW-EXIST             
                                                  THRU 7122-EXIT        
                         IF WS-ROW-COUNT > 0                            
                            MOVE WS-OPTION-CD TO                        
                                 WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX) 
                            MOVE WS-RED-FLAG  TO                        
                                 WS-RULE-FLAG(WS-ERR-MESS-INDX)         
                            MOVE 'RPM038'     TO                        
                                 WS-RULE-NO(WS-ERR-MESS-INDX)           
                            MOVE 2            TO WS-ERR-MSG-RETURN-CD   
                            SET WS-ERR-MESS-INDX UP BY 1                
                         END-IF                                         
                      END-IF                                            
                    END-IF                                              
                  END-IF                                                
                                                                        
             WHEN CRM-OPTION-UPDATE(WS-CRM-OPT-INDX)                    
      * CHECK THERE IS ANY CHANGE IN OPTN START DATE OR OPTN END DATE           
      * WHEN THE PROC STATUS IS NEW.                                            
                  IF WS-CHK-OPT-PRC-STAT-CD EQUAL WS-NEW                
                     PERFORM 7121-GET-OPT-END-DT  THRU 7121-EXIT        
                    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
                      IF WS-CHK-OPTION-END-DT NOT EQUAL FI-OPTION-END-DT
                        MOVE WS-CHK-OPT-PRC-REQ-ID                      
                                                TO WS-COMMON-PROC-REQ-ID
                        MOVE 0                  TO WS-ROW-COUNT         
                        PERFORM 7122-CHK-OFF-OPT-ROW-EXIST              
                                                  THRU 7122-EXIT        
                         IF WS-ROW-COUNT > 0                            
                            MOVE WS-ERR-HEAD-OPTION-DESC TO             
                                 WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX) 
                            MOVE WS-RED-FLAG  TO                        
                                 WS-RULE-FLAG(WS-ERR-MESS-INDX)         
                            MOVE 'RPM035'     TO                        
                                 WS-RULE-NO(WS-ERR-MESS-INDX)           
                            MOVE 2            TO WS-ERR-MSG-RETURN-CD   
                            SET WS-ERR-MESS-INDX UP BY 1                
                         END-IF                                         
                      END-IF                                            
                                                                        
                      IF WS-CHK-OPTION-START-DT NOT EQUAL               
                                                    FI-OPTION-START-DT  
                         MOVE WS-CHK-OPT-PRC-REQ-ID                     
                                                TO WS-COMMON-PROC-REQ-ID
                         PERFORM 7122-CHK-OFF-OPT-ROW-EXIST             
                                                  THRU 7122-EXIT        
                         IF WS-ROW-COUNT > 0                            
                            MOVE WS-OPTION-CD TO                        
                                 WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX) 
                            MOVE WS-RED-FLAG  TO                        
                                 WS-RULE-FLAG(WS-ERR-MESS-INDX)         
                            MOVE 'RPM038'     TO                        
                                 WS-RULE-NO(WS-ERR-MESS-INDX)           
                            MOVE 2            TO WS-ERR-MSG-RETURN-CD   
                            SET WS-ERR-MESS-INDX UP BY 1                
                         END-IF                                         
                      END-IF                                            
                    END-IF                                              
                  END-IF                                                
             WHEN CRM-OPTION-DELETE(WS-CRM-OPT-INDX)                    
                  IF WS-CHK-OPT-PRC-STAT-CD NOT EQUAL WS-NEW            
                     MOVE WS-ERR-HEAD-OPTION-DESC TO                    
                                  WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)
                     MOVE WS-RED-FLAG  TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
                     MOVE 'RPM029'     TO WS-RULE-NO(WS-ERR-MESS-INDX)  
                     MOVE 2            TO WS-ERR-MSG-RETURN-CD          
                     SET WS-ERR-MESS-INDX UP BY 1                       
                  END-IF                                                
      * SHOULD NOT ALLOW TO DELETE AN OPTION THAT ATTACHED WIT OTHER OFF        
                  IF WS-CHK-OPT-PRC-STAT-CD EQUAL WS-NEW                
                     PERFORM 7124-GET-OTHER-OFF-FOR-OPT  THRU 7124-EXIT 
                     IF WS-ATTCHD-WITH-OTHR-OFF EQUAL WS-YES            
                        MOVE WS-OPTION-CD TO                            
                                  WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)
                        MOVE WS-RED-FLAG  TO                            
                                  WS-RULE-FLAG(WS-ERR-MESS-INDX)        
                        MOVE 'RPM039' TO WS-RULE-NO(WS-ERR-MESS-INDX)   
                        MOVE 2            TO WS-ERR-MSG-RETURN-CD       
                        SET WS-ERR-MESS-INDX UP BY 1                    
                     END-IF                                             
                  END-IF                                                
           END-EVALUATE.                                                
                                                                        
       6120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * VALIDATION FOR OFF.OPT INSERT / DELETE - CRM_OFFER_OPTION.   *          
      *                                                              *          
      ****************************************************************          
       6122-VLDT-FOR-OFF-OPT.                                           
                                                                        
           MOVE WS-NO                  TO WS-ROW-EXIST.                 
           MOVE WS-CHK-OPTION-CD       TO E9-OPTION-CD.                 
           MOVE WS-CHK-OFFER-CD        TO E9-OFFER-CD.                  
                                                                        
      * When we try to approve the option that created                          
      * Through other offer, it should return an error message.                 
           IF CALL-FRM-STATUS-UPDT                                      
             IF WS-CHK-OFF-OPT-PRC-STAT-CD NOT EQUAL WS-NEW             
                PERFORM 7116-GET-MAX-PROC-REQ-ID THRU 7116-EXIT         
                IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                 IF FI-PROC-REQ-ID NOT EQUAL WS-CHK-OPT-PRC-REQ-ID      
                  IF (FI-PROC-STATUS-CD        EQUAL WS-NEW          AND
                   (WS-CHK-OFF-OPT-PRC-STAT-CD EQUAL WS-PEND-APPROVAL OR
                   WS-CHK-OFF-OPT-PRC-STAT-CD EQUAL WS-EARLY-APPROVAL OR
                   WS-CHK-OFF-OPT-PRC-STAT-CD EQUAL WS-APPROVED))       
                     OR                                                 
                   (FI-PROC-STATUS-CD         EQUAL WS-PEND-APPROVAL AND
                  (WS-CHK-OFF-OPT-PRC-STAT-CD EQUAL WS-EARLY-APPROVAL OR
                   WS-CHK-OFF-OPT-PRC-STAT-CD EQUAL WS-APPROVED))       
                     OR                                                 
                    (FI-PROC-STATUS-CD       EQUAL WS-EARLY-APPROVAL AND
                     WS-CHK-OFF-OPT-PRC-STAT-CD EQUAL WS-APPROVED)      
                                                                        
                     MOVE E9-OPTION-CD TO                               
                                  WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)
                     MOVE 'RPM037'     TO WS-RULE-NO(WS-ERR-MESS-INDX)  
                     MOVE WS-RED-FLAG  TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
                     MOVE 2            TO WS-ERR-MSG-RETURN-CD          
                     SET WS-ERR-MESS-INDX UP BY 1                       
                  END-IF                                                
                 END-IF                                                 
                END-IF                                                  
             ELSE                                                       
      * When we try to reject the offer and if the option(created under         
      * same offer) are attached wih other offer, it should return              
      * warning message.                                                        
                PERFORM 7117-CHK-OFF-OPT-STATUS THRU 7117-EXIT          
                IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                   IF WS-OPT-ATTCHD-WTH-OTHR-OFF EQUAL WS-YES           
                      MOVE FI-OPTION-CD   TO                            
                                  WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)
                      MOVE 'RPM040'     TO WS-RULE-NO(WS-ERR-MESS-INDX) 
                      MOVE WS-YELLOW-FLAG TO                            
                                          WS-RULE-FLAG(WS-ERR-MESS-INDX)
                      IF WS-ERR-MSG-RETURN-CD <= 1                      
                         MOVE 1           TO WS-ERR-MSG-RETURN-CD       
                      END-IF                                            
                      SET WS-ERR-MESS-INDX UP BY 1                      
                   END-IF                                               
                END-IF                                                  
             END-IF                                                     
           END-IF.                                                      
                                                                        
           EVALUATE TRUE                                                
             WHEN CRM-OFFER-OPT-INSERT(WS-CRM-OPT-INDX)                 
                  MOVE WS-APPROVED     TO WS-PROC-STATUS-CD             
                  MOVE E9-OPTION-CD    TO WS-OPTION-CD                  
                  MOVE E9-OFFER-CD     TO WS-OFFER-CD                   
                  PERFORM 7123-CHK-OFF-OPT-ROW-EXIST                    
                                          THRU 7123-EXIT                
                  MOVE WS-ROW-EXIST    TO WS-OFF-OPT-ROW-EXIST          
                  IF WS-OFF-OPT-ROW-EXIST EQUAL WS-YES                  
                     MOVE WS-ERR-HEAD-OFF-OPT-DESC TO                   
                                  WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)
                     MOVE WS-RED-FLAG  TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
                     MOVE 'RPM033'     TO WS-RULE-NO(WS-ERR-MESS-INDX)  
                     MOVE 2            TO WS-ERR-MSG-RETURN-CD          
                     SET WS-ERR-MESS-INDX UP BY 1                       
                  END-IF                                                
             WHEN CRM-OFFER-OPT-DELETE(WS-CRM-OPT-INDX) AND             
                  WS-CHK-OFF-OPT-PRC-STAT-CD NOT EQUAL WS-NEW           
                     MOVE WS-ERR-HEAD-OFF-OPT-DESC TO                   
                                  WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)
                     MOVE WS-RED-FLAG  TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
                     MOVE 'RPM034'     TO WS-RULE-NO(WS-ERR-MESS-INDX)  
                     MOVE 2            TO WS-ERR-MSG-RETURN-CD          
                     SET WS-ERR-MESS-INDX UP BY 1                       
           END-EVALUATE.                                                
                                                                        
       6122-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * VALIDATION FOR CRM_OPT_ATTR_INCTV TABLE.                     *          
      *                                                              *          
      ****************************************************************          
       6125-VLDT-FOR-ATTR-INCTV.                                        
                                                                        
           MOVE WS-NO                     TO WS-ROW-EXIST.              
           MOVE WS-CHK-OPTION-CD          TO HQ-OPTION-CD               
                                             WS-OPTN1-CD.               
           MOVE WS-CHK-ATTR-INCTV-SEQ-NO  TO HQ-ATTR-INCTV-SEQ-NO.      
           MOVE WS-CHK-RT-ATTR-INCTV-TYPE TO WS-RT-ATTR-INCTV-TYPE.     
                                                                        
           EVALUATE TRUE                                                
           WHEN CRM-OPT-ATTRB-INSERT(WS-CRM-OPT-INDX,WS-CRM-ATTRB-INDX) 
                MOVE WS-APPROVED       TO WS-PROC-STATUS-CD             
                PERFORM 7125-CHK-OPT-ATTR-ROW-EXIST THRU 7125-EXIT      
                MOVE WS-ROW-EXIST      TO WS-OPT-ATTR-INCTV-ROW-EXIST   
             IF WS-OPT-ATTR-INCTV-ROW-EXIST  EQUAL WS-YES               
                PERFORM VARYING WS-DUMMY-ATTR-INCTV-INDX FROM 1 BY 1    
                UNTIL WS-DUMMY-ATTR-INCTV-INDX = WS-CRM-ATTRB-INDX      
                                              OR WS-DELETE-ROW-FOUND    
      *****************************************************************         
      *    IF THE STRING COMES WITH DELETE AND INSERT FOR THE EXITING *         
      *    ENtry THEN SYSTEM SHOULD NOT THROW ERROR.                  *         
      *****************************************************************         
                  IF CRM-OPT-ATTRB-DELETE                               
                              (WS-CRM-OPT-INDX,WS-DUMMY-ATTR-INCTV-INDX)
                     AND WS-CRM-OPTION-CD-HQ                            
                              (WS-CRM-OPT-INDX,WS-CRM-ATTRB-INDX) EQUAL 
                         WS-CRM-OPTION-CD-HQ                            
                              (WS-CRM-OPT-INDX,WS-DUMMY-ATTR-INCTV-INDX)
                     AND WS-CRM-ATTR-INCTV-SEQ-NO-HQ                    
                              (WS-CRM-OPT-INDX,WS-CRM-ATTRB-INDX) EQUAL 
                         WS-CRM-ATTR-INCTV-SEQ-NO-HQ                    
                              (WS-CRM-OPT-INDX,WS-DUMMY-ATTR-INCTV-INDX)
                     MOVE WS-YES          TO WS-DELETE-ROW-FOUND        
                  ELSE                                                  
                     MOVE WS-NO           TO WS-DELETE-ROW-FOUND        
                  END-IF                                                
                END-PERFORM                                             
                                                                        
                IF DELETE-ROW-NOT-FOUND                                 
                   MOVE WS-ERR-HEAD-OPT-ATTR-INCTV                      
                               TO WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)
                   MOVE WS-RED-FLAG  TO WS-RULE-FLAG(WS-ERR-MESS-INDX)  
                   MOVE 'RPM023'     TO WS-RULE-NO(WS-ERR-MESS-INDX)    
                   MOVE 2            TO WS-ERR-MSG-RETURN-CD            
                   SET WS-ERR-MESS-INDX UP BY 1                         
                   MOVE WS-NO        TO WS-DELETE-ROW-FOUND             
                END-IF                                                  
             END-IF                                                     
                                                                        
           WHEN CRM-OPT-ATTRB-DELETE(WS-CRM-OPT-INDX,WS-CRM-ATTRB-INDX) 
                AND WS-CHK-OPT-ATRB-PRC-STAT-CD NOT EQUAL WS-NEW        
                   MOVE WS-ERR-HEAD-OPT-ATTR-INCTV TO                   
                                 WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX) 
                   MOVE WS-RED-FLAG  TO WS-RULE-FLAG(WS-ERR-MESS-INDX)  
                   MOVE 'RPM028'     TO WS-RULE-NO(WS-ERR-MESS-INDX)    
                   MOVE 2            TO WS-ERR-MSG-RETURN-CD            
                   SET WS-ERR-MESS-INDX UP BY 1                         
           END-EVALUATE.                                                
                                                                        
       6125-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * VALIDATION FOR CRM_ACCESS_OFF_OPT TABLE.                     *          
      *                                                              *          
      ****************************************************************          
       6130-VLDT-FOR-OPT-ACCESS.                                        
                                                                        
           MOVE WS-NO                       TO WS-ROW-EXIST.            
           MOVE WS-CHK-OPTN-OPTION          TO CI-OPTION-CD             
                                               WS-OPTION-CD.            
           MOVE WS-CHK-OPTN-CATEGORY-ID     TO CI-CATEGORY-ID.          
                                                                        
           EVALUATE TRUE                                                
              WHEN CRM-OPTN-ACCS-INSERT(WS-CRM-OPT-INDX                 
                                         ,WS-CRM-OPTN-ACCS-INDX)        
                   MOVE WS-APPROVED    TO WS-PROC-STATUS-CD             
                   PERFORM 7130-CHK-OPT-ACCESS-ROW  THRU 7130-EXIT      
                   MOVE WS-ROW-EXIST   TO WS-OPT-ACCESS-ROW-EXIST       
                   IF WS-OPT-ACCESS-ROW-EXIST EQUAL WS-YES              
                      MOVE WS-OPTION-CD TO                              
                                  WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)
                      MOVE WS-RED-FLAG TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
                      MOVE 'RPM024'    TO WS-RULE-NO(WS-ERR-MESS-INDX)  
                      MOVE 2           TO WS-ERR-MSG-RETURN-CD          
                      SET WS-ERR-MESS-INDX UP BY 1                      
                   END-IF                                               
              WHEN CRM-OPTN-ACCS-DELETE(WS-CRM-OPT-INDX                 
                                         ,WS-CRM-OPTN-ACCS-INDX)        
                   AND WS-CHK-OPT-ACS-PRC-STAT-CD NOT EQUAL WS-NEW      
                      MOVE WS-ERR-HEAD-OPTION-DESC TO                   
                                  WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)
                      MOVE WS-RED-FLAG TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
                      MOVE 'RPM030'    TO WS-RULE-NO(WS-ERR-MESS-INDX)  
                      MOVE 2           TO WS-ERR-MSG-RETURN-CD          
                      SET WS-ERR-MESS-INDX UP BY 1                      
           END-EVALUATE.                                                
                                                                        
       6130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * VALIDATION FOR CRM_MKT_PROMOTION TABLE.                     *           
      *                                                             *           
      ***************************************************************           
       6135-VLDT-FOR-MKT-PROMO.                                         
                                                                        
           MOVE WS-NO                  TO WS-ROW-EXIST.                 
           MOVE WS-CHK-PROMO-CD        TO KM-PROMO-CD                   
                                          WS-PROMO-CD.                  
                                                                        
           EVALUATE TRUE                                                
              WHEN CRM-PROMO-INSERT(WS-CRM-PROMO-INDX)                  
                   MOVE WS-APPROVED    TO WS-PROC-STATUS-CD             
                   PERFORM 7135-CHK-MKT-PROMO-ROW-EXIST  THRU 7135-EXIT 
                   MOVE WS-ROW-EXIST   TO WS-MKT-PROMO-ROW-EXIST        
                   IF WS-MKT-PROMO-ROW-EXIST EQUAL WS-YES               
                      MOVE WS-PROMO-CD TO                               
                                  WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)
                      MOVE WS-RED-FLAG TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
                      MOVE 'RPM025'    TO WS-RULE-NO(WS-ERR-MESS-INDX)  
                      MOVE 2           TO WS-ERR-MSG-RETURN-CD          
                      SET WS-ERR-MESS-INDX UP BY 1                      
                   END-IF                                               
              WHEN CRM-PROMO-DELETE(WS-CRM-PROMO-INDX) AND              
                   WS-CHK-PROMO-PRC-STAT-CD NOT EQUAL WS-NEW            
                      MOVE WS-ERR-HEAD-PROMO-DESC TO                    
                                  WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)
                      MOVE WS-RED-FLAG TO WS-RULE-FLAG(WS-ERR-MESS-INDX)
                      MOVE 'RPM032'    TO WS-RULE-NO(WS-ERR-MESS-INDX)  
                      MOVE 2           TO WS-ERR-MSG-RETURN-CD          
                      SET WS-ERR-MESS-INDX UP BY 1                      
           END-EVALUATE.                                                
                                                                        
       6135-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * VALIDATION FOR CRM_MKT_PROMOTION TABLE. (TEMPLATE OFFER)    *           
      *                                                             *           
      ***************************************************************           
       6136-VLDT-FOR-MKT-PROMO.                                         
                                                                        
            PERFORM 7136-CHK-PROMO-REUSED   THRU 7136-EXIT              
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
              IF WS-CHK-OFFER-CD NOT EQUAL WS-PROMO-OFFER-CD AND        
                 WS-CHK-PROMO-VRSN-NO  <= KM-PROMO-VRSN-NO              
                 MOVE WS-CHK-PROMO-CD   TO WS-HEADER-PROMO-CD           
                 MOVE WS-PROMO-OFFER-CD TO WS-HEADER-PROMO-OFF-CD       
                 MOVE WS-ERR-HEAD-MKT-PROMOTION TO                      
                                 WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX) 
                 MOVE WS-RED-FLAG   TO WS-RULE-FLAG(WS-ERR-MESS-INDX)   
                 MOVE 'RPM042'       TO WS-RULE-NO(WS-ERR-MESS-INDX)    
                 MOVE 2  TO WS-ERR-MSG-RETURN-CD                        
                 SET WS-ERR-MESS-INDX UP BY 1                           
              END-IF                                                    
            END-IF.                                                     
                                                                        
       6136-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
PRJ680* 7000-CHK-OFF-CD-ACTV-STAT.                                   *          
      *                                                              *          
      ****************************************************************          
PRJ680 7000-CHK-OFF-CD-ACTV-STAT.                                       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y',
              FG.OFFER_DESC_INT                                 
      *          INTO :WS-RNWL-OFF-CD-VALID                                     
                 INTO :WS-OFFER-CD-VALID                                
                     ,:FG-OFFER-DESC-INT                                
                 FROM CRM_RT_PKG_OFFER  FG WITH(READUNCOMMITTED)                
                WHERE FG.COMPANY_NO         = :WS-COMPANY-NO            
                  AND FG.OFFER_CD           = :FG-OFFER-CD              
                  AND FG.OFFER_START_DT    <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )            
                  AND FG.OFFER_END_DT      >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )            
                  AND FG.OFF_VSTART_TS     <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )       
                  AND FG.OFF_VEND_TS       >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )       
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*              ,FG.OFFER_DESC_INT                                         
MFA-TR*          INTO :WS-RNWL-OFF-CD-VALID                                     
MFA-TR*          INTO :WS-OFFER-CD-VALID                                        
MFA-TR*              ,:FG-OFFER-DESC-INT                                        
MFA-TR*          FROM CRM_RT_PKG_OFFER  FG                                      
MFA-TR*         WHERE FG.COMPANY_NO         = :WS-COMPANY-NO                    
MFA-TR*           AND FG.OFFER_CD           = :FG-OFFER-CD                      
MFA-TR*           AND FG.OFFER_START_DT    <= :WS-CHECK-DATE                    
MFA-TR*           AND FG.OFFER_END_DT      >= :WS-CHECK-DATE                    
MFA-TR*           AND FG.OFF_VSTART_TS     <= :WS-CHECK-TIMESTAMP               
MFA-TR*           AND FG.OFF_VEND_TS       >= :WS-CHECK-TIMESTAMP               
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'DU_OFFER_CD'             TO TABLE-ELEMENT-2         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FG-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7001-GET-MKT-TIER-STAT-DT.                                     *        
      *                                                                *        
      ******************************************************************        
       7001-GET-MKT-TIER-STAT-DT.                                       
                                                                        
           EXEC SQL                                                     
               SELECT MAX(IG.MKT_TIER_START_DT)                         
                 INTO :IG-MKT-TIER-START-DT                             
                 FROM CRM_MKT_TIER IG WITH(READUNCOMMITTED)                     
                WHERE IG.COMPANY_NO         = :IG-COMPANY-NO            
                  AND IG.TIER_CUST_STAT_CD  = :IG-TIER-CUST-STAT-CD     
                  AND IG.TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD     
                  AND IG.MKT_TIER_RANKING   = :IG-MKT-TIER-RANKING      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(IG.MKT_TIER_START_DT)                                 
MFA-TR*          INTO :IG-MKT-TIER-START-DT                                     
MFA-TR*          FROM CRM_MKT_TIER IG                                           
MFA-TR*         WHERE IG.COMPANY_NO         = :IG-COMPANY-NO                    
MFA-TR*           AND IG.TIER_CUST_STAT_CD  = :IG-TIER-CUST-STAT-CD             
MFA-TR*           AND IG.TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD             
MFA-TR*           AND IG.MKT_TIER_RANKING   = :IG-MKT-TIER-RANKING              
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7001                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7001'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_MKT_TIER'            TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'DU_OFFER_CD'             TO TABLE-ELEMENT-2         
              MOVE 'DU_OFFER_CD'             TO TABLE-ELEMENT-3         
              MOVE IG-TIER-CUST-STAT-CD      TO HOSTVAR-ELEMENT-1       
              MOVE IG-TIER-ACCT-TYPE-CD      TO HOSTVAR-ELEMENT-2       
              MOVE IG-MKT-TIER-RANKING       TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7001-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7002-VLDT-RENEWAL-OFF-CD.                                      *        
      *                                                                *        
      ******************************************************************        
       7002-VLDT-RENEWAL-OFF-CD.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y',
              FG.OFFER_CD,
              FI.OPTION_CD,
              FI.OPT_CALC_TYPE_CD,
              FG.OFFER_DESC_INT                                 
                 INTO :WS-OPTION-IS-VP                                  
                     ,:FG-OFFER-CD                                      
                     ,:FI-OPTION-CD                                     
                     ,:FI-OPT-CALC-TYPE-CD                              
                     ,:FG-OFFER-DESC-INT                                
                 FROM CRM_RT_PKG_OFFER  FG WITH(READUNCOMMITTED)                
                     ,CRM_OFFER_OPTION  E9 WITH(READUNCOMMITTED)                
                     ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
                WHERE FG.COMPANY_NO           = :WS-COMPANY-NO          
                  AND FG.OFFER_START_DT      <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND FG.OFFER_END_DT        >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND FG.OFF_VSTART_TS       <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
                  AND FG.OFF_VEND_TS         >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
                  AND E9.OFFER_OPT_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND E9.OFFER_OPT_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND FG.OFFER_CD             = :FG-RENEWAL-OFFER-CD    
                  AND E9.COMPANY_NO           = FG.COMPANY_NO           
                  AND E9.OFFER_CD             = FG.OFFER_CD             
                  AND E9.OFF_OPT_VSTART_TS   <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
                  AND E9.OFF_OPT_VEND_TS     >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
                  AND E9.OPTION_SORT_SEQ_NO  IN  (                      
                    SELECT  MAX(ZZ.OPTION_SORT_SEQ_NO)                  
                      FROM CRM_OFFER_OPTION  ZZ WITH(READUNCOMMITTED)           
                     WHERE ZZ.COMPANY_NO          = FG.COMPANY_NO       
                       AND ZZ.OFFER_CD            = :FG-RENEWAL-OFFER-CD
                       AND ZZ.OFF_OPT_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              ) 
                       AND ZZ.OFF_OPT_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              ) 
                       AND ZZ.OFFER_OPT_START_DT <= 
              IIF(TRY_CONVERT(DATE, :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )      
                       AND ZZ.OFFER_OPT_END_DT   >= 
              IIF(TRY_CONVERT(DATE, :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) ) )    
                  AND FI.COMPANY_NO           = E9.COMPANY_NO           
                  AND FI.OPTION_CD            = E9.OPTION_CD            
                  AND FI.CODE_UTIL_TYPE       = 'G'                     
                  AND FI.OPTION_START_DT     <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND FI.OPTION_END_DT       >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )          
                  AND FI.OPT_CALC_TYPE_CD     = 'VP'                    
                  AND FI.OPT_VSTART_TS       <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
                  AND FI.OPT_VEND_TS         >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )     
                ORDER BY FG.RENEWAL_OFFER_CD                            
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*              ,FG.OFFER_CD                                               
MFA-TR*              ,FI.OPTION_CD                                              
MFA-TR*              ,FI.OPT_CALC_TYPE_CD                                       
MFA-TR*              ,FG.OFFER_DESC_INT                                         
MFA-TR*          INTO :WS-OPTION-IS-VP                                          
MFA-TR*              ,:FG-OFFER-CD                                              
MFA-TR*              ,:FI-OPTION-CD                                             
MFA-TR*              ,:FI-OPT-CALC-TYPE-CD                                      
MFA-TR*              ,:FG-OFFER-DESC-INT                                        
MFA-TR*          FROM CRM_RT_PKG_OFFER  FG                                      
MFA-TR*              ,CRM_OFFER_OPTION  E9                                      
MFA-TR*              ,CRM_RT_PKG_OPTION FI                                      
MFA-TR*         WHERE FG.COMPANY_NO           = :WS-COMPANY-NO                  
MFA-TR*           AND FG.OFFER_START_DT      <= :WS-CHECK-DATE                  
MFA-TR*           AND FG.OFFER_END_DT        >= :WS-CHECK-DATE                  
MFA-TR*           AND FG.OFF_VSTART_TS       <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND FG.OFF_VEND_TS         >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND E9.OFFER_OPT_START_DT  <= :WS-CHECK-DATE                  
MFA-TR*           AND E9.OFFER_OPT_END_DT    >= :WS-CHECK-DATE                  
MFA-TR*           AND FG.OFFER_CD             = :FG-RENEWAL-OFFER-CD            
MFA-TR*           AND E9.COMPANY_NO           = FG.COMPANY_NO                   
MFA-TR*           AND E9.OFFER_CD             = FG.OFFER_CD                     
MFA-TR*           AND E9.OFF_OPT_VSTART_TS   <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND E9.OFF_OPT_VEND_TS     >= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND E9.OPTION_SORT_SEQ_NO  IN  (                              
MFA-TR*             SELECT  MAX(ZZ.OPTION_SORT_SEQ_NO)                          
MFA-TR*               FROM CRM_OFFER_OPTION  ZZ                                 
MFA-TR*              WHERE ZZ.COMPANY_NO          = FG.COMPANY_NO               
MFA-TR*                AND ZZ.OFFER_CD            = :FG-RENEWAL-OFFER-CD        
MFA-TR*                AND ZZ.OFF_OPT_VSTART_TS  <= :WS-CHECK-TIMESTAMP         
MFA-TR*                AND ZZ.OFF_OPT_VEND_TS    >= :WS-CHECK-TIMESTAMP         
MFA-TR*                AND ZZ.OFFER_OPT_START_DT <= :WS-CHECK-DATE              
MFA-TR*                AND ZZ.OFFER_OPT_END_DT   >= :WS-CHECK-DATE )            
MFA-TR*           AND FI.COMPANY_NO           = E9.COMPANY_NO                   
MFA-TR*           AND FI.OPTION_CD            = E9.OPTION_CD                    
MFA-TR*           AND FI.CODE_UTIL_TYPE       = 'G'                             
MFA-TR*           AND FI.OPTION_START_DT     <= :WS-CHECK-DATE                  
MFA-TR*           AND FI.OPTION_END_DT       >= :WS-CHECK-DATE                  
MFA-TR*           AND FI.OPT_CALC_TYPE_CD     = 'VP'                            
MFA-TR*           AND FI.OPT_VSTART_TS       <= :WS-CHECK-TIMESTAMP             
MFA-TR*           AND FI.OPT_VEND_TS         >= :WS-CHECK-TIMESTAMP             
MFA-TR*         ORDER BY FG.RENEWAL_OFFER_CD                                    
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_RT_PKG_OFFER'       TO TABLE-1                  
              MOVE 'RENEWAL_OFFER_CD'       TO TABLE-ELEMENT-1          
              MOVE FG-RENEWAL-OFFER-Cd      TO HOSTVAR-ELEMENT-1        
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7002-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  7003-VLDT-DEFLT-OFF-CD.                                      *         
      *                                                               *         
      *****************************************************************         
       7003-VLDT-DEFLT-OFF-CD.                                          
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y',
              DU.OFFER_CD                                       
                 INTO :WS-ALREADY-DFLT-OFF-EXIST                        
                     ,:DU-OFFER-CD                                      
                 FROM CRM_OFF_MKT_TIER DU WITH(READUNCOMMITTED)                 
                WHERE DU.COMPANY_NO          = :WS-COMPANY-NO           
                  AND DU.TIER_CUST_STAT_CD   = :DU-TIER-CUST-STAT-CD    
                  AND DU.TIER_ACCT_TYPE_CD   = :DU-TIER-ACCT-TYPE-CD    
                  AND DU.MKT_TIER_RANKING    = :DU-MKT-TIER-RANKING     
                  AND DU.MKT_TIER_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
                  AND DU.OFFER_TIER_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
                  AND DU.OFFER_TIER_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
                  AND DU.TIER_DEFLT_OFFR_CD  = :DU-TIER-DEFLT-OFFR-CD   
                  AND DU.OFF_TIER_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
                  AND DU.OFF_TIER_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
                  AND DU.PROC_STATUS_CD      = :WS-PROC-STATUS-CD       
               ORDER BY DU.TIER_DEFLT_OFFR_CD DESC                      
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*              ,DU.OFFER_CD                                               
MFA-TR*          INTO :WS-ALREADY-DFLT-OFF-EXIST                                
MFA-TR*              ,:DU-OFFER-CD                                              
MFA-TR*          FROM CRM_OFF_MKT_TIER DU                                       
MFA-TR*         WHERE DU.COMPANY_NO          = :WS-COMPANY-NO                   
MFA-TR*           AND DU.TIER_CUST_STAT_CD   = :DU-TIER-CUST-STAT-CD            
MFA-TR*           AND DU.TIER_ACCT_TYPE_CD   = :DU-TIER-ACCT-TYPE-CD            
MFA-TR*           AND DU.MKT_TIER_RANKING    = :DU-MKT-TIER-RANKING             
MFA-TR*           AND DU.MKT_TIER_START_DT  <= :WS-CHECK-DATE                   
MFA-TR*           AND DU.OFFER_TIER_STRT_DT <= :WS-CHECK-DATE                   
MFA-TR*           AND DU.OFFER_TIER_END_DT  >= :WS-CHECK-DATE                   
MFA-TR*           AND DU.TIER_DEFLT_OFFR_CD  = :DU-TIER-DEFLT-OFFR-CD           
MFA-TR*           AND DU.OFF_TIER_VSTART_TS <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND DU.OFF_TIER_VEND_TS   >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND DU.PROC_STATUS_CD      = :WS-PROC-STATUS-CD               
MFA-TR*        ORDER BY DU.TIER_DEFLT_OFFR_CD DESC                              
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*     QUERYNO 7003                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7003'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_OFF_MKT_TIER'       TO TABLE-1                  
              MOVE 'TIER_CUST_STAT_CD'      TO TABLE-ELEMENT-1          
              MOVE 'TIER_ACCT_TYPE_CD'      TO TABLE-ELEMENT-2          
              MOVE 'MKT_TIER_RANKING'       TO TABLE-ELEMENT-3          
              MOVE DU-TIER-CUST-STAT-CD     TO HOSTVAR-ELEMENT-1        
              MOVE DU-TIER-ACCT-TYPE-CD     TO HOSTVAR-ELEMENT-1        
              MOVE DU-MKT-TIER-RANKING      TO HOSTVAR-ELEMENT-1        
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7003-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7004-VLDT-OFF-MKT-TIER.                                       *         
      *                                                               *         
      *****************************************************************         
       7004-VLDT-OFF-MKT-TIER.                                          
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-ACTIVE-ROW-COUNT                               
                FROM CRM_OFF_MKT_TIER DU WITH(READUNCOMMITTED)                  
               WHERE DU.COMPANY_NO          = :WS-COMPANY-NO            
                 AND DU.TIER_CUST_STAT_CD   = :DU-TIER-CUST-STAT-CD     
                 AND DU.TIER_ACCT_TYPE_CD   = :DU-TIER-ACCT-TYPE-CD     
                 AND DU.MKT_TIER_RANKING    = :DU-MKT-TIER-RANKING      
                 AND DU.OFFER_CD            = :DU-OFFER-CD              
                 AND DU.MKT_TIER_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )            
                 AND DU.OFFER_TIER_STRT_DT <> IIF(TRY_CONVERT(DATE, 
                                             :WS-CHK-OFFER-TIER-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CHK-OFFER-TIER-STRT-DT
              ) <> 0) OR (LEN(:WS-CHK-OFFER-TIER-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:WS-CHK-OFFER-TIER-STRT-DT
              ), CONVERT(DATE, :WS-CHK-OFFER-TIER-STRT-DT) )
                 AND DU.OFFER_TIER_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )            
                 AND DU.OFFER_TIER_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )            
                 AND DU.OFF_TIER_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )       
                 AND DU.OFF_TIER_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )       
                 AND DU.PROC_STATUS_CD      = :WS-PROC-STATUS-CD        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-ACTIVE-ROW-COUNT                                       
MFA-TR*         FROM CRM_OFF_MKT_TIER DU                                        
MFA-TR*        WHERE DU.COMPANY_NO          = :WS-COMPANY-NO                    
MFA-TR*          AND DU.TIER_CUST_STAT_CD   = :DU-TIER-CUST-STAT-CD             
MFA-TR*          AND DU.TIER_ACCT_TYPE_CD   = :DU-TIER-ACCT-TYPE-CD             
MFA-TR*          AND DU.MKT_TIER_RANKING    = :DU-MKT-TIER-RANKING              
MFA-TR*          AND DU.OFFER_CD            = :DU-OFFER-CD                      
MFA-TR*          AND DU.MKT_TIER_START_DT  <= :WS-CHECK-DATE                    
MFA-TR*          AND DU.OFFER_TIER_STRT_DT <> :WS-CHK-OFFER-TIER-STRT-DT        
MFA-TR*          AND DU.OFFER_TIER_STRT_DT <= :WS-CHECK-DATE                    
MFA-TR*          AND DU.OFFER_TIER_END_DT  >= :WS-CHECK-DATE                    
MFA-TR*          AND DU.OFF_TIER_VSTART_TS <= :WS-CHECK-TIMESTAMP               
MFA-TR*          AND DU.OFF_TIER_VEND_TS   >= :WS-CHECK-TIMESTAMP               
MFA-TR*          AND DU.PROC_STATUS_CD      = :WS-PROC-STATUS-CD                
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7004                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7004'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_OFF_MKT_TIER'       TO TABLE-1                  
              MOVE 'TIER_CUST_STAT_CD'      TO TABLE-ELEMENT-1          
              MOVE 'TIER_ACCT_TYPE_CD'      TO TABLE-ELEMENT-2          
              MOVE 'MKT_TIER_RANKING'       TO TABLE-ELEMENT-3          
              MOVE DU-TIER-CUST-STAT-CD     TO HOSTVAR-ELEMENT-1        
              MOVE DU-TIER-ACCT-TYPE-CD     TO HOSTVAR-ELEMENT-1        
              MOVE DU-MKT-TIER-RANKING      TO HOSTVAR-ELEMENT-1        
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7004-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7005-VLDT-OFF-MKT-TIER.                                       *         
      *                                                               *         
      *****************************************************************         
       7005-VLDT-OFF-MKT-TIER.                                          
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-CUST-STAT-ACCT-TYPE-VALID                     
                 FROM CRM_OFF_MKT_TIER  DU
                           WITH(READUNCOMMITTED)  LEFT JOIN                   
                      CRM_MKT_TIER      IG WITH(READUNCOMMITTED)                
                   ON (IG.COMPANY_NO        =  DU.COMPANY_NO            
                  AND IG.TIER_CUST_STAT_CD  =  DU.TIER_CUST_STAT_CD     
                  AND IG.TIER_ACCT_TYPE_CD  =  DU.TIER_ACCT_TYPE_CD     
                  AND IG.MKT_TIER_RANKING   =  DU.MKT_TIER_RANKING      
                  AND IG.MKT_TIER_START_DT  =  DU.MKT_TIER_START_DT     
                  AND IG.MKT_TIER_START_DT <=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
                  AND IG.MKT_TIER_END_DT   >=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) ) )         
                WHERE DU.COMPANY_NO          = :WS-COMPANY-NO           
                  AND DU.MKT_TIER_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
                  AND DU.OFFER_TIER_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
                  AND DU.OFFER_TIER_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
                  AND DU.TIER_DEFLT_OFFR_CD  = 'Y'                      
                  AND DU.OFF_TIER_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
                  AND DU.OFF_TIER_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
                  AND DU.PROC_STATUS_CD      = 'AC'                     
                  AND DU.TIER_CUST_STAT_CD   = :DU-TIER-CUST-STAT-CD    
                  AND DU.TIER_ACCT_TYPE_CD   = :DU-TIER-ACCT-TYPE-CD    
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-CUST-STAT-ACCT-TYPE-VALID                             
MFA-TR*          FROM CRM_OFF_MKT_TIER  DU  LEFT JOIN                           
MFA-TR*               CRM_MKT_TIER      IG                                      
MFA-TR*            ON (IG.COMPANY_NO        =  DU.COMPANY_NO                    
MFA-TR*           AND IG.TIER_CUST_STAT_CD  =  DU.TIER_CUST_STAT_CD             
MFA-TR*           AND IG.TIER_ACCT_TYPE_CD  =  DU.TIER_ACCT_TYPE_CD             
MFA-TR*           AND IG.MKT_TIER_RANKING   =  DU.MKT_TIER_RANKING              
MFA-TR*           AND IG.MKT_TIER_START_DT  =  DU.MKT_TIER_START_DT             
MFA-TR*           AND IG.MKT_TIER_START_DT <=  :WS-CHECK-DATE                   
MFA-TR*           AND IG.MKT_TIER_END_DT   >=  :WS-CHECK-DATE )                 
MFA-TR*         WHERE DU.COMPANY_NO          = :WS-COMPANY-NO                   
MFA-TR*           AND DU.MKT_TIER_START_DT  <= :WS-CHECK-DATE                   
MFA-TR*           AND DU.OFFER_TIER_STRT_DT <= :WS-CHECK-DATE                   
MFA-TR*           AND DU.OFFER_TIER_END_DT  >= :WS-CHECK-DATE                   
MFA-TR*           AND DU.TIER_DEFLT_OFFR_CD  = 'Y'                              
MFA-TR*           AND DU.OFF_TIER_VSTART_TS <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND DU.OFF_TIER_VEND_TS   >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND DU.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND DU.TIER_CUST_STAT_CD   = :DU-TIER-CUST-STAT-CD            
MFA-TR*           AND DU.TIER_ACCT_TYPE_CD   = :DU-TIER-ACCT-TYPE-CD            
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*    QUERYNO 7005                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7005'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_OFF_MKT_TIER'       TO TABLE-1                  
              MOVE 'TIER_CUST_STAT_CD'      TO TABLE-ELEMENT-1          
              MOVE 'TIER_ACCT_TYPE_CD'      TO TABLE-ELEMENT-2          
              MOVE DU-TIER-CUST-STAT-CD     TO HOSTVAR-ELEMENT-1        
              MOVE DU-TIER-ACCT-TYPE-CD     TO HOSTVAR-ELEMENT-1        
              PERFORM 9910-SQL-ERROR           THRU 9910-EXIT           
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7006-VLDT-OPTION-CD                                            *        
      *                                                                *        
      ******************************************************************        
       7006-VLDT-OPTION-CD.                                             
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-PRIM-ATTR-COUNT                                
                FROM CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)               
               WHERE HQ.COMPANY_NO          = :WS-COMPANY-NO            
                 AND HQ.OPTION_CD           = :HQ-OPTION-CD             
                 AND HQ.PRIMRY_OPT_ATTR_FL  = :HQ-PRIMRY-OPT-ATTR-FL    
                 AND HQ.ATTR_INCTV_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )            
                 AND HQ.ATTR_INCTV_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )            
                 AND HQ.OPT_ATTR_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )       
                 AND HQ.OPT_ATTR_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )       
                 AND HQ.RT_ATTR_INCTV_TYPE <> :WS-CHK-RT-ATTR-INCTV-TYPE
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-PRIM-ATTR-COUNT                                        
MFA-TR*         FROM CRM_OPT_ATTR_INCTV  HQ                                     
MFA-TR*        WHERE HQ.COMPANY_NO          = :WS-COMPANY-NO                    
MFA-TR*          AND HQ.OPTION_CD           = :HQ-OPTION-CD                     
MFA-TR*          AND HQ.PRIMRY_OPT_ATTR_FL  = :HQ-PRIMRY-OPT-ATTR-FL            
MFA-TR*          AND HQ.ATTR_INCTV_STRT_DT <= :WS-CHECK-DATE                    
MFA-TR*          AND HQ.ATTR_INCTV_END_DT  >= :WS-CHECK-DATE                    
MFA-TR*          AND HQ.OPT_ATTR_VSTART_TS <= :WS-CHECK-TIMESTAMP               
MFA-TR*          AND HQ.OPT_ATTR_VEND_TS   >= :WS-CHECK-TIMESTAMP               
MFA-TR*          AND HQ.RT_ATTR_INCTV_TYPE <> :WS-CHK-RT-ATTR-INCTV-TYPE        
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7006                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7006'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_OPT_ATTR_INCT'      TO TABLE-1                  
              MOVE 'OPTION_CD'              TO TABLE-ELEMENT-1          
              MOVE HQ-OPTION-CD             TO HOSTVAR-ELEMENT-1        
              PERFORM 9910-SQL-ERROR           THRU 9910-EXIT           
           END-IF.                                                      
                                                                        
       7006-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7007-VLDT-OPT-ATTR-INCTV.                                      *        
      *                                                                *        
      ******************************************************************        
       7007-VLDT-OPT-ATTR-INCTV.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-FCTR-ACTIVE                                   
                 FROM CSS_SPCL_FCTR_APPL  SA WITH(READUNCOMMITTED)              
                WHERE SA.FACTOR_ID           = :SA-FACTOR-ID            
                  AND SA.DATE_FROM          <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
                  AND SA.DATE_TO            >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
                  AND SA.CODE_STATUS         = 'A'                      
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-FCTR-ACTIVE                                           
MFA-TR*          FROM CSS_SPCL_FCTR_APPL  SA                                    
MFA-TR*         WHERE SA.FACTOR_ID           = :SA-FACTOR-ID                    
MFA-TR*           AND SA.DATE_FROM          <= :WS-CHECK-DATE                   
MFA-TR*           AND SA.DATE_TO            >= :WS-CHECK-DATE                   
MFA-TR*           AND SA.CODE_STATUS         = 'A'                              
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*       QUERYNO 7007                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7007'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                  
              MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-1          
              MOVE SA-FACTOR-ID             TO HOSTVAR-ELEMENT-1        
              PERFORM 9910-SQL-ERROR           THRU 9910-EXIT           
           END-IF.                                                      
                                                                        
       7007-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7008-VLDT-OPT-ATTR-INCTV.                                      *        
      *                                                                *        
      ******************************************************************        
       7008-VLDT-OPT-ATTR-INCTV.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                              
                 INTO :WS-FIXED-FCTR-FOR-OPT                            
                 FROM CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)              
                WHERE HQ.COMPANY_NO          = :WS-COMPANY-NO           
                  AND HQ.RT_ATTR_INCTV_TYPE  = :HQ-RT-ATTR-INCTV-TYPE   
                  AND HQ.FACTOR_ID           = :HQ-FACTOR-ID            
                  AND HQ.OPT_ATTR_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
                  AND HQ.OPT_ATTR_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
                  AND HQ.PROC_STATUS_CD      = :WS-PROC-STATUS-CD       
                  AND EXISTS                                            
                      (SELECT 1                                         
                         FROM CRM_RT_ATTR_INCTV   G7
                           WITH(READUNCOMMITTED)                    
                        WHERE G7.COMPANY_NO  =  HQ.COMPANY_NO           
                          AND G7.RT_ATTR_INCTV_TYPE =                   
                              HQ.RT_ATTR_INCTV_TYPE                     
                          AND G7.SOURCE_CD   =  'FF' )                  
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  'Y'                                                      
MFA-TR*          INTO :WS-FIXED-FCTR-FOR-OPT                                    
MFA-TR*          FROM CRM_OPT_ATTR_INCTV  HQ                                    
MFA-TR*         WHERE HQ.COMPANY_NO          = :WS-COMPANY-NO                   
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE  = :HQ-RT-ATTR-INCTV-TYPE           
MFA-TR*           AND HQ.FACTOR_ID           = :HQ-FACTOR-ID                    
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS   >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND HQ.PROC_STATUS_CD      = :WS-PROC-STATUS-CD               
MFA-TR*           AND EXISTS                                                    
MFA-TR*               (SELECT 1                                                 
MFA-TR*                  FROM CRM_RT_ATTR_INCTV   G7                            
MFA-TR*                 WHERE G7.COMPANY_NO  =  HQ.COMPANY_NO                   
MFA-TR*                   AND G7.RT_ATTR_INCTV_TYPE =                           
MFA-TR*                       HQ.RT_ATTR_INCTV_TYPE                             
MFA-TR*                   AND G7.SOURCE_CD   =  'FF' )                          
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*       QUERYNO 7008                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7008'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_OPT_ATTR_INCT'      TO TABLE-1                  
              MOVE 'OPTION_CD'              TO TABLE-ELEMENT-1          
              MOVE HQ-OPTION-CD             TO HOSTVAR-ELEMENT-1        
              PERFORM 9910-SQL-ERROR           THRU 9910-EXIT           
           END-IF.                                                      
                                                                        
       7008-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-GET-MKT-TIER-DESC.                                        *        
      *                                                                *        
      ******************************************************************        
       7010-GET-MKT-TIER-DESC.                                          
                                                                        
           EXEC SQL                                                     
               SELECT MKT_TIER_DESC                                     
                 INTO :WS-MKT-TIER-DESC                                 
                 FROM CRM_MKT_TIER IG WITH(READUNCOMMITTED)                     
                WHERE IG.COMPANY_NO         = :WS-COMPANY-NO            
                  AND IG.TIER_CUST_STAT_CD  = :IG-TIER-CUST-STAT-CD     
                  AND IG.TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD     
                  AND IG.MKT_TIER_RANKING   = :IG-MKT-TIER-RANKING      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MKT_TIER_DESC                                             
MFA-TR*          INTO :WS-MKT-TIER-DESC                                         
MFA-TR*          FROM CRM_MKT_TIER IG                                           
MFA-TR*         WHERE IG.COMPANY_NO         = :WS-COMPANY-NO                    
MFA-TR*           AND IG.TIER_CUST_STAT_CD  = :IG-TIER-CUST-STAT-CD             
MFA-TR*           AND IG.TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD             
MFA-TR*           AND IG.MKT_TIER_RANKING   = :IG-MKT-TIER-RANKING              
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_MKT_TIER'            TO TABLE-1                 
              MOVE 'TIER_CUST_STAT_CD'       TO TABLE-ELEMENT-1         
              MOVE 'TIER_ACCT_TYPE_CD'       TO TABLE-ELEMENT-2         
              MOVE 'MKT_TIER_RANKING'        TO TABLE-ELEMENT-3         
              MOVE IG-TIER-CUST-STAT-CD      TO HOSTVAR-ELEMENT-1       
              MOVE IG-TIER-ACCT-TYPE-CD      TO HOSTVAR-ELEMENT-2       
              MOVE IG-MKT-TIER-RANKING       TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04177******************************************************************        
A04177* 7012-GET-RATE-PLAN-NO.                                         *        
A04177*                                                                *        
A04177******************************************************************        
A04177 7012-GET-RATE-PLAN-NO.                                           
A04177                                                                  
A04177     EXEC SQL                                                     
A04177         SELECT TOP(1) FI.RATE_PLAN_NO                                   
A04177           INTO :FI-RATE-PLAN-NO                                  
A04177           FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
A04177               ,CRM_OFFER_OPTION  E9 WITH(READUNCOMMITTED)                
A04177          WHERE FI.COMPANY_NO          = :WS-COMPANY-NO           
A04177            AND E9.OFFER_CD            = :E9-OFFER-CD             
A04177            AND FI.OPTION_CD           = E9.OPTION_CD             
A04177            AND FI.OPTION_START_DT    <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
A04177            AND FI.OPTION_END_DT      >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
A04177            AND FI.OPT_VSTART_TS      <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
A04177            AND FI.OPT_VEND_TS        >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
A04177            AND E9.OFFER_OPT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
A04177            AND E9.OFFER_OPT_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )           
A04177            AND E9.OFF_OPT_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
A04177            AND E9.OFF_OPT_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )      
A04177            AND (E9.PROC_STATUS_CD     = :WS-APPROVED             
A04177             OR (E9.PROC_STATUS_CD    <> :WS-APPROVED             
A04177            AND  E9.OFF_OPT_VRSN_NO    = 1 ) )                    
A04177          ORDER BY E9.OFF_OPT_VRSN_NO DESC                        
A04177                                       
A04177                                                      
A04177     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FI.RATE_PLAN_NO                                           
MFA-TR*          INTO :FI-RATE-PLAN-NO                                          
MFA-TR*          FROM CRM_RT_PKG_OPTION FI                                      
MFA-TR*              ,CRM_OFFER_OPTION  E9                                      
MFA-TR*         WHERE FI.COMPANY_NO          = :WS-COMPANY-NO                   
MFA-TR*           AND E9.OFFER_CD            = :E9-OFFER-CD                     
MFA-TR*           AND FI.OPTION_CD           = E9.OPTION_CD                     
MFA-TR*           AND FI.OPTION_START_DT    <= :WS-CHECK-DATE                   
MFA-TR*           AND FI.OPTION_END_DT      >= :WS-CHECK-DATE                   
MFA-TR*           AND FI.OPT_VSTART_TS      <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND FI.OPT_VEND_TS        >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND E9.OFFER_OPT_START_DT <= :WS-CHECK-DATE                   
MFA-TR*           AND E9.OFFER_OPT_END_DT   >= :WS-CHECK-DATE                   
MFA-TR*           AND E9.OFF_OPT_VSTART_TS  <= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND E9.OFF_OPT_VEND_TS    >= :WS-CHECK-TIMESTAMP              
MFA-TR*           AND (E9.PROC_STATUS_CD     = :WS-APPROVED                     
MFA-TR*            OR (E9.PROC_STATUS_CD    <> :WS-APPROVED                     
MFA-TR*           AND  E9.OFF_OPT_VRSN_NO    = 1 ) )                            
MFA-TR*         ORDER BY E9.OFF_OPT_VRSN_NO DESC                                
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7012                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04177                                                                  
A04177     MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE           
A04177                                                                  
A04177     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A04177        NEXT SENTENCE                                             
A04177     ELSE                                                         
A04177        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
A04177        MOVE '7012'                    TO ACTIVE-PARAGRAPH        
A04177        MOVE 'SELECT'                  TO ABEND-FUNCTION          
A04177        MOVE 'CRM_RT_PKG_OPTION'       TO TABLE-1                 
A04177        MOVE 'CRM_OFFER_OPTION'        TO TABLE-2                 
A04177        MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
A04177        MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
A04177        MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
A04177        MOVE E9-OFFER-CD               TO HOSTVAR-ELEMENT-2       
A04177        PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
A04177     END-IF.                                                      
A04177                                                                  
A04177 7012-EXIT.                                                       
A04177     EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7014-CHK-OFF-CD-ACTV-STAT.                                   *          
      *                                                              *          
      ****************************************************************          
       7014-CHK-OFF-CD-ACTV-STAT.                                       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y',
              FG.OFFER_DESC_INT                                 
PRJ680           INTO :WS-OFFER-CD-VALID                                
                     ,:FG-OFFER-DESC-INT                                
                 FROM CRM_RT_PKG_OFFER  FG WITH(READUNCOMMITTED)                
                WHERE FG.COMPANY_NO         = :WS-COMPANY-NO            
                  AND FG.OFFER_CD           = :FG-OFFER-CD              
                  AND FG.OFFER_START_DT    <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )            
                  AND FG.OFFER_END_DT      >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )            
                  AND FG.OFF_VSTART_TS     <= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )       
                  AND FG.OFF_VEND_TS       >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )       
                  AND FG.PROC_STATUS_CD     = :WS-APPROVED              
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*              ,FG.OFFER_DESC_INT                                         
MFA-TR*          INTO :WS-OFFER-CD-VALID                                        
MFA-TR*              ,:FG-OFFER-DESC-INT                                        
MFA-TR*          FROM CRM_RT_PKG_OFFER  FG                                      
MFA-TR*         WHERE FG.COMPANY_NO         = :WS-COMPANY-NO                    
MFA-TR*           AND FG.OFFER_CD           = :FG-OFFER-CD                      
MFA-TR*           AND FG.OFFER_START_DT    <= :WS-CHECK-DATE                    
MFA-TR*           AND FG.OFFER_END_DT      >= :WS-CHECK-DATE                    
MFA-TR*           AND FG.OFF_VSTART_TS     <= :WS-CHECK-TIMESTAMP               
MFA-TR*           AND FG.OFF_VEND_TS       >= :WS-CHECK-TIMESTAMP               
MFA-TR*           AND FG.PROC_STATUS_CD     = :WS-APPROVED                      
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7014                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7014'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FG-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7014-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7015-CHK-OFF-CD-ACTV-STAT.                                   *          
      *                                                              *          
      ****************************************************************          
PRJ680 7015-CHK-OFF-CD-ACTV-STAT.                                       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) FG.PROC_STATUS_CD                                 
                 INTO :FG-PROC-STATUS-CD                                
                 FROM CRM_RT_PKG_OFFER  FG WITH(READUNCOMMITTED)                
                WHERE FG.COMPANY_NO         = :WS-COMPANY-NO            
                  AND FG.OFFER_CD           = :FG-OFFER-CD              
                  AND FG.OFFER_END_DT      >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )            
                  AND FG.OFF_VEND_TS       >= CIS.CHAR2TIMESTAMP(
                                                    :WS-CHECK-TIMESTAMP
              )       
                  ORDER BY FG.OFF_VRSN_NO                               
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FG.PROC_STATUS_CD                                         
MFA-TR*          INTO :FG-PROC-STATUS-CD                                        
MFA-TR*          FROM CRM_RT_PKG_OFFER  FG                                      
MFA-TR*         WHERE FG.COMPANY_NO         = :WS-COMPANY-NO                    
MFA-TR*           AND FG.OFFER_CD           = :FG-OFFER-CD                      
MFA-TR*           AND FG.OFFER_END_DT      >= :WS-CHECK-DATE                    
MFA-TR*           AND FG.OFF_VEND_TS       >= :WS-CHECK-TIMESTAMP               
MFA-TR*           ORDER BY FG.OFF_VRSN_NO                                       
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7015                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7015'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FG-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7090-GET-RATE-GRP-DESC.                                    *            
      *                                                            *            
      **************************************************************            
       7090-GET-RATE-GRP-DESC.                                          
                                                                        
           EXEC SQL                                                     
               SELECT F7.RATE_GRP_DESC                                  
                 INTO :WS-RATE-GROUP-DESC                               
                 FROM CRM_RATE_GROUP          F7 WITH(READUNCOMMITTED)          
                WHERE F7.COMPANY_NO         = :WS-COMPANY-NO            
                  AND F7.RATE_GROUP_TYPE_CD = :F7-RATE-GROUP-TYPE-CD    
                  AND F7.RATE_GROUP_CD      = :F7-RATE-GROUP-CD         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT F7.RATE_GRP_DESC                                          
MFA-TR*          INTO :WS-RATE-GROUP-DESC                                       
MFA-TR*          FROM CRM_RATE_GROUP          F7                                
MFA-TR*         WHERE F7.COMPANY_NO         = :WS-COMPANY-NO                    
MFA-TR*           AND F7.RATE_GROUP_TYPE_CD = :F7-RATE-GROUP-TYPE-CD            
MFA-TR*           AND F7.RATE_GROUP_CD      = :F7-RATE-GROUP-CD                 
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7090                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7090'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RATE_GROUP'          TO TABLE-1                 
              MOVE 'RATE_GROUP_TYPE_CD'      TO TABLE-ELEMENT-1         
              MOVE 'RATE_GROUP_CD'           TO TABLE-ELEMENT-2         
              MOVE G5-RATE-GROUP-TYPE-CD     TO HOSTVAR-ELEMENT-1       
              MOVE G5-RATE-GROUP-CD          TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR         THRU 9910-EXIT             
           END-IF.                                                      
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7100-CHK-OFF-ROW-EXIST.                                   *             
      *                                                           *             
      **************************************************************            
       7100-CHK-OFF-ROW-EXIST.                                          
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-OFFER-ROW-EXIST                               
                 FROM CRM_RT_PKG_OFFER FG WITH(READUNCOMMITTED)                 
                WHERE FG.COMPANY_NO     = :WS-COMPANY-NO                
                  AND FG.OFFER_CD       = :FG-OFFER-CD                  
                  AND FG.PROC_STATUS_CD <> 'AC'                         
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-OFFER-ROW-EXIST                                       
MFA-TR*          FROM CRM_RT_PKG_OFFER FG                                       
MFA-TR*         WHERE FG.COMPANY_NO     = :WS-COMPANY-NO                        
MFA-TR*           AND FG.OFFER_CD       = :FG-OFFER-CD                          
MFA-TR*           AND FG.PROC_STATUS_CD <> 'AC'                                 
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FG-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7105-CHK-OFF-MKT-TIER-ROW.                                 *            
      *                                                            *            
      **************************************************************            
       7105-CHK-OFF-MKT-TIER-ROW.                                       
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-ROW-EXIST                                    
                  FROM CRM_OFF_MKT_TIER DU WITH(READUNCOMMITTED)                
                 WHERE DU.COMPANY_NO          = :WS-COMPANY-NO          
                   AND DU.OFFER_CD            = :DU-OFFER-CD            
                   AND DU.TIER_CUST_STAT_CD   = :DU-TIER-CUST-STAT-CD   
                   AND DU.TIER_ACCT_TYPE_CD   = :DU-TIER-ACCT-TYPE-CD   
                   AND DU.MKT_TIER_RANKING    = :DU-MKT-TIER-RANKING    
                   AND DU.MKT_TIER_START_DT   = IIF(TRY_CONVERT(DATE, 
                                                  :DU-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DU-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:DU-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:DU-MKT-TIER-START-DT
              ), CONVERT(DATE, :DU-MKT-TIER-START-DT) )   
                   AND DU.OFFER_TIER_STRT_DT  = IIF(TRY_CONVERT(DATE, 
                                                 :DU-OFFER-TIER-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :DU-OFFER-TIER-STRT-DT
              ) <> 0) OR (LEN(:DU-OFFER-TIER-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:DU-OFFER-TIER-STRT-DT
              ), CONVERT(DATE, :DU-OFFER-TIER-STRT-DT) )  
                   AND DU.PROC_STATUS_CD     <> :WS-PROC-STATUS-CD      
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-ROW-EXIST                                            
MFA-TR*           FROM CRM_OFF_MKT_TIER DU                                      
MFA-TR*          WHERE DU.COMPANY_NO          = :WS-COMPANY-NO                  
MFA-TR*            AND DU.OFFER_CD            = :DU-OFFER-CD                    
MFA-TR*            AND DU.TIER_CUST_STAT_CD   = :DU-TIER-CUST-STAT-CD           
MFA-TR*            AND DU.TIER_ACCT_TYPE_CD   = :DU-TIER-ACCT-TYPE-CD           
MFA-TR*            AND DU.MKT_TIER_RANKING    = :DU-MKT-TIER-RANKING            
MFA-TR*            AND DU.MKT_TIER_START_DT   = :DU-MKT-TIER-START-DT           
MFA-TR*            AND DU.OFFER_TIER_STRT_DT  = :DU-OFFER-TIER-STRT-DT          
MFA-TR*            AND DU.PROC_STATUS_CD     <> :WS-PROC-STATUS-CD              
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7105                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7105'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFF_MKT_TIER'        TO TABLE-1                 
              MOVE 'TIER_CUST_STAT_CD'       TO TABLE-ELEMENT-1         
              MOVE 'TIER_ACCT_TYPE_CD'       TO TABLE-ELEMENT-2         
              MOVE 'MKT_TIER_RANKING'        TO TABLE-ELEMENT-3         
              MOVE 'MKT_TIER_START_DT'       TO TABLE-ELEMENT-4         
              MOVE DU-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              MOVE DU-TIER-CUST-STAT-CD      TO HOSTVAR-ELEMENT-2       
              MOVE DU-TIER-ACCT-TYPE-CD      TO HOSTVAR-ELEMENT-3       
              MOVE DU-MKT-TIER-RANKING       TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7110-CHK-OFF-ACCESS-ROW.                                   *            
      *                                                            *            
      **************************************************************            
       7110-CHK-OFF-ACCESS-ROW.                                         
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-ROW-EXIST                                    
                  FROM CRM_ACCESS_OFF_OPT CI WITH(READUNCOMMITTED)              
                 WHERE CI.COMPANY_NO         = :WS-COMPANY-NO           
                   AND CI.OFFER_CD           = :CI-OFFER-CD             
                   AND CI.CATEGORY_ID        = :CI-CATEGORY-ID          
                   AND CI.PROC_STATUS_CD    <> :WS-PROC-STATUS-CD       
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-ROW-EXIST                                            
MFA-TR*           FROM CRM_ACCESS_OFF_OPT CI                                    
MFA-TR*          WHERE CI.COMPANY_NO         = :WS-COMPANY-NO                   
MFA-TR*            AND CI.OFFER_CD           = :CI-OFFER-CD                     
MFA-TR*            AND CI.CATEGORY_ID        = :CI-CATEGORY-ID                  
MFA-TR*            AND CI.PROC_STATUS_CD    <> :WS-PROC-STATUS-CD               
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7110                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7110'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_ACCESS_OFF_OPT'      TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE 'CATEGORY_ID'             TO TABLE-ELEMENT-2         
              MOVE CI-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              MOVE CI-CATEGORY-ID            TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7115-CHK-OFF-RATE-GRP-ROW.                                 *            
      *                                                            *            
      **************************************************************            
       7115-CHK-OFF-RATE-GRP-ROW.                                       
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-ROW-EXIST                                    
                  FROM CRM_RATE_GRP_OFFER G5 WITH(READUNCOMMITTED)              
                 WHERE G5.COMPANY_NO         = :WS-COMPANY-NO           
                   AND G5.OFFER_CD           = :G5-OFFER-CD             
                   AND G5.RATE_GROUP_TYPE_CD = :G5-RATE-GROUP-TYPE-CD   
                   AND G5.RATE_GROUP_CD      = :G5-RATE-GROUP-CD        
                   AND G5.PROC_STATUS_CD    <> :WS-PROC-STATUS-CD       
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-ROW-EXIST                                            
MFA-TR*           FROM CRM_RATE_GRP_OFFER G5                                    
MFA-TR*          WHERE G5.COMPANY_NO         = :WS-COMPANY-NO                   
MFA-TR*            AND G5.OFFER_CD           = :G5-OFFER-CD                     
MFA-TR*            AND G5.RATE_GROUP_TYPE_CD = :G5-RATE-GROUP-TYPE-CD           
MFA-TR*            AND G5.RATE_GROUP_CD      = :G5-RATE-GROUP-CD                
MFA-TR*            AND G5.PROC_STATUS_CD    <> :WS-PROC-STATUS-CD               
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7110                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7115'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RATE_GRP_OFFER'      TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE 'RATE_GROUP_TYPE_CD'      TO TABLE-ELEMENT-2         
              MOVE 'RATE_GROUP_CD'           TO TABLE-ELEMENT-3         
              MOVE G5-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              MOVE G5-RATE-GROUP-TYPE-CD     TO HOSTVAR-ELEMENT-2       
              MOVE G5-RATE-GROUP-CD          TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7115-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7116-GET-MAX-PROC-REQ-ID.                                  *            
      *                                                            *            
      **************************************************************            
       7116-GET-MAX-PROC-REQ-ID.                                        
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) FI.PROC_REQ_ID,
              FI.PROC_STATUS_CD                                
                  INTO :FI-PROC-REQ-ID                                  
                      ,:FI-PROC-STATUS-CD                               
                  FROM CRM_RT_PKG_OPTION  FI WITH(READUNCOMMITTED)              
                 WHERE FI.COMPANY_NO         = :WS-COMPANY-NO           
                   AND FI.OPTION_CD          = :E9-OPTION-CD            
                   AND FI.OPT_VRSN_NO        = 1                        
                 ORDER BY FI.OPT_VRSN_NO DESC                           
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT FI.PROC_REQ_ID                                           
MFA-TR*               ,FI.PROC_STATUS_CD                                        
MFA-TR*           INTO :FI-PROC-REQ-ID                                          
MFA-TR*               ,:FI-PROC-STATUS-CD                                       
MFA-TR*           FROM CRM_RT_PKG_OPTION  FI                                    
MFA-TR*          WHERE FI.COMPANY_NO         = :WS-COMPANY-NO                   
MFA-TR*            AND FI.OPTION_CD          = :E9-OPTION-CD                    
MFA-TR*            AND FI.OPT_VRSN_NO        = 1                                
MFA-TR*          ORDER BY FI.OPT_VRSN_NO DESC                                   
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7116                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7116'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OPTION'       TO TABLE-1                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE FI-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7116-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7117-CHK-OFF-OPT-STATUS.                                   *            
      *                                                            *            
      **************************************************************            
       7117-CHK-OFF-OPT-STATUS.                                         
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-OPT-ATTCHD-WTH-OTHR-OFF                      
                  FROM CRM_RT_PKG_OPTION  FI WITH(READUNCOMMITTED)              
                      ,CRM_OFFER_OPTION   E9 WITH(READUNCOMMITTED)              
                 WHERE FI.COMPANY_NO         = :WS-COMPANY-NO           
                   AND FI.OPTION_CD          = :E9-OPTION-CD            
                   AND FI.PROC_REQ_ID        = :WS-CHK-OPT-PRC-REQ-ID   
                   AND FI.OPT_VRSN_NO        =  1                       
                   AND E9.OPTION_CD          =  FI.OPTION_CD            
                   AND E9.OFFER_CD          <> :E9-OFFER-CD             
                 ORDER BY FI.OPT_VRSN_NO DESC                           
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-OPT-ATTCHD-WTH-OTHR-OFF                              
MFA-TR*           FROM CRM_RT_PKG_OPTION  FI                                    
MFA-TR*               ,CRM_OFFER_OPTION   E9                                    
MFA-TR*          WHERE FI.COMPANY_NO         = :WS-COMPANY-NO                   
MFA-TR*            AND FI.OPTION_CD          = :E9-OPTION-CD                    
MFA-TR*            AND FI.PROC_REQ_ID        = :WS-CHK-OPT-PRC-REQ-ID           
MFA-TR*            AND FI.OPT_VRSN_NO        =  1                               
MFA-TR*            AND E9.OPTION_CD          =  FI.OPTION_CD                    
MFA-TR*            AND E9.OFFER_CD          <> :E9-OFFER-CD                     
MFA-TR*          ORDER BY FI.OPT_VRSN_NO DESC                                   
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7117                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7117'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OPTION'       TO TABLE-1                 
              MOVE 'CRM_OFFER_OPTION'        TO TABLE-2                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE E9-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              MOVE E9-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7117-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7118-CHK-RJCT-OFF-AS-RNWL.                                              
      *                                                                         
      **************************************************************            
       7118-CHK-RJCT-OFF-AS-RNWL.                                       
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-OFF-ATTCHD-WTH-OTHR-OFF                      
                  FROM CRM_RT_PKG_OFFER   FG WITH(READUNCOMMITTED)              
                 WHERE FG.COMPANY_NO         = :WS-COMPANY-NO           
                   AND FG.RENEWAL_OFFER_CD   = :FG-OFFER-CD             
                   AND FG.RENEWAL_OFFER_CD  <>  FG.OFFER_CD             
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-OFF-ATTCHD-WTH-OTHR-OFF                              
MFA-TR*           FROM CRM_RT_PKG_OFFER   FG                                    
MFA-TR*          WHERE FG.COMPANY_NO         = :WS-COMPANY-NO                   
MFA-TR*            AND FG.RENEWAL_OFFER_CD   = :FG-OFFER-CD                     
MFA-TR*            AND FG.RENEWAL_OFFER_CD  <>  FG.OFFER_CD                     
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7118                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7118'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
              MOVE 'CRM_OFFER_OPTION'        TO TABLE-2                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
              MOVE FG-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7118-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7120-CHK-OPT-ROW-EXIST.                                    *            
      *                                                            *            
      **************************************************************            
       7120-CHK-OPT-ROW-EXIST.                                          
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-ROW-EXIST                                     
                 FROM CRM_RT_PKG_OPTION  FI WITH(READUNCOMMITTED)               
                WHERE FI.COMPANY_NO     = :WS-COMPANY-NO                
                  AND FI.OPTION_CD      = :FI-OPTION-CD                 
                  AND FI.PROC_STATUS_CD <> :WS-PROC-STATUS-CD           
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-ROW-EXIST                                             
MFA-TR*          FROM CRM_RT_PKG_OPTION  FI                                     
MFA-TR*         WHERE FI.COMPANY_NO     = :WS-COMPANY-NO                        
MFA-TR*           AND FI.OPTION_CD      = :FI-OPTION-CD                         
MFA-TR*           AND FI.PROC_STATUS_CD <> :WS-PROC-STATUS-CD                   
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7120                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7120'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OPTION'       TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'FI_OPTION_CD'            TO TABLE-ELEMENT-2         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FI-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7121-GET-OPT-END-DT.                                       *            
      *                                                            *            
      **************************************************************            
       7121-GET-OPT-END-DT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) FI.OPTION_START_DT,
              FI.OPTION_END_DT                                  
                 INTO :FI-OPTION-START-DT                               
                     ,:FI-OPTION-END-DT                                 
                 FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
                WHERE FI.COMPANY_NO       = :WS-COMPANY-NO              
                  AND FI.OPTION_CD        = :FI-OPTION-CD               
               ORDER BY FI.OPT_VRSN_NO DESC                             
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FI.OPTION_START_DT                                        
MFA-TR*              ,FI.OPTION_END_DT                                          
MFA-TR*          INTO :FI-OPTION-START-DT                                       
MFA-TR*              ,:FI-OPTION-END-DT                                         
MFA-TR*          FROM CRM_RT_PKG_OPTION FI                                      
MFA-TR*         WHERE FI.COMPANY_NO       = :WS-COMPANY-NO                      
MFA-TR*           AND FI.OPTION_CD        = :FI-OPTION-CD                       
MFA-TR*        ORDER BY FI.OPT_VRSN_NO DESC                                     
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*       QUERYNO 7121                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7121'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OPTION'       TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'FI_OPTION_CD'            TO TABLE-ELEMENT-2         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FI-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7121-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7122-CHK-OFF-OPT-ROW-EXIST                                 *            
      *                                                            *            
      **************************************************************            
       7122-CHK-OFF-OPT-ROW-EXIST.                                      
                                                                        
           EXEC SQL                                                     
              SELECT COUNT (*)                                          
                INTO :WS-ROW-COUNT                                      
                FROM CRM_OFFER_OPTION E9 WITH(READUNCOMMITTED)                  
               WHERE E9.COMPANY_NO         = :WS-COMPANY-NO             
                 AND E9.OPTION_CD          = :FI-OPTION-CD              
                 AND E9.PROC_REQ_ID       <> :WS-COMMON-PROC-REQ-ID     
                 AND E9.OFFER_OPT_END_DT   > CAST(SYSDATETIMEOFFSET() 
           AS DATE)               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT (*)                                                  
MFA-TR*         INTO :WS-ROW-COUNT                                              
MFA-TR*         FROM CRM_OFFER_OPTION E9                                        
MFA-TR*        WHERE E9.COMPANY_NO         = :WS-COMPANY-NO                     
MFA-TR*          AND E9.OPTION_CD          = :FI-OPTION-CD                      
MFA-TR*          AND E9.PROC_REQ_ID       <> :WS-COMMON-PROC-REQ-ID             
MFA-TR*          AND E9.OFFER_OPT_END_DT   > CURRENT DATE                       
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7122                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7122'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFFER_OPTION'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'E9_OPTION_CD'            TO TABLE-ELEMENT-2         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE E9-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7122-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7123-CHK-OFF-OPT-ROW-EXIST.                              *              
      *                                                            *            
      **************************************************************            
       7123-CHK-OFF-OPT-ROW-EXIST.                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-ROW-EXIST                                     
                 FROM CRM_OFFER_OPTION  E9 WITH(READUNCOMMITTED)                
                WHERE E9.COMPANY_NO       = :WS-COMPANY-NO              
                  AND E9.OFFER_CD         = :E9-OFFER-CD                
                  AND E9.OPTION_CD        = :E9-OPTION-CD               
                  AND E9.PROC_STATUS_CD  <> :WS-PROC-STATUS-CD          
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-ROW-EXIST                                             
MFA-TR*          FROM CRM_OFFER_OPTION  E9                                      
MFA-TR*         WHERE E9.COMPANY_NO       = :WS-COMPANY-NO                      
MFA-TR*           AND E9.OFFER_CD         = :E9-OFFER-CD                        
MFA-TR*           AND E9.OPTION_CD        = :E9-OPTION-CD                       
MFA-TR*           AND E9.PROC_STATUS_CD  <> :WS-PROC-STATUS-CD                  
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7123                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7123'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFFER_OPTION'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'E9_OPTION_CD'            TO TABLE-ELEMENT-2         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE E9-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7123-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7124-GET-OTHER-OFF-FOR-OPT.                                *            
      *                                                            *            
      **************************************************************            
       7124-GET-OTHER-OFF-FOR-OPT.                                      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-ATTCHD-WITH-OTHR-OFF                           
                FROM CRM_OFFER_OPTION E9 WITH(READUNCOMMITTED)                  
               WHERE E9.COMPANY_NO         = :WS-COMPANY-NO             
                 AND E9.OPTION_CD          = :FI-OPTION-CD              
                 AND E9.OFFER_CD          <> :WS-CHK-OFFER-CD           
                 AND E9.OFFER_OPT_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHECK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CHECK-DATE
              ) <> 0) OR (LEN(:WS-CHECK-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHECK-DATE
              ), CONVERT(DATE, :WS-CHECK-DATE) )             
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-ATTCHD-WITH-OTHR-OFF                                   
MFA-TR*         FROM CRM_OFFER_OPTION E9                                        
MFA-TR*        WHERE E9.COMPANY_NO         = :WS-COMPANY-NO                     
MFA-TR*          AND E9.OPTION_CD          = :FI-OPTION-CD                      
MFA-TR*          AND E9.OFFER_CD          <> :WS-CHK-OFFER-CD                   
MFA-TR*          AND E9.OFFER_OPT_END_DT  >= :WS-CHECK-DATE                     
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7124                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7124'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFFER_OPTION'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'FI_OPTION_CD'            TO TABLE-ELEMENT-2         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FI-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7124-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 7125-CHK-OPT-ATTR-ROW-EXIST.                                *           
      *                                                             *           
      ***************************************************************           
       7125-CHK-OPT-ATTR-ROW-EXIST.                                     
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-ROW-EXIST                                     
                 FROM CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)               
                WHERE HQ.COMPANY_NO        = :WS-COMPANY-NO             
                  AND HQ.OPTION_CD         = :HQ-OPTION-CD              
                  AND HQ.ATTR_INCTV_SEQ_NO = :HQ-ATTR-INCTV-SEQ-NO      
                  AND HQ.PROC_STATUS_CD   <> :WS-PROC-STATUS-CD         
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-ROW-EXIST                                             
MFA-TR*          FROM CRM_OPT_ATTR_INCTV HQ                                     
MFA-TR*         WHERE HQ.COMPANY_NO        = :WS-COMPANY-NO                     
MFA-TR*           AND HQ.OPTION_CD         = :HQ-OPTION-CD                      
MFA-TR*           AND HQ.ATTR_INCTV_SEQ_NO = :HQ-ATTR-INCTV-SEQ-NO              
MFA-TR*           AND HQ.PROC_STATUS_CD   <> :WS-PROC-STATUS-CD                 
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7125                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7125'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OPT_ATTR_INCTV'      TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE HQ-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7125-EXIT.                                                       
           EXIT.                                                        
                                                                        
PRJ680**************************************************************            
PRJ680* 7126-GET-OFF-END-DT.                                       *            
PRJ680*                                                            *            
PRJ680**************************************************************            
PRJ680 7126-GET-OFF-END-DT.                                             
PRJ680                                                                  
PRJ680     EXEC SQL                                                     
PRJ680         SELECT TOP(1) FG.OFFER_END_DT                                   
PRJ680           INTO :FG-OFFER-END-DT                                  
PRJ680           FROM CRM_RT_PKG_OFFER FG WITH(READUNCOMMITTED)                 
PRJ680          WHERE FG.COMPANY_NO       = :WS-COMPANY-NO              
PRJ680            AND FG.OFFER_CD         = :FG-OFFER-CD                
PRJ680            AND FG.PROC_STATUS_CD   = :WS-APPROVED                
PRJ680         ORDER BY FG.OFF_VRSN_NO DESC                             
PRJ680                                       
PRJ680                                                      
PRJ680     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FG.OFFER_END_DT                                           
MFA-TR*          INTO :FG-OFFER-END-DT                                          
MFA-TR*          FROM CRM_RT_PKG_OFFER FG                                       
MFA-TR*         WHERE FG.COMPANY_NO       = :WS-COMPANY-NO                      
MFA-TR*           AND FG.OFFER_CD         = :FG-OFFER-CD                        
MFA-TR*           AND FG.PROC_STATUS_CD   = :WS-APPROVED                        
MFA-TR*        ORDER BY FG.OFF_VRSN_NO DESC                                     
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*       QUERYNO 7126                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ680                                                                  
PRJ680     MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE           
PRJ680                                                                  
PRJ680     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PRJ680         NEXT SENTENCE                                            
PRJ680     ELSE                                                         
PRJ680        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
PRJ680        MOVE '7126'                    TO ACTIVE-PARAGRAPH        
PRJ680        MOVE 'SELECT'                  TO ABEND-FUNCTION          
PRJ680        MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
PRJ680        MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
PRJ680        MOVE 'FG_OFFER_CD'             TO TABLE-ELEMENT-2         
PRJ680        MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
PRJ680        MOVE FG-OFFER-CD               TO HOSTVAR-ELEMENT-2       
PRJ680        PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
PRJ680     END-IF.                                                      
PRJ680                                                                  
PRJ680 7126-EXIT.                                                       
PRJ680     EXIT.                                                        
PRJ680                                                                  
PRJ680**************************************************************            
PRJ680* 7127-CHK-OFF-OPT-ROW-EXIST                                 *            
PRJ680*                                                            *            
PRJ680**************************************************************            
PRJ680 7127-CHK-OFF-OPT-ROW-EXIST.                                      
PRJ680                                                                  
PRJ680     EXEC SQL                                                     
PRJ680        SELECT COUNT (*)                                          
PRJ680          INTO :WS-ROW-COUNT                                      
PRJ680          FROM CRM_RT_PKG_OFFER FG WITH(READUNCOMMITTED)                  
PRJ680         WHERE FG.COMPANY_NO         = :WS-COMPANY-NO             
PRJ680           AND FG.MAX_PRICE_OFFER_CD = :FG-OFFER-CD               
PRJ680           AND FG.OFFER_CD          <> :FG-OFFER-CD               
PRJ680           AND FG.PROC_STATUS_CD IN (:WS-APPROVED ,               
PRJ680                                     :WS-PEND-APPROVAL )          
PRJ680           AND FG.OFFER_END_DT       > IIF(TRY_CONVERT(DATE, 
                                                     :WS-CHK-OFF-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CHK-OFF-END-DT
              ) <> 0) OR (LEN(:WS-CHK-OFF-END-DT
              ) <> 10), CIS.CHAR2DATE(:WS-CHK-OFF-END-DT
              ), CONVERT(DATE, :WS-CHK-OFF-END-DT) )         
PRJ680                                                           
PRJ680                                                      
PRJ680     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT (*)                                                  
MFA-TR*         INTO :WS-ROW-COUNT                                              
MFA-TR*         FROM CRM_RT_PKG_OFFER FG                                        
MFA-TR*        WHERE FG.COMPANY_NO         = :WS-COMPANY-NO                     
MFA-TR*          AND FG.MAX_PRICE_OFFER_CD = :FG-OFFER-CD                       
MFA-TR*          AND FG.OFFER_CD          <> :FG-OFFER-CD                       
MFA-TR*          AND FG.PROC_STATUS_CD IN (:WS-APPROVED ,                       
MFA-TR*                                    :WS-PEND-APPROVAL )                  
MFA-TR*          AND FG.OFFER_END_DT       > :WS-CHK-OFF-END-DT                 
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7127                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ680                                                                  
PRJ680     MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE           
PRJ680                                                                  
PRJ680     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PRJ680         NEXT SENTENCE                                            
PRJ680     ELSE                                                         
PRJ680        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
PRJ680        MOVE '7127'                    TO ACTIVE-PARAGRAPH        
PRJ680        MOVE 'SELECT'                  TO ABEND-FUNCTION          
PRJ680        MOVE 'CRM_OFFER_OPTION'        TO TABLE-1                 
PRJ680        MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
PRJ680        MOVE 'E9_OFFER-CD'             TO TABLE-ELEMENT-2         
PRJ680        MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
PRJ680        MOVE E9-OFFER-CD               TO HOSTVAR-ELEMENT-2       
PRJ680        PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
PRJ680     END-IF.                                                      
PRJ680                                                                  
PRJ680 7127-EXIT.                                                       
PRJ680     EXIT.                                                        
                                                                        
P00863**************************************************************            
P00863* 7128-CHK-OFFER-ROW-EXIST                                   *            
P00863*                                                            *            
P00863**************************************************************            
P00863 7128-CHK-OFFER-ROW-EXIST.                                        
P00863                                                                  
P00863     EXEC SQL                                                     
P00863        SELECT COUNT (*)                                          
P00863          INTO :WS-ROW-COUNT                                      
P00863          FROM CRM_RT_PKG_OFFER FG WITH(READUNCOMMITTED)                  
P00863         WHERE FG.COMPANY_NO         = :WS-COMPANY-NO             
P00863           AND FG.RTCHG_PUB_OFFER_CD = :FG-OFFER-CD               
P00863           AND FG.OFFER_CD          <> :FG-OFFER-CD               
P00863           AND FG.PROC_STATUS_CD IN (:WS-APPROVED ,               
P00863                                     :WS-PEND-APPROVAL )          
P00863           AND FG.OFFER_END_DT       > IIF(TRY_CONVERT(DATE, 
                                                     :WS-CHK-OFF-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CHK-OFF-END-DT
              ) <> 0) OR (LEN(:WS-CHK-OFF-END-DT
              ) <> 10), CIS.CHAR2DATE(:WS-CHK-OFF-END-DT
              ), CONVERT(DATE, :WS-CHK-OFF-END-DT) )         
P00863                                                           
P00863                                                      
P00863     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT (*)                                                  
MFA-TR*         INTO :WS-ROW-COUNT                                              
MFA-TR*         FROM CRM_RT_PKG_OFFER FG                                        
MFA-TR*        WHERE FG.COMPANY_NO         = :WS-COMPANY-NO                     
MFA-TR*          AND FG.RTCHG_PUB_OFFER_CD = :FG-OFFER-CD                       
MFA-TR*          AND FG.OFFER_CD          <> :FG-OFFER-CD                       
MFA-TR*          AND FG.PROC_STATUS_CD IN (:WS-APPROVED ,                       
MFA-TR*                                    :WS-PEND-APPROVAL )                  
MFA-TR*          AND FG.OFFER_END_DT       > :WS-CHK-OFF-END-DT                 
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7128                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00863                                                                  
P00863     MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE           
P00863                                                                  
P00863     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00863         NEXT SENTENCE                                            
P00863     ELSE                                                         
P00863        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00863        MOVE '7128'                    TO ACTIVE-PARAGRAPH        
P00863        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00863        MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
P00863        MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
P00863        MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
P00863        MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
P00863        MOVE FG-OFFER-CD               TO HOSTVAR-ELEMENT-2       
P00863        PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
P00863     END-IF.                                                      
P00863                                                                  
P00863 7128-EXIT.                                                       
P00863     EXIT.                                                        
P00863                                                                  
      ****************************************************************          
      * 7130-CHK-OPT-ACCESS-ROW.                                     *          
      *                                                              *          
      ****************************************************************          
       7130-CHK-OPT-ACCESS-ROW.                                         
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-ROW-EXIST                                    
                  FROM CRM_ACCESS_OFF_OPT CI WITH(READUNCOMMITTED)              
                 WHERE CI.COMPANY_NO         = :WS-COMPANY-NO           
                   AND CI.OPTION_CD          = :CI-OPTION-CD            
                   AND CI.CATEGORY_ID        = :CI-CATEGORY-ID          
                   AND CI.PROC_STATUS_CD    <> :WS-PROC-STATUS-CD       
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-ROW-EXIST                                            
MFA-TR*           FROM CRM_ACCESS_OFF_OPT CI                                    
MFA-TR*          WHERE CI.COMPANY_NO         = :WS-COMPANY-NO                   
MFA-TR*            AND CI.OPTION_CD          = :CI-OPTION-CD                    
MFA-TR*            AND CI.CATEGORY_ID        = :CI-CATEGORY-ID                  
MFA-TR*            AND CI.PROC_STATUS_CD    <> :WS-PROC-STATUS-CD               
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7130                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7130'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_ACCESS_OFF_OPT'      TO TABLE-1                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE 'CATEGORY_ID'             TO TABLE-ELEMENT-2         
              MOVE CI-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              MOVE CI-CATEGORY-ID            TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7135-CHK-MKT-PROMO-ROW-EXIST.                              *            
      *                                                            *            
      **************************************************************            
       7135-CHK-MKT-PROMO-ROW-EXIST.                                    
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-ROW-EXIST                                     
                 FROM CRM_MKT_PROMOTION KM WITH(READUNCOMMITTED)                
                WHERE KM.COMPANY_NO        = :WS-COMPANY-NO             
                  AND KM.PROMO_CD          = :KM-PROMO-CD               
                  AND KM.PROC_STATUS_CD   <> :WS-PROC-STATUS-CD         
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-ROW-EXIST                                             
MFA-TR*          FROM CRM_MKT_PROMOTION KM                                      
MFA-TR*         WHERE KM.COMPANY_NO        = :WS-COMPANY-NO                     
MFA-TR*           AND KM.PROMO_CD          = :KM-PROMO-CD                       
MFA-TR*           AND KM.PROC_STATUS_CD   <> :WS-PROC-STATUS-CD                 
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7135                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7135'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_MKT_PROMOTION'       TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PROMO_CD'                TO TABLE-ELEMENT-2         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE KM-PROMO-CD               TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7135-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7136-CHK-PROMO-REUSED.                                     *            
      *                                                            *            
      **************************************************************            
       7136-CHK-PROMO-REUSED.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) KM.OFFER_CD,
              PROMO_VRSN_NO                                     
                 INTO :WS-PROMO-OFFER-CD                                
                     ,:KM-PROMO-VRSN-NO                                 
                 FROM CRM_MKT_PROMOTION KM WITH(READUNCOMMITTED)                
                WHERE KM.COMPANY_NO    = :WS-COMPANY-NO                 
                  AND KM.PROMO_CD      = :WS-CHK-PROMO-CD               
                ORDER BY KM.PROMO_VRSN_NO DESC                          
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT KM.OFFER_CD                                               
MFA-TR*              ,PROMO_VRSN_NO                                             
MFA-TR*          INTO :WS-PROMO-OFFER-CD                                        
MFA-TR*              ,:KM-PROMO-VRSN-NO                                         
MFA-TR*          FROM CRM_MKT_PROMOTION KM                                      
MFA-TR*         WHERE KM.COMPANY_NO    = :WS-COMPANY-NO                         
MFA-TR*           AND KM.PROMO_CD      = :WS-CHK-PROMO-CD                       
MFA-TR*         ORDER BY KM.PROMO_VRSN_NO DESC                                  
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*          QUERYNO 7136                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7136'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_MKT_PROMOTION'       TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PROMO_CD'                TO TABLE-ELEMENT-2         
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-CHK-PROMO-CD           TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7136-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9910-SQL-ERROR.                                               *         
      *                                                               *         
      *****************************************************************         
       9910-SQL-ERROR.                                                  
                                                                        
           EXIT PROGRAM.                                                
                                                                        
       9910-EXIT.                                                       
           EXIT.                                                        
                                                                        
