      *****************************************************************         
      **  CPD00826 COPYBOOK TO SET UP CUSTOMER ON OPTION.            **         
      **               SEB CRM BPA ENTRY                            **          
      **.............................................................**         
      **.............................................................**         
      **NOTE: WHEN MODIFYING THIS MEMBER, MEMBER CWS00826 & CWS0826A **         
      **      SHOULD BE EVALUATED FOR CORRESPONDING MODIFICATIONS.   **         
      **.............................................................**         
      **                                                             **         
      **  PROCEDURE REFERENCE:                                       **         
      **                                                             **         
      **  PREREQUISITES: CWS00826 & CWS0826A                         **         
      **                                                             **         
      **  ADDITIONAL INFORMATION:                                    **         
      **    This copybook is called from CRM - BPA Table entry       **         
      **    wizard and has the core logic to support the process     **         
      **    driven operations.                                       **         
      **                                                             **         
      *****************************************************************         
      ****************************************************************          
      *   MODIFICATION LOG -                                          *         
      *                                                               *         
      *   DATE     INITIALS        COMMENTS                           *         
      *  ------    --------        -----------------------------------*         
P00473* 03/10/11   MN90523         INTIALLY WRITTEN.                  *         
PRJ680* 02/12/13   MS93554         A NEW COLUMN MAX_PRICE_OFFER_CD    *         
      *                            HAS BEEN ADDED INTO CRM TABLE      *         
      *                            CRM_RT_PKG_OFFER.                  *         
A04805* 11/05/13   MS93554         NEW COLUMNS ARE ADDED IN CRM_OFFER *         
      *                            _OPTION & CRM_RT_PKG_OPTION TABLES *         
PRJ892* 04/23/15   SS95855         NEW COLUMNS ADDED TO TABLE         *         
PRJ892*                            CRM_RT_PKG_OPTION.                 *         
P00863* 07/08/15   SS45239         A NEW COLUMN RTCHG_PUB_OFFER_CD    *         
      *                            HAS BEEN ADDED INTO CRM TABLE      *         
      *                            CRM_RT_PKG_OFFER.                  *         
      *****************************************************************         
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6000-START-CRM-BPA-OPS.                                       *         
      *****************************************************************         
       6000-START-CRM-BPA-OPS.                                          
                                                                        
           PERFORM 6020-PROCESS-INPUT           THRU 6020-EXIT.         
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6020-PROCESS-INPUT.                                           *         
      *****************************************************************         
       6020-PROCESS-INPUT.                                              
                                                                        
           MOVE WS-CRM-RESOURCE-ID          TO WS-RPM-RESOURCE-SW.      
           PERFORM 6570-GET-CRM-PROCESS-DETAILS   THRU 6570-EXIT.       
                                                                        
      * UPDATE THE VERSION START TIMESTAMP IN PROC REQUEST TABLE                
           IF CRM-OFFER-CHANGE                                          
            OR CRM-OPTION-CHANGE                                        
            OR CRM-PROMOTION-CHANGE THEN                                
              MOVE WS-CRM-PROC-REQ-ID             TO 1P-PROC-REQ-ID     
              MOVE WS-CRM-VRSN-TIMESTAMP          TO 1P-EFFECTIVE-TS    
              PERFORM 8010-UPT-PROC-REQ-EFF-TS    THRU 8010-EXIT        
           END-IF                                                       
      * PROCESS OFFER                                                           
           IF CRM-OFFER-CHANGE THEN                                     
                                                                        
              EVALUATE TRUE                                             
              WHEN CRM-OFFER-INSERT                                     
      * PROCESS TEMPLATE OFFER IF IT IS A CREATE REPLACE OFFFER WIZARD          
      * AND IF THE TEMPLATE OFFER CODE IS SUPPLIED                              
                  IF CREATE-REPLACE-OFFER-WIZARD                        
                   AND CALL-FRM-WIZARD                                  
                   AND WS-CRM-TEMPLATE-OFFER-CD > SPACES                
                    PERFORM 6522-PROCESS-TMPLT-OFFER                    
                                                  THRU 6522-EXIT        
                  END-IF                                                
      * PROCESS NEW OFFER                                                       
                  PERFORM 6520-MOVE-RT-PKG-OFFER  THRU 6520-EXIT        
                  PERFORM 8050-INS-RT-PKG-OFFER   THRU 8050-EXIT        
              WHEN CRM-OFFER-UPDATE                                     
      * PROCESS TEMPLATE OFFER IF IT IS A CREATE REPLACE OFFFER WIZARD          
      * AND IF THE TEMPLATE OFFER CODE IS SUPPLIED                              
                  IF CREATE-REPLACE-OFFER-WIZARD                        
                   AND CALL-FRM-WIZARD                                  
                   AND WS-CRM-TEMPLATE-OFFER-CD > SPACES                
                    PERFORM 6522-PROCESS-TMPLT-OFFER                    
                                                  THRU 6522-EXIT        
                  END-IF                                                
                  PERFORM 6520-MOVE-RT-PKG-OFFER  THRU 6520-EXIT        
                  IF CALL-FRM-STATUS-UPDT                               
                     PERFORM 6525-CHG-RT-PKG-OFFER THRU 6525-EXIT       
                  ELSE                                                  
                     PERFORM 8060-UPT-RT-PKG-OFFER THRU 8060-EXIT       
                  END-IF                                                
              END-EVALUATE                                              
                                                                        
      * PROCESS OFFER ASSOCIATES                                                
              PERFORM 6025-PROCESS-OFFER-DTLS     THRU 6025-EXIT        
                                                                        
           END-IF                                                       
                                                                        
           IF CRM-OPTION-CHANGE THEN                                    
                                                                        
      * PROCESS OPTIONS                                                         
              PERFORM VARYING WS-CRM-OPT-INDX FROM 1 BY 1               
                       UNTIL WS-CRM-OPT-INDX > 20                       
              OR WS-CRM-OPTION-KEY-FI(WS-CRM-OPT-INDX) = SPACES         
              OR WS-CRM-OPTION-KEY-FI(WS-CRM-OPT-INDX) = LOW-VALUES     
                                                                        
                  EVALUATE TRUE                                         
                  WHEN CRM-OPTION-INSERT(WS-CRM-OPT-INDX)               
                      PERFORM 6540-MOVE-RT-PKG-OPTION THRU 6540-EXIT    
                      PERFORM 8100-INS-RT-PKG-OPTION  THRU 8100-EXIT    
                  WHEN CRM-OPTION-UPDATE(WS-CRM-OPT-INDX)               
                      PERFORM 6540-MOVE-RT-PKG-OPTION THRU 6540-EXIT    
                      IF CALL-FRM-STATUS-UPDT                           
                         PERFORM 6545-CHG-RT-PKG-OPTION THRU 6545-EXIT  
                      ELSE                                              
                         PERFORM 8110-UPT-RT-PKG-OPTION THRU 8110-EXIT  
                      END-IF                                            
      *        DELETE ONLY NEW OPTION                                           
                  WHEN CRM-OPTION-DELETE(WS-CRM-OPT-INDX)               
                   AND WS-CRM-OPT-PRC-STAT-CD-FI(WS-CRM-OPT-INDX)       
                                            = WS-PROC-STATUS-NEW        
                      PERFORM 6540-MOVE-RT-PKG-OPTION THRU 6540-EXIT    
                      PERFORM 8120-DEL-RT-PKG-OPTION  THRU 8120-EXIT    
                  END-EVALUATE                                          
                                                                        
      * PROCESS OPTION ASSOCIATES                                               
                  PERFORM 6030-PROCESS-OPTION-DTLS    THRU 6030-EXIT    
                                                                        
              END-PERFORM                                               
           END-IF.                                                      
                                                                        
      * PROCESS PROMOTION                                                       
           IF CRM-PROMOTION-CHANGE THEN                                 
                                                                        
              PERFORM VARYING WS-CRM-PROMO-INDX FROM 1 BY 1             
                      UNTIL WS-CRM-PROMO-INDX > 2                       
              OR WS-CRM-PROMO-KEY-KM(WS-CRM-PROMO-INDX) = SPACES        
              OR WS-CRM-PROMO-KEY-KM(WS-CRM-PROMO-INDX) = LOW-VALUES    
                                                                        
                 PERFORM 6510-MOVE-MKT-PROMO         THRU 6510-EXIT     
                                                                        
                 EVALUATE TRUE                                          
                 WHEN CRM-PROMO-INSERT(WS-CRM-PROMO-INDX)               
                     PERFORM 8030-INS-MKT-PROMO      THRU 8030-EXIT     
                 WHEN CRM-PROMO-UPDATE(WS-CRM-PROMO-INDX)               
                     IF CALL-FRM-STATUS-UPDT                            
                        PERFORM 6515-CHG-MKT-PROMO   THRU 6515-EXIT     
                     ELSE                                               
                        PERFORM 8040-UPT-MKT-PROMO   THRU 8040-EXIT     
                     END-IF                                             
      *        DELETE ONLY NEW PROMOTION                                        
                 WHEN CRM-PROMO-DELETE(WS-CRM-PROMO-INDX)               
                   AND WS-CRM-PROMO-PRC-STAT-CD-KM(WS-CRM-PROMO-INDX)   
                                            = WS-PROC-STATUS-NEW        
                      PERFORM 8045-DEL-MKT-PROMO      THRU 8045-EXIT    
                 END-EVALUATE                                           
                                                                        
              END-PERFORM                                               
                                                                        
           END-IF.                                                      
                                                                        
       6020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6025-PROCESS-OFFER-DTLS                                       *         
      *****************************************************************         
       6025-PROCESS-OFFER-DTLS.                                         
                                                                        
      * PROCESS OFFER MARKET TIERS                                              
           PERFORM VARYING WS-CRM-OFFR-TIER-INDX FROM 1 BY 1            
                       UNTIL WS-CRM-OFFR-TIER-INDX > 15                 
            OR WS-CRM-OFFR-TIER-IND-DU(WS-CRM-OFFR-TIER-INDX) = SPACES  
            OR WS-CRM-OFFR-TIER-IND-DU(WS-CRM-OFFR-TIER-INDX)           
                                     = LOW-VALUES                       
                                                                        
               EVALUATE TRUE                                            
               WHEN CRM-OFFR-TIER-INSERT(WS-CRM-OFFR-TIER-INDX)         
                   PERFORM 6530-MOVE-OFF-MKT-TIER THRU 6530-EXIT        
                   PERFORM 8080-INS-OFF-MKT-TIER  THRU 8080-EXIT        
               WHEN CRM-OFFR-TIER-UPDATE(WS-CRM-OFFR-TIER-INDX)         
                   PERFORM 6530-MOVE-OFF-MKT-TIER THRU 6530-EXIT        
                   IF CALL-FRM-STATUS-UPDT                              
                      PERFORM 6532-CHG-OFF-MKT-TIER THRU 6532-EXIT      
                   ELSE                                                 
                      PERFORM 8090-UPT-OFF-MKT-TIER THRU 8090-EXIT      
      * WHEN WE CHANGE THE OFFER START DATE IN MODIFY OFFER WIZARD,             
      * TO UPDATE THE OFF MKT TIER START DATE WILL DELETE THE                   
      * PREVIOUS ROW AND INSERT NEW ROW WITH MODIFIED START DATE.               
                      IF WS-ACTIVE-RETURN-CODE =  NOT-FOUND             
                        IF ((DU-PROC-STATUS-CD = WS-PROC-STATUS-NEW OR  
                                              WS-PROC-STATUS-ERLY-APRVL)
                                           AND DU-OFF-TIER-VRSN-NO = 1) 
                           PERFORM 7005-GET-OFF-MKT-TIER-STRT-DT        
                                                          THRU 7005-EXIT
                           PERFORM 8097-DEL-OFF-MKT-TIER  THRU 8097-EXIT
                           PERFORM 8080-INS-OFF-MKT-TIER  THRU 8080-EXIT
                        END-IF                                          
                      END-IF                                            
                   END-IF                                               
      *        DELETE ONLY NEW OFFER MARKET TIER                                
               WHEN CRM-OFFR-TIER-DELETE(WS-CRM-OFFR-TIER-INDX)         
                AND WS-CRM-OFF-TER-PRC-STAT-CD-DU(WS-CRM-OFFR-TIER-INDX)
                                            = WS-PROC-STATUS-NEW        
                   PERFORM 6530-MOVE-OFF-MKT-TIER THRU 6530-EXIT        
                   PERFORM 8095-DEL-OFF-MKT-TIER  THRU 8095-EXIT        
               END-EVALUATE                                             
                                                                        
           END-PERFORM .                                                
                                                                        
      * PROCESS OFFER ACCESS                                                    
           PERFORM VARYING WS-CRM-OFFR-ACCS-INDX FROM 1 BY 1            
                       UNTIL WS-CRM-OFFR-ACCS-INDX > 05                 
            OR WS-CRM-OFFR-ACCS-IND-CI(WS-CRM-OFFR-ACCS-INDX) = SPACES  
            OR WS-CRM-OFFR-ACCS-IND-CI(WS-CRM-OFFR-ACCS-INDX)           
                                     = LOW-VALUES                       
                                                                        
               EVALUATE TRUE                                            
               WHEN CRM-OFFR-ACCS-INSERT(WS-CRM-OFFR-ACCS-INDX)         
                   PERFORM 6535-MOVE-OFF-ACCESS    THRU 6535-EXIT       
                   PERFORM 8180-INS-ACCESS-OFF-OPT THRU 8180-EXIT       
               WHEN CRM-OFFR-ACCS-UPDATE(WS-CRM-OFFR-ACCS-INDX)         
                   PERFORM 6535-MOVE-OFF-ACCESS    THRU 6535-EXIT       
                   IF CALL-FRM-STATUS-UPDT                              
                      PERFORM 6536-CHG-ACCESS-OFFER   THRU 6536-EXIT    
                   ELSE                                                 
                      PERFORM 8190-UPT-ACCESS-OFF-OPT THRU 8190-EXIT    
      * WHEN WE CHANGE THE OFFER START DATE IN MODIFY OFFER WIZARD,             
      * TO UPDATE THE OFFER ACCESS START DATE WILL DELETE THE                   
      * PREVIOUS ROW AND INSERT NEW ROW WITH MODIFIED START DATE.               
                      IF WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                        IF  (CI-PROC-STATUS-CD = WS-PROC-STATUS-NEW     
                                          OR WS-PROC-STATUS-ERLY-APRVL )
                                                                        
                          PERFORM 7006-GET-ACC-OFF-OPT-STRT-DT          
                                                          THRU 7006-EXIT
                          PERFORM 8196-DEL-ACCESS-OFF-OPT THRU 8196-EXIT
                          PERFORM 8180-INS-ACCESS-OFF-OPT THRU 8180-EXIT
                        END-IF                                          
                      END-IF                                            
                   END-IF                                               
      *        DELETE ONLY NEW OFFER ACCESS                                     
               WHEN CRM-OFFR-ACCS-DELETE(WS-CRM-OFFR-ACCS-INDX)         
                AND WS-CRM-OFF-ACS-PRC-STAT-CD-CI(WS-CRM-OFFR-ACCS-INDX)
                                            = WS-PROC-STATUS-NEW        
                   PERFORM 6535-MOVE-OFF-ACCESS    THRU 6535-EXIT       
                   PERFORM 8195-DEL-ACCESS-OFF-OPT THRU 8195-EXIT       
               END-EVALUATE                                             
                                                                        
           END-PERFORM .                                                
                                                                        
      * PROCESS OFFER RATE GROUP                                                
           PERFORM VARYING WS-CRM-RT-GRP-OFFR-INDX FROM 1 BY 1          
                       UNTIL WS-CRM-RT-GRP-OFFR-INDX > 5 OR             
             WS-CRM-RT-GRP-OFFR-IND-G5(WS-CRM-RT-GRP-OFFR-INDX) = SPACES
             OR WS-CRM-RT-GRP-OFFR-IND-G5(WS-CRM-RT-GRP-OFFR-INDX)      
                                     = LOW-VALUES                       
                                                                        
               EVALUATE TRUE                                            
               WHEN CRM-RT-GRP-OFFR-INSERT(WS-CRM-RT-GRP-OFFR-INDX)     
                   PERFORM 6537-MOVE-RT-GRP-OFFR   THRU 6537-EXIT       
                   PERFORM 8200-INS-RT-GRP-OFFR    THRU 8200-EXIT       
               WHEN CRM-RT-GRP-OFFR-UPDATE(WS-CRM-RT-GRP-OFFR-INDX)     
                   PERFORM 6537-MOVE-RT-GRP-OFFR   THRU 6537-EXIT       
                   IF CALL-FRM-STATUS-UPDT                              
                      PERFORM 6538-CHG-RT-GRP-OFFR THRU 6538-EXIT       
                   ELSE                                                 
                      IF RT-GRP-OFFER-KEY-CHGD                          
                         PERFORM 8217-DEL-RT-GRP-OFFR-BY-VRSN           
                                                   THRU 8217-EXIT       
                         PERFORM 8200-INS-RT-GRP-OFFR                   
                                                   THRU 8200-EXIT       
                      ELSE                                              
                         PERFORM 8210-UPT-RT-GRP-OFFR                   
                                                   THRU 8210-EXIT       
                      END-IF                                            
                   END-IF                                               
      *        DELETE ONLY NEW OFFER RATE GROUP                                 
               WHEN CRM-RT-GRP-OFFR-DELETE(WS-CRM-RT-GRP-OFFR-INDX)     
              AND WS-CRM-GRP-OFF-PRC-STAT-CD-G5(WS-CRM-RT-GRP-OFFR-INDX)
                                            = WS-PROC-STATUS-NEW        
                   PERFORM 6537-MOVE-RT-GRP-OFFR   THRU 6537-EXIT       
                   PERFORM 8215-DEL-RT-GRP-OFFR    THRU 8215-EXIT       
               END-EVALUATE                                             
                                                                        
           END-PERFORM .                                                
                                                                        
       6025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6030-PROCESS-OPTION-DTLS                                      *         
      *****************************************************************         
       6030-PROCESS-OPTION-DTLS.                                        
                                                                        
      * PROCESS OFFER OPTION                                                    
           EVALUATE TRUE                                                
           WHEN CRM-OFFER-OPT-INSERT(WS-CRM-OPT-INDX)                   
               PERFORM 6550-MOVE-OFFER-OPTION THRU 6550-EXIT            
               PERFORM 8130-INS-OFFER-OPTION  THRU 8130-EXIT            
           WHEN CRM-OFFER-OPT-UPDATE(WS-CRM-OPT-INDX)                   
               PERFORM 6550-MOVE-OFFER-OPTION THRU 6550-EXIT            
               IF CALL-FRM-STATUS-UPDT                                  
                  PERFORM 6555-CHG-OFFER-OPTION THRU 6555-EXIT          
               ELSE                                                     
                  PERFORM 8140-UPT-OFFER-OPTION THRU 8140-EXIT          
      * WHEN WE CHANGE THE OFFER START DATE IN MODIFY OFFER WIZARD,             
      * TO UPDATE THE OFFER OPTION START DATE WILL DELETE THE                   
      * PREVIOUS ROW AND INSERT NEW ROW WITH MODIFIED START DATE.               
                  IF WS-ACTIVE-RETURN-CODE =  NOT-FOUND                 
                     IF ((E9-PROC-STATUS-CD = WS-PROC-STATUS-NEW OR     
                                              WS-PROC-STATUS-ERLY-APRVL)
                                           AND E9-OFF-OPT-VRSN-NO = 1)  
                        PERFORM 7007-GET-OFF-OPT-STRT-DT                
                                                       THRU 7007-EXIT   
                        PERFORM 8146-DEL-OFFER-OPTION  THRU 8146-EXIT   
                        PERFORM 8130-INS-OFFER-OPTION  THRU 8130-EXIT   
                     END-IF                                             
                  END-IF                                                
               END-IF                                                   
      *    DELETE ONLY NEW OFFER OPTION                                         
           WHEN CRM-OFFER-OPT-DELETE(WS-CRM-OPT-INDX)                   
            AND WS-CRM-OFF-OPT-PRC-STAT-CD-E9(WS-CRM-OPT-INDX)          
                                            = WS-PROC-STATUS-NEW        
               PERFORM 6550-MOVE-OFFER-OPTION THRU 6550-EXIT            
               PERFORM 8145-DEL-OFFER-OPTION  THRU 8145-EXIT            
           END-EVALUATE                                                 
                                                                        
      * PROCESS OPTION ATTRIBUTES                                               
           PERFORM VARYING WS-CRM-ATTRB-INDX FROM 1 BY 1                
                       UNTIL WS-CRM-ATTRB-INDX > 10                     
               OR WS-CRM-OPT-ATTRB-IND(WS-CRM-OPT-INDX                  
                                      ,WS-CRM-ATTRB-INDX) = SPACES      
               OR WS-CRM-OPT-ATTRB-IND(WS-CRM-OPT-INDX                  
                                      ,WS-CRM-ATTRB-INDX)               
                                     = LOW-VALUES                       
                                                                        
               EVALUATE TRUE                                            
               WHEN CRM-OPT-ATTRB-INSERT(WS-CRM-OPT-INDX ,              
                                             WS-CRM-ATTRB-INDX)         
                   PERFORM 6560-MOVE-OPT-ATTR-INCTV THRU 6560-EXIT      
                   PERFORM 8150-INS-OPT-ATTR-INCTV  THRU 8150-EXIT      
               WHEN CRM-OPT-ATTRB-UPDATE(WS-CRM-OPT-INDX ,              
                                             WS-CRM-ATTRB-INDX)         
                   PERFORM 6560-MOVE-OPT-ATTR-INCTV THRU 6560-EXIT      
                   IF CALL-FRM-STATUS-UPDT                              
                      PERFORM 6562-CHG-OPT-ATTR-INCTV THRU 6562-EXIT    
                   ELSE                                                 
                      PERFORM 8160-UPT-OPT-ATTR-INCTV THRU 8160-EXIT    
      * WHEN WE CHANGE THE OFFER START DATE IN MODIFY OPTION WIZARD,            
      * TO UPDATE THE OPT ATTR INCTV START DATE WILL DELETE THE                 
      * PREVIOUS ROW AND INSERT NEW ROW WITH MODIFIED START DATE.               
                      IF WS-ACTIVE-RETURN-CODE =  NOT-FOUND             
                         IF ((HQ-PROC-STATUS-CD = WS-PROC-STATUS-NEW OR 
                                              WS-PROC-STATUS-ERLY-APRVL)
                                          AND HQ-OPT-ATTR-VRSN-NO = 1)  
                            PERFORM 7008-GET-ATTR-INCTV-START-DT        
                                                       THRU 7008-EXIT   
                            PERFORM 8171-DEL-OPT-ATTR-INCTV             
                                                       THRU 8171-EXIT   
                            PERFORM 8150-INS-OPT-ATTR-INCTV             
                                                       THRU 8150-EXIT   
                         END-IF                                         
                      END-IF                                            
                   END-IF                                               
      *        DELETE ONLY NEW OPTION ATTRIBUTES                                
               WHEN CRM-OPT-ATTRB-DELETE(WS-CRM-OPT-INDX ,              
                                             WS-CRM-ATTRB-INDX)         
                AND WS-CRM-OPT-ATRB-PRC-STAT-CD-HQ(WS-CRM-OPT-INDX      
                                                 , WS-CRM-ATTRB-INDX)   
                                            = WS-PROC-STATUS-NEW        
                   PERFORM 6560-MOVE-OPT-ATTR-INCTV THRU 6560-EXIT      
                   PERFORM 8170-DEL-OPT-ATTR-INCTV  THRU 8170-EXIT      
               END-EVALUATE                                             
                                                                        
           END-PERFORM .                                                
                                                                        
      * PROCESS OPTION ACCESS                                                   
           PERFORM VARYING WS-CRM-OPTN-ACCS-INDX FROM 1 BY 1            
                       UNTIL WS-CRM-OPTN-ACCS-INDX > 05                 
            OR WS-CRM-OPTN-ACCS-IND-CI(WS-CRM-OPT-INDX                  
                                      ,WS-CRM-OPTN-ACCS-INDX) = SPACES  
            OR WS-CRM-OPTN-ACCS-IND-CI(WS-CRM-OPT-INDX                  
                                      ,WS-CRM-OPTN-ACCS-INDX)           
                                     = LOW-VALUES                       
                                                                        
               EVALUATE TRUE                                            
               WHEN CRM-OPTN-ACCS-INSERT(WS-CRM-OPT-INDX ,              
                                         WS-CRM-OPTN-ACCS-INDX)         
                   PERFORM 6565-MOVE-OPT-ACCESS    THRU 6565-EXIT       
                   PERFORM 8180-INS-ACCESS-OFF-OPT THRU 8180-EXIT       
               WHEN CRM-OPTN-ACCS-UPDATE(WS-CRM-OPT-INDX ,              
                                         WS-CRM-OPTN-ACCS-INDX)         
                   PERFORM 6565-MOVE-OPT-ACCESS    THRU 6565-EXIT       
                   IF CALL-FRM-STATUS-UPDT                              
                      PERFORM 6567-CHG-ACCESS-OPTION  THRU 6567-EXIT    
                   ELSE                                                 
                      PERFORM 8190-UPT-ACCESS-OFF-OPT THRU 8190-EXIT    
      * WHEN WE CHANGE THE OFFER START DATE IN MODIFY OFFER WIZARD,             
      * TO UPDATE THE OFFER ACCESS START DATE WILL DELETE THE                   
      * PREVIOUS ROW AND INSERT NEW ROW WITH MODIFIED START DATE.               
                      IF WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                        IF  (CI-PROC-STATUS-CD = WS-PROC-STATUS-NEW     
                                        OR WS-PROC-STATUS-ERLY-APRVL)   
                          PERFORM 7006-GET-ACC-OFF-OPT-STRT-DT          
                                                          THRU 7006-EXIT
                          PERFORM 8196-DEL-ACCESS-OFF-OPT THRU 8196-EXIT
                          PERFORM 8180-INS-ACCESS-OFF-OPT THRU 8180-EXIT
                        END-IF                                          
                      END-IF                                            
                   END-IF                                               
      *        DELETE ONLY NEW OPTION ACCESS                                    
               WHEN CRM-OPTN-ACCS-DELETE(WS-CRM-OPT-INDX ,              
                                         WS-CRM-OPTN-ACCS-INDX)         
                AND WS-CRM-OPT-ACS-PRC-STAT-CD-CI(WS-CRM-OPT-INDX ,     
                                              WS-CRM-OPTN-ACCS-INDX)    
                                            = WS-PROC-STATUS-NEW        
                   PERFORM 6565-MOVE-OPT-ACCESS    THRU 6565-EXIT       
                   PERFORM 8195-DEL-ACCESS-OFF-OPT THRU 8195-EXIT       
               END-EVALUATE                                             
                                                                        
           END-PERFORM .                                                
                                                                        
       6030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6510-MOVE-MKT-PROMO.                                          *         
      *****************************************************************         
       6510-MOVE-MKT-PROMO.                                             
                                                                        
           MOVE WS-CRM-COMPANY-NO                                       
                                       TO KM-COMPANY-NO                 
           MOVE WS-CRM-PROMO-CD-KM(WS-CRM-PROMO-INDX)                   
                                       TO KM-PROMO-CD                   
           MOVE WS-CRM-PROMO-DESC-KM(WS-CRM-PROMO-INDX)                 
                                       TO KM-PROMO-DESC                 
           MOVE WS-CRM-OFFER-CD-KM(WS-CRM-PROMO-INDX)                   
                                       TO KM-OFFER-CD                   
           MOVE WS-CRM-MKT-PLAN-CD-KM(WS-CRM-PROMO-INDX)                
                                       TO KM-MKT-PLAN-CD                
           MOVE WS-CRM-PROMO-START-DT-KM(WS-CRM-PROMO-INDX)             
                                       TO KM-PROMO-START-DT             
           MOVE WS-CRM-PROMO-START-TM-KM(WS-CRM-PROMO-INDX)             
                                       TO KM-PROMO-START-TM             
           MOVE WS-CRM-PROMO-END-DT-KM(WS-CRM-PROMO-INDX)               
                                       TO KM-PROMO-END-DT               
           MOVE WS-CRM-PROMO-END-TM-KM(WS-CRM-PROMO-INDX)               
                                       TO KM-PROMO-END-TM               
           MOVE WS-CRM-AD-CHANNEL-CD-KM(WS-CRM-PROMO-INDX)              
                                       TO KM-AD-CHANNEL-CD              
           MOVE WS-CRM-PROMO-DESC-LONG-LEN-KM(WS-CRM-PROMO-INDX)        
                                       TO WS-SMALLINT-NUM               
           MOVE WS-SMALLINT-NUM        TO KM-PROMO-DESC-LONG-LEN        
           MOVE WS-CRM-PROMO-DESC-LONG-TXT-KM(WS-CRM-PROMO-INDX)        
                                       TO KM-PROMO-DESC-LONG-TEXT       
           MOVE WS-CRM-EXT-LNDG-PG-URL-LEN-KM(WS-CRM-PROMO-INDX)        
                                       TO WS-SMALLINT-NUM               
           MOVE WS-SMALLINT-NUM        TO KM-EXT-LANDING-PG-URL-LEN     
           MOVE WS-CRM-EXT-LNDG-PG-URL-TXT-KM(WS-CRM-PROMO-INDX)        
                                       TO KM-EXT-LANDING-PG-URL-TEXT    
           MOVE 'RT'                   TO KM-PROMO-TYPE-CD              
           MOVE WS-CRM-WEB-IMG-FILE-NM-LEN-KM(WS-CRM-PROMO-INDX)        
                                       TO WS-SMALLINT-NUM               
           MOVE WS-SMALLINT-NUM        TO KM-WEB-IMAGE-FILE-NM-LEN      
           MOVE WS-CRM-WEB-IMG-FILE-NM-TXT-KM(WS-CRM-PROMO-INDX)        
                                       TO KM-WEB-IMAGE-FILE-NM-TEXT     
           MOVE WS-CRM-USER-ID         TO KM-LAST-UPDATE-USERID         
           MOVE WS-CRM-CURRENT-TIMESTAMP                                
                                       TO KM-LAST-UPDATE-TS             
           MOVE WS-CRM-REPLACMNT-PROMO-CD-KM(WS-CRM-PROMO-INDX)         
                                       TO KM-REPLACMNT-PROMO-CD         
           MOVE WS-CRM-DISPLAY-END-DT-KM(WS-CRM-PROMO-INDX)             
                                       TO KM-DISPLAY-END-DT             
           MOVE WS-CRM-INT-LNDG-PG-URL-LEN-KM(WS-CRM-PROMO-INDX)        
                                       TO WS-SMALLINT-NUM               
           MOVE WS-SMALLINT-NUM        TO KM-INT-LANDING-PG-URL-LEN.    
           MOVE WS-CRM-INT-LNDG-PG-URL-TXT-KM(WS-CRM-PROMO-INDX)        
                                       TO KM-INT-LANDING-PG-URL-TEXT.   
           MOVE WS-CRM-PROC-REQ-ID     TO KM-PROC-REQ-ID                
           MOVE WS-CRM-VRSN-TIMESTAMP  TO KM-PROMO-VSTART-TS            
           IF CRM-PROMO-INSERT(WS-CRM-PROMO-INDX)                       
              PERFORM 7130-GET-PROMO-MAX-VRSN THRU 7130-EXIT            
              ADD +1                         TO WS-MAX-PROC-VRSN-NO     
              MOVE WS-MAX-PROC-VRSN-NO       TO WS-PROC-VRSN-NO         
              MOVE WS-INFINITE-TS            TO KM-PROMO-VEND-TS        
           ELSE                                                         
              MOVE WS-CRM-PROMO-VRSN-NO-KM(WS-CRM-PROMO-INDX)           
                                             TO WS-SMALLINT-NUM         
              MOVE WS-SMALLINT-NUM           TO WS-PROC-VRSN-NO         
      *       MOVE WS-CRM-PROMO-PRC-REQ-ID-KM(WS-CRM-PROMO-INDX)                
      *                                      TO WS-DECIMAL-10V0-NUM             
      *       MOVE WS-DECIMAL-10V0-NUM       TO KM-PROC-REQ-ID                  
      *       MOVE WS-CRM-PROMO-VSTART-TS-KM(WS-CRM-PROMO-INDX)                 
      *                                      TO KM-PROMO-VSTART-TS              
              MOVE WS-CRM-PROMO-VEND-TS-KM(WS-CRM-PROMO-INDX)           
                                             TO KM-PROMO-VEND-TS        
           END-IF.                                                      
           MOVE WS-PROC-VRSN-NO              TO KM-PROMO-VRSN-NO        
           MOVE WS-CRM-PROMO-PRC-STAT-CD-KM(WS-CRM-PROMO-INDX)          
                                             TO KM-PROC-STATUS-CD.      
                                                                        
       6510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6515-CHG-MKT-PROMO                                            *         
      * WHEN IT IS UPDATE BASED ON PROC STATUS UPATE THE OFFER                  
      * WHEN THE STATUS IS APRVL COMPLETE UPDATE THE PREVIOUS  VERSION          
      * END TS WITH CURRENT VERSION START TS - 1 MICORSECOND                    
      * THAT MAKES THE PREVIOUS VERSION EXPIRED AND MAKE THE CURRENT            
      * VERSION ACTIVE                                                          
      *****************************************************************         
       6515-CHG-MKT-PROMO.                                              
                                                                        
           MOVE ZERO                         TO WS-MAX-APRVL-VRSN       
                                                WS-MAX-APRVL-VRSN-NULL. 
                                                                        
           EVALUATE WS-CRM-PROMO-PRC-STAT-CD-KM(WS-CRM-PROMO-INDX)      
              WHEN WS-PROC-STATUS-NEW                                   
              WHEN WS-PROC-STATUS-PEND-APRVL                            
              WHEN WS-PROC-STATUS-ERLY-APRVL                            
                   PERFORM 8044-UPT-MKT-PROMO-STATUS                    
                                                THRU 8044-EXIT          
              WHEN WS-PROC-STATUS-APRVL-CMPLT                           
                   PERFORM 7135-GET-PROMO-MAX-APRVL-VRSN                
                                                THRU 7135-EXIT          
                   IF WS-MAX-APRVL-VRSN > 0                             
                      PERFORM 8042-UPT-MKT-PROMO-VENDTS                 
                                                THRU 8042-EXIT          
                   END-IF                                               
                   PERFORM 8044-UPT-MKT-PROMO-STATUS                    
                                                THRU 8044-EXIT          
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
                                                                        
       6515-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 6520-MOVE-RT-PKG-OFFER.                                       *         
      *****************************************************************         
       6520-MOVE-RT-PKG-OFFER.                                          
                                                                        
           MOVE WS-CRM-COMPANY-NO            TO FG-COMPANY-NO           
           MOVE WS-CRM-OFFER-CD-FG           TO FG-OFFER-CD             
           MOVE WS-CRM-OFFER-DESC-INT-FG     TO FG-OFFER-DESC-INT       
           MOVE WS-CRM-OFFER-DESC-EXT-FG     TO FG-OFFER-DESC-EXT       
           MOVE WS-CRM-PROMO-CD-INT-FL-FG    TO FG-PROMO-CD-INT-FL      
           MOVE WS-CRM-PROMO-CD-EXT-FL-FG    TO FG-PROMO-CD-EXT-FL      
           MOVE WS-CRM-OFFER-START-DT-FG     TO FG-OFFER-START-DT       
           MOVE WS-CRM-OFFER-END-DT-FG       TO FG-OFFER-END-DT         
           MOVE WS-CRM-DISP-START-INT-TS-FG  TO FG-DISP-START-INT-TS    
           MOVE WS-CRM-DISP-END-INT-TS-FG    TO FG-DISP-END-INT-TS      
           MOVE WS-CRM-DISP-START-EXT-TS-FG  TO FG-DISP-START-EXT-TS    
           MOVE WS-CRM-DISP-END-EXT-TS-FG    TO FG-DISP-END-EXT-TS      
           MOVE WS-CRM-CURRENT-TIMESTAMP     TO FG-LAST-UPDATE-TS       
           MOVE WS-CRM-USER-ID               TO FG-LAST-UPDATE-USERID   
           MOVE WS-CRM-OFFR-DSC-INT-LNG-LEN-FG                          
                                             TO WS-SMALLINT-NUM         
           MOVE WS-SMALLINT-NUM          TO FG-OFFER-DESC-INT-LNG-LEN   
           MOVE WS-CRM-OFFR-DSC-INT-LNG-TXT-FG                          
                                         TO FG-OFFER-DESC-INT-LNG-TEXT  
           MOVE WS-CRM-OFFR-DSC-EXT-LNG-LEN-FG                          
                                             TO WS-SMALLINT-NUM         
           MOVE WS-SMALLINT-NUM          TO FG-OFFER-DESC-EXT-LNG-LEN   
           MOVE WS-CRM-OFFR-DSC-EXT-LNG-TXT-FG                          
                                         TO FG-OFFER-DESC-EXT-LNG-TEXT  
           MOVE WS-CRM-SPCL-OFFER-TYPE-CD-FG TO FG-SPCL-OFFER-TYPE-CD   
           MOVE WS-CRM-RENEWAL-OFFER-CD-FG   TO FG-RENEWAL-OFFER-CD     
           MOVE WS-CRM-RENEW-PUB-OFFER-CD-FG TO FG-RENEW-PUB-OFFER-CD.  
           MOVE WS-CRM-PROC-REQ-ID           TO FG-PROC-REQ-ID          
           MOVE WS-CRM-VRSN-TIMESTAMP        TO FG-OFF-VSTART-TS        
           IF CRM-OFFER-INSERT                                          
              PERFORM 7110-GET-OFFER-MAX-VRSN THRU 7110-EXIT            
              ADD +1                         TO WS-MAX-PROC-VRSN-NO     
              MOVE WS-MAX-PROC-VRSN-NO       TO WS-PROC-VRSN-NO         
              MOVE WS-INFINITE-TS            TO FG-OFF-VEND-TS          
           ELSE                                                         
              MOVE WS-CRM-OFF-VRSN-NO-FG     TO WS-SMALLINT-NUM         
              MOVE WS-SMALLINT-NUM           TO WS-PROC-VRSN-NO         
              MOVE WS-CRM-OFF-VEND-TS-FG     TO FG-OFF-VEND-TS          
           END-IF.                                                      
           MOVE WS-PROC-VRSN-NO              TO FG-OFF-VRSN-NO.         
           MOVE WS-CRM-OFF-PRC-STAT-CD-FG    TO FG-PROC-STATUS-CD.      
PRJ680     MOVE WS-CRM-MAX-PRICE-OFFER-CD-FG TO FG-MAX-PRICE-OFFER-CD.  
P00863     MOVE WS-CRM-RTCHG-PUB-OFFER-CD-FG TO FG-RTCHG-PUB-OFFER-CD.  
                                                                        
       6520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6522-PROCESS-TMPLT-OFFER.                                     *         
      *****************************************************************         
       6522-PROCESS-TMPLT-OFFER.                                        
                                                                        
           MOVE WS-CRM-COMPANY-NO            TO FG-COMPANY-NO           
           MOVE WS-CRM-TEMPLATE-OFFER-CD     TO FG-OFFER-CD             
           MOVE WS-CRM-PROC-REQ-ID           TO FG-PROC-REQ-ID          
                                                                        
           PERFORM 7015-CHK-TMPLT-OFFR-EXISTS   THRU 7015-EXIT          
                                                                        
           IF SET-PROMO-INT-EXT-FLGS                                    
                                                                        
      * IF PROMO INT EXT FLAG IS SET AND TEMPLATE OFFER NOT EXISTS              
      * THEN INSERT THE TEMPLATE OFFER CHANGES                                  
              IF WS-TMPLT-OFFER-EXISTS  = 'N'                           
                                                                        
                 PERFORM 7010-SELECT-TEMPLATE-OFFER THRU 7010-EXIT      
                                                                        
      * IF EITHER OF PROMO INTERNAL OR EXTERNAL IS 'N' THEN MAKE                
      * THEM TO 'Y'                                                             
                 IF FG-PROMO-CD-INT-FL = WS-NO                          
                  OR FG-PROMO-CD-EXT-FL = WS-NO                         
                    MOVE WS-YES                TO FG-PROMO-CD-INT-FL    
                                                  FG-PROMO-CD-EXT-FL    
                    MOVE WS-CRM-PROC-REQ-ID    TO FG-PROC-REQ-ID        
                    MOVE WS-CRM-VRSN-TIMESTAMP TO FG-OFF-VSTART-TS      
                    MOVE WS-INFINITE-TS        TO FG-OFF-VEND-TS        
                    ADD  +1                    TO FG-OFF-VRSN-NO        
                    MOVE WS-CRM-OFF-PRC-STAT-CD-FG                      
                                               TO FG-PROC-STATUS-CD     
                    MOVE WS-CRM-USER-ID        TO FG-LAST-UPDATE-USERID 
                    MOVE WS-CRM-CURRENT-TIMESTAMP                       
                                               TO FG-LAST-UPDATE-TS     
                    PERFORM 8050-INS-RT-PKG-OFFER THRU 8050-EXIT        
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
      * IF PROMO INT EXT FLAG IS NOT SET AND TEMPLATE OFFER ALREADY             
      * EXISTS THEN DELETE THE TEMPLATE OFFER CHANGES                           
              IF WS-TMPLT-OFFER-EXISTS = 'Y'                            
                 PERFORM 8065-DEL-RT-PKG-OFFER     THRU 8065-EXIT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
      * PROCESS UNDEFAULT TEMPLATE OFFER MARKET TIERS                           
           PERFORM 6534-PROCESS-TMPLT-OFF-TIER    THRU 6534-EXIT.       
                                                                        
       6522-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6525-CHG-RT-PKG-OFFER.                                        *         
      * WHEN IT IS UPDATE BASED ON PROC STATUS UPATE THE OFFER                  
      * WHEN THE STATUS IS APRVL COMPLETE UPDATE THE PREVIOUS  VERSION          
      * END TS WITH CURRENT VERSION START TS - 1 MICORSECOND                    
      * THAT MAKES THE PREVIOUS VERSION EXPIRED AND MAKE THE CURRENT            
      * VERSION ACTIVE                                                          
      *****************************************************************         
       6525-CHG-RT-PKG-OFFER.                                           
                                                                        
           MOVE ZERO                         TO WS-MAX-APRVL-VRSN       
                                                WS-MAX-APRVL-VRSN-NULL. 
                                                                        
           EVALUATE WS-CRM-OFF-PRC-STAT-CD-FG                           
              WHEN WS-PROC-STATUS-NEW                                   
              WHEN WS-PROC-STATUS-PEND-APRVL                            
              WHEN WS-PROC-STATUS-ERLY-APRVL                            
                   PERFORM 8075-UPT-RT-PKG-OFFER-STATUS                 
                                                THRU 8075-EXIT          
              WHEN WS-PROC-STATUS-APRVL-CMPLT                           
                   PERFORM 7115-GET-OFFER-MAX-APRVL-VRSN                
                                                THRU 7115-EXIT          
                   IF WS-MAX-APRVL-VRSN > 0                             
                      PERFORM 8070-UPT-RT-PKG-OFFER-VENDTS              
                                                THRU 8070-EXIT          
                   END-IF                                               
                   PERFORM 8075-UPT-RT-PKG-OFFER-STATUS                 
                                                THRU 8075-EXIT          
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
                                                                        
       6525-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 6530-MOVE-OFF-MKT-TIER.                                       *         
      *****************************************************************         
       6530-MOVE-OFF-MKT-TIER.                                          
                                                                        
           MOVE WS-CRM-COMPANY-NO            TO DU-COMPANY-NO           
                                                                        
           MOVE WS-CRM-OFFER-CD-DU(WS-CRM-OFFR-TIER-INDX)               
                                             TO DU-OFFER-CD             
           MOVE WS-CRM-TIER-CUST-STAT-CD-DU(WS-CRM-OFFR-TIER-INDX)      
                                             TO DU-TIER-CUST-STAT-CD    
           MOVE WS-CRM-TIER-ACCT-TYPE-CD-DU(WS-CRM-OFFR-TIER-INDX)      
                                             TO DU-TIER-ACCT-TYPE-CD    
           MOVE WS-CRM-MKT-TIER-RANKING-DU(WS-CRM-OFFR-TIER-INDX)       
                                             TO WS-SMALLINT-NUM         
           MOVE WS-SMALLINT-NUM              TO DU-MKT-TIER-RANKING     
                                                                        
      * GET THE MARKET TIER START DATE FOR THE NEW OFFER MKT TIER               
      * ONLY WHEN THE VERSION NUMBER IS ZERO OR ONE                             
           IF CRM-OFFR-TIER-INSERT(WS-CRM-OFFR-TIER-INDX)               
            AND WS-CRM-OFF-TER-VRSN-NO-DU(WS-CRM-OFFR-TIER-INDX) <= 1   
              MOVE WS-CRM-COMPANY-NO         TO IG-COMPANY-NO           
              MOVE DU-TIER-CUST-STAT-CD      TO IG-TIER-CUST-STAT-CD    
              MOVE DU-TIER-ACCT-TYPE-CD      TO IG-TIER-ACCT-TYPE-CD    
              MOVE DU-MKT-TIER-RANKING       TO IG-MKT-TIER-RANKING     
              PERFORM 7000-GET-MKT-TIER-START-DT                        
                                             THRU 7000-EXIT             
              MOVE IG-MKT-TIER-START-DT      TO DU-MKT-TIER-START-DT    
           ELSE                                                         
              MOVE WS-CRM-MKT-TIER-START-DT-DU(WS-CRM-OFFR-TIER-INDX)   
                                             TO DU-MKT-TIER-START-DT    
           END-IF.                                                      
                                                                        
           MOVE WS-CRM-OFFER-TIER-STRT-DT-DU(WS-CRM-OFFR-TIER-INDX)     
                                             TO DU-OFFER-TIER-STRT-DT   
           MOVE WS-CRM-MKT-TIER-APPLY-CD-DU(WS-CRM-OFFR-TIER-INDX)      
                                             TO DU-MKT-TIER-APPLY-CD    
           MOVE WS-CRM-TIER-DEFLT-OFFR-CD-DU(WS-CRM-OFFR-TIER-INDX)     
                                             TO DU-TIER-DEFLT-OFFR-CD   
           MOVE WS-CRM-OFFER-TIER-END-DT-DU(WS-CRM-OFFR-TIER-INDX)      
                                             TO DU-OFFER-TIER-END-DT    
           MOVE WS-CRM-USER-ID               TO DU-LAST-UPDATE-USERID   
           MOVE WS-CRM-CURRENT-TIMESTAMP     TO DU-LAST-UPDATE-TS.      
           MOVE WS-CRM-PROC-REQ-ID           TO DU-PROC-REQ-ID          
           MOVE WS-CRM-VRSN-TIMESTAMP        TO DU-OFF-TIER-VSTART-TS   
                                                                        
      * GET THE MAX OFFER TIER VERSION AND INCRMENT BY +1 WHEN IT IS            
      * INSERT AND SET VRNS START WITH CRM VRSN AND VRSN END AS INFINITE        
           IF CRM-OFFR-TIER-INSERT(WS-CRM-OFFR-TIER-INDX)               
              PERFORM 7140-GET-OFFER-TIER-MAX-VRSN                      
                                             THRU 7140-EXIT             
              ADD +1                         TO WS-MAX-PROC-VRSN-NO     
              MOVE WS-MAX-PROC-VRSN-NO       TO WS-PROC-VRSN-NO         
              MOVE WS-INFINITE-TS            TO DU-OFF-TIER-VEND-TS     
           ELSE                                                         
              MOVE WS-CRM-OFF-TER-VRSN-NO-DU(WS-CRM-OFFR-TIER-INDX)     
                                             TO WS-SMALLINT-NUM         
              MOVE WS-SMALLINT-NUM           TO WS-PROC-VRSN-NO         
      *       MOVE WS-CRM-OFF-TER-PRC-REQ-ID-DU(WS-CRM-OFFR-TIER-INDX)          
      *                                      TO WS-DECIMAL-10V0-NUM             
      *       MOVE WS-DECIMAL-10V0-NUM       TO DU-PROC-REQ-ID                  
      *       MOVE WS-CRM-OFF-TER-VSTART-TS-DU(WS-CRM-OFFR-TIER-INDX)           
      *                                      TO DU-OFF-TIER-VSTART-TS           
              MOVE WS-CRM-OFF-TER-VEND-TS-DU(WS-CRM-OFFR-TIER-INDX)     
                                             TO DU-OFF-TIER-VEND-TS     
           END-IF.                                                      
                                                                        
           MOVE WS-PROC-VRSN-NO              TO DU-OFF-TIER-VRSN-NO.    
           MOVE WS-CRM-OFF-TER-PRC-STAT-CD-DU(WS-CRM-OFFR-TIER-INDX)    
                                             TO DU-PROC-STATUS-CD.      
                                                                        
       6530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6532-CHG-OFF-MKT-TIER.                                        *         
      * WHEN IT IS UPDATE BASED ON PROC STATUS UPATE THE OFFER MKT TIER         
      * WHEN THE STATUS IS APRVL COMPLETE UPDATE THE PREVIOUS  VERSION          
      * END TS WITH CURRENT VERSION START TS - 1 MICORSECOND                    
      * THAT MAKES THE PREVIOUS VERSION EXPIRED AND MAKE THE CURRENT            
      * VERSION ACTIVE                                                          
      *****************************************************************         
       6532-CHG-OFF-MKT-TIER.                                           
                                                                        
           MOVE ZERO                         TO WS-MAX-APRVL-VRSN       
                                                WS-MAX-APRVL-VRSN-NULL. 
                                                                        
           EVALUATE WS-CRM-OFF-TER-PRC-STAT-CD-DU(WS-CRM-OFFR-TIER-INDX)
              WHEN WS-PROC-STATUS-NEW                                   
              WHEN WS-PROC-STATUS-PEND-APRVL                            
              WHEN WS-PROC-STATUS-ERLY-APRVL                            
                   PERFORM 8094-UPT-OFF-MKT-TIER-STATUS                 
                                                THRU 8094-EXIT          
              WHEN WS-PROC-STATUS-APRVL-CMPLT                           
                   PERFORM 7145-GET-OFF-MKT-MAX-AC-VRSN                 
                                                THRU 7145-EXIT          
                   IF WS-MAX-APRVL-VRSN > 0                             
                      PERFORM 8092-UPT-OFF-MKT-TIER-VENDTS              
                                                THRU 8092-EXIT          
                   END-IF                                               
                   PERFORM 8094-UPT-OFF-MKT-TIER-STATUS                 
                                                THRU 8094-EXIT          
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
                                                                        
       6532-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6534-PROCESS-TMPLT-OFF-TIER                                   *         
      * WHEN IT IS CREATE REPLACE OFFER WIZARD AND UNDEFAULT TEMPLATE           
      * OFFER TIER IS SET, CHECK IF THE OFFER TIER IS DEFAULT TIER              
      * THEN INSERT NEW ROW TO UNDEFAULT THE OFFER TIER                         
      *****************************************************************         
       6534-PROCESS-TMPLT-OFF-TIER.                                     
                                                                        
           MOVE WS-CRM-COMPANY-NO            TO DU-COMPANY-NO           
           MOVE WS-CRM-TEMPLATE-OFFER-CD     TO DU-OFFER-CD             
           MOVE WS-CRM-PROC-REQ-ID           TO DU-PROC-REQ-ID          
                                                                        
           MOVE WS-NO                   TO WS-TMPLT-OFFMKT-TIER-EXISTS  
           PERFORM 7025-CHK-TMPLT-OFF-MKT-EXISTS                        
                                                THRU 7025-EXIT          
                                                                        
      * IF UNDEFAULT TEMPALTE OFFER IS SET AND OFFER TIER CHANGES NOT           
      * EXISTS THEN INSERT THE TEMPLATE OFFER MARKET TIER CHANGES               
           IF UNDEFAULT-TMPLT-OFFER-TIERS                               
             IF WS-TMPLT-OFFMKT-TIER-EXISTS = WS-NO                     
                                                                        
      * GET TEMPLATE OFFER MARKET TIERS TO UNDEFAULT THEM                       
               MOVE 'N'                TO WS-NO-MORE-OFFER-TIER-ROWS    
               PERFORM 7021-OPEN-UNDEFLT-OFFR-TIERS    THRU 7021-EXIT   
               PERFORM 7022-FETCH-UNDEFLT-OFFR-TIERS   THRU 7022-EXIT   
                                                                        
               PERFORM UNTIL NO-MORE-OFFER-TIER-ROWS                    
      * IF DEFAULT OFFER CODE IS 'Y' THEN MAKE IT 'N'                           
                 IF DU-TIER-DEFLT-OFFR-CD = WS-YES                      
                    MOVE WS-NO                  TO DU-TIER-DEFLT-OFFR-CD
                    ADD  +1                     TO DU-OFF-TIER-VRSN-NO  
                    MOVE WS-CRM-VRSN-TIMESTAMP  TO DU-OFF-TIER-VSTART-TS
                    MOVE WS-INFINITE-TS         TO DU-OFF-TIER-VEND-TS  
                    MOVE WS-PROC-STATUS-NEW     TO DU-PROC-STATUS-CD    
                    MOVE WS-CRM-PROC-REQ-ID     TO DU-PROC-REQ-ID       
                    MOVE WS-CRM-USER-ID         TO DU-LAST-UPDATE-USERID
                    MOVE WS-CRM-CURRENT-TIMESTAMP                       
                                                TO DU-LAST-UPDATE-TS    
                    PERFORM 8080-INS-OFF-MKT-TIER  THRU 8080-EXIT       
                 END-IF                                                 
                                                                        
                 PERFORM 7022-FETCH-UNDEFLT-OFFR-TIERS THRU 7022-EXIT   
                                                                        
               END-PERFORM                                              
                                                                        
               PERFORM 7023-CLOSE-UNDEFLT-OFFR-TIERS THRU 7023-EXIT     
             END-IF                                                     
           ELSE                                                         
      * IF UNDEFAULT TEMPALTE OFFER IS NOT SET AND OFFER TIER CHANGES           
      * EXISTS THEN DELETE THE TEMPLATE OFFER MARKET TIER CHANGES               
              IF WS-TMPLT-OFFMKT-TIER-EXISTS = WS-YES                   
                 PERFORM 8096-DEL-TMPLT-OFF-MKT-TIER THRU 8096-EXIT     
              END-IF                                                    
           END-IF.                                                      
                                                                        
       6534-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6535-MOVE-OFF-ACCESS.                                         *         
      *****************************************************************         
       6535-MOVE-OFF-ACCESS.                                            
                                                                        
           MOVE WS-CRM-COMPANY-NO            TO CI-COMPANY-NO           
                                                                        
           MOVE WS-CRM-OFFR-OPTION-CD-CI(WS-CRM-OFFR-ACCS-INDX)         
                                             TO CI-OPTION-CD            
           MOVE WS-CRM-OFFR-OFFER-CD-CI(WS-CRM-OFFR-ACCS-INDX)          
                                             TO CI-OFFER-CD             
           MOVE WS-CRM-OFFR-CATEGORY-ID-CI(WS-CRM-OFFR-ACCS-INDX)       
                                             TO WS-INTEGER-NUM          
           MOVE WS-INTEGER-NUM               TO CI-CATEGORY-ID          
                                                                        
           MOVE WS-CRM-OFFR-ACCES-START-DT-CI(WS-CRM-OFFR-ACCS-INDX)    
                                             TO CI-ACCESS-START-DT      
           MOVE WS-CRM-OFFR-ACCESS-END-DT-CI(WS-CRM-OFFR-ACCS-INDX)     
                                             TO CI-ACCESS-END-DT        
           MOVE WS-CRM-OFFR-VIEW-APPLY-CD-CI(WS-CRM-OFFR-ACCS-INDX)     
                                             TO CI-VIEW-APPLY-CD        
           MOVE WS-CRM-USER-ID               TO CI-LAST-UPDATE-USERID   
           MOVE WS-CRM-CURRENT-TIMESTAMP     TO CI-LAST-UPDATE-TS       
           MOVE WS-CRM-OFFR-COMMENTS-TX-CI(WS-CRM-OFFR-ACCS-INDX)       
                                             TO CI-COMMENTS-TX.         
           MOVE WS-CRM-PROC-REQ-ID           TO CI-PROC-REQ-ID          
           MOVE WS-CRM-VRSN-TIMESTAMP        TO CI-ACCESS-VSTART-TS     
           IF CRM-OFFR-ACCS-INSERT(WS-CRM-OFFR-ACCS-INDX)               
              PERFORM 7150-GET-CRM-ACCESS-MAX-VRSN                      
                                             THRU 7150-EXIT             
              ADD +1                         TO WS-MAX-PROC-VRSN-NO     
              MOVE WS-MAX-PROC-VRSN-NO       TO WS-PROC-VRSN-NO         
              MOVE WS-INFINITE-TS            TO CI-ACCESS-VEND-TS       
           ELSE                                                         
              MOVE WS-CRM-OFF-ACS-VRSN-NO-CI(WS-CRM-OFFR-ACCS-INDX)     
                                             TO WS-SMALLINT-NUM         
              MOVE WS-SMALLINT-NUM           TO WS-PROC-VRSN-NO         
      *       MOVE WS-CRM-OFF-ACS-PRC-REQ-ID-CI(WS-CRM-OFFR-ACCS-INDX)          
      *                                      TO WS-DECIMAL-10V0-NUM             
      *       MOVE WS-DECIMAL-10V0-NUM       TO CI-PROC-REQ-ID                  
      *       MOVE WS-CRM-OFF-ACS-VSTART-TS-CI(WS-CRM-OFFR-ACCS-INDX)           
      *                                      TO CI-ACCESS-VSTART-TS             
              MOVE WS-CRM-OFF-ACS-VEND-TS-CI(WS-CRM-OFFR-ACCS-INDX)     
                                             TO CI-ACCESS-VEND-TS       
           END-IF.                                                      
                                                                        
           MOVE WS-PROC-VRSN-NO              TO CI-ACCESS-VRSN-NO.      
      *    MOVE CI-ACCESS-START-DT           TO WS-DATE-PART.                   
      *    MOVE WS-DATE-TIMESTAMP            TO CI-ACCESS-VSTART-TS.            
      *    MOVE CI-ACCESS-END-DT             TO WS-DATE-PART.                   
      *    MOVE WS-DATE-TIMESTAMP            TO CI-ACCESS-VEND-TS.              
           MOVE WS-CRM-OFF-ACS-PRC-STAT-CD-CI(WS-CRM-OFFR-ACCS-INDX)    
                                             TO CI-PROC-STATUS-CD.      
                                                                        
       6535-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6536-CHG-ACCESS-OFFER                                         *         
      * WHEN IT IS UPDATE BASED ON PROC STATUS UPATE THE OFFER ACCESS           
      * WHEN THE STATUS IS APRVL COMPLETE UPDATE THE PREVIOUS  VERSION          
      * END TS WITH CURRENT VERSION START TS - 1 MICORSECOND                    
      * THAT MAKES THE PREVIOUS VERSION EXPIRED AND MAKE THE CURRENT            
      * VERSION ACTIVE                                                          
      *****************************************************************         
       6536-CHG-ACCESS-OFFER.                                           
                                                                        
           MOVE ZERO                         TO WS-MAX-APRVL-VRSN       
                                                WS-MAX-APRVL-VRSN-NULL. 
                                                                        
           EVALUATE WS-CRM-OFF-ACS-PRC-STAT-CD-CI(WS-CRM-OFFR-ACCS-INDX)
              WHEN WS-PROC-STATUS-NEW                                   
              WHEN WS-PROC-STATUS-PEND-APRVL                            
              WHEN WS-PROC-STATUS-ERLY-APRVL                            
                   PERFORM 8194-UPT-ACCESS-OFF-OPT-STATUS               
                                                THRU 8194-EXIT          
              WHEN WS-PROC-STATUS-APRVL-CMPLT                           
                   PERFORM 7155-GET-ACCESS-MAX-APRVL-VRSN               
                                                THRU 7155-EXIT          
                   IF WS-MAX-APRVL-VRSN > 0                             
                      PERFORM 8192-UPT-ACCESS-OFF-OPT-VENDTS            
                                                THRU 8192-EXIT          
                   END-IF                                               
                   PERFORM 8194-UPT-ACCESS-OFF-OPT-STATUS               
                                                THRU 8194-EXIT          
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
                                                                        
       6536-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6537-MOVE-RT-GRP-OFFR.                                        *         
      *****************************************************************         
       6537-MOVE-RT-GRP-OFFR.                                           
                                                                        
           MOVE WS-CRM-COMPANY-NO            TO G5-COMPANY-NO           
                                                                        
           MOVE WS-CRM-RATE-GROUP-TYPE-CD-G5(WS-CRM-RT-GRP-OFFR-INDX)   
                                             TO G5-RATE-GROUP-TYPE-CD   
           MOVE WS-CRM-RATE-GROUP-CD-G5(WS-CRM-RT-GRP-OFFR-INDX)        
                                             TO G5-RATE-GROUP-CD        
                                                                        
           MOVE WS-CRM-SORT-SEQ-NO-G5(WS-CRM-RT-GRP-OFFR-INDX)          
                                             TO WS-SMALLINT-NUM         
           MOVE WS-SMALLINT-NUM              TO G5-SORT-SEQ-NO          
                                                                        
           MOVE WS-CRM-OFFER-CD-G5(WS-CRM-RT-GRP-OFFR-INDX)             
                                             TO G5-OFFER-CD             
           IF CREATE-OFFER-WIZARD AND                                   
              CRM-RT-GRP-OFFR-INSERT(WS-CRM-RT-GRP-OFFR-INDX)           
              MOVE WS-CRM-OFFER-START-DT-FG  TO G5-EFF-START-DT         
              MOVE WS-CRM-OFFER-END-DT-FG    TO G5-EFF-END-DT           
           ELSE                                                         
              MOVE WS-CRM-EFF-START-DT-G5(WS-CRM-RT-GRP-OFFR-INDX)      
                                             TO G5-EFF-START-DT         
              MOVE WS-CRM-EFF-END-DT-G5(WS-CRM-RT-GRP-OFFR-INDX)        
                                             TO G5-EFF-END-DT           
           END-IF.                                                      
                                                                        
           MOVE WS-CRM-OPTION-CD-G5(WS-CRM-RT-GRP-OFFR-INDX)            
                                             TO G5-OPTION-CD            
           MOVE WS-CRM-USER-ID               TO G5-LAST-UPDATE-USERID   
           MOVE WS-CRM-CURRENT-TIMESTAMP     TO G5-LAST-UPDATE-TS.      
           MOVE WS-CRM-PROC-REQ-ID           TO G5-PROC-REQ-ID          
           MOVE WS-CRM-VRSN-TIMESTAMP        TO G5-GRP-OFF-VSTART-TS    
                                                                        
           IF CRM-RT-GRP-OFFR-INSERT(WS-CRM-RT-GRP-OFFR-INDX)           
              PERFORM 7160-GET-RATE-GRP-MAX-VRSN                        
                                             THRU 7160-EXIT             
              ADD +1                         TO WS-MAX-PROC-VRSN-NO     
              MOVE WS-MAX-PROC-VRSN-NO       TO WS-PROC-VRSN-NO         
              MOVE WS-INFINITE-TS            TO G5-GRP-OFF-VEND-TS      
           ELSE                                                         
              MOVE WS-CRM-GRP-OFF-VRSN-NO-G5(WS-CRM-RT-GRP-OFFR-INDX)   
                                             TO WS-SMALLINT-NUM         
              MOVE WS-SMALLINT-NUM           TO WS-PROC-VRSN-NO         
      *       MOVE WS-CRM-GRP-OFF-PRC-REQ-ID-G5(WS-CRM-RT-GRP-OFFR-INDX)        
      *                                      TO WS-DECIMAL-10V0-NUM             
      *       MOVE WS-DECIMAL-10V0-NUM       TO G5-PROC-REQ-ID                  
      *       MOVE WS-CRM-GRP-OFF-VSTART-TS-G5(WS-CRM-RT-GRP-OFFR-INDX)         
      *                                      TO G5-GRP-OFF-VSTART-TS            
              MOVE WS-CRM-GRP-OFF-VEND-TS-G5(WS-CRM-RT-GRP-OFFR-INDX)   
                                             TO G5-GRP-OFF-VEND-TS      
           END-IF.                                                      
                                                                        
           MOVE WS-PROC-VRSN-NO              TO G5-GRP-OFF-VRSN-NO.     
           MOVE WS-CRM-GRP-OFF-PRC-STAT-CD-G5(WS-CRM-RT-GRP-OFFR-INDX)  
                                             TO G5-PROC-STATUS-CD.      
                                                                        
      * IF OFFER RATE GROUP IN NEW OR EARLY APPROVAL, DELETE THE                
      * EXISTING ROW AND THEN INSERT IF THE SORT SEQ NO OR EFF START DT         
      * GOT CHANGED FOR THE SAME VERSION                                        
                                                                        
           IF CRM-RT-GRP-OFFR-UPDATE(WS-CRM-RT-GRP-OFFR-INDX)           
            AND WS-CRM-GRP-OFF-PRC-STAT-CD-G5(WS-CRM-RT-GRP-OFFR-INDX)  
                = WS-PROC-STATUS-NEW OR WS-PROC-STATUS-ERLY-APRVL       
              MOVE 'N'                       TO WS-RT-GRP-OFFER-KEY-CHGD
              PERFORM 7162-GET-RATE-GRP-DETAILS THRU 7162-EXIT          
              IF G5-SORT-SEQ-NO NOT EQUAL WS-SORT-SEQ-NO                
               OR G5-EFF-START-DT NOT EQUAL WS-EFF-START-DT THEN        
                 SET RT-GRP-OFFER-KEY-CHGD   TO TRUE                    
              END-IF                                                    
           END-IF.                                                      
                                                                        
                                                                        
       6537-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6538-CHG-RT-GRP-OFFR.                                         *         
      * WHEN IT IS UPDATE BASED ON PROC STATUS UPATE THE OFFER RT GRP           
      * WHEN THE STATUS IS APRVL COMPLETE UPDATE THE PREVIOUS  VERSION          
      * END TS WITH CURRENT VERSION START TS - 1 MICORSECOND                    
      * THAT MAKES THE PREVIOUS VERSION EXPIRED AND MAKE THE CURRENT            
      * VERSION ACTIVE                                                          
      *****************************************************************         
       6538-CHG-RT-GRP-OFFR.                                            
                                                                        
           MOVE ZERO                         TO WS-MAX-APRVL-VRSN       
                                                WS-MAX-APRVL-VRSN-NULL. 
                                                                        
           EVALUATE                                                     
                 WS-CRM-GRP-OFF-PRC-STAT-CD-G5(WS-CRM-RT-GRP-OFFR-INDX) 
              WHEN WS-PROC-STATUS-NEW                                   
              WHEN WS-PROC-STATUS-PEND-APRVL                            
              WHEN WS-PROC-STATUS-ERLY-APRVL                            
                   PERFORM 8214-UPT-RT-GRP-OFFR-STATUS                  
                                                THRU 8214-EXIT          
              WHEN WS-PROC-STATUS-APRVL-CMPLT                           
                   PERFORM 7165-GET-RT-GRP-MAX-APRVL-VRSN               
                                                THRU 7165-EXIT          
                   IF WS-MAX-APRVL-VRSN > 0                             
                      PERFORM 8212-UPT-RT-GRP-OFFR-VENDTS               
                                                THRU 8212-EXIT          
                   END-IF                                               
                   PERFORM 8214-UPT-RT-GRP-OFFR-STATUS                  
                                                THRU 8214-EXIT          
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
                                                                        
       6538-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6540-MOVE-RT-PKG-OPTION.                                      *         
      *****************************************************************         
       6540-MOVE-RT-PKG-OPTION.                                         
                                                                        
           MOVE WS-CRM-COMPANY-NO            TO FI-COMPANY-NO           
                                                                        
           MOVE WS-CRM-OPTION-CD-FI(WS-CRM-OPT-INDX)                    
                                             TO FI-OPTION-CD            
           MOVE WS-CRM-CODE-UTIL-TYPE        TO FI-CODE-UTIL-TYPE       
                                                                        
           MOVE WS-CRM-RATE-PLAN-NO-FI(WS-CRM-OPT-INDX)                 
                                             TO FI-RATE-PLAN-NO         
           MOVE WS-CRM-OPTION-START-DT-FI(WS-CRM-OPT-INDX)              
                                             TO FI-OPTION-START-DT      
           MOVE WS-CRM-OPTION-END-DT-FI(WS-CRM-OPT-INDX)                
                                             TO FI-OPTION-END-DT        
           MOVE WS-CRM-OPT-DESC-INT-FI(WS-CRM-OPT-INDX)                 
                                             TO FI-OPT-DESC-INT         
           MOVE WS-CRM-OPT-DESC-INT-LNG-LEN-FI(WS-CRM-OPT-INDX)         
                                             TO WS-SMALLINT-NUM         
           MOVE WS-SMALLINT-NUM              TO FI-OPT-DESC-INT-LONG-LEN
                                                                        
           MOVE WS-CRM-OPT-DESC-INT-LNG-TXT-FI(WS-CRM-OPT-INDX)         
                                          TO FI-OPT-DESC-INT-LONG-TEXT  
           MOVE WS-CRM-CURR-EXT-DSC-LNG-LEN-FI(WS-CRM-OPT-INDX)         
                                             TO WS-SMALLINT-NUM         
           MOVE WS-SMALLINT-NUM           TO FI-CURR-EXT-DESC-LONG-LEN  
                                                                        
           MOVE WS-CRM-CURR-EXT-DSC-LNG-TXT-FI(WS-CRM-OPT-INDX)         
                                          TO FI-CURR-EXT-DESC-LONG-TEXT 
           MOVE WS-CRM-RENEWAL-DESC-LNG-LEN-FI(WS-CRM-OPT-INDX)         
                                             TO WS-SMALLINT-NUM         
           MOVE WS-SMALLINT-NUM          TO FI-RENEWAL-DESC-LONG-LEN    
                                                                        
           MOVE WS-CRM-RENEWAL-DESC-LNG-TXT-FI(WS-CRM-OPT-INDX)         
                                         TO FI-RENEWAL-DESC-LONG-TEXT   
           MOVE WS-CRM-WEB-DESC-LONG-LEN-FI(WS-CRM-OPT-INDX)            
                                             TO WS-SMALLINT-NUM         
           MOVE WS-SMALLINT-NUM              TO FI-WEB-DESC-LONG-LEN    
                                                                        
           MOVE WS-CRM-WEB-DESC-LONG-TXT-FI(WS-CRM-OPT-INDX)            
                                             TO FI-WEB-DESC-LONG-TEXT   
           MOVE 'A'                          TO FI-STATUS-CD            
           MOVE WS-CRM-USER-ID               TO FI-LAST-UPDATE-USERID   
           MOVE WS-CRM-CURRENT-TIMESTAMP     TO FI-LAST-UPDATE-TS       
           MOVE WS-CRM-OPT-CALC-TYPE-CD-FI(WS-CRM-OPT-INDX)             
                                             TO FI-OPT-CALC-TYPE-CD     
           MOVE WS-CRM-WEB-MKT-DESC-LNG-LEN-FI(WS-CRM-OPT-INDX)         
                                             TO WS-SMALLINT-NUM         
           MOVE WS-SMALLINT-NUM          TO FI-WEB-MKT-DESC-LONG-LEN    
           MOVE WS-CRM-WEB-MKT-DESC-LNG-TXT-FI(WS-CRM-OPT-INDX)         
                                         TO FI-WEB-MKT-DESC-LONG-TEXT.  
           MOVE WS-CRM-PROC-REQ-ID       TO FI-PROC-REQ-ID              
           MOVE WS-CRM-VRSN-TIMESTAMP    TO FI-OPT-VSTART-TS            
           IF CRM-OPTION-INSERT(WS-CRM-OPT-INDX)                        
              PERFORM 7120-GET-OPTION-MAX-VRSN THRU 7120-EXIT           
              ADD +1                         TO WS-MAX-PROC-VRSN-NO     
              MOVE WS-MAX-PROC-VRSN-NO       TO WS-PROC-VRSN-NO         
              MOVE WS-INFINITE-TS            TO FI-OPT-VEND-TS          
           ELSE                                                         
              MOVE WS-CRM-OPT-VRSN-NO-FI(WS-CRM-OPT-INDX)               
                                             TO WS-SMALLINT-NUM         
              MOVE WS-SMALLINT-NUM           TO WS-PROC-VRSN-NO         
              MOVE WS-CRM-OPT-VEND-TS-FI(WS-CRM-OPT-INDX)               
                                             TO FI-OPT-VEND-TS          
           END-IF.                                                      
           MOVE WS-PROC-VRSN-NO              TO FI-OPT-VRSN-NO.         
           MOVE WS-CRM-OPT-PRC-STAT-CD-FI(WS-CRM-OPT-INDX)              
                                             TO FI-PROC-STATUS-CD.      
A04805     MOVE WS-CRM-OPTION-TYPE-DESC-FI(WS-CRM-OPT-INDX)             
A04805                                       TO FI-OPTION-TYPE-DESC.    
PRJ892     MOVE WS-CRM-AUTO-RENEWAL-FL-FI (WS-CRM-OPT-INDX)             
PRJ892                                       TO FI-AUTO-RENEWAL-FL.     
PRJ892     MOVE WS-CRM-OPTION-PROMO-DES-LEN-FI (WS-CRM-OPT-INDX)        
PRJ892                                      TO FI-OPTION-PROMO-DESC-LEN.
PRJ892     MOVE WS-CRM-OPTION-PROMO-DES-TXT-FI (WS-CRM-OPT-INDX)        
PRJ892                                     TO FI-OPTION-PROMO-DESC-TEXT.
                                                                        
       6540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6545-CHG-RT-PKG-OPTION                                        *         
      * WHEN IT IS UPDATE BASED ON PROC STATUS UDPATE THE OPTION                
      * WHEN THE STATUS IS APRVL COMPLETE UPDATE THE PREVIOUS  VERSION          
      * END TS WITH CURRENT VERSION START TS - 1 MICORSECOND                    
      * THAT MAKES THE PREVIOUS VERSION EXPIRED AND MAKE THE CURRENT            
      * VERSION ACTIVE                                                          
      *****************************************************************         
       6545-CHG-RT-PKG-OPTION.                                          
                                                                        
           MOVE ZERO                         TO WS-MAX-APRVL-VRSN       
                                                WS-MAX-APRVL-VRSN-NULL. 
                                                                        
           EVALUATE WS-CRM-OPT-PRC-STAT-CD-FI(WS-CRM-OPT-INDX)          
              WHEN WS-PROC-STATUS-NEW                                   
              WHEN WS-PROC-STATUS-PEND-APRVL                            
              WHEN WS-PROC-STATUS-ERLY-APRVL                            
                   PERFORM 8114-UPT-RT-PKG-OPTION-STATUS                
                                                THRU 8114-EXIT          
              WHEN WS-PROC-STATUS-APRVL-CMPLT                           
                   PERFORM 7125-GET-OPTION-MAX-APRVL-VRSN               
                                                THRU 7125-EXIT          
                   IF WS-MAX-APRVL-VRSN > 0                             
                      PERFORM 8112-UPT-RT-PKG-OPTION-VENDTS             
                                                THRU 8112-EXIT          
                   END-IF                                               
                   PERFORM 8114-UPT-RT-PKG-OPTION-STATUS                
                                                THRU 8114-EXIT          
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
                                                                        
       6545-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6550-MOVE-OFFER-OPTION.                                       *         
      *****************************************************************         
       6550-MOVE-OFFER-OPTION.                                          
                                                                        
           MOVE WS-CRM-COMPANY-NO            TO E9-COMPANY-NO.          
                                                                        
           MOVE WS-CRM-OFFER-CD-E9(WS-CRM-OPT-INDX)                     
                                             TO E9-OFFER-CD.            
           MOVE WS-CRM-OPTION-CD-E9(WS-CRM-OPT-INDX)                    
                                             TO E9-OPTION-CD.           
           MOVE WS-CRM-OPTION-SORT-SEQ-NO-E9(WS-CRM-OPT-INDX)           
                                             TO WS-SMALLINT-NUM.        
           MOVE WS-SMALLINT-NUM              TO E9-OPTION-SORT-SEQ-NO.  
                                                                        
           MOVE WS-CRM-OPTION-URL-TX-LEN-E9(WS-CRM-OPT-INDX)            
                                             TO WS-SMALLINT-NUM.        
           MOVE WS-SMALLINT-NUM          TO E9-OPTION-URL-TX-LEN.       
                                                                        
           MOVE WS-CRM-OPTION-URL-TX-TXT-E9(WS-CRM-OPT-INDX)            
                                         TO E9-OPTION-URL-TX-TEXT.      
           MOVE WS-CRM-USER-ID               TO E9-LAST-UPDATE-USERID.  
           MOVE WS-CRM-CURRENT-TIMESTAMP     TO E9-LAST-UPDATE-TS.      
           MOVE WS-CRM-DROP-OPTION-CD-E9(WS-CRM-OPT-INDX)               
                                             TO E9-DROP-OPTION-CD.      
           MOVE WS-CRM-PROC-REQ-ID           TO E9-PROC-REQ-ID.         
           MOVE WS-CRM-VRSN-TIMESTAMP        TO E9-OFF-OPT-VSTART-TS.   
           MOVE WS-CRM-OFFER-OPT-START-DT-E9(WS-CRM-OPT-INDX)           
                                             TO E9-OFFER-OPT-START-DT   
           MOVE WS-CRM-OFFER-OPT-END-DT-E9(WS-CRM-OPT-INDX)             
                                             TO E9-OFFER-OPT-END-DT     
                                                                        
           IF CRM-OFFER-OPT-INSERT(WS-CRM-OPT-INDX)                     
              PERFORM 7170-GET-OFFR-OPT-MAX-VRSN                        
                                             THRU 7170-EXIT             
              ADD +1                         TO WS-MAX-PROC-VRSN-NO     
              MOVE WS-MAX-PROC-VRSN-NO       TO WS-PROC-VRSN-NO         
              MOVE WS-INFINITE-TS            TO E9-OFF-OPT-VEND-TS      
           ELSE                                                         
              MOVE WS-CRM-OFF-OPT-VRSN-NO-E9(WS-CRM-OPT-INDX)           
                                             TO WS-SMALLINT-NUM         
              MOVE WS-SMALLINT-NUM           TO WS-PROC-VRSN-NO         
              MOVE WS-CRM-OFF-OPT-VEND-TS-E9(WS-CRM-OPT-INDX)           
                                             TO E9-OFF-OPT-VEND-TS      
           END-IF.                                                      
                                                                        
           MOVE WS-PROC-VRSN-NO              TO E9-OFF-OPT-VRSN-NO.     
           MOVE WS-CRM-OFF-OPT-PRC-STAT-CD-E9(WS-CRM-OPT-INDX)          
                                             TO E9-PROC-STATUS-CD.      
A04805     MOVE WS-CRM-WEB-NEW-EXISTS-CD-E9(WS-CRM-OPT-INDX)            
A04805                                       TO E9-WEB-NEW-EXISTS-CD.   
A04805     MOVE WS-CRM-WEB-SIGN-UP-FL-E9(WS-CRM-OPT-INDX)               
A04805                                       TO E9-WEB-SIGN-UP-FL.      
A04805     MOVE WS-CRM-OFF-OPT-EXCLUDE-CD-E9(WS-CRM-OPT-INDX)           
A04805                                       TO E9-OFF-OPT-EXCLUDE-CD.  
                                                                        
       6550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6555-CHG-OFFER-OPTION                                         *         
      * WHEN IT IS UPDATE BASED ON PROC STATUS UDPATE THE OFFER OPTION          
      * WHEN THE STATUS IS APRVL COMPLETE UPDATE THE PREVIOUS  VERSION          
      * END TS WITH CURRENT VERSION START TS - 1 MICORSECOND                    
      * THAT MAKES THE PREVIOUS VERSION EXPIRED AND MAKE THE CURRENT            
      * VERSION ACTIVE                                                          
      *****************************************************************         
       6555-CHG-OFFER-OPTION.                                           
                                                                        
           MOVE ZERO                         TO WS-MAX-APRVL-VRSN       
                                                WS-MAX-APRVL-VRSN-NULL. 
                                                                        
           EVALUATE WS-CRM-OFF-OPT-PRC-STAT-CD-E9(WS-CRM-OPT-INDX)      
              WHEN WS-PROC-STATUS-NEW                                   
              WHEN WS-PROC-STATUS-PEND-APRVL                            
              WHEN WS-PROC-STATUS-ERLY-APRVL                            
                   PERFORM 8144-UPT-OFFER-OPTION-STATUS                 
                                                THRU 8144-EXIT          
              WHEN WS-PROC-STATUS-APRVL-CMPLT                           
                   PERFORM 7175-GET-OFFR-OPT-MAX-AC-VRSN                
                                                THRU 7175-EXIT          
                   IF WS-MAX-APRVL-VRSN > 0                             
                      PERFORM 8142-UPT-OFFER-OPTION-VENDTS              
                                                THRU 8142-EXIT          
                   END-IF                                               
                   PERFORM 8144-UPT-OFFER-OPTION-STATUS                 
                                                THRU 8144-EXIT          
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
                                                                        
       6555-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6560-MOVE-OPT-ATTR-INCTV.                                     *         
      *****************************************************************         
       6560-MOVE-OPT-ATTR-INCTV.                                        
                                                                        
           MOVE WS-CRM-COMPANY-NO            TO HQ-COMPANY-NO           
                                                                        
           MOVE WS-CRM-OPTION-CD-HQ  (WS-CRM-OPT-INDX                   
                                         , WS-CRM-ATTRB-INDX)           
                                             TO HQ-OPTION-CD            
           MOVE WS-CRM-RT-ATTR-INCTV-TYPE-HQ (WS-CRM-OPT-INDX           
                                                 , WS-CRM-ATTRB-INDX)   
                                             TO HQ-RT-ATTR-INCTV-TYPE   
           MOVE WS-CRM-ATTR-INCTV-STRT-DT-HQ (WS-CRM-OPT-INDX           
                                                , WS-CRM-ATTRB-INDX)    
                                             TO HQ-ATTR-INCTV-STRT-DT   
           MOVE WS-CRM-ATTR-INCTV-END-DT-HQ (WS-CRM-OPT-INDX            
                                             , WS-CRM-ATTRB-INDX)       
                                             TO HQ-ATTR-INCTV-END-DT .  
           IF CRM-OPT-ATTRB-INSERT(WS-CRM-OPT-INDX ,                    
                                      WS-CRM-ATTRB-INDX)                
      *       IN MODIFY OPTION,WHEN WE MODIFY THE ATTR INCTV(AC STATUS)         
      *       THE SEQ NO SHOLUD NOT GET CHANGE.                                 
              PERFORM 7060-GET-MAX-ATTR-SEQ-NO THRU 7060-EXIT           
              IF WS-MAX-ATTR-SEQ-NO > 0                                 
                 MOVE WS-MAX-ATTR-SEQ-NO     TO HQ-ATTR-INCTV-SEQ-NO    
              ELSE                                                      
      *       IN CREATE OFFER, WHEN WE ADD NEW ATTR INCTV(NW STATUS).           
                 PERFORM 7100-GET-MAX-ATTR-SEQ-NO THRU 7100-EXIT        
                 ADD +1                     TO WS-MAX-ATTR-SEQ-NO       
                 MOVE WS-MAX-ATTR-SEQ-NO    TO HQ-ATTR-INCTV-SEQ-NO     
              END-IF                                                    
           ELSE                                                         
              MOVE WS-CRM-ATTR-INCTV-SEQ-NO-HQ (WS-CRM-OPT-INDX         
                                                 , WS-CRM-ATTRB-INDX)   
                                             TO HQ-ATTR-INCTV-SEQ-NO    
           END-IF                                                       
           MOVE WS-CRM-PRIMRY-OPT-ATTR-FL-HQ (WS-CRM-OPT-INDX           
                                                 , WS-CRM-ATTRB-INDX)   
                                             TO HQ-PRIMRY-OPT-ATTR-FL   
           MOVE WS-CRM-FACTOR-ID-HQ (WS-CRM-OPT-INDX                    
                                         , WS-CRM-ATTRB-INDX)           
                                             TO HQ-FACTOR-ID            
           MOVE WS-CRM-DURATION-NO-HQ (WS-CRM-OPT-INDX                  
                                           , WS-CRM-ATTRB-INDX)         
                                             TO WS-SMALLINT-NUM         
           MOVE WS-SMALLINT-NUM              TO HQ-DURATION-NO          
                                                                        
           MOVE WS-CRM-APPL-PROGRAM-ID-HQ (WS-CRM-OPT-INDX              
                                               , WS-CRM-ATTRB-INDX)     
                                             TO HQ-APPL-PROGRAM-ID      
           MOVE WS-CRM-ATTR-INCTV-VALUE-VAL-HQ (WS-CRM-OPT-INDX         
                                                , WS-CRM-ATTRB-INDX)    
                                             TO WS-DECIMAL-5V6-NUM      
           IF WS-CRM-ATTR-INCTV-VALUE-SGN-HQ (WS-CRM-OPT-INDX           
                                , WS-CRM-ATTRB-INDX) = '-' THEN         
              COMPUTE WS-DECIMAL-5V6-NUM-RED                            
                              = WS-DECIMAL-5V6-NUM-RED * -1             
           END-IF                                                       
           MOVE WS-DECIMAL-5V6-NUM-RED       TO HQ-ATTR-INCTV-VALUE     
                                                                        
           MOVE WS-CRM-ATTR-INCTV-VAL-TX-HQ  (WS-CRM-OPT-INDX           
                                                  , WS-CRM-ATTRB-INDX)  
                                             TO HQ-ATTR-INCTV-VAL-TX    
           MOVE WS-CRM-USER-ID               TO HQ-LAST-UPDATE-USERID   
           MOVE WS-CRM-CURRENT-TIMESTAMP     TO HQ-LAST-UPDATE-TS       
           MOVE WS-CRM-GL-ACCT-CREDIT-VAL-HQ (WS-CRM-OPT-INDX           
                                               , WS-CRM-ATTRB-INDX)     
                                             TO WS-DECIMAL-3V4-NUM      
           IF WS-CRM-GL-ACCT-CREDIT-SGN-HQ (WS-CRM-OPT-INDX             
                            , WS-CRM-ATTRB-INDX) = '-' THEN             
              COMPUTE WS-DECIMAL-3V4-NUM-RED                            
                                  = WS-DECIMAL-3V4-NUM-RED * -1         
           END-IF                                                       
           MOVE WS-DECIMAL-3V4-NUM-RED       TO HQ-GL-ACCT-CREDIT       
                                                                        
           MOVE WS-CRM-GL-ACCT-DEBIT-VAL-HQ (WS-CRM-OPT-INDX            
                                               , WS-CRM-ATTRB-INDX)     
                                             TO WS-DECIMAL-3V4-NUM      
           IF WS-CRM-GL-ACCT-DEBIT-SGN-HQ (WS-CRM-OPT-INDX              
                            , WS-CRM-ATTRB-INDX) = '-' THEN             
              COMPUTE WS-DECIMAL-3V4-NUM-RED                            
                                  = WS-DECIMAL-3V4-NUM-RED * -1         
           END-IF                                                       
           MOVE WS-DECIMAL-3V4-NUM-RED       TO HQ-GL-ACCT-DEBIT        
                                                                        
           MOVE WS-CRM-CATEGORY-ID-HQ  (WS-CRM-OPT-INDX                 
                                            , WS-CRM-ATTRB-INDX)        
                                             TO HQ-CATEGORY-ID          
           MOVE WS-CRM-WQ-ROUTE-CATEGORY-HQ (WS-CRM-OPT-INDX            
                                                 , WS-CRM-ATTRB-INDX)   
                                             TO HQ-WQ-ROUTE-CATEGORY    
           MOVE WS-CRM-OPT-CHG-ACTION-CD-HQ (WS-CRM-OPT-INDX            
                                                , WS-CRM-ATTRB-INDX)    
                                             TO HQ-OPT-CHG-ACTION-CD    
           MOVE WS-CRM-PROC-REQ-ID           TO HQ-PROC-REQ-ID          
           MOVE WS-CRM-VRSN-TIMESTAMP        TO HQ-OPT-ATTR-VSTART-TS   
           IF CRM-OPT-ATTRB-INSERT(WS-CRM-OPT-INDX                      
                                   , WS-CRM-ATTRB-INDX)                 
              PERFORM 7180-GET-OPT-ATRB-MAX-VRSN                        
                                             THRU 7180-EXIT             
              ADD +1                         TO WS-MAX-PROC-VRSN-NO     
              MOVE WS-MAX-PROC-VRSN-NO       TO WS-PROC-VRSN-NO         
              MOVE WS-INFINITE-TS            TO HQ-OPT-ATTR-VEND-TS     
           ELSE                                                         
              MOVE WS-CRM-OPT-ATRB-VRSN-NO-HQ(WS-CRM-OPT-INDX           
                                              , WS-CRM-ATTRB-INDX)      
                                             TO WS-SMALLINT-NUM         
              MOVE WS-SMALLINT-NUM           TO WS-PROC-VRSN-NO         
      *       MOVE WS-CRM-OPT-ATRB-PRC-REQ-ID-HQ(WS-CRM-OPT-INDX                
      *                                          , WS-CRM-ATTRB-INDX)           
      *                                      TO WS-DECIMAL-10V0-NUM             
      *       MOVE WS-DECIMAL-10V0-NUM       TO HQ-PROC-REQ-ID                  
      *       MOVE WS-CRM-OPT-ATRB-VSTART-TS-HQ(WS-CRM-OPT-INDX                 
      *                                         , WS-CRM-ATTRB-INDX)            
      *                                      TO HQ-OPT-ATTR-VSTART-TS           
              MOVE WS-CRM-OPT-ATRB-VEND-TS-HQ(WS-CRM-OPT-INDX           
                                              , WS-CRM-ATTRB-INDX)      
                                             TO HQ-OPT-ATTR-VEND-TS     
           END-IF.                                                      
                                                                        
           MOVE WS-PROC-VRSN-NO                                         
                                             TO HQ-OPT-ATTR-VRSN-NO.    
           MOVE WS-CRM-OPT-ATRB-PRC-STAT-CD-HQ(WS-CRM-OPT-INDX          
                                               , WS-CRM-ATTRB-INDX)     
                                             TO HQ-PROC-STATUS-CD.      
                                                                        
       6560-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6562-CHG-OPT-ATTR-INCTV                                       *         
      * WHEN IT IS UPDATE BASED ON PROC STATUS UDPATE THE OPTION ATTRBS         
      * WHEN THE STATUS IS APRVL COMPLETE UPDATE THE PREVIOUS  VERSION          
      * END TS WITH CURRENT VERSION START TS - 1 MICORSECOND                    
      * THAT MAKES THE PREVIOUS VERSION EXPIRED AND MAKE THE CURRENT            
      * VERSION ACTIVE                                                          
      *****************************************************************         
       6562-CHG-OPT-ATTR-INCTV.                                         
                                                                        
           MOVE ZERO                         TO WS-MAX-APRVL-VRSN       
                                                WS-MAX-APRVL-VRSN-NULL. 
                                                                        
           EVALUATE WS-CRM-OPT-ATRB-PRC-STAT-CD-HQ(WS-CRM-OPT-INDX      
                                                   , WS-CRM-ATTRB-INDX) 
              WHEN WS-PROC-STATUS-NEW                                   
              WHEN WS-PROC-STATUS-PEND-APRVL                            
              WHEN WS-PROC-STATUS-ERLY-APRVL                            
                   PERFORM 8164-UPT-OPT-ATTR-INCTV-STATUS               
                                                THRU 8164-EXIT          
              WHEN WS-PROC-STATUS-APRVL-CMPLT                           
                   PERFORM 7185-GET-OPT-ATRB-MAX-AC-VRSN                
                                                THRU 7185-EXIT          
                   IF WS-MAX-APRVL-VRSN > 0                             
                      PERFORM 8162-UPT-OPT-ATTR-INCTV-VENDTS            
                                                THRU 8162-EXIT          
                   END-IF                                               
                   PERFORM 8164-UPT-OPT-ATTR-INCTV-STATUS               
                                                THRU 8164-EXIT          
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
                                                                        
       6562-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6565-MOVE-OPT-ACCESS.                                         *         
      *****************************************************************         
       6565-MOVE-OPT-ACCESS.                                            
                                                                        
           MOVE WS-CRM-COMPANY-NO            TO CI-COMPANY-NO           
                                                                        
           MOVE WS-CRM-OPTN-OPTION-CD-CI(WS-CRM-OPT-INDX ,              
                                                 WS-CRM-OPTN-ACCS-INDX) 
                                             TO CI-OPTION-CD            
           MOVE WS-CRM-OPTN-OFFER-CD-CI(WS-CRM-OPT-INDX ,               
                                                 WS-CRM-OPTN-ACCS-INDX) 
                                             TO CI-OFFER-CD             
           MOVE WS-CRM-OPTN-CATEGORY-ID-CI(WS-CRM-OPT-INDX ,            
                                                 WS-CRM-OPTN-ACCS-INDX) 
                                             TO WS-INTEGER-NUM          
           MOVE WS-INTEGER-NUM               TO CI-CATEGORY-ID          
                                                                        
                                                                        
           MOVE WS-CRM-OPTN-ACCES-START-DT-CI(WS-CRM-OPT-INDX ,         
                                                 WS-CRM-OPTN-ACCS-INDX) 
                                             TO CI-ACCESS-START-DT      
           MOVE WS-CRM-OPTN-ACCESS-END-DT-CI(WS-CRM-OPT-INDX ,          
                                                 WS-CRM-OPTN-ACCS-INDX) 
                                             TO CI-ACCESS-END-DT        
           MOVE WS-CRM-OPTN-VIEW-APPLY-CD-CI(WS-CRM-OPT-INDX ,          
                                                 WS-CRM-OPTN-ACCS-INDX) 
                                             TO CI-VIEW-APPLY-CD        
           MOVE WS-CRM-USER-ID               TO CI-LAST-UPDATE-USERID   
                                                                        
           MOVE WS-CRM-OPTN-LAST-UPDATE-TS-CI(WS-CRM-OPT-INDX ,         
                                                 WS-CRM-OPTN-ACCS-INDX) 
                                             TO CI-LAST-UPDATE-TS.      
           MOVE WS-CRM-OPTN-COMMENTS-TX-CI(WS-CRM-OPT-INDX ,            
                                                 WS-CRM-OPTN-ACCS-INDX) 
                                             TO CI-COMMENTS-TX.         
           MOVE WS-CRM-PROC-REQ-ID           TO CI-PROC-REQ-ID          
           MOVE WS-CRM-VRSN-TIMESTAMP        TO CI-ACCESS-VSTART-TS     
           IF CRM-OPTN-ACCS-INSERT(WS-CRM-OPT-INDX ,                    
                                         WS-CRM-OPTN-ACCS-INDX)         
              PERFORM 7150-GET-CRM-ACCESS-MAX-VRSN                      
                                             THRU 7150-EXIT             
              ADD +1                         TO WS-MAX-PROC-VRSN-NO     
              MOVE WS-MAX-PROC-VRSN-NO       TO WS-PROC-VRSN-NO         
              MOVE WS-INFINITE-TS            TO CI-ACCESS-VEND-TS       
           ELSE                                                         
              MOVE WS-CRM-OPT-ACS-VRSN-NO-CI(WS-CRM-OPT-INDX ,          
                                              WS-CRM-OPTN-ACCS-INDX)    
                                             TO WS-SMALLINT-NUM         
              MOVE WS-SMALLINT-NUM           TO WS-PROC-VRSN-NO         
      *       MOVE WS-CRM-OPT-ACS-PRC-REQ-ID-CI                                 
      *                         (WS-CRM-OPT-INDX ,                              
      *                                WS-CRM-OPTN-ACCS-INDX)                   
      *                                      TO WS-DECIMAL-10V0-NUM             
      *       MOVE WS-DECIMAL-10V0-NUM       TO CI-PROC-REQ-ID                  
      *       MOVE WS-CRM-OPT-ACS-VSTART-TS-CI                                  
      *                             (WS-CRM-OPT-INDX ,                          
      *                                   WS-CRM-OPTN-ACCS-INDX)                
      *                                      TO CI-ACCESS-VSTART-TS             
              MOVE WS-CRM-OPT-ACS-VEND-TS-CI                            
                                    (WS-CRM-OPT-INDX ,                  
                                          WS-CRM-OPTN-ACCS-INDX)        
                                             TO CI-ACCESS-VEND-TS       
           END-IF.                                                      
                                                                        
           MOVE WS-PROC-VRSN-NO                                         
                                             TO CI-ACCESS-VRSN-NO.      
                                                                        
                                                                        
           MOVE WS-CRM-OPT-ACS-PRC-STAT-CD-CI                           
                                    (WS-CRM-OPT-INDX ,                  
                                          WS-CRM-OPTN-ACCS-INDX)        
                                             TO CI-PROC-STATUS-CD.      
       6565-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6567-CHG-ACCESS-OPTION                                        *         
      * WHEN IT IS UPDATE BASED ON PROC STATUS UPATE THE OPTION ACCESS          
      * WHEN THE STATUS IS APRVL COMPLETE UPDATE THE PREVIOUS  VERSION          
      * END TS WITH CURRENT VERSION START TS - 1 MICORSECOND                    
      * THAT MAKES THE PREVIOUS VERSION EXPIRED AND MAKE THE CURRENT            
      * VERSION ACTIVE                                                          
      *****************************************************************         
       6567-CHG-ACCESS-OPTION.                                          
                                                                        
           MOVE ZERO                         TO WS-MAX-APRVL-VRSN       
                                                WS-MAX-APRVL-VRSN-NULL. 
                                                                        
           EVALUATE WS-CRM-OPT-ACS-PRC-STAT-CD-CI                       
                                        (WS-CRM-OPT-INDX ,              
                                              WS-CRM-OPTN-ACCS-INDX)    
              WHEN WS-PROC-STATUS-NEW                                   
              WHEN WS-PROC-STATUS-PEND-APRVL                            
              WHEN WS-PROC-STATUS-ERLY-APRVL                            
                   PERFORM 8194-UPT-ACCESS-OFF-OPT-STATUS               
                                                THRU 8194-EXIT          
              WHEN WS-PROC-STATUS-APRVL-CMPLT                           
                   PERFORM 7155-GET-ACCESS-MAX-APRVL-VRSN               
                                                THRU 7155-EXIT          
                   IF WS-MAX-APRVL-VRSN > 0                             
                      PERFORM 8192-UPT-ACCESS-OFF-OPT-VENDTS            
                                                THRU 8192-EXIT          
                   END-IF                                               
                   PERFORM 8194-UPT-ACCESS-OFF-OPT-STATUS               
                                                THRU 8194-EXIT          
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
                                                                        
       6567-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6570-GET-CRM-PROCESS-DETAILS.                                 *         
      *****************************************************************         
       6570-GET-CRM-PROCESS-DETAILS.                                    
                                                                        
                                                                        
           PERFORM 7105-GET-CURRENT-TIMESTAMP   THRU 7105-EXIT.         
                                                                        
           EVALUATE TRUE                                                
           WHEN CREATE-OFFER-WIZARD                                     
                MOVE +1                      TO WS-PROC-VRSN-NO         
                MOVE 'NW'                    TO WS-PROC-STATUS-CD       
                MOVE 99999.0                 TO WS-PROC-REQ-ID          
           WHEN MODIFY-OFFER-WIZARD                                     
                MOVE +1                      TO WS-PROC-VRSN-NO         
                MOVE 'NW'                    TO WS-PROC-STATUS-CD       
                MOVE 99999.0                 TO WS-PROC-REQ-ID          
           END-EVALUATE.                                                
                                                                        
       6570-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-GET-MKT-TIER-START-DT                                     *        
      ******************************************************************        
       7000-GET-MKT-TIER-START-DT.                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) IG.MKT_TIER_START_DT                              
                 INTO :IG-MKT-TIER-START-DT                             
                 FROM CRM_MKT_TIER IG WITH(READUNCOMMITTED)                     
                WHERE IG.COMPANY_NO        = :IG-COMPANY-NO             
                  AND IG.TIER_CUST_STAT_CD = :IG-TIER-CUST-STAT-CD      
                  AND IG.TIER_ACCT_TYPE_CD = :IG-TIER-ACCT-TYPE-CD      
                  AND IG.MKT_TIER_RANKING  = :IG-MKT-TIER-RANKING       
                ORDER BY IG.MKT_TIER_END_DT DESC                        
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IG.MKT_TIER_START_DT                                      
MFA-TR*          INTO :IG-MKT-TIER-START-DT                                     
MFA-TR*          FROM CRM_MKT_TIER IG                                           
MFA-TR*         WHERE IG.COMPANY_NO        = :IG-COMPANY-NO                     
MFA-TR*           AND IG.TIER_CUST_STAT_CD = :IG-TIER-CUST-STAT-CD              
MFA-TR*           AND IG.TIER_ACCT_TYPE_CD = :IG-TIER-ACCT-TYPE-CD              
MFA-TR*           AND IG.MKT_TIER_RANKING  = :IG-MKT-TIER-RANKING               
MFA-TR*         ORDER BY IG.MKT_TIER_END_DT DESC                                
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_MKT_TIER'            TO TABLE-1                 
              MOVE 'TIER_CUST_STAT_CD'       TO TABLE-ELEMENT-1         
              MOVE 'TIER_ACCT_TYPE_CD'       TO TABLE-ELEMENT-2         
              MOVE 'MKT_TIER_RANKING'        TO TABLE-ELEMENT-3         
              MOVE IG-TIER-CUST-STAT-CD      TO HOSTVAR-ELEMENT-1       
              MOVE IG-TIER-ACCT-TYPE-CD      TO HOSTVAR-ELEMENT-2       
              MOVE IG-MKT-TIER-RANKING       TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7005-GET-OFF-MKT-TIER-STRT-DT                                           
      ******************************************************************        
       7005-GET-OFF-MKT-TIER-STRT-DT.                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DU.OFFER_TIER_STRT_DT                             
                 INTO :WS-OLD-OFF-TIER-STRT-DT                          
                 FROM CRM_OFF_MKT_TIER DU WITH(READUNCOMMITTED)                 
                WHERE DU.COMPANY_NO         = :DU-COMPANY-NO            
                  AND DU.OFFER_CD           = :DU-OFFER-CD              
                  AND DU.TIER_CUST_STAT_CD  = :DU-TIER-CUST-STAT-CD     
                  AND DU.TIER_ACCT_TYPE_CD  = :DU-TIER-ACCT-TYPE-CD     
                  AND DU.MKT_TIER_RANKING   = :DU-MKT-TIER-RANKING      
                  AND DU.MKT_TIER_START_DT  = IIF(TRY_CONVERT(DATE, 
                                                  :DU-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DU-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:DU-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:DU-MKT-TIER-START-DT
              ), CONVERT(DATE, :DU-MKT-TIER-START-DT) )     
                ORDER BY OFF_TIER_VRSN_NO DESC                          
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DU.OFFER_TIER_STRT_DT                                     
MFA-TR*          INTO :WS-OLD-OFF-TIER-STRT-DT                                  
MFA-TR*          FROM CRM_OFF_MKT_TIER DU                                       
MFA-TR*         WHERE DU.COMPANY_NO         = :DU-COMPANY-NO                    
MFA-TR*           AND DU.OFFER_CD           = :DU-OFFER-CD                      
MFA-TR*           AND DU.TIER_CUST_STAT_CD  = :DU-TIER-CUST-STAT-CD             
MFA-TR*           AND DU.TIER_ACCT_TYPE_CD  = :DU-TIER-ACCT-TYPE-CD             
MFA-TR*           AND DU.MKT_TIER_RANKING   = :DU-MKT-TIER-RANKING              
MFA-TR*           AND DU.MKT_TIER_START_DT  = :DU-MKT-TIER-START-DT             
MFA-TR*         ORDER BY OFF_TIER_VRSN_NO DESC                                  
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7005                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7005'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFF_MKT_TIER'        TO TABLE-1                 
              MOVE 'TIER_CUST_STAT_CD'       TO TABLE-ELEMENT-1         
              MOVE 'TIER_ACCT_TYPE_CD'       TO TABLE-ELEMENT-2         
              MOVE 'MKT_TIER_RANKING'        TO TABLE-ELEMENT-3         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-4         
              MOVE DU-TIER-CUST-STAT-CD      TO HOSTVAR-ELEMENT-1       
              MOVE DU-TIER-ACCT-TYPE-CD      TO HOSTVAR-ELEMENT-2       
              MOVE DU-MKT-TIER-RANKING       TO HOSTVAR-ELEMENT-3       
              MOVE DU-OFFER-CD               TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7006-GET-ACC-OFF-OPT-STRT-DT                                            
      ******************************************************************        
       7006-GET-ACC-OFF-OPT-STRT-DT.                                    
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CI.ACCESS_START_DT,
              CI.VIEW_APPLY_CD                                  
                 INTO :WS-OLD-ACCESS-START-DT                           
                     ,:WS-OLD-VIEW-APPLY-CD                             
                 FROM CRM_ACCESS_OFF_OPT CI WITH(READUNCOMMITTED)               
                WHERE CI.COMPANY_NO       = :CI-COMPANY-NO              
                  AND CI.OPTION_CD        = :CI-OPTION-CD               
                  AND CI.OFFER_CD         = :CI-OFFER-CD                
                  AND CI.CATEGORY_ID      = :CI-CATEGORY-ID             
                  AND CI.ACCESS_VRSN_NO   = :CI-ACCESS-VRSN-NO          
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CI.ACCESS_START_DT                                        
MFA-TR*              ,CI.VIEW_APPLY_CD                                          
MFA-TR*          INTO :WS-OLD-ACCESS-START-DT                                   
MFA-TR*              ,:WS-OLD-VIEW-APPLY-CD                                     
MFA-TR*          FROM CRM_ACCESS_OFF_OPT CI                                     
MFA-TR*         WHERE CI.COMPANY_NO       = :CI-COMPANY-NO                      
MFA-TR*           AND CI.OPTION_CD        = :CI-OPTION-CD                       
MFA-TR*           AND CI.OFFER_CD         = :CI-OFFER-CD                        
MFA-TR*           AND CI.CATEGORY_ID      = :CI-CATEGORY-ID                     
MFA-TR*           AND CI.ACCESS_VRSN_NO   = :CI-ACCESS-VRSN-NO                  
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7006                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7006'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_ACCESS_OFF_OPT'      TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE 'CATEGORY-ID'             TO TABLE-ELEMENT-3         
              MOVE CI-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              MOVE CI-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              MOVE CI-CATEGORY-ID            TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7006-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7007-GET-OFF-OPT-STRT-DT                                                
      ******************************************************************        
       7007-GET-OFF-OPT-STRT-DT.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) E9.OFFER_OPT_START_DT                             
                 INTO :WS-OLD-OFF-OPT-STRT-DT                           
                 FROM CRM_OFFER_OPTION  E9 WITH(READUNCOMMITTED)                
                WHERE E9.COMPANY_NO       = :E9-COMPANY-NO              
                  AND E9.OPTION_CD        = :E9-OPTION-CD               
                  AND E9.OFFER_CD         = :E9-OFFER-CD                
                ORDER BY OFF_OPT_VRSN_NO DESC                           
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT E9.OFFER_OPT_START_DT                                     
MFA-TR*          INTO :WS-OLD-OFF-OPT-STRT-DT                                   
MFA-TR*          FROM CRM_OFFER_OPTION  E9                                      
MFA-TR*         WHERE E9.COMPANY_NO       = :E9-COMPANY-NO                      
MFA-TR*           AND E9.OPTION_CD        = :E9-OPTION-CD                       
MFA-TR*           AND E9.OFFER_CD         = :E9-OFFER-CD                        
MFA-TR*         ORDER BY OFF_OPT_VRSN_NO DESC                                   
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7007                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7007'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFFER_OPTION'        TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE E9-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              MOVE E9-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7007-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7008-GET-ATTR-INCTV-START-DT.                                           
      ******************************************************************        
       7008-GET-ATTR-INCTV-START-DT.                                    
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) HQ.ATTR_INCTV_STRT_DT                             
                 INTO :WS-OLD-ATTR-INCTV-STRT-DT                        
                 FROM CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)               
                WHERE HQ.COMPANY_NO        = :HQ-COMPANY-NO             
                  AND HQ.OPTION_CD         = :HQ-OPTION-CD              
                  AND HQ.ATTR_INCTV_SEQ_NO = :HQ-ATTR-INCTV-SEQ-NO      
                ORDER BY OPT_ATTR_VRSN_NO DESC                          
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT HQ.ATTR_INCTV_STRT_DT                                     
MFA-TR*          INTO :WS-OLD-ATTR-INCTV-STRT-DT                                
MFA-TR*          FROM CRM_OPT_ATTR_INCTV HQ                                     
MFA-TR*         WHERE HQ.COMPANY_NO        = :HQ-COMPANY-NO                     
MFA-TR*           AND HQ.OPTION_CD         = :HQ-OPTION-CD                      
MFA-TR*           AND HQ.ATTR_INCTV_SEQ_NO = :HQ-ATTR-INCTV-SEQ-NO              
MFA-TR*         ORDER BY OPT_ATTR_VRSN_NO DESC                                  
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7008                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7008'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OPT_ATTR_INCTV'      TO TABLE-1                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE 'ATTR_INCTV_SEQ_NO'       TO TABLE-ELEMENT-1         
              MOVE HQ-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              MOVE HQ-ATTR-INCTV-SEQ-NO      TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7008-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-SELECT-TEMPLATE-OFFER                                     *        
      ******************************************************************        
       7010-SELECT-TEMPLATE-OFFER.                                      
                                                                        
           EXEC SQL                                                     
              SELECT COMPANY_NO                                         
                    ,OFFER_CD                                           
                    ,OFFER_DESC_INT                                     
                    ,OFFER_DESC_EXT                                     
                    ,PROMO_CD_INT_FL                                    
                    ,PROMO_CD_EXT_FL                                    
                    ,OFFER_START_DT                                     
                    ,OFFER_END_DT                                       
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), DISP_START_INT_TS
           , 121), ' ', '-'), ':', '.') DISP_START_INT_TS                      
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), DISP_END_INT_TS
           , 121), ' ', '-'), ':', '.') DISP_END_INT_TS                        
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), DISP_START_EXT_TS
           , 121), ' ', '-'), ':', '.') DISP_START_EXT_TS                      
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), DISP_END_EXT_TS
           , 121), ' ', '-'), ':', '.') DISP_END_EXT_TS                        
                    ,LAST_UPDATE_USERID                                 
                    ,OFFER_DESC_INT_LNG                                 
                    ,OFFER_DESC_EXT_LNG                                 
                    ,SPCL_OFFER_TYPE_CD                                 
                    ,RENEWAL_OFFER_CD                                   
                    ,RENEW_PUB_OFFER_CD                                 
                    ,OFF_VRSN_NO                                        
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), OFF_VSTART_TS
           , 121), ' ', '-'), ':', '.') OFF_VSTART_TS                          
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), OFF_VEND_TS
           , 121), ' ', '-'), ':', '.') OFF_VEND_TS                            
                    ,PROC_STATUS_CD                                     
                    ,PROC_REQ_ID                                        
PRJ680              ,MAX_PRICE_OFFER_CD                                 
P00863              ,RTCHG_PUB_OFFER_CD                                 
                INTO :FG-COMPANY-NO                                     
                    ,:FG-OFFER-CD                                       
                    ,:FG-OFFER-DESC-INT                                 
                    ,:FG-OFFER-DESC-EXT                                 
                    ,:FG-PROMO-CD-INT-FL                                
                    ,:FG-PROMO-CD-EXT-FL                                
                    ,:FG-OFFER-START-DT                                 
                    ,:FG-OFFER-END-DT                                   
                    ,:FG-DISP-START-INT-TS                              
                    ,:FG-DISP-END-INT-TS                                
                    ,:FG-DISP-START-EXT-TS                              
                    ,:FG-DISP-END-EXT-TS                                
                    ,:FG-LAST-UPDATE-USERID                             
                    ,:FG-OFFER-DESC-INT-LNG                             
                    ,:FG-OFFER-DESC-EXT-LNG                             
                    ,:FG-SPCL-OFFER-TYPE-CD                             
                    ,:FG-RENEWAL-OFFER-CD                               
                    ,:FG-RENEW-PUB-OFFER-CD                             
                    ,:FG-OFF-VRSN-NO                                    
                    ,:FG-OFF-VSTART-TS                                  
                    ,:FG-OFF-VEND-TS                                    
                    ,:FG-PROC-STATUS-CD                                 
                    ,:FG-PROC-REQ-ID                                    
PRJ680              ,:FG-MAX-PRICE-OFFER-CD                             
P00863              ,:FG-RTCHG-PUB-OFFER-CD                             
                FROM CRM_RT_PKG_OFFER FG WITH(READUNCOMMITTED)                  
               WHERE FG.COMPANY_NO   = :FG-COMPANY-NO                   
                 AND FG.OFFER_CD     = :FG-OFFER-CD                     
                 AND FG.OFF_VRSN_NO  =                                  
                     ( SELECT MAX(F1.OFF_VRSN_NO)                       
                         FROM CRM_RT_PKG_OFFER F1 WITH(READUNCOMMITTED)         
                        WHERE F1.COMPANY_NO     = FG.COMPANY_NO         
                          AND F1.OFFER_CD       = FG.OFFER_CD           
                          AND F1.PROC_STATUS_CD                         
                                     = :WS-PROC-STATUS-APRVL-CMPLT)     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COMPANY_NO                                                 
MFA-TR*             ,OFFER_CD                                                   
MFA-TR*             ,OFFER_DESC_INT                                             
MFA-TR*             ,OFFER_DESC_EXT                                             
MFA-TR*             ,PROMO_CD_INT_FL                                            
MFA-TR*             ,PROMO_CD_EXT_FL                                            
MFA-TR*             ,OFFER_START_DT                                             
MFA-TR*             ,OFFER_END_DT                                               
MFA-TR*             ,DISP_START_INT_TS                                          
MFA-TR*             ,DISP_END_INT_TS                                            
MFA-TR*             ,DISP_START_EXT_TS                                          
MFA-TR*             ,DISP_END_EXT_TS                                            
MFA-TR*             ,LAST_UPDATE_USERID                                         
MFA-TR*             ,OFFER_DESC_INT_LNG                                         
MFA-TR*             ,OFFER_DESC_EXT_LNG                                         
MFA-TR*             ,SPCL_OFFER_TYPE_CD                                         
MFA-TR*             ,RENEWAL_OFFER_CD                                           
MFA-TR*             ,RENEW_PUB_OFFER_CD                                         
MFA-TR*             ,OFF_VRSN_NO                                                
MFA-TR*             ,OFF_VSTART_TS                                              
MFA-TR*             ,OFF_VEND_TS                                                
MFA-TR*             ,PROC_STATUS_CD                                             
MFA-TR*             ,PROC_REQ_ID                                                
MFA-TR*             ,MAX_PRICE_OFFER_CD                                         
MFA-TR*             ,RTCHG_PUB_OFFER_CD                                         
MFA-TR*         INTO :FG-COMPANY-NO                                             
MFA-TR*             ,:FG-OFFER-CD                                               
MFA-TR*             ,:FG-OFFER-DESC-INT                                         
MFA-TR*             ,:FG-OFFER-DESC-EXT                                         
MFA-TR*             ,:FG-PROMO-CD-INT-FL                                        
MFA-TR*             ,:FG-PROMO-CD-EXT-FL                                        
MFA-TR*             ,:FG-OFFER-START-DT                                         
MFA-TR*             ,:FG-OFFER-END-DT                                           
MFA-TR*             ,:FG-DISP-START-INT-TS                                      
MFA-TR*             ,:FG-DISP-END-INT-TS                                        
MFA-TR*             ,:FG-DISP-START-EXT-TS                                      
MFA-TR*             ,:FG-DISP-END-EXT-TS                                        
MFA-TR*             ,:FG-LAST-UPDATE-USERID                                     
MFA-TR*             ,:FG-OFFER-DESC-INT-LNG                                     
MFA-TR*             ,:FG-OFFER-DESC-EXT-LNG                                     
MFA-TR*             ,:FG-SPCL-OFFER-TYPE-CD                                     
MFA-TR*             ,:FG-RENEWAL-OFFER-CD                                       
MFA-TR*             ,:FG-RENEW-PUB-OFFER-CD                                     
MFA-TR*             ,:FG-OFF-VRSN-NO                                            
MFA-TR*             ,:FG-OFF-VSTART-TS                                          
MFA-TR*             ,:FG-OFF-VEND-TS                                            
MFA-TR*             ,:FG-PROC-STATUS-CD                                         
MFA-TR*             ,:FG-PROC-REQ-ID                                            
MFA-TR*             ,:FG-MAX-PRICE-OFFER-CD                                     
MFA-TR*             ,:FG-RTCHG-PUB-OFFER-CD                                     
MFA-TR*         FROM CRM_RT_PKG_OFFER FG                                        
MFA-TR*        WHERE FG.COMPANY_NO   = :FG-COMPANY-NO                           
MFA-TR*          AND FG.OFFER_CD     = :FG-OFFER-CD                             
MFA-TR*          AND FG.OFF_VRSN_NO  =                                          
MFA-TR*              ( SELECT MAX(F1.OFF_VRSN_NO)                               
MFA-TR*                  FROM CRM_RT_PKG_OFFER F1                               
MFA-TR*                 WHERE F1.COMPANY_NO     = FG.COMPANY_NO                 
MFA-TR*                   AND F1.OFFER_CD       = FG.OFFER_CD                   
MFA-TR*                   AND F1.PROC_STATUS_CD                                 
MFA-TR*                              = :WS-PROC-STATUS-APRVL-CMPLT)             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE FG-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FG-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7015-CHK-TMPLT-OFFR-EXISTS                                     *        
      ******************************************************************        
       7015-CHK-TMPLT-OFFR-EXISTS.                                      
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                    ,FG.OFF_VRSN_NO                                     
                INTO :WS-TMPLT-OFFER-EXISTS                             
                    ,:FG-OFF-VRSN-NO                                    
                FROM CRM_RT_PKG_OFFER FG WITH(READUNCOMMITTED)                  
               WHERE FG.COMPANY_NO   = :FG-COMPANY-NO                   
                 AND FG.OFFER_CD     = :FG-OFFER-CD                     
                 AND FG.PROC_REQ_ID  = :FG-PROC-REQ-ID                  
                 AND FG.OFF_VRSN_NO  =                                  
                     ( SELECT MAX(F1.OFF_VRSN_NO)                       
                         FROM CRM_RT_PKG_OFFER F1 WITH(READUNCOMMITTED)         
                        WHERE F1.COMPANY_NO     = FG.COMPANY_NO         
                          AND F1.OFFER_CD       = FG.OFFER_CD           
                          AND F1.PROC_STATUS_CD = :WS-PROC-STATUS-NEW)  
                                                                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*             ,FG.OFF_VRSN_NO                                             
MFA-TR*         INTO :WS-TMPLT-OFFER-EXISTS                                     
MFA-TR*             ,:FG-OFF-VRSN-NO                                            
MFA-TR*         FROM CRM_RT_PKG_OFFER FG                                        
MFA-TR*        WHERE FG.COMPANY_NO   = :FG-COMPANY-NO                           
MFA-TR*          AND FG.OFFER_CD     = :FG-OFFER-CD                             
MFA-TR*          AND FG.PROC_REQ_ID  = :FG-PROC-REQ-ID                          
MFA-TR*          AND FG.OFF_VRSN_NO  =                                          
MFA-TR*              ( SELECT MAX(F1.OFF_VRSN_NO)                               
MFA-TR*                  FROM CRM_RT_PKG_OFFER F1                               
MFA-TR*                 WHERE F1.COMPANY_NO     = FG.COMPANY_NO                 
MFA-TR*                   AND F1.OFFER_CD       = FG.OFFER_CD                   
MFA-TR*                   AND F1.PROC_STATUS_CD = :WS-PROC-STATUS-NEW)          
MFA-TR*                                                                         
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7015                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7015'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE FG-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FG-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-SELECT-TMPLT-OFF-MKT-TIER.                                         
      ******************************************************************        
       7020-SELECT-TMPLT-OFF-MKT-TIER.                                  
                                                                        
           EXEC SQL                                                     
               SELECT COMPANY_NO                                        
                     ,OFFER_CD                                          
                     ,TIER_CUST_STAT_CD                                 
                     ,TIER_ACCT_TYPE_CD                                 
                     ,MKT_TIER_RANKING                                  
                     ,MKT_TIER_START_DT                                 
                     ,OFFER_TIER_STRT_DT                                
                     ,MKT_TIER_APPLY_CD                                 
                     ,TIER_DEFLT_OFFR_CD                                
                     ,OFFER_TIER_END_DT                                 
                     ,LAST_UPDATE_USERID                                
                     ,OFF_TIER_VRSN_NO                                  
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           OFF_TIER_VSTART_TS, 121), ' ', '-'), ':', '.') 
           OFF_TIER_VSTART_TS                                
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), OFF_TIER_VEND_TS
           , 121), ' ', '-'), ':', '.') OFF_TIER_VEND_TS                       
                     ,PROC_STATUS_CD                                    
                     ,PROC_REQ_ID                                       
                 INTO :DU-COMPANY-NO                                    
                     ,:DU-OFFER-CD                                      
                     ,:DU-TIER-CUST-STAT-CD                             
                     ,:DU-TIER-ACCT-TYPE-CD                             
                     ,:DU-MKT-TIER-RANKING                              
                     ,:DU-MKT-TIER-START-DT                             
                     ,:DU-OFFER-TIER-STRT-DT                            
                     ,:DU-MKT-TIER-APPLY-CD                             
                     ,:DU-TIER-DEFLT-OFFR-CD                            
                     ,:DU-OFFER-TIER-END-DT                             
                     ,:DU-LAST-UPDATE-USERID                            
                     ,:DU-OFF-TIER-VRSN-NO                              
                     ,:DU-OFF-TIER-VSTART-TS                            
                     ,:DU-OFF-TIER-VEND-TS                              
                     ,:DU-PROC-STATUS-CD                                
                     ,:DU-PROC-REQ-ID                                   
                 FROM CRM_OFF_MKT_TIER DU                               
                WHERE DU.COMPANY_NO        = :DU-COMPANY-NO             
                  AND DU.OFFER_CD          = :DU-OFFER-CD               
                  AND DU.TIER_CUST_STAT_CD = :DU-TIER-CUST-STAT-CD      
                  AND DU.TIER_ACCT_TYPE_CD = :DU-TIER-ACCT-TYPE-CD      
                  AND DU.MKT_TIER_RANKING  = :DU-MKT-TIER-RANKING       
                  AND DU.MKT_TIER_START_DT = IIF(TRY_CONVERT(DATE, 
                                                  :DU-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DU-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:DU-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:DU-MKT-TIER-START-DT
              ), CONVERT(DATE, :DU-MKT-TIER-START-DT) )      
                  AND DU.OFF_TIER_VRSN_NO  =                            
                   ( SELECT MAX(D1.OFF_TIER_VRSN_NO)                    
                       FROM CRM_OFF_MKT_TIER D1                         
                      WHERE D1.COMPANY_NO        = DU.COMPANY_NO        
                        AND D1.OFFER_CD          = DU.OFFER_CD          
                        AND D1.TIER_CUST_STAT_CD = DU.TIER_CUST_STAT_CD 
                        AND D1.TIER_ACCT_TYPE_CD = DU.TIER_ACCT_TYPE_CD 
                        AND D1.MKT_TIER_RANKING  = DU.MKT_TIER_RANKING  
                        AND D1.MKT_TIER_START_DT = DU.MKT_TIER_START_DT 
                        AND D1.PROC_STATUS_CD                           
                                      = :WS-PROC-STATUS-APRVL-CMPLT)    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NO                                                
MFA-TR*              ,OFFER_CD                                                  
MFA-TR*              ,TIER_CUST_STAT_CD                                         
MFA-TR*              ,TIER_ACCT_TYPE_CD                                         
MFA-TR*              ,MKT_TIER_RANKING                                          
MFA-TR*              ,MKT_TIER_START_DT                                         
MFA-TR*              ,OFFER_TIER_STRT_DT                                        
MFA-TR*              ,MKT_TIER_APPLY_CD                                         
MFA-TR*              ,TIER_DEFLT_OFFR_CD                                        
MFA-TR*              ,OFFER_TIER_END_DT                                         
MFA-TR*              ,LAST_UPDATE_USERID                                        
MFA-TR*              ,OFF_TIER_VRSN_NO                                          
MFA-TR*              ,OFF_TIER_VSTART_TS                                        
MFA-TR*              ,OFF_TIER_VEND_TS                                          
MFA-TR*              ,PROC_STATUS_CD                                            
MFA-TR*              ,PROC_REQ_ID                                               
MFA-TR*          INTO :DU-COMPANY-NO                                            
MFA-TR*              ,:DU-OFFER-CD                                              
MFA-TR*              ,:DU-TIER-CUST-STAT-CD                                     
MFA-TR*              ,:DU-TIER-ACCT-TYPE-CD                                     
MFA-TR*              ,:DU-MKT-TIER-RANKING                                      
MFA-TR*              ,:DU-MKT-TIER-START-DT                                     
MFA-TR*              ,:DU-OFFER-TIER-STRT-DT                                    
MFA-TR*              ,:DU-MKT-TIER-APPLY-CD                                     
MFA-TR*              ,:DU-TIER-DEFLT-OFFR-CD                                    
MFA-TR*              ,:DU-OFFER-TIER-END-DT                                     
MFA-TR*              ,:DU-LAST-UPDATE-USERID                                    
MFA-TR*              ,:DU-OFF-TIER-VRSN-NO                                      
MFA-TR*              ,:DU-OFF-TIER-VSTART-TS                                    
MFA-TR*              ,:DU-OFF-TIER-VEND-TS                                      
MFA-TR*              ,:DU-PROC-STATUS-CD                                        
MFA-TR*              ,:DU-PROC-REQ-ID                                           
MFA-TR*          FROM CRM_OFF_MKT_TIER DU                                       
MFA-TR*         WHERE DU.COMPANY_NO        = :DU-COMPANY-NO                     
MFA-TR*           AND DU.OFFER_CD          = :DU-OFFER-CD                       
MFA-TR*           AND DU.TIER_CUST_STAT_CD = :DU-TIER-CUST-STAT-CD              
MFA-TR*           AND DU.TIER_ACCT_TYPE_CD = :DU-TIER-ACCT-TYPE-CD              
MFA-TR*           AND DU.MKT_TIER_RANKING  = :DU-MKT-TIER-RANKING               
MFA-TR*           AND DU.MKT_TIER_START_DT = :DU-MKT-TIER-START-DT              
MFA-TR*           AND DU.OFF_TIER_VRSN_NO  =                                    
MFA-TR*            ( SELECT MAX(D1.OFF_TIER_VRSN_NO)                            
MFA-TR*                FROM CRM_OFF_MKT_TIER D1                                 
MFA-TR*               WHERE D1.COMPANY_NO        = DU.COMPANY_NO                
MFA-TR*                 AND D1.OFFER_CD          = DU.OFFER_CD                  
MFA-TR*                 AND D1.TIER_CUST_STAT_CD = DU.TIER_CUST_STAT_CD         
MFA-TR*                 AND D1.TIER_ACCT_TYPE_CD = DU.TIER_ACCT_TYPE_CD         
MFA-TR*                 AND D1.MKT_TIER_RANKING  = DU.MKT_TIER_RANKING          
MFA-TR*                 AND D1.MKT_TIER_START_DT = DU.MKT_TIER_START_DT         
MFA-TR*                 AND D1.PROC_STATUS_CD                                   
MFA-TR*                               = :WS-PROC-STATUS-APRVL-CMPLT)            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFF_MKT_TIER'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE 'TIER_CUST_STAT_CD'       TO TABLE-ELEMENT-3         
              MOVE 'TIER_ACCT_TYPE_CD'       TO TABLE-ELEMENT-4         
              MOVE DU-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE DU-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              MOVE DU-TIER-CUST-STAT-CD      TO HOSTVAR-ELEMENT-3       
              MOVE DU-TIER-ACCT-TYPE-CD      TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7021-OPEN-UNDEFLT-OFFR-TIERS.                                           
      ******************************************************************        
       7021-OPEN-UNDEFLT-OFFR-TIERS.                                    
                                                                        
           EXEC SQL                                                     
               OPEN UNDEFLT_OFFR_TIERS                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7021'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'UNDEFLT_OFFR_TIERS'      TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE DU-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7021-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7022-FETCH-UNDEFLT-OFFR-TIERS.                                          
      ******************************************************************        
       7022-FETCH-UNDEFLT-OFFR-TIERS.                                   
                                                                        
           EXEC SQL                                                     
               FETCH UNDEFLT_OFFR_TIERS                                 
                 INTO :DU-COMPANY-NO                                    
                     ,:DU-OFFER-CD                                      
                     ,:DU-TIER-CUST-STAT-CD                             
                     ,:DU-TIER-ACCT-TYPE-CD                             
                     ,:DU-MKT-TIER-RANKING                              
                     ,:DU-MKT-TIER-START-DT                             
                     ,:DU-OFFER-TIER-STRT-DT                            
                     ,:DU-MKT-TIER-APPLY-CD                             
                     ,:DU-TIER-DEFLT-OFFR-CD                            
                     ,:DU-OFFER-TIER-END-DT                             
                     ,:DU-LAST-UPDATE-USERID                            
                     ,:DU-OFF-TIER-VRSN-NO                              
                     ,:DU-OFF-TIER-VSTART-TS                            
                     ,:DU-OFF-TIER-VEND-TS                              
                     ,:DU-PROC-STATUS-CD                                
                     ,:DU-PROC-REQ-ID                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 SET NO-MORE-OFFER-TIER-ROWS TO TRUE                    
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7022'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'UNDEFLT_OFFR_TIERS'      TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE DU-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7022-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7023-CLOSE-UNDEFLT-OFFR-TIERS.                                          
      ******************************************************************        
       7023-CLOSE-UNDEFLT-OFFR-TIERS.                                   
                                                                        
           EXEC SQL                                                     
               CLOSE UNDEFLT_OFFR_TIERS                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7023'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'UNDEFLT_OFFR_TIERS'      TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE DU-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7023-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7025-CHK-TMPLT-OFF-MKT-EXISTS.                                          
      ******************************************************************        
       7025-CHK-TMPLT-OFF-MKT-EXISTS.                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-TMPLT-OFFMKT-TIER-EXISTS                      
                 FROM CRM_OFF_MKT_TIER DU                               
                WHERE DU.COMPANY_NO        = :DU-COMPANY-NO             
                  AND DU.OFFER_CD          = :DU-OFFER-CD               
                  AND DU.PROC_REQ_ID       = :DU-PROC-REQ-ID            
                  AND DU.PROC_STATUS_CD    = :WS-PROC-STATUS-NEW        
                                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-TMPLT-OFFMKT-TIER-EXISTS                              
MFA-TR*          FROM CRM_OFF_MKT_TIER DU                                       
MFA-TR*         WHERE DU.COMPANY_NO        = :DU-COMPANY-NO                     
MFA-TR*           AND DU.OFFER_CD          = :DU-OFFER-CD                       
MFA-TR*           AND DU.PROC_REQ_ID       = :DU-PROC-REQ-ID                    
MFA-TR*           AND DU.PROC_STATUS_CD    = :WS-PROC-STATUS-NEW                
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*       QUERYNO 7025                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7025'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFF_MKT_TIER'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE 'TIER_CUST_STAT_CD'       TO TABLE-ELEMENT-3         
              MOVE 'TIER_ACCT_TYPE_CD'       TO TABLE-ELEMENT-4         
              MOVE DU-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE DU-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              MOVE DU-TIER-CUST-STAT-CD      TO HOSTVAR-ELEMENT-3       
              MOVE DU-TIER-ACCT-TYPE-CD      TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7050-GET-OFFR-STRT-END-DTS                                     *        
      ******************************************************************        
       7050-GET-OFFR-STRT-END-DTS.                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) FG.OFFER_START_DT,
              FG.OFFER_END_DT                                   
                 INTO :FG-OFFER-START-DT                                
                     ,:FG-OFFER-END-DT                                  
                 FROM CRM_RT_PKG_OFFER FG WITH(READUNCOMMITTED)                 
                WHERE FG.COMPANY_NO        = :FG-COMPANY-NO             
                  AND FG.OFFER_CD          = :FG-OFFER-CD               
                  AND FG.PROC_STATUS_CD    = :FG-PROC-STATUS-CD         
                ORDER BY FG.OFF_VRSN_NO DESC                            
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FG.OFFER_START_DT                                         
MFA-TR*              ,FG.OFFER_END_DT                                           
MFA-TR*          INTO :FG-OFFER-START-DT                                        
MFA-TR*              ,:FG-OFFER-END-DT                                          
MFA-TR*          FROM CRM_RT_PKG_OFFER FG                                       
MFA-TR*         WHERE FG.COMPANY_NO        = :FG-COMPANY-NO                     
MFA-TR*           AND FG.OFFER_CD          = :FG-OFFER-CD                       
MFA-TR*           AND FG.PROC_STATUS_CD    = :FG-PROC-STATUS-CD                 
MFA-TR*         ORDER BY FG.OFF_VRSN_NO DESC                                    
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7050'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE 'PROC_STATUS_CD_CD'       TO TABLE-ELEMENT-2         
              MOVE FG-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              MOVE FG-PROC-STATUS-CD         TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7060-GET-MAX-ATTR-SEQ-NO                                       *        
      ******************************************************************        
       7060-GET-MAX-ATTR-SEQ-NO.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(HQ.ATTR_INCTV_SEQ_NO)                         
                 INTO :WS-MAX-ATTR-SEQ-NO :WS-MAX-ATTR-SEQ-NO-NULL       
                 FROM CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)               
                WHERE HQ.COMPANY_NO         = :HQ-COMPANY-NO            
                  AND HQ.OPTION_CD          = :HQ-OPTION-CD             
                  AND HQ.RT_ATTR_INCTV_TYPE = :HQ-RT-ATTR-INCTV-TYPE    
                  AND HQ.ATTR_INCTV_STRT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )    
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(HQ.ATTR_INCTV_SEQ_NO)                                 
MFA-TR*          INTO :WS-MAX-ATTR-SEQ-NO:WS-MAX-ATTR-SEQ-NO-NULL               
MFA-TR*          FROM CRM_OPT_ATTR_INCTV HQ                                     
MFA-TR*         WHERE HQ.COMPANY_NO         = :HQ-COMPANY-NO                    
MFA-TR*           AND HQ.OPTION_CD          = :HQ-OPTION-CD                     
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE = :HQ-RT-ATTR-INCTV-TYPE            
MFA-TR*           AND HQ.ATTR_INCTV_STRT_DT = :HQ-ATTR-INCTV-STRT-DT            
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7060                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-MAX-ATTR-SEQ-NO-NULL = -1                           
                 MOVE ZERO                   TO WS-MAX-ATTR-SEQ-NO      
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7060'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OPT_ATTR_INCTV'      TO TABLE-1                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE 'RT_ATTR_INCTV_TYPE'      TO TABLE-ELEMENT-2         
              MOVE HQ-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              MOVE HQ-RT-ATTR-INCTV-TYPE     TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-GET-MAX-ATTR-SEQ-NO                                       *        
      ******************************************************************        
       7100-GET-MAX-ATTR-SEQ-NO.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(HQ.ATTR_INCTV_SEQ_NO)                         
                 INTO :WS-MAX-ATTR-SEQ-NO :WS-MAX-ATTR-SEQ-NO-NULL       
                 FROM CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)               
                WHERE HQ.COMPANY_NO         = :HQ-COMPANY-NO            
                  AND HQ.OPTION_CD          = :HQ-OPTION-CD             
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(HQ.ATTR_INCTV_SEQ_NO)                                 
MFA-TR*          INTO :WS-MAX-ATTR-SEQ-NO:WS-MAX-ATTR-SEQ-NO-NULL               
MFA-TR*          FROM CRM_OPT_ATTR_INCTV HQ                                     
MFA-TR*         WHERE HQ.COMPANY_NO         = :HQ-COMPANY-NO                    
MFA-TR*           AND HQ.OPTION_CD          = :HQ-OPTION-CD                     
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-MAX-ATTR-SEQ-NO-NULL = -1                           
                 MOVE ZERO                   TO WS-MAX-ATTR-SEQ-NO      
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OPT_ATTR_INCTV'      TO TABLE-1                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE HQ-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7105-GET-CURRENT-TIMESTAMP.                                    *        
      ******************************************************************        
       7105-GET-CURRENT-TIMESTAMP.                                      
                                                                        
           EXEC SQL                                                     
                 SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CRM-CURRENT-TIMESTAMP      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SET :WS-CRM-CURRENT-TIMESTAMP = CURRENT TIMESTAMP              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7105'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              PERFORM 9910-SQL-ERROR           THRU 9910-EXIT           
           END-IF.                                                      
                                                                        
       7105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7110-GET-OFFER-MAX-VRSN                                        *        
      ******************************************************************        
       7110-GET-OFFER-MAX-VRSN.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(FG.OFF_VRSN_NO)                               
                 INTO :WS-MAX-PROC-VRSN-NO :WS-MAX-PROC-VRSN-NO-NULL     
                 FROM CRM_RT_PKG_OFFER FG WITH(READUNCOMMITTED)                 
                WHERE FG.COMPANY_NO        = :FG-COMPANY-NO             
                  AND FG.OFFER_CD          = :FG-OFFER-CD               
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(FG.OFF_VRSN_NO)                                       
MFA-TR*          INTO :WS-MAX-PROC-VRSN-NO:WS-MAX-PROC-VRSN-NO-NULL             
MFA-TR*          FROM CRM_RT_PKG_OFFER FG                                       
MFA-TR*         WHERE FG.COMPANY_NO        = :FG-COMPANY-NO                     
MFA-TR*           AND FG.OFFER_CD          = :FG-OFFER-CD                       
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7110                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-MAX-PROC-VRSN-NO-NULL = -1                          
                 MOVE ZERO                   TO WS-MAX-PROC-VRSN-NO     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7110'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE FG-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7115-GET-OFFER-MAX-APRVL-VRSN                                  *        
      ******************************************************************        
       7115-GET-OFFER-MAX-APRVL-VRSN.                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(FG.OFF_VRSN_NO)                               
                 INTO :WS-MAX-APRVL-VRSN :WS-MAX-APRVL-VRSN-NULL         
                 FROM CRM_RT_PKG_OFFER FG WITH(READUNCOMMITTED)                 
                WHERE FG.COMPANY_NO        = :FG-COMPANY-NO             
                  AND FG.OFFER_CD          = :FG-OFFER-CD               
                  AND FG.PROC_STATUS_CD    = :WS-PROC-STATUS-APRVL-CMPLT
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(FG.OFF_VRSN_NO)                                       
MFA-TR*          INTO :WS-MAX-APRVL-VRSN:WS-MAX-APRVL-VRSN-NULL                 
MFA-TR*          FROM CRM_RT_PKG_OFFER FG                                       
MFA-TR*         WHERE FG.COMPANY_NO        = :FG-COMPANY-NO                     
MFA-TR*           AND FG.OFFER_CD          = :FG-OFFER-CD                       
MFA-TR*           AND FG.PROC_STATUS_CD    = :WS-PROC-STATUS-APRVL-CMPLT        
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7115                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-MAX-APRVL-VRSN-NULL = -1                            
                 MOVE ZERO                   TO WS-MAX-APRVL-VRSN       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7115'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE FG-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7115-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7120-GET-OPTION-MAX-VRSN                                                
      ******************************************************************        
       7120-GET-OPTION-MAX-VRSN.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(FI.OPT_VRSN_NO)                               
                 INTO :WS-MAX-PROC-VRSN-NO :WS-MAX-PROC-VRSN-NO-NULL     
                 FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
                WHERE FI.COMPANY_NO        = :FI-COMPANY-NO             
                  AND FI.OPTION_CD         = :FI-OPTION-CD              
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(FI.OPT_VRSN_NO)                                       
MFA-TR*          INTO :WS-MAX-PROC-VRSN-NO:WS-MAX-PROC-VRSN-NO-NULL             
MFA-TR*          FROM CRM_RT_PKG_OPTION FI                                      
MFA-TR*         WHERE FI.COMPANY_NO        = :FI-COMPANY-NO                     
MFA-TR*           AND FI.OPTION_CD         = :FI-OPTION-CD                      
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7120                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-MAX-PROC-VRSN-NO-NULL = -1                          
                 MOVE ZERO                   TO WS-MAX-PROC-VRSN-NO     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7120'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OPTION'       TO TABLE-1                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE FI-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7125-GET-OPTION-MAX-APRVL-VRSN.                                         
      ******************************************************************        
       7125-GET-OPTION-MAX-APRVL-VRSN.                                  
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(FI.OPT_VRSN_NO)                               
                 INTO :WS-MAX-APRVL-VRSN :WS-MAX-APRVL-VRSN-NULL         
                 FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
                WHERE FI.COMPANY_NO     = :FI-COMPANY-NO                
                  AND FI.OPTION_CD      = :FI-OPTION-CD                 
                  AND FI.PROC_STATUS_CD = :WS-PROC-STATUS-APRVL-CMPLT   
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(FI.OPT_VRSN_NO)                                       
MFA-TR*          INTO :WS-MAX-APRVL-VRSN:WS-MAX-APRVL-VRSN-NULL                 
MFA-TR*          FROM CRM_RT_PKG_OPTION FI                                      
MFA-TR*         WHERE FI.COMPANY_NO     = :FI-COMPANY-NO                        
MFA-TR*           AND FI.OPTION_CD      = :FI-OPTION-CD                         
MFA-TR*           AND FI.PROC_STATUS_CD = :WS-PROC-STATUS-APRVL-CMPLT           
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7125                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-MAX-APRVL-VRSN-NULL = -1                            
                 MOVE ZERO                   TO WS-MAX-APRVL-VRSN       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7125'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OPTION'       TO TABLE-1                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE FI-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7125-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7130-GET-PROMO-MAX-VRSN                                                 
      ******************************************************************        
       7130-GET-PROMO-MAX-VRSN.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(KM.PROMO_VRSN_NO)                             
                 INTO :WS-MAX-PROC-VRSN-NO :WS-MAX-PROC-VRSN-NO-NULL     
                 FROM CRM_MKT_PROMOTION KM WITH(READUNCOMMITTED)                
                WHERE KM.COMPANY_NO        = :KM-COMPANY-NO             
                  AND KM.PROMO_CD          = :KM-PROMO-CD               
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(KM.PROMO_VRSN_NO)                                     
MFA-TR*          INTO :WS-MAX-PROC-VRSN-NO:WS-MAX-PROC-VRSN-NO-NULL             
MFA-TR*          FROM CRM_MKT_PROMOTION KM                                      
MFA-TR*         WHERE KM.COMPANY_NO        = :KM-COMPANY-NO                     
MFA-TR*           AND KM.PROMO_CD          = :KM-PROMO-CD                       
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7130                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-MAX-PROC-VRSN-NO-NULL = -1                          
                 MOVE ZERO                   TO WS-MAX-PROC-VRSN-NO     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7130'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_MKT_PROMOTION'       TO TABLE-1                 
              MOVE 'PROMO_CD'                TO TABLE-ELEMENT-1         
              MOVE KM-PROMO-CD               TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7135-GET-PROMO-MAX-APRVL-VRSN                                           
      ******************************************************************        
       7135-GET-PROMO-MAX-APRVL-VRSN.                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(KM.PROMO_VRSN_NO)                             
                 INTO :WS-MAX-APRVL-VRSN :WS-MAX-APRVL-VRSN-NULL         
                 FROM CRM_MKT_PROMOTION KM WITH(READUNCOMMITTED)                
                WHERE KM.COMPANY_NO     = :KM-COMPANY-NO                
                  AND KM.PROMO_CD       = :KM-PROMO-CD                  
                  AND KM.PROC_STATUS_CD = :WS-PROC-STATUS-APRVL-CMPLT   
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(KM.PROMO_VRSN_NO)                                     
MFA-TR*          INTO :WS-MAX-APRVL-VRSN:WS-MAX-APRVL-VRSN-NULL                 
MFA-TR*          FROM CRM_MKT_PROMOTION KM                                      
MFA-TR*         WHERE KM.COMPANY_NO     = :KM-COMPANY-NO                        
MFA-TR*           AND KM.PROMO_CD       = :KM-PROMO-CD                          
MFA-TR*           AND KM.PROC_STATUS_CD = :WS-PROC-STATUS-APRVL-CMPLT           
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7130                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-MAX-APRVL-VRSN-NULL = -1                            
                 MOVE ZERO                   TO WS-MAX-APRVL-VRSN       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7135'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_MKT_PROMOTION'       TO TABLE-1                 
              MOVE 'PROMO_CD'                TO TABLE-ELEMENT-1         
              MOVE KM-PROMO-CD               TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7135-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7140-GET-OFFER-TIER-MAX-VRSN                                            
      ******************************************************************        
       7140-GET-OFFER-TIER-MAX-VRSN.                                    
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(DU.OFF_TIER_VRSN_NO)                          
                 INTO :WS-MAX-PROC-VRSN-NO :WS-MAX-PROC-VRSN-NO-NULL     
                 FROM CRM_OFF_MKT_TIER DU WITH(READUNCOMMITTED)                 
                WHERE DU.COMPANY_NO         = :DU-COMPANY-NO            
                  AND DU.OFFER_CD           = :DU-OFFER-CD              
                  AND DU.TIER_CUST_STAT_CD  = :DU-TIER-CUST-STAT-CD     
                  AND DU.TIER_ACCT_TYPE_CD  = :DU-TIER-ACCT-TYPE-CD     
                  AND DU.MKT_TIER_RANKING   = :DU-MKT-TIER-RANKING      
                  AND DU.MKT_TIER_START_DT  = IIF(TRY_CONVERT(DATE, 
                                                  :DU-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DU-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:DU-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:DU-MKT-TIER-START-DT
              ), CONVERT(DATE, :DU-MKT-TIER-START-DT) )     
                  AND DU.OFFER_TIER_STRT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :DU-OFFER-TIER-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :DU-OFFER-TIER-STRT-DT
              ) <> 0) OR (LEN(:DU-OFFER-TIER-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:DU-OFFER-TIER-STRT-DT
              ), CONVERT(DATE, :DU-OFFER-TIER-STRT-DT) )    
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(DU.OFF_TIER_VRSN_NO)                                  
MFA-TR*          INTO :WS-MAX-PROC-VRSN-NO:WS-MAX-PROC-VRSN-NO-NULL             
MFA-TR*          FROM CRM_OFF_MKT_TIER DU                                       
MFA-TR*         WHERE DU.COMPANY_NO         = :DU-COMPANY-NO                    
MFA-TR*           AND DU.OFFER_CD           = :DU-OFFER-CD                      
MFA-TR*           AND DU.TIER_CUST_STAT_CD  = :DU-TIER-CUST-STAT-CD             
MFA-TR*           AND DU.TIER_ACCT_TYPE_CD  = :DU-TIER-ACCT-TYPE-CD             
MFA-TR*           AND DU.MKT_TIER_RANKING   = :DU-MKT-TIER-RANKING              
MFA-TR*           AND DU.MKT_TIER_START_DT  = :DU-MKT-TIER-START-DT             
MFA-TR*           AND DU.OFFER_TIER_STRT_DT = :DU-OFFER-TIER-STRT-DT            
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7140                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-MAX-PROC-VRSN-NO-NULL = -1                          
                 MOVE ZERO                   TO WS-MAX-PROC-VRSN-NO     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7140'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFF_MKT_TIER'        TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE 'OFFER_TIER_STRT_DT'      TO TABLE-ELEMENT-2         
              MOVE DU-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              MOVE DU-OFFER-TIER-STRT-DT     TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7145-GET-OFF-MKT-MAX-AC-VRSN                                            
      ******************************************************************        
       7145-GET-OFF-MKT-MAX-AC-VRSN.                                    
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(DU.OFF_TIER_VRSN_NO)                          
                 INTO :WS-MAX-APRVL-VRSN :WS-MAX-APRVL-VRSN-NULL         
                 FROM CRM_OFF_MKT_TIER DU WITH(READUNCOMMITTED)                 
                WHERE DU.COMPANY_NO         = :DU-COMPANY-NO            
                  AND DU.OFFER_CD           = :DU-OFFER-CD              
                  AND DU.TIER_CUST_STAT_CD  = :DU-TIER-CUST-STAT-CD     
                  AND DU.TIER_ACCT_TYPE_CD  = :DU-TIER-ACCT-TYPE-CD     
                  AND DU.MKT_TIER_RANKING   = :DU-MKT-TIER-RANKING      
                  AND DU.MKT_TIER_START_DT  = IIF(TRY_CONVERT(DATE, 
                                                  :DU-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DU-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:DU-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:DU-MKT-TIER-START-DT
              ), CONVERT(DATE, :DU-MKT-TIER-START-DT) )     
                  AND DU.OFFER_TIER_STRT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :DU-OFFER-TIER-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :DU-OFFER-TIER-STRT-DT
              ) <> 0) OR (LEN(:DU-OFFER-TIER-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:DU-OFFER-TIER-STRT-DT
              ), CONVERT(DATE, :DU-OFFER-TIER-STRT-DT) )    
                  AND DU.PROC_STATUS_CD    = :WS-PROC-STATUS-APRVL-CMPLT
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(DU.OFF_TIER_VRSN_NO)                                  
MFA-TR*          INTO :WS-MAX-APRVL-VRSN:WS-MAX-APRVL-VRSN-NULL                 
MFA-TR*          FROM CRM_OFF_MKT_TIER DU                                       
MFA-TR*         WHERE DU.COMPANY_NO         = :DU-COMPANY-NO                    
MFA-TR*           AND DU.OFFER_CD           = :DU-OFFER-CD                      
MFA-TR*           AND DU.TIER_CUST_STAT_CD  = :DU-TIER-CUST-STAT-CD             
MFA-TR*           AND DU.TIER_ACCT_TYPE_CD  = :DU-TIER-ACCT-TYPE-CD             
MFA-TR*           AND DU.MKT_TIER_RANKING   = :DU-MKT-TIER-RANKING              
MFA-TR*           AND DU.MKT_TIER_START_DT  = :DU-MKT-TIER-START-DT             
MFA-TR*           AND DU.OFFER_TIER_STRT_DT = :DU-OFFER-TIER-STRT-DT            
MFA-TR*           AND DU.PROC_STATUS_CD    = :WS-PROC-STATUS-APRVL-CMPLT        
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7140                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-MAX-APRVL-VRSN-NULL = -1                            
                 MOVE ZERO                   TO WS-MAX-APRVL-VRSN       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7145'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFF_MKT_TIER'        TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE 'OFFER_TIER_STRT_DT'      TO TABLE-ELEMENT-2         
              MOVE DU-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              MOVE DU-OFFER-TIER-STRT-DT     TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7145-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7150-GET-CRM-ACCESS-MAX-VRSN                                            
      ******************************************************************        
       7150-GET-CRM-ACCESS-MAX-VRSN.                                    
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(CI.ACCESS_VRSN_NO)                            
                 INTO :WS-MAX-PROC-VRSN-NO :WS-MAX-PROC-VRSN-NO-NULL     
                 FROM CRM_ACCESS_OFF_OPT CI WITH(READUNCOMMITTED)               
                WHERE CI.COMPANY_NO       = :CI-COMPANY-NO              
                  AND CI.OPTION_CD        = :CI-OPTION-CD               
                  AND CI.OFFER_CD         = :CI-OFFER-CD                
                  AND CI.CATEGORY_ID      = :CI-CATEGORY-ID             
      *           AND CI.ACCESS_START_DT  = :CI-ACCESS-START-DT                 
      *           AND CI.VIEW_APPLY_CD    = :CI-VIEW-APPLY-CD                   
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(CI.ACCESS_VRSN_NO)                                    
MFA-TR*          INTO :WS-MAX-PROC-VRSN-NO:WS-MAX-PROC-VRSN-NO-NULL             
MFA-TR*          FROM CRM_ACCESS_OFF_OPT CI                                     
MFA-TR*         WHERE CI.COMPANY_NO       = :CI-COMPANY-NO                      
MFA-TR*           AND CI.OPTION_CD        = :CI-OPTION-CD                       
MFA-TR*           AND CI.OFFER_CD         = :CI-OFFER-CD                        
MFA-TR*           AND CI.CATEGORY_ID      = :CI-CATEGORY-ID                     
MFA-TR*           AND CI.ACCESS_START_DT  = :CI-ACCESS-START-DT                 
MFA-TR*           AND CI.VIEW_APPLY_CD    = :CI-VIEW-APPLY-CD                   
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7150                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-MAX-PROC-VRSN-NO-NULL = -1                          
                 MOVE ZERO                   TO WS-MAX-PROC-VRSN-NO     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7150'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_ACCESS_OFF_OPT'      TO TABLE-1                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE 'CATEGORY_ID'             TO TABLE-ELEMENT-3         
              MOVE CI-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              MOVE CI-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              MOVE CI-CATEGORY-ID            TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7155-GET-ACCESS-MAX-APRVL-VRSN                                          
      ******************************************************************        
       7155-GET-ACCESS-MAX-APRVL-VRSN.                                  
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(CI.ACCESS_VRSN_NO)                            
                 INTO :WS-MAX-APRVL-VRSN :WS-MAX-APRVL-VRSN-NULL         
                 FROM CRM_ACCESS_OFF_OPT CI WITH(READUNCOMMITTED)               
                WHERE CI.COMPANY_NO       = :CI-COMPANY-NO              
                  AND CI.OPTION_CD        = :CI-OPTION-CD               
                  AND CI.OFFER_CD         = :CI-OFFER-CD                
                  AND CI.CATEGORY_ID      = :CI-CATEGORY-ID             
                  AND CI.PROC_STATUS_CD   = :WS-PROC-STATUS-APRVL-CMPLT 
      *           AND CI.ACCESS_START_DT  = :CI-ACCESS-START-DT                 
      *           AND CI.VIEW_APPLY_CD    = :CI-VIEW-APPLY-CD                   
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(CI.ACCESS_VRSN_NO)                                    
MFA-TR*          INTO :WS-MAX-APRVL-VRSN:WS-MAX-APRVL-VRSN-NULL                 
MFA-TR*          FROM CRM_ACCESS_OFF_OPT CI                                     
MFA-TR*         WHERE CI.COMPANY_NO       = :CI-COMPANY-NO                      
MFA-TR*           AND CI.OPTION_CD        = :CI-OPTION-CD                       
MFA-TR*           AND CI.OFFER_CD         = :CI-OFFER-CD                        
MFA-TR*           AND CI.CATEGORY_ID      = :CI-CATEGORY-ID                     
MFA-TR*           AND CI.PROC_STATUS_CD   = :WS-PROC-STATUS-APRVL-CMPLT         
MFA-TR*           AND CI.ACCESS_START_DT  = :CI-ACCESS-START-DT                 
MFA-TR*           AND CI.VIEW_APPLY_CD    = :CI-VIEW-APPLY-CD                   
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7155                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-MAX-APRVL-VRSN-NULL = -1                            
                 MOVE ZERO                   TO WS-MAX-APRVL-VRSN       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7155'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_ACCESS_OFF_OPT'      TO TABLE-1                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE 'CATEGORY_ID'             TO TABLE-ELEMENT-3         
              MOVE CI-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              MOVE CI-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              MOVE CI-CATEGORY-ID            TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7155-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7160-GET-RATE-GRP-MAX-VRSN                                              
      ******************************************************************        
       7160-GET-RATE-GRP-MAX-VRSN.                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(G5.GRP_OFF_VRSN_NO)                           
                 INTO :WS-MAX-PROC-VRSN-NO :WS-MAX-PROC-VRSN-NO-NULL     
                 FROM CRM_RATE_GRP_OFFER G5 WITH(READUNCOMMITTED)               
                WHERE G5.COMPANY_NO         = :G5-COMPANY-NO            
                  AND G5.RATE_GROUP_TYPE_CD = :G5-RATE-GROUP-TYPE-CD    
                  AND G5.RATE_GROUP_CD      = :G5-RATE-GROUP-CD         
      *           AND G5.SORT_SEQ_NO        = :G5-SORT-SEQ-NO                   
                  AND G5.EFF_START_DT       = IIF(TRY_CONVERT(DATE, 
                                                       :G5-EFF-START-DT
              ) IS NULL OR (PATINDEX('%.%', :G5-EFF-START-DT
              ) <> 0) OR (LEN(:G5-EFF-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :G5-EFF-START-DT
              ), CONVERT(DATE, :G5-EFF-START-DT) )          
                  AND G5.OFFER_CD           = :G5-OFFER-CD              
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(G5.GRP_OFF_VRSN_NO)                                   
MFA-TR*          INTO :WS-MAX-PROC-VRSN-NO:WS-MAX-PROC-VRSN-NO-NULL             
MFA-TR*          FROM CRM_RATE_GRP_OFFER G5                                     
MFA-TR*         WHERE G5.COMPANY_NO         = :G5-COMPANY-NO                    
MFA-TR*           AND G5.RATE_GROUP_TYPE_CD = :G5-RATE-GROUP-TYPE-CD            
MFA-TR*           AND G5.RATE_GROUP_CD      = :G5-RATE-GROUP-CD                 
MFA-TR*           AND G5.SORT_SEQ_NO        = :G5-SORT-SEQ-NO                   
MFA-TR*           AND G5.EFF_START_DT       = :G5-EFF-START-DT                  
MFA-TR*           AND G5.OFFER_CD           = :G5-OFFER-CD                      
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7160                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-MAX-PROC-VRSN-NO-NULL = -1                          
                 MOVE ZERO                   TO WS-MAX-PROC-VRSN-NO     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7160'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RATE_GRP_OFFER'      TO TABLE-1                 
              MOVE 'RATE_GROUP_TYPE_CD'      TO TABLE-ELEMENT-1         
              MOVE 'RATE_GROUP_CD'           TO TABLE-ELEMENT-2         
              MOVE 'SORT_SEQ_NO'             TO TABLE-ELEMENT-3         
              MOVE 'EFF_START_DT'            TO TABLE-ELEMENT-4         
              MOVE G5-RATE-GROUP-TYPE-CD     TO HOSTVAR-ELEMENT-1       
              MOVE G5-RATE-GROUP-CD          TO HOSTVAR-ELEMENT-2       
              MOVE G5-SORT-SEQ-NO            TO HOSTVAR-ELEMENT-3       
              MOVE G5-EFF-START-DT           TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7162-GET-RATE-GRP-DETAILS                                               
      ******************************************************************        
       7162-GET-RATE-GRP-DETAILS.                                       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) G5.SORT_SEQ_NO,
              G5.EFF_START_DT                                   
                 INTO :WS-SORT-SEQ-NO                                   
                     ,:WS-EFF-START-DT                                  
                 FROM CRM_RATE_GRP_OFFER G5 WITH(READUNCOMMITTED)               
                WHERE G5.COMPANY_NO         = :G5-COMPANY-NO            
                  AND G5.RATE_GROUP_TYPE_CD = :G5-RATE-GROUP-TYPE-CD    
                  AND G5.RATE_GROUP_CD      = :G5-RATE-GROUP-CD         
                  AND G5.GRP_OFF_VRSN_NO    = :G5-GRP-OFF-VRSN-NO       
                  AND G5.OFFER_CD           = :G5-OFFER-CD              
                ORDER BY GRP_OFF_VSTART_TS DESC                         
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT G5.SORT_SEQ_NO                                            
MFA-TR*              ,G5.EFF_START_DT                                           
MFA-TR*          INTO :WS-SORT-SEQ-NO                                           
MFA-TR*              ,:WS-EFF-START-DT                                          
MFA-TR*          FROM CRM_RATE_GRP_OFFER G5                                     
MFA-TR*         WHERE G5.COMPANY_NO         = :G5-COMPANY-NO                    
MFA-TR*           AND G5.RATE_GROUP_TYPE_CD = :G5-RATE-GROUP-TYPE-CD            
MFA-TR*           AND G5.RATE_GROUP_CD      = :G5-RATE-GROUP-CD                 
MFA-TR*           AND G5.GRP_OFF_VRSN_NO    = :G5-GRP-OFF-VRSN-NO               
MFA-TR*           AND G5.OFFER_CD           = :G5-OFFER-CD                      
MFA-TR*         ORDER BY GRP_OFF_VSTART_TS DESC                                 
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7162                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7162'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RATE_GRP_OFFER'      TO TABLE-1                 
              MOVE 'RATE_GROUP_TYPE_CD'      TO TABLE-ELEMENT-1         
              MOVE 'RATE_GROUP_CD'           TO TABLE-ELEMENT-2         
              MOVE 'GRP_OFF_VRSN_NO'         TO TABLE-ELEMENT-2         
              MOVE G5-RATE-GROUP-TYPE-CD     TO HOSTVAR-ELEMENT-1       
              MOVE G5-RATE-GROUP-CD          TO HOSTVAR-ELEMENT-2       
              MOVE G5-GRP-OFF-VRSN-NO        TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7162-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7165-GET-RT-GRP-MAX-APRVL-VRSN                                          
      ******************************************************************        
       7165-GET-RT-GRP-MAX-APRVL-VRSN.                                  
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(G5.GRP_OFF_VRSN_NO)                           
                 INTO :WS-MAX-APRVL-VRSN :WS-MAX-APRVL-VRSN-NULL         
                 FROM CRM_RATE_GRP_OFFER G5 WITH(READUNCOMMITTED)               
                WHERE G5.COMPANY_NO         = :G5-COMPANY-NO            
                  AND G5.OFFER_CD           = :G5-OFFER-CD              
                  AND G5.RATE_GROUP_TYPE_CD = :G5-RATE-GROUP-TYPE-CD    
                  AND G5.RATE_GROUP_CD      = :G5-RATE-GROUP-CD         
      *           AND G5.SORT_SEQ_NO        = :G5-SORT-SEQ-NO                   
                  AND G5.EFF_START_DT       = IIF(TRY_CONVERT(DATE, 
                                                       :G5-EFF-START-DT
              ) IS NULL OR (PATINDEX('%.%', :G5-EFF-START-DT
              ) <> 0) OR (LEN(:G5-EFF-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :G5-EFF-START-DT
              ), CONVERT(DATE, :G5-EFF-START-DT) )          
                  AND G5.PROC_STATUS_CD    = :WS-PROC-STATUS-APRVL-CMPLT
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(G5.GRP_OFF_VRSN_NO)                                   
MFA-TR*          INTO :WS-MAX-APRVL-VRSN:WS-MAX-APRVL-VRSN-NULL                 
MFA-TR*          FROM CRM_RATE_GRP_OFFER G5                                     
MFA-TR*         WHERE G5.COMPANY_NO         = :G5-COMPANY-NO                    
MFA-TR*           AND G5.OFFER_CD           = :G5-OFFER-CD                      
MFA-TR*           AND G5.RATE_GROUP_TYPE_CD = :G5-RATE-GROUP-TYPE-CD            
MFA-TR*           AND G5.RATE_GROUP_CD      = :G5-RATE-GROUP-CD                 
MFA-TR*           AND G5.SORT_SEQ_NO        = :G5-SORT-SEQ-NO                   
MFA-TR*           AND G5.EFF_START_DT       = :G5-EFF-START-DT                  
MFA-TR*           AND G5.PROC_STATUS_CD    = :WS-PROC-STATUS-APRVL-CMPLT        
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7165                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-MAX-APRVL-VRSN-NULL = -1                            
                 MOVE ZERO                   TO WS-MAX-APRVL-VRSN       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7165'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RATE_GRP_OFFER'      TO TABLE-1                 
              MOVE 'RATE_GROUP_TYPE_CD'      TO TABLE-ELEMENT-1         
              MOVE 'RATE_GROUP_CD'           TO TABLE-ELEMENT-2         
              MOVE 'SORT_SEQ_NO'             TO TABLE-ELEMENT-3         
              MOVE 'EFF_START_DT'            TO TABLE-ELEMENT-4         
              MOVE G5-RATE-GROUP-TYPE-CD     TO HOSTVAR-ELEMENT-1       
              MOVE G5-RATE-GROUP-CD          TO HOSTVAR-ELEMENT-2       
              MOVE G5-SORT-SEQ-NO            TO HOSTVAR-ELEMENT-3       
              MOVE G5-EFF-START-DT           TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7165-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7170-GET-OFFR-OPT-MAX-VRSN                                              
      ******************************************************************        
       7170-GET-OFFR-OPT-MAX-VRSN.                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(E9.OFF_OPT_VRSN_NO)                           
                 INTO :WS-MAX-PROC-VRSN-NO :WS-MAX-PROC-VRSN-NO-NULL     
                 FROM CRM_OFFER_OPTION E9 WITH(READUNCOMMITTED)                 
                WHERE E9.COMPANY_NO         = :E9-COMPANY-NO            
                  AND E9.OFFER_CD           = :E9-OFFER-CD              
                  AND E9.OPTION_CD          = :E9-OPTION-CD             
                  AND E9.OFFER_OPT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                 :E9-OFFER-OPT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :E9-OFFER-OPT-START-DT
              ) <> 0) OR (LEN(:E9-OFFER-OPT-START-DT
              ) <> 10), CIS.CHAR2DATE(:E9-OFFER-OPT-START-DT
              ), CONVERT(DATE, :E9-OFFER-OPT-START-DT) )    
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(E9.OFF_OPT_VRSN_NO)                                   
MFA-TR*          INTO :WS-MAX-PROC-VRSN-NO:WS-MAX-PROC-VRSN-NO-NULL             
MFA-TR*          FROM CRM_OFFER_OPTION E9                                       
MFA-TR*         WHERE E9.COMPANY_NO         = :E9-COMPANY-NO                    
MFA-TR*           AND E9.OFFER_CD           = :E9-OFFER-CD                      
MFA-TR*           AND E9.OPTION_CD          = :E9-OPTION-CD                     
MFA-TR*           AND E9.OFFER_OPT_START_DT = :E9-OFFER-OPT-START-DT            
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7170                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-MAX-PROC-VRSN-NO-NULL = -1                          
                 MOVE ZERO                   TO WS-MAX-PROC-VRSN-NO     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7170'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFFER_OPTION'        TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE 'OFFER_OPT_START_DT'      TO TABLE-ELEMENT-3         
              MOVE E9-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              MOVE E9-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              MOVE E9-OFFER-OPT-START-DT     TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7175-GET-OFFR-OPT-MAX-AC-VRSN                                           
      ******************************************************************        
       7175-GET-OFFR-OPT-MAX-AC-VRSN.                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(E9.OFF_OPT_VRSN_NO)                           
                 INTO :WS-MAX-APRVL-VRSN :WS-MAX-APRVL-VRSN-NULL         
                 FROM CRM_OFFER_OPTION E9 WITH(READUNCOMMITTED)                 
                WHERE E9.COMPANY_NO         = :E9-COMPANY-NO            
                  AND E9.OFFER_CD           = :E9-OFFER-CD              
                  AND E9.OPTION_CD          = :E9-OPTION-CD             
                  AND E9.OFFER_OPT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                 :E9-OFFER-OPT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :E9-OFFER-OPT-START-DT
              ) <> 0) OR (LEN(:E9-OFFER-OPT-START-DT
              ) <> 10), CIS.CHAR2DATE(:E9-OFFER-OPT-START-DT
              ), CONVERT(DATE, :E9-OFFER-OPT-START-DT) )    
                  AND E9.PROC_STATUS_CD    = :WS-PROC-STATUS-APRVL-CMPLT
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(E9.OFF_OPT_VRSN_NO)                                   
MFA-TR*          INTO :WS-MAX-APRVL-VRSN:WS-MAX-APRVL-VRSN-NULL                 
MFA-TR*          FROM CRM_OFFER_OPTION E9                                       
MFA-TR*         WHERE E9.COMPANY_NO         = :E9-COMPANY-NO                    
MFA-TR*           AND E9.OFFER_CD           = :E9-OFFER-CD                      
MFA-TR*           AND E9.OPTION_CD          = :E9-OPTION-CD                     
MFA-TR*           AND E9.OFFER_OPT_START_DT = :E9-OFFER-OPT-START-DT            
MFA-TR*           AND E9.PROC_STATUS_CD    = :WS-PROC-STATUS-APRVL-CMPLT        
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7175                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-MAX-APRVL-VRSN-NULL = -1                            
                 MOVE ZERO                   TO WS-MAX-APRVL-VRSN       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7175'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFFER_OPTION'        TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE 'OFFER_OPT_START_DT'      TO TABLE-ELEMENT-3         
              MOVE E9-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              MOVE E9-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              MOVE E9-OFFER-OPT-START-DT     TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7175-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7180-GET-OPT-ATRB-MAX-VRSN                                              
      ******************************************************************        
       7180-GET-OPT-ATRB-MAX-VRSN.                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(HQ.OPT_ATTR_VRSN_NO)                          
                 INTO :WS-MAX-PROC-VRSN-NO :WS-MAX-PROC-VRSN-NO-NULL     
                 FROM CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)               
                WHERE HQ.COMPANY_NO         = :HQ-COMPANY-NO            
                  AND HQ.OPTION_CD          = :HQ-OPTION-CD             
                  AND HQ.ATTR_INCTV_SEQ_NO  = :HQ-ATTR-INCTV-SEQ-NO     
                  AND HQ.ATTR_INCTV_STRT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )    
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(HQ.OPT_ATTR_VRSN_NO)                                  
MFA-TR*          INTO :WS-MAX-PROC-VRSN-NO:WS-MAX-PROC-VRSN-NO-NULL             
MFA-TR*          FROM CRM_OPT_ATTR_INCTV HQ                                     
MFA-TR*         WHERE HQ.COMPANY_NO         = :HQ-COMPANY-NO                    
MFA-TR*           AND HQ.OPTION_CD          = :HQ-OPTION-CD                     
MFA-TR*           AND HQ.ATTR_INCTV_SEQ_NO  = :HQ-ATTR-INCTV-SEQ-NO             
MFA-TR*           AND HQ.ATTR_INCTV_STRT_DT = :HQ-ATTR-INCTV-STRT-DT            
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7180                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-MAX-PROC-VRSN-NO-NULL = -1                          
                 MOVE ZERO                   TO WS-MAX-PROC-VRSN-NO     
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7180'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OPT_ATTR_INCTV'      TO TABLE-1                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE 'ATTR_INCTV_SEQ_NO'       TO TABLE-ELEMENT-2         
              MOVE HQ-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              MOVE HQ-ATTR-INCTV-SEQ-NO      TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7185-GET-OPT-ATRB-MAX-AC-VRSN                                           
      ******************************************************************        
       7185-GET-OPT-ATRB-MAX-AC-VRSN.                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(HQ.OPT_ATTR_VRSN_NO)                          
                 INTO :WS-MAX-APRVL-VRSN :WS-MAX-APRVL-VRSN-NULL         
                 FROM CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)               
                WHERE HQ.COMPANY_NO         = :HQ-COMPANY-NO            
                  AND HQ.OPTION_CD          = :HQ-OPTION-CD             
                  AND HQ.ATTR_INCTV_SEQ_NO  = :HQ-ATTR-INCTV-SEQ-NO     
                  AND HQ.ATTR_INCTV_STRT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )    
                  AND HQ.PROC_STATUS_CD    = :WS-PROC-STATUS-APRVL-CMPLT
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(HQ.OPT_ATTR_VRSN_NO)                                  
MFA-TR*          INTO :WS-MAX-APRVL-VRSN:WS-MAX-APRVL-VRSN-NULL                 
MFA-TR*          FROM CRM_OPT_ATTR_INCTV HQ                                     
MFA-TR*         WHERE HQ.COMPANY_NO         = :HQ-COMPANY-NO                    
MFA-TR*           AND HQ.OPTION_CD          = :HQ-OPTION-CD                     
MFA-TR*           AND HQ.ATTR_INCTV_SEQ_NO  = :HQ-ATTR-INCTV-SEQ-NO             
MFA-TR*           AND HQ.ATTR_INCTV_STRT_DT = :HQ-ATTR-INCTV-STRT-DT            
MFA-TR*           AND HQ.PROC_STATUS_CD    = :WS-PROC-STATUS-APRVL-CMPLT        
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7185                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-MAX-APRVL-VRSN-NULL = -1                            
                 MOVE ZERO                   TO WS-MAX-APRVL-VRSN       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7185'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OPT_ATTR_INCTV'      TO TABLE-1                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE 'ATTR_INCTV_SEQ_NO'       TO TABLE-ELEMENT-2         
              MOVE HQ-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              MOVE HQ-ATTR-INCTV-SEQ-NO      TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7185-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8010-UPT-PROC-REQ-EFF-TS.                                      *        
      ******************************************************************        
       8010-UPT-PROC-REQ-EFF-TS.                                        
                                                                        
           EXEC SQL                                                     
               UPDATE [1P]                                 
                  SET EFFECTIVE_TS = CIS.CHAR2TIMESTAMP(:1P-EFFECTIVE-TS
              )                   
               FROM CSS_PROCESS_REQ [1P]
                WHERE PROC_REQ_ID = :1P-PROC-REQ-ID                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_PROCESS_REQ 1P                                        
MFA-TR*           SET EFFECTIVE_TS = :1P-EFFECTIVE-TS                           
MFA-TR*         WHERE PROC_REQ_ID = :1P-PROC-REQ-ID                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_PROCESS_REQ'         TO TABLE-1                 
              MOVE 'PROC_REQ_ID'             TO TABLE-ELEMENT-1         
              MOVE 1P-PROC-REQ-ID            TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8030-INS-MKT-PROMO.                                            *        
      ******************************************************************        
       8030-INS-MKT-PROMO.                                              
                                                                        
           EXEC SQL                                                     
               INSERT INTO CRM_MKT_PROMOTION                            
               (                                                        
                  COMPANY_NO                                            
                 ,PROMO_CD                                              
                 ,PROMO_DESC                                            
                 ,OFFER_CD                                              
                 ,MKT_PLAN_CD                                           
                 ,PROMO_START_DT                                        
                 ,PROMO_START_TM                                        
                 ,PROMO_END_DT                                          
                 ,PROMO_END_TM                                          
                 ,AD_CHANNEL_CD                                         
                 ,PROMO_DESC_LONG                                       
                 ,EXT_LANDING_PG_URL                                    
                 ,PROMO_TYPE_CD                                         
                 ,WEB_IMAGE_FILE_NM                                     
                 ,LAST_UPDATE_USERID                                    
                 ,LAST_UPDATE_TS                                        
                 ,REPLACMNT_PROMO_CD                                    
                 ,DISPLAY_END_DT                                        
                 ,INT_LANDING_PG_URL                                    
                 ,PROMO_VRSN_NO                                         
                 ,PROMO_VSTART_TS                                       
                 ,PROMO_VEND_TS                                         
                 ,PROC_STATUS_CD                                        
                 ,PROC_REQ_ID                                           
               )                                                        
               VALUES                                                   
               (                                                        
                  :KM-COMPANY-NO                                        
                 ,:KM-PROMO-CD                                          
                 ,:KM-PROMO-DESC                                        
                 ,:KM-OFFER-CD                                          
                 ,:KM-MKT-PLAN-CD                                       
                 ,IIF(TRY_CONVERT(DATE, :KM-PROMO-START-DT
              ) IS NULL OR (PATINDEX('%.%', :KM-PROMO-START-DT
              ) <> 0) OR (LEN(:KM-PROMO-START-DT
              ) <> 10), CIS.CHAR2DATE(:KM-PROMO-START-DT
              ), CONVERT(DATE, :KM-PROMO-START-DT) )                           
                 ,CIS.CHAR2TIME(:KM-PROMO-START-TM)                             
                 ,IIF(TRY_CONVERT(DATE, :KM-PROMO-END-DT
              ) IS NULL OR (PATINDEX('%.%', :KM-PROMO-END-DT
              ) <> 0) OR (LEN(:KM-PROMO-END-DT) <> 10), CIS.CHAR2DATE(
                                                       :KM-PROMO-END-DT
              ), CONVERT(DATE, :KM-PROMO-END-DT) )                             
                 ,CIS.CHAR2TIME(:KM-PROMO-END-TM)                               
                 ,:KM-AD-CHANNEL-CD                                     
                 ,:KM-PROMO-DESC-LONG                                   
                 ,:KM-EXT-LANDING-PG-URL                                
                 ,:KM-PROMO-TYPE-CD                                     
                 ,:KM-WEB-IMAGE-FILE-NM                                 
                 ,:KM-LAST-UPDATE-USERID                                
                 ,CIS.CHAR2TIMESTAMP(:KM-LAST-UPDATE-TS)                        
                 ,:KM-REPLACMNT-PROMO-CD                                
                 ,IIF(TRY_CONVERT(DATE, :KM-DISPLAY-END-DT
              ) IS NULL OR (PATINDEX('%.%', :KM-DISPLAY-END-DT
              ) <> 0) OR (LEN(:KM-DISPLAY-END-DT
              ) <> 10), CIS.CHAR2DATE(:KM-DISPLAY-END-DT
              ), CONVERT(DATE, :KM-DISPLAY-END-DT) )                           
                 ,:KM-INT-LANDING-PG-URL                                
                 ,:KM-PROMO-VRSN-NO                                     
                 ,CIS.CHAR2TIMESTAMP(:KM-PROMO-VSTART-TS)                       
                 ,CIS.CHAR2TIMESTAMP(:KM-PROMO-VEND-TS)                         
                 ,:KM-PROC-STATUS-CD                                    
                 ,:KM-PROC-REQ-ID                                       
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CRM_MKT_PROMOTION                                    
MFA-TR*        (                                                                
MFA-TR*           COMPANY_NO                                                    
MFA-TR*          ,PROMO_CD                                                      
MFA-TR*          ,PROMO_DESC                                                    
MFA-TR*          ,OFFER_CD                                                      
MFA-TR*          ,MKT_PLAN_CD                                                   
MFA-TR*          ,PROMO_START_DT                                                
MFA-TR*          ,PROMO_START_TM                                                
MFA-TR*          ,PROMO_END_DT                                                  
MFA-TR*          ,PROMO_END_TM                                                  
MFA-TR*          ,AD_CHANNEL_CD                                                 
MFA-TR*          ,PROMO_DESC_LONG                                               
MFA-TR*          ,EXT_LANDING_PG_URL                                            
MFA-TR*          ,PROMO_TYPE_CD                                                 
MFA-TR*          ,WEB_IMAGE_FILE_NM                                             
MFA-TR*          ,LAST_UPDATE_USERID                                            
MFA-TR*          ,LAST_UPDATE_TS                                                
MFA-TR*          ,REPLACMNT_PROMO_CD                                            
MFA-TR*          ,DISPLAY_END_DT                                                
MFA-TR*          ,INT_LANDING_PG_URL                                            
MFA-TR*          ,PROMO_VRSN_NO                                                 
MFA-TR*          ,PROMO_VSTART_TS                                               
MFA-TR*          ,PROMO_VEND_TS                                                 
MFA-TR*          ,PROC_STATUS_CD                                                
MFA-TR*          ,PROC_REQ_ID                                                   
MFA-TR*        )                                                                
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*           :KM-COMPANY-NO                                                
MFA-TR*          ,:KM-PROMO-CD                                                  
MFA-TR*          ,:KM-PROMO-DESC                                                
MFA-TR*          ,:KM-OFFER-CD                                                  
MFA-TR*          ,:KM-MKT-PLAN-CD                                               
MFA-TR*          ,:KM-PROMO-START-DT                                            
MFA-TR*          ,:KM-PROMO-START-TM                                            
MFA-TR*          ,:KM-PROMO-END-DT                                              
MFA-TR*          ,:KM-PROMO-END-TM                                              
MFA-TR*          ,:KM-AD-CHANNEL-CD                                             
MFA-TR*          ,:KM-PROMO-DESC-LONG                                           
MFA-TR*          ,:KM-EXT-LANDING-PG-URL                                        
MFA-TR*          ,:KM-PROMO-TYPE-CD                                             
MFA-TR*          ,:KM-WEB-IMAGE-FILE-NM                                         
MFA-TR*          ,:KM-LAST-UPDATE-USERID                                        
MFA-TR*          ,:KM-LAST-UPDATE-TS                                            
MFA-TR*          ,:KM-REPLACMNT-PROMO-CD                                        
MFA-TR*          ,:KM-DISPLAY-END-DT                                            
MFA-TR*          ,:KM-INT-LANDING-PG-URL                                        
MFA-TR*          ,:KM-PROMO-VRSN-NO                                             
MFA-TR*          ,:KM-PROMO-VSTART-TS                                           
MFA-TR*          ,:KM-PROMO-VEND-TS                                             
MFA-TR*          ,:KM-PROC-STATUS-CD                                            
MFA-TR*          ,:KM-PROC-REQ-ID                                               
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8030'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_MKT_PROMOTION'       TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PROMO_CD'                TO TABLE-ELEMENT-2         
              MOVE KM-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE KM-PROMO-CD               TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8040-UPT-MKT-PROMO.                                            *        
      ******************************************************************        
       8040-UPT-MKT-PROMO.                                              
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_MKT_PROMOTION                                 
                  SET PROMO_DESC         = :KM-PROMO-DESC               
                     ,OFFER_CD           = :KM-OFFER-CD                 
                     ,MKT_PLAN_CD        = :KM-MKT-PLAN-CD              
                     ,PROMO_START_DT     = IIF(TRY_CONVERT(DATE, 
                                                     :KM-PROMO-START-DT
              ) IS NULL OR (PATINDEX('%.%', :KM-PROMO-START-DT
              ) <> 0) OR (LEN(:KM-PROMO-START-DT
              ) <> 10), CIS.CHAR2DATE(:KM-PROMO-START-DT
              ), CONVERT(DATE, :KM-PROMO-START-DT) )           
                     ,PROMO_START_TM     = CIS.CHAR2TIME(
                                                     :KM-PROMO-START-TM
              )           
                     ,PROMO_END_DT       = IIF(TRY_CONVERT(DATE, 
                                                       :KM-PROMO-END-DT
              ) IS NULL OR (PATINDEX('%.%', :KM-PROMO-END-DT
              ) <> 0) OR (LEN(:KM-PROMO-END-DT) <> 10), CIS.CHAR2DATE(
                                                       :KM-PROMO-END-DT
              ), CONVERT(DATE, :KM-PROMO-END-DT) )             
                     ,PROMO_END_TM       = CIS.CHAR2TIME(
                                                       :KM-PROMO-END-TM
              )             
                     ,AD_CHANNEL_CD      = :KM-AD-CHANNEL-CD            
                     ,PROMO_DESC_LONG    = :KM-PROMO-DESC-LONG          
                     ,EXT_LANDING_PG_URL = :KM-EXT-LANDING-PG-URL       
                     ,PROMO_TYPE_CD      = :KM-PROMO-TYPE-CD            
                     ,WEB_IMAGE_FILE_NM  = :KM-WEB-IMAGE-FILE-NM        
                     ,LAST_UPDATE_USERID = :KM-LAST-UPDATE-USERID       
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :KM-LAST-UPDATE-TS
              )           
                     ,REPLACMNT_PROMO_CD = :KM-REPLACMNT-PROMO-CD       
                     ,DISPLAY_END_DT     = IIF(TRY_CONVERT(DATE, 
                                                     :KM-DISPLAY-END-DT
              ) IS NULL OR (PATINDEX('%.%', :KM-DISPLAY-END-DT
              ) <> 0) OR (LEN(:KM-DISPLAY-END-DT
              ) <> 10), CIS.CHAR2DATE(:KM-DISPLAY-END-DT
              ), CONVERT(DATE, :KM-DISPLAY-END-DT) )           
                     ,INT_LANDING_PG_URL = :KM-INT-LANDING-PG-URL       
                     ,PROMO_VSTART_TS    = CIS.CHAR2TIMESTAMP(
                                                    :KM-PROMO-VSTART-TS
              )          
                     ,PROMO_VEND_TS      = CIS.CHAR2TIMESTAMP(
                                                      :KM-PROMO-VEND-TS
              )            
                     ,PROC_STATUS_CD     = :KM-PROC-STATUS-CD           
      *              ,PROC_REQ_ID        = :KM-PROC-REQ-ID                      
                WHERE COMPANY_NO         = :KM-COMPANY-NO               
                  AND PROMO_CD           = :KM-PROMO-CD                 
                  AND PROMO_VRSN_NO      = :KM-PROMO-VRSN-NO            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_MKT_PROMOTION                                         
MFA-TR*           SET PROMO_DESC         = :KM-PROMO-DESC                       
MFA-TR*              ,OFFER_CD           = :KM-OFFER-CD                         
MFA-TR*              ,MKT_PLAN_CD        = :KM-MKT-PLAN-CD                      
MFA-TR*              ,PROMO_START_DT     = :KM-PROMO-START-DT                   
MFA-TR*              ,PROMO_START_TM     = :KM-PROMO-START-TM                   
MFA-TR*              ,PROMO_END_DT       = :KM-PROMO-END-DT                     
MFA-TR*              ,PROMO_END_TM       = :KM-PROMO-END-TM                     
MFA-TR*              ,AD_CHANNEL_CD      = :KM-AD-CHANNEL-CD                    
MFA-TR*              ,PROMO_DESC_LONG    = :KM-PROMO-DESC-LONG                  
MFA-TR*              ,EXT_LANDING_PG_URL = :KM-EXT-LANDING-PG-URL               
MFA-TR*              ,PROMO_TYPE_CD      = :KM-PROMO-TYPE-CD                    
MFA-TR*              ,WEB_IMAGE_FILE_NM  = :KM-WEB-IMAGE-FILE-NM                
MFA-TR*              ,LAST_UPDATE_USERID = :KM-LAST-UPDATE-USERID               
MFA-TR*              ,LAST_UPDATE_TS     = :KM-LAST-UPDATE-TS                   
MFA-TR*              ,REPLACMNT_PROMO_CD = :KM-REPLACMNT-PROMO-CD               
MFA-TR*              ,DISPLAY_END_DT     = :KM-DISPLAY-END-DT                   
MFA-TR*              ,INT_LANDING_PG_URL = :KM-INT-LANDING-PG-URL               
MFA-TR*              ,PROMO_VSTART_TS    = :KM-PROMO-VSTART-TS                  
MFA-TR*              ,PROMO_VEND_TS      = :KM-PROMO-VEND-TS                    
MFA-TR*              ,PROC_STATUS_CD     = :KM-PROC-STATUS-CD                   
MFA-TR*              ,PROC_REQ_ID        = :KM-PROC-REQ-ID                      
MFA-TR*         WHERE COMPANY_NO         = :KM-COMPANY-NO                       
MFA-TR*           AND PROMO_CD           = :KM-PROMO-CD                         
MFA-TR*           AND PROMO_VRSN_NO      = :KM-PROMO-VRSN-NO                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8040'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_MKT_PROMOTION'       TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PROMO_CD'                TO TABLE-ELEMENT-2         
              MOVE KM-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE KM-PROMO-CD               TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8042-UPT-MKT-PROMO-VENDTS                                      *        
      ******************************************************************        
       8042-UPT-MKT-PROMO-VENDTS.                                       
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_MKT_PROMOTION                                 
                  SET PROMO_VEND_TS                                     
                  = DATEADD( MICROSECOND, -1, ( CIS.CHAR2TIMESTAMP (
                                                :KM-PROMO-VSTART-TS ) )
               )
                     ,LAST_UPDATE_USERID = :KM-LAST-UPDATE-USERID       
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :KM-LAST-UPDATE-TS
              )           
                WHERE COMPANY_NO         = :KM-COMPANY-NO               
                  AND PROMO_CD           = :KM-PROMO-CD                 
                  AND PROMO_VRSN_NO      = :WS-MAX-APRVL-VRSN           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_MKT_PROMOTION                                         
MFA-TR*           SET PROMO_VEND_TS                                             
MFA-TR*           = ( TIMESTAMP (:KM-PROMO-VSTART-TS ) ) - 1 MICROSECOND        
MFA-TR*              ,LAST_UPDATE_USERID = :KM-LAST-UPDATE-USERID               
MFA-TR*              ,LAST_UPDATE_TS     = :KM-LAST-UPDATE-TS                   
MFA-TR*         WHERE COMPANY_NO         = :KM-COMPANY-NO                       
MFA-TR*           AND PROMO_CD           = :KM-PROMO-CD                         
MFA-TR*           AND PROMO_VRSN_NO      = :WS-MAX-APRVL-VRSN                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8042'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_MKT_PROMOTION'       TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PROMO_CD'                TO TABLE-ELEMENT-2         
              MOVE KM-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE KM-PROMO-CD               TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8042-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8044-UPT-MKT-PROMO-STATUS                                      *        
      ******************************************************************        
       8044-UPT-MKT-PROMO-STATUS.                                       
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_MKT_PROMOTION                                 
                  SET PROC_STATUS_CD     = :KM-PROC-STATUS-CD           
                 ,LAST_UPDATE_USERID     = :KM-LAST-UPDATE-USERID       
                 ,LAST_UPDATE_TS         = CIS.CHAR2TIMESTAMP(
                                                     :KM-LAST-UPDATE-TS
              )           
                WHERE COMPANY_NO         = :KM-COMPANY-NO               
                  AND PROMO_CD           = :KM-PROMO-CD                 
                  AND PROMO_VRSN_NO      = :KM-PROMO-VRSN-NO            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_MKT_PROMOTION                                         
MFA-TR*           SET PROC_STATUS_CD     = :KM-PROC-STATUS-CD                   
MFA-TR*          ,LAST_UPDATE_USERID     = :KM-LAST-UPDATE-USERID               
MFA-TR*          ,LAST_UPDATE_TS         = :KM-LAST-UPDATE-TS                   
MFA-TR*         WHERE COMPANY_NO         = :KM-COMPANY-NO                       
MFA-TR*           AND PROMO_CD           = :KM-PROMO-CD                         
MFA-TR*           AND PROMO_VRSN_NO      = :KM-PROMO-VRSN-NO                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8044'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_MKT_PROMOTION'       TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PROMO_CD'                TO TABLE-ELEMENT-2         
              MOVE KM-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE KM-PROMO-CD               TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8044-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8045-DEL-MKT-PROMO                                             *        
      ******************************************************************        
       8045-DEL-MKT-PROMO.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM CRM_MKT_PROMOTION                            
                WHERE COMPANY_NO         = :KM-COMPANY-NO               
                  AND PROMO_CD           = :KM-PROMO-CD                 
                  AND PROMO_VRSN_NO      = :KM-PROMO-VRSN-NO            
                  AND PROC_STATUS_CD     = :WS-PROC-STATUS-NEW          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8045'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_MKT_PROMOTION'       TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PROMO_CD'                TO TABLE-ELEMENT-2         
              MOVE KM-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE KM-PROMO-CD               TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8045-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8050-INS-RT-PKG-OFFER.                                         *        
      ******************************************************************        
       8050-INS-RT-PKG-OFFER.                                           
                                                                        
           EXEC SQL                                                     
               INSERT INTO CRM_RT_PKG_OFFER                             
               (                                                        
                  COMPANY_NO                                            
                 ,OFFER_CD                                              
                 ,OFFER_DESC_INT                                        
                 ,OFFER_DESC_EXT                                        
                 ,PROMO_CD_INT_FL                                       
                 ,PROMO_CD_EXT_FL                                       
                 ,OFFER_START_DT                                        
                 ,OFFER_END_DT                                          
                 ,DISP_START_INT_TS                                     
                 ,DISP_END_INT_TS                                       
                 ,DISP_START_EXT_TS                                     
                 ,DISP_END_EXT_TS                                       
                 ,LAST_UPDATE_TS                                        
                 ,LAST_UPDATE_USERID                                    
                 ,OFFER_DESC_INT_LNG                                    
                 ,OFFER_DESC_EXT_LNG                                    
                 ,SPCL_OFFER_TYPE_CD                                    
                 ,RENEWAL_OFFER_CD                                      
                 ,RENEW_PUB_OFFER_CD                                    
                 ,OFF_VRSN_NO                                           
                 ,OFF_VSTART_TS                                         
                 ,OFF_VEND_TS                                           
                 ,PROC_STATUS_CD                                        
                 ,PROC_REQ_ID                                           
PRJ680           ,MAX_PRICE_OFFER_CD                                    
P00863           ,RTCHG_PUB_OFFER_CD                                    
               )                                                        
               VALUES                                                   
               (                                                        
                  :FG-COMPANY-NO                                        
                 ,:FG-OFFER-CD                                          
                 ,:FG-OFFER-DESC-INT                                    
                 ,:FG-OFFER-DESC-EXT                                    
                 ,:FG-PROMO-CD-INT-FL                                   
                 ,:FG-PROMO-CD-EXT-FL                                   
                 ,IIF(TRY_CONVERT(DATE, :FG-OFFER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :FG-OFFER-START-DT
              ) <> 0) OR (LEN(:FG-OFFER-START-DT
              ) <> 10), CIS.CHAR2DATE(:FG-OFFER-START-DT
              ), CONVERT(DATE, :FG-OFFER-START-DT) )                           
                 ,IIF(TRY_CONVERT(DATE, :FG-OFFER-END-DT
              ) IS NULL OR (PATINDEX('%.%', :FG-OFFER-END-DT
              ) <> 0) OR (LEN(:FG-OFFER-END-DT) <> 10), CIS.CHAR2DATE(
                                                       :FG-OFFER-END-DT
              ), CONVERT(DATE, :FG-OFFER-END-DT) )                             
                 ,CIS.CHAR2TIMESTAMP(:FG-DISP-START-INT-TS)                     
                 ,CIS.CHAR2TIMESTAMP(:FG-DISP-END-INT-TS)                       
                 ,CIS.CHAR2TIMESTAMP(:FG-DISP-START-EXT-TS)                     
                 ,CIS.CHAR2TIMESTAMP(:FG-DISP-END-EXT-TS)                       
                 ,CIS.CHAR2TIMESTAMP(:FG-LAST-UPDATE-TS)                        
                 ,:FG-LAST-UPDATE-USERID                                
                 ,:FG-OFFER-DESC-INT-LNG                                
                 ,:FG-OFFER-DESC-EXT-LNG                                
                 ,:FG-SPCL-OFFER-TYPE-CD                                
                 ,:FG-RENEWAL-OFFER-CD                                  
                 ,:FG-RENEW-PUB-OFFER-CD                                
                 ,:FG-OFF-VRSN-NO                                       
                 ,CIS.CHAR2TIMESTAMP(:FG-OFF-VSTART-TS)                         
                 ,CIS.CHAR2TIMESTAMP(:FG-OFF-VEND-TS)                           
                 ,:FG-PROC-STATUS-CD                                    
                 ,:FG-PROC-REQ-ID                                       
PRJ680           ,:FG-MAX-PRICE-OFFER-CD                                
P00863           ,:FG-RTCHG-PUB-OFFER-CD                                
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CRM_RT_PKG_OFFER                                     
MFA-TR*        (                                                                
MFA-TR*           COMPANY_NO                                                    
MFA-TR*          ,OFFER_CD                                                      
MFA-TR*          ,OFFER_DESC_INT                                                
MFA-TR*          ,OFFER_DESC_EXT                                                
MFA-TR*          ,PROMO_CD_INT_FL                                               
MFA-TR*          ,PROMO_CD_EXT_FL                                               
MFA-TR*          ,OFFER_START_DT                                                
MFA-TR*          ,OFFER_END_DT                                                  
MFA-TR*          ,DISP_START_INT_TS                                             
MFA-TR*          ,DISP_END_INT_TS                                               
MFA-TR*          ,DISP_START_EXT_TS                                             
MFA-TR*          ,DISP_END_EXT_TS                                               
MFA-TR*          ,LAST_UPDATE_TS                                                
MFA-TR*          ,LAST_UPDATE_USERID                                            
MFA-TR*          ,OFFER_DESC_INT_LNG                                            
MFA-TR*          ,OFFER_DESC_EXT_LNG                                            
MFA-TR*          ,SPCL_OFFER_TYPE_CD                                            
MFA-TR*          ,RENEWAL_OFFER_CD                                              
MFA-TR*          ,RENEW_PUB_OFFER_CD                                            
MFA-TR*          ,OFF_VRSN_NO                                                   
MFA-TR*          ,OFF_VSTART_TS                                                 
MFA-TR*          ,OFF_VEND_TS                                                   
MFA-TR*          ,PROC_STATUS_CD                                                
MFA-TR*          ,PROC_REQ_ID                                                   
MFA-TR*          ,MAX_PRICE_OFFER_CD                                            
MFA-TR*          ,RTCHG_PUB_OFFER_CD                                            
MFA-TR*        )                                                                
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*           :FG-COMPANY-NO                                                
MFA-TR*          ,:FG-OFFER-CD                                                  
MFA-TR*          ,:FG-OFFER-DESC-INT                                            
MFA-TR*          ,:FG-OFFER-DESC-EXT                                            
MFA-TR*          ,:FG-PROMO-CD-INT-FL                                           
MFA-TR*          ,:FG-PROMO-CD-EXT-FL                                           
MFA-TR*          ,:FG-OFFER-START-DT                                            
MFA-TR*          ,:FG-OFFER-END-DT                                              
MFA-TR*          ,:FG-DISP-START-INT-TS                                         
MFA-TR*          ,:FG-DISP-END-INT-TS                                           
MFA-TR*          ,:FG-DISP-START-EXT-TS                                         
MFA-TR*          ,:FG-DISP-END-EXT-TS                                           
MFA-TR*          ,:FG-LAST-UPDATE-TS                                            
MFA-TR*          ,:FG-LAST-UPDATE-USERID                                        
MFA-TR*          ,:FG-OFFER-DESC-INT-LNG                                        
MFA-TR*          ,:FG-OFFER-DESC-EXT-LNG                                        
MFA-TR*          ,:FG-SPCL-OFFER-TYPE-CD                                        
MFA-TR*          ,:FG-RENEWAL-OFFER-CD                                          
MFA-TR*          ,:FG-RENEW-PUB-OFFER-CD                                        
MFA-TR*          ,:FG-OFF-VRSN-NO                                               
MFA-TR*          ,:FG-OFF-VSTART-TS                                             
MFA-TR*          ,:FG-OFF-VEND-TS                                               
MFA-TR*          ,:FG-PROC-STATUS-CD                                            
MFA-TR*          ,:FG-PROC-REQ-ID                                               
MFA-TR*          ,:FG-MAX-PRICE-OFFER-CD                                        
MFA-TR*          ,:FG-RTCHG-PUB-OFFER-CD                                        
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8050'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE FG-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FG-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8060-UPT-RT-PKG-OFFER.                                         *        
      ******************************************************************        
       8060-UPT-RT-PKG-OFFER.                                           
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_RT_PKG_OFFER                                  
                  SET OFFER_DESC_INT     = :FG-OFFER-DESC-INT           
                     ,OFFER_DESC_EXT     = :FG-OFFER-DESC-EXT           
                     ,PROMO_CD_INT_FL    = :FG-PROMO-CD-INT-FL          
                     ,PROMO_CD_EXT_FL    = :FG-PROMO-CD-EXT-FL          
                     ,OFFER_START_DT     = IIF(TRY_CONVERT(DATE, 
                                                     :FG-OFFER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :FG-OFFER-START-DT
              ) <> 0) OR (LEN(:FG-OFFER-START-DT
              ) <> 10), CIS.CHAR2DATE(:FG-OFFER-START-DT
              ), CONVERT(DATE, :FG-OFFER-START-DT) )           
                     ,OFFER_END_DT       = IIF(TRY_CONVERT(DATE, 
                                                       :FG-OFFER-END-DT
              ) IS NULL OR (PATINDEX('%.%', :FG-OFFER-END-DT
              ) <> 0) OR (LEN(:FG-OFFER-END-DT) <> 10), CIS.CHAR2DATE(
                                                       :FG-OFFER-END-DT
              ), CONVERT(DATE, :FG-OFFER-END-DT) )             
                     ,DISP_START_INT_TS  = CIS.CHAR2TIMESTAMP(
                                                  :FG-DISP-START-INT-TS
              )        
                     ,DISP_END_INT_TS    = CIS.CHAR2TIMESTAMP(
                                                    :FG-DISP-END-INT-TS
              )          
                     ,DISP_START_EXT_TS  = CIS.CHAR2TIMESTAMP(
                                                  :FG-DISP-START-EXT-TS
              )        
                     ,DISP_END_EXT_TS    = CIS.CHAR2TIMESTAMP(
                                                    :FG-DISP-END-EXT-TS
              )          
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :FG-LAST-UPDATE-TS
              )           
                     ,LAST_UPDATE_USERID = :FG-LAST-UPDATE-USERID       
                     ,OFFER_DESC_INT_LNG = :FG-OFFER-DESC-INT-LNG       
                     ,OFFER_DESC_EXT_LNG = :FG-OFFER-DESC-EXT-LNG       
                     ,SPCL_OFFER_TYPE_CD = :FG-SPCL-OFFER-TYPE-CD       
                     ,RENEWAL_OFFER_CD   = :FG-RENEWAL-OFFER-CD         
                     ,RENEW_PUB_OFFER_CD = :FG-RENEW-PUB-OFFER-CD       
                     ,OFF_VSTART_TS      = CIS.CHAR2TIMESTAMP(
                                                      :FG-OFF-VSTART-TS
              )            
                     ,OFF_VEND_TS        = CIS.CHAR2TIMESTAMP(
                                                        :FG-OFF-VEND-TS
              )              
                     ,PROC_STATUS_CD     = :FG-PROC-STATUS-CD           
PRJ680               ,MAX_PRICE_OFFER_CD = :FG-MAX-PRICE-OFFER-CD       
P00863               ,RTCHG_PUB_OFFER_CD = :FG-RTCHG-PUB-OFFER-CD       
                WHERE COMPANY_NO         = :FG-COMPANY-NO               
                  AND OFFER_CD           = :FG-OFFER-CD                 
                  AND OFF_VRSN_NO        = :FG-OFF-VRSN-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_RT_PKG_OFFER                                          
MFA-TR*           SET OFFER_DESC_INT     = :FG-OFFER-DESC-INT                   
MFA-TR*              ,OFFER_DESC_EXT     = :FG-OFFER-DESC-EXT                   
MFA-TR*              ,PROMO_CD_INT_FL    = :FG-PROMO-CD-INT-FL                  
MFA-TR*              ,PROMO_CD_EXT_FL    = :FG-PROMO-CD-EXT-FL                  
MFA-TR*              ,OFFER_START_DT     = :FG-OFFER-START-DT                   
MFA-TR*              ,OFFER_END_DT       = :FG-OFFER-END-DT                     
MFA-TR*              ,DISP_START_INT_TS  = :FG-DISP-START-INT-TS                
MFA-TR*              ,DISP_END_INT_TS    = :FG-DISP-END-INT-TS                  
MFA-TR*              ,DISP_START_EXT_TS  = :FG-DISP-START-EXT-TS                
MFA-TR*              ,DISP_END_EXT_TS    = :FG-DISP-END-EXT-TS                  
MFA-TR*              ,LAST_UPDATE_TS     = :FG-LAST-UPDATE-TS                   
MFA-TR*              ,LAST_UPDATE_USERID = :FG-LAST-UPDATE-USERID               
MFA-TR*              ,OFFER_DESC_INT_LNG = :FG-OFFER-DESC-INT-LNG               
MFA-TR*              ,OFFER_DESC_EXT_LNG = :FG-OFFER-DESC-EXT-LNG               
MFA-TR*              ,SPCL_OFFER_TYPE_CD = :FG-SPCL-OFFER-TYPE-CD               
MFA-TR*              ,RENEWAL_OFFER_CD   = :FG-RENEWAL-OFFER-CD                 
MFA-TR*              ,RENEW_PUB_OFFER_CD = :FG-RENEW-PUB-OFFER-CD               
MFA-TR*              ,OFF_VSTART_TS      = :FG-OFF-VSTART-TS                    
MFA-TR*              ,OFF_VEND_TS        = :FG-OFF-VEND-TS                      
MFA-TR*              ,PROC_STATUS_CD     = :FG-PROC-STATUS-CD                   
MFA-TR*              ,MAX_PRICE_OFFER_CD = :FG-MAX-PRICE-OFFER-CD               
MFA-TR*              ,RTCHG_PUB_OFFER_CD = :FG-RTCHG-PUB-OFFER-CD               
MFA-TR*         WHERE COMPANY_NO         = :FG-COMPANY-NO                       
MFA-TR*           AND OFFER_CD           = :FG-OFFER-CD                         
MFA-TR*           AND OFF_VRSN_NO        = :FG-OFF-VRSN-NO                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8060'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE FG-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FG-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8065-DEL-RT-PKG-OFFER.                                         *        
      ******************************************************************        
       8065-DEL-RT-PKG-OFFER.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM CRM_RT_PKG_OFFER                             
                WHERE COMPANY_NO  = :FG-COMPANY-NO                      
                  AND OFFER_CD    = :FG-OFFER-CD                        
                  AND OFF_VRSN_NO = :FG-OFF-VRSN-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8065'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE FG-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FG-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8065-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8070-UPT-RT-PKG-OFFER-VENDTS                                   *        
      ******************************************************************        
       8070-UPT-RT-PKG-OFFER-VENDTS.                                    
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_RT_PKG_OFFER                                  
                  SET OFF_VEND_TS = ( DATEADD( MICROSECOND, -1, 
           CIS.CHAR2TIMESTAMP(:FG-OFF-VSTART-TS) ) )                 
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :FG-LAST-UPDATE-TS
              )           
                     ,LAST_UPDATE_USERID = :FG-LAST-UPDATE-USERID       
                WHERE COMPANY_NO         = :FG-COMPANY-NO               
                  AND OFFER_CD           = :FG-OFFER-CD                 
                  AND OFF_VRSN_NO        = :WS-MAX-APRVL-VRSN           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_RT_PKG_OFFER                                          
MFA-TR*           SET OFF_VEND_TS = ( TIMESTAMP(:FG-OFF-VSTART-TS)              
MFA-TR*                               - 1 MICROSECOND )                         
MFA-TR*              ,LAST_UPDATE_TS     = :FG-LAST-UPDATE-TS                   
MFA-TR*              ,LAST_UPDATE_USERID = :FG-LAST-UPDATE-USERID               
MFA-TR*         WHERE COMPANY_NO         = :FG-COMPANY-NO                       
MFA-TR*           AND OFFER_CD           = :FG-OFFER-CD                         
MFA-TR*           AND OFF_VRSN_NO        = :WS-MAX-APRVL-VRSN                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8070'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE 'OFF_VRSN_NO'             TO TABLE-ELEMENT-3         
              MOVE FG-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FG-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              MOVE WS-MAX-APRVL-VRSN         TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8075-UPT-RT-PKG-OFFER-STATUS                                   *        
      ******************************************************************        
       8075-UPT-RT-PKG-OFFER-STATUS.                                    
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_RT_PKG_OFFER                                  
                  SET PROC_STATUS_CD     = :FG-PROC-STATUS-CD           
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :FG-LAST-UPDATE-TS
              )           
                     ,LAST_UPDATE_USERID = :FG-LAST-UPDATE-USERID       
                WHERE COMPANY_NO         = :FG-COMPANY-NO               
                  AND OFFER_CD           = :FG-OFFER-CD                 
                  AND OFF_VRSN_NO        = :FG-OFF-VRSN-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_RT_PKG_OFFER                                          
MFA-TR*           SET PROC_STATUS_CD     = :FG-PROC-STATUS-CD                   
MFA-TR*              ,LAST_UPDATE_TS     = :FG-LAST-UPDATE-TS                   
MFA-TR*              ,LAST_UPDATE_USERID = :FG-LAST-UPDATE-USERID               
MFA-TR*         WHERE COMPANY_NO         = :FG-COMPANY-NO                       
MFA-TR*           AND OFFER_CD           = :FG-OFFER-CD                         
MFA-TR*           AND OFF_VRSN_NO        = :FG-OFF-VRSN-NO                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8075'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE 'OFF_VRSN_NO'             TO TABLE-ELEMENT-3         
              MOVE FG-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FG-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              MOVE FG-OFF-VRSN-NO            TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8075-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8080-INS-OFF-MKT-TIER.                                         *        
      ******************************************************************        
       8080-INS-OFF-MKT-TIER.                                           
                                                                        
           EXEC SQL                                                     
               INSERT INTO CRM_OFF_MKT_TIER                             
               (                                                        
                  COMPANY_NO                                            
                 ,OFFER_CD                                              
                 ,TIER_CUST_STAT_CD                                     
                 ,TIER_ACCT_TYPE_CD                                     
                 ,MKT_TIER_RANKING                                      
                 ,MKT_TIER_START_DT                                     
                 ,OFFER_TIER_STRT_DT                                    
                 ,MKT_TIER_APPLY_CD                                     
                 ,TIER_DEFLT_OFFR_CD                                    
                 ,OFFER_TIER_END_DT                                     
                 ,LAST_UPDATE_TS                                        
                 ,LAST_UPDATE_USERID                                    
                 ,OFF_TIER_VRSN_NO                                      
                 ,OFF_TIER_VSTART_TS                                    
                 ,OFF_TIER_VEND_TS                                      
                 ,PROC_STATUS_CD                                        
                 ,PROC_REQ_ID                                           
               )                                                        
               VALUES                                                   
               (                                                        
                  :DU-COMPANY-NO                                        
                 ,:DU-OFFER-CD                                          
                 ,:DU-TIER-CUST-STAT-CD                                 
                 ,:DU-TIER-ACCT-TYPE-CD                                 
                 ,:DU-MKT-TIER-RANKING                                  
                 ,IIF(TRY_CONVERT(DATE, :DU-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DU-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:DU-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:DU-MKT-TIER-START-DT
              ), CONVERT(DATE, :DU-MKT-TIER-START-DT) )                        
                 ,IIF(TRY_CONVERT(DATE, :DU-OFFER-TIER-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :DU-OFFER-TIER-STRT-DT
              ) <> 0) OR (LEN(:DU-OFFER-TIER-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:DU-OFFER-TIER-STRT-DT
              ), CONVERT(DATE, :DU-OFFER-TIER-STRT-DT) )                       
                 ,:DU-MKT-TIER-APPLY-CD                                 
                 ,:DU-TIER-DEFLT-OFFR-CD                                
                 ,IIF(TRY_CONVERT(DATE, :DU-OFFER-TIER-END-DT
              ) IS NULL OR (PATINDEX('%.%', :DU-OFFER-TIER-END-DT
              ) <> 0) OR (LEN(:DU-OFFER-TIER-END-DT
              ) <> 10), CIS.CHAR2DATE(:DU-OFFER-TIER-END-DT
              ), CONVERT(DATE, :DU-OFFER-TIER-END-DT) )                        
                 ,CIS.CHAR2TIMESTAMP(:DU-LAST-UPDATE-TS)                        
                 ,:DU-LAST-UPDATE-USERID                                
                 ,:DU-OFF-TIER-VRSN-NO                                  
                 ,CIS.CHAR2TIMESTAMP(:DU-OFF-TIER-VSTART-TS)                    
                 ,CIS.CHAR2TIMESTAMP(:DU-OFF-TIER-VEND-TS)                      
                 ,:DU-PROC-STATUS-CD                                    
                 ,:DU-PROC-REQ-ID                                       
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CRM_OFF_MKT_TIER                                     
MFA-TR*        (                                                                
MFA-TR*           COMPANY_NO                                                    
MFA-TR*          ,OFFER_CD                                                      
MFA-TR*          ,TIER_CUST_STAT_CD                                             
MFA-TR*          ,TIER_ACCT_TYPE_CD                                             
MFA-TR*          ,MKT_TIER_RANKING                                              
MFA-TR*          ,MKT_TIER_START_DT                                             
MFA-TR*          ,OFFER_TIER_STRT_DT                                            
MFA-TR*          ,MKT_TIER_APPLY_CD                                             
MFA-TR*          ,TIER_DEFLT_OFFR_CD                                            
MFA-TR*          ,OFFER_TIER_END_DT                                             
MFA-TR*          ,LAST_UPDATE_TS                                                
MFA-TR*          ,LAST_UPDATE_USERID                                            
MFA-TR*          ,OFF_TIER_VRSN_NO                                              
MFA-TR*          ,OFF_TIER_VSTART_TS                                            
MFA-TR*          ,OFF_TIER_VEND_TS                                              
MFA-TR*          ,PROC_STATUS_CD                                                
MFA-TR*          ,PROC_REQ_ID                                                   
MFA-TR*        )                                                                
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*           :DU-COMPANY-NO                                                
MFA-TR*          ,:DU-OFFER-CD                                                  
MFA-TR*          ,:DU-TIER-CUST-STAT-CD                                         
MFA-TR*          ,:DU-TIER-ACCT-TYPE-CD                                         
MFA-TR*          ,:DU-MKT-TIER-RANKING                                          
MFA-TR*          ,:DU-MKT-TIER-START-DT                                         
MFA-TR*          ,:DU-OFFER-TIER-STRT-DT                                        
MFA-TR*          ,:DU-MKT-TIER-APPLY-CD                                         
MFA-TR*          ,:DU-TIER-DEFLT-OFFR-CD                                        
MFA-TR*          ,:DU-OFFER-TIER-END-DT                                         
MFA-TR*          ,:DU-LAST-UPDATE-TS                                            
MFA-TR*          ,:DU-LAST-UPDATE-USERID                                        
MFA-TR*          ,:DU-OFF-TIER-VRSN-NO                                          
MFA-TR*          ,:DU-OFF-TIER-VSTART-TS                                        
MFA-TR*          ,:DU-OFF-TIER-VEND-TS                                          
MFA-TR*          ,:DU-PROC-STATUS-CD                                            
MFA-TR*          ,:DU-PROC-REQ-ID                                               
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8080'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFF_MKT_TIER'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE 'TIER_CUST_STAT_CD'       TO TABLE-ELEMENT-3         
              MOVE 'TIER_ACCT_TYPE_CD'       TO TABLE-ELEMENT-4         
              MOVE DU-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE DU-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              MOVE DU-TIER-CUST-STAT-CD      TO HOSTVAR-ELEMENT-3       
              MOVE DU-TIER-ACCT-TYPE-CD      TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8080-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8090-UPT-OFF-MKT-TIER.                                         *        
      ******************************************************************        
       8090-UPT-OFF-MKT-TIER.                                           
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_OFF_MKT_TIER                                  
                  SET MKT_TIER_APPLY_CD  = :DU-MKT-TIER-APPLY-CD        
                     ,TIER_DEFLT_OFFR_CD = :DU-TIER-DEFLT-OFFR-CD       
                     ,OFFER_TIER_END_DT  = IIF(TRY_CONVERT(DATE, 
                                                  :DU-OFFER-TIER-END-DT
              ) IS NULL OR (PATINDEX('%.%', :DU-OFFER-TIER-END-DT
              ) <> 0) OR (LEN(:DU-OFFER-TIER-END-DT
              ) <> 10), CIS.CHAR2DATE(:DU-OFFER-TIER-END-DT
              ), CONVERT(DATE, :DU-OFFER-TIER-END-DT) )        
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :DU-LAST-UPDATE-TS
              )           
                     ,LAST_UPDATE_USERID = :DU-LAST-UPDATE-USERID       
                     ,OFF_TIER_VSTART_TS = CIS.CHAR2TIMESTAMP(
                                                 :DU-OFF-TIER-VSTART-TS
              )       
                     ,OFF_TIER_VEND_TS   = CIS.CHAR2TIMESTAMP(
                                                   :DU-OFF-TIER-VEND-TS
              )         
                     ,PROC_STATUS_CD     = :DU-PROC-STATUS-CD           
      *              ,PROC_REQ_ID        = :DU-PROC-REQ-ID                      
                WHERE COMPANY_NO         = :DU-COMPANY-NO               
                  AND OFFER_CD           = :DU-OFFER-CD                 
                  AND TIER_CUST_STAT_CD  = :DU-TIER-CUST-STAT-CD        
                  AND TIER_ACCT_TYPE_CD  = :DU-TIER-ACCT-TYPE-CD        
                  AND MKT_TIER_RANKING   = :DU-MKT-TIER-RANKING         
                  AND MKT_TIER_START_DT  = IIF(TRY_CONVERT(DATE, 
                                                  :DU-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DU-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:DU-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:DU-MKT-TIER-START-DT
              ), CONVERT(DATE, :DU-MKT-TIER-START-DT) )        
                  AND OFFER_TIER_STRT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :DU-OFFER-TIER-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :DU-OFFER-TIER-STRT-DT
              ) <> 0) OR (LEN(:DU-OFFER-TIER-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:DU-OFFER-TIER-STRT-DT
              ), CONVERT(DATE, :DU-OFFER-TIER-STRT-DT) )       
                  AND OFF_TIER_VRSN_NO   = :DU-OFF-TIER-VRSN-NO         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_OFF_MKT_TIER                                          
MFA-TR*           SET MKT_TIER_APPLY_CD  = :DU-MKT-TIER-APPLY-CD                
MFA-TR*              ,TIER_DEFLT_OFFR_CD = :DU-TIER-DEFLT-OFFR-CD               
MFA-TR*              ,OFFER_TIER_END_DT  = :DU-OFFER-TIER-END-DT                
MFA-TR*              ,LAST_UPDATE_TS     = :DU-LAST-UPDATE-TS                   
MFA-TR*              ,LAST_UPDATE_USERID = :DU-LAST-UPDATE-USERID               
MFA-TR*              ,OFF_TIER_VSTART_TS = :DU-OFF-TIER-VSTART-TS               
MFA-TR*              ,OFF_TIER_VEND_TS   = :DU-OFF-TIER-VEND-TS                 
MFA-TR*              ,PROC_STATUS_CD     = :DU-PROC-STATUS-CD                   
MFA-TR*              ,PROC_REQ_ID        = :DU-PROC-REQ-ID                      
MFA-TR*         WHERE COMPANY_NO         = :DU-COMPANY-NO                       
MFA-TR*           AND OFFER_CD           = :DU-OFFER-CD                         
MFA-TR*           AND TIER_CUST_STAT_CD  = :DU-TIER-CUST-STAT-CD                
MFA-TR*           AND TIER_ACCT_TYPE_CD  = :DU-TIER-ACCT-TYPE-CD                
MFA-TR*           AND MKT_TIER_RANKING   = :DU-MKT-TIER-RANKING                 
MFA-TR*           AND MKT_TIER_START_DT  = :DU-MKT-TIER-START-DT                
MFA-TR*           AND OFFER_TIER_STRT_DT = :DU-OFFER-TIER-STRT-DT               
MFA-TR*           AND OFF_TIER_VRSN_NO   = :DU-OFF-TIER-VRSN-NO                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8090'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFF_MKT_TIER'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE 'TIER_CUST_STAT_CD'       TO TABLE-ELEMENT-3         
              MOVE 'TIER_ACCT_TYPE_CD'       TO TABLE-ELEMENT-4         
              MOVE DU-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE DU-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              MOVE DU-TIER-CUST-STAT-CD      TO HOSTVAR-ELEMENT-3       
              MOVE DU-TIER-ACCT-TYPE-CD      TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8090-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8092-UPT-OFF-MKT-TIER-VENDTS.                                  *        
      ******************************************************************        
       8092-UPT-OFF-MKT-TIER-VENDTS.                                    
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_OFF_MKT_TIER                                  
                  SET OFF_TIER_VEND_TS                                  
                  = ( DATEADD( MICROSECOND, -1, CIS.CHAR2TIMESTAMP (
                                               :DU-OFF-TIER-VSTART-TS )
               ) )               
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :DU-LAST-UPDATE-TS
              )           
                     ,LAST_UPDATE_USERID = :DU-LAST-UPDATE-USERID       
                WHERE COMPANY_NO         = :DU-COMPANY-NO               
                  AND OFFER_CD           = :DU-OFFER-CD                 
                  AND TIER_CUST_STAT_CD  = :DU-TIER-CUST-STAT-CD        
                  AND TIER_ACCT_TYPE_CD  = :DU-TIER-ACCT-TYPE-CD        
                  AND MKT_TIER_RANKING   = :DU-MKT-TIER-RANKING         
                  AND MKT_TIER_START_DT  = IIF(TRY_CONVERT(DATE, 
                                                  :DU-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DU-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:DU-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:DU-MKT-TIER-START-DT
              ), CONVERT(DATE, :DU-MKT-TIER-START-DT) )        
                  AND OFFER_TIER_STRT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :DU-OFFER-TIER-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :DU-OFFER-TIER-STRT-DT
              ) <> 0) OR (LEN(:DU-OFFER-TIER-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:DU-OFFER-TIER-STRT-DT
              ), CONVERT(DATE, :DU-OFFER-TIER-STRT-DT) )       
                  AND OFF_TIER_VRSN_NO   = :WS-MAX-APRVL-VRSN           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_OFF_MKT_TIER                                          
MFA-TR*           SET OFF_TIER_VEND_TS                                          
MFA-TR*           = ( TIMESTAMP (:DU-OFF-TIER-VSTART-TS )                       
MFA-TR*                                 - 1 MICROSECOND )                       
MFA-TR*              ,LAST_UPDATE_TS     = :DU-LAST-UPDATE-TS                   
MFA-TR*              ,LAST_UPDATE_USERID = :DU-LAST-UPDATE-USERID               
MFA-TR*         WHERE COMPANY_NO         = :DU-COMPANY-NO                       
MFA-TR*           AND OFFER_CD           = :DU-OFFER-CD                         
MFA-TR*           AND TIER_CUST_STAT_CD  = :DU-TIER-CUST-STAT-CD                
MFA-TR*           AND TIER_ACCT_TYPE_CD  = :DU-TIER-ACCT-TYPE-CD                
MFA-TR*           AND MKT_TIER_RANKING   = :DU-MKT-TIER-RANKING                 
MFA-TR*           AND MKT_TIER_START_DT  = :DU-MKT-TIER-START-DT                
MFA-TR*           AND OFFER_TIER_STRT_DT = :DU-OFFER-TIER-STRT-DT               
MFA-TR*           AND OFF_TIER_VRSN_NO   = :WS-MAX-APRVL-VRSN                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8092'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFF_MKT_TIER'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE 'TIER_CUST_STAT_CD'       TO TABLE-ELEMENT-3         
              MOVE 'TIER_ACCT_TYPE_CD'       TO TABLE-ELEMENT-4         
              MOVE DU-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE DU-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              MOVE DU-TIER-CUST-STAT-CD      TO HOSTVAR-ELEMENT-3       
              MOVE DU-TIER-ACCT-TYPE-CD      TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8092-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8094-UPT-OFF-MKT-TIER-STATUS.                                  *        
      ******************************************************************        
       8094-UPT-OFF-MKT-TIER-STATUS.                                    
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_OFF_MKT_TIER                                  
                  SET PROC_STATUS_CD     = :DU-PROC-STATUS-CD           
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :DU-LAST-UPDATE-TS
              )           
                     ,LAST_UPDATE_USERID = :DU-LAST-UPDATE-USERID       
                WHERE COMPANY_NO         = :DU-COMPANY-NO               
                  AND OFFER_CD           = :DU-OFFER-CD                 
                  AND TIER_CUST_STAT_CD  = :DU-TIER-CUST-STAT-CD        
                  AND TIER_ACCT_TYPE_CD  = :DU-TIER-ACCT-TYPE-CD        
                  AND MKT_TIER_RANKING   = :DU-MKT-TIER-RANKING         
                  AND MKT_TIER_START_DT  = IIF(TRY_CONVERT(DATE, 
                                                  :DU-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DU-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:DU-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:DU-MKT-TIER-START-DT
              ), CONVERT(DATE, :DU-MKT-TIER-START-DT) )        
                  AND OFFER_TIER_STRT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :DU-OFFER-TIER-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :DU-OFFER-TIER-STRT-DT
              ) <> 0) OR (LEN(:DU-OFFER-TIER-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:DU-OFFER-TIER-STRT-DT
              ), CONVERT(DATE, :DU-OFFER-TIER-STRT-DT) )       
                  AND OFF_TIER_VRSN_NO   = :DU-OFF-TIER-VRSN-NO         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_OFF_MKT_TIER                                          
MFA-TR*           SET PROC_STATUS_CD     = :DU-PROC-STATUS-CD                   
MFA-TR*              ,LAST_UPDATE_TS     = :DU-LAST-UPDATE-TS                   
MFA-TR*              ,LAST_UPDATE_USERID = :DU-LAST-UPDATE-USERID               
MFA-TR*         WHERE COMPANY_NO         = :DU-COMPANY-NO                       
MFA-TR*           AND OFFER_CD           = :DU-OFFER-CD                         
MFA-TR*           AND TIER_CUST_STAT_CD  = :DU-TIER-CUST-STAT-CD                
MFA-TR*           AND TIER_ACCT_TYPE_CD  = :DU-TIER-ACCT-TYPE-CD                
MFA-TR*           AND MKT_TIER_RANKING   = :DU-MKT-TIER-RANKING                 
MFA-TR*           AND MKT_TIER_START_DT  = :DU-MKT-TIER-START-DT                
MFA-TR*           AND OFFER_TIER_STRT_DT = :DU-OFFER-TIER-STRT-DT               
MFA-TR*           AND OFF_TIER_VRSN_NO   = :DU-OFF-TIER-VRSN-NO                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8094'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFF_MKT_TIER'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE 'TIER_CUST_STAT_CD'       TO TABLE-ELEMENT-3         
              MOVE 'TIER_ACCT_TYPE_CD'       TO TABLE-ELEMENT-4         
              MOVE DU-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE DU-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              MOVE DU-TIER-CUST-STAT-CD      TO HOSTVAR-ELEMENT-3       
              MOVE DU-TIER-ACCT-TYPE-CD      TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8094-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8095-DEL-OFF-MKT-TIER.                                         *        
      ******************************************************************        
       8095-DEL-OFF-MKT-TIER.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM CRM_OFF_MKT_TIER                             
                WHERE COMPANY_NO         = :DU-COMPANY-NO               
                  AND OFFER_CD           = :DU-OFFER-CD                 
                  AND TIER_CUST_STAT_CD  = :DU-TIER-CUST-STAT-CD        
                  AND TIER_ACCT_TYPE_CD  = :DU-TIER-ACCT-TYPE-CD        
                  AND MKT_TIER_RANKING   = :DU-MKT-TIER-RANKING         
                  AND MKT_TIER_START_DT  = IIF(TRY_CONVERT(DATE, 
                                                  :DU-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DU-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:DU-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:DU-MKT-TIER-START-DT
              ), CONVERT(DATE, :DU-MKT-TIER-START-DT) )        
                  AND OFFER_TIER_STRT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :DU-OFFER-TIER-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :DU-OFFER-TIER-STRT-DT
              ) <> 0) OR (LEN(:DU-OFFER-TIER-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:DU-OFFER-TIER-STRT-DT
              ), CONVERT(DATE, :DU-OFFER-TIER-STRT-DT) )       
                  AND OFF_TIER_VRSN_NO   = :DU-OFF-TIER-VRSN-NO         
                  AND PROC_STATUS_CD     = :WS-PROC-STATUS-NEW          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CRM_OFF_MKT_TIER                                     
MFA-TR*         WHERE COMPANY_NO         = :DU-COMPANY-NO                       
MFA-TR*           AND OFFER_CD           = :DU-OFFER-CD                         
MFA-TR*           AND TIER_CUST_STAT_CD  = :DU-TIER-CUST-STAT-CD                
MFA-TR*           AND TIER_ACCT_TYPE_CD  = :DU-TIER-ACCT-TYPE-CD                
MFA-TR*           AND MKT_TIER_RANKING   = :DU-MKT-TIER-RANKING                 
MFA-TR*           AND MKT_TIER_START_DT  = :DU-MKT-TIER-START-DT                
MFA-TR*           AND OFFER_TIER_STRT_DT = :DU-OFFER-TIER-STRT-DT               
MFA-TR*           AND OFF_TIER_VRSN_NO   = :DU-OFF-TIER-VRSN-NO                 
MFA-TR*           AND PROC_STATUS_CD     = :WS-PROC-STATUS-NEW                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8095'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFF_MKT_TIER'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE 'TIER_CUST_STAT_CD'       TO TABLE-ELEMENT-3         
              MOVE 'TIER_ACCT_TYPE_CD'       TO TABLE-ELEMENT-4         
              MOVE DU-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE DU-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              MOVE DU-TIER-CUST-STAT-CD      TO HOSTVAR-ELEMENT-3       
              MOVE DU-TIER-ACCT-TYPE-CD      TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8095-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8096-DEL-TMPLT-OFF-MKT-TIER.                                            
      ******************************************************************        
       8096-DEL-TMPLT-OFF-MKT-TIER.                                     
                                                                        
           EXEC SQL                                                     
               DELETE FROM CRM_OFF_MKT_TIER                             
                WHERE COMPANY_NO         = :DU-COMPANY-NO               
                  AND OFFER_CD           = :DU-OFFER-CD                 
                  AND PROC_REQ_ID        = :DU-PROC-REQ-ID              
                  AND PROC_STATUS_CD     = :WS-PROC-STATUS-NEW          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8096'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFF_MKT_TIER'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE DU-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE DU-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8096-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8097-DEL-OFF-MKT-TIER.                                         *        
      * DELETE PRIVIOUS OFFER MARKET TIER ROW                          *        
      ******************************************************************        
       8097-DEL-OFF-MKT-TIER.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM CRM_OFF_MKT_TIER                             
                WHERE COMPANY_NO         = :DU-COMPANY-NO               
                  AND OFFER_CD           = :DU-OFFER-CD                 
                  AND TIER_CUST_STAT_CD  = :DU-TIER-CUST-STAT-CD        
                  AND TIER_ACCT_TYPE_CD  = :DU-TIER-ACCT-TYPE-CD        
                  AND MKT_TIER_RANKING   = :DU-MKT-TIER-RANKING         
                  AND MKT_TIER_START_DT  = IIF(TRY_CONVERT(DATE, 
                                                  :DU-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DU-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:DU-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:DU-MKT-TIER-START-DT
              ), CONVERT(DATE, :DU-MKT-TIER-START-DT) )        
                  AND OFFER_TIER_STRT_DT = IIF(TRY_CONVERT(DATE, 
                                               :WS-OLD-OFF-TIER-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-OLD-OFF-TIER-STRT-DT
              ) <> 0) OR (LEN(:WS-OLD-OFF-TIER-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:WS-OLD-OFF-TIER-STRT-DT
              ), CONVERT(DATE, :WS-OLD-OFF-TIER-STRT-DT) )     
                  AND PROC_STATUS_CD     IN (:WS-PROC-STATUS-NEW ,      
                                             :WS-PROC-STATUS-ERLY-APRVL)
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CRM_OFF_MKT_TIER                                     
MFA-TR*         WHERE COMPANY_NO         = :DU-COMPANY-NO                       
MFA-TR*           AND OFFER_CD           = :DU-OFFER-CD                         
MFA-TR*           AND TIER_CUST_STAT_CD  = :DU-TIER-CUST-STAT-CD                
MFA-TR*           AND TIER_ACCT_TYPE_CD  = :DU-TIER-ACCT-TYPE-CD                
MFA-TR*           AND MKT_TIER_RANKING   = :DU-MKT-TIER-RANKING                 
MFA-TR*           AND MKT_TIER_START_DT  = :DU-MKT-TIER-START-DT                
MFA-TR*           AND OFFER_TIER_STRT_DT = :WS-OLD-OFF-TIER-STRT-DT             
MFA-TR*           AND PROC_STATUS_CD     IN (:WS-PROC-STATUS-NEW ,              
MFA-TR*                                      :WS-PROC-STATUS-ERLY-APRVL)        
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8097'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFF_MKT_TIER'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE 'TIER_CUST_STAT_CD'       TO TABLE-ELEMENT-3         
              MOVE 'TIER_ACCT_TYPE_CD'       TO TABLE-ELEMENT-4         
              MOVE DU-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE DU-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              MOVE DU-TIER-CUST-STAT-CD      TO HOSTVAR-ELEMENT-3       
              MOVE DU-TIER-ACCT-TYPE-CD      TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8097-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-INS-RT-PKG-OPTION.                                        *        
      ******************************************************************        
       8100-INS-RT-PKG-OPTION.                                          
                                                                        
           EXEC SQL                                                     
               INSERT INTO CRM_RT_PKG_OPTION                            
               (                                                        
                  COMPANY_NO                                            
                 ,OPTION_CD                                             
                 ,CODE_UTIL_TYPE                                        
                 ,RATE_PLAN_NO                                          
                 ,OPTION_START_DT                                       
                 ,OPTION_END_DT                                         
                 ,OPT_DESC_INT                                          
                 ,OPT_DESC_INT_LONG                                     
                 ,CURR_EXT_DESC_LONG                                    
                 ,RENEWAL_DESC_LONG                                     
                 ,WEB_DESC_LONG                                         
                 ,STATUS_CD                                             
                 ,LAST_UPDATE_USERID                                    
                 ,LAST_UPDATE_TS                                        
                 ,OPT_CALC_TYPE_CD                                      
                 ,WEB_MKT_DESC_LONG                                     
                 ,OPT_VRSN_NO                                           
                 ,OPT_VSTART_TS                                         
                 ,OPT_VEND_TS                                           
                 ,PROC_STATUS_CD                                        
                 ,PROC_REQ_ID                                           
A04805           ,OPTION_TYPE_DESC                                      
PRJ892           ,AUTO_RENEWAL_FL                                       
PRJ892           ,OPTION_PROMO_DESC                                     
               )                                                        
               VALUES                                                   
               (                                                        
                  :FI-COMPANY-NO                                        
                 ,:FI-OPTION-CD                                         
                 ,:FI-CODE-UTIL-TYPE                                    
                 ,:FI-RATE-PLAN-NO                                      
                 ,IIF(TRY_CONVERT(DATE, :FI-OPTION-START-DT
              ) IS NULL OR (PATINDEX('%.%', :FI-OPTION-START-DT
              ) <> 0) OR (LEN(:FI-OPTION-START-DT
              ) <> 10), CIS.CHAR2DATE(:FI-OPTION-START-DT
              ), CONVERT(DATE, :FI-OPTION-START-DT) )                          
                 ,IIF(TRY_CONVERT(DATE, :FI-OPTION-END-DT
              ) IS NULL OR (PATINDEX('%.%', :FI-OPTION-END-DT
              ) <> 0) OR (LEN(:FI-OPTION-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :FI-OPTION-END-DT
              ), CONVERT(DATE, :FI-OPTION-END-DT) )                            
                 ,:FI-OPT-DESC-INT                                      
                 ,:FI-OPT-DESC-INT-LONG                                 
                 ,:FI-CURR-EXT-DESC-LONG                                
                 ,:FI-RENEWAL-DESC-LONG                                 
                 ,:FI-WEB-DESC-LONG                                     
                 ,:FI-STATUS-CD                                         
                 ,:FI-LAST-UPDATE-USERID                                
                 ,CIS.CHAR2TIMESTAMP(:FI-LAST-UPDATE-TS)                        
                 ,:FI-OPT-CALC-TYPE-CD                                  
                 ,:FI-WEB-MKT-DESC-LONG                                 
                 ,:FI-OPT-VRSN-NO                                       
                 ,CIS.CHAR2TIMESTAMP(:FI-OPT-VSTART-TS)                         
                 ,CIS.CHAR2TIMESTAMP(:FI-OPT-VEND-TS)                           
                 ,:FI-PROC-STATUS-CD                                    
                 ,:FI-PROC-REQ-ID                                       
A04805           ,:FI-OPTION-TYPE-DESC                                  
PRJ892           ,:FI-AUTO-RENEWAL-FL                                   
PRJ892           ,:FI-OPTION-PROMO-DESC                                 
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CRM_RT_PKG_OPTION                                    
MFA-TR*        (                                                                
MFA-TR*           COMPANY_NO                                                    
MFA-TR*          ,OPTION_CD                                                     
MFA-TR*          ,CODE_UTIL_TYPE                                                
MFA-TR*          ,RATE_PLAN_NO                                                  
MFA-TR*          ,OPTION_START_DT                                               
MFA-TR*          ,OPTION_END_DT                                                 
MFA-TR*          ,OPT_DESC_INT                                                  
MFA-TR*          ,OPT_DESC_INT_LONG                                             
MFA-TR*          ,CURR_EXT_DESC_LONG                                            
MFA-TR*          ,RENEWAL_DESC_LONG                                             
MFA-TR*          ,WEB_DESC_LONG                                                 
MFA-TR*          ,STATUS_CD                                                     
MFA-TR*          ,LAST_UPDATE_USERID                                            
MFA-TR*          ,LAST_UPDATE_TS                                                
MFA-TR*          ,OPT_CALC_TYPE_CD                                              
MFA-TR*          ,WEB_MKT_DESC_LONG                                             
MFA-TR*          ,OPT_VRSN_NO                                                   
MFA-TR*          ,OPT_VSTART_TS                                                 
MFA-TR*          ,OPT_VEND_TS                                                   
MFA-TR*          ,PROC_STATUS_CD                                                
MFA-TR*          ,PROC_REQ_ID                                                   
MFA-TR*          ,OPTION_TYPE_DESC                                              
MFA-TR*          ,AUTO_RENEWAL_FL                                               
MFA-TR*          ,OPTION_PROMO_DESC                                             
MFA-TR*        )                                                                
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*           :FI-COMPANY-NO                                                
MFA-TR*          ,:FI-OPTION-CD                                                 
MFA-TR*          ,:FI-CODE-UTIL-TYPE                                            
MFA-TR*          ,:FI-RATE-PLAN-NO                                              
MFA-TR*          ,:FI-OPTION-START-DT                                           
MFA-TR*          ,:FI-OPTION-END-DT                                             
MFA-TR*          ,:FI-OPT-DESC-INT                                              
MFA-TR*          ,:FI-OPT-DESC-INT-LONG                                         
MFA-TR*          ,:FI-CURR-EXT-DESC-LONG                                        
MFA-TR*          ,:FI-RENEWAL-DESC-LONG                                         
MFA-TR*          ,:FI-WEB-DESC-LONG                                             
MFA-TR*          ,:FI-STATUS-CD                                                 
MFA-TR*          ,:FI-LAST-UPDATE-USERID                                        
MFA-TR*          ,:FI-LAST-UPDATE-TS                                            
MFA-TR*          ,:FI-OPT-CALC-TYPE-CD                                          
MFA-TR*          ,:FI-WEB-MKT-DESC-LONG                                         
MFA-TR*          ,:FI-OPT-VRSN-NO                                               
MFA-TR*          ,:FI-OPT-VSTART-TS                                             
MFA-TR*          ,:FI-OPT-VEND-TS                                               
MFA-TR*          ,:FI-PROC-STATUS-CD                                            
MFA-TR*          ,:FI-PROC-REQ-ID                                               
MFA-TR*          ,:FI-OPTION-TYPE-DESC                                          
MFA-TR*          ,:FI-AUTO-RENEWAL-FL                                           
MFA-TR*          ,:FI-OPTION-PROMO-DESC                                         
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OPTION'       TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE FI-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FI-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8110-UPT-RT-PKG-OPTION.                                        *        
      ******************************************************************        
       8110-UPT-RT-PKG-OPTION.                                          
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_RT_PKG_OPTION                                 
                  SET CODE_UTIL_TYPE     = :FI-CODE-UTIL-TYPE           
                     ,RATE_PLAN_NO       = :FI-RATE-PLAN-NO             
                     ,OPTION_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                    :FI-OPTION-START-DT
              ) IS NULL OR (PATINDEX('%.%', :FI-OPTION-START-DT
              ) <> 0) OR (LEN(:FI-OPTION-START-DT
              ) <> 10), CIS.CHAR2DATE(:FI-OPTION-START-DT
              ), CONVERT(DATE, :FI-OPTION-START-DT) )          
                     ,OPTION_END_DT      = IIF(TRY_CONVERT(DATE, 
                                                      :FI-OPTION-END-DT
              ) IS NULL OR (PATINDEX('%.%', :FI-OPTION-END-DT
              ) <> 0) OR (LEN(:FI-OPTION-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :FI-OPTION-END-DT
              ), CONVERT(DATE, :FI-OPTION-END-DT) )            
                     ,OPT_DESC_INT       = :FI-OPT-DESC-INT             
                     ,OPT_DESC_INT_LONG  = :FI-OPT-DESC-INT-LONG        
                     ,CURR_EXT_DESC_LONG = :FI-CURR-EXT-DESC-LONG       
                     ,RENEWAL_DESC_LONG  = :FI-RENEWAL-DESC-LONG        
                     ,WEB_DESC_LONG      = :FI-WEB-DESC-LONG            
                     ,STATUS_CD          = :FI-STATUS-CD                
                     ,LAST_UPDATE_USERID = :FI-LAST-UPDATE-USERID       
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :FI-LAST-UPDATE-TS
              )           
                     ,OPT_CALC_TYPE_CD   = :FI-OPT-CALC-TYPE-CD         
                     ,WEB_MKT_DESC_LONG  = :FI-WEB-MKT-DESC-LONG        
                     ,OPT_VSTART_TS      = CIS.CHAR2TIMESTAMP(
                                                      :FI-OPT-VSTART-TS
              )            
                     ,OPT_VEND_TS        = CIS.CHAR2TIMESTAMP(
                                                        :FI-OPT-VEND-TS
              )              
                     ,PROC_STATUS_CD     = :FI-PROC-STATUS-CD           
A04805               ,OPTION_TYPE_DESC   = :FI-OPTION-TYPE-DESC         
PRJ892               ,AUTO_RENEWAL_FL    = :FI-AUTO-RENEWAL-FL          
PRJ892               ,OPTION_PROMO_DESC  = :FI-OPTION-PROMO-DESC        
                WHERE COMPANY_NO         = :FI-COMPANY-NO               
                  AND OPTION_CD          = :FI-OPTION-CD                
                  AND OPT_VRSN_NO        = :FI-OPT-VRSN-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_RT_PKG_OPTION                                         
MFA-TR*           SET CODE_UTIL_TYPE     = :FI-CODE-UTIL-TYPE                   
MFA-TR*              ,RATE_PLAN_NO       = :FI-RATE-PLAN-NO                     
MFA-TR*              ,OPTION_START_DT    = :FI-OPTION-START-DT                  
MFA-TR*              ,OPTION_END_DT      = :FI-OPTION-END-DT                    
MFA-TR*              ,OPT_DESC_INT       = :FI-OPT-DESC-INT                     
MFA-TR*              ,OPT_DESC_INT_LONG  = :FI-OPT-DESC-INT-LONG                
MFA-TR*              ,CURR_EXT_DESC_LONG = :FI-CURR-EXT-DESC-LONG               
MFA-TR*              ,RENEWAL_DESC_LONG  = :FI-RENEWAL-DESC-LONG                
MFA-TR*              ,WEB_DESC_LONG      = :FI-WEB-DESC-LONG                    
MFA-TR*              ,STATUS_CD          = :FI-STATUS-CD                        
MFA-TR*              ,LAST_UPDATE_USERID = :FI-LAST-UPDATE-USERID               
MFA-TR*              ,LAST_UPDATE_TS     = :FI-LAST-UPDATE-TS                   
MFA-TR*              ,OPT_CALC_TYPE_CD   = :FI-OPT-CALC-TYPE-CD                 
MFA-TR*              ,WEB_MKT_DESC_LONG  = :FI-WEB-MKT-DESC-LONG                
MFA-TR*              ,OPT_VSTART_TS      = :FI-OPT-VSTART-TS                    
MFA-TR*              ,OPT_VEND_TS        = :FI-OPT-VEND-TS                      
MFA-TR*              ,PROC_STATUS_CD     = :FI-PROC-STATUS-CD                   
MFA-TR*              ,OPTION_TYPE_DESC   = :FI-OPTION-TYPE-DESC                 
MFA-TR*              ,AUTO_RENEWAL_FL    = :FI-AUTO-RENEWAL-FL                  
MFA-TR*              ,OPTION_PROMO_DESC  = :FI-OPTION-PROMO-DESC                
MFA-TR*         WHERE COMPANY_NO         = :FI-COMPANY-NO                       
MFA-TR*           AND OPTION_CD          = :FI-OPTION-CD                        
MFA-TR*           AND OPT_VRSN_NO        = :FI-OPT-VRSN-NO                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8110'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OPTION'       TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE FI-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FI-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8112-UPT-RT-PKG-OPTION-VENDTS.                                 *        
      ******************************************************************        
       8112-UPT-RT-PKG-OPTION-VENDTS.                                   
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_RT_PKG_OPTION                                 
                  SET OPT_VEND_TS = ( DATEADD( MICROSECOND, -1, 
           CIS.CHAR2TIMESTAMP (:FI-OPT-VSTART-TS) ) )     
                     ,LAST_UPDATE_USERID = :FI-LAST-UPDATE-USERID       
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :FI-LAST-UPDATE-TS
              )           
                WHERE COMPANY_NO         = :FI-COMPANY-NO               
                  AND OPTION_CD          = :FI-OPTION-CD                
                  AND OPT_VRSN_NO        = :WS-MAX-APRVL-VRSN           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_RT_PKG_OPTION                                         
MFA-TR*           SET OPT_VEND_TS = ( TIMESTAMP (:FI-OPT-VSTART-TS)             
MFA-TR*                                           - 1 MICROSECOND )             
MFA-TR*              ,LAST_UPDATE_USERID = :FI-LAST-UPDATE-USERID               
MFA-TR*              ,LAST_UPDATE_TS     = :FI-LAST-UPDATE-TS                   
MFA-TR*         WHERE COMPANY_NO         = :FI-COMPANY-NO                       
MFA-TR*           AND OPTION_CD          = :FI-OPTION-CD                        
MFA-TR*           AND OPT_VRSN_NO        = :WS-MAX-APRVL-VRSN                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8112'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OPTION'       TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE FI-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FI-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8112-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8114-UPT-RT-PKG-OPTION-STATUS.                                 *        
      ******************************************************************        
       8114-UPT-RT-PKG-OPTION-STATUS.                                   
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_RT_PKG_OPTION                                 
                  SET PROC_STATUS_CD     = :FI-PROC-STATUS-CD           
                     ,LAST_UPDATE_USERID = :FI-LAST-UPDATE-USERID       
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :FI-LAST-UPDATE-TS
              )           
                WHERE COMPANY_NO         = :FI-COMPANY-NO               
                  AND OPTION_CD          = :FI-OPTION-CD                
                  AND OPT_VRSN_NO        = :FI-OPT-VRSN-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_RT_PKG_OPTION                                         
MFA-TR*           SET PROC_STATUS_CD     = :FI-PROC-STATUS-CD                   
MFA-TR*              ,LAST_UPDATE_USERID = :FI-LAST-UPDATE-USERID               
MFA-TR*              ,LAST_UPDATE_TS     = :FI-LAST-UPDATE-TS                   
MFA-TR*         WHERE COMPANY_NO         = :FI-COMPANY-NO                       
MFA-TR*           AND OPTION_CD          = :FI-OPTION-CD                        
MFA-TR*           AND OPT_VRSN_NO        = :FI-OPT-VRSN-NO                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8114'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OPTION'       TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE FI-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FI-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8114-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8120-DEL-RT-PKG-OPTION.                                        *        
      ******************************************************************        
       8120-DEL-RT-PKG-OPTION.                                          
                                                                        
           EXEC SQL                                                     
               DELETE FROM CRM_RT_PKG_OPTION                            
                WHERE COMPANY_NO         = :FI-COMPANY-NO               
                  AND OPTION_CD          = :FI-OPTION-CD                
                  AND OPT_VRSN_NO        = :FI-OPT-VRSN-NO              
                  AND PROC_STATUS_CD     = :WS-PROC-STATUS-NEW          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8120'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OPTION'       TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE FI-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FI-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8130-INS-OFFER-OPTION.                                         *        
      ******************************************************************        
       8130-INS-OFFER-OPTION.                                           
                                                                        
           EXEC SQL                                                     
               INSERT INTO CRM_OFFER_OPTION                             
               (                                                        
                  COMPANY_NO                                            
                 ,OFFER_CD                                              
                 ,OPTION_CD                                             
                 ,OPTION_SORT_SEQ_NO                                    
                 ,OPTION_URL_TX                                         
                 ,LAST_UPDATE_USERID                                    
                 ,LAST_UPDATE_TS                                        
                 ,DROP_OPTION_CD                                        
                 ,OFFER_OPT_START_DT                                    
                 ,OFFER_OPT_END_DT                                      
                 ,OFF_OPT_VRSN_NO                                       
                 ,OFF_OPT_VSTART_TS                                     
                 ,OFF_OPT_VEND_TS                                       
                 ,PROC_STATUS_CD                                        
                 ,PROC_REQ_ID                                           
A04805           ,WEB_NEW_EXISTS_CD                                     
A04805           ,WEB_SIGN_UP_FL                                        
A04805           ,OFF_OPT_EXCLUDE_CD                                    
               )                                                        
               VALUES                                                   
               (                                                        
                  :E9-COMPANY-NO                                        
                 ,:E9-OFFER-CD                                          
                 ,:E9-OPTION-CD                                         
                 ,:E9-OPTION-SORT-SEQ-NO                                
                 ,:E9-OPTION-URL-TX                                     
                 ,:E9-LAST-UPDATE-USERID                                
                 ,CIS.CHAR2TIMESTAMP(:E9-LAST-UPDATE-TS)                        
                 ,:E9-DROP-OPTION-CD                                    
                 ,IIF(TRY_CONVERT(DATE, :E9-OFFER-OPT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :E9-OFFER-OPT-START-DT
              ) <> 0) OR (LEN(:E9-OFFER-OPT-START-DT
              ) <> 10), CIS.CHAR2DATE(:E9-OFFER-OPT-START-DT
              ), CONVERT(DATE, :E9-OFFER-OPT-START-DT) )                       
                 ,IIF(TRY_CONVERT(DATE, :E9-OFFER-OPT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :E9-OFFER-OPT-END-DT
              ) <> 0) OR (LEN(:E9-OFFER-OPT-END-DT
              ) <> 10), CIS.CHAR2DATE(:E9-OFFER-OPT-END-DT
              ), CONVERT(DATE, :E9-OFFER-OPT-END-DT) )                         
                 ,:E9-OFF-OPT-VRSN-NO                                   
                 ,CIS.CHAR2TIMESTAMP(:E9-OFF-OPT-VSTART-TS)                     
                 ,CIS.CHAR2TIMESTAMP(:E9-OFF-OPT-VEND-TS)                       
                 ,:E9-PROC-STATUS-CD                                    
                 ,:E9-PROC-REQ-ID                                       
A04805           ,:E9-WEB-NEW-EXISTS-CD                                 
A04805           ,:E9-WEB-SIGN-UP-FL                                    
A04805           ,:E9-OFF-OPT-EXCLUDE-CD                                
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CRM_OFFER_OPTION                                     
MFA-TR*        (                                                                
MFA-TR*           COMPANY_NO                                                    
MFA-TR*          ,OFFER_CD                                                      
MFA-TR*          ,OPTION_CD                                                     
MFA-TR*          ,OPTION_SORT_SEQ_NO                                            
MFA-TR*          ,OPTION_URL_TX                                                 
MFA-TR*          ,LAST_UPDATE_USERID                                            
MFA-TR*          ,LAST_UPDATE_TS                                                
MFA-TR*          ,DROP_OPTION_CD                                                
MFA-TR*          ,OFFER_OPT_START_DT                                            
MFA-TR*          ,OFFER_OPT_END_DT                                              
MFA-TR*          ,OFF_OPT_VRSN_NO                                               
MFA-TR*          ,OFF_OPT_VSTART_TS                                             
MFA-TR*          ,OFF_OPT_VEND_TS                                               
MFA-TR*          ,PROC_STATUS_CD                                                
MFA-TR*          ,PROC_REQ_ID                                                   
MFA-TR*          ,WEB_NEW_EXISTS_CD                                             
MFA-TR*          ,WEB_SIGN_UP_FL                                                
MFA-TR*          ,OFF_OPT_EXCLUDE_CD                                            
MFA-TR*        )                                                                
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*           :E9-COMPANY-NO                                                
MFA-TR*          ,:E9-OFFER-CD                                                  
MFA-TR*          ,:E9-OPTION-CD                                                 
MFA-TR*          ,:E9-OPTION-SORT-SEQ-NO                                        
MFA-TR*          ,:E9-OPTION-URL-TX                                             
MFA-TR*          ,:E9-LAST-UPDATE-USERID                                        
MFA-TR*          ,:E9-LAST-UPDATE-TS                                            
MFA-TR*          ,:E9-DROP-OPTION-CD                                            
MFA-TR*          ,:E9-OFFER-OPT-START-DT                                        
MFA-TR*          ,:E9-OFFER-OPT-END-DT                                          
MFA-TR*          ,:E9-OFF-OPT-VRSN-NO                                           
MFA-TR*          ,:E9-OFF-OPT-VSTART-TS                                         
MFA-TR*          ,:E9-OFF-OPT-VEND-TS                                           
MFA-TR*          ,:E9-PROC-STATUS-CD                                            
MFA-TR*          ,:E9-PROC-REQ-ID                                               
MFA-TR*          ,:E9-WEB-NEW-EXISTS-CD                                         
MFA-TR*          ,:E9-WEB-SIGN-UP-FL                                            
MFA-TR*          ,:E9-OFF-OPT-EXCLUDE-CD                                        
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8130'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFFER_OPTION'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-3         
              MOVE 'OFFER_OPT_START_DT'      TO TABLE-ELEMENT-4         
              MOVE E9-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE E9-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              MOVE E9-OPTION-CD              TO HOSTVAR-ELEMENT-3       
              MOVE E9-OFFER-OPT-START-DT     TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8140-UPT-OFFER-OPTION.                                         *        
      ******************************************************************        
       8140-UPT-OFFER-OPTION.                                           
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_OFFER_OPTION                                  
                  SET OPTION_SORT_SEQ_NO = :E9-OPTION-SORT-SEQ-NO       
                     ,OPTION_URL_TX      = :E9-OPTION-URL-TX            
                     ,LAST_UPDATE_USERID = :E9-LAST-UPDATE-USERID       
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :E9-LAST-UPDATE-TS
              )           
                     ,DROP_OPTION_CD     = :E9-DROP-OPTION-CD           
                     ,OFFER_OPT_END_DT   = IIF(TRY_CONVERT(DATE, 
                                                   :E9-OFFER-OPT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :E9-OFFER-OPT-END-DT
              ) <> 0) OR (LEN(:E9-OFFER-OPT-END-DT
              ) <> 10), CIS.CHAR2DATE(:E9-OFFER-OPT-END-DT
              ), CONVERT(DATE, :E9-OFFER-OPT-END-DT) )         
                     ,OFF_OPT_VSTART_TS  = CIS.CHAR2TIMESTAMP(
                                                  :E9-OFF-OPT-VSTART-TS
              )        
                     ,OFF_OPT_VEND_TS    = CIS.CHAR2TIMESTAMP(
                                                    :E9-OFF-OPT-VEND-TS
              )          
                     ,PROC_STATUS_CD     = :E9-PROC-STATUS-CD           
A04805               ,WEB_NEW_EXISTS_CD  = :E9-WEB-NEW-EXISTS-CD        
A04805               ,WEB_SIGN_UP_FL     = :E9-WEB-SIGN-UP-FL           
A04805               ,OFF_OPT_EXCLUDE_CD = :E9-OFF-OPT-EXCLUDE-CD       
                WHERE COMPANY_NO         = :E9-COMPANY-NO               
                  AND OFFER_CD           = :E9-OFFER-CD                 
                  AND OPTION_CD          = :E9-OPTION-CD                
                  AND OFFER_OPT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                 :E9-OFFER-OPT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :E9-OFFER-OPT-START-DT
              ) <> 0) OR (LEN(:E9-OFFER-OPT-START-DT
              ) <> 10), CIS.CHAR2DATE(:E9-OFFER-OPT-START-DT
              ), CONVERT(DATE, :E9-OFFER-OPT-START-DT) )       
                  AND OFF_OPT_VRSN_NO    = :E9-OFF-OPT-VRSN-NO          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_OFFER_OPTION                                          
MFA-TR*           SET OPTION_SORT_SEQ_NO = :E9-OPTION-SORT-SEQ-NO               
MFA-TR*              ,OPTION_URL_TX      = :E9-OPTION-URL-TX                    
MFA-TR*              ,LAST_UPDATE_USERID = :E9-LAST-UPDATE-USERID               
MFA-TR*              ,LAST_UPDATE_TS     = :E9-LAST-UPDATE-TS                   
MFA-TR*              ,DROP_OPTION_CD     = :E9-DROP-OPTION-CD                   
MFA-TR*              ,OFFER_OPT_END_DT   = :E9-OFFER-OPT-END-DT                 
MFA-TR*              ,OFF_OPT_VSTART_TS  = :E9-OFF-OPT-VSTART-TS                
MFA-TR*              ,OFF_OPT_VEND_TS    = :E9-OFF-OPT-VEND-TS                  
MFA-TR*              ,PROC_STATUS_CD     = :E9-PROC-STATUS-CD                   
MFA-TR*              ,WEB_NEW_EXISTS_CD  = :E9-WEB-NEW-EXISTS-CD                
MFA-TR*              ,WEB_SIGN_UP_FL     = :E9-WEB-SIGN-UP-FL                   
MFA-TR*              ,OFF_OPT_EXCLUDE_CD = :E9-OFF-OPT-EXCLUDE-CD               
MFA-TR*         WHERE COMPANY_NO         = :E9-COMPANY-NO                       
MFA-TR*           AND OFFER_CD           = :E9-OFFER-CD                         
MFA-TR*           AND OPTION_CD          = :E9-OPTION-CD                        
MFA-TR*           AND OFFER_OPT_START_DT = :E9-OFFER-OPT-START-DT               
MFA-TR*           AND OFF_OPT_VRSN_NO    = :E9-OFF-OPT-VRSN-NO                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8140'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFFER_OPTION'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-3         
              MOVE 'OFFER_OPT_START_DT'      TO TABLE-ELEMENT-4         
              MOVE E9-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE E9-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              MOVE E9-OPTION-CD              TO HOSTVAR-ELEMENT-3       
              MOVE E9-OFFER-OPT-START-DT     TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8142-UPT-OFFER-OPTION-VENDTS.                                 *         
      ******************************************************************        
       8142-UPT-OFFER-OPTION-VENDTS.                                    
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_OFFER_OPTION                                  
                  SET OFF_OPT_VEND_TS                                   
                  = ( DATEADD( MICROSECOND, -1, CIS.CHAR2TIMESTAMP (
                                                :E9-OFF-OPT-VSTART-TS )
               ) )        
                     ,LAST_UPDATE_USERID = :E9-LAST-UPDATE-USERID       
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :E9-LAST-UPDATE-TS
              )           
                WHERE COMPANY_NO         = :E9-COMPANY-NO               
                  AND OFFER_CD           = :E9-OFFER-CD                 
                  AND OPTION_CD          = :E9-OPTION-CD                
                  AND OFFER_OPT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                 :E9-OFFER-OPT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :E9-OFFER-OPT-START-DT
              ) <> 0) OR (LEN(:E9-OFFER-OPT-START-DT
              ) <> 10), CIS.CHAR2DATE(:E9-OFFER-OPT-START-DT
              ), CONVERT(DATE, :E9-OFFER-OPT-START-DT) )       
                  AND OFF_OPT_VRSN_NO    = :WS-MAX-APRVL-VRSN           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_OFFER_OPTION                                          
MFA-TR*           SET OFF_OPT_VEND_TS                                           
MFA-TR*           = ( TIMESTAMP (:E9-OFF-OPT-VSTART-TS )                        
MFA-TR*                                        - 1 MICROSECOND )                
MFA-TR*              ,LAST_UPDATE_USERID = :E9-LAST-UPDATE-USERID               
MFA-TR*              ,LAST_UPDATE_TS     = :E9-LAST-UPDATE-TS                   
MFA-TR*         WHERE COMPANY_NO         = :E9-COMPANY-NO                       
MFA-TR*           AND OFFER_CD           = :E9-OFFER-CD                         
MFA-TR*           AND OPTION_CD          = :E9-OPTION-CD                        
MFA-TR*           AND OFFER_OPT_START_DT = :E9-OFFER-OPT-START-DT               
MFA-TR*           AND OFF_OPT_VRSN_NO    = :WS-MAX-APRVL-VRSN                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8142'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFFER_OPTION'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-3         
              MOVE 'OFFER_OPT_START_DT'      TO TABLE-ELEMENT-4         
              MOVE E9-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE E9-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              MOVE E9-OPTION-CD              TO HOSTVAR-ELEMENT-3       
              MOVE E9-OFFER-OPT-START-DT     TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8142-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8144-UPT-OFFER-OPTION-STATUS.                                 *         
      ******************************************************************        
       8144-UPT-OFFER-OPTION-STATUS.                                    
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_OFFER_OPTION                                  
                  SET PROC_STATUS_CD     = :E9-PROC-STATUS-CD           
                     ,LAST_UPDATE_USERID = :E9-LAST-UPDATE-USERID       
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :E9-LAST-UPDATE-TS
              )           
                WHERE COMPANY_NO         = :E9-COMPANY-NO               
                  AND OFFER_CD           = :E9-OFFER-CD                 
                  AND OPTION_CD          = :E9-OPTION-CD                
                  AND OFFER_OPT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                 :E9-OFFER-OPT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :E9-OFFER-OPT-START-DT
              ) <> 0) OR (LEN(:E9-OFFER-OPT-START-DT
              ) <> 10), CIS.CHAR2DATE(:E9-OFFER-OPT-START-DT
              ), CONVERT(DATE, :E9-OFFER-OPT-START-DT) )       
                  AND OFF_OPT_VRSN_NO    = :E9-OFF-OPT-VRSN-NO          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_OFFER_OPTION                                          
MFA-TR*           SET PROC_STATUS_CD     = :E9-PROC-STATUS-CD                   
MFA-TR*              ,LAST_UPDATE_USERID = :E9-LAST-UPDATE-USERID               
MFA-TR*              ,LAST_UPDATE_TS     = :E9-LAST-UPDATE-TS                   
MFA-TR*         WHERE COMPANY_NO         = :E9-COMPANY-NO                       
MFA-TR*           AND OFFER_CD           = :E9-OFFER-CD                         
MFA-TR*           AND OPTION_CD          = :E9-OPTION-CD                        
MFA-TR*           AND OFFER_OPT_START_DT = :E9-OFFER-OPT-START-DT               
MFA-TR*           AND OFF_OPT_VRSN_NO    = :E9-OFF-OPT-VRSN-NO                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8144'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFFER_OPTION'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-3         
              MOVE 'OFFER_OPT_START_DT'      TO TABLE-ELEMENT-4         
              MOVE E9-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE E9-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              MOVE E9-OPTION-CD              TO HOSTVAR-ELEMENT-3       
              MOVE E9-OFFER-OPT-START-DT     TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8144-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8145-DEL-OFFER-OPTION.                                        *         
      ******************************************************************        
       8145-DEL-OFFER-OPTION.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM CRM_OFFER_OPTION                             
                WHERE COMPANY_NO         = :E9-COMPANY-NO               
                  AND OFFER_CD           = :E9-OFFER-CD                 
                  AND OPTION_CD          = :E9-OPTION-CD                
                  AND OFFER_OPT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                 :E9-OFFER-OPT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :E9-OFFER-OPT-START-DT
              ) <> 0) OR (LEN(:E9-OFFER-OPT-START-DT
              ) <> 10), CIS.CHAR2DATE(:E9-OFFER-OPT-START-DT
              ), CONVERT(DATE, :E9-OFFER-OPT-START-DT) )       
                  AND OFF_OPT_VRSN_NO    = :E9-OFF-OPT-VRSN-NO          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CRM_OFFER_OPTION                                     
MFA-TR*         WHERE COMPANY_NO         = :E9-COMPANY-NO                       
MFA-TR*           AND OFFER_CD           = :E9-OFFER-CD                         
MFA-TR*           AND OPTION_CD          = :E9-OPTION-CD                        
MFA-TR*           AND OFFER_OPT_START_DT = :E9-OFFER-OPT-START-DT               
MFA-TR*           AND OFF_OPT_VRSN_NO    = :E9-OFF-OPT-VRSN-NO                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8145'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFFER_OPTION'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-3         
              MOVE 'OFFER_OPT_START_DT'      TO TABLE-ELEMENT-4         
              MOVE E9-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE E9-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              MOVE E9-OPTION-CD              TO HOSTVAR-ELEMENT-3       
              MOVE E9-OFFER-OPT-START-DT     TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8145-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8146-DEL-OFFER-OPTION.                                        *         
      ******************************************************************        
       8146-DEL-OFFER-OPTION.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM CRM_OFFER_OPTION                             
                WHERE COMPANY_NO         = :E9-COMPANY-NO               
                  AND OFFER_CD           = :E9-OFFER-CD                 
                  AND OPTION_CD          = :E9-OPTION-CD                
                  AND OFFER_OPT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                :WS-OLD-OFF-OPT-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-OLD-OFF-OPT-STRT-DT
              ) <> 0) OR (LEN(:WS-OLD-OFF-OPT-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:WS-OLD-OFF-OPT-STRT-DT
              ), CONVERT(DATE, :WS-OLD-OFF-OPT-STRT-DT) )      
                  AND PROC_STATUS_CD   IN (:WS-PROC-STATUS-NEW ,        
                                           :WS-PROC-STATUS-ERLY-APRVL)  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CRM_OFFER_OPTION                                     
MFA-TR*         WHERE COMPANY_NO         = :E9-COMPANY-NO                       
MFA-TR*           AND OFFER_CD           = :E9-OFFER-CD                         
MFA-TR*           AND OPTION_CD          = :E9-OPTION-CD                        
MFA-TR*           AND OFFER_OPT_START_DT = :WS-OLD-OFF-OPT-STRT-DT              
MFA-TR*           AND PROC_STATUS_CD   IN (:WS-PROC-STATUS-NEW ,                
MFA-TR*                                    :WS-PROC-STATUS-ERLY-APRVL)          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8146'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OFFER_OPTION'        TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-2         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-3         
              MOVE 'OFFER_OPT_START_DT'      TO TABLE-ELEMENT-4         
              MOVE E9-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE E9-OFFER-CD               TO HOSTVAR-ELEMENT-2       
              MOVE E9-OPTION-CD              TO HOSTVAR-ELEMENT-3       
              MOVE WS-OLD-OFF-OPT-STRT-DT    TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8146-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8150-INS-OPT-ATTR-INCTV                                        *        
      ******************************************************************        
       8150-INS-OPT-ATTR-INCTV.                                         
                                                                        
           EXEC SQL                                                     
               INSERT INTO CRM_OPT_ATTR_INCTV                           
               (                                                        
                  COMPANY_NO                                            
                 ,OPTION_CD                                             
                 ,ATTR_INCTV_SEQ_NO                                     
                 ,RT_ATTR_INCTV_TYPE                                    
                 ,PRIMRY_OPT_ATTR_FL                                    
                 ,FACTOR_ID                                             
                 ,DURATION_NO                                           
                 ,APPL_PROGRAM_ID                                       
                 ,ATTR_INCTV_VALUE                                      
                 ,ATTR_INCTV_VAL_TX                                     
                 ,LAST_UPDATE_USERID                                    
                 ,LAST_UPDATE_TS                                        
                 ,GL_ACCT_CREDIT                                        
                 ,GL_ACCT_DEBIT                                         
                 ,CATEGORY_ID                                           
                 ,WQ_ROUTE_CATEGORY                                     
                 ,OPT_CHG_ACTION_CD                                     
                 ,ATTR_INCTV_STRT_DT                                    
                 ,ATTR_INCTV_END_DT                                     
                 ,OPT_ATTR_VRSN_NO                                      
                 ,OPT_ATTR_VSTART_TS                                    
                 ,OPT_ATTR_VEND_TS                                      
                 ,PROC_STATUS_CD                                        
                 ,PROC_REQ_ID                                           
               )                                                        
               VALUES                                                   
               (                                                        
                  :HQ-COMPANY-NO                                        
                 ,:HQ-OPTION-CD                                         
                 ,:HQ-ATTR-INCTV-SEQ-NO                                 
                 ,:HQ-RT-ATTR-INCTV-TYPE                                
                 ,:HQ-PRIMRY-OPT-ATTR-FL                                
                 ,:HQ-FACTOR-ID                                         
                 ,:HQ-DURATION-NO                                       
                 ,:HQ-APPL-PROGRAM-ID                                   
                 ,:HQ-ATTR-INCTV-VALUE                                  
                 ,:HQ-ATTR-INCTV-VAL-TX                                 
                 ,:HQ-LAST-UPDATE-USERID                                
                 ,CIS.CHAR2TIMESTAMP(:HQ-LAST-UPDATE-TS)                        
                 ,:HQ-GL-ACCT-CREDIT                                    
                 ,:HQ-GL-ACCT-DEBIT                                     
                 ,:HQ-CATEGORY-ID                                       
                 ,:HQ-WQ-ROUTE-CATEGORY                                 
                 ,:HQ-OPT-CHG-ACTION-CD                                 
                 ,IIF(TRY_CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )                       
                 ,IIF(TRY_CONVERT(DATE, :HQ-ATTR-INCTV-END-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-END-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-END-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-END-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-END-DT) )                        
                 ,:HQ-OPT-ATTR-VRSN-NO                                  
                 ,CIS.CHAR2TIMESTAMP(:HQ-OPT-ATTR-VSTART-TS)                    
                 ,CIS.CHAR2TIMESTAMP(:HQ-OPT-ATTR-VEND-TS)                      
                 ,:HQ-PROC-STATUS-CD                                    
                 ,:HQ-PROC-REQ-ID                                       
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CRM_OPT_ATTR_INCTV                                   
MFA-TR*        (                                                                
MFA-TR*           COMPANY_NO                                                    
MFA-TR*          ,OPTION_CD                                                     
MFA-TR*          ,ATTR_INCTV_SEQ_NO                                             
MFA-TR*          ,RT_ATTR_INCTV_TYPE                                            
MFA-TR*          ,PRIMRY_OPT_ATTR_FL                                            
MFA-TR*          ,FACTOR_ID                                                     
MFA-TR*          ,DURATION_NO                                                   
MFA-TR*          ,APPL_PROGRAM_ID                                               
MFA-TR*          ,ATTR_INCTV_VALUE                                              
MFA-TR*          ,ATTR_INCTV_VAL_TX                                             
MFA-TR*          ,LAST_UPDATE_USERID                                            
MFA-TR*          ,LAST_UPDATE_TS                                                
MFA-TR*          ,GL_ACCT_CREDIT                                                
MFA-TR*          ,GL_ACCT_DEBIT                                                 
MFA-TR*          ,CATEGORY_ID                                                   
MFA-TR*          ,WQ_ROUTE_CATEGORY                                             
MFA-TR*          ,OPT_CHG_ACTION_CD                                             
MFA-TR*          ,ATTR_INCTV_STRT_DT                                            
MFA-TR*          ,ATTR_INCTV_END_DT                                             
MFA-TR*          ,OPT_ATTR_VRSN_NO                                              
MFA-TR*          ,OPT_ATTR_VSTART_TS                                            
MFA-TR*          ,OPT_ATTR_VEND_TS                                              
MFA-TR*          ,PROC_STATUS_CD                                                
MFA-TR*          ,PROC_REQ_ID                                                   
MFA-TR*        )                                                                
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*           :HQ-COMPANY-NO                                                
MFA-TR*          ,:HQ-OPTION-CD                                                 
MFA-TR*          ,:HQ-ATTR-INCTV-SEQ-NO                                         
MFA-TR*          ,:HQ-RT-ATTR-INCTV-TYPE                                        
MFA-TR*          ,:HQ-PRIMRY-OPT-ATTR-FL                                        
MFA-TR*          ,:HQ-FACTOR-ID                                                 
MFA-TR*          ,:HQ-DURATION-NO                                               
MFA-TR*          ,:HQ-APPL-PROGRAM-ID                                           
MFA-TR*          ,:HQ-ATTR-INCTV-VALUE                                          
MFA-TR*          ,:HQ-ATTR-INCTV-VAL-TX                                         
MFA-TR*          ,:HQ-LAST-UPDATE-USERID                                        
MFA-TR*          ,:HQ-LAST-UPDATE-TS                                            
MFA-TR*          ,:HQ-GL-ACCT-CREDIT                                            
MFA-TR*          ,:HQ-GL-ACCT-DEBIT                                             
MFA-TR*          ,:HQ-CATEGORY-ID                                               
MFA-TR*          ,:HQ-WQ-ROUTE-CATEGORY                                         
MFA-TR*          ,:HQ-OPT-CHG-ACTION-CD                                         
MFA-TR*          ,:HQ-ATTR-INCTV-STRT-DT                                        
MFA-TR*          ,:HQ-ATTR-INCTV-END-DT                                         
MFA-TR*          ,:HQ-OPT-ATTR-VRSN-NO                                          
MFA-TR*          ,:HQ-OPT-ATTR-VSTART-TS                                        
MFA-TR*          ,:HQ-OPT-ATTR-VEND-TS                                          
MFA-TR*          ,:HQ-PROC-STATUS-CD                                            
MFA-TR*          ,:HQ-PROC-REQ-ID                                               
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8150'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OPT_ATTR_INCTV'      TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE 'ATTR_INCTV_SEQ_NO'       TO TABLE-ELEMENT-3         
              MOVE HQ-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE HQ-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              MOVE HQ-ATTR-INCTV-SEQ-NO      TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8160-UPT-OPT-ATTR-INCTV                                        *        
      ******************************************************************        
       8160-UPT-OPT-ATTR-INCTV.                                         
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_OPT_ATTR_INCTV                                
                                                                        
                  SET RT_ATTR_INCTV_TYPE = :HQ-RT-ATTR-INCTV-TYPE       
                     ,PRIMRY_OPT_ATTR_FL = :HQ-PRIMRY-OPT-ATTR-FL       
                     ,FACTOR_ID          = :HQ-FACTOR-ID                
                     ,DURATION_NO        = :HQ-DURATION-NO              
                     ,APPL_PROGRAM_ID    = :HQ-APPL-PROGRAM-ID          
                     ,ATTR_INCTV_VALUE   = :HQ-ATTR-INCTV-VALUE         
                     ,ATTR_INCTV_VAL_TX  = :HQ-ATTR-INCTV-VAL-TX        
                     ,LAST_UPDATE_USERID = :HQ-LAST-UPDATE-USERID       
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :HQ-LAST-UPDATE-TS
              )           
                     ,GL_ACCT_CREDIT     = :HQ-GL-ACCT-CREDIT           
                     ,GL_ACCT_DEBIT      = :HQ-GL-ACCT-DEBIT            
                     ,CATEGORY_ID        = :HQ-CATEGORY-ID              
                     ,WQ_ROUTE_CATEGORY  = :HQ-WQ-ROUTE-CATEGORY        
                     ,OPT_CHG_ACTION_CD  = :HQ-OPT-CHG-ACTION-CD        
      *              ,ATTR_INCTV_STRT_DT = :HQ-ATTR-INCTV-STRT-DT               
                     ,ATTR_INCTV_END_DT  = IIF(TRY_CONVERT(DATE, 
                                                  :HQ-ATTR-INCTV-END-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-END-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-END-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-END-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-END-DT) )        
                     ,OPT_ATTR_VSTART_TS = CIS.CHAR2TIMESTAMP(
                                                 :HQ-OPT-ATTR-VSTART-TS
              )       
                     ,OPT_ATTR_VEND_TS   = CIS.CHAR2TIMESTAMP(
                                                   :HQ-OPT-ATTR-VEND-TS
              )         
                     ,PROC_STATUS_CD     = :HQ-PROC-STATUS-CD           
      *              ,PROC_REQ_ID        = :HQ-PROC-REQ-ID                      
                WHERE COMPANY_NO         = :HQ-COMPANY-NO               
                  AND OPTION_CD          = :HQ-OPTION-CD                
                  AND ATTR_INCTV_SEQ_NO  = :HQ-ATTR-INCTV-SEQ-NO        
                  AND OPT_ATTR_VRSN_NO   = :HQ-OPT-ATTR-VRSN-NO         
                  AND ATTR_INCTV_STRT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_OPT_ATTR_INCTV                                        
MFA-TR*                                                                         
MFA-TR*           SET RT_ATTR_INCTV_TYPE = :HQ-RT-ATTR-INCTV-TYPE               
MFA-TR*              ,PRIMRY_OPT_ATTR_FL = :HQ-PRIMRY-OPT-ATTR-FL               
MFA-TR*              ,FACTOR_ID          = :HQ-FACTOR-ID                        
MFA-TR*              ,DURATION_NO        = :HQ-DURATION-NO                      
MFA-TR*              ,APPL_PROGRAM_ID    = :HQ-APPL-PROGRAM-ID                  
MFA-TR*              ,ATTR_INCTV_VALUE   = :HQ-ATTR-INCTV-VALUE                 
MFA-TR*              ,ATTR_INCTV_VAL_TX  = :HQ-ATTR-INCTV-VAL-TX                
MFA-TR*              ,LAST_UPDATE_USERID = :HQ-LAST-UPDATE-USERID               
MFA-TR*              ,LAST_UPDATE_TS     = :HQ-LAST-UPDATE-TS                   
MFA-TR*              ,GL_ACCT_CREDIT     = :HQ-GL-ACCT-CREDIT                   
MFA-TR*              ,GL_ACCT_DEBIT      = :HQ-GL-ACCT-DEBIT                    
MFA-TR*              ,CATEGORY_ID        = :HQ-CATEGORY-ID                      
MFA-TR*              ,WQ_ROUTE_CATEGORY  = :HQ-WQ-ROUTE-CATEGORY                
MFA-TR*              ,OPT_CHG_ACTION_CD  = :HQ-OPT-CHG-ACTION-CD                
MFA-TR*              ,ATTR_INCTV_STRT_DT = :HQ-ATTR-INCTV-STRT-DT               
MFA-TR*              ,ATTR_INCTV_END_DT  = :HQ-ATTR-INCTV-END-DT                
MFA-TR*              ,OPT_ATTR_VSTART_TS = :HQ-OPT-ATTR-VSTART-TS               
MFA-TR*              ,OPT_ATTR_VEND_TS   = :HQ-OPT-ATTR-VEND-TS                 
MFA-TR*              ,PROC_STATUS_CD     = :HQ-PROC-STATUS-CD                   
MFA-TR*              ,PROC_REQ_ID        = :HQ-PROC-REQ-ID                      
MFA-TR*         WHERE COMPANY_NO         = :HQ-COMPANY-NO                       
MFA-TR*           AND OPTION_CD          = :HQ-OPTION-CD                        
MFA-TR*           AND ATTR_INCTV_SEQ_NO  = :HQ-ATTR-INCTV-SEQ-NO                
MFA-TR*           AND OPT_ATTR_VRSN_NO   = :HQ-OPT-ATTR-VRSN-NO                 
MFA-TR*           AND ATTR_INCTV_STRT_DT = :HQ-ATTR-INCTV-STRT-DT               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8160'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OPT_ATTR_INCTV'      TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE 'ATTR_INCTV_SEQ_NO'       TO TABLE-ELEMENT-3         
              MOVE HQ-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE HQ-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              MOVE HQ-ATTR-INCTV-SEQ-NO      TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8162-UPT-OPT-ATTR-INCTV-VENDTS                                          
      ******************************************************************        
       8162-UPT-OPT-ATTR-INCTV-VENDTS.                                  
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_OPT_ATTR_INCTV                                
                  SET OPT_ATTR_VEND_TS                                  
                  = ( DATEADD( MICROSECOND, -1, CIS.CHAR2TIMESTAMP ( 
                                               :HQ-OPT-ATTR-VSTART-TS )
               ) )         
                     ,LAST_UPDATE_USERID = :HQ-LAST-UPDATE-USERID       
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :HQ-LAST-UPDATE-TS
              )           
                WHERE COMPANY_NO         = :HQ-COMPANY-NO               
                  AND OPTION_CD          = :HQ-OPTION-CD                
                  AND ATTR_INCTV_SEQ_NO  = :HQ-ATTR-INCTV-SEQ-NO        
                  AND OPT_ATTR_VRSN_NO   = :WS-MAX-APRVL-VRSN           
                  AND ATTR_INCTV_STRT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_OPT_ATTR_INCTV                                        
MFA-TR*           SET OPT_ATTR_VEND_TS                                          
MFA-TR*           = ( TIMESTAMP ( :HQ-OPT-ATTR-VSTART-TS )                      
MFA-TR*                                       - 1 MICROSECOND )                 
MFA-TR*              ,LAST_UPDATE_USERID = :HQ-LAST-UPDATE-USERID               
MFA-TR*              ,LAST_UPDATE_TS     = :HQ-LAST-UPDATE-TS                   
MFA-TR*         WHERE COMPANY_NO         = :HQ-COMPANY-NO                       
MFA-TR*           AND OPTION_CD          = :HQ-OPTION-CD                        
MFA-TR*           AND ATTR_INCTV_SEQ_NO  = :HQ-ATTR-INCTV-SEQ-NO                
MFA-TR*           AND OPT_ATTR_VRSN_NO   = :WS-MAX-APRVL-VRSN                   
MFA-TR*           AND ATTR_INCTV_STRT_DT = :HQ-ATTR-INCTV-STRT-DT               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8162'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OPT_ATTR_INCTV'      TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE 'ATTR_INCTV_SEQ_NO'       TO TABLE-ELEMENT-3         
              MOVE HQ-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE HQ-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              MOVE HQ-ATTR-INCTV-SEQ-NO      TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8162-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8164-UPT-OPT-ATTR-INCTV-STATUS                                          
      ******************************************************************        
       8164-UPT-OPT-ATTR-INCTV-STATUS.                                  
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_OPT_ATTR_INCTV                                
                  SET PROC_STATUS_CD     = :HQ-PROC-STATUS-CD           
                     ,LAST_UPDATE_USERID = :HQ-LAST-UPDATE-USERID       
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :HQ-LAST-UPDATE-TS
              )           
                WHERE COMPANY_NO         = :HQ-COMPANY-NO               
                  AND OPTION_CD          = :HQ-OPTION-CD                
                  AND ATTR_INCTV_SEQ_NO  = :HQ-ATTR-INCTV-SEQ-NO        
                  AND ATTR_INCTV_STRT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )       
                  AND OPT_ATTR_VRSN_NO   = :HQ-OPT-ATTR-VRSN-NO         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_OPT_ATTR_INCTV                                        
MFA-TR*           SET PROC_STATUS_CD     = :HQ-PROC-STATUS-CD                   
MFA-TR*              ,LAST_UPDATE_USERID = :HQ-LAST-UPDATE-USERID               
MFA-TR*              ,LAST_UPDATE_TS     = :HQ-LAST-UPDATE-TS                   
MFA-TR*         WHERE COMPANY_NO         = :HQ-COMPANY-NO                       
MFA-TR*           AND OPTION_CD          = :HQ-OPTION-CD                        
MFA-TR*           AND ATTR_INCTV_SEQ_NO  = :HQ-ATTR-INCTV-SEQ-NO                
MFA-TR*           AND ATTR_INCTV_STRT_DT = :HQ-ATTR-INCTV-STRT-DT               
MFA-TR*           AND OPT_ATTR_VRSN_NO   = :HQ-OPT-ATTR-VRSN-NO                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8164'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OPT_ATTR_INCTV'      TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE 'ATTR_INCTV_SEQ_NO'       TO TABLE-ELEMENT-3         
              MOVE HQ-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE HQ-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              MOVE HQ-ATTR-INCTV-SEQ-NO      TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8164-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8170-DEL-OPT-ATTR-INCTV                                        *        
      ******************************************************************        
       8170-DEL-OPT-ATTR-INCTV.                                         
                                                                        
           EXEC SQL                                                     
               DELETE FROM CRM_OPT_ATTR_INCTV                           
                WHERE COMPANY_NO         = :HQ-COMPANY-NO               
                  AND OPTION_CD          = :HQ-OPTION-CD                
                  AND ATTR_INCTV_SEQ_NO  = :HQ-ATTR-INCTV-SEQ-NO        
                  AND ATTR_INCTV_STRT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )       
                  AND OPT_ATTR_VRSN_NO   = :HQ-OPT-ATTR-VRSN-NO         
                  AND PROC_STATUS_CD     = :WS-PROC-STATUS-NEW          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CRM_OPT_ATTR_INCTV                                   
MFA-TR*         WHERE COMPANY_NO         = :HQ-COMPANY-NO                       
MFA-TR*           AND OPTION_CD          = :HQ-OPTION-CD                        
MFA-TR*           AND ATTR_INCTV_SEQ_NO  = :HQ-ATTR-INCTV-SEQ-NO                
MFA-TR*           AND ATTR_INCTV_STRT_DT = :HQ-ATTR-INCTV-STRT-DT               
MFA-TR*           AND OPT_ATTR_VRSN_NO   = :HQ-OPT-ATTR-VRSN-NO                 
MFA-TR*           AND PROC_STATUS_CD     = :WS-PROC-STATUS-NEW                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8170'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OPT_ATTR_INCTV'      TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE 'ATTR_INCTV_SEQ_NO'       TO TABLE-ELEMENT-3         
              MOVE HQ-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE HQ-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              MOVE HQ-ATTR-INCTV-SEQ-NO      TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8170-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8171-DEL-OPT-ATTR-INCTV                                        *        
      ******************************************************************        
       8171-DEL-OPT-ATTR-INCTV.                                         
                                                                        
           EXEC SQL                                                     
               DELETE FROM CRM_OPT_ATTR_INCTV                           
                WHERE COMPANY_NO         = :HQ-COMPANY-NO               
                  AND OPTION_CD          = :HQ-OPTION-CD                
                  AND ATTR_INCTV_SEQ_NO  = :HQ-ATTR-INCTV-SEQ-NO        
                  AND ATTR_INCTV_STRT_DT = IIF(TRY_CONVERT(DATE, 
                                             :WS-OLD-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-OLD-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:WS-OLD-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:WS-OLD-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :WS-OLD-ATTR-INCTV-STRT-DT) )   
                  AND OPT_ATTR_VRSN_NO   = :HQ-OPT-ATTR-VRSN-NO         
                  AND PROC_STATUS_CD     IN (:WS-PROC-STATUS-NEW ,      
                                             :WS-PROC-STATUS-ERLY-APRVL)
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CRM_OPT_ATTR_INCTV                                   
MFA-TR*         WHERE COMPANY_NO         = :HQ-COMPANY-NO                       
MFA-TR*           AND OPTION_CD          = :HQ-OPTION-CD                        
MFA-TR*           AND ATTR_INCTV_SEQ_NO  = :HQ-ATTR-INCTV-SEQ-NO                
MFA-TR*           AND ATTR_INCTV_STRT_DT = :WS-OLD-ATTR-INCTV-STRT-DT           
MFA-TR*           AND OPT_ATTR_VRSN_NO   = :HQ-OPT-ATTR-VRSN-NO                 
MFA-TR*           AND PROC_STATUS_CD     IN (:WS-PROC-STATUS-NEW ,              
MFA-TR*                                      :WS-PROC-STATUS-ERLY-APRVL)        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8171'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OPT_ATTR_INCTV'      TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE 'ATTR_INCTV_SEQ_NO'       TO TABLE-ELEMENT-3         
              MOVE HQ-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE HQ-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              MOVE HQ-ATTR-INCTV-SEQ-NO      TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8171-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8180-INS-ACCESS-OFF-OPT                                        *        
      ******************************************************************        
       8180-INS-ACCESS-OFF-OPT.                                         
                                                                        
           EXEC SQL                                                     
               INSERT INTO CRM_ACCESS_OFF_OPT                           
               (                                                        
                  COMPANY_NO                                            
                 ,OPTION_CD                                             
                 ,OFFER_CD                                              
                 ,CATEGORY_ID                                           
                 ,ACCESS_START_DT                                       
                 ,ACCESS_END_DT                                         
                 ,VIEW_APPLY_CD                                         
                 ,LAST_UPDATE_USERID                                    
                 ,LAST_UPDATE_TS                                        
                 ,COMMENTS_TX                                           
                 ,ACCESS_VRSN_NO                                        
                 ,ACCESS_VSTART_TS                                      
                 ,ACCESS_VEND_TS                                        
                 ,PROC_STATUS_CD                                        
                 ,PROC_REQ_ID                                           
               )                                                        
               VALUES                                                   
               (                                                        
                  :CI-COMPANY-NO                                        
                 ,:CI-OPTION-CD                                         
                 ,:CI-OFFER-CD                                          
                 ,:CI-CATEGORY-ID                                       
                 ,IIF(TRY_CONVERT(DATE, :CI-ACCESS-START-DT
              ) IS NULL OR (PATINDEX('%.%', :CI-ACCESS-START-DT
              ) <> 0) OR (LEN(:CI-ACCESS-START-DT
              ) <> 10), CIS.CHAR2DATE(:CI-ACCESS-START-DT
              ), CONVERT(DATE, :CI-ACCESS-START-DT) )                          
                 ,IIF(TRY_CONVERT(DATE, :CI-ACCESS-END-DT
              ) IS NULL OR (PATINDEX('%.%', :CI-ACCESS-END-DT
              ) <> 0) OR (LEN(:CI-ACCESS-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :CI-ACCESS-END-DT
              ), CONVERT(DATE, :CI-ACCESS-END-DT) )                            
                 ,:CI-VIEW-APPLY-CD                                     
                 ,:CI-LAST-UPDATE-USERID                                
                 ,CIS.CHAR2TIMESTAMP(:CI-LAST-UPDATE-TS)                        
                 ,:CI-COMMENTS-TX                                       
                 ,:CI-ACCESS-VRSN-NO                                    
                 ,CIS.CHAR2TIMESTAMP(:CI-ACCESS-VSTART-TS)                      
                 ,CIS.CHAR2TIMESTAMP(:CI-ACCESS-VEND-TS)                        
                 ,:CI-PROC-STATUS-CD                                    
                 ,:CI-PROC-REQ-ID                                       
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CRM_ACCESS_OFF_OPT                                   
MFA-TR*        (                                                                
MFA-TR*           COMPANY_NO                                                    
MFA-TR*          ,OPTION_CD                                                     
MFA-TR*          ,OFFER_CD                                                      
MFA-TR*          ,CATEGORY_ID                                                   
MFA-TR*          ,ACCESS_START_DT                                               
MFA-TR*          ,ACCESS_END_DT                                                 
MFA-TR*          ,VIEW_APPLY_CD                                                 
MFA-TR*          ,LAST_UPDATE_USERID                                            
MFA-TR*          ,LAST_UPDATE_TS                                                
MFA-TR*          ,COMMENTS_TX                                                   
MFA-TR*          ,ACCESS_VRSN_NO                                                
MFA-TR*          ,ACCESS_VSTART_TS                                              
MFA-TR*          ,ACCESS_VEND_TS                                                
MFA-TR*          ,PROC_STATUS_CD                                                
MFA-TR*          ,PROC_REQ_ID                                                   
MFA-TR*        )                                                                
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*           :CI-COMPANY-NO                                                
MFA-TR*          ,:CI-OPTION-CD                                                 
MFA-TR*          ,:CI-OFFER-CD                                                  
MFA-TR*          ,:CI-CATEGORY-ID                                               
MFA-TR*          ,:CI-ACCESS-START-DT                                           
MFA-TR*          ,:CI-ACCESS-END-DT                                             
MFA-TR*          ,:CI-VIEW-APPLY-CD                                             
MFA-TR*          ,:CI-LAST-UPDATE-USERID                                        
MFA-TR*          ,:CI-LAST-UPDATE-TS                                            
MFA-TR*          ,:CI-COMMENTS-TX                                               
MFA-TR*          ,:CI-ACCESS-VRSN-NO                                            
MFA-TR*          ,:CI-ACCESS-VSTART-TS                                          
MFA-TR*          ,:CI-ACCESS-VEND-TS                                            
MFA-TR*          ,:CI-PROC-STATUS-CD                                            
MFA-TR*          ,:CI-PROC-REQ-ID                                               
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8180'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_ACCESS_OFF_OPT'      TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-3         
              MOVE 'CATEGORY_ID'             TO TABLE-ELEMENT-4         
              MOVE CI-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CI-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              MOVE CI-OFFER-CD               TO HOSTVAR-ELEMENT-3       
              MOVE CI-CATEGORY-ID            TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8190-UPT-ACCESS-OFF-OPT                                        *        
      ******************************************************************        
       8190-UPT-ACCESS-OFF-OPT.                                         
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_ACCESS_OFF_OPT                                
                  SET ACCESS_END_DT      = IIF(TRY_CONVERT(DATE, 
                                                      :CI-ACCESS-END-DT
              ) IS NULL OR (PATINDEX('%.%', :CI-ACCESS-END-DT
              ) <> 0) OR (LEN(:CI-ACCESS-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :CI-ACCESS-END-DT
              ), CONVERT(DATE, :CI-ACCESS-END-DT) )            
      *              ,VIEW_APPLY_CD      = :CI-VIEW-APPLY-CD                    
                     ,LAST_UPDATE_USERID = :CI-LAST-UPDATE-USERID       
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :CI-LAST-UPDATE-TS
              )           
                     ,COMMENTS_TX        = :CI-COMMENTS-TX              
                     ,ACCESS_VSTART_TS   = CIS.CHAR2TIMESTAMP(
                                                   :CI-ACCESS-VSTART-TS
              )         
                     ,ACCESS_VEND_TS     = CIS.CHAR2TIMESTAMP(
                                                     :CI-ACCESS-VEND-TS
              )           
                     ,PROC_STATUS_CD     = :CI-PROC-STATUS-CD           
      *              ,PROC_REQ_ID        = :CI-PROC-REQ-ID                      
                WHERE COMPANY_NO         = :CI-COMPANY-NO               
                  AND OPTION_CD          = :CI-OPTION-CD                
                  AND OFFER_CD           = :CI-OFFER-CD                 
                  AND CATEGORY_ID        = :CI-CATEGORY-ID              
                  AND ACCESS_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                    :CI-ACCESS-START-DT
              ) IS NULL OR (PATINDEX('%.%', :CI-ACCESS-START-DT
              ) <> 0) OR (LEN(:CI-ACCESS-START-DT
              ) <> 10), CIS.CHAR2DATE(:CI-ACCESS-START-DT
              ), CONVERT(DATE, :CI-ACCESS-START-DT) )          
                  AND VIEW_APPLY_CD      = :CI-VIEW-APPLY-CD            
                  AND ACCESS_VRSN_NO     = :CI-ACCESS-VRSN-NO           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_ACCESS_OFF_OPT                                        
MFA-TR*           SET ACCESS_END_DT      = :CI-ACCESS-END-DT                    
MFA-TR*              ,VIEW_APPLY_CD      = :CI-VIEW-APPLY-CD                    
MFA-TR*              ,LAST_UPDATE_USERID = :CI-LAST-UPDATE-USERID               
MFA-TR*              ,LAST_UPDATE_TS     = :CI-LAST-UPDATE-TS                   
MFA-TR*              ,COMMENTS_TX        = :CI-COMMENTS-TX                      
MFA-TR*              ,ACCESS_VSTART_TS   = :CI-ACCESS-VSTART-TS                 
MFA-TR*              ,ACCESS_VEND_TS     = :CI-ACCESS-VEND-TS                   
MFA-TR*              ,PROC_STATUS_CD     = :CI-PROC-STATUS-CD                   
MFA-TR*              ,PROC_REQ_ID        = :CI-PROC-REQ-ID                      
MFA-TR*         WHERE COMPANY_NO         = :CI-COMPANY-NO                       
MFA-TR*           AND OPTION_CD          = :CI-OPTION-CD                        
MFA-TR*           AND OFFER_CD           = :CI-OFFER-CD                         
MFA-TR*           AND CATEGORY_ID        = :CI-CATEGORY-ID                      
MFA-TR*           AND ACCESS_START_DT    = :CI-ACCESS-START-DT                  
MFA-TR*           AND VIEW_APPLY_CD      = :CI-VIEW-APPLY-CD                    
MFA-TR*           AND ACCESS_VRSN_NO     = :CI-ACCESS-VRSN-NO                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8190'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_ACCESS_OFF_OPT'      TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-3         
              MOVE 'CATEGORY_ID'             TO TABLE-ELEMENT-4         
              MOVE CI-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CI-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              MOVE CI-OFFER-CD               TO HOSTVAR-ELEMENT-3       
              MOVE CI-CATEGORY-ID            TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8190-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8192-UPT-ACCESS-OFF-OPT-VENDTS.                                *        
      ******************************************************************        
       8192-UPT-ACCESS-OFF-OPT-VENDTS.                                  
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_ACCESS_OFF_OPT                                
                  SET ACCESS_VEND_TS                                    
                  =  ( DATEADD( MICROSECOND, -1, CIS.CHAR2TIMESTAMP ( 
                                                 :CI-ACCESS-VSTART-TS )
               ) )      
                     ,LAST_UPDATE_USERID = :CI-LAST-UPDATE-USERID       
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :CI-LAST-UPDATE-TS
              )           
                WHERE COMPANY_NO         = :CI-COMPANY-NO               
                  AND OPTION_CD          = :CI-OPTION-CD                
                  AND OFFER_CD           = :CI-OFFER-CD                 
                  AND CATEGORY_ID        = :CI-CATEGORY-ID              
                  AND ACCESS_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                    :CI-ACCESS-START-DT
              ) IS NULL OR (PATINDEX('%.%', :CI-ACCESS-START-DT
              ) <> 0) OR (LEN(:CI-ACCESS-START-DT
              ) <> 10), CIS.CHAR2DATE(:CI-ACCESS-START-DT
              ), CONVERT(DATE, :CI-ACCESS-START-DT) )          
      *           AND VIEW_APPLY_CD      = :CI-VIEW-APPLY-CD                    
                  AND ACCESS_VRSN_NO     = :WS-MAX-APRVL-VRSN           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_ACCESS_OFF_OPT                                        
MFA-TR*           SET ACCESS_VEND_TS                                            
MFA-TR*           =  ( TIMESTAMP ( :CI-ACCESS-VSTART-TS ) -                     
MFA-TR*                                            1 MICROSECOND )              
MFA-TR*              ,LAST_UPDATE_USERID = :CI-LAST-UPDATE-USERID               
MFA-TR*              ,LAST_UPDATE_TS     = :CI-LAST-UPDATE-TS                   
MFA-TR*         WHERE COMPANY_NO         = :CI-COMPANY-NO                       
MFA-TR*           AND OPTION_CD          = :CI-OPTION-CD                        
MFA-TR*           AND OFFER_CD           = :CI-OFFER-CD                         
MFA-TR*           AND CATEGORY_ID        = :CI-CATEGORY-ID                      
MFA-TR*           AND ACCESS_START_DT    = :CI-ACCESS-START-DT                  
MFA-TR*           AND VIEW_APPLY_CD      = :CI-VIEW-APPLY-CD                    
MFA-TR*           AND ACCESS_VRSN_NO     = :WS-MAX-APRVL-VRSN                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8192'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_ACCESS_OFF_OPT'      TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-3         
              MOVE 'CATEGORY_ID'             TO TABLE-ELEMENT-4         
              MOVE CI-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CI-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              MOVE CI-OFFER-CD               TO HOSTVAR-ELEMENT-3       
              MOVE CI-CATEGORY-ID            TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8192-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8194-UPT-ACCESS-OFF-OPT-STATUS.                                *        
      ******************************************************************        
       8194-UPT-ACCESS-OFF-OPT-STATUS.                                  
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_ACCESS_OFF_OPT                                
                  SET PROC_STATUS_CD     = :CI-PROC-STATUS-CD           
                     ,LAST_UPDATE_USERID = :CI-LAST-UPDATE-USERID       
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :CI-LAST-UPDATE-TS
              )           
                WHERE COMPANY_NO         = :CI-COMPANY-NO               
                  AND OPTION_CD          = :CI-OPTION-CD                
                  AND OFFER_CD           = :CI-OFFER-CD                 
                  AND CATEGORY_ID        = :CI-CATEGORY-ID              
                  AND ACCESS_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                    :CI-ACCESS-START-DT
              ) IS NULL OR (PATINDEX('%.%', :CI-ACCESS-START-DT
              ) <> 0) OR (LEN(:CI-ACCESS-START-DT
              ) <> 10), CIS.CHAR2DATE(:CI-ACCESS-START-DT
              ), CONVERT(DATE, :CI-ACCESS-START-DT) )          
                  AND VIEW_APPLY_CD      = :CI-VIEW-APPLY-CD            
                  AND ACCESS_VRSN_NO     = :CI-ACCESS-VRSN-NO           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_ACCESS_OFF_OPT                                        
MFA-TR*           SET PROC_STATUS_CD     = :CI-PROC-STATUS-CD                   
MFA-TR*              ,LAST_UPDATE_USERID = :CI-LAST-UPDATE-USERID               
MFA-TR*              ,LAST_UPDATE_TS     = :CI-LAST-UPDATE-TS                   
MFA-TR*         WHERE COMPANY_NO         = :CI-COMPANY-NO                       
MFA-TR*           AND OPTION_CD          = :CI-OPTION-CD                        
MFA-TR*           AND OFFER_CD           = :CI-OFFER-CD                         
MFA-TR*           AND CATEGORY_ID        = :CI-CATEGORY-ID                      
MFA-TR*           AND ACCESS_START_DT    = :CI-ACCESS-START-DT                  
MFA-TR*           AND VIEW_APPLY_CD      = :CI-VIEW-APPLY-CD                    
MFA-TR*           AND ACCESS_VRSN_NO     = :CI-ACCESS-VRSN-NO                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8194'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_ACCESS_OFF_OPT'      TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-3         
              MOVE 'CATEGORY_ID'             TO TABLE-ELEMENT-4         
              MOVE CI-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CI-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              MOVE CI-OFFER-CD               TO HOSTVAR-ELEMENT-3       
              MOVE CI-CATEGORY-ID            TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8194-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8195-DEL-ACCESS-OFF-OPT                                        *        
      ******************************************************************        
       8195-DEL-ACCESS-OFF-OPT.                                         
                                                                        
           EXEC SQL                                                     
               DELETE FROM CRM_ACCESS_OFF_OPT                           
                WHERE COMPANY_NO         = :CI-COMPANY-NO               
                  AND OPTION_CD          = :CI-OPTION-CD                
                  AND OFFER_CD           = :CI-OFFER-CD                 
                  AND CATEGORY_ID        = :CI-CATEGORY-ID              
                  AND ACCESS_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                    :CI-ACCESS-START-DT
              ) IS NULL OR (PATINDEX('%.%', :CI-ACCESS-START-DT
              ) <> 0) OR (LEN(:CI-ACCESS-START-DT
              ) <> 10), CIS.CHAR2DATE(:CI-ACCESS-START-DT
              ), CONVERT(DATE, :CI-ACCESS-START-DT) )          
                  AND VIEW_APPLY_CD      = :CI-VIEW-APPLY-CD            
                  AND ACCESS_VRSN_NO     = :CI-ACCESS-VRSN-NO           
                  AND PROC_STATUS_CD     = :WS-PROC-STATUS-NEW          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CRM_ACCESS_OFF_OPT                                   
MFA-TR*         WHERE COMPANY_NO         = :CI-COMPANY-NO                       
MFA-TR*           AND OPTION_CD          = :CI-OPTION-CD                        
MFA-TR*           AND OFFER_CD           = :CI-OFFER-CD                         
MFA-TR*           AND CATEGORY_ID        = :CI-CATEGORY-ID                      
MFA-TR*           AND ACCESS_START_DT    = :CI-ACCESS-START-DT                  
MFA-TR*           AND VIEW_APPLY_CD      = :CI-VIEW-APPLY-CD                    
MFA-TR*           AND ACCESS_VRSN_NO     = :CI-ACCESS-VRSN-NO                   
MFA-TR*           AND PROC_STATUS_CD     = :WS-PROC-STATUS-NEW                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8195'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_ACCESS_OFF_OPT'      TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-3         
              MOVE 'CATEGORY_ID'             TO TABLE-ELEMENT-4         
              MOVE CI-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CI-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              MOVE CI-OFFER-CD               TO HOSTVAR-ELEMENT-3       
              MOVE CI-CATEGORY-ID            TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8195-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8196-DEL-ACCESS-OFF-OPT                                        *        
      ******************************************************************        
       8196-DEL-ACCESS-OFF-OPT.                                         
                                                                        
           EXEC SQL                                                     
               DELETE FROM CRM_ACCESS_OFF_OPT                           
                WHERE COMPANY_NO         = :CI-COMPANY-NO               
                  AND OPTION_CD          = :CI-OPTION-CD                
                  AND OFFER_CD           = :CI-OFFER-CD                 
                  AND CATEGORY_ID        = :CI-CATEGORY-ID              
                  AND VIEW_APPLY_CD      = :WS-OLD-VIEW-APPLY-CD        
                  AND ACCESS_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                :WS-OLD-ACCESS-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-OLD-ACCESS-START-DT
              ) <> 0) OR (LEN(:WS-OLD-ACCESS-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-OLD-ACCESS-START-DT
              ), CONVERT(DATE, :WS-OLD-ACCESS-START-DT) )      
                  AND PROC_STATUS_CD     IN (:WS-PROC-STATUS-NEW,       
                                             :WS-PROC-STATUS-ERLY-APRVL)
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CRM_ACCESS_OFF_OPT                                   
MFA-TR*         WHERE COMPANY_NO         = :CI-COMPANY-NO                       
MFA-TR*           AND OPTION_CD          = :CI-OPTION-CD                        
MFA-TR*           AND OFFER_CD           = :CI-OFFER-CD                         
MFA-TR*           AND CATEGORY_ID        = :CI-CATEGORY-ID                      
MFA-TR*           AND VIEW_APPLY_CD      = :WS-OLD-VIEW-APPLY-CD                
MFA-TR*           AND ACCESS_START_DT    = :WS-OLD-ACCESS-START-DT              
MFA-TR*           AND PROC_STATUS_CD     IN (:WS-PROC-STATUS-NEW,               
MFA-TR*                                      :WS-PROC-STATUS-ERLY-APRVL)        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8196'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_ACCESS_OFF_OPT'      TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-3         
              MOVE 'CATEGORY_ID'             TO TABLE-ELEMENT-4         
              MOVE CI-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CI-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              MOVE CI-OFFER-CD               TO HOSTVAR-ELEMENT-3       
              MOVE CI-CATEGORY-ID            TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8196-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-INS-RT-GRP-OFFR.                                          *        
      ******************************************************************        
       8200-INS-RT-GRP-OFFR.                                            
                                                                        
           EXEC SQL                                                     
               INSERT INTO CRM_RATE_GRP_OFFER                           
               (                                                        
                  COMPANY_NO                                            
                 ,RATE_GROUP_TYPE_CD                                    
                 ,RATE_GROUP_CD                                         
                 ,SORT_SEQ_NO                                           
                 ,EFF_START_DT                                          
                 ,EFF_END_DT                                            
                 ,OFFER_CD                                              
                 ,OPTION_CD                                             
                 ,LAST_UPDATE_USERID                                    
                 ,LAST_UPDATE_TS                                        
                 ,GRP_OFF_VRSN_NO                                       
                 ,GRP_OFF_VSTART_TS                                     
                 ,GRP_OFF_VEND_TS                                       
                 ,PROC_STATUS_CD                                        
                 ,PROC_REQ_ID                                           
               )                                                        
               VALUES                                                   
               (                                                        
                  :G5-COMPANY-NO                                        
                 ,:G5-RATE-GROUP-TYPE-CD                                
                 ,:G5-RATE-GROUP-CD                                     
                 ,:G5-SORT-SEQ-NO                                       
                 ,IIF(TRY_CONVERT(DATE, :G5-EFF-START-DT
              ) IS NULL OR (PATINDEX('%.%', :G5-EFF-START-DT
              ) <> 0) OR (LEN(:G5-EFF-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :G5-EFF-START-DT
              ), CONVERT(DATE, :G5-EFF-START-DT) )                             
                 ,IIF(TRY_CONVERT(DATE, :G5-EFF-END-DT
              ) IS NULL OR (PATINDEX('%.%', :G5-EFF-END-DT
              ) <> 0) OR (LEN(:G5-EFF-END-DT) <> 10), CIS.CHAR2DATE(
                                                         :G5-EFF-END-DT
              ), CONVERT(DATE, :G5-EFF-END-DT) )                               
                 ,:G5-OFFER-CD                                          
                 ,:G5-OPTION-CD                                         
                 ,:G5-LAST-UPDATE-USERID                                
                 ,CIS.CHAR2TIMESTAMP(:G5-LAST-UPDATE-TS)                        
                 ,:G5-GRP-OFF-VRSN-NO                                   
                 ,CIS.CHAR2TIMESTAMP(:G5-GRP-OFF-VSTART-TS)                     
                 ,CIS.CHAR2TIMESTAMP(:G5-GRP-OFF-VEND-TS)                       
                 ,:G5-PROC-STATUS-CD                                    
                 ,:G5-PROC-REQ-ID                                       
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CRM_RATE_GRP_OFFER                                   
MFA-TR*        (                                                                
MFA-TR*           COMPANY_NO                                                    
MFA-TR*          ,RATE_GROUP_TYPE_CD                                            
MFA-TR*          ,RATE_GROUP_CD                                                 
MFA-TR*          ,SORT_SEQ_NO                                                   
MFA-TR*          ,EFF_START_DT                                                  
MFA-TR*          ,EFF_END_DT                                                    
MFA-TR*          ,OFFER_CD                                                      
MFA-TR*          ,OPTION_CD                                                     
MFA-TR*          ,LAST_UPDATE_USERID                                            
MFA-TR*          ,LAST_UPDATE_TS                                                
MFA-TR*          ,GRP_OFF_VRSN_NO                                               
MFA-TR*          ,GRP_OFF_VSTART_TS                                             
MFA-TR*          ,GRP_OFF_VEND_TS                                               
MFA-TR*          ,PROC_STATUS_CD                                                
MFA-TR*          ,PROC_REQ_ID                                                   
MFA-TR*        )                                                                
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*           :G5-COMPANY-NO                                                
MFA-TR*          ,:G5-RATE-GROUP-TYPE-CD                                        
MFA-TR*          ,:G5-RATE-GROUP-CD                                             
MFA-TR*          ,:G5-SORT-SEQ-NO                                               
MFA-TR*          ,:G5-EFF-START-DT                                              
MFA-TR*          ,:G5-EFF-END-DT                                                
MFA-TR*          ,:G5-OFFER-CD                                                  
MFA-TR*          ,:G5-OPTION-CD                                                 
MFA-TR*          ,:G5-LAST-UPDATE-USERID                                        
MFA-TR*          ,:G5-LAST-UPDATE-TS                                            
MFA-TR*          ,:G5-GRP-OFF-VRSN-NO                                           
MFA-TR*          ,:G5-GRP-OFF-VSTART-TS                                         
MFA-TR*          ,:G5-GRP-OFF-VEND-TS                                           
MFA-TR*          ,:G5-PROC-STATUS-CD                                            
MFA-TR*          ,:G5-PROC-REQ-ID                                               
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RATE_GRP_OFFER'      TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'RATE_GROUP_TYPE_CD'      TO TABLE-ELEMENT-2         
              MOVE 'RATE_GROUP_CD'           TO TABLE-ELEMENT-3         
              MOVE 'EFF_START_DT'            TO TABLE-ELEMENT-4         
              MOVE G5-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE G5-RATE-GROUP-TYPE-CD     TO HOSTVAR-ELEMENT-2       
              MOVE G5-RATE-GROUP-CD          TO HOSTVAR-ELEMENT-3       
              MOVE G5-EFF-START-DT           TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8210-UPT-RT-GRP-OFFR.                                          *        
      ******************************************************************        
       8210-UPT-RT-GRP-OFFR.                                            
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_RATE_GRP_OFFER                                
                  SET EFF_END_DT         = IIF(TRY_CONVERT(DATE, 
                                                         :G5-EFF-END-DT
              ) IS NULL OR (PATINDEX('%.%', :G5-EFF-END-DT
              ) <> 0) OR (LEN(:G5-EFF-END-DT) <> 10), CIS.CHAR2DATE(
                                                         :G5-EFF-END-DT
              ), CONVERT(DATE, :G5-EFF-END-DT) )               
                     ,OFFER_CD           = :G5-OFFER-CD                 
                     ,OPTION_CD          = :G5-OPTION-CD                
                     ,LAST_UPDATE_USERID = :G5-LAST-UPDATE-USERID       
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :G5-LAST-UPDATE-TS
              )           
                     ,GRP_OFF_VSTART_TS  = CIS.CHAR2TIMESTAMP(
                                                  :G5-GRP-OFF-VSTART-TS
              )        
                     ,GRP_OFF_VEND_TS    = CIS.CHAR2TIMESTAMP(
                                                    :G5-GRP-OFF-VEND-TS
              )          
                     ,PROC_STATUS_CD     = :G5-PROC-STATUS-CD           
      *              ,PROC_REQ_ID        = :G5-PROC-REQ-ID                      
                WHERE COMPANY_NO         = :G5-COMPANY-NO               
                  AND OFFER_CD           = :G5-OFFER-CD                 
                  AND RATE_GROUP_TYPE_CD = :G5-RATE-GROUP-TYPE-CD       
                  AND RATE_GROUP_CD      = :G5-RATE-GROUP-CD            
                  AND SORT_SEQ_NO        = :G5-SORT-SEQ-NO              
                  AND EFF_START_DT       = IIF(TRY_CONVERT(DATE, 
                                                       :G5-EFF-START-DT
              ) IS NULL OR (PATINDEX('%.%', :G5-EFF-START-DT
              ) <> 0) OR (LEN(:G5-EFF-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :G5-EFF-START-DT
              ), CONVERT(DATE, :G5-EFF-START-DT) )             
                  AND GRP_OFF_VRSN_NO    = :G5-GRP-OFF-VRSN-NO          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_RATE_GRP_OFFER                                        
MFA-TR*           SET EFF_END_DT         = :G5-EFF-END-DT                       
MFA-TR*              ,OFFER_CD           = :G5-OFFER-CD                         
MFA-TR*              ,OPTION_CD          = :G5-OPTION-CD                        
MFA-TR*              ,LAST_UPDATE_USERID = :G5-LAST-UPDATE-USERID               
MFA-TR*              ,LAST_UPDATE_TS     = :G5-LAST-UPDATE-TS                   
MFA-TR*              ,GRP_OFF_VSTART_TS  = :G5-GRP-OFF-VSTART-TS                
MFA-TR*              ,GRP_OFF_VEND_TS    = :G5-GRP-OFF-VEND-TS                  
MFA-TR*              ,PROC_STATUS_CD     = :G5-PROC-STATUS-CD                   
MFA-TR*              ,PROC_REQ_ID        = :G5-PROC-REQ-ID                      
MFA-TR*         WHERE COMPANY_NO         = :G5-COMPANY-NO                       
MFA-TR*           AND OFFER_CD           = :G5-OFFER-CD                         
MFA-TR*           AND RATE_GROUP_TYPE_CD = :G5-RATE-GROUP-TYPE-CD               
MFA-TR*           AND RATE_GROUP_CD      = :G5-RATE-GROUP-CD                    
MFA-TR*           AND SORT_SEQ_NO        = :G5-SORT-SEQ-NO                      
MFA-TR*           AND EFF_START_DT       = :G5-EFF-START-DT                     
MFA-TR*           AND GRP_OFF_VRSN_NO    = :G5-GRP-OFF-VRSN-NO                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8210'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RATE_GRP_OFFER'      TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'RATE_GROUP_TYPE_CD'      TO TABLE-ELEMENT-2         
              MOVE 'RATE_GROUP_CD'           TO TABLE-ELEMENT-3         
              MOVE 'EFF_START_DT'            TO TABLE-ELEMENT-4         
              MOVE G5-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE G5-RATE-GROUP-TYPE-CD     TO HOSTVAR-ELEMENT-2       
              MOVE G5-RATE-GROUP-CD          TO HOSTVAR-ELEMENT-3       
              MOVE G5-EFF-START-DT           TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8212-UPT-RT-GRP-OFFR-VENDTS                                   *         
      ******************************************************************        
       8212-UPT-RT-GRP-OFFR-VENDTS.                                     
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_RATE_GRP_OFFER                                
                  SET GRP_OFF_VEND_TS                                   
                  = ( DATEADD( MICROSECOND, -1, CIS.CHAR2TIMESTAMP ( 
                                                :G5-GRP-OFF-VSTART-TS )
               ) )        
                     ,LAST_UPDATE_USERID = :G5-LAST-UPDATE-USERID       
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :G5-LAST-UPDATE-TS
              )           
                WHERE COMPANY_NO         = :G5-COMPANY-NO               
                  AND OFFER_CD           = :G5-OFFER-CD                 
                  AND RATE_GROUP_TYPE_CD = :G5-RATE-GROUP-TYPE-CD       
                  AND RATE_GROUP_CD      = :G5-RATE-GROUP-CD            
      *           AND SORT_SEQ_NO        = :G5-SORT-SEQ-NO                      
                  AND EFF_START_DT       = IIF(TRY_CONVERT(DATE, 
                                                       :G5-EFF-START-DT
              ) IS NULL OR (PATINDEX('%.%', :G5-EFF-START-DT
              ) <> 0) OR (LEN(:G5-EFF-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :G5-EFF-START-DT
              ), CONVERT(DATE, :G5-EFF-START-DT) )             
                  AND GRP_OFF_VRSN_NO    = :WS-MAX-APRVL-VRSN           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_RATE_GRP_OFFER                                        
MFA-TR*           SET GRP_OFF_VEND_TS                                           
MFA-TR*           = ( TIMESTAMP ( :G5-GRP-OFF-VSTART-TS )                       
MFA-TR*                                        - 1 MICROSECOND )                
MFA-TR*              ,LAST_UPDATE_USERID = :G5-LAST-UPDATE-USERID               
MFA-TR*              ,LAST_UPDATE_TS     = :G5-LAST-UPDATE-TS                   
MFA-TR*         WHERE COMPANY_NO         = :G5-COMPANY-NO                       
MFA-TR*           AND OFFER_CD           = :G5-OFFER-CD                         
MFA-TR*           AND RATE_GROUP_TYPE_CD = :G5-RATE-GROUP-TYPE-CD               
MFA-TR*           AND RATE_GROUP_CD      = :G5-RATE-GROUP-CD                    
MFA-TR*           AND SORT_SEQ_NO        = :G5-SORT-SEQ-NO                      
MFA-TR*           AND EFF_START_DT       = :G5-EFF-START-DT                     
MFA-TR*           AND GRP_OFF_VRSN_NO    = :WS-MAX-APRVL-VRSN                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8212'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RATE_GRP_OFFER'      TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'RATE_GROUP_TYPE_CD'      TO TABLE-ELEMENT-2         
              MOVE 'RATE_GROUP_CD'           TO TABLE-ELEMENT-3         
              MOVE 'EFF_START_DT'            TO TABLE-ELEMENT-4         
              MOVE G5-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE G5-RATE-GROUP-TYPE-CD     TO HOSTVAR-ELEMENT-2       
              MOVE G5-RATE-GROUP-CD          TO HOSTVAR-ELEMENT-3       
              MOVE G5-EFF-START-DT           TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8212-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8214-UPT-RT-GRP-OFFR-STATUS                                   *         
      ******************************************************************        
       8214-UPT-RT-GRP-OFFR-STATUS.                                     
                                                                        
           EXEC SQL                                                     
               UPDATE CRM_RATE_GRP_OFFER                                
                  SET PROC_STATUS_CD     = :G5-PROC-STATUS-CD           
                     ,LAST_UPDATE_USERID = :G5-LAST-UPDATE-USERID       
                     ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :G5-LAST-UPDATE-TS
              )           
                WHERE COMPANY_NO         = :G5-COMPANY-NO               
                  AND OFFER_CD           = :G5-OFFER-CD                 
                  AND RATE_GROUP_TYPE_CD = :G5-RATE-GROUP-TYPE-CD       
                  AND RATE_GROUP_CD      = :G5-RATE-GROUP-CD            
                  AND SORT_SEQ_NO        = :G5-SORT-SEQ-NO              
                  AND EFF_START_DT       = IIF(TRY_CONVERT(DATE, 
                                                       :G5-EFF-START-DT
              ) IS NULL OR (PATINDEX('%.%', :G5-EFF-START-DT
              ) <> 0) OR (LEN(:G5-EFF-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :G5-EFF-START-DT
              ), CONVERT(DATE, :G5-EFF-START-DT) )             
                  AND GRP_OFF_VRSN_NO    = :G5-GRP-OFF-VRSN-NO          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CRM_RATE_GRP_OFFER                                        
MFA-TR*           SET PROC_STATUS_CD     = :G5-PROC-STATUS-CD                   
MFA-TR*              ,LAST_UPDATE_USERID = :G5-LAST-UPDATE-USERID               
MFA-TR*              ,LAST_UPDATE_TS     = :G5-LAST-UPDATE-TS                   
MFA-TR*         WHERE COMPANY_NO         = :G5-COMPANY-NO                       
MFA-TR*           AND OFFER_CD           = :G5-OFFER-CD                         
MFA-TR*           AND RATE_GROUP_TYPE_CD = :G5-RATE-GROUP-TYPE-CD               
MFA-TR*           AND RATE_GROUP_CD      = :G5-RATE-GROUP-CD                    
MFA-TR*           AND SORT_SEQ_NO        = :G5-SORT-SEQ-NO                      
MFA-TR*           AND EFF_START_DT       = :G5-EFF-START-DT                     
MFA-TR*           AND GRP_OFF_VRSN_NO    = :G5-GRP-OFF-VRSN-NO                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8214'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RATE_GRP_OFFER'      TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'RATE_GROUP_TYPE_CD'      TO TABLE-ELEMENT-2         
              MOVE 'RATE_GROUP_CD'           TO TABLE-ELEMENT-3         
              MOVE 'EFF_START_DT'            TO TABLE-ELEMENT-4         
              MOVE G5-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE G5-RATE-GROUP-TYPE-CD     TO HOSTVAR-ELEMENT-2       
              MOVE G5-RATE-GROUP-CD          TO HOSTVAR-ELEMENT-3       
              MOVE G5-EFF-START-DT           TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8214-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8215-DEL-RT-GRP-OFFR.                                          *        
      ******************************************************************        
       8215-DEL-RT-GRP-OFFR.                                            
                                                                        
           EXEC SQL                                                     
               DELETE FROM CRM_RATE_GRP_OFFER                           
                WHERE COMPANY_NO         = :G5-COMPANY-NO               
                  AND OFFER_CD           = :G5-OFFER-CD                 
                  AND RATE_GROUP_TYPE_CD = :G5-RATE-GROUP-TYPE-CD       
                  AND RATE_GROUP_CD      = :G5-RATE-GROUP-CD            
                  AND SORT_SEQ_NO        = :G5-SORT-SEQ-NO              
                  AND EFF_START_DT       = IIF(TRY_CONVERT(DATE, 
                                                       :G5-EFF-START-DT
              ) IS NULL OR (PATINDEX('%.%', :G5-EFF-START-DT
              ) <> 0) OR (LEN(:G5-EFF-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :G5-EFF-START-DT
              ), CONVERT(DATE, :G5-EFF-START-DT) )             
                  AND GRP_OFF_VRSN_NO    = :G5-GRP-OFF-VRSN-NO          
                  AND PROC_STATUS_CD     = :WS-PROC-STATUS-NEW          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CRM_RATE_GRP_OFFER                                   
MFA-TR*         WHERE COMPANY_NO         = :G5-COMPANY-NO                       
MFA-TR*           AND OFFER_CD           = :G5-OFFER-CD                         
MFA-TR*           AND RATE_GROUP_TYPE_CD = :G5-RATE-GROUP-TYPE-CD               
MFA-TR*           AND RATE_GROUP_CD      = :G5-RATE-GROUP-CD                    
MFA-TR*           AND SORT_SEQ_NO        = :G5-SORT-SEQ-NO                      
MFA-TR*           AND EFF_START_DT       = :G5-EFF-START-DT                     
MFA-TR*           AND GRP_OFF_VRSN_NO    = :G5-GRP-OFF-VRSN-NO                  
MFA-TR*           AND PROC_STATUS_CD     = :WS-PROC-STATUS-NEW                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8215'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RATE_GRP_OFFER'      TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'RATE_GROUP_TYPE_CD'      TO TABLE-ELEMENT-2         
              MOVE 'RATE_GROUP_CD'           TO TABLE-ELEMENT-3         
              MOVE 'EFF_START_DT'            TO TABLE-ELEMENT-4         
              MOVE G5-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE G5-RATE-GROUP-TYPE-CD     TO HOSTVAR-ELEMENT-2       
              MOVE G5-RATE-GROUP-CD          TO HOSTVAR-ELEMENT-3       
              MOVE G5-EFF-START-DT           TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8215-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8217-DEL-RT-GRP-OFFR-BY-VRSN                                   *        
      ******************************************************************        
       8217-DEL-RT-GRP-OFFR-BY-VRSN.                                    
                                                                        
           EXEC SQL                                                     
               DELETE FROM CRM_RATE_GRP_OFFER                           
                WHERE COMPANY_NO         = :G5-COMPANY-NO               
                  AND OFFER_CD           = :G5-OFFER-CD                 
                  AND RATE_GROUP_TYPE_CD = :G5-RATE-GROUP-TYPE-CD       
                  AND RATE_GROUP_CD      = :G5-RATE-GROUP-CD            
                  AND GRP_OFF_VRSN_NO    = :G5-GRP-OFF-VRSN-NO          
                  AND PROC_STATUS_CD     = :G5-PROC-STATUS-CD           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8217'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RATE_GRP_OFFER'      TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'RATE_GROUP_TYPE_CD'      TO TABLE-ELEMENT-2         
              MOVE 'RATE_GROUP_CD'           TO TABLE-ELEMENT-3         
              MOVE 'EFF_START_DT'            TO TABLE-ELEMENT-4         
              MOVE G5-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE G5-RATE-GROUP-TYPE-CD     TO HOSTVAR-ELEMENT-2       
              MOVE G5-RATE-GROUP-CD          TO HOSTVAR-ELEMENT-3       
              MOVE G5-EFF-START-DT           TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8217-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 9910-SQL-ERROR.                                               *         
      *****************************************************************         
       9910-SQL-ERROR.                                                  
                                                                        
           EXIT PROGRAM.                                                
                                                                        
       9910-EXIT.                                                       
           EXIT.                                                        
                                                                        
