      *****************************************************************         
      **  CPD00728 COPYBOOK - USED IN MCSCB728 (CALLED FROM CSR04506) *         
      *****************************************************************         
      *****************************************************************         
      *   MODIFICATION LOG -                                          *         
      *                                                               *         
      *   DATE     INITIALS        COMMENTS                           *         
      *  ------    --------        -----------------------------------*         
      * 07/30/11   DB41297         INTIALLY WRITTEN.                  *         
      * 07/17/12   AW41078         COMMENTED OUT 7425-DELETE-REQ-CH   *         
      *                            AFTER ADDING CASCADE DELETE TO     *         
      *                            PREVENT 100 RETURN-CODE            *         
      *****************************************************************         
      *                 E R R O R  C O D E S                           *        
      *                                                                *        
      * 703 - INVALID/MISSING PARMS FOR PROMOTE                        *        
      * 707 - INVALID/MISSING PARMS FOR PROMOTE                        *        
      * 711 - INVALID/MISSING PARMS FOR DEMOTE                         *        
      * 777 - INVLAID CURNT-LAST-UPDATE-TS PASSED                               
      * 888 - SHOULD BE INSERT, DELETE OR UPDATE                       *        
      * 900 - INVALID PROC-REQ-ID FOR DELETE                           *        
      * 901 - INVALID GET-FIRST-BPR-STEP FOR INSERT                    *        
      * 902 - INVALID COMPANY-NO, PROC-GROUP-CD                        *        
      * 903 - INVALID NEXT PROC-REQ-ID RETURNED                        *        
      * 904 - INSERT ALREADY EXIST IN CSS_PROCESS_REQ                  *        
      * 905 - INVALID PROC-REQ-ID FOR PROMOTE                          *        
      * 906 - REQUIRED STEP ALREADY EXISTS FOR PROMOTE                 *        
      * 907 - INVALID GET-BPR-CNTRL FOR OVERRIDE-PROMOTE-BPR-STAT      *        
      * 908 - INVALID PROC-REQ-ID FOR PROMOTE BPR STAT                 *        
      * 909 - INVALID GET-NEXT-BPR-STEP                                *        
      * 910 - UPDATE BPR FAILED                                        *        
      * 912 - INVALID GET-BPR FOR DEMOTE                               *        
      * 913 - INVALID GET-BPR-CNTRL FOR DEMOTE                         *        
      * 914 - DELETE FAILED                                            *        
      * 915 - UPDATE BPR FAILED FOR DEMOTE                             *        
      * 916 - INSERT BPR-CHG FAILED FOR DEMOTE                         *        
      * 917 - INVALID GET-BPR-CNTRL FOR DEMOTE                         *        
      * 918 - UPDATE BPR FAILED                                        *        
      * 919 - INVALID GET-PREV-BPR-STEP FOR DEMOTE                     *        
      * 999 - INVALID UPDATE PARMS PASSED                              *        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE LS-MCSCB728-ACTION-FL                               
      *    //INSERT BUSINESS PROCESS REQUEST                                    
             WHEN 'I' PERFORM                                           
                    1100-PROCESS-INSERT-BPR THRU 1100-EXIT              
      *    //UPDATE BUSINESS PROCESS REQUEST                                    
             WHEN 'U' PERFORM                                           
                    1200-PROCESS-UPDATE-BPR THRU 1200-EXIT              
      *    //DELETE BUSINESS PROCESS REQUEST                                    
             WHEN 'D' PERFORM                                           
                    1300-PROCESS-DELETE-BPR THRU 1300-EXIT              
            WHEN OTHER                                                  
                PERFORM 1400-INVALID-REQUEST THRU 1400-EXIT             
           END-EVALUATE.                                                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-PROCESS-INSERT-BPR.                                       *        
      *              INSERT BUSINESS PROCESS REQUEST                   *        
      *     1. INSERT NEW BPR GROUP                                    *        
      *     2. SEND RESULT SET                                         *        
      ******************************************************************        
       1100-PROCESS-INSERT-BPR.                                         
                                                                        
           MOVE LR-MCSCB728-COMPANY-NO     TO 6P-COMPANY-NO.            
           MOVE LR-MCSCB728-CODE-UTIL-TYPE TO 6P-CODE-UTIL-TYPE.        
           MOVE LR-MCSCB728-PROC-TYPE-CD   TO 6P-PROC-TYPE-CD.          
           MOVE 'P'                        TO 6P-PROC-FLOW-IND.         
                                                                        
           PERFORM 7000-GET-FIRST-BPR-STEP THRU 7000-EXIT.              
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
             MOVE 901 TO WS-APPL-RETURN-CODE                            
             PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT            
             GO TO 1100-EXIT                                            
           END-IF.                                                      
                                                                        
           IF LR-MCSCB728-PROC-GROUP-CD > ' '                           
              MOVE LR-MCSCB728-PROC-GROUP-CD      TO 5P-PROC-GROUP-CD   
              MOVE LR-MCSCB728-COMPANY-NO         TO 5P-COMPANY-NO      
              MOVE LS-MCSCB728-PROC-GROUP-DESC    TO 5P-PROC-GROUP-DESC 
              MOVE LR-MCSCB728-LAST-UPDATE-USERID TO                    
                   5P-LAST-UPDATE-USERID                                
              MOVE WS-CURRENT-TIMESTAMP  TO 5P-LAST-UPDATE-TS           
              PERFORM 7025-CHECK-BPR-GROUP-EXISTS THRU 7025-EXIT        
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 IF LS-MCSCB728-PROC-GROUP-DESC = ' '                   
                    MOVE 902 TO WS-APPL-RETURN-CODE                     
                    PERFORM 2000-PROCESS-OUTPUT   THRU 2000-EXIT        
                    GO TO 1100-EXIT                                     
                 ELSE                                                   
                    PERFORM 7050-INSERT-BPR-GROUP THRU 7050-EXIT        
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7075-GET-NEXT-BPR-ID THRU 7075-EXIT.                 
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
             MOVE 903 TO WS-APPL-RETURN-CODE                            
             PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT            
             GO TO 1100-EXIT                                            
           END-IF.                                                      
                                                                        
           MOVE WS-NEXT-PROC-REQ-ID           TO 1P-PROC-REQ-ID         
                                                 4P-PROC-REQ-ID.        
           MOVE LR-MCSCB728-COMPANY-NO        TO 1P-COMPANY-NO.         
           MOVE LR-MCSCB728-CODE-UTIL-TYPE    TO 1P-CODE-UTIL-TYPE.     
           MOVE LR-MCSCB728-PROC-TYPE-CD      TO 1P-PROC-TYPE-CD.       
           MOVE 6P-STATUS-SEQ-NO              TO 1P-STATUS-SEQ-NO.      
           MOVE 6P-PROC-FLOW-IND              TO 1P-PROC-FLOW-IND       
                                                 4P-PROC-FLOW-IND.      
           MOVE 6P-PROC-STATUS-CD             TO 1P-PROC-STATUS-CD      
                                                 4P-PROC-STATUS-CD.     
           MOVE LR-MCSCB728-PROC-GROUP-CD     TO 1P-PROC-GROUP-CD.      
           MOVE LR-MCSCB728-CREATED-BY-USERID TO                        
                1P-CREATED-BY-USERID.                                   
           MOVE WS-CURRENT-TIMESTAMP   TO 1P-CREATED-TS                 
                                          1P-LAST-UPDATE-TS             
                                          4P-REQ-CHG-TS.                
           MOVE LR-MCSCB728-LAST-UPDATE-USERID TO 1P-LAST-UPDATE-USERID 
                                                  4P-REQ-CHG-USERID.    
           MOVE LR-MCSCB728-PROC-REQ-DESC TO 1P-PROC-REQ-DESC.          
           MOVE 6P-CATEGORY-ID            TO 4P-CATEGORY-ID.            
      * WHEN PASSED SHOULD BE VALID DB2 TIMESTAMP FORMAT                        
           IF LR-MCSCB728-EFFECTIVE-TS    > SPACES                      
              MOVE LR-MCSCB728-EFFECTIVE-TS    TO 1P-EFFECTIVE-TS       
              MOVE +0                     TO WS-TS-NULL-IND1            
           ELSE                                                         
              MOVE LOW-VALUES             TO 1P-EFFECTIVE-TS            
              MOVE -1                     TO WS-TS-NULL-IND1            
           END-IF.                                                      
      * WHEN PASSED SHOULD BE VALID DB2 TIMESTAMP FORMAT                        
           IF LR-MCSCB728-PROC-REQ-DUE-TS > SPACES                      
              MOVE LR-MCSCB728-PROC-REQ-DUE-TS TO 1P-PROC-REQ-DUE-TS    
              MOVE +0                     TO WS-TS-NULL-IND             
           ELSE                                                         
              MOVE LOW-VALUES             TO 1P-PROC-REQ-DUE-TS         
              MOVE -1                     TO WS-TS-NULL-IND             
           END-IF.                                                      
                                                                        
           MOVE SPACES TO 4P-REQ-CHG-COMMENTS-TEXT.                     
           MOVE 0      TO SUB1.                                         
           IF 6P-DEFAULT-COMMENTS-TEXT > ' '                            
             PERFORM VARYING SUB2 FROM 255 BY -1 UNTIL                  
              SUB2 < 1                          OR                      
              6P-DEFAULT-COMMENTS-TEXT(SUB2:1) NOT = ' ' AND LOW-VALUES 
             END-PERFORM                                                
             COMPUTE SUB1 = SUB2                                        
             MOVE 6P-DEFAULT-COMMENTS-TEXT(1:SUB1) TO                   
                  4P-REQ-CHG-COMMENTS-TEXT                              
             COMPUTE SUB1 = SUB1 + 1                                    
           END-IF.                                                      
                                                                        
           IF LS-MCSCB728-REQ-CHG-COMMENTS > ' '                        
             ADD 1 TO SUB1                                              
             PERFORM VARYING SUB2 FROM 255 BY -1 UNTIL                  
               SUB2 < 1                          OR                     
               LS-MCSCB728-REQ-CHG-COMMENTS(SUB2:1) NOT =               
                ' ' AND LOW-VALUES                                      
             END-PERFORM                                                
             MOVE LS-MCSCB728-REQ-CHG-COMMENTS(1:SUB2) TO               
                 4P-REQ-CHG-COMMENTS-TEXT(SUB1:SUB2)                    
             COMPUTE SUB1 = SUB1 + SUB2 - 1                             
           END-IF.                                                      
           MOVE SUB1 TO 4P-REQ-CHG-COMMENTS-LEN.                        
                                                                        
           PERFORM 7100-INSERT-BPR     THRU 7100-EXIT.                  
           IF WS-ACTIVE-RETURN-CODE = ALREADY-EXISTS                    
             MOVE 904 TO WS-APPL-RETURN-CODE                            
             PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT            
             GO TO 1100-EXIT                                            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE WS-CURRENT-TIMESTAMP    TO 4P-REQ-CHG-TS.               
                                                                        
           PERFORM 7125-INSERT-BPR-CHG THRU 7125-EXIT.                  
                                                                        
           PERFORM 2000-PROCESS-OUTPUT     THRU 2000-EXIT.              
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1200-PROCESS-UPDATE-BPR.                                       *        
      *            UPDATE BUSINESS PROCESS REQUEST                     *        
      *     1. CHECK OVERRIDE PROMOTE STAT                             *        
      *     2. CHECK PROMOTE STATUS                                    *        
      *     3. CHECK DEMOTE STATUS                                     *        
      *     4. SEND RESULT SET                                         *        
      ******************************************************************        
       1200-PROCESS-UPDATE-BPR.                                         
                                                                        
      *    // COMPARE THE CURRENT LAST UPDT TS PARAMETER PASSED TO SP           
      *    TO THE 1P-LAST-UPDATE-TS RETRIEVED FROM CSS_PROCESS_REQ QUERY        
                                                                        
           MOVE LN-PROC-REQ-ID           TO 1P-PROC-REQ-ID              
           PERFORM 7200-GET-BPR             THRU 7200-EXIT.             
           IF LR-MCSCB728-CRNT-LAST-UPDT-TS(1:19)                       
                                      NOT EQUAL 1P-LAST-UPDATE-TS(1:19) 
              MOVE 777 TO WS-APPL-RETURN-CODE                           
              PERFORM 2000-PROCESS-OUTPUT     THRU 2000-EXIT            
              GO TO 1200-EXIT                                           
           END-IF.                                                      
                                                                        
           EVALUATE TRUE                                                
      *       //OVERRIDE PROMOTE STATUS                                         
            WHEN LR-MCSCB728-PROC-FLOW-IND = 'P' AND                    
                 LS-MCSCB728-OVERRIDE-FL = 'Y' AND                      
                 LR-MCSCB728-STATUS-SEQ-NO > 0                          
                 PERFORM 2100-OVERRIDE-PROMOTE-BPR-STAT                 
                 THRU    2100-EXIT                                      
      *       //PROMOTE STATUS                                                  
            WHEN LR-MCSCB728-PROC-FLOW-IND = 'P' AND                    
                 LS-MCSCB728-OVERRIDE-FL NOT = 'Y'                      
                 PERFORM 2150-PROCESS-PROMOTE-BPR-STAT                  
                 THRU    2150-EXIT                                      
      *     //DEMOTE STATUS                                                     
              WHEN LR-MCSCB728-PROC-FLOW-IND = 'D'                      
                 PERFORM 2200-PROCESS-DEMOTE-BPR-STATUS                 
                 THRU    2200-EXIT                                      
      *     //ERROR - INVALID PARAMETERS                                        
              WHEN OTHER                                                
                 MOVE 999 TO WS-APPL-RETURN-CODE                        
                 PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT        
           END-EVALUATE.                                                
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1300-PROCESS-DELETE-BPR                                        *        
      *            DELETE BUSINESS PROCESS REQUEST                     *        
      *     1. DELETE BPR GROUP                                        *        
      *     2. SEND RESULT SET                                         *        
      ******************************************************************        
       1300-PROCESS-DELETE-BPR.                                         
                                                                        
           MOVE LN-PROC-REQ-ID         TO 1P-PROC-REQ-ID.               
                                                                        
           PERFORM 7200-GET-BPR             THRU 7200-EXIT.             
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
             MOVE 900 TO WS-APPL-RETURN-CODE                            
             PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT            
             GO TO 1300-EXIT                                            
           END-IF.                                                      
                                                                        
           MOVE LN-PROC-REQ-ID          TO     1P-PROC-REQ-ID.          
                                                                        
           PERFORM 7400-DELETE-BPR              THRU 7400-EXIT.         
                                                                        
           MOVE LN-PROC-REQ-ID          TO     1P-PROC-REQ-ID.          
      ***  PERFORM 7425-DELETE-REQ-CH           THRU 7425-EXIT.                 
                                                                        
           IF 1P-PROC-GROUP-CD > ' '                                    
              MOVE SPACES TO WS-PROC-GROUP-EXISTS-FL                    
              PERFORM 7375-CHECK-PROC-GROUP-EXISTS THRU 7375-EXIT       
              IF WS-PROC-GROUP-EXISTS-FL NOT = 'Y'                      
                 MOVE 1P-PROC-GROUP-CD    TO     5P-PROC-GROUP-CD       
                 PERFORM 7450-DELETE-BPR-GROUP THRU 7450-EXIT           
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                   MOVE 914 TO WS-APPL-RETURN-CODE                      
                   PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT      
                   GO TO 1300-EXIT                                      
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
                                                                        
       1300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1400-INVALID-REQUEST.                                          *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. BUILD RESULT SET                                        *        
      *     3. SEND RESULT SET                                         *        
      ******************************************************************        
       1400-INVALID-REQUEST.                                            
                                                                        
           MOVE 888 TO WS-APPL-RETURN-CODE.                             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
                                                                        
       1400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. BUILD RESULT SET                                        *        
      *     3. SEND RESULT SET                                         *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           IF WS-APPL-RETURN-CODE       NOT = 0                         
              MOVE 0                      TO LR-MCSCB728-RETURN-CODE    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO LR-MCSCB728-RETURN-CODE    
           END-IF.                                                      
                                                                        
           MOVE WS-APPL-RETURN-CODE       TO                            
                LR-MCSCB728-APPL-RETURN-CODE.                           
           MOVE 1P-PROC-REQ-ID            TO                            
                LR-MCSCB728-PROC-REQ-ID.                                
           MOVE 1P-STATUS-SEQ-NO          TO                            
                LR-MCSCB728-STATUS-SEQ-NO.                              
           MOVE 1P-PROC-REQ-DESC          TO                            
                LR-MCSCB728-PROC-REQ-DESC.                              
           MOVE 1P-PROC-GROUP-CD          TO                            
                LR-MCSCB728-PROC-GROUP-CD.                              
           MOVE 1P-CREATED-BY-USERID      TO                            
                LR-MCSCB728-CREATED-BY-USERID.                          
           MOVE 1P-CREATED-TS             TO                            
                LR-MCSCB728-CREATED-TS.                                 
           MOVE 1P-COMPANY-NO             TO                            
                LR-MCSCB728-COMPANY-NO.                                 
           MOVE 6P-CATEGORY-ID            TO                            
                LR-MCSCB728-CATEGORY-ID.                                
           MOVE 1P-EFFECTIVE-TS           TO                            
                LR-MCSCB728-EFFECTIVE-TS.                               
           MOVE 1P-PROC-REQ-DUE-TS        TO                            
                LR-MCSCB728-PROC-REQ-DUE-TS.                            
           MOVE 1P-CODE-UTIL-TYPE         TO                            
                LR-MCSCB728-CODE-UTIL-TYPE.                             
           MOVE 1P-PROC-TYPE-CD           TO                            
                LR-MCSCB728-PROC-TYPE-CD.                               
           MOVE 1P-PROC-FLOW-IND          TO                            
                LR-MCSCB728-PROC-FLOW-IND.                              
           MOVE 1P-PROC-STATUS-CD         TO                            
                LR-MCSCB728-PROC-STATUS-CD.                             
           MOVE 1P-LAST-UPDATE-USERID     TO                            
                LR-MCSCB728-LAST-UPDATE-USERID.                         
           MOVE 1P-LAST-UPDATE-TS         TO                            
                LR-MCSCB728-LAST-UPDATE-TS.                             
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-OVERRIDE-PROMOTE-BPR-STAT                                 *        
      ******************************************************************        
       2100-OVERRIDE-PROMOTE-BPR-STAT.                                  
                                                                        
           MOVE '2100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           IF LS-MCSCB728-APPL-PROG-ID = ' ' OR                         
              LS-MCSCB728-USER-ID = ' ' OR                              
              LS-MCSCB728-ACTION-FL = ' ' OR                            
              (LS-MCSCB728-OVERRIDE-FL NOT = 'Y') OR                    
              LN-PROC-REQ-ID    = ' ' OR                                
              LN-PROC-REQ-ID    NOT NUMERIC OR                          
              LN-PROC-REQ-ID = '0000000000' OR                          
              LR-MCSCB728-STATUS-SEQ-NO NOT NUMERIC OR                  
              LR-MCSCB728-STATUS-SEQ-NO = '0000000000' OR               
              LR-MCSCB728-PROC-FLOW-IND = ' ' OR                        
              LR-MCSCB728-LAST-UPDATE-USERID = ' '                      
                 MOVE 703 TO WS-APPL-RETURN-CODE                        
                 PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT        
                 GO TO 2100-EXIT                                        
           END-IF.                                                      
                                                                        
           MOVE LN-PROC-REQ-ID         TO 1P-PROC-REQ-ID.               
                                                                        
           PERFORM 7200-GET-BPR             THRU 7200-EXIT.             
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
             MOVE 905 TO WS-APPL-RETURN-CODE                            
             PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT            
             GO TO 2100-EXIT                                            
           END-IF.                                                      
                                                                        
           MOVE 1P-COMPANY-NO             TO 6P-COMPANY-NO.             
           MOVE 1P-CODE-UTIL-TYPE         TO 6P-CODE-UTIL-TYPE.         
           MOVE 1P-PROC-TYPE-CD           TO 6P-PROC-TYPE-CD.           
           MOVE LR-MCSCB728-STATUS-SEQ-NO TO WS-NEW-SEQ-NO.             
           MOVE 1P-STATUS-SEQ-NO          TO WS-CURNT-SEQ-NO.           
           MOVE 'P'                       TO 6P-PROC-FLOW-IND.          
           MOVE SPACES                    TO WS-REQUIRED-STEP-EXISTS-FL.
                                                                        
           PERFORM 7225-CHECK-BPR-REQUIRED-STEP THRU 7225-EXIT.         
           IF WS-REQUIRED-STEP-EXISTS-FL = 'Y'                          
             MOVE 906 TO WS-APPL-RETURN-CODE                            
             PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT            
             GO TO 2100-EXIT                                            
           END-IF.                                                      
                                                                        
           MOVE 1P-COMPANY-NO             TO 6P-COMPANY-NO.             
           MOVE 1P-CODE-UTIL-TYPE         TO 6P-CODE-UTIL-TYPE.         
           MOVE 1P-PROC-TYPE-CD           TO 6P-PROC-TYPE-CD.           
           MOVE LR-MCSCB728-STATUS-SEQ-NO TO 6P-STATUS-SEQ-NO           
                                             WS-NEW-SEQ-NO.             
           MOVE 'P'                       TO 6P-PROC-FLOW-IND.          
                                                                        
           PERFORM 7250-GET-BPR-CNTRL THRU 7250-EXIT.                   
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = 0                             
             MOVE 907 TO WS-APPL-RETURN-CODE                            
             PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT            
             GO TO 2100-EXIT                                            
           END-IF.                                                      
                                                                        
           MOVE LN-PROC-REQ-ID          TO 1P-PROC-REQ-ID               
                                           4P-PROC-REQ-ID.              
           MOVE 6P-STATUS-SEQ-NO        TO 1P-STATUS-SEQ-NO.            
           MOVE 6P-PROC-FLOW-IND        TO 1P-PROC-FLOW-IND.            
           MOVE 'O'                     TO 4P-PROC-FLOW-IND.            
           MOVE 6P-PROC-STATUS-CD       TO 1P-PROC-STATUS-CD            
                                           4P-PROC-STATUS-CD.           
           MOVE LR-MCSCB728-LAST-UPDATE-USERID TO 1P-LAST-UPDATE-USERID 
                                           4P-REQ-CHG-USERID.           
           MOVE WS-CURRENT-TIMESTAMP    TO 1P-LAST-UPDATE-TS            
                                           4P-REQ-CHG-TS.               
           MOVE 6P-CATEGORY-ID          TO 4P-CATEGORY-ID.              
      * WHEN PASSED SHOULD BE VALID DB2 TIMESTAMP FORMAT                        
           IF LR-MCSCB728-EFFECTIVE-TS    > SPACES                      
              MOVE LR-MCSCB728-EFFECTIVE-TS    TO 1P-EFFECTIVE-TS       
              MOVE +0                   TO WS-TS-NULL-IND1              
           ELSE                                                         
             IF 1P-EFFECTIVE-TS NOT > SPACES                            
                MOVE LOW-VALUES         TO 1P-EFFECTIVE-TS              
                MOVE -1                 TO WS-TS-NULL-IND1              
              ELSE                                                      
                  MOVE +0                   TO WS-TS-NULL-IND1          
             END-IF                                                     
           END-IF.                                                      
      * WHEN PASSED SHOULD BE VALID DB2 TIMESTAMP FORMAT                        
           IF LR-MCSCB728-PROC-REQ-DUE-TS > SPACES                      
              MOVE LR-MCSCB728-PROC-REQ-DUE-TS TO 1P-PROC-REQ-DUE-TS    
              MOVE +0                   TO WS-TS-NULL-IND               
           ELSE                                                         
             IF 1P-PROC-REQ-DUE-TS NOT > SPACES                         
                MOVE LOW-VALUES         TO 1P-PROC-REQ-DUE-TS           
                MOVE -1                 TO WS-TS-NULL-IND               
             ELSE                                                       
                 MOVE +0                TO WS-TS-NULL-IND               
             END-IF                                                     
           END-IF.                                                      
                                                                        
           MOVE SPACES TO 4P-REQ-CHG-COMMENTS-TEXT.                     
           MOVE 'OVERRIDE: ' TO 4P-REQ-CHG-COMMENTS-TEXT.               
           MOVE 10         TO SUB1.                                     
                                                                        
           IF 6P-DEFAULT-COMMENTS-TEXT > ' '                            
             ADD 1 TO SUB1                                              
             PERFORM VARYING SUB2 FROM 255 BY -1 UNTIL                  
               SUB2 < 1                          OR                     
              6P-DEFAULT-COMMENTS-TEXT(SUB2:1) NOT = ' ' AND LOW-VALUES 
             END-PERFORM                                                
             MOVE 6P-DEFAULT-COMMENTS-TEXT(1:SUB2) TO                   
                  4P-REQ-CHG-COMMENTS-TEXT(SUB1:SUB2)                   
             COMPUTE SUB1 = SUB1 + SUB2 - 1                             
           END-IF.                                                      
                                                                        
           IF LS-MCSCB728-REQ-CHG-COMMENTS > ' '                        
             ADD 1 TO SUB1                                              
             PERFORM VARYING SUB2 FROM 255 BY -1 UNTIL                  
               SUB2 < 1                          OR                     
               LS-MCSCB728-REQ-CHG-COMMENTS(SUB2:1) NOT =               
               ' ' AND LOW-VALUES                                       
             END-PERFORM                                                
             MOVE LS-MCSCB728-REQ-CHG-COMMENTS(1:SUB2) TO               
                 4P-REQ-CHG-COMMENTS-TEXT(SUB1:SUB2)                    
             COMPUTE SUB1 = SUB1 + SUB2 - 1                             
           END-IF.                                                      
           MOVE SUB1 TO 4P-REQ-CHG-COMMENTS-LEN.                        
                                                                        
      *    IF 1P-PROC-REQ-DUE-TS > SPACES                                       
      *       MOVE +0                   TO WS-TS-NULL-IND                       
      *    ELSE                                                                 
      *       MOVE -1                   TO WS-TS-NULL-IND                       
      *    END-IF.                                                              
                                                                        
           PERFORM 7275-UPDATE-BPR           THRU 7275-EXIT.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = 0                             
             MOVE 918 TO WS-APPL-RETURN-CODE                            
             PERFORM 2000-PROCESS-OUTPUT     THRU 2000-EXIT             
             GO TO 2100-EXIT                                            
           END-IF.                                                      
                                                                        
           PERFORM 7300-INSERT-BPR-CHG      THRU 7300-EXIT.             
                                                                        
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2150-PROCESS-PROMOTE-BPR-STAT                                  *        
      ******************************************************************        
       2150-PROCESS-PROMOTE-BPR-STAT.                                   
                                                                        
           MOVE '2150'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           IF LS-MCSCB728-APPL-PROG-ID = ' ' OR                         
              LS-MCSCB728-USER-ID = ' ' OR                              
              LS-MCSCB728-ACTION-FL = ' ' OR                            
              LS-MCSCB728-OVERRIDE-FL = 'Y' OR                          
              LN-PROC-REQ-ID    = ' ' OR                                
              LN-PROC-REQ-ID    NOT NUMERIC OR                          
              LN-PROC-REQ-ID = '0000000000' OR                          
              LR-MCSCB728-PROC-FLOW-IND = ' ' OR                        
              LR-MCSCB728-LAST-UPDATE-USERID = ' '                      
                 MOVE 707 TO WS-APPL-RETURN-CODE                        
                 PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT        
                 GO TO 2150-EXIT                                        
           END-IF.                                                      
                                                                        
           MOVE LN-PROC-REQ-ID         TO 1P-PROC-REQ-ID.               
                                                                        
           PERFORM 7200-GET-BPR             THRU 7200-EXIT.             
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
             MOVE 908 TO WS-APPL-RETURN-CODE                            
             PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT            
             GO TO 2150-EXIT                                            
           END-IF.                                                      
                                                                        
           MOVE 1P-COMPANY-NO          TO 6P-COMPANY-NO.                
           MOVE 1P-CODE-UTIL-TYPE      TO 6P-CODE-UTIL-TYPE.            
           MOVE 1P-PROC-TYPE-CD        TO 6P-PROC-TYPE-CD.              
           MOVE 1P-STATUS-SEQ-NO       TO 6P-STATUS-SEQ-NO              
                                          WS-CURNT-SEQ-NO.              
           MOVE 'P'                    TO 6P-PROC-FLOW-IND.             
                                                                        
           PERFORM 7325-GET-NEXT-BPR-STEP   THRU 7325-EXIT.             
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
             MOVE 909 TO WS-APPL-RETURN-CODE                            
             PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT            
             GO TO 2150-EXIT                                            
           END-IF.                                                      
                                                                        
           MOVE LN-PROC-REQ-ID          TO 1P-PROC-REQ-ID               
                                           4P-PROC-REQ-ID.              
           MOVE 6P-STATUS-SEQ-NO        TO 1P-STATUS-SEQ-NO.            
           MOVE 6P-PROC-FLOW-IND        TO 1P-PROC-FLOW-IND.            
           MOVE 'P'                     TO 4P-PROC-FLOW-IND.            
                                                                        
           MOVE 6P-PROC-STATUS-CD       TO 1P-PROC-STATUS-CD            
                                           4P-PROC-STATUS-CD.           
           MOVE LR-MCSCB728-LAST-UPDATE-USERID TO 1P-LAST-UPDATE-USERID 
                                           4P-REQ-CHG-USERID.           
           MOVE WS-CURRENT-TIMESTAMP    TO 1P-LAST-UPDATE-TS            
                                           4P-REQ-CHG-TS.               
           MOVE 6P-CATEGORY-ID          TO 4P-CATEGORY-ID.              
      * WHEN PASSED SHOULD BE VALID DB2 TIMESTAMP FORMAT                        
           IF LR-MCSCB728-EFFECTIVE-TS    > SPACES                      
              MOVE LR-MCSCB728-EFFECTIVE-TS    TO 1P-EFFECTIVE-TS       
              MOVE +0                   TO WS-TS-NULL-IND1              
           ELSE                                                         
             IF 1P-EFFECTIVE-TS NOT > SPACES                            
                MOVE LOW-VALUES         TO 1P-EFFECTIVE-TS              
                MOVE -1                 TO WS-TS-NULL-IND1              
              ELSE                                                      
                  MOVE +0               TO WS-TS-NULL-IND1              
             END-IF                                                     
           END-IF.                                                      
      * WHEN PASSED SHOULD BE VALID DB2 TIMESTAMP FORMAT                        
           IF LR-MCSCB728-PROC-REQ-DUE-TS > SPACES                      
              MOVE LR-MCSCB728-PROC-REQ-DUE-TS TO 1P-PROC-REQ-DUE-TS    
              MOVE +0                   TO WS-TS-NULL-IND               
           ELSE                                                         
             IF 1P-PROC-REQ-DUE-TS NOT > SPACES                         
                MOVE LOW-VALUES         TO 1P-PROC-REQ-DUE-TS           
                MOVE -1                 TO WS-TS-NULL-IND               
              ELSE                                                      
                  MOVE +0               TO WS-TS-NULL-IND               
             END-IF                                                     
           END-IF.                                                      
                                                                        
           MOVE SPACES TO 4P-REQ-CHG-COMMENTS-TEXT.                     
           MOVE 0      TO SUB1.                                         
                                                                        
           IF 6P-DEFAULT-COMMENTS-TEXT > ' '                            
             PERFORM VARYING SUB2 FROM 255 BY -1 UNTIL                  
               SUB2 < 1                          OR                     
              6P-DEFAULT-COMMENTS-TEXT(SUB2:1) NOT = ' ' AND LOW-VALUES 
             END-PERFORM                                                
             COMPUTE SUB1 = SUB2                                        
             MOVE 6P-DEFAULT-COMMENTS-TEXT(1:SUB1) TO                   
                  4P-REQ-CHG-COMMENTS-TEXT                              
             COMPUTE SUB1 = SUB1 + 1                                    
           END-IF.                                                      
                                                                        
           IF LS-MCSCB728-REQ-CHG-COMMENTS > ' '                        
             ADD 1 TO SUB1                                              
             PERFORM VARYING SUB2 FROM 255 BY -1 UNTIL                  
               SUB2 < 1                          OR                     
               LS-MCSCB728-REQ-CHG-COMMENTS(SUB2:1) NOT =               
               ' ' AND LOW-VALUES                                       
             END-PERFORM                                                
             MOVE LS-MCSCB728-REQ-CHG-COMMENTS(1:SUB2) TO               
                 4P-REQ-CHG-COMMENTS-TEXT(SUB1:SUB2)                    
             COMPUTE SUB1 = SUB1 + SUB2 - 1                             
           END-IF.                                                      
           MOVE SUB1 TO 4P-REQ-CHG-COMMENTS-LEN.                        
                                                                        
      *    IF 1P-PROC-REQ-DUE-TS > SPACES                                       
      *       MOVE +0                   TO WS-TS-NULL-IND                       
      *    ELSE                                                                 
      *       MOVE -1                   TO WS-TS-NULL-IND                       
      *    END-IF.                                                              
                                                                        
           PERFORM 7275-UPDATE-BPR           THRU 7275-EXIT.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
             MOVE 910 TO WS-APPL-RETURN-CODE                            
             PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT            
             GO TO 2150-EXIT                                            
           END-IF.                                                      
                                                                        
           PERFORM 7300-INSERT-BPR-CHG      THRU 7300-EXIT.             
                                                                        
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
                                                                        
       2150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-PROCESS-DEMOTE-BPR-STATUS                                 *        
      ******************************************************************        
       2200-PROCESS-DEMOTE-BPR-STATUS.                                  
                                                                        
           MOVE '2200'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           IF LS-MCSCB728-APPL-PROG-ID = ' ' OR                         
              LS-MCSCB728-USER-ID = ' ' OR                              
              LS-MCSCB728-ACTION-FL = ' ' OR                            
              LN-PROC-REQ-ID    = ' ' OR                                
              LN-PROC-REQ-ID    NOT NUMERIC OR                          
              LN-PROC-REQ-ID = '0000000000' OR                          
              LR-MCSCB728-PROC-FLOW-IND = ' ' OR                        
              LR-MCSCB728-LAST-UPDATE-USERID = ' '                      
                 MOVE 711 TO WS-APPL-RETURN-CODE                        
                 PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT        
                 GO TO 2200-EXIT                                        
           END-IF.                                                      
                                                                        
           MOVE LN-PROC-REQ-ID         TO 1P-PROC-REQ-ID.               
                                                                        
           PERFORM 7200-GET-BPR             THRU 7200-EXIT.             
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
             MOVE 912 TO WS-APPL-RETURN-CODE                            
             PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT            
             GO TO 2200-EXIT                                            
           END-IF.                                                      
                                                                        
           IF LR-MCSCB728-STATUS-SEQ-NO > 0                             
             MOVE 1P-COMPANY-NO          TO 6P-COMPANY-NO               
             MOVE 1P-CODE-UTIL-TYPE      TO 6P-CODE-UTIL-TYPE           
             MOVE 1P-PROC-TYPE-CD        TO 6P-PROC-TYPE-CD             
             MOVE LR-MCSCB728-STATUS-SEQ-NO TO 6P-STATUS-SEQ-NO         
                                            WS-NEW-SEQ-NO               
             MOVE 'D'                    TO 6P-PROC-FLOW-IND            
             PERFORM 7250-GET-BPR-CNTRL THRU 7250-EXIT                  
             IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
               MOVE 913 TO WS-APPL-RETURN-CODE                          
               PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT          
               GO TO 2200-EXIT                                          
             END-IF                                                     
           ELSE                                                         
             MOVE 1P-COMPANY-NO        TO 6P-COMPANY-NO                 
             MOVE 1P-CODE-UTIL-TYPE    TO 6P-CODE-UTIL-TYPE             
             MOVE 1P-PROC-TYPE-CD      TO 6P-PROC-TYPE-CD               
             MOVE 'D'                  TO 6P-PROC-FLOW-IND              
             MOVE 1P-STATUS-SEQ-NO     TO 6P-STATUS-SEQ-NO              
                                          WS-CURNT-SEQ-NO               
             PERFORM 7350-GET-PREV-BPR-STEP   THRU 7350-EXIT            
             IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
               MOVE 919 TO WS-APPL-RETURN-CODE                          
               PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT          
               GO TO 2200-EXIT                                          
             END-IF                                                     
           END-IF.                                                      
                                                                        
           MOVE LN-PROC-REQ-ID          TO 1P-PROC-REQ-ID               
                                           4P-PROC-REQ-ID.              
           MOVE 6P-STATUS-SEQ-NO        TO 1P-STATUS-SEQ-NO.            
           MOVE 'D'                     TO 1P-PROC-FLOW-IND             
                                           4P-PROC-FLOW-IND.            
           MOVE 6P-PROC-STATUS-CD       TO 1P-PROC-STATUS-CD            
                                           4P-PROC-STATUS-CD.           
           MOVE LR-MCSCB728-LAST-UPDATE-USERID TO 1P-LAST-UPDATE-USERID 
                                           4P-REQ-CHG-USERID.           
           MOVE WS-CURRENT-TIMESTAMP    TO 1P-LAST-UPDATE-TS            
                                           4P-REQ-CHG-TS.               
           MOVE 6P-CATEGORY-ID          TO 4P-CATEGORY-ID.              
      * WHEN PASSED SHOULD BE VALID DB2 TIMESTAMP FORMAT                        
           IF LR-MCSCB728-EFFECTIVE-TS    > SPACES                      
              MOVE LR-MCSCB728-EFFECTIVE-TS    TO 1P-EFFECTIVE-TS       
              MOVE +0                   TO WS-TS-NULL-IND1              
           ELSE                                                         
             IF 1P-EFFECTIVE-TS NOT > SPACES                            
                MOVE LOW-VALUES         TO 1P-EFFECTIVE-TS              
                MOVE -1                 TO WS-TS-NULL-IND1              
              ELSE                                                      
                  MOVE +0               TO WS-TS-NULL-IND1              
             END-IF                                                     
           END-IF.                                                      
      * WHEN PASSED SHOULD BE VALID DB2 TIMESTAMP FORMAT                        
           IF LR-MCSCB728-PROC-REQ-DUE-TS > SPACES                      
              MOVE LR-MCSCB728-PROC-REQ-DUE-TS TO 1P-PROC-REQ-DUE-TS    
              MOVE +0                   TO WS-TS-NULL-IND               
           ELSE                                                         
             IF 1P-PROC-REQ-DUE-TS NOT > SPACES                         
                MOVE LOW-VALUES         TO 1P-PROC-REQ-DUE-TS           
                MOVE -1                 TO WS-TS-NULL-IND               
              ELSE                                                      
                  MOVE +0               TO WS-TS-NULL-IND               
             END-IF                                                     
           END-IF.                                                      
                                                                        
           MOVE SPACES TO 4P-REQ-CHG-COMMENTS-TEXT.                     
           MOVE 0      TO SUB1.                                         
                                                                        
           IF 6P-DEFAULT-COMMENTS-TEXT > ' '                            
             PERFORM VARYING SUB2 FROM 255 BY -1 UNTIL                  
               SUB2 < 1                          OR                     
              6P-DEFAULT-COMMENTS-TEXT(SUB2:1) NOT = ' ' AND LOW-VALUES 
             END-PERFORM                                                
             COMPUTE SUB1 = SUB2                                        
             MOVE 6P-DEFAULT-COMMENTS-TEXT(1:SUB1) TO                   
                  4P-REQ-CHG-COMMENTS-TEXT                              
             COMPUTE SUB1 = SUB1 + 1                                    
           END-IF.                                                      
                                                                        
           IF LS-MCSCB728-REQ-CHG-COMMENTS > ' '                        
             ADD 1 TO SUB1                                              
             PERFORM VARYING SUB2 FROM 255 BY -1 UNTIL                  
               SUB2 < 1                          OR                     
               LS-MCSCB728-REQ-CHG-COMMENTS(SUB2:1) NOT =               
               ' ' AND LOW-VALUES                                       
             END-PERFORM                                                
             MOVE LS-MCSCB728-REQ-CHG-COMMENTS(1:SUB2) TO               
                 4P-REQ-CHG-COMMENTS-TEXT(SUB1:SUB2)                    
             COMPUTE SUB1 = SUB1 + SUB2 - 1                             
           END-IF.                                                      
           MOVE SUB1 TO 4P-REQ-CHG-COMMENTS-LEN.                        
                                                                        
      *    IF 1P-PROC-REQ-DUE-TS > SPACES                                       
      *       MOVE +0                   TO WS-TS-NULL-IND                       
      *    ELSE                                                                 
      *       MOVE -1                   TO WS-TS-NULL-IND                       
      *    END-IF.                                                              
                                                                        
           PERFORM 7275-UPDATE-BPR           THRU 7275-EXIT.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
             MOVE 915 TO WS-APPL-RETURN-CODE                            
             PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT            
             GO TO 2200-EXIT                                            
           END-IF.                                                      
                                                                        
           PERFORM 7300-INSERT-BPR-CHG      THRU 7300-EXIT.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = 0                             
             MOVE 916 TO WS-APPL-RETURN-CODE                            
             PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT            
             GO TO 2200-EXIT                                            
           END-IF.                                                      
                                                                        
           MOVE 'P'                  TO 6P-PROC-FLOW-IND.               
                                                                        
           PERFORM 7250-GET-BPR-CNTRL THRU 7250-EXIT.                   
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = 0                             
             MOVE 917 TO WS-APPL-RETURN-CODE                            
             PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT            
             GO TO 2200-EXIT                                            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE LN-PROC-REQ-ID          TO 4P-PROC-REQ-ID.              
           MOVE 'P'                     TO 4P-PROC-FLOW-IND.            
           MOVE 6P-PROC-STATUS-CD       TO 4P-PROC-STATUS-CD.           
           MOVE 'SYSTEM'                TO 4P-REQ-CHG-USERID.           
           MOVE WS-CURRENT-TIMESTAMP    TO 4P-REQ-CHG-TS.               
           MOVE 6P-CATEGORY-ID          TO 4P-CATEGORY-ID.              
                                                                        
           MOVE SPACES TO 4P-REQ-CHG-COMMENTS-TEXT.                     
           MOVE 0      TO SUB1.                                         
                                                                        
           MOVE SUB1 TO 4P-REQ-CHG-COMMENTS-LEN.                        
                                                                        
           PERFORM 7125-INSERT-BPR-CHG THRU 7125-EXIT.                  
                                                                        
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7000-GET-FIRST-BPR-STEP                                   *             
      ****************************************************************          
                                                                        
       7000-GET-FIRST-BPR-STEP.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) [6P].STATUS_SEQ_NO,
              [6P].PROC_FLOW_IND,
              [6P].PROC_STATUS_CD,
              [6P].DEFAULT_COMMENTS,
              [6P].CATEGORY_ID                                   
              INTO     :6P-STATUS-SEQ-NO                                
                      ,:6P-PROC-FLOW-IND                                
                      ,:6P-PROC-STATUS-CD                               
                      ,:6P-DEFAULT-COMMENTS                             
                      ,:6P-CATEGORY-ID                                  
              FROM CSS_PROCESS_CNTRL [6P]                                 
              WHERE [6P].PROC_TYPE_CD    = :6P-PROC-TYPE-CD               
               AND [6P].COMPANY_NO       = :6P-COMPANY-NO                 
               AND [6P].CODE_UTIL_TYPE   = :6P-CODE-UTIL-TYPE             
               AND [6P].PROC_FLOW_IND    = :6P-PROC-FLOW-IND              
               ORDER BY [6P].STATUS_SEQ_NO                                
                                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT   6P.STATUS_SEQ_NO                                         
MFA-TR*               ,6P.PROC_FLOW_IND                                         
MFA-TR*               ,6P.PROC_STATUS_CD                                        
MFA-TR*               ,6P.DEFAULT_COMMENTS                                      
MFA-TR*               ,6P.CATEGORY_ID                                           
MFA-TR*       INTO     :6P-STATUS-SEQ-NO                                        
MFA-TR*               ,:6P-PROC-FLOW-IND                                        
MFA-TR*               ,:6P-PROC-STATUS-CD                                       
MFA-TR*               ,:6P-DEFAULT-COMMENTS                                     
MFA-TR*               ,:6P-CATEGORY-ID                                          
MFA-TR*       FROM CSS_PROCESS_CNTRL 6P                                         
MFA-TR*       WHERE 6P.PROC_TYPE_CD    = :6P-PROC-TYPE-CD                       
MFA-TR*        AND 6P.COMPANY_NO       = :6P-COMPANY-NO                         
MFA-TR*        AND 6P.CODE_UTIL_TYPE   = :6P-CODE-UTIL-TYPE                     
MFA-TR*        AND 6P.PROC_FLOW_IND    = :6P-PROC-FLOW-IND                      
MFA-TR*        ORDER BY 6P.STATUS_SEQ_NO                                        
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7000'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_PROCESS_CNTRL' TO TABLE-1                       
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
              MOVE 6P-COMPANY-NO       TO HOSTVAR-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 6P-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-2               
              PERFORM 9001-TERMINATE-PROGRAM  THRU 9001-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7025-CHECK-BPR-GROUP-EXISTS                                    *        
      *     GET THE DATA FROM CSS_PROCESS_GROUP                        *        
      ******************************************************************        
       7025-CHECK-BPR-GROUP-EXISTS.                                     
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
              INTO :WS-PROC-GROUP-EXISTS-FL                             
              FROM CSS_PROCESS_GROUP [5P] WITH(READUNCOMMITTED)                 
              WHERE [5P].COMPANY_NO  = :5P-COMPANY-NO                     
              AND [5P].PROC_GROUP_CD = :5P-PROC-GROUP-CD                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*       INTO :WS-PROC-GROUP-EXISTS-FL                                     
MFA-TR*       FROM CSS_PROCESS_GROUP 5P                                         
MFA-TR*       WHERE 5P.COMPANY_NO  = :5P-COMPANY-NO                             
MFA-TR*       AND 5P.PROC_GROUP_CD = :5P-PROC-GROUP-CD                          
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7025                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7025'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_PROCESS_GROUP'     TO TABLE-1                   
              MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2           
              MOVE 6P-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-1         
              MOVE 6P-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2         
              PERFORM 9001-TERMINATE-PROGRAM  THRU 9001-EXIT            
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7050-INSERT-BPR-GROUP                                        *          
      ****************************************************************          
                                                                        
       7050-INSERT-BPR-GROUP.                                           
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_PROCESS_GROUP                              
                  (PROC_GROUP_CD                                        
                  ,COMPANY_NO                                           
                  ,PROC_GROUP_DESC                                      
                  ,LAST_UPDATE_USERID                                   
                  ,LAST_UPDATE_TS)                                      
             VALUES                                                     
                 (:5P-PROC-GROUP-CD                                     
                 ,:5P-COMPANY-NO                                        
                 ,:5P-PROC-GROUP-DESC                                   
                 ,:5P-LAST-UPDATE-USERID                                
                 ,CIS.CHAR2TIMESTAMP(:5P-LAST-UPDATE-TS))                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_PROCESS_GROUP                                      
MFA-TR*           (PROC_GROUP_CD                                                
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,PROC_GROUP_DESC                                              
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,LAST_UPDATE_TS)                                              
MFA-TR*      VALUES                                                             
MFA-TR*          (:5P-PROC-GROUP-CD                                             
MFA-TR*          ,:5P-COMPANY-NO                                                
MFA-TR*          ,:5P-PROC-GROUP-DESC                                           
MFA-TR*          ,:5P-LAST-UPDATE-USERID                                        
MFA-TR*          ,:5P-LAST-UPDATE-TS)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7050'              TO ACTIVE-PARAGRAPH              
              MOVE 'INSERT'            TO ABEND-FUNCTION                
              MOVE 'CSS_PROCESS_GROUP' TO TABLE-1                       
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
              MOVE 6P-COMPANY-NO       TO HOSTVAR-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 6P-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
              PERFORM 9001-TERMINATE-PROGRAM  THRU 9001-EXIT            
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7075-GET-NEXT-BPR-ID                                           *        
      *     GET THE NEXT SEQ NO FROM CSS_PROCESS_SEQ                   *        
      *  CITY                                                          *        
      ******************************************************************        
       7075-GET-NEXT-BPR-ID.                                            
                                                                        
           EXEC SQL                                                     
               SELECT
              NEXT VALUE FOR SEQ_1P_PROC_REQ_ID
            INTO
              :WS-NEXT-PROC-REQ-ID                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ048
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-NEXT-PROC-REQ-ID =                                       
MFA-TR*            NEXTVAL FOR SEQ_1P_PROC_REQ_ID                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              OR -305                                                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7075'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SET   '                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_PROCESS_SEQ'       TO TABLE-1                   
              MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2           
              MOVE 6P-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-1         
              MOVE 6P-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2         
              PERFORM 9001-TERMINATE-PROGRAM  THRU 9001-EXIT            
           END-IF.                                                      
                                                                        
       7075-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7100-INSERT-BPR                                           *             
      ****************************************************************          
       7100-INSERT-BPR.                                                 
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_PROCESS_REQ                               
                  (PROC_REQ_ID                                          
                  ,COMPANY_NO                                           
                  ,CODE_UTIL_TYPE                                       
                  ,PROC_REQ_DESC                                        
                  ,PROC_TYPE_CD                                         
                  ,STATUS_SEQ_NO                                        
                  ,PROC_FLOW_IND                                        
                  ,PROC_STATUS_CD                                       
                  ,PROC_GROUP_CD                                        
                  ,CREATED_BY_USERID                                    
                  ,CREATED_TS                                           
                  ,EFFECTIVE_TS                                         
                  ,PROC_REQ_DUE_TS                                      
                  ,LAST_UPDATE_USERID                                   
                  ,LAST_UPDATE_TS)                                      
              VALUES (:1P-PROC-REQ-ID                                   
                  ,:1P-COMPANY-NO                                       
                  ,:1P-CODE-UTIL-TYPE                                   
                  ,:1P-PROC-REQ-DESC                                    
                  ,:1P-PROC-TYPE-CD                                     
                  ,:1P-STATUS-SEQ-NO                                    
                  ,:1P-PROC-FLOW-IND                                    
                  ,:1P-PROC-STATUS-CD                                   
                  ,:1P-PROC-GROUP-CD                                    
                  ,:1P-CREATED-BY-USERID                                
                  ,CIS.CHAR2TIMESTAMP(:1P-CREATED-TS)                           
                  ,CIS.CHAR2TIMESTAMP(:1P-EFFECTIVE-TS :WS-TS-NULL-IND1)        
                  ,CIS.CHAR2TIMESTAMP(:1P-PROC-REQ-DUE-TS 
                                      :WS-TS-NULL-IND)                   
                  ,:1P-LAST-UPDATE-USERID                               
                  ,CIS.CHAR2TIMESTAMP(:1P-LAST-UPDATE-TS))                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_PROCESS_REQ                                       
MFA-TR*           (PROC_REQ_ID                                                  
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,PROC_REQ_DESC                                                
MFA-TR*           ,PROC_TYPE_CD                                                 
MFA-TR*           ,STATUS_SEQ_NO                                                
MFA-TR*           ,PROC_FLOW_IND                                                
MFA-TR*           ,PROC_STATUS_CD                                               
MFA-TR*           ,PROC_GROUP_CD                                                
MFA-TR*           ,CREATED_BY_USERID                                            
MFA-TR*           ,CREATED_TS                                                   
MFA-TR*           ,EFFECTIVE_TS                                                 
MFA-TR*           ,PROC_REQ_DUE_TS                                              
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,LAST_UPDATE_TS)                                              
MFA-TR*       VALUES (:1P-PROC-REQ-ID                                           
MFA-TR*           ,:1P-COMPANY-NO                                               
MFA-TR*           ,:1P-CODE-UTIL-TYPE                                           
MFA-TR*           ,:1P-PROC-REQ-DESC                                            
MFA-TR*           ,:1P-PROC-TYPE-CD                                             
MFA-TR*           ,:1P-STATUS-SEQ-NO                                            
MFA-TR*           ,:1P-PROC-FLOW-IND                                            
MFA-TR*           ,:1P-PROC-STATUS-CD                                           
MFA-TR*           ,:1P-PROC-GROUP-CD                                            
MFA-TR*           ,:1P-CREATED-BY-USERID                                        
MFA-TR*           ,:1P-CREATED-TS                                               
MFA-TR*           ,:1P-EFFECTIVE-TS:WS-TS-NULL-IND1                             
MFA-TR*           ,:1P-PROC-REQ-DUE-TS:WS-TS-NULL-IND                           
MFA-TR*           ,:1P-LAST-UPDATE-USERID                                       
MFA-TR*           ,:1P-LAST-UPDATE-TS)                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR ALREADY-EXISTS 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7100'              TO ACTIVE-PARAGRAPH              
              MOVE 'INSERT'            TO ABEND-FUNCTION                
              MOVE 'CSS_PROCESS_REQ  ' TO TABLE-1                       
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
              MOVE 6P-COMPANY-NO       TO HOSTVAR-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 6P-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-2               
              PERFORM 9001-TERMINATE-PROGRAM  THRU 9001-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7125-INSERT-BPR-CHG                                          *          
      ****************************************************************          
       7125-INSERT-BPR-CHG.                                             
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_PROCESS_REQ_CH                             
                 (PROC_REQ_ID                                           
                 ,REQ_CHG_TS                                            
                 ,PROC_STATUS_CD                                        
                 ,PROC_FLOW_IND                                         
                 ,REQ_CHG_USERID                                        
                 ,REQ_CHG_COMMENTS                                      
                 ,CATEGORY_ID)                                          
             VALUES (:4P-PROC-REQ-ID                                    
                 ,CIS.CHAR2TIMESTAMP(:4P-REQ-CHG-TS)                            
                 ,:4P-PROC-STATUS-CD                                    
                 ,:4P-PROC-FLOW-IND                                     
                 ,:4P-REQ-CHG-USERID                                    
                 ,:4P-REQ-CHG-COMMENTS                                  
                 ,:4P-CATEGORY-ID)                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_PROCESS_REQ_CH                                     
MFA-TR*          (PROC_REQ_ID                                                   
MFA-TR*          ,REQ_CHG_TS                                                    
MFA-TR*          ,PROC_STATUS_CD                                                
MFA-TR*          ,PROC_FLOW_IND                                                 
MFA-TR*          ,REQ_CHG_USERID                                                
MFA-TR*          ,REQ_CHG_COMMENTS                                              
MFA-TR*          ,CATEGORY_ID)                                                  
MFA-TR*      VALUES (:4P-PROC-REQ-ID                                            
MFA-TR*          ,:4P-REQ-CHG-TS                                                
MFA-TR*          ,:4P-PROC-STATUS-CD                                            
MFA-TR*          ,:4P-PROC-FLOW-IND                                             
MFA-TR*          ,:4P-REQ-CHG-USERID                                            
MFA-TR*          ,:4P-REQ-CHG-COMMENTS                                          
MFA-TR*          ,:4P-CATEGORY-ID)                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR ALREADY-EXISTS 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7125'              TO ACTIVE-PARAGRAPH              
              MOVE 'INSERT'            TO ABEND-FUNCTION                
              MOVE 'CSS_PROCESS_REQ_CH' TO TABLE-1                      
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
              MOVE 6P-COMPANY-NO       TO HOSTVAR-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 6P-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-2               
              PERFORM 9001-TERMINATE-PROGRAM  THRU 9001-EXIT            
           END-IF.                                                      
                                                                        
       7125-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7200-GET-BPR                                                 *          
      ****************************************************************          
                                                                        
       7200-GET-BPR.                                                    
                                                                        
           EXEC SQL                                                     
             SELECT [1P].PROC_REQ_ID                                      
                  ,[1P].COMPANY_NO                                        
                  ,[1P].CODE_UTIL_TYPE                                    
                  ,[1P].PROC_REQ_DESC                                     
                  ,[1P].PROC_TYPE_CD                                      
                  ,[1P].STATUS_SEQ_NO                                     
                  ,[1P].PROC_FLOW_IND                                     
                  ,[1P].PROC_STATUS_CD                                    
                  ,[1P].PROC_GROUP_CD                                     
                  ,[1P].CREATED_BY_USERID                                 
                  ,REPLACE(REPLACE(CONVERT(CHAR(26), [1P].CREATED_TS
           , 121), ' ', '-'), ':', '.') CREATED_TS                             
           ,REPLACE(REPLACE(CONVERT(CHAR(26), COALESCE(
           [1P].EFFECTIVE_TS,CIS.CHAR2TIMESTAMP(
              '1999-01-01-00.00.00.000000')), 121), ' ', '-'), ':', 
           '.')        
           ,REPLACE(REPLACE(CONVERT(CHAR(26), COALESCE(
           [1P].PROC_REQ_DUE_TS,CIS.CHAR2TIMESTAMP(
              '1999-01-01-00.00.00.000000')), 121), ' ', '-'), ':', 
           '.')     
                  ,[1P].LAST_UPDATE_USERID                                
                  ,REPLACE(REPLACE(CONVERT(CHAR(26), [1P].LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
            INTO :1P-PROC-REQ-ID                                        
                ,:1P-COMPANY-NO                                         
                ,:1P-CODE-UTIL-TYPE                                     
                ,:1P-PROC-REQ-DESC                                      
                ,:1P-PROC-TYPE-CD                                       
                ,:1P-STATUS-SEQ-NO                                      
                ,:1P-PROC-FLOW-IND                                      
                ,:1P-PROC-STATUS-CD                                     
                ,:1P-PROC-GROUP-CD                                      
                ,:1P-CREATED-BY-USERID                                  
                ,:1P-CREATED-TS                                         
                ,:1P-EFFECTIVE-TS :WS-TS-NULL-IND1                       
                ,:1P-PROC-REQ-DUE-TS :WS-TS-NULL-IND                     
                ,:1P-LAST-UPDATE-USERID                                 
                ,:1P-LAST-UPDATE-TS                                     
              FROM CSS_PROCESS_REQ   [1P] WITH(READUNCOMMITTED)                 
              WHERE [1P].PROC_REQ_ID = :1P-PROC-REQ-ID                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 1P.PROC_REQ_ID                                              
MFA-TR*           ,1P.COMPANY_NO                                                
MFA-TR*           ,1P.CODE_UTIL_TYPE                                            
MFA-TR*           ,1P.PROC_REQ_DESC                                             
MFA-TR*           ,1P.PROC_TYPE_CD                                              
MFA-TR*           ,1P.STATUS_SEQ_NO                                             
MFA-TR*           ,1P.PROC_FLOW_IND                                             
MFA-TR*           ,1P.PROC_STATUS_CD                                            
MFA-TR*           ,1P.PROC_GROUP_CD                                             
MFA-TR*           ,1P.CREATED_BY_USERID                                         
MFA-TR*           ,1P.CREATED_TS                                                
MFA-TR*    ,IFNULL(1P.EFFECTIVE_TS,'1999-01-01-00.00.00.000000')                
MFA-TR*    ,IFNULL(1P.PROC_REQ_DUE_TS,'1999-01-01-00.00.00.000000')             
MFA-TR*           ,1P.LAST_UPDATE_USERID                                        
MFA-TR*           ,1P.LAST_UPDATE_TS                                            
MFA-TR*     INTO :1P-PROC-REQ-ID                                                
MFA-TR*         ,:1P-COMPANY-NO                                                 
MFA-TR*         ,:1P-CODE-UTIL-TYPE                                             
MFA-TR*         ,:1P-PROC-REQ-DESC                                              
MFA-TR*         ,:1P-PROC-TYPE-CD                                               
MFA-TR*         ,:1P-STATUS-SEQ-NO                                              
MFA-TR*         ,:1P-PROC-FLOW-IND                                              
MFA-TR*         ,:1P-PROC-STATUS-CD                                             
MFA-TR*         ,:1P-PROC-GROUP-CD                                              
MFA-TR*         ,:1P-CREATED-BY-USERID                                          
MFA-TR*         ,:1P-CREATED-TS                                                 
MFA-TR*         ,:1P-EFFECTIVE-TS:WS-TS-NULL-IND1                               
MFA-TR*         ,:1P-PROC-REQ-DUE-TS:WS-TS-NULL-IND                             
MFA-TR*         ,:1P-LAST-UPDATE-USERID                                         
MFA-TR*         ,:1P-LAST-UPDATE-TS                                             
MFA-TR*       FROM CSS_PROCESS_REQ   1P                                         
MFA-TR*       WHERE 1P.PROC_REQ_ID = :1P-PROC-REQ-ID                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF 1P-PROC-REQ-DUE-TS = '1999-01-01-00.00.00.000000'      
                 MOVE SPACES TO 1P-PROC-REQ-DUE-TS                      
              END-IF                                                    
              IF 1P-EFFECTIVE-TS    = '1999-01-01-00.00.00.000000'      
                 MOVE SPACES TO 1P-EFFECTIVE-TS                         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7200'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_PROCESS_REQ  ' TO TABLE-1                       
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
              MOVE 6P-COMPANY-NO       TO HOSTVAR-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 6P-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-2               
              PERFORM 9001-TERMINATE-PROGRAM  THRU 9001-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7225-CHECK-BPR-REQUIRED-STEP                                  *         
      *     GET THE DATA FROM CSS_PROCESS_CNTRL                        *        
      ******************************************************************        
       7225-CHECK-BPR-REQUIRED-STEP.                                    
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
              INTO :WS-REQUIRED-STEP-EXISTS-FL                          
              FROM CSS_PROCESS_CNTRL [6P] WITH(READUNCOMMITTED)                 
              WHERE [6P].COMPANY_NO      = :6P-COMPANY-NO                 
               AND [6P].CODE_UTIL_TYPE   = :6P-CODE-UTIL-TYPE             
               AND [6P].PROC_TYPE_CD     = :6P-PROC-TYPE-CD               
               AND [6P].STATUS_SEQ_NO    < :WS-NEW-SEQ-NO                 
               AND [6P].STATUS_SEQ_NO    > :WS-CURNT-SEQ-NO               
               AND [6P].REQUIRED_STATUS_FL = 'Y'                          
               AND [6P].PROC_FLOW_IND    = :6P-PROC-FLOW-IND              
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*       INTO :WS-REQUIRED-STEP-EXISTS-FL                                  
MFA-TR*       FROM CSS_PROCESS_CNTRL 6P                                         
MFA-TR*       WHERE 6P.COMPANY_NO      = :6P-COMPANY-NO                         
MFA-TR*        AND 6P.CODE_UTIL_TYPE   = :6P-CODE-UTIL-TYPE                     
MFA-TR*        AND 6P.PROC_TYPE_CD     = :6P-PROC-TYPE-CD                       
MFA-TR*        AND 6P.STATUS_SEQ_NO    < :WS-NEW-SEQ-NO                         
MFA-TR*        AND 6P.STATUS_SEQ_NO    > :WS-CURNT-SEQ-NO                       
MFA-TR*        AND 6P.REQUIRED_STATUS_FL = 'Y'                                  
MFA-TR*        AND 6P.PROC_FLOW_IND    = :6P-PROC-FLOW-IND                      
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7225                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7225'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_PROCESS_GROUP'     TO TABLE-1                   
              MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2           
              MOVE 6P-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-1         
              MOVE 6P-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2         
              PERFORM 9001-TERMINATE-PROGRAM  THRU 9001-EXIT            
           END-IF.                                                      
                                                                        
       7225-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7250-GET-BPR-CNTRL                                           *          
      ****************************************************************          
                                                                        
       7250-GET-BPR-CNTRL.                                              
                                                                        
           EXEC SQL                                                     
              SELECT [6P].STATUS_SEQ_NO                                   
                    ,[6P].PROC_FLOW_IND                                   
                    ,[6P].PROC_STATUS_CD                                  
                    ,[6P].DEFAULT_COMMENTS                                
                    ,[6P].CATEGORY_ID                                     
              INTO  :6P-STATUS-SEQ-NO                                   
                   ,:6P-PROC-FLOW-IND                                   
                   ,:6P-PROC-STATUS-CD                                  
                   ,:6P-DEFAULT-COMMENTS                                
                   ,:6P-CATEGORY-ID                                     
              FROM CSS_PROCESS_CNTRL [6P] WITH(READUNCOMMITTED)                 
                WHERE [6P].COMPANY_NO     = :6P-COMPANY-NO                
                AND [6P].CODE_UTIL_TYPE   = :6P-CODE-UTIL-TYPE            
                AND [6P].PROC_TYPE_CD     = :6P-PROC-TYPE-CD              
                AND [6P].STATUS_SEQ_NO    = :6P-STATUS-SEQ-NO             
                AND [6P].PROC_FLOW_IND    = :6P-PROC-FLOW-IND             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 6P.STATUS_SEQ_NO                                           
MFA-TR*             ,6P.PROC_FLOW_IND                                           
MFA-TR*             ,6P.PROC_STATUS_CD                                          
MFA-TR*             ,6P.DEFAULT_COMMENTS                                        
MFA-TR*             ,6P.CATEGORY_ID                                             
MFA-TR*       INTO  :6P-STATUS-SEQ-NO                                           
MFA-TR*            ,:6P-PROC-FLOW-IND                                           
MFA-TR*            ,:6P-PROC-STATUS-CD                                          
MFA-TR*            ,:6P-DEFAULT-COMMENTS                                        
MFA-TR*            ,:6P-CATEGORY-ID                                             
MFA-TR*       FROM CSS_PROCESS_CNTRL 6P                                         
MFA-TR*         WHERE 6P.COMPANY_NO     = :6P-COMPANY-NO                        
MFA-TR*         AND 6P.CODE_UTIL_TYPE   = :6P-CODE-UTIL-TYPE                    
MFA-TR*         AND 6P.PROC_TYPE_CD     = :6P-PROC-TYPE-CD                      
MFA-TR*         AND 6P.STATUS_SEQ_NO    = :6P-STATUS-SEQ-NO                     
MFA-TR*         AND 6P.PROC_FLOW_IND    = :6P-PROC-FLOW-IND                     
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7250                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7250'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_PROCESS_CNTRL' TO TABLE-1                       
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
              MOVE 6P-COMPANY-NO       TO HOSTVAR-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 6P-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-2               
              PERFORM 9001-TERMINATE-PROGRAM  THRU 9001-EXIT            
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7275-UPDATE-BPR                                              *          
      ****************************************************************          
                                                                        
       7275-UPDATE-BPR.                                                 
                                                                        
           EXEC SQL                                                     
            UPDATE CSS_PROCESS_REQ                                      
            SET STATUS_SEQ_NO      = :1P-STATUS-SEQ-NO                  
               ,PROC_FLOW_IND      = :1P-PROC-FLOW-IND                  
               ,PROC_STATUS_CD     = :1P-PROC-STATUS-CD                 
               ,EFFECTIVE_TS       = CIS.CHAR2TIMESTAMP(
                                                      :1P-EFFECTIVE-TS 
                                                        :WS-TS-NULL-IND1
              )   
               ,PROC_REQ_DUE_TS    = CIS.CHAR2TIMESTAMP(
                                                   :1P-PROC-REQ-DUE-TS 
                                                        :WS-TS-NULL-IND
              ) 
               ,LAST_UPDATE_USERID = :1P-LAST-UPDATE-USERID             
               ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                     :1P-LAST-UPDATE-TS
              )                 
            WHERE PROC_REQ_ID      = :1P-PROC-REQ-ID                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     UPDATE CSS_PROCESS_REQ                                              
MFA-TR*     SET STATUS_SEQ_NO      = :1P-STATUS-SEQ-NO                          
MFA-TR*        ,PROC_FLOW_IND      = :1P-PROC-FLOW-IND                          
MFA-TR*        ,PROC_STATUS_CD     = :1P-PROC-STATUS-CD                         
MFA-TR*        ,EFFECTIVE_TS       = :1P-EFFECTIVE-TS:WS-TS-NULL-IND1           
MFA-TR*        ,PROC_REQ_DUE_TS    = :1P-PROC-REQ-DUE-TS:WS-TS-NULL-IND         
MFA-TR*        ,LAST_UPDATE_USERID = :1P-LAST-UPDATE-USERID                     
MFA-TR*        ,LAST_UPDATE_TS     = :1P-LAST-UPDATE-TS                         
MFA-TR*     WHERE PROC_REQ_ID      = :1P-PROC-REQ-ID                            
MFA-TR*     QUERYNO 7275                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7275'              TO ACTIVE-PARAGRAPH              
              MOVE 'UPDATE'            TO ABEND-FUNCTION                
              MOVE 'CSS_PROCESS_REQ  ' TO TABLE-1                       
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
              MOVE 6P-COMPANY-NO       TO HOSTVAR-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 6P-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-2               
              PERFORM 9001-TERMINATE-PROGRAM  THRU 9001-EXIT            
           END-IF.                                                      
                                                                        
       7275-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7300-INSERT-BPR-CHG.                                         *          
      ****************************************************************          
       7300-INSERT-BPR-CHG.                                             
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_PROCESS_REQ_CH                             
                  (PROC_REQ_ID                                          
                  ,REQ_CHG_TS                                           
                  ,PROC_STATUS_CD                                       
                  ,PROC_FLOW_IND                                        
                  ,REQ_CHG_USERID                                       
                  ,REQ_CHG_COMMENTS                                     
                  ,CATEGORY_ID)                                         
             VALUES (:4P-PROC-REQ-ID                                    
                  ,CIS.CHAR2TIMESTAMP(:4P-REQ-CHG-TS)                           
                  ,:4P-PROC-STATUS-CD                                   
                  ,:4P-PROC-FLOW-IND                                    
                  ,:4P-REQ-CHG-USERID                                   
                  ,:4P-REQ-CHG-COMMENTS                                 
                  ,:4P-CATEGORY-ID)                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_PROCESS_REQ_CH                                     
MFA-TR*           (PROC_REQ_ID                                                  
MFA-TR*           ,REQ_CHG_TS                                                   
MFA-TR*           ,PROC_STATUS_CD                                               
MFA-TR*           ,PROC_FLOW_IND                                                
MFA-TR*           ,REQ_CHG_USERID                                               
MFA-TR*           ,REQ_CHG_COMMENTS                                             
MFA-TR*           ,CATEGORY_ID)                                                 
MFA-TR*      VALUES (:4P-PROC-REQ-ID                                            
MFA-TR*           ,:4P-REQ-CHG-TS                                               
MFA-TR*           ,:4P-PROC-STATUS-CD                                           
MFA-TR*           ,:4P-PROC-FLOW-IND                                            
MFA-TR*           ,:4P-REQ-CHG-USERID                                           
MFA-TR*           ,:4P-REQ-CHG-COMMENTS                                         
MFA-TR*           ,:4P-CATEGORY-ID)                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7300'              TO ACTIVE-PARAGRAPH              
              MOVE 'INSERT'            TO ABEND-FUNCTION                
              MOVE 'CSS_PROCESS_REQ  ' TO TABLE-1                       
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
              MOVE 6P-COMPANY-NO       TO HOSTVAR-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 6P-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-2               
              PERFORM 9001-TERMINATE-PROGRAM  THRU 9001-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7325-GET-NEXT-BPR-STEP                                       *          
      ****************************************************************          
       7325-GET-NEXT-BPR-STEP.                                          
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) [6P].STATUS_SEQ_NO,
              [6P].PROC_FLOW_IND,
              [6P].PROC_STATUS_CD,
              [6P].DEFAULT_COMMENTS,
              [6P].CATEGORY_ID                                      
             INTO  :6P-STATUS-SEQ-NO                                    
                 , :6P-PROC-FLOW-IND                                    
                 , :6P-PROC-STATUS-CD                                   
                 ,:6P-DEFAULT-COMMENTS                                  
                 ,:6P-CATEGORY-ID                                       
             FROM CSS_PROCESS_CNTRL [6P] WITH(READUNCOMMITTED)                  
               WHERE [6P].COMPANY_NO     = :6P-COMPANY-NO                 
               AND [6P].CODE_UTIL_TYPE   = :6P-CODE-UTIL-TYPE             
               AND [6P].PROC_TYPE_CD     = :6P-PROC-TYPE-CD               
               AND [6P].STATUS_SEQ_NO   >  :6P-STATUS-SEQ-NO              
               AND [6P].PROC_FLOW_IND    = :6P-PROC-FLOW-IND              
               ORDER BY [6P].STATUS_SEQ_NO                                
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 6P.STATUS_SEQ_NO                                            
MFA-TR*           , 6P.PROC_FLOW_IND                                            
MFA-TR*           , 6P.PROC_STATUS_CD                                           
MFA-TR*           , 6P.DEFAULT_COMMENTS                                         
MFA-TR*           , 6P.CATEGORY_ID                                              
MFA-TR*      INTO  :6P-STATUS-SEQ-NO                                            
MFA-TR*          , :6P-PROC-FLOW-IND                                            
MFA-TR*          , :6P-PROC-STATUS-CD                                           
MFA-TR*          ,:6P-DEFAULT-COMMENTS                                          
MFA-TR*          ,:6P-CATEGORY-ID                                               
MFA-TR*      FROM CSS_PROCESS_CNTRL 6P                                          
MFA-TR*        WHERE 6P.COMPANY_NO     = :6P-COMPANY-NO                         
MFA-TR*        AND 6P.CODE_UTIL_TYPE   = :6P-CODE-UTIL-TYPE                     
MFA-TR*        AND 6P.PROC_TYPE_CD     = :6P-PROC-TYPE-CD                       
MFA-TR*        AND 6P.STATUS_SEQ_NO   >  :6P-STATUS-SEQ-NO                      
MFA-TR*        AND 6P.PROC_FLOW_IND    = :6P-PROC-FLOW-IND                      
MFA-TR*        ORDER BY 6P.STATUS_SEQ_NO                                        
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7325                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7325'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_PROCESS_CNTRL' TO TABLE-1                       
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
              MOVE 6P-COMPANY-NO       TO HOSTVAR-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 6P-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-2               
              PERFORM 9001-TERMINATE-PROGRAM  THRU 9001-EXIT            
           END-IF.                                                      
                                                                        
       7325-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7350-GET-PREV-BPR-STEP                                       *          
      ****************************************************************          
       7350-GET-PREV-BPR-STEP.                                          
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) [6P].STATUS_SEQ_NO,
              [6P].PROC_FLOW_IND,
              [6P].PROC_STATUS_CD,
              [6P].DEFAULT_COMMENTS,
              [6P].CATEGORY_ID                                       
             INTO :6P-STATUS-SEQ-NO                                     
                 ,:6P-PROC-FLOW-IND                                     
                 ,:6P-PROC-STATUS-CD                                    
                 ,:6P-DEFAULT-COMMENTS                                  
                 ,:6P-CATEGORY-ID                                       
             FROM CSS_PROCESS_CNTRL [6P] WITH(READUNCOMMITTED)                  
               WHERE [6P].COMPANY_NO     = :6P-COMPANY-NO                 
               AND [6P].CODE_UTIL_TYPE   = :6P-CODE-UTIL-TYPE             
               AND [6P].PROC_TYPE_CD     = :6P-PROC-TYPE-CD               
               AND [6P].STATUS_SEQ_NO    < :6P-STATUS-SEQ-NO              
               AND [6P].PROC_FLOW_IND    = :6P-PROC-FLOW-IND              
               ORDER BY [6P].STATUS_SEQ_NO DESC                           
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 6P.STATUS_SEQ_NO                                            
MFA-TR*           ,6P.PROC_FLOW_IND                                             
MFA-TR*           ,6P.PROC_STATUS_CD                                            
MFA-TR*           ,6P.DEFAULT_COMMENTS                                          
MFA-TR*           ,6P.CATEGORY_ID                                               
MFA-TR*      INTO :6P-STATUS-SEQ-NO                                             
MFA-TR*          ,:6P-PROC-FLOW-IND                                             
MFA-TR*          ,:6P-PROC-STATUS-CD                                            
MFA-TR*          ,:6P-DEFAULT-COMMENTS                                          
MFA-TR*          ,:6P-CATEGORY-ID                                               
MFA-TR*      FROM CSS_PROCESS_CNTRL 6P                                          
MFA-TR*        WHERE 6P.COMPANY_NO     = :6P-COMPANY-NO                         
MFA-TR*        AND 6P.CODE_UTIL_TYPE   = :6P-CODE-UTIL-TYPE                     
MFA-TR*        AND 6P.PROC_TYPE_CD     = :6P-PROC-TYPE-CD                       
MFA-TR*        AND 6P.STATUS_SEQ_NO    < :6P-STATUS-SEQ-NO                      
MFA-TR*        AND 6P.PROC_FLOW_IND    = :6P-PROC-FLOW-IND                      
MFA-TR*        ORDER BY 6P.STATUS_SEQ_NO DESC                                   
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7350                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7350'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_PROCESS_CNTRL' TO TABLE-1                       
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
              MOVE 6P-COMPANY-NO       TO HOSTVAR-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 6P-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-2               
              PERFORM 9001-TERMINATE-PROGRAM  THRU 9001-EXIT            
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7375-CHECK-PROC-GROUP-EXISTS                                   *        
      *     GET THE DATA FROM CSS_PROCESS_GROUP                        *        
      ******************************************************************        
       7375-CHECK-PROC-GROUP-EXISTS.                                    
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
              INTO :WS-PROC-GROUP-EXISTS-FL                             
              FROM CSS_PROCESS_REQ [1P] WITH(READUNCOMMITTED)                   
              WHERE [1P].PROC_GROUP_CD = :1P-PROC-GROUP-CD                
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*       INTO :WS-PROC-GROUP-EXISTS-FL                                     
MFA-TR*       FROM CSS_PROCESS_REQ 1P                                           
MFA-TR*       WHERE 1P.PROC_GROUP_CD = :1P-PROC-GROUP-CD                        
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7375                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7375'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_PROCESS_REQ  '     TO TABLE-1                   
              MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2           
              MOVE 6P-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-1         
              MOVE 6P-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2         
              PERFORM 9001-TERMINATE-PROGRAM  THRU 9001-EXIT            
           END-IF.                                                      
                                                                        
       7375-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7400-DELETE-BPR                                              *          
      ****************************************************************          
       7400-DELETE-BPR.                                                 
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_PROCESS_REQ                                
             WHERE PROC_REQ_ID = :1P-PROC-REQ-ID                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7400'              TO ACTIVE-PARAGRAPH              
              MOVE 'DELETE'            TO ABEND-FUNCTION                
              MOVE 'CSS_PROCESS_CNTRL' TO TABLE-1                       
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
              MOVE 6P-COMPANY-NO       TO HOSTVAR-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 6P-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-2               
              PERFORM 9001-TERMINATE-PROGRAM  THRU 9001-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7425-DELETE-REQ-CH                                           *          
      ****************************************************************          
       7425-DELETE-REQ-CH.                                              
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_PROCESS_REQ_CH                             
             WHERE PROC_REQ_ID = :1P-PROC-REQ-ID                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7425'              TO ACTIVE-PARAGRAPH              
              MOVE 'DELETE'            TO ABEND-FUNCTION                
              MOVE 'CSS_PROCESS_CNTRL' TO TABLE-1                       
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
              MOVE 6P-COMPANY-NO       TO HOSTVAR-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 6P-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-2               
              PERFORM 9001-TERMINATE-PROGRAM  THRU 9001-EXIT            
           END-IF.                                                      
                                                                        
       7425-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7450-DELETE-BPR-GROUP                                        *          
      ****************************************************************          
       7450-DELETE-BPR-GROUP.                                           
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_PROCESS_GROUP                              
             WHERE PROC_GROUP_CD = :5P-PROC-GROUP-CD                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7450'              TO ACTIVE-PARAGRAPH              
              MOVE 'DELETE'            TO ABEND-FUNCTION                
              MOVE 'CSS_PROCESS_GROUP' TO TABLE-1                       
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
              MOVE 6P-COMPANY-NO       TO HOSTVAR-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 6P-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-2               
              PERFORM 9001-TERMINATE-PROGRAM  THRU 9001-EXIT            
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
