      *****************************************************************         
      **  CPD00727 COPYBOOK                                          **         
      **           CALLED FROM CSR04505                              **         
      *****************************************************************         
      *****************************************************************         
      *   MODIFICATION LOG -                                          *         
      *                                                               *         
      *   DATE     INITIALS        COMMENTS                           *         
      *  ------    --------        -----------------------------------*         
      * 07/30/11   DB41297         INTIALLY WRITTEN.                  *         
      *****************************************************************         
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      *     1. VALIDATE BUSINESS REQUEST                               *        
      *     2. PERFORM APPLICABLE FUNCTION                             *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EVALUATE TRUE                                                
      ******************************************************************        
      *  GET SPECIFIC BUSINESS PROCESS REQUEST                                  
            WHEN 1P-PROC-REQ-ID > 0                                     
                PERFORM 1100-PROCESS-REQID THRU 1100-EXIT               
      ******************************************************************        
      *  GET PENDING BUSINESS PROCESS FOR SPECIFIED COMPANY                     
            WHEN 6P-COMPANY-NO NOT   = ' ' AND                          
                 2P-PROC-AREA-CD NOT = ' ' AND                          
               LINK-PENDING-FL = 'Y'                                    
                PERFORM 1200-PENDING-COMPANY-PROCESS THRU 1200-EXIT     
      ******************************************************************        
      *  GET COMPL/CANC BUS PROCESS REQUESTS FOR SPECIFIED COMPANY              
            WHEN 6P-COMPANY-NO   NOT = ' ' AND                          
                 2P-PROC-AREA-CD NOT = ' ' AND                          
                  LINK-PENDING-FL = 'N'                                 
                PERFORM 1300-COMPLETE-CANCEL-PROCESS THRU 1300-EXIT     
      ******************************************************************        
      *  GET PENDING BUSINESS PROCESS REQUESTS FOR SPECIFIED COMPANY            
            WHEN 6P-COMPANY-NO NOT = ' ' AND LINK-PENDING-FL = 'Y'      
                PERFORM 1400-PENDING-COMPANY THRU 1400-EXIT             
      ******************************************************************        
      *  GET COMP/CANC BUS PROCESS RQUESTS FOR SPECIFIED COMPANY                
            WHEN 6P-COMPANY-NO NOT = ' ' AND LINK-PENDING-FL = 'N'      
                PERFORM 1500-COMPLETE-CANCEL-COMPANY THRU 1500-EXIT     
      ******************************************************************        
      *  GET PENDING BUS PROCESS REQUESTS FOR SPECIFIED PROCESS AREA            
            WHEN 2P-PROC-AREA-CD NOT = ' ' AND LINK-PENDING-FL = 'Y'    
                PERFORM 1600-PENDING-PROCESS THRU 1600-EXIT             
      ******************************************************************        
      *  GET COMPL/CANC BUS PROCESS REQUESTS FOR SPECIFIED PROCESS AREA         
            WHEN 2P-PROC-AREA-CD NOT = ' ' AND LINK-PENDING-FL = 'N'    
                PERFORM 1700-COMPLETE-CANCEL-AREA THRU 1700-EXIT        
      ******************************************************************        
            WHEN OTHER                                                  
                PERFORM 1800-INVALID-REQUEST THRU 1800-EXIT             
           END-EVALUATE.                                                
                                                                        
                                                                        
      ******************************************************************        
      *  FOR THE ALL ABOVE ANY SCENARIO RETURNED +100 FOR FIRST FETCH  *        
      ******************************************************************        
           IF CTR-ROWS EQUAL ZERO                                       
              MOVE 100                        TO S-RETURN-CODE          
              MOVE   0                        TO S-APPL-RETURN-CODE     
              PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-PROCESS-REQID.                                            *        
      *  GET SPECIFIC BUSINESS PROCESS REQUEST                                  
      ******************************************************************        
       1100-PROCESS-REQID.                                              
                                                                        
           PERFORM 7000-OPEN-PROCESS-CNTRL  THRU 7000-EXIT.             
           PERFORM 7025-FETCH-PROCESS-CNTRL THRU 7025-EXIT.             
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = 100                    
      *      PERFORM 7700-GET-EFFECTIVE-TS    THRU 7700-EXIT                    
             PERFORM 7800-GET-BPR-SECURITY    THRU 7800-EXIT            
             PERFORM 7900-CHECK-CAN-DELETE    THRU 7900-EXIT            
             PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT            
             PERFORM 7025-FETCH-PROCESS-CNTRL THRU 7025-EXIT            
           END-PERFORM                                                  
                                                                        
           PERFORM 7050-CLOSE-PROCESS-CNTRL THRU 7050-EXIT.             
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1200-PENDING-COMPANY-PROCESS.                                  *        
      *  GET PENDING BUSINESS PROCESS FOR SPECIFIED COMPANY                     
      ******************************************************************        
       1200-PENDING-COMPANY-PROCESS.                                    
                                                                        
           PERFORM 7100-OPEN-PROCESS-CNTRL  THRU 7100-EXIT.             
           PERFORM 7125-FETCH-PROCESS-CNTRL THRU 7125-EXIT.             
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = 100                    
      *      PERFORM 7700-GET-EFFECTIVE-TS    THRU 7700-EXIT                    
             PERFORM 7800-GET-BPR-SECURITY    THRU 7800-EXIT            
             PERFORM 7900-CHECK-CAN-DELETE    THRU 7900-EXIT            
             PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT            
             PERFORM 7125-FETCH-PROCESS-CNTRL THRU 7125-EXIT            
           END-PERFORM                                                  
                                                                        
           PERFORM 7150-CLOSE-PROCESS-CNTRL THRU 7150-EXIT.             
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1300-COMPLETE-CANCEL-PROCESS.                                  *        
      *  GET COMPL/CANC BUS PROCESS REQUESTS FOR SPECIFIED COMPANY              
      ******************************************************************        
       1300-COMPLETE-CANCEL-PROCESS.                                    
                                                                        
           PERFORM 7200-OPEN-PROCESS-CNTRL  THRU 7200-EXIT.             
           PERFORM 7225-FETCH-PROCESS-CNTRL THRU 7225-EXIT.             
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = 100                    
      *      PERFORM 7700-GET-EFFECTIVE-TS    THRU 7700-EXIT                    
             PERFORM 7800-GET-BPR-SECURITY    THRU 7800-EXIT            
             PERFORM 7900-CHECK-CAN-DELETE    THRU 7900-EXIT            
             PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT            
             PERFORM 7225-FETCH-PROCESS-CNTRL THRU 7225-EXIT            
           END-PERFORM                                                  
                                                                        
           PERFORM 7250-CLOSE-PROCESS-CNTRL THRU 7250-EXIT.             
                                                                        
       1300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1400-PENDING-COMPANY.                                          *        
      *  GET PENDING BUSINESS PROCESS REQUESTS FOR SPECIFIED COMPANY            
      ******************************************************************        
       1400-PENDING-COMPANY.                                            
                                                                        
           PERFORM 7300-OPEN-PROCESS-CNTRL  THRU 7300-EXIT.             
           PERFORM 7325-FETCH-PROCESS-CNTRL THRU 7325-EXIT.             
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = 100                    
      *      PERFORM 7700-GET-EFFECTIVE-TS    THRU 7700-EXIT                    
             PERFORM 7800-GET-BPR-SECURITY    THRU 7800-EXIT            
             PERFORM 7900-CHECK-CAN-DELETE    THRU 7900-EXIT            
             PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT            
             PERFORM 7325-FETCH-PROCESS-CNTRL THRU 7325-EXIT            
           END-PERFORM                                                  
                                                                        
           PERFORM 7350-CLOSE-PROCESS-CNTRL THRU 7350-EXIT.             
                                                                        
       1400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1500-COMPLETE-CANCEL-COMPANY.                                  *        
      *  GET COMP/CANC BUS PROCESS RQUESTS FOR SPECIFIED COMPANY                
      ******************************************************************        
       1500-COMPLETE-CANCEL-COMPANY.                                    
                                                                        
           PERFORM 7400-OPEN-PROCESS-CNTRL  THRU 7400-EXIT.             
           PERFORM 7425-FETCH-PROCESS-CNTRL THRU 7425-EXIT.             
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = 100                    
      *      PERFORM 7700-GET-EFFECTIVE-TS    THRU 7700-EXIT                    
             PERFORM 7800-GET-BPR-SECURITY    THRU 7800-EXIT            
             PERFORM 7900-CHECK-CAN-DELETE    THRU 7900-EXIT            
             PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT            
             PERFORM 7425-FETCH-PROCESS-CNTRL THRU 7425-EXIT            
           END-PERFORM                                                  
                                                                        
           PERFORM 7450-CLOSE-PROCESS-CNTRL THRU 7450-EXIT.             
                                                                        
       1500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1600-PENDING-PROCESS.                                          *        
      *  GET PENDING BUS PROCESS REQUESTS FOR SPECIFIED PROCESS AREA            
      ******************************************************************        
       1600-PENDING-PROCESS.                                            
                                                                        
           PERFORM 7500-OPEN-PROCESS-CNTRL  THRU 7500-EXIT.             
           PERFORM 7525-FETCH-PROCESS-CNTRL THRU 7525-EXIT.             
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = 100                    
      *      PERFORM 7700-GET-EFFECTIVE-TS    THRU 7700-EXIT                    
             PERFORM 7800-GET-BPR-SECURITY    THRU 7800-EXIT            
             PERFORM 7900-CHECK-CAN-DELETE    THRU 7900-EXIT            
             PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT            
             PERFORM 7525-FETCH-PROCESS-CNTRL THRU 7525-EXIT            
           END-PERFORM                                                  
                                                                        
           PERFORM 7550-CLOSE-PROCESS-CNTRL THRU 7550-EXIT.             
                                                                        
       1600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1700-COMPLETE-CANCEL-AREA.                                     *        
      *  GET COMPL/CANC BUS PROCESS REQUESTS FOR SPECIFIED PROCESS AREA         
      ******************************************************************        
       1700-COMPLETE-CANCEL-AREA.                                       
                                                                        
           PERFORM 7600-OPEN-PROCESS-CNTRL  THRU 7600-EXIT.             
           PERFORM 7625-FETCH-PROCESS-CNTRL THRU 7625-EXIT.             
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = 100                    
      *      PERFORM 7700-GET-EFFECTIVE-TS    THRU 7700-EXIT                    
             PERFORM 7800-GET-BPR-SECURITY    THRU 7800-EXIT            
             PERFORM 7900-CHECK-CAN-DELETE    THRU 7900-EXIT            
             PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT            
             PERFORM 7625-FETCH-PROCESS-CNTRL THRU 7625-EXIT            
           END-PERFORM                                                  
                                                                        
           PERFORM 7650-CLOSE-PROCESS-CNTRL THRU 7650-EXIT.             
                                                                        
       1700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1800-INVALID-REQUEST.                                          *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. BUILD RESULT SET                                        *        
      *     3. SEND RESULT SET                                         *        
      ******************************************************************        
       1800-INVALID-REQUEST.                                            
                                                                        
           MOVE 803 TO WS-ACTIVE-RETURN-CODE                            
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
                                                                        
       1800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     1. POPULATE RETURN FIELDS                                  *        
      *     2. SEND RESULT SET                                         *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           INITIALIZE                     GTT-RETURN-FIELDS             
      *    IF WS-ACTIVE-RETURN-CODE       NOT = 0                               
      *       MOVE 100                    TO S-RETURN-CODE                      
      *    END-IF                                                               
      *    MOVE WS-ACTIVE-RETURN-CODE     TO S-APPL-RETURN-CODE                 
           MOVE 1P-PROC-REQ-ID            TO S-PROC-REQ-ID              
           MOVE 1P-STATUS-SEQ-NO          TO S-STATUS-SEQ-NO            
           MOVE 1P-PROC-REQ-DESC          TO S-PROC-REQ-DESC            
           MOVE 1P-PROC-GROUP-CD          TO S-PROC-GROUP-CD            
           MOVE 1P-CREATED-BY-USERID      TO S-CREATED-BY-USERID        
           MOVE 1P-CREATED-TS             TO S-CREATED-TS               
           MOVE 1P-EFFECTIVE-TS           TO S-EFFECTIVE-TS             
           MOVE 1P-COMPANY-NO             TO S-COMPANY-NO               
           MOVE 6P-CATEGORY-ID            TO S-CATEGORY-ID              
           MOVE 1P-PROC-REQ-DUE-TS        TO S-PROC-REQ-DUE-TS          
           MOVE 1P-CODE-UTIL-TYPE         TO S-CODE-UTIL-TYPE           
           MOVE 1P-PROC-TYPE-CD           TO S-PROC-TYPE-CD             
           MOVE 1P-PROC-FLOW-IND          TO S-PROC-FLOW-IND            
           MOVE 1P-PROC-STATUS-CD         TO S-PROC-STATUS-CD           
           MOVE 1P-LAST-UPDATE-USERID     TO S-LAST-UPDATE-USERID       
           MOVE 1P-LAST-UPDATE-TS         TO S-LAST-UPDATE-TS           
           MOVE WS-HAS-ACCESS-FL          TO S-HAS-ACCESS-FL            
           MOVE WS-CAN-DELETE-FL          TO S-CAN-DELETE-FL.           
                                                                        
           PERFORM 8100-SEND-RESULT           THRU 8100-EXIT.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7000-OPEN-PROCESS-CNTRL                                   *             
      ****************************************************************          
                                                                        
       7000-OPEN-PROCESS-CNTRL.                                         
                                                                        
           EXEC SQL                                                     
              OPEN QUERY1-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7000'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_PROCESS_CNTRL' TO TABLE-1                       
              MOVE '1P-PROC-REQ-ID'    TO TABLE-ELEMENT-1               
              MOVE 1P-PROC-REQ-ID      TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7025-FETCH-PROCESS-CNTRL                                       *        
      *     GET THE DATA FROM CSS_PROCESS_CNTRL                        *        
      *  CITY                                                          *        
      ******************************************************************        
       7025-FETCH-PROCESS-CNTRL.                                        
                                                                        
           EXEC SQL                                                     
              FETCH QUERY1-CURSOR                                       
                INTO :1P-PROC-REQ-ID                                    
                    ,:1P-COMPANY-NO                                     
                    ,:1P-CODE-UTIL-TYPE                                 
                    ,:1P-PROC-REQ-DESC                                  
                    ,:1P-PROC-TYPE-CD                                   
                    ,:1P-STATUS-SEQ-NO                                  
                    ,:1P-PROC-FLOW-IND                                  
                    ,:1P-PROC-STATUS-CD                                 
                    ,:1P-PROC-GROUP-CD                                  
                    ,:1P-CREATED-BY-USERID                              
                    ,:1P-CREATED-TS                                     
                    ,:1P-EFFECTIVE-TS                                   
                    ,:6P-CATEGORY-ID                                    
                    ,:1P-PROC-REQ-DUE-TS                                
                    ,:1P-LAST-UPDATE-USERID                             
                    ,:1P-LAST-UPDATE-TS                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF 1P-PROC-REQ-DUE-TS = '1999-01-01-00.00.00.000000'      
                 MOVE SPACES TO 1P-PROC-REQ-DUE-TS                      
              END-IF                                                    
              IF 1P-EFFECTIVE-TS    = '1999-01-01-00.00.00.000000'      
                 MOVE SPACES TO 1P-EFFECTIVE-TS                         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7025'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROCESS_CNTRL'      TO TABLE-1                  
              MOVE '1P-PROC-REQ-ID'         TO TABLE-ELEMENT-1          
              MOVE 1P-PROC-REQ-ID           TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU  9900-EXIT          
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7050-CLOSE-PROCESS-CNTRL                                   *            
      ****************************************************************          
                                                                        
       7050-CLOSE-PROCESS-CNTRL.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE QUERY1-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7050'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROCESS_CNTRL'      TO TABLE-1                  
              MOVE '1P-PROC-REQ-ID'         TO TABLE-ELEMENT-1          
              MOVE 1P-PROC-REQ-ID           TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7100-OPEN-PROCESS-CNTRL                                   *             
      ****************************************************************          
                                                                        
       7100-OPEN-PROCESS-CNTRL.                                         
                                                                        
           EXEC SQL                                                     
              OPEN QUERY2-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROCESS_CNTRL'      TO TABLE-1                  
              MOVE 'CSS_PROCESS_REQ'        TO TABLE-2                  
              MOVE 'CSS_PROCESS_TYPE'       TO TABLE-3                  
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-1          
              MOVE 'PROC_AREA_CD'           TO TABLE-ELEMENT-2          
              MOVE 1P-COMPANY-NO            TO HOSTVAR-ELEMENT-1        
              MOVE WS-PROC-AREA-CD          TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7125-FETCH-PROCESS-CNTRL                                       *        
      *     GET THE DATA FROM CSS_PROCESS_CNTRL                        *        
      ******************************************************************        
       7125-FETCH-PROCESS-CNTRL.                                        
                                                                        
           EXEC SQL                                                     
              FETCH QUERY2-CURSOR                                       
                INTO :1P-PROC-REQ-ID                                    
                    ,:1P-COMPANY-NO                                     
                    ,:1P-CODE-UTIL-TYPE                                 
                    ,:1P-PROC-REQ-DESC                                  
                    ,:1P-PROC-TYPE-CD                                   
                    ,:1P-STATUS-SEQ-NO                                  
                    ,:1P-PROC-FLOW-IND                                  
                    ,:1P-PROC-STATUS-CD                                 
                    ,:1P-PROC-GROUP-CD                                  
                    ,:1P-CREATED-BY-USERID                              
                    ,:1P-CREATED-TS                                     
                    ,:1P-EFFECTIVE-TS                                   
                    ,:6P-CATEGORY-ID                                    
                    ,:1P-PROC-REQ-DUE-TS                                
                    ,:1P-LAST-UPDATE-USERID                             
                    ,:1P-LAST-UPDATE-TS                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF 1P-PROC-REQ-DUE-TS = '1999-01-01-00.00.00.000000'      
                 MOVE SPACES TO 1P-PROC-REQ-DUE-TS                      
              END-IF                                                    
              IF 1P-EFFECTIVE-TS    = '1999-01-01-00.00.00.000000'      
                 MOVE SPACES TO 1P-EFFECTIVE-TS                         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7125'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROCESS_CNTRL'      TO TABLE-1                  
              MOVE 'CSS_PROCESS_REQ'        TO TABLE-2                  
              MOVE 'CSS_PROCESS_TYPE'       TO TABLE-3                  
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-1          
              MOVE 'PROC_AREA_CD'           TO TABLE-ELEMENT-2          
              MOVE 1P-COMPANY-NO            TO HOSTVAR-ELEMENT-1        
              MOVE WS-PROC-AREA-CD          TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU  9900-EXIT          
           END-IF.                                                      
                                                                        
       7125-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7150-CLOSE-PROCESS-CNTRL                                   *            
      ****************************************************************          
                                                                        
       7150-CLOSE-PROCESS-CNTRL.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE QUERY2-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7150'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROCESS_CNTRL'      TO TABLE-1                  
              MOVE 'CSS_PROCESS_REQ'        TO TABLE-2                  
              MOVE 'CSS_PROCESS_TYPE'       TO TABLE-3                  
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-1          
              MOVE 'PROC_AREA_CD'           TO TABLE-ELEMENT-2          
              MOVE 1P-COMPANY-NO            TO HOSTVAR-ELEMENT-1        
              MOVE WS-PROC-AREA-CD          TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7200-OPEN-PROCESS-CNTRL                                   *             
      ****************************************************************          
                                                                        
       7200-OPEN-PROCESS-CNTRL.                                         
                                                                        
           EXEC SQL                                                     
              OPEN QUERY3-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROCESS_CNTRL'      TO TABLE-1                  
              MOVE 'CSS_PROCESS_REQ'        TO TABLE-2                  
              MOVE 'CSS_PROCESS_TYPE'       TO TABLE-3                  
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-1          
              MOVE 'PROC_AREA_CD'           TO TABLE-ELEMENT-2          
              MOVE 1P-COMPANY-NO            TO HOSTVAR-ELEMENT-1        
              MOVE WS-PROC-AREA-CD          TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7225-FETCH-PROCESS-CNTRL                                       *        
      *     GET THE DATA FROM CSS_PROCESS_CNTRL                        *        
      ******************************************************************        
       7225-FETCH-PROCESS-CNTRL.                                        
                                                                        
           EXEC SQL                                                     
              FETCH QUERY3-CURSOR                                       
                INTO :1P-PROC-REQ-ID                                    
                    ,:1P-COMPANY-NO                                     
                    ,:1P-CODE-UTIL-TYPE                                 
                    ,:1P-PROC-REQ-DESC                                  
                    ,:1P-PROC-TYPE-CD                                   
                    ,:1P-STATUS-SEQ-NO                                  
                    ,:1P-PROC-FLOW-IND                                  
                    ,:1P-PROC-STATUS-CD                                 
                    ,:1P-PROC-GROUP-CD                                  
                    ,:1P-CREATED-BY-USERID                              
                    ,:1P-CREATED-TS                                     
                    ,:1P-EFFECTIVE-TS                                   
                    ,:6P-CATEGORY-ID                                    
                    ,:1P-PROC-REQ-DUE-TS                                
                    ,:1P-LAST-UPDATE-USERID                             
                    ,:1P-LAST-UPDATE-TS                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF 1P-PROC-REQ-DUE-TS = '1999-01-01-00.00.00.000000'      
                 MOVE SPACES TO 1P-PROC-REQ-DUE-TS                      
              END-IF                                                    
              IF 1P-EFFECTIVE-TS    = '1999-01-01-00.00.00.000000'      
                 MOVE SPACES TO 1P-EFFECTIVE-TS                         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7225'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROCESS_CNTRL'      TO TABLE-1                  
              MOVE 'CSS_PROCESS_REQ'        TO TABLE-2                  
              MOVE 'CSS_PROCESS_TYPE'       TO TABLE-3                  
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-1          
              MOVE 'PROC_AREA_CD'           TO TABLE-ELEMENT-2          
              MOVE 1P-COMPANY-NO            TO HOSTVAR-ELEMENT-1        
              MOVE WS-PROC-AREA-CD          TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU  9900-EXIT          
           END-IF.                                                      
                                                                        
       7225-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7250-CLOSE-PROCESS-CNTRL                                   *            
      ****************************************************************          
                                                                        
       7250-CLOSE-PROCESS-CNTRL.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE QUERY3-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7250'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROCESS_CNTRL'      TO TABLE-1                  
              MOVE 'CSS_PROCESS_REQ'        TO TABLE-2                  
              MOVE 'CSS_PROCESS_TYPE'       TO TABLE-3                  
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-1          
              MOVE 'PROC_AREA_CD'           TO TABLE-ELEMENT-2          
              MOVE 1P-COMPANY-NO            TO HOSTVAR-ELEMENT-1        
              MOVE WS-PROC-AREA-CD          TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7300-OPEN-PROCESS-CNTRL                                   *             
      ****************************************************************          
                                                                        
       7300-OPEN-PROCESS-CNTRL.                                         
                                                                        
           EXEC SQL                                                     
              OPEN QUERY4-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROCESS_REQ'        TO TABLE-1                  
              MOVE 'CSS_PROCESS_CNTRL'      TO TABLE-2                  
              MOVE 'CSS_PROCESS_TYPE'       TO TABLE-3                  
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-1          
              MOVE 1P-COMPANY-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7325-FETCH-PROCESS-CNTRL                                       *        
      *     GET THE DATA FROM CSS_PROCESS_CNTRL                        *        
      ******************************************************************        
       7325-FETCH-PROCESS-CNTRL.                                        
                                                                        
           EXEC SQL                                                     
              FETCH QUERY4-CURSOR                                       
                INTO :1P-PROC-REQ-ID                                    
                    ,:1P-COMPANY-NO                                     
                    ,:1P-CODE-UTIL-TYPE                                 
                    ,:1P-PROC-REQ-DESC                                  
                    ,:1P-PROC-TYPE-CD                                   
                    ,:1P-STATUS-SEQ-NO                                  
                    ,:1P-PROC-FLOW-IND                                  
                    ,:1P-PROC-STATUS-CD                                 
                    ,:1P-PROC-GROUP-CD                                  
                    ,:1P-CREATED-BY-USERID                              
                    ,:1P-CREATED-TS                                     
                    ,:1P-EFFECTIVE-TS                                   
                    ,:6P-CATEGORY-ID                                    
                    ,:1P-PROC-REQ-DUE-TS                                
                    ,:1P-LAST-UPDATE-USERID                             
                    ,:1P-LAST-UPDATE-TS                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF 1P-PROC-REQ-DUE-TS = '1999-01-01-00.00.00.000000'      
                 MOVE SPACES TO 1P-PROC-REQ-DUE-TS                      
              END-IF                                                    
              IF 1P-EFFECTIVE-TS    = '1999-01-01-00.00.00.000000'      
                 MOVE SPACES TO 1P-EFFECTIVE-TS                         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7325'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROCESS_REQ'        TO TABLE-1                  
              MOVE 'CSS_PROCESS_CNTRL'      TO TABLE-2                  
              MOVE 'CSS_PROCESS_TYPE'       TO TABLE-3                  
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-1          
              MOVE 1P-COMPANY-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7325-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7350-CLOSE-PROCESS-CNTRL                                   *            
      ****************************************************************          
                                                                        
       7350-CLOSE-PROCESS-CNTRL.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE QUERY4-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7350'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROCESS_REQ'        TO TABLE-1                  
              MOVE 'CSS_PROCESS_CNTRL'      TO TABLE-2                  
              MOVE 'CSS_PROCESS_TYPE'       TO TABLE-3                  
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-1          
              MOVE 1P-COMPANY-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7400-OPEN-PROCESS-CNTRL                                   *             
      ****************************************************************          
                                                                        
       7400-OPEN-PROCESS-CNTRL.                                         
                                                                        
           EXEC SQL                                                     
              OPEN QUERY5-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7400'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROCESS_REQ'        TO TABLE-1                  
              MOVE 'CSS_PROCESS_CNTRL'      TO TABLE-2                  
              MOVE 'CSS_PROCESS_TYPE'       TO TABLE-3                  
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-1          
              MOVE 1P-COMPANY-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7425-FETCH-PROCESS-CNTRL                                       *        
      *     GET THE DATA FROM CSS_PROCESS_CNTRL                        *        
      ******************************************************************        
       7425-FETCH-PROCESS-CNTRL.                                        
                                                                        
           EXEC SQL                                                     
              FETCH QUERY5-CURSOR                                       
                INTO :1P-PROC-REQ-ID                                    
                    ,:1P-COMPANY-NO                                     
                    ,:1P-CODE-UTIL-TYPE                                 
                    ,:1P-PROC-REQ-DESC                                  
                    ,:1P-PROC-TYPE-CD                                   
                    ,:1P-STATUS-SEQ-NO                                  
                    ,:1P-PROC-FLOW-IND                                  
                    ,:1P-PROC-STATUS-CD                                 
                    ,:1P-PROC-GROUP-CD                                  
                    ,:1P-CREATED-BY-USERID                              
                    ,:1P-CREATED-TS                                     
                    ,:1P-EFFECTIVE-TS                                   
                    ,:6P-CATEGORY-ID                                    
                    ,:1P-PROC-REQ-DUE-TS                                
                    ,:1P-LAST-UPDATE-USERID                             
                    ,:1P-LAST-UPDATE-TS                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF 1P-PROC-REQ-DUE-TS = '1999-01-01-00.00.00.000000'      
                 MOVE SPACES TO 1P-PROC-REQ-DUE-TS                      
              END-IF                                                    
              IF 1P-EFFECTIVE-TS    = '1999-01-01-00.00.00.000000'      
                 MOVE SPACES TO 1P-EFFECTIVE-TS                         
              END-IF                                                    
           ELSE                                                         
              MOVE '7425'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROCESS_REQ'        TO TABLE-1                  
              MOVE 'CSS_PROCESS_CNTRL'      TO TABLE-2                  
              MOVE 'CSS_PROCESS_TYPE'       TO TABLE-3                  
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-1          
              MOVE 1P-COMPANY-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU  9900-EXIT          
           END-IF.                                                      
                                                                        
       7425-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7450-CLOSE-PROCESS-CNTRL                                   *            
      ****************************************************************          
                                                                        
       7450-CLOSE-PROCESS-CNTRL.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE QUERY5-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7450'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROCESS_REQ'        TO TABLE-1                  
              MOVE 'CSS_PROCESS_CNTRL'      TO TABLE-2                  
              MOVE 'CSS_PROCESS_TYPE'       TO TABLE-3                  
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-1          
              MOVE 1P-COMPANY-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7500-OPEN-PROCESS-CNTRL                                   *             
      ****************************************************************          
                                                                        
       7500-OPEN-PROCESS-CNTRL.                                         
                                                                        
           EXEC SQL                                                     
              OPEN QUERY6-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROCESS_REQ'        TO TABLE-1                  
              MOVE 'CSS_PROCESS_CNTRL'      TO TABLE-2                  
              MOVE 'CSS_PROCESS_TYPE'       TO TABLE-3                  
              MOVE 'PROC_AREA_CD'           TO TABLE-ELEMENT-1          
              MOVE WS-PROC-AREA-CD          TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7525-FETCH-PROCESS-CNTRL                                       *        
      *     GET THE DATA FROM CSS_PROCESS_CNTRL                        *        
      ******************************************************************        
       7525-FETCH-PROCESS-CNTRL.                                        
                                                                        
           EXEC SQL                                                     
              FETCH QUERY6-CURSOR                                       
                INTO :1P-PROC-REQ-ID                                    
                    ,:1P-COMPANY-NO                                     
                    ,:1P-CODE-UTIL-TYPE                                 
                    ,:1P-PROC-REQ-DESC                                  
                    ,:1P-PROC-TYPE-CD                                   
                    ,:1P-STATUS-SEQ-NO                                  
                    ,:1P-PROC-FLOW-IND                                  
                    ,:1P-PROC-STATUS-CD                                 
                    ,:1P-PROC-GROUP-CD                                  
                    ,:1P-CREATED-BY-USERID                              
                    ,:1P-CREATED-TS                                     
                    ,:1P-EFFECTIVE-TS                                   
                    ,:6P-CATEGORY-ID                                    
                    ,:1P-PROC-REQ-DUE-TS                                
                    ,:1P-LAST-UPDATE-USERID                             
                    ,:1P-LAST-UPDATE-TS                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF 1P-PROC-REQ-DUE-TS = '1999-01-01-00.00.00.000000'      
                 MOVE SPACES TO 1P-PROC-REQ-DUE-TS                      
              END-IF                                                    
              IF 1P-EFFECTIVE-TS    = '1999-01-01-00.00.00.000000'      
                 MOVE SPACES TO 1P-EFFECTIVE-TS                         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7525'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROCESS_REQ'        TO TABLE-1                  
              MOVE 'CSS_PROCESS_CNTRL'      TO TABLE-2                  
              MOVE 'CSS_PROCESS_TYPE'       TO TABLE-3                  
              MOVE 'PROC_AREA_CD'           TO TABLE-ELEMENT-1          
              MOVE WS-PROC-AREA-CD          TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU  9900-EXIT          
           END-IF.                                                      
                                                                        
       7525-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7550-CLOSE-PROCESS-CNTRL                                   *            
      ****************************************************************          
                                                                        
       7550-CLOSE-PROCESS-CNTRL.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE QUERY6-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7550'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROCESS_REQ'        TO TABLE-1                  
              MOVE 'CSS_PROCESS_CNTRL'      TO TABLE-2                  
              MOVE 'CSS_PROCESS_TYPE'       TO TABLE-3                  
              MOVE 'PROC_AREA_CD'           TO TABLE-ELEMENT-1          
              MOVE WS-PROC-AREA-CD          TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7600-OPEN-PROCESS-CNTRL                                   *             
      ****************************************************************          
                                                                        
       7600-OPEN-PROCESS-CNTRL.                                         
                                                                        
           EXEC SQL                                                     
              OPEN QUERY7-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7600'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROCESS_REQ'        TO TABLE-1                  
              MOVE 'CSS_PROCESS_CNTRL'      TO TABLE-2                  
              MOVE 'CSS_PROCESS_TYPE'       TO TABLE-3                  
              MOVE 'PROC_AREA_CD'           TO TABLE-ELEMENT-1          
              MOVE WS-PROC-AREA-CD          TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7625-FETCH-PROCESS-CNTRL                                       *        
      *     GET THE DATA FROM CSS_PROCESS_CNTRL                        *        
      ******************************************************************        
       7625-FETCH-PROCESS-CNTRL.                                        
                                                                        
           EXEC SQL                                                     
              FETCH QUERY7-CURSOR                                       
                INTO :1P-PROC-REQ-ID                                    
                    ,:1P-COMPANY-NO                                     
                    ,:1P-CODE-UTIL-TYPE                                 
                    ,:1P-PROC-REQ-DESC                                  
                    ,:1P-PROC-TYPE-CD                                   
                    ,:1P-STATUS-SEQ-NO                                  
                    ,:1P-PROC-FLOW-IND                                  
                    ,:1P-PROC-STATUS-CD                                 
                    ,:1P-PROC-GROUP-CD                                  
                    ,:1P-CREATED-BY-USERID                              
                    ,:1P-CREATED-TS                                     
                    ,:1P-EFFECTIVE-TS                                   
                    ,:6P-CATEGORY-ID                                    
                    ,:1P-PROC-REQ-DUE-TS                                
                    ,:1P-LAST-UPDATE-USERID                             
                    ,:1P-LAST-UPDATE-TS                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF 1P-PROC-REQ-DUE-TS = '1999-01-01-00.00.00.000000'      
                 MOVE SPACES TO 1P-PROC-REQ-DUE-TS                      
              END-IF                                                    
              IF 1P-EFFECTIVE-TS    = '1999-01-01-00.00.00.000000'      
                 MOVE SPACES TO 1P-EFFECTIVE-TS                         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7625'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROCESS_REQ'        TO TABLE-1                  
              MOVE 'CSS_PROCESS_CNTRL'      TO TABLE-2                  
              MOVE 'CSS_PROCESS_TYPE'       TO TABLE-3                  
              MOVE 'PROC_AREA_CD'           TO TABLE-ELEMENT-1          
              MOVE WS-PROC-AREA-CD          TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU  9900-EXIT          
           END-IF.                                                      
                                                                        
       7625-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7650-CLOSE-PROCESS-CNTRL                                   *            
      ****************************************************************          
                                                                        
       7650-CLOSE-PROCESS-CNTRL.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE QUERY7-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7650'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROCESS_REQ'        TO TABLE-1                  
              MOVE 'CSS_PROCESS_CNTRL'      TO TABLE-2                  
              MOVE 'CSS_PROCESS_TYPE'       TO TABLE-3                  
              MOVE 'PROC_AREA_CD'           TO TABLE-ELEMENT-1          
              MOVE WS-PROC-AREA-CD          TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7700-GET-EFFECTIVE-TS                                      *            
      ****************************************************************          
      *                                                                         
      *7700-GET-EFFECTIVE-TS.                                                   
      *                                                                         
      *    MOVE '-'        TO WS-DASH1                                          
      *    MOVE '.'        TO WS-PERIOD1                                        
      *    MOVE ZEROS      TO WS-NULL-IND.                                      
      *                                                                         
      *    EVALUATE 1P-PROC-TYPE-CD                                             
      *     WHEN RTE001, RTE003, RTE004                                         
      *     WHEN 'RTE001'                                                       
      *     WHEN 'RTE003'                                                       
      *     WHEN 'RTE004'                                                       
      *       PERFORM 7710-GET-MIN-RATE-EFF-TS THRU 7710-EXIT                   
      *     WHEN FCT001, PRM007, RPM008, RPM009, RPM010, RPM011                 
      *     WHEN 'FCT001'                                                       
      *     WHEN 'PRM007'                                                       
      *     WHEN 'RPM007'                                                       
      *     WHEN 'RPM008'                                                       
      *     WHEN 'RPM009'                                                       
      *     WHEN 'RPM010'                                                       
      *     WHEN 'RPM011'                                                       
      *       PERFORM 7720-GET-MIN-FCTRAPPL-EFF-TS THRU 7720-EXIT               
      *     WHEN RTE002                                                         
      *     WHEN 'RTE002'                                                       
      *       PERFORM 7710-GET-MIN-RATE-EFF-TS THRU 7710-EXIT                   
      *       PERFORM 7720-GET-MIN-FCTRAPPL-EFF-TS THRU 7720-EXIT               
      *       IF WS-EFF-TS1 > SPACES                                            
      *         IF WS-EFF-TS1 < WS-EFF-TS2                                      
      *           CONTINUE                                                      
      *         END-IF                                                          
      *       ELSE                                                              
      *       IF WS-EFF-TS2 > SPACES                                            
      *         IF WS-EFF-TS2 < WS-EFF-TS1                                      
      *           MOVE WS-EFF-TS2 TO WS-EFF-TS1                                 
      *         END-IF                                                          
      *       END-IF                                                            
      *       END-IF                                                            
      *     WHEN RPM001, RPM002, RPM003                                         
      *     WHEN 'RPM001'                                                       
      *     WHEN 'RPM002'                                                       
      *     WHEN 'RPM003'                                                       
      *       PERFORM 7730-GET-MIN-OFFER-EFF-TS THRU 7730-EXIT                  
      *     WHEN RPM004                                                         
      *     WHEN 'RPM004'                                                       
      *       PERFORM 7740-GET-MIN-OPTION-EFF-TS THRU 7740-EXIT                 
      *     WHEN RPM005, RPM006                                                 
      *     WHEN 'RPM005'                                                       
      *     WHEN 'RPM006'                                                       
      *       PERFORM 7750-GET-MIN-PROMO-EFF-TS THRU 7750-EXIT                  
      *     WHEN OTHER                                                          
      *       MOVE SPACES TO WS-EFF-TS1                                         
      *    END-EVALUATE.                                                        
      *                                                                         
      *7700-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ****************************************************************          
      * 7710-GET-MIN-RATE-EFF-TS                                                
      ****************************************************************          
      *                                                                         
      *7710-GET-MIN-RATE-EFF-TS.                                                
      *                                                                         
      *    EXEC SQL                                                             
      *       SELECT                                                            
      *       IFNULL(FROM_EFFECTIVE_DT,'1900-01-01')                            
      *       INTO :WS-EFF-DT                                                   
      *       FROM CSS_RATE_CREATOR RT                                          
      *       WHERE RT.PROC_REQ_ID = :1P-PROC-REQ-ID                            
      *        AND  RT.FROM_EFFECTIVE_DT IS NOT NULL                            
      *        ORDER BY RT.FROM_EFFECTIVE_DT                                    
      *        FETCH FIRST ROW ONLY                                             
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.                
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                           
      *       IF WS-EFF-DT = '1900-01-01'                                       
      *          MOVE SPACES     TO WS-EFF-TS1                                  
      *       ELSE                                                              
      *          MOVE '00.00.00' TO WS-EFF-TIME                                 
      *          MOVE '000000'   TO WS-MICSEC                                   
      *          MOVE WS-EFF-TS  TO WS-EFF-TS1                                  
      *       END-IF                                                            
      *    ELSE                                                                 
      *    IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                                 
      *       MOVE SPACES        TO WS-EFF-TS1                                  
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME        TO ABEND-PROGRAM                         
      *       MOVE '7710'              TO ACTIVE-PARAGRAPH                      
      *       MOVE 'SELECT'            TO ABEND-FUNCTION                        
      *       MOVE 'CSS_RATE_CREATOR'  TO TABLE-1                               
      *       MOVE 'PROC_REQ_ID'       TO TABLE-ELEMENT-1                       
      *       MOVE 1P-PROC-REQ-ID      TO HOSTVAR-ELEMENT-1                     
      *       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
      *       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
      *    END-IF.                                                              
      *                                                                         
      *7710-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ****************************************************************          
      * 7720-GET-MIN-FCTRAPPL-EFF-TS                                            
      ****************************************************************          
      *                                                                         
      *7720-GET-MIN-FCTRAPPL-EFF-TS.                                            
      *                                                                         
      *    EXEC SQL                                                             
      *       SELECT                                                            
      *       IFNULL(DATE_FROM,'1900-01-01')                                    
      *       INTO :WS-EFF-DT                                                   
      *       FROM CSS_SPCL_FCTR_APPL SA                                        
      *       WHERE SA.PROC_REQ_ID = :1P-PROC-REQ-ID                            
      *        AND  SA.DATE_FROM IS NOT NULL                                    
      *        ORDER BY SA.DATE_FROM                                            
      *        FETCH FIRST ROW ONLY                                             
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.                
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                           
      *       IF WS-EFF-DT = '1900-01-01'                                       
      *          MOVE SPACES     TO WS-EFF-TS1                                  
      *       ELSE                                                              
      *          MOVE '00.00.00' TO WS-EFF-TIME                                 
      *          MOVE '000000'   TO WS-MICSEC                                   
      *          MOVE WS-EFF-TS  TO WS-EFF-TS1                                  
      *       END-IF                                                            
      *    ELSE                                                                 
      *    IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                                 
      *       MOVE SPACES        TO WS-EFF-TS1                                  
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME        TO ABEND-PROGRAM                         
      *       MOVE '7720'              TO ACTIVE-PARAGRAPH                      
      *       MOVE 'SELECT'            TO ABEND-FUNCTION                        
      *       MOVE 'CSS_SPCL_FCTR'     TO TABLE-1                               
      *       MOVE 'PROC_REQ_ID'       TO TABLE-ELEMENT-1                       
      *       MOVE 1P-PROC-REQ-ID      TO HOSTVAR-ELEMENT-1                     
      *       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
      *       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
      *    END-IF.                                                              
      *                                                                         
      *7720-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ****************************************************************          
      * 7730-GET-MIN-OFFER-EFF-TS                                               
      ****************************************************************          
      *                                                                         
      *7730-GET-MIN-OFFER-EFF-TS.                                               
      *                                                                         
      *    EXEC SQL                                                             
      *       SELECT                                                            
      *       IFNULL(OFF_VSTART_TS,'1900-01-01-00.00.00.000000')                
      *       INTO :WS-EFF-TS                                                   
      *       FROM CRM_RT_PKG_OFFER FG                                          
      *       WHERE FG.PROC_REQ_ID = :1P-PROC-REQ-ID                            
      *        AND  FG.OFF_VSTART_TS IS NOT NULL                                
      *        ORDER BY FG.OFF_VSTART_TS                                        
      *        FETCH FIRST ROW ONLY                                             
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.                
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                           
      *       IF WS-EFF-TS = '1900-01-01-00.00.00.000000'                       
      *          MOVE SPACES    TO WS-EFF-TS1                                   
      *       ELSE                                                              
      *          MOVE WS-EFF-TS TO WS-EFF-TS1                                   
      *       END-IF                                                            
      *    ELSE                                                                 
      *    IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                                 
      *       MOVE SPACES       TO WS-EFF-TS1                                   
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME        TO ABEND-PROGRAM                         
      *       MOVE '7730'              TO ACTIVE-PARAGRAPH                      
      *       MOVE 'SELECT'            TO ABEND-FUNCTION                        
      *       MOVE 'CRM_RT_PKG_OFFER ' TO TABLE-1                               
      *       MOVE 'PROC_REQ_ID'       TO TABLE-ELEMENT-1                       
      *       MOVE 1P-PROC-REQ-ID      TO HOSTVAR-ELEMENT-1                     
      *       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
      *       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
      *    END-IF.                                                              
      *                                                                         
      *7730-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ****************************************************************          
      * 7740-GET-MIN-OPTION-EFF-TS                                              
      ****************************************************************          
      *                                                                         
      *7740-GET-MIN-OPTION-EFF-TS.                                              
      *                                                                         
      *    EXEC SQL                                                             
      *       SELECT                                                            
      *       IFNULL(OPT_VSTART_TS,'1900-01-01-00.00.00.000000')                
      *       INTO :WS-EFF-TS                                                   
      *       FROM CRM_RT_PKG_OPTION FI                                         
      *       WHERE FI.PROC_REQ_ID = :1P-PROC-REQ-ID                            
      *        AND  FI.OPT_VSTART_TS IS NOT NULL                                
      *        ORDER BY FI.OPT_VSTART_TS                                        
      *        FETCH FIRST ROW ONLY                                             
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.                
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                           
      *       IF WS-EFF-TS = '1900-01-01-00.00.00.000000'                       
      *          MOVE SPACES    TO WS-EFF-TS1                                   
      *       ELSE                                                              
      *          MOVE WS-EFF-TS TO WS-EFF-TS1                                   
      *       END-IF                                                            
      *    ELSE                                                                 
      *    IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                                 
      *       MOVE SPACES       TO WS-EFF-TS1                                   
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME        TO ABEND-PROGRAM                         
      *       MOVE '7740'              TO ACTIVE-PARAGRAPH                      
      *       MOVE 'SELECT'            TO ABEND-FUNCTION                        
      *       MOVE 'CRM_RT_PKG_OPTION' TO TABLE-1                               
      *       MOVE 'PROC_REQ_ID'       TO TABLE-ELEMENT-1                       
      *       MOVE 1P-PROC-REQ-ID      TO HOSTVAR-ELEMENT-1                     
      *       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
      *       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
      *    END-IF.                                                              
      *                                                                         
      *7740-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ****************************************************************          
      * 7750-GET-MIN-PROMO-EFF-TS                                               
      ****************************************************************          
      *                                                                         
      *7750-GET-MIN-PROMO-EFF-TS.                                               
      *                                                                         
      *    EXEC SQL                                                             
      *       SELECT                                                            
      *       IFNULL(PROMO_VSTART_TS,'1900-01-01-00.00.00.000000')              
      *       INTO :WS-EFF-TS                                                   
      *       FROM CRM_MKT_PROMOTION KM                                         
      *       WHERE KM.PROC_REQ_ID = :1P-PROC-REQ-ID                            
      *        AND  KM.PROMO_VSTART_TS IS NOT NULL                              
      *        ORDER BY KM.PROMO_VSTART_TS                                      
      *        FETCH FIRST ROW ONLY                                             
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.                
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                           
      *       IF WS-EFF-TS = '1900-01-01-00.00.00.000000'                       
      *          MOVE SPACES    TO WS-EFF-TS1                                   
      *       ELSE                                                              
      *          MOVE WS-EFF-TS TO WS-EFF-TS1                                   
      *       END-IF                                                            
      *    ELSE                                                                 
      *    IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                                 
      *       MOVE SPACES       TO WS-EFF-TS1                                   
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME        TO ABEND-PROGRAM                         
      *       MOVE '7750'              TO ACTIVE-PARAGRAPH                      
      *       MOVE 'SELECT'            TO ABEND-FUNCTION                        
      *       MOVE 'CRM_MKT_PROMOTION' TO TABLE-1                               
      *       MOVE 'PROC_REQ_ID'       TO TABLE-ELEMENT-1                       
      *       MOVE 1P-PROC-REQ-ID      TO HOSTVAR-ELEMENT-1                     
      *       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
      *       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
      *    END-IF.                                                              
      *                                                                         
      *7750-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ****************************************************************          
      * CHECK-USER-ACCESS                                            *          
      ****************************************************************          
                                                                        
       7800-GET-BPR-SECURITY.                                           
                                                                        
           MOVE 'N'                    TO WS-HAS-ACCESS-FL.             
                                                                        
           MOVE 1P-PROC-TYPE-CD        TO 6P-PROC-TYPE-CD               
           MOVE 1P-COMPANY-NO          TO 6P-COMPANY-NO                 
           MOVE 1P-CODE-UTIL-TYPE      TO 6P-CODE-UTIL-TYPE             
           MOVE 1P-STATUS-SEQ-NO       TO 6P-STATUS-SEQ-NO              
           MOVE 'P'                    TO 6P-PROC-FLOW-IND.             
                                                                        
           EXEC SQL                                                     
             SELECT [6P].CATEGORY_ID                                      
              INTO :6P-CATEGORY-ID                                      
              FROM CSS_PROCESS_CNTRL [6P]                                 
                 WHERE [6P].COMPANY_NO   = :6P-COMPANY-NO                 
                 AND [6P].CODE_UTIL_TYPE = :6P-CODE-UTIL-TYPE             
                 AND [6P].PROC_TYPE_CD   = :6P-PROC-TYPE-CD               
                 AND [6P].STATUS_SEQ_NO  = :6P-STATUS-SEQ-NO              
                 AND [6P].PROC_FLOW_IND  = :6P-PROC-FLOW-IND              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 6P.CATEGORY_ID                                              
MFA-TR*       INTO :6P-CATEGORY-ID                                              
MFA-TR*       FROM CSS_PROCESS_CNTRL 6P                                         
MFA-TR*          WHERE 6P.COMPANY_NO   = :6P-COMPANY-NO                         
MFA-TR*          AND 6P.CODE_UTIL_TYPE = :6P-CODE-UTIL-TYPE                     
MFA-TR*          AND 6P.PROC_TYPE_CD   = :6P-PROC-TYPE-CD                       
MFA-TR*          AND 6P.STATUS_SEQ_NO  = :6P-STATUS-SEQ-NO                      
MFA-TR*          AND 6P.PROC_FLOW_IND  = :6P-PROC-FLOW-IND                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              GO TO 7800-EXIT                                           
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7800'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_PROCESS_CNTRL' TO TABLE-1                       
              MOVE 'COMPANY'           TO TABLE-ELEMENT-1               
              MOVE 6P-COMPANY-NO       TO HOSTVAR-ELEMENT-1             
              MOVE 'PROC-TYPE-CD'      TO TABLE-ELEMENT-2               
              MOVE 6P-PROC-TYPE-CD     TO HOSTVAR-ELEMENT-2             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
           MOVE  'AD18406'                TO F5-USER-ID                 
           MOVE  LINK-USER-ID             TO F5-USER-ID                 
           MOVE  1                        TO F5-CATEGORY-ID             
           MOVE  6P-CATEGORY-ID           TO F5-CATEGORY-ID             
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
              INTO :WS-HAS-ACCESS-FL                                    
              FROM CSS_CATEGORY F5                                      
              WHERE F5.USER_ID = :F5-USER-ID                            
              AND F5.CATEGORY_ID = :F5-CATEGORY-ID                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'Y'     TO WS-HAS-ACCESS-FL                          
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              GO TO 7800-EXIT                                           
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7800'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_CATEGORY '     TO TABLE-1                       
              MOVE 'USER_ID'           TO TABLE-ELEMENT-1               
              MOVE F5-USER-ID          TO HOSTVAR-ELEMENT-1             
              MOVE 'CATEGORY_ID'       TO TABLE-ELEMENT-2               
              MOVE F5-CATEGORY-ID      TO HOSTVAR-ELEMENT-2             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * REQUEST CAN ONLY BE DELETED IF IT IS THE FIRST STEP IN THE   *          
      * APPROVAL PROCESS.                                            *          
      ****************************************************************          
       7900-CHECK-CAN-DELETE.                                           
                                                                        
           MOVE 'N'               TO WS-CAN-DELETE-FL                   
           PERFORM 7910-GET-FIRST-BPR-STEP THRU 7910-EXIT               
                                                                        
           IF 1P-STATUS-SEQ-NO EQUAL 6P-STATUS-SEQ-NO THEN              
               MOVE 'Y'           TO WS-CAN-DELETE-FL                   
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *                                                              *          
      * 7910-GET-FIRST-BPR-STEP.                                     *          
      ****************************************************************          
       7910-GET-FIRST-BPR-STEP.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) [6P].STATUS_SEQ_NO                                  
                INTO :6P-STATUS-SEQ-NO                                  
                FROM CSS_PROCESS_CNTRL [6P] WITH(READUNCOMMITTED)               
               WHERE [6P].COMPANY_NO       = :6P-COMPANY-NO               
                 AND [6P].CODE_UTIL_TYPE   = :6P-CODE-UTIL-TYPE           
                 AND [6P].PROC_TYPE_CD     = :6P-PROC-TYPE-CD             
                 AND [6P].PROC_FLOW_IND    = :6P-PROC-FLOW-IND            
               ORDER BY [6P].STATUS_SEQ_NO                                
                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 6P.STATUS_SEQ_NO                                           
MFA-TR*         INTO :6P-STATUS-SEQ-NO                                          
MFA-TR*         FROM CSS_PROCESS_CNTRL 6P                                       
MFA-TR*        WHERE 6P.COMPANY_NO       = :6P-COMPANY-NO                       
MFA-TR*          AND 6P.CODE_UTIL_TYPE   = :6P-CODE-UTIL-TYPE                   
MFA-TR*          AND 6P.PROC_TYPE_CD     = :6P-PROC-TYPE-CD                     
MFA-TR*          AND 6P.PROC_FLOW_IND    = :6P-PROC-FLOW-IND                    
MFA-TR*        ORDER BY 6P.STATUS_SEQ_NO                                        
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*       QUERYNO 7910                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7910'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_PROCESS_CNTRL' TO TABLE-1                       
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
              MOVE 'CODE-UTIL-TYPE'    TO TABLE-ELEMENT-2               
              MOVE 'PROC-TYPE-CD'      TO TABLE-ELEMENT-3               
              MOVE 'PROC_FLOW_IND'     TO TABLE-ELEMENT-4               
              MOVE 6P-COMPANY-NO       TO HOSTVAR-ELEMENT-1             
              MOVE 6P-CODE-UTIL-TYPE   TO TABLE-ELEMENT-2               
              MOVE 6P-PROC-TYPE-CD     TO HOSTVAR-ELEMENT-2             
              MOVE 6P-PROC-FLOW-IND    TO HOSTVAR-ELEMENT-2             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
        7910-EXIT.                                                      
            EXIT.                                                       
