      *****************************************************************         
      **  CPD00678 ACCOUNT EVALUATOR COPYBOOK FOR BILLING.           **         
      **           CIS MOD RELEASE 1.0                               **         
      **.............................................................**         
      **.............................................................**         
      **NOTE: WHEN MODIFYING THIS MEMBER, MEMBER CWS00678 & CWS0678A **         
      **      SHOULD BE EVALUATED FOR CORRESPONDING MODIFICATIONS.   **         
      **.............................................................**         
      **                                                             **         
      **  PROCEDURE REFERENCE:                                       **         
      **                                                             **         
      **  PREREQUISITES: CWS0678A & CWS00678                         **         
      **                                                             **         
      **  ADDITIONAL INFORMATION:                                    **         
      **    THIS COPYBOOK HAS THE CORE LOGIC TO DETERMINE BUSINESS   **         
      **    RULES AND SET THE FLAGS ON THE FLY FOR DIFFERENT ACCOUNT **         
      **    ATTRIBUTES.                                              **         
      **                                                             **         
      **    PROCESS CODE DETERMINES WHAT PROCESSING NEEDS TO BE DONE.**         
      **                                                             **         
      ** 1. REQUIRED FIELDS.                                         **         
      **                                                             **         
      **       (A) ACCOUNT NUMBER                                    **         
      **                                                             **         
      *****************************************************************         
      *****************************************************************         
      *   MODIFICATION LOG -                                          *         
      *                                                               *         
      *   DATE     INITIALS        COMMENTS                           *         
      *  ------    --------        -----------------------------------*         
P00594* 03/07/13   JC91900         INTIALLY WRITTEN.                  *         
ACT106** 07/12/13   BD09555        ADD NULL INDICATOR TO PARAGRAPH    *         
ACT106**            APPL4527       7005-SELECT-RATE-INFO             **         
      *****************************************************************         
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6000-ACCT-BILLING-EVALUATOR.                                  *         
      *****************************************************************         
       6000-ACCT-BILLING-EVALUATOR.                                     
                                                                        
           PERFORM 6005-INITIALIZE              THRU 6005-EXIT.         
           PERFORM 6010-MOVE-INPUT-VAR          THRU 6010-EXIT.         
           PERFORM 6015-VALIDATE-INPUT          THRU 6015-EXIT.         
           PERFORM 6020-GET-SYS-PARMS           THRU 6020-EXIT          
           PERFORM 6025-EVALUATE-ACCOUNT        THRU 6025-EXIT.         
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6005-INITIALIZE.                                              *         
      *****************************************************************         
       6005-INITIALIZE.                                                 
                                                                        
            INITIALIZE WS-678-VARS                                      
                      ,WS-678-NULL-IND                                  
                      ,ABEND-FILE                                       
                      ,WS-ACTIVE-RETURN-CODE                            
                      ,WS-678-SWITCHES.                                 
                                                                        
            MOVE 'N'                       TO WS-678-QUALIFY-DRG-SWTCH. 
                                                                        
       6005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6010-MOVE-INPUT-VAR.                                          *         
      *****************************************************************         
       6010-MOVE-INPUT-VAR.                                             
                                                                        
            MOVE WS-678-ACCOUNT-NO            TO WS-ACCOUNT-NO          
                                                 AT-ACCOUNT-NO          
                                                 CZ-ACCOUNT-NO          
                                                 UT-ACCOUNT-NO.         
                                                                        
       6010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6015-VALIDATE-INPUT.                                          *         
      *****************************************************************         
       6015-VALIDATE-INPUT.                                             
                                                                        
           IF WS-ACCOUNT-NO > ZEROES                                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '6010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'RECEIVE INPUT'           TO ABEND-FUNCTION          
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE +1000                     TO WS-ACTIVE-RETURN-CODE   
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       6015-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6020-GET-SYS-PARMS.                                           *         
      *****************************************************************         
       6020-GET-SYS-PARMS.                                              
                                                                        
      * GET REVENUE MONTH                                                       
           MOVE  20                          TO G6-SEQ-NO.              
           MOVE '01'                         TO G6-COMPANY-NO.          
           MOVE 'DATE'                       TO G6-CMND-CODE.           
           MOVE 'COMMON'                     TO G6-PROGRAM-NAME.        
           PERFORM 7160-SELECT-JOB-PARM         THRU 7160-EXIT.         
           MOVE G6-PARM-DATA(15:6)           TO WS-REVENUE-MONTH-JP.    
                                                                        
       6020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6025-EVALUATE-ACCOUNT.                                        *         
      *****************************************************************         
       6025-EVALUATE-ACCOUNT.                                           
                                                                        
           PERFORM 7000-SELECT-ACCT-DETAILS     THRU 7000-EXIT.         
           PERFORM 7005-SELECT-RATE-INFO        THRU 7005-EXIT.         
                                                                        
           MOVE RD-REG-GROUP-CD              TO WS-REGULATED.           
           MOVE FI-OPT-CALC-TYPE-CD          TO WS-OPTION-TYPE.         
                                                                        
      * CHECK FOR DE-REG QUALIFICATION                                          
           PERFORM 6500-QUALIFY-DEREG-SWTCH     THRU 6500-EXIT.         
                                                                        
       6025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6500-QUALIFY-DEREG-SWTCH.                                     *         
      *****************************************************************         
       6500-QUALIFY-DEREG-SWTCH.                                        
                                                                        
           IF REGULATED-GRP2 AND CU-DHR-FL NOT EQUAL 'Y'                
              PERFORM 7250-SELECT-MIN-GOOD-PAY-QTY THRU 7250-EXIT       
              MOVE 1B-MIN-GOOD-PAY-QTY      TO WS-MIN-GOOD-PAY-QTY      
              MOVE 1B-EVAL-MONTHS-QTY       TO WS-HIST-EVAL-MONTHS      
                                                                        
              PERFORM 6700-EXTRACT-PAYMENT-HIST    THRU 6700-EXIT       
              IF WS-NBR-GOOD-PAYMENT >= WS-MIN-GOOD-PAY-QTY             
                 AND WS-NBR-GOOD-PAYMENT GREATER THAN ZEROES            
                     AND WS-MIN-GOOD-PAY-QTY GREATER THAN ZEROES        
                 MOVE 'Y'                   TO WS-678-QUALIFY-DRG-SWTCH 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       6500-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6700-EXTRACT-PAYMENT-HIST.                                    *         
      *****************************************************************         
       6700-EXTRACT-PAYMENT-HIST.                                       
                                                                        
           PERFORM 7255-SELECT-CREDIT-HISTORY   THRU 7255-EXIT.         
           MOVE CZ-DISCONNECT-HIST           TO WS-UTL-CR-HST.          
           MOVE CZ-DISC-EXCEPTN-HIST         TO WS-UTL-EXP-HST.         
           MOVE CZ-ARREARS-HIST              TO WS-UTL-ARRS-HST.        
           MOVE CZ-NON-UTL-CR-HST            TO WS-NON-UTL-CR-HST.      
           MOVE CZ-NON-UTL-CR-HST-EX         TO WS-NON-UTL-EXP-HST.     
           MOVE CZ-NON-UTL-ARRER-HIST        TO WS-NON-UTL-ARRS-HST.    
                                                                        
           IF AT-REV-MTH-LST-NRML EQUAL ZEROES                          
              MOVE WS-REVENUE-MONTH-JP       TO WS-REV-YR-MM            
           ELSE                                                         
              MOVE AT-REV-MTH-LST-NRML       TO WS-REV-YR-MM            
           END-IF.                                                      
                                                                        
           MOVE UT-GAS-BASE-LAST-UPDT        TO WS-GAS-BASE-LAST-UPDT.  
                                                                        
           PERFORM 6896-CHECK-PAYMENT-HISTORY   THRU 6896-EXIT.         
                                                                        
       6700-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7000-SELECT-ACCT-DETAILS.                                     *         
      *****************************************************************         
       7000-SELECT-ACCT-DETAILS.                                        
                                                                        
           EXEC SQL                                                     
              SELECT AT.ACCOUNT_NO                                      
                    ,AT.REV_MTH_LST_NRML                                
                    ,AT.CODE_ACCT_STAT                                  
                    ,AT.COMPANY_NO                                      
                    ,AT.BILL_CYCLE                                      
                    ,CU.DHR_FL                                          
                INTO :AT-ACCOUNT-NO                                     
                    ,:AT-REV-MTH-LST-NRML                               
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-COMPANY-NO                                     
                    ,:AT-BILL-CYCLE                                     
                    ,:CU-DHR-FL                                         
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
                    ,CSS_CUSTOMER CU WITH(READUNCOMMITTED)                      
               WHERE AT.ACCOUNT_NO   = :AT-ACCOUNT-NO                   
                 AND AT.CUSTOMER_NO  = CU.CUSTOMER_NO                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.ACCOUNT_NO                                              
MFA-TR*             ,AT.REV_MTH_LST_NRML                                        
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*             ,AT.BILL_CYCLE                                              
MFA-TR*             ,CU.DHR_FL                                                  
MFA-TR*         INTO :AT-ACCOUNT-NO                                             
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-BILL-CYCLE                                             
MFA-TR*             ,:CU-DHR-FL                                                 
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*             ,CSS_CUSTOMER CU                                            
MFA-TR*        WHERE AT.ACCOUNT_NO   = :AT-ACCOUNT-NO                           
MFA-TR*          AND AT.CUSTOMER_NO  = CU.CUSTOMER_NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7005-SELECT-RATE-INFO                                         *         
      *****************************************************************         
       7005-SELECT-RATE-INFO.                                           
                                                                        
ACT106     MOVE SPACES TO UT-GAS-BASE-LAST-UPDT.                        
           EXEC SQL                                                     
              SELECT UT.GAS_BASE_LAST_UPDT                              
                    ,RD.MKT_PROGRAM_CD                                  
                    ,RD.REG_GROUP_CD                                    
                    ,FI.OPT_CALC_TYPE_CD                                
ACT106         INTO :UT-GAS-BASE-LAST-UPDT :WS-NULL-IND-01              
                   ,:RD-MKT-PROGRAM-CD                                  
                   ,:RD-REG-GROUP-CD                                    
                   ,:FI-OPT-CALC-TYPE-CD                                
               FROM CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)                 
                   ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                 
                   ,CSS_ACCT_RTPK_AGR  DF WITH(READUNCOMMITTED)                 
                   ,CRM_RT_PKG_OPTION  FI WITH(READUNCOMMITTED)                 
              WHERE UT.ACCOUNT_NO         = :UT-ACCOUNT-NO              
                AND UT.CODE_UTIL_TYPE     = 'G'                         
                AND UT.CODE_UTIL_TYPE     = RD.CODE_UTIL_TYPE           
                AND UT.RATE_PLAN_NO       = RD.RATE_PLAN_NO             
                AND UT.ACCOUNT_NO         = DF.ACCOUNT_NO               
                AND UT.CODE_UTIL_TYPE     = DF.CODE_UTIL_TYPE           
                AND UT.IC_NO              = DF.IC_NO                    
                AND UT.RT_PKG_OPT_SEQ_NO  = DF.RT_PKG_OPT_SEQ_NO        
                AND FI.OPTION_CD          = DF.OPTION_CD                
                AND FI.OPT_VSTART_TS      <= CIS.CURRENT$TIMESTAMP()          
                AND FI.OPT_VEND_TS        >= CIS.CURRENT$TIMESTAMP()          
                AND FI.PROC_STATUS_CD     = 'AC'                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UT.GAS_BASE_LAST_UPDT                                      
MFA-TR*             ,RD.MKT_PROGRAM_CD                                          
MFA-TR*             ,RD.REG_GROUP_CD                                            
MFA-TR*             ,FI.OPT_CALC_TYPE_CD                                        
MFA-TR*        INTO :UT-GAS-BASE-LAST-UPDT :WS-NULL-IND-01                      
MFA-TR*            ,:RD-MKT-PROGRAM-CD                                          
MFA-TR*            ,:RD-REG-GROUP-CD                                            
MFA-TR*            ,:FI-OPT-CALC-TYPE-CD                                        
MFA-TR*        FROM CSS_UTIL_ENVRNMT   UT                                       
MFA-TR*            ,CSS_RATE_PLAN_DESC RD                                       
MFA-TR*            ,CSS_ACCT_RTPK_AGR  DF                                       
MFA-TR*            ,CRM_RT_PKG_OPTION  FI                                       
MFA-TR*       WHERE UT.ACCOUNT_NO         = :UT-ACCOUNT-NO                      
MFA-TR*         AND UT.CODE_UTIL_TYPE     = 'G'                                 
MFA-TR*         AND UT.CODE_UTIL_TYPE     = RD.CODE_UTIL_TYPE                   
MFA-TR*         AND UT.RATE_PLAN_NO       = RD.RATE_PLAN_NO                     
MFA-TR*         AND UT.ACCOUNT_NO         = DF.ACCOUNT_NO                       
MFA-TR*         AND UT.CODE_UTIL_TYPE     = DF.CODE_UTIL_TYPE                   
MFA-TR*         AND UT.IC_NO              = DF.IC_NO                            
MFA-TR*         AND UT.RT_PKG_OPT_SEQ_NO  = DF.RT_PKG_OPT_SEQ_NO                
MFA-TR*         AND FI.OPTION_CD          = DF.OPTION_CD                        
MFA-TR*         AND FI.OPT_VSTART_TS      <= CURRENT TIMESTAMP                  
MFA-TR*         AND FI.OPT_VEND_TS        >= CURRENT TIMESTAMP                  
MFA-TR*         AND FI.PROC_STATUS_CD     = 'AC'                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7005'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7160-SELECT-JOB-PARM.                                         *         
      *****************************************************************         
       7160-SELECT-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
              SELECT G6.PARM_DATA                                       
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                      
               WHERE G6.PROGRAM_NAME   = :G6-PROGRAM-NAME               
                 AND G6.CMND_CODE      = :G6-CMND-CODE                  
                 AND G6.COMPANY_NO     = :G6-COMPANY-NO                 
                 AND G6.SEQ_NO         = :G6-SEQ-NO                     
                 AND G6.STATUS         = 'A'                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT G6.PARM_DATA                                               
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM G6                                            
MFA-TR*        WHERE G6.PROGRAM_NAME   = :G6-PROGRAM-NAME                       
MFA-TR*          AND G6.CMND_CODE      = :G6-CMND-CODE                          
MFA-TR*          AND G6.COMPANY_NO     = :G6-COMPANY-NO                         
MFA-TR*          AND G6.SEQ_NO         = :G6-SEQ-NO                             
MFA-TR*          AND G6.STATUS         = 'A'                                    
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7160'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_JOB_PARM'            TO TABLE-1                 
              MOVE 'PROGRAM_NAME'            TO TABLE-ELEMENT-1         
              MOVE 'CMND_CODE'               TO TABLE-ELEMENT-2         
              MOVE G6-PROGRAM-NAME           TO HOSTVAR-ELEMENT-1       
              MOVE G6-CMND-CODE              TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7250-SELECT-MIN-GOOD-PAY-QTY                                  *         
      *****************************************************************         
       7250-SELECT-MIN-GOOD-PAY-QTY.                                    
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) [1B].MIN_GOOD_PAY_QTY,
              [1B].EVAL_MONTHS_QTY                                 
               INTO :1B-MIN-GOOD-PAY-QTY                                
                   ,:1B-EVAL-MONTHS-QTY                                 
               FROM CRM_MKT_TIER_ADJ [1B] WITH(READUNCOMMITTED)                 
              WHERE [1B].ADJ_SOURCE_CD      = 'L'                         
                AND [1B].ADJ_TIER_ACCT_TYPE = '2'                         
                AND [1B].APPLICATION_CD NOT IN ('RT','IG')                
                AND [1B].ADJ_START_DT      <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                
                AND [1B].ADJ_END_DT        >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                
                AND [1B].MIN_GOOD_PAY_QTY   > 0                           
                                                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 1B.MIN_GOOD_PAY_QTY                                        
MFA-TR*             ,1B.EVAL_MONTHS_QTY                                         
MFA-TR*        INTO :1B-MIN-GOOD-PAY-QTY                                        
MFA-TR*            ,:1B-EVAL-MONTHS-QTY                                         
MFA-TR*        FROM CRM_MKT_TIER_ADJ 1B                                         
MFA-TR*       WHERE 1B.ADJ_SOURCE_CD      = 'L'                                 
MFA-TR*         AND 1B.ADJ_TIER_ACCT_TYPE = '2'                                 
MFA-TR*         AND 1B.APPLICATION_CD NOT IN ('RT','IG')                        
MFA-TR*         AND 1B.ADJ_START_DT      <= CURRENT DATE                        
MFA-TR*         AND 1B.ADJ_END_DT        >= CURRENT DATE                        
MFA-TR*         AND 1B.MIN_GOOD_PAY_QTY   > 0                                   
MFA-TR*       FETCH FIRST 1 ROW ONLY                                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7250'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7255-SELECT-CREDIT-HISTORY.                                   *         
      *****************************************************************         
       7255-SELECT-CREDIT-HISTORY.                                      
                                                                        
           EXEC SQL                                                     
              SELECT DISCONNECT_HIST                                    
                    ,DISC_EXCEPTN_HIST                                  
                    ,ARREARS_HIST                                       
                    ,NON_UTL_CR_HST                                     
                    ,NON_UTL_CR_HST_EX                                  
                    ,NON_UTL_ARRER_HIST                                 
                INTO :CZ-DISCONNECT-HIST                                
                    ,:CZ-DISC-EXCEPTN-HIST                              
                    ,:CZ-ARREARS-HIST                                   
                    ,:CZ-NON-UTL-CR-HST                                 
                    ,:CZ-NON-UTL-CR-HST-EX                              
                    ,:CZ-NON-UTL-ARRER-HIST                             
                FROM CSS_CREDIT_PROFILE CZ WITH(READUNCOMMITTED)                
               WHERE CZ.ACCOUNT_NO = :CZ-ACCOUNT-NO                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DISCONNECT_HIST                                            
MFA-TR*             ,DISC_EXCEPTN_HIST                                          
MFA-TR*             ,ARREARS_HIST                                               
MFA-TR*             ,NON_UTL_CR_HST                                             
MFA-TR*             ,NON_UTL_CR_HST_EX                                          
MFA-TR*             ,NON_UTL_ARRER_HIST                                         
MFA-TR*         INTO :CZ-DISCONNECT-HIST                                        
MFA-TR*             ,:CZ-DISC-EXCEPTN-HIST                                      
MFA-TR*             ,:CZ-ARREARS-HIST                                           
MFA-TR*             ,:CZ-NON-UTL-CR-HST                                         
MFA-TR*             ,:CZ-NON-UTL-CR-HST-EX                                      
MFA-TR*             ,:CZ-NON-UTL-ARRER-HIST                                     
MFA-TR*         FROM CSS_CREDIT_PROFILE CZ                                      
MFA-TR*        WHERE CZ.ACCOUNT_NO = :CZ-ACCOUNT-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7255'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CREDIT_PROFILE'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE CZ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7255-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 9910-SQL-ERROR.                                               *         
      *****************************************************************         
       9910-SQL-ERROR.                                                  
                                                                        
           EXIT PROGRAM.                                                
                                                                        
       9910-EXIT.                                                       
           EXIT.                                                        
                                                                        
