      *****************************************************************         
      **  CPD00626 COPYBOOK TO GET ACTIVE MESSAGE FOR AN ACCOUNT     **         
      **.............................................................**         
      **.............................................................**         
      **NOTE: WHEN MODIFYING THIS MEMBER, MEMBER CWS00626 & CWS0626A **         
      **      SHOULD BE EVALUATED FOR CORRESPONDING MODIFICATIONS.   **         
      **.............................................................**         
      **  WS-REFERENCE:  TABLES:     TBACCT                          **         
      **                             TBMVALU                         **         
      **                             TBMPTXT                         **         
      **                             TBSBLMSG                        **         
      **                             TBJBPARM                        **         
      **                             TBBILWDW                        **         
      **                             TBMNHDT                         **         
      **                             TBMNHIST                        **         
      **                             TBUSRPRF                        **         
      **                                                             **         
      **  PREREQUISITES: CWS00626, CWS00327                          **         
      **                                                             **         
      **                                                             **         
      *****************************************************************         
      *****************************************************************         
      *   MODIFICATION LOG -                                          *         
      *                                                               *         
      *   DATE     INITIALS        COMMENTS                           *         
      *  ------    --------        -----------------------------------*         
      * 03/18/09   VY95550         INTIALLY WRITTEN.                  *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 6000-START-PROCESS.                                           *         
      *****************************************************************         
       6000-START-PROCESS.                                              
                                                                        
           INITIALIZE LS-626-OUTPUT-FIELDS                              
                     ,ABEND-FILE                                        
                     ,WS-ACTIVE-RETURN-CODE.                            
                                                                        
           PERFORM 6010-VALIDATE-INPUT          THRU 6010-EXIT          
           PERFORM 6015-MOVE-INPUT              THRU 6015-EXIT          
           PERFORM 6020-PROCESS-INPUT           THRU 6020-EXIT          
           IF WS-626-CALLING-PGM EQUAL WS-PRE-BILLING-PGM               
                           AND AT-REV-MTH-LST-NRML EQUAL ZEROES         
              PERFORM 6030-ACTIVATE-EXPIRED-MSGS                        
                                                THRU 6030-EXIT          
           END-IF.                                                      
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6010-VALIDATE-INPUT.                                          *         
      *****************************************************************         
       6010-VALIDATE-INPUT.                                             
                                                                        
           IF WS-626-ACCOUNT-NO > ZEROES                                
              CONTINUE                                                  
           ELSE                                                         
              MOVE 1010                      TO WS-626-RETURN-CODE      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '6010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'VALIDATE'                TO ABEND-FUNCTION          
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-626-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF                                                       
                                                                        
           IF WS-626-COMPANY-NO > SPACES                                
              CONTINUE                                                  
           ELSE                                                         
              MOVE 1020                      TO WS-626-RETURN-CODE      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '6010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'VALIDATE'                TO ABEND-FUNCTION          
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-626-COMPANY-NO         TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF                                                       
                                                                        
           IF WS-626-CODE-UTIL-TYPE > SPACE OR                          
              ( WS-626-CODE-UTIL-TYPE  = SPACE  AND                     
                WS-626-VALUE-SOURCE-CD = 'A' )                          
              CONTINUE                                                  
           ELSE                                                         
              MOVE 1030                      TO WS-626-RETURN-CODE      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '6010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'VALIDATE'                TO ABEND-FUNCTION          
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE WS-626-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF                                                       
                                                                        
           IF WS-626-VALUE-SOURCE-CD > SPACE                            
              CONTINUE                                                  
           ELSE                                                         
              MOVE 1040                      TO WS-626-RETURN-CODE      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '6010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'VALIDATE'                TO ABEND-FUNCTION          
              MOVE 'VALUE_SOURCE_CD'         TO TABLE-ELEMENT-1         
              MOVE WS-626-VALUE-SOURCE-CD    TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF                                                       
                                                                        
           IF WS-626-VALUE-CD > SPACES OR WS-626-PREV-VALUE-CD > SPACES 
              CONTINUE                                                  
           ELSE                                                         
              MOVE 1050                      TO WS-626-RETURN-CODE      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '6010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'VALIDATE'                TO ABEND-FUNCTION          
              MOVE 'VALUE_CD'                TO TABLE-ELEMENT-1         
              MOVE WS-626-VALUE-CD           TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF                                                       
                                                                        
           IF WS-626-VALUE-CD NOT EQUAL WS-626-PREV-VALUE-CD            
              CONTINUE                                                  
           ELSE                                                         
              MOVE 1060                      TO WS-626-RETURN-CODE      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '6010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'VALIDATE'                TO ABEND-FUNCTION          
              MOVE 'VALUE_CD'                TO TABLE-ELEMENT-1         
              MOVE WS-626-VALUE-CD           TO HOSTVAR-ELEMENT-1       
              MOVE 'PREV_VALUE_CD'           TO TABLE-ELEMENT-2         
              MOVE WS-626-PREV-VALUE-CD      TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       6010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6015-MOVE-INPUT.                                              *         
      *****************************************************************         
       6015-MOVE-INPUT.                                                 
                                                                        
           MOVE WS-626-ACCOUNT-NO            TO AT-ACCOUNT-NO           
                                                U1-ACCOUNT-NO           
           MOVE WS-626-COMPANY-NO            TO PI-COMPANY-NO           
                                                U1-COMPANY-NO           
           MOVE WS-626-CODE-UTIL-TYPE        TO PI-CODE-UTIL-TYPE       
           MOVE WS-626-VALUE-SOURCE-CD       TO PI-VALUE-SOURCE-CD      
           MOVE WS-626-VALUE-CD              TO PI-VALUE-CD             
                                                                        
           IF WS-626-PREV-VALUE-CD > SPACES                             
              MOVE WS-626-PREV-VALUE-CD      TO PI-PREV-VALUE-CD        
           ELSE                                                         
              MOVE SPACES                    TO PI-PREV-VALUE-CD        
           END-IF.                                                      
                                                                        
       6015-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6020-PROCESS-INPUT.                                           *         
      *****************************************************************         
       6020-PROCESS-INPUT.                                              
                                                                        
           PERFORM 7000-GET-ACCOUNT-INFO        THRU 7000-EXIT          
                                                                        
           IF WS-626-CODE-ACCT-STAT > SPACE                             
              MOVE WS-626-CODE-ACCT-STAT     TO WS-TEMP-CODE-ACCT-STAT  
           ELSE                                                         
              MOVE AT-CODE-ACCT-STAT         TO WS-TEMP-CODE-ACCT-STAT  
           END-IF                                                       
                                                                        
           PERFORM 6200-SET-REV-MONTH-DT        THRU 6200-EXIT          
           PERFORM 6300-GET-ACTIVE-MSG-PLAN     THRU 6300-EXIT.         
                                                                        
       6020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6030-ACTIVATE-EXPIRED-MSGS.                                   *         
      *****************************************************************         
       6030-ACTIVATE-EXPIRED-MSGS.                                      
                                                                        
           MOVE WS-REV-MONTH-YR          TO WS-TEMP-YR-N                
           MOVE WS-REV-MONTH-MT          TO WS-TEMP-MT-N                
           MOVE WS-TEMP-MONTH-N          TO WS-TEMP-REV-MONTH           
           MOVE WS-TEMP-REV-MONTH        TO WS-CURR-REV-MONTH           
                                                                        
           MOVE 'N'                      TO WS-EXPIRED-ROWS             
           MOVE SPACES                   TO WS-PREV-BILL-MSG-ID         
                                                                        
           PERFORM 7300-OPEN-EXPIRED-CUR        THRU 7300-EXIT          
           PERFORM 7310-FETCH-EXPIRED-CUR       THRU 7310-EXIT          
                                                                        
           PERFORM 6035-PROCESS-EXPIRED-MSGS    THRU 6035-EXIT          
                                                UNTIL NO-EXPIRED-ROWS   
                                                                        
           PERFORM 7320-CLOSE-EXPIRED-CUR       THRU 7320-EXIT.         
                                                                        
       6030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6035-PROCESS-EXPIRED-MSGS.                                    *         
      *****************************************************************         
       6035-PROCESS-EXPIRED-MSGS.                                       
                                                                        
           MOVE U1-REVENUE-MO-ST             TO WS-REVENUE-MO-ST        
           MOVE U1-REVENUE-MO-END            TO WS-REVENUE-MO-END       
           MOVE 'N'                          TO WS-UPDATE-REV-MO-FLAG   
                                                                        
           IF P2-BILL-MSG-ID NOT EQUAL WS-PREV-BILL-MSG-ID              
              MOVE P2-BILL-MSG-ID            TO WS-PREV-BILL-MSG-ID     
              MOVE WS-CURR-REV-MONTH         TO U1-REVENUE-MO-ST        
                                                                        
              IF WS-REVENUE-MO-ST = WS-REVENUE-MO-END                   
                 MOVE 0                      TO WS-MONTHS-TO-ADD        
              ELSE                                                      
                 MOVE '01'                   TO WS-REV-MONTH-DT         
                 MOVE 0                      TO WS-MONTHS-DIFF          
                                                                        
                 MOVE WS-REVENUE-MO-ST       TO WS-TEMP-REV-MONTH       
                 MOVE WS-TEMP-REV-MONTH      TO WS-TEMP-MONTH-N         
                 MOVE WS-TEMP-YR-N           TO WS-REV-MONTH-YR         
                 MOVE WS-TEMP-MT-N           TO WS-REV-MONTH-MT         
                 MOVE WS-REV-MONTH-DATE      TO WS-START-DATE           
                                                                        
                 MOVE WS-REVENUE-MO-END      TO WS-TEMP-REV-MONTH       
                 MOVE WS-TEMP-REV-MONTH      TO WS-TEMP-MONTH-N         
                 MOVE WS-TEMP-YR-N           TO WS-REV-MONTH-YR         
                 MOVE WS-TEMP-MT-N           TO WS-REV-MONTH-MT         
                 MOVE WS-REV-MONTH-DATE      TO WS-END-DATE             
                                                                        
                 PERFORM 7060-GET-MONTHS-DIFF   THRU 7060-EXIT          
                                                                        
                 MOVE WS-MONTHS-DIFF         TO WS-MONTHS-TO-ADD        
              END-IF                                                    
                                                                        
              IF WS-MONTHS-TO-ADD = 0                                   
                 MOVE WS-CURR-REV-MONTH      TO U1-REVENUE-MO-END       
              ELSE                                                      
                 MOVE WS-CURR-REV-MONTH      TO WS-INPUT-REV-MONTH-N    
                 MOVE WS-INPUT-REV-MONTH-N   TO WS-INPUT-REV-MONTH-C    
                                                                        
                 PERFORM 6205-ADD-REV-MONTHS    THRU 6205-EXIT          
                                                                        
                 MOVE WS-INPUT-REV-MONTH-C(1:4) TO WS-TEMP-YR-N         
                 MOVE WS-INPUT-REV-MONTH-C(5:2) TO WS-TEMP-MT-N         
                 MOVE WS-TEMP-MONTH-N           TO WS-TEMP-REV-MONTH    
                 MOVE WS-TEMP-REV-MONTH         TO U1-REVENUE-MO-END    
              END-IF                                                    
                                                                        
              MOVE P2-BILL-MSG-ID            TO U1-BILL-MSG-ID          
              MOVE P2-MSG-TYPE-CD            TO U1-MSG-TYPE-CD          
              MOVE 1                         TO U1-BILL-CYCLE-ST        
              MOVE 21                        TO U1-BILL-CYCLE-END       
                                                                        
              IF WS-626-DB2-UPDATE-FLAG = 'Y' AND                       
                 P2-BILL-MSG-ID NOT = SPACES                            
                 SET UPDATE-BOTH-REV-MO      TO TRUE                    
                 PERFORM 6526-UPD-MSG-TRANS-DET   THRU 6526-EXIT        
                 PERFORM 8120-UPDATE-BOTH-REV-MO  THRU 8120-EXIT        
              END-IF                                                    
           END-IF                                                       
                                                                        
           PERFORM 7310-FETCH-EXPIRED-CUR       THRU 7310-EXIT.         
                                                                        
       6035-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6200-SET-REV-MONTH-DT.                                        *         
      *****************************************************************         
       6200-SET-REV-MONTH-DT.                                           
                                                                        
           MOVE '01'                         TO WS-REV-MONTH-DT         
           MOVE 1                            TO WS-SUB-R                
                                                                        
           IF WS-626-MSG-REV-MONTH > ZEROS                              
              MOVE WS-626-MSG-REV-MONTH(1:4) TO WS-REV-MONTH-YR         
              MOVE WS-626-MSG-REV-MONTH(5:2) TO WS-REV-MONTH-MT         
           ELSE                                                         
              IF AT-REV-MTH-LST-NRML > ZEROS                            
                 MOVE AT-REV-MTH-LST-NRML    TO WS-INPUT-REV-MONTH-N    
                 MOVE WS-INPUT-REV-MONTH-N   TO WS-INPUT-REV-MONTH-C    
                 MOVE 1                      TO WS-MONTHS-TO-ADD        
                 PERFORM 6205-ADD-REV-MONTHS    THRU 6205-EXIT          
                 MOVE WS-INPUT-REV-MONTH-C(1:4) TO WS-REV-MONTH-YR      
                 MOVE WS-INPUT-REV-MONTH-C(5:2) TO WS-REV-MONTH-MT      
              ELSE                                                      
                 MOVE  10                      TO G6-SEQ-NO             
                 MOVE '01'                     TO G6-COMPANY-NO         
                 MOVE 'DATE'                   TO G6-CMND-CODE          
                 MOVE 'COMMON'                 TO G6-PROGRAM-NAME       
                                                                        
                 PERFORM 7010-SELECT-JOB-PARM   THRU 7010-EXIT          
                 MOVE G6-PARM-DATA(10:10)      TO BN-DATE-EXTRACT       
                 MOVE AT-BILL-CYCLE            TO BN-BILL-CYCLE         
                                                                        
                 PERFORM 7020-GET-MIN-REV-MONTH THRU 7020-EXIT          
                 MOVE BN-REVENUE-MONTH         TO WS-TEMP-REV-MONTH     
                 MOVE WS-TEMP-REV-MONTH        TO WS-TEMP-MONTH-N       
                 MOVE WS-TEMP-YR-N             TO WS-REV-MONTH-YR       
                 MOVE WS-TEMP-MT-N             TO WS-REV-MONTH-MT       
              END-IF                                                    
           END-IF                                                       
                                                                        
           MOVE WS-REV-MONTH-DATE            TO WS-CURR-REV-MONTH-DATE. 
                                                                        
       6200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6205-ADD-REV-MONTHS.                                          *         
      *     STPE UP N NUMBER OF MONTHS                                *         
      *****************************************************************         
       6205-ADD-REV-MONTHS.                                             
                                                                        
           MOVE 1                            TO WS-SUB-MT               
           PERFORM 6210-STEP-UP-ONE-MONTH       THRU 6210-EXIT          
             UNTIL WS-SUB-MT > WS-MONTHS-TO-ADD                         
           .                                                            
       6205-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6210-STEP-UP-ONE-MONTH.                                       *         
      *     STEP UP ONE MONTH FROM THE LAST REVENUE MONTH             *         
      *****************************************************************         
       6210-STEP-UP-ONE-MONTH.                                          
                                                                        
           ADD 1                             TO WS-SUB-MT               
           MOVE WS-INPUT-REV-MONTH-C(1:4)    TO WS-TEMP-YR              
           MOVE WS-INPUT-REV-MONTH-C(5:2)    TO WS-TEMP-MT              
                                                                        
           MOVE WS-TEMP-YR                   TO WS-TEMP-YR-N            
           MOVE WS-TEMP-MT                   TO WS-TEMP-MT-N            
                                                                        
           COMPUTE WS-TEMP-MT-N = WS-TEMP-MT-N + 1                      
                                                                        
           IF WS-TEMP-MT-N > 12                                         
              COMPUTE WS-TEMP-YR-N = WS-TEMP-YR-N + 1                   
              MOVE 01                        TO WS-TEMP-MT-N            
           END-IF                                                       
                                                                        
           MOVE WS-TEMP-YR-N               TO WS-INPUT-REV-MONTH-C(1:4) 
           MOVE WS-TEMP-MT-N               TO WS-INPUT-REV-MONTH-C(5:2) 
           .                                                            
                                                                        
       6210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6300-GET-ACTIVE-MSG-PLAN.                                     *         
      *****************************************************************         
       6300-GET-ACTIVE-MSG-PLAN.                                        
                                                                        
           MOVE 'N'                          TO WS-MSG-CD-ROWS          
           PERFORM 7200-OPEN-MSG-CD-CUR         THRU 7200-EXIT          
           PERFORM 7210-FETCH-MSG-CD-CUR        THRU 7210-EXIT          
                                                                        
           PERFORM 6500-PROCESS-MSG-TX          THRU 6500-EXIT          
                                                UNTIL NO-MSG-CD-ROWS    
                                                                        
           PERFORM 7220-CLOSE-MSG-CD-CUR        THRU 7220-EXIT.         
                                                                        
       6300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6500-PROCESS-MSG-TX.                                          *         
      *****************************************************************         
       6500-PROCESS-MSG-TX.                                             
                                                                        
           MOVE WS-REV-MONTH-YR             TO WS-INPUT-REV-MONTH-C(1:4)
                                               WS-TEMP-YR-N             
           MOVE WS-REV-MONTH-MT             TO WS-INPUT-REV-MONTH-C(5:2)
                                               WS-TEMP-MT-N             
                                                                        
           IF P2-MSG-DURATION-CD EQUAL WS-REVENUE-MONTHS                
              MOVE WS-TEMP-MONTH-N           TO WS-TEMP-REV-MONTH       
              MOVE WS-TEMP-REV-MONTH         TO U1-REVENUE-MO-ST        
              MOVE P2-MSG-DURATION-NO        TO WS-MONTHS-TO-ADD        
                                                                        
              IF WS-MONTHS-TO-ADD > 0                                   
                 COMPUTE WS-MONTHS-TO-ADD = WS-MONTHS-TO-ADD - 1        
              END-IF                                                    
                                                                        
              PERFORM 6205-ADD-REV-MONTHS       THRU 6205-EXIT          
              MOVE WS-INPUT-REV-MONTH-C(1:4) TO WS-TEMP-YR-N            
              MOVE WS-INPUT-REV-MONTH-C(5:2) TO WS-TEMP-MT-N            
              MOVE WS-TEMP-MONTH-N           TO WS-TEMP-REV-MONTH       
              MOVE WS-TEMP-REV-MONTH         TO U1-REVENUE-MO-END       
           ELSE                                                         
              MOVE WS-TEMP-MONTH-N           TO WS-TEMP-REV-MONTH       
              MOVE WS-TEMP-REV-MONTH         TO U1-REVENUE-MO-ST        
                                                                        
              IF P2-MSG-DURATION-CD EQUAL WS-NEVER-ENDS                 
                 MOVE 299912                 TO U1-REVENUE-MO-END       
              ELSE                                                      
                 MOVE WS-TEMP-REV-MONTH      TO U1-REVENUE-MO-END       
              END-IF                                                    
           END-IF                                                       
                                                                        
           MOVE 'N'                          TO WS-UPDATE-FLAG          
                                                                        
           IF WS-626-VALUE-CD > SPACES                                  
              IF ((PI-VALUE-CD = WS-626-VALUE-CD AND                    
                           PI-PREV-VALUE-CD = SPACES ) OR               
                  (PI-VALUE-CD = WS-626-VALUE-CD AND                    
                           PI-PREV-VALUE-CD = WS-626-PREV-VALUE-CD) )   
                 EVALUATE P2-MSG-APPL-CD                                
                     WHEN WS-ALL-ACCOUNTS                               
                          SET INSERT-SPCL-BILL-MSG    TO TRUE           
                     WHEN WS-INITIAL-BILL-INSERT                        
                          IF AT-REV-MTH-LST-NRML EQUAL ZEROES           
                             SET INSERT-SPCL-BILL-MSG TO TRUE           
                          END-IF                                        
                     WHEN WS-FINAL-BILL-INSERT                          
                          IF WS-TEMP-CODE-ACCT-STAT = 'B'               
                             SET INSERT-SPCL-BILL-MSG TO TRUE           
                          END-IF                                        
                     WHEN WS-NEW-BILL-FOR-EXIST                         
                          IF AT-REV-MTH-LST-NRML > ZEROES               
                             SET INSERT-SPCL-BILL-MSG TO TRUE           
                          END-IF                                        
                 END-EVALUATE                                           
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF WS-626-PREV-VALUE-CD > SPACES                             
              IF ((PI-VALUE-CD = SPACES AND                             
                           PI-PREV-VALUE-CD = WS-626-PREV-VALUE-CD) OR  
                  (PI-VALUE-CD = WS-626-VALUE-CD AND                    
                           PI-PREV-VALUE-CD = WS-626-PREV-VALUE-CD) )   
                 EVALUATE P2-MSG-APPL-CD                                
                     WHEN WS-DEL-PREV-VALUE                             
                          SET DELETE-SPCL-BILL-MSG TO TRUE              
                 END-EVALUATE                                           
              END-IF                                                    
           END-IF                                                       
                                                                        
           MOVE P2-BILL-MSG-ID               TO U1-BILL-MSG-ID          
           MOVE P2-MSG-TYPE-CD               TO U1-MSG-TYPE-CD          
           MOVE 1                            TO U1-BILL-CYCLE-ST        
           MOVE 21                           TO U1-BILL-CYCLE-END       
                                                                        
           IF INSERT-SPCL-BILL-MSG OR DELETE-SPCL-BILL-MSG              
              PERFORM 6505-INSERT-RETURN-TABLE  THRU 6505-EXIT          
           END-IF                                                       
                                                                        
           IF WS-626-DB2-UPDATE-FLAG = 'Y' AND                          
              P2-BILL-MSG-ID NOT = SPACES                               
                                                                        
              EVALUATE TRUE                                             
                  WHEN INSERT-SPCL-BILL-MSG                             
                       PERFORM 6501-VALIDATE-AND-INSERT                 
                          THRU 6501-EXIT                                
                  WHEN DELETE-SPCL-BILL-MSG                             
                       PERFORM 6502-VALIDATE-AND-DELETE                 
                          THRU 6502-EXIT                                
              END-EVALUATE                                              
           END-IF                                                       
                                                                        
           PERFORM 7210-FETCH-MSG-CD-CUR        THRU 7210-EXIT.         
                                                                        
       6500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6501-VALIDATE-AND-INSERT.                                     *         
      *****************************************************************         
       6501-VALIDATE-AND-INSERT.                                        
                                                                        
            MOVE 0                           TO WS-REVENUE-MO-ST        
                                                WS-REVENUE-MO-END       
            MOVE 'N'                         TO WS-UPDATE-REV-MO-FLAG   
                                                                        
            PERFORM 7050-SELECT-MSG-REV-MONTH   THRU 7050-EXIT          
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               IF U1-REVENUE-MO-ST     < WS-REVENUE-MO-ST               
                  IF U1-REVENUE-MO-END < WS-REVENUE-MO-ST               
                     SET INSERT-NEW-ROW      TO TRUE                    
                  ELSE                                                  
                     IF U1-REVENUE-MO-END <= WS-REVENUE-MO-END          
                        SET UPDATE-REV-MO-ST TO TRUE                    
                     ELSE                                               
                        SET UPDATE-BOTH-REV-MO                          
                                             TO TRUE                    
                     END-IF                                             
                  END-IF                                                
               ELSE                                                     
                  IF U1-REVENUE-MO-ST <= WS-REVENUE-MO-END              
                     IF U1-REVENUE-MO-END <= WS-REVENUE-MO-END          
                        MOVE 'N'             TO WS-UPDATE-REV-MO-FLAG   
                     ELSE                                               
                        SET UPDATE-REV-MO-END TO TRUE                   
                     END-IF                                             
                  ELSE                                                  
                     IF AT-REV-MTH-LST-NRML EQUAL ZEROES                
                        SET UPDATE-BOTH-REV-MO                          
                                             TO TRUE                    
                     ELSE                                               
                        SET INSERT-NEW-ROW   TO TRUE                    
                     END-IF                                             
                  END-IF                                                
               END-IF                                                   
            ELSE                                                        
               SET INSERT-NEW-ROW            TO TRUE                    
            END-IF                                                      
                                                                        
            EVALUATE TRUE                                               
                WHEN INSERT-NEW-ROW                                     
                     PERFORM 6520-INS-MSG-TRANS-DET                     
                        THRU 6520-EXIT                                  
                     PERFORM 8100-INSERT-BILL-MSG                       
                        THRU 8100-EXIT                                  
                WHEN UPDATE-BOTH-REV-MO                                 
                     PERFORM 6526-UPD-MSG-TRANS-DET                     
                        THRU 6526-EXIT                                  
                     PERFORM 8120-UPDATE-BOTH-REV-MO                    
                        THRU 8120-EXIT                                  
                WHEN UPDATE-REV-MO-ST                                   
                     PERFORM 6526-UPD-MSG-TRANS-DET                     
                        THRU 6526-EXIT                                  
                     PERFORM 8130-UPDATE-START-REV-MO                   
                        THRU 8130-EXIT                                  
                WHEN UPDATE-REV-MO-END                                  
                     PERFORM 6526-UPD-MSG-TRANS-DET                     
                        THRU 6526-EXIT                                  
                     PERFORM 8140-UPDATE-END-REV-MO                     
                        THRU 8140-EXIT                                  
            END-EVALUATE.                                               
                                                                        
       6501-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6502-VALIDATE-AND-DELETE.                                     *         
      *     DELETE ONLY THE ACTIVE MESSAGES WHEN MSG-APPL-CD = 'DPR'  *         
      *****************************************************************         
       6502-VALIDATE-AND-DELETE.                                        
                                                                        
           MOVE 0                            TO WS-REVENUE-MO-ST        
                                                WS-REVENUE-MO-END       
                                                                        
           PERFORM 7050-SELECT-MSG-REV-MONTH    THRU 7050-EXIT          
                                                                        
           IF WS-REVENUE-MO-ST  < U1-REVENUE-MO-ST AND                  
              WS-REVENUE-MO-END < U1-REVENUE-MO-ST                      
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 6525-DEL-MSG-TRANS-DET THRU 6525-EXIT             
              PERFORM 8110-DELETE-BILL-MSG   THRU 8110-EXIT             
           END-IF.                                                      
                                                                        
       6502-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6505-INSERT-RETURN-TABLE.                                     *         
      *****************************************************************         
       6505-INSERT-RETURN-TABLE.                                        
                                                                        
           MOVE P2-BILL-MSG-ID         TO WS-RET-BILL-MSG-ID (WS-SUB-R) 
                                                                        
           IF P2-MSG-TX-TEXT > SPACE                                    
              MOVE P2-MSG-TX-TEXT(1:P2-MSG-TX-LEN)                      
                                       TO WS-RET-MSG-TX (WS-SUB-R)      
           ELSE                                                         
              MOVE SPACES              TO WS-RET-MSG-TX (WS-SUB-R)      
           END-IF                                                       
                                                                        
           MOVE P2-MSG-START-DT        TO WS-RET-MSG-START-DT (WS-SUB-R)
           MOVE P2-MSG-END-DT          TO WS-RET-MSG-END-DT (WS-SUB-R)  
           MOVE P2-MSG-APPL-CD         TO WS-RET-MSG-APPL-CD (WS-SUB-R) 
           MOVE P2-MSG-SHORT-DESC      TO                               
                                      WS-RET-MSG-SHORT-DESC (WS-SUB-R)  
                                                                        
           ADD 1                       TO WS-SUB-R.                     
                                                                        
       6505-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6510-MOVE-TRANS-HDR-DETAILS.                                  *         
      *****************************************************************         
       6510-MOVE-TRANS-HDR-DETAILS.                                     
                                                                        
           PERFORM 7030-SELECT-MH-DATE-TIME     THRU 7030-EXIT          
           MOVE MH-TRANS-HIST-SEQ-NO         TO MI-TRANS-HIST-SEQ-NO    
           MOVE 'F'                          TO MH-CODE-TRAN-TYPE       
           MOVE WS-626-ACCOUNT-NO            TO MH-ACCOUNT-NO           
           MOVE ZEROS                        TO MH-CUSTOMER-NO          
                                                MH-PREMISE-NO           
           IF WS-626-USER-ID > SPACES                                   
              MOVE WS-626-USER-ID            TO MH-USER-ID              
           ELSE                                                         
              MOVE 'SYSTEM'                  TO MH-USER-ID              
           END-IF                                                       
                                                                        
           MOVE MH-USER-ID                   TO PF-USER-ID              
           PERFORM 7040-SELECT-RESP-AREA-ID     THRU 7040-EXIT          
                                                                        
           MOVE PF-RESP-AREA-ID              TO MH-RESP-AREA-ID         
                                                                        
           IF WS-626-CALLING-PGM > LOW-VALUES AND                       
              WS-626-CALLING-PGM > SPACES                               
              MOVE WS-626-CALLING-PGM        TO MH-APPL-PROGRAM-ID      
           ELSE                                                         
              MOVE PROGRAM-NAME              TO MH-APPL-PROGRAM-ID      
           END-IF                                                       
                                                                        
           STRING 'BILL MESSAGE: '      DELIMITED BY SIZE               
                  P2-MSG-SHORT-DESC     DELIMITED BY SIZE               
             INTO MH-TRAN-COMMENT-TEXT                                  
           END-STRING                                                   
                                                                        
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                             TO MH-TRAN-COMMENT-LEN.    
                                                                        
       6510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6520-INS-MSG-TRANS-DET                                        *         
      *****************************************************************         
       6520-INS-MSG-TRANS-DET.                                          
                                                                        
           MOVE SPACES                       TO MI-TABLE-ID             
           MOVE +14                          TO MI-PRV-COLUMN-VALUE-LEN 
           MOVE '** INSERTED **'             TO MI-PRV-COLUMN-VALUE-TEXT
           MOVE 1                            TO WS-TRAN-APPL-NO         
      *                                                                         
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO         
           MOVE 'BILL MESSAGE'               TO MI-COLUMN-DESC          
           MOVE U1-BILL-MSG-ID               TO MI-CHG-COLUMN-VALUE-TEXT
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                             TO MI-CHG-COLUMN-VALUE-LEN 
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
           ADD 1                             TO WS-TRAN-APPL-NO         
      *                                                                         
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO         
           MOVE 'REV MONTH START'            TO MI-COLUMN-DESC          
           MOVE U1-REVENUE-MO-ST             TO MI-CHG-COLUMN-VALUE-TEXT
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                             TO MI-CHG-COLUMN-VALUE-LEN 
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
           ADD 1                             TO WS-TRAN-APPL-NO         
      *                                                                         
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO         
           MOVE 'REV MONTH END'              TO MI-COLUMN-DESC          
           MOVE U1-REVENUE-MO-END            TO MI-CHG-COLUMN-VALUE-TEXT
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                             TO MI-CHG-COLUMN-VALUE-LEN 
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
                                                                        
       6520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6525-DEL-MSG-TRANS-DET                                        *         
      *****************************************************************         
       6525-DEL-MSG-TRANS-DET.                                          
                                                                        
           MOVE SPACES                       TO MI-TABLE-ID             
           MOVE +14                          TO MI-CHG-COLUMN-VALUE-LEN 
           MOVE '** DELETED  **'             TO MI-CHG-COLUMN-VALUE-TEXT
           MOVE 1                            TO WS-TRAN-APPL-NO         
      *                                                                         
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO         
           MOVE 'BILL MESSAGE'               TO MI-COLUMN-DESC          
           MOVE U1-BILL-MSG-ID               TO MI-PRV-COLUMN-VALUE-TEXT
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                             TO MI-PRV-COLUMN-VALUE-LEN 
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
           ADD 1                             TO WS-TRAN-APPL-NO         
      *                                                                         
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO         
           MOVE 'REV MONTH START'            TO MI-COLUMN-DESC          
           MOVE WS-REVENUE-MO-ST             TO MI-PRV-COLUMN-VALUE-TEXT
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                             TO MI-PRV-COLUMN-VALUE-LEN 
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT          
           ADD 1                             TO WS-TRAN-APPL-NO         
      *                                                                         
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO         
           MOVE 'REV MONTH END'              TO MI-COLUMN-DESC          
           MOVE WS-REVENUE-MO-END            TO MI-PRV-COLUMN-VALUE-TEXT
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                             TO MI-PRV-COLUMN-VALUE-LEN 
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
                                                                        
       6525-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6526-UPD-MSG-TRANS-DET                                        *         
      *****************************************************************         
       6526-UPD-MSG-TRANS-DET.                                          
                                                                        
           MOVE SPACES                         TO MI-TABLE-ID           
           MOVE 1                              TO WS-TRAN-APPL-NO       
                                                                        
           IF ( UPDATE-BOTH-REV-MO OR UPDATE-REV-MO-ST OR               
                UPDATE-REV-MO-END )                                     
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              MOVE 'BILL MESSAGE'            TO MI-COLUMN-DESC          
              MOVE U1-BILL-MSG-ID            TO MI-PRV-COLUMN-VALUE-TEXT
              MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                   
                                             TO MI-PRV-COLUMN-VALUE-LEN 
              MOVE U1-BILL-MSG-ID            TO MI-CHG-COLUMN-VALUE-TEXT
              MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                   
                                             TO MI-CHG-COLUMN-VALUE-LEN 
              PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT       
              ADD 1                          TO WS-TRAN-APPL-NO         
           END-IF                                                       
                                                                        
           IF UPDATE-BOTH-REV-MO OR UPDATE-REV-MO-ST                    
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              MOVE 'REV MONTH START'         TO MI-COLUMN-DESC          
              MOVE WS-REVENUE-MO-ST          TO MI-PRV-COLUMN-VALUE-TEXT
              MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                   
                                             TO MI-PRV-COLUMN-VALUE-LEN 
              MOVE U1-REVENUE-MO-ST          TO MI-CHG-COLUMN-VALUE-TEXT
              MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                   
                                             TO MI-CHG-COLUMN-VALUE-LEN 
              PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT       
              ADD 1                          TO WS-TRAN-APPL-NO         
           END-IF                                                       
                                                                        
           IF UPDATE-BOTH-REV-MO OR UPDATE-REV-MO-END                   
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              MOVE 'REV MONTH END'           TO MI-COLUMN-DESC          
              MOVE WS-REVENUE-MO-END         TO MI-PRV-COLUMN-VALUE-TEXT
              MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                   
                                             TO MI-PRV-COLUMN-VALUE-LEN 
              MOVE U1-REVENUE-MO-END         TO MI-CHG-COLUMN-VALUE-TEXT
              MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                   
                                             TO MI-CHG-COLUMN-VALUE-LEN 
              PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT       
           END-IF.                                                      
                                                                        
       6526-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6530-LOAD-MNT-TRANS-HIST.                                     *         
      *****************************************************************         
       6530-LOAD-MNT-TRANS-HIST.                                        
                                                                        
           IF MI-TRAN-APPL-NO EQUAL 1                                   
              PERFORM 6510-MOVE-TRANS-HDR-DETAILS THRU 6510-EXIT        
              PERFORM 8600-INSERT-MNT-TRANS-HIST THRU 8600-EXIT         
              PERFORM 8610-INSERT-MT-TRN-HST-DET THRU 8610-EXIT         
           ELSE                                                         
              PERFORM 8610-INSERT-MT-TRN-HST-DET THRU 8610-EXIT         
           END-IF.                                                      
                                                                        
       6530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7000-GET-ACCOUNT-INFO.                                        *         
      *****************************************************************         
       7000-GET-ACCOUNT-INFO.                                           
                                                                        
           EXEC SQL                                                     
              SELECT AT.REV_MTH_LST_NRML                                
                    ,AT.CODE_ACCT_STAT                                  
                    ,AT.BILL_CYCLE                                      
                INTO :AT-REV-MTH-LST-NRML                               
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-BILL-CYCLE                                     
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.REV_MTH_LST_NRML                                        
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.BILL_CYCLE                                              
MFA-TR*         INTO :AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-BILL-CYCLE                                             
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO WS-626-RETURN-CODE      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7010-SELECT-JOB-PARM.                                         *         
      *****************************************************************         
       7010-SELECT-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
              SELECT G6.PARM_DATA                                       
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                      
               WHERE G6.PROGRAM_NAME   = :G6-PROGRAM-NAME               
                 AND G6.CMND_CODE      = :G6-CMND-CODE                  
                 AND G6.COMPANY_NO     = :G6-COMPANY-NO                 
                 AND G6.SEQ_NO         = :G6-SEQ-NO                     
                 AND G6.STATUS         = 'A'                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT G6.PARM_DATA                                               
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM G6                                            
MFA-TR*        WHERE G6.PROGRAM_NAME   = :G6-PROGRAM-NAME                       
MFA-TR*          AND G6.CMND_CODE      = :G6-CMND-CODE                          
MFA-TR*          AND G6.COMPANY_NO     = :G6-COMPANY-NO                         
MFA-TR*          AND G6.SEQ_NO         = :G6-SEQ-NO                             
MFA-TR*          AND G6.STATUS         = 'A'                                    
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_JOB_PARM'            TO TABLE-1                 
              MOVE 'PROGRAM_NAME'            TO TABLE-ELEMENT-1         
              MOVE 'CMND_CODE'               TO TABLE-ELEMENT-2         
              MOVE G6-PROGRAM-NAME           TO HOSTVAR-ELEMENT-1       
              MOVE G6-CMND-CODE              TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7020-GET-MIN-REV-MONTH.                                       *         
      *****************************************************************         
       7020-GET-MIN-REV-MONTH.                                          
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) BN.REVENUE_MONTH                                  
                 INTO :BN-REVENUE-MONTH                                 
                 FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                  
                WHERE BN.DATE_EXTRACT >= IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )               
                  AND BN.BILL_CYCLE    = :BN-BILL-CYCLE                 
                ORDER BY BN.REVENUE_MONTH                               
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BN.REVENUE_MONTH                                          
MFA-TR*          INTO :BN-REVENUE-MONTH                                         
MFA-TR*          FROM CSS_BILL_WINDOW BN                                        
MFA-TR*         WHERE BN.DATE_EXTRACT >= :BN-DATE-EXTRACT                       
MFA-TR*           AND BN.BILL_CYCLE    = :BN-BILL-CYCLE                         
MFA-TR*         ORDER BY BN.REVENUE_MONTH                                       
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BILL_WINDOW'         TO TABLE-1                 
              MOVE 'DATE_EXTRACT'            TO TABLE-ELEMENT-1         
              MOVE 'BILL_CYCLE'              TO TABLE-ELEMENT-2         
              MOVE BN-DATE-EXTRACT           TO HOSTVAR-ELEMENT-1       
              MOVE BN-BILL-CYCLE             TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7030-SELECT-MH-DATE-TIME.                                     *         
      *****************************************************************         
       7030-SELECT-MH-DATE-TIME.                                        
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*          ,:MH-DATE-TRANS        = CURRENT DATE                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7030'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SET'                     TO ABEND-FUNCTION          
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7040-SELECT-RESP-AREA-ID.                                     *         
      *     GET THE USER'S ASSOCIATED AREA ID BASED ON USERID.        *         
      *****************************************************************         
       7040-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT PF.RESP_AREA_ID                                    
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                  
               WHERE PF.USER_ID = :PF-USER-ID                           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PF.RESP_AREA_ID                                            
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE PF                                        
MFA-TR*        WHERE PF.USER_ID = :PF-USER-ID                                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7040'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_USER_PROFILE'        TO TABLE-1                 
              MOVE 'USER_ID'                 TO TABLE-ELEMENT-1         
              MOVE PF-USER-ID                TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7050-SELECT-MSG-REV-MONTH.                                    *         
      *****************************************************************         
       7050-SELECT-MSG-REV-MONTH.                                       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) REVENUE_MO_ST,
              REVENUE_MO_END                                    
                 INTO :WS-REVENUE-MO-ST                                 
                     ,:WS-REVENUE-MO-END                                
                 FROM CSS_SPCL_BILL_MSG U1 WITH(READUNCOMMITTED)                
                WHERE U1.BILL_MSG_ID    = :U1-BILL-MSG-ID               
                  AND U1.ACCOUNT_NO     = :U1-ACCOUNT-NO                
                  AND U1.COMPANY_NO     = :U1-COMPANY-NO                
                  AND U1.MSG_TYPE_CD    = :U1-MSG-TYPE-CD               
                  AND U1.BILL_CYCLE_ST  = :U1-BILL-CYCLE-ST             
                  AND U1.BILL_CYCLE_END = :U1-BILL-CYCLE-END            
                ORDER BY REVENUE_MO_END DESC                            
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REVENUE_MO_ST                                             
MFA-TR*              ,REVENUE_MO_END                                            
MFA-TR*          INTO :WS-REVENUE-MO-ST                                         
MFA-TR*              ,:WS-REVENUE-MO-END                                        
MFA-TR*          FROM CSS_SPCL_BILL_MSG U1                                      
MFA-TR*         WHERE U1.BILL_MSG_ID    = :U1-BILL-MSG-ID                       
MFA-TR*           AND U1.ACCOUNT_NO     = :U1-ACCOUNT-NO                        
MFA-TR*           AND U1.COMPANY_NO     = :U1-COMPANY-NO                        
MFA-TR*           AND U1.MSG_TYPE_CD    = :U1-MSG-TYPE-CD                       
MFA-TR*           AND U1.BILL_CYCLE_ST  = :U1-BILL-CYCLE-ST                     
MFA-TR*           AND U1.BILL_CYCLE_END = :U1-BILL-CYCLE-END                    
MFA-TR*         ORDER BY REVENUE_MO_END DESC                                    
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7050'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_BILL_MSG'       TO TABLE-1                 
              MOVE 'BILL_MSG_ID'             TO TABLE-ELEMENT-1         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-3         
              MOVE U1-BILL-MSG-ID            TO HOSTVAR-ELEMENT-1       
              MOVE U1-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2       
              MOVE U1-COMPANY-NO             TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7060-GET-MONTHS-DIFF.                                         *         
      *****************************************************************         
       7060-GET-MONTHS-DIFF.                                            
                                                                        
           EXEC SQL                                                     
              SELECT
              12 * CIS.DECIMAL2YEAR(CIS.DIFFDATE( IIF(TRY_CONVERT(DATE, 
                                                           :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ), IIF(TRY_CONVERT(DATE, 
                                                         :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) ) ))   
                                         + 
           CIS.DECIMAL2MONTH(CIS.DIFFDATE( IIF(TRY_CONVERT(DATE, 
                                                           :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ), IIF(TRY_CONVERT(DATE, 
                                                         :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) ) ))
            INTO
              :WS-MONTHS-DIFF  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-MONTHS-DIFF = ( 12 * YEAR(DATE(:WS-END-DATE)              
MFA-TR*                                       - DATE(:WS-START-DATE))           
MFA-TR*                                  + MONTH(DATE(:WS-END-DATE)             
MFA-TR*                                       - DATE(:WS-START-DATE)))          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7060'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SET'                     TO ABEND-FUNCTION          
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7200-OPEN-MSG-CD-CUR.                                         *         
      *****************************************************************         
       7200-OPEN-MSG-CD-CUR.                                            
                                                                        
           EXEC SQL                                                     
               OPEN MSG_CD_CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO WS-626-RETURN-CODE      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_MSG_PLAN_VALUE'      TO TABLE-1                 
              MOVE 'VALUE_SOURCE_CD'         TO TABLE-ELEMENT-1         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2         
              MOVE 'VALUE_CD'                TO TABLE-ELEMENT-3         
              MOVE 'WS-REV-MONTH-DATE'       TO TABLE-ELEMENT-4         
              MOVE PI-VALUE-SOURCE-CD        TO HOSTVAR-ELEMENT-1       
              MOVE U1-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2       
              MOVE PI-VALUE-CD               TO HOSTVAR-ELEMENT-3       
              MOVE WS-REV-MONTH-DATE         TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7210-FETCH-MSG-CD-CUR.                                        *         
      *****************************************************************         
       7210-FETCH-MSG-CD-CUR.                                           
                                                                        
           EXEC SQL                                                     
               FETCH MSG_CD_CUR                                         
                INTO :PI-MSG-PLAN-CD                                    
                    ,:PI-VALUE-CD                                       
                    ,:PI-PREV-VALUE-CD                                  
                    ,:P2-BILL-MSG-ID                                    
                    ,:P2-MSG-TYPE-CD                                    
                    ,:P2-MSG-APPL-CD                                    
                    ,:P2-MSG-START-DT                                   
                    ,:P2-MSG-END-DT                                     
                    ,:P2-MSG-DURATION-CD                                
                    ,:P2-MSG-DURATION-NO                                
                    ,:P2-MSG-TX                                         
                    ,:P2-MSG-SHORT-DESC                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'Y'                    TO WS-MSG-CD-ROWS          
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO WS-626-RETURN-CODE      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7210'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_MSG_PLAN_VALUE'      TO TABLE-1                 
              MOVE 'VALUE_SOURCE_CD'         TO TABLE-ELEMENT-1         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2         
              MOVE 'VALUE_CD'                TO TABLE-ELEMENT-3         
              MOVE 'WS-REV-MONTH-DATE'       TO TABLE-ELEMENT-4         
              MOVE PI-VALUE-SOURCE-CD        TO HOSTVAR-ELEMENT-1       
              MOVE U1-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2       
              MOVE PI-VALUE-CD               TO HOSTVAR-ELEMENT-3       
              MOVE WS-REV-MONTH-DATE         TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7220-CLOSE-MSG-CD-CUR.                                        *         
      *****************************************************************         
       7220-CLOSE-MSG-CD-CUR.                                           
                                                                        
           EXEC SQL                                                     
               CLOSE MSG_CD_CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO WS-626-RETURN-CODE      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7220'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_MSG_PLAN_VALUE'      TO TABLE-1                 
              MOVE 'VALUE_SOURCE_CD'         TO TABLE-ELEMENT-1         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2         
              MOVE 'VALUE_CD'                TO TABLE-ELEMENT-3         
              MOVE 'WS-REV-MONTH-DATE'       TO TABLE-ELEMENT-4         
              MOVE PI-VALUE-SOURCE-CD        TO HOSTVAR-ELEMENT-1       
              MOVE U1-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2       
              MOVE PI-VALUE-CD               TO HOSTVAR-ELEMENT-3       
              MOVE WS-REV-MONTH-DATE         TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7300-OPEN-EXPIRED-CUR.                                        *         
      *****************************************************************         
       7300-OPEN-EXPIRED-CUR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN EXPIRED_CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO WS-626-RETURN-CODE      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_BILL_MSG'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'WS-CURR-REV-MONTH'       TO TABLE-ELEMENT-2         
              MOVE U1-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-CURR-REV-MONTH         TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7310-FETCH-EXPIRED-CUR.                                       *         
      *****************************************************************         
       7310-FETCH-EXPIRED-CUR.                                          
                                                                        
           EXEC SQL                                                     
               FETCH EXPIRED_CUR                                        
                INTO :U1-REVENUE-MO-ST                                  
                    ,:U1-REVENUE-MO-END                                 
                    ,:P2-BILL-MSG-ID                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'Y'                    TO WS-EXPIRED-ROWS         
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO WS-626-RETURN-CODE      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7310'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_BILL_MSG'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'WS-CURR-REV-MONTH'       TO TABLE-ELEMENT-2         
              MOVE U1-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-CURR-REV-MONTH         TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7320-CLOSE-EXPIRED-CUR.                                       *         
      *****************************************************************         
       7320-CLOSE-EXPIRED-CUR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE EXPIRED_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO WS-626-RETURN-CODE      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7320'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_BILL_MSG'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'WS-CURR-REV-MONTH'       TO TABLE-ELEMENT-2         
              MOVE U1-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-CURR-REV-MONTH         TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8100-INSERT-BILL-MSG.                                         *         
      *****************************************************************         
       8100-INSERT-BILL-MSG.                                            
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SPCL_BILL_MSG                            
                  ( REVENUE_MO_ST                                       
                   ,ACCOUNT_NO                                          
                   ,BILL_MSG_ID                                         
                   ,MSG_TYPE_CD                                         
                   ,COMPANY_NO                                          
                   ,BILL_CYCLE_ST                                       
                   ,BILL_CYCLE_END                                      
                   ,REVENUE_MO_END )                                    
               VALUES                                                   
                  ( :U1-REVENUE-MO-ST                                   
                   ,:U1-ACCOUNT-NO                                      
                   ,:U1-BILL-MSG-ID                                     
                   ,:U1-MSG-TYPE-CD                                     
                   ,:U1-COMPANY-NO                                      
                   ,:U1-BILL-CYCLE-ST                                   
                   ,:U1-BILL-CYCLE-END                                  
                   ,:U1-REVENUE-MO-END )                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD  1                         TO WS-626-RETURN-ROW-COUNT 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO WS-626-RETURN-CODE      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_BILL_MSG'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL_MSG_ID'             TO TABLE-ELEMENT-2         
              MOVE U1-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE U1-BILL-MSG-ID            TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8110-DELETE-BILL-MSG.                                         *         
      *****************************************************************         
       8110-DELETE-BILL-MSG.                                            
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_SPCL_BILL_MSG                            
                WHERE BILL_MSG_ID = :U1-BILL-MSG-ID                     
                  AND ACCOUNT_NO  = :U1-ACCOUNT-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD 1                          TO WS-626-MSG-DEL-COUNT    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO WS-626-RETURN-CODE      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8110'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_BILL_MSG'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL_MSG_ID'             TO TABLE-ELEMENT-2         
              MOVE U1-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE U1-BILL-MSG-ID            TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       8110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8120-UPDATE-BOTH-REV-MO.                                      *         
      *****************************************************************         
       8120-UPDATE-BOTH-REV-MO.                                         
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SPCL_BILL_MSG                                 
                  SET REVENUE_MO_ST  = :U1-REVENUE-MO-ST                
                     ,REVENUE_MO_END = :U1-REVENUE-MO-END               
                WHERE ACCOUNT_NO  = :U1-ACCOUNT-NO                      
                  AND BILL_MSG_ID = :U1-BILL-MSG-ID                     
                  AND MSG_TYPE_CD = :U1-MSG-TYPE-CD                     
                  AND COMPANY_NO  = :U1-COMPANY-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD  1                         TO WS-626-RETURN-ROW-COUNT 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO WS-626-RETURN-CODE      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8120'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_BILL_MSG'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL_MSG_ID'             TO TABLE-ELEMENT-2         
              MOVE 'MSG_TYPE_CD'             TO TABLE-ELEMENT-3         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-4         
              MOVE U1-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE U1-BILL-MSG-ID            TO HOSTVAR-ELEMENT-2       
              MOVE U1-MSG-TYPE-CD            TO HOSTVAR-ELEMENT-3       
              MOVE U1-COMPANY-NO             TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       8120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8130-UPDATE-START-REV-MO.                                     *         
      *****************************************************************         
       8130-UPDATE-START-REV-MO.                                        
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SPCL_BILL_MSG                                 
                  SET REVENUE_MO_ST  = :U1-REVENUE-MO-ST                
                WHERE ACCOUNT_NO  = :U1-ACCOUNT-NO                      
                  AND BILL_MSG_ID = :U1-BILL-MSG-ID                     
                  AND MSG_TYPE_CD = :U1-MSG-TYPE-CD                     
                  AND COMPANY_NO  = :U1-COMPANY-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD  1                         TO WS-626-RETURN-ROW-COUNT 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO WS-626-RETURN-CODE      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8130'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_BILL_MSG'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL_MSG_ID'             TO TABLE-ELEMENT-2         
              MOVE 'MSG_TYPE_CD'             TO TABLE-ELEMENT-3         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-4         
              MOVE U1-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE U1-BILL-MSG-ID            TO HOSTVAR-ELEMENT-2       
              MOVE U1-MSG-TYPE-CD            TO HOSTVAR-ELEMENT-3       
              MOVE U1-COMPANY-NO             TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       8130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8140-UPDATE-END-REV-MO.                                       *         
      *****************************************************************         
       8140-UPDATE-END-REV-MO.                                          
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SPCL_BILL_MSG                                 
                  SET REVENUE_MO_END = :U1-REVENUE-MO-END               
                WHERE ACCOUNT_NO  = :U1-ACCOUNT-NO                      
                  AND BILL_MSG_ID = :U1-BILL-MSG-ID                     
                  AND MSG_TYPE_CD = :U1-MSG-TYPE-CD                     
                  AND COMPANY_NO  = :U1-COMPANY-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD  1                         TO WS-626-RETURN-ROW-COUNT 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO WS-626-RETURN-CODE      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8140'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_BILL_MSG'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL_MSG_ID'             TO TABLE-ELEMENT-2         
              MOVE 'MSG_TYPE_CD'             TO TABLE-ELEMENT-3         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-4         
              MOVE U1-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE U1-BILL-MSG-ID            TO HOSTVAR-ELEMENT-2       
              MOVE U1-MSG-TYPE-CD            TO HOSTVAR-ELEMENT-3       
              MOVE U1-COMPANY-NO             TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       8140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8600-INSERT-MNT-TRANS-HIST.                                   *         
      *****************************************************************         
       8600-INSERT-MNT-TRANS-HIST.                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MNT_TRANS_HIST                           
                 (                                                      
                   TRANS_HIST_SEQ_NO                                    
                  ,DATE_TRANS                                           
                  ,CODE_TRAN_TYPE                                       
                  ,RESP_AREA_ID                                         
                  ,ACCOUNT_NO                                           
                  ,PREMISE_NO                                           
                  ,CUSTOMER_NO                                          
                  ,USER_ID                                              
                  ,APPL_PROGRAM_ID                                      
                  ,TRAN_COMMENT                                         
                 )                                                      
               VALUES                                                   
                 (                                                      
                   CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO)                    
                  ,IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) )                               
                  ,:MH-CODE-TRAN-TYPE                                   
                  ,:MH-RESP-AREA-ID                                     
                  ,:MH-ACCOUNT-NO                                       
                  ,:MH-PREMISE-NO                                       
                  ,:MH-CUSTOMER-NO                                      
                  ,:MH-USER-ID                                          
                  ,:MH-APPL-PROGRAM-ID                                  
                  ,:MH-TRAN-COMMENT                                     
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MNT_TRANS_HIST                                   
MFA-TR*          (                                                              
MFA-TR*            TRANS_HIST_SEQ_NO                                            
MFA-TR*           ,DATE_TRANS                                                   
MFA-TR*           ,CODE_TRAN_TYPE                                               
MFA-TR*           ,RESP_AREA_ID                                                 
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,PREMISE_NO                                                   
MFA-TR*           ,CUSTOMER_NO                                                  
MFA-TR*           ,USER_ID                                                      
MFA-TR*           ,APPL_PROGRAM_ID                                              
MFA-TR*           ,TRAN_COMMENT                                                 
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :MH-TRANS-HIST-SEQ-NO                                        
MFA-TR*           ,:MH-DATE-TRANS                                               
MFA-TR*           ,:MH-CODE-TRAN-TYPE                                           
MFA-TR*           ,:MH-RESP-AREA-ID                                             
MFA-TR*           ,:MH-ACCOUNT-NO                                               
MFA-TR*           ,:MH-PREMISE-NO                                               
MFA-TR*           ,:MH-CUSTOMER-NO                                              
MFA-TR*           ,:MH-USER-ID                                                  
MFA-TR*           ,:MH-APPL-PROGRAM-ID                                          
MFA-TR*           ,:MH-TRAN-COMMENT                                             
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO WS-626-RETURN-CODE      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8600'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_MNT_TRANS_HIST'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-2         
              MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-3         
              MOVE 'DATE_TRANS'              TO TABLE-ELEMENT-4         
              MOVE MH-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE MH-CUSTOMER-NO            TO HOSTVAR-ELEMENT-2       
              MOVE MH-PREMISE-NO             TO HOSTVAR-ELEMENT-3       
              MOVE MH-DATE-TRANS             TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8610-INSERT-MT-TRN-HST-DET.                                   *         
      *****************************************************************         
       8610-INSERT-MT-TRN-HST-DET.                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MT_TRN_HST_DET                           
                 (                                                      
                   TRANS_HIST_SEQ_NO                                    
                  ,TRAN_APPL_NO                                         
                  ,COLUMN_DESC                                          
                  ,PRV_COLUMN_VALUE                                     
                  ,CHG_COLUMN_VALUE                                     
                  ,TABLE_ID                                             
                 )                                                      
               VALUES                                                   
                 (                                                      
                   CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO)                    
                  ,:MI-TRAN-APPL-NO                                     
                  ,:MI-COLUMN-DESC                                      
                  ,:MI-PRV-COLUMN-VALUE                                 
                  ,:MI-CHG-COLUMN-VALUE                                 
                  ,:MI-TABLE-ID                                         
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MT_TRN_HST_DET                                   
MFA-TR*          (                                                              
MFA-TR*            TRANS_HIST_SEQ_NO                                            
MFA-TR*           ,TRAN_APPL_NO                                                 
MFA-TR*           ,COLUMN_DESC                                                  
MFA-TR*           ,PRV_COLUMN_VALUE                                             
MFA-TR*           ,CHG_COLUMN_VALUE                                             
MFA-TR*           ,TABLE_ID                                                     
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :MI-TRANS-HIST-SEQ-NO                                        
MFA-TR*           ,:MI-TRAN-APPL-NO                                             
MFA-TR*           ,:MI-COLUMN-DESC                                              
MFA-TR*           ,:MI-PRV-COLUMN-VALUE                                         
MFA-TR*           ,:MI-CHG-COLUMN-VALUE                                         
MFA-TR*           ,:MI-TABLE-ID                                                 
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO WS-626-RETURN-CODE      
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8610'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_MT_TRN_HST_DET'      TO TABLE-1                 
              MOVE 'TRANS_HIST_SEQ_NO'       TO TABLE-ELEMENT-1         
              MOVE 'TRAN_APPL_NO'            TO TABLE-ELEMENT-2         
              MOVE 'COLUMN_DESC'             TO TABLE-ELEMENT-3         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-4         
              MOVE MI-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-1       
              MOVE MI-TRAN-APPL-NO           TO HOSTVAR-ELEMENT-2       
              MOVE MI-COLUMN-DESC            TO HOSTVAR-ELEMENT-3       
              MOVE MH-ACCOUNT-NO             TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       8610-EXIT.                                                       
           EXIT.                                                        
                                                                        
