      ******************************************************************        
      **                                                              **00022008
      **   CPD00526                                                   **00023008
      **                                                              **00022008
      ******************************************************************        
      **                                                              **00027008
      **   THIS COPY STATEMENT CONTAINS THE PROCEDURE DIVISION        **00024008
      **   STATEMENTS NECESSARY TO COMPUTE THE METER CAPABILITY       **00025008
      **   CONSTANT                                                   **00027008
      **                                                              **00027008
      ******************************************************************        
      **                                                              **        
      **              PROGRAM MODIFICATION LOG                        **        
      **                                                              **        
      **   DATE     INITIALS   COMMENTS                               **        
      **  --------  --------   ---------------------------------------**        
      **  03/03/09  MN90523    PROCEDURE ORIGINALLY CODED.            **        
P00447**  10/05/10  SB40505    CONSTANT GT 1                          **        
      **                                                              **        
      ******************************************************************        
      **                                                              **        
      **  CALL PARA 6200-COMPUTE-MTR-CAP-CONSTANT                     **00027008
      **                                                              **        
      **  INCLUDE CWS00526   ( WORKING STORAGE FOR THIS CPD00526 )    **        
      **                                                              **        
      **  INCLUDE THE FOLLOWING DECLGEN IN THE CALLING PROGRAM        **        
      **                                                              **        
      **  TBELMTRD                                                    **        
      **  TBMTRCAP                                                    **        
      **  TBMTRATT                                                    **        
      **  TBEQUIPF                                                    **        
      **  TBINXFOR                                                    **        
      **                                                              **        
      **  PASS INFORMATION IN THE FOLLOWING VARIABLE.                 **        
      **                                                              **        
      **  WS-526-IN-DEVICE-NO          ( PASS DEVICE-NO      )        **        
      **  WS-526-IN-COMPANY-NO         ( PASS COMPANY-NO     )        **        
      **  WS-526-IN-CODE-UTIL-TYPE     ( PASS CODE-UTIL-TYPE )        **        
      **  WS-526-ATTCH-INFO-TABLE.                                    **        
      **  +- WS-526-ARRY-ATTACH-TYPE   ( PASS ATTACH TYPE    )        **        
      **  +- WS-526-ARRY-CONSTANT      ( PASS MTR CONSTANT   )        **        
      **  +- WS-526-ARRY-DEVICE-NO     ( PASS ATTACHED DEVICE NO )    **        
      **  +- WS-526-ARRY-RTO-UPR       ( PASS DEVICE UPPER FRACTION ) **        
      **  +- WS-526-ARRY-RTO-LWR       ( PASS DEVICE LOWER FRACTION ) **        
      **  +- WS-526-ARRY-CT-PT-RATIO   ( PASS CT PT RATIO    )        **        
      **                                                              **        
      **                                                              **        
      **  RESULT WILL IN    WS-526-NEW-CONSTANT                       **        
      **                    WS-526-RATIO-DIFFERS                      **        
      **                    WS-526-CONSTANT-MISMATCH                  **        
      **                                                              **        
      **                                                              **        
      ******************************************************************        
       6200-COMPUTE-MTR-CAP-CONSTANT.                                   
                                                                        
           MOVE '6200'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           MOVE 'N'                       TO WS-526-RATIO-DIFFERS-SW    
                                             WS-526-CONSTANT-MISMATCH-SW
                                             WS-PT-RATIO-DIFFERS-SW     
                                             WS-CT-RATIO-DIFFERS-SW     
                                             WS-CT-FOUND-SW             
                                             WS-PT-FOUND-SW.            
                                                                        
           PERFORM VARYING ATTCH-526-INDX FROM 1 BY 1                   
                                 UNTIL ATTCH-526-INDX > 20              
              IF WS-526-ARRY-ATTACH-TYPE(ATTCH-526-INDX) = 'CT'         
                 IF NOT WS-CT-FOUND                                     
                    SET WS-CT-FOUND         TO TRUE                     
                    COMPUTE WS-PREV-CT-RATIO =                          
                       WS-526-ARRY-RTO-UPR(ATTCH-526-INDX) /            
                                 WS-526-ARRY-RTO-LWR(ATTCH-526-INDX)    
                 ELSE                                                   
                                                                        
                    COMPUTE WS-CUR-CT-RATIO =                           
                       WS-526-ARRY-RTO-UPR(ATTCH-526-INDX) /            
                                 WS-526-ARRY-RTO-LWR(ATTCH-526-INDX)    
                    IF WS-CUR-CT-RATIO NOT = WS-PREV-CT-RATIO           
                       SET WS-CT-RATIO-DIFFERS   TO TRUE                
                    END-IF                                              
                    MOVE WS-CUR-CT-RATIO         TO WS-PREV-CT-RATIO    
                 END-IF                                                 
              END-IF                                                    
              IF WS-526-ARRY-ATTACH-TYPE(ATTCH-526-INDX) = 'PT'         
                 IF NOT WS-PT-FOUND                                     
                    SET WS-PT-FOUND         TO TRUE                     
                    COMPUTE WS-PREV-PT-RATIO =                          
                       WS-526-ARRY-RTO-UPR(ATTCH-526-INDX) /            
                                 WS-526-ARRY-RTO-LWR(ATTCH-526-INDX)    
                 ELSE                                                   
                                                                        
                    COMPUTE WS-CUR-PT-RATIO =                           
                       WS-526-ARRY-RTO-UPR(ATTCH-526-INDX) /            
                                 WS-526-ARRY-RTO-LWR(ATTCH-526-INDX)    
                    IF WS-CUR-PT-RATIO NOT = WS-PREV-PT-RATIO           
                       SET WS-PT-RATIO-DIFFERS   TO TRUE                
                    END-IF                                              
                    MOVE WS-CUR-PT-RATIO         TO WS-PREV-PT-RATIO    
                 END-IF                                                 
              END-IF                                                    
                                                                        
           END-PERFORM.                                                 
                                                                        
P00447     IF (NOT WS-PT-FOUND AND NOT WS-CT-FOUND                      
P00447         AND WS-IN-ALLOW-OVERRIDE = 'N')                          
P00447        MOVE WS-DEFAULT-CONSTANT TO WS-PREV-CT-RATIO              
P00447     END-IF                                                       
                                                                        
           COMPUTE WS-COMP-CONST = WS-PREV-PT-RATIO * WS-PREV-CT-RATIO  
                                                                        
           IF WS-PT-RATIO-DIFFERS OR WS-CT-RATIO-DIFFERS                
P00447        MOVE +0.0                           TO WS-526-NEW-CONSTANT
              SET WS-526-RATIO-DIFFERS            TO TRUE               
           ELSE                                                         
              IF WS-COMP-CONST NOT = WS-526-IN-CONSTANT                 
                 MOVE WS-COMP-CONST           TO WS-526-NEW-CONSTANT    
                 SET WS-526-CONSTANT-MISMATCH TO TRUE                   
              ELSE                                                      
                 MOVE WS-526-IN-CONSTANT      TO WS-526-NEW-CONSTANT    
              END-IF                                                    
           END-IF.                                                      
                                                                        
       6200-EXIT.                                                       
           EXIT.                                                        
                                                                        
