      ******************************************************************31298000
      ** MAIN PROGRAM COPYBOOK FOR MCSCB444/SCSCA444                  **31300000
      ******************************************************************31320000
      ** PURPOSE: VALIDATE ELIGIBILITY AND APPLY/EXPIRE CSC DISCOUNTS **31300000
      **                                                              **        
      ** INPUTS: ACCOUNT NO(REQUIRED)                                 **        
      **         PROGRAM ID(OPTIONAL)                                 **        
      **         USER ID   (OPTIONAL)                                 **        
      **                                                              **        
      ** OUTPUT: SETS DISCOUNT ELIGIBILITY/RECEIVING/PROMOTE FLAGS    **        
      **         ADD/EXPIRE/DELETE DISCOUNTS BASED ON ELIGIBILITY     **        
      **                                                              **        
      ** NOTE:   WHEN MODIFYING THIS MEMBER, EVALUATE COMPONENTS      **31300000
      **         CPD0444E, CWS00444, CWS0444E, MCSCB444 & SCSCA444    **31300000
      **                                                              **31300000
      ******************************************************************31360000
      **               COPYBOOK MODIFICATION  LOG                     **        
      **                                                              **        
      **  DATE       INITIALS   REASON                                **        
      **  ________   ________   ___________________________________   **        
P805CS**  03/03/16   GD43988    NEW COPYBOOK.                         **        
      ******************************************************************        
      *                                                                         
      *** WORKING STORAGE VARIABLES                                             
      *                                                                         
       01 WS-WQ-TEXT-VARIABLES.                                         
          05 WS-INVL-CSC-WQ-TEXT.                                       
             10 FILLER                   PIC X(24) VALUE                
                'CSC AMOUNT IS < 0. CSC: '.                             
             10 WS-CSC-AMT-FMT           PIC -ZZZZ9.99.                 
      *                                                                         
       01 WS-CPD063-VARIABLES.                                          
          05 MCSCB063                    PIC X(08) VALUE 'MCSCB063'.    
          05 SCSCB063                    PIC X(08) VALUE 'SCSCB063'.    
          05 WS-CPD063-RET-CODE          PIC S9(04) COMP VALUE 0.       
      *                                                                         
       01 WS-CPD077-VARIABLES.                                          
          05 MCSCB077                    PIC X(08) VALUE 'MCSCB077'.    
          05 SCSCB077                    PIC X(08) VALUE 'SCSCB077'.    
          05 WS-CPD077-RET-CODE          PIC S9(04) COMP VALUE 0.       
      *                                                                         
       01 WS-OTHER-VARIABLES.                                           
          05 WS-IC-NO-Z                  PIC  Z(04).                    
          05 WS-FCTR-SEQ-NO-Z            PIC  Z(04).                    
          05 WS-FACTOR-Z                 PIC -Z(09).9(04).              
          05 WS-TRAN-COMMENT-INS         PIC  X(26) VALUE               
                'ADDED CSC DISCOUNT FACTOR.'.                           
          05 WS-TRAN-COMMENT-UPD         PIC  X(28) VALUE               
                'EXPIRED CSC DISCOUNT FACTOR.'.                         
          05 WS-TRAN-COMMENT-DEL         PIC  X(28) VALUE               
                'DELETED CSC DISCOUNT FACTOR.'.                         
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
      *** LINKAGE VARIABLES                                                     
      *                                                                         
      *** WS ABEND WORK AREA                                                    
      *                                                                         
           COPY CWS00010.                                                       
      *                                                                         
      *** DB2 AND SQL ERROR CHECKING                                            
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      *** COPY BOOK TO PROCESS CSC DISCOUNTS                            00725901
      *                                                                         
           COPY CWS00444.                                                       
      *                                                                         
       PROCEDURE DIVISION USING ABEND-FILE                              
                               ,WS-WARNING-DATA-ELEMENTS                
                               ,LS-MCSCB444-COMM-AREA.                  
      *                                                                         
      ******************************************************************PCS03340
      ** 0000-MAINLINE                                                **PCS03320
      ******************************************************************PCS03340
      *                                                                 PCS03300
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
      *                                                                         
           IF PROGRAM-NAME = 'SCSCA444'                                 
              EXIT PROGRAM                                              
           ELSE                                                         
              GOBACK                                                    
           END-IF.                                                      
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS03340
      ** 2000-PROCESS-OUTPUT                                          **PCS03320
      ******************************************************************PCS03340
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                   TO ACTIVE-PARAGRAPH.           
      *                                                                         
      *** DISCOUNT ELIGIBILITY VALIDATION                                       
           PERFORM 6000-CPD444-CSC-DISCOUNT-ELIG                        
              THRU 6000-CPD444-EXIT.                                    
      *                                                                         
      *** PROCESS EACH DISCOUNT TYPE                                            
           PERFORM 2100-PROCESS-DISCOUNT-TYPES THRU 2100-EXIT           
           VARYING WS-444-S FROM 1 BY 1                                 
             UNTIL WS-444-S > 10                                        
                OR WS-444-O-ELIG-FL(WS-444-S) = SPACES.                 
      *                                                                         
      *** VALIDATE NET CSC AFTER APPLYING DISCOUNTS                             
      *** IF CSC < 0 AFTER APPLYING DISCOUNTS, CREATE WQ                        
           PERFORM 6100-CALL-PRICE-PGM-063 THRU 6100-EXIT.              
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS03340
      ** BASED ON SCENARIO, APPLY/EXPIRE DISCOUNTS                    **PCS03320
      ******************************************************************PCS03340
      *                                                                         
       2100-PROCESS-DISCOUNT-TYPES.                                     
      *                                                                         
           MOVE '2100'                   TO ACTIVE-PARAGRAPH.           
      *                                                                         
      *** VALIDATE ELIGIBILITY FLAG AND RECEIVING FLAG                          
           EVALUATE WS-444-O-ELIG-FL(WS-444-S)                          
               ALSO WS-444-O-RECV-FL(WS-444-S)                          
               WHEN 'Y' ALSO 'Y'                                        
                 IF WS-444-O-DT-TO(WS-444-S)  = '2999-12-31' AND        
                    WS-444-O-FACTOR(WS-444-S) =                         
                    WS-444-O-DELINQ-VAL(WS-444-S)                       
                    CONTINUE                                            
                 ELSE                                                   
                    PERFORM 2200-EXPIRE-DISCOUNT THRU 2200-EXIT         
                    PERFORM 2300-APPLY-DISCOUNT  THRU 2300-EXIT         
                 END-IF                                                 
               WHEN 'N' ALSO 'Y'                                        
                 PERFORM 2200-EXPIRE-DISCOUNT THRU 2200-EXIT            
               WHEN 'Y' ALSO 'N'                                        
                 PERFORM 2300-APPLY-DISCOUNT  THRU 2300-EXIT            
               WHEN 'N' ALSO 'N'                                        
                 CONTINUE                                               
           END-EVALUATE.                                                
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS03340
      *** EXPIRE DISCOUNTS AND MODIFY ARRAY                          ***PCS03320
      ******************************************************************PCS03340
      *                                                                         
       2200-EXPIRE-DISCOUNT.                                            
      *                                                                         
           MOVE '2200'                     TO ACTIVE-PARAGRAPH.         
      *                                                                         
           MOVE W4AT-ACCOUNT-NO            TO FF-ACCOUNT-NO.            
           MOVE W4UT-CODE-UTIL-TYPE        TO FF-CODE-UTIL-TYPE.        
           MOVE W4UT-IC-NO                 TO FF-IC-NO.                 
           MOVE WS-444-O-FCTR-SEQ-NO(WS-444-S)                          
                                           TO FF-FIXED-FCTR-SEQ-NO.     
           MOVE WS-444-O-FCTR-ID(WS-444-S) TO FF-FACTOR-ID.             
      *                                                                         
      *** IF ACCT IS NEVER BILLED/FCTR BEG DT > OLD FCTR END DT,                
      *** DELETE THE FACTOR                                                     
           IF (W4AT-REV-MTH-LST-NRML      = 0)                          
                          OR                                            
              (WS-444-O-DT-FROM(WS-444-S) > WS-444-OLDFCTR-END-DT)      
              PERFORM 8050-DELETE-FIXED-FCTR      THRU 8050-EXIT        
              PERFORM 2650-LOAD-TRANS-HIST-DELETE THRU 2650-EXIT        
           ELSE                                                         
              MOVE WS-444-OLDFCTR-END-DT   TO FF-EFF-DATE-TO            
              PERFORM 8025-UPDATE-FIXED-FCTR      THRU 8025-EXIT        
              PERFORM 2625-LOAD-TRANS-HIST-EXPIRE THRU 2625-EXIT        
           END-IF.                                                      
      *                                                                         
      *** AFTER DATABASE UPDATE, MAKE SURE TRUE-UP THE ARRAY                    
           MOVE 'N'                 TO WS-444-O-RECV-FL(WS-444-S)       
           MOVE SPACES              TO WS-444-O-DT-FROM(WS-444-S)       
           MOVE SPACES              TO WS-444-O-DT-TO(WS-444-S)         
           MOVE 0                   TO WS-444-O-FACTOR(WS-444-S)        
           MOVE 0                   TO WS-444-O-FCTR-SEQ-NO(WS-444-S).  
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS03340
      ** APPLY DISCOUNTS                                              **PCS03320
      ******************************************************************PCS03340
      *                                                                         
       2300-APPLY-DISCOUNT.                                             
      *                                                                         
           MOVE '2300'                     TO ACTIVE-PARAGRAPH.         
      *                                                                         
           MOVE W4AT-ACCOUNT-NO               TO FF-ACCOUNT-NO.         
           MOVE W4UT-CODE-UTIL-TYPE           TO FF-CODE-UTIL-TYPE.     
           MOVE W4UT-IC-NO                    TO FF-IC-NO.              
      *                                                                         
      *** GET FIXED FCTR SEQ NO                                                 
           PERFORM 7500-GET-FIXED-FCTR-SEQ-NO THRU 7500-EXIT.           
      *                                                                         
           MOVE WS-444-O-FCTR-ID(WS-444-S)    TO FF-FACTOR-ID.          
           MOVE WS-444-NEWFCTR-BEG-DT         TO FF-EFF-DATE-FROM.      
           MOVE '10'                          TO FF-CMPNT-ID-CD.        
           MOVE 'B'                           TO FF-CODE-SEASON.        
           MOVE 'R'                           TO FF-INSTR-USE-TYPE-CD.  
           MOVE  0                            TO FF-CODE-TIME-PERIOD.   
           MOVE WS-444-NEWFCTR-END-DT         TO FF-EFF-DATE-TO.        
           MOVE SPACES                        TO FF-FIXED-FCTR-TYP-CD.  
           MOVE 0                             TO FF-FAC-CHRG-BASE-AM.   
           MOVE 0                             TO FF-RT-PKG-OPT-SEQ-NO.  
           MOVE 0                             TO FF-BLOCK-NO.           
      *                                                                         
           MOVE WS-444-O-DELINQ-VAL(WS-444-S) TO FF-FACTOR.             
           COMPUTE FF-FACTOR = FF-FACTOR * -1                           
           END-COMPUTE.                                                 
      *                                                                         
           PERFORM 8000-INSERT-FIXED-FCTR   THRU 8000-EXIT.             
      *                                                                         
           COMPUTE FF-FACTOR = FF-FACTOR * -1                           
           END-COMPUTE.                                                 
      *                                                                         
           PERFORM 2600-LOAD-TRANS-HIST-ADD THRU 2600-EXIT.             
      *                                                                         
      *** AFTER DATABASE UPDATE, TRUE-UP THE ARRAY                              
           MOVE 'Y'                  TO WS-444-O-RECV-FL(WS-444-S).     
           MOVE FF-EFF-DATE-FROM     TO WS-444-O-DT-FROM(WS-444-S).     
           MOVE FF-EFF-DATE-TO       TO WS-444-O-DT-TO(WS-444-S).       
           MOVE FF-FACTOR            TO WS-444-O-FACTOR(WS-444-S).      
           MOVE FF-FIXED-FCTR-SEQ-NO TO WS-444-O-FCTR-SEQ-NO(WS-444-S). 
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS03340
      *** TRANSACITON HISTORY & DETAILS - ADD DISCOUNT               ***PCS03320
      ******************************************************************PCS03340
      *                                                                         
       2600-LOAD-TRANS-HIST-ADD.                                        
      *                                                                         
           MOVE '2600'                     TO ACTIVE-PARAGRAPH.         
      *                                                                         
           INITIALIZE                         DCLCSS-MNT-TRANS-HIST.    
      *                                                                         
           EVALUATE WS-444-O-DISC-CD(WS-444-S)                          
               WHEN 'AUTORENEW'                                         
                    MOVE 'Auto Renew Discount Added'                    
                                           TO MH-TRAN-COMMENT-TEXT      
               WHEN 'PAPERLESS'                                         
                    MOVE 'Paperless Discount Added'                     
                                           TO MH-TRAN-COMMENT-TEXT      
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 2700-POPULATE-MNT-TRANS-HIST THRU 2700-EXIT.         
      *                                                                         
           INITIALIZE                         DCLCSS-MT-TRN-HST-DET.    
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
           ADD  +1                         TO MI-TRAN-APPL-NO.          
           MOVE 'FACTOR_ID'                TO MI-COLUMN-DESC.           
           MOVE SPACES                     TO MI-TABLE-ID.              
           MOVE '**NEW**'                  TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                           TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE FF-FACTOR-ID               TO MI-CHG-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                           TO MI-CHG-COLUMN-VALUE-LEN.  
           PERFORM 8550-INSERT-MT-TRN-HST-DET THRU 8550-EXIT.           
      *                                                                         
           ADD  +1                         TO MI-TRAN-APPL-NO.          
           MOVE 'FACTOR'                   TO MI-COLUMN-DESC.           
           MOVE SPACES                     TO MI-TABLE-ID.              
           MOVE '**NEW**'                  TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                           TO MI-PRV-COLUMN-VALUE-LEN.  
           INITIALIZE                         WS-FACTOR-Z.              
           MOVE FF-FACTOR                  TO WS-FACTOR-Z.              
           MOVE WS-FACTOR-Z                TO MI-CHG-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                           TO MI-CHG-COLUMN-VALUE-LEN.  
           PERFORM 8550-INSERT-MT-TRN-HST-DET THRU 8550-EXIT.           
      *                                                                         
           ADD  +1                         TO MI-TRAN-APPL-NO.          
           MOVE 'EFF_DATE_FROM'            TO MI-COLUMN-DESC.           
           MOVE SPACES                     TO MI-TABLE-ID.              
           MOVE '**NEW**'                  TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                           TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE FF-EFF-DATE-FROM           TO MI-CHG-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                           TO MI-CHG-COLUMN-VALUE-LEN.  
           PERFORM 8550-INSERT-MT-TRN-HST-DET THRU 8550-EXIT.           
      *                                                                         
           ADD  +1                         TO MI-TRAN-APPL-NO.          
           MOVE 'EFF_DATE_TO'              TO MI-COLUMN-DESC.           
           MOVE SPACES                     TO MI-TABLE-ID.              
           MOVE '**NEW**'                  TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                           TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE FF-EFF-DATE-TO             TO MI-CHG-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                           TO MI-CHG-COLUMN-VALUE-LEN.  
           PERFORM 8550-INSERT-MT-TRN-HST-DET THRU 8550-EXIT.           
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS03340
      *** TRANSACITON HISTORY & DETAILS - EXPIRE DISCOUNT            ***PCS03320
      ******************************************************************PCS03340
      *                                                                         
       2625-LOAD-TRANS-HIST-EXPIRE.                                     
      *                                                                         
           MOVE '2625'                     TO ACTIVE-PARAGRAPH.         
      *                                                                         
           INITIALIZE                         DCLCSS-MNT-TRANS-HIST.    
      *                                                                         
           EVALUATE WS-444-O-DISC-CD(WS-444-S)                          
               WHEN 'AUTORENEW'                                         
                    MOVE 'Auto Renew Discount Expired'                  
                                           TO MH-TRAN-COMMENT-TEXT      
               WHEN 'PAPERLESS'                                         
                    MOVE 'Paperless Discount Expired'                   
                                           TO MH-TRAN-COMMENT-TEXT      
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 2700-POPULATE-MNT-TRANS-HIST THRU 2700-EXIT.         
      *                                                                         
           INITIALIZE                         DCLCSS-MT-TRN-HST-DET.    
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
           ADD  +1                         TO MI-TRAN-APPL-NO.          
           MOVE 'FACTOR_ID'                TO MI-COLUMN-DESC.           
           MOVE SPACES                     TO MI-TABLE-ID.              
           MOVE FF-FACTOR-ID               TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                           TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE FF-FACTOR-ID               TO MI-CHG-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                           TO MI-CHG-COLUMN-VALUE-LEN.  
           PERFORM 8550-INSERT-MT-TRN-HST-DET THRU 8550-EXIT.           
      *                                                                         
           ADD  +1                         TO MI-TRAN-APPL-NO.          
           MOVE 'FACTOR'                   TO MI-COLUMN-DESC.           
           MOVE SPACES                     TO MI-TABLE-ID.              
           INITIALIZE                         WS-FACTOR-Z.              
           MOVE WS-444-O-FACTOR(WS-444-S)  TO WS-FACTOR-Z.              
           MOVE WS-FACTOR-Z                TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                           TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE WS-FACTOR-Z                TO MI-CHG-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                           TO MI-CHG-COLUMN-VALUE-LEN.  
           PERFORM 8550-INSERT-MT-TRN-HST-DET THRU 8550-EXIT.           
      *                                                                         
           ADD  +1                         TO MI-TRAN-APPL-NO.          
           MOVE 'EFF DATE FROM'            TO MI-COLUMN-DESC.           
           MOVE SPACES                     TO MI-TABLE-ID.              
           MOVE WS-444-O-DT-FROM(WS-444-S) TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                           TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE WS-444-O-DT-FROM(WS-444-S) TO MI-CHG-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                           TO MI-CHG-COLUMN-VALUE-LEN.  
           PERFORM 8550-INSERT-MT-TRN-HST-DET THRU 8550-EXIT.           
      *                                                                         
           ADD  +1                         TO MI-TRAN-APPL-NO.          
           MOVE 'EFF DATE TO'              TO MI-COLUMN-DESC.           
           MOVE SPACES                     TO MI-TABLE-ID.              
           MOVE WS-444-O-DT-TO(WS-444-S)   TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                           TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE FF-EFF-DATE-TO             TO MI-CHG-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                           TO MI-CHG-COLUMN-VALUE-LEN.  
           PERFORM 8550-INSERT-MT-TRN-HST-DET THRU 8550-EXIT.           
      *                                                                         
       2625-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS03340
      *** TRANSACITON HISTORY & DETAILS - DELETE DISCOUNT            ***PCS03320
      ******************************************************************PCS03340
      *                                                                         
       2650-LOAD-TRANS-HIST-DELETE.                                     
      *                                                                         
           MOVE '2650'                     TO ACTIVE-PARAGRAPH.         
      *                                                                         
           INITIALIZE                         DCLCSS-MNT-TRANS-HIST.    
      *                                                                         
           EVALUATE WS-444-O-DISC-CD(WS-444-S)                          
               WHEN 'AUTORENEW'                                         
                    MOVE 'Auto Renew Discount Deleted'                  
                                           TO MH-TRAN-COMMENT-TEXT      
               WHEN 'PAPERLESS'                                         
                    MOVE 'Paperless Discount Deleted'                   
                                           TO MH-TRAN-COMMENT-TEXT      
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 2700-POPULATE-MNT-TRANS-HIST THRU 2700-EXIT.         
      *                                                                         
           INITIALIZE                         DCLCSS-MT-TRN-HST-DET.    
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
           ADD  +1                         TO MI-TRAN-APPL-NO.          
           MOVE 'FACTOR_ID'                TO MI-COLUMN-DESC.           
           MOVE SPACES                     TO MI-TABLE-ID.              
           MOVE FF-FACTOR-ID               TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                           TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE '**DELETED**'              TO MI-CHG-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                           TO MI-CHG-COLUMN-VALUE-LEN.  
           PERFORM 8550-INSERT-MT-TRN-HST-DET THRU 8550-EXIT.           
      *                                                                         
           ADD  +1                         TO MI-TRAN-APPL-NO.          
           MOVE 'FACTOR'                   TO MI-COLUMN-DESC.           
           MOVE SPACES                     TO MI-TABLE-ID.              
           INITIALIZE                         WS-FACTOR-Z.              
           MOVE WS-444-O-FACTOR(WS-444-S)  TO WS-FACTOR-Z.              
           MOVE WS-FACTOR-Z                TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                           TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE '**DELETED**'              TO MI-CHG-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                           TO MI-CHG-COLUMN-VALUE-LEN.  
           PERFORM 8550-INSERT-MT-TRN-HST-DET THRU 8550-EXIT.           
      *                                                                         
           ADD  +1                         TO MI-TRAN-APPL-NO.          
           MOVE 'EFF DATE FROM'            TO MI-COLUMN-DESC.           
           MOVE SPACES                     TO MI-TABLE-ID.              
           MOVE WS-444-O-DT-FROM(WS-444-S) TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                           TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE '**DELETED**'              TO MI-CHG-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                           TO MI-CHG-COLUMN-VALUE-LEN.  
           PERFORM 8550-INSERT-MT-TRN-HST-DET THRU 8550-EXIT.           
      *                                                                         
           ADD  +1                         TO MI-TRAN-APPL-NO.          
           MOVE 'EFF DATE TO'              TO MI-COLUMN-DESC.           
           MOVE SPACES                     TO MI-TABLE-ID.              
           MOVE WS-444-O-DT-TO(WS-444-S)   TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                           TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE '**DELETED**'              TO MI-CHG-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                           TO MI-CHG-COLUMN-VALUE-LEN.  
           PERFORM 8550-INSERT-MT-TRN-HST-DET THRU 8550-EXIT.           
      *                                                                         
       2650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS03340
      *** POPULATE TRANSACTION HISTORY HEADER TABLE DATA             ***PCS03320
      ******************************************************************PCS03340
      *                                                                         
       2700-POPULATE-MNT-TRANS-HIST.                                    
      *                                                                         
           MOVE '2700'                     TO ACTIVE-PARAGRAPH.         
      *                                                                         
           PERFORM 7550-GET-CURR-DATE-TIMESTAMP THRU 7550-EXIT.         
      *                                                                         
           MOVE 'F'                        TO MH-CODE-TRAN-TYPE.        
           MOVE SPACES                     TO MH-RESP-AREA-ID.          
           MOVE W4AT-ACCOUNT-NO            TO MH-ACCOUNT-NO.            
           MOVE W4AT-CUSTOMER-NO           TO MH-CUSTOMER-NO.           
           MOVE W4AT-PREMISE-NO            TO MH-PREMISE-NO.            
           MOVE WS-444-I-USER-ID           TO MH-USER-ID.               
           MOVE PROGRAM-NAME               TO MH-APPL-PROGRAM-ID.       
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                           TO MH-TRAN-COMMENT-LEN.      
      *                                                                         
           PERFORM 8500-INSERT-MNT-TRANS-HIST THRU 8500-EXIT.           
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS03340
      ** CALL MCSCB063/SCSCB063 BASED ON ONLINE/BATCH                 **PCS03320
      ******************************************************************PCS03340
      *                                                                         
       6100-CALL-PRICE-PGM-063.                                         
      *                                                                         
           MOVE '6100'              TO ACTIVE-PARAGRAPH.                
      *                                                                         
           INITIALIZE                  CWS00063-FIELDS.                 
      *                                                                         
           MOVE W4DF-OPTION-CD      TO WS-OPTION-CD.                    
           MOVE W4AT-ACCOUNT-NO     TO WS-ACCOUNT-NO-063.               
           MOVE W4UT-CODE-UTIL-TYPE TO WS-CODE-UTIL-TYPE-063.           
           MOVE W4UT-IC-NO          TO WS-IC-NO-063.                    
           MOVE PROGRAM-NAME        TO WS-CPD063-CALLING-PGM.           
           MOVE 'Y'                 TO WS-THERM-CSC-ACCT-FL.            
      *                                                                         
           IF PROGRAM-NAME = 'SCSCA444'                                 
              CALL SCSCB063 USING CWS00063-FIELDS                       
                                 ,ABEND-FILE                            
                                 ,WS-CPD063-RET-CODE                    
           ELSE                                                         
              CALL MCSCB063 USING CWS00063-FIELDS                       
                                 ,ABEND-FILE                            
                                 ,WS-CPD063-RET-CODE                    
           END-IF.                                                      
      *                                                                         
           MOVE WS-CPD063-RET-CODE        TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-CSC-AMT < 0                                         
                 INITIALIZE            CWS00077-FIELDS                  
                 MOVE 17                  TO WS-77-CATEGORY-ID          
                 MOVE WS-CSC-AMT          TO WS-CSC-AMT-FMT             
                 MOVE WS-INVL-CSC-WQ-TEXT TO WS-77-COMMENTS-TEXT        
                 PERFORM 6200-CALL-WQ-PGM-077 THRU 6200-EXIT            
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '6100'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CALL'                 TO ABEND-FUNCTION             
              IF PROGRAM-NAME = 'SCSCA444'                              
                 MOVE 'SCSCB063'          TO TABLE-1                    
              ELSE                                                      
                 MOVE 'MCSCB063'          TO TABLE-1                    
              END-IF                                                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE 'IC_NO'                TO TABLE-ELEMENT-2            
              MOVE 'OPTION_CD'            TO TABLE-ELEMENT-3            
              MOVE 'PROGRAM NAME'         TO TABLE-ELEMENT-4            
              MOVE WS-ACCOUNT-NO-063      TO HOSTVAR-ELEMENT-1          
              MOVE WS-IC-NO-063           TO HOSTVAR-ELEMENT-2          
              MOVE WS-OPTION-CD           TO HOSTVAR-ELEMENT-3          
              MOVE WS-CPD063-CALLING-PGM  TO HOSTVAR-ELEMENT-4          
              PERFORM 9900-TERMINATE  THRU  9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       6100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS03340
      ** CALL MCSCB077/SCSCB077 BASED ON ONLINE/BATCH                 **PCS03320
      ******************************************************************PCS03340
      *                                                                         
       6200-CALL-WQ-PGM-077.                                            
      *                                                                         
           MOVE '6200'              TO ACTIVE-PARAGRAPH.                
      *                                                                         
           MOVE W4AT-ACCOUNT-NO     TO WS-77-ACCOUNT-NO.                
           MOVE ZEROES              TO WS-77-ITEM-ID.                   
           MOVE SPACES              TO WS-77-USER-ID-ASGN.              
           MOVE W4AT-CUSTOMER-NO    TO WS-77-CUSTOMER-NO.               
           MOVE ZEROES              TO WS-77-SERV-ORDER-NO.             
           MOVE 'SYSTEM'            TO WS-77-USER-ID-ORIG.              
           MOVE W4AT-PREMISE-NO     TO WS-77-PREMISE-NO.                
           MOVE W4AT-LOCAL-OFFICE   TO WS-77-LOCAL-OFFICE.              
           MOVE SPACES              TO WS-77-RESP-AREA-ID.              
           MOVE 'N'                 TO WS-77-PRIORITY.                  
           MOVE WS-444-COMMON-DT    TO WS-77-DATE-CREATED(1:10).        
           MOVE '-00.00.00.000000'  TO WS-77-DATE-CREATED(11:16).       
      *                                                                         
      *** GET NEXT BUSINESS DAY                                                 
           MOVE W4AT-COMPANY-NO     TO 1G-COMPANY-NO.                   
           MOVE WS-444-COMMON-DT    TO 1G-BUSINESS-DAY-DT.              
           PERFORM 7700-GET-NEXT-BUSINESS-DAY THRU 7700-EXIT.           
           MOVE 1G-BUSINESS-DAY-DT  TO WS-77-DATE-REQUIRED.             
      *                                                                         
           MOVE 4                   TO WS-77-ROUTE-CATEGORY.            
           MOVE PROGRAM-NAME        TO WS-77-CREATED-BY.                
           MOVE LENGTH OF WS-77-COMMENTS-TEXT                           
                                    TO WS-77-COMMENTS-LEN.              
      *                                                                         
           IF PROGRAM-NAME = 'SCSCA444'                                 
              CALL SCSCB077 USING CWS00077-FIELDS                       
                                 ,ABEND-FILE                            
                                 ,WS-CPD077-RET-CODE                    
           ELSE                                                         
              CALL MCSCB077 USING CWS00077-FIELDS                       
                                 ,ABEND-FILE                            
                                 ,WS-CPD077-RET-CODE                    
           END-IF.                                                      
      *                                                                         
           MOVE WS-CPD077-RET-CODE        TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '6200'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CALL'                 TO ABEND-FUNCTION             
              IF PROGRAM-NAME = 'SCSCA444'                              
                 MOVE 'SCSCB077'          TO TABLE-1                    
              ELSE                                                      
                 MOVE 'MCSCB077'          TO TABLE-1                    
              END-IF                                                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE WS-77-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1          
              PERFORM 9900-TERMINATE  THRU  9900-EXIT                   
           END-IF.                                                      
       6200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** ERROR HANDLING FOR DISCOUNT ELIGIBILITY COPYBOOK CPD0444E   **         
      *****************************************************************         
      *                                                                         
       6999-CPD444-ERROR-ROUTINE.                                       
      *                                                                         
           MOVE '6999'              TO ACTIVE-PARAGRAPH.                
      *                                                                         
           PERFORM 9900-TERMINATE THRU 9900-EXIT.                       
      *                                                                         
       6999-CPD444-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** GET FACTOR SEQ NO                                           **         
      *****************************************************************         
      *                                                                         
       7500-GET-FIXED-FCTR-SEQ-NO.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT  COALESCE(MAX(FF.FIXED_FCTR_SEQ_NO) + 1,1)           
                INTO :FF-FIXED-FCTR-SEQ-NO                              
                FROM  CSS_FIXED_FCTR    FF WITH(READUNCOMMITTED)                
               WHERE  FF.ACCOUNT_NO     = :FF-ACCOUNT-NO                
                 AND  FF.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE            
                 AND  FF.IC_NO          = :FF-IC-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  IFNULL(MAX(FF.FIXED_FCTR_SEQ_NO) + 1,1)                   
MFA-TR*         INTO :FF-FIXED-FCTR-SEQ-NO                                      
MFA-TR*         FROM  CSS_FIXED_FCTR    FF                                      
MFA-TR*        WHERE  FF.ACCOUNT_NO     = :FF-ACCOUNT-NO                        
MFA-TR*          AND  FF.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE                    
MFA-TR*          AND  FF.IC_NO          = :FF-IC-NO                             
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7500'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_FIXED_FCTR'      TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE FF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE FF-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE FF-IC-NO              TO HOSTVAR-ELEMENT-3           
              PERFORM 9900-TERMINATE  THRU  9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** GET TRANSACITON HISTORY DATE AND TIMESTAMP                  **         
      *****************************************************************         
      *                                                                         
       7550-GET-CURR-DATE-TIMESTAMP.                                    
      *                                                                         
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*          ,:MH-DATE-TRANS        = CURRENT DATE                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7550'                TO ACTIVE-PARAGRAPH            
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE 'CSS_MODEL_SQL'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE 'FIXED_FCTR_SEQ_NO'   TO TABLE-ELEMENT-4             
              MOVE FF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE FF-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE FF-IC-NO              TO HOSTVAR-ELEMENT-3           
              MOVE FF-FIXED-FCTR-SEQ-NO  TO HOSTVAR-ELEMENT-4           
              PERFORM 6999-CPD444-ERROR-ROUTINE THRU 6999-CPD444-EXIT   
           END-IF.                                                      
      *                                                                         
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** GET NEXT BUSINESS DAY                                       **         
      *****************************************************************         
      *                                                                         
       7700-GET-NEXT-BUSINESS-DAY.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) BUSINESS_DAY_DT                                   
                INTO :1G-BUSINESS-DAY-DT                                
                FROM  CSS_BUSINESS_DAYS WITH(READUNCOMMITTED)                   
               WHERE  COMPANY_NO      = :1G-COMPANY-NO                  
                 AND  BUSINESS_DAY_DT > IIF(TRY_CONVERT(DATE, 
                                                    :1G-BUSINESS-DAY-DT
              ) IS NULL OR (PATINDEX('%.%', :1G-BUSINESS-DAY-DT
              ) <> 0) OR (LEN(:1G-BUSINESS-DAY-DT
              ) <> 10), CIS.CHAR2DATE(:1G-BUSINESS-DAY-DT
              ), CONVERT(DATE, :1G-BUSINESS-DAY-DT) )             
              ORDER BY 1                                                
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  BUSINESS_DAY_DT                                           
MFA-TR*         INTO :1G-BUSINESS-DAY-DT                                        
MFA-TR*         FROM  CSS_BUSINESS_DAYS                                         
MFA-TR*        WHERE  COMPANY_NO      = :1G-COMPANY-NO                          
MFA-TR*          AND  BUSINESS_DAY_DT > :1G-BUSINESS-DAY-DT                     
MFA-TR*       ORDER BY 1                                                        
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7700'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_BUSINESS_DAYS'   TO TABLE-1                     
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
              MOVE 'BUSINESS-DAY_DT'     TO TABLE-ELEMENT-2             
              MOVE 1G-COMPANY-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 1G-BUSINESS-DAY-DT    TO HOSTVAR-ELEMENT-2           
              PERFORM 9900-TERMINATE  THRU  9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** INSERT FIXED FCTR DATA                                      **         
      *****************************************************************         
      *                                                                         
       8000-INSERT-FIXED-FCTR.                                          
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_FIXED_FCTR                                
                     ( ACCOUNT_NO                                       
                      ,CODE_UTIL_TYPE                                   
                      ,IC_NO                                            
                      ,FIXED_FCTR_SEQ_NO                                
                      ,FACTOR_ID                                        
                      ,EFF_DATE_FROM                                    
                      ,CMPNT_ID_CD                                      
                      ,CODE_SEASON                                      
                      ,INSTR_USE_TYPE_CD                                
                      ,CODE_TIME_PERIOD                                 
                      ,EFF_DATE_TO                                      
                      ,FIXED_FCTR_TYP_CD                                
                      ,FACTOR                                           
                      ,FAC_CHRG_BASE_AM                                 
                      ,LAST_UPDATE_TS                                   
                      ,DURATION_REMAIN_NO                               
                      ,RT_PKG_OPT_SEQ_NO                                
                      ,BLOCK_NO)                                        
              VALUES (:FF-ACCOUNT-NO                                    
                     ,:FF-CODE-UTIL-TYPE                                
                     ,:FF-IC-NO                                         
                     ,:FF-FIXED-FCTR-SEQ-NO                             
                     ,:FF-FACTOR-ID                                     
                     ,IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )                            
                     ,:FF-CMPNT-ID-CD                                   
                     ,:FF-CODE-SEASON                                   
                     ,:FF-INSTR-USE-TYPE-CD                             
                     ,:FF-CODE-TIME-PERIOD                              
                     ,IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )                              
                     ,:FF-FIXED-FCTR-TYP-CD                             
                     ,:FF-FACTOR                                        
                     ,:FF-FAC-CHRG-BASE-AM                              
                     , CIS.CURRENT$TIMESTAMP()                                
                     , NULL                                             
                     ,:FF-RT-PKG-OPT-SEQ-NO                             
                     ,:FF-BLOCK-NO)                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_FIXED_FCTR                                        
MFA-TR*              ( ACCOUNT_NO                                               
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,FIXED_FCTR_SEQ_NO                                        
MFA-TR*               ,FACTOR_ID                                                
MFA-TR*               ,EFF_DATE_FROM                                            
MFA-TR*               ,CMPNT_ID_CD                                              
MFA-TR*               ,CODE_SEASON                                              
MFA-TR*               ,INSTR_USE_TYPE_CD                                        
MFA-TR*               ,CODE_TIME_PERIOD                                         
MFA-TR*               ,EFF_DATE_TO                                              
MFA-TR*               ,FIXED_FCTR_TYP_CD                                        
MFA-TR*               ,FACTOR                                                   
MFA-TR*               ,FAC_CHRG_BASE_AM                                         
MFA-TR*               ,LAST_UPDATE_TS                                           
MFA-TR*               ,DURATION_REMAIN_NO                                       
MFA-TR*               ,RT_PKG_OPT_SEQ_NO                                        
MFA-TR*               ,BLOCK_NO)                                                
MFA-TR*       VALUES (:FF-ACCOUNT-NO                                            
MFA-TR*              ,:FF-CODE-UTIL-TYPE                                        
MFA-TR*              ,:FF-IC-NO                                                 
MFA-TR*              ,:FF-FIXED-FCTR-SEQ-NO                                     
MFA-TR*              ,:FF-FACTOR-ID                                             
MFA-TR*              ,:FF-EFF-DATE-FROM                                         
MFA-TR*              ,:FF-CMPNT-ID-CD                                           
MFA-TR*              ,:FF-CODE-SEASON                                           
MFA-TR*              ,:FF-INSTR-USE-TYPE-CD                                     
MFA-TR*              ,:FF-CODE-TIME-PERIOD                                      
MFA-TR*              ,:FF-EFF-DATE-TO                                           
MFA-TR*              ,:FF-FIXED-FCTR-TYP-CD                                     
MFA-TR*              ,:FF-FACTOR                                                
MFA-TR*              ,:FF-FAC-CHRG-BASE-AM                                      
MFA-TR*              , CURRENT TIMESTAMP                                        
MFA-TR*              , NULL                                                     
MFA-TR*              ,:FF-RT-PKG-OPT-SEQ-NO                                     
MFA-TR*              ,:FF-BLOCK-NO)                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8000'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSS_FIXED_FCTR'      TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE 'FIXED_FCTR_SEQ_NO'   TO TABLE-ELEMENT-4             
              MOVE FF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE FF-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE FF-IC-NO              TO HOSTVAR-ELEMENT-3           
              MOVE FF-FIXED-FCTR-SEQ-NO  TO HOSTVAR-ELEMENT-4           
              PERFORM 9900-TERMINATE  THRU  9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** UPDATE FIXED FCTR DATA                                      **         
      *****************************************************************         
      *                                                                         
       8025-UPDATE-FIXED-FCTR.                                          
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_FIXED_FCTR                                     
                 SET EFF_DATE_TO       = IIF(TRY_CONVERT(DATE, 
                                                        :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )                
                    ,LAST_UPDATE_TS    =  CIS.CURRENT$TIMESTAMP()             
               WHERE ACCOUNT_NO        = :FF-ACCOUNT-NO                 
                 AND CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE             
                 AND IC_NO             = :FF-IC-NO                      
                 AND FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO          
                 AND FACTOR_ID         = :FF-FACTOR-ID                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_FIXED_FCTR                                             
MFA-TR*          SET EFF_DATE_TO       = :FF-EFF-DATE-TO                        
MFA-TR*             ,LAST_UPDATE_TS    =  CURRENT TIMESTAMP                     
MFA-TR*        WHERE ACCOUNT_NO        = :FF-ACCOUNT-NO                         
MFA-TR*          AND CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE                     
MFA-TR*          AND IC_NO             = :FF-IC-NO                              
MFA-TR*          AND FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO                  
MFA-TR*          AND FACTOR_ID         = :FF-FACTOR-ID                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8025'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_FIXED_FCTR'      TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE 'FIXED_FCTR_SEQ_NO'   TO TABLE-ELEMENT-4             
              MOVE FF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE FF-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE FF-IC-NO              TO HOSTVAR-ELEMENT-3           
              MOVE FF-FIXED-FCTR-SEQ-NO  TO HOSTVAR-ELEMENT-4           
              PERFORM 9900-TERMINATE  THRU  9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       8025-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** DELETE FIXED FCTR DATA                                      **         
      *****************************************************************         
      *                                                                         
       8050-DELETE-FIXED-FCTR.                                          
      *                                                                         
           EXEC SQL                                                     
              DELETE FROM CSS_FIXED_FCTR                                
               WHERE ACCOUNT_NO        = :FF-ACCOUNT-NO                 
                 AND CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE             
                 AND IC_NO             = :FF-IC-NO                      
                 AND FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO          
                 AND FACTOR_ID         = :FF-FACTOR-ID                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8050'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_FIXED_FCTR'      TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE 'FIXED_FCTR_SEQ_NO'   TO TABLE-ELEMENT-4             
              MOVE FF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE FF-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE FF-IC-NO              TO HOSTVAR-ELEMENT-3           
              MOVE FF-FIXED-FCTR-SEQ-NO  TO HOSTVAR-ELEMENT-4           
              PERFORM 9900-TERMINATE  THRU  9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       8050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** INSERT TRANSACTION HISTORY HEADER DATA                      **         
      *****************************************************************         
      *                                                                         
       8500-INSERT-MNT-TRANS-HIST.                                      
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_MNT_TRANS_HIST                            
                     ( TRANS_HIST_SEQ_NO                                
                      ,DATE_TRANS                                       
                      ,CODE_TRAN_TYPE                                   
                      ,RESP_AREA_ID                                     
                      ,ACCOUNT_NO                                       
                      ,CUSTOMER_NO                                      
                      ,PREMISE_NO                                       
                      ,USER_ID                                          
                      ,APPL_PROGRAM_ID                                  
                      ,TRAN_COMMENT                                     
                      ,LAST_UPDATE_TS)                                  
              VALUES (CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO)                 
                     ,IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) )                               
                     ,:MH-CODE-TRAN-TYPE                                
                     ,:MH-RESP-AREA-ID                                  
                     ,:MH-ACCOUNT-NO                                    
                     ,:MH-CUSTOMER-NO                                   
                     ,:MH-PREMISE-NO                                    
                     ,:MH-USER-ID                                       
                     ,:MH-APPL-PROGRAM-ID                               
                     ,:MH-TRAN-COMMENT                                  
                     , CIS.CURRENT$TIMESTAMP())                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_MNT_TRANS_HIST                                    
MFA-TR*              ( TRANS_HIST_SEQ_NO                                        
MFA-TR*               ,DATE_TRANS                                               
MFA-TR*               ,CODE_TRAN_TYPE                                           
MFA-TR*               ,RESP_AREA_ID                                             
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,CUSTOMER_NO                                              
MFA-TR*               ,PREMISE_NO                                               
MFA-TR*               ,USER_ID                                                  
MFA-TR*               ,APPL_PROGRAM_ID                                          
MFA-TR*               ,TRAN_COMMENT                                             
MFA-TR*               ,LAST_UPDATE_TS)                                          
MFA-TR*       VALUES (:MH-TRANS-HIST-SEQ-NO                                     
MFA-TR*              ,:MH-DATE-TRANS                                            
MFA-TR*              ,:MH-CODE-TRAN-TYPE                                        
MFA-TR*              ,:MH-RESP-AREA-ID                                          
MFA-TR*              ,:MH-ACCOUNT-NO                                            
MFA-TR*              ,:MH-CUSTOMER-NO                                           
MFA-TR*              ,:MH-PREMISE-NO                                            
MFA-TR*              ,:MH-USER-ID                                               
MFA-TR*              ,:MH-APPL-PROGRAM-ID                                       
MFA-TR*              ,:MH-TRAN-COMMENT                                          
MFA-TR*              , CURRENT TIMESTAMP)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8500'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSS_MNT_TRANS_HIST'  TO TABLE-1                     
              MOVE 'TRANS_HIST_SEQ_NO'   TO TABLE-ELEMENT-1             
              MOVE 'DATE_TRANS'          TO TABLE-ELEMENT-2             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
              MOVE MH-TRANS-HIST-SEQ-NO  TO HOSTVAR-ELEMENT-1           
              MOVE MH-DATE-TRANS         TO HOSTVAR-ELEMENT-2           
              MOVE MH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-3           
              PERFORM 9900-TERMINATE  THRU  9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** INSERT TRANSACTION HISTORY DETAILS DATA                     **         
      *****************************************************************         
      *                                                                         
       8550-INSERT-MT-TRN-HST-DET.                                      
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_MT_TRN_HST_DET                            
                     ( TRANS_HIST_SEQ_NO                                
                      ,TRAN_APPL_NO                                     
                      ,COLUMN_DESC                                      
                      ,TABLE_ID                                         
                      ,PRV_COLUMN_VALUE                                 
                      ,CHG_COLUMN_VALUE                                 
                      ,LAST_UPDATE_TS)                                  
              VALUES (CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO)                 
                     ,:MI-TRAN-APPL-NO                                  
                     ,:MI-COLUMN-DESC                                   
                     ,:MI-TABLE-ID                                      
                     ,:MI-PRV-COLUMN-VALUE                              
                     ,:MI-CHG-COLUMN-VALUE                              
                     , CIS.CURRENT$TIMESTAMP())                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_MT_TRN_HST_DET                                    
MFA-TR*              ( TRANS_HIST_SEQ_NO                                        
MFA-TR*               ,TRAN_APPL_NO                                             
MFA-TR*               ,COLUMN_DESC                                              
MFA-TR*               ,TABLE_ID                                                 
MFA-TR*               ,PRV_COLUMN_VALUE                                         
MFA-TR*               ,CHG_COLUMN_VALUE                                         
MFA-TR*               ,LAST_UPDATE_TS)                                          
MFA-TR*       VALUES (:MI-TRANS-HIST-SEQ-NO                                     
MFA-TR*              ,:MI-TRAN-APPL-NO                                          
MFA-TR*              ,:MI-COLUMN-DESC                                           
MFA-TR*              ,:MI-TABLE-ID                                              
MFA-TR*              ,:MI-PRV-COLUMN-VALUE                                      
MFA-TR*              ,:MI-CHG-COLUMN-VALUE                                      
MFA-TR*              , CURRENT TIMESTAMP)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8550'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSS_MT_TRN_HST_DET'  TO TABLE-1                     
              MOVE 'TRANS_HIST_SEQ_NO'   TO TABLE-ELEMENT-1             
              MOVE 'TRAN_APPL_NO'        TO TABLE-ELEMENT-2             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
              MOVE MI-TRANS-HIST-SEQ-NO  TO HOSTVAR-ELEMENT-1           
              MOVE MI-TRAN-APPL-NO       TO HOSTVAR-ELEMENT-2           
              MOVE MH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-3           
              PERFORM 9900-TERMINATE  THRU  9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       8550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9900-TERMINATE.                                                  
      *                                                                         
           IF PROGRAM-NAME = 'SCSCA444'                                 
              EXIT PROGRAM                                              
           ELSE                                                         
              GOBACK                                                    
           END-IF.                                                      
      *                                                                         
       9900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
