      *****************************************************************         
      **  CPD00426 COPYBOOK TO RETRIEVE TAX DETAILS AND PERCENTAGE.  **         
      **                     RELEASE 1.0                             **         
      **.............................................................**         
      **.............................................................**         
      **NOTE: WHEN MODIFYING THIS MEMBER, MEMBER CWS00426 & CWS00427 **         
      **      SHOULD BE EVALUATED FOR CORRESPONDING MODIFICATIONS.   **         
      **.............................................................**         
      **  WS-REFERENCE:  TABLES:     TBACCT                          **         
      **                             TBJBPARM                        **         
      **                             TBUTLENV                        **         
      **                             TBREVCLS                        **         
      **                             TBFTXXMP                        **         
      **                             TBTXCNTL                        **         
      **                             TBTXRATE                        **         
      **                             TBTXUSE                         **         
      **                             TBTXMPCD                        **         
      **                                                             **         
      **  PROCEDURE REFERENCE:                                       **         
      **                                                             **         
      **  PREREQUISITES: CWS00426 & CWS00427                         **         
      **                                                             **         
      **  ADDITIONAL INFORMATION:                                    **         
      **    THIS COPYBOOK CAN BE CALLED FROM BATCH AND ONLINE, AND   **         
      **    GET ALL THE CURRENT TAX DETAIL INFORMATION. BEFORE       **         
      **    CALLING THIS COPYBOOK, PASS A VALID REVENUE DIST CODE    **         
      **    AND ENERGY FLAG. ALL OTHER INPUT VARIABLES ARE OPTIONAL. **         
      **                                                             **         
      **    THIS COPY BOOK DOES AN ADDITIONAL PROCESSING TO GET ACCT **         
      **    LEVEL EXEMPTION DETAILS, IF ACCOUNT NO, UTIL TYPE AND    **         
      **    IC INFORMATION SUPPLIED.                                 **         
      **                                                             **         
      *****************************************************************         
      *****************************************************************         
      *   MODIFICATION LOG -                                          *         
      *                                                               *         
      *   DATE     INITIALS        COMMENTS                           *         
      *  ------    --------        -----------------------------------*         
I00174* 11/22/08   JC91900         INTIALLY WRITTEN.                  *         
A04359* 11/29/12   HA7A338         SALES TAX EXEMPTION CHANGES FOR SEB*         
A04359*                            GEORGIA MANUFACTURER CUSTOMERS     *         
P00794* 04/15/14   MC95456         PSNC TAX DETAILS SCREEN CHANGES    *         
P794FX* 07/01/14   SS97726         PROD FIX.                          *         
      *****************************************************************         
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6000-GET-TAX-DETAILS.                                         *         
      *****************************************************************         
       6000-GET-TAX-DETAILS.                                            
                                                                        
           INITIALIZE WS-426-NULL-IND                                   
                     ,ABEND-FILE                                        
                     ,WS-ACTIVE-RETURN-CODE                             
                     ,LS-CPD00426-RET-FIELDS                            
                     ,WS-426-VARS.                                      
                                                                        
           PERFORM 6010-VALIDATE-INPUT          THRU 6010-EXIT.         
           PERFORM 6020-PROCESS-INPUT           THRU 6020-EXIT.         
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6010-VALIDATE-INPUT.                                          *         
      *****************************************************************         
       6010-VALIDATE-INPUT.                                             
                                                                        
           IF WS-426-ACCOUNT-NO > ZEROES AND WS-426-IC-NO > ZEROES      
                                     AND WS-426-CODE-UTIL-TYPE > SPACES 
              SET ACCOUNT-INFO-FOUND TO TRUE                            
           END-IF.                                                      
                                                                        
           IF WS-426-CODE-REV-CLASS > SPACES                            
              SET REV-CLASS-FOUND TO TRUE                               
           END-IF.                                                      
                                                                        
           IF WS-426-REVENUE-DIST-CD > SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '6010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'RECEIVE INPUT'           TO ABEND-FUNCTION          
              MOVE 'REV DIST CD'             TO TABLE-ELEMENT-1         
              MOVE WS-426-REVENUE-DIST-CD    TO HOSTVAR-ELEMENT-1       
              MOVE +1010                     TO WS-ACTIVE-RETURN-CODE   
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
           IF WS-426-COMPANY-NO > SPACES                                
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '6010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'RECEIVE INPUT'           TO ABEND-FUNCTION          
              MOVE 'COMPANY NO'              TO TABLE-ELEMENT-1         
              MOVE WS-426-COMPANY-NO         TO HOSTVAR-ELEMENT-1       
              MOVE +1020                     TO WS-ACTIVE-RETURN-CODE   
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       6010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *                                                              *          
      * 6020-PROCESS-INPUT.                                          *          
      ****************************************************************          
       6020-PROCESS-INPUT.                                              
                                                                        
A04359     MOVE 'DATABASE'                   TO C8-DELINQ-CD.           
A04359     MOVE '01'                         TO C8-COMPANY-NO.          
A04359     PERFORM 7080-SELECT-DELINQ         THRU 7080-EXIT.           
P00794     MOVE C8-DELINQ-VALUE              TO WS-DATABASE.            
A04359                                                                  
           MOVE WS-426-REVENUE-DIST-CD       TO TU-DETAIL-ID            
                                                F2-REV-DISTRICT-CD.     
                                                                        
           IF ACCOUNT-INFO-FOUND                                        
              PERFORM 6300-GET-UTIL-INFO        THRU 6300-EXIT          
           END-IF.                                                      
                                                                        
           MOVE WS-426-CODE-REV-CLASS        TO F3-CODE-REVENUE-CLASS   
                                                F2-CODE-REVENUE-CLASS.  
           MOVE WS-426-COMPANY-NO            TO F3-COMPANY-NO           
                                                F2-COMPANY-NO.          
           PERFORM 6030-CALCULATE-DATES         THRU 6030-EXIT.         
                                                                        
           IF REV-CLASS-FOUND                                           
              PERFORM 7020-SEL-FRNCHS-TX-XMPT   THRU 7020-EXIT          
              PERFORM 7030-SEL-STATE-TX-XMPT    THRU 7030-EXIT          
           END-IF                                                       
                                                                        
           IF FRNCHS-TX-XMPT                                            
              MOVE 'Y'                       TO WS-CT-TAX-XMPT-REV-DST  
           ELSE                                                         
              IF ACCOUNT-INFO-FOUND AND UT-CODE-CITY-TAX-XMT = 'Y'      
                 SET FRNCHS-TX-XMPT TO TRUE                             
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF STATE-TX-XMPT                                             
              MOVE 'Y'                       TO WS-ST-TAX-XMPT-REV-CLS  
           ELSE                                                         
              IF ACCOUNT-INFO-FOUND AND UT-CODE-STAT-TAX-XMT > SPACES   
                                    AND WS-PARTIAL-XMPT-CD EQUAL SPACES 
                 SET STATE-TX-XMPT TO TRUE                              
              END-IF                                                    
           END-IF.                                                      
                                                                        
P00794     IF WS-426-COMPANY-NO = '26'                                  
P00794        MOVE WS-426-COMPANY-NO               TO C8-COMPANY-NO     
P00794        MOVE 'WS-CHANGE-PSNC-TAX'            TO C8-DELINQ-CD      
P00794        PERFORM 7080-SELECT-DELINQ           THRU 7080-EXIT       
P00794        MOVE C8-DELINQ-VALUE                 TO WS-PSNC-TAX       
P00794     END-IF.                                                      
                                                                        
P00794     IF WS-426-COMPANY-NO = '26' AND WS-PSNC-TAX = 1              
              IF UT-CODE-STAT-TAX-XMT > SPACES                          
                              AND WS-PARTIAL-XMPT-CD EQUAL SPACES       
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM 6200-GET-TAX-EXCISE-DET   THRU 6200-EXIT       
              END-IF                                                    
           ELSE                                                         
              IF WS-426-ENERGY-FLAG > SPACES                            
                 PERFORM 6100-LOAD-TAX-INFO        THRU 6100-EXIT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
       6020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6030-CALCULATE-DATES.                                         *         
      *****************************************************************         
       6030-CALCULATE-DATES.                                            
                                                                        
           IF ACCOUNT-INFO-FOUND AND AT-REV-MTH-LST-NRML > ZEROES       
             MOVE AT-REV-MTH-LST-NRML        TO WS-REV-MTH-LST-NRML     
             MOVE WS-REV-MTH-LST-NRML        TO WS-REV-MTH-LST-NRML-C   
             MOVE WS-REV-MTH-LST-NRML-C(1:4) TO WS-START-YR             
             MOVE WS-REV-MTH-LST-NRML-C(5:2) TO WS-START-MT             
             MOVE '01'                       TO WS-START-DY             
                                                                        
             MOVE WS-START-DATE              TO WS-DUMMY-DATE           
             PERFORM 7060-ADD-ONE-MONTH         THRU 7060-EXIT          
             MOVE WS-RESULT-DATE             TO TR-DATE-FROM            
                                                TR-DATE-TO              
                                                X6-DATE-FROM            
                                                                        
           ELSE                                                         
             MOVE  20                        TO G6-SEQ-NO               
             MOVE '01'                       TO G6-COMPANY-NO           
             MOVE 'DATE'                     TO G6-CMND-CODE            
             MOVE 'COMMON'                   TO G6-PROGRAM-NAME         
             PERFORM 7070-SELECT-JOB-PARM       THRU 7070-EXIT          
             MOVE G6-PARM-DATA(15:6)         TO WS-COM-REV-MONTH        
             MOVE WS-COM-REV-MONTH(1:4)      TO WS-START-YR             
             MOVE WS-COM-REV-MONTH(5:2)      TO WS-START-MT             
             MOVE '01'                       TO WS-START-DY             
             MOVE WS-START-DATE              TO TR-DATE-FROM            
                                                TR-DATE-TO              
                                                X6-DATE-FROM            
           END-IF.                                                      
                                                                        
       6030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *                                                              *          
      * 6100-LOAD-TAX-INFO.                                          *          
      ****************************************************************          
       6100-LOAD-TAX-INFO.                                              
                                                                        
           MOVE 'N'                          TO WS-NO-MORE-ROWS         
           PERFORM 7350-OPEN-TAX-RATE-CSR       THRU 7350-EXIT          
           PERFORM 7355-FETCH-TAX-RATE-CSR      THRU 7355-EXIT          
           PERFORM 6510-PROCESS-TAX-RATES       THRU 6510-EXIT          
                                                UNTIL NO-MORE-ROWS      
           PERFORM 7360-CLOSE-TAX-RATE-CSR      THRU 7360-EXIT.         
                                                                        
       6100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6200-GET-TAX-EXCISE-DET.                                      *         
      *****************************************************************         
       6200-GET-TAX-EXCISE-DET.                                         
                                                                        
           IF WS-PARTIAL-XMPT-CD > SPACES                               
              MOVE +13                       TO X6-TAX-CNTRL-NO         
           ELSE                                                         
              MOVE +11                       TO X6-TAX-CNTRL-NO         
           END-IF                                                       
                                                                        
           MOVE 'N'                          TO WS-NO-MORE-ROWS         
           PERFORM 7300-OPEN-TAX-EXCISE-CSR     THRU 7300-EXIT          
           PERFORM 7305-FETCH-TAX-EXCISE-CSR    THRU 7305-EXIT          
           PERFORM 6500-PROCESS-TAX-EXCISE      THRU 6500-EXIT          
                                                UNTIL NO-MORE-ROWS      
           PERFORM 7310-CLOSE-TAX-EXCISE-CSR    THRU 7310-EXIT.         
                                                                        
       6200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6300-GET-UTIL-INFO.                                           *         
      *****************************************************************         
       6300-GET-UTIL-INFO.                                              
                                                                        
           MOVE WS-426-ACCOUNT-NO            TO AT-ACCOUNT-NO           
                                                UT-ACCOUNT-NO           
           MOVE WS-426-IC-NO                 TO UT-IC-NO                
           MOVE WS-426-CODE-UTIL-TYPE        TO UT-CODE-UTIL-TYPE       
                                                F3-CODE-UTIL-TYPE       
                                                F2-CODE-UTIL-TYPE       
                                                                        
           PERFORM 7000-SELECT-ACCT-DETAILS  THRU 7000-EXIT             
           MOVE AT-COMPANY-NO                TO WS-426-COMPANY-NO       
                                                                        
           PERFORM 7010-SELECT-UTIL-ENVRNMT     THRU 7010-EXIT          
                                                                        
           MOVE UT-CODE-REVENUE-CLASS        TO WS-426-CODE-REV-CLASS   
                                                WS-CODE-REV-CLASS-UT    
           MOVE UT-STATE-TAX-EXMPT-NO        TO WS-ST-TAX-EXMPT-NO-UT   
           MOVE UT-CODE-STAT-TAX-XMT         TO WS-CODE-STAT-TAX-XMT-UT 
           MOVE UT-CODE-CITY-TAX-XMT         TO WS-CODE-CITY-TAX-XMT-UT 
                                                                        
           IF UT-CODE-STAT-TAX-XMT > SPACES                             
              MOVE UT-CODE-STAT-TAX-XMT   TO F1-TAX-EXEMPT-CODE         
              PERFORM 7050-SEL-TAX-XMPT-CD   THRU 7050-EXIT             
              IF F1-PARTIAL-EXEMPT-CD > SPACES                          
                 MOVE F1-PARTIAL-EXEMPT-CD TO WS-PARTIAL-XMPT-CD        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       6300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6500-PROCESS-TAX-EXCISE.                                      *         
      *****************************************************************         
       6500-PROCESS-TAX-EXCISE.                                         
                                                                        
           ADD +01                    TO WS-TAX-INDX.                   
                                                                        
           MOVE X6-BLOCK-NO           TO WS-BLOCK-NO(WS-TAX-INDX).      
           MOVE X6-BLOCK-UNITS        TO WS-BLOCK-UNITS(WS-TAX-INDX).   
           MOVE X6-DATE-FROM          TO WS-DATE-FROM(WS-TAX-INDX).     
           MOVE X6-TAX-CNTRL-NO       TO WS-TAX-CNTRL-NO(WS-TAX-INDX).  
           MOVE X6-EXCISE-TAX-UNIT-AM                                   
                                 TO WS-EXCISE-TAX-UNIT-AM(WS-TAX-INDX). 
                                                                        
           PERFORM 7305-FETCH-TAX-EXCISE-CSR    THRU 7305-EXIT.         
                                                                        
       6500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6510-PROCESS-TAX-RATES.                                       *         
      *****************************************************************         
       6510-PROCESS-TAX-RATES.                                          
                                                                        
           EVALUATE WS-426-ENERGY-FLAG                                  
              WHEN 'G'                                                  
                   IF TU-TAX-GAS = 'Y' AND TU-CODE-TAX-CALC-INST = 'R'  
                      PERFORM 6520-MOVE-TAX-DETAILS THRU 6520-EXIT      
                   END-IF                                               
              WHEN 'E'                                                  
                   IF TU-TAX-ELEC = 'Y' AND TU-CODE-TAX-CALC-INST = 'R' 
                      PERFORM 6520-MOVE-TAX-DETAILS THRU 6520-EXIT      
                   END-IF                                               
           END-EVALUATE.                                                
                                                                        
           PERFORM 7355-FETCH-TAX-RATE-CSR      THRU 7355-EXIT.         
                                                                        
       6510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6520-MOVE-TAX-DETAILS.                                        *         
      *****************************************************************         
       6520-MOVE-TAX-DETAILS.                                           
                                                                        
           ADD +01                    TO WS-TAX-RATE-INDX.              
           MOVE SPACES                TO  SF-FACTOR-TEXT                
           MOVE ZEROES                TO  SF-GL-ACCT-NO                 
                                                                        
           IF TC-FACTOR-ID NOT EQUAL SPACES                             
              MOVE SPACES             TO  SF-FACTOR-TEXT                
              MOVE ZEROES             TO  SF-GL-ACCT-NO                 
              MOVE TC-FACTOR-ID          TO SF-FACTOR-ID                
              PERFORM 7040-SEL-SPCL-FCTR    THRU 7040-EXIT              
           END-IF.                                                      
                                                                        
A04359     IF SEB-DATABASE                                              
A04359              AND UT-CODE-STAT-TAX-XMT = WS-GA-MFG-SALES-TAX-XMT  
A04359        PERFORM 7090-SEL-XMT-TAX-RATE   THRU 7090-EXIT            
A04359                                                                  
A04359        IF TC-TAX-CNTRL-NO NOT EQUAL STATE-TAX                    
A04359         AND TC-TAX-CNTRL-NO NOT EQUAL CITY-TAX                   
CRISPC           IF TC-CODE-APPL-COND NOT EQUAL WS-GA-MFG-SALES-TAX-XMT 
A04359              ADD TR-TAX-RATE          TO WS-TOT-OTHER-TAX        
CRISPC           END-IF                                                 
A04359           COMPUTE TR-TAX-RATE ROUNDED =                          
A04359                   TR-TAX-RATE * X6-EXCISE-TAX-UNIT-AM            
A04359           ADD TR-TAX-RATE             TO WS-TOT-OTHER-TAX-XMT    
A04359        END-IF                                                    
A04359                                                                  
A04359        IF TC-TAX-CNTRL-NO EQUAL STATE-TAX                        
A04359           COMPUTE TR-TAX-RATE ROUNDED = WS-TOT-OTHER-TAX-XMT  +  
A04359                                        (X6-EXCISE-TAX-UNIT-AM *  
A04359                                (TR-TAX-RATE - WS-TOT-OTHER-TAX)) 
A04359        END-IF                                                    
A04359     ELSE                                                         
P794FX        IF TC-TAX-CNTRL-NO EQUAL (STATE-TAX OR PSNC-SALES-TAX)    
P794FX                              AND STATE-TX-XMPT                   
                 MOVE ZEROES                    TO TR-TAX-RATE          
              END-IF                                                    
A04359     END-IF                                                       
                                                                        
           IF TC-TAX-CNTRL-NO EQUAL CITY-TAX AND FRNCHS-TX-XMPT         
              MOVE ZEROES                    TO TR-TAX-RATE             
           END-IF                                                       
                                                                        
           MOVE TR-TAX-RATE           TO WS-TAX-RATE(WS-TAX-RATE-INDX). 
           MOVE TC-TAX-CNTRL-NO       TO WS-TAX-TYPE(WS-TAX-RATE-INDX)  
           MOVE SF-GL-ACCT-NO         TO                                
                                      WS-GL-ACCT-NO(WS-TAX-RATE-INDX).  
           MOVE SF-FACTOR-TEXT        TO WS-TAX-TEXT(WS-TAX-RATE-INDX). 
                                                                        
       6520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7000-SELECT-ACCT-DETAILS.                                     *         
      *****************************************************************         
       7000-SELECT-ACCT-DETAILS.                                        
                                                                        
           EXEC SQL                                                     
              SELECT AT.REV_MTH_LST_NRML                                
                    ,AT.COMPANY_NO                                      
                INTO :AT-REV-MTH-LST-NRML                               
                    ,:AT-COMPANY-NO                                     
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.REV_MTH_LST_NRML                                        
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*         INTO :AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7010-SELECT-UTIL-ENVRNMT.                                     *         
      *****************************************************************         
       7010-SELECT-UTIL-ENVRNMT.                                        
                                                                        
           EXEC SQL                                                     
               SELECT UT.CODE_STAT_TAX_XMT                              
                     ,UT.CODE_CITY_TAX_XMT                              
                     ,UT.STATE_TAX_EXMPT_NO                             
                     ,UT.CODE_REVENUE_CLASS                             
                 INTO :UT-CODE-STAT-TAX-XMT                             
                     ,:UT-CODE-CITY-TAX-XMT                             
                     ,:UT-STATE-TAX-EXMPT-NO                            
                     ,:UT-CODE-REVENUE-CLASS                            
                 FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                
                  AND UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE            
                  AND UT.IC_NO          = :UT-IC-NO                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT UT.CODE_STAT_TAX_XMT                                      
MFA-TR*              ,UT.CODE_CITY_TAX_XMT                                      
MFA-TR*              ,UT.STATE_TAX_EXMPT_NO                                     
MFA-TR*              ,UT.CODE_REVENUE_CLASS                                     
MFA-TR*          INTO :UT-CODE-STAT-TAX-XMT                                     
MFA-TR*              ,:UT-CODE-CITY-TAX-XMT                                     
MFA-TR*              ,:UT-STATE-TAX-EXMPT-NO                                    
MFA-TR*              ,:UT-CODE-REVENUE-CLASS                                    
MFA-TR*          FROM CSS_UTIL_ENVRNMT UT                                       
MFA-TR*         WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                        
MFA-TR*           AND UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                    
MFA-TR*           AND UT.IC_NO          = :UT-IC-NO                             
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              SET REV-CLASS-FOUND TO TRUE                               
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7030'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE UT-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE UT-IC-NO                  TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7020-SEL-FRNCHS-TX-XMPT.                                      *         
      *****************************************************************         
       7020-SEL-FRNCHS-TX-XMPT.                                         
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-FRNCHS-TX-XMPT                                 
                FROM CSS_FRNCHS_TX_XMPT F2 WITH(READUNCOMMITTED)                
               WHERE F2.REV_DISTRICT_CD    = :F2-REV-DISTRICT-CD        
                 AND F2.CODE_REVENUE_CLASS = :F2-CODE-REVENUE-CLASS     
                 AND F2.CODE_UTIL_TYPE     = :F2-CODE-UTIL-TYPE         
                 AND F2.COMPANY_NO         = :F2-COMPANY-NO             
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-FRNCHS-TX-XMPT                                         
MFA-TR*         FROM CSS_FRNCHS_TX_XMPT F2                                      
MFA-TR*        WHERE F2.REV_DISTRICT_CD    = :F2-REV-DISTRICT-CD                
MFA-TR*          AND F2.CODE_REVENUE_CLASS = :F2-CODE-REVENUE-CLASS             
MFA-TR*          AND F2.CODE_UTIL_TYPE     = :F2-CODE-UTIL-TYPE                 
MFA-TR*          AND F2.COMPANY_NO         = :F2-COMPANY-NO                     
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE ZEROES                 TO WS-ACTIVE-RETURN-CODE   
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_FRNCHS_TX_XMPT'      TO TABLE-1                 
              MOVE 'REV_DISTRICT_CD'         TO TABLE-ELEMENT-1         
              MOVE 'CODE_REVENUE_CLASS'      TO TABLE-ELEMENT-2         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-3         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-4         
              MOVE F2-REV-DISTRICT-CD        TO HOSTVAR-ELEMENT-1       
              MOVE F2-CODE-REVENUE-CLASS     TO HOSTVAR-ELEMENT-2       
              MOVE F2-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-3       
              MOVE F2-COMPANY-NO             TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7030-SEL-STATE-TX-XMPT.                                       *         
      *****************************************************************         
       7030-SEL-STATE-TX-XMPT.                                          
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-STATE-TX-XMPT                                  
                FROM CSS_REVENUE_CLASS F3 WITH(READUNCOMMITTED)                 
               WHERE F3.CODE_REVENUE_CLASS = :F3-CODE-REVENUE-CLASS     
                 AND F3.CODE_UTIL_TYPE     = :F3-CODE-UTIL-TYPE         
                 AND F3.COMPANY_NO         = :F3-COMPANY-NO             
                 AND F3.ST_TAX_XMPT_IND    = 'Y'                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-STATE-TX-XMPT                                          
MFA-TR*         FROM CSS_REVENUE_CLASS F3                                       
MFA-TR*        WHERE F3.CODE_REVENUE_CLASS = :F3-CODE-REVENUE-CLASS             
MFA-TR*          AND F3.CODE_UTIL_TYPE     = :F3-CODE-UTIL-TYPE                 
MFA-TR*          AND F3.COMPANY_NO         = :F3-COMPANY-NO                     
MFA-TR*          AND F3.ST_TAX_XMPT_IND    = 'Y'                                
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE ZEROES                 TO WS-ACTIVE-RETURN-CODE   
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7030'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_REVENUE_CLASS'       TO TABLE-1                 
              MOVE 'CODE_REVENUE_CLASS'      TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-3         
              MOVE F3-CODE-REVENUE-CLASS     TO HOSTVAR-ELEMENT-1       
              MOVE F3-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE F3-COMPANY-NO             TO HOSTVAR-ELEMENT-3       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7040-SEL-SPCL-FCTR.                                           *         
      *****************************************************************         
       7040-SEL-SPCL-FCTR.                                              
                                                                        
           EXEC SQL                                                     
              SELECT SF.FACTOR_TEXT                                     
                    ,SF.GL_ACCT_NO                                      
                INTO :SF-FACTOR-TEXT                                    
                    ,:SF-GL-ACCT-NO                                     
                FROM CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                     
               WHERE SF.FACTOR_ID = :SF-FACTOR-ID                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SF.FACTOR_TEXT                                             
MFA-TR*             ,SF.GL_ACCT_NO                                              
MFA-TR*         INTO :SF-FACTOR-TEXT                                            
MFA-TR*             ,:SF-GL-ACCT-NO                                             
MFA-TR*         FROM CSS_SPCL_FCTR SF                                           
MFA-TR*        WHERE SF.FACTOR_ID = :SF-FACTOR-ID                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE ZEROES                 TO WS-ACTIVE-RETURN-CODE   
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7040'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR'           TO TABLE-1                 
              MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-1         
              MOVE SF-FACTOR-ID              TO HOSTVAR-ELEMENT-1       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7050-SEL-TAX-XMPT-CD.                                         *         
      *****************************************************************         
       7050-SEL-TAX-XMPT-CD.                                            
                                                                        
           EXEC SQL                                                     
               SELECT F1.PARTIAL_EXEMPT_CD                              
                 INTO :F1-PARTIAL-EXEMPT-CD                             
                 FROM CSS_TAX_EXMPT_CODE F1 WITH(READUNCOMMITTED)               
                WHERE F1.TAX_EXEMPT_CODE = :F1-TAX-EXEMPT-CODE          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT F1.PARTIAL_EXEMPT_CD                                      
MFA-TR*          INTO :F1-PARTIAL-EXEMPT-CD                                     
MFA-TR*          FROM CSS_TAX_EXMPT_CODE F1                                     
MFA-TR*         WHERE F1.TAX_EXEMPT_CODE = :F1-TAX-EXEMPT-CODE                  
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE ZEROES                 TO WS-ACTIVE-RETURN-CODE   
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7050'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_TAX_EXMPT_CODE'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'TAX_EXEMPT_CODE'         TO TABLE-ELEMENT-2         
              MOVE WS-426-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1       
              MOVE F1-TAX-EXEMPT-CODE        TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7060-ADD-ONE-MONTH.                                           *         
      *****************************************************************         
       7060-ADD-ONE-MONTH.                                              
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( MONTH, 1, IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE
              ) <> 0) OR (LEN(:WS-DUMMY-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-DUMMY-DATE
              ), CONVERT(DATE, :WS-DUMMY-DATE) ) )
            INTO
              :WS-RESULT-DATE     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-RESULT-DATE = DATE(:WS-DUMMY-DATE)  + 1 MONTH             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7060'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SET'                     TO ABEND-FUNCTION          
              MOVE 'CSS_MODEL_SQL'           TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'DUMMY_DATE'              TO TABLE-ELEMENT-2         
              MOVE WS-426-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1       
              MOVE WS-DUMMY-DATE             TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7070-SELECT-JOB-PARM.                                         *         
      *****************************************************************         
       7070-SELECT-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
              SELECT G6.PARM_DATA                                       
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                      
               WHERE G6.PROGRAM_NAME   = :G6-PROGRAM-NAME               
                 AND G6.CMND_CODE      = :G6-CMND-CODE                  
                 AND G6.COMPANY_NO     = :G6-COMPANY-NO                 
                 AND G6.SEQ_NO         = :G6-SEQ-NO                     
                 AND G6.STATUS         = 'A'                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT G6.PARM_DATA                                               
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM G6                                            
MFA-TR*        WHERE G6.PROGRAM_NAME   = :G6-PROGRAM-NAME                       
MFA-TR*          AND G6.CMND_CODE      = :G6-CMND-CODE                          
MFA-TR*          AND G6.COMPANY_NO     = :G6-COMPANY-NO                         
MFA-TR*          AND G6.SEQ_NO         = :G6-SEQ-NO                             
MFA-TR*          AND G6.STATUS         = 'A'                                    
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7070'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_JOB_PARM'            TO TABLE-1                 
              MOVE 'PROGRAM_NAME'            TO TABLE-ELEMENT-1         
              MOVE 'CMND_CODE'               TO TABLE-ELEMENT-2         
              MOVE G6-PROGRAM-NAME           TO HOSTVAR-ELEMENT-1       
              MOVE G6-CMND-CODE              TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04359*****************************************************************         
A04359*                                                               *         
A04359* 7080-SELECT-DELINQ.                                           *         
A04359*****************************************************************         
A04359 7080-SELECT-DELINQ.                                              
A04359                                                                  
A04359     EXEC SQL                                                     
A04359        SELECT DELINQ_VALUE                                       
A04359          INTO :C8-DELINQ-VALUE                                   
A04359          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
A04359         WHERE DELINQ_CD  = :C8-DELINQ-CD                         
A04359           AND COMPANY_NO = :C8-COMPANY-NO                        
A04359                                                           
A04359     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04359                                                                  
A04359     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A04359                                                                  
A04359     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00974        CONTINUE                                                  
A04359     ELSE                                                         
A04359        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
A04359        MOVE '7080'                    TO ACTIVE-PARAGRAPH        
A04359        MOVE 'SELECT'                  TO ABEND-FUNCTION          
A04359        MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
A04359        MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-1         
A04359        MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
A04359        MOVE C8-DELINQ-CD              TO HOSTVAR-ELEMENT-1       
A04359        MOVE C8-COMPANY-NO             TO HOSTVAR-ELEMENT-2       
A04359        PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
A04359     END-IF.                                                      
A04359                                                                  
A04359 7080-EXIT.                                                       
A04359     EXIT.                                                        
A04359                                                                  
A04359*****************************************************************         
A04359*                                                               *         
A04359* 7090-SEL-XMT-TAX-RATE.                                        *         
A04359*****************************************************************         
A04359 7090-SEL-XMT-TAX-RATE.                                           
A04359                                                                  
A04359     EXEC SQL                                                     
A04359           SELECT TOP(1) X6.EXCISE_TAX_UNIT_AM                           
A04359           INTO  :X6-EXCISE-TAX-UNIT-AM                           
A04359           FROM   CSS_TAX_EXCISE_AMT X6 WITH(READUNCOMMITTED)             
A04359           WHERE  X6.TAX_CNTRL_NO      = :TC-TAX-CNTRL-NO         
A04359           AND    X6.DATE_FROM        <= IIF(TRY_CONVERT(DATE, 
                                                          :TR-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :TR-DATE-FROM
              ) <> 0) OR (LEN(:TR-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :TR-DATE-FROM
              ), CONVERT(DATE, :TR-DATE-FROM) )            
A04359           ORDER  BY X6.DATE_FROM DESC                            
A04359                                       
A04359     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT X6.EXCISE_TAX_UNIT_AM                                   
MFA-TR*          INTO  :X6-EXCISE-TAX-UNIT-AM                                   
MFA-TR*          FROM   CSS_TAX_EXCISE_AMT X6                                   
MFA-TR*          WHERE  X6.TAX_CNTRL_NO      = :TC-TAX-CNTRL-NO                 
MFA-TR*          AND    X6.DATE_FROM        <= :TR-DATE-FROM                    
MFA-TR*          ORDER  BY X6.DATE_FROM DESC                                    
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04359                                                                  
A04359     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A04359                                                                  
A04359     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A04359        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
A04359           MOVE 1                      TO X6-EXCISE-TAX-UNIT-AM   
A04359        END-IF                                                    
A04359     ELSE                                                         
A04359        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
A04359        MOVE '7090'                    TO ACTIVE-PARAGRAPH        
A04359        MOVE 'SELECT'                  TO ABEND-FUNCTION          
A04359        MOVE 'CSS_TAX_EXCISE_AMT'      TO TABLE-1                 
A04359        MOVE 'TAX_CNTRL_NO'            TO TABLE-ELEMENT-1         
A04359        MOVE 'DATE_FROM'               TO TABLE-ELEMENT-2         
A04359        MOVE TC-TAX-CNTRL-NO           TO HOSTVAR-ELEMENT-1       
A04359        MOVE TR-DATE-FROM              TO HOSTVAR-ELEMENT-2       
A04359        PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
A04359     END-IF.                                                      
A04359                                                                  
A04359 7090-EXIT.                                                       
A04359     EXIT.                                                        
A04359                                                                  
      *****************************************************************         
      *                                                               *         
      * 7300-OPEN-TAX-EXCISE-CSR.                                     *         
      *****************************************************************         
       7300-OPEN-TAX-EXCISE-CSR.                                        
                                                                        
           EXEC SQL                                                     
               OPEN TAX_EXCISE                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_TAX_EXCISE_AMT'      TO TABLE-1                 
              MOVE 'TAX_CNTRL_NO'            TO TABLE-ELEMENT-1         
              MOVE 'DATE_FROM'               TO TABLE-ELEMENT-2         
              MOVE X6-TAX-CNTRL-NO           TO HOSTVAR-ELEMENT-1       
              MOVE X6-DATE-FROM              TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7305-FETCH-TAX-EXCISE-CSR.                                    *         
      *****************************************************************         
       7305-FETCH-TAX-EXCISE-CSR.                                       
                                                                        
           EXEC SQL                                                     
               FETCH TAX_EXCISE                                         
                INTO :X6-BLOCK-NO                                       
                    ,:X6-BLOCK-UNITS                                    
                    ,:X6-DATE-FROM                                      
                    ,:X6-TAX-CNTRL-NO                                   
                    ,:X6-EXCISE-TAX-UNIT-AM                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'Y'                    TO WS-NO-MORE-ROWS         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7305'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_TAX_EXCISE_AMT'      TO TABLE-1                 
              MOVE 'TAX_CNTRL_NO'            TO TABLE-ELEMENT-1         
              MOVE 'DATE_FROM'               TO TABLE-ELEMENT-2         
              MOVE X6-TAX-CNTRL-NO           TO HOSTVAR-ELEMENT-1       
              MOVE X6-DATE-FROM              TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7305-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7310-CLOSE-TAX-EXCISE-CSR.                                    *         
      *****************************************************************         
       7310-CLOSE-TAX-EXCISE-CSR.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE TAX_EXCISE                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7310'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_TAX_EXCISE_AMT'      TO TABLE-1                 
              MOVE 'TAX_CNTRL_NO'            TO TABLE-ELEMENT-1         
              MOVE 'DATE_FROM'               TO TABLE-ELEMENT-2         
              MOVE X6-TAX-CNTRL-NO           TO HOSTVAR-ELEMENT-1       
              MOVE X6-DATE-FROM              TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7350-OPEN-TAX-RATE-CSR.                                       *         
      *****************************************************************         
       7350-OPEN-TAX-RATE-CSR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN TAX_DETAILS                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7350'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_TAX_RATE'            TO TABLE-1                 
              MOVE 'DATE_FROM'               TO TABLE-ELEMENT-1         
              MOVE 'DETAIL_ID'               TO TABLE-ELEMENT-2         
              MOVE TR-DATE-FROM              TO HOSTVAR-ELEMENT-1       
              MOVE TU-DETAIL-ID              TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7355-FETCH-TAX-RATE-CSR.                                      *         
      *****************************************************************         
       7355-FETCH-TAX-RATE-CSR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH TAX_DETAILS                                        
                INTO :TR-TAX-RATE                                       
                    ,:TC-TAX-CNTRL-NO                                   
                    ,:TC-FACTOR-ID                                      
                    ,:TU-TAX-ELEC                                       
                    ,:TU-TAX-GAS                                        
                    ,:TU-CODE-TAX-CALC-INST                             
CRISPC              ,:TC-CODE-APPL-COND                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'Y'                    TO WS-NO-MORE-ROWS         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7355'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_TAX_RATE'            TO TABLE-1                 
              MOVE 'DATE_FROM'               TO TABLE-ELEMENT-1         
              MOVE 'DETAIL_ID'               TO TABLE-ELEMENT-2         
              MOVE TR-DATE-FROM              TO HOSTVAR-ELEMENT-1       
              MOVE TU-DETAIL-ID              TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7355-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7360-CLOSE-TAX-RATE-CSR.                                      *         
      *****************************************************************         
       7360-CLOSE-TAX-RATE-CSR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE TAX_DETAILS                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7360'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_TAX_RATE'            TO TABLE-1                 
              MOVE 'DATE_FROM'               TO TABLE-ELEMENT-1         
              MOVE 'DETAIL_ID'               TO TABLE-ELEMENT-2         
              MOVE TR-DATE-FROM              TO HOSTVAR-ELEMENT-1       
              MOVE TU-DETAIL-ID              TO HOSTVAR-ELEMENT-2       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7360-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 9910-SQL-ERROR.                                               *         
      *****************************************************************         
       9910-SQL-ERROR.                                                  
                                                                        
           EXIT PROGRAM.                                                
                                                                        
       9910-EXIT.                                                       
           EXIT.                                                        
                                                                        
