      ******************************************************************        
      *                      PROGRAM MODIFICATION LOG                  *        
      *                                                                *        
      *     DATE    INITIALS   COMMENTS                                *        
      *   --------  --------   -----------------                       *        
C30135*  06/24/04    FB        COPYBOOK CREATED FOR FRANCHISE FEE      *        
      *                        PROJECT.                                *        
T34097*  01/22/07   COVANSYS   1. NEED TO REPLACE MODEL_SQL WITH SET   *        
T34097*                           COMMAND AND ADDED WITH UR FOR        *        
T34097*                           SINGELTON SELECTS AND FOR FETCH      *        
T34097*                           ONLY WITH UR FOR CURSOR SELECTS      *        
C36435*  02/04/08    FB        REMOVE LIMITATION OF BILL MESSAGE ON    *        
C36435*                        MULTIPLE CHARGE.                        *        
C37064*  03/06/08    FB        IGNORE DUPLICATES WHEN WRITING BILL     *        
C37064*                        MESSAGE.                                *        
A37549*  03/01/10    FB        DELETE BILL MESSAGE WHEN PROCESSING AN  *        
A37549*                        I ROW AND A B ROW ALREADY EXISTS.       *        
A05317*  02/22/17    FB        FRANCHISE FEE MODS.                     *        
      ******************************************************************        
                                                                        
       F1000-DETERMINE-REGION.                                          
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = 'DATABASE'                             
                 AND COMPANY_NO = '01'                                  
T34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = 'DATABASE'                                     
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE-037     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'F1000'                    TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
              MOVE 'DELINQ_CD'                TO TABLE-ELEMENT-1        
              MOVE 'DATABASE'                 TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       F1000-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F1100-CHECK-FOR-ACCOUNTS.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :AT-ACCOUNT-NO                                    
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO = :WS-PREMISE-NO                       
                  AND CODE_ACCT_STAT IN ('A', 'B', 'S')                 
                                                 
T34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :AT-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE PREMISE_NO = :WS-PREMISE-NO                               
MFA-TR*           AND CODE_ACCT_STAT IN ('A', 'B', 'S')                         
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE-037     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'F1100'                    TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       F1100-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F1200-PROCESS-FRANCHISE-FEE.                                     
                                                                        
           EXEC SQL                                                     
T34097        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE WS-PREMISE-NO             TO JQ-PREMISE-NO.             
           MOVE PR-REV-DISTRICT-CD        TO JQ-PREV-REV-DIST.          
           MOVE PARM-REV-DISTRICT-CD-037  TO JQ-CURR-REV-DIST.          
           PERFORM F7000-GET-CURR-MONTH   THRU F7000-EXIT.              
                                                                        
           MOVE JQ-PREV-REV-DIST          TO TR-DETAIL-ID.              
           MOVE WS-CURRENT-DATE           TO TR-DATE-FROM               
                                             TR-DATE-TO.                
           MOVE 'B'                       TO TC-TAX-TYPE.               
           MOVE ZEROES                    TO TR-TAX-RATE.               
           PERFORM F7200-GET-TAX-RATE     THRU F7200-EXIT.              
           MOVE TR-TAX-RATE               TO WS-PREV-TAX-RATE.          
                                                                        
           MOVE JQ-CURR-REV-DIST          TO TR-DETAIL-ID.              
           MOVE WS-CURRENT-DATE           TO TR-DATE-FROM               
                                             TR-DATE-TO.                
           MOVE 'B'                       TO TC-TAX-TYPE.               
           MOVE ZEROES                    TO TR-TAX-RATE.               
           PERFORM F7200-GET-TAX-RATE     THRU F7200-EXIT.              
           MOVE TR-TAX-RATE               TO WS-CURR-TAX-RATE.          
                                                                        
      *  B = BILL MESSAGE ONLY AND I = INITIATE CREDIT PROCESS                  
                                                                        
           IF WS-CURR-TAX-RATE < WS-PREV-TAX-RATE                       
               MOVE 'I'                   TO JQ-PROCESS-CD              
           ELSE                                                         
               MOVE 'B'                   TO JQ-PROCESS-CD              
               MOVE WS-CURRENT-DATE       TO JQ-PROCESSED-DT
           END-IF.           
                                                                        
           MOVE WS-PREMISE-NO             TO JQ-PREMISE-NO.             
                                                                        
           PERFORM F1250-ACTIVE-ACCOUNT      THRU F1250-EXIT.           
           PERFORM F1300-INDIVIDUAL-ACCOUNTS THRU F1300-EXIT.           
                                                                        
       F1200-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F1250-ACTIVE-ACCOUNT.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) REV_MTH_LST_NRML,
              REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_CREATE_DT, 121), 
           ' ', '-'), ':', '.') ACCT_CREATE_DT                                 
                 INTO :WS-REV-MTH-LST-NRML,                             
                      :AT-ACCT-CREATE-DT                                
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO = :WS-PREMISE-NO                       
                  AND CODE_ACCT_STAT = 'A'                              
                                                 
T34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REV_MTH_LST_NRML,                                         
MFA-TR*               ACCT_CREATE_DT                                            
MFA-TR*          INTO :WS-REV-MTH-LST-NRML,                                     
MFA-TR*               :AT-ACCT-CREATE-DT                                        
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE PREMISE_NO = :WS-PREMISE-NO                               
MFA-TR*           AND CODE_ACCT_STAT = 'A'                                      
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-ACCT-CREATE-DT (1:10) TO WS-ACCT-CREATE-DT   
                   IF WS-REV-MTH-LST-NRML > 0                           
                       PERFORM F1900-ACTIVE-DATES THRU F1900-EXIT       
                       MOVE WS-ACTIVE-START-DT   TO JQ-REV-START-MONTH  
                       MOVE WS-ACTIVE-END-DT     TO JQ-REV-END-MONTH    
                   ELSE                                                 
                       PERFORM F1950-NO-ACTIVE-DATES THRU F1950-EXIT    
                       MOVE WS-NO-ACTIVE-START-DT TO JQ-REV-START-MONTH 
                       MOVE WS-NO-ACTIVE-END-DT TO JQ-REV-END-MONTH     
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   PERFORM F1950-NO-ACTIVE-DATES THRU F1950-EXIT        
                   MOVE WS-NO-ACTIVE-START-DT TO JQ-REV-START-MONTH     
                   MOVE WS-NO-ACTIVE-END-DT   TO JQ-REV-END-MONTH       
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE-037     
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE 'F1250'               TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_ACCOUNT'         TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
                   MOVE WS-PREMISE-NO         TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       F1250-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F1300-INDIVIDUAL-ACCOUNTS.                                       
                                                                        
           EXEC SQL                                                     
              DECLARE ACCOUNTS CURSOR FOR                               
                  SELECT ACCOUNT_NO,                                    
                         CODE_ACCT_STAT,                                
                         REV_MTH_LST_NRML,                              
                         COMPANY_NO,                                    
                         CUSTOMER_NO,                                   
                         LOCAL_OFFICE                                   
                    FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                      
                   WHERE PREMISE_NO = :WS-PREMISE-NO                    
                     AND CODE_ACCT_STAT IN ('A', 'B', 'S')              
T34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCOUNTS CURSOR FOR                                       
MFA-TR*           SELECT ACCOUNT_NO,                                            
MFA-TR*                  CODE_ACCT_STAT,                                        
MFA-TR*                  REV_MTH_LST_NRML,                                      
MFA-TR*                  COMPANY_NO,                                            
MFA-TR*                  CUSTOMER_NO,                                           
MFA-TR*                  LOCAL_OFFICE                                           
MFA-TR*             FROM CSS_ACCOUNT                                            
MFA-TR*            WHERE PREMISE_NO = :WS-PREMISE-NO                            
MFA-TR*              AND CODE_ACCT_STAT IN ('A', 'B', 'S')                      
MFA-TR*              WITH UR                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
               OPEN ACCOUNTS                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE-037     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'F1300'                    TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
           PERFORM F1400-PROCESS-ACCOUNTS THRU F1400-EXIT.              
                                                                        
           EXEC SQL                                                     
               CLOSE ACCOUNTS                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE-037     
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'F1300'                    TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       F1300-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F1400-PROCESS-ACCOUNTS.                                          
                                                                        
           EXEC SQL                                                     
               FETCH ACCOUNTS                                           
                INTO :AT-ACCOUNT-NO,                                    
                     :AT-CODE-ACCT-STAT,                                
                     :AT-REV-MTH-LST-NRML,                              
                     :AT-COMPANY-NO,                                    
                     :AT-CUSTOMER-NO,                                   
                     :AT-LOCAL-OFFICE                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO F1400-EXIT                                     
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE-037 
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F1300'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'CLOSE'                   TO ABEND-FUNCTION     
                   MOVE 'CSS_ACCOUNT'             TO TABLE-1            
                   MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1    
                   MOVE WS-PREMISE-NO             TO HOSTVAR-ELEMENT-1  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           MOVE AT-ACCOUNT-NO                  TO JQ-ACCOUNT-NO.        
           MOVE AT-CUSTOMER-NO                 TO JQ-CUSTOMER-NO.       
           IF JQ-PROCESS-CD = 'B'                                       
               IF AT-CODE-ACCT-STAT = 'A' AND                           
                  AT-REV-MTH-LST-NRML > 0                               
                      PERFORM F1800-CREDIT-ACTIVE     THRU F1800-EXIT   
               END-IF                                                   
           ELSE                                                         
               PERFORM F1600-CREDIT-PROCESS        THRU F1600-EXIT
           END-IF.     
                                                                        
           GO TO F1400-PROCESS-ACCOUNTS.                                
                                                                        
       F1400-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F1600-CREDIT-PROCESS.                                            
                                                                        
           PERFORM F7300-CHECK-I-OR-P-ROW THRU F7300-EXIT.              
           IF WS-EXISTS-I-OR-P = 'Y'                                    
               MOVE 'M'                     TO JQ-PROCESS-CD            
               MOVE ZERO                    TO JQ-REV-END-MONTH         
               MOVE WS-CURRENT-DATE         TO JQ-PROCESSED-DT          
               PERFORM F8000-INSERT-CREDIT  THRU F8000-EXIT             
               IF WS-ACTIVE-RETURN-CODE = DUPLICATE-FOUND               
                   PERFORM F8100-UPDATE-CREDIT  THRU F8100-EXIT         
               END-IF                                                   
           ELSE                                                         
               PERFORM F7400-CHECK-B-ROW    THRU F7400-EXIT             
               IF WS-EXISTS-B = 'Y'                                     
                   MOVE 'M'                 TO JQ-PROCESS-CD            
                   MOVE ZERO                TO JQ-REV-END-MONTH         
                   MOVE WS-CURRENT-DATE     TO JQ-PROCESSED-DT          
                   PERFORM F8000-INSERT-CREDIT THRU F8000-EXIT          
                   IF WS-ACTIVE-RETURN-CODE = DUPLICATE-FOUND           
                       PERFORM F8100-UPDATE-CREDIT THRU F8100-EXIT      
                   END-IF                                               
A37549             PERFORM F8400-DELETE-BILL-MSG THRU F8400-EXIT        
               ELSE                                                     
                   PERFORM F8000-INSERT-CREDIT      THRU F8000-EXIT
               END-IF
           END-IF.    
                                                                        
       F1600-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F1800-CREDIT-ACTIVE.                                             
                                                                        
C36435     PERFORM F7400-CHECK-B-ROW         THRU F7400-EXIT.           
C36435     PERFORM F7500-HAS-MESSAGE-PRINTED THRU F7500-EXIT.           
C36435     IF WS-EXISTS-B = 'Y' AND WS-EXISTS-BILL-MSG = 'Y'            
C36435         PERFORM F8500-UPDATE-CREDIT THRU F8500-EXIT              
C36435         PERFORM F8300-DELETE-CREDIT           THRU F8300-EXIT    
C36435         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
C36435             PERFORM F8400-DELETE-BILL-MSG THRU F8400-EXIT        
C36435         END-IF                                                   
C36435     ELSE                                                         
C36435         PERFORM F8200-INSERT-BILL-MSG    THRU F8200-EXIT         
C36435         PERFORM F8000-INSERT-CREDIT      THRU F8000-EXIT
           END-IF.        
                                                                        
                                                                        
       F1800-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F1900-ACTIVE-DATES.                                              
                                                                        
           MOVE WS-REV-MTH-LST-NRML TO WS-ACTIVE-END-DT.                
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
A05317         WHERE DELINQ_CD = 'FRAN_CRDT_SC_NBR_MT'                  
                 AND COMPANY_NO = '01'                                  
T34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = 'FRAN_CRDT_SC_NBR_MT'                          
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
A05317             MOVE C8-DELINQ-VALUE TO WS-SCEG-FRAN-MONTHS          
               WHEN NOT-FOUND                                           
A05317             MOVE 0               TO WS-SCEG-FRAN-MONTHS          
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE-037 
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F1900'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'SELECT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_DELINQUENCY'         TO TABLE-1            
                   MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-1    
A05317             MOVE 'FRAN_CRDT_SC_NBR_MT'     TO HOSTVAR-ELEMENT-1  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           IF WS-ACCT-CREATE-DT > '2004-08-03'                          
A05317         MOVE 0 TO WS-SCEG-FRAN-MONTHS
           END-IF.                           
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
A05317         WHERE DELINQ_CD = 'FRAN_CRDT_MUN_NBR_MT'                 
                 AND COMPANY_NO = '01'                                  
T34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = 'FRAN_CRDT_MUN_NBR_MT'                         
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
A05317             MOVE C8-DELINQ-VALUE TO WS-MUN-FRAN-MONTHS           
               WHEN NOT-FOUND                                           
A05317             MOVE 6               TO WS-MUN-FRAN-MONTHS           
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE-037 
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F7100'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'SELECT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_DELINQUENCY'         TO TABLE-1            
                   MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-1    
A05317             MOVE 'FRAN_CRDT_MUN_NBR_MT'    TO HOSTVAR-ELEMENT-1  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
A05317     COMPUTE WS-TOT-FRAN-MONTHS =                                 
A05317             WS-MUN-FRAN-MONTHS +                                 
A05317             WS-SCEG-FRAN-MONTHS.                                 
                                                                        
           MOVE WS-REV-MTH-LST-NRML        TO WS-REV-MTH-LST-NRML-X.    
           MOVE WS-REV-MTH-LST-NRML-X(1:4) TO WS-REVENUE-DATE(1:4).     
           MOVE WS-REV-MTH-LST-NRML-X(5:2) TO WS-REVENUE-DATE(6:2).     
           MOVE '01'                       TO WS-REVENUE-DATE(9:2).     
           MOVE '-'                        TO WS-REVENUE-DATE(5:1)      
                                              WS-REVENUE-DATE(8:1).     
                                                                        
           EXEC SQL                                                     
T34097         SELECT
              DATEADD( MONTH, 1, (DATEADD( MONTH, -(:WS-TOT-FRAN-MONTHS)
              , IIF(TRY_CONVERT(DATE, :WS-REVENUE-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-REVENUE-DATE
              ) <> 0) OR (LEN(:WS-REVENUE-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-REVENUE-DATE
              ), CONVERT(DATE, :WS-REVENUE-DATE) ) )) )
            INTO
              :WS-FRAN-START-DATE                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-FRAN-START-DATE = (DATE(:WS-REVENUE-DATE) -              
MFA-TR*                    (:WS-TOT-FRAN-MONTHS) MONTH) +                       
MFA-TR*                    1 MONTH                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE WS-FRAN-START-DATE(1:4) TO WS-START-REV-MONTH(1:4).     
           MOVE WS-FRAN-START-DATE(6:2) TO WS-START-REV-MONTH(5:2).     
           MOVE WS-START-REV-MONTH-R    TO WS-ACTIVE-START-DT.          
                                                                        
       F1900-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F1950-NO-ACTIVE-DATES.                                           
                                                                        
           MOVE WS-CURR-REV-MONTH-R TO WS-NO-ACTIVE-END-DT.             
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
A05317         WHERE DELINQ_CD = 'FRAN_CRDT_SC_NBR_MT'                  
                 AND COMPANY_NO = '01'                                  
T34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = 'FRAN_CRDT_SC_NBR_MT'                          
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
A05317             MOVE C8-DELINQ-VALUE TO WS-SCEG-FRAN-MONTHS          
               WHEN NOT-FOUND                                           
A05317             MOVE 0               TO WS-SCEG-FRAN-MONTHS          
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE-037 
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F7100'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'SELECT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_DELINQUENCY'         TO TABLE-1            
                   MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-1    
A05317             MOVE 'FRAN_CRDT_SC_NBR_MT'     TO HOSTVAR-ELEMENT-1  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           IF WS-ACCT-CREATE-DT > '2004-08-03'                          
A05317         MOVE 0 TO WS-SCEG-FRAN-MONTHS
           END-IF.                           
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
A05317         WHERE DELINQ_CD = 'FRAN_CRDT_MUN_NBR_MT'                 
                 AND COMPANY_NO = '01'                                  
T34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = 'FRAN_CRDT_MUN_NBR_MT'                         
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
A05317             MOVE C8-DELINQ-VALUE TO WS-MUN-FRAN-MONTHS           
               WHEN NOT-FOUND                                           
A05317             MOVE 6               TO WS-MUN-FRAN-MONTHS           
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE-037 
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F7100'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'SELECT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_DELINQUENCY'         TO TABLE-1            
                   MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-1    
A05317             MOVE 'FRAN_CRDT_MUN_NBR_MT'    TO HOSTVAR-ELEMENT-1  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
A05317     COMPUTE WS-TOT-FRAN-MONTHS =                                 
A05317             WS-MUN-FRAN-MONTHS +                                 
A05317             WS-SCEG-FRAN-MONTHS.                                 
                                                                        
           MOVE WS-CURR-REV-MONTH(1:4) TO WS-REVENUE-DATE(1:4).         
           MOVE WS-CURR-REV-MONTH(5:2) TO WS-REVENUE-DATE(6:2).         
           MOVE '01'                   TO WS-REVENUE-DATE(9:2).         
           MOVE '-'                    TO WS-REVENUE-DATE(5:1)          
                                          WS-REVENUE-DATE(8:1).         
                                                                        
           EXEC SQL                                                     
T34097         SELECT
              DATEADD( MONTH, 1, (DATEADD( MONTH, -(:WS-TOT-FRAN-MONTHS)
              , IIF(TRY_CONVERT(DATE, :WS-REVENUE-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-REVENUE-DATE
              ) <> 0) OR (LEN(:WS-REVENUE-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-REVENUE-DATE
              ), CONVERT(DATE, :WS-REVENUE-DATE) ) )) )
            INTO
              :WS-FRAN-START-DATE                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-FRAN-START-DATE = (DATE(:WS-REVENUE-DATE) -              
MFA-TR*                    (:WS-TOT-FRAN-MONTHS) MONTH) +                       
MFA-TR*                    1 MONTH                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE WS-FRAN-START-DATE(1:4) TO WS-START-REV-MONTH(1:4).     
           MOVE WS-FRAN-START-DATE(6:2) TO WS-START-REV-MONTH(5:2).     
           MOVE WS-START-REV-MONTH-R    TO WS-NO-ACTIVE-START-DT.       
                                                                        
       F1950-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F7000-GET-CURR-MONTH.                                            
                                                                        
           EXEC SQL                                                     
               SELECT CIS.SUBSTR3(PARM_DATA,15,6)                            
                 INTO :WS-CURR-REV-MONTH                                
                 FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                        
                WHERE PROGRAM_NAME = 'COMMON'                           
                  AND CMND_CODE    = 'DATE'                             
                  AND SEQ_NO       = 20                                 
                  AND STATUS       = 'A'                                
                  AND COMPANY_NO   = '01'                               
T34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUBSTR(PARM_DATA,15,6)                                    
MFA-TR*          INTO :WS-CURR-REV-MONTH                                        
MFA-TR*          FROM CSS_JOB_PARM                                              
MFA-TR*         WHERE PROGRAM_NAME = 'COMMON'                                   
MFA-TR*           AND CMND_CODE    = 'DATE'                                     
MFA-TR*           AND SEQ_NO       = 20                                         
MFA-TR*           AND STATUS       = 'A'                                        
MFA-TR*           AND COMPANY_NO   = '01'                                       
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE WS-CURRENT-DATE(1:4) TO WS-CURR-REV-MONTH(1:4)  
                   MOVE WS-CURRENT-DATE(6:2) TO WS-CURR-REV-MONTH(5:2)  
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE-037 
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F7000'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'SELECT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_JOB_PARM'            TO TABLE-1            
                   MOVE 'PROGRAM_NAME'            TO TABLE-ELEMENT-1    
                   MOVE 'COMMON'                  TO HOSTVAR-ELEMENT-1  
                   MOVE 'CMND_CODE'               TO TABLE-ELEMENT-2    
                   MOVE 'DATE'                    TO HOSTVAR-ELEMENT-2  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       F7000-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F7200-GET-TAX-RATE.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) TR.TAX_RATE                                        
                INTO :TR-TAX-RATE                                       
                FROM CSS_TAX_CNTL TC WITH(READUNCOMMITTED),                     
                     CSS_TAX_RATE TR WITH(READUNCOMMITTED),                     
                     CSS_TAX_USE_CNTL TU WITH(READUNCOMMITTED)                  
               WHERE TC.OPER_MODE = 'A'                                 
                 AND TC.OPER_MODE = TR.OPER_MODE                        
                 AND TC.TAX_TYPE  = :TC-TAX-TYPE                        
                 AND TR.TAX_CNTRL_NO = TC.TAX_CNTRL_NO                  
                 AND TR.DATE_FROM IS NOT NULL                           
                 AND TR.DATE_FROM <= IIF(TRY_CONVERT(DATE, :TR-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :TR-DATE-FROM
              ) <> 0) OR (LEN(:TR-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :TR-DATE-FROM
              ), CONVERT(DATE, :TR-DATE-FROM) )                      
                 AND TR.DATE_TO >= IIF(TRY_CONVERT(DATE, :TR-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :TR-DATE-TO) <> 0) OR (LEN(
                                                            :TR-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:TR-DATE-TO), CONVERT(DATE, 
                                                            :TR-DATE-TO
              ) )                          
                 AND TU.OPER_MODE = TC.OPER_MODE                        
                 AND TU.TAX_CNTRL_NO = TC.TAX_CNTRL_NO                  
                 AND TU.DETAIL_ID = TR.DETAIL_ID                        
                 AND TR.DETAIL_ID = :TR-DETAIL-ID                       
                                                 
T34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TR.TAX_RATE                                                
MFA-TR*         INTO :TR-TAX-RATE                                               
MFA-TR*         FROM CSS_TAX_CNTL TC,                                           
MFA-TR*              CSS_TAX_RATE TR,                                           
MFA-TR*              CSS_TAX_USE_CNTL TU                                        
MFA-TR*        WHERE TC.OPER_MODE = 'A'                                         
MFA-TR*          AND TC.OPER_MODE = TR.OPER_MODE                                
MFA-TR*          AND TC.TAX_TYPE  = :TC-TAX-TYPE                                
MFA-TR*          AND TR.TAX_CNTRL_NO = TC.TAX_CNTRL_NO                          
MFA-TR*          AND TR.DATE_FROM IS NOT NULL                                   
MFA-TR*          AND TR.DATE_FROM <= :TR-DATE-FROM                              
MFA-TR*          AND TR.DATE_TO >= :TR-DATE-TO                                  
MFA-TR*          AND TU.OPER_MODE = TC.OPER_MODE                                
MFA-TR*          AND TU.TAX_CNTRL_NO = TC.TAX_CNTRL_NO                          
MFA-TR*          AND TU.DETAIL_ID = TR.DETAIL_ID                                
MFA-TR*          AND TR.DETAIL_ID = :TR-DETAIL-ID                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 0.0 TO TR-TAX-RATE                              
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE-037 
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F7200'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'SELECT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_TAX_CNTL'            TO TABLE-1            
                   MOVE 'CSS_TAX_RATE'            TO TABLE-2            
                   MOVE 'CSS_TAX_USE_CNTL'        TO TABLE-3            
                   MOVE 'DETAIL_ID'               TO TABLE-ELEMENT-1    
                   MOVE TR-DETAIL-ID              TO HOSTVAR-ELEMENT-1  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       F7200-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F7300-CHECK-I-OR-P-ROW.                                          
                                                                        
           MOVE 'N' TO WS-EXISTS-I-OR-P.                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :WS-ACCOUNT-NO-F                                   
                FROM CSS_FRNCHSE_CRDT WITH(READUNCOMMITTED)                     
               WHERE PREMISE_NO = :JQ-PREMISE-NO                        
                 AND ACCOUNT_NO = :JQ-ACCOUNT-NO                        
                 AND PROCESS_CD IN ('I', 'P')                           
                                                 
T34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :WS-ACCOUNT-NO-F                                           
MFA-TR*         FROM CSS_FRNCHSE_CRDT                                           
MFA-TR*        WHERE PREMISE_NO = :JQ-PREMISE-NO                                
MFA-TR*          AND ACCOUNT_NO = :JQ-ACCOUNT-NO                                
MFA-TR*          AND PROCESS_CD IN ('I', 'P')                                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-EXISTS-I-OR-P                         
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-EXISTS-I-OR-P                         
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE-037 
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F7300'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'SELECT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_FRNCHSE_CRDT'        TO TABLE-1            
                   MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1    
                   MOVE JQ-PREMISE-NO             TO HOSTVAR-ELEMENT-1  
                   MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2    
                   MOVE JQ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       F7300-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F7400-CHECK-B-ROW.                                               
                                                                        
           MOVE 'N' TO WS-EXISTS-B.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :WS-ACCOUNT-NO-F                                   
                FROM CSS_FRNCHSE_CRDT WITH(READUNCOMMITTED)                     
               WHERE PREMISE_NO = :JQ-PREMISE-NO                        
                 AND ACCOUNT_NO = :JQ-ACCOUNT-NO                        
                 AND PROCESS_CD = 'B'                                   
                                                 
T34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :WS-ACCOUNT-NO-F                                           
MFA-TR*         FROM CSS_FRNCHSE_CRDT                                           
MFA-TR*        WHERE PREMISE_NO = :JQ-PREMISE-NO                                
MFA-TR*          AND ACCOUNT_NO = :JQ-ACCOUNT-NO                                
MFA-TR*          AND PROCESS_CD = 'B'                                           
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-EXISTS-B                              
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-EXISTS-B                              
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE-037 
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F7400'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'SELECT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_FRNCHSE_CRDT'        TO TABLE-1            
                   MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1    
                   MOVE JQ-PREMISE-NO             TO HOSTVAR-ELEMENT-1  
                   MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2    
                   MOVE JQ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       F7400-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F7500-HAS-MESSAGE-PRINTED.                                       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :U1-ACCOUNT-NO                                    
                 FROM CSS_SPCL_BILL_MSG WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
                  AND REVENUE_MO_ST  > :AT-REV-MTH-LST-NRML             
                  AND BILL_MSG_ID    = '95048'                          
                  AND MSG_TYPE_CD    = 'M'                              
                  AND REVENUE_MO_END > :AT-REV-MTH-LST-NRML             
                  AND COMPANY_NO     = :AT-COMPANY-NO                   
                                                 
T34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :U1-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_SPCL_BILL_MSG                                         
MFA-TR*         WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                           
MFA-TR*           AND REVENUE_MO_ST  > :AT-REV-MTH-LST-NRML                     
MFA-TR*           AND BILL_MSG_ID    = '95048'                                  
MFA-TR*           AND MSG_TYPE_CD    = 'M'                                      
MFA-TR*           AND REVENUE_MO_END > :AT-REV-MTH-LST-NRML                     
MFA-TR*           AND COMPANY_NO     = :AT-COMPANY-NO                           
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN DUPLICATE-FOUND                                     
                   MOVE 'Y' TO WS-EXISTS-BILL-MSG                       
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-EXISTS-BILL-MSG                       
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE-037 
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F7500'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'SELECT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_SPCL_BILL_MSG'       TO TABLE-1            
                   MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1    
                   MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1  
                   MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2    
                   MOVE JQ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       F7500-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F8000-INSERT-CREDIT.                                             
                                                                        
           IF JQ-PROCESSED-DT <= SPACES                                 
               MOVE -1 TO WS-NULL-IND-F
           END-IF.                                
           EXEC SQL                                                     
               INSERT INTO CSS_FRNCHSE_CRDT                             
                      (PREMISE_NO,                                      
                       ACCOUNT_NO,                                      
                       REV_END_MONTH,                                   
                       CUSTOMER_NO,                                     
                       CURR_REV_DIST,                                   
                       PREV_REV_DIST,                                   
                       PROCESS_CD,                                      
                       PROCESSED_DT,                                    
                       REV_START_MONTH)                                 
                  VALUES                                                
                      (:JQ-PREMISE-NO,                                  
                       :JQ-ACCOUNT-NO,                                  
                       :JQ-REV-END-MONTH,                               
                       :JQ-CUSTOMER-NO,                                 
                       :JQ-CURR-REV-DIST,                               
                       :JQ-PREV-REV-DIST,                               
                       :JQ-PROCESS-CD,                                  
                       IIF(TRY_CONVERT(DATE, :JQ-PROCESSED-DT 
                                             :WS-NULL-IND-F
              ) IS NULL OR (PATINDEX('%.%', :JQ-PROCESSED-DT 
                                                         :WS-NULL-IND-F
              ) <> 0) OR (LEN(:JQ-PROCESSED-DT :WS-NULL-IND-F
              ) <> 10), CIS.CHAR2DATE(:JQ-PROCESSED-DT :WS-NULL-IND-F
              ), CONVERT(DATE, :JQ-PROCESSED-DT :WS-NULL-IND-F) ),             
                       :JQ-REV-START-MONTH)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_FRNCHSE_CRDT                                     
MFA-TR*               (PREMISE_NO,                                              
MFA-TR*                ACCOUNT_NO,                                              
MFA-TR*                REV_END_MONTH,                                           
MFA-TR*                CUSTOMER_NO,                                             
MFA-TR*                CURR_REV_DIST,                                           
MFA-TR*                PREV_REV_DIST,                                           
MFA-TR*                PROCESS_CD,                                              
MFA-TR*                PROCESSED_DT,                                            
MFA-TR*                REV_START_MONTH)                                         
MFA-TR*           VALUES                                                        
MFA-TR*               (:JQ-PREMISE-NO,                                          
MFA-TR*                :JQ-ACCOUNT-NO,                                          
MFA-TR*                :JQ-REV-END-MONTH,                                       
MFA-TR*                :JQ-CUSTOMER-NO,                                         
MFA-TR*                :JQ-CURR-REV-DIST,                                       
MFA-TR*                :JQ-PREV-REV-DIST,                                       
MFA-TR*                :JQ-PROCESS-CD,                                          
MFA-TR*                :JQ-PROCESSED-DT :WS-NULL-IND-F,                         
MFA-TR*                :JQ-REV-START-MONTH)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN DUPLICATE-FOUND                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE-037 
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F8000'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'INSERT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_FRNCHSE_CRDT'        TO TABLE-1            
                   MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1    
                   MOVE JQ-PREMISE-NO             TO HOSTVAR-ELEMENT-1  
                   MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2    
                   MOVE JQ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       F8000-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F8100-UPDATE-CREDIT.                                             
                                                                        
           IF JQ-PROCESSED-DT <= SPACES                                 
               MOVE -1 TO WS-NULL-IND-F
           END-IF.                                
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_FRNCHSE_CRDT                                  
                  SET CURR_REV_DIST = :JQ-CURR-REV-DIST,                
                      PROCESS_CD    = :JQ-PROCESS-CD,                   
                      PROCESSED_DT  = IIF(TRY_CONVERT(DATE, 
                                                       :JQ-PROCESSED-DT
              ) IS NULL OR (PATINDEX('%.%', :JQ-PROCESSED-DT
              ) <> 0) OR (LEN(:JQ-PROCESSED-DT) <> 10), CIS.CHAR2DATE(
                                                       :JQ-PROCESSED-DT
              ), CONVERT(DATE, :JQ-PROCESSED-DT) )                  
                WHERE PREMISE_NO    = :JQ-PREMISE-NO                    
                  AND ACCOUNT_NO    = :JQ-ACCOUNT-NO                    
                  AND PROCESS_CD    = 'M'                               
                  AND REV_END_MONTH = 0                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_FRNCHSE_CRDT                                          
MFA-TR*           SET CURR_REV_DIST = :JQ-CURR-REV-DIST,                        
MFA-TR*               PROCESS_CD    = :JQ-PROCESS-CD,                           
MFA-TR*               PROCESSED_DT  = :JQ-PROCESSED-DT                          
MFA-TR*         WHERE PREMISE_NO    = :JQ-PREMISE-NO                            
MFA-TR*           AND ACCOUNT_NO    = :JQ-ACCOUNT-NO                            
MFA-TR*           AND PROCESS_CD    = 'M'                                       
MFA-TR*           AND REV_END_MONTH = 0                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE-037 
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F8100'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'UPDATE'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_FRNCHSE_CRDT'        TO TABLE-1            
                   MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1    
                   MOVE JQ-PREMISE-NO             TO HOSTVAR-ELEMENT-1  
                   MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2    
                   MOVE JQ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.       
                                                                        
       F8100-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F8200-INSERT-BILL-MSG.                                           
                                                                        
           MOVE AT-REV-MTH-LST-NRML  TO WS-BILL-REV-MONTH.              
           MOVE WS-BILL-REV-MONTH(1:4) TO WS-BILL-REV-DATE(1:4).        
           MOVE WS-BILL-REV-MONTH(5:2) TO WS-BILL-REV-DATE(6:2).        
           MOVE '01'                   TO WS-BILL-REV-DATE(9:2).        
           MOVE '-'                    TO WS-BILL-REV-DATE(5:1)         
                                          WS-BILL-REV-DATE(8:1).        
                                                                        
           EXEC SQL                                                     
T34097         SELECT
              DATEADD( MONTH, 1, IIF(TRY_CONVERT(DATE, :WS-BILL-REV-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-BILL-REV-DATE
              ) <> 0) OR (LEN(:WS-BILL-REV-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-BILL-REV-DATE
              ), CONVERT(DATE, :WS-BILL-REV-DATE) ) )
            INTO
              :WS-NEXT-BILL-REV-DATE               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-NEXT-BILL-REV-DATE =                                     
MFA-TR*               (DATE(:WS-BILL-REV-DATE) + 1 MONTH)                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE WS-NEXT-BILL-REV-DATE(1:4) TO                           
                WS-NEXT-BILL-REV-MONTH(1:4).                            
           MOVE WS-NEXT-BILL-REV-DATE(6:2) TO                           
                WS-NEXT-BILL-REV-MONTH(5:2).                            
                                                                        
           MOVE WS-NEXT-BILL-REV-MONTH TO U1-REVENUE-MO-ST              
                                          U1-REVENUE-MO-END.            
           MOVE AT-ACCOUNT-NO          TO U1-ACCOUNT-NO.                
           MOVE '95048'                TO U1-BILL-MSG-ID.               
           MOVE 'M'                    TO U1-MSG-TYPE-CD.               
           MOVE AT-COMPANY-NO          TO U1-COMPANY-NO.                
           MOVE 01                     TO U1-BILL-CYCLE-ST.             
           MOVE 21                     TO U1-BILL-CYCLE-END.            
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SPCL_BILL_MSG                            
                  (REVENUE_MO_ST,                                       
                   ACCOUNT_NO,                                          
                   BILL_MSG_ID,                                         
                   MSG_TYPE_CD,                                         
                   COMPANY_NO,                                          
                   BILL_CYCLE_ST,                                       
                   BILL_CYCLE_END,                                      
                   REVENUE_MO_END)                                      
                 VALUES                                                 
                  (:U1-REVENUE-MO-ST,                                   
                   :U1-ACCOUNT-NO,                                      
                   :U1-BILL-MSG-ID,                                     
                   :U1-MSG-TYPE-CD,                                     
                   :U1-COMPANY-NO,                                      
                   :U1-BILL-CYCLE-ST,                                   
                   :U1-BILL-CYCLE-END,                                  
                   :U1-REVENUE-MO-END)                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
C37064         WHEN DUPLICATE-FOUND                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE-037 
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F8200'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'INSERT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_SPCL_BILL_MSG'       TO TABLE-1            
                   MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1    
                   MOVE JQ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       F8200-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F8300-DELETE-CREDIT.                                             
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_FRNCHSE_CRDT                             
                WHERE PREMISE_NO    = :JQ-PREMISE-NO                    
                  AND ACCOUNT_NO    = :JQ-ACCOUNT-NO                    
                  AND PROCESSED_DT  = (SELECT MAX(PROCESSED_DT)         
                                         FROM CSS_FRNCHSE_CRDT          
                                       WHERE PREMISE_NO = :JQ-PREMISE-NO
                                         AND ACCOUNT_NO = :JQ-ACCOUNT-NO
                                         AND PROCESS_CD = 'B')          
                  AND PROCESS_CD    = 'B'                               
                  AND CURR_REV_DIST = PREV_REV_DIST                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE-037 
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F8300'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'DELETE'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_FRNCHSE_CRDT'        TO TABLE-1            
                   MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1    
                   MOVE JQ-PREMISE-NO             TO HOSTVAR-ELEMENT-1  
                   MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2    
                   MOVE JQ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.       
                                                                        
       F8300-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F8400-DELETE-BILL-MSG.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_SPCL_BILL_MSG                            
                WHERE ACCOUNT_NO     = :JQ-ACCOUNT-NO                   
                  AND REVENUE_MO_ST  > :AT-REV-MTH-LST-NRML             
                  AND BILL_MSG_ID    = '95048'                          
                  AND MSG_TYPE_CD    = 'M'                              
                  AND REVENUE_MO_END > :AT-REV-MTH-LST-NRML             
                  AND COMPANY_NO     = :AT-COMPANY-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE-037 
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F8400'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'DELETE'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_SPCL_BILL_MSG'       TO TABLE-1            
                   MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1    
                   MOVE JQ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.       
                                                                        
       F8400-EXIT.                                                      
           EXIT.                                                        
                                                                        
       F8500-UPDATE-CREDIT.                                             
                                                                        
           IF JQ-PROCESSED-DT <= SPACES                                 
               MOVE -1 TO WS-NULL-IND-F
           END-IF.                                
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_FRNCHSE_CRDT                                  
                  SET CURR_REV_DIST = :JQ-CURR-REV-DIST,                
                      PROCESS_CD    = :JQ-PROCESS-CD,                   
                      PROCESSED_DT  = IIF(TRY_CONVERT(DATE, 
                                                       :JQ-PROCESSED-DT
              ) IS NULL OR (PATINDEX('%.%', :JQ-PROCESSED-DT
              ) <> 0) OR (LEN(:JQ-PROCESSED-DT) <> 10), CIS.CHAR2DATE(
                                                       :JQ-PROCESSED-DT
              ), CONVERT(DATE, :JQ-PROCESSED-DT) )                  
                WHERE PREMISE_NO    = :JQ-PREMISE-NO                    
                  AND ACCOUNT_NO    = :JQ-ACCOUNT-NO                    
                  AND PROCESSED_DT  = (SELECT MAX(PROCESSED_DT)         
                                         FROM CSS_FRNCHSE_CRDT          
                                       WHERE PREMISE_NO = :JQ-PREMISE-NO
                                         AND ACCOUNT_NO = :JQ-ACCOUNT-NO
                                         AND PROCESS_CD = 'B')          
                  AND PROCESS_CD    = 'B'                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_FRNCHSE_CRDT                                          
MFA-TR*           SET CURR_REV_DIST = :JQ-CURR-REV-DIST,                        
MFA-TR*               PROCESS_CD    = :JQ-PROCESS-CD,                           
MFA-TR*               PROCESSED_DT  = :JQ-PROCESSED-DT                          
MFA-TR*         WHERE PREMISE_NO    = :JQ-PREMISE-NO                            
MFA-TR*           AND ACCOUNT_NO    = :JQ-ACCOUNT-NO                            
MFA-TR*           AND PROCESSED_DT  = (SELECT MAX(PROCESSED_DT)                 
MFA-TR*                                  FROM CSS_FRNCHSE_CRDT                  
MFA-TR*                                WHERE PREMISE_NO = :JQ-PREMISE-NO        
MFA-TR*                                  AND ACCOUNT_NO = :JQ-ACCOUNT-NO        
MFA-TR*                                  AND PROCESS_CD = 'B')                  
MFA-TR*           AND PROCESS_CD    = 'B'                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE-037 
                   MOVE PROGRAM-NAME              TO ABEND-PROGRAM      
                   MOVE 'F8500'                   TO ACTIVE-PARAGRAPH   
                   MOVE 'UPDATE'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_FRNCHSE_CRDT'        TO TABLE-1            
                   MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1    
                   MOVE JQ-PREMISE-NO             TO HOSTVAR-ELEMENT-1  
                   MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2    
                   MOVE JQ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.       
                                                                        
       F8500-EXIT.                                                      
           EXIT.                                                        
                                                                        
