      *---------------------------------------------------------------*         
      **             SOUTH CAROLINA ELECTRIC & GAS                   **         
      **              CUSTOMER INFORMATION SYSTEM                    **         
      *---------------------------------------------------------------*         
      **              P R O G R A M  S U M M A R Y                   **         
      **                                                             **         
      ** THIS COPYBOOK UPDATES DNP DATA                              **         
      **                                                             **         
      *---------------------------------------------------------------*         
      **                                                              *         
      **              PROGRAM  MODIFICATION  LOG                      *         
      **                                                              *         
      **    DATE    INITIALS     REASON                               *         
      **  -------   --------     ------                               *         
P00420**  06/25/10  BASKAR V     THE MAIN LOGIC FROM MCSCB371 IS MOVED*         
P00420**                         HERE AS A NEW COPYBOOK.              *         
      *---------------------------------------------------------------*         
                                                                        
      *---------------------------------------------------------------*         
      *1000-PROCESS-INPUT.                                            *         
      *---------------------------------------------------------------*         
       1000-PROCESS-INPUT.                                              
           MOVE WS-ACCT-NO                 TO WS-ACCOUNT-NUM            
           MOVE WS-AMT-DNP-BAL             TO WS-AMT-DNP-BAL-N          
           MOVE WS-AMT-DNP-BAL-N           TO WS-AMT-DNP-BAL-C          
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      *2000-PROCESS-OUTPUT.                                           *         
      *---------------------------------------------------------------*         
       2000-PROCESS-OUTPUT.                                             
           PERFORM 3300-CALC-SECURITY-BAL  THRU 3300-EXIT               
           PERFORM 3400-DETERMINE-AGING    THRU 3400-EXIT               
           PERFORM 5200-UPDATE-TABLES      THRU 5200-EXIT               
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * CALCULATE DEPOSIT BALANCE.                                    *         
      *---------------------------------------------------------------*         
       3300-CALC-SECURITY-BAL.                                          
           MOVE WS-ACCT-NO       TO SB-ACCOUNT-NO                       
                                    GU-ACCOUNT-NO                       
                                    DO-ACCOUNT-NO                       
                                                                        
           MOVE WS-A             TO SB-CODE-BOND-TYPE                   
           PERFORM 7600-SUM-SURETY-BOND    THRU 7600-EXIT               
                                                                        
           MOVE WS-B             TO SB-CODE-BOND-TYPE                   
           PERFORM 7605-SUM-IRR-LETTER     THRU 7605-EXIT               
                                                                        
           PERFORM 7610-SUM-GUARANTOR      THRU 7610-EXIT               
           PERFORM 7620-SUM-DEP-ON-HAND    THRU 7620-EXIT               
                                                                        
           COMPUTE WS-AMT-SEC-BAL = WS-AMT-BOND                         
                                  + WS-AMT-IRR-LTR                      
                                  + WS-AMT-GUARANTEED                   
                                  + WS-AMT-DEP-ON-HAND                  
                                                                        
           MOVE WS-AMT-SEC-BAL             TO WS-AMT-SEC-BAL-N          
           MOVE WS-AMT-SEC-BAL-N           TO WS-AMT-SEC-BAL-C          
           .                                                            
       3300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *     CALLS 7200-SELECT-ARREARS-CODE                             *        
      *----------------------------------------------------------------*        
       3400-DETERMINE-AGING.                                            
           MOVE WS-ACCT-NO                 TO CZ-ACCOUNT-NO             
           PERFORM 7200-SELECT-ARREARS-CODE   THRU 7200-EXIT            
           MOVE CZ-ARREARS-HIST(1:1)       TO WS-CODE-ARREARS           
           .                                                            
       3400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * 5200-UPDATE-TABLES                                             *        
      *----------------------------------------------------------------*        
       5200-UPDATE-TABLES.                                              
      *    EXEC SQL CALL CSR00428                                       
      *                ( :WS-ACCOUNT-NO                                 
      *                 ,:WS-AMT-DNP-BAL-C                              
      *                 ,:WS-AMT-SEC-BAL-C                              
      *                 ,:WS-DATE-BILL-DAY-00                           
      *                 ,:WS-CREDIT-GROUP                               
      *                 ,:WS-CODE-ARREARS                               
      *                )                                                
      *    END-EXEC                                                     

MSQ001        EXEC SQL
MSQ001          CLOSE C2
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C2
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C2 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
           IF  WS-ACTIVE-RETURN-CODE = +466                             
      *        EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE        
      *           CSR00428                                              
      *        END-EXEC                                                 
                                                                        
      *        EXEC SQL ALLOCATE C2  CURSOR FOR RESULT SET :LOC1        
      *        END-EXEC                                                 
                                                                        
               EXEC SQL                                                 
                  FETCH C2 INTO :RS-RETURN-CODE                         
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE   
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  MOVE RS-RETURN-CODE        TO WS-ACTIVE-RETURN-CODE   
               ELSE                                                     
                  MOVE '5200'                TO ACTIVE-PARAGRAPH        
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE 'FETCH C2'            TO ABEND-FUNCTION          
                  MOVE 'CSR00428'            TO TABLE-1                 
                  MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1         
                  MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1       
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
               END-IF                                                   
                                                                        
               EXEC SQL                                                 
                  CLOSE C2                                              
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE   
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 CONTINUE                                               
               ELSE                                                     
                 MOVE '5200'                 TO ACTIVE-PARAGRAPH        
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE 'CLOSE C2'             TO ABEND-FUNCTION          
                 MOVE 'CSR00428'             TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE WS-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
               END-IF                                                   
           ELSE                                                         
               MOVE '5200'                   TO ACTIVE-PARAGRAPH        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE 'CALL SP'                TO ABEND-FUNCTION          
               MOVE 'CSR00428'               TO TABLE-1                 
               MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
               MOVE WS-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF                                                       
           .                                                            
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * 7200-SELECT-ARREARS-CODE                                       *        
      *----------------------------------------------------------------*        
       7200-SELECT-ARREARS-CODE.                                        
                                                                        
           EXEC SQL                                                     
             SELECT ARREARS_HIST                                        
               INTO :CZ-ARREARS-HIST                                    
               FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                    
              WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                         
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT ARREARS_HIST                                                
MFA-TR*        INTO :CZ-ARREARS-HIST                                            
MFA-TR*        FROM CSS_CREDIT_PROFILE                                          
MFA-TR*       WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE     
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7200'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_CREDIT_PROFILE'   TO TABLE-1                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE CZ-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
            END-IF                                                      
            .                                                           
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * 7600-SUM-SURETY-BOND                                           *        
      *----------------------------------------------------------------*        
       7600-SUM-SURETY-BOND.                                            
           EXEC SQL                                                     
              SELECT SUM(AMT_BOND)                                      
                INTO :WS-AMT-BOND :WS-NULL-INDICATOR                     
                FROM CSS_SURETY_BOND WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO     = :SB-ACCOUNT-NO                    
                 AND CODE_BOND_TYPE = :SB-CODE-BOND-TYPE                
                 AND CODE_STATUS IN ('A','P')                           
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_BOND)                                              
MFA-TR*         INTO :WS-AMT-BOND:WS-NULL-INDICATOR                             
MFA-TR*         FROM CSS_SURETY_BOND                                            
MFA-TR*        WHERE ACCOUNT_NO     = :SB-ACCOUNT-NO                            
MFA-TR*          AND CODE_BOND_TYPE = :SB-CODE-BOND-TYPE                        
MFA-TR*          AND CODE_STATUS IN ('A','P')                                   
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7600'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SURETY_BOND'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_BOND_TYPE'      TO TABLE-ELEMENT-2             
              MOVE SB-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE SB-CODE-BOND-TYPE     TO HOSTVAR-ELEMENT-2           
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * 7605-SUM-IRR-LETTER                                            *        
      *----------------------------------------------------------------*        
       7605-SUM-IRR-LETTER.                                             
           EXEC SQL                                                     
              SELECT SUM(AMT_BOND)                                      
                INTO :WS-AMT-IRR-LTR :WS-NULL-INDICATOR                  
                FROM CSS_SURETY_BOND WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO     = :SB-ACCOUNT-NO                    
                 AND CODE_BOND_TYPE = :SB-CODE-BOND-TYPE                
                 AND CODE_STATUS IN ('A','P')                           
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_BOND)                                              
MFA-TR*         INTO :WS-AMT-IRR-LTR:WS-NULL-INDICATOR                          
MFA-TR*         FROM CSS_SURETY_BOND                                            
MFA-TR*        WHERE ACCOUNT_NO     = :SB-ACCOUNT-NO                            
MFA-TR*          AND CODE_BOND_TYPE = :SB-CODE-BOND-TYPE                        
MFA-TR*          AND CODE_STATUS IN ('A','P')                                   
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7605'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SURETY_BOND'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_BOND_TYPE'      TO TABLE-ELEMENT-2             
              MOVE SB-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE SB-CODE-BOND-TYPE     TO HOSTVAR-ELEMENT-2           
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7605-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * 7610-SUM-GUARANTOR                                             *        
      *----------------------------------------------------------------*        
       7610-SUM-GUARANTOR.                                              
           EXEC SQL                                                     
              SELECT SUM(AMOUNT_GUARANTEED)                             
                INTO :WS-AMT-GUARANTEED :WS-NULL-INDICATOR               
                FROM CSS_GUARANTOR WITH(READUNCOMMITTED)                        
               WHERE ACCOUNT_NO = :GU-ACCOUNT-NO                        
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMOUNT_GUARANTEED)                                     
MFA-TR*         INTO :WS-AMT-GUARANTEED:WS-NULL-INDICATOR                       
MFA-TR*         FROM CSS_GUARANTOR                                              
MFA-TR*        WHERE ACCOUNT_NO = :GU-ACCOUNT-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7610'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_GUARANTOR'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE GU-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * 7620-SUM-DEP-ON-HAND                                           *        
      *----------------------------------------------------------------*        
       7620-SUM-DEP-ON-HAND.                                            
           EXEC SQL                                                     
              SELECT SUM(AMT_DEPOSIT)                                   
                INTO :WS-AMT-DEP-ON-HAND :WS-NULL-INDICATOR              
                FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO = :DO-ACCOUNT-NO                        
                 AND (DEPOSIT_STATUS_CD = 'A'                           
                  OR  DEPOSIT_STATUS_CD = 'P')                          
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_DEPOSIT)                                           
MFA-TR*         INTO :WS-AMT-DEP-ON-HAND:WS-NULL-INDICATOR                      
MFA-TR*         FROM CSS_DEP_ON_HAND                                            
MFA-TR*        WHERE ACCOUNT_NO = :DO-ACCOUNT-NO                                
MFA-TR*          AND (DEPOSIT_STATUS_CD = 'A'                                   
MFA-TR*           OR  DEPOSIT_STATUS_CD = 'P')                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7620'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * WRITE ERROR-LOG AND RETURN TO CALLING PROGRAM                  *        
      *----------------------------------------------------------------*        
       9900-SQL-ERROR-ROUTINE.                                          
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE                 
                                         ABEND-SQLCODE                  
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXIT PROGRAM                                                 
           .                                                            
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
