      ******************************************************************00000401
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **00000501
      **                                                              **00000601
      *********           CUSTOMER SERVICE SYSTEM              *********00000701
      *********                     DB2                        *********00000801
      **                                                              **00000601
      ******************************************************************        
      **--------------- P R O G R A M  S U M M A R Y -----------------**        
      *************************************************************** **        
      ** CPD00351:                                                    **        
      **           1. WS-REFERENCES - CWS00351                        **00020000
      **           2. COPYBOOK FOR CORRESP DATA INSERT PROCESS.       **        
      ******************************************************************        
      ** PREREQUISITES: THE WORKING STORAGE VARIABLES SHOULD BE       **        
      **                POPULATED PRIOR TO INVOKING THIS ROUTINE      **        
      ** INPUT :                                                      **        
      **    WS-CUSTOMER-NO                                            **        
      **    WS-CR-HIST-TRAN-DT                                        **        
      **    WS-CR-HIST-TRAN-TM                                        **        
      **    WS-CPD351-COMP-NO                                         **        
      **    PARM-REG-GROUP-CD                                         **        
      **    PARM-SENIOR-FL                                            **        
      **    PROGRAM-NAME                                              **        
      ** OUTPUT:                                                      **        
      **    INSERT CORRESP DATA DETAILS.                              **        
      **                                                              **        
      ******************************************************************        
      **------------- PROGRAM  MODIFICATION  LOG -------------------- **        
      ******************************************************************        
      **      CPD00351   PROGRAM  MODIFICATION  LOG                   **        
      **                                                              **        
      **   DATE        INITIALS  REASON                               **        
      **   __________  ________  ______________                       **        
P00599**   09/27/2012  AA97148   INITIAL PROGRAM VERSION.             **        
P0599A**   02/16/2013  AA97148   POPULATE NEW FIELD WS-CR-HIST-TRN-DT **        
A05382**   02/07/2016  MJ13662   GENERATE RISK BASED PRICING NOTICE   **        
A05382**                         FOR SCEG AND PSNC.                   **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      * 5000-CORRESP-DATA-INSERT-DTLS                                  *        
      ******************************************************************        
      *                                                                         
       5000-CORRESP-DATA-INSERT-DTLS.                                   
      *                                                                         
           PERFORM 5040-POPULATE-CORRESP-HDR-DTLS                       
                                                THRU 5040-CPD351-EXIT.  
           PERFORM 5010-GET-MSG-ID-FST-METHOD   THRU 5010-CPD351-EXIT.  
           PERFORM 5030-CALL-NOTICES            THRU 5030-CPD351-EXIT.  
                                                                        
           IF RS-RETURN-CODE = 0                                        
              IF LF-LETTER-NOTIFY-CD = 'A' OR 'U'                       
                 PERFORM 5020-GET-MSG-ID-SCND-METHOD                    
                                                THRU 5020-CPD351-EXIT   
                 PERFORM 5030-CALL-NOTICES      THRU 5030-CPD351-EXIT   
              END-IF                                                    
           END-IF.                                                      
      *                                                                 66150000
       5000-CPD351-EXIT.                                                
           EXIT.                                                        
      *                                                                 66150000
      ******************************************************************        
      * 5010-GET-MSG-ID-FST-METHOD                                     *        
      ******************************************************************        
                                                                        
       5010-GET-MSG-ID-FST-METHOD.                                      
                                                                        
           IF LF-LETTER-NOTIFY-CD = 'A'                                 
              IF CK-CR-CHK-COMPANY-NO = '30'                            
                 MOVE '92065'    TO WS-CORRESP-MSG-ID                   
              ELSE                                                      
                 MOVE '92061'    TO WS-CORRESP-MSG-ID                   
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF LF-LETTER-NOTIFY-CD = 'U'                                 
              IF CK-CR-CHK-COMPANY-NO = '30'                            
                 MOVE '92067'    TO WS-CORRESP-MSG-ID                   
              ELSE                                                      
                 MOVE '92063'    TO WS-CORRESP-MSG-ID                   
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF CK-ADV-CREDIT-LTR = 'Y'                                   
              IF CWS350-SEB-DATABASE                                    
                 IF CK-SPECIAL-OFFER-CD = 'P' AND                       
                    CK-APPL-STATUS-CD   = 'C'                           
                    MOVE '90706' TO WS-CORRESP-MSG-ID                   
                 ELSE                                                   
                    MOVE '90701' TO WS-CORRESP-MSG-ID                   
                 END-IF                                                 
              END-IF                                                    
              IF CWS350-CSR-DATABASE                                    
                 IF CK-CR-CHK-COMPANY-NO = '30'                         
                    MOVE '90799' TO WS-CORRESP-MSG-ID                   
                 ELSE                                                   
A05382              IF CK-CR-ACTION-FL = 'H' OR 'G' OR 'F' OR 'E'       
A05382                 MOVE '90704' TO WS-CORRESP-MSG-ID                
A05382              ELSE                                                
                       MOVE '90701' TO WS-CORRESP-MSG-ID                
A05382              END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5010-CPD351-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5020-GET-MSG-ID-SCND-METHOD                                    *        
      ******************************************************************        
                                                                        
       5020-GET-MSG-ID-SCND-METHOD.                                     
                                                                        
           PERFORM 7000-SELECT-CREDIT-HIST-ADDR  THRU 7000-CPD351-EXIT. 
           MOVE LJ-ADDR-TYPE-CD  TO WS-ADDR-TYPE-CD.                    
                                                                        
           IF LF-LETTER-NOTIFY-CD = 'A'                                 
              IF WS-ADDR-TYPE-CD  = 'C'                                 
                 IF CK-CR-CHK-COMPANY-NO = '30'                         
                    MOVE '92066' TO WS-CORRESP-MSG-ID                   
                 ELSE                                                   
                    MOVE '92062' TO WS-CORRESP-MSG-ID                   
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF LF-LETTER-NOTIFY-CD = 'U'                                 
              IF WS-ADDR-TYPE-CD  = 'C'                                 
                 IF CK-CR-CHK-COMPANY-NO = '30'                         
                    MOVE '92068' TO WS-CORRESP-MSG-ID                   
                 ELSE                                                   
                    MOVE '92064' TO WS-CORRESP-MSG-ID                   
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5020-CPD351-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5030-CALL-NOTICES                                                       
      ******************************************************************        
      *                                                                         
       5030-CALL-NOTICES.                                               
                                                                        
           CALL MCSKR125 USING   WS-CORRESP-HDR                         
                                 WS-CORRESP-NOTICE                      
                                 WS-CORRESP-VAR                         
                                 WS-MISC-PROCESSING-VARS                
                                 WS-KR125-COMM-DATA-VARS                
                                 WS-KR125-MNT-TRANS-VARS                
                                 ABEND-FILE                             
                                 WS-CWS350-MISC                         
                                 WS-CORRESP-COMM-VAR                    
                                 RS-KR125-RETURN-CODE.                  
                                                                        
           IF ABEND-FUNCTION  > SPACES                                  
              MOVE ABEND-SQLCODE            TO RS-RETURN-CODE           
                                               WS-ACTIVE-RETURN-CODE    
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       5030-CPD351-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5040-POPULATE-CORRESP-HDR-DTLS                                 *        
      ******************************************************************        
                                                                        
       5040-POPULATE-CORRESP-HDR-DTLS.                                  
                                                                        
           INITIALIZE WS-CORRESP-NOTICE                                 
                      WS-CORRESP-VAR.                                   
                                                                        
P0599A     PERFORM 7010-GET-CURRENT-DATE    THRU 7010-CPD351-EXIT.      
           MOVE WS-CUSTOMER-NO       TO WS-NOTICE-CUSTOMER-NO.          
           MOVE ZEROES               TO WS-NOTICE-ACCOUNT-NO            
                                        WS-CORRESP-THD-PRTY-ID          
                                        WS-NOTICE-GUARANTOR-ACCT-NO.    
           MOVE SPACES               TO WS-CORRESP-BARCODE-UNIQUE-ID.   
P0599A     MOVE WS-CORRESP-STMT-DT   TO WS-CORRESP-CREATE-DT.           
           MOVE WS-CR-HIST-TRAN-TM   TO WS-CR-HIST-TRN-TM               
P0599A     MOVE WS-CR-HIST-TRAN-DT   TO WS-CR-HIST-TRN-DT.              
           MOVE WS-CPD351-COMP-NO    TO WS-CORRESP-COMPANY-NO.          
           MOVE PARM-REG-GROUP-CD    TO WS-NOTICE-REG-GROUP-CD.         
           MOVE PARM-SENIOR-FL       TO WS-NOTICE-SENIOR-FL             
           MOVE PROGRAM-NAME         TO WS-CORRESP-CREATED-BY-PGM-ID    
                                        WS-CORRESP-LAST-UPDATE-PGM-ID   
                                        WS-CALLING-PGM-NAME.            
       5040-CPD351-EXIT.                                                
           EXIT.                                                        
                                                                        
      ***********************************************************************   
      * 7000-SELECT-CREDIT-HIST-ADDR                                   *        
      ***********************************************************************   
                                                                        
       7000-SELECT-CREDIT-HIST-ADDR.                                    
                                                                        
           EXEC SQL                                                     
              SELECT ADDR_TYPE_CD                                       
                INTO :LJ-ADDR-TYPE-CD                                   
                FROM CSS_CRED_HIST_ADDR WITH(READUNCOMMITTED)                   
               WHERE CR_HIST_TRAN_DT = IIF(TRY_CONVERT(DATE, 
                                                    :LJ-CR-HIST-TRAN-DT
              ) IS NULL OR (PATINDEX('%.%', :LJ-CR-HIST-TRAN-DT
              ) <> 0) OR (LEN(:LJ-CR-HIST-TRAN-DT
              ) <> 10), CIS.CHAR2DATE(:LJ-CR-HIST-TRAN-DT
              ), CONVERT(DATE, :LJ-CR-HIST-TRAN-DT) )              
                 AND CR_HIST_TRAN_TM = CIS.CHAR2TIME(:LF-CR-HIST-TRAN-TM
              )              
                 AND CUSTOMER_NO     = :LJ-CUSTOMER-NO                  
                 AND ADDR_TYPE_CD    = 'C'                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ADDR_TYPE_CD                                               
MFA-TR*         INTO :LJ-ADDR-TYPE-CD                                           
MFA-TR*         FROM CSS_CRED_HIST_ADDR                                         
MFA-TR*        WHERE CR_HIST_TRAN_DT = :LJ-CR-HIST-TRAN-DT                      
MFA-TR*          AND CR_HIST_TRAN_TM = :LF-CR-HIST-TRAN-TM                      
MFA-TR*          AND CUSTOMER_NO     = :LJ-CUSTOMER-NO                          
MFA-TR*          AND ADDR_TYPE_CD    = 'C'                                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CRED_HIST_ADDR'  TO TABLE-1                     
              MOVE 'CR_HIST_TRAN_DT'     TO TABLE-ELEMENT-1             
              MOVE LJ-CR-HIST-TRAN-DT    TO HOSTVAR-ELEMENT-1           
              MOVE 'CR_HIST_TRAN_TM'     TO TABLE-ELEMENT-2             
              MOVE LF-CR-HIST-TRAN-TM    TO HOSTVAR-ELEMENT-2           
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-3             
              MOVE LJ-CUSTOMER-NO        TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7000-CPD351-EXIT.                                                
           EXIT.                                                        
                                                                        
P0599A******************************************************************        
P0599A* 7010-GET-CURRENT-DATE                                          *        
P0599A******************************************************************        
P0599A                                                                  
P0599A 7010-GET-CURRENT-DATE.                                           
P0599A                                                                  
P0599A     EXEC SQL                                                     
P0599A        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CORRESP-STMT-DT                    
P0599A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CORRESP-STMT-DT = CURRENT DATE                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0599A                                                                  
P0599A     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0599A     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0599A        CONTINUE                                                  
P0599A     ELSE                                                         
P0599A        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P0599A        MOVE '7010'                TO ACTIVE-PARAGRAPH            
P0599A        MOVE 'SET'                 TO ABEND-FUNCTION              
P0599A        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P0599A                                      ABEND-TABLES                
P0599A        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P0599A     END-IF.                                                      
P0599A                                                                  
P0599A 7010-CPD351-EXIT.                                                
P0599A     EXIT.                                                        
P0599A                                                                  
