      ******************************************************************00000401
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **00000501
      **                                                              **00000601
      *********           CUSTOMER SERVICE SYSTEM              *********00000701
      *********                     DB2                        *********00000801
      **                                                              **00000601
      ******************************************************************        
      **--------------- P R O G R A M  S U M M A R Y -----------------**        
      *************************************************************** **        
      ** CPD00350:                                                    **        
      **           1. WS-REFERENCES - CWS00350                        **00020000
      **           2. COPYBOOK TO GET AUTO CARD PAYMENT DATE.         **        
      ******************************************************************        
      ** PREREQUISITES: THE WORKING STORAGE VARIABLES SHOULD BE       **        
      **                POPULATED PRIOR TO INVOKING THIS ROUTINE      **        
      ** INPUT : WS-CWS350-LOCAL-OFFICE                               **        
      **         WS-CWS350-DATABASE                                   **        
      **         1L-CORRESP-MSG-ID                                    **        
      **         1J-CUSTOMER-NO                                       **        
      **         1J-ACCOUNT-NO                                        **        
      **         1J-CORRESP-STMT-DT                                   **        
      **         1J-CORRESP-COMPANY-NO                                **        
      **         PROGRAM-NAME                                         **        
      **                                                              **        
      ** OUTPUT: 1J-BARCODE-UNIQUE-ID                                 **        
      **                                                              **        
      ******************************************************************        
      **------------- PROGRAM  MODIFICATION  LOG -------------------- **        
      ******************************************************************        
      **      CPD00350   PROGRAM  MODIFICATION  LOG                   **        
      **                                                              **        
      **   DATE        INITIALS  REASON                               **        
      **   __________  ________  ______________                       **        
P00599**   08/30/2012  GV7A828   COPYBOOK ORIGINALLY WRITTEN.         **        
ACT115**   04/22/2016  MJ13662   BEFORE INSERTING TO CSS_CORRESP_HDR  **        
ACT115**                         CHECK TO SEE IF ALOC OR ITPA EXISTS. **        
ACT115**                         IF IT DOES, CANCEL IT.               **        
      **                                                              **        
      ******************************************************************        
      ****************************************************************          
      * 5000-CHECK-LOAD-CORRESP-TBL.                                 *          
      ****************************************************************          
       5000-CHECK-LOAD-CORRESP-TBL.                                     
                                                                        
           IF NOT CORRESP-TBL-LOADED                                    
              PERFORM 5050-LOAD-CORRESP-COMM     THRU 5050-CPD350-EXIT  
              SET CORRESP-TBL-LOADED         TO TRUE                    
           END-IF.                                                      
                                                                        
           PERFORM 5025-MATCH-CORRESP-ID         THRU 5025-CPD350-EXIT. 
                                                                        
           IF CORRESP-ID-FND                                            
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 5050-LOAD-CORRESP-COMM     THRU 5050-CPD350-EXIT  
              PERFORM 5025-MATCH-CORRESP-ID      THRU 5025-CPD350-EXIT  
           END-IF.                                                      
                                                                        
        5000-CPD350-EXIT.                                               
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 5025-MATCH-CORRESP-ID.                                       *          
      ****************************************************************          
       5025-MATCH-CORRESP-ID.                                           
                                                                        
           SET WS-COR-INDX               TO 1.                          
           SEARCH WS-CORRESP-COMM-TBL                                   
              WHEN WS-CORR-MSG-ID(WS-COR-INDX) = WS-MESSAGE-ID          
                  SET CORRESP-ID-FND     TO TRUE                        
                  MOVE WS-COMM-TYP-CD(WS-COR-INDX)                      
                                         TO WS-CURR-COMM-TYP-CD         
                  MOVE WS-COMM-SUBTYP-CD(WS-COR-INDX)                   
                                         TO WS-CURR-COMM-SUBTYP-CD      
                  MOVE WS-CORRESP-TYP-CD(WS-COR-INDX)                   
                                         TO WS-CURR-CORRESP-TYP-CD      
                  MOVE WS-COMM-INSERT-FL(WS-COR-INDX)                   
                                         TO WS-CURR-COMM-INSERT-FL      
           END-SEARCH.                                                  
                                                                        
        5025-CPD350-EXIT.                                               
           EXIT.                                                        
      ****************************************************************          
      * 5050-LOAD-CORRESP-COMM.                                      *          
      ****************************************************************          
       5050-LOAD-CORRESP-COMM.                                          
                                                                        
           PERFORM 7450-OPEN-CORRESP-CSR         THRU 7450-CPD350-EXIT. 
           PERFORM 7500-FETCH-CORRESP-CSR        THRU 7500-CPD350-EXIT. 
           PERFORM 5100-LOAD-CORRESP-VAL         THRU 5100-CPD350-EXIT  
             UNTIL SQLCODE = NOT-FOUND.                                 
           PERFORM 7550-CLOSE-CORRESP-CSR        THRU 7550-CPD350-EXIT. 
                                                                        
       5050-CPD350-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5100-LOAD-CORRESP-VAL.                                        *         
      *****************************************************************         
       5100-LOAD-CORRESP-VAL.                                           
                                                                        
           ADD +1                      TO WS-COR-TAB-CNT                
           MOVE 1L-CORRESP-MSG-ID      TO WS-CORR-MSG-ID(WS-COR-TAB-CNT)
           MOVE 1L-COMM-TYPE-CODE      TO WS-COMM-TYP-CD(WS-COR-TAB-CNT)
           MOVE 1L-COMM-SUBTYPE-CODE   TO                               
                                       WS-COMM-SUBTYP-CD(WS-COR-TAB-CNT)
           MOVE 1L-CORRESP-TYPE-CD     TO                               
                                       WS-CORRESP-TYP-CD(WS-COR-TAB-CNT)
           MOVE 1L-COMM-INSERT-FL      TO                               
                                       WS-COMM-INSERT-FL(WS-COR-TAB-CNT)
           PERFORM 7500-FETCH-CORRESP-CSR THRU 7500-CPD350-EXIT.        
                                                                        
       5100-CPD350-EXIT.                                                
           EXIT.                                                        
                                                                        
      *                                                                         
      *****************************************************************         
      *5425-GET-CORRESP-ID-VAL.                                       *         
      *****************************************************************         
       5425-GET-CORRESP-ID-VAL.                                         
                                                                        
           PERFORM 7000-GET-CORRESP-ID           THRU 7000-CPD350-EXIT. 
                                                                        
           MOVE WS-CORRESP-ID          TO 1J-CORRESP-ID                 
                                          1K-CORRESP-ID                 
           IF 1J-BARCODE-UNIQUE-ID <= SPACES AND GEN-BARCODE            
              PERFORM 5430-POPULATE-CA165IN-DTLS THRU 5430-CPD350-EXIT  
              IF BATCH-CALL                                             
                 PERFORM 5435-CALL-SCSCA165      THRU 5435-CPD350-EXIT  
                 MOVE WS-CA165OUT-UNIQ-ID TO 1J-BARCODE-UNIQUE-ID       
              END-IF                                                    
              IF ONLINE-CALL                                            
                 PERFORM 5440-CALL-MCSCB165      THRU 5440-CPD350-EXIT  
                 MOVE WS-CA165OUT-UNIQ-ID TO 1J-BARCODE-UNIQUE-ID       
              END-IF                                                    
              IF WS-CA165OUT-UNIQ-ID <= '000000000'                     
                 MOVE SPACES              TO WS-CA165OUT-UNIQ-ID        
              END-IF                                                    
           END-IF.                                                      
                                                                        
ACT115     IF 1J-CORRESP-MSG-ID = 92062 OR 92064                        
ACT115        CONTINUE                                                  
ACT115     ELSE                                                         
ACT115        IF 1J-CORRESP-TYPE-CD = 'CL' OR 'IT'                      
ACT115           PERFORM 8700-UPDATE-CORRESP-HDR-IT-CL THRU             
ACT115                                                8700-CPD350-EXIT  
ACT115        END-IF                                                    
ACT115     END-IF.                                                      
           PERFORM 8000-INSERT-CORRESP-HDR       THRU 8000-CPD350-EXIT. 
                                                                        
       5425-CPD350-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************00049105
      * 5430-POPULATE-CA165IN-DTLS                                     *00049205
      ******************************************************************00049305
                                                                        
       5430-POPULATE-CA165IN-DTLS.                                      
                                                                        
           MOVE 'NONMKT'                  TO WS-CA165IN-CORR-TYPE.      
           MOVE 1J-CUSTOMER-NO            TO WS-CA165IN-CUSTOMER-NO.    
           MOVE 1J-ACCOUNT-NO             TO WS-CA165IN-ACCOUNT-NO      
           MOVE 1J-CORRESP-STMT-DT        TO WS-CA165IN-PROCESS-DATE.   
           MOVE 1J-CORRESP-COMPANY-NO     TO WS-CA165IN-COMPANY-NO.     
           MOVE WS-CWS350-DATABASE        TO WS-CA165IN-DATABASE.       
           MOVE SPACES                    TO WS-CA165IN-TP-MEMO-PROCESS.
           MOVE WS-CWS350-LOCAL-OFFICE    TO WS-CA165IN-LOCAL-OFFICE.   
           MOVE 'SYSTEM'                  TO WS-CA165IN-UPDATE-USERID.  
           MOVE PROGRAM-NAME              TO WS-CA165IN-APPL-PROGRAM-ID.
                                                                        
           IF CWS350-SEB-DATABASE                                       
              MOVE 1J-REG-GROUP-CD        TO WS-CA165IN-REG-GROUP-CD    
           ELSE                                                         
              MOVE SPACES                 TO WS-CA165IN-REG-GROUP-CD    
           END-IF.                                                      
                                                                        
                                                                        
       5430-CPD350-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************00052705
      * 5435-CALL-SCSCA165.                                            *00052805
      ******************************************************************00052905
                                                                        
       5435-CALL-SCSCA165.                                              
                                                                        
           MOVE SPACES          TO ABEND-FUNCTION.                      
                                                                        
           CALL SCSCA165  USING    WS-SCSCA165-PARMS                    
                                  ,WS-CA165-MISC                        
                                  ,ABEND-FILE                           
                                  ,WS-CA165-RET.                        
                                                                        
           MOVE WS-CA165-RET    TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'O'          TO 1J-CORRESP-STATUS-CD                 
           END-IF.                                                      
                                                                        
       5435-CPD350-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************00052705
      * 5440-CALL-MCSCB165.                                            *00052805
      ******************************************************************00052905
                                                                        
       5440-CALL-MCSCB165.                                              
                                                                        
           MOVE SPACES          TO ABEND-FUNCTION.                      
                                                                        
           CALL MCSCB165  USING    WS-SCSCA165-PARMS                    
                                  ,WS-CA165-MISC                        
                                  ,ABEND-FILE                           
                                  ,WS-CA165-RET.                        
                                                                        
           MOVE WS-CA165-RET    TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'B'          TO 1J-CORRESP-STATUS-CD                 
           END-IF.                                                      
                                                                        
       5440-CPD350-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-GET-CORRESP-ID.                                           *        
      * GET NEXT CORRSP_ID FOR CREDIT NOTICE                           *        
      ******************************************************************        
                                                                        
       7000-GET-CORRESP-ID.                                             
                                                                        
           EXEC SQL                                                     
               SELECT
              NEXT VALUE FOR SEQ_1J_CORRESP_ID
            INTO
              :WS-CORRESP-ID       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ048
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CORRESP-ID = NEXTVAL FOR SEQ_1J_CORRESP_ID               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '7000'               TO ACTIVE-PARAGRAPH             
              MOVE 'SET'                TO ABEND-FUNCTION               
              MOVE SQLCODE              TO ABEND-SQLCODE                
                                           RS-RETURN-CODE               
              MOVE WS-PGRMNAME          TO ABEND-PROGRAM                
              MOVE '7000'               TO ACTIVE-PARAGRAPH             
              MOVE 'CORRESP_ID'         TO TABLE-ELEMENT-1              
              MOVE WS-CORRESP-ID        TO HOSTVAR-ELEMENT-1            
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7000-CPD350-EXIT.                                                
           EXIT.                                                        
      ******************************************************************        
      * 7450-OPEN-CORRESP-CSR                                          *        
      ******************************************************************        
                                                                        
       7450-OPEN-CORRESP-CSR.                                           
                                                                        
      *****************************************************************         
      *DECLARE CORRESP-CSR                                            *         
      *****************************************************************         
           EXEC SQL                                                     
              DECLARE CORRESP-CSR CURSOR WITH ROWSET POSITIONING FOR    
                  SELECT [1L].CORRESP_MSG_ID                              
                        ,[1L].COMM_TYPE_CODE                              
                        ,[1L].COMM_SUBTYPE_CODE                           
                        ,[1L].CORRESP_TYPE_CD                             
                        ,[1L].COMM_INSERT_FL                              
                  FROM   CSS_CORRESP_COMM [1L] WITH(READUNCOMMITTED)            
                  WHERE  [1L].CORRESP_MSG_ID     = :1L-CORRESP-MSG-ID     
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CORRESP-CSR CURSOR WITH ROWSET POSITIONING FOR            
MFA-TR*           SELECT 1L.CORRESP_MSG_ID                                      
MFA-TR*                 ,1L.COMM_TYPE_CODE                                      
MFA-TR*                 ,1L.COMM_SUBTYPE_CODE                                   
MFA-TR*                 ,1L.CORRESP_TYPE_CD                                     
MFA-TR*                 ,1L.COMM_INSERT_FL                                      
MFA-TR*           FROM   CSS_CORRESP_COMM 1L                                    
MFA-TR*           WHERE  1L.CORRESP_MSG_ID     = :1L-CORRESP-MSG-ID             
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              OPEN CORRESP-CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE WS-PGRMNAME          TO ABEND-PROGRAM                
              MOVE '7450'               TO ACTIVE-PARAGRAPH             
              MOVE 'CSS_CORRESP_COMM'   TO TABLE-1                      
              MOVE 'CORRESP_MSG_ID'     TO TABLE-ELEMENT-1              
              MOVE 1L-CORRESP-MSG-ID    TO HOSTVAR-ELEMENT-1            
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       7450-CPD350-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-FETCH-CORRESP-CSR                                         *        
      ******************************************************************        
       7500-FETCH-CORRESP-CSR.                                          
                                                                        
           EXEC SQL                                                     
              FETCH CORRESP-CSR                                         
               INTO :1L-CORRESP-MSG-ID                                  
                   ,:1L-COMM-TYPE-CODE                                  
                   ,:1L-COMM-SUBTYPE-CODE                               
                   ,:1L-CORRESP-TYPE-CD                                 
                   ,:1L-COMM-INSERT-FL                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE SQLCODE              TO ABEND-SQLCODE                
                                           RS-RETURN-CODE               
              MOVE WS-PGRMNAME          TO ABEND-PROGRAM                
              MOVE '7500'               TO ACTIVE-PARAGRAPH             
              MOVE 'CSS_CORRESP_COMM'   TO TABLE-1                      
              MOVE 'CORRESP_MSG_ID'     TO TABLE-ELEMENT-1              
              MOVE 1L-CORRESP-MSG-ID    TO HOSTVAR-ELEMENT-1            
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       7500-CPD350-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7550-CLOSE-CORRESP-CSR                                         *        
      ******************************************************************        
                                                                        
       7550-CLOSE-CORRESP-CSR.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE CORRESP-CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE SQLCODE              TO ABEND-SQLCODE                
                                           RS-RETURN-CODE               
              MOVE WS-PGRMNAME          TO ABEND-PROGRAM                
              MOVE '7550'               TO ACTIVE-PARAGRAPH             
              MOVE 'CSS_CORRESP_COMM'   TO TABLE-1                      
              MOVE 'CORRESP_MSG_ID'     TO TABLE-ELEMENT-1              
              MOVE 1L-CORRESP-MSG-ID    TO HOSTVAR-ELEMENT-1            
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       7550-CPD350-EXIT.                                                
           EXIT.                                                        
      *****************************************************************         
      * 8000-INSERT-CORRESP-HDR.                                      *         
      *****************************************************************         
       8000-INSERT-CORRESP-HDR.                                         
      *                                                                         
           IF 1J-ACCOUNT-NO        = ZEROES                             
              MOVE -1                     TO WS-CORRESP-ACCOUNT-NULL    
           ELSE                                                         
              MOVE ZERO                   TO WS-CORRESP-ACCOUNT-NULL    
           END-IF                                                       
      *                                                                         
           IF 1J-CORRESP-SEQ-NO    <= ZEROES                            
              MOVE ZERO                   TO 1J-CORRESP-SEQ-NO          
           END-IF                                                       
      *                                                                         
           IF 1J-THD-PRTY-ID       <= ZEROES                            
              MOVE ZERO                   TO 1J-THD-PRTY-ID             
           END-IF                                                       
      *                                                                         
           EXEC SQL INSERT INTO CSS_CORRESP_HDR                         
                       ( CORRESP_ID                                     
                       , CUSTOMER_NO                                    
                       , ACCOUNT_NO                                     
                       , CORRESP_MSG_ID                                 
                       , CORRESP_STMT_DT                                
                       , GUARNTR_ACCT_NO                                
                       , THD_PRTY_ID                                    
                       , CORRESP_SEQ_NO                                 
                       , CORRESP_COMPANY_NO                             
                       , CORRESP_CREATE_TS                              
                       , CORRESP_STATUS_CD                              
                       , CORRESP_TYPE_CD                                
                       , REG_GROUP_CD                                   
                       , SENIOR_FL                                      
                       , BARCODE_UNIQUE_ID                              
                       , CREATED_BY_PGM_ID                              
                       , LAST_UPDATE_PGM_ID                             
                       , LAST_UPDATE_TS )                               
               VALUES ( :1J-CORRESP-ID                                  
                      , :1J-CUSTOMER-NO                                 
                      , :1J-ACCOUNT-NO :WS-CORRESP-ACCOUNT-NULL       
                      , :1J-CORRESP-MSG-ID                              
                      , IIF(TRY_CONVERT(DATE, :1J-CORRESP-STMT-DT
              ) IS NULL OR (PATINDEX('%.%', :1J-CORRESP-STMT-DT
              ) <> 0) OR (LEN(:1J-CORRESP-STMT-DT
              ) <> 10), CIS.CHAR2DATE(:1J-CORRESP-STMT-DT
              ), CONVERT(DATE, :1J-CORRESP-STMT-DT) )                          
                      , :1J-GUARNTR-ACCT-NO                             
                      , :1J-THD-PRTY-ID                                 
                      , :1J-CORRESP-SEQ-NO                              
                      , :1J-CORRESP-COMPANY-NO                          
                      , CIS.CURRENT$TIMESTAMP()                               
                      , :1J-CORRESP-STATUS-CD                           
                      , :1J-CORRESP-TYPE-CD                             
                      , :1J-REG-GROUP-CD                                
                      , :1J-SENIOR-FL                                   
                      , :1J-BARCODE-UNIQUE-ID                           
                      , :1J-CREATED-BY-PGM-ID                           
                      , :1J-LAST-UPDATE-PGM-ID                          
                      , CIS.CURRENT$TIMESTAMP())                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL INSERT INTO CSS_CORRESP_HDR                                 
MFA-TR*                ( CORRESP_ID                                             
MFA-TR*                , CUSTOMER_NO                                            
MFA-TR*                , ACCOUNT_NO                                             
MFA-TR*                , CORRESP_MSG_ID                                         
MFA-TR*                , CORRESP_STMT_DT                                        
MFA-TR*                , GUARNTR_ACCT_NO                                        
MFA-TR*                , THD_PRTY_ID                                            
MFA-TR*                , CORRESP_SEQ_NO                                         
MFA-TR*                , CORRESP_COMPANY_NO                                     
MFA-TR*                , CORRESP_CREATE_TS                                      
MFA-TR*                , CORRESP_STATUS_CD                                      
MFA-TR*                , CORRESP_TYPE_CD                                        
MFA-TR*                , REG_GROUP_CD                                           
MFA-TR*                , SENIOR_FL                                              
MFA-TR*                , BARCODE_UNIQUE_ID                                      
MFA-TR*                , CREATED_BY_PGM_ID                                      
MFA-TR*                , LAST_UPDATE_PGM_ID                                     
MFA-TR*                , LAST_UPDATE_TS )                                       
MFA-TR*        VALUES ( :1J-CORRESP-ID                                          
MFA-TR*               , :1J-CUSTOMER-NO                                         
MFA-TR*               , :1J-ACCOUNT-NO   :WS-CORRESP-ACCOUNT-NULL               
MFA-TR*               , :1J-CORRESP-MSG-ID                                      
MFA-TR*               , :1J-CORRESP-STMT-DT                                     
MFA-TR*               , :1J-GUARNTR-ACCT-NO                                     
MFA-TR*               , :1J-THD-PRTY-ID                                         
MFA-TR*               , :1J-CORRESP-SEQ-NO                                      
MFA-TR*               , :1J-CORRESP-COMPANY-NO                                  
MFA-TR*               , CURRENT TIMESTAMP                                       
MFA-TR*               , :1J-CORRESP-STATUS-CD                                   
MFA-TR*               , :1J-CORRESP-TYPE-CD                                     
MFA-TR*               , :1J-REG-GROUP-CD                                        
MFA-TR*               , :1J-SENIOR-FL                                           
MFA-TR*               , :1J-BARCODE-UNIQUE-ID                                   
MFA-TR*               , :1J-CREATED-BY-PGM-ID                                   
MFA-TR*               , :1J-LAST-UPDATE-PGM-ID                                  
MFA-TR*               , CURRENT TIMESTAMP)                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR  (         
              WS-ACTIVE-RETURN-CODE EQUAL -803 AND ONLINE-CALL)         
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES          TO ABEND-TABLES                     
                                       ABEND-SQL-PREDICATES             
               MOVE '8000'          TO ACTIVE-PARAGRAPH                 
               MOVE SQLCODE         TO ABEND-SQLCODE                    
                                       RS-RETURN-CODE                   
               MOVE WS-PGRMNAME     TO ABEND-PROGRAM                    
               MOVE 'INSERT'        TO ABEND-FUNCTION                   
               MOVE 'CSS_CORRESP_HDR'                                   
                                    TO TABLE-1                          
               MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1                  
               MOVE 1J-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1                
               MOVE 'CORRESP_ID'    TO TABLE-ELEMENT-2                  
               MOVE 1J-CORRESP-ID                                       
                                    TO HOSTVAR-ELEMENT-2                
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       8000-CPD350-EXIT.                                                
           EXIT.                                                        
      ******************************************************************        
      * 8500-INSERT-CORRESP-NOTICE.                                    *        
      ******************************************************************        
       8500-INSERT-CORRESP-NOTICE.                                      
                                                                        
           IF 1M-NOTICE-DUE-DT    = LOW-VALUES OR SPACES                
              MOVE -1                     TO WS-NOTICE-DUE-DT-NULL      
           ELSE                                                         
              MOVE ZERO                   TO WS-NOTICE-DUE-DT-NULL      
           END-IF                                                       
                                                                        
           IF 1M-LAST-PAYMENT-DT  = LOW-VALUES OR SPACES                
              MOVE -1                     TO WS-LAST-PAYMENT-DT-NULL    
           ELSE                                                         
              MOVE ZERO                   TO WS-LAST-PAYMENT-DT-NULL    
           END-IF                                                       
      *                                                                         
           EXEC SQL INSERT INTO CSS_CORRESP_NOTICE                      
                       ( CORRESP_ID                                     
                       , CASH_ONLY_FL                                   
                       , AUTO_DEP_FCST_AM                               
                       , UTIL_PAST_DUE_AM                               
                       , NONUTL_PAST_DUE_AM                             
                       , NOTICE_DUE_DT                                  
                       , NOTICE_DUE_AM                                  
                       , LAST_PAYMENT_AM                                
                       , LAST_PAYMENT_DT                                
                       , LAST_UPDATE_TS)                                
               VALUES ( :1M-CORRESP-ID                                  
                      , :1M-CASH-ONLY-FL                                
                      , :1M-AUTO-DEP-FCST-AM                            
                      , :1M-UTIL-PAST-DUE-AM                            
                      , :1M-NONUTL-PAST-DUE-AM                          
                      , IIF(TRY_CONVERT(DATE, :1M-NOTICE-DUE-DT 
                                              :WS-NOTICE-DUE-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :1M-NOTICE-DUE-DT 
                                                 :WS-NOTICE-DUE-DT-NULL
              ) <> 0) OR (LEN(:1M-NOTICE-DUE-DT :WS-NOTICE-DUE-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:1M-NOTICE-DUE-DT 
                                                 :WS-NOTICE-DUE-DT-NULL
              ), CONVERT(DATE, :1M-NOTICE-DUE-DT :WS-NOTICE-DUE-DT-NULL
              ) )      
                      , :1M-NOTICE-DUE-AM                               
                      , :1M-LAST-PAYMENT-AM                             
                      , IIF(TRY_CONVERT(DATE, :1M-LAST-PAYMENT-DT 
                                              :WS-LAST-PAYMENT-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :1M-LAST-PAYMENT-DT 
                                               :WS-LAST-PAYMENT-DT-NULL
              ) <> 0) OR (LEN(:1M-LAST-PAYMENT-DT 
                                               :WS-LAST-PAYMENT-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:1M-LAST-PAYMENT-DT 
                                               :WS-LAST-PAYMENT-DT-NULL
              ), CONVERT(DATE, :1M-LAST-PAYMENT-DT 
                                               :WS-LAST-PAYMENT-DT-NULL
              ) )    
                      , CIS.CURRENT$TIMESTAMP())                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL INSERT INTO CSS_CORRESP_NOTICE                              
MFA-TR*                ( CORRESP_ID                                             
MFA-TR*                , CASH_ONLY_FL                                           
MFA-TR*                , AUTO_DEP_FCST_AM                                       
MFA-TR*                , UTIL_PAST_DUE_AM                                       
MFA-TR*                , NONUTL_PAST_DUE_AM                                     
MFA-TR*                , NOTICE_DUE_DT                                          
MFA-TR*                , NOTICE_DUE_AM                                          
MFA-TR*                , LAST_PAYMENT_AM                                        
MFA-TR*                , LAST_PAYMENT_DT                                        
MFA-TR*                , LAST_UPDATE_TS)                                        
MFA-TR*        VALUES ( :1M-CORRESP-ID                                          
MFA-TR*               , :1M-CASH-ONLY-FL                                        
MFA-TR*               , :1M-AUTO-DEP-FCST-AM                                    
MFA-TR*               , :1M-UTIL-PAST-DUE-AM                                    
MFA-TR*               , :1M-NONUTL-PAST-DUE-AM                                  
MFA-TR*               , :1M-NOTICE-DUE-DT   :WS-NOTICE-DUE-DT-NULL              
MFA-TR*               , :1M-NOTICE-DUE-AM                                       
MFA-TR*               , :1M-LAST-PAYMENT-AM                                     
MFA-TR*               , :1M-LAST-PAYMENT-DT :WS-LAST-PAYMENT-DT-NULL            
MFA-TR*               , CURRENT TIMESTAMP)                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SPACES          TO ABEND-TABLES                     
                                       ABEND-SQL-PREDICATES             
               MOVE '8500'          TO ACTIVE-PARAGRAPH                 
               MOVE SQLCODE         TO ABEND-SQLCODE                    
                                       RS-RETURN-CODE                   
               MOVE WS-PGRMNAME     TO ABEND-PROGRAM                    
               MOVE 'INSERT'        TO ABEND-FUNCTION                   
               MOVE 'CSS_CORRESP_NOTICE'                                
                                    TO TABLE-1                          
               MOVE 'CORRESP_ID'    TO TABLE-ELEMENT-1                  
               MOVE 1M-CORRESP-ID   TO HOSTVAR-ELEMENT-1                
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       8500-CPD350-EXIT.                                                
           EXIT.                                                        
      **************************************************************            
      *INSERT INTO 8600-INSERT-CORRESP-VAR.                        *            
      **************************************************************            
       8600-INSERT-CORRESP-VAR.                                         
                                                                        
           EXEC SQL INSERT INTO CSS_CORRESP_VAR                         
                       ( CORRESP_ID                                     
                       , CORRESP_VAR_NM                                 
                       , CORRESP_VAR_DATA                               
                       , CORRESP_VAR_NUM                                
                       , CORRESP_VAR_CHAR                               
                       , LAST_UPDATE_TS)                                
               VALUES ( :1K-CORRESP-ID                                  
                      , :1K-CORRESP-VAR-NM                              
                      , :1K-CORRESP-VAR-DATA                            
                      , :1K-CORRESP-VAR-NUM                             
                      , :1K-CORRESP-VAR-CHAR                            
                      , CIS.CURRENT$TIMESTAMP())                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL INSERT INTO CSS_CORRESP_VAR                                 
MFA-TR*                ( CORRESP_ID                                             
MFA-TR*                , CORRESP_VAR_NM                                         
MFA-TR*                , CORRESP_VAR_DATA                                       
MFA-TR*                , CORRESP_VAR_NUM                                        
MFA-TR*                , CORRESP_VAR_CHAR                                       
MFA-TR*                , LAST_UPDATE_TS)                                        
MFA-TR*        VALUES ( :1K-CORRESP-ID                                          
MFA-TR*               , :1K-CORRESP-VAR-NM                                      
MFA-TR*               , :1K-CORRESP-VAR-DATA                                    
MFA-TR*               , :1K-CORRESP-VAR-NUM                                     
MFA-TR*               , :1K-CORRESP-VAR-CHAR                                    
MFA-TR*               , CURRENT TIMESTAMP)                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SPACES          TO ABEND-TABLES                     
                                       ABEND-SQL-PREDICATES             
               MOVE '8600'          TO ACTIVE-PARAGRAPH                 
               MOVE SQLCODE         TO ABEND-SQLCODE                    
                                       RS-RETURN-CODE                   
               MOVE WS-PGRMNAME     TO ABEND-PROGRAM                    
               MOVE 'INSERT'        TO ABEND-FUNCTION                   
               MOVE 'CSS_CORRESP_VAR'                                   
                                    TO TABLE-1                          
               MOVE 'CORRESP_ID'    TO TABLE-ELEMENT-1                  
               MOVE 1K-CORRESP-ID   TO HOSTVAR-ELEMENT-1                
               MOVE 'CORRESP_VAR_NM'                                    
                                    TO TABLE-ELEMENT-2                  
               MOVE 1K-CORRESP-VAR-NM                                   
                                    TO HOSTVAR-ELEMENT-2                
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       8600-CPD350-EXIT.                                                
           EXIT.                                                        
      *                                                                         
ACT115*****************************************************************         
ACT115* 8700-UPDATE-CORRESP-HDR-IT-CL                                 *         
ACT115*****************************************************************         
ACT115 8700-UPDATE-CORRESP-HDR-IT-CL.                                   
ACT115                                                                  
ACT115     EXEC SQL                                                     
ACT115        UPDATE CSS_CORRESP_HDR                                    
ACT115           SET CORRESP_STATUS_CD  = 'C'                           
ACT115         WHERE CUSTOMER_NO        = :1J-CUSTOMER-NO               
ACT115           AND CORRESP_COMPANY_NO = :1J-CORRESP-COMPANY-NO        
ACT115           AND REG_GROUP_CD       = :1J-REG-GROUP-CD              
ACT115           AND CORRESP_STATUS_CD  = 'I'                           
ACT115           AND CIS.SUBSTR3(CREATED_BY_PGM_ID,8,1) =                    
ACT115                            :WS-PROGRAM-ID-RQST-REA-350           
ACT115                                                                  
ACT115     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CORRESP_HDR                                            
MFA-TR*          SET CORRESP_STATUS_CD  = 'C'                                   
MFA-TR*        WHERE CUSTOMER_NO        = :1J-CUSTOMER-NO                       
MFA-TR*          AND CORRESP_COMPANY_NO = :1J-CORRESP-COMPANY-NO                
MFA-TR*          AND REG_GROUP_CD       = :1J-REG-GROUP-CD                      
MFA-TR*          AND CORRESP_STATUS_CD  = 'I'                                   
MFA-TR*          AND SUBSTR(CREATED_BY_PGM_ID,8,1) =                            
MFA-TR*                           :WS-PROGRAM-ID-RQST-REA-350                   
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT115                                                                  
ACT115     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT115     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
ACT115        CONTINUE                                                  
ACT115     ELSE                                                         
ACT115        MOVE SPACES                TO ABEND-TABLES                
ACT115                                      ABEND-SQL-PREDICATES        
ACT115        MOVE '8700'                TO ACTIVE-PARAGRAPH            
ACT115        MOVE SQLCODE               TO ABEND-SQLCODE               
ACT115        MOVE WS-PGRMNAME           TO ABEND-PROGRAM               
ACT115        MOVE 'UPDATE'              TO ABEND-FUNCTION              
ACT115        MOVE 'CSS_CORRESP_HDR'     TO TABLE-1                     
ACT115        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
ACT115        MOVE 1J-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
ACT115        MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3             
ACT115        MOVE 1J-CORRESP-COMPANY-NO TO HOSTVAR-ELEMENT-3           
ACT115        MOVE 'CREATED_BY_PGM_ID'   TO TABLE-ELEMENT-4             
ACT115        MOVE 1J-CREATED-BY-PGM-ID  TO HOSTVAR-ELEMENT-4           
ACT115        MOVE 12                    TO RS-RETURN-CODE              
ACT115        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
ACT115     END-IF.                                                      
ACT115                                                                  
ACT115 8700-CPD350-EXIT.                                                
ACT115     EXIT.                                                        
