      *****************************************************************         
      **             SOUTH CAROLINA ELECTRIC & GAS                   **         
      **                                                             **         
      **              CUSTOMER INFORMATION SYSTEM                    **         
      *****************************************************************         
      **              P R O G R A M  S U M M A R Y                   **         
      **                                                             **         
      ** THIS CODE CALCULATES NEW FW_SEQ_NO FOR RETURN CHECK NOTICE  **         
      ** COPYBOOK WILL BE CALLED BY PCSKR200 AND PCSKR300            **         
      ******************************************************************        
      ** PREREQUISITES: THE WORKING STORAGE VARIABLES SHOULD BE       **        
      **                POPULATED PRIOR TO INVOKING THIS ROUTINE      **        
      ** INPUT : KD-ACCOUNT-NO                                        **        
      **         WS-FW-ACTION-DT                                    **          
      **                                                              **        
      ** OUTPUT: WS-NEW-SEQ-NO                                        **        
      **                                                              **        
      **                                                                        
      *****************************************************************         
      **              PROGRAM  MODIFICATION  LOG                     **         
      *****************************************************************         
      **    DATE     INITIALS     REASON                             **         
      **  -------    --------     ------                             **         
P00599**  07/11/2012 GAYATHRI    INITIAL PROGRAM VERSION             **         
P0599A**  01/24/2013 AARON       ADDED UPPER SEQ ACTION DATE.        **         
      *****************************************************************         
      *                                                                         
      ***************************************************************** 00234900
      * 6600-PROCESS-CALC-NEW-SEQ-NO.                                 * 00235000
      ***************************************************************** 00235300
                                                                        
       6600-PROCESS-CALC-NEW-SEQ-NO.                                    
                                                                        
           INITIALIZE WS-NEW-SEQ-NO                                     
                      WS-UPPER-SEQ-NO                                   
                      WS-LOWER-SEQ-NO                                   
                      WS-MAX-SEQ-NO.                                    
                                                                        
           PERFORM 6610-GET-UPPER-SEQ-NO        THRU 6610-CPD348-EXIT.  
           EVALUATE TRUE                                                
             WHEN SQLCODE = 0                                           
               PERFORM 6620-GET-LOWER-SEQ-NO    THRU 6620-CPD348-EXIT   
               IF SQLCODE = 0                                           
                  COMPUTE WS-NEW-SEQ-NO =                               
                  (WS-UPPER-SEQ-NO - WS-LOWER-SEQ-NO)/2+WS-LOWER-SEQ-NO 
               ELSE                                                     
                  COMPUTE WS-NEW-SEQ-NO = WS-UPPER-SEQ-NO/2             
               END-IF                                                   
             WHEN SQLCODE = 100                                         
               PERFORM 6630-GET-MAX-SEQ-NO      THRU 6630-CPD348-EXIT   
               COMPUTE WS-NEW-SEQ-NO = WS-MAX-SEQ-NO + 5                
           END-EVALUATE.                                                
                                                                        
       6600-CPD348-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *6610-GET-UPPER-SEQ-NO.                                                   
      *****************************************************************         
       6610-GET-UPPER-SEQ-NO.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) KD.FW_SEQ_NO,
              KD.FW_ACTION_DT                                   
                 INTO :WS-UPPER-SEQ-NO                                  
P0599A               ,:WS-UPPER-SEQ-ACTION-DT                           
                 FROM CSS_FIN_WO_ACTION KD                              
                WHERE KD.ACCOUNT_NO        = :KD-ACCOUNT-NO             
                  AND KD.FW_ACTION_DT      > IIF(TRY_CONVERT(DATE, 
                                                       :WS-FW-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-FW-ACTION-DT
              ) <> 0) OR (LEN(:WS-FW-ACTION-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-FW-ACTION-DT
              ), CONVERT(DATE, :WS-FW-ACTION-DT) )           
P0599A            AND KD.FW_ACTION_TYPE_CD NOT IN ('AXFR4', 'CREDB')    
                  ORDER BY KD.FW_ACTION_DT ASC                          
P0599A                    ,KD.FW_SEQ_NO    DESC                         
                                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT KD.FW_SEQ_NO                                              
MFA-TR*              ,KD.FW_ACTION_DT                                           
MFA-TR*          INTO :WS-UPPER-SEQ-NO                                          
MFA-TR*              ,:WS-UPPER-SEQ-ACTION-DT                                   
MFA-TR*          FROM CSS_FIN_WO_ACTION KD                              01898000
MFA-TR*         WHERE KD.ACCOUNT_NO        = :KD-ACCOUNT-NO             01899000
MFA-TR*           AND KD.FW_ACTION_DT      > :WS-FW-ACTION-DT           01899000
MFA-TR*           AND KD.FW_ACTION_TYPE_CD NOT IN ('AXFR4', 'CREDB')            
MFA-TR*           ORDER BY KD.FW_ACTION_DT ASC                                  
MFA-TR*                   ,KD.FW_SEQ_NO    DESC                                 
MFA-TR*           FETCH FIRST ROW ONLY                                          
MFA-TR*           QUERYNO 6610                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '6610'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_FIN_WO_ACTION'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE KD-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'WS-FW-ACTION-DT'    TO TABLE-ELEMENT-2              
              MOVE WS-FW-ACTION-DT      TO HOSTVAR-ELEMENT-2            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
       6610-CPD348-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *6620-GET-LOWER-SEQ-NO.                                                   
      *****************************************************************         
       6620-GET-LOWER-SEQ-NO.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) KD.FW_SEQ_NO                                      
                 INTO :WS-LOWER-SEQ-NO                                  
                 FROM CSS_FIN_WO_ACTION KD                              
                WHERE KD.ACCOUNT_NO        = :KD-ACCOUNT-NO             
                  AND KD.FW_SEQ_NO         < :WS-UPPER-SEQ-NO           
P0599A            AND KD.FW_ACTION_DT      < IIF(TRY_CONVERT(DATE, 
                                                :WS-UPPER-SEQ-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-UPPER-SEQ-ACTION-DT
              ) <> 0) OR (LEN(:WS-UPPER-SEQ-ACTION-DT
              ) <> 10), CIS.CHAR2DATE(:WS-UPPER-SEQ-ACTION-DT
              ), CONVERT(DATE, :WS-UPPER-SEQ-ACTION-DT) )    
P0599A            AND KD.FW_ACTION_TYPE_CD NOT IN ('AXFR4', 'CREDB')    
                  ORDER BY KD.FW_ACTION_DT DESC                         
P0599A                    ,KD.FW_SEQ_NO    DESC                         
                                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT KD.FW_SEQ_NO                                              
MFA-TR*          INTO :WS-LOWER-SEQ-NO                                          
MFA-TR*          FROM CSS_FIN_WO_ACTION KD                              01898000
MFA-TR*         WHERE KD.ACCOUNT_NO        = :KD-ACCOUNT-NO             01899000
MFA-TR*           AND KD.FW_SEQ_NO         < :WS-UPPER-SEQ-NO           01899000
MFA-TR*           AND KD.FW_ACTION_DT      < :WS-UPPER-SEQ-ACTION-DT            
MFA-TR*           AND KD.FW_ACTION_TYPE_CD NOT IN ('AXFR4', 'CREDB')            
MFA-TR*           ORDER BY KD.FW_ACTION_DT DESC                                 
MFA-TR*                   ,KD.FW_SEQ_NO    DESC                                 
MFA-TR*           FETCH FIRST ROW ONLY                                          
MFA-TR*           QUERYNO 6620                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '6620'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_FIN_WO_ACTION'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE KD-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'WS-UPPER-SEQ-NO'    TO TABLE-ELEMENT-2              
              MOVE WS-UPPER-SEQ-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       6620-CPD348-EXIT.                                                
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *6630-GET-MAX-SEQ-NO                                                      
      *****************************************************************         
       6630-GET-MAX-SEQ-NO.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) KD.FW_SEQ_NO                                       
                INTO :WS-MAX-SEQ-NO                                     
                FROM CSS_FIN_WO_ACTION KD WITH(READUNCOMMITTED)                 
               WHERE KD.ACCOUNT_NO     = :KD-ACCOUNT-NO                 
               ORDER BY KD.FW_SEQ_NO DESC                               
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT KD.FW_SEQ_NO                                               
MFA-TR*         INTO :WS-MAX-SEQ-NO                                             
MFA-TR*         FROM CSS_FIN_WO_ACTION KD                               01898000
MFA-TR*        WHERE KD.ACCOUNT_NO     = :KD-ACCOUNT-NO                 01899000
MFA-TR*        ORDER BY KD.FW_SEQ_NO DESC                                       
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 6630                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE '6630'               TO ACTIVE-PARAGRAPH             
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_FIN_WO_ACTION'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE KD-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       6630-CPD348-EXIT.                                                
           EXIT.                                                        
                                                                        
