      ******************************************************************00000401
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **00000501
      **                                                              **00000601
      *********           CUSTOMER SERVICE SYSTEM              *********00000701
      *********                     DB2                        *********00000801
      **                                                              **00000601
      ******************************************************************        
      **--------------- P R O G R A M  S U M M A R Y -----------------**        
      *************************************************************** **        
      ** THIS COPYBOOK IS USED TO GET THE WQ GENERATE FLAG TO         **        
      ** DETERMINE IF WQ SHOULD BE GENERATED IN PCSKR205.             **        
      **                                                              **        
      ******************************************************************        
      ** PREREQUISITES: THE WORKING STORAGE VARIABLES SHOULD BE       **        
      **                POPULATED PRIOR TO INVOKING THIS ROUTINE      **        
      ** INPUT : WS-CATEGORY-ID                                       **        
      **         WS-COMP-NO                                           **        
      **         WS-REG-GRP-CD                                        **        
      **         WS-SEN-FL                                            **        
      **         WS-SRCE-PGM-ID                                       **        
      **                                                              **        
      ** OUTPUT: WS-WQ-GEN-FL                                         **        
      **         WS-FOUND-SW                                          **        
      **                                                              **        
      ******************************************************************        
      **------------- PROGRAM  MODIFICATION  LOG -------------------- **        
      ******************************************************************        
      **      CPD00346   PROGRAM  MODIFICATION  LOG                   **        
      **                                                              **        
      **   DATE        INITIALS  REASON                               **        
      **   __________  ________  ______________                       **        
P00599**   06/14/2012  RC41079   INITIAL PROGRAM VERSION.             **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      * CURSOR TO LOAD CSS_WQ_PGM_CNTL DETAILS                         *        
      ******************************************************************        
      *                                                                         
      *****************************************                                 
      * WQ_PGM_CNTL_CSR                                                         
      *****************************************                                 
      *                                                                         
           EXEC SQL                                                     
               DECLARE WQ_PGM_CNTL_CSR CURSOR FOR                       
               SELECT  WN.CATEGORY_ID,                                  
                       WN.SOURCE_PGM_ID,                                
                       WN.COMPANY_NO,                                   
                       WN.REG_GROUP_CD,                                 
                       WN.SENIOR_FL,                                    
                       WN.WQ_GENERATE_FL,                               
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           WN.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') 
           LAST_UPDATE_TS,                               
                       WN.LAST_UPDATE_USERID                            
               FROM    CSS_WQ_PGM_CNTL WN WITH(READUNCOMMITTED)                 
               WHERE   COMPANY_NO = WN.COMPANY_NO                       
                 AND   REG_GROUP_CD = WN.REG_GROUP_CD                   
                 AND   SOURCE_PGM_ID = :WS-SRCE-PGM-ID                  
               ORDER BY WN.COMPANY_NO, WN.REG_GROUP_CD                  
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE WQ_PGM_CNTL_CSR CURSOR FOR                               
MFA-TR*        SELECT  WN.CATEGORY_ID,                                          
MFA-TR*                WN.SOURCE_PGM_ID,                                        
MFA-TR*                WN.COMPANY_NO,                                           
MFA-TR*                WN.REG_GROUP_CD,                                         
MFA-TR*                WN.SENIOR_FL,                                            
MFA-TR*                WN.WQ_GENERATE_FL,                                       
MFA-TR*                WN.LAST_UPDATE_TS,                                       
MFA-TR*                WN.LAST_UPDATE_USERID                                    
MFA-TR*        FROM    CSS_WQ_PGM_CNTL WN                                       
MFA-TR*        WHERE   COMPANY_NO = WN.COMPANY_NO                               
MFA-TR*          AND   REG_GROUP_CD = WN.REG_GROUP_CD                           
MFA-TR*          AND   SOURCE_PGM_ID = :WS-SRCE-PGM-ID                          
MFA-TR*        ORDER BY WN.COMPANY_NO, WN.REG_GROUP_CD                          
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 4900-GET-WQ-GEN-FL                                             *        
      ******************************************************************        
      *                                                                         
       4900-GET-WQ-GEN-FL.                                              
      *                                                                         
      * LOAD WORK QUEUE CONTROL DETAILS INTO WS VARIABLES.                      
           IF WQ-PGM-CNTL-TBL-LOADED                                    
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 5000-LOAD-WQ-PGM-CNTL-TBL                         
                                                  THRU 5000-CPD346-EXIT 
              SET WQ-PGM-CNTL-TBL-LOADED    TO TRUE                     
              DISPLAY WS-CWS346-WQ-PGM-CNTL-TBL                         
           END-IF.                                                      
      *                                                                         
           INITIALIZE     WS-WQ-GEN-FL                                  
                          WS-GENERATE-WQ-SW                             
                          WS-WQ-GENERATED-SW.                           
           PERFORM 5200-SEARCH-WQ-PGM-CNTL-TBL THRU 5200-CPD346-EXIT.   
           IF SEB-DATABASE                                              
             IF FL-NOT-FOUND                                            
               IF WS-SEN-FL > SPACES                                    
                 MOVE SPACES                   TO WS-SEN-FL             
                 PERFORM 5200-SEARCH-WQ-PGM-CNTL-TBL                    
                                                 THRU 5200-CPD346-EXIT  
                 IF FL-NOT-FOUND                                        
                   MOVE SPACES                   TO WS-REG-GRP-CD       
                   PERFORM 5200-SEARCH-WQ-PGM-CNTL-TBL                  
                                                 THRU 5200-CPD346-EXIT  
                 END-IF                                                 
               END-IF                                                   
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       4900-CPD346-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5000-LOAD-WQ-PGM-CNTL-TBL                                      *        
      ******************************************************************        
      *                                                                         
       5000-LOAD-WQ-PGM-CNTL-TBL.                                       
      *                                                                         
           PERFORM 7230-OPEN-WQ-PGM-CNTL        THRU 7230-CPD346-EXIT.  
           PERFORM 7240-FETCH-WQ-PGM-CNTL       THRU 7240-CPD346-EXIT.  
           SET WS-CNTL-INDX               TO 1.                         
           PERFORM 5100-LOAD-WQ-PGM-CNTL-VARS   THRU 5100-CPD346-EXIT   
             UNTIL SQLCODE = NOT-FOUND.                                 
           PERFORM 7250-CLOSE-WQ-PGM-CNTL       THRU 7250-CPD346-EXIT.  
      *                                                                         
       5000-CPD346-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5100-LOAD-WQ-PGM-CNTL-VARS                                     *        
      ******************************************************************        
      *                                                                         
       5100-LOAD-WQ-PGM-CNTL-VARS.                                      
      *                                                                         
           MOVE WN-CATEGORY-ID            TO                            
                WS-CATEGORY-ID-WN(WS-CNTL-INDX).                        
           MOVE WN-SOURCE-PGM-ID          TO                            
                WS-SOURCE-PGM-ID-WN(WS-CNTL-INDX).                      
           MOVE WN-COMPANY-NO             TO                            
                WS-COMPANY-NO-WN(WS-CNTL-INDX).                         
           MOVE WN-REG-GROUP-CD           TO                            
                WS-REG-GROUP-CD-WN(WS-CNTL-INDX).                       
           MOVE WN-SENIOR-FL              TO                            
                WS-SENIOR-FL-WN(WS-CNTL-INDX).                          
           MOVE WN-WQ-GENERATE-FL         TO                            
                WS-WQ-GENERATE-FL-WN(WS-CNTL-INDX).                     
      *                                                                         
           SET WS-CNTL-INDX UP BY 1.                                    
           PERFORM 7240-FETCH-WQ-PGM-CNTL       THRU 7240-CPD346-EXIT.  
      *                                                                         
       5100-CPD346-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5200-SEARCH-WQ-PGM-CNTL-TBL                                    *        
      ******************************************************************        
      *                                                                         
       5200-SEARCH-WQ-PGM-CNTL-TBL.                                     
      *                                                                         
           MOVE WS-N                      TO WS-FOUND-SW.               
      *                                                                         
           SET WS-CNTL-INDX               TO 1.                         
           SEARCH WS-PGM-CNTL-ENTRY                                     
               AT END                                                   
                  CONTINUE                                              
             WHEN WS-CATEGORY-ID-WN(WS-CNTL-INDX)   = WS-CATEGORY-ID    
              AND WS-COMPANY-NO-WN(WS-CNTL-INDX)    = WS-COMP-NO        
              AND WS-REG-GROUP-CD-WN(WS-CNTL-INDX)  = WS-REG-GRP-CD     
              AND WS-SENIOR-FL-WN(WS-CNTL-INDX)     = WS-SEN-FL         
                  MOVE 'Y'     TO WS-FOUND-SW                           
                  MOVE WS-WQ-GENERATE-FL-WN(WS-CNTL-INDX) TO            
                       WS-WQ-GEN-FL                                     
           END-SEARCH.                                                  
      *                                                                         
       5200-CPD346-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7230-OPEN-WQ_PGM_CNTL_CSR                                 **          
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **          
      **      WQ_PGM_CNTL_CSR CURSOR                                **          
      ****************************************************************          
      *                                                                         
       7230-OPEN-WQ-PGM-CNTL.                                           
      *                                                                         
           EXEC SQL                                                     
               OPEN WQ_PGM_CNTL_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** 7230 :  RETURN CODE ERROR - OPEN '           
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '******************************************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7230-CPD346-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7240-FETCH-WQ_PGM_CNTL                                    **          
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **          
      **      WQ_PGM_CNTL_CSR CURSOR                                **          
      ****************************************************************          
       7240-FETCH-WQ-PGM-CNTL.                                          
      *                                                                         
           EXEC SQL                                                     
               FETCH WQ_PGM_CNTL_CSR INTO                               
                   :WN-CATEGORY-ID,                                     
                   :WN-SOURCE-PGM-ID,                                   
                   :WN-COMPANY-NO,                                      
                   :WN-REG-GROUP-CD,                                    
                   :WN-SENIOR-FL,                                       
                   :WN-WQ-GENERATE-FL,                                  
                   :WN-LAST-UPDATE-TS,                                  
                   :WN-LAST-UPDATE-USERID                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               ADD 1 TO WS-CNTL-CNT                                     
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** 7240 :  RETURN CODE ERROR - FETCH'           
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '******************************************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7240-CPD346-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7250-CLOSE-WQ_PGM_CNTL                                    **          
      **      CURSOR DECLARATION, OPEN, FETCH AND CLOSE OF          **          
      **      WQ_PGM_CNTL_CSR CURSOR                                **          
      ****************************************************************          
       7250-CLOSE-WQ-PGM-CNTL.                                          
      *                                                                         
           EXEC SQL                                                     
               CLOSE WQ_PGM_CNTL_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** 7250 :  RETURN CODE ERROR - CLOSE'           
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '******************************************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7250-CPD346-EXIT.                                                
           EXIT.                                                        
      *                                                                         
