      ******************************************************************00000401
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **00000501
      **                                                              **00000601
      *********           CUSTOMER SERVICE SYSTEM              *********00000701
      *********                     DB2                        *********00000801
      **                                                              **00000601
      ******************************************************************        
      **--------------- P R O G R A M  S U M M A R Y -----------------**        
      *************************************************************** **        
      ** CPD00340:                                                    **        
      **           1. WS-REFERENCES - CWS00340                        **00020000
      **           2. COPYBOOK FOR SURETY BOND EXPIRATION.            **        
      **           3. DCLGEN FOR CSS_GUARANTOR.                       **        
      ******************************************************************        
      ** PREREQUISITES: THE WORKING STORAGE VARIABLES SHOULD BE       **        
      **                POPULATED PRIOR TO INVOKING THIS ROUTINE      **        
      ** INPUT :                                                      **        
      **        WS-INPUT-DATE                                         **        
      **        WS-SB-INDX                                            **        
      **        WS-ACCOUNT-NO-SB                                      **        
      **        WS-BOND-NO-SB                                         **        
      **        WS-CODE-BOND-TYPE-SB                                  **        
      **        WS-BOND-EXPIRATION-DT-SB                              **        
      ** OUTPUT:                                                      **        
      **        WS-EXPIRED-COUNTER                                    **        
      **        WS-ACTIVE-COUNTER                                     **        
      **                                                              **        
      ******************************************************************        
      **------------- PROGRAM  MODIFICATION  LOG -------------------- **        
      ******************************************************************        
      **      CPD00340   PROGRAM  MODIFICATION  LOG                   **        
      **                                                              **        
      **   DATE        INITIALS  REASON                               **        
      **   __________  ________  ______________                       **        
P00599**   02/17/2012  RB19957   INITIAL PROGRAM VERSION.             **        
P00599**   04/24/2012  RB19957   CHANGE WS-CODE-DEP-REQ TO            **        
      **             RICK BLACK  WS-CODE-DEP-ON-HAND IN PARA 3500     **        
      ******************************************************************        
      *                                                                         
      ***************************************************************** 03861000
      *  3500-CHECK-SECURITIES.                                       * 03862000
      *  THIS PARAGRAPH WILL CONTROL CHECKING TO SEE IF A SURETY BOND * 03863000
      *  HAS EXPIRED. IT ALSO CHECKS WITH THE DB TABLE CSS_GUARANTOR  * 03864000
      *  TO SEE IF THE CODE DATA PRESENT FOR SECURED ACCOUNT NEEDS    * 03865000
      *  CHANGING.                                                    * 03866000
      ***************************************************************** 03867000
       3500-CHECK-SECURITIES.                                           
      *                                                                 03870000
           INITIALIZE WS-EXPIRED-COUNTER                                
                      WS-ACTIVE-COUNTER.                                
      *                                                                 03870000
           PERFORM 3505-CHECK-SURETY-BOND THRU 3505-CPD340-EXIT.        
      *                                                                 03897000
           IF (WS-EXPIRED-COUNTER > ZERO                                
                   AND WS-ACTIVE-COUNTER = ZERO)                        
                 OR WS-ACCOUNT-NO-SB (1) = ZERO                         
              MOVE WS-CODES-DATA-PRESENT-AT TO WS-CODES-DATA-PRESENT    
              MOVE WS-ACCOUNT-NO-AT TO GU-ACCOUNT-NO                    
              PERFORM 7101-SELECT-GUARANTOR THRU 7101-CPD340-EXIT       
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                                 AND WS-CODE-DEP-ON-HAND = SPACE        
                 MOVE SPACES                TO WS-CODE-SEC-ACCT         
                 MOVE WS-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT-AT 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       3500-CPD340-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 03861000
      *  3505-CHECK-SURETY-BOND.                                      * 03862000
      *  THIS PARAGRAPH WILL CONTROL CHECKING TO SEE IF A SURETY BOND * 03863000
      *  HAS EXPIRED.                                                 * 03864000
      ***************************************************************** 03867000
       3505-CHECK-SURETY-BOND.                                          
      *                                                                 03870000
           PERFORM VARYING WS-SB-INDX FROM 1 BY 1                       
                   UNTIL WS-SB-INDX GREATER THAN 10                     
                      OR WS-ACCOUNT-NO-SB (WS-SB-INDX) = ZERO           
               IF WS-CODE-STATUS-SB (WS-SB-INDX) = WS-ACTIVE            
                  IF WS-CODE-BOND-TYPE-SB (WS-SB-INDX) EQUAL 'A'        
                   OR WS-CODE-BOND-TYPE-SB (WS-SB-INDX) EQUAL 'B'       
                     IF WS-INPUT-DATE                                   
                          > WS-BOND-EXPIRATION-DT-SB (WS-SB-INDX)       
                      AND WS-BOND-EXPIRATION-DT-SB (WS-SB-INDX)         
                          NOT EQUAL SPACES                              
                      AND WS-BOND-EXPIRATION-DT-SB (WS-SB-INDX)         
                          NOT EQUAL LOW-VALUES                          
                        MOVE WS-EXPIRED TO SB-CODE-STATUS               
                        MOVE WS-ACCOUNT-NO-SB (WS-SB-INDX)              
                             TO SB-ACCOUNT-NO                           
                        MOVE WS-BOND-NO-SB (WS-SB-INDX)                 
                             TO SB-BOND-NO                              
                        PERFORM 8905-UPDATE-SURETY-BOND THRU            
                             8905-CPD340-EXIT                           
                        ADD 1 TO WS-EXPIRED-COUNTER                     
                     ELSE                                               
                        ADD 1 TO WS-ACTIVE-COUNTER                      
                     END-IF                                             
                  ELSE                                                  
                     ADD 1 TO WS-ACTIVE-COUNTER                         
                  END-IF                                                
               END-IF                                                   
           END-PERFORM.                                                 
      *                                                                 03897000
       3505-CPD340-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 08888600
      *  7101-SELECT-GUARANTOR.                                       * 08890000
      *  THIS PARAGRAPH CHECKS TO SEE IF THERE IS AN ACTIVE GUARANTOR * 08889000
      *  ON THE ACCOUNT. USED CNT_ITEM_ID FOR NO PARTICULAR REASON.   * 08890000
      ***************************************************************** 08891000
       7101-SELECT-GUARANTOR.                                           
      *                                                                 08894000
           EXEC SQL                                                     
                SELECT CNT_ITEM_ID                                      
                  INTO :GU-CNT-ITEM-ID                                  
                  FROM CSS_GUARANTOR                                    
                 WHERE ACCOUNT_NO     = :GU-ACCOUNT-NO                  
                 AND   GUAR_STATUS_CD = 'A'                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08904000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 08906000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                  OR NOT-FOUND                                          
                  OR -811                                               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '************** CPD00340 ******************'      
              DISPLAY '** 7101 :  RETURN CODE ERROR - COUNT'            
              DISPLAY '* GU-ACCOUNT-NO ', GU-ACCOUNT-NO                 
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '************** CPD00340 ******************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 08920000
       7101-CPD340-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8905-UPDATE-SURETY-BOND                                        *        
      ******************************************************************        
       8905-UPDATE-SURETY-BOND.                                         
      *                                                                         
           EXEC SQL                                                     
                UPDATE CSS_SURETY_BOND                                  
                SET   CODE_STATUS      = :SB-CODE-STATUS                
                WHERE ACCOUNT_NO       = :SB-ACCOUNT-NO                 
                  AND BOND_NO          = :SB-BOND-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              DISPLAY '************** CPD00340 ******************'      
              DISPLAY '** 8905 :  RETURN CODE ERROR - UPDATE'           
              DISPLAY '* SB-ACCOUNT-NO ', SB-ACCOUNT-NO                 
              DISPLAY '* SB-BOND-NO ', SB-BOND-NO                       
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '************** CPD00340 ******************'      
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       8905-CPD340-EXIT.                                                
           EXIT.                                                        
      *                                                                         
