      ******************************************************************00000401
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **00000501
      **                                                              **00000601
      *********           CUSTOMER SERVICE SYSTEM              *********00000701
      *********                     DB2                        *********00000801
      **                                                              **00000601
      ******************************************************************        
      **--------------- P R O G R A M  S U M M A R Y -----------------**        
      *************************************************************** **        
      ** CPD00338:                                                    **        
      **           1. WS-REFERENCES - CWS00338                        **00020000
      **           2. COPYBOOK TO GET AUTO CARD PAYMENT DATE.         **        
      ******************************************************************        
      ** PREREQUISITES: THE WORKING STORAGE VARIABLES SHOULD BE       **        
      **                POPULATED PRIOR TO INVOKING THIS ROUTINE      **        
      ** INPUT : WS-CURR-CHG-DUE-DT                                   **        
      **         WS-AUTO-CARD-PAY-DAYS                                **        
      **                                                              **        
      ** OUTPUT: WS-AUTO-CARD-PYMT-DT                                 **        
      **                                                              **        
      ******************************************************************        
      **------------- PROGRAM  MODIFICATION  LOG -------------------- **        
      ******************************************************************        
      **      CPD00338   PROGRAM  MODIFICATION  LOG                   **        
      **                                                              **        
      **   DATE        INITIALS  REASON                               **        
      **   __________  ________  ______________                       **        
P00599**   02/07/2012  AA97148   INITIAL PROGRAM VERSION.             **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      * 5050-GET-AUTO-CARD-PYMT-DATA                                   *        
      ******************************************************************        
      *                                                                         
       5050-GET-AUTO-CARD-PYMT-DATA.                                    
      *                                                                         
           IF WS-CURR-CHG-DUE-DT = SPACES                               
              MOVE SPACES           TO WS-AUTO-CARD-PYMT-DT             
           ELSE                                                         
      * Look-up AUTO CARD PAY delinq value on Attribute table.          02262000
              SET WS-ATTR-INDX      TO 1                                
              SEARCH WS-ACCT-ATTR-DATA                                  
                  AT END                                                
                     MOVE SPACES    TO WS-AUTO-CARD-PYMT-DT             
                WHEN WS-ACCOUNT-NO-YP(WS-ATTR-INDX) = ZERO              
                     MOVE SPACES    TO WS-AUTO-CARD-PYMT-DT             
                WHEN WS-ATTRIBUTE-DESC-YP(WS-ATTR-INDX) =               
                                                        'AUTO_CARD_PAY' 
                     PERFORM 5060-CALC-AUTO-PYMT-DT                     
                                                   THRU 5060-CPD338-EXIT
              END-SEARCH                                                
           END-IF.                                                      
      *                                                                         
       5050-CPD338-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5060-CALC-AUTO-PYMT-DT                                         *        
      ******************************************************************        
      *                                                                         
       5060-CALC-AUTO-PYMT-DT.                                          
      *                                                                         
      * CURR-CHG-DUE-DT down by AUTO CARD PAY calendar days.                    
           PERFORM 7000-SET-AUTO-CARD-PYMT-DT     THRU 7000-CPD338-EXIT.
           MOVE WS-AUTO-CARD-PYMT-DT      TO WS-NEW-BUSINESS-DAY.       
      * Validate the date is business day, if not get next business day.        
           PERFORM 7010-GET-NEXT-BUSINESS-DAY     THRU 7010-CPD338-EXIT.
           MOVE 1G-BUSINESS-DAY-DT        TO WS-AUTO-CARD-PYMT-DT.      
      *                                                                         
       5060-CPD338-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7000-SET-AUTO-CARD-PYMT-DT.                                     *        
      ******************************************************************        
      *                                                                         
       7000-SET-AUTO-CARD-PYMT-DT.                                      
      *                                                                         
            EXEC SQL                                                    
               SELECT
              DATEADD( DAY, -:WS-AUTO-CARD-PAY-DAYS, 
              IIF(TRY_CONVERT(DATE, :WS-CURR-CHG-DUE-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-CHG-DUE-DT
              ) <> 0) OR (LEN(:WS-CURR-CHG-DUE-DT
              ) <> 10), CIS.CHAR2DATE(:WS-CURR-CHG-DUE-DT
              ), CONVERT(DATE, :WS-CURR-CHG-DUE-DT) ) )
            INTO
              :WS-AUTO-CARD-PYMT-DT  
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SET :WS-AUTO-CARD-PYMT-DT = DATE(:WS-CURR-CHG-DUE-DT)            
MFA-TR*                                  - :WS-AUTO-CARD-PAY-DAYS DAYS          
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-DISPLAY-SQLCODE.        
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** CPD00338 ABORT **********************'
              DISPLAY '* ABEND IN 7000-SET-AUTO-CARD-PYMT-DT          *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* AUTO CARD PAY DT    = ' WS-CURR-CHG-DUE-DT     
              DISPLAY '* AUTO CARD PAY DAYS  = ' WS-AUTO-CARD-PAY-DAYS  
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** CPD00338 ABORT **********************'
              PERFORM 9900-ABEND                         THRU 9900-EXIT 
           END-IF.                                                      
      *                                                                         
       7000-CPD338-EXIT.                                                
            EXIT.                                                       
      *                                                                         
      ******************************************************************08740060
      * 7010-GET-NEXT-BUSINESS-DAY                                     *08790055
      ******************************************************************08830000
      *                                                                         
       7010-GET-NEXT-BUSINESS-DAY.                                      
      *                                                                 08840000
           EXEC SQL                                                     
              SELECT TOP(1) BUSINESS_DAY_DT                                    
                INTO :1G-BUSINESS-DAY-DT                                
                FROM CSS_BUSINESS_DAYS WITH(READUNCOMMITTED)                    
               WHERE BUSINESS_DAY_DT >= IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) )            
               ORDER BY BUSINESS_DAY_DT ASC                             
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUSINESS_DAY_DT                                            
MFA-TR*         INTO :1G-BUSINESS-DAY-DT                                        
MFA-TR*         FROM CSS_BUSINESS_DAYS                                          
MFA-TR*        WHERE BUSINESS_DAY_DT >= :WS-NEW-BUSINESS-DAY                    
MFA-TR*        ORDER BY BUSINESS_DAY_DT ASC                                     
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08950000
           MOVE SQLCODE                   TO WS-DISPLAY-SQLCODE.        
      *                                                                 08970000
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** CPD00338 ABORT **********************'
              DISPLAY '* ABEND IN 7010-GET-NEXT-BUSINESS-DAY          *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* BUSINESS DAY DT     = ' WS-NEW-BUSINESS-DAY    
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** CPD00338 ABORT **********************'
              PERFORM 9900-ABEND                         THRU 9900-EXIT 
           END-IF.                                                      
      *                                                                 09110000
       7010-CPD338-EXIT.                                                
           EXIT.                                                        
      *                                                                 09110000
