      ******************************************************************00000401
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **00000501
      **                                                              **00000601
      *********           CUSTOMER SERVICE SYSTEM              *********00000701
      *********                     DB2                        *********00000801
      **                                                              **00000601
      ******************************************************************        
      **--------------- P R O G R A M  S U M M A R Y -----------------**        
      *************************************************************** **        
      ** CPD00337: 1. COPYBOOK TO LOAD FORECAST ACTION DETAILS FROM   **        
      **              CSS_FW_FCST_ACTION TABLE.                       **        
      **           2. SEARCH ON FORECAST ACTION TABLE TO GET ACTION   **        
      **              LIMIT AMOUNT.                                   **        
      **           3. WS-REFERENCES - CWS00337                        **00020000
      ******************************************************************        
      ** PREREQUISITES: THE WORKING STORAGE VARIABLES SHOULD BE       **        
      **                POPULATED PRIOR TO INVOKING THIS ROUTINE      **        
      ** INPUT : F8-FW-BUS-PROCESS-CD                                 **        
      **         WS-CWS337-PROCESS-DATE                               **        
      **         WS-FW-COMPANY                                        **00100000
      **         WS-REG-GROUP-CD                                      **00110000
      **         WS-FW-PATH-TYPE-CD                                   **00120000
      **         WS-FW-ACTION-TYPE-CD                                 **00130000
      **                                                              **        
      ** OUTPUT: WS-FW-ACTION-LIMIT-AM                                **        
      **         WS-FW-SPEC-PROCESS-CD                                **        
      **         WS-FW-FCST-DAYS-NM                                             
      **                                                              **        
      ******************************************************************        
      **------------- PROGRAM  MODIFICATION  LOG -------------------- **        
      ******************************************************************        
      **      CPD00337   PROGRAM  MODIFICATION  LOG                   **        
      **                                                              **        
      **   DATE        INITIALS  REASON                               **        
      **   __________  ________  ______________                       **        
P00599**   01/10/2012  AA97148   INITIAL PROGRAM VERSION.             **        
      **                                                              **        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      * CURSOR TO LOAD FORECAST ACTION DETAILS                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE FORECAST-ACTN CURSOR FOR                          
               SELECT F8.COMPANY_NO                                     
                     ,F8.REG_GROUP_CD                                   
                     ,F8.FW_PATH_TYPE_CD                                
                     ,F8.FW_ACTION_TYPE_CD                              
                     ,F8.FW_FCST_DAYS_NM                                
                     ,F8.FW_ACTION_LIMIT_AM                             
                     ,F8.FW_SPEC_PROCESS_CD                             
                 FROM CSS_FW_FCST_ACTION F8 WITH(READUNCOMMITTED)               
                WHERE F8.FW_BUS_PROCESS_CD = :F8-FW-BUS-PROCESS-CD      
                  AND F8.EFFECTIVE_DT     <= IIF(TRY_CONVERT(DATE, 
                                                :WS-CWS337-PROCESS-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CWS337-PROCESS-DATE
              ) <> 0) OR (LEN(:WS-CWS337-PROCESS-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CWS337-PROCESS-DATE
              ), CONVERT(DATE, :WS-CWS337-PROCESS-DATE) )    
                  AND F8.EXPIRATION_DT     > IIF(TRY_CONVERT(DATE, 
                                                :WS-CWS337-PROCESS-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CWS337-PROCESS-DATE
              ) <> 0) OR (LEN(:WS-CWS337-PROCESS-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CWS337-PROCESS-DATE
              ), CONVERT(DATE, :WS-CWS337-PROCESS-DATE) )    
                  AND F8.FW_ACTION_SEQ_NO <> 999                        
                ORDER BY F8.COMPANY_NO,                                 
                         F8.FW_ACTION_TYPE_CD                           
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE FORECAST-ACTN CURSOR FOR                                  
MFA-TR*        SELECT F8.COMPANY_NO                                             
MFA-TR*              ,F8.REG_GROUP_CD                                           
MFA-TR*              ,F8.FW_PATH_TYPE_CD                                        
MFA-TR*              ,F8.FW_ACTION_TYPE_CD                                      
MFA-TR*              ,F8.FW_FCST_DAYS_NM                                        
MFA-TR*              ,F8.FW_ACTION_LIMIT_AM                                     
MFA-TR*              ,F8.FW_SPEC_PROCESS_CD                                     
MFA-TR*          FROM CSS_FW_FCST_ACTION F8                                     
MFA-TR*         WHERE F8.FW_BUS_PROCESS_CD = :F8-FW-BUS-PROCESS-CD              
MFA-TR*           AND F8.EFFECTIVE_DT     <= :WS-CWS337-PROCESS-DATE            
MFA-TR*           AND F8.EXPIRATION_DT     > :WS-CWS337-PROCESS-DATE            
MFA-TR*           AND F8.FW_ACTION_SEQ_NO <> 999                                
MFA-TR*         ORDER BY F8.COMPANY_NO,                                         
MFA-TR*                  F8.FW_ACTION_TYPE_CD                                   
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7110                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 5100-GET-FCST-ACTN-DATA                                        *        
      ******************************************************************        
      *                                                                         
       5100-GET-FCST-ACTN-DATA.                                         
      *                                                                         
      * Load Forecast Action Details into WS variables.                         
           IF FCST-ACTN-TBL-LOADED                                      
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 5200-LOAD-FORECAST-ACTION-TBL                     
                                                  THRU 5200-CPD337-EXIT 
              SET FCST-ACTN-TBL-LOADED    TO TRUE                       
           END-IF.                                                      
      *                                                                         
      * Process to Get Forecast Action Limit Amount.                            
           PERFORM 5400-SEARCH-FCST-ACTN-TBL      THRU 5400-CPD337-EXIT.
      *                                                                         
       5100-CPD337-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5200-LOAD-FORECAST-ACTION-TBL                                  *        
      ******************************************************************        
      *                                                                 02284000
       5200-LOAD-FORECAST-ACTION-TBL.                                   
      *                                                                 02284000
           INITIALIZE WS-CWS337-FCST-ACTN-TBL.                          
      *                                                                         
           PERFORM 7100-OPEN-FORECAST-ACTN-CSR    THRU 7100-CPD337-EXIT.
           PERFORM 7110-FETCH-FORECAST-ACTN-CSR   THRU 7110-CPD337-EXIT.
           SET WS-FCST-INDX               TO 1.                         
           PERFORM 5300-LOAD-F8-VARIABLES         THRU 5300-CPD337-EXIT 
             UNTIL SQLCODE = NOT-FOUND.                                 
           PERFORM 7120-CLOSE-FORECAST-ACTN-CSR   THRU 7120-CPD337-EXIT.
      *                                                                         
       5200-CPD337-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5300-LOAD-F8-VARIABLES                                         *        
      ******************************************************************        
      *                                                                         
       5300-LOAD-F8-VARIABLES.                                          
                                                                        
           MOVE F8-COMPANY-NO             TO                            
                WS-COMPANY-NO-F8(WS-FCST-INDX).                         
           MOVE F8-REG-GROUP-CD           TO                            
                WS-REG-GROUP-CD-F8(WS-FCST-INDX).                       
           MOVE F8-FW-PATH-TYPE-CD        TO                            
                WS-FW-PATH-TYPE-CD-F8(WS-FCST-INDX).                    
           MOVE F8-FW-ACTION-TYPE-CD      TO                            
                WS-FW-ACTION-TYPE-CD-F8(WS-FCST-INDX).                  
           MOVE F8-FW-FCST-DAYS-NM        TO                            
                WS-FW-FCST-DAYS-NM-F8(WS-FCST-INDX).                    
           MOVE F8-FW-ACTION-LIMIT-AM     TO                            
                WS-FW-ACTION-LIMIT-AM-F8(WS-FCST-INDX).                 
           MOVE F8-FW-SPEC-PROCESS-CD     TO                            
                WS-FW-SPEC-PROCESS-CD-F8(WS-FCST-INDX).                 
      *                                                                         
           SET WS-FCST-INDX UP BY 1.                                    
           PERFORM 7110-FETCH-FORECAST-ACTN-CSR   THRU 7110-CPD337-EXIT.
      *                                                                         
       5300-CPD337-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5400-SEARCH-FCST-ACTN-TBL                                      *        
      ******************************************************************        
      *                                                                 02284000
       5400-SEARCH-FCST-ACTN-TBL.                                       
      *                                                                 02284000
           INITIALIZE WS-FW-ACTION-LIMIT-AM                             
                      WS-FW-SPEC-PROCESS-CD                             
                      WS-FW-FCST-DAYS-NM.                               
                                                                        
           MOVE 'N' TO WS-F8-MATCH-FOUND.                               
      *                                                                         
           SET WS-FCST-INDX               TO 1.                         
           SEARCH WS-FCST-ACTN-ENTRY                                    
               AT END                                                   
                  PERFORM 5500-GET-DEFAULT-LIMIT-AMT                    
                                                  THRU 5500-CPD337-EXIT 
                  DISPLAY 'DEFAULT ACTION LIMIT AMOUNT USED'            
                  DISPLAY 'COMP NO:      ' WS-FW-COMPANY                
                  DISPLAY 'REG GRP:      ' WS-REG-GROUP-CD              
                  DISPLAY 'PATH TYPE:    ' WS-FW-PATH-TYPE-CD           
                  DISPLAY 'ACTION TYPE:  ' WS-FW-ACTION-TYPE-CD         
             WHEN WS-COMPANY-NO-F8(WS-FCST-INDX)      = WS-FW-COMPANY   
              AND WS-REG-GROUP-CD-F8(WS-FCST-INDX)    = WS-REG-GROUP-CD 
              AND WS-FW-PATH-TYPE-CD-F8(WS-FCST-INDX) =                 
                  WS-FW-PATH-TYPE-CD                                    
              AND WS-FW-ACTION-TYPE-CD-F8(WS-FCST-INDX) =               
                  WS-FW-ACTION-TYPE-CD                                  
                  SET F8-MATCH-FOUND TO TRUE                            
                  MOVE WS-FW-ACTION-LIMIT-AM-F8(WS-FCST-INDX) TO        
                       WS-FW-ACTION-LIMIT-AM                            
                  MOVE WS-FW-SPEC-PROCESS-CD-F8(WS-FCST-INDX) TO        
                       WS-FW-SPEC-PROCESS-CD                            
                  MOVE WS-FW-FCST-DAYS-NM-F8(WS-FCST-INDX) TO           
                       WS-FW-FCST-DAYS-NM                               
           END-SEARCH.                                                  
      *                                                                         
       5400-CPD337-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5500-GET-DEFAULT-LIMIT-AMT.                                    *        
      * THIS PARA GETS THE DEFAULT LIMIT AMOUNT WHEN A MATCH FOR PATH  *        
      * TYPE IS NOT FOULD                                              *        
      ******************************************************************        
      *                                                                         
       5500-GET-DEFAULT-LIMIT-AMT.                                      
      *                                                                         
           SET WS-FCST-INDX  TO 1.                                      
           SEARCH WS-FCST-ACTN-ENTRY                                    
               AT END                                                   
                  DISPLAY 'MISSING ACTION LIMIT AMOUNT'                 
                  DISPLAY 'COMP NO:      ' WS-FW-COMPANY                
                  DISPLAY 'REG GRP:      ' WS-REG-GROUP-CD              
                  DISPLAY 'PATH TYPE:    ' WS-FW-PATH-TYPE-CD           
                  DISPLAY 'ACTION TYPE:  ' WS-FW-ACTION-TYPE-CD         
             WHEN WS-COMPANY-NO-F8(WS-FCST-INDX)      = WS-FW-COMPANY   
              AND WS-REG-GROUP-CD-F8(WS-FCST-INDX)    = WS-REG-GROUP-CD 
              AND WS-FW-PATH-TYPE-CD-F8(WS-FCST-INDX) = 'DE'            
              AND WS-FW-ACTION-TYPE-CD-F8(WS-FCST-INDX) =               
                  WS-FW-ACTION-TYPE-CD                                  
                  SET F8-MATCH-FOUND TO TRUE                            
                  MOVE WS-FW-ACTION-LIMIT-AM-F8(WS-FCST-INDX) TO        
                       WS-FW-ACTION-LIMIT-AM                            
                  MOVE WS-FW-SPEC-PROCESS-CD-F8(WS-FCST-INDX) TO        
                       WS-FW-SPEC-PROCESS-CD                            
                  MOVE WS-FW-FCST-DAYS-NM-F8(WS-FCST-INDX) TO           
                       WS-FW-FCST-DAYS-NM                               
           END-SEARCH.                                                  
      *                                                                         
       5500-CPD337-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-OPEN-FORECAST-ACTN-CSR                                    *        
      ******************************************************************        
      *                                                                         
       7100-OPEN-FORECAST-ACTN-CSR.                                     
      *                                                                 08606000
           EXEC SQL                                                     
              OPEN FORECAST-ACTN                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08365000
           MOVE SQLCODE                   TO WS-DISPLAY-SQLCODE.        
      *                                                                 08365000
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              DISPLAY '********** CPD00337 ABORT **********************'
              DISPLAY '* ABEND IN 7100-OPEN-FORECAST-ACTN-CSR         *'
              DISPLAY '* FORECAST-ACTN ERROR                          *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** CPD00337 ABORT **********************'
              PERFORM 9900-ABEND                         THRU 9900-EXIT 
           END-IF.                                                      
      *                                                                 08375000
       7100-CPD337-EXIT.                                                
           EXIT.                                                        
      *                                                                 08623000
      ******************************************************************        
      * 7110-FETCH-FORECAST-ACTN-CSR                                            
      ******************************************************************        
      *                                                                 08623000
       7110-FETCH-FORECAST-ACTN-CSR.                                    
      *                                                                 08625000
           EXEC SQL                                                     
              FETCH FORECAST-ACTN                                       
               INTO :F8-COMPANY-NO                                      
                   ,:F8-REG-GROUP-CD                                    
                   ,:F8-FW-PATH-TYPE-CD                                 
                   ,:F8-FW-ACTION-TYPE-CD                               
                   ,:F8-FW-FCST-DAYS-NM                                 
                   ,:F8-FW-ACTION-LIMIT-AM                              
                   ,:F8-FW-SPEC-PROCESS-CD                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08365000
           MOVE SQLCODE                   TO WS-DISPLAY-SQLCODE.        
      *                                                                 08365000
           IF SQLCODE NOT = SUCCESSFUL-CALL AND NOT-FOUND               
              DISPLAY '********** CPD00337 ABORT **********************'
              DISPLAY '* ABEND IN 7110-FETCH-FORECAST-ACTN-CSR        *'
              DISPLAY '* FORECAST-ACTN ERROR                          *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* FW BUS PROCESS CD   = ' F8-FW-BUS-PROCESS-CD   
              DISPLAY '* PROCESS DATE        = ' WS-CWS337-PROCESS-DATE 
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** CPD00337 ABORT **********************'
              PERFORM 9900-ABEND                         THRU 9900-EXIT 
           END-IF.                                                      
      *                                                                 08703000
       7110-CPD337-EXIT.                                                
           EXIT.                                                        
      *                                                                 08706000
      ******************************************************************        
      * 7120-CLOSE-FORECAST-ACTN-CSR                                   *        
      ******************************************************************        
      *                                                                 08712000
       7120-CLOSE-FORECAST-ACTN-CSR.                                    
      *                                                                 08708000
           EXEC SQL                                                     
              CLOSE FORECAST-ACTN                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08712000
           MOVE SQLCODE                   TO WS-DISPLAY-SQLCODE.        
      *                                                                 08365000
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              DISPLAY '********** CPD00337 ABORT **********************'
              DISPLAY '* ABEND IN 7120-CLOSE-FORECAST-ACTN-CSR        *'
              DISPLAY '* FORECAST-ACTN ERROR                          *'
              DISPLAY '* SQL RETURN CODE     = ' WS-DISPLAY-SQLCODE     
              DISPLAY '* PROCESSING TERMINATED                        *'
              DISPLAY '********** CPD00337 ABORT **********************'
              PERFORM 9900-ABEND                         THRU 9900-EXIT 
           END-IF.                                                      
      *                                                                 08722000
       7120-CPD337-EXIT.                                                
           EXIT.                                                        
      *                                                                 08722000
