      *****************************************************************         
      **             SOUTH CAROLINA ELECTRIC & GAS                   **         
      **                                                             **         
      **              CUSTOMER INFORMATION SYSTEM                    **         
      *****************************************************************         
      **              P R O G R A M  S U M M A R Y                   **         
      **                                                             **         
      ** INSERTS RESCHEDULED DNP WHEN 6100 WAS CALLED ACCORDINGLY.    **        
      ** THE COPYBOOK CWS00335 IS NECESSARY FOR THIS TO WORK.        **         
      ** APPLIES ONLY TO CSR - SCEG & PSNC                           **         
      ** COPYBOOK WILL BE CALLED BY CSR02122(PNL16, PNL75 & PCSSO103)**         
      ** COPYBOOK WILL NOT INSERT RESCHEDULED DNPS FOR THE FOLLOWING:**         
      **  1.RESCHEDULED DNP SWITCH IS OFF(RES-DNP-SW = 0/PER COMPANY)**         
      **  2.EXEMPTION PREVIOUSLY SET.                                **         
      **  3.EXCEPTIONAL UTILITY (OR) DEPOSIT CREDIT ACTION ALREADY   **         
      **    EXISTS(E/F/G/O/I).                                       **         
      **  4.NOT ENOUGH TIME TO MAIL EXCEPTIONAL 2ND NOTICE.          **         
      ** INSERTS COMMUNICATION RECORD & TRANSACTION HISTORY AS NEEDED**         
      *****************************************************************         
      **              PROGRAM  MODIFICATION  LOG                     **         
      *****************************************************************         
      **    DATE     INITIALS     REASON                             **         
      **  -------    --------     ------                             **         
P00471**  04/11/2011 VENKAT      INITIAL PROGRAM VERSION             **         
      **             VUDDANDAPU                                      **         
TASK01**  08/02/2011 VV94890     ADDED TO DISPLAY THE CANCEL REASON &**         
TASK01**  **P00471**             IVR ON MAINT TRANSACTION HISTORY COM**         
TASK01**                         MENTS BASED ON ACCT TYPE ACCORDINGLY**         
TASK02**  08/16/2011 VV94890     ADDED RETURN CHECK DNP LOGIC(P00471)**         
      *****************************************************************         
      *                                                                         
      ***************************************************************** 00050000
      * 6100-PROCESS-RESCH-DNPS.                                      *         
      ***************************************************************** 00050000
       6100-PROCESS-RESCH-DNPS.                                         
      *                                                                         
           INITIALIZE CWS00335-FIELDS.                                  
           MOVE AT-ACCOUNT-NO          TO CL-ACCOUNT-NO.                
           MOVE AT-COMPANY-NO          TO C8-COMPANY-NO.                
           PERFORM 6120-RSD-DELINQ-VALUE     THRU 6120-RSD-DELINQ-EXIT. 
      *                                                                         
      ***************************************************************** 00050000
      * DISCONNECTION WAS NOT RESCHEDULED, IF RESCHEDULED DNP SWITCH  *         
      * IS OFF(RES-DNP-SW = 0/PER COMPANY).                           *         
      ***************************************************************** 00050000
      *                                                                         
           IF WS-RESCH-DNP-SW  = 0                                      
              MOVE +4100               TO WS-RETURN-CODE-C335           
              GO TO 6100-RESCH-DNPS-EXIT                                
           END-IF.                                                      
      *                                                                         
      ***************************************************************** 00050000
      * DISCONNECTION WAS NOT RESCHEDULED, IF DISCONNECT EXEMPTION    *         
      * PREVIOUSLY SET.                                               *         
      ***************************************************************** 00050000
      *                                                                         
           IF ( AT-NOTICE-EXEMPT-CD > SPACES AND NOT = 'A' ) OR         
              ( AT-CODE-DISC-OK     > SPACES AND NOT = 'A' )            
              MOVE WS-INIT-COMMENTS-LEN  TO WS-INITIAL-COMMENT-TX-LEN   
              MOVE WS-RSD-INIT-COMMENTS  TO WS-INIT-COMM-TEXT-RESCH     
              MOVE WS-RSD-EXEMPTION-TEXT TO WS-INIT-COMM-TEXT-INFO      
              MOVE WS-INIT-COMMENTS-TEXT TO WS-INITIAL-COMMENT-TX-TEXT  
              PERFORM 6110-RESCH-COMM-RECORD THRU 6110-RESCH-COMM-EXIT  
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE +4300              TO WS-RETURN-CODE-C335         
              END-IF                                                    
              GO TO 6100-RESCH-DNPS-EXIT                                
           END-IF.                                                      
      *                                                                         
      ***************************************************************** 00050000
      * DISCONNECTION WAS NOT RESCHEDULED, IF EXCEPTIONAL UTILITY (OR)*         
      * DEPOSIT CREDIT ACTION ALREADY EXISTS (E/F/G/O/I).             *         
      ***************************************************************** 00050000
      *                                                                         
           MOVE 'N'                      TO WS-EXCEP-CRD-ACT-EXIST.     
           PERFORM 7210-CHECK-EXCEP-CRED-ACT     THRU 7210-EXCEP-EXIT.  
      *                                                                         
           IF WS-EXCEP-CRD-ACT-EXIST = 'Y'                              
              MOVE WS-INIT-COMMENTS-LEN  TO WS-INITIAL-COMMENT-TX-LEN   
              MOVE WS-RSD-INIT-COMMENTS  TO WS-INIT-COMM-TEXT-RESCH     
              MOVE WS-RSD-EXCEPTION-TEXT TO WS-INIT-COMM-TEXT-INFO      
              MOVE WS-INIT-COMMENTS-TEXT TO WS-INITIAL-COMMENT-TX-TEXT  
              PERFORM 6110-RESCH-COMM-RECORD THRU 6110-RESCH-COMM-EXIT  
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE +4400              TO WS-RETURN-CODE-C335         
              END-IF                                                    
              GO TO 6100-RESCH-DNPS-EXIT                                
           END-IF.                                                      
      *                                                                         
           PERFORM 6130-VERIFY-RSD-DW-VARS   THRU 6130-VRY-DW-VARS-EXIT.
      *                                                                         
      ***************************************************************** 00050000
LOADWD* LOAD WORK DAYS                                                *         
      ***************************************************************** 00050000
      *                                                                         
           MOVE AT-REV-MTH-LST-NRML      TO BN-REVENUE-MONTH.           
           PERFORM 6210-LOAD-RSD-WORK-DAYS    THRU                      
                                              6210-RSD-WORK-DAYS-EXIT.  
      ***************************************************************** 00050000
DNPDT** GET NEXT READ DATE  (CPD00310)                                *         
      ***************************************************************** 00050000
      *                                                                         
           PERFORM 5901-NEXT-READ-DATE THRU 5901-NEXT-READ-DATE-EXIT.   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF RW-THIRD-PTY-READ-DT > SPACES                          
                 MOVE RW-THIRD-PTY-READ-DT TO WS-RSD-TARGET-DT          
              ELSE                                                      
                 MOVE RW-OPTIMUM-READ-DATE TO WS-RSD-TARGET-DT          
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES                  TO WS-RSD-TARGET-DT          
           END-IF.                                                      
      ***************************************************************** 00050000
      * SEARCH FOR TARGET DATE                                        *         
      ***************************************************************** 00050000
      *                                                                         
           PERFORM 6310-SEARCH-FCAST-DT    THRU 6310-SEARCH-DATE-EXIT.  
      ***************************************************************** 00050000
      *                 NEW RESCHEDULED DNP DATE                      *         
      ***************************************************************** 00050000
           IF AT-COMPANY-NO = '26'                                      
              SET BD-INDX UP BY WS-DAY-RESCH-DNP                        
              MOVE WS-RSD-WORK-DAY(BD-INDX) TO WS-NEW-RESCH-DNP-DT      
           ELSE                                                         
              MOVE WS-RSD-WORK-DAY(BD-INDX) TO WS-NEW-RESCH-DNP-DT      
           END-IF.                                                      
      ***************************************************************** 00050000
      *                 NEW RESCHEDULED IVR DATE                      *         
      ***************************************************************** 00050000
           IF AT-ACCOUNT-TYPE-CODE = 'R'                                
              SET BD-INDX DOWN BY WS-RSD-DAY-BSECIVREXC                 
              MOVE WS-RSD-WORK-DAY(BD-INDX) TO WS-NEW-RESCH-IVR-DT      
              SET BD-INDX UP BY WS-RSD-DAY-BSECIVREXC                   
           ELSE                                                         
              MOVE LOW-VALUES               TO WS-NEW-RESCH-IVR-DT      
           END-IF.                                                      
      ***************************************************************** 00050000
      *                 NEW RESCHEDULED SECOND DUE DATE               *         
      ***************************************************************** 00050000
           SET BD-INDX DOWN BY WS-RSD-DAY-DUE.                          
           MOVE WS-RSD-WORK-DAY(BD-INDX) TO WS-NEW-RESCH-SCND-DUE.      
           SET BD-INDX UP BY WS-RSD-DAY-DUE.                            
      ******************************************************************00050000
      *                 NEW RESCHEDULED SECOND MAILED DATE             *        
      *FOR SCEG/DPP, CALCULATE 2ND NOTICE MAIL AS DNP - DPPDELINQ VALUE*03641000
      ******************************************************************03642000
           IF AT-COMPANY-NO = '01' AND WS-CODE-DPP-ACCT = 'A'           
              SET BD-INDX DOWN BY WS-RSD-DAY-DPP-SECND-ML               
           ELSE                                                         
              SET BD-INDX DOWN BY WS-DAY-RESCH-SECND-MAIL               
           END-IF.                                                      
           MOVE WS-RSD-WORK-DAY(BD-INDX) TO WS-NEW-RESCH-SCND-MAIL.     
      ***************************************************************** 00050000
      * DISCONNECTION WAS NOT RESCHEDULED, IF NOT ENOUGH TIME TO MAIL *         
      * EXCEPTIONAL 2ND NOTICE.                                       *         
      * BATCH(CSRS103) - NOTICES ARE PROCESSED PRIOR TO THIS(CSRC132) *         
      * AND SELECT ACCOUNTS 1 BUSINESS DATE PRIOR TO MAIL DATE.       *         
      ***************************************************************** 00050000
      *                                                                         
           PERFORM 7140-GET-CURR-DT        THRU 7140-CURR-DT-EXIT.      
      *                                                                         
           MOVE SPACES                      TO WS-PROCESS-DATE.         
           IF PARM-PANEL-NO = 'P103'                                    
              MOVE SPACES                   TO WS-RSD-TARGET-DT         
              MOVE WS-CURR-DT               TO WS-RSD-TARGET-DT         
              PERFORM 6310-SEARCH-FCAST-DT  THRU 6310-SEARCH-DATE-EXIT  
              SET BD-INDX UP BY 1                                       
              MOVE WS-RSD-WORK-DAY(BD-INDX) TO WS-PROCESS-DATE          
           ELSE                                                         
              MOVE WS-CURR-DT               TO WS-PROCESS-DATE          
           END-IF.                                                      
      *                                                                         
           IF WS-NEW-RESCH-SCND-MAIL <= WS-PROCESS-DATE                 
              MOVE WS-INIT-COMMENTS-LEN  TO WS-INITIAL-COMMENT-TX-LEN   
              MOVE WS-RSD-INIT-COMMENTS  TO WS-INIT-COMM-TEXT-RESCH     
              MOVE WS-RSD-NOT-EGH-TS-TXT TO WS-INIT-COMM-TEXT-INFO      
              MOVE WS-INIT-COMMENTS-TEXT TO WS-INITIAL-COMMENT-TX-TEXT  
              PERFORM 6110-RESCH-COMM-RECORD THRU 6110-RESCH-COMM-EXIT  
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE +4500              TO WS-RETURN-CODE-C335         
              END-IF                                                    
              GO TO 6100-RESCH-DNPS-EXIT                                
           ELSE                                                         
      ***** DISCONNECTION WAS RESCHEDULED******************************         
      ***********CALCULATE DNP AMOUT & TYPE FROM CPD00068**************         
              PERFORM 6410-CPD68-RESULT         THRU 6410-CPD68-EXIT    
              IF WS-NEW-RESCH-DNP-AMT  > ZEROS                          
      ***********DELETE T/U/X NON UTIL ROWS****************************         
                 PERFORM 8210-DEL-NONUTIL-ROWS    THRU 8210-DELETE-EXIT 
      ***********INSERT F/G EXCEPTIONAL ROWS***************************         
                 PERFORM 6510-MOVE-CRED-COLL      THRU 6510-MOVE-EXIT   
TASK02***********NORMAL W/RT CK****************************************         
TASK02           IF WS-NEW-RESCH-DNP-TYPE = 'T'                         
TASK02***********DELETE RETURNED CHECK DNP ROW (H)*********************         
TASK02              PERFORM 8320-DEL-RETCK-DNP-ROW    THRU 8320-H-EXIT  
TASK02***********UPDATE RETURNED CHECK N/W/V ROWS**********************         
TASK02              PERFORM 8330-UPD-RETCK-N-W-V-ROW  THRU 8330-N-EXIT  
TASK02           END-IF                                                 
      ***********INSERT RESCH DNP MAINTENANCE TRANSACTION ROW**********         
                 PERFORM 6515-JRNL-TRAN-HEAD      THRU 6515-HEAD-EXIT   
                 PERFORM 6520-JRNL-UPDATE         THRU 6520-JRNL-EXIT   
      *                                                                         
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    MOVE +4600             TO WS-RETURN-CODE-C335       
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       6100-RESCH-DNPS-EXIT.                                            
           EXIT.                                                        
      *                                                                         
      ******************************************************************04480000
      * COMMUNICATION RECORD FOR DISSCONNECTION WAS NOT RESCHEDULED.   *        
      ******************************************************************        
       6110-RESCH-COMM-RECORD.                                          
      *                                                                         
           MOVE AT-ACCOUNT-NO          TO KO-ACCOUNT-NO                 
           MOVE AT-CUSTOMER-NO         TO KO-CUSTOMER-NO                
           MOVE AT-PREMISE-NO          TO KO-PREMISE-NO                 
           MOVE AT-COMPANY-NO          TO KO-COMPANY-NO                 
           MOVE 'N'                    TO KO-RED-FLAG-IND               
           MOVE SPACES                 TO KO-RED-FLAG-EXPIRE-DT         
           MOVE -1                     TO WS-RED-FL-NULL-IND            
           MOVE 'O'                    TO KO-COMM-METHOD                
           MOVE 'O'                    TO KO-COMM-DIRECTION             
           MOVE '40'                   TO KO-COMM-TYPE-CD               
           MOVE '14'                   TO KO-COMM-SUBTYPE-CODE          
           MOVE 'SYSTEM'               TO KO-USER-ID-ORIG               
           MOVE SPACES                 TO KO-CONTACT-NAME               
           MOVE SPACES                 TO KO-PROMOTION-ID               
           MOVE 'N'                    TO KO-PSC-COMPLIANCE-IND         
           MOVE 0                      TO KO-CALL-ORIGIN-ID             
           MOVE SPACES                 TO KO-CALL-END-TIME              
           MOVE -1                     TO WS-END-NULL-IND               
           MOVE 0                      TO KO-NUMBER-TRANSFERS           
           MOVE 0                      TO KO-HOLD-TIME                  
           MOVE 0                      TO KO-QUEUE-TIME                 
           MOVE 'N'                    TO KO-SCREEN-POP-IND             
           MOVE 0                      TO KO-TOTAL-CALL-TIME            
           MOVE WS-INITIAL-COMMENT-TX  TO KO-INITIAL-COMMENT-TX         
           MOVE SPACES                 TO KO-RESPONSE-REASON-CD         
           MOVE SPACES                 TO KO-RESPONSE-TYPE-CD           
           MOVE SPACES                 TO KO-SOLICITATION-CD            
           MOVE 'A'                    TO KO-COMM-ASSOC-CD              
           MOVE 'N'                    TO KO-COMPLAINT-FL               
           MOVE SPACES                 TO KO-DISCOVERY-MTHD-CD          
           MOVE SPACES                 TO KO-PREV-MARKETER-CD           
      *                                                                         
           PERFORM 8110-INS-RESCH-COMM-DATA      THRU 8110-COMM-EXIT.   
      *                                                                         
       6110-RESCH-COMM-EXIT.                                            
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6120-RSD-DELINQ-VALUE                                         *         
      *      LOAD DELINQUENCY VALUES                                  *         
      *****************************************************************         
       6120-RSD-DELINQ-VALUE.                                           
      *                                                                         
           PERFORM 7110-OPEN-RSD-DW   THRU 7110-OPEN-RSD-DW-EXIT        
           PERFORM 7120-FETCH-RSD-DW  THRU 7120-FETCH-RSD-DW-EXIT       
      *                                                                         
            PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND         
      *                                                                         
                EVALUATE C8-DELINQ-CD                                   
                    WHEN 'DAY-DUE'                                      
                       MOVE C8-DELINQ-VALUE  TO WS-RSD-DAY-DUE          
                    WHEN 'DAY-RESCH-SECND-MAIL'                         
                       MOVE C8-DELINQ-VALUE  TO WS-DAY-RESCH-SECND-MAIL 
                    WHEN 'DAY-DPP-SECOND-MAIL'                          
                       MOVE C8-DELINQ-VALUE  TO WS-RSD-DAY-DPP-SECND-ML 
                    WHEN 'DAY-BSECIVREXC'                               
                       MOVE C8-DELINQ-VALUE  TO WS-RSD-DAY-BSECIVREXC   
                    WHEN 'DAY-RESCH-DNP'                                
                       MOVE C8-DELINQ-VALUE  TO WS-DAY-RESCH-DNP        
                    WHEN 'RESCH-DNP-SW'                                 
                       MOVE C8-DELINQ-VALUE  TO WS-RESCH-DNP-SW         
                END-EVALUATE                                            
      *                                                                         
                PERFORM 7120-FETCH-RSD-DW  THRU 7120-FETCH-RSD-DW-EXIT  
            END-PERFORM                                                 
      *                                                                         
            PERFORM 7130-CLOSE-RSD-DW  THRU 7130-CLOSE-RSD-DW-EXIT.     
      *                                                                         
       6120-RSD-DELINQ-EXIT.                                            
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  THIS PARA CHECKS WHETHER ALL DELINQUENCY VALUES ARE POSITIVE *         
      *****************************************************************         
       6130-VERIFY-RSD-DW-VARS.                                         
      *                                                                         
           MOVE '6130'                       TO ACTIVE-PARAGRAPH.       
      *                                                                         
           IF        WS-RSD-DAY-DUE                   > ZERO            
                 AND WS-DAY-RESCH-SECND-MAIL          > ZERO            
                 AND WS-RSD-DAY-BSECIVREXC            > ZERO            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE -1                        TO WS-ACTIVE-RETURN-CODE   
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'DELINQER'                TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
                                                TABLE-2                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2         
              MOVE C8-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2       
              MOVE 'RESCH-DNP-SW = 0'        TO TABLE-3                 
              MOVE 'TO TURN RES DNP OFF'     TO TABLE-4                 
              PERFORM 9100-RSD-SQL-ERRLOG    THRU 9100-ERRLOG-EXIT      
           END-IF.                                                      
      *                                                                         
       6130-VRY-DW-VARS-EXIT.                                           
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6210-LOAD-RSD-WORK-DAYS.                                       *        
      * LOAD NEXT 4 MONTHS WORK DAYS INTO TABLE FROM FIRST DATE        *        
      * OF REVENUE MONTH.  NEEDED FOR FORECASTING. ENTRY 001 IS        *        
      * THE OPEN DAY OF THE REVENUE MONTH.  1 THROUGH 120 ENTRIES      *        
      * WILL EXIST.                                                    *        
      ******************************************************************        
       6210-LOAD-RSD-WORK-DAYS.                                         
      *                                                                         
           PERFORM 7310-SEL-RSD-MIN-DT-EXT  THRU 7310-RSD-MIN-DT-EXIT   
      *                                                                         
           SET BD-INDX                      TO 1                        
           MOVE WS-RSD-MIN-DT-EXTRT         TO WS-RSD-DT-CCYY-MM-DD     
      *                                                                         
           MOVE WS-RSD-DT-CCYY-MM-DD        TO WS-RSD-WORK-DAY(BD-INDX) 
      *                                                                         
           SET BD-INDX                      TO 2                        
           MOVE 1                           TO WS-ADJ-DY                
      *                                                                         
           PERFORM UNTIL BD-INDX > 120                                  
              OR WS-ADJ-DY > 365                                        
              PERFORM 7410-GET-NEXT-WORK-DY   THRU 7410-NEXT-WK-DY-EXIT 
           END-PERFORM.                                                 
      *                                                                         
       6210-RSD-WORK-DAYS-EXIT.                                         
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 6310-SEARCH-FCAST-DT.                                        *          
      ****************************************************************          
       6310-SEARCH-FCAST-DT.                                            
      *                                                                         
           SET BD-INDX TO 1                                             
      *                                                                         
           SEARCH WS-RSD-WORK-DAY-LIST                                  
              AT END                                                    
                MOVE -1                      TO WS-ACTIVE-RETURN-CODE   
                MOVE PROGRAM-NAME            TO ABEND-PROGRAM           
                MOVE '6310'                  TO ACTIVE-PARAGRAPH        
                MOVE 'SEARCH'                TO ABEND-FUNCTION          
                MOVE 'WORK DAY LIST'         TO TABLE-1                 
                MOVE 'WORK DAY  '            TO TABLE-ELEMENT-1         
                MOVE 'ACCOUNT-NO'            TO TABLE-ELEMENT-2         
                MOVE WS-RSD-TARGET-DT        TO HOSTVAR-ELEMENT-1       
                MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-2       
                MOVE 'CSS_DELINQUENCY'       TO TABLE-2                 
                MOVE 'RESCH-DNP-SW = 0'      TO TABLE-3                 
                MOVE 'TO TURN RES DNP OFF'   TO TABLE-4                 
                PERFORM 9100-RSD-SQL-ERRLOG  THRU 9100-ERRLOG-EXIT      
      *                                                                         
              WHEN WS-RSD-WORK-DAY(BD-INDX) = WS-RSD-TARGET-DT          
                CONTINUE                                                
           END-SEARCH.                                                  
      *                                                                         
       6310-SEARCH-DATE-EXIT.                                           
           EXIT.                                                        
      *                                                                         
      ******************************************************************04220000
      *  6410-CPD68-RESULT                                             *04230000
      ******************************************************************04240000
       6410-CPD68-RESULT.                                               
      * SET CPD00068 SWITCHES THAT ARE NEEDED                                   
           MOVE 'Y' TO CALC-ARREARS-SW                                  
                       CALC-PAST-DUE-SW                                 
                       CALC-DNP-BAL-NO-LIMIT-SW.                        
           MOVE PROGRAM-NAME               TO WS-CPD00068-CALLING-PGM.  
           MOVE SPACES                     TO ABEND-FUNCTION            
                                              WS-PANEL-NUM-CPD68.       
      *                                                                         
           CALL  MCSCB068  USING CWS00068-FIELDS,                       
                                 WS-CODES-DATA-PRESENT,                 
                                 DCLCSS-ACCOUNT,                        
                                 ABEND-FILE,                            
                                 S-RETURN-CODE.                         
      *                                                                         
           MOVE S-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE     
                                              SQLCODE.                  
           IF ABEND-FUNCTION  > SPACES                                  
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '6410'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CALL'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CPD00068-CALL'          TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE 'CSS_DELINQUENCY'        TO TABLE-2                  
              MOVE 'RESCH-DNP-SW = 0'       TO TABLE-3                  
              MOVE 'TO TURN RES DNP OFF'    TO TABLE-4                  
              PERFORM 9100-RSD-SQL-ERRLOG    THRU 9100-ERRLOG-EXIT      
           END-IF.                                                      
      *                                                                         
           MOVE ZEROES                      TO WS-NEW-RESCH-DNP-AMT.    
           MOVE WS-AMT-DNP-BAL              TO WS-NEW-RESCH-DNP-AMT.    
           MOVE SPACES                      TO WS-NEW-RESCH-DNP-TYPE.   
           MOVE WS-HOLD-DNP-TYPE            TO WS-NEW-RESCH-DNP-TYPE.   
      *                                                                         
       6410-CPD68-EXIT.                                                 
           EXIT.                                                        
      *                                                                 04200000
      ***************************************************************           
      * INSERT EXCEPTIONAL CREDIT ACTION F & G ROWS IN CL TABLE WITH*           
      * EXCEPTIONAL TYPE RESCHEDULED(W)/RESCH W/RT-CK(T) ACCORDINGLY*           
      ***************************************************************           
       6510-MOVE-CRED-COLL.                                             
      *                                                                         
      ***************************************************************           
      * EXCEPTIONAL CREDIT ACTION 'F' ROW                                       
      ***************************************************************           
           IF WS-NEW-RESCH-DNP-AMT  > ZEROS                             
              MOVE 'F'                       TO CL-CODE-NOTICE-TYPE     
      ************SECOND MAIL DATE***********************************           
              IF WS-NEW-RESCH-SCND-MAIL > SPACES                        
                 MOVE ZEROS                  TO WS-NULL-RSD-MAIL        
                 MOVE WS-NEW-RESCH-SCND-MAIL TO CL-DATE-NOTICE-MAIL     
              ELSE                                                      
                 MOVE -1                     TO WS-NULL-RSD-MAIL        
              END-IF                                                    
      ************SECOND DUE DATE************************************           
              IF WS-NEW-RESCH-SCND-DUE  > SPACES                        
                 MOVE ZEROS                 TO WS-NULL-RSD-DUE          
                 MOVE WS-NEW-RESCH-SCND-DUE TO CL-DATE-NOTICE-DUE       
              ELSE                                                      
                 MOVE -1                    TO WS-NULL-RSD-DUE          
              END-IF                                                    
      ************IVR DATE ******************************************           
              IF AT-ACCOUNT-TYPE-CODE = 'R' AND                         
                 WS-NEW-RESCH-IVR-DT  > SPACES                          
                 MOVE ZEROS                 TO WS-NULL-RSD-CREDACT      
                 MOVE WS-NEW-RESCH-IVR-DT   TO CL-DATE-CREDIT-ACTION    
              ELSE                                                      
                 MOVE -1                    TO WS-NULL-RSD-CREDACT      
              END-IF                                                    
      ************DNP AMOUNT*****************************************           
              MOVE WS-NEW-RESCH-DNP-AMT     TO CL-AMT-NOTICE            
              MOVE SPACES                   TO CL-CODE-FRCST-CR-GRP     
              MOVE ZEROS                    TO CL-ITEM-ID               
              MOVE ZEROS                    TO CL-CODE-MESSAGE-TYPE     
              MOVE AT-DATE-BILL-DAY-00      TO CL-DATE-BILL             
              MOVE WS-NEW-RESCH-DNP-TYPE    TO CL-CODE-SPECIAL-TYPE     
              PERFORM 8310-INSERT-CRED-COLL THRU 8310-INSERT-EXIT       
           END-IF                                                       
      *                                                                         
      ***************************************************************           
      * EXCEPTIONAL CREDIT ACTION 'G' ROW                                       
      ***************************************************************           
           IF WS-NEW-RESCH-DNP-AMT > ZEROS                              
              MOVE 'G'                         TO CL-CODE-NOTICE-TYPE   
              MOVE -1                          TO WS-NULL-RSD-MAIL      
              MOVE -1                          TO WS-NULL-RSD-DUE       
      ************DNP DATE ******************************************           
              IF WS-NEW-RESCH-DNP-DT > SPACES                           
                 MOVE 0                        TO WS-NULL-RSD-CREDACT   
                 MOVE WS-NEW-RESCH-DNP-DT      TO CL-DATE-CREDIT-ACTION 
              ELSE                                                      
                 MOVE -1                       TO WS-NULL-RSD-CREDACT   
              END-IF                                                    
              MOVE WS-NEW-RESCH-DNP-AMT        TO CL-AMT-NOTICE         
              MOVE SPACES                      TO CL-CODE-FRCST-CR-GRP  
              MOVE ZEROS                       TO CL-ITEM-ID            
              MOVE ZEROS                       TO CL-CODE-MESSAGE-TYPE  
              MOVE AT-DATE-BILL-DAY-00         TO CL-DATE-BILL          
              MOVE WS-NEW-RESCH-DNP-TYPE       TO CL-CODE-SPECIAL-TYPE  
              PERFORM 8310-INSERT-CRED-COLL    THRU 8310-INSERT-EXIT    
           END-IF.                                                      
      *                                                                         
       6510-MOVE-EXIT.                                                  
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   6515-JRNL-TRAN-HEAD.                                         *        
      *   MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER.           *        
      *   THE FIRST TIME THE TRANSACTION DETAILS ROW IS WRITTEN        *        
      ******************************************************************        
       6515-JRNL-TRAN-HEAD.                                             
      *                                                                         
           MOVE WS-CURR-DT               TO MH-DATE-TRANS               
           MOVE WS-CURR-TS               TO MH-TRANS-HIST-SEQ-NO        
           MOVE 'SYSTEM'                 TO WS-RSD-USER-ID              
           PERFORM 7510-RSD-SELECT-RESP-AREA  THRU 7510-RESP-EXIT       
           MOVE 1                        TO WS-RSD-TRAN-APPL-NO         
                                            MI-TRAN-APPL-NO             
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE           
           MOVE WS-RESP-AREA-CODE        TO MH-RESP-AREA-ID             
           MOVE AT-ACCOUNT-NO            TO MH-ACCOUNT-NO               
           MOVE AT-CUSTOMER-NO           TO MH-CUSTOMER-NO              
           MOVE AT-PREMISE-NO            TO MH-PREMISE-NO               
           MOVE WS-RSD-USER-ID           TO MH-USER-ID                  
           MOVE PROGRAM-NAME             TO MH-APPL-PROGRAM-ID          
      *                                                                         
TASK01     MOVE WS-TRAN-COMMENT1         TO WS-RSD-TRAN-COMMENT1        
TASK01*                                                                         
TASK01     EVALUATE PARM-CANCEL-REASON                                  
TASK01        WHEN '2'                                                  
TASK01           MOVE 'WEATHER'          TO WS-RSD-CANCEL-RSN           
TASK01        WHEN '4'                                                  
TASK01           MOVE 'WORKLOAD'         TO WS-RSD-CANCEL-RSN           
TASK01        WHEN 'G'                                                  
TASK01           MOVE 'EXPIRED'          TO WS-RSD-CANCEL-RSN           
TASK01        WHEN OTHER                                                
TASK01           MOVE SPACES             TO WS-RSD-CANCEL-RSN           
TASK01     END-EVALUATE                                                 
TASK01*                                                                         
TASK01     MOVE WS-TRAN-COMMENT2         TO WS-RSD-TRAN-COMMENT2        
TASK01*                                                                         
TASK01     IF AT-ACCOUNT-TYPE-CODE = 'R'                                
TASK01        MOVE WS-TRAN-RES-COMMENT   TO WS-RSD-TRAN-COMMENT3        
TASK01     ELSE                                                         
TASK01        MOVE WS-TRAN-COM-COMMENT   TO WS-RSD-TRAN-COMMENT3        
TASK01     END-IF                                                       
TASK01*                                                                         
TASK01     MOVE +90                      TO MH-TRAN-COMMENT-LEN         
           MOVE WS-RSD-TRAN-COMMENT      TO MH-TRAN-COMMENT-TEXT.       
      *                                                                         
       6515-HEAD-EXIT.                                                  
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 6520-JRNL-UPDATE                                            *           
      ***************************************************************           
       6520-JRNL-UPDATE.                                                
      *                                                                         
           MOVE '6520' TO ACTIVE-PARAGRAPH                              
           IF WS-NEW-RESCH-DNP-AMT > ZEROES                             
              PERFORM 6522-JRNL-DNP-AMOUNT      THRU 6522-AMT-EXIT      
           END-IF                                                       
           IF WS-NEW-RESCH-SCND-MAIL > SPACES                           
              PERFORM 6523-JRNL-DATE-SCND-MAIL  THRU 6523-MAIL-EXIT     
           END-IF                                                       
           IF WS-NEW-RESCH-IVR-DT > SPACES                              
              PERFORM 6524-JRNL-IVR-DATE        THRU 6524-IVR-EXIT      
           END-IF                                                       
           IF WS-NEW-RESCH-SCND-DUE  > SPACES                           
              PERFORM 6525-JRNL-DATE-SCND-DUE   THRU 6525-DUE-EXIT      
           END-IF                                                       
           IF WS-NEW-RESCH-DNP-DT > SPACES                              
              PERFORM 6526-JRNL-NEXT-DNP-DATE   THRU 6526-DNP-EXIT      
           END-IF.                                                      
      *                                                                         
       6520-JRNL-EXIT.                                                  
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 6522-JRNL-DNP-AMOUNT                                         *          
      ****************************************************************          
       6522-JRNL-DNP-AMOUNT.                                            
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO        
           MOVE WS-RSD-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
           MOVE +12                      TO MI-CHG-COLUMN-VALUE-LEN     
           MOVE WS-NEW-RESCH-DNP-AMT     TO WS-COMPT-2-CHAR-CONV        
           MOVE WS-COMPT-2-CHAR-CONV     TO MI-CHG-COLUMN-VALUE-TEXT    
           MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN     
           MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT    
           MOVE 'DNP AMOUNT'             TO MI-COLUMN-DESC              
           PERFORM 6610-LOAD-RSD-TRANS-HIST  THRU 6610-RSD-MNT-EXIT     
           ADD 1                         TO WS-RSD-TRAN-APPL-NO.        
      *                                                                         
       6522-AMT-EXIT.                                                   
           EXIT.                                                        
      ****************************************************************          
      * 6523-JRNL-DATE-SCND-MAIL                                     *          
      ****************************************************************          
       6523-JRNL-DATE-SCND-MAIL.                                        
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO        
           MOVE WS-RSD-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
           MOVE SPACES                   TO WS-RSD-DT-HOLD              
           MOVE WS-NEW-RESCH-SCND-MAIL   TO WS-RSD-DT-HOLD              
           PERFORM 7610-RSD-GET-USA-DT   THRU 7610-USA-DT-EXIT          
           MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN     
           MOVE WS-RSD-DT-HOLD-USA       TO MI-CHG-COLUMN-VALUE-TEXT    
           MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN     
           MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT    
           MOVE 'DATE SCND MAIL'         TO MI-COLUMN-DESC              
           PERFORM 6610-LOAD-RSD-TRANS-HIST  THRU 6610-RSD-MNT-EXIT     
           ADD 1                         TO WS-RSD-TRAN-APPL-NO.        
      *                                                                         
       6523-MAIL-EXIT.                                                  
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 6524-JRNL-IVR-DATE                                           *          
      ****************************************************************          
       6524-JRNL-IVR-DATE.                                              
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO        
           MOVE WS-RSD-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
           MOVE SPACES                   TO WS-RSD-DT-HOLD              
           MOVE WS-NEW-RESCH-IVR-DT      TO WS-RSD-DT-HOLD              
           PERFORM 7610-RSD-GET-USA-DT   THRU 7610-USA-DT-EXIT          
           MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN     
           MOVE WS-RSD-DT-HOLD-USA       TO MI-CHG-COLUMN-VALUE-TEXT    
           MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN     
           MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT    
           MOVE 'IVR DATE'               TO MI-COLUMN-DESC              
           PERFORM 6610-LOAD-RSD-TRANS-HIST  THRU 6610-RSD-MNT-EXIT     
           ADD 1                         TO WS-RSD-TRAN-APPL-NO.        
      *                                                                         
       6524-IVR-EXIT.                                                   
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 6525-JRNL-DATE-SCND-DUE                                      *          
      ****************************************************************          
       6525-JRNL-DATE-SCND-DUE.                                         
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO        
           MOVE WS-RSD-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
           MOVE SPACES                   TO WS-RSD-DT-HOLD              
           MOVE WS-NEW-RESCH-SCND-DUE    TO WS-RSD-DT-HOLD              
           PERFORM 7610-RSD-GET-USA-DT   THRU 7610-USA-DT-EXIT          
           MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN     
           MOVE WS-RSD-DT-HOLD-USA       TO MI-CHG-COLUMN-VALUE-TEXT    
           MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN     
           MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT    
           MOVE 'DATE SCND DUE'          TO MI-COLUMN-DESC              
           PERFORM 6610-LOAD-RSD-TRANS-HIST  THRU 6610-RSD-MNT-EXIT     
           ADD 1                         TO WS-RSD-TRAN-APPL-NO.        
      *                                                                         
       6525-DUE-EXIT.                                                   
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 6526-JRNL-NEXT-DNP-DATE                                      *          
      ****************************************************************          
       6526-JRNL-NEXT-DNP-DATE.                                         
      *                                                              *          
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO        
           MOVE WS-RSD-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
           MOVE SPACES                   TO WS-RSD-DT-HOLD              
           MOVE WS-NEW-RESCH-DNP-DT      TO WS-RSD-DT-HOLD              
           PERFORM 7610-RSD-GET-USA-DT   THRU 7610-USA-DT-EXIT          
           MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN     
           MOVE WS-RSD-DT-HOLD-USA       TO MI-CHG-COLUMN-VALUE-TEXT    
           MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN     
           MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT    
           MOVE 'NEXT DNP DATE'          TO MI-COLUMN-DESC              
           PERFORM 6610-LOAD-RSD-TRANS-HIST THRU 6610-RSD-MNT-EXIT      
           ADD 1                         TO WS-RSD-TRAN-APPL-NO.        
      *                                                                         
       6526-DNP-EXIT.                                                   
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 6610-LOAD-RSD-TRANS-HIST                                     *          
      ****************************************************************          
      *                                                                         
       6610-LOAD-RSD-TRANS-HIST.                                        
      *                                                                         
           MOVE '6610' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           IF MI-TRAN-APPL-NO EQUAL 1                                   
             PERFORM 8410-INS-RSD-MNT-TRANS-HIST THRU 8410-MNT-EXIT     
             PERFORM 8510-INS-RSD-MT-TRN-HST-DET THRU 8510-MT-DET-EXIT  
           ELSE                                                         
             PERFORM 8510-INS-RSD-MT-TRN-HST-DET THRU 8510-MT-DET-EXIT
           END-IF. 
      *                                                                         
       6610-RSD-MNT-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************04480000
      * 7110-OPEN-RSD-DW.                                              *04490000
      ******************************************************************        
       7110-OPEN-RSD-DW.                                                
      *                                                                         
           MOVE '7110'                   TO ACTIVE-PARAGRAPH.           
      *                                                                         
           EXEC SQL DECLARE DELINQY_RSD_CSR CURSOR FOR                  
                SELECT DELINQ_CD                                        
                      ,DELINQ_VALUE                                     
                FROM  CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
                WHERE DELINQ_CD    IN ('DAY-DUE             ' ,         
                                       'DAY-RESCH-SECND-MAIL' ,         
                                       'DAY-DPP-SECOND-MAIL ' ,         
                                       'DAY-BSECIVREXC      ' ,         
                                       'DAY-RESCH-DNP       ' ,         
                                       'RESCH-DNP-SW        ' )         
                AND COMPANY_NO = :C8-COMPANY-NO                         
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE DELINQY_RSD_CSR CURSOR FOR                          
MFA-TR*         SELECT DELINQ_CD                                                
MFA-TR*               ,DELINQ_VALUE                                             
MFA-TR*         FROM  CSS_DELINQUENCY                                           
MFA-TR*         WHERE DELINQ_CD    IN ('DAY-DUE             ' ,                 
MFA-TR*                                'DAY-RESCH-SECND-MAIL' ,                 
MFA-TR*                                'DAY-DPP-SECOND-MAIL ' ,                 
MFA-TR*                                'DAY-BSECIVREXC      ' ,                 
MFA-TR*                                'DAY-RESCH-DNP       ' ,                 
MFA-TR*                                'RESCH-DNP-SW        ' )                 
MFA-TR*         AND COMPANY_NO = :C8-COMPANY-NO                                 
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
                OPEN DELINQY_RSD_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_DELINQUENCY'    TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE C8-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
              PERFORM 9100-RSD-SQL-ERRLOG    THRU 9100-ERRLOG-EXIT      
           END-IF.                                                      
      *                                                                         
       7110-OPEN-RSD-DW-EXIT.                                           
           EXIT.                                                        
      *                                                                         
      ******************************************************************04480000
      * 7120-FETCH-RSD-DW.                                             *04490000
      *      FETCHES THE DELINQUENCY FIELDS.                           *        
      ******************************************************************        
       7120-FETCH-RSD-DW.                                               
      *                                                                         
           MOVE '7120'                   TO ACTIVE-PARAGRAPH.           
      *                                                                         
           EXEC SQL                                                     
              FETCH DELINQY_RSD_CSR                                     
              INTO  :C8-DELINQ-CD                                       
                   ,:C8-DELINQ-VALUE                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DELINQUENCY'     TO TABLE-1                     
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
              MOVE C8-COMPANY-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9100-RSD-SQL-ERRLOG    THRU 9100-ERRLOG-EXIT      
           END-IF.                                                      
      *                                                                         
       7120-FETCH-RSD-DW-EXIT.                                          
           EXIT.                                                        
      *                                                                         
      ******************************************************************04480000
      * 7130-CLOSE-RSD-DW.                                             *04490000
      *      CLOSES CURSOR                                            *         
      ******************************************************************        
       7130-CLOSE-RSD-DW.                                               
      *                                                                         
           MOVE '7130'                   TO ACTIVE-PARAGRAPH.           
      *                                                                         
           EXEC SQL                                                     
                CLOSE DELINQY_RSD_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DELINQUENCY'     TO TABLE-1                     
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
              MOVE C8-COMPANY-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9100-RSD-SQL-ERRLOG    THRU 9100-ERRLOG-EXIT      
           END-IF.                                                      
      *                                                                         
       7130-CLOSE-RSD-DW-EXIT.                                          
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 7140-GET-CURR-DT.                                          **          
      ****************************************************************          
       7140-GET-CURR-DT.                                                
      *                                                                         
           MOVE '7140'                   TO ACTIVE-PARAGRAPH.           
      *                                                                         
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURR-TS,
              :WS-CURR-DT                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURR-TS = CURRENT TIMESTAMP,                              
MFA-TR*           :WS-CURR-DT = CURRENT DATE                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE SPACES                   TO TABLE-1                  
              MOVE 'CURRENT DATE'           TO TABLE-ELEMENT-1          
              MOVE WS-CURR-DT               TO HOSTVAR-ELEMENT-1        
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2        
              MOVE 'CSS_DELINQUENCY'        TO TABLE-2                  
              MOVE 'RESCH-DNP-SW = 0'       TO TABLE-3                  
              MOVE 'TO TURN RES DNP OFF'    TO TABLE-4                  
              PERFORM 9100-RSD-SQL-ERRLOG   THRU 9100-ERRLOG-EXIT       
           END-IF.                                                      
      *                                                                         
       7140-CURR-DT-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   7210-CHECK-EXCEP-CRED-ACT                                   *         
      *****************************************************************         
       7210-CHECK-EXCEP-CRED-ACT.                                       
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                INTO  :WS-EXCEP-CRD-ACT-EXIST                           
                FROM  CSS_CRED_COLL WITH(READUNCOMMITTED)                       
                WHERE ACCOUNT_NO       = :CL-ACCOUNT-NO                 
                  AND CODE_NOTICE_TYPE IN ('E','F','G','I','O')         
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*         INTO  :WS-EXCEP-CRD-ACT-EXIST                                   
MFA-TR*         FROM  CSS_CRED_COLL                                             
MFA-TR*         WHERE ACCOUNT_NO       = :CL-ACCOUNT-NO                         
MFA-TR*           AND CODE_NOTICE_TYPE IN ('E','F','G','I','O')                 
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7210                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7210'                   TO ACTIVE-PARAGRAPH        
               MOVE 'SELECT'                 TO ABEND-FUNCTION          
               MOVE 'CSS_CRED_COLL'          TO TABLE-1                 
               MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
               MOVE CL-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
               PERFORM 9100-RSD-SQL-ERRLOG   THRU 9100-ERRLOG-EXIT      
           END-IF.                                                      
      *                                                                         
       7210-EXCEP-EXIT.                                                 
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7310-SEL-RSD-MIN-DT-EXT                                        *        
      ******************************************************************        
       7310-SEL-RSD-MIN-DT-EXT.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                     COALESCE(MIN(BN.DATE_EXTRACT),
              IIF(TRY_CONVERT(DATE, '0001-01-01'
              ) IS NULL OR (PATINDEX('%.%', '0001-01-01'
              ) <> 0) OR (LEN('0001-01-01') <> 10), CIS.CHAR2DATE(
              '0001-01-01'), CONVERT(DATE, '0001-01-01') ))          
                INTO                                                    
                     :WS-RSD-MIN-DT-EXTRT                               
                FROM                                                    
                     CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                   
               WHERE                                                    
                     BN.REVENUE_MONTH   = :BN-REVENUE-MONTH             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              IFNULL(MIN(BN.DATE_EXTRACT),'0001-01-01')                  
MFA-TR*         INTO                                                            
MFA-TR*              :WS-RSD-MIN-DT-EXTRT                                       
MFA-TR*         FROM                                                            
MFA-TR*              CSS_BILL_WINDOW BN                                         
MFA-TR*        WHERE                                                            
MFA-TR*              BN.REVENUE_MONTH   = :BN-REVENUE-MONTH                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7310                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND               
              WS-RSD-MIN-DT-EXTRT NOT = '0001-01-01'                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7310'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_BILL_WINDOW'        TO TABLE-1                  
              MOVE 'REVENUE_MONTH'          TO TABLE-ELEMENT-1          
              MOVE  BN-REVENUE-MONTH        TO HOSTVAR-ELEMENT-1        
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2        
              MOVE 'CSS_DELINQUENCY'        TO TABLE-2                  
              MOVE 'RESCH-DNP-SW = 0'       TO TABLE-3                  
              MOVE 'TO TURN RES DNP OFF'    TO TABLE-4                  
              PERFORM 9100-RSD-SQL-ERRLOG   THRU 9100-ERRLOG-EXIT       
           END-IF.                                                      
      *                                                                         
       7310-RSD-MIN-DT-EXIT.                                            
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7410-GET-NEXT-WORK-DY.                                        *         
      *****************************************************************         
      *                                                                         
       7410-GET-NEXT-WORK-DY.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                     DATEADD( DAY, :WS-ADJ-DY, IIF(TRY_CONVERT(DATE, 
                                                   :WS-RSD-MIN-DT-EXTRT
              ) IS NULL OR (PATINDEX('%.%', :WS-RSD-MIN-DT-EXTRT
              ) <> 0) OR (LEN(:WS-RSD-MIN-DT-EXTRT
              ) <> 10), CIS.CHAR2DATE(:WS-RSD-MIN-DT-EXTRT
              ), CONVERT(DATE, :WS-RSD-MIN-DT-EXTRT) ) )       
                INTO                                                    
                     :WS-WORK-DATE-C335                                 
                FROM                                                    
                     CIS.SYSDUMMY1 WITH(READUNCOMMITTED)                        
               WHERE                                                    
                     CIS.DAYS(DATEADD( DAY, :WS-ADJ-DY, 
              IIF(TRY_CONVERT(DATE, :WS-RSD-MIN-DT-EXTRT
              ) IS NULL OR (PATINDEX('%.%', :WS-RSD-MIN-DT-EXTRT
              ) <> 0) OR (LEN(:WS-RSD-MIN-DT-EXTRT
              ) <> 10), CIS.CHAR2DATE(:WS-RSD-MIN-DT-EXTRT
              ), CONVERT(DATE, :WS-RSD-MIN-DT-EXTRT) ) )) -                    
                        (CIS.DAYS(DATEADD( DAY, :WS-ADJ-DY, 
              IIF(TRY_CONVERT(DATE, :WS-RSD-MIN-DT-EXTRT
              ) IS NULL OR (PATINDEX('%.%', :WS-RSD-MIN-DT-EXTRT
              ) <> 0) OR (LEN(:WS-RSD-MIN-DT-EXTRT
              ) <> 10), CIS.CHAR2DATE(:WS-RSD-MIN-DT-EXTRT
              ), CONVERT(DATE, :WS-RSD-MIN-DT-EXTRT
              ) ) )) / 7 * 7) BETWEEN 1 AND 5   
                 AND NOT EXISTS                                         
                       (SELECT                                          
                            HOLIDAY_DT                                  
                        FROM                                            
                            CSS_HOLIDAY WITH(READUNCOMMITTED)                   
                        WHERE                                           
                            COMPANY_NO = '01'                           
                        AND HOLIDAY_DT = DATEADD( DAY, :WS-ADJ-DY, 
              IIF(TRY_CONVERT(DATE, :WS-RSD-MIN-DT-EXTRT
              ) IS NULL OR (PATINDEX('%.%', :WS-RSD-MIN-DT-EXTRT
              ) <> 0) OR (LEN(:WS-RSD-MIN-DT-EXTRT
              ) <> 10), CIS.CHAR2DATE(:WS-RSD-MIN-DT-EXTRT
              ), CONVERT(DATE, :WS-RSD-MIN-DT-EXTRT) ) ))          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              DATE(:WS-RSD-MIN-DT-EXTRT) + :WS-ADJ-DY DAYS               
MFA-TR*         INTO                                                            
MFA-TR*              :WS-WORK-DATE-C335                                         
MFA-TR*         FROM                                                            
MFA-TR*              SYSIBM.SYSDUMMY1                                           
MFA-TR*        WHERE                                                            
MFA-TR*              DAYS(DATE(:WS-RSD-MIN-DT-EXTRT)                            
MFA-TR*                      + :WS-ADJ-DY DAYS) -                               
MFA-TR*                 (INTEGER(DAYS(DATE(:WS-RSD-MIN-DT-EXTRT)                
MFA-TR*                  + :WS-ADJ-DY DAYS) / 7) * 7) BETWEEN 1 AND 5           
MFA-TR*          AND NOT EXISTS                                                 
MFA-TR*                (SELECT                                                  
MFA-TR*                     HOLIDAY_DT                                          
MFA-TR*                 FROM                                                    
MFA-TR*                     CSS_HOLIDAY                                         
MFA-TR*                 WHERE                                                   
MFA-TR*                     COMPANY_NO = '01'                                   
MFA-TR*                 AND HOLIDAY_DT = DATE(:WS-RSD-MIN-DT-EXTRT) +           
MFA-TR*                                       :WS-ADJ-DY DAYS)                  
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7410                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                  MOVE WS-WORK-DATE-C335    TO WS-RSD-DT-CCYY-MM-DD     
                  MOVE WS-RSD-DT-CCYY-MM-DD TO WS-RSD-WORK-DAY(BD-INDX) 
                  ADD 1                     TO WS-ADJ-DY                
                  SET BD-INDX UP BY 1                                   
              ELSE                                                      
                  ADD 1 TO WS-ADJ-DY                                    
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7410'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_HOLIDAY'            TO TABLE-1                  
              MOVE 'WS-RSD-MIN-DT-EXTRT'    TO TABLE-ELEMENT-1          
              MOVE  WS-RSD-MIN-DT-EXTRT     TO HOSTVAR-ELEMENT-1        
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2        
              MOVE 'CSS_DELINQUENCY'        TO TABLE-2                  
              MOVE 'RESCH-DNP-SW = 0'       TO TABLE-3                  
              MOVE 'TO TURN RES DNP OFF'    TO TABLE-4                  
              PERFORM 9100-RSD-SQL-ERRLOG   THRU 9100-ERRLOG-EXIT       
           END-IF.                                                      
      *                                                                         
       7410-NEXT-WK-DY-EXIT.                                            
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7510-RSD-SELECT-RESP-AREA                                     *         
      *****************************************************************         
       7510-RSD-SELECT-RESP-AREA.                                       
      *                                                                         
           MOVE '7510'               TO ACTIVE-PARAGRAPH.               
      *                                                                         
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :WS-RESP-AREA-CODE                                 
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :WS-RSD-USER-ID                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :WS-RESP-AREA-CODE                                         
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :WS-RSD-USER-ID                                  
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7510                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7510'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_USER_PROFILE'       TO TABLE-1                  
              MOVE 'USER_ID'                TO TABLE-ELEMENT-1          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-RSD-USER-ID           TO HOSTVAR-ELEMENT-1        
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2        
              MOVE 'CSS_DELINQUENCY'        TO TABLE-2                  
              MOVE 'RESCH-DNP-SW = 0'       TO TABLE-3                  
              MOVE 'TO TURN RES DNP OFF'    TO TABLE-4                  
              PERFORM 9100-RSD-SQL-ERRLOG   THRU 9100-ERRLOG-EXIT       
           END-IF.                                                      
      *                                                                         
       7510-RESP-EXIT.                                                  
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7610-RSD-GET-USA-DT                                            *        
      *     FORMATS THE DATE                                           *        
      ******************************************************************        
       7610-RSD-GET-USA-DT.                                             
      *                                                                         
           MOVE '7610'              TO ACTIVE-PARAGRAPH.                
           MOVE SPACES              TO WS-RSD-DT-HOLD-USA.              
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CIS.CHAR2$DATE(IIF(TRY_CONVERT(DATE, :WS-RSD-DT-HOLD
              ) IS NULL OR (PATINDEX('%.%', :WS-RSD-DT-HOLD
              ) <> 0) OR (LEN(:WS-RSD-DT-HOLD) <> 10), CIS.CHAR2DATE(
                                                        :WS-RSD-DT-HOLD
              ), CONVERT(DATE, :WS-RSD-DT-HOLD) ),'USA')
            INTO
              :WS-RSD-DT-HOLD-USA 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-RSD-DT-HOLD-USA = CHAR(DATE(:WS-RSD-DT-HOLD),USA)         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE 'SET'                   TO ABEND-FUNCTION            
              MOVE SPACES                  TO TABLE-1                   
              MOVE 'WS-RSD-DT-HOLD'        TO TABLE-ELEMENT-1           
              MOVE WS-RSD-DT-HOLD          TO HOSTVAR-ELEMENT-1         
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-2           
              MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-2         
              MOVE 'CSS_DELINQUENCY'       TO TABLE-2                   
              MOVE 'RESCH-DNP-SW = 0'      TO TABLE-3                   
              MOVE 'TO TURN RES DNP OFF'   TO TABLE-4                   
              PERFORM 9100-RSD-SQL-ERRLOG  THRU 9100-ERRLOG-EXIT        
           END-IF.                                                      
      *                                                                         
       7610-USA-DT-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   8110-INS-RESCH-COMM-DATA                                   *          
      ****************************************************************          
       8110-INS-RESCH-COMM-DATA.                                        
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_COMM_DATA                               
                        (COMMUNICATION_ID,                              
                         ACCOUNT_NO,                                    
                         CUSTOMER_NO,                                   
                         PREMISE_NO,                                    
                         COMPANY_NO,                                    
                         RED_FLAG_IND,                                  
                         RED_FLAG_EXPIRE_DT,                            
                         COMM_METHOD,                                   
                         COMM_DIRECTION,                                
                         COMM_TYPE_CD,                                  
                         COMM_SUBTYPE_CODE,                             
                         USER_ID_ORIG,                                  
                         CONTACT_NAME,                                  
                         PROMOTION_ID,                                  
                         PSC_COMPLIANCE_IND,                            
                         CALL_ORIGIN_ID,                                
                         CALL_END_TIME,                                 
                         NUMBER_TRANSFERS,                              
                         HOLD_TIME,                                     
                         QUEUE_TIME,                                    
                         SCREEN_POP_IND,                                
                         TOTAL_CALL_TIME,                               
                         INITIAL_COMMENT_TX,                            
                         RESPONSE_REASON_CD,                            
                         RESPONSE_TYPE_CD,                              
                         SOLICITATION_CD,                               
                         COMM_ASSOC_CD,                                 
                         COMPLAINT_FL,                                  
                         DISCOVERY_MTHD_CD,                             
                         PREV_MARKETER_CD)                              
                VALUES   (CIS.CURRENT$TIMESTAMP(),                            
                         :KO-ACCOUNT-NO,                                
                         :KO-CUSTOMER-NO,                               
                         :KO-PREMISE-NO,                                
                         :KO-COMPANY-NO,                                
                         :KO-RED-FLAG-IND,                              
                         CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                            :WS-RED-FL-NULL-IND),     
                         :KO-COMM-METHOD,                               
                         :KO-COMM-DIRECTION,                            
                         :KO-COMM-TYPE-CD,                              
                         :KO-COMM-SUBTYPE-CODE,                         
                         :KO-USER-ID-ORIG,                              
                         :KO-CONTACT-NAME,                              
                         :KO-PROMOTION-ID,                              
                         :KO-PSC-COMPLIANCE-IND,                        
                         :KO-CALL-ORIGIN-ID,                            
                         CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME 
                                            :WS-END-NULL-IND),             
                         :KO-NUMBER-TRANSFERS,                          
                         :KO-HOLD-TIME,                                 
                         :KO-QUEUE-TIME,                                
                         :KO-SCREEN-POP-IND,                            
                         :KO-TOTAL-CALL-TIME,                           
                         :KO-INITIAL-COMMENT-TX,                        
                         :KO-RESPONSE-REASON-CD,                        
                         :KO-RESPONSE-TYPE-CD,                          
                         :KO-SOLICITATION-CD,                           
                         :KO-COMM-ASSOC-CD,                             
                         :KO-COMPLAINT-FL,                              
                         :KO-DISCOVERY-MTHD-CD,                         
                         :KO-PREV-MARKETER-CD)                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_COMM_DATA                                       
MFA-TR*                 (COMMUNICATION_ID,                                      
MFA-TR*                  ACCOUNT_NO,                                            
MFA-TR*                  CUSTOMER_NO,                                           
MFA-TR*                  PREMISE_NO,                                            
MFA-TR*                  COMPANY_NO,                                            
MFA-TR*                  RED_FLAG_IND,                                          
MFA-TR*                  RED_FLAG_EXPIRE_DT,                                    
MFA-TR*                  COMM_METHOD,                                           
MFA-TR*                  COMM_DIRECTION,                                        
MFA-TR*                  COMM_TYPE_CD,                                          
MFA-TR*                  COMM_SUBTYPE_CODE,                                     
MFA-TR*                  USER_ID_ORIG,                                          
MFA-TR*                  CONTACT_NAME,                                          
MFA-TR*                  PROMOTION_ID,                                          
MFA-TR*                  PSC_COMPLIANCE_IND,                                    
MFA-TR*                  CALL_ORIGIN_ID,                                        
MFA-TR*                  CALL_END_TIME,                                         
MFA-TR*                  NUMBER_TRANSFERS,                                      
MFA-TR*                  HOLD_TIME,                                             
MFA-TR*                  QUEUE_TIME,                                            
MFA-TR*                  SCREEN_POP_IND,                                        
MFA-TR*                  TOTAL_CALL_TIME,                                       
MFA-TR*                  INITIAL_COMMENT_TX,                                    
MFA-TR*                  RESPONSE_REASON_CD,                                    
MFA-TR*                  RESPONSE_TYPE_CD,                                      
MFA-TR*                  SOLICITATION_CD,                                       
MFA-TR*                  COMM_ASSOC_CD,                                         
MFA-TR*                  COMPLAINT_FL,                                          
MFA-TR*                  DISCOVERY_MTHD_CD,                                     
MFA-TR*                  PREV_MARKETER_CD)                                      
MFA-TR*         VALUES   (CURRENT TIMESTAMP,                                    
MFA-TR*                  :KO-ACCOUNT-NO,                                        
MFA-TR*                  :KO-CUSTOMER-NO,                                       
MFA-TR*                  :KO-PREMISE-NO,                                        
MFA-TR*                  :KO-COMPANY-NO,                                        
MFA-TR*                  :KO-RED-FLAG-IND,                                      
MFA-TR*                  :KO-RED-FLAG-EXPIRE-DT:WS-RED-FL-NULL-IND,             
MFA-TR*                  :KO-COMM-METHOD,                                       
MFA-TR*                  :KO-COMM-DIRECTION,                                    
MFA-TR*                  :KO-COMM-TYPE-CD,                                      
MFA-TR*                  :KO-COMM-SUBTYPE-CODE,                                 
MFA-TR*                  :KO-USER-ID-ORIG,                                      
MFA-TR*                  :KO-CONTACT-NAME,                                      
MFA-TR*                  :KO-PROMOTION-ID,                                      
MFA-TR*                  :KO-PSC-COMPLIANCE-IND,                                
MFA-TR*                  :KO-CALL-ORIGIN-ID,                                    
MFA-TR*                  :KO-CALL-END-TIME:WS-END-NULL-IND,                     
MFA-TR*                  :KO-NUMBER-TRANSFERS,                                  
MFA-TR*                  :KO-HOLD-TIME,                                         
MFA-TR*                  :KO-QUEUE-TIME,                                        
MFA-TR*                  :KO-SCREEN-POP-IND,                                    
MFA-TR*                  :KO-TOTAL-CALL-TIME,                                   
MFA-TR*                  :KO-INITIAL-COMMENT-TX,                                
MFA-TR*                  :KO-RESPONSE-REASON-CD,                                
MFA-TR*                  :KO-RESPONSE-TYPE-CD,                                  
MFA-TR*                  :KO-SOLICITATION-CD,                                   
MFA-TR*                  :KO-COMM-ASSOC-CD,                                     
MFA-TR*                  :KO-COMPLAINT-FL,                                      
MFA-TR*                  :KO-DISCOVERY-MTHD-CD,                                 
MFA-TR*                  :KO-PREV-MARKETER-CD)                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE '8110'                TO ACTIVE-PARAGRAPH            
              MOVE 'CSS_COMM_DATA'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9100-RSD-SQL-ERRLOG    THRU 9100-ERRLOG-EXIT      
           END-IF.                                                      
      *                                                                         
       8110-COMM-EXIT.                                                  
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8210-DEL-NONUTIL-ROWS                                         *         
      *     DELETES NON-UTIL ROWS IN CSS_CRED_COLL TABLE.             *         
      *****************************************************************         
       8210-DEL-NONUTIL-ROWS.                                           
      *                                                                         
           MOVE '8210'               TO ACTIVE-PARAGRAPH.               
      *                                                                         
           EXEC SQL                                                     
              DELETE FROM CSS_CRED_COLL                                 
              WHERE  ACCOUNT_NO         = :CL-ACCOUNT-NO                
              AND    CODE_NOTICE_TYPE  IN ('T', 'U', 'X')               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CRED_COLL'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CL-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'CSS_DELINQUENCY'          TO TABLE-2                
              MOVE 'RESCH-DNP-SW = 0'         TO TABLE-3                
              MOVE 'TO TURN RES DNP OFF'      TO TABLE-4                
              PERFORM 9100-RSD-SQL-ERRLOG     THRU 9100-ERRLOG-EXIT     
           END-IF.                                                      
      *                                                                         
       8210-DELETE-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8310-INSERT-CRED-COLL                                         *         
      *     INSERTS F & G ROWS IN CSS_CRED_COLL TABLE.                *         
      *****************************************************************         
       8310-INSERT-CRED-COLL.                                           
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_CRED_COLL                                
                          ( ACCOUNT_NO,                                 
                            CODE_SPECIAL_TYPE,                          
                            DATE_NOTICE_MAIL,                           
                            CODE_FRCST_CR_GRP,                          
                            ITEM_ID,                                    
                            CODE_MESSAGE_TYPE,                          
                            DATE_CREDIT_ACTION,                         
                            DATE_NOTICE_DUE,                            
                            AMT_NOTICE,                                 
                            CODE_NOTICE_TYPE,                           
                            DATE_BILL,                                  
                            LAST_UPDATE_TS)                             
               VALUES     (:CL-ACCOUNT-NO,                              
                           :CL-CODE-SPECIAL-TYPE,                       
                           IIF(TRY_CONVERT(DATE, :CL-DATE-NOTICE-MAIL 
                                                 :WS-NULL-RSD-MAIL
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-NOTICE-MAIL 
                                                      :WS-NULL-RSD-MAIL
              ) <> 0) OR (LEN(:CL-DATE-NOTICE-MAIL :WS-NULL-RSD-MAIL
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-NOTICE-MAIL 
                                                      :WS-NULL-RSD-MAIL
              ), CONVERT(DATE, :CL-DATE-NOTICE-MAIL :WS-NULL-RSD-MAIL
              ) ),      
                           :CL-CODE-FRCST-CR-GRP,                       
                           :CL-ITEM-ID,                                 
                           :CL-CODE-MESSAGE-TYPE,                       
                           IIF(TRY_CONVERT(DATE, :CL-DATE-CREDIT-ACTION 
                                                 :WS-NULL-RSD-CREDACT
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-CREDIT-ACTION 
                                                   :WS-NULL-RSD-CREDACT
              ) <> 0) OR (LEN(:CL-DATE-CREDIT-ACTION 
                                                   :WS-NULL-RSD-CREDACT
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-CREDIT-ACTION 
                                                   :WS-NULL-RSD-CREDACT
              ), CONVERT(DATE, :CL-DATE-CREDIT-ACTION 
                                                   :WS-NULL-RSD-CREDACT
              ) ), 
                           IIF(TRY_CONVERT(DATE, :CL-DATE-NOTICE-DUE 
                                                 :WS-NULL-RSD-DUE
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-NOTICE-DUE 
                                                       :WS-NULL-RSD-DUE
              ) <> 0) OR (LEN(:CL-DATE-NOTICE-DUE :WS-NULL-RSD-DUE
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-NOTICE-DUE 
                                                       :WS-NULL-RSD-DUE
              ), CONVERT(DATE, :CL-DATE-NOTICE-DUE :WS-NULL-RSD-DUE) ),        
                           :CL-AMT-NOTICE,                              
                           :CL-CODE-NOTICE-TYPE,                        
                           IIF(TRY_CONVERT(DATE, :CL-DATE-BILL
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-BILL
              ) <> 0) OR (LEN(:CL-DATE-BILL) <> 10), CIS.CHAR2DATE(
                                                          :CL-DATE-BILL
              ), CONVERT(DATE, :CL-DATE-BILL) ),                               
                            CIS.CURRENT$TIMESTAMP())                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_CRED_COLL                                        
MFA-TR*                   ( ACCOUNT_NO,                                         
MFA-TR*                     CODE_SPECIAL_TYPE,                                  
MFA-TR*                     DATE_NOTICE_MAIL,                                   
MFA-TR*                     CODE_FRCST_CR_GRP,                                  
MFA-TR*                     ITEM_ID,                                            
MFA-TR*                     CODE_MESSAGE_TYPE,                                  
MFA-TR*                     DATE_CREDIT_ACTION,                                 
MFA-TR*                     DATE_NOTICE_DUE,                                    
MFA-TR*                     AMT_NOTICE,                                         
MFA-TR*                     CODE_NOTICE_TYPE,                                   
MFA-TR*                     DATE_BILL,                                          
MFA-TR*                     LAST_UPDATE_TS)                                     
MFA-TR*        VALUES     (:CL-ACCOUNT-NO,                                      
MFA-TR*                    :CL-CODE-SPECIAL-TYPE,                               
MFA-TR*                    :CL-DATE-NOTICE-MAIL :WS-NULL-RSD-MAIL,              
MFA-TR*                    :CL-CODE-FRCST-CR-GRP,                               
MFA-TR*                    :CL-ITEM-ID,                                         
MFA-TR*                    :CL-CODE-MESSAGE-TYPE,                               
MFA-TR*                    :CL-DATE-CREDIT-ACTION :WS-NULL-RSD-CREDACT,         
MFA-TR*                    :CL-DATE-NOTICE-DUE :WS-NULL-RSD-DUE,                
MFA-TR*                    :CL-AMT-NOTICE,                                      
MFA-TR*                    :CL-CODE-NOTICE-TYPE,                                
MFA-TR*                    :CL-DATE-BILL,                                       
MFA-TR*                     CURRENT TIMESTAMP)                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8310'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE 'CSS_CRED_COLL'         TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 'CSS_DELINQUENCY'       TO TABLE-2                  
               MOVE 'RESCH-DNP-SW = 0'      TO TABLE-3                  
               MOVE 'TO TURN RES DNP OFF'   TO TABLE-4                  
               PERFORM 9100-RSD-SQL-ERRLOG  THRU 9100-ERRLOG-EXIT       
           END-IF.                                                      
      *                                                                         
       8310-INSERT-EXIT.                                                
           EXIT.                                                        
      *                                                                         
TASK02***************************************************************           
TASK02* 8320-DEL-RETCK-DNP-ROW                                      *           
TASK02* DELETE RETURNED CHECK DNP (H) ROW.                          *           
TASK02***************************************************************           
TASK02*                                                                         
TASK02 8320-DEL-RETCK-DNP-ROW.                                          
TASK02*                                                                         
TASK02     MOVE '8320' TO ACTIVE-PARAGRAPH.                             
TASK02*                                                                         
TASK02     EXEC SQL                                                     
TASK02        DELETE FROM CSS_CRED_COLL                                 
TASK02          WHERE ACCOUNT_NO          = :CL-ACCOUNT-NO              
TASK02          AND   CODE_NOTICE_TYPE    = 'H'                         
TASK02     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TASK02*                                                                         
TASK02     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
TASK02*                                                                         
TASK02     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
TASK02        NEXT SENTENCE                                             
TASK02     ELSE                                                         
TASK02        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
TASK02        MOVE 'DELETE'                   TO ABEND-FUNCTION         
TASK02        MOVE 'CSS_CRED_COLL'            TO TABLE-1                
TASK02        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
TASK02        MOVE 'CODE_NOTICE_TYPE'         TO TABLE-ELEMENT-2        
TASK02        MOVE CL-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
TASK02        MOVE 'H'                        TO HOSTVAR-ELEMENT-2      
TASK02        MOVE 'CSS_DELINQUENCY'          TO TABLE-2                
TASK02        MOVE 'RESCH-DNP-SW = 0'         TO TABLE-3                
TASK02        MOVE 'TO TURN RES DNP OFF'      TO TABLE-4                
TASK02        PERFORM 9100-RSD-SQL-ERRLOG     THRU 9100-ERRLOG-EXIT     
TASK02     END-IF.                                                      
TASK02*                                                                         
TASK02 8320-H-EXIT.                                                     
TASK02     EXIT.                                                        
TASK02*                                                                         
TASK02***************************************************************           
TASK02* 8330-UPD-RETCK-N-W-V-ROW.                                   *           
TASK02* UPDATE RETURNED CHECK NOTICE MAIL DATE WITH RESCH 2ND NOTICE*           
TASK02* MAIL DATE AND SPACES WITH DUE AND IVR NOTICE DATES(N/W/V).  *           
TASK02***************************************************************           
TASK02*                                                                         
TASK02 8330-UPD-RETCK-N-W-V-ROW.                                        
TASK02*                                                                         
TASK02     MOVE '8330'                 TO ACTIVE-PARAGRAPH.             
TASK02*                                                                         
TASK02     EXEC SQL                                                     
TASK02        UPDATE CSS_CRED_COLL                                      
TASK02          SET DATE_NOTICE_MAIL    = IIF(TRY_CONVERT(DATE, 
                                                :WS-NEW-RESCH-SCND-MAIL
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-RESCH-SCND-MAIL
              ) <> 0) OR (LEN(:WS-NEW-RESCH-SCND-MAIL
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-RESCH-SCND-MAIL
              ), CONVERT(DATE, :WS-NEW-RESCH-SCND-MAIL) )       
TASK02             ,DATE_NOTICE_DUE     = NULL                          
TASK02             ,DATE_CREDIT_ACTION  = NULL                          
TASK02          WHERE ACCOUNT_NO        = :CL-ACCOUNT-NO                
TASK02          AND ITEM_ID             = 0                             
TASK02          AND CODE_NOTICE_TYPE    IN ('W','V','N')                
TASK02     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CRED_COLL                                              
MFA-TR*         SET DATE_NOTICE_MAIL    = :WS-NEW-RESCH-SCND-MAIL               
MFA-TR*            ,DATE_NOTICE_DUE     = NULL                                  
MFA-TR*            ,DATE_CREDIT_ACTION  = NULL                                  
MFA-TR*         WHERE ACCOUNT_NO        = :CL-ACCOUNT-NO                        
MFA-TR*         AND ITEM_ID             = 0                                     
MFA-TR*         AND CODE_NOTICE_TYPE    IN ('W','V','N')                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TASK02*                                                                         
TASK02     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
TASK02*                                                                         
TASK02     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
TASK02        NEXT SENTENCE                                             
TASK02     ELSE                                                         
TASK02        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
TASK02        MOVE 'UPDATE'                TO ABEND-FUNCTION            
TASK02        MOVE 'CSS_CRED_COLL'         TO TABLE-1                   
TASK02        MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
TASK02        MOVE CL-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
TASK02        MOVE 'CSS_DELINQUENCY'       TO TABLE-2                   
TASK02        MOVE 'RESCH-DNP-SW = 0'      TO TABLE-3                   
TASK02        MOVE 'TO TURN RES DNP OFF'   TO TABLE-4                   
TASK02        PERFORM 9100-RSD-SQL-ERRLOG  THRU 9100-ERRLOG-EXIT        
TASK02     END-IF.                                                      
TASK02*                                                                         
TASK02 8330-N-EXIT.                                                     
TASK02     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 8410-INS-RSD-MNT-TRANS-HIST                                  *          
      ****************************************************************          
      *                                                                         
       8410-INS-RSD-MNT-TRANS-HIST.                                     
      *                                                                         
           MOVE '8410' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_MNT_TRANS_HIST                           
                 ( TRANS_HIST_SEQ_NO, DATE_TRANS,                       
                   CODE_TRAN_TYPE,    RESP_AREA_ID,                     
                   ACCOUNT_NO,                                          
                   CUSTOMER_NO,       PREMISE_NO,                       
                   USER_ID,           APPL_PROGRAM_ID,                  
                   TRAN_COMMENT)                                        
               VALUES                                                   
                 ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO), 
              IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),               
                   :MH-CODE-TRAN-TYPE,    :MH-RESP-AREA-ID,             
                   :MH-ACCOUNT-NO,                                      
                   :MH-CUSTOMER-NO,       :MH-PREMISE-NO,               
                   :MH-USER-ID,           :MH-APPL-PROGRAM-ID,          
                   :MH-TRAN-COMMENT)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00202600
MFA-TR*        INSERT INTO CSS_MNT_TRANS_HIST                           00202700
MFA-TR*          ( TRANS_HIST_SEQ_NO, DATE_TRANS,                       00202800
MFA-TR*            CODE_TRAN_TYPE,    RESP_AREA_ID,                     00202900
MFA-TR*            ACCOUNT_NO,                                          00203000
MFA-TR*            CUSTOMER_NO,       PREMISE_NO,                       00203300
MFA-TR*            USER_ID,           APPL_PROGRAM_ID,                  00203400
MFA-TR*            TRAN_COMMENT)                                        00204000
MFA-TR*        VALUES                                                   00290000
MFA-TR*          ( :MH-TRANS-HIST-SEQ-NO, :MH-DATE-TRANS,               00291000
MFA-TR*            :MH-CODE-TRAN-TYPE,    :MH-RESP-AREA-ID,             00293000
MFA-TR*            :MH-ACCOUNT-NO,                                      00295000
MFA-TR*            :MH-CUSTOMER-NO,       :MH-PREMISE-NO,               00297000
MFA-TR*            :MH-USER-ID,           :MH-APPL-PROGRAM-ID,          00299000
MFA-TR*            :MH-TRAN-COMMENT)                                    00299300
MFA-TR*    END-EXEC.                                                    00409000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE MH-APPL-PROGRAM-ID    TO ABEND-PROGRAM               
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE SQLERRMC              TO ABEND-SQLERRMC              
              MOVE 'CSS_MNT_TRANS_HIST'  TO TABLE-1                     
              MOVE 'ACCOUNT-NO'          TO TABLE-ELEMENT-1             
              MOVE 'CUSTOMER-NO'         TO TABLE-ELEMENT-2             
              MOVE 'PREMISE-NO'          TO TABLE-ELEMENT-3             
              MOVE 'DATE-TRANS'          TO TABLE-ELEMENT-4             
              MOVE MH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE MH-CUSTOMER-NO        TO HOSTVAR-ELEMENT-2           
              MOVE MH-PREMISE-NO         TO HOSTVAR-ELEMENT-3           
              MOVE MH-DATE-TRANS         TO HOSTVAR-ELEMENT-4           
              MOVE 'CSS_DELINQUENCY'     TO TABLE-2                     
              MOVE 'RESCH-DNP-SW = 0'    TO TABLE-3                     
              MOVE 'TO TURN RES DNP OFF' TO TABLE-4                     
              PERFORM 9100-RSD-SQL-ERRLOG    THRU 9100-ERRLOG-EXIT
           END-IF.     
      *                                                                         
       8410-MNT-EXIT.                                                   
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 8510-INS-RSD-MT-TRN-HST-DET.                                 *          
      ****************************************************************          
      *                                                                         
       8510-INS-RSD-MT-TRN-HST-DET.                                     
      *                                                                         
           MOVE '8510' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_MT_TRN_HST_DET                           
               ( TRANS_HIST_SEQ_NO, TRAN_APPL_NO,                       
                 COLUMN_DESC,       PRV_COLUMN_VALUE,                   
                 CHG_COLUMN_VALUE,                                      
                 TABLE_ID)                                              
               VALUES                                                   
               ( CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO), 
                                                      :MI-TRAN-APPL-NO,        
                 :MI-COLUMN-DESC,       :MI-PRV-COLUMN-VALUE,           
                 :MI-CHG-COLUMN-VALUE,                                  
                 :MI-TABLE-ID)                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00601200
MFA-TR*        INSERT INTO CSS_MT_TRN_HST_DET                           00601300
MFA-TR*        ( TRANS_HIST_SEQ_NO, TRAN_APPL_NO,                       00601600
MFA-TR*          COLUMN_DESC,       PRV_COLUMN_VALUE,                   00601900
MFA-TR*          CHG_COLUMN_VALUE,                                      00602200
MFA-TR*          TABLE_ID)                                              00602300
MFA-TR*        VALUES                                                   00602700
MFA-TR*        ( :MI-TRANS-HIST-SEQ-NO, :MI-TRAN-APPL-NO,               00602800
MFA-TR*          :MI-COLUMN-DESC,       :MI-PRV-COLUMN-VALUE,           00603200
MFA-TR*          :MI-CHG-COLUMN-VALUE,                                  00603500
MFA-TR*          :MI-TABLE-ID)                                          00603600
MFA-TR*    END-EXEC.                                                    00604300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE MH-APPL-PROGRAM-ID   TO ABEND-PROGRAM                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE SQLERRMC             TO ABEND-SQLERRMC               
              MOVE 'CSS_MT_TRN_HST_DET' TO TABLE-1                      
              MOVE 'TRANS-HIST-SEQ-NO'  TO TABLE-ELEMENT-1              
              MOVE 'TRAN-APPL-NO'       TO TABLE-ELEMENT-2              
              MOVE 'COLUMN-DESC'        TO TABLE-ELEMENT-3              
              MOVE 'ACCOUNT-NO'         TO TABLE-ELEMENT-4              
              MOVE MI-TRANS-HIST-SEQ-NO TO HOSTVAR-ELEMENT-1            
              MOVE MI-TRAN-APPL-NO      TO HOSTVAR-ELEMENT-2            
              MOVE MI-COLUMN-DESC       TO HOSTVAR-ELEMENT-3            
              MOVE MH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-4            
              MOVE 'CSS_DELINQUENCY'    TO TABLE-2                      
              MOVE 'RESCH-DNP-SW = 0'   TO TABLE-3                      
              MOVE 'TO TURN RES DNP OFF' TO TABLE-4                     
              PERFORM 9100-RSD-SQL-ERRLOG    THRU 9100-ERRLOG-EXIT
           END-IF.     
      *                                                                         
       8510-MT-DET-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 9100-RSD-SQL-ERRLOG                                           *         
      *  WRITE ERROR-LOG AND RETURN TO CALLING PROGRAM                *         
      *****************************************************************         
      *                                                                         
       9100-RSD-SQL-ERRLOG.                                             
      *                                                                         
           MOVE WS-ACTIVE-RETURN-CODE TO ABEND-SQLCODE.                 
           MOVE +4000                 TO WS-RETURN-CODE-C335.           

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
      *                                                                         
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           GO TO 6100-RESCH-DNPS-EXIT.                                  
      *                                                                         
       9100-ERRLOG-EXIT.                                                
           EXIT.                                                        
      *                                                                         
