      ******************************************************************        
      ******************************************************************        
      **   CPD00322                                                   **        
      ******************************************************************00000401
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                **00000501
      **                                                              **00000601
      *********           CUSTOMER SERVICE SYSTEM              *********00000701
      *********                     DB2                        *********00000801
      **                                                              **00000601
      ******************************************************************        
      **---------------P R O G R A M  S U M M A R Y-------------------**        
      *************************************************************** **        
      ******************************************************************        
      ** THIS COPYBOOK IS USED TO GET NEXT AND PREVIOUS BUSINESS DAY. **        
      ** THE COPYBOOK CWS00322 IS NECESSARY FOR THIS TO WORK.         **        
      **                                                              **        
      ******************************************************************        
      ** PREREQUISITES: THE WORKING STORAGE VARIABLES SHOULD BE       **        
      **                POPULATED PRIOR TO INVOKING THIS ROUTINE      **        
      ** INPUT : WS-NEW-BUSINESS-DAY                                  **        
      **         WS-NO-OF-DAY                                         **        
      **                                                              **        
      ** OUTPUT: WS-NEW-BUSINESS-DAY                                  **        
      **                                                              **        
      ******************************************************************        
      *                   PROGRAM  MODIFICATION  LOG                  **        
      *                   --------------------------                  **        
      *  DATE      INITIALS     REASON                                **        
      *  ------    --------     ------                                **        
P00599*  01/17/12  SP95538    COPYBOOK ORIGINALLY WRITTEN             **        
      *                                                               **        
P00870*  07/25/16  WR19680    ADD CODE TO GET CURRENT BUSINESS DAY    **        
      ******************************************************************        
                                                                        
      ******************************************************************        
      * 6500-GET-NEXT-BUSINESS-DAY                                     *        
      ******************************************************************        
      *                                                                         
       6500-GET-NEXT-BUSINESS-DAY.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT A.BUSINESS_DAY_DT                                  
                INTO :WS-NEW-BUSINESS-DAY                               
                FROM CSS_BUSINESS_DAYS A WITH(READUNCOMMITTED)                  
               WHERE A.BUS_DAY_DT_SEQ =                                 
                     (SELECT MIN(B.BUS_DAY_DT_SEQ)                      
                        FROM CSS_BUSINESS_DAYS B WITH(READUNCOMMITTED)          
                       WHERE B.BUSINESS_DAY_DT >                        
                             IIF(TRY_CONVERT(DATE, :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) )) - 1 + 
                                                          :WS-NO-OF-DAY  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT A.BUSINESS_DAY_DT                                          
MFA-TR*         INTO :WS-NEW-BUSINESS-DAY                                       
MFA-TR*         FROM CSS_BUSINESS_DAYS A                                        
MFA-TR*        WHERE A.BUS_DAY_DT_SEQ =                                         
MFA-TR*              (SELECT MIN(B.BUS_DAY_DT_SEQ)                              
MFA-TR*                 FROM CSS_BUSINESS_DAYS B                                
MFA-TR*                WHERE B.BUSINESS_DAY_DT >                                
MFA-TR*                      :WS-NEW-BUSINESS-DAY) - 1 + :WS-NO-OF-DAY          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 6500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE  1                      TO WS-NO-OF-DAY              
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE            
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE SQLCODE                 TO ABEND-SQLCODE             
              MOVE '6500'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE 'CSS_BUSINESS_DAYS'     TO TABLE-1                   
              MOVE 'BUSINESS DAY'          TO TABLE-ELEMENT-1           
              MOVE 'NO OF DAY'             TO TABLE-ELEMENT-2           
              MOVE WS-NEW-BUSINESS-DAY     TO HOSTVAR-ELEMENT-1         
              MOVE WS-NO-OF-DAY            TO HOSTVAR-ELEMENT-2         
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                         
       6500-NEXT-BUSINESS-DAY-EXIT.                                     
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6525-PREV-BUSINESS-DAY                                         *        
      ******************************************************************        
      *                                                                         
       6525-PREV-BUSINESS-DAY.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT A.BUSINESS_DAY_DT                                  
                INTO :WS-NEW-BUSINESS-DAY                               
                FROM CSS_BUSINESS_DAYS A WITH(READUNCOMMITTED)                  
               WHERE A.BUS_DAY_DT_SEQ =                                 
                     (SELECT MAX(B.BUS_DAY_DT_SEQ)                      
                        FROM CSS_BUSINESS_DAYS B WITH(READUNCOMMITTED)          
                       WHERE B.BUSINESS_DAY_DT <                        
                             IIF(TRY_CONVERT(DATE, :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) )) + 1 - 
                                                          :WS-NO-OF-DAY  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT A.BUSINESS_DAY_DT                                          
MFA-TR*         INTO :WS-NEW-BUSINESS-DAY                                       
MFA-TR*         FROM CSS_BUSINESS_DAYS A                                        
MFA-TR*        WHERE A.BUS_DAY_DT_SEQ =                                         
MFA-TR*              (SELECT MAX(B.BUS_DAY_DT_SEQ)                              
MFA-TR*                 FROM CSS_BUSINESS_DAYS B                                
MFA-TR*                WHERE B.BUSINESS_DAY_DT <                                
MFA-TR*                      :WS-NEW-BUSINESS-DAY) + 1 - :WS-NO-OF-DAY          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 6525                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE  1                      TO WS-NO-OF-DAY              
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE            
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE SQLCODE                 TO ABEND-SQLCODE             
              MOVE '6525'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE 'CSS_BUSINESS_DAYS'     TO TABLE-1                   
              MOVE 'BUSINESS DAY'          TO TABLE-ELEMENT-1           
              MOVE 'NO OF DAY'             TO TABLE-ELEMENT-2           
              MOVE WS-NEW-BUSINESS-DAY     TO HOSTVAR-ELEMENT-1         
              MOVE WS-NO-OF-DAY            TO HOSTVAR-ELEMENT-2         
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                         
       6525-PREV-BUSINESS-DAY-EXIT.                                     
           EXIT.                                                        
      *                                                                         
P00870******************************************************************        
P00870* 6530-CURRENT-BUSINESS-DAY                                      *        
P00870******************************************************************        
P00870*                                                                         
P00870 6530-CURRENT-BUSINESS-DAY.                                       
P00870*                                                                         
P00870     EXEC SQL                                                     
P00870        SELECT A.BUSINESS_DAY_DT                                  
P00870          INTO :WS-NEW-BUSINESS-DAY                               
P00870          FROM CSS_BUSINESS_DAYS A WITH(READUNCOMMITTED)                  
P00870         WHERE A.BUS_DAY_DT_SEQ =                                 
P00870               (SELECT MIN(B.BUS_DAY_DT_SEQ)                      
P00870                  FROM CSS_BUSINESS_DAYS B WITH(READUNCOMMITTED)          
P00870                 WHERE B.BUSINESS_DAY_DT >= IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) )) 
P00870                                                           
P00870                                                      
P00870     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT A.BUSINESS_DAY_DT                                          
MFA-TR*         INTO :WS-NEW-BUSINESS-DAY                                       
MFA-TR*         FROM CSS_BUSINESS_DAYS A                                        
MFA-TR*        WHERE A.BUS_DAY_DT_SEQ =                                         
MFA-TR*              (SELECT MIN(B.BUS_DAY_DT_SEQ)                              
MFA-TR*                 FROM CSS_BUSINESS_DAYS B                                
MFA-TR*                WHERE B.BUSINESS_DAY_DT >= :WS-NEW-BUSINESS-DAY)         
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 6530                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00870*                                                                         
P00870     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
P00870     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00870        MOVE  1                      TO WS-NO-OF-DAY              
P00870     ELSE                                                         
P00870        MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE            
P00870        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
P00870        MOVE SQLCODE                 TO ABEND-SQLCODE             
P00870        MOVE '6530'                  TO ACTIVE-PARAGRAPH          
P00870        MOVE 'SELECT'                TO ABEND-FUNCTION            
P00870        MOVE 'CSS_BUSINESS_DAYS'     TO TABLE-1                   
P00870        MOVE 'BUSINESS DAY'          TO TABLE-ELEMENT-1           
P00870        MOVE 'NO OF DAY'             TO TABLE-ELEMENT-2           
P00870        MOVE WS-NEW-BUSINESS-DAY     TO HOSTVAR-ELEMENT-1         
P00870        MOVE WS-NO-OF-DAY            TO HOSTVAR-ELEMENT-2         
P00870        PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
P00870     END-IF.                                                      
P00870*                                                                         
P00870 6530-CURRENT-BUSINESS-DAY-EXIT.                                  
P00870     EXIT.                                                        
