P00176*****************************************************************         
      *    THIS COPYBOOK IS USED TO GET NEXT AND PREVIOUS BUSINESS   **         
      *    DAY                                                       **         
      *    THE COPYBOOK CWS00315 IS NECESSARY FOR THIS TO WORK.      **         
      *                                                              **         
      *****************************************************************         
      *         MODIFICATION HISTORY                                  *         
      *                                                               *         
      *****************************************************************         
      *                                                               *         
      *  COVANSYS  07/20/09  P00176  - ADDED PREVIOUS BUSINESS DAY    *         
      *                                CALCULATION AND PARA           *         
      *                                6550-WKND-HLDY-CHECK           *         
P00176*****************************************************************         
                                                                        
      *****************************************************************         
      *    6500-GET-NEXT-BUSINESS-DAY                                **         
      *                                                              **         
      *    FINDS THE NEXT BUSINESS DAY, SKIPPING OVER WEEKENDS       **         
      *    AND HOLIDAYS (FOUND IN CSS_HOLIDAY), AFTER THE CURRENT    **         
      *    VALUE IN WS-NEW-BUSINESS-DAY WHEN 6500 WAS CALLED.        **         
      *                                                              **         
      *****************************************************************         
       6500-GET-NEXT-BUSINESS-DAY.                                      
      *                                                                         
           EXEC SQL                                                     
T34097       SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) ) ),
              (CIS.DAYS(DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) ) )) -     
T34097                 CIS.DAYS(DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) ) ))/7*7)+1
            INTO
              :WS-NEW-BUSINESS-DAY,
              :WS-DAY-OF-WEEK 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET  :WS-NEW-BUSINESS-DAY                                          
MFA-TR*              = DATE(:WS-NEW-BUSINESS-DAY) + 1 DAYS                      
MFA-TR*          ,:WS-DAY-OF-WEEK                                               
MFA-TR*              = (DAYS(DATE(:WS-NEW-BUSINESS-DAY) + 1 DAYS) -             
MFA-TR*                DAYS(DATE(:WS-NEW-BUSINESS-DAY) + 1 DAYS)/7*7)+1         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE NOT EQUAL SUCCESSFUL-CALL                         
               DISPLAY '***********************************'            
               DISPLAY '**   ' WS-PGRMNAME ' PROCESSING ERROR   **'     
               DISPLAY '**-------------------------------**'            
               DISPLAY '**   6500-GET-NEXT-BUSINESS-DAY:'               
               DISPLAY '**   COULD NOT FIND NEXT'                       
               DISPLAY '**   CALENDAR DAY'                              
               DISPLAY '***********************************'            
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
                                                                        
P00176     PERFORM 6550-WKND-HLDY-CHECK   THRU                          
                                              6550-WKND-HLDY-CHECK-EXIT.
                                                                        
       6500-NEXT-BUSINESS-DAY-EXIT.                                     
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *    6525-PREV-BUSINESS-DAY                                    **         
      *                                                              **         
      *    FINDS THE PREVIOUS BUSINESS DAY, SKIPPING OVER WEEKENDS   **         
      *    AND HOLIDAYS (FOUND IN CSS_HOLIDAY), FROM THE CURRENT     **         
      *    VALUE IN WS-NEW-BUSINESS-DAY WHEN 6500 WAS CALLED.        **         
      *****************************************************************         
       6525-PREV-BUSINESS-DAY.                                          
      *                                                                         
           EXEC SQL                                                     
             SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) ) ),
              (CIS.DAYS(DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) ) )) -     
                       CIS.DAYS(DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) ) ))/7*7)+1
            INTO
              :WS-NEW-BUSINESS-DAY,
              :WS-DAY-OF-WEEK 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET  :WS-NEW-BUSINESS-DAY                                          
MFA-TR*              = DATE(:WS-NEW-BUSINESS-DAY) - 1 DAYS                      
MFA-TR*          ,:WS-DAY-OF-WEEK                                               
MFA-TR*              = (DAYS(DATE(:WS-NEW-BUSINESS-DAY) - 1 DAYS) -             
MFA-TR*                DAYS(DATE(:WS-NEW-BUSINESS-DAY) - 1 DAYS)/7*7)+1         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE NOT EQUAL SUCCESSFUL-CALL                         
               DISPLAY '***********************************'            
               DISPLAY '**   ' WS-PGRMNAME ' PROCESSING ERROR   **'     
               DISPLAY '**-------------------------------**'            
               DISPLAY '**   6525-PREV-BUSINESS-DAY    :'               
               DISPLAY '**   COULD NOT FIND NEXT'                       
               DISPLAY '**   CALENDAR DAY'                              
               DISPLAY '***********************************'            
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
                                                                        
           PERFORM 6550-WKND-HLDY-CHECK   THRU                          
                                            6550-WKND-HLDY-CHECK-EXIT.  
                                                                        
       6525-PREV-BUSINESS-DAY-EXIT.                                     
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *    6550-WKND-HLDY-CHECK                                       *         
      *    CHECK TO SEE IF IT IS A WEEKEND OR HOLIDAY                 *         
      *****************************************************************         
       6550-WKND-HLDY-CHECK.                                            
P00176                                                                  
           IF WS-DAY-OF-WEEK NOT EQUAL WS-SATURDAY AND                  
              WS-DAY-OF-WEEK NOT EQUAL WS-SUNDAY                        
                                                                        
              MOVE WS-NEW-BUSINESS-DAY       TO J8-HOLIDAY-DT           
              MOVE WS-NO                     TO WS-HOLIDAY-EXISTS       
                                                                        
      ***  ...IF NOT A WEEKEND, THEN CHECK TO SEE IF IT IS A HOLIDAY            
              EXEC SQL                                                  
                  SELECT DISTINCT('Y')                                  
                  INTO   :WS-HOLIDAY-EXISTS                             
                  FROM   CSS_HOLIDAY WITH(READUNCOMMITTED)                      
                  WHERE  HOLIDAY_DT = IIF(TRY_CONVERT(DATE, 
                                                         :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                    
T34097                                                           
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*           SELECT DISTINCT('Y')                                          
MFA-TR*           INTO   :WS-HOLIDAY-EXISTS                                     
MFA-TR*           FROM   CSS_HOLIDAY                                            
MFA-TR*           WHERE  HOLIDAY_DT = :J8-HOLIDAY-DT                            
MFA-TR*           WITH UR                                                       
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
              IF SQLCODE EQUAL SUCCESSFUL-CALL                          
                  CONTINUE                                              
              ELSE                                                      
                  IF SQLCODE NOT EQUAL NOT-FOUND                        
                      DISPLAY '***********************************'     
P00176                DISPLAY '** ' WS-PGRMNAME ' PROCESSING ERROR   **'
                      DISPLAY '**-------------------------------**'     
P00176                DISPLAY '**   6550-WKND-HLDY-CHECK      :'        
                      DISPLAY '**   ERROR WHEN CHECKING TO SEE'         
                      DISPLAY '**   IF THE NEXT DAY IS A HOLIDAY'       
                      DISPLAY '***********************************'     
                      PERFORM 9900-ABEND         THRU 9900-EXIT         
                  END-IF                                                
              END-IF                                                    
                                                                        
              IF HOLIDAY-EXISTS-NO                                      
                  MOVE WS-YES                TO WS-NEXT-BUSINESS-DAY    
              ELSE                                                      
                  MOVE WS-NO                 TO WS-NEXT-BUSINESS-DAY    
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
P00176 6550-WKND-HLDY-CHECK-EXIT.                                       
P00176     EXIT.                                                        
