      *****************************************************************         
      **  CPD00314   COPYBOOK TO LOAD THE LIMITS FOR EXCEPTIONS FROM **         
      **             THE CSS_DELINQUENCY TABLE                       **         
      **.............................................................**         
      **  WS-REFERENCE:  CWS00314 (WORKING STORAGE COPYBOOK)         **         
      **                 CWS00038 (FOR READING JOB PARM TABLE)       **         
      **                 CWS00303 (DB2 SQLCODES)                     **         
      **                 CWS09900 (9900 ABEND)                                  
      **                                                             **         
      **  PROCEDURE REFERENCE: CPD00038 (FOR READING JOB PARM TABLE) **         
      **                       CPD09900 (9900-ABEND)                 **         
      **                                                             **         
      **  ADDITIONAL INFORMATION:                                    **         
      **  ALL THE HIGH LIMITS IN CWS00314 (WORKING STORAGE FOR THE   **         
      **  CPD) ARE INITIALIZED TO 99999 AND THE LOW LIMITS  TO 0.    **         
      **  THE CPD FIRST CHECKS FOR A PROGRAM OVERRIDE THRESHOLD PARM.**         
      **  IF IT DOES NOT FIND ONE IT LOOKS FOR A COMMON PARM.        **         
      **  IF IT DOES NOT FIND THAT ALSO, IT ABENDS.                  **         
      **  IF THE THRESHOLD PARM IS SET TO YES, THE CPD LOADS THE     **         
      **  LIMITS RELEVANT TO THAT PROGRAM FROM THE DELINQUENCY TABLE **         
      **  INTO THE CORRESPONDING WORKING STORAGE VARIABLE.           **         
      **  THE PROGRAMS USING THIS COPYBOOK HAVE TO COMPARE THE RELE- **         
      **  VANT WORKING STORAGE LIMITS WITH THEIR INTERNAL COUNTERS   **         
      **  NOTE : THE FOLLOWING DELINQUENCY VALUES ARE STORED IN THE  **         
      **         TABLE AS A FRACTION OF 10.                          **         
      **         'EXT-BILLING-HI',    'EXT-BILLING-LO',              **         
      **         'EXT-METER-READ-HI', 'EXT-METER-READ-LO' ,          **         
      **         'EXT-MTR-HI',        'EXT-MTR-LO',                  **         
      **         THEREFORE THEY ARE MULTIPLIED BY 10.                **         
      *****************************************************************         
T20910**  ADD A SWITCH TO BILLING TO INDICATE WHAT BILLING ENTITY WE            
T20910**  ARE BILLING FOR. SCEG = 1; SEB = 2                                    
T23513**  MOVED 'DATABASE' TO C8-DELINQ-CD TO DETERMINE WHAT DATABASE**         
T23513**  IT REFERS TO, FOR PCSCA100                                 **         
T23501**  ADDED COMPANY-NO IN CSS_DELINQUENCY TABLE FOR MULITCOMPANY **         
T23501**  CHANGES                                                    **         
T23631**  ADDED NEW PROGRAM PCSBW135 LOGIC TO LOAD DELINQUNCY VALUES **         
T23631**  FOR THE WQ-MTR-POST.                                       **         
C28373**  ADDED NEW PROGRAM PCSBW143 LOGIC TO LOAD DELINQUNCY VALUES **         
C28373**  FOR THE WQ-MTR-POST.                                       **         
      *****************************************************************         
      *                                                                         
       6500-LOAD-EXCP-LIMITS.                                           
           MOVE WS-PGRMNAME TO WS-PROGRAM                               
           PERFORM 6501-GET-THRESHOLD-PARM  THRU                        
                   6501-GET-THRESHOLD-PARM-EXIT.                        
           IF END-OF-SYSIPT                                             
              DISPLAY '** ' WS-PROGRAM ' THRESHOLD PARM NOT FOUND.'     
                      ' COMMON PARM WILL BE USED'                       
              MOVE 'COMMON'  TO WS-PROGRAM                              
              PERFORM 6501-GET-THRESHOLD-PARM  THRU                     
                      6501-GET-THRESHOLD-PARM-EXIT                      
           END-IF.                                                      
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                 DISPLAY ' '                                            
                 DISPLAY '** ' WS-PGRMNAME ' PROCESSING ERROR  **'      
                 DISPLAY '** THRESHOLD PARM NOT PRESENT'                
                 DISPLAY '** PROCESSING TERMINATED **'                  
                 PERFORM 9900-ABEND  THRU  9900-EXIT                    
              WHEN WS-INPUT-DATA-BREAKDOWN(11:1) = 'N'                  
                 DISPLAY ' '                                            
                 DISPLAY '** ' WS-PROGRAM ' THRESHOLD PARM = N'         
                 DISPLAY '** EXCEPTIONS WILL NOT BE MONITORED'          
              WHEN WS-INPUT-DATA-BREAKDOWN(11:1) = 'Y'                  
                 DISPLAY ' '                                            
                 DISPLAY '** ' WS-PROGRAM ' THRESHOLD PARM = Y'         
                 DISPLAY '** EXCEPTIONS WILL BE MONITORED'              
                 PERFORM 6510-LOAD-DELINQ-VALUES THRU                   
                         6510-LOAD-DELINQ-VALUES-EXIT                   
              WHEN OTHER                                                
                 DISPLAY ' '                                            
                 DISPLAY '** ' WS-PROGRAM  ' PROCESSING ERROR  **'      
                 DISPLAY '** INVALID THRESHOLD PARAMETER '              
                         WS-INPUT-DATA-BREAKDOWN(1:11) ' **'            
                 DISPLAY '**  PROCESSING TERMINATED  **'                
                 PERFORM 7611-CLOSE THRU 7611-EXIT                      
                 PERFORM 9900-ABEND  THRU  9900-EXIT                    
           END-EVALUATE.                                                
                                                                        
           PERFORM 7611-CLOSE THRU 7611-EXIT.                           
                                                                        
       6500-LOAD-EXCP-LIMITS-EXIT.                                      
           EXIT.                                                        
      *                                                                         
       6501-GET-THRESHOLD-PARM.                                         
           MOVE SPACES      TO WS-SYSIPT.                               
           MOVE WS-PARM     TO WS-COMMAND.                              
           MOVE ZEROS       TO WS-SEQUENCE.                             
                                                                        
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
                                                                        
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
               UNTIL (WS-INPUT-DATA-BREAKDOWN(1:10) = 'THRESHOLD='      
                      AND INPUT-ACTIVE)                                 
                  OR  END-OF-SYSIPT.                                    
                                                                        
       6501-GET-THRESHOLD-PARM-EXIT.                                    
           EXIT.                                                        
      *                                                                         
       6510-LOAD-DELINQ-VALUES.                                         
           EVALUATE WS-PGRMNAME                                         
           WHEN 'PCSCA107'                                              
              MOVE 'EXT-BILLING-HI'     TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              COMPUTE WS-RR-EXT-BILLING-HI = C8-DELINQ-VALUE * 10       
      *                                                                         
              MOVE 'EXT-BILLING-LO'     TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              COMPUTE WS-RR-EXT-BILLING-LO = C8-DELINQ-VALUE * 10       
      *                                                                         
              MOVE 'EXT-METER-READ-HI'  TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              COMPUTE WS-RR-EXT-METER-READ-HI = C8-DELINQ-VALUE * 10    
      *                                                                         
              MOVE 'EXT-METER-READ-LO'  TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              COMPUTE WS-RR-EXT-METER-READ-LO = C8-DELINQ-VALUE * 10    
      *                                                                         
           WHEN 'PCSCA109'                                              
              MOVE 'EXT-MTR-HI'         TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              COMPUTE WS-RR-EXT-MTR-HI = C8-DELINQ-VALUE * 10           
      *                                                                         
              MOVE 'EXT-MTR-LO'         TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              COMPUTE WS-RR-EXT-MTR-LO = C8-DELINQ-VALUE * 10           
      *                                                                         
           WHEN 'PCSCA132'                                              
              MOVE 'EXT-NOTICES-106'    TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-EXT-NOTICES-106             
      *                                                                         
              MOVE 'EXT-NOTICES-107'    TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-EXT-NOTICES-107             
      *                                                                         
              MOVE 'EXT-NOTICES-202'    TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-EXT-NOTICES-202             
      *                                                                         
              MOVE 'EXT-NOTICES-203'    TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-EXT-NOTICES-203             
      *                                                                         
              MOVE 'EXT-NOTICES-204'    TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-EXT-NOTICES-204             
      *                                                                         
              MOVE 'EXT-NOTICES-205'    TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-EXT-NOTICES-205             
      *                                                                         
              MOVE 'EXT-NOTICES-206'    TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-EXT-NOTICES-206             
      *                                                                         
              MOVE 'EXT-NOTICES-208'    TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-EXT-NOTICES-208             
      *                                                                         
              MOVE 'EXT-NOTICES-209'    TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-EXT-NOTICES-209             
      *                                                                         
              MOVE 'EXT-NOTICES-301'    TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-EXT-NOTICES-301             
      *                                                                         
              MOVE 'EXT-NOTICES-302'    TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-EXT-NOTICES-302             
      *                                                                         
              MOVE 'EXT-NOTICES-303'    TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-EXT-NOTICES-303             
      *                                                                         
              MOVE 'EXT-NOTICES-304'    TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-EXT-NOTICES-304             
      *                                                                         
              MOVE 'EXT-NOTICES-305'    TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-EXT-NOTICES-305             
      *                                                                         
              MOVE 'EXT-NOTICES-306'    TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-EXT-NOTICES-306             
      *                                                                         
              MOVE 'EXT-NOTICES-307'    TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-EXT-NOTICES-307             
      *                                                                         
              MOVE 'EXT-NOTICES-308'    TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-EXT-NOTICES-308             
      *                                                                         
              MOVE 'EXT-NOTICES-309'    TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-EXT-NOTICES-309             
      *                                                                         
              MOVE 'EXT-NOTICES-503'    TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-EXT-NOTICES-503             
      *                                                                         
              MOVE 'EXT-NOTICES-504'    TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-EXT-NOTICES-504             
      *                                                                         
              MOVE 'EXT-NOTICES-CHGOFF' TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-EXT-NOTICES-CHGOFF          
      *                                                                         
              MOVE 'EXT-NOTICES-DNP'    TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-EXT-NOTICES-DNP             
      *                                                                         
           WHEN 'PCSAC163'                                              
              MOVE 'WQ-BCH-CSH-FULLPOST' TO C8-DELINQ-CD                
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-WQ-BCH-CSH-FULLPOST         
      *                                                                         
              MOVE 'WQ-BCH-CSH-SLOWPOST' TO C8-DELINQ-CD                
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-WQ-BCH-CSH-SLOWPOST         
      *                                                                         
           WHEN 'PCSCA100'                                              
              MOVE 'WQ-BILLING'         TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-WQ-BILLING                  
      *                                                                         
              MOVE 'WQ-BILLING9'        TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-WQ-BILLING9                 
      *                                                                         
T23513        MOVE ZEROS                    TO WS-DATABASE              
T23513        MOVE 'DATABASE'               TO C8-DELINQ-CD             
T20910        PERFORM 6520-GET-DELINQ-VALUE THRU                        
T20910                6520-GET-DELINQ-VALUE-EXIT                        
T23513        MOVE C8-DELINQ-VALUE          TO WS-DATABASE              
      *                                                                         
           WHEN 'PCSBW125'                                              
              MOVE 'WQ-MTR-POST'        TO C8-DELINQ-CD                 
              PERFORM 6520-GET-DELINQ-VALUE THRU                        
                      6520-GET-DELINQ-VALUE-EXIT                        
              MOVE C8-DELINQ-VALUE TO WS-RR-WQ-MTR-POST                 
T23631*                                                                         
T23631     WHEN 'PCSBW135'                                              
T23631        MOVE 'WQ-MTR-POST'        TO C8-DELINQ-CD                 
T23631        PERFORM 6520-GET-DELINQ-VALUE THRU                        
T23631                6520-GET-DELINQ-VALUE-EXIT                        
T23631        MOVE C8-DELINQ-VALUE TO WS-RR-WQ-MTR-POST                 
      *                                                                         
C28373     WHEN 'PCSBW143'                                              
C28373        MOVE 'WQ-MTR-POST'        TO C8-DELINQ-CD                 
C28373        PERFORM 6520-GET-DELINQ-VALUE THRU                        
C28373                6520-GET-DELINQ-VALUE-EXIT                        
C28373        MOVE C8-DELINQ-VALUE TO WS-RR-WQ-MTR-POST                 
C28373*                                                                         
           END-EVALUATE.                                                
       6510-LOAD-DELINQ-VALUES-EXIT.                                    
           EXIT.                                                        
      *                                                                         
       6520-GET-DELINQ-VALUE.                                           
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
              INTO    :C8-DELINQ-VALUE                                  
              FROM    CSS_DELINQUENCY                                   
              WHERE   DELINQ_CD = :C8-DELINQ-CD                         
T23501        AND     COMPANY_NO = :C8-COMPANY-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '** 6520-GET-DELINQ-VALUE'                       
               DISPLAY '** ERROR ON SELECT FROM CSS_DELINQUENCY **'     
               DISPLAY '** DELINQ_CD = ' C8-DELINQ-CD ' ; SQLCODE = '   
                       SQLCODE                                          
T23501         DISPLAY '** DCOMPANY_NO= ' C8-COMPANY-NO ' ; SQLCODE = ' 
T23501                 SQLCODE                                          
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND      THRU  9900-EXIT                  
           END-IF.                                                      
                                                                        
       6520-GET-DELINQ-VALUE-EXIT.                                      
           EXIT.                                                        
