      *****************************************************************         
      ** CPD00312  COPYBOOK TO DETERMINE IF A NON UTILITY ACCOUNT    **         
      **           IS READY TO BILL.                                 **         
      **                     RELEASE 1.0                             **         
      **.............................................................**         
      **  WS-REFERENCE:  TABLES:    TBDFAACT                         **         
      **                            TBACCT                           **         
      **                            TBDEPHND                         **         
      **                            TBCNTRCT                         **         
      **                            TBARCNTL                         **         
      **                            TBPRJSHR                         **         
      **                            TBGTNTR                          **         
      **                            TBMSTSUB                         **         
      **                                                             **         
      **  PROCEDURE REFERENCE:                                       **         
      **                                                             **         
      **  PREREQUISITES: THE WORKING STORAGE VARIABLES FOR           **         
      **                 AT-ACCOUNT-NO AND WS-PROGRAM-ID MUST BE     **         
      **                 POPULATED.  CWS10016 IS THE WORKING STORAGE **         
      **                 COPYBOOK THAT IS ASSOCIATED WITH THIS CPD.  **         
      **                                                             **         
      **  ADDITIONAL INFORMATION:                                    **         
      **    THIS COPYBOOK WILL DETERMINE IF A NON-UTILITY ACCOUNT    **         
      **    IS CAPABLE OF BEING FINALED.  THERE ARE 3 EDITS THAT     **         
      **    MUST BE PASSED FOR THIS TO HAPPED.                       **         
      **    1) NO APPLICABLE RECEIVABLES ON THE ACCT(CNT,PJS,DPP     **         
      **       DFA, DEP).                                            **         
      **    1) NO PENDING OR ACTIVE GUARANTEE ACCOUNTS ASSOCIATED    **         
      **       TO THIS ACCOUNT.                                      **         
      **    1) NO PENDING OR ACTIVE SUB ACCOUNTS ASSOCIATED          **         
      **       TO THIS ACCOUNT.                                      **         
      **    IN ADDITION IF THIS CPD IS CALLED BY PCSCA107 THE        **         
      **    CODE-ACCT-STAT FIELD WILL BE UPDATED FROM 'A' TO 'B'.    **         
      **    IF THE ACCOUNT FAILS ONE OF THE FOLLOWING EDITS AN ERROR **         
      **    CODE WILL BE SENT BACK TO THE CALLING PROGRAM STATING    **         
      **    WHAT EDIT FAILED.  TO DETERMINE IF THERE IS AN ERROR     **         
      **    EVALUATE WS-NON-UTIL-ERROR.                              **         
      **                                                             **         
      *****************************************************************         
      *****************************************************************         
      *   MODIFICATION LOG -                                          *         
      *                                                               *         
      *   DATE     INITIALS        COMMENTS                           *         
      *                                                               *         
      * 07/10/97     MJG           FIRST RELEASE                      *         
T21197* 11/23/97     ZB17046       CORRECT ERROR FINALING NON-UTIL    *         
T21197*                            CORPORATE GUARANTOR.  THE WRONG    *         
T21197*                            STATUS WAS BEING USED TO DETERMINE *         
T21197*                            WHETHER OR NOT THE ACCOUNT WAS     *         
T21197*                            STILL AN ACTIVE GUARANTOR.         *         
T33182* 03/31/06     JC91900       TUNE THE SQL STATEMENTS TO IMPROVE *         
T33182*                            THE PERFORMANCE.                   *         
A01589* 01/07/11     DM94438       DONT LET MASTER FINAL BILL WITHOUT *         
A01589*                            DETACHING ALL SUBS -EVEN IF SUB IS *         
A01589*                            FINAL BILLED                       *         
      *****************************************************************         
       5500-CHECK-NON-UTIL.                                             
      *                                                                         
           MOVE '0'                TO WS-NON-UTIL-ERROR                 
                                                                        
           PERFORM 7700-DFA-NON-UTIL         THRU 7700-NON-UTIL-EXIT.   
           IF WS-COUNT-NON-UTIL > 0                                     
              MOVE '9999'         TO WS-NON-UTIL-ERROR                  
              MOVE 0              TO WS-COUNT-NON-UTIL                  
              GO TO 5500-CHECK-NON-UTIL-EXIT                            
           END-IF.                                                      
                                                                        
           PERFORM 7702-CNT-NON-UTIL         THRU 7702-NON-UTIL-EXIT.   
           IF WS-COUNT-NON-UTIL > 0                                     
              MOVE '9999'         TO WS-NON-UTIL-ERROR                  
              MOVE 0              TO WS-COUNT-NON-UTIL                  
              GO TO 5500-CHECK-NON-UTIL-EXIT                            
           END-IF.                                                      
                                                                        
           PERFORM 7703-CIA-NON-UTIL         THRU 7703-NON-UTIL-EXIT.   
           IF WS-COUNT-NON-UTIL > 0                                     
              MOVE '9999'         TO WS-NON-UTIL-ERROR                  
              MOVE 0              TO WS-COUNT-NON-UTIL                  
              GO TO 5500-CHECK-NON-UTIL-EXIT                            
           END-IF.                                                      
                                                                        
           PERFORM 7705-GUAR-NON-UTIL        THRU 7705-NON-UTIL-EXIT.   
           IF WS-COUNT-NON-UTIL > 0                                     
              MOVE '9997'         TO WS-NON-UTIL-ERROR                  
              MOVE 0              TO WS-COUNT-NON-UTIL                  
              GO TO 5500-CHECK-NON-UTIL-EXIT                            
           END-IF.                                                      
                                                                        
           PERFORM 7706-SUB-NON-UTIL         THRU 7706-NON-UTIL-EXIT.   
           IF WS-COUNT-NON-UTIL > 0                                     
              MOVE '9996'         TO WS-NON-UTIL-ERROR                  
              MOVE 0              TO WS-COUNT-NON-UTIL                  
              GO TO 5500-CHECK-NON-UTIL-EXIT                            
           END-IF.                                                      
                                                                        
           PERFORM 7701-PJS-NON-UTIL         THRU 7701-NON-UTIL-EXIT.   
           IF WS-COUNT-NON-UTIL > 0                                     
              MOVE '9995'         TO WS-NON-UTIL-ERROR                  
              MOVE 0              TO WS-COUNT-NON-UTIL                  
              GO TO 5500-CHECK-NON-UTIL-EXIT                            
           END-IF.                                                      
                                                                        
           PERFORM 7704-DEP-NON-UTIL         THRU 7704-NON-UTIL-EXIT.   
           IF WS-COUNT-NON-UTIL > 0                                     
              MOVE '9998'         TO WS-NON-UTIL-ERROR                  
              MOVE 0              TO WS-COUNT-NON-UTIL                  
              GO TO 5500-CHECK-NON-UTIL-EXIT                            
           END-IF.                                                      
                                                                        
           IF WS-NON-UTIL-PROG = 'PCSCA107'                             
              PERFORM 7707-STAT-UPD-NON-UTIL THRU 7707-NON-UTIL-EXIT    
           END-IF.                                                      
                                                                        
      *                                                                         
       5500-CHECK-NON-UTIL-EXIT.                                        
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7700- LOOK FOR ACTIVE DPP OR DFAS ON A NON-UTIL ACCOUNT.    **         
      *****************************************************************         
       7700-DFA-NON-UTIL.                                               
                                                                        
           EXEC SQL                                                     
T33182        SELECT TOP(1) 1                                                  
                INTO :WS-COUNT-NON-UTIL                                 
                FROM CSS_DFA_ACCT WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                   
                 AND CODE_DFA_STATUS = 'A'                              
T33182                                       
A01589                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 1                                                          
MFA-TR*         INTO :WS-COUNT-NON-UTIL                                         
MFA-TR*         FROM CSS_DFA_ACCT                                               
MFA-TR*        WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                           
MFA-TR*          AND CODE_DFA_STATUS = 'A'                                      
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_DFA_ACCT'           TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7700-NON-UTIL-EXIT.                                              
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7701- LOOK FOR ACTIVE PJS ON A NON-UTIL ACCOUNT.            **         
      *****************************************************************         
       7701-PJS-NON-UTIL.                                               
                                                                        
           EXEC SQL                                                     
T33182        SELECT TOP(1) 1                                                  
                INTO :WS-COUNT-NON-UTIL                                 
                FROM CSS_PROJ_SHARE WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                   
                 AND SHARE_STATUS_CD IN ('A','P')                       
T33182                                       
A01589                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 1                                                          
MFA-TR*         INTO :WS-COUNT-NON-UTIL                                         
MFA-TR*         FROM CSS_PROJ_SHARE                                             
MFA-TR*        WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                           
MFA-TR*          AND SHARE_STATUS_CD IN ('A','P')                               
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7701                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROJ_SHARE'         TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7701-NON-UTIL-EXIT.                                              
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7702- LOOK FOR ACTIVE OR PENDING CONTRACTS ON A ACCOUNT.    **         
      *****************************************************************         
       7702-CNT-NON-UTIL.                                               
                                                                        
           EXEC SQL                                                     
T33182        SELECT TOP(1) 1                                                  
                INTO :WS-COUNT-NON-UTIL                                 
                FROM CSS_CONTRACT WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                   
                 AND CNT_STATUS_CD   IN ('A','B')                       
T33182                                       
A01589                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 1                                                          
MFA-TR*         INTO :WS-COUNT-NON-UTIL                                         
MFA-TR*         FROM CSS_CONTRACT                                               
MFA-TR*        WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                           
MFA-TR*          AND CNT_STATUS_CD   IN ('A','B')                               
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7702                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CONTRACT'           TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7702-NON-UTIL-EXIT.                                              
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7703- LOOK FOR A CIA DEBIT ON THE ACCOUNT.                  **         
      *****************************************************************         
       7703-CIA-NON-UTIL.                                               
                                                                        
           EXEC SQL                                                     
T33182        SELECT TOP(1) 1                                                  
                INTO :WS-COUNT-NON-UTIL                                 
                FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = 70                             
                 AND ITEM_ID           = 3                              
T33182                                       
A01589                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 1                                                          
MFA-TR*         INTO :WS-COUNT-NON-UTIL                                         
MFA-TR*         FROM CSS_AR_CNTL                                                
MFA-TR*        WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = 70                                     
MFA-TR*          AND ITEM_ID           = 3                                      
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7703                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_CONTRACT'           TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7703-NON-UTIL-EXIT.                                              
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7704- LOOK FOR A DEPOSIT THAT IS CURRENTLY BEING BILLED.    **         
      *****************************************************************         
       7704-DEP-NON-UTIL.                                               
                                                                        
           EXEC SQL                                                     
T33182        SELECT TOP(1) 1                                                  
                INTO :WS-COUNT-NON-UTIL                                 
                FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                
                 AND DEPOSIT_STATUS_CD  = 'A'                           
T33182                                       
A01589                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 1                                                          
MFA-TR*         INTO :WS-COUNT-NON-UTIL                                         
MFA-TR*         FROM CSS_DEP_ON_HAND                                            
MFA-TR*        WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                        
MFA-TR*          AND DEPOSIT_STATUS_CD  = 'A'                                   
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7704                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_DEP_ON_HAND'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7704-NON-UTIL-EXIT.                                              
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7705- LOOK ACTIVE OR PENDING GUARANTEED ACCOUNTS.           **         
      *****************************************************************         
       7705-GUAR-NON-UTIL.                                              
                                                                        
           EXEC SQL                                                     
T33182        SELECT TOP(1) 1                                                  
                INTO :WS-COUNT-NON-UTIL                                 
                FROM CSS_GUARANTOR A WITH(READUNCOMMITTED),                     
                     CSS_ACCOUNT B WITH(READUNCOMMITTED)                        
               WHERE A.GUARNTR_ACCT_NO = :AT-ACCOUNT-NO                 
                 AND A.ACCOUNT_NO      = B.ACCOUNT_NO                   
T21197           AND A.GUAR_STATUS_CD  IN ('A','P')                     
T33182                                       
A01589                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 1                                                          
MFA-TR*         INTO :WS-COUNT-NON-UTIL                                         
MFA-TR*         FROM CSS_GUARANTOR A,                                           
MFA-TR*              CSS_ACCOUNT B                                              
MFA-TR*        WHERE A.GUARNTR_ACCT_NO = :AT-ACCOUNT-NO                         
MFA-TR*          AND A.ACCOUNT_NO      = B.ACCOUNT_NO                           
MFA-TR*          AND A.GUAR_STATUS_CD  IN ('A','P')                             
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7705                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_GUARANTOR'          TO TABLE-1                  
              MOVE 'GUARNTR_ACCT_NO'        TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7705-NON-UTIL-EXIT.                                              
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7706- LOOK ACTIVE OR PENDING SUB ACCOUNTS.                  **         
      *****************************************************************         
       7706-SUB-NON-UTIL.                                               
A01589*ADDED CODE_ACCT_STAT OF B                                                
           EXEC SQL                                                     
T33182        SELECT TOP(1) 1                                                  
                INTO :WS-COUNT-NON-UTIL                                 
                FROM CSS_MSTSUB_ACCT A WITH(READUNCOMMITTED),                   
                     CSS_ACCOUNT B WITH(READUNCOMMITTED)                        
               WHERE A.MST_ACCT_NO     = :AT-ACCOUNT-NO                 
                 AND A.SUB_ACCT_NO     = B.ACCOUNT_NO                   
A01589           AND B.CODE_ACCT_STAT  IN ('A','P','B')                 
T33182                                       
A01589                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 1                                                          
MFA-TR*         INTO :WS-COUNT-NON-UTIL                                         
MFA-TR*         FROM CSS_MSTSUB_ACCT A,                                         
MFA-TR*              CSS_ACCOUNT B                                              
MFA-TR*        WHERE A.MST_ACCT_NO     = :AT-ACCOUNT-NO                         
MFA-TR*          AND A.SUB_ACCT_NO     = B.ACCOUNT_NO                           
MFA-TR*          AND B.CODE_ACCT_STAT  IN ('A','P','B')                         
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7706                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MSTSUB_ACCT'        TO TABLE-1                  
              MOVE 'MST_ACCT_NO'            TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7706-NON-UTIL-EXIT.                                              
           EXIT.                                                        
                                                                        
      *****************************************************************         
      ** 7707- UPDATE THE CODE-ACCT-STAT TO B IF THIS IS CALLED BY   **         
      **       BY PCSCA107                                           **         
      *****************************************************************         
       7707-STAT-UPD-NON-UTIL.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET CODE_ACCT_STAT     = 'B'                           
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7707-NON-UTIL-EXIT.                                              
           EXIT.                                                        
