      ******************************************************************00000500
      **   CPD00308                                                   **00001000
      **                                                              **00001000
      **    THIS COPYBOOK WILL BE CALLED BY THE RPCS USED BY PANELS   **00001500
      **  141, 057, 245 AND 247.  THE PURPOSE OF THIS COPYBOOK IS     **00002000
      **  TO CALCULATE THE MAXIMUM DEPOSIT FOR EACH OF THESE PANELS.  **00002500
      **  THIS IS AN EXTENSION OF PCR483 AND IS BEING INITIATED VIA   **00003000
      **  TPR8452, WHICH DESCRIBES THE MAXIMUM DEPOSIT CALCULATION.   **00003500
      **                                                              **00004500
      **  THIS COPYBOOK IS ALSO USED IN BATCH (PCSCA184) TO COMPUTE   **00004500
      **   MAXIMUM DEPOSIT. IN THE CASE OF BATCH THE COMMON DATE IS   **00004500
      **   MOVED TO WS-DATE AND AT-PREMISE-NO IS MOVED TO WS-PREMISE  **00004500
      **   NO BEFORE THIS COPYBOOK IS PERFORMED                       **00004500
      **                                                              **00004500
T22668**   *** THE COMPONENT CALLING THIS COPYBOOK MUST SEND THE      **00004500
T23513**   *** WS-DATABASE    SO THAT THIS COPYBOOK WILL KNOW WHETHER **00004500
T22668**   *** TO CALCULATE MAX DEPOSIT FOR SCEG OR SEB.              **00004500
      **                                                              **00004500
      **  THE RESULTS OF THE COMPUTATION WILL BE LOCATED IN:          **00005000
      **             WS-MAX-DEPOSIT-AMT                               **00005500
      **             WS-NUMBER-OF-BILLS                               **00005500
      **                                                              **        
      **  THE INPUT REQUIRED BY THIS COPYBOOK WILL BE ACQUIRED FROM   **00007500
      **             CSS_BILLING_DET                                  **        
      **                                                              **        
      **  THIS FUNCTION REQUIRES CWS00308                             **00008000
      **                         CPD0023C/CPD0023B                    **00008000
      **                                                              **00010000
      *****************************************************************         
      **                                                             **         
      **               PROGRAM  MODIFICATION  LOG                    **         
      **                                                             **         
      **    DATE     INITIALS                 REASON                 **         
      **  ________   ________   ___________________________________  **         
      **                                                             **         
      **  01/16/97     JEP      TPR 8452 AND PCR 483.  CPD00308 IS   **         
      **                        CALLED BY S022, S304 AND S092 AND IS **         
      **                        SUBSEQUENTLY LOADED INTO ISTR_       **         
      **                        SECURITIES_SUMMARY                   **         
      **                                                             **         
      **  02/05/97     KB       THE COPYBOOK MODIFIED TO BE ABLE     **         
      **                        TO BE PERFORMED FROM BATCH PROGRAMS  **         
      **                        ALSO                                 **         
      **                                                             **         
      **  02/05/97     JPC      CORRECT SOC7 ABEND WHEN PENDING      **         
      **                        ACCOUNT SELECTED.                    **         
TP9422**  02/25/97     PD       CALCULATION OF DIFFERENCE BETWEEN    **         
TP9422**                        REVENUE MONTHS.                      **         
T10290**  04/10/97     MAD      PENDING ACCOUNTS DO NOT HAVE A BILL  **         
      **                        CYCLE ASSOCIATED WITH THEM UNTIL THEY**         
      **                        BECOME ACTIVE.  ADDED LOGIC TO       **         
      **                        RETRIEVE THE BILL CYCLE FROM THE     **         
      **                        PREVIOUS ACCOUNT IN THE EVENT OF A   **         
      **                        CUSTOMER CHANGE.                     **         
T11792**  06/24/97     MAD      COPYBOOK SHOULD EXECUTE BASED ON THE **         
      **                        LAST NORMAL BILL DATE RATHER THAN    **         
      **                        CURRENT DATE.  ONLINE AND BATCH      **         
      **                        COMPONENTS WILL UTILIZE THE SAME     **         
      **                        FUNCTIONALITY AND, THEREFORE, WILL   **         
      **                        NOT REQUIRE SEPARATE ROUTINES.       **         
T18427**  10/25/99     ZB17046  MADE CHANGE TO MAKE MINIMUM DEPOSIT  **         
T18427**                        THE SAME AS THE MAX DEPOSIT WHEN THE **         
T18427**                        MAXIMUM CALCULATED IS LESS THAN THE  **         
T18427**                        MINIMUM.                             **         
T22668**  08/18/00     SFH      SEB CREDIT PROJECT - PHASE II.       **         
T23543**  01/19/01     SFH      CHANGED THE DEPOSIT MINIMUM LIMIT    **         
      **                        $100 TO $300 FOR SEB.                **         
T23513**  01/17/01     CBSI     CHANGES MADE TO DISTINGUISH DATABASES**         
T23513*                MDS      SEB AND NON SEB TO INCORPORATE PSNC  **         
T23513*                         IN NON SEB                           **         
T23943**  04/04/01     CB18344  CHANGED THE DEPOSIT MINIMUM DEPOSIT  **         
T23943*                         $300 TO $100 FOR SEB.                **         
T23179**  05/03/01     SS82048  CHANGES FOR PSNC TO COMPUTE MAXIMUM  **         
T23179*                         DEPOSIT AMOUNT FOR SEASONAL /        **         
T23179*                         NON-SEASONAL RATES.                  **         
T24946**  09/06/01     SS82048  CHANGES FOR PSNC TO SEND NON-SEASONAL**         
T24946*                         PRESET VALUES AS MAX DEPOSIT AMOUNT  **         
T24946*                         FOR ACCOUNTS WHICH DON'T HAVE A ROW  **         
T24946*                         IN CSS-UTIL-ENVRNMT                  **         
T25272*   10/04/01     DL85939  CHANGE MADE TO HAVE CORRECT MIN. AND **         
T25272*                         MAX. DEPOSIT FOR CYCLE 99 PSNC ACCTS.**         
C25448*   12/19/01     SR82046  CHANGED TO USE REVENUE CLASS TO CALC **         
C25448*                         SEASONAL RATE FOR PSNC.              **         
T26404*   05/15/02     VD88125  CHANGED TO MODIFY MAX DEP CAL ROUTINE**         
T26404*                         TO USE CANCEL/REBILLS CROSSING MULT  **         
T26404*                         REVENUE MTHS.CHANGES MADE TO CWS00308**         
C25730*   12/10/02     MDJ      QUALIFYING WS-REMAINDER AT A HIGHER  **         
C25730*                         LEVEL DUE TO NONUNIQUE DATA-NAME.    **         
C33201*   08/31/05     SS82048  CHANGES FOR MAX DEPOSIT CALCULATION  **         
      *                         1. FOR SCEG - USE 12 MONTHS PREMISE  **         
      *                            HIST TO CALCULATE MAX DEPOSIT     **         
      *                            BASED ON ATLEAST 2 CONSECUTIVE    **         
      *                            MONTHS OF USAGE. USE DEFAULTS IF  **         
      *                            MAX DEPOSIT CANNOT BE CALCULATED. **         
      *                         2. FOR PSNC - USE AVAILABLE HIST IN  **         
      *                            THE LAST 12 MONTHS FOR NON-SEASONAL*         
      *                            AND AVAILABLE HIST IN THE 6        *         
      *                            SEASONAL MONTHS FOR SEASONAL ACCTS *         
      *                         3. FOR SEB - NO CALCULATION REQUIRED  *         
      *                            USE DEFAULT VALUES FOR ALL ACCTS   *         
      *                         4. FOR SCEG GAS ONLY ACCTS USE HISTORY*         
      *                            FROM OCTOBER THRU MARCH.           *         
F33201*   03/18/06     SS82048  MOVED MAX DEP CALC CODE FOR SEB TO    *         
      *                         ORIGINAL LOCATION TO FIX ERROR ON     *         
      *                         PANEL 141                             *         
      *                                                               *         
T34114*   04/19/2006   CVNS     (1) USE COMBO ACCOUNT RULES FOR SCE&G *         
T34114*                CHENNAI   NON-RESIDENTIAL GAS ONLY ACCOUNTS.   *         
T34114*                         (2) USE DEFAULT VALUES FOR PSNC       *         
T34114*                          ACCOUNTS WHEN CALCULATED MAX DEPOSIT *         
T34114*                          IS ZERO.                             *         
T34114*                         (3) WHEN NO UTIL-ENVRNMT FOR THE      *         
T34114*                          CURRENT ACCOUNT USE PREVIOUSLY FINAL *         
T34114*                          BILLED ACCOUNT AT THE PREMISE TO GET *         
T34114*                          THE ACCOUNT TYPE FOR SCE&G/PSNC AND  *         
T34114*                          SEASONAL OR YEAR ROUND FOR PSNC.     *         
F34114*  06/21/2006    SS82048  ADD CHECK FOR CODE-REVENUE-CLASS      *         
      *                         -2 FOR COMMERCIAL AND 3-FOR INDUSTRIAL*         
      *                         WHEN USING GAS-ONLY NON-RES. DEFAULT  *         
      *                         TO STOP PENDING ACCTS AT BRAND NEW    *         
      *                         RESIDENTIAL PREMISE TO USE THEM.      *         
T35163*  12/22/2006    COVANSYS  COMPUTING THE START AND END REVENUE  *         
T35163*                CHENNAI   MONTH FOR COMPUTING THE MAX DEPOSIT. *         
T34097*  02/01/2007    COVANSYS  REPLACE MODEL_SQL WITH SET COMMAND   *         
      *                          REPLACE CURSOR HAVING SINGLETON FETCH*         
      *                          WITH SELECT FOR FIRST ROW            *         
T35163* 07/02/2007     CVNS      ON SOME COMBO ACCOUNTS (ACCOUNTS WITH*         
      *                CHENNAI   MORE THAN 2 IC'S) THE 3RD IC BILLING *         
      *                          DETAIL IS SKIPPED IN MAX DEPOSIT CALC*         
T35163* 08/07/2007     CVNS      CHANGE CALCULATION FOR SCE&G RESIDEN-*         
      *                CHENNAI   TIL GAS ONLY TO CALCULATE USING  12  *         
      *                          MONTHS USAGE                         *         
A04243**07/09/2012     NS75440   ADDED DATE FIELD IN CWS00308 CPYBK AND*        
A04243**                         USED IT IN CPD00308 7055-SELECT-PARA.*         
ACT041**04/12/2013     DB41297   ADD FETCH FIRST ROW ONLY IN 7085A TO *         
ACT041**               APL4527   PREVENT -811.                        *         
A05073* 10/09/2014     MJ13662   INSTEAD OF LOOKING FOR ACCOUNT WITH  *         
A05073*                          SERVICE END DATE, WILL LOOK FOR      *         
A05073*                          LATEST ACCOUNT ON THE PREMISE AND    *         
A05073*                          GET THE RATE INFO BASED ON THAT ACCT.*         
A05091* 11/19/2015     RB19957 1)STANDARDIZE NAMING OF MIN/MAX        *         
A05091*         APPL00005091     DEPOSITS AND ADDED A BIGGER VARIETY  *         
A05091*                          OF MIN/MAX DEPOSITS ESPECIALLY FOR   *         
A05091*                          SEB CUSTOMERS.                       *         
A05091*                        2)CLEAN UP CODE.                       *         
A5091A* 12/01/2016     RB19957 CORRECT NULL TEST IN PARAGRAPH 7310.   *         
      ******************************************************************        
      *****************************************************************         
      *                                                                 00011000
       5650-GET-MAX-DEPOSIT.                                            
      *                                                                         
C25448     MOVE 'N' TO WS-SEASONAL-FL.                                  
C33201*                                                                         
C33201     INITIALIZE  WS-COMPANY-NO                                    
C33201                 WS-RATE-PLAN-NO                                  
C33201                 WS-SEASONAL-DEP-IND                              
C33201                 WS-SEAS-MONTH-COUNT                              
C33201                 WS-SEASONAL-HIST-FL                              
C33201                 WS-GAS-ONLY-FL                                   
C33201                 WS-DEPOSIT-AMOUNT-ARRAY-WHST                     
C33201                 WS-DEPOSIT-AMOUNT-ARRAY.                         
C33201*                                                                         
A05091     PERFORM 7060-SELECT-ACCT-INFO                                
A05091        THRU 7060-SELECT-ACCT-INFO-EXIT.                          
T34114*                                                                         
T23179     IF CSR-DATABASE THEN                                         
T23179         IF WS-COMPANY-NO = WS-PSNC                               
T23179             PERFORM 2300-GET-RATE-TYPE                           
T23179             THRU 2300-GET-RATE-TYPE-EXIT                         
C34114         ELSE                                                     
C34114             PERFORM 2370-CHECK-GAS-ONLY                          
C34114                THRU 2370-CHECK-GAS-ONLY-EXIT                     
T23179         END-IF                                                   
               PERFORM 2150-GET-LAST-BILL-DATE                          
                  THRU 2150-GET-LAST-BILL-DATE-EXIT                     
               IF WS-DATE-CWS00308 = SPACES                             
T25272             IF WS-COMPANY-NO = WS-PSNC                           
T25272                 PERFORM 2334-GET-PSNC-DEFAULT-DEPOSIT            
T25272                    THRU 2334-GET-PSNC-DEF-DEP-EXIT               
T25272             ELSE                                                 
C33201                 PERFORM 2360-GET-SCEG-DEFAULT-DEPOSIT            
C33201                    THRU 2360-GET-SCEG-DEF-DEP-EXIT               
RICK                   MOVE ZEROES TO WS-NUMBER-OF-BILLS                
C33201             END-IF                                               
A05091         ELSE                                                     
                   PERFORM 2320-DETERMINE-DEP-AMT                       
                      THRU 2320-DETERMINE-DEP-AMT-EXIT                  
               END-IF                                                   
T23179     END-IF.                                                      
      *                                                                         
A05091*USE DEFAULT VALUES FOR MIN/MAX DEPOSIT AMT FROM CSS_DELINQUENCY          
C33201*NO CALCULATION REQUIRED.                                                 
T23513     IF SEB-DATABASE                                              
C33201         PERFORM 2335-COMPUTE-MAX-DEP-SEB                         
C33201            THRU 2335-COMPUTE-MAX-DEP-SEB-EXIT                    
T22668     END-IF.                                                      
      *                                                                         
       5650-GET-MAX-DEPOSIT-EXIT.                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2150 GET LAST BILL DATE                                        *        
      *     -- THIS MODULE GETS THE LAST BILL DATE FOR USE IN SELECTING*        
      *        ONLY THE 12 MOST RECENT MONTHLY BILL AMOUNTS.           *        
      ******************************************************************        
       2150-GET-LAST-BILL-DATE.                                         
      *                                                                         
T34097     PERFORM 7025-SELECT-BILL-DATE                                
T34097        THRU 7025-SELECT-BILL-DATE-EXIT.                          
      *                                                                         
A04243     IF BATCH-IS-CALLING                                          
A04243        MOVE WS-TEMP-BATCH-DATE    TO WS-PARA-CURRENT-DATE        
A04243     ELSE                                                         
A04243        PERFORM 7140-GET-CURRENT-DATE                             
A04243           THRU 7140-GET-CURRENT-DATE-EXIT                        
A04243        MOVE WS-TEMP-ONLINE-DATE   TO WS-PARA-CURRENT-DATE        
A04243     END-IF.                                                      
           MOVE WS-DATE-CWS00308         TO WS-CURRENT-DATE-CWS308      
                                            WS-TEMP-HOLD-DATE.          
           MOVE WS-DATE-CWS00308(1:2)    TO WS-REVENUE-CENTURY.         
           MOVE WS-DATE-CWS00308(3:2)    TO WS-REVENUE-YEAR.            
           MOVE WS-DATE-CWS00308(6:2)    TO WS-REVENUE-MONTH.           
           MOVE WS-REVENUE-DATE-DEC      TO WS-CURRENT-YEAR-MO.         
           MOVE WS-DATE-CWS00308         TO WS-CURRENT-DATE-CWS308.     
                                                                        
T10290     IF AT-BILL-CYCLE = '00'                                      
T10290         PERFORM 2350-GET-OLD-BILL-CYCLE                          
T10290            THRU 2350-GET-OLD-BILL-CYCLE-EXIT                     
T10290     END-IF.                                                      
                                                                        
           PERFORM 7050-GET-REV-SRCH-DT-ALL                             
              THRU 7050-GET-REV-SRCH-DT-ALL-EXIT.                       
                                                                        
           IF WS-DATE-CWS00308 NOT = SPACES                             
              MOVE WS-DATE-CWS00308(1:2) TO WS-REVENUE-CENTURY          
              MOVE WS-DATE-CWS00308(3:2) TO WS-REVENUE-YEAR             
              MOVE WS-DATE-CWS00308(6:2) TO WS-REVENUE-MONTH            
              MOVE WS-REVENUE-DATE-DEC   TO WS-REVENUE-SEARCH-DATE      
           END-IF.                                                      
                                                                        
T35163     PERFORM 7055-GET-REV-SRCH-DT-ALL                             
T35163        THRU 7055-GET-REV-SRCH-DT-ALL-EXIT.                       
                                                                        
T35163     IF WS-SEARCH-END-DATE NOT = ZEROES                           
T35163        MOVE  AT-COMPANY-NO               TO C8-COMPANY-NO        
T35163        MOVE  WS-MAX-DEP-CAL-HIST         TO C8-DELINQ-CD         
T35163        PERFORM 7300-SELECT-DELINQ-DEPOSIT-AMT                    
T35163           THRU 7300-SELECT-DELINQ-DEP-EXIT                       
T35163        MOVE  C8-DELINQ-VALUE            TO WS-DEP-MAX-CALC-MONTHS
T35163                                                                  
T35163        MOVE WS-SEARCH-END-DATE          TO WS-SEARCH-END-DEC     
      *                                                                         
T35163        DIVIDE WS-DEP-MAX-CALC-MONTHS BY WS-TWELVEMONTH           
T35163                       GIVING     WS-SUB-YEAR                     
T35163                       REMAINDER  WS-SUB-MONTH                    
      *                                                                         
T35163        COMPUTE WS-SEARCH-START-YR =                              
T35163                                 WS-SEARCH-END-YR - WS-SUB-YEAR   
      *                                                                         
T35163        COMPUTE WS-SEARCH-START-MTH =                             
T35163                           WS-SEARCH-END-MTH - WS-SUB-MONTH       
T35163        IF WS-SEARCH-START-MTH < 0                                
T35163           SUBTRACT 1 FROM WS-SEARCH-START-YR                     
T35163           COMPUTE WS-SEARCH-START-MTH =                          
T35163                  (WS-SEARCH-END-MTH + 12) - WS-SUB-MONTH         
T35163        END-IF                                                    
      *                                                                         
T35163        MOVE WS-SEARCH-START-DEC  TO WS-SEARCH-START-REV          
T35163        MOVE WS-SEARCH-START-REV  TO WS-SEARCH-START-DATE         
T35163     END-IF.                                                      
                                                                        
       2150-GET-LAST-BILL-DATE-EXIT.                                    
           EXIT.                                                        
      *                                                                 00011500
T23179******************************************************************        
T23179* THIS IS USED TO DETERMINE IF THE RATE IS SEASONAL                       
T23179******************************************************************        
T23179 2300-GET-RATE-TYPE.                                              
T23179*                                                                 00011500
T23179     MOVE WS-ACCOUNT-NO              TO UT-ACCOUNT-NO             
T23179     PERFORM 7085-GET-RATE-PLAN-NO                                
T23179        THRU 7085-GET-RATE-PLAN-NO-EXIT                           
T24946     IF  (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL)                
T23179          MOVE WS-RATE-PLAN-NO       TO RT-RATE-PLAN-NO           
C25448          PERFORM 7085A-GET-REV-CLASS                             
C25448                                     THRU 7085A-EXIT              
T23179          PERFORM 7090-GET-SEAS-DEP-IND                           
T23179             THRU 7090-GET-SEAS-DEP-IND-EXIT                      
T24946     ELSE                                                         
T34114           MOVE WS-PREMISE-NO             TO CH-PREMISE-NO        
T34114          PERFORM 7400-PREVIOUS-ACCOUNT                           
T34114             THRU 7400-PREVIOUS-ACCOUNT-EXIT                      
T34114         IF  (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL)            
T34114           MOVE CH-ACCOUNT-NO             TO UT-ACCOUNT-NO        
T34114          PERFORM 7085-GET-RATE-PLAN-NO                           
T34114             THRU 7085-GET-RATE-PLAN-NO-EXIT                      
T34114           IF  (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL)          
T34114               MOVE WS-RATE-PLAN-NO       TO RT-RATE-PLAN-NO      
T34114             PERFORM 7085A-GET-REV-CLASS                          
T34114                                     THRU 7085A-EXIT              
T34114             PERFORM 7090-GET-SEAS-DEP-IND                        
T34114                THRU 7090-GET-SEAS-DEP-IND-EXIT                   
T34114               GO TO 2300-GET-RATE-TYPE-EXIT                      
T34114           END-IF                                                 
T34114         END-IF                                                   
T24946          PERFORM 2334-GET-PSNC-DEFAULT-DEPOSIT                   
T24946             THRU 2334-GET-PSNC-DEF-DEP-EXIT                      
T24946          GO TO 5650-GET-MAX-DEPOSIT-EXIT                         
T24946     END-IF.                                                      
T23179*                                                                 00011500
T23179 2300-GET-RATE-TYPE-EXIT.                                         
T23179     EXIT.                                                        
T23179*                                                                 00011500
      ******************************************************************        
      * 2320 DETERMINE DEPOSIT AMT                                     *        
      *    -- THIS MODULE DETERMINES THE DOLLAR VALUE OF THE MAX       *        
      *       DEPOSIT AMOUNT BASED ON VALUES PRESENT IN THE BG TABLE.  *        
      *       THE BILL AMOUNTS ARE RETRIEVED AND THE MAXIMUM TOTAL     *        
      *       BILL OF TWO CONSECUTIVE MONTHS IS DETERMINED.  THE       *        
      *       VALUES ARE FETCHED INTO AN INTERNAL TABLE AND THEN A     *        
      *       PROCEDURE IS CALLED THAT TRAVERSES THE VALUES TO         *        
      *       DETERMINE THE MAXIMUM CONSECUTIVE MONTHS.                *        
      ******************************************************************        
       2320-DETERMINE-DEP-AMT.                                          
      *                                                                         
TP8644     MOVE ZEROES TO WS-MAX-DEPOSIT-AMT                            
TP8644     MOVE ZEROES TO WS-COUNT                                      
                                                                        
           PERFORM 7000-OPEN-COMPUTEDEP-CSR                             
              THRU 7000-OPEN-COMPUTEDEP-CSR-EXIT.                       
           PERFORM 7010-FETCH-COMPUTEDEP-CSR                            
              THRU 7010-FETCH-COMPUTEDEP-CSR-EXIT                       
T26404       UNTIL WS-COUNT > 12                                        
                OR WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
      *                                                                         
           PERFORM 7020-CLOSE-COMPUTEDEP-CSR                            
              THRU 7020-CLOSE-COMPUTEDEP-CSR-EXIT.                      
      *                                                                         
T26404     IF WS-COUNT > 12                                             
T26404        MOVE 12 TO WS-COUNT                                       
T26404     END-IF.                                                      
           MOVE WS-COUNT TO WS-NUMBER-OF-BILLS.                         
      *                                                                         
C33201* CHANGE MAX DEPOSIT CALCULATION TO REVIEW JUST PREMISE HIST              
C33201* THAT ARE AVAILABLE IN THE LAST 12 MONTHS.                               
C33201* MAX DEPOSIT CALCULATION BASED ON NEW CRITERIA                           
C33201* USE AVAILABLE MONTHS IN THE LAST 12 MONTHS.                             
C33201     IF  WS-NUMBER-OF-BILLS > 1                                   
C33201         IF  CSR-DATABASE                                         
C33201             EVALUATE WS-COMPANY-NO                               
C33201                 WHEN WS-SCEG                                     
C33201                     MOVE +1 TO WS-COUNT                          
C33201                     PERFORM 2330-COMPUTE-MAX-DEP-AMT             
C33201                        THRU 2330-COMPUTE-MAX-DEP-AMT-EXIT        
C33201                       UNTIL WS-COUNT = WS-NUMBER-OF-BILLS        
C33201* USE DEFAULT VALUES IF MAX DEPOSIT COULD NOT BE CALCULATED               
C33201                       IF  WS-MAX-DEPOSIT-AMT > 0                 
C33201                           PERFORM 2340-ROUND-MAX-DEPOSIT         
C33201                              THRU 2340-ROUND-MAX-DEPOSIT-EXIT    
C33201                       ELSE                                       
C33201                           PERFORM 2360-GET-SCEG-DEFAULT-DEPOSIT  
C33201                              THRU 2360-GET-SCEG-DEF-DEP-EXIT     
C33201                           GO TO 2320-DETERMINE-DEP-AMT-EXIT      
C33201                       END-IF                                     
C33201                 WHEN WS-PSNC                                     
C33201                     IF  WS-SEASONAL-DEP-IND = 'Y' OR WS-SEASONAL 
C33201                         PERFORM 2336-CHECK-SEASONAL-HIST         
C33201                            THRU 2336-CHECK-SEASONAL-EXIT         
C33201                         IF  SEASONAL-HIST                        
C33201                             MOVE +1 TO WS-COUNT                  
C33201                             PERFORM 2333-COMP-MAX-DEP-AMT-PSNC   
C33201                              THRU 2333-COMP-MAX-DEPAMT-PSNC-EXIT 
T34114                           IF WS-MAX-DEPOSIT-AMT > 0              
T34114                                 PERFORM 2340-ROUND-MAX-DEPOSIT   
T34114                                  THRU 2340-ROUND-MAX-DEPOSIT-EXIT
T34114                           ELSE                                   
T34114                             PERFORM 2334-GET-PSNC-DEFAULT-DEPOSIT
T34114                                THRU 2334-GET-PSNC-DEF-DEP-EXIT   
T34114                           END-IF                                 
C33201                         ELSE                                     
C33201                             PERFORM 2334-GET-PSNC-DEFAULT-DEPOSIT
C33201                                THRU 2334-GET-PSNC-DEF-DEP-EXIT   
C33201                              GO TO 2320-DETERMINE-DEP-AMT-EXIT   
C33201                         END-IF                                   
C33201                     ELSE                                         
C33201                         MOVE +1 TO WS-COUNT                      
C33201                         PERFORM 2333-COMP-MAX-DEP-AMT-PSNC       
C33201                            THRU 2333-COMP-MAX-DEPAMT-PSNC-EXIT   
T34114                            IF WS-MAX-DEPOSIT-AMT > 0             
C33201                             PERFORM 2340-ROUND-MAX-DEPOSIT       
C33201                               THRU 2340-ROUND-MAX-DEPOSIT-EXIT   
T34114                            ELSE                                  
T34114                             PERFORM 2334-GET-PSNC-DEFAULT-DEPOSIT
T34114                               THRU 2334-GET-PSNC-DEF-DEP-EXIT    
T34114                            END-IF                                
C33201                     END-IF                                       
C33201             END-EVALUATE                                         
C33201         END-IF                                                   
C33201     ELSE                                                         
C33201         IF  WS-COMPANY-NO = WS-PSNC                              
C33201             PERFORM 2334-GET-PSNC-DEFAULT-DEPOSIT                
C33201                THRU 2334-GET-PSNC-DEF-DEP-EXIT                   
C33201         ELSE                                                     
C33201            IF  CSR-DATABASE AND WS-COMPANY-NO = WS-SCEG          
C33201                PERFORM 2360-GET-SCEG-DEFAULT-DEPOSIT             
C33201                   THRU 2360-GET-SCEG-DEF-DEP-EXIT                
C33201            END-IF                                                
C33201         END-IF                                                   
C33201     END-IF.                                                      
      *                                                                         
       2320-DETERMINE-DEP-AMT-EXIT.                                     
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2330 COMPUTE MAX DEPOSIT AMT                                   *        
      *    -- THIS MODULE COMPUTES THE MAX DEPOSIT AMOUNT              *        
      ******************************************************************        
       2330-COMPUTE-MAX-DEP-AMT.                                        
      *                                                                         
C33201* BEFORE ADDING AMOUNTS VERIFY THEY ARE BILLS FROM 2 CONSECUTIVE          
C33201* MONTHS                                                                  
C33201*                                                                         
C33201     SUBTRACT WS-MONTH-DEP(WS-COUNT + 1)                          
C33201         FROM WS-MONTH-DEP(WS-COUNT) GIVING WS-TOTAL.             
C33201     IF  WS-TOTAL > 11                                            
C33201         MOVE WS-MONTH-DEP(WS-COUNT) TO                           
C33201                                  WS-REVENUE-DATE-DEC             
C33201         MOVE WS-REVENUE-CENTURY TO WS-FROM-CENTURY               
C33201         MOVE WS-REVENUE-YEAR             TO WS-FROM-YEAR         
C33201         MOVE WS-REVENUE-MONTH            TO WS-FROM-MONTH        
C33201         MOVE '01'                        TO WS-FROM-DAY          
C33201         MOVE WS-MONTH-DEP(WS-COUNT + 1)           TO             
C33201                                  WS-REVENUE-DATE-DEC             
C33201         MOVE WS-REVENUE-CENTURY TO WS-TO-CENTURY                 
C33201         MOVE WS-REVENUE-YEAR             TO WS-TO-YEAR           
C33201         MOVE WS-REVENUE-MONTH            TO WS-TO-MONTH          
C33201         MOVE '01'                        TO WS-TO-DAY            
C33201         PERFORM 7070-MONTH-DIFFERENCE             THRU           
C33201                 7070-MONTH-DIFFERENCE                            
C33201         MOVE WS-NO-OF-MONTHS             TO WS-TOTAL             
C33201     END-IF.                                                      
C33201*                                                                         
C33201     IF  WS-TOTAL = 1                                             
C33201         COMPUTE WS-COMPUTE-MAX-DEPOSIT =                         
C33201                               (WS-AMOUNT-DEP(WS-COUNT) +         
C33201                                WS-AMOUNT-DEP(WS-COUNT + 1))      
C33201                                                                  
C33201         IF WS-COMPUTE-MAX-DEPOSIT > WS-MAX-DEPOSIT-AMT THEN      
C33201            MOVE WS-COMPUTE-MAX-DEPOSIT TO WS-MAX-DEPOSIT-AMT     
C33201         END-IF                                                   
C33201     END-IF.                                                      
      *                                                                         
           ADD +1 TO WS-COUNT.                                          
      *                                                                         
       2330-COMPUTE-MAX-DEP-AMT-EXIT.                                   
           EXIT.                                                        
      *                                                                         
T23179*****************************************************************         
T23179* COMPUTES MAX DEPOSIT FOR PSNC ACCOUNTS BASED ON SEASONAL      *         
T23179* OR NON-SEASONAL RATES. FOR SEASONAL RATES AMOUNTS OF REV MONTH*         
T23179* JAN, FEB, MAR, NOV AND DEC ARE ADDED AND DIVIDED BY 3         *         
T23179* FOR NON-SEASONAL RATES BILL AMOUNTS OF LAST 12 MONTHS ARE     *         
T23179* ADDED AND DIVIDED BY 6                                        *         
T23179*****************************************************************         
T23179 2333-COMP-MAX-DEP-AMT-PSNC.                                      
T23179*                                                                         
C33201     MOVE ZEROES  TO WS-SEAS-MONTH-COUNT.                         
C25448     IF  WS-SEASONAL-DEP-IND = 'Y' OR WS-SEASONAL                 
T23179         MOVE ZERO                TO WS-COMPUTE-MAX-DEPOSIT       
T23179         PERFORM UNTIL WS-COUNT > WS-NUMBER-OF-BILLS              
T23179             MOVE WS-MONTH-DEP(WS-COUNT) TO WS-REVENUE-DATE-DEC   
T23179             EVALUATE WS-REVENUE-MONTH                            
T23179                 WHEN 01                                          
T23179                 WHEN 02                                          
T23179                 WHEN 03                                          
T23179                 WHEN 10                                          
T23179                 WHEN 11                                          
T23179                 WHEN 12                                          
T23179                  COMPUTE WS-COMPUTE-MAX-DEPOSIT =                
T23179                         WS-COMPUTE-MAX-DEPOSIT +                 
T23179                         WS-AMOUNT-DEP(WS-COUNT)                  
C33201                  ADD 1  TO WS-SEAS-MONTH-COUNT                   
T23179             END-EVALUATE                                         
T23179             ADD 1                    TO WS-COUNT                 
T23179         END-PERFORM                                              
C33201* MAX DEPOSIT AMT WILL BE BASED ON NO OF SEASONAL MONTHS USAGE            
C33201* AVAILABLE. IT IS NOT ALWAYS BASED ON 6 SEASONAL USAGE MONTHS            
C33201* AS BEFORE.                                                              
C33201         COMPUTE WS-MAX-DEPOSIT-AMT =                             
C33201              (WS-COMPUTE-MAX-DEPOSIT / WS-SEAS-MONTH-COUNT) * 2  
T23179     ELSE                                                         
T23179         MOVE ZERO                    TO WS-COMPUTE-MAX-DEPOSIT   
T23179         PERFORM UNTIL WS-COUNT > WS-NUMBER-OF-BILLS              
T23179             MOVE WS-MONTH-DEP(WS-COUNT)  TO WS-REVENUE-DATE-DEC  
T23179             COMPUTE WS-COMPUTE-MAX-DEPOSIT =                     
T23179               WS-COMPUTE-MAX-DEPOSIT +  WS-AMOUNT-DEP(WS-COUNT)  
T23179             ADD 1                        TO WS-COUNT             
T23179         END-PERFORM                                              
C33201* MAX DEPOSIT AMT WILL BE BASED ON NO OF USAGE MONTHS AVAILABLE           
C33201* IT IS NOT ALWAYS BASED ON 12 USAGE MONTHS AS BEFORE.                    
C33201         COMPUTE WS-MAX-DEPOSIT-AMT =                             
C33201              (WS-COMPUTE-MAX-DEPOSIT / WS-NUMBER-OF-BILLS) * 2   
T23179     END-IF.                                                      
T23179*                                                                         
T23179 2333-COMP-MAX-DEPAMT-PSNC-EXIT.                                  
T23179     EXIT.                                                        
T23179*                                                                         
T23179*****************************************************************         
T23179* GETS THE MAXIMUM AND MINIMUM DEPOSIT AMTS FOR PSNC ACCOUNTS   *         
T23179* WHICH DON'T HAVE SUFFICIENT HISTORY.                          *         
T23179*****************************************************************         
T23179 2334-GET-PSNC-DEFAULT-DEPOSIT.                                   
T23179*                                                                         
A05091     MOVE  '26' TO C8-COMPANY-NO.                                 
T25448     IF  WS-SEASONAL-DEP-IND = 'Y' OR WS-SEASONAL                 
A05091         MOVE  WS-DEP-MAX-SEASONAL     TO C8-DELINQ-CD            
T23179     ELSE                                                         
A05091         MOVE  WS-DEP-MAX-NON-SEASONAL TO C8-DELINQ-CD            
T23179     END-IF.                                                      
T23179     PERFORM 7300-SELECT-DELINQ-DEPOSIT-AMT                       
T23179        THRU 7300-SELECT-DELINQ-DEP-EXIT.                         
T23179     MOVE C8-DELINQ-VALUE              TO WS-MAX-DEPOSIT-AMT.     
T23179*                                                                         
T23179     MOVE  WS-DEP-MIN-PSNC             TO C8-DELINQ-CD.           
T23179     PERFORM 7300-SELECT-DELINQ-DEPOSIT-AMT                       
T23179        THRU 7300-SELECT-DELINQ-DEP-EXIT.                         
T23179     MOVE C8-DELINQ-VALUE              TO WS-MIN-DEPOSIT-AMT.     
T23179*                                         RS-MIN-DEPOSIT-AMT.             
C33201     MOVE INSUFFICIENT-DATA-MSG        TO WS-USAGE-HISTORY-FLAG.  
T23179*                                                                         
T23179 2334-GET-PSNC-DEF-DEP-EXIT.                                      
T23179     EXIT.                                                        
T23179*                                                                         
T22668******************************************************************        
T22668* 2335 COMPUTE MAX DEPOSIT AMT FOR SEB                           *        
T22668*    -- THIS MODULE COMPUTES THE MAX DEPOSIT AMOUNT FOR SEB      *        
T22668******************************************************************        
T22668 2335-COMPUTE-MAX-DEP-SEB.                                        
T22668                                                                  
C33201* NO CALCULATION REQUIRED FOR ANY SEB ACCT USE DEFAULT VALUES FROM        
C33201* CSS_DELINQUENCY BASED ON REGULATED GROUP 1 OR GROUP 2 OR                
C33201* DEREGULATED RESIDENTIAL OR COMMERICAL.                                  
T22668     MOVE ZERO TO WS-COMPUTE-MAX-DEPOSIT.                         
T22668*                                                                         
A05091     MOVE '01' TO C8-COMPANY-NO.                                  
C33201* CHECK IF THE ACCOUNT IS A REGULATED OR DEREGULATED ACCT                 
C33201     MOVE WS-ACCOUNT-NO TO LR-ACCOUNT-NO                          
A05091                           TA-ACCOUNT-NO.                         
C33201     PERFORM 7310-SELECT-REG-GROUP                                
C33201        THRU 7310-SELECT-REG-GROUP-EXIT.                          
A05091     PERFORM 7500-SEL-SEB-SEASNL-FL                               
A05091        THRU 7500-SEL-SEB-SEASNL-FL-EXIT.                         
A05091     MOVE WS-AMT-MAX-SEB TO WS-TEMP-MIN-DEP                       
A05091                            WS-TEMP-MAX-DEP.                      
A05091     EVALUATE AT-ACCOUNT-TYPE-CODE                                
A05091       WHEN 'R'                                                   
A05091         EVALUATE WS-DREG-ACCT-FL                                 
A05091           WHEN 'Y'                                               
A05091             IF TA-SEASONAL-FL = 'S'                              
A05091                MOVE WS-DEP-MAX-DREG-RES-SEA TO WS-TEMP-MAX-DEP   
A05091                MOVE WS-DEP-MIN-DREG-RES-SEA TO WS-TEMP-MIN-DEP   
A05091             ELSE                                                 
A05091                MOVE WS-DEP-MAX-DREG-RES TO WS-TEMP-MAX-DEP       
A05091                MOVE WS-DEP-MIN-DREG-RES TO WS-TEMP-MIN-DEP       
A05091             END-IF                                               
A05091           WHEN 'N'                                               
A05091             EVALUATE LR-REG-GROUP-CD                             
A05091               WHEN '100'                                         
A05091                 IF LR-SENIOR-FL = 'Y'                            
A05091                    MOVE WS-DEP-MAX-REG100-SR TO WS-TEMP-MAX-DEP  
A05091                    MOVE WS-DEP-MIN-REG100-SR TO WS-TEMP-MIN-DEP  
A05091                 ELSE                                             
A05091                    MOVE WS-DEP-MAX-REG100 TO WS-TEMP-MAX-DEP     
A05091                    MOVE WS-DEP-MIN-REG100 TO WS-TEMP-MIN-DEP     
A05091                 END-IF                                           
A05091               WHEN '200'                                         
A05091                 IF WS-DHR-ACCT-FL = 'Y'                          
A05091                  IF LR-SENIOR-FL = 'Y'                           
A05091                    MOVE WS-DEP-MAX-REG2-SR-DHR TO WS-TEMP-MAX-DEP
A05091                    MOVE WS-DEP-MIN-REG2-SR-DHR TO WS-TEMP-MIN-DEP
A05091                  ELSE                                            
A05091                    MOVE WS-DEP-MAX-REG200-DHR TO WS-TEMP-MAX-DEP 
A05091                    MOVE WS-DEP-MIN-REG200-DHR TO WS-TEMP-MIN-DEP 
A05091                  END-IF                                          
A05091                 ELSE                                             
A05091                  IF LR-SENIOR-FL = 'Y'                           
A05091                    MOVE WS-DEP-MAX-REG200-SR TO WS-TEMP-MAX-DEP  
A05091                    MOVE WS-DEP-MIN-REG200-SR TO WS-TEMP-MIN-DEP  
A05091                  ELSE                                            
A05091                    MOVE WS-DEP-MAX-REG200 TO WS-TEMP-MAX-DEP     
A05091                    MOVE WS-DEP-MIN-REG200 TO WS-TEMP-MIN-DEP     
A05091                  END-IF                                          
A05091                 END-IF                                           
A05091             END-EVALUATE                                         
A05091         END-EVALUATE                                             
A05091     WHEN 'C'                                                     
A05091     WHEN 'I'                                                     
A05091       IF WS-DREG-ACCT-FL = 'Y'                                   
A05091          IF TA-SEASONAL-FL = 'S'                                 
A05091             MOVE WS-DEP-MAX-DREG-COM-SEA TO WS-TEMP-MAX-DEP      
A05091             MOVE WS-DEP-MIN-DREG-COM-SEA TO WS-TEMP-MIN-DEP      
A05091          ELSE                                                    
A05091             MOVE WS-DEP-MAX-DREG-COM TO WS-TEMP-MAX-DEP          
A05091             MOVE WS-DEP-MIN-DREG-COM TO WS-TEMP-MIN-DEP          
A05091          END-IF                                                  
A05091       END-IF                                                     
A05091     END-EVALUATE.                                                
A05091     MOVE WS-TEMP-MIN-DEP TO C8-DELINQ-CD.                        
C33201     PERFORM 7300-SELECT-DELINQ-DEPOSIT-AMT                       
C33201        THRU 7300-SELECT-DELINQ-DEP-EXIT.                         
C33201     MOVE C8-DELINQ-VALUE                TO WS-MIN-DEPOSIT-AMT    
A05091                                            RS-MIN-DEPOSIT-AMT.   
A05091     MOVE WS-TEMP-MAX-DEP TO C8-DELINQ-CD.                        
C33201     PERFORM 7300-SELECT-DELINQ-DEPOSIT-AMT                       
C33201        THRU 7300-SELECT-DELINQ-DEP-EXIT.                         
C33201     MOVE C8-DELINQ-VALUE                TO WS-MAX-DEPOSIT-AMT.   
C33201*                                                                         
T22668 2335-COMPUTE-MAX-DEP-SEB-EXIT.                                   
T22668     EXIT.                                                        
      *                                                                         
T23179******************************************************************        
T23179* CHECKS IF THE ACCOUNT/PREMISE IN COMBINATION HAVE SIX SEASONAL *        
T23179* MONTHS HISTORY.                                                *        
T23179******************************************************************        
T23179 2336-CHECK-SEASONAL-HIST.                                        
T23179*                                                                         
T23179     MOVE 'N'          TO WS-SEASONAL-HIST-FL                     
T23179     MOVE ZEROS        TO WS-SEAS-MONTH-COUNT                     
T23179     PERFORM VARYING WS-COUNT FROM 1 BY 1                         
T23179       UNTIL WS-COUNT > WS-NUMBER-OF-BILLS                        
T23179          OR WS-SEAS-MONTH-COUNT = 6                              
T23179         MOVE WS-MONTH-DEP(WS-COUNT) TO WS-REVENUE-DATE-DEC       
T23179         EVALUATE WS-REVENUE-MONTH                                
T23179             WHEN 01                                              
T23179             WHEN 02                                              
T23179             WHEN 03                                              
T23179             WHEN 10                                              
T23179             WHEN 11                                              
T23179             WHEN 12                                              
T23179                 ADD 1  TO WS-SEAS-MONTH-COUNT                    
T23179         END-EVALUATE                                             
T23179     END-PERFORM                                                  
T23179*                                                                         
C33201* SEASONAL HIST CAN BE USED IF THERE ARE USAGE FOR AT LEAST 2             
C33201* SEASONAL MONTHS                                                         
T23179*    IF  WS-SEAS-MONTH-COUNT = 6                                          
T23179     IF  WS-SEAS-MONTH-COUNT >= 2                                 
T23179         SET SEASONAL-HIST TO TRUE                                
T23179     END-IF.                                                      
T23179*                                                                         
T23179 2336-CHECK-SEASONAL-EXIT.                                        
T23179     EXIT.                                                        
T23179*                                                                         
      ******************************************************************        
      * 2340 ROUND WS-MAX-DEPOSIT-AMT DOWN TO THE NEAREST $5.          *        
      ******************************************************************        
       2340-ROUND-MAX-DEPOSIT.                                          
      *                                                                         
           MOVE WS-MAX-DEPOSIT-AMT         TO WS-MAX-DEPOSIT-TRUNC.     
      *                                                                         
           DIVIDE WS-MAX-DEPOSIT-TRUNC BY 5                             
                GIVING WS-TOTAL REMAINDER WS-REMAINDER                  
C25730          IN WS-HOST-VARIABLES-308.                               
      *                                                                         
C25730     SUBTRACT WS-REMAINDER IN WS-HOST-VARIABLES-308               
C25730                           FROM WS-MAX-DEPOSIT-TRUNC              
                GIVING WS-MAX-DEPOSIT-AMT.                              
      *                                                                         
C33201* MINIMUM DEPOSIT AMT WILL ALWAYS BE DEFAULT FOR SCEG                     
C33201* 01/24/06 - SS82048                                                      
C33201* FOR PSNC MIN DEPOSIT AMT WILL BE SAME AS MAX DEPOSIT AMT                
C33201* 01/24/06 - SS82048                                                      
C33201* FOR SCEG GAS ONLY ACCTS MIN DEP WILL BE SAME AS MAX DEPOSIT AMT         
C33201* 02/13/06 - SS82048                                                      
C33201     IF  WS-COMPANY-NO = WS-PSNC                                  
C33201     OR  WS-GAS-ONLY-FL = 'Y'                                     
C33201         MOVE WS-MAX-DEPOSIT-AMT TO WS-MIN-DEPOSIT-AMT            
C33201                                    RS-MIN-DEPOSIT-AMT            
C33201     END-IF.                                                      
      *                                                                         
       2340-ROUND-MAX-DEPOSIT-EXIT.                                     
           EXIT.                                                        
      *                                                                         
T10290******************************************************************        
T10290* 2350-GET-OLD-BILL-CYCLE.                                       *        
T10290*       -- WHEN THE ACCOUNT IS IN PENDING STATUS THE BILL CYCLE  *        
T10290*          IS SET TO '00'.  IF THIS CONDITION IS FOUND, THIS     *        
T10290*          MODULE SEARCHES THE CSS_CUST_PREM_HIST TABLE FOR THE  *        
T10290*          BILL CYCLE OF THE LAST ACCOUNT AT THIS PREMISE.       *        
T10290******************************************************************        
T10290 2350-GET-OLD-BILL-CYCLE.                                         
      *                                                                         
T10290     MOVE WS-N                TO WS-OLD-ACCT-FOUND-SW.            
T10290     MOVE WS-ACCOUNT-NO       TO CH-ACCOUNT-NO.                   
      *                                                                         
T34097     PERFORM 7100-SELECT-OLD-ACCOUNT                              
T34097        THRU 7100-SELECT-OLD-ACCOUNT-EXIT.                        
      *                                                                         
T10290     IF OLD-ACCT-NO-IS-FOUND                                      
T10290         PERFORM 7130-SELECT-BILL-CYCLE                           
T10290            THRU 7130-SELECT-BILL-CYCLE-EXIT                      
T10290     END-IF.                                                      
      *                                                                         
T10290 2350-GET-OLD-BILL-CYCLE-EXIT.                                    
T10290     EXIT.                                                        
      *                                                                         
C33201*                                                                         
C33201******************************************************************        
C33201* 2360-GET-SCEG-DEFAULT-DEPOSIT.                                 *        
C33201*      - THIS MODULE GETS THE DEFAULT MAX DEPOSIT AMTS FOR SCEG  *        
C33201*      - ACCOUNTS.                                               *        
C33201******************************************************************        
C33201 2360-GET-SCEG-DEFAULT-DEPOSIT.                                   
C33201*                                                                         
C34114*    MOVE WS-ACCOUNT-NO              TO UT-ACCOUNT-NO                     
C33201     MOVE WS-COMPANY-NO              TO C8-COMPANY-NO             
A05091     MOVE WS-DEP-MAX                 TO C8-DELINQ-CD.             
A05091     IF AT-ACCOUNT-TYPE-CODE = 'R'                                
A05091         MOVE WS-DEP-MAX-RES                 TO C8-DELINQ-CD      
C33201     ELSE                                                         
T34114         IF WS-GAS-ONLY-FL = 'Y'                                  
F34114          AND AT-ACCOUNT-TYPE-CODE = 'C' OR 'I'                   
A05091            MOVE WS-DEP-MAX-GAS-ONLY         TO C8-DELINQ-CD      
T34114         ELSE                                                     
A05091             IF AT-ACCOUNT-TYPE-CODE = 'C' OR 'I'                 
A05091                 MOVE WS-DEP-MAX-COMM          TO C8-DELINQ-CD    
C33201             ELSE                                                 
A05091                 MOVE WS-DEP-MAX               TO C8-DELINQ-CD    
C33201             END-IF                                               
T34114         END-IF                                                   
C33201     END-IF.                                                      
C33201     PERFORM 7300-SELECT-DELINQ-DEPOSIT-AMT                       
C33201        THRU 7300-SELECT-DELINQ-DEP-EXIT.                         
C33201     MOVE C8-DELINQ-VALUE                   TO WS-MAX-DEPOSIT-AMT.
C33201* DEFAULT MIN DEPOSIT AMT WILL BE SAME AS DEFAULT MAX DEPOSIT AMT         
C33201* - 01/24/06 - SS82048                                                    
C33201     MOVE WS-MAX-DEPOSIT-AMT                TO WS-MIN-DEPOSIT-AMT 
C33201                                               RS-MIN-DEPOSIT-AMT.
C33201     MOVE INSUFFICIENT-DATA-MSG          TO WS-USAGE-HISTORY-FLAG.
C33201*                                                                         
C33201 2360-GET-SCEG-DEF-DEP-EXIT.                                      
C33201     EXIT.                                                        
C33201*                                                                         
C33201******************************************************************        
C33201* 2370-CHECK-GAS-ONLY.                                           *        
C33201*      - THIS MODULE CHECKS FOR GAS ONLY ACCOUNTS.               *        
C33201******************************************************************        
C33201 2370-CHECK-GAS-ONLY.                                             
C33201*                                                                         
C33201     MOVE AT-LOCAL-OFFICE               TO B1-LOCAL-OFFICE        
C33201     MOVE AT-COMPANY-NO                 TO B1-COMPANY-NO          
C33201     MOVE 'GAS'                         TO B1-DISTRICT-NO         
C33201     PERFORM 7330-SELECT-GAS-ONLY                                 
C33201        THRU 7330-SELECT-GAS-ONLY-EXIT                            
C33201     IF  WS-GAS-ONLY-FL = 'Y'                                     
C33201         CONTINUE                                                 
C33201     ELSE                                                         
C33201* CHECK GAS ONLY ACCTS IN COMBO LOCAL OFFICES                             
C33201         MOVE WS-ACCOUNT-NO TO UT-ACCOUNT-NO                      
C33201         PERFORM 7340-CHECK-COMBO-LOCALOFF                        
C33201            THRU 7340-CHECK-COMBO-LOCALOFF-EXIT                   
C33201     END-IF.                                                      
C33201*                                                                         
C33201 2370-CHECK-GAS-ONLY-EXIT.                                        
C33201     EXIT.                                                        
C33201*                                                                         
C33201******************************************************************        
C33201* 2380-SCEG-GAS-ONLY-DEP.                                        *        
C33201*      - THIS MODULE CHECKS FOR SCEG GAS ONLY ACCOUNTS.          *        
C33201******************************************************************        
C33201 2380-SCEG-GAS-ONLY-DEP.                                          
C33201*                                                                         
RICK***    MOVE +1                      TO WS-COUNT                             
RICK***    MOVE ZEROES                  TO WS-WHST                              
RICK***    PERFORM UNTIL WS-COUNT > WS-NUMBER-OF-BILLS                          
RICK***        MOVE WS-MONTH-DEP(WS-COUNT) TO WS-REVENUE-DATE-DEC               
RICK***        EVALUATE WS-REVENUE-MONTH                                        
RICK***            WHEN 01                                                      
RICK***            WHEN 02                                                      
RICK***            WHEN 03                                                      
RICK***            WHEN 10                                                      
RICK***            WHEN 11                                                      
RICK***            WHEN 12                                                      
RICK***               ADD 1 TO WS-WHST                                          
RICK***               MOVE WS-AMOUNT-DEP(WS-COUNT)                              
RICK***                 TO WS-AMOUNT-DEP-WHST(WS-WHST)                          
RICK***               MOVE WS-ACCOUNT-DEP(WS-COUNT)                             
RICK***                 TO WS-ACCOUNT-DEP-WHST(WS-WHST)                         
RICK***               MOVE WS-MONTH-DEP(WS-COUNT)                               
RICK***                 TO WS-MONTH-DEP-WHST(WS-WHST)                           
RICK***        END-EVALUATE                                                     
RICK***        ADD 1                        TO WS-COUNT                         
RICK***    END-PERFORM                                                          
RICK***    IF  WS-WHST > 1                                                      
RICK***        INITIALIZE WS-DEPOSIT-AMOUNT-ARRAY                               
RICK***        MOVE WS-DEPOSIT-AMOUNT-ARRAY-WHST                                
RICK***          TO WS-DEPOSIT-AMOUNT-ARRAY                                     
RICK***    END-IF.                                                              
C33201*                                                                         
RICK***2380-SCEG-GAS-ONLY-DEP-EXIT.                                             
RICK***    EXIT.                                                                
      *                                                                         
      ******************************************************************        
      * 7000-OPEN-COMPUTEDEP-CSR                                       *        
      *       -- THIS MODULE OPENS THE COMPUTE DEPOSITS CURSOR         *        
      ******************************************************************        
       7000-OPEN-COMPUTEDEP-CSR.                                        
      *                                                                         
           EXEC SQL                                                     
               OPEN COMPUTEDEP                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO RS-RETURN-CODE.        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'CPD00308'                 TO ABEND-PROGRAM         
               MOVE '7000'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN COMPUTEDEP   '       TO ABEND-FUNCTION        
               MOVE 'CSS_BILLING_DET'          TO TABLE-1               
               MOVE 'COMPUTEDEP'               TO TABLE-ELEMENT-1       
               MOVE 'OPEN CURSOR'              TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-OPEN-COMPUTEDEP-CSR-EXIT.                                   
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 7010-FETCH-COMPUTEDEP-CSR                                      *        
      *     -- THIS MODULE FETCHES THE RESULT ROWS THAT WILL BE USED TO*        
      *        DETERMINE THE MAX DEPOSIT AMOUNT.  IT ALSO CHECKS THAT  *        
      *        THE REVENUE MONTHS ARE CONSECUTIVE MONTHS.              *        
      ******************************************************************        
       7010-FETCH-COMPUTEDEP-CSR.                                       
                                                                        
           EXEC SQL                                                     
               FETCH COMPUTEDEP                                         
                  INTO :WS-TEMP-DEPOSIT-AMT :WS-TEMP-NULL-IND,           
                       :WS-TEMP-REV-DATE,                               
T26404                 :WS-TEMP-REVMTH-ORIG,                            
T26404                 :WS-TEMP-TIMESTMP,                               
T26404                 :WS-REBILL-IND,                                  
                       :WS-TEMP-ACCT-NO                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF WS-TEMP-NULL-IND < 0 THEN                                 
              MOVE 0 TO WS-TEMP-DEPOSIT-AMT                             
C33201        MOVE ZEROES TO WS-TEMP-NULL-IND                           
           END-IF.                                                      
      *                                                                         
T26404     IF WS-TEMP-REVMTH-ORIG > 0                                   
T26404        AND WS-REBILL-IND EQUAL WS-Y                              
T26404        MOVE WS-TEMP-REVMTH-ORIG TO WS-TEMP-REV-DATE              
T26404     END-IF.                                                      
      *                                                                         
           EVALUATE SQLCODE                                             
             WHEN SUCCESSFUL-CALL                                       
               IF WS-COUNT = 0 THEN                                     
                    ADD +1                   TO WS-COUNT                
                    MOVE WS-TEMP-DEPOSIT-AMT TO WS-AMOUNT-DEP(WS-COUNT) 
                    MOVE WS-TEMP-REV-DATE    TO WS-MONTH-DEP(WS-COUNT)  
                    MOVE WS-TEMP-ACCT-NO     TO WS-ACCOUNT-DEP(WS-COUNT)
                    MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE   
                    GO TO 7010-FETCH-COMPUTEDEP-CSR-EXIT                
               END-IF                                                   
               IF WS-COUNT NOT = 0                                      
                  IF WS-TEMP-REV-DATE = WS-MONTH-DEP(WS-COUNT)          
                     ADD WS-TEMP-DEPOSIT-AMT TO WS-AMOUNT-DEP(WS-COUNT) 
                     IF WS-ACCOUNT-DEP(WS-COUNT) NOT = WS-ACCOUNT-NO    
                        AND WS-TEMP-ACCT-NO  = WS-ACCOUNT-NO            
                        MOVE WS-TEMP-ACCT-NO TO                         
                                            WS-ACCOUNT-DEP(WS-COUNT)    
                     END-IF                                             
C33201            ELSE                                                  
C33201                ADD +1                     TO WS-COUNT            
T26404                IF WS-COUNT > 12                                  
T26404                   MOVE NOT-FOUND    TO WS-ACTIVE-RETURN-CODE     
T26404                ELSE                                              
C33201                   MOVE WS-TEMP-DEPOSIT-AMT                       
C33201                                TO WS-AMOUNT-DEP(WS-COUNT)        
C33201                   MOVE WS-TEMP-REV-DATE                          
C33201                                TO WS-MONTH-DEP(WS-COUNT)         
C33201                   MOVE WS-TEMP-ACCT-NO                           
C33201                                TO WS-ACCOUNT-DEP(WS-COUNT)       
C33201                   MOVE SQLCODE                                   
C33201                                TO WS-ACTIVE-RETURN-CODE          
C33201                END-IF                                            
C33201            END-IF                                                
C33201         END-IF                                                   
C33201* THE CHECK TO VERIFY IF THE BILLS ARE FOR CONSECUTIVE MONTHS             
C33201* WILL BE DONE BEFORE ADDING THE AMOUNTS OF 2 MONTHS FOR SCEG             
C33201* FOR PSNC IT DOES NOT MATTER IF BILL AMTS AVAILABLE ARE FROM             
C33201* CONSECUTIVE MONTHS.                                                     
C33201*                                                                         
             WHEN NOT-FOUND                                             
                  MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE   
             WHEN OTHER                                                 
                  MOVE SQLCODE               TO RS-RETURN-CODE          
                  MOVE 'CPD00308'            TO ABEND-PROGRAM           
                  MOVE '7010'                TO ACTIVE-PARAGRAPH        
                  MOVE 'FETCH COMPUTEDEP '   TO ABEND-FUNCTION          
                  MOVE 'CSS_BILLING_DET'     TO TABLE-1                 
                  MOVE 'COMPUTEDEP'          TO TABLE-ELEMENT-1         
                  MOVE 'FETCH CURSOR'        TO HOSTVAR-ELEMENT-1       
                  PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT        
           END-EVALUATE.                                                
      *                                                                         
       7010-FETCH-COMPUTEDEP-CSR-EXIT.                                  
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7020-CLOSE-COMPUTEDEP-CSR                                      *        
      *       -- THIS MODULE CLOSES THE COMPUTEDEP CURSOR              *        
      ******************************************************************        
       7020-CLOSE-COMPUTEDEP-CSR.                                       
      *                                                                         
           EXEC SQL                                                     
               CLOSE COMPUTEDEP                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO RS-RETURN-CODE.        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'CPD00308'                 TO ABEND-PROGRAM         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE '7020'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE COMPUTEDEP  '       TO ABEND-FUNCTION        
               MOVE 'CSS_BILLING_DET'          TO TABLE-1               
               MOVE 'COMPUTEDEP'               TO TABLE-ELEMENT-1       
               MOVE 'CLOSE CURSOR'             TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7020-CLOSE-COMPUTEDEP-CSR-EXIT.                                  
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
T44097* 7025-SELECT-BILL-DATE                                                   
      ******************************************************************        
T34097 7025-SELECT-BILL-DATE.                                           
      *                                                                         
T34097     EXEC SQL                                                     
T34097          SELECT TOP(1) COALESCE(CAST(DATE_BILLED
            AS CHAR(10)),' ')                   
T34097            INTO  :WS-DATE-CWS00308                               
T34097            FROM  CSS_BILLING_HDR WITH(READUNCOMMITTED)                   
T34097           WHERE  PREMISE_NO        = :WS-PREMISE-NO              
T34097             AND  ACCOUNT_NO        = :WS-ACCOUNT-NO              
T34097             AND  CODE_BILL_STATUS  = :BILLED-CODE                
T34097             AND  CODE_BILL_TYPE    = :BILL-NORMAL                
T34097        ORDER BY  DATE_BILLED DESC                                
T34097                                     
ACT041                                                      
T34097     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  IFNULL(CHAR(DATE_BILLED),' ')                           
MFA-TR*           INTO  :WS-DATE-CWS00308                                       
MFA-TR*           FROM  CSS_BILLING_HDR                                         
MFA-TR*          WHERE  PREMISE_NO        = :WS-PREMISE-NO                      
MFA-TR*            AND  ACCOUNT_NO        = :WS-ACCOUNT-NO                      
MFA-TR*            AND  CODE_BILL_STATUS  = :BILLED-CODE                        
MFA-TR*            AND  CODE_BILL_TYPE    = :BILL-NORMAL                        
MFA-TR*       ORDER BY  DATE_BILLED DESC                                        
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*         QUERYNO 7025                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-DATE-NULL-IND < 0                                  
                   MOVE SPACES            TO WS-DATE-CWS00308           
C33201             MOVE ZEROES            TO WS-DATE-NULL-IND           
               END-IF                                                   
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  IF BATCH-IS-CALLING                                   
                     MOVE WS-TEMP-BATCH-DATE                            
                                          TO WS-DATE-CWS00308           
                  ELSE                                                  
                     PERFORM 7200-GET-CURRENT-DATE                      
                        THRU 7200-GET-CURRENT-DATE-EXIT                 
                  END-IF                                                
               ELSE                                                     
                  MOVE 'CPD00308'         TO ABEND-PROGRAM              
T34097            MOVE '7025'             TO ACTIVE-PARAGRAPH           
T34097            MOVE 'SELECT          ' TO ABEND-FUNCTION             
                  MOVE 'CSS_BILLING_HDR'  TO TABLE-1                    
T34097            MOVE 'PREMISE_NO'       TO TABLE-ELEMENT-1            
T34097            MOVE WS-PREMISE-NO      TO HOSTVAR-ELEMENT-1          
T34097            MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-2            
T34097            MOVE WS-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2          
                  PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT        
               END-IF                                                   
           END-IF.                                                      
       7025-SELECT-BILL-DATE-EXIT.                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7050 GET-REV-SRCH-DT-ALL                                       *        
      *     -- THIS MODULE GETS THE LAST-BILL-DATE AND THEN SUBTRACTS  *        
      *     -- 1 YEAR FROM IT TO GIVE THE REVENUE SEARCH DATE          *        
      ******************************************************************        
       7050-GET-REV-SRCH-DT-ALL.                                        
      *                                                                         
           EXEC SQL                                                     
               SELECT (DATEADD( YEAR, -1, MAX(DATE_EXTRACT) ) )                 
                INTO  :WS-DATE-CWS00308 :WS-TEMP-NULL-IND              
                FROM  CSS_BILL_WINDOW WITH(READUNCOMMITTED)                     
                WHERE  BILL_CYCLE = :AT-BILL-CYCLE                      
                       AND CODE_BILL_COND = 'C'                         
                       AND DATE_EXTRACT <= IIF(TRY_CONVERT(DATE, 
                                                     :WS-TEMP-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-TEMP-HOLD-DATE
              ) <> 0) OR (LEN(:WS-TEMP-HOLD-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-TEMP-HOLD-DATE
              ), CONVERT(DATE, :WS-TEMP-HOLD-DATE) )           
ACT041                                                           
ACT041                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT (MAX(DATE_EXTRACT)  - 1 YEAR )                            
MFA-TR*         INTO  :WS-DATE-CWS00308  :WS-TEMP-NULL-IND                      
MFA-TR*         FROM  CSS_BILL_WINDOW                                           
MFA-TR*         WHERE  BILL_CYCLE = :AT-BILL-CYCLE                              
MFA-TR*                AND CODE_BILL_COND = 'C'                                 
MFA-TR*                AND DATE_EXTRACT <= :WS-TEMP-HOLD-DATE                   
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL)                 
               IF WS-TEMP-NULL-IND < ZEROES                             
                  MOVE SPACES TO WS-DATE-CWS00308                       
C33201            MOVE ZEROES TO WS-TEMP-NULL-IND                       
               END-IF                                                   
           ELSE                                                         
               MOVE 'CPD00308'            TO ABEND-PROGRAM              
               MOVE '7050'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT             ' TO ABEND-FUNCTION             
               MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                    
               MOVE 'DATE_EXTRACT'        TO TABLE-ELEMENT-1            
               MOVE  WS-TEMP-HOLD-DATE    TO HOSTVAR-ELEMENT-1          
               MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2            
               MOVE WS-PREMISE-NO         TO HOSTVAR-ELEMENT-2          
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-3          
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7050-GET-REV-SRCH-DT-ALL-EXIT.                                   
           EXIT.                                                        
      *                                                                         
T35163******************************************************************        
T35163* 7055 GET-REV-SRCH-DT-ALL                                                
T35163*     -- THIS MODULE GETS THE CURRENT REVENUE MONTH FOR THE      *        
T35163*     -- ACCT'S BILL CYCLE                                       *        
T35163******************************************************************        
T35163 7055-GET-REV-SRCH-DT-ALL.                                        
T35163*                                                                         
T35163     EXEC SQL                                                     
T35163         SELECT (MAX(REVENUE_MONTH))                              
T35163          INTO  :WS-SEARCH-END-DATE :WS-TEMP-NULL-IND              
T35163          FROM  CSS_BILL_WINDOW WITH(READUNCOMMITTED)                     
T35163          WHERE  BILL_CYCLE    = :AT-BILL-CYCLE                   
A04243             AND DATE_EXTRACT <= IIF(TRY_CONVERT(DATE, 
                                                  :WS-PARA-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PARA-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-PARA-CURRENT-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-PARA-CURRENT-DATE
              ), CONVERT(DATE, :WS-PARA-CURRENT-DATE) )            
ACT041                                                           
ACT041                                                      
T35163     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT (MAX(REVENUE_MONTH))                                      
MFA-TR*         INTO  :WS-SEARCH-END-DATE:WS-TEMP-NULL-IND                      
MFA-TR*         FROM  CSS_BILL_WINDOW                                           
MFA-TR*         WHERE  BILL_CYCLE    = :AT-BILL-CYCLE                           
MFA-TR*            AND DATE_EXTRACT <= :WS-PARA-CURRENT-DATE                    
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7055                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
T35163     MOVE SQLCODE                   TO RS-RETURN-CODE.            
T35163     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
T35163     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T35163         IF WS-TEMP-NULL-IND < ZEROES                             
T35163            MOVE ZEROES TO WS-SEARCH-END-DATE                     
C33201            MOVE ZEROES TO WS-TEMP-NULL-IND                       
T35163         END-IF                                                   
T35163     ELSE                                                         
T35163         MOVE 'CPD00308'            TO ABEND-PROGRAM              
T35163         MOVE '7055'                TO ACTIVE-PARAGRAPH           
T35163         MOVE 'SELECT             ' TO ABEND-FUNCTION             
T35163         MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                    
T35163         MOVE 'REVENUE_MONTH'       TO TABLE-ELEMENT-1            
T35163         MOVE  WS-SEARCH-END-DATE   TO HOSTVAR-ELEMENT-1          
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2          
T35163         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
T35163 7055-GET-REV-SRCH-DT-ALL-EXIT.                                   
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
A05091* 7060 SELECT-ACCT-INFO                                          *        
A05091*     -- THIS MODULE GETS NEEDED ACCOUNT INFROMATION FROM THE    *        
A05091*     -- ACCOUNT TABLE.                                          *        
      ******************************************************************        
A05091 7060-SELECT-ACCT-INFO.                                           
      *                                                                         
           EXEC SQL                                                     
A05091         SELECT COMPANY_NO                                        
A05091               ,LOCAL_OFFICE                                      
                     ,PREMISE_NO                                        
A05091               ,ACCOUNT_TYPE_CODE                                 
A05091           INTO :AT-COMPANY-NO                                    
A05091               ,:AT-LOCAL-OFFICE                                  
                     ,:WS-PREMISE-NO                                    
A05091               ,:AT-ACCOUNT-TYPE-CODE                             
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
ACT041                                                           
ACT041                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NO                                                
MFA-TR*              ,LOCAL_OFFICE                                              
MFA-TR*              ,PREMISE_NO                                                
MFA-TR*              ,ACCOUNT_TYPE_CODE                                         
MFA-TR*          INTO :AT-COMPANY-NO                                            
MFA-TR*              ,:AT-LOCAL-OFFICE                                          
MFA-TR*              ,:WS-PREMISE-NO                                            
MFA-TR*              ,:AT-ACCOUNT-TYPE-CODE                                     
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7060                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL)                 
               MOVE AT-COMPANY-NO         TO WS-COMPANY-NO              
           ELSE                                                         
               MOVE 'CPD00308'            TO ABEND-PROGRAM              
               MOVE '7060'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT             ' TO ABEND-FUNCTION             
               MOVE 'CSS_ACCOUNT'         TO TABLE-1                    
               MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1            
               MOVE  WS-PREMISE-NO        TO HOSTVAR-ELEMENT-1          
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2            
               MOVE  WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2          
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
A05091 7060-SELECT-ACCT-INFO-EXIT.                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7070 MONTH-DIFFERENCE                                          *        
      *     -- THIS MODULE FINDS THE DIFFERENCE BETWEEN TWO DATES IN   *        
      *     MONTHS .                                                   *        
      ******************************************************************        
       7070-MONTH-DIFFERENCE.                                           
      *                                                                         
           MOVE WS-FROM-DATE     TO WS-FROM-DATE-REDEF.                 
           MOVE WS-TO-DATE       TO WS-TO-DATE-REDEF.                   
T34097     EXEC SQL                                                     
T34097        SELECT
              12 * CIS.DECIMAL2YEAR(CIS.DIFFDATE( IIF(TRY_CONVERT(DATE, 
                                                    :WS-FROM-DATE-REDEF
              ) IS NULL OR (PATINDEX('%.%', :WS-FROM-DATE-REDEF
              ) <> 0) OR (LEN(:WS-FROM-DATE-REDEF
              ) <> 10), CIS.CHAR2DATE(:WS-FROM-DATE-REDEF
              ), CONVERT(DATE, :WS-FROM-DATE-REDEF) ), 
              IIF(TRY_CONVERT(DATE, :WS-TO-DATE-REDEF
              ) IS NULL OR (PATINDEX('%.%', :WS-TO-DATE-REDEF
              ) <> 0) OR (LEN(:WS-TO-DATE-REDEF) <> 10), CIS.CHAR2DATE(
                                                      :WS-TO-DATE-REDEF
              ), CONVERT(DATE, :WS-TO-DATE-REDEF) ) ))              
T34097            + CIS.DECIMAL2MONTH(CIS.DIFFDATE( 
              IIF(TRY_CONVERT(DATE, :WS-FROM-DATE-REDEF
              ) IS NULL OR (PATINDEX('%.%', :WS-FROM-DATE-REDEF
              ) <> 0) OR (LEN(:WS-FROM-DATE-REDEF
              ) <> 10), CIS.CHAR2DATE(:WS-FROM-DATE-REDEF
              ), CONVERT(DATE, :WS-FROM-DATE-REDEF) ), 
              IIF(TRY_CONVERT(DATE, :WS-TO-DATE-REDEF
              ) IS NULL OR (PATINDEX('%.%', :WS-TO-DATE-REDEF
              ) <> 0) OR (LEN(:WS-TO-DATE-REDEF) <> 10), CIS.CHAR2DATE(
                                                      :WS-TO-DATE-REDEF
              ), CONVERT(DATE, :WS-TO-DATE-REDEF) ) ))
            INTO
              :WS-NO-OF-MONTHS              
T34097     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-NO-OF-MONTHS =                                            
MFA-TR*             12 * YEAR(DATE(:WS-FROM-DATE-REDEF)                         
MFA-TR*                         - DATE(:WS-TO-DATE-REDEF))                      
MFA-TR*           + MONTH(DATE(:WS-FROM-DATE-REDEF)                             
MFA-TR*                         - DATE(:WS-TO-DATE-REDEF))                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL)                 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'CPD00308'            TO ABEND-PROGRAM              
               MOVE '7070'                TO ACTIVE-PARAGRAPH           
T34097         MOVE 'SET '                TO ABEND-FUNCTION             
T34097         MOVE SPACES                TO ABEND-SQL-PREDICATES       
T34097                                       ABEND-TABLES               
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
       7070-MONTH-DIFFERNCE.                                            
           EXIT.                                                        
      *                                                                         
T23179******************************************************************        
T23179* GET THE RATE-PLAN-NO TO CHECK IF IT IS A SEASONAL              *        
T23179******************************************************************        
T23179 7085-GET-RATE-PLAN-NO.                                           
T23179*                                                                 00011500
T23179     EXEC SQL                                                     
T23179*                                                                 00011500
T23179         SELECT RATE_PLAN_NO                                      
C33201               ,CODE_REVENUE_CLASS                                
T23179         INTO :UT-RATE-PLAN-NO                                    
C33201             ,:UT-CODE-REVENUE-CLASS                              
T23179         FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                   
T23179         WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                        
T23179         AND   CODE_UTIL_TYPE = 'G'                               
T23179         AND   IC_NO =                                            
T23179                      (SELECT MAX(IC_NO)                          
T23179                       FROM CSS_UTIL_ENVRNMT UT
                           WITH(READUNCOMMITTED)                   
T23179                       WHERE ACCOUNT_NO = :UT-ACCOUNT-NO          
T23179                       AND   CODE_UTIL_TYPE = 'G')                
ACT041                                                           
ACT041                                                      
T23179*                                                                 00011500
T23179     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                 00011500
MFA-TR*        SELECT RATE_PLAN_NO                                              
MFA-TR*              ,CODE_REVENUE_CLASS                                        
MFA-TR*        INTO :UT-RATE-PLAN-NO                                            
MFA-TR*            ,:UT-CODE-REVENUE-CLASS                                      
MFA-TR*        FROM CSS_UTIL_ENVRNMT UT                                         
MFA-TR*        WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                                
MFA-TR*        AND   CODE_UTIL_TYPE = 'G'                                       
MFA-TR*        AND   IC_NO =                                                    
MFA-TR*                     (SELECT MAX(IC_NO)                                  
MFA-TR*                      FROM CSS_UTIL_ENVRNMT UT                           
MFA-TR*                      WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                  
MFA-TR*                      AND   CODE_UTIL_TYPE = 'G')                        
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7085                                                    
MFA-TR*                                                                 00011500
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T23179*                                                                         
T23179     MOVE SQLCODE                   TO RS-RETURN-CODE.            
T23179     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
T23179*                                                                         
T23179     IF  (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL)                
T23179         MOVE UT-RATE-PLAN-NO       TO WS-RATE-PLAN-NO            
T23179     ELSE                                                         
T24946         IF  (WS-ACTIVE-RETURN-CODE = NOT-FOUND)                  
T24946              CONTINUE                                            
T24946         ELSE                                                     
T23179             MOVE 'CPD00308'        TO ABEND-PROGRAM              
T23179             MOVE '7085'            TO ACTIVE-PARAGRAPH           
T23179             MOVE 'SELECT             ' TO ABEND-FUNCTION         
T23179             MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
T23179             MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
T23179             MOVE 'CODE_UTIL_TYPE'  TO TABLE-ELEMENT-2            
T23179             MOVE UT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
T23179             MOVE 'G'               TO HOSTVAR-ELEMENT-2          
T23179             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
T24946         END-IF                                                   
T23179     END-IF.                                                      
T23179*                                                                         
T23179  7085-GET-RATE-PLAN-NO-EXIT.                                     
T23179      EXIT.                                                       
T23179*                                                                         
C25448******************************************************************        
C25448* GET THE REVENUE CLASS TO CHECK FOR THE SEASONAL APPL           *        
C25448******************************************************************        
C25448 7085A-GET-REV-CLASS.                                             
C25448*                                                                 00011500
C25448     EXEC SQL                                                     
C25448*                                                                 00011500
C25448        SELECT TOP(1) :WS-EXISTS                                         
C25448          INTO :WS-SEASONAL-FL                                    
C25448          FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
C25448         WHERE ACCOUNT_NO         = :UT-ACCOUNT-NO                
C25448           AND CODE_UTIL_TYPE     = 'G'                           
C25448           AND RATE_PLAN_NO       = :UT-RATE-PLAN-NO              
C25448           AND CODE_REVENUE_CLASS = :WS-SP-REV-CLS                
ACT041                                       
ACT041                                                      
C25448*                                                                 00011500
C25448     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                 00011500
MFA-TR*       SELECT :WS-EXISTS                                                 
MFA-TR*         INTO :WS-SEASONAL-FL                                            
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT                                        
MFA-TR*        WHERE ACCOUNT_NO         = :UT-ACCOUNT-NO                        
MFA-TR*          AND CODE_UTIL_TYPE     = 'G'                                   
MFA-TR*          AND RATE_PLAN_NO       = :UT-RATE-PLAN-NO                      
MFA-TR*          AND CODE_REVENUE_CLASS = :WS-SP-REV-CLS                        
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*          QUERYNO 7851                                                   
MFA-TR*                                                                 00011500
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C25448*                                                                         
C25448     MOVE SQLCODE                   TO RS-RETURN-CODE.            
C25448     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
C25448*                                                                         
C25448     IF  (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND)   
C25448         CONTINUE                                                 
C25448     ELSE                                                         
C25448         MOVE 'CPD00308'        TO ABEND-PROGRAM                  
C25448         MOVE '7085A'           TO ACTIVE-PARAGRAPH               
C25448         MOVE 'SELECT         ' TO ABEND-FUNCTION                 
C25448         MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                       
C25448         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1                
C25448         MOVE 'CODE_UTIL_TYPE'  TO TABLE-ELEMENT-2                
C25448         MOVE 'RATE_PLAN_NO'    TO TABLE-ELEMENT-3                
C25448         MOVE UT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1              
C25448         MOVE 'G'               TO HOSTVAR-ELEMENT-2              
C25448         MOVE UT-RATE-PLAN-NO   TO HOSTVAR-ELEMENT-3              
C25448         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
C25448     END-IF.                                                      
C25448*                                                                         
C25448  7085A-EXIT.                                                     
C25448      EXIT.                                                       
C25448*                                                                         
T23179******************************************************************        
T23179* GET THE SEASONAL-DEP-IND FOR THE RATE-PLAN-NO                  *        
T23179******************************************************************        
T23179 7090-GET-SEAS-DEP-IND.                                           
T23179*                                                                 00011500
T23179     EXEC SQL                                                     
T23179*                                                                 00011500
T23179         SELECT SEASONAL_DEP_IND                                  
T23179         INTO :RT-SEASONAL-DEP-IND :WS-TEMP-NULL-IND               
T23179         FROM CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)                   
T23179         WHERE RT.RATE_PLAN_NO = :RT-RATE-PLAN-NO                 
T23179         AND   RT.CODE_UTIL_TYPE = 'G'                            
T23179         AND   RT.CODE_STATUS    = 'A'                            
T23179         AND   RT.FROM_EFFECTIVE_DT =                             
T23179                      (SELECT MAX(FROM_EFFECTIVE_DT)              
T23179                       FROM CSS_RATE_CREATOR WITH(READUNCOMMITTED)        
T23179                       WHERE RATE_PLAN_NO = :RT-RATE-PLAN-NO      
T23179                       AND   CODE_UTIL_TYPE = 'G'                 
T23179                       AND   CODE_STATUS    = 'A'                 
T23179                       AND   FROM_EFFECTIVE_DT <= 
           CAST(SYSDATETIMEOFFSET() AS DATE))   
ACT041                                                           
ACT041                                                      
T23179*                                                                 00011500
T23179     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                 00011500
MFA-TR*        SELECT SEASONAL_DEP_IND                                          
MFA-TR*        INTO :RT-SEASONAL-DEP-IND:WS-TEMP-NULL-IND                       
MFA-TR*        FROM CSS_RATE_CREATOR RT                                         
MFA-TR*        WHERE RT.RATE_PLAN_NO = :RT-RATE-PLAN-NO                         
MFA-TR*        AND   RT.CODE_UTIL_TYPE = 'G'                                    
MFA-TR*        AND   RT.CODE_STATUS    = 'A'                                    
MFA-TR*        AND   RT.FROM_EFFECTIVE_DT =                                     
MFA-TR*                     (SELECT MAX(FROM_EFFECTIVE_DT)                      
MFA-TR*                      FROM CSS_RATE_CREATOR                              
MFA-TR*                      WHERE RATE_PLAN_NO = :RT-RATE-PLAN-NO              
MFA-TR*                      AND   CODE_UTIL_TYPE = 'G'                         
MFA-TR*                      AND   CODE_STATUS    = 'A'                         
MFA-TR*                      AND   FROM_EFFECTIVE_DT <= CURRENT DATE)           
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7090                                                    
MFA-TR*                                                                 00011500
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T23179*                                                                         
T23179     MOVE SQLCODE                   TO RS-RETURN-CODE.            
T23179     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
T23179*                                                                         
T23179     IF  (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL)                
T23179         MOVE RT-SEASONAL-DEP-IND   TO WS-SEASONAL-DEP-IND        
T23179     ELSE                                                         
T23179        IF  WS-TEMP-NULL-IND < 0 THEN                             
T23179            MOVE 'N'                   TO WS-SEASONAL-DEP-IND     
C33201            MOVE ZEROES                TO WS-TEMP-NULL-IND        
T23179        ELSE                                                      
T23179            MOVE 'CPD00308'            TO ABEND-PROGRAM           
T23179            MOVE '7090'                TO ACTIVE-PARAGRAPH        
T23179            MOVE 'SELECT             ' TO ABEND-FUNCTION          
T23179            MOVE 'CSS_RATE_CREATOR'    TO TABLE-1                 
T23179            MOVE 'RATE_PLAN_NO'        TO TABLE-ELEMENT-1         
T23179            MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2         
                  MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3         
T23179            MOVE RT-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-1       
T23179            MOVE 'G'                   TO HOSTVAR-ELEMENT-2       
                  MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-3       
T23179            PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
T23179        END-IF                                                    
T23179     END-IF.                                                      
T23179*                                                                         
T23179  7090-GET-SEAS-DEP-IND-EXIT.                                     
T23179      EXIT.                                                       
T23179*                                                                         
      ******************************************************************        
T34097* 7100-SELECT-OLD-ACCOUNT.                                       *        
T34097*     -- THIS MODULE SELECTS THE ACCOUNT NO FOR THE OLD BILL     *        
T34097*        CYCLE. THE ACCOUNT NO FOR THE OLDEST UTILITY SERVICE    *        
T34097*        START DATE IS SELECTED.                                 *        
      ******************************************************************        
T34097 7100-SELECT-OLD-ACCOUNT.                                         
      *                                                                         
T34097     EXEC SQL                                                     
T34097          SELECT TOP(1) ACCOUNT_NO                                      
T34097            INTO  :WS-OLD-ACCOUNT-NO                              
T34097            FROM  CSS_CUST_PREM_HIST WITH(READUNCOMMITTED)                
T34097           WHERE  ACCOUNT_NO <> :CH-ACCOUNT-NO                    
T34097             AND  PREMISE_NO = :WS-PREMISE-NO                     
T34097        ORDER BY  DATE_UTIL_SVC_STRT DESC                         
T34097                                            
ACT041                                                           
ACT041                                                      
T34097     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  ACCOUNT_NO                                              
MFA-TR*           INTO  :WS-OLD-ACCOUNT-NO                                      
MFA-TR*           FROM  CSS_CUST_PREM_HIST                                      
MFA-TR*          WHERE  ACCOUNT_NO <> :CH-ACCOUNT-NO                            
MFA-TR*            AND  PREMISE_NO = :WS-PREMISE-NO                             
MFA-TR*       ORDER BY  DATE_UTIL_SVC_STRT DESC                                 
MFA-TR*           FETCH FIRST 1 ROW ONLY                                        
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
T17149     MOVE SQLCODE                       TO RS-RETURN-CODE.        
T17149     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
T10290     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T10290         MOVE WS-Y            TO WS-OLD-ACCT-FOUND-SW             
T10290     ELSE                                                         
T10290         IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
T10290             NEXT SENTENCE                                        
T10290         ELSE                                                     
T10290             MOVE 'CPD00308'             TO ABEND-PROGRAM         
T10290             MOVE '7100'                 TO ACTIVE-PARAGRAPH      
T34097             MOVE 'SELECT'               TO ABEND-FUNCTION        
T10290             MOVE 'CSS_CUST_PREM_HIST'   TO TABLE-1               
                   MOVE 'PREMISE_NO'           TO TABLE-ELEMENT-1       
                   MOVE  WS-PREMISE-NO         TO HOSTVAR-ELEMENT-1     
                   MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-2       
                   MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-3      
T10290             PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
T10290         END-IF                                                   
T10290     END-IF.                                                      
      *                                                                         
T34097 7100-SELECT-OLD-ACCOUNT-EXIT.                                    
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
T10290* 7130-SELECT-BILL-CYCLE                                         *        
T10290*     -- THIS MODULE GETS THE BILL CYCLE FROM THE PREVIOUS ACCT  *        
T10290*        WHICH HAD SERVICE AT THIS PREMISE (CURRENT ACCOUNT IS   *        
T10290*        PENDING.)                                               *        
      ******************************************************************        
T10290 7130-SELECT-BILL-CYCLE.                                          
      *                                                                         
T10290     EXEC SQL                                                     
T10290         SELECT   BILL_CYCLE                                      
T10290           INTO   :AT-BILL-CYCLE                                  
T10290           FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                       
T10290          WHERE   ACCOUNT_NO = :WS-OLD-ACCOUNT-NO                 
ACT041                                                           
ACT041                                                      
T10290     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT   BILL_CYCLE                                              
MFA-TR*          INTO   :AT-BILL-CYCLE                                          
MFA-TR*          FROM   CSS_ACCOUNT                                             
MFA-TR*         WHERE   ACCOUNT_NO = :WS-OLD-ACCOUNT-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7130                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
T10290     MOVE SQLCODE                   TO RS-RETURN-CODE.            
T10290     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
T10290     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T10290         NEXT SENTENCE                                            
T10290     ELSE                                                         
T10290         IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
T10290             MOVE '00'                  TO AT-BILL-CYCLE          
T10290         ELSE                                                     
T10290             MOVE 'CPD00308'            TO ABEND-PROGRAM          
T10290             MOVE '7130'                TO ACTIVE-PARAGRAPH       
T10290             MOVE 'SELECT'              TO ABEND-FUNCTION         
T10290             MOVE 'CSS_ACCOUNT'         TO TABLE-1                
T10290             MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
T10290             MOVE  WS-OLD-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1      
T10290             PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT       
T10290         END-IF                                                   
T10290     END-IF.                                                      
      *                                                                         
T10290 7130-SELECT-BILL-CYCLE-EXIT.                                     
T10290     EXIT.                                                        
A04243******************************************************************        
A04243*    7140-GET-CURRENT-DATE.                                               
A04243*                                                                         
A04243*    THIS PARA IS TO GET THE CURRENT DATE.                                
A04243******************************************************************        
A04243                                                                  
A04243 7140-GET-CURRENT-DATE.                                           
A04243                                                                  
A04243     EXEC SQL                                                     
A04243          SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-TEMP-ONLINE-DATE                 
A04243     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-TEMP-ONLINE-DATE = CURRENT DATE                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04243                                                                  
A04243     MOVE SQLCODE                   TO RS-RETURN-CODE.            
A04243     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
A04243*                                                                         
A04243     IF (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL)                 
A04243         NEXT SENTENCE                                            
A04243     ELSE                                                         
A04243         MOVE 'CPD00308'            TO ABEND-PROGRAM              
A04243         MOVE '7140'                TO ACTIVE-PARAGRAPH           
A04243         MOVE 'SET '                TO ABEND-FUNCTION             
A04243         MOVE SPACES                TO ABEND-SQL-PREDICATES       
A04243                                       ABEND-TABLES               
A04243         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
A04243     END-IF.                                                      
A04243 7140-GET-CURRENT-DATE-EXIT.                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-GET-CURRENT-DATE                                          *        
      *     -- THIS MODULE GETS THE CURRENT DATE FOR USE IN INSTANCES  *        
      *        WHEN THE PREMISE HAS NO PREVIOUS BILLING HISTORY.       *        
      ******************************************************************        
       7200-GET-CURRENT-DATE.                                           
      *                                                                         
           EXEC SQL                                                     
T34097         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-DATE-CWS00308                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-DATE-CWS00308 = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO RS-RETURN-CODE.            
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'CPD00308'            TO ABEND-PROGRAM              
               MOVE '7200'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
T34097         MOVE 'SET'                 TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CURRENT DATE'        TO TABLE-ELEMENT-1            
               MOVE  WS-DATE-CWS00308     TO HOSTVAR-ELEMENT-1          
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-GET-CURRENT-DATE-EXIT.                                      
           EXIT.                                                        
T23179*                                                                         
T23179******************************************************************        
T23179* 7300-SELECT-DELINQ-DEPOSIT-AMT.                                *        
T23179*     -- THIS MODULE GETS THE DEFAULT MIN/MAX DEPOSITS FROM      *        
T23179*        CSS_DELINQUENCY.                                        *        
T23179******************************************************************        
T23179 7300-SELECT-DELINQ-DEPOSIT-AMT.                                  
T23179*                                                                         
T23179     EXEC SQL                                                     
T23179         SELECT DELINQ_VALUE                                      
T23179           INTO :C8-DELINQ-VALUE                                  
T23179           FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
T23179          WHERE DELINQ_CD  = :C8-DELINQ-CD                        
T23179            AND COMPANY_NO = :C8-COMPANY-NO                       
ACT041                                                           
ACT041                                                      
T23179     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DELINQ_VALUE                                              
MFA-TR*          INTO :C8-DELINQ-VALUE                                          
MFA-TR*          FROM CSS_DELINQUENCY                                           
MFA-TR*         WHERE DELINQ_CD  = :C8-DELINQ-CD                                
MFA-TR*           AND COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T23179*                                                                         
T23179     MOVE SQLCODE                   TO RS-RETURN-CODE.            
T23179     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
T23179*                                                                         
T23179     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
T23179         NEXT SENTENCE                                            
T23179     ELSE                                                         
T23179         MOVE 'CPD00308'            TO ABEND-PROGRAM              
T23179         MOVE '7300'                TO ACTIVE-PARAGRAPH           
T23179         MOVE 'SELECT'              TO ABEND-FUNCTION             
T23179         MOVE 'CSS_DELINQUENCY'     TO TABLE-1                    
T23179         MOVE 'DELINQ_CD'           TO TABLE-ELEMENT-1            
T23179         MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2            
T23179         MOVE C8-DELINQ-CD          TO HOSTVAR-ELEMENT-1          
T23179         MOVE C8-COMPANY-NO         TO HOSTVAR-ELEMENT-2          
T23179         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
T23179     END-IF.                                                      
T23179*                                                                         
T23179 7300-SELECT-DELINQ-DEP-EXIT.                                     
T23179     EXIT.                                                        
C33201*                                                                         
C33201******************************************************************        
C33201* 7310-SELECT-REG-GROUP.                                         *        
C33201*     -- THIS MODULE GETS THE REG GROUP CD FOR SEB ACCOUNTS.     *        
C33201******************************************************************        
C33201 7310-SELECT-REG-GROUP.                                           
C33201*                                                                         
C33201     EXEC SQL                                                     
C33201         SELECT REG_GROUP_CD                                      
C33201               ,SENIOR_FL                                         
A05091               ,DHR_EXPIRATION_DT                                 
C33201           INTO :LR-REG-GROUP-CD                                  
C33201               ,:LR-SENIOR-FL                                     
A05091               ,:LR-DHR-EXPIRATION-DT :WS-DHR-EXPIRE-DT-NULL      
C33201           FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                     
C33201          WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                       
ACT041                                                           
ACT041                                                      
C33201     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REG_GROUP_CD                                              
MFA-TR*              ,SENIOR_FL                                                 
MFA-TR*              ,DHR_EXPIRATION_DT                                         
MFA-TR*          INTO :LR-REG-GROUP-CD                                          
MFA-TR*              ,:LR-SENIOR-FL                                             
MFA-TR*              ,:LR-DHR-EXPIRATION-DT :WS-DHR-EXPIRE-DT-NULL              
MFA-TR*          FROM CSS_REG_PROFILE                                           
MFA-TR*         WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7310                                                    
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33201*                                                                         
C33201     MOVE SQLCODE                   TO RS-RETURN-CODE.            
C33201     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
C33201*                                                                         
A05091         MOVE 'N' TO WS-DHR-ACCT-FL.                              
A05091     EVALUATE  WS-ACTIVE-RETURN-CODE                              
A05091         WHEN SUCCESSFUL-CALL                                     
A05091             MOVE 'N' TO WS-DREG-ACCT-FL                          
A5091A             IF WS-DHR-EXPIRE-DT-NULL = 0                         
A05091                 MOVE 'Y' TO WS-DHR-ACCT-FL                       
A05091             END-IF                                               
A05091         WHEN NOT-FOUND                                           
A05091             MOVE 'Y' TO WS-DREG-ACCT-FL                          
A05091         WHEN OTHER                                               
C33201             MOVE 'CPD00308'            TO ABEND-PROGRAM          
C33201             MOVE '7310'                TO ACTIVE-PARAGRAPH       
C33201             MOVE 'SELECT'              TO ABEND-FUNCTION         
C33201             MOVE 'CSS_REG_PROFILE'     TO TABLE-1                
C33201             MOVE 'ACCOUNT_NO '         TO TABLE-ELEMENT-1        
C33201             MOVE LR-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
C33201             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
C33201     END-EVALUATE.                                                
C33201*                                                                         
C33201 7310-SELECT-REG-GROUP-EXIT.                                      
C33201     EXIT.                                                        
C33201*                                                                         
C33201 7330-SELECT-GAS-ONLY.                                            
C33201*                                                                         
C33201     MOVE '7330'                        TO ACTIVE-PARAGRAPH.      
C33201*                                                                         
C33201     EXEC SQL                                                     
C33201         SELECT 'Y'                                               
C33201           INTO  :WS-GAS-ONLY-FL                                  
C33201           FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                    
C33201          WHERE COMPANY_NO   = :B1-COMPANY-NO                     
C33201            AND LOCAL_OFFICE = :B1-LOCAL-OFFICE                   
C33201            AND DISTRICT_NO  = :B1-DISTRICT-NO                    
ACT041                                                           
ACT041                                                      
C33201     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO  :WS-GAS-ONLY-FL                                          
MFA-TR*          FROM CSS_LOCAL_OFFICE                                          
MFA-TR*         WHERE COMPANY_NO   = :B1-COMPANY-NO                             
MFA-TR*           AND LOCAL_OFFICE = :B1-LOCAL-OFFICE                           
MFA-TR*           AND DISTRICT_NO  = :B1-DISTRICT-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7330                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T34114     MOVE SQLCODE                       TO RS-RETURN-CODE         
C33201     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
C33201                                                                  
C33201     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
C33201         CONTINUE                                                 
C33201     ELSE                                                         
C33201         MOVE SPACES                     TO ABEND-TABLES          
C33201         MOVE SPACES                     TO ABEND-SQL-PREDICATES  
C33201         MOVE 'CPD00308'                 TO ABEND-PROGRAM         
C33201         MOVE '7330'                     TO ACTIVE-PARAGRAPH      
C33201         MOVE 'SELECT'                   TO ABEND-FUNCTION        
C33201         MOVE 'CSS_LOCAL_OFFICE'         TO TABLE-1               
C33201         MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
C33201         MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
C33201         MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-2       
C33201         MOVE B1-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2     
C33201         MOVE 'DISTRICT_NO'              TO TABLE-ELEMENT-3       
C33201         MOVE B1-DISTRICT-NO             TO HOSTVAR-ELEMENT-3     
C33201         MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-4       
C33201         MOVE B1-COMPANY-NO              TO HOSTVAR-ELEMENT-4     
C33201         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
C33201     END-IF.                                                      
C33201*                                                                         
C33201 7330-SELECT-GAS-ONLY-EXIT.                                       
C33201     EXIT.                                                        
C33201*                                                                         
C33201 7340-CHECK-COMBO-LOCALOFF.                                       
C33201*                                                                         
C33201     MOVE '7340'                        TO ACTIVE-PARAGRAPH.      
C33201*                                                                         
C33201     EXEC SQL                                                     
C33201         SELECT TOP(1) 'Y'                                              
C33201         INTO :WS-GAS-ONLY-FL                                     
C33201         FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                   
C33201         WHERE UT.ACCOUNT_NO = :UT-ACCOUNT-NO                     
C33201           AND UT.CODE_UTIL_TYPE = 'G'                            
C33201           AND NOT EXISTS(                                        
C33201                   SELECT 'Y'                                     
C33201                     FROM CSS_UTIL_ENVRNMT UT1
                           WITH(READUNCOMMITTED)                    
C33201                    WHERE UT1.ACCOUNT_NO = UT.ACCOUNT_NO          
C33201                      AND UT1.CODE_UTIL_TYPE ='E')                
C33201                                            
ACT041                                                           
ACT041                                                      
C33201     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  'Y'                                                      
MFA-TR*        INTO :WS-GAS-ONLY-FL                                             
MFA-TR*        FROM CSS_UTIL_ENVRNMT UT                                         
MFA-TR*        WHERE UT.ACCOUNT_NO = :UT-ACCOUNT-NO                             
MFA-TR*          AND UT.CODE_UTIL_TYPE = 'G'                                    
MFA-TR*          AND NOT EXISTS(                                                
MFA-TR*                  SELECT 'Y'                                             
MFA-TR*                    FROM CSS_UTIL_ENVRNMT UT1                            
MFA-TR*                   WHERE UT1.ACCOUNT_NO = UT.ACCOUNT_NO                  
MFA-TR*                     AND UT1.CODE_UTIL_TYPE ='E')                        
MFA-TR*          FETCH FIRST 1 ROW ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7340                                                    
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T34114     MOVE SQLCODE                       TO RS-RETURN-CODE         
C33201     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
C33201                                                                  
C33201     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
C33201         CONTINUE                                                 
C33201     ELSE                                                         
C33201         MOVE SPACES                     TO ABEND-TABLES          
C33201         MOVE SPACES                     TO ABEND-SQL-PREDICATES  
C33201         MOVE 'CPD00308'                 TO ABEND-PROGRAM         
C33201         MOVE '7340'                     TO ACTIVE-PARAGRAPH      
C33201         MOVE 'SELECT'                   TO ABEND-FUNCTION        
C33201         MOVE 'CSS_UTIL_ENVRNMT '        TO TABLE-1               
C33201         MOVE 'CSS_UTIL_ENVRNMT '        TO TABLE-2               
C33201         MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
C33201         MOVE UT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
C33201         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
C33201     END-IF.                                                      
C33201*                                                                         
C33201 7340-CHECK-COMBO-LOCALOFF-EXIT.                                  
C33201     EXIT.                                                        
T34114*                                                                         
T34114 7400-PREVIOUS-ACCOUNT.                                           
T34114*                                                                         
T34114     MOVE '7400'                        TO ACTIVE-PARAGRAPH.      
T34114     EXEC SQL                                                     
T34114          SELECT TOP(1) CH.ACCOUNT_NO                                    
T34114                 INTO :CH-ACCOUNT-NO                              
T34114          FROM                                                    
T34114               CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)                
T34114          WHERE CH.PREMISE_NO        = :CH-PREMISE-NO             
A05073          ORDER BY  DATE_UTIL_SVC_STRT DESC                       
T34114                                            
ACT041                                                           
ACT041                                                      
T34114     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CH.ACCOUNT_NO                                            
MFA-TR*                INTO :CH-ACCOUNT-NO                                      
MFA-TR*         FROM                                                            
MFA-TR*              CSS_CUST_PREM_HIST CH                                      
MFA-TR*         WHERE CH.PREMISE_NO        = :CH-PREMISE-NO                     
MFA-TR*         ORDER BY  DATE_UTIL_SVC_STRT DESC                               
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T34114     MOVE SQLCODE                       TO RS-RETURN-CODE         
T34114     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
T34114                                                                  
T34114     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
T34114         CONTINUE                                                 
T34114     ELSE                                                         
T34114         MOVE SPACES                     TO ABEND-TABLES          
T34114         MOVE SPACES                     TO ABEND-SQL-PREDICATES  
T34114         MOVE 'CPD00308'                 TO ABEND-PROGRAM         
T34114         MOVE '7400'                     TO ACTIVE-PARAGRAPH      
T34114         MOVE 'SELECT'                   TO ABEND-FUNCTION        
T34114         MOVE 'CSS_CUST_PREM_HIST'       TO TABLE-1               
T34114         MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1       
T34114         MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2       
T34114         MOVE CH-PREMISE-NO              TO HOSTVAR-ELEMENT-1     
T34114         MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2     
T34114         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
T34114     END-IF.                                                      
T34114 7400-PREVIOUS-ACCOUNT-EXIT.                                      
T34114     EXIT.                                                        
A05091*                                                                         
A05091****************************************************************          
A05091*  SELECTS THE SEASONAL FLAG FOR SEB ACCOUNTS.                 *          
A05091****************************************************************          
A05091 7500-SEL-SEB-SEASNL-FL.                                          
A05091*                                                                         
A05091     MOVE '7500'                        TO ACTIVE-PARAGRAPH.      
A05091     EXEC SQL                                                     
A05091        SELECT  TA.SEASONAL_FL                                    
A05091          INTO :TA-SEASONAL-FL                                    
A05091          FROM  CSS_ACCT_MISC_INFO TA WITH(READUNCOMMITTED)               
A05091         WHERE  TA.ACCOUNT_NO       = :TA-ACCOUNT-NO              
A05091                                                           
A05091                                                      
A05091     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  TA.SEASONAL_FL                                            
MFA-TR*         INTO :TA-SEASONAL-FL                                            
MFA-TR*         FROM  CSS_ACCT_MISC_INFO TA                                     
MFA-TR*        WHERE  TA.ACCOUNT_NO       = :TA-ACCOUNT-NO                      
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05091*                                                                         
A05091     MOVE SQLCODE                       TO RS-RETURN-CODE         
A05091     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
A05091                                                                  
A05091     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05091         WHEN SUCCESSFUL-CALL                                     
A05091             CONTINUE                                             
A05091         WHEN NOT-FOUND                                           
A05091             MOVE 'N' TO TA-SEASONAL-FL                           
A05091         WHEN OTHER                                               
A05091             MOVE SPACES                 TO ABEND-TABLES          
A05091             MOVE SPACES                 TO ABEND-SQL-PREDICATES  
A05091             MOVE 'CPD00308'             TO ABEND-PROGRAM         
A05091             MOVE '7500'                 TO ACTIVE-PARAGRAPH      
A05091             MOVE 'SELECT'               TO ABEND-FUNCTION        
A05091             MOVE 'CSS_ACCT_MISC_INFO'   TO TABLE-1               
A05091             MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
A05091             MOVE TA-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
A05091             PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
A05091     END-EVALUATE.                                                
A05091 7500-SEL-SEB-SEASNL-FL-EXIT.                                     
A05091     EXIT.                                                        
