      *****************************************************************         
      **   CPD00226                                                  **         
      *****************************************************************         
      *****************************************************************         
      ** This copybook is used by Service Orders while posting the   **         
      ** CX for Meter Change or Toff for SEB accounts.               **         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **              --------------------------                     **         
      **    DATE    INITIALS   REASON                                **         
      **  --------  --------   ------                                **         
      **  02/21/10  SS97726    Copybook Originally Written.          **         
      *****************************************************************         
      *                                                                         
       5961-CPD226-NEW-BG-MAIN.                                         
      *FOR SEB ACCOUNTS CHECK IF A NEW BG NEEDS TO BE CREATED.                  
           IF SEB-DATABASE                                              
              MOVE +0                          TO CWS226-HOLD-DAYS      
              PERFORM 5964-CPD226-SUM-CX       THRU 5964-CPD226-EXIT    
              IF CWS226-HOLD-DAYS > 0                                   
                 COMPUTE CWS226-HOLD-DAYS = CWS226-HOLD-DAYS            
                                          + CX-NO-DAYS                  
                 IF CWS226-HOLD-DAYS > 45                               
                    PERFORM 8862-INSERT-BILLING-DETAIL                  
                       THRU 8862-EXIT                                   
      *PUT ACCOUNT ON HOLD                                                      
                    MOVE CWS226-HOLD-NO-READ   TO AT-CODE-ACCT-BILLED   
                    PERFORM 5969-CPD226-REPL-CODE-BILLED                
                       THRU 5969-CPD226-EXIT                            
      *UPDATE EXEMPT CODES ON AT TABLE                                          
                    PERFORM 5962-CPD226-EXEMPT-ACCOUNT                  
                       THRU 5962-CPD226-EXIT                            
      *GENERATE WARNING WQ                                                      
                    MOVE CWS226-MSG-BG-CREATED TO WS-WQ-MESSAGE         
                    MOVE 17                    TO WS-CATEGORY-ID        
                    MOVE '4'                   TO WS-ROUTING-CATEGORY   
                    PERFORM 5910-CREATE-WORKQ  THRU 5910-EXIT           
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5961-CPD226-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * EXEMPT ACCOUNT FOR 3 MONTHS TO AVOID CREDIT ACTION.           *         
      *****************************************************************         
       5962-CPD226-EXEMPT-ACCOUNT.                                      
      *                                                                         
           MOVE SPACES                     TO CWS226-XMT-CODES          
                                              CWS226-XMT-SWITCHES.      
           IF AT-CODE-DISC-OK  = SPACES OR                              
              AT-CODE-DISC-OK IS NUMERIC                                
              IF AT-CODE-DISC-OK < '3'                                  
                 MOVE 'Y'                  TO CWS226-DISC-OK-CHG        
                 MOVE AT-CODE-DISC-OK      TO CWS226-CODE-DISC-OK       
                 MOVE '3'                  TO AT-CODE-DISC-OK           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF AT-NOTICE-EXEMPT-CD  = SPACES OR                          
              AT-NOTICE-EXEMPT-CD IS NUMERIC                            
              IF AT-NOTICE-EXEMPT-CD < '3'                              
                 MOVE 'Y'                  TO CWS226-EXEMPT-CD-CHG      
                 MOVE AT-NOTICE-EXEMPT-CD  TO CWS226-NOTICE-EXEMPT-CD   
                 MOVE '3'                  TO AT-NOTICE-EXEMPT-CD       
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF AT-CODE-LPC-XMT  = SPACES OR                              
              AT-CODE-LPC-XMT IS NUMERIC                                
              IF AT-CODE-LPC-XMT < '3'                                  
                 MOVE 'Y'                  TO CWS226-LPC-XMT-CHG        
                 MOVE AT-CODE-LPC-XMT      TO CWS226-CODE-LPC-XMT       
                 MOVE '3'                  TO AT-CODE-LPC-XMT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF AT-IVR-EXEMPT-CD  = SPACES OR                             
              AT-IVR-EXEMPT-CD IS NUMERIC                               
              IF AT-IVR-EXEMPT-CD < '3'                                 
                 MOVE 'Y'                  TO CWS226-IVR-EXEMPT-CHG     
                 MOVE AT-IVR-EXEMPT-CD     TO CWS226-IVR-EXEMPT-CD      
                 MOVE '3'                  TO AT-IVR-EXEMPT-CD          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF CWS226-DISC-OK-CHG    = 'Y' OR                            
              CWS226-EXEMPT-CD-CHG  = 'Y' OR                            
              CWS226-LPC-XMT-CHG    = 'Y' OR                            
              CWS226-IVR-EXEMPT-CHG = 'Y'                               
              PERFORM 5963-CPD226-LOAD-TRAN-HIST THRU 5963-CPD226-EXIT  
              PERFORM 5965-CPD226-UPD-AT-XMT     THRU 5965-CPD226-EXIT  
           END-IF.                                                      
      *                                                                         
       5962-CPD226-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * LOAD TRANSACTION HISTORY HEADER AND DETAILS.                  *         
      *****************************************************************         
       5963-CPD226-LOAD-TRAN-HIST.                                      
      *                                                                         
           MOVE BG-BILL-ITEM-TIMESTMP      TO MH-TRANS-HIST-SEQ-NO.     
           MOVE WS-TODAYS-DATE             TO MH-DATE-TRANS.            
           MOVE 'F'                        TO MH-CODE-TRAN-TYPE.        
           MOVE '437'                      TO MH-RESP-AREA-ID.          
           MOVE BG-ACCOUNT-NO              TO MH-ACCOUNT-NO.            
           MOVE ZEROS                      TO MH-CUSTOMER-NO.           
           MOVE ZEROS                      TO MH-PREMISE-NO.            
           MOVE 'SYSTEM '                  TO MH-USER-ID.               
           MOVE PROGRAM-NAME               TO MH-APPL-PROGRAM-ID.       
           STRING 'ACCOUNT EXEMPT CODES UPDATED' DELIMITED BY SIZE      
                                         INTO MH-TRAN-COMMENT-TEXT      
           MOVE +28                        TO MH-TRAN-COMMENT-LEN.      
           MOVE ZEROS                      TO CWS226-TRAN-APPL-NO.      
      *LOAD MNT TRANSACTION HISTORY DETAILS                                     
           IF CWS226-DISC-OK-CHG = 'Y'                                  
              MOVE BG-BILL-ITEM-TIMESTMP   TO MI-TRANS-HIST-SEQ-NO      
              ADD 1                        TO CWS226-TRAN-APPL-NO       
              MOVE CWS226-TRAN-APPL-NO     TO MI-TRAN-APPL-NO           
              MOVE 'DISCONNECT CODE'       TO MI-COLUMN-DESC            
              IF CWS226-CODE-DISC-OK > SPACE                            
                 MOVE 24                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE CWS226-CODE-DISC-OK  TO CWS226-MSG-MONTHS         
                 MOVE CWS226-MSG-LITERAL   TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE SPACES               TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 24                      TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE '3'                     TO CWS226-MSG-MONTHS         
              MOVE CWS226-MSG-LITERAL      TO MI-CHG-COLUMN-VALUE-TEXT  
              MOVE SPACES                  TO MI-TABLE-ID               
              IF CWS226-TRAN-APPL-NO = 1                                
                 PERFORM 5966-CPD226-ISRT-TRNS-HST THRU 5966-CPD226-EXIT
              END-IF                                                    
              PERFORM 5967-CPD226-ISRT-MT-TRN-DET  THRU 5967-CPD226-EXIT
           END-IF.                                                      
      *                                                                         
           IF CWS226-EXEMPT-CD-CHG = 'Y'                                
              MOVE BG-BILL-ITEM-TIMESTMP   TO MI-TRANS-HIST-SEQ-NO      
              ADD 1                        TO CWS226-TRAN-APPL-NO       
              MOVE CWS226-TRAN-APPL-NO     TO MI-TRAN-APPL-NO           
              MOVE 'NOTICE XMT CODE'       TO MI-COLUMN-DESC            
              IF CWS226-NOTICE-EXEMPT-CD > SPACE                        
                 MOVE 24                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE CWS226-NOTICE-EXEMPT-CD                           
                                           TO CWS226-MSG-MONTHS         
                 MOVE CWS226-MSG-LITERAL   TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE SPACES               TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 24                      TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE '3'                     TO CWS226-MSG-MONTHS         
              MOVE CWS226-MSG-LITERAL      TO MI-CHG-COLUMN-VALUE-TEXT  
              MOVE SPACES                  TO MI-TABLE-ID               
              IF CWS226-TRAN-APPL-NO = 1                                
                 PERFORM 5966-CPD226-ISRT-TRNS-HST THRU 5966-CPD226-EXIT
              END-IF                                                    
              PERFORM 5967-CPD226-ISRT-MT-TRN-DET  THRU 5967-CPD226-EXIT
           END-IF.                                                      
      *                                                                         
           IF CWS226-LPC-XMT-CHG = 'Y'                                  
              MOVE BG-BILL-ITEM-TIMESTMP   TO MI-TRANS-HIST-SEQ-NO      
              ADD 1                        TO CWS226-TRAN-APPL-NO       
              MOVE CWS226-TRAN-APPL-NO     TO MI-TRAN-APPL-NO           
              MOVE 'LPC EXEMPT CODE'       TO MI-COLUMN-DESC            
              IF CWS226-CODE-LPC-XMT > SPACE                            
                 MOVE 24                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE CWS226-CODE-LPC-XMT  TO CWS226-MSG-MONTHS         
                 MOVE CWS226-MSG-LITERAL   TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE SPACES               TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 24                      TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE '3'                     TO CWS226-MSG-MONTHS         
              MOVE CWS226-MSG-LITERAL      TO MI-CHG-COLUMN-VALUE-TEXT  
              MOVE SPACES                  TO MI-TABLE-ID               
              IF CWS226-TRAN-APPL-NO = 1                                
                 PERFORM 5966-CPD226-ISRT-TRNS-HST THRU 5966-CPD226-EXIT
              END-IF                                                    
              PERFORM 5967-CPD226-ISRT-MT-TRN-DET  THRU 5967-CPD226-EXIT
           END-IF.                                                      
      *                                                                         
           IF CWS226-IVR-EXEMPT-CHG = 'Y'                               
              MOVE BG-BILL-ITEM-TIMESTMP   TO MI-TRANS-HIST-SEQ-NO      
              ADD 1                        TO CWS226-TRAN-APPL-NO       
              MOVE CWS226-TRAN-APPL-NO     TO MI-TRAN-APPL-NO           
              MOVE 'IVR EXEMPT CODE'       TO MI-COLUMN-DESC            
              IF CWS226-IVR-EXEMPT-CD > SPACE                           
                 MOVE 24                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE CWS226-IVR-EXEMPT-CD TO CWS226-MSG-MONTHS         
                 MOVE CWS226-MSG-LITERAL   TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE SPACES               TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 24                      TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE '3'                     TO CWS226-MSG-MONTHS         
              MOVE CWS226-MSG-LITERAL      TO MI-CHG-COLUMN-VALUE-TEXT  
              MOVE SPACES                  TO MI-TABLE-ID               
              IF CWS226-TRAN-APPL-NO = 1                                
                 PERFORM 5966-CPD226-ISRT-TRNS-HST THRU 5966-CPD226-EXIT
              END-IF                                                    
              PERFORM 5967-CPD226-ISRT-MT-TRN-DET  THRU 5967-CPD226-EXIT
           END-IF.                                                      
      *                                                                         
       5963-CPD226-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * SUM UP NO OF DAYS FOR EXISTING CX ROWS FOR A PARTICULAR BILL_NO*        
      ******************************************************************        
       5964-CPD226-SUM-CX.                                              
      *                                                                         
           MOVE '5964'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           EXEC SQL                                                     
               SELECT SUM(CX.NO_DAYS)                                   
                 INTO :CWS226-HOLD-DAYS :CWS226-NULL-IND                 
                 FROM CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                 
                WHERE CX.ACCOUNT_NO         = :CX-ACCOUNT-NO            
                  AND CX.BILL_NO            = :CX-BILL-NO               
                  AND CX.CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE        
                  AND CX.IC_NO              = :CX-IC-NO                 
                  AND CX.MTR_REF_NO         = :CX-MTR-REF-NO            
                  AND CX.REG_ID_NO          = :CX-REG-ID-NO             
                  AND CX.CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD      
                  AND CX.CODE_USAGE_TYPE    = :CX-CODE-USAGE-TYPE       
                  AND CX.CODE_USAGE_ID      = :CX-CODE-USAGE-ID         
                  AND CX.CODE_USAGE_SOURCE  = :CX-CODE-USAGE-SOURCE     
                  AND CX.BILL_ITEM_TIMESTMP IN                          
                     (SELECT BILL_ITEM_TIMESTMP                         
                        FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)           
                       WHERE BG.ACCOUNT_NO         = CX.ACCOUNT_NO      
                         AND BG.BILL_NO            = CX.BILL_NO         
                         AND BG.CODE_UTIL_TYPE     = CX.CODE_UTIL_TYPE  
                         AND BG.IC_NO              = CX.IC_NO           
                         AND BG.CODE_BILL_CALC     = 'A'                
                         AND BG.CODE_BILL_ITM_TYPE = 'C'                
                         AND BG.CODE_BILL_ITM_IND  = 'A'                
                         AND BG.DATE_ORIG_BILL     IS NULL              
                         AND BG.REV_MTH_ORIG_BILL  = 0)                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(CX.NO_DAYS)                                           
MFA-TR*          INTO :CWS226-HOLD-DAYS:CWS226-NULL-IND                         
MFA-TR*          FROM CSS_CNSMPTN_HIST CX                                       
MFA-TR*         WHERE CX.ACCOUNT_NO         = :CX-ACCOUNT-NO                    
MFA-TR*           AND CX.BILL_NO            = :CX-BILL-NO                       
MFA-TR*           AND CX.CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE                
MFA-TR*           AND CX.IC_NO              = :CX-IC-NO                         
MFA-TR*           AND CX.MTR_REF_NO         = :CX-MTR-REF-NO                    
MFA-TR*           AND CX.REG_ID_NO          = :CX-REG-ID-NO                     
MFA-TR*           AND CX.CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD              
MFA-TR*           AND CX.CODE_USAGE_TYPE    = :CX-CODE-USAGE-TYPE               
MFA-TR*           AND CX.CODE_USAGE_ID      = :CX-CODE-USAGE-ID                 
MFA-TR*           AND CX.CODE_USAGE_SOURCE  = :CX-CODE-USAGE-SOURCE             
MFA-TR*           AND CX.BILL_ITEM_TIMESTMP IN                                  
MFA-TR*              (SELECT BILL_ITEM_TIMESTMP                                 
MFA-TR*                 FROM CSS_BILLING_DET BG                                 
MFA-TR*                WHERE BG.ACCOUNT_NO         = CX.ACCOUNT_NO              
MFA-TR*                  AND BG.BILL_NO            = CX.BILL_NO                 
MFA-TR*                  AND BG.CODE_UTIL_TYPE     = CX.CODE_UTIL_TYPE          
MFA-TR*                  AND BG.IC_NO              = CX.IC_NO                   
MFA-TR*                  AND BG.CODE_BILL_CALC     = 'A'                        
MFA-TR*                  AND BG.CODE_BILL_ITM_TYPE = 'C'                        
MFA-TR*                  AND BG.CODE_BILL_ITM_IND  = 'A'                        
MFA-TR*                  AND BG.DATE_ORIG_BILL     IS NULL                      
MFA-TR*                  AND BG.REV_MTH_ORIG_BILL  = 0)                         
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF CWS226-NULL-IND < 0                                    
                 MOVE +0                   TO CWS226-HOLD-DAYS          
              ELSE                                                      
                 NEXT SENTENCE                                          
              END-IF                                                    
           ELSE                                                         
              MOVE 'CSS_CNSMPTN_HIST'      TO CMN-TABLE-1               
              MOVE 'ACCOUNT-NO'            TO CMN-TABLE-ELEMENT-1       
              MOVE 'BILL_NO'               TO CMN-TABLE-ELEMENT-2       
              MOVE 'CODE_UTIL_TYPE'        TO CMN-TABLE-ELEMENT-3       
              MOVE 'IC_NO'                 TO CMN-TABLE-ELEMENT-4       
              MOVE CX-ACCOUNT-NO           TO CMN-HOSTVAR-ELEMENT-1     
              MOVE CX-BILL-NO              TO CMN-HOSTVAR-ELEMENT-2     
              MOVE CX-CODE-UTIL-TYPE       TO CMN-HOSTVAR-ELEMENT-3     
              MOVE CX-IC-NO                TO CMN-HOSTVAR-ELEMENT-4     
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       5964-CPD226-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      * UPDATE EXEMPT CODES ON ACCOUNT TABLE                       *            
      **************************************************************            
       5965-CPD226-UPD-AT-XMT.                                          
      *                                                                         
           MOVE '5965'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET CODE_LPC_XMT     = :AT-CODE-LPC-XMT               
                     ,NOTICE_EXEMPT_CD = :AT-NOTICE-EXEMPT-CD           
                     ,CODE_DISC_OK     = :AT-CODE-DISC-OK               
                     ,IVR_EXEMPT_CD    = :AT-IVR-EXEMPT-CD              
                WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_ACCOUNT'           TO CMN-TABLE-1               
              MOVE 'ACCOUNT-NO'            TO CMN-TABLE-ELEMENT-1       
              MOVE AT-ACCOUNT-NO           TO CMN-HOSTVAR-ELEMENT-1     
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       5965-CPD226-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *   INSERT TRANSACTION HISTORY HEADER                          *          
      ****************************************************************          
       5966-CPD226-ISRT-TRNS-HST.                                       
      *                                                                         
           MOVE '5966'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MNT_TRANS_HIST                           
                 ( TRANS_HIST_SEQ_NO, DATE_TRANS,                       
                   CODE_TRAN_TYPE,    RESP_AREA_ID,                     
                   ACCOUNT_NO,                                          
                   CUSTOMER_NO,       PREMISE_NO,                       
                   USER_ID,           APPL_PROGRAM_ID,                  
                   TRAN_COMMENT)                                        
               VALUES                                                   
                 ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO), 
              IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),               
                   :MH-CODE-TRAN-TYPE,    :MH-RESP-AREA-ID,             
                   :MH-ACCOUNT-NO,                                      
                   :MH-CUSTOMER-NO,       :MH-PREMISE-NO,               
                   :MH-USER-ID,           :MH-APPL-PROGRAM-ID,          
                   :MH-TRAN-COMMENT)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MNT_TRANS_HIST                                   
MFA-TR*          ( TRANS_HIST_SEQ_NO, DATE_TRANS,                               
MFA-TR*            CODE_TRAN_TYPE,    RESP_AREA_ID,                             
MFA-TR*            ACCOUNT_NO,                                                  
MFA-TR*            CUSTOMER_NO,       PREMISE_NO,                               
MFA-TR*            USER_ID,           APPL_PROGRAM_ID,                          
MFA-TR*            TRAN_COMMENT)                                                
MFA-TR*        VALUES                                                           
MFA-TR*          ( :MH-TRANS-HIST-SEQ-NO, :MH-DATE-TRANS,                       
MFA-TR*            :MH-CODE-TRAN-TYPE,    :MH-RESP-AREA-ID,                     
MFA-TR*            :MH-ACCOUNT-NO,                                              
MFA-TR*            :MH-CUSTOMER-NO,       :MH-PREMISE-NO,                       
MFA-TR*            :MH-USER-ID,           :MH-APPL-PROGRAM-ID,                  
MFA-TR*            :MH-TRAN-COMMENT)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_MNT_TRANS_HIST'    TO CMN-TABLE-1               
              MOVE 'ACCOUNT-NO'            TO CMN-TABLE-ELEMENT-1       
              MOVE 'CUSTOMER-NO'           TO CMN-TABLE-ELEMENT-2       
              MOVE 'PREMISE-NO'            TO CMN-TABLE-ELEMENT-3       
              MOVE 'DATE-TRANS'            TO CMN-TABLE-ELEMENT-4       
              MOVE MH-ACCOUNT-NO           TO CMN-HOSTVAR-ELEMENT-1     
              MOVE MH-CUSTOMER-NO          TO CMN-HOSTVAR-ELEMENT-2     
              MOVE MH-PREMISE-NO           TO CMN-HOSTVAR-ELEMENT-3     
              MOVE MH-DATE-TRANS           TO CMN-HOSTVAR-ELEMENT-4     
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       5966-CPD226-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  INSERT TRANSACTION HISTORY DETAIL                         **          
      ****************************************************************          
       5967-CPD226-ISRT-MT-TRN-DET.                                     
      *                                                                         
           MOVE '5967'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MT_TRN_HST_DET                           
                 ( TRANS_HIST_SEQ_NO, TRAN_APPL_NO,                     
                   COLUMN_DESC,       PRV_COLUMN_VALUE,                 
                   CHG_COLUMN_VALUE,                                    
                   TABLE_ID)                                            
               VALUES                                                   
                 ( CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO), 
                                                      :MI-TRAN-APPL-NO,        
                   :MI-COLUMN-DESC,       :MI-PRV-COLUMN-VALUE,         
                   :MI-CHG-COLUMN-VALUE,                                
                   :MI-TABLE-ID)                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MT_TRN_HST_DET                                   
MFA-TR*          ( TRANS_HIST_SEQ_NO, TRAN_APPL_NO,                             
MFA-TR*            COLUMN_DESC,       PRV_COLUMN_VALUE,                         
MFA-TR*            CHG_COLUMN_VALUE,                                            
MFA-TR*            TABLE_ID)                                                    
MFA-TR*        VALUES                                                           
MFA-TR*          ( :MI-TRANS-HIST-SEQ-NO, :MI-TRAN-APPL-NO,                     
MFA-TR*            :MI-COLUMN-DESC,       :MI-PRV-COLUMN-VALUE,                 
MFA-TR*            :MI-CHG-COLUMN-VALUE,                                        
MFA-TR*            :MI-TABLE-ID)                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_MT_TRN_HST_DET'    TO CMN-TABLE-1               
              MOVE 'TRANS-HIST-SEQ-NO'     TO CMN-TABLE-ELEMENT-1       
              MOVE 'TRAN-APPL-NO'          TO CMN-TABLE-ELEMENT-2       
              MOVE 'COLUMN-DESC'           TO CMN-TABLE-ELEMENT-3       
              MOVE 'ACCOUNT-NO'            TO CMN-TABLE-ELEMENT-4       
              MOVE MI-TRANS-HIST-SEQ-NO    TO CMN-HOSTVAR-ELEMENT-1     
              MOVE MI-TRAN-APPL-NO         TO CMN-HOSTVAR-ELEMENT-2     
              MOVE MI-COLUMN-DESC          TO CMN-HOSTVAR-ELEMENT-3     
              MOVE MH-ACCOUNT-NO           TO CMN-HOSTVAR-ELEMENT-4     
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       5967-CPD226-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      * UPDATE CODE_ACCT_BILLED ON ACCOUNT TABLE                   *            
      **************************************************************            
       5969-CPD226-REPL-CODE-BILLED.                                    
      *                                                                         
           MOVE '5969'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET CODE_ACCT_BILLED = :AT-CODE-ACCT-BILLED            
               WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 'CSS_ACCOUNT'           TO CMN-TABLE-1               
              MOVE 'ACCOUNT-NO'            TO CMN-TABLE-ELEMENT-1       
              MOVE AT-ACCOUNT-NO           TO CMN-HOSTVAR-ELEMENT-1     
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       5969-CPD226-EXIT.                                                
           EXIT.                                                        
      *                                                                         
