      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **                                                            **          
      **  THIS PROGRAM WILL CALCULATE TOTAL BBP CHARGES FOR          **         
      **  ACTIVE BBP ACCOUNT                                         **         
      **                                                             **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE          INITIALS  REASON                            **         
      *    ----          --------  ------                            **         
      *    01/04/16      MS7M727   CREATE NEW COPYBOOK               **         
      *                                                              **         
      *****************************************************************         
                                                                        
      ******************************************************************        
      ** 4000B-CALC-TOTAL-BBP-CHRG                                              
      ******************************************************************        
      *                                                                         
       4000B-CALC-TOTAL-BBP-CHRG.                                       
      *                                                                         
           INITIALIZE WS-GL-NAME-TABLE                                  
                      WS-HOLD-DATA.                                     
                                                                        
           MOVE WS-CA168-ACCOUNT-NO      TO BH-ACCOUNT-NO               
                                            AR-ACCOUNT-NO               
                                            UT-ACCOUNT-NO.              
                                                                        
                                                                        
           MOVE 'DATABASE'               TO C8-DELINQ-CD.               
           MOVE '01'                     TO C8-COMPANY-NO.              
                                                                        
           PERFORM 7018B-GET-DATABASE       THRU 7018B-EXIT.            
                                                                        
           MOVE C8-DELINQ-VALUE          TO LS-DATABASE.                
                                                                        
           IF SEB-DATABASE                                              
              PERFORM 7019B-GET-RATE-PLAN-NO THRU 7019B-EXIT            
              MOVE UT-RATE-PLAN-NO       TO WS-RATE-PLAN-TYPES          
           END-IF.                                                      
      *                                                                         
                                                                        
           PERFORM 7020B-GET-ACCOUNT-DETAIL THRU 7020B-EXIT.            
      *                                                                         
           MOVE AT-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT.      
           MOVE AT-DATE-BILL-DAY-00      TO WS-DATE-TRANS-SEARCH.       
           MOVE AT-REV-MTH-LST-NRML      TO WS-REV-MTH-LST-NRML-AT.     
           MOVE WS-REV-MTH-LST-NRML-AT                                  
                                         TO WS-REV-MONTH-HOLD.          
           MOVE WS-REV-MONTH-HOLD-CCYY                                  
                                         TO WS-FORMAT-EPP-YR.           
           EVALUATE WS-REV-MONTH-HOLD-MM                                
               WHEN '04'                                                
               WHEN '06'                                                
               WHEN '09'                                                
               WHEN '11'                                                
                   MOVE '30'             TO WS-FORMAT-EPP-DAY           
               WHEN '02'                                                
                   MOVE '28'             TO WS-FORMAT-EPP-DAY           
               WHEN OTHER                                               
                   MOVE '31'             TO WS-FORMAT-EPP-DAY           
           END-EVALUATE.                                                
      *                                                                         
           MOVE WS-REV-MONTH-HOLD-MM     TO WS-FORMAT-EPP-MO.           
           MOVE WS-FORMAT-EPP-DATE       TO BH-DATE-PYMT-STRT.          
      *                                                                         
           PERFORM 7022B-GET-BBP-START-DATE THRU 7022B-EXIT             
                                                                        
           IF BBP-CHARGE-CONTINUE                                       
      *                                                                         
              MOVE BH-BALANCE-FORWARD    TO WS-BALANCE-BROUGHT-FORWARD  
              MOVE BH-DATE-PYMT-STRT     TO WS-DATE-TRANS-SEARCH        
                                            WS-PLAN-PREV-START-DATE     
              MOVE BH-DATE-PYMT-STRT (1:4)                              
                                         TO WS-REV-MONTH-HOLD-CCYY      
              MOVE BH-DATE-PYMT-STRT (6:2)                              
                                         TO WS-REV-MONTH-HOLD-MM        
              PERFORM 4010B-PROCESS-BBP-CHARGE   THRU 4010B-EXIT        
                                                                        
              PERFORM 7024B-GET-BBP-TRANS-BALANCE                       
                                                 THRU 7024B-EXIT        
              IF WS-NULL-IND-2  < ZERO                                  
                 MOVE ZERO               TO AC-AMT-TRAN-BALANCE         
              END-IF                                                    
                                                                        
              MOVE AC-AMT-TRAN-BALANCE   TO WS-BBP-TRAN-BALANCE         
                                                                        
              PERFORM 7025B-GET-NON-BBP-TRAN-BALAN                      
                                                 THRU 7025B-EXIT        
              IF WS-NULL-IND-2  < ZERO                                  
                 MOVE ZERO               TO AC-AMT-TRAN-BALANCE         
              END-IF                                                    
                                                                        
              MOVE AC-AMT-TRAN-BALANCE   TO WS-NON-BBP-TRAN-BALANCE     
                                                                        
              PERFORM 7026B-GET-OTHER-CHARGES-BAL                       
                                                 THRU 7026B-EXIT        
              IF WS-NULL-IND-2  < ZERO                                  
                 MOVE ZERO               TO AC-AMT-TRAN-BALANCE         
              END-IF                                                    
                                                                        
              MOVE AC-AMT-TRAN-BALANCE   TO WS-OTHER-CHARG-BAL          
                                                                        
              PERFORM 7027B-GET-CURR-BBP-PAYMENT THRU 7027B-EXIT        
                                                                        
              IF WS-NULL-IND-2  < ZERO                                  
                 MOVE ZERO               TO AU-AMT-POSTED               
              END-IF                                                    
                                                                        
              MOVE AU-AMT-POSTED         TO WS-CURR-AMT-POSTED          
                                                                        
              PERFORM 4080B-CALC-ANNUAL-ADJ      THRU 4080B-EXIT        
                                                                        
           END-IF.                                                      
                                                                        
      *                                                                         
       4000B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 4010B-PROCESS-BBP-CHARGE                                               
      ******************************************************************        
      *                                                                         
       4010B-PROCESS-BBP-CHARGE.                                        
      *                                                                         
           MOVE WS-REV-MONTH-HOLD        TO BG-REVENUE-MONTH            
           MOVE WS-CA168-ACCOUNT-NO      TO BG-ACCOUNT-NO               
                                            AC-ACCOUNT-NO               
           MOVE 50                       TO AC-PYMT-PRIORITY-LVL        
                                                                        
           PERFORM 7023B-GET-BILL-NO        THRU 7023B-EXIT             
                                                                        
           MOVE BI-DATE-BILLED           TO WS-DATE-TRANS-SEARCH        
                                                                        
                                                                        
           PERFORM 7016B-GET-PREV-SEQ-NO    THRU 7016B-EXIT             
      *                                                                         
           MOVE AR-AMT-BILLED-UNPAID     TO WS-PREV-BILL-UNPAID         
           MOVE AR-TRANS-HIST-SEQ-NO     TO WS-PREV-SEQ-NO              
                                                                        
           PERFORM 7017B-GET-CURR-SEQ-NO    THRU 7017B-EXIT             
           MOVE AR-TRANS-HIST-SEQ-NO     TO WS-CURR-SEQ-NO              
      *                                                                         
           MOVE 12                       TO WS-HOLD-SUB.                
      *                                                                         
           PERFORM 7010B-OPEN-AR-TRANSHIST  THRU 7010B-EXIT.            
                                                                        
           PERFORM 7011B-FETCH-AR-TRANSHIST THRU 7011B-EXIT.            
                                                                        
           PERFORM 4020B-PROCESS-AR-TRANSHIST THRU 4020B-EXIT           
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.               
                                                                        
           PERFORM 7012B-CLOSE-AR-TRANSHIST THRU 7012B-EXIT.            
      *                                                                         
           MOVE WS-REV-MTH-LST-NRML-AT   TO WS-CURR-REV-MONTH.          
           MOVE WS-CURR-REV-MONTH        TO WS-BILL-CYCLE-MM.           
           MOVE WS-CURR-REV-MONTH        TO WS-BILL-CYCLE-MMCCYY.       
                                                                        
           COMPUTE WS-HOLD-SUB =                                        
                   12 - WS-HOLD-COUNT + 1.                              
                                                                        
           PERFORM UNTIL WS-HOLD-SUB > 12                               
                                                                        
               MOVE WS-BILL-CYCLE-MM    TO WS-HOLD-BILL-MM (WS-HOLD-SUB)
               MOVE WS-BILL-CYCLE-MMCCYY                                
                                      TO WS-HOLD-BILL-MMYY (WS-HOLD-SUB)
               SUBTRACT 1 FROM WS-BILL-CYCLE-MM                         
               MOVE WS-BILL-CYCLE-MM     TO WS-BILL-CYC-MM              
                                                                        
               IF WS-BILL-CYC-YY = 0 AND WS-BILL-CYCLE-MM = 0           
                  MOVE 99                TO WS-BILL-CYC-YY              
                  SUBTRACT 1 FROM WS-BILL-CYC-CC                        
               END-IF                                                   
                                                                        
               IF WS-BILL-CYCLE-MM = 0                                  
                   MOVE 12               TO WS-BILL-CYCLE-MM            
                   SUBTRACT 1 FROM WS-BILL-CYC-YY                       
                   MOVE 12               TO WS-BILL-CYC-MM              
               END-IF                                                   
               ADD 1                     TO WS-HOLD-SUB                 
           END-PERFORM.                                                 
                                                                        
           MOVE 1                        TO WS-HOLD-SUB.                
                                                                        
           IF WS-AMT-EPP-CIA-HOLD NOT EQUAL ZERO                        
              COMPUTE WS-AMT-EPP-CIA-HOLD = WS-AMT-EPP-CIA-HOLD * -1    
           END-IF.                                                      
                                                                        
           PERFORM VARYING WS-HOLD-SUB FROM 1 BY 1 UNTIL                
                                                   WS-HOLD-SUB > 12     
               IF WS-HOLD-BILL-MM (WS-HOLD-SUB) > SPACES                
                   IF WS-HOLD-SETUP (WS-HOLD-SUB) = 'X'                 
                       MOVE WS-HOLD-ORIG (WS-HOLD-SUB) TO               
                            WS-HOLD-TOTAL (WS-HOLD-SUB)                 
                   ELSE                                                 
                       IF WS-HOLD-EPP (WS-HOLD-SUB) = 0.00              
                           COMPUTE WS-HOLD-TOTAL (WS-HOLD-SUB) =        
                                  (WS-HOLD-ORIG (WS-HOLD-SUB) -         
                                   WS-AMT-EPP-CIA-HOLD) +               
                                   WS-HOLD-UTIL (WS-HOLD-SUB) -         
                                   WS-AMT-EPP-ADJ-HOLD                  
                       ELSE                                             
                           COMPUTE WS-HOLD-TOTAL (WS-HOLD-SUB) =        
                                  (WS-HOLD-ORIG (WS-HOLD-SUB) -         
                                   WS-HOLD-EPP (WS-HOLD-SUB)) +         
                                   WS-HOLD-UTIL (WS-HOLD-SUB) -         
                                   WS-AMT-EPP-ADJ-HOLD                  
                       END-IF                                           
                   END-IF                                               
                   ADD  WS-HOLD-TOTAL (WS-HOLD-SUB) TO                  
                                               WS-TOTAL-BBP-CHARGE      
                   ADD  WS-HOLD-PYMT (WS-HOLD-SUB)  TO WS-BBP-PAYMENT   
                   MOVE 0.00 TO WS-AMT-EPP-ADJ-HOLD                     
                   INITIALIZE WS-AMT-EPP-CIA-HOLD                       
               END-IF                                                   
           END-PERFORM.                                                 
      *                                                                         
       4010B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 4020B-PROCESS-AR-TRANSHIST                                             
      ******************************************************************        
      *                                                                         
       4020B-PROCESS-AR-TRANSHIST.                                      
      *                                                                         
           IF AR-RECORD-ONLY-FL = 'Y'                                   
               MOVE AR-AMT-BILLED-UNPAID    TO WS-PREV-BILL-UNPAID      
           ELSE                                                         
              IF AR-APPL-PROGRAM-ID = 'PANEL147C' AND                   
                 AR-CODE-TRAN-TYPE = 'D'                                
                 MOVE AR-AMT-BILLED-UNPAID  TO WS-PREV-BILL-UNPAID      
              ELSE                                                      
                 PERFORM 4025B-EVAL-AR-CODE-TRAN-TYPE                   
                                               THRU 4025B-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM  7011B-FETCH-AR-TRANSHIST   THRU 7011B-EXIT.         
      *                                                                         
       4020B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 4025B-EVAL-AR-CODE-TRAN-TYPE                                           
      ******************************************************************        
      *                                                                         
       4025B-EVAL-AR-CODE-TRAN-TYPE.                                    
                                                                        
           EVALUATE AR-CODE-TRAN-TYPE                                   
               WHEN 'B'                                                 
                 IF AR-APPL-PROGRAM-ID = 'PCSCA10R'                     
                    IF WS-HOLD-SUB < 12                                 
                        ADD 1 TO WS-HOLD-SUB                            
                       IF  WS-CODE-PRE-PAY-PLAN = 'A'                   
                          COMPUTE WS-HOLD-PYMT-SUB = WS-HOLD-SUB - 1    
                          COMPUTE WS-HOLD-PYMT (WS-HOLD-SUB) =          
                               WS-HOLD-PYMT (WS-HOLD-SUB) +             
                               WS-HOLD-PYMT (WS-HOLD-PYMT-SUB)          
                          MOVE 0 TO WS-HOLD-PYMT (WS-HOLD-PYMT-SUB)     
                       END-IF                                           
                     END-IF                                             
      ************* IF C\R BACK TO THE PREVIOUS EPP-SUB ROW AND ADD             
      ************* TO IT INSTEAD OF CREATING A NEW ROW.                        
                   ELSE                                                 
                       ADD 1 TO WS-HOLD-COUNT                           
                       IF WS-HOLD-SUB < 1                               
                           MOVE 1 TO WS-HOLD-SUB                        
                           MOVE 12 TO WS-HOLD-COUNT                     
                           IF SEB-DATABASE AND 1RATE                    
                              CONTINUE                                  
                           ELSE                                         
      ************** WS-HOLD-SUB HAS GONE OUT-OF-BOUNDS.                        
                              MOVE -1               TO SQLCODE          
                                                   WS-ACTIVE-RETURN-CODE
                              MOVE 'CPD00168'       TO ABEND-PROGRAM    
                              MOVE '4025B'          TO ACTIVE-PARAGRAPH 
                              MOVE SQLCODE          TO ABEND-SQLCODE    
                              MOVE 'ARRAY'          TO ABEND-FUNCTION   
                              MOVE 'OUT OF BOUNDS'  TO TABLE-1          
                              MOVE 'BPP EXCEPTION'  TO TABLE-ELEMENT-1  
                              MOVE 'WS-HOLD-SUB'                        
                                                    TO HOSTVAR-ELEMENT-1
                              PERFORM 9700-PROCESS-ABEND                
                                                   THRU 9700-EXIT       
                           END-IF                                       
                       END-IF                                           
                       MOVE AR-AMT-ORIG-ENTERED     TO                  
                            WS-HOLD-ORIG (WS-HOLD-SUB)                  
                   END-IF                                               
                   PERFORM 4030B-AR-TRANSHIST-DETAIL THRU 4030B-EXIT    
                   SUBTRACT 1 FROM WS-HOLD-SUB                          
               MOVE AR-AMT-BILLED-UNPAID    TO WS-PREV-BILL-UNPAID      
               WHEN 'P'                                                 
                   IF AR-AMT-BILLED-UNPAID NOT = WS-PREV-BILL-UNPAID    
                       IF WS-CODE-PRE-PAY-PLAN = 'A'                    
                          COMPUTE WS-HOLD-PYMT-SUB = WS-HOLD-SUB        
                       ELSE                                             
                          COMPUTE WS-HOLD-PYMT-SUB = WS-HOLD-SUB + 1    
                       END-IF                                           
                       IF WS-HOLD-PYMT-SUB < 13                         
                           COMPUTE WS-HOLD-PYMT (WS-HOLD-PYMT-SUB) =    
                               WS-HOLD-PYMT (WS-HOLD-PYMT-SUB) -        
                               AR-AMT-ORIG-ENTERED                      
                       END-IF                                           
                   END-IF                                               
               MOVE AR-AMT-BILLED-UNPAID     TO WS-PREV-BILL-UNPAID     
               WHEN 'A'                                                 
                   IF AR-APPL-PROGRAM-ID = 'PANEL147'  OR               
                                           'PANEL147C' OR               
                                           'PANEL147D'                  
                       COMPUTE WS-HOLD-AMT-SUB =                        
                               WS-HOLD-SUB + 1                          
                       IF WS-HOLD-AMT-SUB < 13                          
                           MOVE AR-AMT-ORIG-ENTERED TO                  
                                WS-HOLD-EPP (WS-HOLD-AMT-SUB)           
                           MOVE 'X' TO                                  
                                WS-HOLD-SETUP (WS-HOLD-AMT-SUB)         
                       END-IF                                           
                   ELSE                                                 
                     IF SEB-DATABASE                                    
                       IF AR-AMT-BILLED-UNPAID NOT = WS-PREV-BILL-UNPAID
                         AND AR-APPL-PROGRAM-ID = 'SCSCA112A'           
                         IF WS-CODE-PRE-PAY-PLAN = 'A'                  
                            COMPUTE WS-HOLD-PYMT-SUB = WS-HOLD-SUB      
                         ELSE                                           
                            COMPUTE WS-HOLD-PYMT-SUB = WS-HOLD-SUB + 1  
                         END-IF                                         
                         IF WS-HOLD-PYMT-SUB < 13                       
                             COMPUTE WS-HOLD-PYMT (WS-HOLD-PYMT-SUB) =  
                                 WS-HOLD-PYMT (WS-HOLD-PYMT-SUB) -      
                                 AR-AMT-BILLED-UNPAID                   
                         END-IF                                         
                       END-IF                                           
                     END-IF                                             
                   END-IF                                               
              MOVE AR-AMT-BILLED-UNPAID     TO WS-PREV-BILL-UNPAID      
              WHEN OTHER                                                
                   IF AR-AMT-BILLED-UNPAID NOT = WS-PREV-BILL-UNPAID    
                       IF WS-CODE-PRE-PAY-PLAN = 'A'                    
                          COMPUTE WS-HOLD-PYMT-SUB = WS-HOLD-SUB        
                       ELSE                                             
                          COMPUTE WS-HOLD-PYMT-SUB = WS-HOLD-SUB + 1    
                       END-IF                                           
                       IF WS-HOLD-PYMT-SUB < 13                         
                           IF AR-AMT-BILLED-UNPAID >                    
                                            WS-PREV-BILL-UNPAID         
                           COMPUTE WS-HOLD-PYMT (WS-HOLD-PYMT-SUB) =    
                               WS-HOLD-PYMT (WS-HOLD-PYMT-SUB) +        
                               AR-AMT-ORIG-ENTERED                      
                           ELSE                                         
                           COMPUTE WS-HOLD-PYMT (WS-HOLD-PYMT-SUB) =    
                               WS-HOLD-PYMT (WS-HOLD-PYMT-SUB) -        
                               AR-AMT-ORIG-ENTERED                      
                           END-IF                                       
                       END-IF                                           
                   END-IF                                               
                   MOVE AR-AMT-BILLED-UNPAID TO WS-PREV-BILL-UNPAID     
                   END-EVALUATE.                                        
      *                                                                         
       4025B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 4030B-AR-TRANSHIST-DETAIL                                              
      ******************************************************************        
      *                                                                         
       4030B-AR-TRANSHIST-DETAIL.                                       
                                                                        
           MOVE AR-ACCOUNT-NO            TO AU-ACCOUNT-NO.              
           MOVE AR-TRANS-HIST-SEQ-NO     TO AU-TRANS-HIST-SEQ-NO.       
                                                                        
           PERFORM 7013B-OPEN-AR-TRANS-DET  THRU 7013B-EXIT.            
           PERFORM 7014B-FETCH-AR-TRANS-DET THRU 7014B-EXIT.            
                                                                        
           PERFORM 4040B-PRCS-AR-TRANS-DET  THRU 4040B-EXIT             
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.               
                                                                        
           PERFORM 7015B-CLOSE-AR-TRANS-DET THRU 7015B-EXIT.            
                                                                        
       4030B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      ** 4040B-PRCS-AR-TRANS-DET                                                
      ******************************************************************        
      *                                                                         
       4040B-PRCS-AR-TRANS-DET.                                         
      *                                                                         
                                                                        
           IF AU-CODE-AR-AGE = 'A'                                      
              CONTINUE                                                  
           ELSE                                                         
      * WE HAVE THE GL NUMBERS FROM THE DATABASE.  TRANSLATE THEM               
      * INTO THE CORRECT MNEMONICS.                                             
              MOVE SPACES  TO  WS-GL-DEBIT-NAME WS-GL-CREDIT-NAME       
              MOVE SPACES  TO  WS-GL-DEBIT-CLASS  WS-GL-CREDIT-CLASS    
              MOVE AU-GL-ACCT-DEBIT         TO WS-HOLD-GL-ACCT          
              PERFORM 4050B-SERCH-GL-DETAIL    THRU 4050B-EXIT          
              MOVE WS-HOLD-GL-NAME          TO WS-GL-DEBIT-NAME         
              MOVE WS-HOLD-GL-CLASS         TO WS-GL-DEBIT-CLASS        
                                                                        
              IF WS-GL-MATCH NOT = 'Y'                                  
                 CONTINUE                                               
              ELSE                                                      
                 MOVE ' '                   TO WS-GL-MATCH              
                 MOVE 1                     TO WS-GL-SUB1               
                 MOVE AU-GL-ACCT-CREDIT     TO WS-HOLD-GL-ACCT          
                 PERFORM 4050B-SERCH-GL-DETAIL THRU 4050B-EXIT          
                 MOVE WS-HOLD-GL-NAME       TO WS-GL-CREDIT-NAME        
                 MOVE WS-HOLD-GL-CLASS      TO WS-GL-CREDIT-CLASS       
                                                                        
                 IF WS-GL-MATCH NOT = 'Y'                               
                    CONTINUE                                            
      * IGNORE DETAIL RECORDS THAT DO NOT HAVE AN A/R ACCOUNT AS                
      * EITHER THE DEBIT OR CREDIT.                                             
                 ELSE                                                   
                    MOVE 'N'                TO WS-CREDIT-AR-SW          
                                               WS-DEBIT-AR-SW           
                    MOVE WS-GL-CREDIT-NAME  TO WS-CHECK-GL-ACCT         
                    IF WS-AR-ACCOUNT                                    
                       MOVE 'Y'             TO WS-CREDIT-AR-SW          
                    END-IF                                              
                                                                        
                    MOVE WS-GL-DEBIT-NAME   TO WS-CHECK-GL-ACCT         
                                                                        
                    IF WS-AR-ACCOUNT                                    
                        MOVE 'Y'            TO WS-DEBIT-AR-SW           
                    END-IF                                              
                                                                        
                    IF WS-CREDIT-AR-SW = 'Y' OR WS-DEBIT-AR-SW = 'Y'    
                       IF AR-APPL-PROGRAM-ID = 'PCSCA10R'               
                          SUBTRACT AU-AMT-POSTED                        
                                    FROM WS-HOLD-CIA-AMT (WS-HOLD-SUB)  
                       ELSE                                             
                          ADD  AU-AMT-POSTED TO                         
                               WS-HOLD-CIA-AMT(WS-HOLD-SUB)             
                       END-IF                                           
                                                                        
                       PERFORM 4060B-PROCESS-GL-CREDIT-DEBIT            
                                                 THRU 4060B-EXIT        
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 7014B-FETCH-AR-TRANS-DET      THRU 7014B-EXIT.       
      *                                                                         
                                                                        
       4040B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 4050B-SERCH-GL-DETAIL                                                  
      *****************************************************************         
      *                                                                         
       4050B-SERCH-GL-DETAIL.                                           
      *                                                                         
           MOVE ' '                      TO WS-GL-MATCH                 
           MOVE 1                        TO WS-GL-SUB1                  
           PERFORM UNTIL WS-GL-ACCT (WS-GL-SUB1) = 0.0000               
                          OR WS-GL-MATCH  = 'Y'                         
             IF WS-GL-ACCT (WS-GL-SUB1) = WS-HOLD-GL-ACCT               
                MOVE WS-GL-NAME (WS-GL-SUB1)      TO WS-HOLD-GL-NAME    
                MOVE WS-GL-ACCT-CLASS(WS-GL-SUB1) TO WS-HOLD-GL-CLASS   
                MOVE 'Y'                 TO WS-GL-MATCH                 
             END-IF                                                     
             ADD  1                      TO WS-GL-SUB1                  
           END-PERFORM.                                                 
      *                                                                         
           IF WS-GL-MATCH  NOT = 'Y'                                    
              MOVE WS-HOLD-GL-ACCT       TO GO-GL-ACCT-NO               
              MOVE 'N'                   TO WS-GL-MATCH                 
              PERFORM 7021B-GET-GL-DETAIL           THRU 7021B-EXIT     
              IF WS-GL-MATCH = 'Y'                                      
                 PERFORM 4070B-LOAD-GL-DETAIL       THRU 4070B-EXIT     
                 MOVE WS-GL-NAME (WS-GL-SUB1)      TO WS-HOLD-GL-NAME   
                 MOVE WS-GL-ACCT-CLASS(WS-GL-SUB1) TO WS-HOLD-GL-CLASS  
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       4050B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      ** 4060B-PROCESS-GL-CREDIT-DEBIT                                          
      *****************************************************************         
      *                                                                         
       4060B-PROCESS-GL-CREDIT-DEBIT.                                   
      *                                                                         
      * EVALUATE THE DEBIT GL ACCOUNTS.                                         
                                                                        
           EVALUATE WS-GL-DEBIT-NAME                                    
               WHEN 'AR-UTE'                                            
               WHEN 'AR-UTG'                                            
                   ADD AU-AMT-POSTED     TO WS-HOLD-UTIL (WS-HOLD-SUB)  
               WHEN 'AR-BUD'                                            
                   IF WS-GL-CREDIT-NAME = 'AR-BUD'                      
                       MOVE AU-AMT-POSTED TO WS-HOLD-EPP (WS-HOLD-SUB)  
                   END-IF                                               
                   IF WS-GL-CREDIT-NAME = 'AR-CIA'                      
                       MOVE 'Y'       TO WS-HOLD-CIA-FLAG (WS-HOLD-SUB) 
                       SUBTRACT AU-AMT-POSTED FROM                      
                                WS-HOLD-CIA-AMT (WS-HOLD-SUB)           
                       ADD  AU-AMT-POSTED TO  WS-AMT-EPP-CIA-HOLD       
                   END-IF                                               
                   MOVE WS-GL-CREDIT-NAME  TO WS-CHECK-GL-ACCT          
                   IF AU-CODE-AR-AGE = ' ' AND                          
                      WS-GL-CREDIT-CLASS = '4' OR '5'                   
                          ADD AU-AMT-POSTED TO                          
                              WS-HOLD-UTIL (WS-HOLD-SUB)                
                   END-IF                                               
           END-EVALUATE                                                 
      ***********************************************************               
           EVALUATE WS-GL-CREDIT-NAME                                   
               WHEN 'AR-UTE'                                            
               WHEN 'AR-UTG'                                            
                   SUBTRACT AU-AMT-POSTED FROM                          
                                          WS-HOLD-UTIL (WS-HOLD-SUB)    
               WHEN 'AR-BUD'                                            
                   IF WS-GL-DEBIT-NAME = 'AR-BUD'                       
                       MOVE AU-AMT-POSTED TO WS-HOLD-EPP (WS-HOLD-SUB)  
                   END-IF                                               
                   IF WS-GL-DEBIT-NAME = 'AR-CIA'                       
                       MOVE 'Y' TO WS-HOLD-CIA-FLAG (WS-HOLD-SUB)       
                       ADD  AU-AMT-POSTED TO                            
                                WS-HOLD-CIA-AMT (WS-HOLD-SUB)           
                   END-IF                                               
                   IF AU-CODE-AR-AGE = ' ' AND                          
                      WS-GL-DEBIT-CLASS = '4' OR '5'                    
                          SUBTRACT AU-AMT-POSTED FROM                   
                              WS-HOLD-UTIL (WS-HOLD-SUB)                
                   END-IF                                               
           END-EVALUATE.                                                
      *                                                                         
       4060B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 4070B-LOAD-GL-DETAIL                                                    
      ******************************************************************        
      *                                                                         
       4070B-LOAD-GL-DETAIL.                                            
      *                                                                         
            MOVE GO-GL-ACCT-NAME         TO WS-GL-NAME (WS-GL-SUB1).    
            MOVE GO-GL-ACCT-NAME-DESC    TO WS-GL-DESC (WS-GL-SUB1).    
            MOVE GO-GL-ACCT-NO           TO WS-GL-ACCT (WS-GL-SUB1).    
            MOVE GO-GL-ACCT-CLASS       TO WS-GL-ACCT-CLASS(WS-GL-SUB1).
      *                                                                         
       4070B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 4080B-CALC-ANNUAL-ADJ                                                   
      ******************************************************************        
      *                                                                         
       4080B-CALC-ANNUAL-ADJ.                                           
      *                                                                         
           COMPUTE WS-TRAN-BALANCE = WS-BBP-TRAN-BALANCE                
                                     + WS-NON-BBP-TRAN-BALANCE          
                                     + WS-CURR-AMT-POSTED               
                                     + WS-OTHER-CHARG-BAL.              
                                                                        
           COMPUTE WS-ANNUAL-ADJ = WS-TRAN-BALANCE                      
                                   - WS-TOTAL-BBP-CHARGE                
                                   - WS-BBP-PAYMENT.                    
                                                                        
           COMPUTE WS-TOTAL-BBP-CHARGE =  WS-TOTAL-BBP-CHARGE           
                                         + WS-ANNUAL-ADJ.               
      *                                                                         
       4080B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7010B-OPEN-AR-TRANSHIST                                                
      ******************************************************************        
      *                                                                         
       7010B-OPEN-AR-TRANSHIST.                                         
                                                                        
      *                                                                         
           EXEC SQL                                                     
               OPEN GET_TRANS_HIST                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 'CPD00168'            TO ABEND-PROGRAM               
              MOVE '7010B'               TO ACTIVE-PARAGRAPH            
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'GET_TRANS_HIST'      TO TABLE-1                     
              MOVE 'CURSOR'              TO TABLE-ELEMENT-1             
              MOVE 'GET_TRANS_HIST'      TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7010B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7011B-FETCH-AR-TRANSHIST                                               
      ******************************************************************        
      *                                                                         
       7011B-FETCH-AR-TRANSHIST.                                        
                                                                        
           EXEC SQL                                                     
               FETCH GET_TRANS_HIST INTO                                
                    :AR-TRANS-HIST-SEQ-NO,                              
                    :AR-DATE-TRANS :WS-NULL-IND-1,                      
                    :AR-CODE-TRAN-TYPE,                                 
                    :AR-AMT-ORIG-ENTERED,                               
                    :AR-AMT-BILLED-UNPAID,                              
                    :AR-RECORD-ONLY-FL,                                 
                    :AR-APPL-PROGRAM-ID,                                
                    :AR-USER-ID                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE 'CPD00168'       TO ABEND-PROGRAM               
                   MOVE '7011B'          TO ACTIVE-PARAGRAPH            
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_AR_TRANS_HIST' TO TABLE-1                  
                   MOVE 'ACCOUNT NO'     TO TABLE-ELEMENT-1             
                   MOVE AR-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
                                                                        
       7011B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7012B-CLOSE-AR-TRANSHIST                                               
      ******************************************************************        
      *                                                                         
       7012B-CLOSE-AR-TRANSHIST.                                        
      *                                                                         
           EXEC SQL                                                     
               CLOSE GET_TRANS_HIST                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 'CPD00168'            TO ABEND-PROGRAM               
              MOVE '7012B'               TO ACTIVE-PARAGRAPH            
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'GET_TRANS_HIST'      TO TABLE-1                     
              MOVE 'CURSOR'              TO TABLE-ELEMENT-1             
              MOVE 'GET_TRANS_HIST'      TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7012B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * EXTRACT AR TRANS HIST DET FOR BILLED ROW.                               
      ******************************************************************        
      *                                                                         
       7013B-OPEN-AR-TRANS-DET.                                         
      *                                                                         
           EXEC SQL                                                     
               OPEN AR_TRN_HST_DET                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 'CPD00168'            TO ABEND-PROGRAM               
              MOVE '7013B'               TO ACTIVE-PARAGRAPH            
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'AR_TRN_HST_DET'      TO TABLE-1                     
              MOVE 'CURSOR'              TO TABLE-ELEMENT-1             
              MOVE 'AR_TRN_HST_DET'      TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7013B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * FETCH AR TRANS HIST DET FOR BILLED ROW.                                 
      ******************************************************************        
      *                                                                         
       7014B-FETCH-AR-TRANS-DET.                                        
      *                                                                         
           EXEC SQL                                                     
               FETCH AR_TRN_HST_DET                                     
                INTO :AU-TRAN-APPL-NO,                                  
                     :AU-CODE-AR-AGE,                                   
                     :AU-GL-ACCT-CREDIT,                                
                     :AU-GL-ACCT-DEBIT,                                 
                     :AU-AMT-POSTED,                                    
                     :AU-ITEM-ID,                                       
                     :AU-CODE-CONTRACT-TYPE,                            
                     :AU-CURRENCY-TYPE,                                 
                     :AU-CURRENCY-AMT                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'CPD00168'            TO ABEND-PROGRAM               
              MOVE '7014B'               TO ACTIVE-PARAGRAPH            
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_TRN_HST_DET'                                 
                                         TO TABLE-1                     
              MOVE 'ACCOUNT NO'          TO TABLE-ELEMENT-1             
              MOVE AU-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'TIME_HIST_SEQ_NO'    TO TABLE-ELEMENT-2             
              MOVE AU-TRANS-HIST-SEQ-NO  TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7014B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CLOSE AR TRANS HIST DET FOR BILLED ROW.                                 
      ******************************************************************        
      *                                                                         
       7015B-CLOSE-AR-TRANS-DET.                                        
      *                                                                         
           EXEC SQL                                                     
               CLOSE AR_TRN_HST_DET                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE 'CPD00168'            TO ABEND-PROGRAM               
              MOVE '7015B'               TO ACTIVE-PARAGRAPH            
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'AR_TRN_HST_DET'      TO TABLE-1                     
              MOVE 'CURSOR'              TO TABLE-ELEMENT-1             
              MOVE 'AR_TRN_HST_DET'      TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7015B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7016B-GET-PREV-SEQ-NO                                                  
      ******************************************************************        
      *                                                                         
       7016B-GET-PREV-SEQ-NO.                                           
                                                                        
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,
              DATE_TRANS,
              CODE_TRAN_TYPE,
              AMT_BILLED_UNPAID                                
                 INTO :AR-TRANS-HIST-SEQ-NO,                            
                      :AR-DATE-TRANS :WS-NULL-IND-1,                    
                      :AR-CODE-TRAN-TYPE,                               
                      :AR-AMT-BILLED-UNPAID                             
                  FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                  
                 WHERE ACCOUNT_NO       = :WS-CA168-ACCOUNT-NO          
                   AND DATE_TRANS      >= IIF(TRY_CONVERT(DATE, 
                                                  :WS-DATE-TRANS-SEARCH
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-TRANS-SEARCH
              ) <> 0) OR (LEN(:WS-DATE-TRANS-SEARCH
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-TRANS-SEARCH
              ), CONVERT(DATE, :WS-DATE-TRANS-SEARCH) )         
                   AND APPL_PROGRAM_ID <>  'PCSCA10R'                   
                   AND CODE_TRAN_TYPE   = 'B'                           
                 ORDER BY TRANS_HIST_SEQ_NO ASC                         
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT TRANS_HIST_SEQ_NO,                                       
MFA-TR*                DATE_TRANS,                                              
MFA-TR*                CODE_TRAN_TYPE,                                          
MFA-TR*                AMT_BILLED_UNPAID                                        
MFA-TR*          INTO :AR-TRANS-HIST-SEQ-NO,                                    
MFA-TR*               :AR-DATE-TRANS :WS-NULL-IND-1,                            
MFA-TR*               :AR-CODE-TRAN-TYPE,                                       
MFA-TR*               :AR-AMT-BILLED-UNPAID                                     
MFA-TR*           FROM CSS_AR_TRANS_HIST                                        
MFA-TR*          WHERE ACCOUNT_NO       = :WS-CA168-ACCOUNT-NO                  
MFA-TR*            AND DATE_TRANS      >= :WS-DATE-TRANS-SEARCH                 
MFA-TR*            AND APPL_PROGRAM_ID <>  'PCSCA10R'                           
MFA-TR*            AND CODE_TRAN_TYPE   = 'B'                                   
MFA-TR*          ORDER BY TRANS_HIST_SEQ_NO ASC                                 
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE 'CPD00168'       TO ABEND-PROGRAM               
                   MOVE '7016B'          TO ACTIVE-PARAGRAPH            
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_AR_TRANS_HIST' TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE  AR-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7016B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7017B-GET-CURR-SEQ-NO                                                  
      ******************************************************************        
      *                                                                         
       7017B-GET-CURR-SEQ-NO.                                           
                                                                        
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO                                
                 INTO :AR-TRANS-HIST-SEQ-NO                             
                  FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                  
                 WHERE ACCOUNT_NO       = :WS-CA168-ACCOUNT-NO          
                   AND DATE_TRANS      >= IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-BILL-DAY-00
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-00
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-00
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-00
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-00) )          
                   AND APPL_PROGRAM_ID <>  'PCSCA10R'                   
                   AND CODE_TRAN_TYPE   = 'B'                           
                 ORDER BY TRANS_HIST_SEQ_NO DESC                        
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT TRANS_HIST_SEQ_NO                                        
MFA-TR*          INTO :AR-TRANS-HIST-SEQ-NO                                     
MFA-TR*           FROM CSS_AR_TRANS_HIST                                        
MFA-TR*          WHERE ACCOUNT_NO       = :WS-CA168-ACCOUNT-NO                  
MFA-TR*            AND DATE_TRANS      >= :AT-DATE-BILL-DAY-00                  
MFA-TR*            AND APPL_PROGRAM_ID <>  'PCSCA10R'                           
MFA-TR*            AND CODE_TRAN_TYPE   = 'B'                                   
MFA-TR*          ORDER BY TRANS_HIST_SEQ_NO DESC                                
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE 'CPD00168'       TO ABEND-PROGRAM               
                   MOVE '7017B'          TO ACTIVE-PARAGRAPH            
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_AR_TRANS_HIST' TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE  AR-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7017B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7018B-GET-DATABASE                                                     
      ******************************************************************        
      *                                                                         
       7018B-GET-DATABASE.                                              
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) DELINQ_VALUE                                     
                  INTO :C8-DELINQ-VALUE                                 
                  FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                    
                 WHERE DELINQ_CD = :C8-DELINQ-CD                        
                   AND COMPANY_NO = :C8-COMPANY-NO                      
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DELINQ_VALUE                                             
MFA-TR*           INTO :C8-DELINQ-VALUE                                         
MFA-TR*           FROM CSS_DELINQUENCY                                          
MFA-TR*          WHERE DELINQ_CD = :C8-DELINQ-CD                                
MFA-TR*            AND COMPANY_NO = :C8-COMPANY-NO                              
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE 'CPD00168'       TO ABEND-PROGRAM               
                   MOVE '7018B'          TO ACTIVE-PARAGRAPH            
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ CODE'    TO TABLE-ELEMENT-1             
                   MOVE C8-DELINQ-CD     TO HOSTVAR-ELEMENT-1           
                   MOVE 'COMPANY NO'     TO TABLE-ELEMENT-1             
                   MOVE C8-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT     
           END-EVALUATE.                                                
      *                                                                         
       7018B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7019B GET-RATE-PLAN-NO                                                 
      ******************************************************************        
      *                                                                         
       7019B-GET-RATE-PLAN-NO.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) RATE_PLAN_NO                                      
                INTO :UT-RATE-PLAN-NO                                   
                FROM  CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
               WHERE  ACCOUNT_NO = :UT-ACCOUNT-NO                       
                AND   IC_NO      = 1                                    
                AND   CODE_UTIL_TYPE ='G'                               
                                                    
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  RATE_PLAN_NO                                              
MFA-TR*         INTO :UT-RATE-PLAN-NO                                           
MFA-TR*         FROM  CSS_UTIL_ENVRNMT                                          
MFA-TR*        WHERE  ACCOUNT_NO = :UT-ACCOUNT-NO                               
MFA-TR*         AND   IC_NO      = 1                                            
MFA-TR*         AND   CODE_UTIL_TYPE ='G'                                       
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE 'CPD00168'       TO ABEND-PROGRAM               
                   MOVE '7019B'          TO ACTIVE-PARAGRAPH            
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT NO'     TO TABLE-ELEMENT-1             
                   MOVE UT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
      *                                                                         
       7019B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 7020B-GET-ACCOUNT-DETAIL                                               
      ******************************************************************        
      *                                                                         
       7020B-GET-ACCOUNT-DETAIL.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) DATE_BILL_DAY_00,
              REV_MTH_LST_NRML,
              CODES_DATA_PRESENT                                
                INTO :AT-DATE-BILL-DAY-00                               
                    ,:AT-REV-MTH-LST-NRML                               
                    ,:AT-CODES-DATA-PRESENT                             
                FROM  CSS_ACCOUNT WITH(READUNCOMMITTED)                         
               WHERE  ACCOUNT_NO = :WS-CA168-ACCOUNT-NO                 
                                                   
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DATE_BILL_DAY_00                                          
MFA-TR*              ,REV_MTH_LST_NRML                                          
MFA-TR*              ,CODES_DATA_PRESENT                                        
MFA-TR*         INTO :AT-DATE-BILL-DAY-00                                       
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-CODES-DATA-PRESENT                                     
MFA-TR*         FROM  CSS_ACCOUNT                                               
MFA-TR*        WHERE  ACCOUNT_NO = :WS-CA168-ACCOUNT-NO                         
MFA-TR*        FETCH  FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE 'CPD00168'       TO ABEND-PROGRAM               
                   MOVE '7020B'          TO ACTIVE-PARAGRAPH            
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'ACCOUNT NO'     TO TABLE-ELEMENT-1             
                   MOVE WS-CA168-ACCOUNT-NO TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT     
           END-EVALUATE.                                                
      *                                                                         
       7020B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7021B-GET-GL-DETAIL                                                     
      ******************************************************************        
      *                                                                         
       7021B-GET-GL-DETAIL.                                             
      *                                                                         
           EXEC SQL                                                     
                   SELECT TOP(1) GL_ACCT_NAME,
              GL_ACCT_NAME_DESC,
              GL_ACCT_NO,
              GL_ACCT_CLASS                                 
                    INTO :GO-GL-ACCT-NAME,                              
                         :GO-GL-ACCT-NAME-DESC,                         
                         :GO-GL-ACCT-NO,                                
                         :GO-GL-ACCT-CLASS                              
                   FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                    
                   WHERE  GL_ACCT_NO = :GO-GL-ACCT-NO                   
                                                   
                                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*            SELECT GL_ACCT_NAME,                                         
MFA-TR*                   GL_ACCT_NAME_DESC,                                    
MFA-TR*                   GL_ACCT_NO,                                           
MFA-TR*                   GL_ACCT_CLASS                                         
MFA-TR*             INTO :GO-GL-ACCT-NAME,                                      
MFA-TR*                  :GO-GL-ACCT-NAME-DESC,                                 
MFA-TR*                  :GO-GL-ACCT-NO,                                        
MFA-TR*                  :GO-GL-ACCT-CLASS                                      
MFA-TR*            FROM CSS_GL_ACCT_NO                                          
MFA-TR*            WHERE  GL_ACCT_NO = :GO-GL-ACCT-NO                           
MFA-TR*            FETCH  FIRST ROW ONLY                                        
MFA-TR*             WITH  UR                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL OR NOT-FOUND     
              IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL               
                 MOVE 'Y'                TO WS-GL-MATCH                 
              END-IF                                                    
           ELSE                                                         
              MOVE 'CPD00168'            TO ABEND-PROGRAM               
              MOVE '7021B'               TO ACTIVE-PARAGRAPH            
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_GL_ACCT_NO'      TO TABLE-1                     
              MOVE 'ACCOUNT NO'          TO TABLE-ELEMENT-1             
              MOVE WS-CA168-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
       7021B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** 7022B-GET-BBP-START-DATE                                               
      ******************************************************************        
      *                                                                         
       7022B-GET-BBP-START-DATE.                                        
                                                                        
      *                                                                         
           EXEC SQL                                                     
                 SELECT TOP(1) DATE_PYMT_STRT,
              BALANCE_FORWARD,
              REPLACE(REPLACE(CONVERT(CHAR(26), BUD_HIST_SEQ_NO, 121), 
           ' ', '-'), ':', '.') BUD_HIST_SEQ_NO,
              CHANGE_REASON                                   
                  INTO :BH-DATE-PYMT-STRT,                              
                       :BH-BALANCE-FORWARD,                             
                       :BH-BUD-HIST-SEQ-NO,                             
                       :BH-CHANGE-REASON                                
                   FROM CSS_BUDGET_HIST WITH(READUNCOMMITTED)                   
                  WHERE ACCOUNT_NO = :BH-ACCOUNT-NO                     
                    AND PYMT_PRIORITY_LVL = 50                          
                    AND CHANGE_REASON IN ('A','S','H')                  
                    AND DATE_PYMT_STRT <= IIF(TRY_CONVERT(DATE, 
                                                     :BH-DATE-PYMT-STRT
              ) IS NULL OR (PATINDEX('%.%', :BH-DATE-PYMT-STRT
              ) <> 0) OR (LEN(:BH-DATE-PYMT-STRT
              ) <> 10), CIS.CHAR2DATE(:BH-DATE-PYMT-STRT
              ), CONVERT(DATE, :BH-DATE-PYMT-STRT) )            
               ORDER BY BUD_HIST_SEQ_NO DESC,                           
                        DATE_PYMT_STRT DESC                             
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT DATE_PYMT_STRT,                                         
MFA-TR*                 BALANCE_FORWARD,                                        
MFA-TR*                 BUD_HIST_SEQ_NO,                                        
MFA-TR*                 CHANGE_REASON                                           
MFA-TR*           INTO :BH-DATE-PYMT-STRT,                                      
MFA-TR*                :BH-BALANCE-FORWARD,                                     
MFA-TR*                :BH-BUD-HIST-SEQ-NO,                                     
MFA-TR*                :BH-CHANGE-REASON                                        
MFA-TR*            FROM CSS_BUDGET_HIST                                         
MFA-TR*           WHERE ACCOUNT_NO = :BH-ACCOUNT-NO                             
MFA-TR*             AND PYMT_PRIORITY_LVL = 50                                  
MFA-TR*             AND CHANGE_REASON IN ('A','S','H')                          
MFA-TR*             AND DATE_PYMT_STRT <= :BH-DATE-PYMT-STRT                    
MFA-TR*        ORDER BY BUD_HIST_SEQ_NO DESC,                                   
MFA-TR*                 DATE_PYMT_STRT DESC                                     
MFA-TR*           FETCH FIRST ROW ONLY                                          
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y'              TO WS-BBP-CHRG-CONTINUE-SW     
               WHEN NOT-FOUND                                           
                   MOVE 'N'              TO WS-BBP-CHRG-CONTINUE-SW     
               WHEN OTHER                                               
                   MOVE 'CPD00168'       TO ABEND-PROGRAM               
                   MOVE '7022B'          TO ACTIVE-PARAGRAPH            
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_BUDGET_HIST' TO TABLE-1                    
                   MOVE 'DATE PAYMENT'    TO TABLE-ELEMENT-1            
                   MOVE BH-DATE-PYMT-STRT TO HOSTVAR-ELEMENT-1          
                   PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT     
           END-EVALUATE.                                                
      *                                                                         
       7022B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** 7023B-GET-BILL-NO.                                                     
      ******************************************************************        
      *                                                                         
       7023B-GET-BILL-NO.                                               
                                                                        
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) BI.DATE_BILLED                                    
                 INTO :BI-DATE-BILLED                                   
                FROM  CSS_BILLING_DET BG WITH(READUNCOMMITTED),                 
                      CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                  
                WHERE BI.ACCOUNT_NO     = :BG-ACCOUNT-NO                
                  AND BG.REVENUE_MONTH  = :BG-REVENUE-MONTH             
                  AND BI.ACCOUNT_NO     =  BG.ACCOUNT_NO                
                  AND BI.BILL_NO        =  BG.BILL_NO                   
                  AND DATE_ORIG_BILL IS NULL                            
                ORDER BY BG.BILL_ITEM_TIMESTMP                          
                                                    
                                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BI.DATE_BILLED                                            
MFA-TR*          INTO :BI-DATE-BILLED                                           
MFA-TR*         FROM  CSS_BILLING_DET BG,                                       
MFA-TR*               CSS_BILLING_HDR BI                                        
MFA-TR*         WHERE BI.ACCOUNT_NO     = :BG-ACCOUNT-NO                        
MFA-TR*           AND BG.REVENUE_MONTH  = :BG-REVENUE-MONTH                     
MFA-TR*           AND BI.ACCOUNT_NO     =  BG.ACCOUNT_NO                        
MFA-TR*           AND BI.BILL_NO        =  BG.BILL_NO                           
MFA-TR*           AND DATE_ORIG_BILL IS NULL                                    
MFA-TR*         ORDER BY BG.BILL_ITEM_TIMESTMP                                  
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH  UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE 'CPD00168'       TO ABEND-PROGRAM               
                   MOVE '7023B'          TO ACTIVE-PARAGRAPH            
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_BILLING_DET' TO TABLE-1                    
                   MOVE 'ACCOUNT-NO'     TO TABLE-ELEMENT-1             
                   MOVE 'CSS_BILLING_HDR' TO TABLE-1                    
                   MOVE 'ACCOUNT-NO'     TO TABLE-ELEMENT-1             
                   MOVE BG-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'REVENUE MONTH'  TO TABLE-ELEMENT-1             
                   MOVE BG-REVENUE-MONTH TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT     
           END-EVALUATE.                                                
      *                                                                         
       7023B-EXIT.                                                      
           EXIT.                                                        
      *****************************************************************         
      ** 7024B-GET-BBP-TRANS-BALANCE.                                           
      ******************************************************************        
      *                                                                         
       7024B-GET-BBP-TRANS-BALANCE.                                     
                                                                        
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) SUM(AMT_TRAN_BALANCE)                             
                 INTO :AC-AMT-TRAN-BALANCE :WS-NULL-IND-2                
                FROM  CSS_AR_CNTL AC WITH(READUNCOMMITTED)                      
                WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO             
                  AND AC.PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL      
                  AND AC.ITEM_ID           >  0                         
                                                    
                                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_TRAN_BALANCE)                                     
MFA-TR*          INTO :AC-AMT-TRAN-BALANCE:WS-NULL-IND-2                        
MFA-TR*         FROM  CSS_AR_CNTL AC                                            
MFA-TR*         WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO                     
MFA-TR*           AND AC.PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL              
MFA-TR*           AND AC.ITEM_ID           >  0                                 
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH  UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE 'CPD00168'       TO ABEND-PROGRAM               
                   MOVE '7024B'          TO ACTIVE-PARAGRAPH            
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_AR_DTL'     TO TABLE-1                     
                   MOVE 'ACCOUNT-NO'     TO TABLE-ELEMENT-1             
                   MOVE AC-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'PAYMNET PRIORITY'   TO TABLE-ELEMENT-1         
                   MOVE AC-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT     
           END-EVALUATE.                                                
      *                                                                         
       7024B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** 7025B-GET-NON-BBP-TRAN-BALAN.                                          
      ******************************************************************        
      *                                                                         
       7025B-GET-NON-BBP-TRAN-BALAN.                                    
                                                                        
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) SUM( AMT_AR_DAY_00 + AMT_AR_DAY_30                
                         + AMT_AR_DAY_60 + AMT_AR_DAY_90                
                         + AMT_UNUSED_CR )                              
                 INTO :AC-AMT-TRAN-BALANCE :WS-NULL-IND-2                
                FROM  CSS_AR_CNTL AC WITH(READUNCOMMITTED)                      
                WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO             
                  AND AC.PYMT_PRIORITY_LVL NOT IN ( 50 )                
                  AND AC.ITEM_ID           >  0                         
                                                    
                                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM( AMT_AR_DAY_00 + AMT_AR_DAY_30                        
MFA-TR*                  + AMT_AR_DAY_60 + AMT_AR_DAY_90                        
MFA-TR*                  + AMT_UNUSED_CR )                                      
MFA-TR*          INTO :AC-AMT-TRAN-BALANCE:WS-NULL-IND-2                        
MFA-TR*         FROM  CSS_AR_CNTL AC                                            
MFA-TR*         WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO                     
MFA-TR*           AND AC.PYMT_PRIORITY_LVL NOT IN ( 50 )                        
MFA-TR*           AND AC.ITEM_ID           >  0                                 
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH  UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE 'CPD00168'       TO ABEND-PROGRAM               
                   MOVE '7025B'          TO ACTIVE-PARAGRAPH            
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_AR_DTL'     TO TABLE-1                     
                   MOVE 'ACCOUNT-NO'     TO TABLE-ELEMENT-1             
                   MOVE AC-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT     
           END-EVALUATE.                                                
      *                                                                         
       7025B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *****************************************************************         
      ** 7026B-GET-OTHER-CHARGES-BAL                                            
      ******************************************************************        
      *                                                                         
       7026B-GET-OTHER-CHARGES-BAL.                                     
                                                                        
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) SUM( AMT_AR_DAY_00 + AMT_AR_DAY_30                
                         + AMT_AR_DAY_60 + AMT_AR_DAY_90                
                         + AMT_UNUSED_CR )                              
                 INTO :AC-AMT-TRAN-BALANCE :WS-NULL-IND-2                
                FROM  CSS_AR_CNTL AC WITH(READUNCOMMITTED)                      
                WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO             
                  AND AC.PYMT_PRIORITY_LVL >= 30                        
                  AND AC.PYMT_PRIORITY_LVL < 50                         
                  AND AC.ITEM_ID           =  0                         
                                                    
                                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM( AMT_AR_DAY_00 + AMT_AR_DAY_30                        
MFA-TR*                  + AMT_AR_DAY_60 + AMT_AR_DAY_90                        
MFA-TR*                  + AMT_UNUSED_CR )                                      
MFA-TR*          INTO :AC-AMT-TRAN-BALANCE:WS-NULL-IND-2                        
MFA-TR*         FROM  CSS_AR_CNTL AC                                            
MFA-TR*         WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO                     
MFA-TR*           AND AC.PYMT_PRIORITY_LVL >= 30                                
MFA-TR*           AND AC.PYMT_PRIORITY_LVL < 50                                 
MFA-TR*           AND AC.ITEM_ID           =  0                                 
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH  UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE 'CPD00168'       TO ABEND-PROGRAM               
                   MOVE '7026B'          TO ACTIVE-PARAGRAPH            
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_AR_DTL'     TO TABLE-1                     
                   MOVE 'ACCOUNT-NO'     TO TABLE-ELEMENT-1             
                   MOVE AC-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT     
           END-EVALUATE.                                                
      *                                                                         
       7026B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** 7027B-GET-CURR-BBP-PAYMENT.                                            
      ******************************************************************        
      *                                                                         
       7027B-GET-CURR-BBP-PAYMENT.                                      
                                                                        
      *                                                                         
           EXEC SQL                                                     
                SELECT SUM(AMT_POSTED)                                  
                 INTO :AU-AMT-POSTED :WS-NULL-IND-2                      
                  FROM CSS_AR_TRN_HST_DET AU WITH(READUNCOMMITTED),             
                       CSS_AR_TRANS_HIST  AR WITH(READUNCOMMITTED)              
                 WHERE AU.ACCOUNT_NO       = :WS-CA168-ACCOUNT-NO       
                   AND AR.ACCOUNT_NO       = AU.ACCOUNT_NO              
                   AND AU.TRANS_HIST_SEQ_NO  > CIS.CHAR2TIMESTAMP(
                                                        :WS-CURR-SEQ-NO
              )          
                   AND AU.TRANS_HIST_SEQ_NO  = AR.TRANS_HIST_SEQ_NO     
                   AND AR.CODE_TRAN_TYPE   = 'P'                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT SUM(AMT_POSTED)                                          
MFA-TR*          INTO :AU-AMT-POSTED:WS-NULL-IND-2                              
MFA-TR*           FROM CSS_AR_TRN_HST_DET AU,                                   
MFA-TR*                CSS_AR_TRANS_HIST  AR                                    
MFA-TR*          WHERE AU.ACCOUNT_NO       = :WS-CA168-ACCOUNT-NO               
MFA-TR*            AND AR.ACCOUNT_NO       = AU.ACCOUNT_NO                      
MFA-TR*            AND AU.TRANS_HIST_SEQ_NO  > :WS-CURR-SEQ-NO                  
MFA-TR*            AND AU.TRANS_HIST_SEQ_NO  = AR.TRANS_HIST_SEQ_NO             
MFA-TR*            AND AR.CODE_TRAN_TYPE   = 'P'                                
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE 'CPD00168'       TO ABEND-PROGRAM               
                   MOVE '7027B'          TO ACTIVE-PARAGRAPH            
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_AR_TRANS_HIST_DET' TO TABLE-1              
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE  AU-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
      *                                                                         
       7027B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
