      **  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  **00021008
      **                                                              **00022008
      **  CPD00150                                                    **00023008
      **  THIS COPY STATEMENT CONTAINS THE NON-SQL PROCEDURE DIVISION **00024008
      **  STATEMENTS NECESSARY TO CENTER VARIABLE LENGTH TABLE        **00025008
      **  RETRIEVED INFORMATION IN A FIXED LENGTH FIELD.  WILL MOSTLY **00026008
      **  BE UTILIZED FOR CENTERING THE COMPANY NAME IN THE HEADER    **        
      **  OF SERVICE 2000 BATCH REPORTS.                              **        
      **                                                              **00027008
      **  THIS COPYBOOK SHOULD BE 'COPIED' INTO ALL BATCH REPORTS     **        
      **  COMPONENTS.                                                 **        
      **                                                              **        
      **  REQUIREMENTS:                                               **        
      **  1.  COPY CWS00150 - CONTAINS SWITCHES AND VARIABLES         **        
      **        NECESSARY FOR EXECUTION.                              **        
      **                                                              **        
      **  2.  MOVE THE FIELD WHICH MUST BE CENTERED TO THE COPYBOOK   **        
      **        WORKING STORAGE INPUT FIELD.  EXAMPLE:                **        
      **          MOVE C7-COMPANY-NAME     TO WS-INPT-CTR-FIELD       **        
      **                                                              **        
      **  3.  MOVE MAXIMUM REPORT FIELD LENGTH TO THE VARIABLE        **        
      **        WS-MAX-FIELD-LEN-3900.  EXAMPLE:  FOR COMPANY NAME,   **        
      **        THE FOLLOWING STATEMENT SHOULD BE PRESENT -           **        
      **          MOVE +26                 TO WS-MAX-FIELD-LEN-3900   **        
      **        THIS VALUE REPRESENTS THE COLUMN SIZE FROM TABLE      **        
      **        CSS_COMPANY AND ALSO THE FIELD SIZE FOR COMPANY NAME  **        
      **        ON ALL BATCH REPORTS.                                 **        
      **                                                              **        
      **      NOTE:  75 IS THE MAXIMUM COLUMN WIDTH WHICH MAY BE      **        
      **        SUCCESSFULLY PROCESSED UTILIZING THIS ROUTINE.        **        
      **                                                              **        
      **  3.  CALL: PERFORM 3900-CENTERING-ROUTINE   THRU 3900-EXIT   **        
      **                                                              **        
      **  4.  MOVE THE CENTERING RESULT FIELD TO THE REPORT DISPLAY   **        
      **        FIELD.  EXAMPLE:                                      **        
      **          MOVE WS-OUTPUT-CTR-FIELD TO P-RPT1-COMP-NAME        **        
      **                                                              **        
      **  **********************************************************  **        
      **  ** ALL RESULT WORKING STORAGE FIELDS PROCESSED BY THIS  **  **        
      **  ** COMMON PROCEDURE DIVISION ARE INITIALIZED WITHIN THE **  **        
      **  **                          COPYBOOK.                   **  **        
      **  **********************************************************  **        
      **..............................................................**00028008
      **                    MODIFICATION  LOG                         **00029008
      **..............................................................**00030008
      **                                                              **00040008
      **                                                              **00050008
      **    DATE    INITIALS     REASON                               **00060008
      **    ____    ________     ______                               **00070008
      **                                                              **00100008
      **  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  **00110008
      *****************************************************************         
      *                                                                         
       3900-CENTERING-ROUTINE.                                          
      *                                                                         
           MOVE WS-N                   TO WS-CURRENT-CHAR-SW.           
           MOVE WS-N                   TO WS-PREVIOUS-CHAR-SW.          
      *                                                                         
           MOVE SPACES                 TO WS-OUTPUT-CTR-FIELD.          
      *                                                                         
           PERFORM VARYING WS-LTR-COUNT-3900 FROM +1 BY +1              
            UNTIL PREVIOUS-CHAR-IS-SPACE AND CURRENT-CHAR-IS-SPACE      
             OR WS-LTR-COUNT-3900 > WS-MAX-FIELD-LEN-3900               
               IF WS-INPT-CTR-FIELD(WS-LTR-COUNT-3900:1) EQUAL SPACES   
                 AND PREVIOUS-CHAR-IS-SPACE                             
                   MOVE WS-Y           TO WS-CURRENT-CHAR-SW            
               ELSE                                                     
                 IF WS-INPT-CTR-FIELD(WS-LTR-COUNT-3900:1) EQUAL SPACES 
                   AND PREVIOUS-CHAR-NOT-SPACE                          
                     MOVE WS-Y         TO WS-PREVIOUS-CHAR-SW           
                   ELSE                                                 
                       MOVE WS-N       TO WS-PREVIOUS-CHAR-SW           
                       MOVE WS-N       TO WS-CURRENT-CHAR-SW            
                   END-IF                                               
               END-IF                                                   
           END-PERFORM.                                                 
      *                                                                         
           IF PREVIOUS-CHAR-IS-SPACE AND CURRENT-CHAR-IS-SPACE          
             SUBTRACT +3 FROM WS-LTR-COUNT-3900                         
           ELSE                                                         
             IF PREVIOUS-CHAR-IS-SPACE                                  
               SUBTRACT +2 FROM WS-LTR-COUNT-3900                       
             ELSE                                                       
               SUBTRACT +1 FROM WS-LTR-COUNT-3900                       
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
           SUBTRACT WS-LTR-COUNT-3900 FROM WS-MAX-FIELD-LEN-3900        
             GIVING WS-NUM-OF-SPACES-3900.                              
      *                                                                         
           IF WS-NUM-OF-SPACES-3900 EQUAL +0                            
             OR WS-NUM-OF-SPACES-3900 EQUAL +1                          
               MOVE +0                 TO WS-NUM-OF-LEAD-SPCS-3900      
           ELSE                                                         
             DIVIDE WS-NUM-OF-SPACES-3900 BY +2                         
               GIVING WS-NUM-OF-LEAD-SPCS-3900                          
           END-IF.                                                      
      *                                                                         
           ADD +1 TO WS-NUM-OF-LEAD-SPCS-3900                           
             GIVING WS-NUM-CHAR-STRT-3900.                              
      *                                                                         
           IF WS-LTR-COUNT-3900 NOT EQUAL 0                             
            MOVE WS-INPT-CTR-FIELD(1:WS-LTR-COUNT-3900) TO              
            WS-OUTPUT-CTR-FIELD(WS-NUM-CHAR-STRT-3900:WS-LTR-COUNT-3900)
           END-IF.                                                      
      *                                                                         
           MOVE SPACES                 TO WS-INPT-CTR-FIELD.            
      *                                                                         
       3900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
