      *****************************************************************         
      **             CPD00140 - ZERO USE WQ'S                        **         
      *****************************************************************         
      ** ASSOCIATED COPY BOOKS  CWS00140, CPD00055, CPD0023B         **         
      *****************************************************************         
      **  PURPOSE :                                                  **         
      **                                                             **         
      **  CREATES WORK QUEUES FOR METERS WITH ZERO USAGE.            **         
      **                                                             **         
      **  LOGIC :                                                    **         
      **                                                             **         
      **  IF THE RECORD HAS A SEASONAL USE CODE THE METER READ DATE  **         
      **  IS COMPARED TO THE ZERO USE MONTHS TO SEE IF THE METER READ**         
      **  DATE FALLS IN THE ACCEPTABLE TIME PERIOD. IF THE READ DATE **         
      **  IS IN THE ACCEPTABLE TIME FRAME THEN NO PROCESSING IS      **         
      **  NECESSARY, OTHERWISE IF THE ACCOUNT HAS BEEN INVESTIGATED  **         
      **  IN THE LAST 3 MONTHS. IF NO SEASONAL USE CODE IS PRESENT   **         
      **  CHECK THE DATABASE TO SEE IF THE ACCOUNT HAS BEEN INVESTIGA**         
      **  TED IN THE LAST 3 MONTHS. FOR ACCOUNTS THAT HAVE NOT BEEN  **         
      **  INVESTIGATED IN THE LAST 3 MONTHS WRITE A WORK QUEUE RECORD**         
      **  OUT, OTHERWISE READ & PROCESS THE NEXT RECORD.             **         
      *****************************************************************         
      ** FOR THIS PROGRAM TO WORK THE BELOW FIELDS MUST BE PASSED    **         
      ** PRIOR TO COMING HERE.                                       **         
      **                                                             **         
      ** INPUT TO THE COPYBOOK:                                      **         
      ** BATCH - WS-140-RUN-DATE (FORMAT CCYY-MM-DD)                 **         
      **         WS-140-ACCOUNT-NO                                   **         
      **         WS-140-METER-NO                                     **         
      **         WS-140-IC-NO                                        **         
      **         WS-140-CODE-UTIL-TYPE                               **         
      **         WS-140-CODE-USAGE-TYPE                              **         
      **         WS-140-MTR-READ-DATE                                **         
      **         WS-140-CURR-REVMTH                                  **         
      **                                                             **         
      ** OUTPUT FROM THE COPYBOOK: CREATE ZERO USE WQ'S              **         
      **                                                             **         
      ** COPYBOOKS - DATABASE WORKING STORAGE VARIABLES.             **         
      **         CSS_ACCOUNT                                         **         
      **         CSS_MTRD_ENVRNMT                                    **         
      **         CSS_UTIL_ENVRNMT                                    **         
      **         CSS_RATE_PLAN_DESC                                  **         
      **         CSS_SEASONAL_USE                                    **         
      **         CSS_BILLING_DET                                     **         
      **         CSS_CNSMPTN_HIST                                    **         
      **                                                             **         
      ** CALLING PERFORM STATEMENT FROM MAIN PROGRAM.                **         
      **         6400-PROCESS-ZERO-USE-WQ THRU 6400-CPD140-EXIT      **         
      *---------------------------------------------------------------*         
      *  NOTE:                                                        *         
      *        WHEN MODIFYING THIS MEMBER, MEMBER CWS00140 SHOULD     *         
      *        BE EVALUATED FOR CORRESPONDING MODIFICATIONS.          *         
      *---------------------------------------------------------------*         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  ________     __________________________________  **         
      **  08/19/03  VD88125      INITIAL VERSION                     **         
C29853**  02/04/04  SG18894      CHANGES MADE TO NOT CREATE ZERO USE **         
      **                         WQS FOR SEB 'HEATING ONLY' CUSTOMERS**         
      **                         (HARDCODING WOULD BE REMOVED ONCE SO**         
      **                         IS FIXED TO SET RIGHT SEASON-CODE)  **         
      **                                                             **         
C32957**  08/01/05  SG18894      CHANGES MADE TO SPLIT ELECTRIC NON- **         
      **                         DEMAND ZERO USE WQS                 **         
T34097**  12/14/07  MK92804      REPLACED CSS_MODEL_SQL SELECT STMTS **         
T34097**                         WITH SET COMMAND AND ADDED FOR FETCH**         
T34097**                         ONLY WITH UR FOR CURSOR SELECTS AND **         
T34097**                         WITH UR FOR SINGELTON SELECTS.      **         
A02711**  08/27/10  SJ97149      CHANGING THE RUN DATE MONTH FROM    **         
A02711**                         <=09 TO <=10 FOR CATEGORY-ID  = 153 **         
A02711**                         FOR SEB ACCOUNTS                    **         
ACT103**  05/02/11  BD09555      APPL 3082.  CHANGE THE RUN DATE TO  **         
ACT103**                         EXCLUDE ACCOUNTS BETWEEN THE MONTHS **         
ACT103**                         OF JUNE AND NOVEMBER.  PREVIOUSLY   **         
ACT103**                         IT HAD EXCLUDED MAY THRU OCTOBER.   **         
ACT047**  05/11/12  BD09555      APPL 3967.  CHANGE THE RUN DATE TO  **         
ACT047**                         EXCLUDE ACCOUNTS BETWEEN THE MONTHS **         
ACT047**                         OF MAY AND NOVEMBER.  PREVIOUSLY    **         
ACT047**                         IT HAD EXCLUDED JUNE THRU NOVEMBER. **         
ACT015** 06/16/14   SS95855     A04880 USE WQ COPYBOOK CPD00077.     **         
      **                                                             **         
A04880** 1 NOV 2014 RF10596     CHANGE THE WAY WQ CREATED            **         
      **                                                             **         
A04880**24 NOV 2014 RF10596     FOR SEB -USE BEG AND END MONTHS FROM **         
A04880**                        JOB_PARM INSTEAD OF HARDCODED MONTHS **         
      **                                                             **         
      *****************************************************************         
      ****************************************************************          
      **                                                            **          
      **  6400-PROCESS-ZERO-USE-WQ                                  **          
      **       CONTAINS THE MAIN PROCESSING LOOP.                   **          
      ****************************************************************          
      *                                                                         
       6400-PROCESS-ZERO-USE-WQ.                                        
      *                                                                         
           MOVE WS-140-RUN-DATE         TO WS-140-FORMAT-DATE.          
           PERFORM 7111-CALC-DATE-3-MNTH-AGO THRU 7111-CPD140-EXIT.     
      *                                                                         
           MOVE WS-140-ACCOUNT-NO       TO AT-ACCOUNT-NO                
                                           BG-ACCOUNT-NO                
                                           CX-ACCOUNT-NO                
                                           MN-ACCOUNT-NO.               
           PERFORM 15 TIMES                                             
                IF WS-140-REVMTH-MM = 01                                
                   MOVE 12 TO WS-140-REVMTH-MM                          
                   SUBTRACT 1 FROM WS-140-REVMTH-CCYY                   
                ELSE                                                    
                   SUBTRACT 1 FROM WS-140-REVMTH-MM                     
                END-IF                                                  
           END-PERFORM.                                                 
                                                                        
           MOVE WS-140-CURR-REVMTH      TO BG-REVENUE-MONTH.            
           MOVE ZERO                    TO WS-140-NO-CNSC-ZERO-USE      
                                           CX-NO-UNITS.                 
                                                                        
           PERFORM 7333-SELECT-CUST-DETAILS THRU 7333-CPD140-EXIT.      
                                                                        
           MOVE WS-140-CODE-UTIL-TYPE   TO MN-CODE-UTIL-TYPE            
                                           BG-CODE-UTIL-TYPE            
                                           CX-CODE-UTIL-TYPE.           
           MOVE WS-140-METER-NO         TO MN-METER-NO                  
           MOVE WS-140-IC-NO            TO MN-IC-NO                     
                                           BG-IC-NO                     
                                           CX-IC-NO.                    
                                                                        
           PERFORM 7444-SELECT-ZERO-USE-INV-DATE THRU 7444-CPD140-EXIT. 
                                                                        
           MOVE MN-MTR-REF-NO           TO CX-MTR-REF-NO.               
           MOVE MN-REG-ID-NO            TO CX-REG-ID-NO.                
           MOVE MN-CODE-TIME-PERIOD     TO CX-CODE-TIME-PERIOD.         
                                                                        
           PERFORM 7555-OPEN-BILLING-DET    THRU 7555-CPD140-EXIT.      
           PERFORM 7666-FETCH-BILLING-DET   THRU 7666-CPD140-EXIT.      
           PERFORM 6490-PROCESS-CX-NO-UNITS THRU 6490-CPD140-EXIT       
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                   OR    CX-NO-UNITS NOT EQUAL 0.                       
           PERFORM 7777-CLOSE-BILLING-DET   THRU 7777-CPD140-EXIT.      
      *                                                                         
           IF UT-SEASONAL-USE-CODE NOT = SPACES                         
              PERFORM 6410-PROCESS-SEASONAL-USE-CODE                    
                                     THRU 6410-CPD140-EXIT              
           ELSE                                                         
               PERFORM 6415-VAL-3-MTHS-DT THRU 6415-CPD140-EXIT         
           END-IF.                                                      
      *                                                                         
       6400-CPD140-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   6410-PROCESS-SEASONAL-USE-CODE.                          **          
      **     CALLED WHEN SEASONAL CODE IS NOT NULL, CHECKS TO SEE   **          
      **     IF METER DATE IS WITHIN RANGE WHEN IT SHOULD NOT BE    **          
      **     ZERO & CHECKS IF INVEST PERIOD IS LESS THAN 3 MONTHS.  **          
      **     IT ALSO CHECKS TO SEE IF NO OF CONS MONTHS IS > ALLOW  **          
      **     NO OF MONTHS.                                          **          
      ****************************************************************          
      *                                                                         
       6410-PROCESS-SEASONAL-USE-CODE.                                  
      *                                                                         
           MOVE UT-SEASONAL-USE-CODE       TO B2-SEASONAL-USE-CD.       
           MOVE WS-140-CODE-UTIL-TYPE      TO B2-CODE-UTIL-TYPE.        
           PERFORM 7222-SELECT-MTHS-ZERO-USE THRU 7222-CPD140-EXIT.     
      *                                                                         
A04880     MOVE B2-CNSC-MTH-ZERO-USE TO WS-140-WQ-MONTHS.               
      *                                                                         
           MOVE WS-140-MTR-READ-DATE       TO WS-140-DATE-MR.           
           MOVE SPACES                     TO WS-140-WORK-PERIOD.       
           IF B2-FRST-MTH-ZERO-USE > ZERO AND                           
              B2-LAST-MTH-ZERO-USE > ZERO                               
              IF B2-FRST-MTH-ZERO-USE <= B2-LAST-MTH-ZERO-USE           
                 IF WS-140-MONTH-MR >= B2-FRST-MTH-ZERO-USE AND         
                    WS-140-MONTH-MR <= B2-LAST-MTH-ZERO-USE             
                    PERFORM 6415-VAL-3-MTHS-DT THRU 6415-CPD140-EXIT    
                 ELSE                                                   
                    IF WS-140-NO-CNSC-ZERO-USE > B2-CNSC-MTH-ZERO-USE   
                       MOVE UT-SEASONAL-USE-CODE TO WS-140-SEASN-CODES  
                       IF (VALID-GAS-USE-CODES AND                      
                          WS-140-CODE-UTIL-TYPE EQUAL WS-140-G)         
                          OR (VALID-ELEC-USE-CODES AND                  
                          WS-140-CODE-UTIL-TYPE EQUAL WS-140-E)         
                          CONTINUE                                      
                       ELSE                                             
                          MOVE 'Y' TO WS-140-WORK-PERIOD                
                          PERFORM 6415-VAL-3-MTHS-DT   THRU             
                                                       6415-CPD140-EXIT 
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 IF WS-140-MONTH-MR >= B2-FRST-MTH-ZERO-USE OR          
                    WS-140-MONTH-MR <= B2-LAST-MTH-ZERO-USE             
                    PERFORM 6415-VAL-3-MTHS-DT THRU 6415-CPD140-EXIT    
                 ELSE                                                   
                    IF WS-140-NO-CNSC-ZERO-USE > B2-CNSC-MTH-ZERO-USE   
                       MOVE UT-SEASONAL-USE-CODE  TO                    
                                      WS-140-SEASN-CODES                
                       IF (VALID-GAS-USE-CODES AND                      
                          WS-140-CODE-UTIL-TYPE EQUAL WS-140-G)         
                          OR (VALID-ELEC-USE-CODES AND                  
                          WS-140-CODE-UTIL-TYPE EQUAL WS-140-E)         
                          CONTINUE                                      
                       ELSE                                             
                          MOVE 'Y' TO WS-140-WORK-PERIOD                
                          PERFORM 6415-VAL-3-MTHS-DT  THRU              
                                                      6415-CPD140-EXIT  
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
               IF WS-140-NO-CNSC-ZERO-USE > B2-CNSC-MTH-ZERO-USE        
                   MOVE UT-SEASONAL-USE-CODE  TO                        
                                      WS-140-SEASN-CODES                
                   IF (VALID-GAS-USE-CODES AND                          
                      WS-140-CODE-UTIL-TYPE EQUAL WS-140-G)             
                      OR (VALID-ELEC-USE-CODES AND                      
                      WS-140-CODE-UTIL-TYPE EQUAL WS-140-E)             
                      CONTINUE                                          
                   ELSE                                                 
                      MOVE 'Y' TO WS-140-WORK-PERIOD                    
                      PERFORM 6415-VAL-3-MTHS-DT      THRU              
                                                      6415-CPD140-EXIT  
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       6410-CPD140-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   6415-VAL-3-MTHS-DT.                                      **          
      **       VALIDTES TO SEE IF INVESTIGATION PERIOD IS LESS THAN **          
      **       3 MONTHS FROM CURRENT DATE.                          **          
      ****************************************************************          
      *                                                                         
       6415-VAL-3-MTHS-DT.                                              
      *                                                                         
           EVALUATE WS-140-CODE-USAGE-TYPE                              
           WHEN 'B'                                                     
             MOVE       'KWH' TO WS-140-READ-LIT                        
           WHEN 'E'                                                     
             MOVE       'KVA' TO WS-140-READ-LIT                        
           WHEN 'J'                                                     
             MOVE        'KW' TO WS-140-READ-LIT                        
           WHEN 'C'                                                     
             MOVE       'CCF' TO WS-140-READ-LIT                        
           WHEN 'U'                                                     
             MOVE       'UNC' TO WS-140-READ-LIT                        
           WHEN 'I'                                                     
             MOVE       'INT' TO WS-140-READ-LIT                        
           WHEN 'P'                                                     
             MOVE       'PRE' TO WS-140-READ-LIT                        
           WHEN 'T'                                                     
             MOVE       'TMP' TO WS-140-READ-LIT                        
           WHEN 'V'                                                     
             MOVE       'VLT' TO WS-140-READ-LIT                        
           END-EVALUATE.                                                
      *                                                                         
      ****************************************************************          
A04880*  WHEN UT-ZERO-USE-INVEST-DATE = NO DATE(BLANK)               *          
A04880*   AND UT-SEASONAL-USE-CODE = SPACES (NOT SEASONAL)           *          
A04880*             OR                                               *          
A04880*  WHEN UT-ZERO-USE-INVEST-DATE = NO DATE (BLANK)              *          
A04880*   AND UT-SEASONAL-USE-CODE = SOME CODE (SEASONAL)            *          
A04880*     ALWAYS DO 6420-PROCESS-WORK-QUEUE                        *          
      *                                                              *          
A04880*  WHEN UT-ZERO-USE-INVEST-DATE = SOME DATE                    *          
A04880*     AND UT-SEASONAL-USE-CODE = SPACES                        *          
A04880*  ( DO A WQ EVERY 3 THREE MONTHS CHECK - NOT SEASONAL )       *          
      *                                                              *          
A04880*  WHEN UT-ZERO-USE-INVEST-DATE = SOME DATE                    *          
A04880*        AND UT-SEASONAL-USE-CODE = SOME CODE                  *          
A04880*  (TAKE THE UT-ZERO-USE-INVEST-DATE AND ADD THE NUMBER OF     *          
A04880*  MONTHS FROM THE SEASONAL USE TABLE (CNSC-MTH-ZERO-USE)      *          
A04880*  AND THEN IF READ DATE IS >= (CALCULATED DATE )              *          
A04880*   DO A WQ - IT IS SEASONAL)                                  *          
      ****************************************************************          
      *                                                                         
A04880     MOVE SPACES TO WS-140-WQ-DATE.                               
A04880     IF UT-ZERO-USE-INVEST-DT = SPACES                            
A04880        PERFORM 6420-PROCESS-WORK-QUEUE THRU 6420-CPD140-EXIT     
A04880     ELSE                                                         
A04880        IF UT-SEASONAL-USE-CODE = SPACES                          
A04880           IF UT-ZERO-USE-INVEST-DT < WS-140-DATE-3-MTHS-AGO      
A04880              PERFORM 6420-PROCESS-WORK-QUEUE                     
A04880                  THRU 6420-CPD140-EXIT                           
A04880           END-IF                                                 
A04880        ELSE                                                      
A04880           PERFORM 7144-CALC-DATE-FOR-WQ THRU 7144-CPD140-EXIT    
A04880           IF WS-140-MTR-READ-DATE >= WS-140-WQ-DATE              
A04880              PERFORM 6420-PROCESS-WORK-QUEUE                     
A04880                  THRU 6420-CPD140-EXIT                           
A04880           END-IF                                                 
A04880        END-IF                                                    
A04880     END-IF.                                                      
      *                                                                         
       6415-CPD140-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **   6420-PROCESS-WORK-QUEUE                                  **          
      **       WRITES INTO WORK QUEUE                               **          
      ****************************************************************          
      *                                                                         
       6420-PROCESS-WORK-QUEUE.                                         
      *                                                                         
ACT015     INITIALIZE CWS00077-FIELDS.                                  
ACT015     MOVE WS-140-ACCOUNT-NO  TO WS-77-ACCOUNT-NO.                 
           MOVE WS-140-READ-LIT    TO WS-140-WQ285-REG                  
                                      WS-140-WQ204-REG                  
                                      WS-140-WQ153-REG                  
                                      WS-140-WQ-REG                     
                                      WS-140-WQ2-REG.                   
                                                                        
           IF UT-SEASONAL-USE-CODE NOT = SPACES                         
               PERFORM 6425-SEASONAL-USE THRU 6425-CPD140-EXIT          
           ELSE                                                         
               PERFORM 6450-NOT-SEASONAL-USE THRU 6450-CPD140-EXIT      
           END-IF.                                                      
                                                                        
           EVALUATE WS-140-CODE-UTIL-TYPE                               
             WHEN 'E'                                                   
C32957         IF RD-SECURED-RATE-FL  = 'Y'                             
C32957            IF AT-COMPANY-NO = '01'                               
ACT015               MOVE  285        TO WS-77-CATEGORY-ID              
C32957            END-IF                                                
ACT015            MOVE '4'            TO WS-77-ROUTE-CATEGORY           
C32957         ELSE                                                     
C32957            IF UT-CODE-REVENUE-CLASS(2:1) EQUAL TO '1'            
ACT015               MOVE  51         TO WS-77-CATEGORY-ID              
ACT015               MOVE '1'         TO WS-77-ROUTE-CATEGORY           
C32957            ELSE                                                  
ACT015               MOVE  399        TO WS-77-CATEGORY-ID              
ACT015               MOVE '4'         TO WS-77-ROUTE-CATEGORY           
C32957            END-IF                                                
C32957         END-IF                                                   
             WHEN 'G'                                                   
               IF RD-SECURED-RATE-FL  = 'Y'                             
                  IF AT-COMPANY-NO = '01'                               
ACT015               MOVE  285        TO WS-77-CATEGORY-ID              
                  ELSE                                                  
                    IF AT-COMPANY-NO = '26'                             
ACT015                  MOVE  286     TO WS-77-CATEGORY-ID              
                    END-IF                                              
                  END-IF                                                
ACT015            MOVE '4'            TO WS-77-ROUTE-CATEGORY           
               ELSE                                                     
                  IF UT-CODE-REVENUE-CLASS(2:1) EQUAL TO '1'            
ACT015               MOVE  153        TO WS-77-CATEGORY-ID              
                  ELSE                                                  
ACT015               MOVE  204        TO WS-77-CATEGORY-ID              
                  END-IF                                                
ACT015            MOVE '1'            TO WS-77-ROUTE-CATEGORY           
               END-IF                                                   
           END-EVALUATE.                                                
                                                                        
ACT015     IF WS-77-CATEGORY-ID = 285 OR 286                            
             IF  UT-SEASONAL-USE-CODE NOT = SPACES                      
                MOVE WS-140-WQ-COMMENTS-285                             
ACT015                                TO WS-77-COMMENTS-TEXT            
ACT015          MOVE +161             TO WS-77-COMMENTS-LEN             
             END-IF                                                     
           END-IF                                                       
                                                                        
ACT015     IF WS-77-CATEGORY-ID = 204                                   
C29853       IF UT-CODE-REVENUE-CLASS = ('022' OR '027' OR '032') AND   
C29853                                 SEB-DATABASE                     
C29853          GO TO 6420-CPD140-EXIT                                  
C29853       ELSE                                                       
             IF  UT-SEASONAL-USE-CODE NOT = SPACES                      
                MOVE WS-140-WQ-COMMENTS-204                             
ACT015                                TO WS-77-COMMENTS-TEXT            
ACT015          MOVE +161             TO WS-77-COMMENTS-LEN             
             END-IF                                                     
C29853       END-IF                                                     
           END-IF                                                       
                                                                        
ACT015     IF WS-77-CATEGORY-ID = 153                                   
A04880       IF WS-140-RUN-MONTH >= WS-140-BEG-SEB-SEASONAL AND         
A04880          WS-140-RUN-MONTH <= WS-140-END-SEB-SEASONAL AND         
C29853            SEB-DATABASE                                          
C29853          GO TO 6420-CPD140-EXIT                                  
C29853       ELSE                                                       
             IF  UT-SEASONAL-USE-CODE NOT = SPACES                      
                MOVE WS-140-WQ-COMMENTS-153                             
ACT015                                  TO WS-77-COMMENTS-TEXT          
ACT015          MOVE +161               TO WS-77-COMMENTS-LEN           
             END-IF                                                     
C29853       END-IF                                                     
           END-IF                                                       
                                                                        
           IF WS-140-CODE-UTIL-TYPE = 'E' AND                           
              WS-140-CODE-USAGE-TYPE NOT = 'B'                          
ACT015        MOVE  175               TO WS-77-CATEGORY-ID              
ACT015        MOVE  '4'               TO WS-77-ROUTE-CATEGORY           
           END-IF                                                       
                                                                        
ACT015     MOVE SPACES                TO WS-FRMT-WQ-DT .                
ACT015     MOVE WS-140-FORMAT-DATE    TO WS-FRMT-WQ-DT.                 
ACT015     MOVE WS-FRMT-WQ-TS         TO WS-77-DATE-CREATED.            
           MOVE WS-140-RUN-YEAR       TO WS-140-REQ-YEAR.               
           MOVE WS-140-RUN-MONTH      TO WS-140-REQ-MONTH.              
           IF WS-140-REQ-MONTH = 12                                     
               MOVE 01                TO WS-140-REQ-MONTH               
               ADD  01                TO WS-140-REQ-YEAR                
           ELSE                                                         
               ADD  01                TO WS-140-REQ-MONTH               
           END-IF.                                                      
ACT015     MOVE WS-140-DATE-REQUIRED  TO WS-77-DATE-REQUIRED(1:10).     
ACT015     MOVE SPACES                TO WS-77-FREE-FORM-TXT.           
ACT015     MOVE SPACES                TO WS-77-RESP-AREA-ID.            
ACT015     MOVE ZEROES                TO WS-77-FREE-FORM-LEN.           
ACT015     MOVE AT-LOCAL-OFFICE       TO WS-77-LOCAL-OFFICE.            
ACT015     MOVE AT-CUSTOMER-NO        TO WS-77-CUSTOMER-NO.             
ACT015     MOVE AT-PREMISE-NO         TO WS-77-PREMISE-NO.              
ACT015     MOVE WS-PGRMNAME           TO WS-77-CREATED-BY.              
ACT015     MOVE ZEROES                TO WS-77-SERV-ORDER-NO.           
ACT015     MOVE 'N'                   TO WS-77-PRIORITY.                
      *                                                                         
           PERFORM 8895-INSERT-WORK-QUEUE        THRU 8895-EXIT.        
      *                                                                         
       6420-CPD140-EXIT.                                                
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **   0025-SEASONAL-USE.                                       **          
      **   POPULATES COMMENTS FIELD WHEN SEASONAL CODE IS NOT NULL  **          
      ****************************************************************          
      *                                                                         
       6425-SEASONAL-USE.                                               
      *                                                                         
           MOVE WS-140-METER-NO        TO WS-140-MTR-NO-COMMENT         
                                          WS-140-MTR-NO-COMMENT-153     
                                          WS-140-MTR-NO-COMMENT-204     
                                          WS-140-MTR-NO-COMMENT-285.    
           MOVE B2-SEASONAL-USE-DESC   TO WS-140-SEASN-USE-COMMENT      
                                          WS-140-SEASN-USE-COMMENT-153  
                                          WS-140-SEASN-USE-COMMENT-204  
                                          WS-140-SEASN-USE-COMMENT-285. 
           IF WS-140-WORK-PERIOD = 'Y'                                  
               PERFORM 6480-FORMAT-CONS-MTHS THRU 6480-CPD140-EXIT      
           ELSE                                                         
               PERFORM 6475-EVALUATE-USAGE-MONTHS THRU 6475-CPD140-EXIT 
           END-IF.                                                      
ACT015     MOVE WS-140-WQ-COMMENTS  TO WS-77-COMMENTS-TEXT.             
ACT015     MOVE +141                   TO WS-77-COMMENTS-LEN.           
      *                                                                         
       6425-CPD140-EXIT.                                                
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **   6450-NOT-SEASONAL-USE.                                   **          
      **       POPULATES COMMENTS FIELD WHEN SEASONAL CODE IS NULL. **          
      ****************************************************************          
      *                                                                         
       6450-NOT-SEASONAL-USE.                                           
      *                                                                         
           MOVE WS-140-METER-NO       TO WS-140-MTR-NO.                 
           MOVE WS-140-RUN-MTH-RED    TO WS-140-MTH-ZERO-USE.           
           PERFORM 6485-SEASN-MONTH-DESC THRU 6485-CPD140-EXIT.         
           MOVE WS-140-MTH-DESC       TO WS-140-CURR-MTH.               
ACT015     MOVE WS-140-WQ-COMMENT-2   TO WS-77-COMMENTS-TEXT.           
ACT015     MOVE +153                  TO WS-77-COMMENTS-LEN.            
      *                                                                         
       6450-CPD140-EXIT.                                                
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **   6475-EVALUATE-USAGE-MONTHS.                              **          
      **       EVALUATE THE FIRST & LAST MONTH OF ZERO USAGE. THE   **          
      **       WINDOW FOR ACCEPTABLE ZERO USAGE IS CALCULATED BY    **          
      **       ADDING ONE MONTH TO THE ENDING MONTH AND SUBTRACTING **          
      **       ONE MONTH FROM THE LAST MONTH. THESE MONTHS ARE THEN **          
      **       TRANSLATED INTO A 3 CHAR VALUE & MOVED TO WS.        **          
      ****************************************************************          
      *                                                                         
       6475-EVALUATE-USAGE-MONTHS.                                      
      *                                                                         
           MOVE B2-FRST-MTH-ZERO-USE     TO WS-140-MTH-ZERO-USE.        
           SUBTRACT 1 FROM WS-140-MTH-ZERO-USE.                         
           PERFORM 6485-SEASN-MONTH-DESC THRU 6485-CPD140-EXIT.         
           MOVE WS-140-MTH-DESC          TO WS-140-END-TIME-PER.        
                                                                        
           MOVE B2-LAST-MTH-ZERO-USE     TO WS-140-MTH-ZERO-USE.        
           ADD      1 TO   WS-140-MTH-ZERO-USE.                         
           PERFORM 6485-SEASN-MONTH-DESC THRU 6485-CPD140-EXIT.         
           MOVE WS-140-MTH-DESC          TO WS-140-BEG-TIME-PER.        
                                                                        
           MOVE WS-140-MONTH-TO-MONTH    TO WS-140-TIME-PER-COMMENT     
                                            WS-140-TIME-PER-COMMENT-153 
                                            WS-140-TIME-PER-COMMENT-204 
                                            WS-140-TIME-PER-COMMENT-285.
      *                                                                         
       6475-CPD140-EXIT.                                                
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **   6480-FORMAT-CONS-MTHS.                                   **          
      **       FORMATS THE TIME PERIOD MESSAGE WITH THE NUMBER OF   **          
      **       CONSECUTIVE MONTHS A SEASONAL RATE METER CAN HAVE    **          
      **       ZERO USAGE. THIS PROCESS OCCURS WHEN THE BEGINNING   **          
      **       AND ENDING MONTHS BOTH HAVE VALUES OF 0.             **          
      ****************************************************************          
      *                                                                         
       6480-FORMAT-CONS-MTHS.                                           
      *                                                                         
           MOVE B2-CNSC-MTH-ZERO-USE    TO  WS-140-CONSEC-MONTHS.       
           MOVE WS-140-MONTH-PERIOD     TO  WS-140-TIME-PER-COMMENT     
                                            WS-140-TIME-PER-COMMENT-153 
                                            WS-140-TIME-PER-COMMENT-204.
       6480-CPD140-EXIT.                                                
            EXIT.                                                       
      *                                                                         
       6485-SEASN-MONTH-DESC.                                           
      *                                                                         
           EVALUATE WS-140-MTH-ZERO-USE                                 
               WHEN 01                                                  
                   MOVE 'JAN'         TO WS-140-MTH-DESC                
               WHEN 02                                                  
                   MOVE 'FEB'         TO WS-140-MTH-DESC                
               WHEN 03                                                  
                   MOVE 'MAR'         TO WS-140-MTH-DESC                
               WHEN 04                                                  
                   MOVE 'APR'         TO WS-140-MTH-DESC                
               WHEN 05                                                  
                   MOVE 'MAY'         TO WS-140-MTH-DESC                
               WHEN 06                                                  
                   MOVE 'JUN'         TO WS-140-MTH-DESC                
               WHEN 07                                                  
                   MOVE 'JUL'         TO WS-140-MTH-DESC                
               WHEN 08                                                  
                   MOVE 'AUG'         TO WS-140-MTH-DESC                
               WHEN 09                                                  
                   MOVE 'SEP'         TO WS-140-MTH-DESC                
               WHEN 10                                                  
                   MOVE 'OCT'         TO WS-140-MTH-DESC                
               WHEN 11                                                  
                   MOVE 'NOV'         TO WS-140-MTH-DESC                
               WHEN 12                                                  
                   MOVE 'DEC'         TO WS-140-MTH-DESC                
           END-EVALUATE.                                                
      *                                                                         
       6485-CPD140-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  6490-PROCESS-CX-NO-UNITS.                             **              
      **                                                        **              
      **                                                        **              
      ************************************************************              
       6490-PROCESS-CX-NO-UNITS.                                        
      *                                                                         
           MOVE BG-BILL-NO                TO CX-BILL-NO.                
           MOVE BG-BILL-ITEM-TIMESTMP     TO CX-BILL-ITEM-TIMESTMP.     
                                                                        
           PERFORM 7888-SELECT-CNSMPTN-HIST THRU 7888-CPD140-EXIT.      
                                                                        
           IF CX-NO-UNITS = 0                                           
              ADD 1                       TO WS-140-NO-CNSC-ZERO-USE    
              PERFORM 7666-FETCH-BILLING-DET    THRU 7666-CPD140-EXIT   
           END-IF.                                                      
      *                                                                         
       6490-CPD140-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  7111-CALC-DATE-3-MNTH-AGO.                            **              
      ************************************************************              
      *                                                                         
       7111-CALC-DATE-3-MNTH-AGO.                                       
      *                                                                         
           EXEC SQL                                                     
T34097        SELECT
              DATEADD( MONTH, -3, IIF(TRY_CONVERT(DATE, 
                                                    :WS-140-FORMAT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-140-FORMAT-DATE
              ) <> 0) OR (LEN(:WS-140-FORMAT-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-140-FORMAT-DATE
              ), CONVERT(DATE, :WS-140-FORMAT-DATE) ) )
            INTO
              :WS-140-DATE-3-MTHS-AGO                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET  :WS-140-DATE-3-MTHS-AGO =                                    
MFA-TR*         DATE(:WS-140-FORMAT-DATE) - 3 MONTHS                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE SQLCODE                   TO RS-RETURN-CODE     
                   MOVE SPACES                    TO ABEND-FILE         
                   MOVE '7111'                    TO ACTIVE-PARAGRAPH   
T34097             MOVE 'SET'                     TO ABEND-FUNCTION     
                   MOVE 'DATE3 MTHS AGO'          TO TABLE-ELEMENT-1    
                   MOVE WS-140-FORMAT-DATE        TO HOSTVAR-ELEMENT-1  
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
      *                                                                         
       7111-CPD140-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ************************************************************              
A04880**  CALCULATE DATE USING UT-ZERO-USE-INVEST-DT            **              
A04880**     AND B2-CNSC-MTH-ZERO-USE TO DETERMINE IF WQ        **              
A04880**     SHOULD BE CREATED.                                 **              
      ************************************************************              
      *                                                                         
A04880 7144-CALC-DATE-FOR-WQ.                                           
      *                                                                         
A04880     EXEC SQL                                                     
A04880        SELECT
              DATEADD( MONTH, :WS-140-WQ-MONTHS, IIF(TRY_CONVERT(DATE, 
                                                 :UT-ZERO-USE-INVEST-DT
              ) IS NULL OR (PATINDEX('%.%', :UT-ZERO-USE-INVEST-DT
              ) <> 0) OR (LEN(:UT-ZERO-USE-INVEST-DT
              ) <> 10), CIS.CHAR2DATE(:UT-ZERO-USE-INVEST-DT
              ), CONVERT(DATE, :UT-ZERO-USE-INVEST-DT) ) )
            INTO
              :WS-140-WQ-DATE                    
A04880     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET  :WS-140-WQ-DATE  =                                           
MFA-TR*         DATE(:UT-ZERO-USE-INVEST-DT)                                    
MFA-TR*                   + :WS-140-WQ-MONTHS MONTHS                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
A04880     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A04880     EVALUATE WS-ACTIVE-RETURN-CODE                               
A04880         WHEN SUCCESSFUL-CALL                                     
A04880             CONTINUE                                             
A04880         WHEN OTHER                                               
A04880             MOVE SQLCODE                   TO RS-RETURN-CODE     
A04880             MOVE SPACES                    TO ABEND-FILE         
A04880             MOVE '7144'                    TO ACTIVE-PARAGRAPH   
A04880             MOVE 'SET'                     TO ABEND-FUNCTION     
A04880             MOVE 'WQ DATE '                TO TABLE-ELEMENT-1    
A04880             MOVE UT-ZERO-USE-INVEST-DT     TO HOSTVAR-ELEMENT-1  
A04880             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A04880     END-EVALUATE.                                                
      *                                                                         
A04880 7144-CPD140-EXIT.                                                
A04880     EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  7222-SELECT-MTHS-ZERO-USE.                            **              
      ************************************************************              
       7222-SELECT-MTHS-ZERO-USE.                                       
      *                                                                         
            EXEC SQL                                                    
                SELECT  FRST_MTH_ZERO_USE,                              
                        LAST_MTH_ZERO_USE,                              
                        CNSC_MTH_ZERO_USE,                              
                        SEASONAL_USE_DESC                               
                INTO   :B2-FRST-MTH-ZERO-USE,                           
                       :B2-LAST-MTH-ZERO-USE,                           
                       :B2-CNSC-MTH-ZERO-USE,                           
                       :B2-SEASONAL-USE-DESC                            
                FROM   CSS_SEASONAL_USE WITH(READUNCOMMITTED)                   
                WHERE  SEASONAL_USE_CD    = :B2-SEASONAL-USE-CD         
                  AND  CODE_UTIL_TYPE     = :B2-CODE-UTIL-TYPE          
T34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT  FRST_MTH_ZERO_USE,                                      
MFA-TR*                 LAST_MTH_ZERO_USE,                                      
MFA-TR*                 CNSC_MTH_ZERO_USE,                                      
MFA-TR*                 SEASONAL_USE_DESC                                       
MFA-TR*         INTO   :B2-FRST-MTH-ZERO-USE,                                   
MFA-TR*                :B2-LAST-MTH-ZERO-USE,                                   
MFA-TR*                :B2-CNSC-MTH-ZERO-USE,                                   
MFA-TR*                :B2-SEASONAL-USE-DESC                                    
MFA-TR*         FROM   CSS_SEASONAL_USE                                         
MFA-TR*         WHERE  SEASONAL_USE_CD    = :B2-SEASONAL-USE-CD                 
MFA-TR*           AND  CODE_UTIL_TYPE     = :B2-CODE-UTIL-TYPE                  
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE SQLCODE                   TO RS-RETURN-CODE     
                   MOVE SPACES                    TO ABEND-FILE         
                   MOVE '7222'                    TO ACTIVE-PARAGRAPH   
                   MOVE 'SELECT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_SEASONAL_USE'        TO TABLE-1            
                   MOVE 'SEASONAL_USE_CD'         TO TABLE-ELEMENT-1    
                   MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2    
                   MOVE B2-SEASONAL-USE-CD        TO HOSTVAR-ELEMENT-1  
                   MOVE B2-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2  
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
      *                                                                         
       7222-CPD140-EXIT.                                                
           EXIT.                                                        
      ************************************************************              
      **  7333-SELECT-CUST-DETAILS.                             **              
      **                                                        **              
      ************************************************************              
       7333-SELECT-CUST-DETAILS.                                        
      *                                                                         
           EXEC SQL                                                     
                SELECT AT.COMPANY_NO                                    
                      ,AT.CUSTOMER_NO                                   
                      ,AT.PREMISE_NO                                    
                      ,AT.LOCAL_OFFICE                                  
                  INTO :AT-COMPANY-NO                                   
                      ,:AT-CUSTOMER-NO                                  
                      ,:AT-PREMISE-NO                                   
                      ,:AT-LOCAL-OFFICE                                 
                  FROM CSS_ACCOUNT  AT WITH(READUNCOMMITTED)                    
                 WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                   
T34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT AT.COMPANY_NO                                            
MFA-TR*               ,AT.CUSTOMER_NO                                           
MFA-TR*               ,AT.PREMISE_NO                                            
MFA-TR*               ,AT.LOCAL_OFFICE                                          
MFA-TR*           INTO :AT-COMPANY-NO                                           
MFA-TR*               ,:AT-CUSTOMER-NO                                          
MFA-TR*               ,:AT-PREMISE-NO                                           
MFA-TR*               ,:AT-LOCAL-OFFICE                                         
MFA-TR*           FROM CSS_ACCOUNT  AT                                          
MFA-TR*          WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                           
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE SQLCODE                   TO RS-RETURN-CODE     
                   MOVE SPACES                    TO ABEND-FILE         
                   MOVE '7333'                    TO ACTIVE-PARAGRAPH   
                   MOVE 'SELECT'                  TO ABEND-FUNCTION     
                   MOVE 'CSS_ACCOUNT'             TO TABLE-1            
                   MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1    
                   MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1  
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
               END-EVALUATE.                                            
      *                                                                         
       7333-CPD140-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  7444-SELECT-ZERO-USE-INV-DATE                         **              
      **   SELECTS ZERO USE INVEST DATE FROM UTIL_ENVRNMT       **              
      ************************************************************              
       7444-SELECT-ZERO-USE-INV-DATE.                                   
      *                                                                         
            EXEC SQL                                                    
                SELECT UT.ZERO_USE_INVEST_DT                            
                      ,UT.CODE_REVENUE_CLASS                            
                      ,UT.SEASONAL_USE_CODE                             
                      ,RD.SECURED_RATE_FL                               
                      ,MN.MTR_REF_NO                                    
                      ,MN.REG_ID_NO                                     
                      ,MN.CODE_TIME_PERIOD                              
                INTO   :UT-ZERO-USE-INVEST-DT :WS-140-NULL-IND1          
                      ,:UT-CODE-REVENUE-CLASS                           
                      ,:UT-SEASONAL-USE-CODE                            
                      ,:RD-SECURED-RATE-FL                              
                      ,:MN-MTR-REF-NO                                   
                      ,:MN-REG-ID-NO                                    
                      ,:MN-CODE-TIME-PERIOD                             
                FROM   CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)              
                      ,CSS_MTRD_ENVRNMT   MN WITH(READUNCOMMITTED)              
                      ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)              
                WHERE  MN.ACCOUNT_NO     = :MN-ACCOUNT-NO               
                AND    MN.CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE           
                AND    MN.METER_NO       = :MN-METER-NO                 
                AND    MN.IC_NO          = :MN-IC-NO                    
                AND    UT.ACCOUNT_NO     = MN.ACCOUNT_NO                
                AND    UT.CODE_UTIL_TYPE = MN.CODE_UTIL_TYPE            
                AND    UT.IC_NO          = MN.IC_NO                     
                AND    RD.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE            
                AND    RD.RATE_PLAN_NO   = UT.RATE_PLAN_NO              
T34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT UT.ZERO_USE_INVEST_DT                                    
MFA-TR*               ,UT.CODE_REVENUE_CLASS                                    
MFA-TR*               ,UT.SEASONAL_USE_CODE                                     
MFA-TR*               ,RD.SECURED_RATE_FL                                       
MFA-TR*               ,MN.MTR_REF_NO                                            
MFA-TR*               ,MN.REG_ID_NO                                             
MFA-TR*               ,MN.CODE_TIME_PERIOD                                      
MFA-TR*         INTO   :UT-ZERO-USE-INVEST-DT:WS-140-NULL-IND1                  
MFA-TR*               ,:UT-CODE-REVENUE-CLASS                                   
MFA-TR*               ,:UT-SEASONAL-USE-CODE                                    
MFA-TR*               ,:RD-SECURED-RATE-FL                                      
MFA-TR*               ,:MN-MTR-REF-NO                                           
MFA-TR*               ,:MN-REG-ID-NO                                            
MFA-TR*               ,:MN-CODE-TIME-PERIOD                                     
MFA-TR*         FROM   CSS_UTIL_ENVRNMT   UT                                    
MFA-TR*               ,CSS_MTRD_ENVRNMT   MN                                    
MFA-TR*               ,CSS_RATE_PLAN_DESC RD                                    
MFA-TR*         WHERE  MN.ACCOUNT_NO     = :MN-ACCOUNT-NO                       
MFA-TR*         AND    MN.CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                   
MFA-TR*         AND    MN.METER_NO       = :MN-METER-NO                         
MFA-TR*         AND    MN.IC_NO          = :MN-IC-NO                            
MFA-TR*         AND    UT.ACCOUNT_NO     = MN.ACCOUNT_NO                        
MFA-TR*         AND    UT.CODE_UTIL_TYPE = MN.CODE_UTIL_TYPE                    
MFA-TR*         AND    UT.IC_NO          = MN.IC_NO                             
MFA-TR*         AND    RD.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                    
MFA-TR*         AND    RD.RATE_PLAN_NO   = UT.RATE_PLAN_NO                      
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-140-NULL-IND1 < 0                                   
                 MOVE SPACES TO UT-ZERO-USE-INVEST-DT                   
              END-IF                                                    
           ELSE                                                         
              MOVE SQLCODE                   TO RS-RETURN-CODE          
              MOVE SPACES                    TO ABEND-FILE              
              MOVE '7444'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
              MOVE 'CSS_MTRD_ENVRNMT'        TO TABLE-2                 
              MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-3                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE 'METER_NO'                TO TABLE-ELEMENT-4         
              MOVE MN-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE MN-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE MN-IC-NO                  TO HOSTVAR-ELEMENT-3       
              MOVE MN-METER-NO               TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7444-CPD140-EXIT.                                                
           EXIT.                                                        
      *****************************************************************         
      ** OPEN CURSOR FOR CSS_BILLING_HDR                             **         
      *****************************************************************         
       7555-OPEN-BILLING-DET.                                           
      *                                                                         
           EXEC SQL                                                     
                OPEN CPD140_BG_CRSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                   TO RS-RETURN-CODE         
               MOVE SPACES                    TO ABEND-FILE             
               MOVE '7555'                    TO ACTIVE-PARAGRAPH       
               MOVE 'OPEN'                    TO ABEND-FUNCTION         
               MOVE 'CSS_BILING_DET'          TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2        
               MOVE 'IC_NO'                   TO TABLE-ELEMENT-3        
               MOVE 'REVENUE_MONTH'           TO TABLE-ELEMENT-4        
               MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               MOVE BG-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2      
               MOVE BG-IC-NO                  TO HOSTVAR-ELEMENT-3      
               MOVE BG-REVENUE-MONTH          TO HOSTVAR-ELEMENT-4      
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       7555-CPD140-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** FETCH CURSOR FOR CSS_BILLING_DET                            **         
      *****************************************************************         
       7666-FETCH-BILLING-DET.                                          
      *                                                                         
           EXEC SQL                                                     
               FETCH CPD140_BG_CRSR                                     
                INTO :BG-BILL-NO                                        
                    ,:BG-BILL-ITEM-TIMESTMP                             
                    ,:BG-REVENUE-MONTH                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               MOVE SQLCODE                   TO RS-RETURN-CODE         
               MOVE SPACES                    TO ABEND-FILE             
               MOVE '7666'                    TO ACTIVE-PARAGRAPH       
               MOVE 'FETCH'                   TO ABEND-FUNCTION         
               MOVE 'CSS_BILING_DET'          TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2        
               MOVE 'IC_NO'                   TO TABLE-ELEMENT-3        
               MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               MOVE BG-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2      
               MOVE BG-IC-NO                  TO HOSTVAR-ELEMENT-3      
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       7666-CPD140-EXIT.                                                
           EXIT.                                                        
      *****************************************************************         
      ** CLOSE CURSOR FOR CSS_BILLING_DET                            **         
      *****************************************************************         
       7777-CLOSE-BILLING-DET.                                          
      *                                                                         
           EXEC SQL                                                     
               CLOSE CPD140_BG_CRSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                   TO RS-RETURN-CODE         
               MOVE SPACES                    TO ABEND-FILE             
               MOVE '7777'                    TO ACTIVE-PARAGRAPH       
               MOVE 'CLOSE'                   TO ABEND-FUNCTION         
               MOVE 'CSS_BILING_DET'          TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2        
               MOVE 'IC_NO'                   TO TABLE-ELEMENT-3        
               MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               MOVE BG-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2      
               MOVE BG-IC-NO                  TO HOSTVAR-ELEMENT-3      
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       7777-CPD140-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  7888-SELECT-CNSMPTN-HIST                              **              
      **                                                        **              
      ************************************************************              
       7888-SELECT-CNSMPTN-HIST.                                        
      *                                                                         
           EXEC SQL                                                     
               SELECT COALESCE(SUM(NO_UNITS),0)                           
                 INTO :CX-NO-UNITS                                      
                 FROM CSS_CNSMPTN_HIST WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO               
                  AND BILL_NO            = :CX-BILL-NO                  
                  AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE           
                  AND IC_NO              = :CX-IC-NO                    
                  AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )       
                  AND MTR_REF_NO         = :CX-MTR-REF-NO               
                  AND REG_ID_NO          = :CX-REG-ID-NO                
                  AND CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD         
T34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IFNULL(SUM(NO_UNITS),0)                                   
MFA-TR*          INTO :CX-NO-UNITS                                              
MFA-TR*          FROM CSS_CNSMPTN_HIST                                          
MFA-TR*         WHERE ACCOUNT_NO         = :CX-ACCOUNT-NO                       
MFA-TR*           AND BILL_NO            = :CX-BILL-NO                          
MFA-TR*           AND CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE                   
MFA-TR*           AND IC_NO              = :CX-IC-NO                            
MFA-TR*           AND BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP               
MFA-TR*           AND MTR_REF_NO         = :CX-MTR-REF-NO                       
MFA-TR*           AND REG_ID_NO          = :CX-REG-ID-NO                        
MFA-TR*           AND CODE_TIME_PERIOD   = :CX-CODE-TIME-PERIOD                 
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO RS-RETURN-CODE          
              MOVE SPACES                    TO ABEND-FILE              
              MOVE '7888'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CNSMPTN_HIST'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-4         
              MOVE CX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CX-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE CX-IC-NO                  TO HOSTVAR-ELEMENT-3       
              MOVE CX-BILL-NO                TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7888-CPD140-EXIT.                                                
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** END OF COPYBOOK CPD00140                                    **         
      *****************************************************************         
