      *****************************************************************         
      ***************************************************************           
      *  CPD00128    INTEREST HISTORY UPDATE/INSERT                 *           
      *                                                             *           
      ***************************************************************           
      *                 P R O G R A M  S U M M A R Y                *           
      *                                                             *           
      *  THIS PROCEDURE DIVISION WILL INSERT OR UPDATE RECORDS INTO *           
      *  TABLE CSS_INTREST_HIST.  THIS COPYBOOK IS CALLED BY        *           
      *  CPD00023.                                                  *           
      *                                                             *           
      ***************************************************************           
      *                                                             *           
      *                PROGRAM  MODIFICATION  LOG                   *           
      *                                                             *           
      *     DATE     INITIALS   COMMENTS                            *           
      *   --------   --------   ----------------------------------  *           
      *   06/20/96     CS       TPR 3753 CREATED AS A PART OF TPR   *           
C29752*   01/11/03     MJ       IF WS-RECALC-SWITCH IS SET TO 'Y'   *           
C29752*                         REMOVE PREVIOUS INSERTED ROWS FROM  *           
C29752*                         CSS_INTEREST_HIST TABLE.            *           
      *                                                             *           
      ***************************************************************           
      ***************************************************************           
                                                                        
       6050-PROCESS-INTEREST-HIST.                                      
           MOVE DP-ACCOUNT-NO                TO IH-ACCOUNT-NO.          
           MOVE DP-DEPOSIT-CERT-NO           TO IH-DEPOSIT-CERT-NO.     
           MOVE WS-EFF-DATE-FROM (WS-INT-INDX)                          
                                             TO IH-EFFECTIVE-DT         
           MOVE WS-REFUND-DATE               TO IH-INT-CREDIT-DT.       
           MOVE WS-CURR-INTRST-CALC          TO IH-INTEREST-AMT.        
           MOVE WS-INTRST-RATE (WS-INT-INDX) TO IH-INTEREST-RT.         
C29752     IF INT-WAS-RECALCULATED                                      
C29752        PERFORM 6080-DELETE-INTEREST-HIST    THRU 6080-EXIT       
C29752     END-IF                                                       
           PERFORM 6070-UPDATE-INTEREST-HIST       THRU 6070-EXIT.      
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
                PERFORM 6060-INSERT-INTEREST-HIST  THRU 6060-EXIT       
           END-IF.                                                      
       6050-EXIT.                                                       
      **************************************************************            
      * 6060-INSERT-INTEREST-HIST.                                 *            
      *                                                            *            
      * PERFORMED BY 6050-PROCESS-INTEREST-HIST.                   *            
      *                                                            *            
      **************************************************************            
       6060-INSERT-INTEREST-HIST.                                       
                                                                        
           MOVE '6060'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_INTEREST_HIST                             
                 (ACCOUNT_NO,                                           
                  DEPOSIT_CERT_NO,                                      
                  EFFECTIVE_DT,                                         
                  INT_CREDIT_DT,                                        
                  INTEREST_AMT,                                         
                  INTEREST_RT)                                          
              VALUES                                                    
                 (:IH-ACCOUNT-NO,                                       
                  :IH-DEPOSIT-CERT-NO,                                  
                  IIF(TRY_CONVERT(DATE, :IH-EFFECTIVE-DT
              ) IS NULL OR (PATINDEX('%.%', :IH-EFFECTIVE-DT
              ) <> 0) OR (LEN(:IH-EFFECTIVE-DT) <> 10), CIS.CHAR2DATE(
                                                       :IH-EFFECTIVE-DT
              ), CONVERT(DATE, :IH-EFFECTIVE-DT) ),                            
                  IIF(TRY_CONVERT(DATE, :IH-INT-CREDIT-DT
              ) IS NULL OR (PATINDEX('%.%', :IH-INT-CREDIT-DT
              ) <> 0) OR (LEN(:IH-INT-CREDIT-DT) <> 10), CIS.CHAR2DATE(
                                                      :IH-INT-CREDIT-DT
              ), CONVERT(DATE, :IH-INT-CREDIT-DT) ),                           
                  :IH-INTEREST-AMT,                                     
                  :IH-INTEREST-RT)                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_INTEREST_HIST                                     
MFA-TR*          (ACCOUNT_NO,                                                   
MFA-TR*           DEPOSIT_CERT_NO,                                              
MFA-TR*           EFFECTIVE_DT,                                                 
MFA-TR*           INT_CREDIT_DT,                                                
MFA-TR*           INTEREST_AMT,                                                 
MFA-TR*           INTEREST_RT)                                                  
MFA-TR*       VALUES                                                            
MFA-TR*          (:IH-ACCOUNT-NO,                                               
MFA-TR*           :IH-DEPOSIT-CERT-NO,                                          
MFA-TR*           :IH-EFFECTIVE-DT,                                             
MFA-TR*           :IH-INT-CREDIT-DT,                                            
MFA-TR*           :IH-INTEREST-AMT,                                             
MFA-TR*           :IH-INTEREST-RT)                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSS_INTEREST_HIST'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE IH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'DEPOSIT_CERT_NO'     TO TABLE-ELEMENT-2             
              MOVE IH-DEPOSIT-CERT-NO    TO HOSTVAR-ELEMENT-2           
              MOVE 'EFFECTIVE_DT'        TO TABLE-ELEMENT-3             
              MOVE IH-EFFECTIVE-DT       TO HOSTVAR-ELEMENT-3           
              MOVE 'INT_CREDIT_DT'       TO TABLE-ELEMENT-4             
              MOVE IH-INT-CREDIT-DT      TO HOSTVAR-ELEMENT-4           
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       6060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 6070-UPDATE-INTEREST-HIST.                                 *            
      *                                                            *            
      * PERFORMED BY 6050-PROCESS-INTEREST-HIST.                   *            
      *                                                            *            
      **************************************************************            
       6070-UPDATE-INTEREST-HIST.                                       
                                                                        
           MOVE '6070'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_INTEREST_HIST                                  
                 SET INTEREST_RT     = :IH-INTEREST-RT,                 
                     INTEREST_AMT    = INTEREST_AMT + :IH-INTEREST-AMT  
               WHERE ACCOUNT_NO      = :IH-ACCOUNT-NO                   
                 AND DEPOSIT_CERT_NO = :IH-DEPOSIT-CERT-NO              
                 AND EFFECTIVE_DT    = IIF(TRY_CONVERT(DATE, 
                                                       :IH-EFFECTIVE-DT
              ) IS NULL OR (PATINDEX('%.%', :IH-EFFECTIVE-DT
              ) <> 0) OR (LEN(:IH-EFFECTIVE-DT) <> 10), CIS.CHAR2DATE(
                                                       :IH-EFFECTIVE-DT
              ), CONVERT(DATE, :IH-EFFECTIVE-DT) )                 
                 AND INT_CREDIT_DT   = IIF(TRY_CONVERT(DATE, 
                                                      :IH-INT-CREDIT-DT
              ) IS NULL OR (PATINDEX('%.%', :IH-INT-CREDIT-DT
              ) <> 0) OR (LEN(:IH-INT-CREDIT-DT) <> 10), CIS.CHAR2DATE(
                                                      :IH-INT-CREDIT-DT
              ), CONVERT(DATE, :IH-INT-CREDIT-DT) )                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_INTEREST_HIST                                          
MFA-TR*          SET INTEREST_RT     = :IH-INTEREST-RT,                         
MFA-TR*              INTEREST_AMT    = INTEREST_AMT + :IH-INTEREST-AMT          
MFA-TR*        WHERE ACCOUNT_NO      = :IH-ACCOUNT-NO                           
MFA-TR*          AND DEPOSIT_CERT_NO = :IH-DEPOSIT-CERT-NO                      
MFA-TR*          AND EFFECTIVE_DT    = :IH-EFFECTIVE-DT                         
MFA-TR*          AND INT_CREDIT_DT   = :IH-INT-CREDIT-DT                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_INTEREST_HIST'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE IH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'DEPOSIT_CERT_NO'     TO TABLE-ELEMENT-2             
              MOVE IH-DEPOSIT-CERT-NO    TO HOSTVAR-ELEMENT-2           
              MOVE 'EFFECTIVE_DT'        TO TABLE-ELEMENT-3             
              MOVE IH-EFFECTIVE-DT       TO HOSTVAR-ELEMENT-3           
              MOVE 'INT_CREDIT_DT'       TO TABLE-ELEMENT-4             
              MOVE IH-INT-CREDIT-DT      TO HOSTVAR-ELEMENT-4           
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       6070-EXIT.                                                       
           EXIT.                                                        
                                                                        
C29752**************************************************************            
      * 6080-DELETE-INTEREST-HIST.                                 *            
      *                                                            *            
      * PERFORMED BY 6050-PROCESS-INTEREST-HIST.                   *            
      *                                                            *            
      **************************************************************            
C29752 6080-DELETE-INTEREST-HIST.                                       
                                                                        
           MOVE '6080'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_INTEREST_HIST                             
               WHERE ACCOUNT_NO      = :IH-ACCOUNT-NO                   
                 AND DEPOSIT_CERT_NO = :IH-DEPOSIT-CERT-NO              
                 AND EFFECTIVE_DT    = IIF(TRY_CONVERT(DATE, 
                                                       :IH-EFFECTIVE-DT
              ) IS NULL OR (PATINDEX('%.%', :IH-EFFECTIVE-DT
              ) <> 0) OR (LEN(:IH-EFFECTIVE-DT) <> 10), CIS.CHAR2DATE(
                                                       :IH-EFFECTIVE-DT
              ), CONVERT(DATE, :IH-EFFECTIVE-DT) )                 
                 AND INT_CREDIT_DT   = IIF(TRY_CONVERT(DATE, 
                                                      :IH-INT-CREDIT-DT
              ) IS NULL OR (PATINDEX('%.%', :IH-INT-CREDIT-DT
              ) <> 0) OR (LEN(:IH-INT-CREDIT-DT) <> 10), CIS.CHAR2DATE(
                                                      :IH-INT-CREDIT-DT
              ), CONVERT(DATE, :IH-INT-CREDIT-DT) )                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_INTEREST_HIST                                     
MFA-TR*        WHERE ACCOUNT_NO      = :IH-ACCOUNT-NO                           
MFA-TR*          AND DEPOSIT_CERT_NO = :IH-DEPOSIT-CERT-NO                      
MFA-TR*          AND EFFECTIVE_DT    = :IH-EFFECTIVE-DT                         
MFA-TR*          AND INT_CREDIT_DT   = :IH-INT-CREDIT-DT                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_INTEREST_HIST'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE IH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'DEPOSIT_CERT_NO'     TO TABLE-ELEMENT-2             
              MOVE IH-DEPOSIT-CERT-NO    TO HOSTVAR-ELEMENT-2           
              MOVE 'EFFECTIVE_DT'        TO TABLE-ELEMENT-3             
              MOVE IH-EFFECTIVE-DT       TO HOSTVAR-ELEMENT-3           
              MOVE 'INT_CREDIT_DT'       TO TABLE-ELEMENT-4             
              MOVE IH-INT-CREDIT-DT      TO HOSTVAR-ELEMENT-4           
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
C29752 6080-EXIT.                                                       
           EXIT.                                                        
                                                                        
