      *****************************************************************         
      **                                                              **00022008
      **   CPD00126                                                   **00023008
      **     THIS COPY STATEMENT CONTAINS THE PROCEDURE DIVISION      **00024008
      **   STATEMENTS NECESSARY TO CREATE A NEW ACCOUNT NUMBER.       **00025008
      **                                                              **00027008
      **..............................................................**00028008
      **                                                              **        
      **              PROGRAM  MODIFICATION  LOG                      **        
      **    DATE   INTIALS   REASON                                   **        
      **    ____   _______   ______                                   **        
      **    0496     SD      COPYBOOK ORIGINALLY WRITTEN              **        
      **                                                              **        
      **    0197    RPG      TPR#8720 - CHANGED THE JRNL-INSERT TO    **        
      **                     ONLY ADD THE ACCOUNT NUM AND NOT CUSTOMER**        
      **    1002    GAC      MOVE 'AT', NOT SPACE TO MI-TABLE-ID      **        
      **    1008    GAC      TOOK OUT ABOVE.                          **        
      ******************************************************************        
      **     *     *     *     *     *     *     *     *     *       ***        
      **   CALL PARA 6102-GET-NEW-ACCOUNT-NO.                        ***00027008
      **                                                             ***        
      **  INCLUDE CWS0126A.  ( WORKING STORAGE FOR THIS CPD00126 )   ***        
      **                                                             ***        
      **  INCLUDE CPD00071.  ( CODE FOR CALCULATING CHECK DIGIT )    ***        
      **                                                             ***        
      **  INCLUDE CPD00067.  ( MAINTENANCE TRANSACTION HISTORY )     ***        
      **                                                             ***        
      **  INCLUDE THE FOLLOWING DECLGEN IN THE CALLING RPC           ***        
      **                                                             ***        
      **  TBATCNTL                                                   ***        
      **  TBUSRPRF                                                   ***        
      **  TBMNHIST                                                   ***        
      **  TBMNHDT                                                    ***        
      **                                                             ***        
      **  PASS INFORMATION IN THE FOLLOWING VARIABLE.                ***        
      **                                                             ***        
      **  WS-126-CUSTOMER-NO           ( PASS CUSTOMER-NO )          ***        
      **  WS-126-CURRENT-DATE          ( PASS CURRENT DATE )         ***        
      **  WS-126-CURRENT-TIMESTAMP     ( PASS CURRENT TIMESTAMP )    ***        
      **  WS-126-USERID                ( PASS USER ID OF THE SYSTEM )***        
      **  WS-126-PANEL-NO              ( PASS THE PANEL NO )         ***        
      **  WS-126-TRANS-COMMENTS        ( PASS TRANSACTION COMMENTS ) ***        
      **  WS-126-TRANS-COMMENTS-LEN    ( PASS TRAN COMMENTS LENGTH ) ***        
      **                                                             ***        
      **  RESULT WILL IN    WS-126-NEW-ACCOUNT-NO                    ***        
      **                                                             ***        
      **                                                             ***        
      **     *     *     *     *     *     *     *     *     *       ***        
      ******************************************************************        
       6102-GET-NEW-ACCOUNT-NO.                                         
                                                                        
           MOVE '6102' TO ACTIVE-PARAGRAPH.                             
                                                                        
      *-------------------------------*                                         
      * DETERMINE NEW ACCOUNT NUMBER. *                                         
      *-------------------------------*                                         
           PERFORM 6104-LOCK-CUST-NO-CNTRL   THRU 6104-EXIT             
           PERFORM 6106-SELECT-ACCT-NO-CNTL  THRU 6106-EXIT.            
                                                                        
      *** SORRY ! WE ARE FULL. WE CANNOT GIVE YOU ANY MORE ACCOUNT NO.          
           IF ( NA-LAST-ACCT-NO-USED >= WS-MAX-ACCT-CNTL )              
              MOVE WS-MAX-ACCT-ERROR-CODE    TO RS-RETURN-CODE          
                                                WS-ACTIVE-RETURN-CODE   
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
           ADD 1                             TO NA-LAST-ACCT-NO-USED.   
                                                                        
      ***-------------------------------------------------------------**        
      *** WE CANNOT HAVE ACCOUNT NO'S FROM 230097000000X TO           **        
      *** 230098000000X FOR CSR. BECAUSE THOSE NUMBERS ARE SPECIFIC   **        
      *** TO GAS ACCOUNTING.                                          **        
      *** THIS CODE DOESN'T GIVE BACK ANY WARNING ,IT SIMPLY STARTS   **        
      *** ASSIGNING NEXT VALID ACCOUNT_NO_CNTL VALUE.                 **        
      *** FOR NEXT ACCOUNT NO WHATEVER MIGHT BE THE PARTITION NO WE   **        
      *** WILL ALWAYS LOOSE THE BLOCK.                                **        
      ***-------------------------------------------------------------**        
           IF ( WS-126-CUST-PARTITION  = 2                              
           AND  NA-LAST-ACCT-NO-USED  >= WS-GAS-ACCT-START-NO           
           AND  NA-LAST-ACCT-NO-USED  <  WS-NEXT-VALID-ACCT-NO )        
                                                                        
              MOVE WS-NEXT-VALID-ACCT-NO     TO NA-LAST-ACCT-NO-USED    
           END-IF.                                                      
                                                                        
           MOVE WS-126-CUST-PARTITION        TO WS-126-LEFT-MOST-DIGIT. 
           MOVE NA-LAST-ACCT-NO-USED         TO WS-126-RIGHT-11-DGT-C.  
           MOVE WS-126-RIGHT-11-DGT-C        TO WS-126-RIGHT-11-DIGIT.  
                                                                        
           MOVE WS-126-AT-12-DGT-BREAK       TO WS-NBR-TO-BE-CHECKED2   
                                                WS-126-ACCT-NO-12.      
           PERFORM 6210-CALCULATE-CHECK-DIGIT  THRU 6210-EXIT.          
           MOVE WS-CHECK-DIGIT2              TO WS-126-ACCT-CHECK-DGT.  
           MOVE WS-126-ACCOUNT-NO            TO WS-126-NEW-ACCOUNT-NO.  
                                                                        
           PERFORM 6108-UPDATE-ACCT-NO-CNTL    THRU 6108-EXIT.          
                                                                        
           PERFORM 6123-JRNL-INSERT            THRU 6123-EXIT.          
       6102-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6123-JRNL-INSERT.                                              *        
      * 1.   MOVE ANY POPULATED INSERT FIELDS TO THE MAINENENCE        *        
      *      TRANSACTION DETAIL RECORD AND CALL COMMON PARAGRAPH FOR   *        
      *      WRITING THE ROW.                                          *        
      *                                                                *        
      ******************************************************************        
       6123-JRNL-INSERT.                                                
                                                                        
           MOVE '6123'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           MOVE SPACE                       TO MI-TABLE-ID.             
                                                                        
           IF WS-126-USERID > SPACES                                    
              MOVE WS-126-USERID            TO PF-USER-ID               
              PERFORM 6126-GET-RESP-AREA-ID THRU 6126-EXIT              
           END-IF.                                                      
                                                                        
           IF  WS-126-CURRENT-TIMESTAMP > SPACES                        
           AND WS-126-CURRENT-DATE      > SPACES                        
               MOVE WS-126-CURRENT-TIMESTAMP    TO MH-TRANS-HIST-SEQ-NO 
                                                   MI-TRANS-HIST-SEQ-NO 
               MOVE WS-126-CURRENT-DATE         TO MH-DATE-TRANS        
           ELSE                                                         
               PERFORM 6128-GET-CURRENT-DATE-TIME THRU 6128-EXIT        
           END-IF.                                                      
                                                                        
           MOVE 'F'                         TO MH-CODE-TRAN-TYPE.       
           MOVE WS-126-USERID               TO MH-USER-ID.              
           MOVE WS-126-PANEL-NO             TO MH-APPL-PROGRAM-ID.      
           MOVE PF-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE WS-126-NEW-ACCOUNT-NO       TO MH-ACCOUNT-NO.           
T8720      MOVE 0                           TO MH-CUSTOMER-NO.          
           MOVE 0                           TO MH-PREMISE-NO.           
           IF WS-126-TRANS-COMMENTS-LEN > 0                             
              MOVE WS-126-TRANS-COMMENTS     TO MH-TRAN-COMMENT-TEXT    
              MOVE WS-126-TRANS-COMMENTS-LEN TO MH-TRAN-COMMENT-LEN     
           ELSE                                                         
              MOVE SPACES                   TO MH-TRAN-COMMENT-TEXT     
              MOVE 0                        TO MH-TRAN-COMMENT-LEN      
           END-IF.                                                      
                                                                        
           MOVE '*NEW*'                     TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE +5                          TO MI-PRV-COLUMN-VALUE-LEN. 
                                                                        
           MOVE +1                          TO MI-TRAN-APPL-NO.         
           MOVE 'ACCOUNT NO     '           TO MI-COLUMN-DESC.          
           MOVE +13                         TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-126-ACCT-NO-STR          TO MI-CHG-COLUMN-VALUE-TEXT.
                                                                        
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
       6123-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6104-LOCK-CUST-NO-CNTRL.                                       *        
      *                                                                *        
      *    1.  LOCK THE CUSTOMER NUMBER CONTROL TABLE.                 *        
      *                                                                *        
      ******************************************************************        
       6104-LOCK-CUST-NO-CNTRL.                                         
                                                                        
           EXEC SQL                                                     
              CALL CIS.LOCK_TABLE_IN_EXCLUSIVE_MODE('CSS_ACCT_NO_CNTL')         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '6104'                TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'LOCK TABLE'          TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_NO_CNTL'    TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       6104-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6106-SELECT-ACCT-NO-CNTL                                       *        
      *                                                                *        
      *    1. SELECT THE LAST ACCOUNT NUMBER USED IN ORDER TO CREATE   *        
      *       A NEW ACCOUNT NUMBER.                                    *        
      *                                                                *        
      ******************************************************************        
       6106-SELECT-ACCT-NO-CNTL.                                        
                                                                        
           EXEC SQL                                                     
              SELECT LAST_ACCT_NO_USED                                  
                INTO :NA-LAST-ACCT-NO-USED                              
                FROM CSS_ACCT_NO_CNTL                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '6106'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_NO_CNTL'    TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       6106-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6108-UPDATE-ACCT-NO-CNTL                                       *        
      *                                                                *        
      *    1. SAVE INCREMENTED LAST NUMBER USED.                       *        
      *                                                                *        
      ******************************************************************        
       6108-UPDATE-ACCT-NO-CNTL.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCT_NO_CNTL                                   
                 SET LAST_ACCT_NO_USED = :NA-LAST-ACCT-NO-USED          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '6108'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_NO_CNTL'    TO TABLE-1                     
              MOVE 'LAST_CUST_NO_USED'   TO TABLE-ELEMENT-1             
              MOVE NA-LAST-ACCT-NO-USED  TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       6108-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6126 GET RESP AREA ID                                          *        
      *      -- THIS MODULE FINDS THE RESPONSIBLE AREA IDENTIFICATION  *        
      *         ACCORDING TO A USERS ID.                               *        
      ******************************************************************        
       6126-GET-RESP-AREA-ID.                                           
                                                                        
           MOVE '6126'         TO ACTIVE-PARAGRAPH.                     
                                                                        
           EXEC SQL                                                     
               SELECT RESP_AREA_ID                                      
                 INTO :PF-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE                                  
                WHERE USER_ID = :PF-USER-ID                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE       TO WS-ACTIVE-RETURN-CODE                  
                                 RS-RETURN-CODE.                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES TO PF-RESP-AREA-ID                         
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE        
                 MOVE PROGRAM-NAME             TO ABEND-PROGRAM         
                 MOVE '6126'                   TO ACTIVE-PARAGRAPH      
                 MOVE 'SELECT RESP-AREA-ID'    TO ABEND-FUNCTION        
                 MOVE 'CSS_USER_PROFILE  '     TO TABLE-1               
                 MOVE 'RESP-AREA-I'            TO TABLE-ELEMENT-1       
                 MOVE PF-USER-ID               TO HOSTVAR-ELEMENT-1     
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
             END-IF                                                     
           END-IF.                                                      
       6126-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6128-GET-CURRENT-DATE-TIME.                                    *        
      *      --THIS MODULE DETERMINES THE TIMESTAMP FOR THE            *        
      *        MAINTENANCE TRANSACTION RECORD.                         *        
      ******************************************************************        
       6128-GET-CURRENT-DATE-TIME.                                      
           MOVE '6128'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-126-CURRENT-DATE                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-126-CURRENT-DATE = CURRENT DATE                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-126-CURRENT-TIMESTAMP        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-126-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE  RS-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '6128'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT CURRENT DATE'    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       6128-EXIT.                                                       
           EXIT.                                                        
                                                                        
