000001*****************************************************************         
000002* CPD TO RETREIVE READ CYCLE, DATE SERVICE INSTALLED, DEPOSIT   *         
000003* INTEREST RATE FOR DOCUMENTS PCSFRM10, PCSFRM11, PCSFRM12.     *         
000010* ADD NULL INDICATOR WS-IND-DATE-INSTALL AND WS-IND-READ-CYCLE  *         
      * TO WORKING STORAGE.                                           *         
000100*****************************************************************         
000200* CURSOR DECLARATION TO RETRIEVE THE READ CYCLE AND TURN ON DATE*         
000300* FOR AN ACCOUNTS UTILITY SERVICE.  ALTHOUGH THERE CAN BE       *         
000400* MULTIPLE ROWS RETRIEVED ONLY ONE ROW IS NEEDED.               *         
000500*****************************************************************         
000600     EXEC SQL                                                     
000700         DECLARE READ_CYCLE_CSR CURSOR FOR                        
000800         SELECT READ_CYCLE,                                       
000900                DATE_INSTALL                                      
001000         FROM   CSS_UTIL_ENVRNMT                                  
001100         WHERE  ACCOUNT_NO = :UT-ACCOUNT-NO                       
001200         AND    CODE_UTIL_TYPE IN ('E','G')                       
001300     END-EXEC.                                                    
001400*****************************************************************         
001500*  3900-PROCESS-FORM-DATA                                       *         
001600*  CPD00124 INCLUDE TO SELECT THE SERVICE TURN ON DATE, METER   *         
001700*  READ DATE, AND DEPOSIT INTEREST RATE FOR DOCUMENTS PCSFRM10, *         
001800*  PCSFRM11 AND PCSFRM12.  THESE DOCUMENTS ARE PRINTED FROM     *         
001900*  PANEL015, PANEL037, AND PANEL085. BE SURE TO INCLUDE         *         
002000*  COPYBOOKS FOR UT, PR, AND PC TABLES.                         *         
002100*****************************************************************         
002200 3900-PROCESS-FORM-DATA.                                          
002300     MOVE SPACES                  TO RS-READ-CYCLE.               
002400     MOVE SPACES                  TO RS-SERV-STRT-DT.             
002500*                                                                         
002600     PERFORM 4900-OPEN-READ-CYCLE-CSR           THRU 4900-EXIT.   
002700*                                                                         
002800     PERFORM 4910-FETCH-READ-CYCLE-CSR          THRU 4910-EXIT.   
002900*                                                                         
003000     PERFORM 4920-CLOSE-READ-CYCLE-CSR          THRU 4920-EXIT.   
003100*                                                                         
003110     IF WS-IND-READ-CYCLE = 0 THEN                                
003200          MOVE UT-READ-CYCLE      TO RS-READ-CYCLE                
003210     ELSE                                                         
003220          MOVE SPACES             TO RS-READ-CYCLE                
003230     END-IF.                                                      
003240*                                                                         
003250     IF WS-IND-DATE-INSTALL = 0 THEN                              
003300          MOVE UT-DATE-INSTALL    TO RS-SERV-STRT-DT              
003310     ELSE                                                         
003320          MOVE SPACES             TO RS-SERV-STRT-DT              
003330     END-IF.                                                      
003400*                                                                         
003500     PERFORM 4940-SELECT-REVENUE-DIST           THRU 4940-EXIT.   
003600*                                                                         
003700     MOVE PR-REV-DISTRICT-CD      TO P6-REV-DISTRICT-CD.          
003800     MOVE AT-COMPANY-NO           TO P6-COMPANY-NO.               
003900     MOVE AT-LOCAL-OFFICE         TO P6-LOCAL-OFFICE.             
004000*                                                                         
004100     PERFORM 4960-SELECT-CURRENT-DATE           THRU 4960-EXIT.   
004200*                                                                         
004300     PERFORM 4950-SELECT-INTEREST-RATE          THRU 4950-EXIT.   
004400*                                                                         
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
004500        MOVE P6-INTRST-RATE          TO RS-DEP-INTST-RT           
           ELSE                                                         
004500        MOVE ZEROES                  TO RS-DEP-INTST-RT           
           END-IF.                                                      
004600 3900-EXIT.                                                       
004700     EXIT.                                                        
004800*****************************************************************         
004900* 4900-OPEN-READ-CYCLE-CSR                                      *         
005000* OPEN THE READ CYCLE AND SERVICE START DATE CURSOR             *         
005300*                                                               *         
005400*****************************************************************         
005500 4900-OPEN-READ-CYCLE-CSR.                                        
005600     EXEC SQL                                                     
005700         OPEN READ_CYCLE_CSR                                      
005800     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

005900*                                                                         
006000     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
006100                                   RS-RETURN-CODE.                
006200*                                                                         
006300     IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
006400          NEXT SENTENCE                                           
006500     ELSE                                                         
006600        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
006700        MOVE '4900-OPEN-READ-CYCLE-CSR' TO ABEND-FUNCTION         
006800        MOVE 'OPEN'                     TO TABLE-1                
006900        MOVE 'READ_CYCLE_CSR'           TO TABLE-ELEMENT-1        
007000        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
007100        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
007200     END-IF.                                                      
007300 4900-EXIT.                                                       
007400     EXIT.                                                        
007500*****************************************************************         
007600* 4910-FETCH-READ-CYCLE-CSR *                                             
007700* SELECTS THE READ CYCLE AND SERVICE START DATE FOR AN ACCOUNT  *         
007800* THERE CAN BE MULITPLE READ CYCLES AND INSTALL DATE FOR AN     *         
007900* ACCOUNT ON UT BUT ONLY ONE IS NEEDED FOR THE CONTRACTS        *         
008000*                                                               *         
008100*****************************************************************         
008200 4910-FETCH-READ-CYCLE-CSR.                                       
008300     EXEC SQL                                                     
008400         FETCH READ_CYCLE_CSR                                     
008500         INTO  :UT-READ-CYCLE :WS-IND-READ-CYCLE,                  
008600               :UT-DATE-INSTALL :WS-IND-DATE-INSTALL               
008700     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

008800*                                                                         
008900     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
009000                                   RS-RETURN-CODE.                
009100*                                                                         
009200     IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
009300          NEXT SENTENCE                                           
009400     ELSE                                                         
009500        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
009600        MOVE '4900-OPEN-READ-CYCLE-CSR' TO ABEND-FUNCTION         
009700        MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-1                
009800        MOVE 'ACCOUNT_NO    '           TO TABLE-ELEMENT-1        
009900        MOVE UT-READ-CYCLE              TO HOSTVAR-ELEMENT-1      
010000        MOVE UT-DATE-INSTALL            TO HOSTVAR-ELEMENT-2      
010100        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
010200        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
010300     END-IF.                                                      
010400 4910-EXIT.                                                       
010500     EXIT.                                                        
010600*****************************************************************         
010700* 4920-CLOSE-READ-CYCLE-CSR                                     *         
010800* CLOSE THE READ CYCLE AND SERVICE START DATE CURSOR            *         
010900*                                                               *         
011000*****************************************************************         
011100 4920-CLOSE-READ-CYCLE-CSR.                                       
011200     EXEC SQL                                                     
011300         CLOSE READ_CYCLE_CSR                                     
011400     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

011500*                                                                         
011600     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
011700                                   RS-RETURN-CODE.                
011800*                                                                         
011900     IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
012000          NEXT SENTENCE                                           
012100     ELSE                                                         
012200        MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
012300        MOVE '4900-CLOSE-READ-CYCLE-CSR' TO ABEND-FUNCTION        
012400        MOVE 'CLOSE'                     TO TABLE-1               
012500        MOVE 'READ_CYCLE_CSR'            TO TABLE-ELEMENT-1       
012600        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
012700        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
012800     END-IF.                                                      
012900 4920-EXIT.                                                       
013000     EXIT.                                                        
013100*****************************************************************         
013200* 4940-SELECT-REVENUE-DIST                                      *         
013300* SELECTS THE REVENUE DISTRICT FOR A PREMISE                    *         
013400*****************************************************************         
013500 4940-SELECT-REVENUE-DIST.                                        
013600     EXEC SQL                                                     
013700        SELECT PR.REV_DISTRICT_CD,                                
013800               AT.COMPANY_NO,                                     
013900               AT.LOCAL_OFFICE                                    
014000        INTO   :PR-REV-DISTRICT-CD,                               
014100               :AT-COMPANY-NO,                                    
014200               :AT-LOCAL-OFFICE                                   
014300        FROM   CSS_PREMISE PR,                                    
014400               CSS_ACCOUNT AT                                     
014500        WHERE  AT.ACCOUNT_NO = :UT-ACCOUNT-NO                     
014600        AND    PR.PREMISE_NO = AT.PREMISE_NO                      
014700     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

014800*                                                                         
014900     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
015000                                    RS-RETURN-CODE.               
015100*                                                                         
015200     IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
015300          NEXT SENTENCE                                           
015400     ELSE                                                         
015500          MOVE PROGRAM-NAME               TO ABEND-PROGRAM        
015600          MOVE '4940-SELECT-REVENUE-DIST' TO ABEND-FUNCTION       
015700          MOVE 'CSS_PREMISE'              TO TABLE-1              
015800          MOVE 'CSS_ACCOUNT'              TO TABLE-2              
015900          MOVE 'ACCOUNT_NO '              TO TABLE-ELEMENT-1      
016000          MOVE 'PREMISE_NO '              TO TABLE-ELEMENT-2      
016100          MOVE PR-REV-DISTRICT-CD         TO HOSTVAR-ELEMENT-1    
016200          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT          
016300          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
016400     END-IF.                                                      
016500 4940-EXIT.                                                       
016600     EXIT.                                                        
016700*****************************************************************         
016800* 4950-SELECT-INTEREST-RATE                                     *         
016900* SELECTS THE REVENUE DISTRICT FOR A PREMISE                    *         
017000*****************************************************************         
017100 4950-SELECT-INTEREST-RATE.                                       
017200     EXEC SQL                                                     
017300        SELECT   INTRST_RATE                                      
017400        INTO     :P6-INTRST-RATE                                  
017500        FROM     CSS_DEP_INT_RATE                                 
017600        WHERE    COMPANY_NO       = :P6-COMPANY-NO                
017700        AND      LOCAL_OFFICE     = :P6-LOCAL-OFFICE              
017800        AND      REV_DISTRICT_CD  = :P6-REV-DISTRICT-CD           
017900        AND      EFF_DATE_FROM    =                               
018000                 (SELECT MAX(EFF_DATE_FROM)                       
018100                  FROM   CSS_DEP_INT_RATE                         
018200                  WHERE  COMPANY_NO    = :P6-COMPANY-NO           
018300                  AND  LOCAL_OFFICE    = :P6-LOCAL-OFFICE         
018400                  AND  REV_DISTRICT_CD = :P6-REV-DISTRICT-CD      
018500                                                                  
018600                  AND  EFF_DATE_FROM  <= IIF(TRY_CONVERT(DATE, 
                                                      :P6-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :P6-EFF-DATE-FROM
              ) <> 0) OR (LEN(:P6-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :P6-EFF-DATE-FROM
              ), CONVERT(DATE, :P6-EFF-DATE-FROM) ))       
018700     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT   INTRST_RATE                                              
MFA-TR*       INTO     :P6-INTRST-RATE                                          
MFA-TR*       FROM     CSS_DEP_INT_RATE                                         
MFA-TR*       WHERE    COMPANY_NO       = :P6-COMPANY-NO                        
MFA-TR*       AND      LOCAL_OFFICE     = :P6-LOCAL-OFFICE                      
MFA-TR*       AND      REV_DISTRICT_CD  = :P6-REV-DISTRICT-CD                   
MFA-TR*       AND      EFF_DATE_FROM    =                                       
MFA-TR*                (SELECT MAX(EFF_DATE_FROM)                               
MFA-TR*                 FROM   CSS_DEP_INT_RATE                                 
MFA-TR*                 WHERE  COMPANY_NO    = :P6-COMPANY-NO                   
MFA-TR*                 AND  LOCAL_OFFICE    = :P6-LOCAL-OFFICE                 
MFA-TR*                 AND  REV_DISTRICT_CD = :P6-REV-DISTRICT-CD              
MFA-TR*                                                                         
MFA-TR*                 AND  EFF_DATE_FROM  <= :P6-EFF-DATE-FROM)               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

018800*                                                                         
018900     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
019000                                    RS-RETURN-CODE.               
019100*                                                                         
019200     IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
019300       NEXT SENTENCE                                              
019400     ELSE                                                         
019500       MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
019600       MOVE '4950-SELECT-INTEREST-RATE' TO ABEND-FUNCTION         
019700       MOVE 'CSS_DEP_INT_RATE'          TO TABLE-1                
019800       MOVE 'INTRST_RATE'               TO TABLE-ELEMENT-1        
019900       MOVE 'EFF_DATE_FROM'             TO TABLE-ELEMENT-2        
020000       MOVE P6-COMPANY-NO               TO HOSTVAR-ELEMENT-1      
020100       MOVE P6-LOCAL-OFFICE             TO HOSTVAR-ELEMENT-2      
020200       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT             
020300       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT             
020400     END-IF.                                                      
020500 4950-EXIT.                                                       
020600     EXIT.                                                        
020700*****************************************************************         
020800* 4960-SELECT-CURRENT-DATE                                      *         
020900* SELECTS THE CURRENT DATE FROM THE SYSTEM                      *         
021000*****************************************************************         
021100 4960-SELECT-CURRENT-DATE.                                        
021200     EXEC SQL                                                     
021300         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :P6-EFF-DATE-FROM                     
021400     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :P6-EFF-DATE-FROM = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

021500*                                                                         
021600     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
021700                                    RS-RETURN-CODE.               
021800*                                                                         
021900     IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
022000       NEXT SENTENCE                                              
022100     ELSE                                                         
022200       MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
022300       MOVE '4960-SELECT-CURRENT-DATE'  TO ABEND-FUNCTION         
022400       MOVE 'CURRENT DATE'              TO TABLE-1                
022500       MOVE 'P6-EFF-DATE-FROM'          TO TABLE-ELEMENT-1        
022600       MOVE P6-EFF-DATE-FROM            TO HOSTVAR-ELEMENT-1      
022700       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT             
022800       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT             
022900     END-IF.                                                      
023000 4960-EXIT.                                                       
023100     EXIT.                                                        
