      ******************************************************************31298000
      *                        COPYBOOK CPD00118                       *31300000
      ******************************************************************31320000
      * PURPOSE : TO DETERMINE ACCT_TYPE_CODE FOR INPUT ACCOUNT.       *31300000
      * (1) USING MIDDLE DIGIT OF CSS_UTIL_ENVRNMT.CODE_REVENUE_CLASS, *        
      *     ACCT_TYPE_CODE IS OBTAINED FOR EACH IC.                    *        
      * (2) USING HEIRARCHY METHOD, EVALUATE ACCT_TYPE_CODE OF EACH IC *        
      *     AND ARRIVE AT ACCT_TYPE_CODE FOR INPUT ACCOUNT.            *        
      *                                                                *31300000
      * NOTE : ACCT_TYPE_CODE WILL BE DERIVED AS "SPACES" FOR          *31300000
      *        CONSOLIDATED MASTER('B') OR NON-UTILITY('N') ACCOUNTS.  *31300000
      *                                                                *31300000
      * INCLUDE CWS00118 IN THE PROGRAM TO USE THIS LOGIC.             *31300000
      *                                                                *31300000
      * SHOULD ALSO INCLUDE THE LOGIC TO DISPLAY ABEND INFO FOR BATCH  *31300000
      * PROGRAMS OR TO SEND ABEND INFO FOR ONLINE PROGRAMS.            *31300000
      * (FOR PARA 6999-CPD118-ERROR-ROUTINE)                           *31300000
      *                                                                *31320000
      * INPUT TO THE COPYBOOK  : UT-ACCOUNT-NO                         *31300000
      * OUTPUT OF THE COPYBOOK : WS-CPD118-ACCT-TYPE-CODE              *31320000
      *                                                                *31320000
      ******************************************************************31360000
      **               PROGRAM  MODIFICATION  LOG                     **        
      **                                                              **        
      **    DATE     INITIALS                 REASON                  **        
      **  ________   ________   ___________________________________   **        
      **  10JUN08    SJ97149    COPYBOOK TO GET ACCOUNT TYPE CODE     **        
      **  04MAR09    GD97441    PERFORMANCE IMPROVEMENTS              **        
      ******************************************************************        
      *                                                                         
      *****************************************************************         
      * LOOP THROUGH CODE_REVENUE_CLASS MIDDLE DIGIT OF ALL THE IC'S  *         
      * OF INPUT ACCOUNT TO DERIVE ACCT_TYPE_CODE                     *         
      *****************************************************************         
      *                                                                         
       6000-GET-ACCT-TYPE-CODE-CPD118.                                  
      *                                                                         
           INITIALIZE  WS-CPD118-UTIL-ENV-DATA                          
                       WS-CPD118-ACCT-TYPE-CODE                         
                       WS-CPD118-IC-COUNT                               
                       WS-CPD118-UT-UNMETER-IND                         
                       WS-CPD118-UNMETER-IC-ACCT                        
                       WS-CPD118-IC-ACCT-TYPE-FLAG                      
                       WS-CPD118-ACCT-TYPE-FLAG.                        
      *                                                                         
           PERFORM 6900-OPEN-UTIL-ENV-CUR-CPD118                        
                                            THRU 6900-CPD118-EXIT.      
      *                                                                         
           PERFORM 6910-FETCH-UTIL-ENV-CUR-CPD118                       
                                            THRU 6910-CPD118-EXIT.      
      *                                                                         
           PERFORM 6100-PROCESS-UTIL-CUR-CPD118                         
                                            THRU 6100-CPD118-EXIT       
                   VARYING WS-CPD118-IC-INDX FROM 1 BY 1                
                     UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND        
                        OR WS-CPD118-IC-INDX > 100.                     
      *                                                                         
           PERFORM 6920-CLOSE-UTIL-ENV-CUR-CPD118                       
                                            THRU 6920-CPD118-EXIT.      
      *                                                                         
           PERFORM 6200-GET-IC-ACCT-TYPE-CPD118                         
                                            THRU 6200-CPD118-EXIT       
                   VARYING WS-CPD118-IC-INDX FROM 1 BY 1                
                     UNTIL WS-CPD118-IC-INDX > WS-CPD118-IC-COUNT.      
      *                                                                         
           IF WS-CPD118-IC-COUNT >= 1                                   
              PERFORM 6300-RESULT-ACCT-TYPE-CPD118                      
                                            THRU 6300-CPD118-EXIT       
           ELSE                                                         
              MOVE SPACES TO WS-CPD118-ACCT-TYPE-CODE                   
           END-IF.                                                      
      *                                                                         
       6000-CPD118-EXIT.                                                
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      * LOAD WS-CPD118-UTIL-ENV-DATA ARRAY WITH FETCHED CURSOR DATA  *          
      ****************************************************************          
       6100-PROCESS-UTIL-CUR-CPD118.                                    
      *                                                                         
           ADD +1                    TO WS-CPD118-IC-COUNT.             
      *                                                                         
           IF WS-CPD118-IC-COUNT          = 1   AND                     
              WS-CPD118-UT-UNMETER-IND    = 'Y'                         
              MOVE 'Y'            TO WS-CPD118-UNMETER-IC-ACCT          
           END-IF.                                                      
      *                                                                         
           IF WS-CPD118-UNMETER-IC-ACCT = 'Y'  OR                       
              WS-CPD118-UT-UNMETER-IND  = 'N'                           
              MOVE UT-IC-NO                                             
                TO WS-CPD118-IC-NO (WS-CPD118-IC-INDX)                  
              MOVE UT-CODE-UTIL-TYPE                                    
                TO WS-CPD118-IC-CODE-UTIL-TYPE (WS-CPD118-IC-INDX)      
              MOVE UT-CODE-REVENUE-CLASS (2:1)                          
                TO WS-CPD118-IC-REV-CLS-MID-DGT (WS-CPD118-IC-INDX)     
              MOVE WS-CPD118-UT-UNMETER-IND                             
                TO WS-CPD118-IC-UNMETER-IND (WS-CPD118-IC-INDX)         
           END-IF.                                                      
      *                                                                         
           PERFORM 6910-FETCH-UTIL-ENV-CUR-CPD118                       
                                            THRU 6910-CPD118-EXIT.      
      *                                                                         
       6100-CPD118-EXIT.                                                
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      * FOR EACH IC OF WS-CPD118-UTIL-ENV-DATA ARRAY, ACCT_TYPE_CODE *          
      * IS DERIVED USING WS-CPD118-IC-ACCT-TYPE-CD-MAP               *          
      ****************************************************************          
      *                                                                         
       6200-GET-IC-ACCT-TYPE-CPD118.                                    
      *                                                                         
            MOVE 'N'              TO WS-CPD118-IC-ACCT-TYPE-FLAG.       
      *                                                                         
            PERFORM VARYING WS-CPD118-MAP-INDX FROM 1 BY 1              
              UNTIL WS-CPD118-IC-ACCT-TYPE-FLAG = 'Y'                   
                 OR WS-CPD118-MAP-INDX > 23                             
             IF WS-CPD118-IC-CODE-UTIL-TYPE (WS-CPD118-IC-INDX) =       
                WS-CPD118-MAP-CODE-UTIL-TYPE (WS-CPD118-MAP-INDX) AND   
                WS-CPD118-IC-REV-CLS-MID-DGT (WS-CPD118-IC-INDX) =      
                WS-CPD118-MAP-REV-CLS-MID-DGT (WS-CPD118-MAP-INDX)      
                MOVE WS-CPD118-MAP-ACCT-TYPE-CD (WS-CPD118-MAP-INDX)    
                  TO WS-CPD118-IC-ACCT-TYPE-CD (WS-CPD118-IC-INDX)      
                MOVE 'Y'              TO WS-CPD118-IC-ACCT-TYPE-FLAG    
             END-IF                                                     
            END-PERFORM.                                                
      *                                                                         
       6200-CPD118-EXIT.                                                
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * EVALUATE ACCT_TYPE_CODE OF EACH IC AND USING HEIRARCHY METHOD *         
      * ARRIVE AT CORRECT ACCT_TYPE_CODE FOR THE GIVEN ACCOUNT        *         
      *****************************************************************         
      *                                                                         
       6300-RESULT-ACCT-TYPE-CPD118.                                    
      *                                                                         
           MOVE 'N'               TO WS-CPD118-ACCT-TYPE-FLAG.          
      *                                                                         
           PERFORM VARYING WS-CPD118-HA-INDX FROM 1 BY 1                
             UNTIL WS-CPD118-ACCT-TYPE-FLAG = 'Y'                       
                OR WS-CPD118-HA-INDX > 6                                
              PERFORM VARYING WS-CPD118-IC-INDX FROM 1 BY 1             
                UNTIL WS-CPD118-ACCT-TYPE-FLAG = 'Y'                    
                   OR WS-CPD118-IC-INDX > WS-CPD118-IC-COUNT            
                IF WS-CPD118-HA-ACCT-TYPE-CD (WS-CPD118-HA-INDX) =      
                   WS-CPD118-IC-ACCT-TYPE-CD (WS-CPD118-IC-INDX)        
                   MOVE WS-CPD118-HA-ACCT-TYPE-CD (WS-CPD118-HA-INDX)   
                     TO WS-CPD118-ACCT-TYPE-CODE                        
                   MOVE 'Y'     TO WS-CPD118-ACCT-TYPE-FLAG             
                END-IF                                                  
              END-PERFORM                                               
           END-PERFORM.                                                 
      *                                                                         
       6300-CPD118-EXIT.                                                
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * THIS PARA IS USED TO OPEN THE UTIL_ENV_CUR CURSOR              *        
      ******************************************************************        
      *                                                                         
       6900-OPEN-UTIL-ENV-CUR-CPD118.                                   
      *                                                                         
           EXEC SQL                                                     
               OPEN UTIL_ENV_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD118-RETURN-CODE    
              MOVE SPACES                   TO ABEND-FILE               
              MOVE '6900'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 6999-CPD118-ERROR-ROUTINE THRU 6999-CPD118-EXIT   
           END-IF.                                                      
      *                                                                         
       6900-CPD118-EXIT.                                                
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * THIS PARA IS USED TO FETCH THE DATA FROM UTIL_ENV_CUR CURSOR   *        
      ******************************************************************        
      *                                                                         
       6910-FETCH-UTIL-ENV-CUR-CPD118.                                  
      *                                                                         
           EXEC SQL                                                     
                FETCH UTIL_ENV_CUR                                      
                 INTO                                                   
                      :UT-IC-NO                                         
                     ,:UT-CODE-UTIL-TYPE                                
                     ,:UT-CODE-REVENUE-CLASS                            
                     ,:WS-CPD118-UT-UNMETER-IND                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD118-RETURN-CODE    
              MOVE SPACES                   TO ABEND-FILE               
              MOVE '6900'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 6999-CPD118-ERROR-ROUTINE THRU 6999-CPD118-EXIT   
           END-IF.                                                      
      *                                                                         
       6910-CPD118-EXIT.                                                
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * THIS PARA IS USED TO CLOSE UTIL_ENV_CUR CURSOR                 *        
      ******************************************************************        
      *                                                                         
       6920-CLOSE-UTIL-ENV-CUR-CPD118.                                  
      *                                                                         
           EXEC SQL                                                     
                CLOSE UTIL_ENV_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE         =  SUCCESSFUL-CALL          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD118-RETURN-CODE    
              MOVE SPACES                   TO ABEND-FILE               
              MOVE '6900'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 6999-CPD118-ERROR-ROUTINE THRU 6999-CPD118-EXIT   
           END-IF.                                                      
      *                                                                         
       6920-CPD118-EXIT.                                                
            EXIT.                                                       
      *                                                                         
