      ***************************************************************           
      * CPD00117   S T A R T   A N D   R E A D   J O B P A R M      *           
      *                       RELEASE 1.0                           *           
      * ............................................................*           
      * WS-REFERENCE: CWS00038, CWS00117                            *           
      * PROCEDURE REFERENCES:  9900-ABEND                           *           
      * ............................................................*           
      * THIS CPD CONTAINS THE PARAGRAPH TO START AND READ THE       *           
      *    FROM JOB PARM TABLE                                      *           
      ***************************************************************           
      **                                                           **           
      **  7630-OPEN-JOB-PARM-CURSOR.                               **   00223300
      **                                                           **           
      **      OPENS CURSOR TO TABLE CSS_JOB_PARM. RETRIEVE ALL     **   00223400
      **      PARAMETERS FOR THE PROGRAM WITH A STATUS ACTIVE      **   00223500
      **                                                           **           
      ***************************************************************   00223600
        7630-OPEN-JOB-PARM-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
                 DECLARE PARM_CURSOR CURSOR FOR                         
                 SELECT      CMND_CODE,                                 
                             SEQ_NO,                                    
                             PARM_DATA                                  
                 FROM        CSS_JOB_PARM                               
                 WHERE       PROGRAM_NAME  = :G6-PROGRAM-NAME           
                 AND         STATUS        = :G6-STATUS                 
                 AND         COMPANY_NO    = :G6-COMPANY-NO             
                 ORDER BY    CMND_CODE,                                 
                             SEQ_NO                                     
           END-EXEC                                                     
      *                                                                         
           MOVE WS-PROGRAM    TO G6-PROGRAM-NAME.                       
           MOVE 'A'           TO G6-STATUS.                             
           MOVE '01'          TO G6-COMPANY-NO.                         
      *                                                                         
           EXEC SQL                                                     
               OPEN PARM_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF  SQLCODE = SUCCESSFUL-CALL                                
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7630-OPEN-JOB-PARM-TABLE'                       
               DISPLAY '** ' WS-PROGRAM ' PROCESSING ERROR **'          
               DISPLAY '**   ERROR ON OPEN PARM CSR        **'          
               DISPLAY '** PROCESSING TERMINATED **'                    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
       7630-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************      00223200
      **                                                        **              
      **  7631-READ-JOB-PARM-TABLE.                             **      00223300
      **                                                        **              
      **      FETCHES VALUES FROM TABLE CSS_JOB_PARM            **      00223400
      **                                                        **              
      ************************************************************      00223600
       7631-READ-JOB-PARM-TABLE.                                        
      *                                                                         
           EXEC SQL                                                     
                 FETCH PARM_CURSOR                                      
                 INTO  :G6-CMND-CODE,                                   
                       :G6-SEQ-NO,                                      
                       :G6-PARM-DATA                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = SUCCESSFUL-CALL                                 
               MOVE G6-SEQ-NO         TO WS-SEQ-NBR                     
               MOVE G6-CMND-CODE      TO WS-CMND-CODE                   
               MOVE G6-PARM-DATA      TO WS-INPUT-DATA-BREAKDOWN        
           ELSE                                                         
               IF SQLCODE EQUAL NOT-FOUND                               
                   MOVE 'END'         TO WS-SYSIPT                      
                   PERFORM 7632-CLOSE-JOB-PARM THRU 7632-EXIT           
               ELSE                                                     
                   DISPLAY '7631-READ-JOB-PARM-TABLE'                   
                   DISPLAY '** ' WS-PROGRAM ' PROCESSING ERROR **'      
                   DISPLAY '**   ERROR ON FETCH PARM CSR       **'      
                   DISPLAY '** PROCESSING TERMINATED **'                
                   PERFORM 9900-ABEND THRU 9900-EXIT
               END-IF
           END-IF.                   
       7631-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************      00223200
      **                                                        **              
      **  7632-CLOSE-JOB-PARM.                                  **      00223300
      **                                                        **              
      **      CLOSE CURSOR JOB PARM                             **      00223400
      **                                                        **              
      ************************************************************      00223600
       7632-CLOSE-JOB-PARM.                                             
      *                                                                         
           EXEC SQL                                                     
                 CLOSE PARM_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = SUCCESSFUL-CALL                                 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7632-CLOSE-JOB-PARM'                            
               DISPLAY '** ' WS-PROGRAM ' PROCESSING ERROR **'          
               DISPLAY '**   ERROR ON CLOSE PARM CSR       **'          
               DISPLAY '** PROCESSING TERMINATED **'                    
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7632-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
