      *****************************************************************         
      *   CPD00114   COPYBOOK TO READ JOB PARM TABLE FOR REPORT DATE  *         
      *                      RELEASE 1.0                              *         
      *   ..........................................................  *         
      *   WS-REFERENCE:  CWS00114 (WORKING STORAGE COPYBOOK)          *         
      *                  CWS00038                                               
      *                  SQL INCLUDE TBJBPARM                         *         
      *                  WS-PGRMNAME (LITERAL NAME OF PROGRAM)        *         
      *                  WS-ABEND-SWITCH, WS-ABEND-YES (CPD09900)     *         
      *                                                               *         
      *   PROCEDURE REFERENCE:  CPD09900,                             *         
      *                        9000-TERMINATE & 9000-EXIT (CPD09900). *         
      *                                                               *         
      *   PREREQUISITES: SQL INCLUDE FOR THE JOB_PARM TABLE MUST BE   *         
      *                  A PART OF WORKING STORAGE                    *         
      *                                                               *         
      *   ADDITIONAL INFORMATION:                                     *         
      *     PART OF THE INITIALIZATION ROUTINE, THIS BLOCK OF CODE    *         
      *     SELECTS A PROCESSING YEAR AND MONTH FOR MONTHLY REPORTING*          
      *     APPLICATIONS. PROGRAM_NAME EQUALS 'REPORTDATE' OR NAME OF *         
      *     EXECUTING PROGRAM (WS-PGRMNAME). THE PARM DATA AREA       *         
      *     CONTAINS A DATE IN THE FORMAT IS YYYYMM WHERE YYYY IS     *         
      *     FULL YR AND MM IS MONTH, EXAMPLE: 199506.                 *         
      *                                                               *         
      *     OCCURANCES OF THE EXECUTING PROGRAM NAME SIGNAL AN        *         
      *     OVERRIDE OF THE NORMAL 'REPORTDATE' PARAMETER. OVERRIDE   *         
      *     DATES WILL BE DEACTIVATED UPON SUCCESSFUL COMPLETION      *         
      *     OF THE PROGRAM.  JOB_PARM STATUS IS UPDATED WITH AN 'I'   *         
      *     MEANING INACTIVE.                                         *         
      *                                                               *         
      *     REQUIREMENTS:                                             *         
      *     - WS-PGRMNAME DEFINED IN WS SHOULD CONTAIN THE NAME OF    *         
      *       THE EXECUTING PROGRAM.                                  *         
      *     - CPD00038 COPYBOOK FOR FETCHING ON JOB PARM TABLE        *         
      *     - CPD09900 STANDARD PD COPYBOOK FOR USER ABENDS.          *         
      *                                                               *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       6200-GET-PARAMETER-DATE.                                         
      ******************************************************************        
      *                                                                *        
      * THIS PARAGRAPH CONTROLS THE RETRIEVAL OF DATE PARAMETERS FOR   *        
      * MONTHLY REPORT AND EXTRACT PROGRAMS.                           *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
           INITIALIZE WS-STNDTE-RPT-BEG-DT.                             
           INITIALIZE WS-STNDTE-RPT-END-DT.                             
      *                                                                         
           PERFORM 6300-GET-OVERRIDE-DATE        THRU 6300-EXIT.        
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6310-GET-DEFAULT-DATE      THRU 6310-EXIT         
           ELSE                                                         
      **** JOB PARM TABLE IS UPDATED ONLY WHEN OVERRIDE DATE IS USED            
      *                                                                         
              PERFORM 6340-UPDATE-JOB-PARM-TABLE THRU 6340-EXIT         
           END-IF.                                                      
      *                                                                         
           PERFORM 6320-EDIT-PARM-DATE           THRU 6320-EXIT.        
      *                                                                         
           PERFORM 6330-GET-START-END-DATE       THRU 6330-EXIT.        
      *                                                                         
       6200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       6300-GET-OVERRIDE-DATE.                                          
      ******************************************************************        
      *                                                                *        
      * THIS PARAGRAPH PERFORMS FORMATTING AND USES CPD00038 TO GET    *        
      * THE OVERRIDE DATE, IF THERE IS ONE, FROM THE JOB_PARM TABLE.   *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           MOVE WS-DATE     TO WS-COMMAND.                              
           MOVE SPACES      TO WS-SYSIPT.                               
      *                                                                         
           PERFORM 7600-START-FCSJC01  THRU 7600-EXIT.                  
           PERFORM 7610-READ-FCSJC01   THRU 7610-EXIT                   
              UNTIL (REPORT-DATE AND INPUT-ACTIVE)                      
                 OR END-OF-SYSIPT.                                      
      *                                                                         
           IF END-OF-SYSIPT                                             
               MOVE WS-N TO WS-OVERRIDE-DATE-SW                         
           ELSE                                                         
               MOVE WS-Y TO WS-OVERRIDE-DATE-SW                         
           END-IF.                                                      
      *                                                                         
       6300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       6310-GET-DEFAULT-DATE.                                           
      ******************************************************************        
      *                                                                *        
      * THIS PARAGRAPH PERFORMS PROCESSING AND USES CPD00038 TO PULL   *        
      * THE DEFAULT REPORT DATE OFF THE JOB PARM TABLE.  FORMATTING OF *        
      * INITIAL PARAMETERS ALLOWS THE PROGRAM TO USE THE SAME LOGIC    *        
      * AGAIN.                                                         *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
           MOVE 'REPORTDATE' TO WS-PROGRAM.                             
           MOVE WS-DATE      TO WS-COMMAND.                             
           MOVE ZEROS        TO WS-SEQUENCE.                            
           MOVE SPACES       TO WS-SYSIPT.                              
      *                                                                         
           PERFORM 7600-START-FCSJC01  THRU 7600-EXIT.                  
           PERFORM 7610-READ-FCSJC01   THRU 7610-EXIT                   
              UNTIL (REPORT-DATE AND INPUT-ACTIVE)                      
                 OR END-OF-SYSIPT.                                      
      *                                                                         
           IF END-OF-SYSIPT                                             
              DISPLAY 'JOB PARM INACTIVE OR NOT FOUND'                  
              PERFORM 9900-ABEND        THRU 9900-EXIT                  
           END-IF.                                                      
      *                                                                         
       6310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       6320-EDIT-PARM-DATE.                                             
      ******************************************************************        
      *                                                                *        
      * THIS PARAGRAPH CHECKS THAT THE DATE IS A VALID CALENDAR YEAR   *        
      * DATE.                                                          *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
           IF WS-PARM-YR < '2050' AND                                   
              WS-PARM-YR > '1950'                                       
                  IF WS-PARM-MONTH < '00' AND                           
                     WS-PARM-MONTH > '13'                               
                      DISPLAY '** INVALID PARM DATE - MONTH '           
                              WS-PARM-MONTH                             
                      DISPLAY '** PROGRAM_NAME ' G6-PROGRAM-NAME        
                      DISPLAY '** COMPANY_NO ' G6-COMPANY-NO '  '       
                              '** SEQ_NO ' G6-SEQ-NO                    
                      DISPLAY '**  PROCESSING TERMINATED  **'           
                      PERFORM 9900-ABEND      THRU  9900-EXIT           
                  END-IF                                                
           ELSE                                                         
               DISPLAY '** INVALID PARM DATE - CENTURY '                
                       WS-PARM-YR                                       
               DISPLAY '** PROGRAM_NAME ' G6-PROGRAM-NAME               
               DISPLAY '** COMPANY_NO ' G6-COMPANY-NO '  '              
                       '** SEQ_NO ' G6-SEQ-NO                           
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND      THRU  9900-EXIT                  
           END-IF.                                                      
      *                                                                         
       6320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       6330-GET-START-END-DATE.                                         
      ******************************************************************        
      *                                                                *        
      * THIS PARAGRAPH ESTABLISHS THE START AND ENDING DATES FOR THE   *        
      * MONTH PASSED DOWN FROM THE JOB PARM TABLE.                     *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
           EVALUATE WS-PARM-MONTH                                       
              WHEN  '01'                                                
              WHEN  '03'                                                
              WHEN  '05'                                                
              WHEN  '07'                                                
              WHEN  '08'                                                
              WHEN  '10'                                                
              WHEN  '12'                                                
                 MOVE '31' TO WS-STNDTE-END-DAY                         
              WHEN '04'                                                 
              WHEN '06'                                                 
              WHEN '09'                                                 
              WHEN '11'                                                 
                 MOVE '30' TO WS-STNDTE-END-DAY                         
              WHEN '02'                                                 
                 MOVE 99  TO WS-REMAINDER1                              
                             WS-REMAINDER2                              
                 DIVIDE WS-NUM-CENTURY BY 4 GIVING WS-QUOTIENT          
                 REMAINDER WS-REMAINDER1                                
                 DIVIDE WS-NUM-CENTURY BY 400 GIVING WS-QUOTIENT        
                 REMAINDER WS-REMAINDER2                                
                    IF (    WS-REMAINDER1 NOT = ZERO                    
                         OR WS-REMAINDER2 = ZERO )                      
                         MOVE '28' TO WS-STNDTE-END-DAY                 
                    ELSE                                                
                         IF WS-REMAINDER1 = ZERO                        
                             MOVE '29' TO WS-STNDTE-END-DAY             
                                                                        
                         END-IF                                         
                    END-IF                                              
              WHEN  OTHER                                               
                    DISPLAY '6330-GET-START-END-DATE'                   
                    'MONTH VALUE IS = ' WS-PARM-MONTH                   
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-EVALUATE.                                                
                                                                        
           MOVE '01'          TO WS-STNDTE-BEG-DAY.                     
                                                                        
           MOVE WS-PARM-MONTH TO WS-STNDTE-MONTH                        
                                 WS-STNDTE-BEG-MONTH                    
                                 WS-STNDTE-END-MONTH.                   
                                                                        
           MOVE WS-PARM-YR    TO WS-STNDTE-CENTURY-YR                   
                                 WS-STNDTE-BEG-YEAR                     
                                 WS-STNDTE-END-YEAR.                    
                                                                        
           MOVE WS-STNDTE-BEG-DATE TO WS-STNDTE-RPT-BEG-DT.             
           MOVE WS-STNDTE-END-DATE TO WS-STNDTE-RPT-END-DT.             
                                                                        
       6330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
       6340-UPDATE-JOB-PARM-TABLE.                                      
      ******************************************************************        
      *                                                                *        
      * THIS PARAGRAPH PERFORMS AN UPDATE TO THE JOB PARM TABLE IF THE *        
      * REPORT IS SUCCESSFULLY CREATED.  THE JOB STATUS IS CHANGED FROM*        
      * AN 'A' TO AN 'I' TO SHOW THE REPORT HAS BEEN ALREADY RUN AND IS*        
      * INACTIVE.                                                      *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_JOB_PARM                                       
              SET    STATUS='I'                                         
              WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                    
              AND    COMPANY_NO = :G6-COMPANY-NO                        
              AND    CMND_CODE = :G6-CMND-CODE                          
              AND    SEQ_NO = :G6-SEQ-NO                                
              AND    STATUS = :G6-STATUS                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '** UPDATE OF JOB_PARM STATUS FAILED '            
              DISPLAY 'COMPANY-NO = ' G6-COMPANY-NO                     
              DISPLAY 'PROGRAM-NAME = ' G6-PROGRAM-NAME                 
              PERFORM 9900-ABEND       THRU 9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       6340-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      *************** END OF CPD00114 COPYBOOK  ****************                
