      ******************************************************************        
      ** CPD00107                                                     **        
      ** THIS COPY STATEMENT CONTAINS THE PROCEDURE SATEMENTS         **        
      ** NECESSARY TO CREATE A NEW METER NO.                          **        
      ******************************************************************        
      **       PROGRAM  MODIFICATION  LOG                             **        
      ******************************************************************        
      ** DATE   INTIALS   REASON                                      **        
      ** ____   _______   ______                                      **        
      ** 0399     JVH     CODE WAS TAKEN FROM EXISTING COPYBOOKS      **        
      ******************************************************************        
      **  CALL PARA 6202-GET-NEW-METER-NO.                            **        
      **                                                              **        
      **  INCLUDE CWS00107   ( WORKING STORAGE )                      **        
      **  INCLUDE CPD00108.  ( CODE FOR CALCULATING CHECK DIGIT )     **        
      **                                                              **        
      **  INCLUDE THE FOLLOWING DECLGEN IN THE CALLING RPC            **        
      **  CSS_METER_NO_CTL TBMTRCTL                                   **        
      **                                                              **        
      **  PASS INFORMATION IN THE FOLLOWING VARIABLES.                **        
      **  WS-107-CURRENT-DATE           ( PASS CURRENT DATE )         **        
      **  WS-107-CURRENT-TIMESTAMP      ( PASS CURRENT TIMESTAMP )    **        
      **  WS-107-USERID                 ( PASS USER ID )              **        
      **  WS-107-PANEL-NO               ( PASS THE PANEL NO )         **        
      **  WS-107-TRANS-COMMENTS         ( PASS TRANSACTION COMMENTS ) **        
      **  WS-107-TRANS-COMMENTS-LEN     ( PASS TRAN COMMENTS LENGTH ) **        
      **                                                              **        
      **  RESULT WILL BE IN WS-107-NEW-METER-NO                       **        
      ******************************************************************        
                                                                        
       6202-GET-NEW-METER-NO.                                           
                                                                        
           MOVE '6202'                        TO ACTIVE-PARAGRAPH.      
                                                                        
      *-------------------------------*                                         
      * DETERMINE NEW METER NO        *                                         
      *-------------------------------*                                         
           PERFORM 6204-LOCK-METER-NO-CNTL               THRU 6204-EXIT.
           PERFORM 6206-SELECT-METER-NO-CNTL             THRU 6206-EXIT.
                                                                        
      *** SORRY ! WE ARE FULL. WE CANNOT GIVE YOU ANY MORE METER NUMBERS        
           IF ML-LAST-METER-NO-USED >= WS-MAX-METER-CNTL THEN           
              MOVE WS-MAX-METER-ERROR-CODE    TO RS-RETURN-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT             THRU 9000-EXIT 
              PERFORM 9900-SQL-ERROR-ROUTINE             THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
           ADD 1                              TO ML-LAST-METER-NO-USED. 
                                                                        
           MOVE ML-LAST-METER-NO-USED         TO WS-107-METER-NO.       
           MOVE WS-107-METER-NO-8             TO WS-NBR-TO-BE-CHECKED2. 
                                                                        
           PERFORM 6210-CALCULATE-CHECK-DIGIT            THRU 6210-EXIT.
                                                                        
           MOVE WS-CHECK-DIGIT2               TO WS-107-METER-CHECK-DGT.
           MOVE WS-107-METER-NO-RED           TO WS-107-NEW-METER-NO.   
                                                                        
           PERFORM 6208-UPDATE-METER-NO-CNTL             THRU 6208-EXIT.
                                                                        
       6202-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6204-LOCK-METER-NO-CNTRL                                       *        
      *    1.  LOCK THE METER NO CONTROL TABLE.                        *        
      ******************************************************************        
       6204-LOCK-METER-NO-CNTL.                                         
                                                                        
           EXEC SQL                                                     
              CALL CIS.LOCK_TABLE_IN_EXCLUSIVE_MODE('CSS_METER_NO_CNTL')        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
              NEXT SENTENCE                                             
           ELSE                                                         
             MOVE '6204'                      TO ACTIVE-PARAGRAPH       
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'LOCK TABLE'                TO ABEND-FUNCTION         
             MOVE 'CSS_METER_NO_CNTL'         TO TABLE-1                
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       6204-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6206-SELECT-METER-NO-CNTL                                      *        
      *    1. SELECT THE LAST METER NO USED IN ORDER TO CREATE A NEW   *        
      *       METER -NO.                                               *        
      ******************************************************************        
       6206-SELECT-METER-NO-CNTL.                                       
                                                                        
           EXEC SQL                                                     
              SELECT LAST_METER_NO_USED                                 
                INTO :ML-LAST-METER-NO-USED                             
                FROM CSS_METER_NO_CNTL                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
              NEXT SENTENCE                                             
           ELSE                                                         
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE '6206'                      TO ACTIVE-PARAGRAPH       
             MOVE 'SELECT'                    TO ABEND-FUNCTION         
             MOVE 'CSS_METER_NO_CNTL'         TO TABLE-1                
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       6206-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6208-UPDATE-METER-NO-CNTL                                      *        
      *    1. SAVE INCREMENTED LAST NUMBER USED.                       *        
      ******************************************************************        
       6208-UPDATE-METER-NO-CNTL.                                       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_METER_NO_CNTL                                  
                 SET LAST_METER_NO_USED = :ML-LAST-METER-NO-USED        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
              NEXT SENTENCE                                             
           ELSE                                                         
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE '6208'                      TO ACTIVE-PARAGRAPH       
             MOVE 'UPDATE'                    TO ABEND-FUNCTION         
             MOVE 'CSS-METER-NO-CNTL'         TO TABLE-1                
             MOVE 'LAST-METER-NO-USED'        TO TABLE-ELEMENT-1        
             MOVE ML-LAST-METER-NO-USED       TO HOSTVAR-ELEMENT-1      
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       6208-EXIT.                                                       
           EXIT.                                                        
