      ******************************************************************31298000
      *                        COPYBOOK CPD00099                       *31300000
      ******************************************************************31320000
      * PURPOSE : TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.    *31300000
      *                                                                *31300000
      * INCLUDE CWS00010 & CWS00099 IN THE PROGRAM TO USE THIS LOGIC.  *31300000
      *                                                                *31300000
      * SHOULD ALSO INCLUDE THE LOGIC TO DISPLAY ABEND INFO FOR BATCH  *31300000
      * PROGRAMS OR TO SEND ABEND INFO TO MC05 IN ONLINE PROGRAMS.     *31300000
      * (FOR PARA 6995-CPD99-ERROR-ROUTINE)                            *31300000
      *                                                                *31320000
      * PASS THE PREMISE-NO TO WS-CPD99-PREMISE-NO AND IT WILL RETURN  *31300000
      * WS-CPD99-ACCOUNT-NO, THE MOST CURRENT ACCT AT THE PREMISE.     *31320000
      *                                                                *31320000
      ******************************************************************31360000
      *                                                                 31370000
      ******************************************************************43111000
      * 6990-FETCH-CUR-ACCOUNT                                         *42840000
      *                                                                *42840000
      *     1.  LOOK FOR A NULL IN DATE_UTIL_SVC_END (THERE SHOULD BE  *42850000
      *         ONLY ONE).  IF EXISTS, USE THIS ACCOUNT.               *42850000
      *     2.  IF NONE EXISTS, LOOK FOR MAX (DATE_UTIL_SVC_END).  IF  *42850000
      *         ONLY ONE EXISTS, USE THIS ACCOUNT.                     *42850000
      *     3.  IF MULTIPLE ROWS WITH SAME MAX END DATE, LOOK AT       *42850000
      *         ACCOUNT TABLE FOR MAX (ACCT_FINALED_DT) FOR THE        *42850000
      *         PREMISE.  USE THIS ACCOUNT.                            *42850000
      *     4.  IF MULTIPLE ROWS WITH SAME MAX ACCT_FINALED_DT, LOOK   *42850000
      *         FOR MAX ACCT_CREATE_DT.  USE THIS ACCOUNT.             *42850000
      ******************************************************************00110000
      *     DATE    INITIALS   MODIFICATION LOG                        *00140000
      *     ____    ________   ________________                        *00150000
      *                                                                *00151000
T22243*    06/00     SREENI    CHANGES MADE TO IMPLEMENT MULTI-COMPANY *        
T22243*                        IN METER INVENTORY.                     *        
C30397*    02/04     SREENI    CHANGES MADE TO FIX -305 IN 6992- PARA  *        
      *                                                                *42840000
      ******************************************************************42860000
      *                                                                 42870000
       6990-FETCH-CUR-ACCOUNT.                                          
      *                                                                 43520000
           EXEC SQL                                                     
              SELECT CH.ACCOUNT_NO                                      
                INTO :WS-CPD99-ACCOUNT-NO                               
                FROM CSS_CUST_PREM_HIST CH                              
                    ,CSS_ACCOUNT        AT                              
               WHERE CH.PREMISE_NO = :WS-CPD99-PREMISE-NO               
                 AND CH.ACCOUNT_NO = AT.ACCOUNT_NO                      
                 AND CH.DATE_UTIL_SVC_END IS NULL                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 43529000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                 43529300
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   PERFORM 6991-MAX-END-DATE THRU 6991-EXIT             
               WHEN OTHER                                               
                   MOVE SQLCODE               TO WS-CPD99-RETURN-CODE   
                   MOVE SPACES                TO ABEND-FILE             
                   MOVE '6990'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_ACCOUNT'         TO TABLE-1                
                   MOVE 'CSS_CUST_PREM_HIST'  TO TABLE-2                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
T22243             MOVE 'DATE_UTIL_SVC_END'   TO TABLE-ELEMENT-2        
                   MOVE WS-CPD99-PREMISE-NO   TO HOSTVAR-ELEMENT-1      
T22243             MOVE 'NULL'                TO HOSTVAR-ELEMENT-2      
                   PERFORM 6995-CPD99-ERROR-ROUTINE THRU 6995-EXIT      
           END-EVALUATE.                                                
      *                                                                 43110000
       6990-EXIT.                                                       
           EXIT.                                                        
      *                                                                 43110000
      ******************************************************************42780000
      * 6991-MAX-END-DATE                                              *42790000
      *                                                                *42820000
      *     CALLED FROM 6990-FETCH-CUR-ACCOUNT                         *42830000
      *                                                                *42840000
      *     MAX DATE_UTIL_SVC_END AT PREMISE                           *42850000
      ******************************************************************42860000
      *                                                                 42870000
       6991-MAX-END-DATE.                                               
      *                                                                 43110000
           EXEC SQL                                                     
              SELECT  MAX(DATE_UTIL_SVC_END)                            
                INTO :WS-CPD99-DATE-SVC-END :WS-CPD99-NULL-IND           
                FROM  CSS_CUST_PREM_HIST CH                             
                     ,CSS_ACCOUNT        AT                             
               WHERE CH.PREMISE_NO = :WS-CPD99-PREMISE-NO               
                 AND CH.ACCOUNT_NO = AT.ACCOUNT_NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 43529000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                 43529300
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE LOW-VALUES            TO WS-CPD99-DATE-SVC-END  
               WHEN OTHER                                               
                   MOVE SQLCODE               TO WS-CPD99-RETURN-CODE   
                   MOVE SPACES                TO ABEND-FILE             
                   MOVE '6991'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_ACCOUNT'         TO TABLE-1                
                   MOVE 'CSS_CUST_PREM_HIST'  TO TABLE-2                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
                   MOVE WS-CPD99-PREMISE-NO   TO HOSTVAR-ELEMENT-1      
                   PERFORM 6995-CPD99-ERROR-ROUTINE THRU 6995-EXIT      
           END-EVALUATE.                                                
      *                                                                 43110000
           IF (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                      AND WS-CPD99-NULL-IND NOT EQUAL -1)               
              EXEC SQL                                                  
                  SELECT CH.ACCOUNT_NO                                  
                    INTO :WS-CPD99-ACCOUNT-NO                           
                    FROM CSS_CUST_PREM_HIST CH                          
                        ,CSS_ACCOUNT        AT                          
                   WHERE CH.PREMISE_NO         = :WS-CPD99-PREMISE-NO   
                     AND AT.PREMISE_NO         = :WS-CPD99-PREMISE-NO   
                     AND CH.ACCOUNT_NO         = AT.ACCOUNT_NO          
                     AND CH.DATE_UTIL_SVC_END  = IIF(TRY_CONVERT(DATE, 
                                                 :WS-CPD99-DATE-SVC-END
              ) IS NULL OR (PATINDEX('%.%', :WS-CPD99-DATE-SVC-END
              ) <> 0) OR (LEN(:WS-CPD99-DATE-SVC-END
              ) <> 10), CIS.CHAR2DATE(:WS-CPD99-DATE-SVC-END
              ), CONVERT(DATE, :WS-CPD99-DATE-SVC-END) ) 
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                  43532000
MFA-TR*           SELECT CH.ACCOUNT_NO                                  43540000
MFA-TR*             INTO :WS-CPD99-ACCOUNT-NO                           43550000
MFA-TR*             FROM CSS_CUST_PREM_HIST CH                          43560000
MFA-TR*                 ,CSS_ACCOUNT        AT                          43561000
MFA-TR*            WHERE CH.PREMISE_NO         = :WS-CPD99-PREMISE-NO   43570000
MFA-TR*              AND AT.PREMISE_NO         = :WS-CPD99-PREMISE-NO   43580000
MFA-TR*              AND CH.ACCOUNT_NO         = AT.ACCOUNT_NO          43600000
MFA-TR*              AND CH.DATE_UTIL_SVC_END  = :WS-CPD99-DATE-SVC-END 43610000
MFA-TR*       END-EXEC                                                  43680000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 43690000
              MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE  
      *                                                                 43690000
              EVALUATE WS-ACTIVE-RETURN-CODE                            
                  WHEN SUCCESSFUL-CALL                                  
                  WHEN NOT-FOUND                                        
                      CONTINUE                                          
                  WHEN WS-CPD99-DUP-ROWS                                
                      PERFORM 6992-GET-MAX-FINAL-DATE THRU 6992-EXIT    
                  WHEN OTHER                                            
                      MOVE SQLCODE               TO WS-CPD99-RETURN-CODE
                      MOVE SPACES                TO ABEND-FILE          
                      MOVE '6991'                TO ACTIVE-PARAGRAPH    
                      MOVE 'SELECT'              TO ABEND-FUNCTION      
                      MOVE 'CSS_ACCOUNT'         TO TABLE-1             
                      MOVE 'CSS_CUST_PREM_HIST'  TO TABLE-2             
                      MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1     
T22243                MOVE 'DATE_UTIL_SVC_END'   TO TABLE-ELEMENT-2     
                      MOVE WS-CPD99-PREMISE-NO   TO HOSTVAR-ELEMENT-1   
T22243                MOVE WS-CPD99-DATE-SVC-END TO HOSTVAR-ELEMENT-2   
                      PERFORM 6995-CPD99-ERROR-ROUTINE THRU 6995-EXIT   
               END-EVALUATE                                             
           END-IF.                                                      
      *                                                                 43870000
       6991-EXIT.                                                       
           EXIT.                                                        
      *                                                                 43110000
      ******************************************************************42780000
      * 6992-GET-MAX-FINAL-DATE                                        *42790000
      *                                                                *42820000
      *     CALLED FROM 6991-MAX-END-DATE                              *42830000
      *                                                                *42840000
      *     MAX ACCT_FINALED_DT AT PREMISE                             *42850000
      ******************************************************************42860000
      *                                                                 42870000
       6992-GET-MAX-FINAL-DATE.                                         
      *                                                                 43110000
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           AT.ACCT_FINALED_DT), 121), ' ', '-'), ':', '.')                     
C30397          INTO :WS-CPD99-MAX-AT-FINAL-DT :WS-CPD99-NULL-IND        
                FROM CSS_CUST_PREM_HIST CH                              
                    ,CSS_ACCOUNT        AT                              
               WHERE CH.PREMISE_NO         = :WS-CPD99-PREMISE-NO       
                 AND CH.ACCOUNT_NO         = AT.ACCOUNT_NO              
                 AND CH.DATE_UTIL_SVC_END  = IIF(TRY_CONVERT(DATE, 
                                                 :WS-CPD99-DATE-SVC-END
              ) IS NULL OR (PATINDEX('%.%', :WS-CPD99-DATE-SVC-END
              ) <> 0) OR (LEN(:WS-CPD99-DATE-SVC-END
              ) <> 10), CIS.CHAR2DATE(:WS-CPD99-DATE-SVC-END
              ), CONVERT(DATE, :WS-CPD99-DATE-SVC-END) )     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     43919100
MFA-TR*       SELECT MAX(AT.ACCT_FINALED_DT)                            43919200
MFA-TR*         INTO :WS-CPD99-MAX-AT-FINAL-DT:WS-CPD99-NULL-IND        43919300
MFA-TR*         FROM CSS_CUST_PREM_HIST CH                              43919400
MFA-TR*             ,CSS_ACCOUNT        AT                              43919500
MFA-TR*        WHERE CH.PREMISE_NO         = :WS-CPD99-PREMISE-NO       43919601
MFA-TR*          AND CH.ACCOUNT_NO         = AT.ACCOUNT_NO              43919800
MFA-TR*          AND CH.DATE_UTIL_SVC_END  = :WS-CPD99-DATE-SVC-END     43919902
MFA-TR*    END-EXEC.                                                    43920000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 43920100
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                 43920300
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                   TO WS-CPD99-RETURN-CODE   
               MOVE SPACES                    TO ABEND-FILE             
               MOVE '6992'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_ACCOUNT'             TO TABLE-1                
               MOVE 'CSS_CUST_PREM_HIST'      TO TABLE-2                
               MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1        
T22243         MOVE 'DATE_UTIL_SVC_END'       TO TABLE-ELEMENT-2        
               MOVE WS-CPD99-PREMISE-NO       TO HOSTVAR-ELEMENT-1      
T22243         MOVE WS-CPD99-DATE-SVC-END     TO HOSTVAR-ELEMENT-2      
               PERFORM 6995-CPD99-ERROR-ROUTINE THRU 6995-EXIT          
           END-IF.                                                      
      *                                                                 43922000
C30397     IF WS-CPD99-NULL-IND EQUAL -1                                
C30397         PERFORM 6993-GET-MAX-CREATE-DATE THRU 6993-EXIT          
C30397     ELSE                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
              EXEC SQL                                                  
                 SELECT CH.ACCOUNT_NO                                   
                   INTO :WS-CPD99-ACCOUNT-NO                            
                   FROM CSS_CUST_PREM_HIST CH                           
                       ,CSS_ACCOUNT        AT                           
                  WHERE CH.PREMISE_NO        = :WS-CPD99-PREMISE-NO     
                    AND AT.PREMISE_NO        = :WS-CPD99-PREMISE-NO     
                    AND CH.ACCOUNT_NO        = AT.ACCOUNT_NO            
                    AND CH.DATE_UTIL_SVC_END = IIF(TRY_CONVERT(DATE, 
                                                 :WS-CPD99-DATE-SVC-END
              ) IS NULL OR (PATINDEX('%.%', :WS-CPD99-DATE-SVC-END
              ) <> 0) OR (LEN(:WS-CPD99-DATE-SVC-END
              ) <> 10), CIS.CHAR2DATE(:WS-CPD99-DATE-SVC-END
              ), CONVERT(DATE, :WS-CPD99-DATE-SVC-END) )   
                    AND AT.ACCT_FINALED_DT   = CIS.CHAR2TIMESTAMP(
                                              :WS-CPD99-MAX-AT-FINAL-DT
              )
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                  43913700
MFA-TR*          SELECT CH.ACCOUNT_NO                                   43913800
MFA-TR*            INTO :WS-CPD99-ACCOUNT-NO                            43914000
MFA-TR*            FROM CSS_CUST_PREM_HIST CH                           43914200
MFA-TR*                ,CSS_ACCOUNT        AT                           43914300
MFA-TR*           WHERE CH.PREMISE_NO        = :WS-CPD99-PREMISE-NO     43914400
MFA-TR*             AND AT.PREMISE_NO        = :WS-CPD99-PREMISE-NO     43914500
MFA-TR*             AND CH.ACCOUNT_NO        = AT.ACCOUNT_NO            43914700
MFA-TR*             AND CH.DATE_UTIL_SVC_END = :WS-CPD99-DATE-SVC-END   43914800
MFA-TR*             AND AT.ACCT_FINALED_DT   = :WS-CPD99-MAX-AT-FINAL-DT        
MFA-TR*       END-EXEC                                                  43915000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 43915100
              MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE 
      *                                                                 43915400
              EVALUATE WS-ACTIVE-RETURN-CODE                            
                  WHEN SUCCESSFUL-CALL                                  
                      CONTINUE                                          
                  WHEN WS-CPD99-DUP-ROWS                                
                      PERFORM 6993-GET-MAX-CREATE-DATE THRU 6993-EXIT   
                  WHEN OTHER                                            
                      MOVE SQLCODE             TO WS-CPD99-RETURN-CODE  
                      MOVE SPACES              TO ABEND-FILE            
                      MOVE '6992'              TO ACTIVE-PARAGRAPH      
                      MOVE 'SELECT'            TO ABEND-FUNCTION        
                      MOVE 'CSS_ACCOUNT'       TO TABLE-1               
                      MOVE 'CSS_CUST_PREM_HIST' TO TABLE-2              
                      MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1      
T22243                MOVE 'DATE_UTIL_SVC_END'  TO TABLE-ELEMENT-2      
T22243                MOVE 'ACCT_FINALED_DT'    TO TABLE-ELEMENT-3      
                      MOVE WS-CPD99-PREMISE-NO  TO HOSTVAR-ELEMENT-1    
T22243                MOVE WS-CPD99-DATE-SVC-END TO HOSTVAR-ELEMENT-2   
T22243                MOVE WS-CPD99-MAX-AT-FINAL-DT TO HOSTVAR-ELEMENT-3
                      PERFORM 6995-CPD99-ERROR-ROUTINE THRU 6995-EXIT   
              END-EVALUATE                                              
C30397     END-IF                                                       
           END-IF.                                                      
      *                                                                 43917500
       6992-EXIT.                                                       
           EXIT.                                                        
      *                                                                 43110000
      ******************************************************************42780000
      * 6993-GET-MAX-CREATE-DATE                                       *42790000
      *                                                                *42820000
      *     CALLED FROM 6992-GET-MAX-END-DATE                          *42830000
      *                                                                *42840000
      *     MAX ACCT_CREATE_DT AT PREMISE                              *42850000
      ******************************************************************42860000
      *                                                                 42870000
       6993-GET-MAX-CREATE-DATE.                                        
      *                                                                 43110000
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           AT.ACCT_CREATE_DT), 121), ' ', '-'), ':', '.')                      
                INTO :WS-CPD99-MAX-AT-CREATE-DT                         
                FROM CSS_CUST_PREM_HIST CH                              
                    ,CSS_ACCOUNT        AT                              
               WHERE CH.PREMISE_NO         = :WS-CPD99-PREMISE-NO       
                 AND CH.ACCOUNT_NO         = AT.ACCOUNT_NO              
                 AND CH.DATE_UTIL_SVC_END  = IIF(TRY_CONVERT(DATE, 
                                                 :WS-CPD99-DATE-SVC-END
              ) IS NULL OR (PATINDEX('%.%', :WS-CPD99-DATE-SVC-END
              ) <> 0) OR (LEN(:WS-CPD99-DATE-SVC-END
              ) <> 10), CIS.CHAR2DATE(:WS-CPD99-DATE-SVC-END
              ), CONVERT(DATE, :WS-CPD99-DATE-SVC-END) )     
                 AND AT.ACCT_FINALED_DT    = CIS.CHAR2TIMESTAMP(
                                             :WS-CPD99-MAX-AT-FINAL-DT 
                                                     :WS-CPD99-NULL-IND
              )      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     43919100
MFA-TR*       SELECT MAX(AT.ACCT_CREATE_DT)                             43919200
MFA-TR*         INTO :WS-CPD99-MAX-AT-CREATE-DT                         43919300
MFA-TR*         FROM CSS_CUST_PREM_HIST CH                              43919400
MFA-TR*             ,CSS_ACCOUNT        AT                              43919500
MFA-TR*        WHERE CH.PREMISE_NO         = :WS-CPD99-PREMISE-NO       43919601
MFA-TR*          AND CH.ACCOUNT_NO         = AT.ACCOUNT_NO              43919800
MFA-TR*          AND CH.DATE_UTIL_SVC_END  = :WS-CPD99-DATE-SVC-END     43919902
MFA-TR*          AND AT.ACCT_FINALED_DT    = :WS-CPD99-MAX-AT-FINAL-DT  43914900
MFA-TR*                                         :WS-CPD99-NULL-IND              
MFA-TR*    END-EXEC.                                                    43920000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 43920100
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                 43920300
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                   TO WS-CPD99-RETURN-CODE   
               MOVE SPACES                    TO ABEND-FILE             
               MOVE '6993'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_ACCOUNT'             TO TABLE-1                
               MOVE 'CSS_CUST_PREM_HIST'      TO TABLE-2                
               MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1        
T22243         MOVE 'DATE_UTIL_SVC_END'       TO TABLE-ELEMENT-2        
T22243         MOVE 'ACCT_FINALED_DT'         TO TABLE-ELEMENT-3        
               MOVE WS-CPD99-PREMISE-NO       TO HOSTVAR-ELEMENT-1      
T22243         MOVE WS-CPD99-DATE-SVC-END     TO HOSTVAR-ELEMENT-2      
T22243         MOVE WS-CPD99-MAX-AT-FINAL-DT  TO HOSTVAR-ELEMENT-3      
               PERFORM 6995-CPD99-ERROR-ROUTINE THRU 6995-EXIT          
           END-IF.                                                      
      *                                                                 43922000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              EXEC SQL                                                  
                 SELECT CH.ACCOUNT_NO                                   
                   INTO :WS-CPD99-ACCOUNT-NO                            
                   FROM CSS_CUST_PREM_HIST CH                           
                       ,CSS_ACCOUNT        AT                           
                  WHERE CH.PREMISE_NO        = :WS-CPD99-PREMISE-NO     
                    AND AT.PREMISE_NO        = :WS-CPD99-PREMISE-NO     
                    AND CH.ACCOUNT_NO        = AT.ACCOUNT_NO            
                    AND CH.DATE_UTIL_SVC_END = IIF(TRY_CONVERT(DATE, 
                                                 :WS-CPD99-DATE-SVC-END
              ) IS NULL OR (PATINDEX('%.%', :WS-CPD99-DATE-SVC-END
              ) <> 0) OR (LEN(:WS-CPD99-DATE-SVC-END
              ) <> 10), CIS.CHAR2DATE(:WS-CPD99-DATE-SVC-END
              ), CONVERT(DATE, :WS-CPD99-DATE-SVC-END) )   
                    AND AT.ACCT_CREATE_DT = CIS.CHAR2TIMESTAMP(
                                             :WS-CPD99-MAX-AT-CREATE-DT
              )  
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                  43913700
MFA-TR*          SELECT CH.ACCOUNT_NO                                   43913800
MFA-TR*            INTO :WS-CPD99-ACCOUNT-NO                            43914000
MFA-TR*            FROM CSS_CUST_PREM_HIST CH                           43914200
MFA-TR*                ,CSS_ACCOUNT        AT                           43914300
MFA-TR*           WHERE CH.PREMISE_NO        = :WS-CPD99-PREMISE-NO     43914400
MFA-TR*             AND AT.PREMISE_NO        = :WS-CPD99-PREMISE-NO     43914500
MFA-TR*             AND CH.ACCOUNT_NO        = AT.ACCOUNT_NO            43914700
MFA-TR*             AND CH.DATE_UTIL_SVC_END = :WS-CPD99-DATE-SVC-END   43914800
MFA-TR*             AND AT.ACCT_CREATE_DT = :WS-CPD99-MAX-AT-CREATE-DT  43914900
MFA-TR*       END-EXEC                                                  43915000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 43915100
              MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE  
      *                                                                 43915400
              IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  NEXT SENTENCE                                         
              ELSE                                                      
                  MOVE SQLCODE                TO WS-CPD99-RETURN-CODE   
                  MOVE SPACES                 TO ABEND-FILE             
                  MOVE '6993'                 TO ACTIVE-PARAGRAPH       
                  MOVE 'SELECT'               TO ABEND-FUNCTION         
                  MOVE 'CSS_ACCOUNT'          TO TABLE-1                
                  MOVE 'CSS_CUST_PREM_HIST'   TO TABLE-2                
                  MOVE 'PREMISE_NO'           TO TABLE-ELEMENT-1        
T22243            MOVE 'DATE_UTIL_SVC_END'    TO TABLE-ELEMENT-2        
T22243            MOVE 'ACCT_CREATE_DT'       TO TABLE-ELEMENT-3        
                  MOVE WS-CPD99-PREMISE-NO    TO HOSTVAR-ELEMENT-1      
T22243            MOVE WS-CPD99-DATE-SVC-END  TO HOSTVAR-ELEMENT-2      
T22243            MOVE WS-CPD99-MAX-AT-CREATE-DT TO HOSTVAR-ELEMENT-3   
                  PERFORM 6995-CPD99-ERROR-ROUTINE THRU 6995-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                 43917500
       6993-EXIT.                                                       
           EXIT.                                                        
      *                                                                 43110000
