      *****************************************************************         
      **                                                              **00022008
      **   CPD00094                                                   **00023008
      **     THIS COPY STATEMENT CONTAINS THE PROCEDURE DIVISION      **00024008
      **   STATEMENTS NECESSARY TO CREATE A NEW PREMISE ID.           **00025008
      **                                                              **00027008
      **..............................................................**00028008
      **                                                              **        
      **              PROGRAM  MODIFICATION  LOG                      **        
      **    DATE   INTIALS   REASON                                   **        
      **    ____   _______   ______                                   **        
      **    0896     AG      COPYBOOK ORIGINALLY WRITTEN              **        
GASACT**    1096     AD      GAS ACCOUNTING SYSTEM CHANGES            **        
TP8450**    0197     MD      JOURNALING TO MAINTENANCE TRANSACTION    **        
      **                       HISTORY REMOVED.                       **        
      **                                                              **        
      ******************************************************************        
      **     *     *     *     *     *     *     *     *     *       ***        
      **   CALL PARA 6702-GET-NEW-PREMISE-NO.                        ***00027008
      **                                                             ***        
      **  INCLUDE CWS00094   ( WORKING STORAGE FOR THIS CPD00093 )   ***        
      **                                                             ***        
      **  INCLUDE CPD00013.  ( CODE FOR CALCULATING CHECK DIGIT )    ***        
      **                                                             ***        
      **  INCLUDE THE FOLLOWING DECLGEN IN THE CALLING RPC           ***        
      **                                                             ***        
      **  TBPRCNTL                                                   ***        
      **  TBUSRPRF                                                   ***        
      **                                                             ***        
      **  PASS INFORMATION IN THE FOLLOWING VARIABLE.                ***        
      **                                                             ***        
      **  WS-94-CURRENT-DATE           ( PASS CURRENT DATE )         ***        
      **  WS-94-CURRENT-TIMESTAMP      ( PASS CURRENT TIMESTAMP )    ***        
      **  WS-94-USERID                 ( PASS USER ID OF THE SYSTEM )***        
      **  WS-94-PANEL-NO               ( PASS THE PANEL NO )         ***        
      **  WS-94-TRANS-COMMENTS         ( PASS TRANSACTION COMMENTS ) ***        
      **  WS-94-TRANS-COMMENTS-LEN     ( PASS TRAN COMMENTS LENGTH ) ***        
      **                                                             ***        
      **  RESULT WILL IN    WS-94-NEW-PREMISE-NO                     ***        
      **                                                             ***        
      **                                                             ***        
      **     *     *     *     *     *     *     *     *     *       ***        
      ******************************************************************        
       6702-GET-NEW-PREMISE-NO.                                         
                                                                        
           MOVE '6702' TO ACTIVE-PARAGRAPH.                             
                                                                        
      *-------------------------------*                                         
      * DETERMINE NEW CONTACT ID      *                                         
      *-------------------------------*                                         
           PERFORM 6704-LOCK-PREMISE-NO-CNTRL THRU 6704-EXIT            
           PERFORM 6706-SELECT-PREMISE-NO-CNTL THRU 6706-EXIT.          
                                                                        
      *** SORRY ! WE ARE FULL. WE CANNOT GIVE YOU ANY MORE CONTACT ID.          
           IF ( NP-LAST-PREM-NO-USED >= WS-MAX-PREMISE-CNTL )           
              MOVE WS-MAX-PREMISE-ERROR-CODE TO RS-RETURN-CODE          
                                                WS-ACTIVE-RETURN-CODE   
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
           ADD 1                           TO NP-LAST-PREM-NO-USED.     
                                                                        
GASACT*    THE RANGE OF PREMISE NUMBERS FROM X397000000 TO X397999999  *        
GASACT*    IS RESERVED FOR GAS ACCOUNTING SYSTEM. THIS RANGE OF IDS    *        
GASACT*    WILL BE SKIPPED. THE CONTROL RECORD IS UPDATED WITH NEXT    *        
GASACT*    VALID ID OUTSIDE THE RANGE : X398000000.                    *        
GASACT*                                                                *        
GASACT                                                                  
GASACT     MOVE NP-LAST-PREM-NO-USED       TO WS-GAS-PREM-ID-NUM.       
GASACT                                                                  
GASACT     IF WS-GAS-PREM-ID-2-10 = WS-GAS-PREM-START-ID                
GASACT        MOVE WS-NEXT-VALID-PREM-ID   TO WS-GAS-PREM-ID-2-10       
GASACT        MOVE WS-GAS-PREM-ID-NUM      TO NP-LAST-PREM-NO-USED      
GASACT     END-IF.                                                      
                                                                        
           MOVE NP-LAST-PREM-NO-USED       TO WS-94-PREMISE-NO.         
                                                                        
           MOVE WS-94-PREMISE-NO-9         TO WS-NBR-TO-BE-CHECKED.     
           PERFORM 6200-CALCULATE-CHECK-DIGIT  THRU 6200-EXIT.          
           MOVE WS-CHECK-DIGIT             TO WS-94-PREMISE-CHECK-DGT.  
           MOVE WS-94-PREMISE-NO           TO WS-94-NEW-PREMISE-NO.     
                                                                        
           PERFORM 6708-UPDATE-PREMISE-NO-CNTL THRU 6708-EXIT.          
                                                                        
       6702-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6704-LOCK-PREMISE-NO-CNTRL.                                    *        
      *                                                                *        
      *    1.  LOCK THE PREMISE ID      CONTROL TABLE.                 *        
      *                                                                *        
      ******************************************************************        
       6704-LOCK-PREMISE-NO-CNTRL.                                      
                                                                        
           EXEC SQL                                                     
              CALL CIS.LOCK_TABLE_IN_EXCLUSIVE_MODE('CSS_PREM_NO_CNTL')         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '6704'                TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'LOCK TABLE'          TO ABEND-FUNCTION              
              MOVE 'CSS_PREM_NO_CNTL '    TO TABLE-1                    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       6704-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6706-SELECT-PREMISE-NO-CNTL                                    *        
      *                                                                *        
      *    1. SELECT THE LAST PREMISE ID     USED IN ORDER TO CREATE   *        
      *       A NEW PREMISE ID .                                       *        
      *                                                                *        
      ******************************************************************        
       6706-SELECT-PREMISE-NO-CNTL.                                     
                                                                        
           EXEC SQL                                                     
              SELECT LAST_PREM_NO_USED                                  
                INTO :NP-LAST-PREM-NO-USED                              
                FROM CSS_PREM_NO_CNTL                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '6706'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_PREM_NO_CNTL '    TO TABLE-1                    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       6706-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6708-UPDATE-PREMISE-NO-CNTL                                    *        
      *                                                                *        
      *    1. SAVE INCREMENTED LAST NUMBER USED.                       *        
      *                                                                *        
      ******************************************************************        
       6708-UPDATE-PREMISE-NO-CNTL.                                     
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_PREM_NO_CNTL                                   
                 SET LAST_PREM_NO_USED = :NP-LAST-PREM-NO-USED          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '6708'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_PREM_NO_CNTL '   TO TABLE-1                     
              MOVE 'LAST_PREM_NO_USED'   TO TABLE-ELEMENT-1             
              MOVE NP-LAST-PREM-NO-USED  TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       6708-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
