      *****************************************************************         
      **                                                              **00022008
      **   CPD00093                                                   **00023008
      **     THIS COPY STATEMENT CONTAINS THE PROCEDURE DIVISION      **00024008
      **   STATEMENTS NECESSARY TO CREATE A NEW CUSTOMER ID.          **00025008
      **                                                              **00027008
      **..............................................................**00028008
      **                                                              **        
      **              PROGRAM  MODIFICATION  LOG                      **        
      **    DATE   INTIALS   REASON                                   **        
      **    ____   _______   ______                                   **        
      **    0896     AG      COPYBOOK ORIGINALLY WRITTEN              **        
GASACT**    1096     AD      GAS ACCOUNTING CHANGES                   **        
TP8450**    0197     MD      REMOVED JOURNALING FOR MAINTENANCE       **        
      **                     TRANSACTION HISTORY.                     **        
      **                                                              **        
      ******************************************************************        
      **     *     *     *     *     *     *     *     *     *       ***        
      **   CALL PARA 6602-GET-NEW-CUSTOMER-NO.                       ***00027008
      **                                                             ***        
      **  INCLUDE CWS00093   ( WORKING STORAGE FOR THIS CPD00093 )   ***        
      **                                                             ***        
      **  INCLUDE CPD00013.  ( CODE FOR CALCULATING CHECK DIGIT )    ***        
      **                                                             ***        
      **  INCLUDE THE FOLLOWING DECLGEN IN THE CALLING RPC           ***        
      **                                                             ***        
      **  TBCSTCTL                                                   ***        
      **  TBUSRPRF                                                   ***        
      **                                                             ***        
      **  PASS INFORMATION IN THE FOLLOWING VARIABLE.                ***        
      **                                                             ***        
      **  WS-93-CURRENT-DATE           ( PASS CURRENT DATE )         ***        
      **  WS-93-CURRENT-TIMESTAMP      ( PASS CURRENT TIMESTAMP )    ***        
      **  WS-93-USERID                 ( PASS USER ID OF THE SYSTEM )***        
      **  WS-93-PANEL-NO               ( PASS THE PANEL NO )         ***        
      **  WS-93-TRANS-COMMENTS         ( PASS TRANSACTION COMMENTS ) ***        
      **  WS-93-TRANS-COMMENTS-LEN     ( PASS TRAN COMMENTS LENGTH ) ***        
      **                                                             ***        
      **  RESULT WILL IN    WS-93-NEW-CUSTOMER-NO                    ***        
      **                                                             ***        
      **                                                             ***        
      **     *     *     *     *     *     *     *     *     *       ***        
      ******************************************************************        
       6602-GET-NEW-CUSTOMER-NO.                                        
                                                                        
           MOVE '6602' TO ACTIVE-PARAGRAPH.                             
                                                                        
      *-------------------------------*                                         
      * DETERMINE NEW CONTACT ID      *                                         
      *-------------------------------*                                         
           PERFORM 6604-LOCK-CUSTOMER-NO-CNTRL THRU 6604-EXIT           
           PERFORM 6606-SELECT-CUSTOMER-NO-CNTL THRU 6606-EXIT.         
                                                                        
      *** SORRY ! WE ARE FULL. WE CANNOT GIVE YOU ANY MORE CONTACT ID.          
           IF ( NC-LAST-CUST-NO-USED >= WS-MAX-CUSTOMER-CNTL )          
              MOVE WS-MAX-CUSTOMER-ERROR-CODE TO RS-RETURN-CODE         
                                                WS-ACTIVE-RETURN-CODE   
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
           ADD 1                        TO NC-LAST-CUST-NO-USED.        
                                                                        
GASACT*    THE RANGE OF PREMISE NUMBERS FROM X397000000 TO X397999999  *        
GASACT*    IS RESERVED FOR GAS ACCOUNT NUMBERS. THIS RANGE WILL BE     *        
GASACT*    SKIPPED. THE CONTROL RECORD IS UPDATED WITH THE NEXT VALID  *        
GASACT*    ID OUTSIDE THE RANGE.                                       *        
GASACT*                                                                *        
GASACT     MOVE NC-LAST-CUST-NO-USED    TO WS-GAS-CUST-ID-NUM.          
GASACT                                                                  
GASACT     IF WS-GAS-CUST-ID-2-10 = WS-GAS-CUST-START-ID                
GASACT        MOVE WS-NEXT-VALID-CUST-ID TO WS-GAS-CUST-ID-2-10         
GASACT        MOVE WS-GAS-CUST-ID-NUM    TO NC-LAST-CUST-NO-USED        
GASACT     END-IF.                                                      
                                                                        
           MOVE NC-LAST-CUST-NO-USED    TO WS-93-CUSTOMER-NO.           
                                                                        
           MOVE WS-93-CUSTOMER-NO-9     TO WS-NBR-TO-BE-CHECKED.        
           PERFORM 6200-CALCULATE-CHECK-DIGIT  THRU 6200-EXIT.          
           MOVE WS-CHECK-DIGIT          TO WS-93-CUSTOMER-CHECK-DGT.    
           MOVE WS-93-CUSTOMER-NO       TO WS-93-NEW-CUSTOMER-NO.       
                                                                        
           PERFORM 6608-UPDATE-CUSTOMER-NO-CNTL THRU 6608-EXIT.         
                                                                        
       6602-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6604-LOCK-CUSTOMER-NO-CNTRL.                                   *        
      *                                                                *        
      *    1.  LOCK THE CUSTOMER ID     CONTROL TABLE.                 *        
      *                                                                *        
      ******************************************************************        
       6604-LOCK-CUSTOMER-NO-CNTRL.                                     
                                                                        
           EXEC SQL                                                     
              CALL CIS.LOCK_TABLE_IN_EXCLUSIVE_MODE('CSS_CUST_NO_CNTL')         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '6604'                TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'LOCK TABLE'          TO ABEND-FUNCTION              
              MOVE 'CSS_CUST_NO_CNTL '    TO TABLE-1                    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       6604-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6606-SELECT-CUSTOMER-NO-CNTL                                   *        
      *                                                                *        
      *    1. SELECT THE LAST CUSTOMER ID    USED IN ORDER TO CREATE   *        
      *       A NEW CUSTOMER ID .                                      *        
      *                                                                *        
      ******************************************************************        
       6606-SELECT-CUSTOMER-NO-CNTL.                                    
                                                                        
           EXEC SQL                                                     
              SELECT LAST_CUST_NO_USED                                  
                INTO :NC-LAST-CUST-NO-USED                              
                FROM CSS_CUST_NO_CNTL                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '6606'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CUST_NO_CNTL '    TO TABLE-1                    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       6606-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6608-UPDATE-CUSTOMER-NO-CNTL                                   *        
      *                                                                *        
      *    1. SAVE INCREMENTED LAST NUMBER USED.                       *        
      *                                                                *        
      ******************************************************************        
       6608-UPDATE-CUSTOMER-NO-CNTL.                                    
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_NO_CNTL                                   
                 SET LAST_CUST_NO_USED = :NC-LAST-CUST-NO-USED          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '6608'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_CUST_NO_CNTL '   TO TABLE-1                     
              MOVE 'LAST_CUST_NO_USED'   TO TABLE-ELEMENT-1             
              MOVE NC-LAST-CUST-NO-USED  TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       6608-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
