      *****************************************************************         
      **                                                              **00022008
      **   CPD00092                                                   **00023008
      **     THIS COPY STATEMENT CONTAINS THE PROCEDURE DIVISION      **00024008
      **   STATEMENTS NECESSARY TO CREATE A NEW CONTACT ID.           **00025008
      **                                                              **00027008
      **..............................................................**00028008
      **                                                              **        
      **              PROGRAM  MODIFICATION  LOG                      **        
      **    DATE   INTIALS   REASON                                   **        
      **    ____   _______   ______                                   **        
      **    0896     AG      COPYBOOK ORIGINALLY WRITTEN              **        
TP8450**    0197     MD      JOURNALING FOR MAINTENANCE TRANSACTION   **        
      **                     HISTORY DELETED.                         **        
      **                                                              **        
      ******************************************************************        
      **     *     *     *     *     *     *     *     *     *       ***        
      **   CALL PARA 6402-GET-NEW-CNTCT-ID.                          ***00027008
      **                                                             ***        
      **  INCLUDE CWS00092   ( WORKING STORAGE FOR THIS CPD00092 )   ***        
      **                                                             ***        
      **  INCLUDE CPD00013.  ( CODE FOR CALCULATING CHECK DIGIT )    ***        
      **                                                             ***        
      **  INCLUDE THE FOLLOWING DECLGEN IN THE CALLING RPC           ***        
      **                                                             ***        
      **  TBCNTCID                                                   ***        
      **  TBUSRPRF                                                   ***        
      **                                                             ***        
      **  PASS INFORMATION IN THE FOLLOWING VARIABLE.                ***        
      **                                                             ***        
      **  WS-92-CURRENT-DATE           ( PASS CURRENT DATE )         ***        
      **  WS-92-CURRENT-TIMESTAMP      ( PASS CURRENT TIMESTAMP )    ***        
      **  WS-92-USERID                 ( PASS USER ID OF THE SYSTEM )***        
      **  WS-92-PANEL-NO               ( PASS THE PANEL NO )         ***        
      **  WS-92-TRANS-COMMENTS         ( PASS TRANSACTION COMMENTS ) ***        
      **  WS-92-TRANS-COMMENTS-LEN     ( PASS TRAN COMMENTS LENGTH ) ***        
      **                                                             ***        
      **  RESULT WILL IN    WS-92-NEW-CNTCT-ID                       ***        
      **                                                             ***        
      **                                                             ***        
      **     *     *     *     *     *     *     *     *     *       ***        
      ******************************************************************        
       6402-GET-NEW-CNTCT-ID.                                           
                                                                        
           MOVE '6402' TO ACTIVE-PARAGRAPH.                             
                                                                        
      *-------------------------------*                                         
      * DETERMINE NEW CONTACT ID      *                                         
      *-------------------------------*                                         
           PERFORM 6404-LOCK-CNTCT-ID-CNTRL   THRU 6404-EXIT            
           PERFORM 6406-SELECT-CNTCT-ID-CNTL  THRU 6406-EXIT.           
                                                                        
      *** SORRY ! WE ARE FULL. WE CANNOT GIVE YOU ANY MORE CONTACT ID.          
           IF ( I6-CONTACT-ID        >= WS-MAX-CNTCT-CNTL )             
              MOVE WS-MAX-CNTCT-ERROR-CODE    TO RS-RETURN-CODE         
                                                WS-ACTIVE-RETURN-CODE   
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
           ADD 1                             TO I6-CONTACT-ID.          
                                                                        
                                                                        
           MOVE I6-CONTACT-ID                TO WS-92-CONTACT-ID.       
                                                                        
           MOVE WS-92-CONTACT-ID-9           TO WS-NBR-TO-BE-CHECKED.   
           PERFORM 6200-CALCULATE-CHECK-DIGIT  THRU 6200-EXIT.          
           MOVE WS-CHECK-DIGIT              TO WS-92-CONTACT-CHECK-DGT. 
           MOVE WS-92-CONTACT-ID             TO WS-92-NEW-CONTACT-ID.   
                                                                        
           PERFORM 6408-UPDATE-CNTCT-ID-CNTL    THRU 6408-EXIT.         
                                                                        
       6402-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6404-LOCK-CNTCT-ID-CNTRL.                                      *        
      *                                                                *        
      *    1.  LOCK THE CONTACT ID      CONTROL TABLE.                 *        
      *                                                                *        
      ******************************************************************        
       6404-LOCK-CNTCT-ID-CNTRL.                                        
                                                                        
           EXEC SQL                                                     
              CALL CIS.LOCK_TABLE_IN_EXCLUSIVE_MODE('CSS_CNTCT_ID_CNTL')        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '6404'                TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'LOCK TABLE'          TO ABEND-FUNCTION              
              MOVE 'CSS_CNTCT_ID_CNTL'    TO TABLE-1                    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       6404-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6406-SELECT-CNTCT-ID-CNTL                                      *        
      *                                                                *        
      *    1. SELECT THE LAST CONTACT ID     USED IN ORDER TO CREATE   *        
      *       A NEW CONTACT ID.                                        *        
      *                                                                *        
      ******************************************************************        
       6406-SELECT-CNTCT-ID-CNTL.                                       
                                                                        
           EXEC SQL                                                     
              SELECT CONTACT_ID                                         
                INTO :I6-CONTACT-ID                                     
                FROM CSS_CNTCT_ID_CNTL                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '6406'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CNTCT_ID_CNTL'    TO TABLE-1                    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       6406-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6408-UPDATE-CNTCT-ID-CNTL                                      *        
      *                                                                *        
      *    1. SAVE INCREMENTED LAST NUMBER USED.                       *        
      *                                                                *        
      ******************************************************************        
       6408-UPDATE-CNTCT-ID-CNTL.                                       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CNTCT_ID_CNTL                                  
                 SET CONTACT_ID        = :I6-CONTACT-ID                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '6408'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_CNTCT_ID_CNTL'   TO TABLE-1                     
              MOVE 'CONTACT_ID'          TO TABLE-ELEMENT-1             
              MOVE I6-CONTACT-ID         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       6408-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
