      ******************************************************************        
      *                                                                *00022008
      *    CPD00091                                                    *00023008
      *                                                                *00022008
      *      THIS COPY STATEMENT CONTAINS THE PROCEDURE DIVISION       *00024008
      *      STATEMENTS NECESSARY TO CREATE A NEW NAME ID.             *00025008
      *                                                                *00027008
      *      NOTE TO DEVELOPER: THIS CODE IS ALSO INCORPORATED INTO    *00027008
      *      THE PROGRAM 'PCSSO061'.  IT COULD NOT USE CPD00091        *00027008
      *      BECAUSE IT USES DIFFERENT ERROR PROCESSING LOGIC.  ANY    *00027008
      *      CHANGES TO CPD00091 MUST ALSO BE CHANGED WITHIN PCSSO061. *00027008
      *      (THE PARAGRAPH NUMBERS AND BASIC LOGIC ARE IDENTICAL).    *00027008
      *                                                                *00027008
      *................................................................*00028008
      *                                                                *        
      *               PROGRAM  MODIFICATION  LOG                       *        
      *     DATE   INTIALS   REASON                                    *        
      *     ____   _______   ______                                    *        
      *     0896     AG      COPYBOOK ORIGINALLY WRITTEN               *        
      *     1096     AD      GAS ACCOUNTING CHANGES                    *        
      *     0197     MC      DELETED 6323-JRNL-INSERT AND              *        
      *                      6328-GET-CURRENT-DATE-TIME AND            *        
      *                      6326-GET-RESP-AREA-ID.                    *        
      ******************************************************************        
      *                                                                *        
      *   INCLUDE CWS00091   ( WORKING STORAGE FOR THIS CPD00091 )     *        
      *   INCLUDE CPD00071.  ( CODE FOR CALCULATING CHECK DIGIT )      *        
      *   INCLUDE CPD00067.  ( MAINTENANCE TRANSACTION HISTORY )       *        
      *                                                                *        
      *   INCLUDE THE FOLLOWING DECLGEN IN THE CALLING RPC:            *        
      *   TBNAMEID                                                     *        
      *   TBUSRPRF                                                     *        
      *   TBMNHIST                                                     *        
      *   TBMNHDT                                                      *        
      *                                                                *        
      *   PASS INFORMATION IN THE FOLLOWING VARIABLES:                 *        
      *                                                                *        
      *   WS-91-CURRENT-DATE        -  PASS CURRENT DATE               *        
      *   WS-91-CURRENT-TIMESTAMP   -  PASS CURRENT TIMESTAMP          *        
      *   WS-91-USERID              -  PASS USER ID OF THE SYSTEM      *        
      *   WS-91-PANEL-NO            -  PASS THE PANEL NO               *        
      *   WS-91-TRANS-COMMENTS      -  PASS TRANSACTION COMMENTS       *        
      *   WS-91-TRANS-COMMENTS-LEN  -  PASS TRAN COMMENTS LENGTH       *        
      *                                                                *        
      *   THE NEW NAME ID WILL BE MOVED TO 'WS-91-NEW-NAME-ID'.        *        
      *                                                                *        
      ******************************************************************        
       6302-GET-NEW-NAME-ID.                                            
                                                                        
           PERFORM 6304-LOCK-NAME-ID-CNTRL    THRU 6304-EXIT            
           PERFORM 6306-SELECT-NAME-ID-CNTL   THRU 6306-EXIT.           
                                                                        
           IF I7-NAME-ID >= WS-MAX-NAME-CNTL                            
              MOVE WS-MAX-NAME-ERROR-CODE     TO RS-RETURN-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1                              TO I7-NAME-ID.            
                                                                        
GASACT*    A RANGE OF NAME IDS WHICH ARE RESERVED FOR THE GAS ACCOUN-           
GASACT*    TING SYSTEM ARE SKIPPED. THESE ARE IDENTIFIED BY A 3 IN              
GASACT*    DIGIT 2 AND 97 IN DIGITS 5-6 OF THE NAME ID.                         
GASACT*    THE CONTROL RECORD IS UPDATED WITH THE NEXT VALID NUMBER             
GASACT*    IE. X3XX98XXXXXXX                                                    
GASACT*                                                                         
GASACT     MOVE I7-NAME-ID                    TO WS-GAS-NAME-ID-NUM     
GASACT                                                                  
GASACT     IF WS-GAS-NAME-ID-2 = 3 AND WS-GAS-NAME-ID-5-6 = 97          
GASACT        MOVE 98                         TO WS-GAS-NAME-ID-5-6     
GASACT        MOVE WS-GAS-NAME-ID-NUM         TO I7-NAME-ID             
GASACT     END-IF.                                                      
                                                                        
           MOVE I7-NAME-ID                    TO WS-91-NAME-ID.         
                                                                        
           MOVE WS-91-NAME-ID-12              TO WS-NBR-TO-BE-CHECKED2. 
           PERFORM 6210-CALCULATE-CHECK-DIGIT THRU 6210-EXIT.           
           MOVE WS-CHECK-DIGIT2               TO WS-91-NAME-CHECK-DGT.  
           MOVE WS-91-NAME-ID                 TO WS-91-NEW-NAME-ID.     
                                                                        
           PERFORM 6308-UPDATE-NAME-ID-CNTL   THRU 6308-EXIT.           
                                                                        
       6302-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6304-LOCK-NAME-ID-CNTRL.                                       *        
      *                                                                *        
      *    1.  LOCK THE NAME ID CONTROL TABLE.                         *        
      *                                                                *        
      ******************************************************************        
       6304-LOCK-NAME-ID-CNTRL.                                         
                                                                        
           EXEC SQL                                                     
              CALL CIS.LOCK_TABLE_IN_EXCLUSIVE_MODE('CSS_NAME_ID_CNTL')         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '6304'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'LOCK TABLE'               TO ABEND-FUNCTION         
              MOVE 'CSS_NAME_ID_CNTL'         TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       6304-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6306-SELECT-NAME-ID-CNTL                                       *        
      *                                                                *        
      *    1. SELECT THE LAST NAME ID USED IN ORDER TO CREATE A NEW    *        
      *       NAME ID.                                                 *        
      *                                                                *        
      ******************************************************************        
       6306-SELECT-NAME-ID-CNTL.                                        
                                                                        
           EXEC SQL                                                     
              SELECT NAME_ID                                            
                INTO :I7-NAME-ID                                        
                FROM CSS_NAME_ID_CNTL                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6306'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_NAME_ID_CNTL'         TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       6306-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6308-UPDATE-NAME-ID-CNTL                                       *        
      *                                                                *        
      *    1. SAVE INCREMENTED LAST NUMBER USED.                       *        
      *                                                                *        
      ******************************************************************        
       6308-UPDATE-NAME-ID-CNTL.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_NAME_ID_CNTL                                   
                 SET NAME_ID = :I7-NAME-ID                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '6308'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_NAME_ID_CNTL'         TO TABLE-1                
              MOVE 'NAME_ID'                  TO TABLE-ELEMENT-1        
              MOVE I7-NAME-ID                 TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       6308-EXIT.                                                       
           EXIT.                                                        
                                                                        
