      *****************************************************************         
      **                                                              **00022008
      **   CPD00090                                                   **00023008
      **     THIS COPY STATEMENT CONTAINS THE PROCEDURE DIVISION      **00024008
      **   STATEMENTS NECESSARY TO CREATE A NEW ADDRESS ID.           **00025008
      **                                                              **00027008
      **..............................................................**00028008
      **                                                              **        
      **              PROGRAM  MODIFICATION  LOG                      **        
      **    DATE   INTIALS   REASON                                   **        
      **    ____   _______   ______                                   **        
      **    0896     AG      COPYBOOK ORIGINALLY WRITTEN              **        
GASACT**    1096     AD      GAS ACCOUNTING CHANGES                   **        
TP8450**    0197     MD      JOURNALING FOR MAINTENANCE TRANSACTION   **        
      **                       REMOVED.                               **        
      **                                                              **        
      ******************************************************************        
      **     *     *     *     *     *     *     *     *     *       ***        
      **   CALL PARA 6202-GET-NEW-ADDR-ID.                           ***00027008
      **                                                             ***        
      **  INCLUDE CWS0090A   ( WORKING STORAGE FOR THIS CPD00090 )   ***        
      **                                                             ***        
      **  INCLUDE CPD00071.  ( CODE FOR CALCULATING CHECK DIGIT )    ***        
      **                                                             ***        
      **  INCLUDE THE FOLLOWING DECLGEN IN THE CALLING RPC           ***        
      **                                                             ***        
      **  TBADDRID                                                   ***        
      **  TBUSRPRF                                                   ***        
      **                                                             ***        
      **  PASS INFORMATION IN THE FOLLOWING VARIABLE.                ***        
      **                                                             ***        
      **  WS-90-CURRENT-DATE           ( PASS CURRENT DATE )         ***        
      **  WS-90-CURRENT-TIMESTAMP      ( PASS CURRENT TIMESTAMP )    ***        
      **  WS-90-USERID                 ( PASS USER ID OF THE SYSTEM )***        
      **  WS-90-PANEL-NO               ( PASS THE PANEL NO )         ***        
      **  WS-90-TRANS-COMMENTS         ( PASS TRANSACTION COMMENTS ) ***        
      **  WS-90-TRANS-COMMENTS-LEN     ( PASS TRAN COMMENTS LENGTH ) ***        
      **                                                             ***        
      **  RESULT WILL IN    WS-90-NEW-ADDRESS-ID                     ***        
      **                                                             ***        
      **                                                             ***        
      **     *     *     *     *     *     *     *     *     *       ***        
      ******************************************************************        
       6202-GET-NEW-ADDRESS-ID.                                         
                                                                        
           MOVE '6202' TO ACTIVE-PARAGRAPH.                             
                                                                        
      *-------------------------------*                                         
      * DETERMINE NEW ADDRESS ID      *                                         
      *-------------------------------*                                         
           PERFORM 6204-LOCK-ADDR-ID-CNTRL   THRU 6204-EXIT             
           PERFORM 6206-SELECT-ADDR-ID-CNTL  THRU 6206-EXIT.            
                                                                        
      *** SORRY ! WE ARE FULL. WE CANNOT GIVE YOU ANY MORE ADDRESS ID.          
           IF ( I8-ADDRESS-ID        >= WS-MAX-ADDR-CNTL )              
              MOVE WS-MAX-ADDR-ERROR-CODE    TO RS-RETURN-CODE          
                                                WS-ACTIVE-RETURN-CODE   
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
           ADD 1                             TO I8-ADDRESS-ID.          
                                                                        
GASACT*    A RANGE OF ADDRESS IDS WHICH ARE RESERVED FOR THE GAS       *        
GASACT*    ACCOUNTING SYSTEM ARE SKIPPED. THESE ARE IDENTIFIED BY A    *        
GASACT*    3 IN THE DIGIT 2 AND 97 IN DIGITS 5-6 OF THE NAME ID.       *        
GASACT*    THE CONTROL RECORD IS UPDATED WITH THE NEXT VALID NUMBER    *        
GASACT*    IE X3XX98XXXXXXX                                            *        
GASACT*                                                                *        
GASACT     MOVE I8-ADDRESS-ID                TO WS-GAS-ADDR-ID-NUM.     
GASACT                                                                  
GASACT     IF WS-GAS-ADDR-ID-2 EQUAL 3 AND WS-GAS-ADDR-ID-5-6 EQUAL 97  
GASACT        MOVE 98                        TO WS-GAS-ADDR-ID-5-6      
GASACT        MOVE WS-GAS-ADDR-ID-NUM        TO I8-ADDRESS-ID           
GASACT     END-IF.                                                      
                                                                        
           MOVE I8-ADDRESS-ID                TO WS-90-ADDRESS-ID.       
                                                                        
           MOVE WS-90-ADDR-ID-12             TO WS-NBR-TO-BE-CHECKED2.  
           PERFORM 6210-CALCULATE-CHECK-DIGIT  THRU 6210-EXIT.          
           MOVE WS-CHECK-DIGIT2              TO WS-90-ADDR-CHECK-DGT.   
           MOVE WS-90-ADDRESS-ID             TO WS-90-NEW-ADDRESS-ID.   
                                                                        
           PERFORM 6208-UPDATE-ADDR-ID-CNTL    THRU 6208-EXIT.          
                                                                        
       6202-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6204-LOCK-ADDR-ID-CNTRL.                                       *        
      *                                                                *        
      *    1.  LOCK THE ADDRESS ID      CONTROL TABLE.                 *        
      *                                                                *        
      ******************************************************************        
       6204-LOCK-ADDR-ID-CNTRL.                                         
                                                                        
           EXEC SQL                                                     
              CALL CIS.LOCK_TABLE_IN_EXCLUSIVE_MODE('CSS_ADDR_ID_CNTL')         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '6204'                TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'LOCK TABLE'          TO ABEND-FUNCTION              
              MOVE 'CSS_ADDR_ID_CNTL'    TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       6204-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6206-SELECT-ADDR-ID-CNTL                                       *        
      *                                                                *        
      *    1. SELECT THE LAST ADDRESS ID     USED IN ORDER TO CREATE   *        
      *       A NEW ADDRESS ID.                                        *        
      *                                                                *        
      ******************************************************************        
       6206-SELECT-ADDR-ID-CNTL.                                        
                                                                        
           EXEC SQL                                                     
              SELECT ADDRESS_ID                                         
                INTO :I8-ADDRESS-ID                                     
                FROM CSS_ADDR_ID_CNTL                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '6206'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ADDR_ID_CNTL'    TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       6206-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 6208-UPDATE-ADDR-ID-CNTL                                       *        
      *                                                                *        
      *    1. SAVE INCREMENTED LAST NUMBER USED.                       *        
      *                                                                *        
      ******************************************************************        
       6208-UPDATE-ADDR-ID-CNTL.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ADDR_ID_CNTL                                   
                 SET ADDRESS_ID        = :I8-ADDRESS-ID                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '6208'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_ADDR_ID_CNTL'    TO TABLE-1                     
              MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-1             
              MOVE I8-ADDRESS-ID         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       6208-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
