      *****************************************************************         
      ** CPD00080  COPYBOOK TO INSERT REFUND ROW INTO CSS_REFUND     **         
      **                     RELEASE 1.0                             **         
      **.............................................................**         
      **  WS-REFERENCE:  COPYBOOKS: CWS00131 (WORKING STORAGE)       **         
      **                 WS-PGRMNAME (LITERAL NAME OF PROGRAM)       **         
      **                                                             **         
      **  PROCEDURE REFERENCE:                                       **         
      **                                                             **         
      **  PREREQUISITES: THE WORKING STORAGE VARIABLE SHOULD BE      **         
      **                 POPULATED PRIOR TO INVOKING THIS ROUTINE    **         
      **                                                             **         
      **  ADDITIONAL INFORMATION:                                    **         
      **                                                             **         
      **                                                             **         
      **                                                             **         
      *****************************************************************         
       5950-INSERT-REFUND.                                              
                                                                        
           MOVE '5950' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE WS-ACCOUNT-NO-NUM     TO RN-ACCOUNT-NO.                 
           PERFORM 7360-GET-REFUND-ITEM-ID THRU 7360-EXIT.              
                                                                        
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :RN-TRANS-HIST-SEQ-NO                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     17410200
MFA-TR*         SET :RN-TRANS-HIST-SEQ-NO                               17410300
MFA-TR*             =   CURRENT TIMESTAMP                               17410400
MFA-TR*    END-EXEC.                                                    17410700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE RN-TRANS-HIST-SEQ-NO  TO RN-REFUND-STATUS-DT.           
           MOVE WS-ORIGINAL-CHECK-NO  TO RN-ORIGINAL-CHECK-NO           
           MOVE WS-REFUND-CHECK-NO    TO RN-REFUND-CHECK-NO.            
           MOVE WS-RETURNED-REASON    TO RN-RETURNED-REASON.            
           MOVE WS-USER-ID-APPRVD-BY  TO RN-USER-ID-APPRVD-BY.          
           MOVE WS-USER-ID-RQSTED-BY  TO RN-USER-ID-RQSTED-BY.          
           MOVE WS-DEPOSIT-CERT-NUMBER  TO RN-DEPOSIT-CERT-NO.          
           MOVE WS-MANUAL-INDICATOR   TO RN-MANUAL-INDICATOR.           
           MOVE WS-COMMENT-TEXT       TO RN-COMMENTS-TEXT.              
           MOVE WS-COMMENT-LEN-NUMBER TO RN-COMMENTS-LEN.               
           MOVE WS-CHECK-ISS-REAS-CD  TO RN-CHECK-ISS-REAS-CD.          
           MOVE WS-AMT-REFUND         TO RN-AMT-REFUNDED.               
           MOVE WS-DATE-REFUNDED      TO RN-DATE-REFUNDED.              
           MOVE WS-LOCAL-OFF          TO RN-LOCAL-OFFICE.               
           MOVE WS-ADDRESS-ID         TO RN-ADDRESS-ID.                 
           PERFORM 8150-INSERT-REFUND THRU 8150-EXIT.                   
                                                                        
       5950-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7360-GET-REFUND-ITEM-ID.                                         
                                                                        
           MOVE '7360' TO  ACTIVE-PARAGRAPH.                            
      *                                                                 17410100
           EXEC SQL                                                     
                SELECT MAX(REFUND_ITEM_ID)                              
                INTO :RN-REFUND-ITEM-ID :WS-RN-NULL-ITEM                 
                FROM CSS_REFUND                                         
                WHERE ACCOUNT_NO = :RN-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17410800
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-RN-NULL-ITEM = -1                                   
                 MOVE 1 TO RN-REFUND-ITEM-ID                            
              ELSE                                                      
                 COMPUTE                                                
                 RN-REFUND-ITEM-ID = RN-REFUND-ITEM-ID + 1              
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME TO ABEND-PROGRAM                        
              MOVE '7360' TO ACTIVE-PARAGRAPH                           
              MOVE 'SELECT MAX' TO ABEND-FUNCTION                       
              MOVE SPACES TO ABEND-SQL-PREDICATES                       
                                     ABEND-TABLES                       
              MOVE 'CSS_REFUND'  TO TABLE-1                             
              MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1                     
              MOVE RN-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                   
              PERFORM 9000-SEND-ERROR-RESULT                            
                                  THRU 9000-EXIT                        
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                  THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 17413600
       7360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
       8150-INSERT-REFUND.                                              
      *                                                                         
           MOVE '8150' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF RN-REFUND-STATUS-DT EQUAL SPACES OR LOW-VALUES            
               MOVE -1 TO WS-REFUND-STATUS-DT-NI                        
           ELSE                                                         
               MOVE ZEROES TO WS-REFUND-STATUS-DT-NI                    
           END-IF.                                                      
                                                                        
           IF RN-DATE-REFUNDED EQUAL SPACES OR LOW-VALUES               
               MOVE -1 TO WS-DATE-REFUNDED-NI                           
           ELSE                                                         
               MOVE ZEROES TO WS-DATE-REFUNDED-NI                       
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_REFUND                                  
                     (ACCOUNT_NO,                                       
                      REFUND_CHECK_NO,                                  
                      ORIGINAL_CHECK_NO,                                
                      AMT_REFUNDED,                                     
                      CHECK_ISS_REAS_CD,                                
                      CHECK_STATUS_CD,                                  
                      REFUND_STATUS_DT,                                 
                      RETURNED_REASON,                                  
                      DATE_REFUNDED,                                    
                      DEPOSIT_CERT_NO,                                  
                      LOCAL_OFFICE,                                     
                      REFUND_ITEM_ID,                                   
                      USER_ID_APPRVD_BY,                                
                      USER_ID_RQSTED_BY,                                
                      MANUAL_INDICATOR,                                 
                      ADDRESS_ID,                                       
                      TRANS_HIST_SEQ_NO,                                
                     COMMENTS)                                          
                VALUES                                                  
                     (:RN-ACCOUNT-NO,                                   
                      :RN-REFUND-CHECK-NO,                              
                      :RN-ORIGINAL-CHECK-NO,                            
                      :RN-AMT-REFUNDED,                                 
                      :RN-CHECK-ISS-REAS-CD,                            
                      :RN-CHECK-STATUS-CD,                              
                      IIF(TRY_CONVERT(DATE, :RN-REFUND-STATUS-DT 
                                            :WS-REFUND-STATUS-DT-NI
              ) IS NULL OR (PATINDEX('%.%', :RN-REFUND-STATUS-DT 
                                                :WS-REFUND-STATUS-DT-NI
              ) <> 0) OR (LEN(:RN-REFUND-STATUS-DT 
                                                :WS-REFUND-STATUS-DT-NI
              ) <> 10), CIS.CHAR2DATE(:RN-REFUND-STATUS-DT 
                                                :WS-REFUND-STATUS-DT-NI
              ), CONVERT(DATE, :RN-REFUND-STATUS-DT 
                                                :WS-REFUND-STATUS-DT-NI
              ) ),      
                      :RN-RETURNED-REASON,                              
                      IIF(TRY_CONVERT(DATE, :RN-DATE-REFUNDED 
                                            :WS-DATE-REFUNDED-NI
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-REFUNDED 
                                                   :WS-DATE-REFUNDED-NI
              ) <> 0) OR (LEN(:RN-DATE-REFUNDED :WS-DATE-REFUNDED-NI
              ) <> 10), CIS.CHAR2DATE(:RN-DATE-REFUNDED 
                                                   :WS-DATE-REFUNDED-NI
              ), CONVERT(DATE, :RN-DATE-REFUNDED :WS-DATE-REFUNDED-NI
              ) ),            
                      :RN-DEPOSIT-CERT-NO,                              
                      :RN-LOCAL-OFFICE,                                 
                      :RN-REFUND-ITEM-ID,                               
                      :RN-USER-ID-APPRVD-BY,                            
                      :RN-USER-ID-RQSTED-BY,                            
                      :RN-MANUAL-INDICATOR,                             
                      :RN-ADDRESS-ID,                                   
                      CIS.CHAR2TIMESTAMP(:RN-TRANS-HIST-SEQ-NO),                
                      :RN-COMMENTS)                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     17414700
MFA-TR*         INSERT INTO CSS_REFUND                                  17414800
MFA-TR*              (ACCOUNT_NO,                                       17414900
MFA-TR*               REFUND_CHECK_NO,                                  17415000
MFA-TR*               ORIGINAL_CHECK_NO,                                17415100
MFA-TR*               AMT_REFUNDED,                                     17415200
MFA-TR*               CHECK_ISS_REAS_CD,                                17415300
MFA-TR*               CHECK_STATUS_CD,                                  17415400
MFA-TR*               REFUND_STATUS_DT,                                 17415500
MFA-TR*               RETURNED_REASON,                                  17415600
MFA-TR*               DATE_REFUNDED,                                    17415700
MFA-TR*               DEPOSIT_CERT_NO,                                  17415800
MFA-TR*               LOCAL_OFFICE,                                     17415900
MFA-TR*               REFUND_ITEM_ID,                                   17416000
MFA-TR*               USER_ID_APPRVD_BY,                                17416100
MFA-TR*               USER_ID_RQSTED_BY,                                17416200
MFA-TR*               MANUAL_INDICATOR,                                 17416300
MFA-TR*               ADDRESS_ID,                                       17416400
MFA-TR*               TRANS_HIST_SEQ_NO,                                17416500
MFA-TR*              COMMENTS)                                          17416600
MFA-TR*         VALUES                                                  17416700
MFA-TR*              (:RN-ACCOUNT-NO,                                   17416800
MFA-TR*               :RN-REFUND-CHECK-NO,                              17416900
MFA-TR*               :RN-ORIGINAL-CHECK-NO,                            17417000
MFA-TR*               :RN-AMT-REFUNDED,                                 17417100
MFA-TR*               :RN-CHECK-ISS-REAS-CD,                            17417200
MFA-TR*               :RN-CHECK-STATUS-CD,                              17417300
MFA-TR*               :RN-REFUND-STATUS-DT:WS-REFUND-STATUS-DT-NI,      17417400
MFA-TR*               :RN-RETURNED-REASON,                              17417500
MFA-TR*               :RN-DATE-REFUNDED:WS-DATE-REFUNDED-NI,            17417600
MFA-TR*               :RN-DEPOSIT-CERT-NO,                              17417700
MFA-TR*               :RN-LOCAL-OFFICE,                                 17417800
MFA-TR*               :RN-REFUND-ITEM-ID,                               17417900
MFA-TR*               :RN-USER-ID-APPRVD-BY,                            17418000
MFA-TR*               :RN-USER-ID-RQSTED-BY,                            17418100
MFA-TR*               :RN-MANUAL-INDICATOR,                             17418200
MFA-TR*               :RN-ADDRESS-ID,                                   17418300
MFA-TR*               :RN-TRANS-HIST-SEQ-NO,                            17418400
MFA-TR*               :RN-COMMENTS)                                     17418500
MFA-TR*    END-EXEC.                                                    17418600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE '8150' TO ACTIVE-PARAGRAPH                           
              MOVE SPACES TO ABEND-TABLES                               
                             ABEND-SQL-PREDICATES                       
              MOVE 'CSS_REFUND'         TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE RN-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'TRANS-HIST-SEQ'     TO TABLE-ELEMENT-2              
              MOVE RN-TRANS-HIST-SEQ-NO TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17420800
      *******************END OF CPD00080******************************* 17420900
